
Ext.define('ClusterDashboard.view.ClusterAlerts', {
    extend: 'Ext.view.View',
    alias: 'widget.clusteralerts',
    id: 'clusteralerts',
    initComponent: function() {
        var me = this;
        me.callParent();
    },
    store: Ext.create('Ext.data.Store', {
        fields: [{
                name: 'title'
            },
            {
                name: 'legendData'
            },
            {
                name: 'legendDataTotal'
            },
            {
                name: 'dataAvailable'
            },
			{
				name:'eventCriticalPageUrl'
			},
			{
				name:'eventMajorPageUrl'
			},
			{
				name:'eventMinorPageUrl'
			}
        ]
    }),
   // data : [],
    //id: 'clusternodes',
    itemSelector: 'div.thumb-wrap',
    emptyText: 'No Data Available',
    tpl: new Ext.XTemplate(



        '<div  class="b_box" style="">',

 //       '<tpl for=".">',
        //'<tpl if="dataAvailable == true">',
        '<div style="" class="thumb-wrap">',
        '<div id="clusteralerts_chart"  style="margin: -10px 0 0; height:236px;"></div>',
        '</div>',
       // '<tpl else>',
       

		'<div id="nodata" style="display:none">',
			
					'<div style="height:195;width:100%;display:table">',
					'<div  class="msgFont" style="display:table-cell;vertical-align:middle">',
					'<div class="iconInformation" style="margin:0px auto"></div>',
					'<div style="text-align:center" class="newFont_normal11">'+noAlerts+'</div>',
					'</div></div>',	
		'</div>',
        //'<div class="newFont_bold14" style="position:relative; top: 0px; z-index:1; width: 100%;padding: 8px 10px;text-transform:uppercase;">{title}</div>',

        
       // '</tpl>',
	//	'</tpl>',

        '</div>'

    ),
    clusterAlertData: function(cmp) {
        var me = this;
        Ext.Ajax.request({
            url: '/final/monitor/clusterDashboard.jsp?reqFrom=alerts&compType=' + encodeURIComponent(compType) + '&compName=' + encodeURIComponent(compName),
            method: 'POST',
            success: function(response) {
                var jsonText = response.responseText;
                if (response.status == 200 && !Ext.isEmpty(jsonText)) {
                    var jsonDataAlerts = Ext.decode(jsonText);
                    jsonDataAlerts = jsonDataAlerts['Alerts'][0];
                    var jsonDataAlertsNoData = Ext.decode(jsonText);
                    jsonDataAlertsNoData = jsonDataAlertsNoData['Alerts'][0]['dataAvailable'];
                    //me.update(jsonDataAlerts);
					//jsonDataAlerts.dataAvailable = false;
                    var ChartData = me.chartView(jsonDataAlerts);
                    $('#clusteralerts_chart').highcharts(ChartData);

                }
            }
        });
    },
    chartView: function(data) {

        var me = this;
        var chartProp = {

            credits: {
                enabled: false
            },
            chart: {
                type: 'pie',
                backgroundColor: 'transparent',
                plotBackgroundColor: null,
                //plotBorderWidth: data.pieBorderWidth,
                plotBorderWidth: 0,
                plotShadow: false
            },
            legend: {
                align: 'center',
                verticalAlign: 'bottom',
                //layout: 'vertical',
                itemDistance: 0,
                minWidth: 64,
                x: 0,
                y: 0,
                symbolPadding: 0,
                symbolWidth: 0.1,
                symbolHeight: 0.1,
                symbolRadius: 0,
                useHTML: true,
                symbolWidth: 0,
                labelFormatter: function() {
                    if (this.name == 'MINOR') {
                        var minorcount = this.y;
						if(minorcount>0)
						{
							return '<div style="min-width:46px;display:inline-block;;margin: 0 0px 24px 0;"><p ><div onclick="javascript:goToAlarmHistory(\''+data.eventMinorPageUrl+'\');" style="cursor:pointer" ><span style="display:inline-block;background-color:' + this.color + ';width:3px;height:34px;margin:0 9px 0 0"></span><span class="font_normal10" style="position:absolute;top:0px;height:10px;line-height:10px;font-size:10px; font-weight:400; display:inline-block;">'+ this.name + '</span><span style="font-family:Roboto;font-size:27px;line-height:1;font-weight:400;">' + minorcount + '</span></div></p></div>';
						}
						else
						{
							return '<div style="min-width:46px;display:inline-block;;margin: 0 0px 24px 0;"><p ><div style="cursor:default" ><span style="display:inline-block;background-color:' + this.color + ';width:3px;height:34px;margin:0 9px 0 0"></span><span class="font_normal10" style="position:absolute;top:0px;height:10px;line-height:10px;font-size:10px; font-weight:400; display:inline-block;">'+ this.name + '</span><span style="font-family:Roboto;font-size:27px;line-height:1;font-weight:400;">' + minorcount + '</span></div></p></div>';
						}
                    } else if (this.name == 'CRITICAL') {
                        var cricticalCount = this.y;
						if(cricticalCount>0)
						{
							return '<div style="min-width:53px;display:inline-block;;margin: 0 10px 24px 0;"><p ><div onclick="javascript:goToAlarmHistory(\''+data.eventCriticalPageUrl+'\');" style="cursor:pointer" ><span style="display:inline-block;background-color:' + this.color + ';width:3px;height:34px;margin:0 9px 0 0"></span><span class="font_normal10" style="position:absolute;top:0px;height:10px;line-height:10px;font-size:10px;font-weight:400; display:inline-block;">' + this.name + '</span><span style="font-family:Roboto;font-size:27px;line-height:1;font-weight:400;">' + cricticalCount + '</span></div></p></div>';
						}
						else
						{
							return '<div style="min-width:53px;display:inline-block;;margin: 0 10px 24px 0;"><p ><div style="cursor:default" ><span style="display:inline-block;background-color:' + this.color + ';width:3px;height:34px;margin:0 9px 0 0"></span><span class="font_normal10" style="position:absolute;top:0px;height:10px;line-height:10px;font-size:10px;font-weight:400; display:inline-block;">' + this.name + '</span><span style="font-family:Roboto;font-size:27px;line-height:1;font-weight:400;">' + cricticalCount + '</span></div></p></div>';
						}
                    } else {
                        var majorCount = this.y;
                        if(majorCount>0)
						{
							return '<div style="min-width:50px;display:inline-block;margin: 0 10px 24px 0;;"><p ><div onclick="javascript:goToAlarmHistory(\''+data.eventMajorPageUrl+'\');" style="cursor:pointer" ><span style="display:inline-block;background-color:' + this.color + ';width:3px;height:34px;margin:0 9px 0 0"></span><span class="font_normal10" style="position:absolute;top:0px;height:10px;line-height:10px;font-size:10px;font-weight:400; display:inline-block;">' + this.name + '</span><span style="font-family:Roboto;font-size:27px;line-height:1;font-weight:400;">' + majorCount + '</span></div></p></div>';
						}
						else
						{
							return '<div style="min-width:50px;display:inline-block;margin: 0 10px 24px 0;;"><p ><div style="cursor:default" ><span style="display:inline-block;background-color:' + this.color + ';width:3px;height:34px;margin:0 9px 0 0"></span><span class="font_normal10" style="position:absolute;top:0px;height:10px;line-height:10px;font-size:10px;font-weight:400; display:inline-block;">' + this.name + '</span><span style="font-family:Roboto;font-size:27px;line-height:1;font-weight:400;">' + majorCount + '</span></div></p></div>';
						}
                    }
                },
                itemStyle: {
                    color: '#000',
                    fontWeight: 'bold',
                    fontSize: '19px',
                    fontFamily: 'Roboto'
                }
            },
            plotOptions: {
                pie: {
                    size: 120,
                    shadow: false,
                    dataLabels: {
                        enabled: false,
                    },
					point:{
					   events : {
						legendItemClick: function(e){
							e.preventDefault();
						}
					   }
				   },
                   showInLegend: true
                }
            },
            title: {
                text: data.legendDataTotal,
                margin: 0,
                y: -25,
                x: 0,
                align: 'center',
                verticalAlign: 'middle',
                style: {
                    color: strSkin=="Dark"?"#c6c6c6":"#000000",
                    fontSize: '56px',
                    fontFamily: 'Roboto',
                    fontWeight: 'normal',
                    lineHeight: '1em',
                },
            },
            series: [{
                type: 'pie',
                 borderColor: strSkin=="Dark"?"#404040":"#ffffff",
                //name: 'Browser share',
                innerSize: '90%',
                states: {
                    hover: {
                        enabled: false
                    }
                },
                data: data.legendData,
                /* data: [{
                         y: 2,
                         name: "CRITICAL",
                         color: "#d93025"
                     },
                     {
                         y: 0,
                         name: "MAJOR",
                         color: "#faa81e"
                     },
                     {
                         y: 0,
                         name: "MINOR",
                         color: "#d2c800"
                     }

                 ]*/
            }],
            exporting: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
        }
		if(!data.dataAvailable){
			$('#clusteralerts_chart').hide();
			$('#nodata').show();
		}else{
			$('#clusteralerts_chart').show();
			$('#nodata').hide();
		}
		
        return chartProp;
    },

    updateChart: function(datax) {
        var me = this;
        if (!Ext.isEmpty($('#clusteralerts_chart'))) {
            var ChartData = me.chartView(datax);
            $('#clusteralerts_chart').highcharts(ChartData);
        };
    },
    listeners: {
        viewready: function(cmp) {
            var me = this;
            //alert("viewready");
            //cmp.chartdata(cmp);
            me.clusterAlertData(cmp);
        },
        resize: function(cmp) {
            var me = this;

            //alert("resize");
            //me.clusterAlertData(cmp);
            //me.updateChart(data);
            //var ChartData = me.chartView(me.store);
            // console.log("Cluster Node update jsonData-->", me.store);
            // $('#clusteralerts_chart').highcharts(ChartData);
        }

    }
});