Ext.define('ClusterDashboard.controller.Main', {
    extend: 'Ext.app.Controller',
    refs: [{
        selector: 'Main',
        ref: 'Main'
    }],
	requires:['ClusterDashboard.view.Main','ClusterDashboard.view.ClusterAvailability','ClusterDashboard.view.ClusterAlerts'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'clusteravailability', ref:'clusteravailability'},
		{selector:'clusteralerts', ref:'clusteralerts'}
	],
	init: function() {
        this.control({			
			'main': {
                "afterrender": this.hideMainMask
            },
			'viewport':
			{
				'afterrender': this.afterMainRender
			}	
        });
    },
	afterMainRender: function()
	{
		var mainViewIdObj = Ext.getCmp('mainViewId');
		var innerMainPanelObj = Ext.getCmp('innerPanel');
	},
    hideMainMask:function() {
        Ext.get('ClusterDashboardMask').remove();
    },
	refresh: function(compName,compType)
	{
		var me =this;
		Ext.Ajax.request(
		{
			url: '/final/monitor/clusterDashboard.jsp?reqFrom=overview&compType='+encodeURIComponent(compType)+'&compName='+encodeURIComponent(compName),
			method: 'POST',
			success: function (response) {
				var jsonText = response.responseText;
				if (response.status == 200 && !Ext.isEmpty(jsonText)) {								
					jsonData = Ext.decode( jsonText );
					me.loadOverviewData(jsonData);					
				}
			}
		});	

		Ext.Ajax.request(
		{
			url: '/final/monitor/clusterDashboard.jsp?reqFrom=alerts&compType='+encodeURIComponent(compType)+'&compName='+encodeURIComponent(compName),
			method: 'POST',
			success: function (response) {
				var jsonText = response.responseText;
				if (response.status == 200 && !Ext.isEmpty(jsonText)) {	
					var jsonDataAlerts = Ext.decode( jsonText );
					jsonDataAlerts = jsonDataAlerts['Alerts'][0];
					Ext.getCmp('clusteralerts').updateChart(jsonDataAlerts);
				}
			}
		});	
		
		Ext.Ajax.request(
		{
			url: '/final/monitor/clusterDashboard.jsp?reqFrom=wmi&compType='+encodeURIComponent(compType)+'&compName='+encodeURIComponent(compName), 
			method: 'POST',
			success: function (response) {
				var jsonText = response.responseText;											
				if (response.status == 200 && !Ext.isEmpty(jsonText)) {								
					var jsonData = Ext.decode( jsonText );
					Ext.getCmp('clusterVMIGrid').getStore().loadRawData(jsonData);
				}
			}
		});
		
		Ext.Ajax.request(
		{
			url: '/final/monitor/clusterDashboard.jsp?reqFrom=resources&compType='+encodeURIComponent(compType)+'&compName='+encodeURIComponent(compName),
			method: 'POST',
			success: function (response) {
				var jsonText = response.responseText;											
				if (response.status == 200 && !Ext.isEmpty(jsonText)) {								
					var jsonDataResource = Ext.decode( jsonText );
					jsonDataResource = jsonDataResource['ResourcesData'];
					
					for (var i = 0; i < jsonDataResource.length; i++) {
						Ext.getCmp('clusternodes' + i).updateChart(jsonDataResource[i]);
					}
				}
			}
		});

		Ext.getCmp('accordionBlock').items.items.forEach(function(item,index){
			if(!item.getCollapsed()){
				if(item.stateId == 'disk')
				{
					Ext.Ajax.request(
					{
						url: '/final/monitor/clusterDashboard.jsp?reqFrom=disk&compType='+encodeURIComponent(compType)+'&compName='+encodeURIComponent(compName),
						method: 'POST',
						success: function (response) {
							var jsonText = response.responseText;
							if (response.status == 200 && !Ext.isEmpty(jsonText)) {								
								var jsonDataDisk = Ext.decode( jsonText );
								jsonDataDisk = jsonDataDisk['disk'][0]['uiData'];
								for (var i = 0; i < jsonDataDisk.length; i++) {
									Ext.getCmp('clusterpiedisk' + i).updateChart(jsonDataDisk[i]);
								}
							}
						}
					});
				}
				else if(item.stateId == 'network')
				{
					Ext.Ajax.request(
					{
						url: '/final/monitor/clusterDashboard.jsp?reqFrom=network&compType='+encodeURIComponent(compType)+'&compName='+encodeURIComponent(compName), 
						method: 'POST',
						success: function (response) {
							var jsonText = response.responseText;											
							if (response.status == 200 && !Ext.isEmpty(jsonText)) {								
								var jsonDataNetwork = Ext.decode( jsonText );
								//jsonDataNetwork = jsonDataResource['network']['gridData'];
								item.getComponent(0).getStore().loadRawData(jsonDataNetwork);
							}
						}
					});
				}
				else if(item.stateId == 'applications')
				{
					Ext.Ajax.request(
					{
						url: '/final/monitor/clusterDashboard.jsp?reqFrom=application&compType='+encodeURIComponent(compType)+'&compName='+encodeURIComponent(compName), 
						method: 'POST',
						success: function (response) {
							var jsonText = response.responseText;											
							if (response.status == 200 && !Ext.isEmpty(jsonText)) {								
								var jsonDataApplication = Ext.decode( jsonText );
								//jsonDataNetwork = jsonDataResource['network']['gridData'];
								item.getComponent(0).getStore().loadRawData(jsonDataApplication);
							}
						}
					});
				}
				else if(item.stateId == 'sharedVolumes')
				{
					Ext.Ajax.request(
					{
						url: '/final/monitor/clusterDashboard.jsp?reqFrom=sharedvolumes&compType='+encodeURIComponent(compType)+'&compName='+encodeURIComponent(compName),
						method: 'POST',
						success: function (response) {
							var jsonText = response.responseText;							
							if (response.status == 200 && !Ext.isEmpty(jsonText)) {								
								var jsonDataSharedVolumes = Ext.decode( jsonText );
								jsonDataSharedVolumes = jsonDataSharedVolumes['Data'][0]['uiData'];								
								for (var i = 0; i < jsonDataSharedVolumes.length; i++) {																	
									Ext.getCmp('clustersharedvolume'+i).updateChart(jsonDataSharedVolumes[i]);
								}
							}
						}
					});
				}
				else if(item.stateId == 'interfaces')
				{
					Ext.Ajax.request(
					{
						url: '/final/monitor/clusterDashboard.jsp?reqFrom=interfaces&compType='+encodeURIComponent(compType)+'&compName='+encodeURIComponent(compName),
						method: 'POST',
						success: function (response) {
							var jsonText = response.responseText;											
							if (response.status == 200 && !Ext.isEmpty(jsonText)) {								
								var jsonDataInterfaces = Ext.decode( jsonText );
								item.getComponent(0).getStore().getRootNode().removeAll();
								item.getComponent(0).getStore().getRootNode().appendChild(jsonDataInterfaces.children);
							}
						}
					});
				}
			}
		});
	},
	loadOverviewData: function(jsonData)
	{
		var healthData = jsonData['Health'];
		if(!Ext.isEmpty(healthData))
		{
			var owner_node = healthData['owner_node'];
			var owner_Lbl = healthData['Owner-title'];
			var healthTitle = healthData['title'];
			var uiData = healthData['uiData'];

			var clusterNode = uiData[0]['name'];
			var state = uiData[0]['state'];			

			if(!Ext.isEmpty(clusterNode))
			{
				Ext.getCmp('healthID').update('<div  class="clustorHealth" style="height:45px;display:flex;align-items:center;justify-content:center;"><span class="font_normal13" style="">'+healthTitle+' : <img src="../images/clear.png" class="cluster'+state+'"  style="vertical-align: middle;margin: -2px 7px 0 10px;" /></span><span class="font_normal16" style="margin:-2px 0 0 0;">'+clusterNode+'</span></div>');
			}
			else
			{
				Ext.getCmp('healthID').update('<div  class="clustorHealth" style="height:45px;display:flex;align-items:center;justify-content:center;"><span class="font_normal13" style="">'+healthTitle+' : <img src="../images/clear.png" class="cluster'+state+'"  style="vertical-align: middle;margin: -2px 7px 0 10px;" /></span><span class="font_normal16" style="margin: -2px 0 0 5px"> - </span></div>');
			}
		}
		else
		{
			Ext.getCmp('healthID').update('<div  class="clustorHealth" style="height:45px;display:flex;align-items:center;justify-content:center;"><span class="font_normal13" style="">Health : </span><span class="font_normal16" style="margin: -2px 0 0 5px"> - </span></div>');
		}
		
		var uptimeData = jsonData['Uptime'];		
		var uptimeTitle  = uptimeData['title'];
		var daysVal  = uptimeData['days'];
		var hrsVal  = uptimeData['hrs'];
		var MthVal  = uptimeData['Mth'];
		var minsVal  = uptimeData['mins'];
		var secsVal  = uptimeData['secs'];
		var daysLbl  = uptimeData['daysLbl'];
		var hrsLbl  = uptimeData['hrsLbl'];
		var minsLbl  = uptimeData['minsLbl'];
		var secsLbl  = uptimeData['secsLbl'];
		var monthLbl  = uptimeData['monthLbl'];
		var stateCls = ''; //.clusterCrictical .clusterIntermediate  .clusterLow  .clusterGood 
		if(state == 'GOOD')
		{
			stateCls = 'clusterGood';
		}
		else if(state == 'HIGH')
		{
			stateCls = 'clusterCrictical';
		}
		else if(state == 'INTERMEDIATE')
		{
			stateCls = 'clusterIntermediate';
		}
		else if(state == 'LOW')
		{
			stateCls = 'clusterLow';
		}
		

		var uptimeData = '<div  class="clustorHealth" style="height:45px;display:flex;align-items:center;justify-content:center;"><p class="font_normal13" style="display: flex;justify-content: center;align-items: center;"><img src="../images/clear.png" class="clusterUptime" style="vertical-align: middle;margin: -2px 7px 0 10px;position:relative;top:-3px;" />'+uptimeTitle+' :';
		
		if(!Ext.isEmpty(MthVal))
		{
			uptimeData +='<span class="font_normal24" style="margin: 0 5px 0 15px;">'+MthVal+'</span><span style="display: flex;justify-content: center;align-items: center;position:relative;top:0px;">'+monthLbl+'</span>';
		}
		if(!Ext.isEmpty(daysVal))
		{
			uptimeData +='<span class="font_normal24" style="margin: 0 5px 0 15px;">'+daysVal+'</span><span style="display: flex;justify-content: center;align-items: center;position:relative;top:0px;">'+daysLbl+'</span>';
		}
		if(!Ext.isEmpty(hrsVal))
		{
			uptimeData +='<span style="margin:0 5px 0 25px;" class="font_normal24" >'+hrsVal+'</span><span style="display: flex;justify-content: center;align-items: center;position:relative;top:0px;"> '+hrsLbl+'</span>';
		}
		if(!Ext.isEmpty(minsVal))
		{
			uptimeData +='<span style="margin:0 5px 0 25px;" class="font_normal24" >'+minsVal+'</span><span style="display: flex;justify-content: center;align-items: center;position:relative;top:0px;">'+minsLbl+'</span>';
		}
		if(!Ext.isEmpty(secsVal))
		{
			uptimeData +='<span style="margin:0 5px 0 25px;" class="font_normal24" >'+secsVal+'</span><span style="display: flex;justify-content: center;align-items: center;position:relative;top:0px;"> '+secsLbl+'</span>';
		}
		
		if(Ext.isEmpty(daysVal) && Ext.isEmpty(hrsVal) && Ext.isEmpty(minsVal) && Ext.isEmpty(secsVal) )
		{
			uptimeData +='<span style="display: flex;justify-content: center;align-items: center;position:relative;margin: 0 5px 0 10px;"> - </span>';
		}
		uptimeData +='</p></div>';

		Ext.getCmp('uptimeID').update(uptimeData);
		
		if(!Ext.isEmpty(owner_node))
		{
			Ext.getCmp('ownerID').update('<div  class="clustorHealth" style="height:45px;display:flex;align-items:center;justify-content:center;"><span class="font_normal13" style=""><img src="../images/clear.png" class="clusterOwner" data-qtip="'+owner_node+'" style="vertical-align: middle;margin: -2px 7px 0 10px;position:relative;top:-3px;" />'+owner_Lbl+' : </span><span class="font_normal16" style="margin: -2px 0 0 10px;">'+owner_node+'</span></div>');
		}
		else
		{
			Ext.getCmp('ownerID').update('<div  class="clustorHealth" style="height:45px;display:flex;align-items:center;justify-content:center;"><span class="font_normal13" style=""><img src="../images/clear.png" class="clusterOwner" data-qtip="" style="vertical-align: middle;margin: -2px 7px 0 10px;position:relative;top:-3px;" />Owner Node :</span><span  style="margin: 0 5px 0 10px;"> - </span></div>');
		}
	}
  
   /* delightMe:function( combo, The, eOpts ){
    	combo.up('container').getEl().setStyle({"background":"#64b4c1"});
    	Ext.getCmp('KIOSK_dashboard_combo').getEl().setStyle({"margin":"0 0 0 0px"});
    	Ext.getCmp('kiosk_tbseparator').getEl().setStyle({"margin":"0 0 0 -5px"});
    	 
    },
   	highlightMe:function( combo, The, eOpts ){
    	combo.up('container').getEl().setStyle({"background":"#126077"});
    	Ext.getCmp('KIOSK_dashboard_combo').getEl().setStyle({"margin":"0 0 0 5px"});
    	Ext.getCmp('kiosk_tbseparator').getEl().setStyle({"margin":"0 0 0 35px"});
		
    },*/
	
});