
<%
/********************************************************************************
FileName	:egSystemDashboardVMTab.jsp
Purpose		:This is created for System tab in Monitor Dashboard
Created by	:Simeon.D
Created on	:05/03/2009
modified on :04/02/10 - G. Arivarasu
				To include fusion chart 
**********************************************************************************/
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ include file = "EgMonitorTracker.jsp"%>
<%@ page import="com.eg.SidCheck" %>
<%@ page import="com.egurkha.*" %>
<%@ page import="java.util.*" %>
<%@page import = "java.util.*"%>
<%@ page errorPage="EgProbsM.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import="java.text.*"%>
<%@ page import="java.sql.*"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="egurkha.*"%>
<%@ page import="egurkha.reporter.ErInfo"%>
<%@ page import="egurkha.reporter.ErTimePlotsBean"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgExternalInfo"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgDateInfo"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import="com.eg.EgMemInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.util.DateTimeTokenizer"%>
<%@ page import="com.egurkha.Health"%>
<%@ page import="com.egurkha.State"%>
<%@ page import="com.egurkha.EgMeasureGraphExt"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="com.eg.EgDbAdapterTypeUI"%>
<%@ page import="egurkha.EgDbAdapterUI"%>
<%@page import="egurkha.reporter.ErUtils"%>
<%@ page import="com.objectplanet.chart.*"%>
<%@ page import="egurkha.reporter.uptime.*"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import="net.sf.json.*"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="com.egurkha.*"%>
<%@ page import="com.egurkha.UserRegistry"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import="com.egurkha.HighChartTimeline"%>
<%@ page import="com.eg.supermanager.*"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>
<%
try
{
	if(EgInstallInfo.isSuperManager)
	{
		String hostname = request.getParameter("hostName");
		//System.out.println("egSystemDashBoardVMTab.jsp hostname " + hostname);
		if(hostname != null && !hostname.trim().equalsIgnoreCase("null"))
		{
			if(hostname.indexOf(":")>-1)
			{
				hostname = hostname.substring(0,hostname.indexOf(":"));
			}
			//System.out.println("egSystemDashBoardVMTab.jsp host " + hostname);
			ArrayList managerIds = EgElementInfo.getInstance().getManagerIDs("component",hostname);
			//System.out.println("egSystemDashBoardVMTab.jsp managerIds " + managerIds);
			if(managerIds != null && !managerIds.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(request.getSession().getId(),managerIds);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
			}
		}
	}
	boolean isFusionChart=HighChartTimeline.isFusion();
	ErUtils  erutils=new  ErUtils();
	//com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	//String trackerLanguage = trackerUI.getDefaultLanguage();
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniObj=new IniFile(s_iniFile_dir+"eg_dashboard.ini");
	IniFile iniObj2=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	//EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	EgMeasureGraphExt measureGraphInfo = new EgMeasureGraphExt();
	DateTimeTokenizer dtd = new DateTimeTokenizer();
	EgDashBoardModel  egDashboard=new  EgDashBoardModel();
	String subject="System_Dashboard_Metrics";
	//String monitor_Skin = null;
	JSONObject json=new JSONObject();
	JSONObject HiddenFields=new JSONObject();
	JSONObject keyobj=new JSONObject();
	JSONObject LowerPanel=new JSONObject();
	JSONArray UpperPanel=new JSONArray();
	
	
	IniUI iniUI = IniUI.getInstance();
	String thisLanguage = iniUI.getDefaultLanguage();
	UserRegistry ur = UserRegistry.getInstance();
	String sessionID = session.getId();
	//User u_ser = ur.getUser(sessionID);
	if (u_ser!=null)
	{
		String userLang = u_ser.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	monitor_Skin  = u_ser.getMonitorSkin();

	IniFile egUi = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");

	String chartOption = egUi.getValue("CHART_TYPE","ChartOption");
	String chartTimeline = egUi.getValue("CHART_TYPE","Timeline");
	chartTimeline = (chartTimeline != null && !chartTimeline.equals(""))?chartTimeline:"1 hour";

	String currentDateFormat = egUi.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	
	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}
	String ddGraphWidth="232";
	String ddGraphHeight="156";

	String EasyGraphWidth="250";
	String EasyGraphHeight="180";

	String HealthGraphWidth="250";
	String HealthGraphHeight="110";

	double defaultDDGraphWidth=300;
	double defaultDDGraphHeight=150;

	double defaultEasyGraphWidth=300;
	double defaultEasyGraphHeight=200;

	double defaultHealthGraphWidth=250;
	double defaultHealthGraphHeight=110;

	double defaultDialGraphWidth=230;  // default dial graph width for calculation
	double defaultDialGraphHeight=115;  // default dial graph height for calculation
	double dialGraphWidth=230;  
	double dialGraphHeight=115;

	double dialGraphWidthTo1024PxInPercent=defaultDialGraphWidth/1024;
	double dialGraphHeightToDefaultWidthInPercent=defaultDialGraphHeight/defaultDialGraphWidth;

	double defaultGauageOuterRadius=65; // default dial graph width for calculation
	double defaultGaugeXPos=85; // default dial graph Gauge X position for calculation
	double defaultGaugeYPos=93; // default dial graph Gauge Y position for calculation 

	String gauageOuterRadius="65";
	String dialRadius="60";
	String baseWidth="5";
	String fontSizeForDial="9";
	String gaugeXPos="85";
	String gaugeYPos="93";
	//for bar chart
	double ddgraphWidthTo1024Px=defaultDDGraphWidth/1024;
	double ddGraphWidthInDouble=screenWidthInDouble*ddgraphWidthTo1024Px;
	ddGraphWidth=erutils.round(ddGraphWidthInDouble,0);

	double ddgraphHeightToDefaultDDHeightInPercent=defaultDDGraphHeight/defaultDDGraphWidth;
	double ddGraphHeightInDouble=ddGraphWidthInDouble*ddgraphHeightToDefaultDDHeightInPercent;
	ddGraphHeight=erutils.round(ddGraphHeightInDouble,0);
	
	//for easy chart
	double EasygraphWidthTo1024Px=defaultEasyGraphWidth/1024;
	double EasyGraphWidthInDouble=screenWidthInDouble*EasygraphWidthTo1024Px;
	EasyGraphWidth=erutils.round(EasyGraphWidthInDouble,0);

	double EasygraphHeightToDefaultEasyHeightInPercent=defaultEasyGraphHeight/defaultEasyGraphWidth;
	double EasyGraphHeightInDouble=EasyGraphWidthInDouble*EasygraphHeightToDefaultEasyHeightInPercent;
	EasyGraphHeight=erutils.round(EasyGraphHeightInDouble,0);
	
	//for layerwise health chart
	double HealthgraphWidthTo1024Px=defaultHealthGraphWidth/1024;
	double HealthGraphWidthInDouble=screenWidthInDouble*HealthgraphWidthTo1024Px;
	HealthGraphWidth=erutils.round(HealthGraphWidthInDouble,0);

	double insideKpiDivWidth=(screenWidthInDouble-HealthGraphWidthInDouble)-100;
	double HealthgraphHeightToDefaultHealthHeightInPercent=defaultHealthGraphHeight/defaultHealthGraphWidth;
	double HealthGraphHeightInDouble=HealthGraphWidthInDouble*HealthgraphHeightToDefaultHealthHeightInPercent;
	HealthGraphHeight=erutils.round(HealthGraphHeightInDouble,0);

	//EgInsideViewChartUtil fusionChart=new EgInsideViewChartUtil();
	EgFusionChartUtil fusChart=new EgFusionChartUtil(trackerLanguage);

	boolean hasConfig=false;
	boolean ddEnabled = EgMemInfo.ddEnabled;
	boolean noGraphsFound=true;

	String compName=request.getParameter("hostName");
	String compType=request.getParameter("compType");
	String siteName=request.getParameter("site");
	if(siteName==null)
		siteName="NULL";
	String componentState=egDashboard.getServerState(compName,compType,siteName);

	egDashboard.setSubject(compType);

	String tab=request.getParameter("tab");
	String subsystem=request.getParameter("subsystem");
	String graphType=request.getParameter("graphType");
	String SystemHealthStartDate=request.getParameter("starttime");
	String SystemHealthEndDate=request.getParameter("endtime");
	String SystemHealthStartHr=request.getParameter("starthr");
	String SystemHealthEndHr=request.getParameter("endhr");
	String high=mappingInfo.getTextDescription("monitor.dashboard.Critical");
	String inter=mappingInfo.getTextDescription("monitor.dashboard.Major");
	String low=mappingInfo.getTextDescription("monitor.dashboard.Minor");
	//Added for Insideview Dashboard
	String from_page=request.getParameter("from_page");
	String selected_info=request.getParameter("info");
	String selected_info_url = "";
	if(selected_info!=null && selected_info.trim().length()>0 && !selected_info.equalsIgnoreCase("NULL"))
		selected_info_url = selected_info;
	String site=request.getParameter("site");
	if(selected_info!=null && selected_info.trim().length()>0)
	{
		selected_info=com.egurkha.util.StringUtils.replace(selected_info,"|plus|","+");
		selected_info=com.egurkha.util.StringUtils.replace(selected_info,"|amp|","&");
		selected_info=com.egurkha.util.StringUtils.replace(selected_info,"|pct|","%");
		selected_info=com.egurkha.util.StringUtils.decodeSecurityChar(selected_info);
	}

	String Layer_name=request.getParameter("Layer");
	String allComps=request.getParameter("allComps");
	//---end---

	boolean isfromSuper = session.getAttribute("fromSuper") != null &&
	session.getAttribute("fromSuper").toString().equalsIgnoreCase("yes");

	Vector priorities = new Vector();

	priorities.add("HIGH");
	priorities.add("INTERMEDIATE");
	priorities.add("LOW");
	priorities.add("GOOD");
	priorities.add("UNKNOWN");

	if(graphType==null || graphType.equals(""))
	{
		graphType="measuregraph";
	}

	SimpleDateFormat sf=new SimpleDateFormat("MM/dd/yyyy");
	SimpleDateFormat sf1=new SimpleDateFormat("dd/MM/yyyy");
	java.util.Date endDate=new java.util.Date();
	java.util.Date startDate=new java.util.Date(endDate.getTime()-(60*60*1000));
	EgExternalInfo egExternalInfo=new EgExternalInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgDashboardMGraphModel measureGraph=new EgDashboardMGraphModel();
	String hostName="";
	String portNo="";
	String startTime="";
	String endTime="";
	String startHour="";
	String endHour="";

	String startTime1="";
	String endTime1="";
	String test="";
	String measure="";
	String info="";
	String mHost="";
	String state="";
	String status="";
	String sid="";

	int dialChartNoMeasuresCount=0;
	int tempDialGraphCount=0;
	boolean isTRNeedInDialChart=false;

	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}
	MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO serverDashboardDAO=monitorDaoFactory.getServerDashBoardDAO();
	Hashtable allMsmtHosts=serverDashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=serverDashboardDAO.getDescriptorsForAllTest(compName,compType,tab);
	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);

	List agentsForDial = egExternalInfo.getAgentsFor(test,compType,hostName);
	if(agentsForDial!=null && agentsForDial.size()>0)
		mHost=(String)agentsForDial.get(0);
	else
		mHost=hostName;
	//mHost=(String)allMsmtHosts.get(test);

	try
	{
		startTime=sf.format(startDate);
		endTime=sf.format(endDate);
		startTime1=sf1.format(startDate);
		endTime1=sf1.format(endDate);
	}
	catch(Exception ex)
	{
		System.out.println("Exception...."+ex);
	}

	if(from_page!=null && from_page.trim().equalsIgnoreCase("VMTabView"))
	{
		subject="Insideview_Dashboard_"+compType;
		egDashboard.setSubject(compType,subject);
		egDashboard.setLayer(Layer_name);
	}

	boolean isSubjectFound=false;
	List subjects=Arrays.asList(iniObj.getSubjects());
	
	if(subjects.contains(subject))
		isSubjectFound=true;

	if(isSubjectFound)
	{
		String healthFlag="No";
		String EventAnalysistimeline=iniObj.getValue("Default_HistoricalEvents_Duration","duration");
		//MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
		//ErUtils erutils=new ErUtils();
		
		EgDashBoardDAO dashboardDAO=monitorDaoFactory.getDashBoardDAO();
		ErInfo erInfo=new ErInfo();
		EgDateInfo egDate=new EgDateInfo();
		Hashtable performanceIndicators=new Hashtable();
		Hashtable alarmCount=new Hashtable();
		Hashtable alarmDetails=new Hashtable();
		Hashtable currentStatus=new Hashtable();
		Hashtable events=new Hashtable();
		Hashtable minMaxAvg=new Hashtable();
		Hashtable currentMeasure=new Hashtable();
		if(from_page!=null && from_page.trim().length()>0 && 
			 from_page.equalsIgnoreCase("VMTabView"))
		{
			performanceIndicators=egDashboard.getPerformanceIndicatorsVMTab(compName,compType,"System",selected_info);
			alarmCount=egDashboard.getAlarmCount(compName,compType,"System",selected_info);
			alarmDetails=egDashboard.getAlarmDetails(from_page,selected_info);
			currentStatus=egDashboard.getCurrentStatusForServer(compName,compType,"System",selected_info);
			events=egDashboard.getEventsForServer(compName,compType,"System",selected_info);
			minMaxAvg=egDashboard.getMinMaxAvgForMeasures(compName,compType,"System",selected_info);
			currentMeasure = egDashboard.getCurrentMeasures(compName,compType,"System",selected_info);
		}
		String ddMeasures=egDashboard.getDDMeasures("Insideview_Dashboard_"+compType,"System");

		hasConfig=false;
		String ddtimeline=iniObj.getValue("Default_DD_Duration","duration");
		String startenddates=egDashboard.getStartEndDatesForTimelines(ddtimeline,"");
		if(!hasConfig)
		{
			healthFlag="Yes";
		}

		DDOverview  ddoverview=new  DDOverview();
		String ddtest="";
		String ddmeasure="";
		String ddformat="";
		String dataTitle="";
		String graphTitle="";

		int eventsCount=0;
		if(events!=null)
		{
			Integer countObj=(Integer)events.get("Count");
			if(countObj!=null)
				eventsCount=countObj.intValue();
		}

		String unit="";
		if(subsystem!=null && subsystem.equals("CPU"))
		{
			ddtest="VmgSystemTest";
			ddmeasure="Cpu_util";
			ddformat="%CPU";
			dataTitle=mappingInfo.getTextDescription("monitor.dashboard.Top CPU consuming processes");
			graphTitle=mappingInfo.getTextDescription("monitor.dashboard.CPU usage by top processes");
			unit="(%)";
		}
		if(subsystem!=null && subsystem.equals("Memory"))
		{
			ddtest="VmgOSMemoryTest";
			ddmeasure="Physical_mem_utilze";
			ddformat="Memory_used";
			dataTitle=mappingInfo.getTextDescription("monitor.dashboard.Top memory consuming processes");
			graphTitle=mappingInfo.getTextDescription("monitor.dashboard.Memory usage by top processes");
			unit="(%)";
		}
		if(subsystem!=null && subsystem.equals("Disk"))
		{
			ddtest="VmgDiskActivityTest";
			ddmeasure="Percent_busy";
			ddformat="IO_Rate(KB/sec)";
			dataTitle=mappingInfo.getTextDescription("monitor.dashboard.Disk activity - Top processes");
			graphTitle=mappingInfo.getTextDescription("monitor.dashboard.Disk Busy by top processes");
			unit="(Bytes/sec)";
		}
		Hashtable analysisData=new Hashtable();
		if(from_page!=null && from_page.trim().length()>0 && 
			 from_page.equalsIgnoreCase("VMTabView"))
		{
			analysisData=ddoverview.getDDAnalysisData(compName,compType,ddtest,ddmeasure,ddformat,"System","","","","","","",selected_info);
		}

		String systemOverviewValues="";
		systemOverviewValues=iniObj.getValue(subject,"System_"+subsystem);

		Vector sysOverviewTests=new Vector();
		Vector sysOverviewMeasure=new Vector();

		if(systemOverviewValues!=null && !systemOverviewValues.equals(""))
		{
			StringTokenizer testDetails=new StringTokenizer(systemOverviewValues,",");
			while(testDetails.hasMoreTokens())
			{
				String token=testDetails.nextToken();
				if(token!=null && token.indexOf(":")!=-1)
				{
					sysOverviewTests.add(token.substring(0,token.indexOf(":")));
					sysOverviewMeasure.add(token.substring(token.indexOf(":")+1));
				}
			}
		}
		state=egDashboard.getServerState(hostName,compType,siteName);
		String ua = request.getHeader( "User-Agent" );
		boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
		boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );

		boolean isFirefox2 = ( ua != null && ua.indexOf( "Firefox/2" ) != -1 );
		boolean isFirefox3 = ( ua != null && ua.indexOf( "Firefox/3" ) != -1 );
		boolean isChrome = ( ua != null && ua.indexOf( "Chrome/" ) != -1 );

		
		
		HiddenFields.put("componentState",componentState);
		
		JSONObject subsystemcombo = new JSONObject();
		subsystemcombo.put("imageURL","/final/monitor/eg_images/"+subsystem+".png");
		subsystemcombo.put("title",mappingInfo.getTextDescription("monitor.dashboard.Subsystem"));
		
		if(from_page!=null && from_page.equalsIgnoreCase("VMTabView"))
		{
			subsystemcombo.put("name","subsystemSelectForVmTab");

		}
		else
		{
			subsystemcombo.put("name","subsystemSelect");
		}
		if(tab!=null && tab.equalsIgnoreCase("system"))
		{
			HiddenFields.put("tab",tab);
			HiddenFields.put("Layer",Layer_name);
			HiddenFields.put("info",selected_info);
			HiddenFields.put("fromPage",from_page);
			JSONArray combooptionsAray = new JSONArray();
			
			String systemSubsystems=iniObj.getValue(subject,"System_subsystems");
			StringTokenizer subsystemTokens=new StringTokenizer(systemSubsystems,":");
			while(subsystemTokens.hasMoreTokens())
			{
				JSONObject combooptions = new JSONObject();
				String token=subsystemTokens.nextToken();
				if(subsystem!=null && token!=null && subsystem.equalsIgnoreCase(token))
				{
					combooptions.put("name",mappingInfo.getTextDescription("monitor.dashboard."+token));
					combooptions.put("value",token);
					subsystemcombo.put("selected",token);
				}
				else
				{
					combooptions.put("name",mappingInfo.getTextDescription("monitor.dashboard."+token));
					combooptions.put("value",token);
				}
				combooptionsAray.add(combooptions);
			}
			subsystemcombo.put("comboValues",combooptionsAray);
		}
		json.put("subsystemCombo",subsystemcombo);
		//UpperPanel.add(Subsystem);
		if(subsystem!=null && !subsystem.equalsIgnoreCase("DDAnalyzer"))
		{
			if(subsystem!=null && subsystem.equalsIgnoreCase("overview"))
			{
				JSONObject systemalert = new JSONObject();
				systemalert.put("title",mappingInfo.getTextDescription("monitor.dashboard.Current System Alerts"));

				int openproblems=0;
				Integer   critical=(Integer)alarmCount.get("HIGH");
				Integer   major=(Integer)alarmCount.get("INTERMEDIATE");
				Integer   minor=(Integer)alarmCount.get("LOW");
				if(alarmCount!=null && alarmCount.size()>0 && (critical.intValue()+major.intValue()+minor.intValue())>0)
				{
				
					String criticalDesc=(String)alarmDetails.get("HIGH");
					String majorDesc=(String)alarmDetails.get("INTERMEDIATE");
					String minorDesc=(String)alarmDetails.get("LOW"); openproblems=critical.intValue()+major.intValue()+minor.intValue();
					
					systemalert.put("monitor.dashboard.Open Alerts",mappingInfo.getTextDescription("monitor.dashboard.Open Alerts"));
					systemalert.put("openAlertsValue",openproblems);
					
					
					systemalert.put("monitor.dashboard.Distribution",mappingInfo.getTextDescription("monitor.dashboard.Distribution"));
					JSONArray alertArray = new JSONArray();
					JSONObject alertValueObj = new JSONObject();
					if(critical!=null && critical.intValue()>0)
					{

						if(from_page!=null && from_page.equalsIgnoreCase("VMTabView"))
						{
							alertValueObj.put("value",critical.intValue());
							alertArray.add(alertValueObj);

						}
						else
						{
							alertValueObj.put("value",critical.intValue());
							alertArray.add(alertValueObj);
					
						}
					}
					else
					{
						alertValueObj.put("value",critical.intValue());
						alertArray.add(alertValueObj);
					}
					if(major!=null && major.intValue()>0)
					{
							
						if(from_page!=null && from_page.equalsIgnoreCase("VMTabView"))
						{
								alertValueObj.put("value",major.intValue());
								alertArray.add(alertValueObj);
						}
						else
						{
							alertValueObj.put("value",major.intValue());
							alertArray.add(alertValueObj);
							
						}
													
					}
					else
					{
						alertValueObj.put("value",major.intValue());
						alertArray.add(alertValueObj);
					}

					if(minor!=null && minor.intValue()>0)
					{

						if(from_page!=null && from_page.equalsIgnoreCase("VMTabView"))
						{
							alertValueObj.put("value",minor.intValue());
							alertArray.add(alertValueObj);
						}
						else
						{
							alertValueObj.put("value",minor.intValue());
							alertArray.add(alertValueObj);
						}

					}
					else
					{
						alertValueObj.put("value",minor.intValue());
						alertArray.add(alertValueObj);
					}
					systemalert.put("alertArray",alertArray);
				}
				else
				{
					systemalert.put("errorMsg",mappingInfo.getTextDescription("monitor.dashboard.No alarms found"+"!"));

				}
				json.put("systemAlert",systemalert);
				JSONObject HistoryEvents=new JSONObject();
				JSONObject ChartObject=new JSONObject();
				JSONArray HistoryEventsArray=new JSONArray();
				//HistoryEvents.put("title",mappingInfo.getTextDescription("monitor.dashboard.History of Events during last ")+mappingInfo.getTextDescription("monitor.common."+EventAnalysistimeline));

				String histroy1 = mappingInfo.getTextDescription("monitor.dashboard.History of Events during last ");
				String histroyValue1 = mappingInfo.getTextDescription("monitor.common."+EventAnalysistimeline);
				HistoryEvents.put("title",histroy1 + " " + histroyValue1);
				
				HistoryEvents.put("type","array");

				if(eventsCount!=0)
				{
					ErUtils erUtils=new ErUtils();
					double criticalEvtCount=0.0;
					double majorEvtCount=0.0;
					double minorEvtCount=0.0;

					Integer   criticalEvents=null;
					Integer majorEvents=null;
					Integer  minorEvents=null;
					
					ArrayList al=new ArrayList();
					criticalEvents=(Integer)events.get("HIGH");
					majorEvents=(Integer)events.get("INTERMEDIATE");
					minorEvents=(Integer)events.get("LOW");
					al.add(criticalEvents.toString());
					al.add(majorEvents.toString());
					al.add(minorEvents.toString());
					criticalEvtCount=criticalEvents.doubleValue();
					majorEvtCount=majorEvents.doubleValue();
					minorEvtCount=minorEvents.doubleValue();

					String max=erUtils.getMaximum(al);
					double[] Hsevalues=new double[]{criticalEvtCount,majorEvtCount,minorEvtCount};
					if(EventAnalysistimeline!=null && EventAnalysistimeline.indexOf("")>0)	
					{
						EventAnalysistimeline=EventAnalysistimeline.substring(0,EventAnalysistimeline.indexOf(""))+"+"+EventAnalysistimeline.substring(EventAnalysistimeline.indexOf("")+1);
					}
					String HistoricalEventsUrl="";
					String HistoricalGraphURL="";
					// For fusionchart
					Vector eventChartAttribute=new Vector();
					String historyXMLData="";
					if(from_page!=null && from_page.trim().length()>0 && 
					from_page.trim().equalsIgnoreCase("VMTabView"))
					{
						HistoricalEventsUrl="/final/monitor/EgAlarmHistoryView.jsp?newAlarms=true&compTypeList="+compType+"&compNameList="+compName.substring(0,compName.indexOf(":"))+"&glduration=0&duration=0&timeselect=seconds&eg_timeline=24+hours&eventsPerPage=All&arrangeAlarms=-1&fromDashBoard=true&selectedLayer=All&tab=Network&from_page="+from_page+"&insideview_info="+selected_info+"&Layer="+Layer_name+"&dashboardcomptype="+compType+"&dashboardcompname="+compName;
						HistoricalGraphURL="/final/servlet/com.egurkha.monitor.EventChart?hostName="+compName+"&compType="+compType+"&module=Network&width=230&height=88&imgdate="+new java.util.Date()+"&from_page="+from_page+"&info="+selected_info+"&Layer="+Layer_name;

						//--------------------------fusionchart added by arivu------------------//
						eventChartAttribute.add("majorTMNumber='6'");
						eventChartAttribute.add("majorTMHeight='10'");
						eventChartAttribute.add("majorTMColor='ffffff'");
						eventChartAttribute.add("minorTMColor='D5D5D5'");
						eventChartAttribute.add("minorTMHeight='5'");
						eventChartAttribute.add("minorTMNumber='5'");
						eventChartAttribute.add("majorTMThickness='2'");
						eventChartAttribute.add("palette='2'");
						eventChartAttribute.add("showValues='1'");
						eventChartAttribute.add("showYAxisValues='0'");
						eventChartAttribute.add("decimals='0'");
						eventChartAttribute.add("formatNumberScale='0'");
						eventChartAttribute.add("useRoundEdges='1'");
						eventChartAttribute.add("exportEnabled='1'");
						eventChartAttribute.add("showExportDialog='1'");
						eventChartAttribute.add("exportAction='save'");
						eventChartAttribute.add("exportTargetWindow='1'");
						eventChartAttribute.add("showShadow='1'");
						eventChartAttribute.add("showToolTipShadow='1'");
						eventChartAttribute.add("chartLeftMargin='8'");
						eventChartAttribute.add("chartRightMargin='20'");
						eventChartAttribute.add("chartTopMargin='3'");
						eventChartAttribute.add("chartBottomMargin='8'");
						//eventChartAttribute.add("bgColor='99CCFF,FFFFFF'");
						eventChartAttribute.add("bgColor='FFFFFF'");
						eventChartAttribute.add("bgAlpha='0,0'");
						eventChartAttribute.add("outCnvBaseFontColor='ffffff'");
						eventChartAttribute.add("canvasLeftMargin='17'");
						eventChartAttribute.add("canvasRightMargin='7'");
						eventChartAttribute.add("canvasTopMargin='5'");
						eventChartAttribute.add("canvasBottomMargin='7'");
						eventChartAttribute.add("showBorder='0'");
						//eventChartAttribute.add("bgColor='E6E6E6,E6E6E6'");
						//---------------------------Events Bar chart-----------------------------//
						
						String smUrl = null;
						if(isfromSuper)
						{
							smUrl = (String)session.getAttribute("Super_Manager_Url");
						}
						/* --- Method created by S.Saravanan ----*/ 
						EgInsideViewChartUtil fusionChart=new EgInsideViewChartUtil();
						historyXMLData=fusionChart.getXMLforEventHistoryVMTab(compName,compType,tab,eventChartAttribute,selected_info,Layer_name,isfromSuper,smUrl);
					}
					
					
					
					//ChartObject.put("title" , mappingInfo.getTextDescription("monitor.dashboard.History of Events During the Last") + mappingInfo.getTextDescription("monitor.common."+EventAnalysistimeline));
					String histroy = mappingInfo.getTextDescription("monitor.dashboard.History of Events during last ");
					String histroyValue = mappingInfo.getTextDescription("monitor.common."+EventAnalysistimeline);
					ChartObject.put("title",histroy + " " + histroyValue);
					
						
						
						
						
						
						 Vector chartAttributes=new Vector();
						chartAttributes.add("bgColor='FFFFFF'");
						chartAttributes.add("bgAlpha='0,0'");
						chartAttributes.add("showLimits='0'");
						chartAttributes.add("showBorder='0'");
						chartAttributes.add("upperLimit='100'");
						chartAttributes.add("lowerLimit='-2'");
						chartAttributes.add("ticksBelowGauge='1'");
						chartAttributes.add("placeValuesInside='0'");
						chartAttributes.add("showGaugeLabels='1'");
						chartAttributes.add("valueAbovePointer='0'");
						chartAttributes.add("pointerOnTop='0'");
						chartAttributes.add("pointerRadius='0'");
						chartAttributes.add("chartTopMargin='5'");
						chartAttributes.add("chartBottomMargin='5'");
						chartAttributes.add("chartLeftMargin='25'");
						chartAttributes.add("chartRightMargin='25'");
						chartAttributes.add("majorTMColor='D73027'");
						chartAttributes.add("plotFillPercent='60'");
						chartAttributes.add("showTickMarks='0'");
						chartAttributes.add("showTickValues='0'");
						chartAttributes.add("adjustTM='0'");
						chartAttributes.add("plotFillColor='000000'");
						chartAttributes.add("baseFontSize='8'");
						chartAttributes.add("baseFontColor='FFFFFF'");
						chartAttributes.add("pointerBgColor='000000'");
						chartAttributes.add("placeTicksInside='0'");
						chartAttributes.add("gaugeRoundRadius='6'");
						chartAttributes.add("ticksBelowGauge='0'");
						chartAttributes.add("showValue='0'");
						chartAttributes.add("exportEnabled='1'");
						chartAttributes.add("exportAction='download'");
						chartAttributes.add("exportAtClient='0'");
						chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'"); 
					

					//	String linearGaugeXML=fusionChart.getXmlForLinearGauge(chartAttributes);
//							EgServerDashboardModel egDashboard=new EgServerDashboardModel();

						 	/*Hashtable eventsTemp=egDashboard.getEventsForServer(compName,compType,tab,"24 hours");

							criticalEvents=(Integer)eventsTemp.get("HIGH");
							majorEvents=(Integer)eventsTemp.get("INTERMEDIATE");
							minorEvents=(Integer)eventsTemp.get("LOW");

							criticalEvents=1;
							majorEvents=2;
							minorEvents=3;*/
						int TotalSum = criticalEvents+majorEvents+minorEvents;

						json.put("criticalEvents" ,criticalEvents );
						json.put("majorEvents" ,majorEvents );
						json.put("minorEvents" ,minorEvents );
						int firstRange = (criticalEvents/TotalSum)*100;

						int secondRange =firstRange+((majorEvents/TotalSum)*100);

						int thirdRange = secondRange+((minorEvents/TotalSum)*100);

						StringBuffer xmlData=new StringBuffer("<chart");

						if(chartAttributes!=null && chartAttributes.size()>0)
						{
							Iterator itr=chartAttributes.iterator();
							while(itr.hasNext())
							{
								xmlData.append(" ");
								xmlData.append((String)itr.next());
							}
						}

						String cricLabel="";
						String majLabel="";
						String minLabel="";
						
						if(criticalEvents!=0)
							cricLabel=criticalEvents.toString();
						if(majorEvents!=0)
							majLabel=majorEvents.toString();
						if(minorEvents!=0)
							minLabel=minorEvents.toString();

						xmlData.append(">");
						xmlData.append("<colorRange>");
						xmlData.append("<color minValue='"+0+"' maxValue='"+firstRange+"' code='d70f0f' label='"+cricLabel +"' /> ");
						xmlData.append("<color minValue='"+firstRange+"' maxValue='"+secondRange+"' code='d8b326' label='"+majLabel +"' /> ");
						xmlData.append("<color minValue='"+secondRange+"' maxValue='"+thirdRange+"' code='90357E' label='"+minLabel +"' /> ");
						xmlData.append("</colorRange>");
						xmlData.append("<styles>");
						xmlData.append("<definition>");
						xmlData.append("<style name='valueFont' type='Font' bgColor='333333' size='10' color='FFFFFF' /> ");
						xmlData.append("</definition>");
						xmlData.append("<application>");
						xmlData.append("<apply toObject='VALUE' styles='valueFont' /> ");
						xmlData.append("</application>");
						xmlData.append("</styles>");
						xmlData.append("</chart>");
						String linearGaugeXML= xmlData.toString();
						
						if(HighChartTimeline.isFusion())
							ChartObject.put("XMLData",linearGaugeXML);
						else
							ChartObject.put("XMLData",historyXMLData);
						ChartObject.put("chartFile","HLinearGauge.swf");
						
						
						HistoryEvents.put("totalEvents" , mappingInfo.getTextDescription("monitor.dashboard.Total Events"));
						HistoryEvents.put("totalEventsValue" , (Integer)events.get("Count"));

						HistoryEvents.put("avgDur" , mappingInfo.getTextDescription("monitor.dashboard.Avg Duration"));
						HistoryEvents.put("avgDurValue" , (String)events.get("AvgDuration") );

						HistoryEvents.put("maxDur" , mappingInfo.getTextDescription("monitor.dashboard.Max Duration"));
						
						HistoryEvents.put("maxDurValue" , (String)events.get("MaxDuration") );
						

						json.put("chart",ChartObject);

				}
				else
				{
					HistoryEvents.put("error",mappingInfo.getTextDescription("monitor.dashboard.No events found")+"!");

				}
				json.put("historyEvents" , HistoryEvents);
			}
			else
			{
				String mGraph="";
				String sGraph="";
				String tGraph="";
				String Analysis="";
				if(graphType.equalsIgnoreCase("measureGraph"))
					mGraph="selected";
	
				if(graphType.equalsIgnoreCase("summaryGraph"))
					sGraph="selected";
	
				if(graphType.equalsIgnoreCase("trendGraph"))
					tGraph="selected";

				String url="";
				if(from_page!=null && from_page.trim().length()>0 && 
					 from_page.equalsIgnoreCase("VMTabView"))
				{
					selected_info_url=(selected_info_url==null)?"":selected_info_url;
					url="egSummaryViewVMTab.jsp?hostName="+compName+"&compType="+compType+"&subsystem="+subsystem+"&info="+EgURLEncoder.encode(selected_info_url,"UTF-8")+"&from_page="+from_page;
				}
				
				
%>
		        <jsp:include page="<%=url%>"/>
<%
				if(request.getAttribute("ExtraGraphs")!="undefined" && request.getAttribute("ExtraGraphs")!="null" && request.getAttribute("ExtraGraphs")!=""){
						json.put("OtherData",request.getAttribute("ExtraGraphs"));
				     request.removeAttribute("ExtraGraphs");
				    }



			}
		}
		//JSONObject LowerPanel=new JSONObject();
		if(subsystem!=null  && subsystem.equalsIgnoreCase("overview"))
		{
			
			JSONObject piegraph=new JSONObject();
			piegraph.put("type","piegraph");
			double defaultPieGraphWidth=190; // default pie graph width for calculation
			double defaultPieGraphHeight=115;  // default pie graph height for calculation
			double defaultPieRadius=40;  // default pie graph radius for calculation

			double pieGraphWidth=190;
			double pieGraphHeight=115;

			String pieRadius="40"; //default radius for 190 width

			double pieGraphWidthTo1024PxInPercent=defaultPieGraphWidth/1024;
			pieGraphWidth=screenWidthInDouble*pieGraphWidthTo1024PxInPercent;
			pieGraphWidth=MathUtils.round(pieGraphWidth,0);

			double pieGraphHeightToDefaultWidthInPercent=defaultPieGraphHeight/defaultPieGraphWidth;

			pieGraphHeight=pieGraphWidth*pieGraphHeightToDefaultWidthInPercent;
			pieGraphHeight=MathUtils.round(pieGraphHeight,0);

			double pieRadiusToDefaultWidthInPercent=defaultPieRadius/defaultPieGraphWidth;
			double pieRadiusInDouble=pieGraphWidth*pieRadiusToDefaultWidthInPercent;
			pieRadius=erutils.round(pieRadiusInDouble,0);
			piegraph.put("title",mappingInfo.getTextDescription("monitor.dashboard.Current System Status"));
			Double criticalMeasurePct=(Double)currentStatus.get("critical");
			Double majorMeasurePct=(Double)currentStatus.get("major");
			Double minorMeasurePct=(Double)currentStatus.get("minor");
			Double unknownMeasurePct=(Double)currentStatus.get("unknown");
			Double goodMeasurePct=(Double)currentStatus.get("good");
			boolean isCurrentStatus=true;
			if((criticalMeasurePct.isNaN() && majorMeasurePct.isNaN() && minorMeasurePct.isNaN() && unknownMeasurePct.isNaN() && goodMeasurePct.isNaN()) ||(criticalMeasurePct.doubleValue()<=0.0 && majorMeasurePct.doubleValue()<=0.0 && minorMeasurePct.doubleValue()<=0.0 && unknownMeasurePct.doubleValue()<=0.0 && goodMeasurePct.doubleValue()<=0.0))
			{
				isCurrentStatus=false;
			}
			if(isCurrentStatus)
			{
				int count_sli=0;
				if(criticalMeasurePct.doubleValue()>0)
					count_sli++;
				if(majorMeasurePct.doubleValue()>0)
					count_sli++;
				if(minorMeasurePct.doubleValue()>0)
					count_sli++;
				if(unknownMeasurePct.doubleValue()>0)
					count_sli++;
				if(goodMeasurePct.doubleValue()>0)
					count_sli++;

				//for fusionchart
				String xmlData="";
				EgInsideViewChartUtil fusionChart=new EgInsideViewChartUtil();
				Vector healthChartAttributes=new Vector();

				StringBuffer  legends=new StringBuffer();
				StringBuffer  samples=new StringBuffer();
				StringBuffer  colors=new StringBuffer();
				boolean showCurrentStatusLink=true;
				if(criticalMeasurePct.doubleValue()==0.00 && majorMeasurePct.doubleValue()==0.00 && minorMeasurePct.doubleValue()==0.00)
				{
					showCurrentStatusLink=false;
				}
				if(from_page!=null && from_page.trim().length()>0 && 
					 from_page.equalsIgnoreCase("VMTabView"))
				{
					//---------------fusionchart added by arivu-------------//
					healthChartAttributes.add("palette='1'");
					healthChartAttributes.add("decimals='2'");
					healthChartAttributes.add("enableRotation='0'");
					//healthChartAttributes.add("bgColor='99CCFF,FFFFFF'");
					healthChartAttributes.add("bgColor='FFFFFF'");
					healthChartAttributes.add("bgAlpha='0,0'");
					healthChartAttributes.add("bgRatio='0,100'");
					healthChartAttributes.add("bgAngle='360'");
					healthChartAttributes.add("showBorder='0'");
					healthChartAttributes.add("startingAngle='70'");
					if(count_sli==1)
					{
						healthChartAttributes.add(" baseFontColor  ='FFFFFF'");
						healthChartAttributes.add(" toolTipBgColor ='000000'");
					}
					else
					{
						healthChartAttributes.add(" baseFontColor  ='545454'");
					}
					//healthChartAttributes.add("baseFontColor ='545454'");--this one add in java for check the condition
					healthChartAttributes.add("exportEnabled='1'");
					healthChartAttributes.add("exportAction='download'");
					healthChartAttributes.add("exportAtClient='0'");
					healthChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
					healthChartAttributes.add("chartLeftMargin ='0'");
					healthChartAttributes.add("chartTopMargin ='0'");
					healthChartAttributes.add("chartBottomMargin ='0'");
					healthChartAttributes.add("chartRightMargin ='0'");
					healthChartAttributes.add("showToolTipShadow ='1'");
					healthChartAttributes.add("pieSliceDepth='7'");
					healthChartAttributes.add("numberSuffix='%25'");
					healthChartAttributes.add("showToolTipShadow ='1'");
					healthChartAttributes.add("showPercentageValues='1'");
					healthChartAttributes.add("showPercentInToolTip='1'");
					healthChartAttributes.add("pieOuterFaceAlpha  ='75'");
					healthChartAttributes.add("pieYScale  ='60'");
					healthChartAttributes.add("smartLineColor  ='000000'");
					healthChartAttributes.add("smartLabelClearance  ='10'");
					healthChartAttributes.add("captionPadding  ='0'");
					healthChartAttributes.add("pieRadius='"+pieRadius+"'");
					healthChartAttributes.add("bgSWFAlpha  ='0'");
					healthChartAttributes.add("enableSmartLabels='1'");
					healthChartAttributes.add("showAboutMenuItem='1' aboutMenuItemLabel='About eG Innovations' aboutMenuItemLink='n-http://www.eginnovations.com'");
					xmlData=fusionChart.getXMLtoHealth(compName,compType,"System",healthChartAttributes,currentStatus);
				}
				if(xmlData!=null && xmlData.trim().length()>0)
				{
					if(showCurrentStatusLink)
					{
						piegraph.put("dataXML",xmlData);

						piegraph.put("chartInx","Pie3DContainer");
						piegraph.put("divId","Pie3DContainer");
						piegraph.put("fcId","myPie3DChartId");
						piegraph.put("movie","/final/FusionCharts/swf/Pie3D.swf");

						piegraph.put("GraphWidth",pieGraphWidth);
						piegraph.put("GraphHeight",pieGraphHeight);
						piegraph.put("GraphFile","Pie3D.swf");

					}
					else
					{
						piegraph.put("dataXML",xmlData);
						piegraph.put("GraphWidth",pieGraphWidth);
						piegraph.put("GraphHeight",pieGraphHeight);
						piegraph.put("GraphFile","Pie3D.swf");
						piegraph.put("chartInx","Pie3DContainer");
						piegraph.put("divId","Pie3DContainer");
						piegraph.put("fcId","myPie3DChartId");
						piegraph.put("movie","/final/FusionCharts/swf/Pie3D.swf");
					
					}

				}
				else
				{
					piegraph.put("errorMsg",mappingInfo.getTextDescription("monitor.summary.No measures available"));
				}
			}
			else
			{
				piegraph.put("errorMsg",mappingInfo.getTextDescription("monitor.summary.No measures available"));
			}
			LowerPanel.put("PieGraph",piegraph);
	String isThresholdNeed=iniObj.getValue("Dashboard_Settings","ApplyThreshold");
	String DialChartNeed=iniObj2.getValue("Dashboard_Settings","UseDial");
	if(DialChartNeed==null || DialChartNeed.equalsIgnoreCase("Yes"))
		DialChartNeed="Yes";
	if(tab!=null && tab.equalsIgnoreCase("system"))
		tab = "System";
	else if(tab!=null && tab.equalsIgnoreCase("network"))
		tab = "Network";

	String overviewDialGraphs=iniObj.getValue(subject,tab+"_Overview_DialGraphs");
	Vector dialGraphtests=egDashboard.getTokensAsVector(overviewDialGraphs,",");
	int dialChartCount=0;
	ArrayList dialmeasuresNAList = new ArrayList();
	JSONArray dialchartarray=new JSONArray();
	if(dialGraphtests!=null && dialGraphtests.size()>0)
	{
		//sarav changes for dialchart
		if(dialGraphtests.size()>0)
		{
			dialGraphWidth=screenWidthInDouble*dialGraphWidthTo1024PxInPercent;
			dialGraphWidth=MathUtils.round(dialGraphWidth,0);

			dialGraphHeight=dialGraphWidth*dialGraphHeightToDefaultWidthInPercent;
			dialGraphHeight=MathUtils.round(dialGraphHeight,0);

			double gauageOutRadiusToDefaultWidthInPercent=defaultGauageOuterRadius/defaultDialGraphWidth;
			double gauageOuterRadiusInDouble=dialGraphWidth*gauageOutRadiusToDefaultWidthInPercent;
			gauageOuterRadius=erutils.round(gauageOuterRadiusInDouble,0);

			double gauageXPosToDefaultWidthInPercent=defaultGaugeXPos/defaultDialGraphWidth;
			double gauageYPosToDefaultHeightInPercent=defaultGaugeYPos/defaultDialGraphHeight;

			double gaugeXPosInDouble=dialGraphWidth*gauageXPosToDefaultWidthInPercent;
			gaugeXPos=erutils.round(gaugeXPosInDouble,0);
			double gaugeYPosInDouble=dialGraphHeight*gauageYPosToDefaultHeightInPercent;
			gaugeYPos=erutils.round(gaugeYPosInDouble,0);
		}

		double defaultLedGraphWidth=140;  //140 default led graph width for calculation
		double defaultLedGraphHeight=70;  //115 default led graph height for calculation
		double ledGraphWidth=140; //140 
		double ledGraphHeight=70;//115

		double ledGraphWidthTo1024PxInPercent=defaultLedGraphWidth/1024;
		double ledGraphHeightToDefaultWidthInPercent=defaultLedGraphHeight/defaultLedGraphWidth;

		double defaultLedGap=1; // default led graph gap for calculation
		double defaultLedSize=1; // default led graph size for calculation

		String ledGap="1";
		String ledSize="1";
		ledGraphWidth=screenWidthInDouble*ledGraphWidthTo1024PxInPercent;
		ledGraphWidth=MathUtils.round(ledGraphWidth,0);

		ledGraphHeight=dialGraphWidth*ledGraphHeightToDefaultWidthInPercent;
		ledGraphHeight=MathUtils.round(ledGraphHeight,0);

		double ledGapToDefaultWidthInPercent=defaultLedGap/defaultLedGraphWidth;
		double ledGapInDouble=ledGraphWidth*ledGapToDefaultWidthInPercent;
		ledGap=erutils.round(ledGapInDouble,0);

		double ledSizeToDefaultWidthInPercent=defaultLedSize/defaultLedGraphWidth;
		double ledSizeInDouble=ledGraphWidth*ledSizeToDefaultWidthInPercent;
		ledSize=erutils.round(ledSizeInDouble,0);
		String chartLeftMargin="42";
		String chartRightMargin="25";

		for(int i= 0; i < dialGraphtests.size();i++ )
		{
			JSONObject dialchart=new JSONObject();
			String testmeasure=(String)dialGraphtests.get(i);
			test=testmeasure.substring(0,testmeasure.indexOf(":"));
			measure=testmeasure.substring(testmeasure.indexOf(":")+1);

			if(enabledTests!=null && !enabledTests.contains(test))
				continue;

			//mHost=(String)allMsmtHosts.get(test);

			String measureValue="";
			String measureForDB=dbInfo.getColumnForMeasure(test,measure);

			String dial_measureMapping=iniObj.getValue("Dashboard_Dial_mapping",testmeasure);


			if(dial_measureMapping==null || dial_measureMapping.trim().equals(""))
				dial_measureMapping=mappingInfo.getMeasureDescription(test,measure);

			String tooltip=dial_measureMapping;

			if(dial_measureMapping!=null && !dial_measureMapping.equals("") && dial_measureMapping.length()>24)
				dial_measureMapping=dial_measureMapping.substring(0,21)+"...";


			//mHost=(String)allMsmtHosts.get(test);

			String units=tablesInfo.getUnitForMeasure(test,measure);
			if((units!=null) && !(units.equalsIgnoreCase("percent") || units.equalsIgnoreCase("percentage") || units.equals("%")))
				continue;
			if((units!=null) && (units.equalsIgnoreCase("percent") || units.equalsIgnoreCase("percentage")))
				units="%";

			Vector testInfos=dashboardDAO.getDescriptorsForTest(compName,compType,test,tab);
			String oneMsmtTime=dashboardDAO.lastMeasurementTimeForTest(compName,compType,test,tab);

			agentsForDial = egExternalInfo.getAgentsFor(test,compType,hostName);
			if(agentsForDial!=null && agentsForDial.size()>0)
				mHost=(String)agentsForDial.get(0);
			else
				mHost=hostName;

			if(mHost==null)
				mHost="";
			boolean isFullView=false;
			Vector infos=(Vector)allTestInfos.get(test);
			Vector infosForCutOffFactor = new Vector();
			if(egDashboard.isTestHasCutOffFactor(test))
			{
				if(infos!=null && !infos.isEmpty())
				{
					for(int d=0;d<infos.size();d++)
					{
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,test,mHost,(String)infos.get(d));
						if(!isTestExceededCutOffFactor)
						{
							infosForCutOffFactor.add(infos.get(d));
						}
					}
				}
				if(infosForCutOffFactor!=null && !infosForCutOffFactor.isEmpty())
				{
					infos=infosForCutOffFactor;
				}
			}
			if(infos!=null && !infos.isEmpty() && infos.size()>1)
			{
				isFullView=true;
			}
			info=fusChart.getInfoForDial(test,measure,compType,hostName,portNo,mHost,"NULL",sid,isThresholdNeed,selected_info);
			if(info!=null && info.indexOf("+")!=-1)
				info=info.substring(info.indexOf("+")+1);

			info=com.egurkha.util.StringUtils.replace(info, "+", "|plus|");

			Vector dialChartAttributes=new Vector();
			dialChartAttributes.add("clickURL='javascript:dialOnclickforInsideView(&apos;dialUrlSVMTab"+dialChartCount+"&apos;)'");  // To avoid drilldown url problem in Doublebyte. We have to create one HIDDEN element and the url to be stored there
			dialChartAttributes.add("fillAngle='60'");
			dialChartAttributes.add("majorTMNumber='6'");
			dialChartAttributes.add("majorTMHeight='8'");
			dialChartAttributes.add("majorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMHeight='4'");
			dialChartAttributes.add("minorTMNumber='6'");
			dialChartAttributes.add("majorTMThickness='1'");
			dialChartAttributes.add("markerRadius='30'");
			dialChartAttributes.add("showGaugeBorder='0'");
			dialChartAttributes.add("gaugeOuterRadius='"+gauageOuterRadius+"'");
			dialChartAttributes.add("gaugeOriginX='"+gaugeXPos+"'");
			dialChartAttributes.add("gaugeOriginY='"+gaugeYPos+"'");
			dialChartAttributes.add("gaugeInnerRadius='0'");
			dialChartAttributes.add("formatNumberScale='0'");
			dialChartAttributes.add("displayValueDistance='0'");
			dialChartAttributes.add("decimalPrecision='0'");
			dialChartAttributes.add("ledGap='"+ledGap+"'");
			dialChartAttributes.add("ledSize='"+ledSize+"'");
			dialChartAttributes.add("tickMarkDecimalPrecision='2'");
			dialChartAttributes.add("tickValueDistance='14'");
			dialChartAttributes.add("pivotRadius='6'");
			dialChartAttributes.add("showPivotBorder='1'");
			dialChartAttributes.add("pivotBorderColor='000000'");
			dialChartAttributes.add("pivotBorderThickness='5'");
			dialChartAttributes.add("pivotFillMix='FFFFFF,000000'");
			dialChartAttributes.add("paletteThemeColor='ffffff'");
			dialChartAttributes.add("pivotFillType='linear'");
			dialChartAttributes.add("showToolTip='1'");
			dialChartAttributes.add("chartLeftMargin='0'");
			dialChartAttributes.add("chartRightMargin='0'");
			dialChartAttributes.add("chartBottomMargin='0'");
			dialChartAttributes.add("chartTopMargin='0'");
			dialChartAttributes.add("baseFontColor='000000'");
			dialChartAttributes.add("adjustTM='0'");
			dialChartAttributes.add("bgColor='FFFFFF'");
			
			dialChartAttributes.add("borderAlpha='0'");
			dialChartAttributes.add("bgAlpha='_alpha'");

			dialChartAttributes.add("showToolTipShadow='1'");
			dialChartAttributes.add("toolTipBgColor='ffffff'");
			dialChartAttributes.add("toolTipBorderColor='555555'");
			dialChartAttributes.add("exportEnabled='1'");
			dialChartAttributes.add("exportAction='download'");
			dialChartAttributes.add("exportAtClient='0'");
			dialChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			String dialXMLData="";
			if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("Yes"))
			{
				dialXMLData=fusChart.getXMLDataForDial(test,measure,compType,hostName,portNo,mHost,"NULL",sid,isThresholdNeed,dialChartAttributes,"black",true,selected_info,dialGraphWidth,dialGraphHeight);
			}
			else if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("No"))
			{
				
				Vector jvmChartAttributes=new Vector();
				jvmChartAttributes.add("clickURL='javascript:dialOnclick(&apos;dialUrlSVMTab"+dialChartCount+"&apos;)'");
				jvmChartAttributes.add("upperLimit='100'");
				jvmChartAttributes.add("bgColor='FFFFFF'");
				jvmChartAttributes.add("bgAlpha='0,0'");
				jvmChartAttributes.add("showBorder='0'");
				jvmChartAttributes.add("adjustTM='0'");
				jvmChartAttributes.add("lowerLimit='0'");
				jvmChartAttributes.add("decimals='2'");
				jvmChartAttributes.add("showValue='0'");
				jvmChartAttributes.add("majorTMNumber='5'");
				//jvmChartAttributes.add("baseFontSize='8'");
				jvmChartAttributes.add("majorTMColor='000000'");
				jvmChartAttributes.add("majorTMHeight='5'");
				jvmChartAttributes.add("minorTMNumber='2'");
				jvmChartAttributes.add("minorTMColor='000000'");
				jvmChartAttributes.add("minorTMHeight='2'");
				jvmChartAttributes.add("majorTMThickness='1'");
				jvmChartAttributes.add("decimalPrecision='0'");
				jvmChartAttributes.add("ledGap='"+ledGap+"'");
				jvmChartAttributes.add("ledSize='"+ledSize+"'");
				jvmChartAttributes.add("tickValueDistance='2'");
				jvmChartAttributes.add("tickMarkDistance='1'");
				jvmChartAttributes.add("tickValueStep='1'");
				jvmChartAttributes.add("tickValueDecimals='8'");
				jvmChartAttributes.add("chartLeftMargin='"+chartLeftMargin+"'");
				jvmChartAttributes.add("chartRightMargin='"+chartRightMargin+"'");
				jvmChartAttributes.add("chartTopMargin='21'");
				jvmChartAttributes.add("chartBottomMargin='20'");
				jvmChartAttributes.add("baseFontSize ='9'");
				jvmChartAttributes.add("showToolTip='1'");
				jvmChartAttributes.add("baseFontColor  ='000000'");
				jvmChartAttributes.add("annRenderDelay='1.7'");
				jvmChartAttributes.add("exportEnabled='1'");
				jvmChartAttributes.add("exportAction='download'");
				jvmChartAttributes.add("exportAtClient='0'");
				jvmChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
				
				dialXMLData=fusChart.getXMLDataForDial(test,measure,compType,hostName,portNo,mHost,"NULL",sid,isThresholdNeed,jvmChartAttributes,"black",true,selected_info,dialGraphWidth,dialGraphHeight);
			}

			if(dialXMLData !=null && !dialXMLData.equals(""))
			{
				String layerName=dashboardDAO.getLayerForTest(compType,test,measure);
				
				String compTypeForAlarm=compType;
				if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
					compTypeForAlarm="Host_system";

				String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,test+"-"+info,measure);

				String layerPageUrl=response.encodeURL("/final/monitor/egMonDashboard.jsp?")+"qctr=2&from=list&tab=layers&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&layer="+EgURLEncoder.encode(layerName,"UTF-8")+"&site=NULL&test="+EgURLEncoder.encode(test,"UTF-8")+"-"+EgURLEncoder.encode(info,"UTF-8")+"&tstate="+measureState+"&msmt_host=&toDashBoardLayer=true&fromalarmWindow=true&gauageClick=true";

				String moreDescriptorUrl=response.encodeURL("/final/monitor/EgMoreInfosDial.jsp?")+"hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+EgURLEncoder.encode(test,"UTF-8")+"&measure="+EgURLEncoder.encode(measure,"UTF-8")+"&msmtHost="+mHost+"&tab="+tab;

				isFullView = false;
				double dialGraphHeightDiv=dialGraphHeight+25;
				double dialGraphWidthDiv=dialGraphWidth+15;
				dialchart.put("title",dial_measureMapping+"("+units+")");
				if(isFullView)
				{

				}
						JSONObject dialJson = new JSONObject();
						
						if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("Yes"))
						{
							if(HighChartTimeline.isFusion())
							{
								dialchart.put("type","dialchart");
								dialchart.put("dataXML",dialXMLData);
								dialchart.put("GraphFile","AngularGauge.swf");
								dialchart.put("ChartWidth",dialGraphWidth);
								dialchart.put("ChartHeight",dialGraphHeight);
								dialchart.put("layerPageUrl",layerPageUrl);

							dialchart.put("chartInx","dialUrlSVMTab"+dialChartCount);
							dialchart.put("divId","AngularGaugeContainerSystem"+i);
							dialchart.put("fcId","myAngularGaugeChartIdSystem"+i);
							dialchart.put("movie","/final/FusionCharts/swf/AngularGauge.swf");

								dialchartarray.add(dialchart);
							}
							else
							{
								JSONObject rootPropObj = new JSONObject();
								JSONObject propObj = new JSONObject();
								JSONObject gaugeProp = new JSONObject();
								JSONObject gaugeArray = new JSONObject();
								JSONArray stopsArr = new JSONArray();
								JSONArray stopsObj = new JSONArray();
								if( dialXMLData != null )
								{
									JSONObject splitData = new JSONObject();
									// value,test,descriptor,color
									ArrayList gaugePropList =  com.egurkha.util.StringUtils.egTokenizer( dialXMLData, ",",true,false,true);
									if( gaugePropList != null && gaugePropList.size() > 0 )
									{
										JSONArray dataArray = new JSONArray();
										String dataVal = (String) gaugePropList.get(0);
										String gaugeColor = "#35c8c2";
										Double dd = new Double(dataVal);
										dataArray.add(dd);
										splitData.put("name",(String) gaugePropList.get(2) );
										splitData.put("color",(String) gaugePropList.get(3) );
										splitData.put("subTitle",(String) gaugePropList.get(2) );
										splitData.put("bgColor","transparent" );
										splitData.put("fontColor","#636363" );
										splitData.put("fontFamily","Lucida Grande" );
										stopsArr.add(dd);
										stopsArr.add(gaugeColor);
										stopsObj.add(stopsArr);
										splitData.put("data",dataArray );
										propObj.put("guageData",splitData);
										propObj.put("stopsArr",stopsObj);
										propObj.put("layerModelUrl","dialUrlSVMTab"+dialChartCount);
										propObj.put("layerModelUrlId","dialUrlSVMTab"+dialChartCount);
										propObj.put("goToPage","layerModel");
										propObj.put("goToPage","layerModel");
										propObj.put("unit","%");
										propObj.put("title",(String) gaugePropList.get(1) );
										propObj.put("subTitle",(String) gaugePropList.get(2) );
									}
								}
								
								dialJson.put("chartName","AngularGauge");
								dialJson.put("chartXML",propObj);
								dialJson.put("layerPageUrl",layerPageUrl);
								dialJson.put("chartInx","dialUrlSVMTab"+dialChartCount);
								dialJson.put("chartWidth",ledGraphWidth);
								dialJson.put("chartHeight",ledGraphHeight);

								dialchartarray.add(dialJson);
								
							}
						}
						else if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("No"))
						{
							if(HighChartTimeline.isFusion())
							{
								dialchart.put("type","dialchart");
								dialchart.put("dataXML",dialXMLData);
								dialchart.put("GraphFile","VLED.swf");
								dialchart.put("ChartWidth",ledGraphWidth);
								dialchart.put("ChartHeight",ledGraphHeight);
								dialchart.put("layerPageUrl",layerPageUrl);

								dialchart.put("chartInx","dialUrlSVMTab"+dialChartCount);
								dialchart.put("divId","VLEDContainerSystem"+i);
								dialchart.put("fcId","myVLEDChartIdSystem"+i);
								dialchart.put("movie","/final/FusionCharts/swf/VLED.swf");

								dialchartarray.add(dialchart);
							}
							else
							{
								JSONObject rootPropObj = new JSONObject();
								JSONObject propObj = new JSONObject();
								JSONObject gaugeProp = new JSONObject();
								JSONObject gaugeArray = new JSONObject();
								JSONArray stopsArr = new JSONArray();
								JSONArray stopsObj = new JSONArray();
								if( dialXMLData != null )
								{
									JSONObject splitData = new JSONObject();
									// value,test,descriptor,color
									ArrayList gaugePropList =  com.egurkha.util.StringUtils.egTokenizer( dialXMLData, ",",true,false,true);
									if( gaugePropList != null && gaugePropList.size() > 0 )
									{
										JSONArray dataArray = new JSONArray();
										String dataVal = (String) gaugePropList.get(0);
										String gaugeColor = "#35c8c2";
										Double dd = new Double(dataVal);
										dataArray.add(dd);
										splitData.put("name",(String) gaugePropList.get(2) );
										splitData.put("color",(String) gaugePropList.get(3) );
										splitData.put("subTitle",(String) gaugePropList.get(2) );
										splitData.put("bgColor","transparent" );
										splitData.put("fontColor","#636363" );
										splitData.put("fontFamily","Lucida Grande" );
										splitData.put("data",dataArray );
										stopsArr.add(dd);
										stopsArr.add(gaugeColor);
										stopsObj.add(stopsArr);
										propObj.put("guageData",splitData);
										propObj.put("stopsArr",stopsObj);
										propObj.put("layerModelUrl","dialUrlS"+dialChartCount);
										propObj.put("layerModelUrlId","dialUrlS"+dialChartCount);
										propObj.put("goToPage","layerModel");
										propObj.put("goToPage","layerModel");
										propObj.put("unit","%");
										propObj.put("title",(String) gaugePropList.get(1) );
										propObj.put("subTitle",(String) gaugePropList.get(2) );
									}
								}
								//rootPropObj.put("rootJson ",propObj);
								dialJson.put("chartName","VLED");
								dialJson.put("chartXML",propObj);
								dialJson.put("layerPageUrl",layerPageUrl);
								dialJson.put("chartInx","dialUrlSVMTab"+dialChartCount);
								dialJson.put("chartWidth",ledGraphWidth);
								dialJson.put("chartHeight",ledGraphHeight);
								dialchartarray.add(dialJson);
							}
						}
						HiddenFields.put("dialChartCount",layerPageUrl);
				dialChartCount++;
				
			}
			else
			{
					dialmeasuresNAList.add(dial_measureMapping+"#"+units+"$"+tooltip);
			}
		}
		
	}

	if(dialChartCount%5==4)
	{

	}
	
	for (int na=1;na < dialmeasuresNAList.size()+1;na++)
	{
		JSONObject temp=new JSONObject();
		String NAlistdata = (String)dialmeasuresNAList.get(na-1);
		String dial_measureMapping = NAlistdata.substring(0,NAlistdata.indexOf("#"));
		String units = NAlistdata.substring(NAlistdata.indexOf("#")+1,NAlistdata.indexOf("$"));
		String tooltip = NAlistdata.substring(NAlistdata.indexOf("$")+1);
		if(((4-(dialChartCount%4)==na-1)&&dialChartCount<4)||((dialChartNoMeasuresCount-tempDialGraphCount)%5==0&&na>=2))
		{
			isTRNeedInDialChart=false;
			tempDialGraphCount=na-1;
		}

		int temCount=(++dialChartCount)%5;
		if(dialChartCount>5&&(temCount!=0)&&(5-(dialChartCount%5)==na-1))
		{
			isTRNeedInDialChart=false;
			tempDialGraphCount=na-1;

		}

		dialChartCount--;
		dialChartNoMeasuresCount++;
		if(((4-(dialChartCount%4)==na)&&dialChartCount<4)||((dialChartNoMeasuresCount-tempDialGraphCount)%5==0))
		{
			isTRNeedInDialChart=true;

		}
		int tempCount=(++dialChartCount)%5;
		if(dialChartCount>5&&(tempCount!=0)&&(5-(dialChartCount%5)==na))
		{
			isTRNeedInDialChart=true;
		}
		dialChartCount--;
		temp.put("title",dial_measureMapping+"("+units+")");
		temp.put("errorMsg",mappingInfo.getTextDescription("monitor.dashboard.No Measures Available"));
		dialchartarray.add(temp);
	}
	LowerPanel.put("DialChart",dialchartarray);
	if(isTRNeedInDialChart)
	{

	}
			JSONObject LayerHealth=new JSONObject();
			if(healthFlag!=null && healthFlag.equalsIgnoreCase("Yes"))
			{
				String layerHealthXML="";
				EgInsideViewChartUtil fusionChart=new EgInsideViewChartUtil();
				Vector chartAttributes=new Vector();
				if(from_page!=null && from_page.trim().length()>0 && 
					 from_page.equalsIgnoreCase("VMTabView"))
				{
					//------------------fusionchart added by arivu-----------------//
					chartAttributes.add("showLegend='0'");
					chartAttributes.add("palette='2'");
					//chartAttributes.add("numberSuffix='%25'");
					chartAttributes.add("useRoundEdges='1'");
					chartAttributes.add("showValues='0'");
					chartAttributes.add("bgAlpha='0,0'");
					//chartAttributes.add("bgColor='E6E6E6,E6E6E6'");
					chartAttributes.add("bgColor='FFFFFF'");
					chartAttributes.add("exportEnabled='1'");
					chartAttributes.add("exportAction='download'");
					chartAttributes.add("exportAtClient='0'");
					chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
					chartAttributes.add("showToolTipShadow='1' ");
					chartAttributes.add("canvasLeftMargin='0' ");
					chartAttributes.add("canvasRightMargin='5' ");
					chartAttributes.add("canvasTopMargin='5' ");
					chartAttributes.add("canvasBottomMargin='5' ");
					chartAttributes.add("baseFontColor ='000000' ");
					chartAttributes.add("baseFontSize ='9' ");
					chartAttributes.add("yAxisMaxValue='100.01'");
					//chartAttributes.add("baseFont  ='verdana'");
					chartAttributes.add("showBorder  ='0' ");
					chartAttributes.add("showPlotBorder  ='0' ");
					chartAttributes.add(" plotSpacePercent='40' ");
					chartAttributes.add(" adjustDiv='0'");
					chartAttributes.add("yAxisValueDecimals='0'");
					//chartAttributes.add("showLimits='1'");
					chartAttributes.add("showAboutMenuItem='1' aboutMenuItemLabel='About eG Innovations' aboutMenuItemLink='n-http://www.eginnovations.com'");
					//-----------------------------------------------------------//
					layerHealthXML=fusionChart.getXMLForLayerHealth(compName,compType,tab,false,chartAttributes,selected_info,Layer_name);
				}
				
				LayerHealth.put("title",mappingInfo.getTextDescription("monitor.dashboard.Current Layerwise Health"));
				if(layerHealthXML!=null && layerHealthXML.trim().length()>0)
				{
					LayerHealth.put("dataXML",layerHealthXML);
					LayerHealth.put("GraphFile","StackedBar2D.swf");
					LayerHealth.put("ChartWidth",HealthGraphWidth);
					LayerHealth.put("ChartHeight",HealthGraphHeight);
				}
				else
				{
					LayerHealth.put("errorMsg",mappingInfo.getTextDescription("monitor.summary.No measures available"));
				}
			}
			LowerPanel.put("Health",LayerHealth);
			
			keyobj.put("type","grid");
			JSONArray keyheaders=new JSONArray();
			boolean isPerformanceIndicatorsAvailable=egDashboard.getPerformanceIndicatorsAvailable();
			if(!hasConfig)
			{
				keyobj.put("title",mappingInfo.getTextDescription("monitor.dashboard.Key Performance Indicators"));
				if(isPerformanceIndicatorsAvailable)
				{
					JSONObject temp1=new JSONObject(); 		
					JSONObject temp2=new JSONObject();
					JSONObject temp3=new JSONObject();
					JSONObject temp4=new JSONObject();
					temp1.put("name",mappingInfo.getTextDescription("monitor.common.Measure"));
					temp2.put("name",mappingInfo.getTextDescription("monitor.common.Min"));
					temp3.put("name",mappingInfo.getTextDescription("monitor.common.Max"));
					temp4.put("name",mappingInfo.getTextDescription("monitor.common.Avg"));
					keyheaders.add(temp1);
					keyheaders.add(temp2);
					keyheaders.add(temp3);
					keyheaders.add(temp4);
				}
				keyobj.put("keyheaders",keyheaders);
			}

			Vector states=new Vector();
			states.add("HIGH");
			states.add("INTERMEDIATE");
			states.add("LOW");
			states.add("UNKNOWN");
			states.add("GOOD");

			if(performanceIndicators!=null && performanceIndicators.size()>0 && isPerformanceIndicatorsAvailable)
			{
				JSONArray griditems=new JSONArray();
				Iterator ptr=states.iterator();
				while(ptr.hasNext())
				{
					String  keyState = (String)ptr.next();
					Vector indicators=(Vector)performanceIndicators.get(keyState);
					if(indicators!=null && indicators.size()>0)
					{
						for(int  i=0;i<indicators.size();i++)
						{
							JSONObject temp1=new JSONObject(); 		
							String perfIndicatorValue=(String)indicators.get(i);
							String tstmeasure ="";
							String desc="";
							String  indicURL="";

							if(perfIndicatorValue.indexOf("{")!=-1)
							{
								tstmeasure = perfIndicatorValue.substring(0,perfIndicatorValue.indexOf("{"));
								desc = perfIndicatorValue.substring(perfIndicatorValue.indexOf("{")+1,perfIndicatorValue.indexOf("}"));
							}
							else if(perfIndicatorValue.indexOf("@")!=-1)
							{
								tstmeasure = perfIndicatorValue.substring(0,perfIndicatorValue.indexOf("@"));
							}

							if(perfIndicatorValue.indexOf("@")!=-1)
								indicURL=perfIndicatorValue.substring(perfIndicatorValue.indexOf("@")+1,perfIndicatorValue.length());

							Vector  min_Max_Avg=(Vector)minMaxAvg.get(tstmeasure.trim());
							
							String cur_Measure = (String)currentMeasure.get(tstmeasure.trim());
							String dispMeasure=iniObj.getValue("Dashboard_measures_mapping",tstmeasure);
							String dispInfo="";

							if(desc!=null && !desc.equals("+") && !desc.equals("") && !desc.equals("Summary"))
							{
								if(desc!=null && desc.indexOf(":")>-1)
								{
									desc = desc.substring(desc.indexOf(":")+1);
								}
								dispInfo=" {"+desc+"}";
							}
							String testname="",testmeasure="";
							if(tstmeasure!=null && tstmeasure.indexOf(":")>0)
							{
								testname=tstmeasure.substring(0,tstmeasure.indexOf(":"));
								testmeasure=tstmeasure.substring(tstmeasure.indexOf(":")+1);
							}
							temp1.put("state",keyState);
							temp1.put("URL",indicURL);
							if(dispMeasure==null || dispMeasure.equals(""))
							{
								temp1.put("value0",mappingInfo.getMeasureDescription(testname,testmeasure)+"("+tablesInfo.getUnitForMeasure(testname,testmeasure)+")");
							}
							else
							{
								temp1.put("value0",mappingInfo.getMeasureDescription(testname,testmeasure)+"("+tablesInfo.getUnitForMeasure(testname,testmeasure)+")");
							}
							if(!hasConfig)
							{
								if(min_Max_Avg!=null && min_Max_Avg.size()>2)
								{
									temp1.put("value1",(String)min_Max_Avg.get(0));
									temp1.put("value2",(String)min_Max_Avg.get(1));
									temp1.put("value3",(String)min_Max_Avg.get(2));
								}
								else
								{
									temp1.put("value1",(String)min_Max_Avg.get(0));
									temp1.put("value2",(String)min_Max_Avg.get(1));
									temp1.put("value3",(String)min_Max_Avg.get(2));
								}
							}
							griditems.add(temp1);
						}
					}
					
				}
				keyobj.put("items",griditems);
			}
			else
			{
				if(!hasConfig)
				{
					keyobj.put("errorMsg",mappingInfo.getTextDescription("monitor.dashboard.No Measures available"));	
				}
			}
			if(!hasConfig)
			{
			}
		}
		if(keyobj.size()>0)
			LowerPanel.put("KeyPerf",keyobj);
		int numDDGraph=0;
		int numMeasureGraph=0;
		int totalGraph=0;
		StringTokenizer st=null;
		if(ddMeasures!=null && !ddMeasures.equals(""))
		{
			st=new StringTokenizer(ddMeasures,",");
			numDDGraph=st.countTokens();
		}
		if(sysOverviewTests!=null)
		{
			numMeasureGraph=sysOverviewTests.size();
		}
		totalGraph=numDDGraph+numMeasureGraph;
		int numColums=0;
		Vector runingTestList=new Vector();
		runingTestList=egDashboard.getRunningTest(compName,compType);

		for(int i=0;i<totalGraph;i++)
		{
			if(i<numMeasureGraph)
			{
				test=(String)sysOverviewTests.get(i);
				if(runingTestList!=null && runingTestList.size()>0 && runingTestList.contains(test))
				{
					noGraphsFound=false;
					break;
				}
			}
			else
			{
				if(subsystem!=null && subsystem.equalsIgnoreCase("Overview"))
				{
					if(st.hasMoreTokens())
					{
						String token=st.nextToken();
						String testName=token.substring(0,token.indexOf(":"));
						if(runingTestList!=null && runingTestList.size()>0 && runingTestList.contains(testName))
						{
							noGraphsFound=false;
							break;
						}
					}
				}
			}
		}

		if(subsystem!=null && !subsystem.equalsIgnoreCase("overview") && !subsystem.equalsIgnoreCase("Uptime")&& graphType.equalsIgnoreCase("measureGraph") && ddEnabled  && runingTestList!=null && runingTestList.size()>0 && runingTestList.contains(ddtest))
		{
			noGraphsFound=false;
		}
		
		if(!noGraphsFound)
		{
			
			JSONArray GraphArray=new JSONArray();
			for(int i=0;i<totalGraph;i++)
			{
				boolean showMultipleInfo=false;
				JSONObject Graph=new JSONObject();
				if(graphType !=null && graphType.equalsIgnoreCase("measureGraph"))
					showMultipleInfo=true;

				if(numColums%3==0)
				{
				}
				
				String dispInfo="";
				if(i<numMeasureGraph)
				{
					test=(String)sysOverviewTests.get(i);
					measure=(String)sysOverviewMeasure.get(i);
					if(runingTestList!=null && test!=null && runingTestList.size()>0 && !runingTestList.contains(test))
						continue;
					//Changed for Insideview Dashboard
					Vector allInfos=new Vector();
					if(from_page!=null && from_page.trim().length()>0 && 
					 from_page.equalsIgnoreCase("VMTabView"))
					{
						allInfos=measureGraph.getAllInfoForTest(compType,compName,test,selected_info);
					}
					//--end--
					if((measure!=null) && !(measure.equalsIgnoreCase("Cpu_util") ||measure.equalsIgnoreCase("System_cpu_util")))
					{
						if(allInfos!=null && allInfos.contains("+Summary"))
						{
							allInfos.clear();
							allInfos.add("+Summary");
						}
					}
					String measureForDB=dbInfo.getColumnForMeasure(test,measure);
					String msmtHost="";

					boolean portReleventForTest = false;
					boolean siteReleventForTest = false;
					boolean infoReleventForTest = false;
					
					if(test!=null)
					{
						portReleventForTest = specsInfo.isPortRelevantForTest(test);
						siteReleventForTest = specsInfo.isSiteRelevantForTest(test);
						infoReleventForTest = specsInfo.isInfoRelevantForTest(test,compType);
					}

					if(!portReleventForTest)
					{
						portNo="NULL";
					}

					String layerName="HOST";
					if(from_page!=null && from_page.trim().length()>0 && 
						 from_page.equalsIgnoreCase("VMTabView"))
					{
						layerName=Layer_name;
					}

					String Layer_name_str=tablesInfo.getLayerForTest(test);
					StringTokenizer tokenLayer=new StringTokenizer(Layer_name_str,",");
					if(tokenLayer!=null)
					{
						while(tokenLayer.hasMoreTokens())
						{
							String l_name=(String)tokenLayer.nextToken();
							if(l_name!=null)
							{
								if(tablesInfo.isMeasureInLayer(test,measure,l_name))
								{
									layerName=l_name;
									break;
								}
							}
						}
					}

					List agents=egExternalInfo.getAgentsFor(test,compType,hostName);
					if(agents!=null && agents.size()>0)
						msmtHost=(String)agents.get(0);
					else
						msmtHost=hostName;

					Vector tempInfo=new Vector();
					for(int infoCount=0;infoCount<allInfos.size();infoCount++)
					{
						String infoFormeasure=(String)allInfos.get(infoCount);
						Vector measureNames=egDashboard.getMeasurenamesFromInfo(hostName,portNo,siteName,layerName,test,infoFormeasure,msmtHost);

						if(measureNames!=null && measureNames.contains(measureForDB))
							tempInfo.add(infoFormeasure);
					}
					allInfos=tempInfo;

					if((subsystem!=null && test!=null) && (subsystem.equalsIgnoreCase("Disk") || test.equals("DiskSpaceTest") || test.equals("DiskActivityTest")) && graphType!=null && graphType.equalsIgnoreCase("measureGraph"))
						showMultipleInfo=true;

					info=measureGraph.getInfoforTest(compType,compName,test);
					if(from_page!=null && from_page.trim().length()>0 && 
						 from_page.equalsIgnoreCase("VMTabView"))
					{
						if(allInfos!=null && allInfos.size()>0)
							info=(String)allInfos.get(0);
						else info="";
					}
					if(info!=null && !info.equals("+") && !info.equals(""))
					{
						String tmpInfo=info.substring(1,info.length());
						dispInfo=tmpInfo;
					}
					
					if(subsystem!=null && !subsystem.equalsIgnoreCase("overview"))
					{
						String gTitle="";
						String dispMeasureTitle=iniObj.getValue("Dashboard_measures_mapping",test+":"+measure);

						String dateDiff="";
						if(measure!=null && measure.equalsIgnoreCase("Uptime"))
						{
							String currentValue=dashboardDAO.getCurrentMeasure(hostName,compType,portNo,com.egurkha.util.StringUtils.replace(info,"|plus|","+"),test,measureForDB,msmtHost);

							if(currentValue==null || currentValue.trim().equals(""))
								currentValue="0";
							long secounds=0;
							if(currentValue!=null && currentValue.indexOf(".")>0)
							{
								secounds=Long.parseLong(currentValue.substring(0,currentValue.indexOf(".")));
							}
							else
							{
								secounds=Long.parseLong(currentValue);
							}

							dateDiff=egDashboard.getDateDifferenceString(secounds);
							dateDiff=com.egurkha.util.StringUtils.replace(dateDiff,"Day","Day(s)");
							dateDiff=com.egurkha.util.StringUtils.replace(dateDiff,"Hrs","Hour(s)");
							dateDiff=com.egurkha.util.StringUtils.replace(dateDiff,"Min","Minute(s)");
							dateDiff=com.egurkha.util.StringUtils.replace(dateDiff,"Sec","Secound(s)");
						}
						if(dispMeasureTitle==null || dispMeasureTitle.equals(""))
						{
							if(measure!=null && measure.equalsIgnoreCase("Uptime") && graphType.equalsIgnoreCase("measureGraph"))
							{
								Graph.put("title",mappingInfo.getMeasureDescription(test,measure)+": "+dateDiff);

							}
							else
							{
								Graph.put("title",mappingInfo.getMeasureDescription(test,measure)+"("+tablesInfo.getUnitForMeasure(test,measure)+")");		
						

							}
						}
						else
						{

							if(measure!=null && measure.equalsIgnoreCase("Uptime") && graphType.equalsIgnoreCase("measureGraph"))
							{
								Graph.put("title",dispMeasureTitle+": "+dateDiff);
							}
							else
							{
								Graph.put("title",dispMeasureTitle+"("+tablesInfo.getUnitForMeasure(test,measure)+")");
							}
						}
						JSONObject Graphcombo=new JSONObject();	
						if(allInfos!=null && allInfos.size()>1 && !showMultipleInfo)
						{
							Graphcombo.put("name","infos"+i);
							Graphcombo.put("type","combo");
							JSONArray Graphcomboitems=new JSONArray();
							for(int infocount=0;infocount<allInfos.size();infocount++)
							{
								JSONObject temp=new JSONObject();
								String selected="";
								String infoFromVector=(String)allInfos.get(infocount);
								String displayinfo=infoFromVector;
								String minfo=info;
								if(sid!=null && !sid.equals(""))
								{
									infoFromVector=com.egurkha.util.StringUtils.replace(infoFromVector,"+","");
									minfo=com.egurkha.util.StringUtils.replace(minfo,"+","");
									infoFromVector=sid+"*"+infoFromVector;
									minfo=sid+"*"+minfo;
								}
								if(infoFromVector!=null && infoFromVector.equals(minfo))
								{
									selected="selected";
								}
								HiddenFields.put("info edited",infoFromVector);
								temp.put("name",com.egurkha.util.StringUtils.replace(displayinfo,"+",""));
								temp.put("value",infoFromVector);
								Graphcomboitems.add(temp);
							}
							Graphcombo.put("items",Graphcomboitems);
						}
						else if(allInfos!=null && allInfos.size()==1)
						{
							String infoFromVector=(String)allInfos.get(0);
							infoFromVector=com.egurkha.util.StringUtils.replace(infoFromVector,"+","");
							if((sid!=null && !sid.equals("")) && (infoFromVector!=null && !infoFromVector.equals("")))
							{
								infoFromVector=sid+"*"+infoFromVector;
							}
							if(infoFromVector!=null && !infoFromVector.trim().equals(""))
							{
								//out.println("ee-"+infoFromVector);
							}
						}
						//Graph.put("Combo",Graphcombo);
					}
					else
					{
						String dispMeasureTitle=iniObj.getValue("Dashboard_measures_mapping",test+":"+measure);

						if(dispMeasureTitle==null || dispMeasureTitle.equals(""))
						{
							Graph.put("title",mappingInfo.getMeasureDescription(test,measure)+"("+tablesInfo.getUnitForMeasure(test,measure)+")");
						}
						else
						{
							Graph.put("title",dispMeasureTitle+"("+tablesInfo.getUnitForMeasure(test,measure)+")");
						}
					}

					if(sid!=null && !sid.equals(""))
					{
						info=com.egurkha.util.StringUtils.replace(info,"+","");
						info=sid+"*"+info;
					}
					else
						info=com.egurkha.util.StringUtils.replace(info,"+","|plus|");

					String defaultMGraphDuration=iniObj.getValue("Default_MeasureGraph_Duration","duration");
					String measuretimeline=egDashboard.convertDurtionIntoTimeline(defaultMGraphDuration,true);
					String currentValue=dashboardDAO.getCurrentMeasure(hostName,compType,portNo,com.egurkha.util.StringUtils.replace(info,"|plus|","+"),test,measureForDB,msmtHost);

					float currValInFloat=0.0f;
					if(currentValue!=null && currentValue.length()>0)
					{
						currValInFloat=Float.parseFloat(currentValue);
					}

					String lastRuntime=measureGraph.getMeasureLastRunTime(test,hostName,"NULL","NULL",com.egurkha.util.StringUtils.replace(info,"|plus|","+"),msmtHost);

					Vector times=egDashboard.getStartEndDateTimeForCurrent();
					if(times!=null && times.size()>=4)
					{
						startTime=(String)times.get(0);
						endTime=(String)times.get(1);
						startHour=(String)times.get(2);
						endHour=(String)times.get(3);
					}

					String infoForDiskbased="";

					for(int infocount=0;infocount<allInfos.size();infocount++)
					{
						String infoFromVector=(String)allInfos.get(infocount);
						infoFromVector=com.egurkha.util.StringUtils.replace(infoFromVector,"+","*");
						infoFromVector=com.egurkha.util.StringUtils.replace(infoFromVector,"|plus|","*");
						infoForDiskbased+=infoFromVector;
						if(infocount<allInfos.size()-1)
							infoForDiskbased+=",";
					}

					if(showMultipleInfo)
					{
						info=infoForDiskbased;
					}
						
					String statusGraphUrl="";
					if(from_page!=null && from_page.trim().length()>0 && 
						 from_page.equalsIgnoreCase("VMTabView"))
					{
						statusGraphUrl="/final/servlet/com.egurkha.monitor.CurrentStatus?measure="+measureForDB+"&state="+state+"&starttime="+startTime+"&port="+portNo+"&comptype="+compType+"&mode=3D&site=NULL&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&monitorSkin="+monitor_Skin+"&msmt_host="+msmtHost+"&gtype=1&starthr="+startHour+"&test="+test+"&info="+EgURLEncoder.encode(info,"UTF-8")+"&layer="+Layer_name+"&endtime="+endTime+"&endhr="+endHour+"&showRange=Range&gformat=graph&width=60&height=160";
					}

					times=egDashboard.getStartEndDateTimeForMeasure();
					if(times!=null && times.size()>=4)
					{
						startTime=(String)times.get(0);
						endTime=(String)times.get(1);
						startHour=(String)times.get(2);
						endHour=(String)times.get(3);
					}

					int measureGraphWidth=232;
					int measureGraphHeight=180;
					if(currValInFloat>0)
					{
						measureGraphWidth=232;
						measureGraphHeight=180;
					}
					else
					{
						measureGraphWidth=292;
						measureGraphHeight=180;
					}
					String measureGraphUrl="";
					if(from_page!=null && from_page.trim().length()>0 && 
						 from_page.equalsIgnoreCase("VMTabView"))
					{
						measureGraphUrl="/final/servlet/com.egurkha.monitor.DashboardTimelineMeasures?measure="+measureForDB+"&state="+state+"&starttime="+startTime+"&port="+portNo+"&comptype="+compType+"&mode=2D&site=NULL&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&monitorSkin="+monitor_Skin+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gtype=1&starthr="+startHour+"&test="+test+"&info="+EgURLEncoder.encode(info,"UTF-8")+"&layer="+Layer_name+"&endtime="+endTime+"&endhr="+endHour+"&showRange=RANGE&gformat=graph&width="+EasyGraphWidth+"&height="+EasyGraphHeight+"&threshold=no";
					}

					if(showMultipleInfo)
					{
						if(from_page!=null && from_page.trim().length()>0 && 
							 from_page.equalsIgnoreCase("VMTabView"))
						{
							measureGraphUrl="/final/servlet/com.egurkha.monitor.DashboardTimelineMeasures?endtime="+endTime+"&port="+portNo+"&site=NULL&sid=&starttime="+startTime+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measureForDB+"&newWindow=true&test="+test+"&layer="+Layer_name+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode=2D&starthr="+startHour+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gformat=graph&monitorSkin="+monitor_Skin+"&width="+EasyGraphWidth+"&height="+EasyGraphHeight+"&legends=true&title=false&priority=TOP+-+3&info="+EgURLEncoder.encode(info,"UTF-8")+"&threshold=no";//sarav easy chart width
						}
					}
					java.util.Date startDateForFullview=new java.util.Date();
					startDateForFullview.setDate(new java.util.Date().getDate()-1);

					String startTimeForFullView="";
					try
					{
						startTimeForFullView=sf.format(startDateForFullview);
						endTime=sf.format(endDate);
					}
					catch(Exception ex)
					{
						System.out.println("Exception...."+ex);
					}
					int numberOfInfo=0;
					if(info!=null)
					{
						StringTokenizer infoTokens=new StringTokenizer(info,",");
						numberOfInfo=infoTokens.countTokens();
					}
					String urlForMaximize="";
					if(from_page!=null && from_page.trim().length()>0 && 
						 from_page.equalsIgnoreCase("VMTabView"))
					{
						if(allComps!=null && allComps.trim().length()>0 && !(allComps.trim().equalsIgnoreCase("null")))
							urlForMaximize="/final/servlet/com.egurkha.monitor.DashboardTimelineMeasures?measure="+measureForDB+"&state="+state+"&starttime="+startTime+"&port="+portNo+"&comptype="+compType+"&mode=3D&site=NULL&host="+allComps+"&monitorSkin="+monitor_Skin+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gtype=1&starthr="+startHour+"&test="+test+"&info="+EgURLEncoder.encode(info,"UTF-8")+"&layer="+Layer_name+"&endtime="+endTime+"&endhr="+endHour+"&showRange=RANGE&gformat=graph&fromDashboard=true&timeLine=1+hour&width=880&height=320&threshold=no&title=true&minmaxavgRequired=true&from_page="+from_page;
						else
							urlForMaximize="/final/servlet/com.egurkha.monitor.DashboardTimelineMeasures?measure="+measureForDB+"&state="+state+"&starttime="+startTime+"&port="+portNo+"&comptype="+compType+"&mode=3D&site=NULL&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&monitorSkin="+monitor_Skin+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gtype=1&starthr="+startHour+"&test="+test+"&info="+EgURLEncoder.encode(info,"UTF-8")+"&layer="+Layer_name+"&endtime="+endTime+"&endhr="+endHour+"&showRange=RANGE&gformat=graph&fromDashboard=true&timeLine=1+hour&width=880&height=320&threshold=no&title=true&minmaxavgRequired=true&from_page="+from_page;
					}

					if(showMultipleInfo)
					{
						if(from_page!=null && from_page.trim().length()>0 &&  from_page.equalsIgnoreCase("VMTabView"))
						{
							if(allComps!=null && allComps.trim().length()>0 && !(allComps.trim().equalsIgnoreCase("null")))
							{
								if(allComps.indexOf(",")>-1)
								{
									urlForMaximize="/final/servlet/com.egurkha.monitor.DashboardTimelineMeasures?endtime="+endTime+"&port="+portNo+"&site=NULL&sid=&starttime="+startTime+"&host="+allComps+"&measure="+measureForDB+"&newWindow=true&test="+test+"&layer="+Layer_name+"&comptype="+compType+"&from=&endhr="+endHour+"&gtype=1&mode=3D&starthr="+startHour+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gformat=graph&monitorSkin="+monitor_Skin+"&width=880&height=320&legends=true&fromDashboard=true&title=true&priority=TOP+-+3&threshold=no&minmaxavgRequired=true&info="+EgURLEncoder.encode(info,"UTF-8")+"&time_line=1+hour&from_page="+from_page;
								}
								else
								{
									urlForMaximize="/final/servlet/com.egurkha.monitor.DashboardTimelineMeasures?endtime="+endTime+"&port="+portNo+"&site=NULL&sid=&starttime="+startTime+"&host="+allComps+"&measure="+measureForDB+"&newWindow=true&test="+test+"&layer="+Layer_name+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode=3D&starthr="+startHour+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gformat=graph&monitorSkin="+monitor_Skin+"&width=880&height=320&legends=true&fromDashboard=true&title=true&priority=TOP+-+3&threshold=no&minmaxavgRequired=true&info="+EgURLEncoder.encode(info,"UTF-8")+"&time_line=1+hour&from_page="+from_page;
								}

							}
							else
								urlForMaximize="/final/servlet/com.egurkha.monitor.DashboardTimelineMeasures?endtime="+endTime+"&port="+portNo+"&site=NULL&sid=&starttime="+startTime+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measureForDB+"&newWindow=true&test="+test+"&layer="+Layer_name+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode=3D&starthr="+startHour+"&msmt_host="+msmtHost+"&gformat=graph&monitorSkin="+monitor_Skin+"&width=880&height=320&legends=true&fromDashboard=true&title=true&priority=TOP+-+3&threshold=no&minmaxavgRequired=true&info="+EgURLEncoder.encode(info,"UTF-8")+"&time_line=1+hour&from_page="+from_page;
						}
					}

					if(from_page!=null && from_page.trim().length()>0 && 
						 from_page.equalsIgnoreCase("VMTabView"))
					{
						if(info!=null && info.trim().length()<=0)
						{
							//measureGraphUrl="../monitor/eg_images/"+monitor_Skin+"/nomeasure_img.gif";
							measureGraphUrl="/final/images/"+monitor_Skin+"/nomeasures_custom.png";
							//urlForMaximize="";
						}
					}

					if(graphType.equalsIgnoreCase("measureGraph"))
					{
						String tline = "1 hour";
						String ctline = chartTimeline;
						String tmp_start_time = startTime+" "+startHour+":00:00";
						String tmp_end_time =  endTime+" "+endHour+":00:00";
						chartOption = HighChartTimeline.getChartOption(tline,currentDateFormat,tmp_start_time,tmp_end_time);

						if(!showMultipleInfo && currValInFloat>0)
						{
							Graph.put("Url",statusGraphUrl);
							HiddenFields.put("currentStatus"+i,statusGraphUrl);	
						}
						Graph.put("Url",measureGraphUrl);
						Graph.put("fullViewUrl",urlForMaximize);
						Graph.put("grpId","graphsvmtImg"+i);
						Graph.put("chartOption",chartOption);
						HiddenFields.put("measureGraphHid"+i,measureGraphUrl);
						HiddenFields.put("fullViewImg"+i,urlForMaximize);	
					}
					GraphArray.add(Graph);
				}
				else if((subsystem!=null)  && (subsystem.equalsIgnoreCase("overview") || subsystem.equalsIgnoreCase("DDAnalyzer")))
				{
					String  ddTitle="";
					if(st.hasMoreTokens())
					{
						String token=st.nextToken();
						String testName=token.substring(0,token.indexOf(":"));
	
						if(runingTestList!=null && testName!=null && runingTestList.size()>0 && !runingTestList.contains(testName))
							continue;
						//else
							//noGraphsFound=false;
						String measureName=token.substring(token.indexOf(":")+1,token.indexOf("#"));
						String unit_for_measure=tablesInfo.getUnitForMeasure(testName,measureName);
						if(measureName!=null && measureName.equals("Cpu_util"))
						{
							ddTitle=mappingInfo.getTextDescription("monitor.dashboard.Top CPU consuming processes") +" ("+unit_for_measure+")";
						}
	
						if(measureName!=null && measureName.equals("Free_memory"))
						{
							ddTitle=mappingInfo.getTextDescription("monitor.dashboard.Top memory consuming processes Overview") +" ("+unit_for_measure+")";
						}
						if(measureName!=null && measureName.equals("Physical_mem_utilze"))
						{
							ddTitle=mappingInfo.getTextDescription("monitor.dashboard.Top memory consuming processes ") +" ("+unit_for_measure+")";
						}

						if(measureName!=null && measureName.equals("Percent_busy"))
						{
							if(from_page!=null && from_page.trim().length()>0 && 
								 from_page.equalsIgnoreCase("VMTabView"))
							{
								//ddTitle=mappingInfo.getTextDescription("monitor.dashboard.Top processes by I/O activity") +" ("+unit_for_measure+")";
								ddTitle=mappingInfo.getTextDescription("monitor.dashboard.Top processes by I/O activity") +" (Bytes/sec)";
							}
						}
	
						if(startenddates!=null && !startenddates.equals("") && startenddates.indexOf("|")>0)
						{
							String start_Date=startenddates.substring(0,startenddates.indexOf("|"));
							String end_Date=startenddates.substring(startenddates.indexOf("|")+1);
							startDate=new java.util.Date(start_Date);
							endDate=new java.util.Date(end_Date);
							startTime=sf.format(startDate);
							endTime=sf.format(endDate);
						}
	
						String  format=token.substring(token.indexOf("#")+1,token.length());
						Vector msmt_host=dashboardDAO.getMsmtHost(compName,compType,testName);
						Vector Infos=new Vector();
	
						if(from_page!=null && from_page.trim().length()>0 && 
							 from_page.equalsIgnoreCase("VMTabView"))
						{
							Infos=measureGraph.getAllInfoForTest(compType,compName,testName,selected_info);
						}
						String msmthst="";
						if(msmt_host!=null && !msmt_host.isEmpty())
						{
							msmthst=(String)msmt_host.get(0);
						}
	
						String ddinfo="";
						if(Infos!=null && Infos.size()>0)
						{	
							if(testName.equals("SystemTest") && Infos.contains("+Summary"))
							{
								ddinfo="+Summary";
							}
							else if(testName.endsWith("SystemTest"))
							{
								boolean isFound = false;
								for(int l=0;l<Infos.size();l++)
								{
									String t_ddinfo=(String)Infos.get(l);
									if(t_ddinfo.endsWith("Summary"))
									{
										ddinfo=t_ddinfo;
										isFound = true;
										break;
									}
								}

								if(!isFound)
									ddinfo=(String)Infos.get(0);
							}
							else
							{
								ddinfo=(String)Infos.get(0);
							}
						}
						else if(selected_info!=null && selected_info.trim().length()>0)
						{
							ddinfo=selected_info;
						}
						ddinfo=com.egurkha.util.StringUtils.replace(ddinfo,"+","");
						//for fusion chart
						String ddXMLData="";
						EgInsideViewChartUtil fusionChart=new EgInsideViewChartUtil();
						Vector ddChartAttribute=new Vector();
	
						String ddGraphUrlLarge="";
						String ddGraphUrl="";
						String dddataurl="";
						if(from_page!=null && from_page.trim().length()>0 && 
							 from_page.equalsIgnoreCase("VMTabView"))
						{
							
							String ddinfo_sl=com.egurkha.util.StringUtils.replace(ddinfo,"\\","\\");
							
							ddinfo_sl=com.egurkha.util.StringUtils.replace(ddinfo_sl,"&","|amp|");
							
							dddataurl="/final/monitor/egDashBoardDDData.jsp?fromPage=current&site=-1&comptype="+compType+"&host="+hostName+"&port="+portNo+"&layer="+Layer_name+"&test="+testName+"&stest="+testName+"-*"+ddinfo+"&info=*"+ddinfo_sl+"&msmt_host="+msmthst+"&time=Any&timeline=Any&measure="+measureName+"&from=0&firsttime=true&flag=1&fromDDGraphs=true&newWindow=false&comeFrom=null&ddTitle="+EgURLEncoder.encode(com.egurkha.util.StringUtils.replace(ddTitle,"%","|pct|"),"UTF-8")+"&starttime="+startTime+"&starthr="+startDate.getHours()+"&endtime="+EgURLEncoder.encode(endTime,"UTF-8")+"&endhr="+endDate.getHours()+"&startmin="+startDate.getMinutes()+"&endmin="+endDate.getMinutes();
	
							ddGraphUrl="/final/servlet/com.egurkha.monitor.DDTopview?host="+compName+"&compType="+compType+"&test="+testName+"&measure="+measureName+"&format="+EgURLEncoder.encode(format,"UTF-8")+"&module=System&width="+ddGraphWidth+"&height="+ddGraphHeight+"&endtime="+EgURLEncoder.encode(endTime,"UTF-8")+"&starthr="+startDate.getHours()+"&endhr="+endDate.getHours()+"&starttime="+startTime+"&monitorSkin="+monitor_Skin+"&mode=3D&graphdisplay=defaultView&startmin="+startDate.getMinutes()+"&endmin="+endDate.getMinutes()+"&from_page="+from_page+"&info="+ddinfo;

							ddGraphUrlLarge="/final/servlet/com.egurkha.monitor.DDTopview?host="+compName+"&compType="+compType+"&test="+testName+"&measure="+measureName+"&format="+EgURLEncoder.encode(com.egurkha.util.StringUtils.replace(format,"%","|pct|"),"UTF-8")+"&module=System&width="+ddGraphWidth+"&height="+ddGraphHeight+"&from=fullview&endtime="+EgURLEncoder.encode(endTime,"UTF-8")+"&starthr="+startDate.getHours()+"&endhr="+endDate.getHours()+"&starttime="+startTime+"&mode=3D&graphTitle="+EgURLEncoder.encode(com.egurkha.util.StringUtils.replace(ddTitle,"%","|pct|"),"UTF-8")+"&showDDData=true&graphdisplay=defaultView&fullview=true&monitorSkin="+monitor_Skin+"&time_line=1+hour&from_page="+from_page+"&info="+EgURLEncoder.encode(ddinfo_sl,"UTF-8");

							//------------added by arivu for fusion chart---------------//
							ddTitle=com.egurkha.util.StringUtils.replace(ddTitle,"|pct|","%");
							ddChartAttribute.add("palette='1'");
							ddChartAttribute.add("showValues='1'");
							ddChartAttribute.add("showBorder ='0'");
							ddChartAttribute.add("decimals='2'");
							ddChartAttribute.add("formatNumberScale='0'");
							ddChartAttribute.add("useRoundEdges='1'");
							ddChartAttribute.add("exportTargetWindow='1'");
							
							ddChartAttribute.add("clickURL='javascript:showFullviewVMTab(&apos;"+i+"&apos;,this.event,2,&apos;ddGraph&apos;);setDDDataURL(&apos;"+EgURLEncoder.encode(dddataurl,"UTF-8")+"&apos;)'");
							ddChartAttribute.add("exportEnabled='1'");
							ddChartAttribute.add("exportAction='download'");
							ddChartAttribute.add("exportAtClient='0'");
							ddChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
							//ddChartAttribute.add("bgColor='E6E6E6'");
							ddChartAttribute.add("bgColor='FFFFFF'");
							ddChartAttribute.add("borderAlpha='100'");
							ddChartAttribute.add("showToolTipShadow='1'");
							ddChartAttribute.add("showYAxisValues='0'");
							ddChartAttribute.add("showToolTip='1'");
							ddChartAttribute.add("chartLeftMargin='8'");
							ddChartAttribute.add("chartRightMargin='8'");
							ddChartAttribute.add("chartTopMargin='8'");
							ddChartAttribute.add("chartBottomMargin='8'");
							ddChartAttribute.add("canvasBorderColor  ='000000'");
							ddChartAttribute.add("canvasBorderThickness  ='0'");
							ddChartAttribute.add("plotSpacePercent  ='40'");
							ddChartAttribute.add("baseFont  ='verdana'");
							ddChartAttribute.add("outCnvBaseFontSize ='9'");
							ddChartAttribute.add("outCnvBaseFontColor ='000000'");
							ddChartAttribute.add("yAxisMaxValue  ='5'");
							ddChartAttribute.add("showAboutMenuItem='1' aboutMenuItemLabel='About eG Innovations' aboutMenuItemLink='n-http://www.eginnovations.com'");
							//-------------------------------------------------------------//
							String startMin= Integer.toString(startDate.getMinutes());
							String endMin=Integer.toString(endDate.getMinutes());
							ddXMLData=fusionChart.getXMLforDD("System",compName,compType,testName,measureName,startTime,startHour,startMin,endTime,endHour,endMin,format,null,false,"",ddChartAttribute,ddinfo);

							if(isFusionChart)
								ddXMLData=com.egurkha.util.StringUtils.replace(ddXMLData,"\"","");
						}
						Graph.put("title",ddTitle);
						if(ddEnabled)
						{
							if(ddXMLData!=null && ddXMLData.trim().length()>0)
							{
								Graph.put("dataXML",ddXMLData);
								Graph.put("maxViewId",i+"^eg^ddGraph");
								Graph.put("chartInx","chartIdInx"+String.valueOf(i));
								Graph.put("divId","Bar2DContainer"+i);
								Graph.put("fcId","myBar2DChartId"+i);
								Graph.put("movie","/final/FusionCharts/swf/Bar2D.swf");
								Graph.put("GraphFile","Bar2D.swf");
								Graph.put("GraphWidth",ddGraphWidth);
								Graph.put("GraphHeight",ddGraphHeight);
								Graph.put("ddGraphUrlLarge",ddGraphUrlLarge);
							}
							else
							{
								String ddUrl="/final/images/"+monitor_Skin+"/nomeasures_custom.png";
								Graph.put("errorMsg",mappingInfo.getTextDescription("monitor.common.No detailed measures available"));
								Graph.put("ddGraphUrlLarge",ddGraphUrlLarge);
								Graph.put("maxViewId",i+"^eg^ddGraph");
								
								Graph.put("chartInx","chartIdInx"+String.valueOf(i));
							}
						}
						else
						{
							Graph.put("errorMsg",mappingInfo.getTextDescription("monitor.common.No detailed measures available"));
						}
					}
					GraphArray.add(Graph);
				}
				
				if(numColums%3==2)
				{
					if((subsystem!=null && subsystem.equalsIgnoreCase("Uptime")) && (graphType !=null && graphType.equalsIgnoreCase("measureGraph")))
					{

					}
				}
				numColums++;
			}
			LowerPanel.put("Graph",GraphArray);
			if(subsystem!=null && !subsystem.equalsIgnoreCase("overview") && !subsystem.equalsIgnoreCase("Uptime")&& graphType.equalsIgnoreCase("measureGraph") && ddEnabled  && runingTestList!=null && ddtest!=null && runingTestList.size()>0 && runingTestList.contains(ddtest))
			{
				//noGraphsFound=false;
				JSONObject Grid=new JSONObject();
				JSONArray GridHeadersArray=new JSONArray();
				Grid.put("title",dataTitle);
				Hashtable graphParams=new Hashtable();
				if(analysisData!=null && analysisData.size()>0)
				{
					int topcnt=0;
					JSONObject temp1=new JSONObject();
					JSONObject temp2=new JSONObject();
					JSONObject temp3=new JSONObject();
					JSONObject temp4=new JSONObject();
					temp1.put("name",mappingInfo.getTextDescription("monitor.dashboard.Process"));
					temp2.put("name",mappingInfo.getTextDescription("monitor.dashboard.Min"));
					temp3.put("name",mappingInfo.getTextDescription("monitor.dashboard.Max"));
					temp4.put("name",mappingInfo.getTextDescription("monitor.dashboard.Avg"));
					GridHeadersArray.add(temp1);
					GridHeadersArray.add(temp2);
					GridHeadersArray.add(temp3);
					GridHeadersArray.add(temp4);
					Grid.put("Headers",GridHeadersArray);
					JSONArray GridItemsArray=new JSONArray();
					Vector top=ddoverview.getTopValues();
					Iterator itr=top.iterator();
					while(itr.hasNext())
					{
						JSONObject temp=new JSONObject();
						String key=(String)itr.next();
						Vector  analysis=(Vector)analysisData.get(key);
						if(analysis==null)
						{
							continue;
						}
						Vector graphValues=(Vector)analysis.get(0);
						Vector graphData=(Vector)analysis.get(1);
						graphParams.put(key,graphValues);
	
						if(topcnt==10)
							break;
						String keyTitle=key;
						if(key!=null && key.length() >15)
						{
							key = key.substring(0,12)+"...";
						}
						temp.put("value0",key);
						temp.put("value1",(String)graphData.get(0));
						temp.put("value2",(String)graphData.get(1));
						temp.put("value3",(String)graphData.get(2));
						topcnt++;
						GridItemsArray.add(temp);
					}
					Grid.put("items",GridItemsArray);
				}
				else
				{
					Grid.put("errorMsg",mappingInfo.getTextDescription("monitor.common.No Measures Available"));
				}
				LowerPanel.put("Grid",Grid);
				JSONObject ImageGraph=new JSONObject();
				ImageGraph.put("title",graphTitle);
				
				if(startenddates!=null && !startenddates.equals("") && startenddates.indexOf("|")>0)
				{
					String start_Date=startenddates.substring(0,startenddates.indexOf("|"));
					String end_Date=startenddates.substring(startenddates.indexOf("|")+1);
					startDate=new java.util.Date(start_Date);
					endDate=new java.util.Date(end_Date);
					startTime=sf.format(startDate);
					endTime=sf.format(endDate);
				}
				Vector msmt_host=dashboardDAO.getMsmtHost(compName,compType,ddtest);
				Vector Infos=new Vector();
				
				if(from_page!=null && from_page.trim().length()>0 && 
					 from_page.equalsIgnoreCase("VMTabView"))
				{
					Infos=measureGraph.getAllInfoForTest(compType,compName,ddtest,selected_info);
					if(selected_info!=null && Infos!=null && Infos.isEmpty())
						Infos.add(selected_info);
				}
				else
				{
					Infos=measureGraph.getAllInfoForTest(compType,compName,ddtest);
				}
				String msmthst="";

				if(msmt_host!=null && !msmt_host.isEmpty())
				{
					msmthst=(String)msmt_host.get(0);
				}

				String ddoverviewinfo="";
				if(Infos!=null && Infos.size()>0)
				{
					if(ddtest.equals("SystemTest") && Infos.contains("+Summary"))
					{
						ddoverviewinfo="+Summary";
					}
					else if(ddtest.endsWith("SystemTest"))
					{
						boolean isFound = false;
						for(int l=0;l<Infos.size();l++)
						{
							String t_ddinfo=(String)Infos.get(l);
							if(t_ddinfo.endsWith("Summary"))
							{
								ddoverviewinfo=t_ddinfo;
								isFound = true;
								break;
							}
						}

						if(!isFound)
							ddoverviewinfo=(String)Infos.get(0);
					}
					else
					{
						ddoverviewinfo=(String)Infos.get(0);
					}
				}

				ddoverviewinfo=com.egurkha.util.StringUtils.replace(ddoverviewinfo,"+","");
				String imageURI="";
				String fullimageURI="";
				String ddoverviewurl="";
				if(from_page!=null && from_page.trim().length()>0 && 
					 from_page.equalsIgnoreCase("VMTabView"))
				{
					ddoverviewurl="/final/monitor/egDashBoardDDData.jsp?fromPage=current&site=-1&comptype="+compType+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&port="+portNo+"&layer="+Layer_name+"&test="+ddtest+"&stest="+ddtest+"-*"+EgURLEncoder.encode(ddoverviewinfo,"UTF-8")+"&info=*"+EgURLEncoder.encode(ddoverviewinfo,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmthst,"UTF-8")+"&time=Any&timeline=Any&starttime="+startTime+"&starthr="+startDate.getHours()+"&endtime="+EgURLEncoder.encode(endTime,"UTF-8")+"&endhr="+endDate.getHours()+"&measure="+ddmeasure+"&from=0&firsttime=true&flag=1&fromDDGraphs=true&newWindow=false&monitorSkin="+monitor_Skin+"&comeFrom=null&startmin="+startDate.getMinutes()+"&endmin="+endDate.getMinutes()+"&ddTitle="+graphTitle;
					
					String AggregateGraphs=iniObj.getValue("Insideview_Dashboard","AggregateGraphs");
					if(AggregateGraphs!=null && AggregateGraphs.equalsIgnoreCase("Yes"))
					{
						fullimageURI="/final/servlet/com.egurkha.monitor.DDOverviewLineChart?host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&test="+ddtest+"&measure="+ddmeasure+"&ddformat="+ddformat+"&module=System&starttime="+startTime+"&starthr="+startDate.getHours()+"&endtime="+endTime+"&endhr="+endDate.getHours()+"&width=880&height=320&startMin="+startDate.getMinutes()+"&endMin="+endDate.getMinutes()+"&monitorSkin="+monitor_Skin+"&fullview=true&mode=3D&showDDData=true&from_page="+from_page+"&info="+EgURLEncoder.encode(ddoverviewinfo,"UTF-8")+"&AggregateGraphs="+AggregateGraphs+"&graphTitle="+EgURLEncoder.encode(graphTitle,"UTF-8")+"&gType=fullImage";

						imageURI="/final/servlet/com.egurkha.monitor.DDOverviewLineChart?host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&test="+ddtest+"&measure="+ddmeasure+"&ddformat="+ddformat+"&module=System&starttime="+startTime+"&starthr="+startDate.getHours()+"&endtime="+endTime+"&endhr="+endDate.getHours()+"&width=538&height=226&startMin="+startDate.getMinutes()+"&endMin="+endDate.getMinutes()+"&monitorSkin="+monitor_Skin+"&mode=3D&from_page="+from_page+"&info="+EgURLEncoder.encode(ddoverviewinfo,"UTF-8")+"&AggregateGraphs="+AggregateGraphs+"&gType=image";
					}
					else
					{
						fullimageURI="/final/servlet/com.egurkha.monitor.DDOverviewLineChart?host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&test="+ddtest+"&measure="+ddmeasure+"&ddformat="+ddformat+"&module=System&starttime="+startTime+"&starthr="+startDate.getHours()+"&endtime="+endTime+"&endhr="+endDate.getHours()+"&width=880&height=320&startMin="+startDate.getMinutes()+"&endMin="+endDate.getMinutes()+"&monitorSkin="+monitor_Skin+"&fullview=true&mode=3D&showDDData=true&from_page="+from_page+"&info="+EgURLEncoder.encode(ddoverviewinfo,"UTF-8")+"&from=fullview&graphdisplay=defaultView&graphTitle="+EgURLEncoder.encode(graphTitle,"UTF-8")+"&gType=fullImage";

						imageURI="/final/servlet/com.egurkha.monitor.DDOverviewLineChart?host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&test="+ddtest+"&measure="+ddmeasure+"&ddformat="+ddformat+"&module=System&starttime="+startTime+"&starthr="+startDate.getHours()+"&endtime="+endTime+"&endhr="+endDate.getHours()+"&width=538&height=226&startMin="+startDate.getMinutes()+"&endMin="+endDate.getMinutes()+"&monitorSkin="+monitor_Skin+"&mode=3D&graphdisplay=defaultView&from_page="+from_page+"&info="+EgURLEncoder.encode(ddoverviewinfo,"UTF-8")+"&gType=image";
					}
				}
				ImageGraph.put("Url",imageURI);
				ImageGraph.put("MaximizeUrl",fullimageURI);
			}
		}
		else
		{
			json.put("errorMsg",mappingInfo.getTextDescription("monitor.dashboard.No measures available for configured metrics"));
		}
		if(from_page!=null && from_page.trim().length()>0 && 
	 from_page.equalsIgnoreCase("VMTabView"))
		{
			String info_for_url=request.getParameter("info");
			if(info_for_url!=null && info_for_url.trim().length()>0)
			{
				info_for_url=com.egurkha.util.StringUtils.replace(info_for_url,"+","|plus|");
				info_for_url=com.egurkha.util.StringUtils.replace(info_for_url,"&","|amp|");
				info_for_url=com.egurkha.util.StringUtils.replace(info_for_url,"%","|pct|");
				info_for_url=com.egurkha.util.StringUtils.replace(info_for_url,"#","|hash|");
			}
			if(request.getQueryString()!=null)
			{
				if(session!=null)
				{
					session.setAttribute("monitorLastSession","/final/monitor/egInsideviewDashboard.jsp?getFor=measure&comp="+request.getParameter("hostName")+"&comptype="+request.getParameter("compType")+"&defaultSelectedTab=System&Layer="+Layer_name+"&info="+EgURLEncoder.encode(info_for_url,"UTF-8")+"&subsystem="+request.getParameter("subsystem")+"&"+request.getQueryString());
					session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
				}
			}
			else
			{
				if(session!=null)
				{
					session.setAttribute("monitorLastSession","/final/monitor/egInsideviewDashboard.jsp?getFor=measure&comp="+request.getParameter("hostName")+"&comptype="+request.getParameter("compType")+"&defaultSelectedTab=System&Layer="+Layer_name+"&info="+EgURLEncoder.encode(info_for_url,"UTF-8")+"&subsystem="+request.getParameter("subsystem"));
					session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
				}
			}
		}
	}
	else
	{
		
		json.put("errorMsg",mappingInfo.getTextDescription("monitor.dashboard.No Metrics Configured"));
	}
	if ( request.getQueryString()!=null && (request.getQueryString().indexOf("from_page=VMTabView")>-1))
	{
		session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?site=NULL&from=list&comptype="+request.getParameter("compType")+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&tab=LayerModel&fromHomepage=true");
	}
	//json.put("UpperPanel",UpperPanel);	
	HiddenFields.put("hostName",hostName);
	HiddenFields.put("compType",compType);
	if(LowerPanel.size()>0)
		json.put("LowerPanel",LowerPanel);
	json.put("HiddenFields",HiddenFields);
	response.getWriter().write(json.toString());		
}
catch(Throwable ex)
{
	ex.printStackTrace();
}
%>