<%
/*******************************************************************************
*	File name		: egSummaryView.jsp
*	Purpose			: To display Summary Data for Cpu,Disc,Uptime in Dashboard
*	Version			: eG 4.3
*	Creation Date	: 20/03/2009
*	Authtor			: Antony
*	ExtJx Modifyed	: Saravanan.A on 16-9-2013
******************************************************************************/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EgServerDashboardTracker.jsp"%>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import="com.eg.EgExternalInfo"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page import="java.text.*"%>
<%@ page import="com.eg.*" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import="com.egurkha.HighChartTimeline"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="net.sf.json.*"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>
<%
	JSONObject jsonSV = new JSONObject();
try
{
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	boolean isFusionChart=HighChartTimeline.isFusion();
	IniFile iniObj=new IniFile(s_iniFile_dir+"eg_dashboard.ini");
	IniFile iniObj2=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");
	IniUI ui = IniUI.getInstance();

	String thisLanguage = ui.getDefaultLanguage();
	if (u_ser!=null)
	{
		String userLang = u_ser.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	ErUtils erutils=new ErUtils();
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String compName=request.getParameter("hostName");
	String compType=request.getParameter("compType");
	String module=request.getParameter("subsystem");
	String s_info=request.getParameter("info");
	String from_page=request.getParameter("from_page");
	String tab=request.getParameter("tab");
	String threadType=request.getParameter("threadType");
	String site=request.getParameter("site");
	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");

	boolean isVM = false;
	String s_isVM = request.getParameter("isVM");
	s_isVM=(s_isVM==null || s_isVM.trim().length()==0)?"false":s_isVM;
	isVM = (new Boolean(s_isVM)).booleanValue();
	
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}
	
	double defaultDialGraphWidth=230;  // default dial graph width for calculation
	double defaultDialGraphHeight=115;  // default dial graph height for calculation
	double dialGraphWidth=230;  
	double dialGraphHeight=115;
	double defaultLedGraphWidth=140;  // default led graph width for calculation
	double defaultLedGraphHeight=115;  // default led graph height for calculation
	double ledGraphWidth=120;  //140
	double ledGraphHeight=89;//115
	String ledGap="1";
	String ledSize="1";
	String chartLeftMargin="42";
	String chartRightMargin="25";
	
	double dialGraphWidthTo1024PxInPercent=defaultDialGraphWidth/1024;
	double dialGraphHeightToDefaultWidthInPercent=defaultDialGraphHeight/defaultDialGraphWidth;
	
	dialGraphWidth=screenWidthInDouble*dialGraphWidthTo1024PxInPercent;
	dialGraphWidth=MathUtils.round(dialGraphWidth,0);

	dialGraphHeight=dialGraphWidth*dialGraphHeightToDefaultWidthInPercent;
	dialGraphHeight=MathUtils.round(dialGraphHeight,0);
	
	MonitorDAOFactory	monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgDashBoardDAO dashboardDAO=monitorDaoFactory.getDashBoardDAO();
	EgDashBoardModel  egDashboard=new  EgDashBoardModel();
	EgExternalInfo egExternalInfo=new EgExternalInfo("manager");
	EgTesterInfo testerInfo=new EgTesterInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	EgDashboardMGraphModel measureGraph=new EgDashboardMGraphModel();
	DDOverview  ddoverview=new  DDOverview();
	

	EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");

	//String subject="System_Dashboard_Metrics";
	String subject="";
	String hostName="";
	String portNo="";
	String sid="";
	String msmtHost="";
	String DialChartNeed=iniObj2.getValue("Dashboard_Settings","UseDial");
	if(DialChartNeed==null || DialChartNeed.equalsIgnoreCase("Yes"))
		DialChartNeed="Yes";
	String suf="S";
	if(tab!=null && tab.equalsIgnoreCase("system"))
	{
		tab = "System";
		suf="S";
	}
	else if(tab!=null && tab.equalsIgnoreCase("network"))
	{
		tab = "Network";
		suf="N";
	}

	boolean isSystemTab=(tab!=null && tab.equalsIgnoreCase("System"));
	boolean isNetworkTab=(tab!=null && tab.equalsIgnoreCase("Network"));
	boolean isApplicationTab=(tab!=null && tab.equalsIgnoreCase("Application"));

	String dashboard_exclude_server=iniObj.getValue("Dashboard_Excluded_servers",compType);
	String dialSubject = "Insideview_Dashboard_"+compType;
	String s_dialgraphs=iniObj.getValue(dialSubject,tab+"_"+module+"_DialGraphs");
	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);
	EgServerDashBoardDAO serverDashboardDAO=monitorDaoFactory.getServerDashBoardDAO();
	Hashtable allMsmtHosts=serverDashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=serverDashboardDAO.getDescriptorsForAllTest(compName,compType,tab);

	if(subject==null || subject.trim().equals(""))
	{
		if(isSystemTab)
		{
			subject="System_Dashboard_Metrics";
		}
		else if(isNetworkTab)
		{
			subject="Network_Dashboard_Metrics";
		}
		else
		{
			subject=compType;
		}
	}
	boolean isDisableTests=false;

	if(tab!=null && tab.equalsIgnoreCase("Application") || dashboard_exclude_server!=null && dashboard_exclude_server.equalsIgnoreCase("No"))
		subject=compType;
	if(from_page!=null && from_page.trim().length()>0 && from_page.equalsIgnoreCase("insideviewDashboard"))
	{
		subject="Insideview_Dashboard_"+compType;
	}
	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");

		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}

	Vector summary=new Vector();
	String title="";
	String dispTitle1="";
	String dispTitle2="";

	String testName="";
	String  measure="";
	String threadsummary="";


	String comp_type=iniObj.getValue("Insideview_Dashboard_"+compType,"System_Memory_summary");
	String test_names = comp_type.substring(0,comp_type.indexOf(":"));
	String measureName = comp_type.substring(comp_type.indexOf(":")+1);
	String test_measure = mappingInfo.getMeasureDescription(test_names,measureName);
	String test_measure_unit =tablesInfo.getUnitForMeasure(test_names,measureName.trim());
	
	if(module!=null && module.equals("CPU"))
	{
		String  inivalue=iniObj.getValue(subject,"System_CPU_summary");
		testName=inivalue.substring(0,inivalue.indexOf(":"));
		measure=inivalue.substring(inivalue.indexOf(":")+1,inivalue.length());

		if(from_page!=null && from_page.trim().length()>0 && from_page.equalsIgnoreCase("insideviewDashboard"))
		{
			summary=dashboardDAO.getCPUSummary(compName,compType,testName,measure,s_info);
		}
		else
		{
			summary=dashboardDAO.getCPUSummary(compName,compType,testName,measure);
		}

		title="CPU Usage Summary";
		dispTitle1="CPU Usage (%)";
		dispTitle2="CPU free (%)";
	}
	else if(module!=null && module.equalsIgnoreCase("Memory") && (compType.equals("VmEsx_i_server") || compType.equals("Xen_virtual_server") || compType.equals("VmVdi_i_server") || compType.equals("Xen_desktop_server")))
	{
		String  inivalue=iniObj.getValue(subject,"System_Memory_summary");
		testName=inivalue.substring(0,inivalue.indexOf(":"));
		measure=inivalue.substring(inivalue.indexOf(":")+1,inivalue.length());

		if(from_page!=null && from_page.trim().length()>0 && from_page.equalsIgnoreCase("insideviewDashboard"))
		{
			summary=dashboardDAO.getMemorySummary(compName,compType,testName,measure,s_info);
		}
		else
		{
			summary=dashboardDAO.getMemorySummary(compName,compType,testName,measure);
		}

		title="Memory Usage Summary";

		if(compType.equals("Xen_virtual_server") || compType.equals("Xen_desktop_server"))
		{
			dispTitle1="Memoy Usage (Number)";
		}
		else
		{
			//dispTitle1="Memoy Usage (%)";
			dispTitle1=test_measure + " ("+test_measure_unit+")";
		}
		dispTitle2="Memory free (%)";
	}
	else if(module!=null && module.equals("Disk"))
	{
		String  inivalue=iniObj.getValue(subject,"System_Disk_summary");
		testName=inivalue.substring(0,inivalue.indexOf(":"));
		measure=inivalue.substring(inivalue.indexOf(":")+1,inivalue.length());

		if(from_page!=null && from_page.trim().length()>0 && from_page.equalsIgnoreCase("insideviewDashboard"))
		{
			summary=dashboardDAO.getDiskSummary(compName,compType,testName,measure,s_info);
		}
		else
		{
			summary=dashboardDAO.getDiskSummary(compName,compType,testName,measure);
		}

		title="Disk Usage Summary";
		dispTitle1="Disk Usage (%)";
		dispTitle2="Disk free (%)";
	}
	else if(module!=null && module.equals("JVM Memory"))
	{
		String  inivalue=iniObj.getValue(subject,"Application_JVM Memory_Summary");

		testName=inivalue.substring(0,inivalue.indexOf(":"));
		measure=inivalue.substring(inivalue.indexOf(":")+1,inivalue.length());
		summary=dashboardDAO.getJVMMemorySummary(compName,compType,testName,measure);

		title="Memory Usage Summary";
		dispTitle1="Memory Usage (%)";
		dispTitle2="Memory free (%)";
	}
	else if(module!=null && module.equals("JVM Thread"))
	{
		threadsummary=iniObj.getValue(subject,"Application_Thread_Summary");
	}

	String colspan="";
	int size=0;
	if(summary!=null && summary.size()>0)
	{
		//int size=summary.size()/3;
		size=summary.size()/3;
		Integer cspan=new Integer(size);
		colspan=cspan.toString();
	}

	Hashtable allCurrentValues=egDashboard.getCurrentValueForAllConfiguredMeasures(compType,compName,tab,"Application_JVM Classes_Summary");
	SimpleDateFormat  sdf=new SimpleDateFormat("MM/dd/yyyy HH:mm");
	java.util.Date end_Date=new java.util.Date();
	java.util.Date start_Date=new java.util.Date(end_Date.getTime()-(60*60*1000));

	String s_startTime=sdf.format(start_Date);
	String s_endTime=sdf.format(end_Date);
	String s_startDate=s_startTime.substring(0,s_startTime.indexOf(" "));
	String s_endDate=s_endTime.substring(0,s_endTime.indexOf(" "));
	String tmp_startHr=s_startTime.substring(s_startTime.indexOf(" ")+1,s_startTime.length());
	String tmp_endHr=s_endTime.substring(s_endTime.indexOf(" ")+1,s_endTime.length());
	String s_startHr=tmp_startHr.substring(0,tmp_startHr.indexOf(":"));
	String s_startMin=tmp_startHr.substring(tmp_startHr.indexOf(":")+1,tmp_startHr.length());
	String s_endHr=tmp_endHr.substring(0,tmp_endHr.indexOf(":"));
	String  s_endMin=tmp_endHr.substring(tmp_endHr.indexOf(":")+1,tmp_endHr.length());
	String  ddtest="JvmThreadTest";
	String ddmeasure="Live_threads";

	if(threadType!=null && threadType.indexOf(":")!=-1)
	{
		ddtest=threadType.substring(0,threadType.indexOf(":"));
		ddmeasure=threadType.substring(threadType.indexOf(":")+1);
	}

	ArrayList al=egDashboard.getDiagnosisData(tab,compName,compType,ddtest,ddmeasure,s_startDate,s_startHr,s_startMin,s_endDate,s_endHr,s_endMin);
	
	if(((s_dialgraphs!=null && s_dialgraphs.trim().length()>0) || (summary!=null && summary.size()>0 && module!=null && !module.equalsIgnoreCase("uptime") && !module.equalsIgnoreCase("JVM Memory"))) && !module.equalsIgnoreCase("tcp"))
	{
		String isThresholdNeed=iniObj.getValue("Dashboard_Settings","ApplyThreshold");

		StringTokenizer dialGraphTokenizer=new StringTokenizer(s_dialgraphs,",");
		ArrayList dialmeasuresNAList = new ArrayList();
		int columnCounts=0;
		int dialCount =0;
		JSONArray jsonSVInArrList = new JSONArray();
		while(dialGraphTokenizer.hasMoreTokens())
		{
			JSONObject dialSVJson = new JSONObject();
			String testmeasure=dialGraphTokenizer.nextToken();
			String s_test=testmeasure.substring(0,testmeasure.indexOf(":"));

			if(enabledTests!=null && !enabledTests.contains(s_test))
			{
				isDisableTests=true;
				continue;
			}
			if(!specsInfo.isTestRelevantForServer(compType,s_test))
			{
				continue;
			}
			String s_measure=testmeasure.substring(testmeasure.indexOf(":")+1);

			List agentsForDial = egExternalInfo.getAgentsFor(s_test,compType,hostName);
			if(agentsForDial!=null && agentsForDial.size()>0)
				msmtHost=(String)agentsForDial.get(0);
			else
				msmtHost=hostName;
			//msmtHost=(String)allMsmtHosts.getss(s_test);

			String measureForDB=dbInfo.getColumnForMeasure(s_test,s_measure);
			String dialTitleMapping=iniObj.getValue("Dashboard_Dial_mapping",testmeasure);
			if(dialTitleMapping==null || dialTitleMapping.trim().equals(""))
			{
				String dialTest="";
				String dialMeasure="";
				dialTest = testmeasure.substring(0,testmeasure.indexOf(":"));
				dialMeasure = testmeasure.substring(testmeasure.indexOf(":")+1,testmeasure.length());
				dialTitleMapping=mappingInfo.getMeasureDescription(dialTest,dialMeasure);
			}

			String unit=tablesInfo.getUnitForMeasure(s_test,s_measure);

			if((unit!=null) && !(unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage") || unit.equals("%")))
				continue;
			if(unit!=null && unit.equals("percent"))
				unit="%";

			boolean isFullView=false;
			Vector infos=(Vector)allTestInfos.get(s_test);
			Vector infosForCutOffFactor = new Vector();
			if(egDashboard.isTestHasCutOffFactor(s_test))
			{
				if(infos!=null && !infos.isEmpty())
				{
					for(int d=0;d<infos.size();d++)
					{
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,s_test,msmtHost,(String)infos.get(d));
						if(!isTestExceededCutOffFactor)
						{
							infosForCutOffFactor.add(infos.get(d));
						}
					}
				}
				if(infosForCutOffFactor!=null && !infosForCutOffFactor.isEmpty())
				{
					infos=infosForCutOffFactor;
				}
			}
			if(infos!=null && !infos.isEmpty() && infos.size()>1)
			{
				isFullView=true;
			}

			Vector dialChartAttributes=new Vector();
			dialChartAttributes.add("clickURL='javascript:dialOnclick(&apos;dialUrlSV"+suf+dialCount+"&apos;)'");
			dialChartAttributes.add("bgColor='e8e8e8'");
			dialChartAttributes.add("bgAlpha='3,80'");
			dialChartAttributes.add("fillAngle='90'");
			dialChartAttributes.add("majorTMNumber='6'");
			dialChartAttributes.add("majorTMHeight='8'");
			dialChartAttributes.add("majorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMHeight='4'");
			dialChartAttributes.add("minorTMNumber='6'");
			dialChartAttributes.add("majorTMThickness='1'");
			dialChartAttributes.add("markerRadius='30'");
			dialChartAttributes.add("showGaugeBorder='0'");
			dialChartAttributes.add("gaugeOuterRadius='65'");
			dialChartAttributes.add("gaugeOriginX='90'");
			dialChartAttributes.add("gaugeOriginY='80'");
			dialChartAttributes.add("gaugeInnerRadius='0'");
			dialChartAttributes.add("formatNumberScale='1'");
			dialChartAttributes.add("displayValueDistance='15'");
			dialChartAttributes.add("decimalPrecision='2'");
			dialChartAttributes.add("tickMarkDecimalPrecision='1'");
			dialChartAttributes.add("pivotRadius='6'");
			dialChartAttributes.add("showPivotBorder='1'");
			dialChartAttributes.add("pivotBorderColor='000000'");
			dialChartAttributes.add("pivotBorderThickness='5'");
			dialChartAttributes.add("pivotFillMix='FFFFFF,000000'");
			dialChartAttributes.add("chartLeftMargin='0'");
			dialChartAttributes.add("chartRightMargin='0'");
			dialChartAttributes.add("chartTopMargin='0'");
			dialChartAttributes.add("chartBottomMargin='0'");
			dialChartAttributes.add("baseFontColor='000000'");
			dialChartAttributes.add("showBorder='0'");
			dialChartAttributes.add("showToolTipShadow='1'");
			dialChartAttributes.add("toolTipBgColor='555555'");
			dialChartAttributes.add("toolTipBorderColor='ffff00'");
			dialChartAttributes.add("exportEnabled='0'");
			dialChartAttributes.add("exportAction='download'");
			dialChartAttributes.add("exportAtClient='0'");
			dialChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			String dialXMLData="";
			if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("Yes"))
			{
				dialXMLData=fusionChart.getXMLDataForDial(s_test,s_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,dialChartAttributes,"FFFFFF",false,s_info,dialGraphWidth,dialGraphHeight);//,"FFFFFF");
			}
			else if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("No"))
			{
				
				Vector jvmChartAttributes=new Vector();
				jvmChartAttributes.add("clickURL='javascript:dialOnclick(&apos;dialUrlSV"+suf+dialCount+"&apos;)'");
				jvmChartAttributes.add("upperLimit='100'");
				jvmChartAttributes.add("bgColor='99CCFF,FFFFFF'");
				jvmChartAttributes.add("bgAlpha='0,0'");
				jvmChartAttributes.add("showBorder='0'");
				jvmChartAttributes.add("adjustTM='0'");
				jvmChartAttributes.add("lowerLimit='0'");
				jvmChartAttributes.add("decimals='2'");
				jvmChartAttributes.add("showValue='0'");
				jvmChartAttributes.add("majorTMNumber='5'");
				//jvmChartAttributes.add("baseFontSize='8'");
				jvmChartAttributes.add("majorTMColor='000000'");
				jvmChartAttributes.add("majorTMHeight='5'");
				jvmChartAttributes.add("minorTMNumber='2'");
				jvmChartAttributes.add("minorTMColor='000000'");
				jvmChartAttributes.add("minorTMHeight='2'");
				jvmChartAttributes.add("majorTMThickness='1'");
				jvmChartAttributes.add("decimalPrecision='0'");
				jvmChartAttributes.add("ledGap='"+ledGap+"'");
				jvmChartAttributes.add("ledSize='"+ledSize+"'");
				jvmChartAttributes.add("tickValueDistance='2'");
				jvmChartAttributes.add("tickMarkDistance='1'");
				jvmChartAttributes.add("tickValueStep='1'");
				jvmChartAttributes.add("tickValueDecimals='8'");
				jvmChartAttributes.add("chartLeftMargin='"+chartLeftMargin+"'");
				jvmChartAttributes.add("chartRightMargin='"+chartRightMargin+"'");
				jvmChartAttributes.add("chartTopMargin='21'");
				jvmChartAttributes.add("chartBottomMargin='20'");
				jvmChartAttributes.add("baseFontSize ='9'");
				jvmChartAttributes.add("showToolTip='1'");
				jvmChartAttributes.add("baseFontColor  ='000000'");
				jvmChartAttributes.add("annRenderDelay='1.7'");
				jvmChartAttributes.add("exportEnabled='0'");
				jvmChartAttributes.add("exportAction='download'");
				jvmChartAttributes.add("exportAtClient='0'");
				jvmChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
						
				dialXMLData=fusionChart.getXMLDataForDial(s_test,s_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,jvmChartAttributes,"FFFFFF",false,s_info,dialGraphWidth,dialGraphHeight);
			}

			if( dialXMLData !=null && !dialXMLData.equals(""))
			{
				String info=fusionChart.getInfoForDial(s_test,s_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,s_info);
		
				if(info!=null && info.indexOf("+")!=-1)
					info=info.substring(info.indexOf("+")+1);

					info=com.egurkha.util.StringUtils.replace(info, "+", "|plus|");

				String layerName=dashboardDAO.getLayerForTest(compType,s_test,s_measure);

				String compTypeForAlarm=compType;
				if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
					compTypeForAlarm="Host_system";

				String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,s_test+"-"+info,s_measure);
			
				String layerPageUrl=response.encodeURL("/final/monitor/egMonDashboard.jsp?")+"qctr=2&from=list&tab=layers&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&layer="+EgURLEncoder.encode(layerName,"UTF-8")+"&site=NULL&test="+EgURLEncoder.encode(s_test+"-"+info,"UTF-8")+"&tstate="+measureState+"&msmt_host=&toDashBoardLayer=true&fromalarmWindow=true&fromSystemTab=true";

				String moreDescriptorUrl = response.encodeURL("/final/monitor/EgMoreInfosDial.jsp?")+"hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+s_test+"&measure="+s_measure+"&msmtHost="+msmtHost+"&tab="+tab;

				isFullView = false;
				dialSVJson.put("dialSVTitle",dialTitleMapping+"("+unit+")");
				if(isFullView)
				{
					dialSVJson.put("dialSVFullViewUrl",moreDescriptorUrl);
				}
				if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("Yes"))
				{
					if(isFusionChart)
					{
						dialSVJson.put("chartName","AngularGauge");
						dialSVJson.put("chartXML",dialXMLData);
						dialSVJson.put("chartWidth","200");
						dialSVJson.put("chartHeight","90");
					}
					else
					{
						JSONObject rootPropObj = new JSONObject();
						JSONObject propObj = new JSONObject();
						JSONObject gaugeProp = new JSONObject();
						JSONObject gaugeArray = new JSONObject();
						JSONArray stopsArr = new JSONArray();
						JSONArray stopsObj = new JSONArray();

						if( dialXMLData != null )
						{
							JSONObject splitData = new JSONObject();
							// value,test,descriptor,color
							ArrayList gaugePropList =  com.egurkha.util.StringUtils.egTokenizer( dialXMLData, ",",true,false,true);
							if( gaugePropList != null && gaugePropList.size() > 0 )
							{
								JSONArray dataArray = new JSONArray();
								String dataVal = (String) gaugePropList.get(0);
								String gaugeColor = "#35c8c2";
								Double dd = new Double(dataVal);
								dataArray.add(dd);
								splitData.put("name",(String) gaugePropList.get(2) );
								splitData.put("color",(String) gaugePropList.get(3) );
								splitData.put("subTitle",(String) gaugePropList.get(2) );
								splitData.put("data",dataArray );
								stopsArr.add(dd);
								stopsArr.add(gaugeColor);
								stopsObj.add(stopsArr);
								propObj.put("stopsArr",stopsObj);
								propObj.put("guageData",splitData);
								propObj.put("isVM",new Boolean(isVM));
								//propObj.put("layerModelUrl","dialUrlS"+dialChartCount);
								//propObj.put("layerModelUrlId","dialUrlS"+dialChartCount);
								//propObj.put("goToPage","layerModel");
								//propObj.put("goToPage","layerModel");
								propObj.put("unit","%");
								propObj.put("title",(String) gaugePropList.get(1) );
								propObj.put("subTitle",(String) gaugePropList.get(2) );
							}
						}
						//rootPropObj.put("rootJson ",propObj);
						dialSVJson.put("chartName","AngularGauge");
						dialSVJson.put("chartXML",propObj);
						//dialJson.put("chartWidth",dialGraphWidth);
						//dialJson.put("chartHeight",dialGraphHeight);

					}
				}
				else if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("No"))
				{
					if(isFusionChart)
					{
						dialSVJson.put("chartName","VLED");
						dialSVJson.put("chartXML",dialXMLData);
						dialSVJson.put("chartWidth",ledGraphWidth);
						dialSVJson.put("chartHeight",ledGraphHeight);
					}
					else
					{
						JSONObject rootPropObj = new JSONObject();
						JSONObject propObj = new JSONObject();
						JSONObject gaugeProp = new JSONObject();
						JSONObject gaugeArray = new JSONObject();
						JSONArray stopsArr = new JSONArray();
						JSONArray stopsObj = new JSONArray();
						if( dialXMLData != null )
						{
							JSONObject splitData = new JSONObject();
							// value,test,descriptor,color
							ArrayList gaugePropList =  com.egurkha.util.StringUtils.egTokenizer( dialXMLData, ",",true,false,true);
							if( gaugePropList != null && gaugePropList.size() > 0 )
							{
								JSONArray dataArray = new JSONArray();
								String dataVal = (String) gaugePropList.get(0);
								String gaugeColor = "#35c8c2";
								Double dd = new Double(dataVal);
								dataArray.add(dd);
								splitData.put("name",(String) gaugePropList.get(2) );
								splitData.put("color",(String) gaugePropList.get(3) );
								splitData.put("subTitle",(String) gaugePropList.get(2) );
								splitData.put("data",dataArray );
								stopsArr.add(dd);
								stopsArr.add(gaugeColor);
								stopsObj.add(stopsArr);
								propObj.put("stopsArr",stopsObj);
								propObj.put("guageData",splitData);
								propObj.put("isVM",new Boolean(isVM));
								//propObj.put("layerModelUrl","dialUrlS"+dialChartCount);
								//propObj.put("layerModelUrlId","dialUrlS"+dialChartCount);
								//propObj.put("goToPage","layerModel");
								//propObj.put("goToPage","layerModel");
								propObj.put("unit","%");
								propObj.put("title",(String) gaugePropList.get(1) );
								propObj.put("subTitle",(String) gaugePropList.get(2) );
							}
						}
						//rootPropObj.put("rootJson ",propObj);
						dialSVJson.put("chartName","AngularGauge");
						dialSVJson.put("chartXML",propObj);
						//dialJson.put("chartWidth",dialGraphWidth);
						//dialJson.put("chartHeight",dialGraphHeight);

					}
				}

				dialCount++;

				if(!isVM)
				{
					dialSVJson.put("dialUrl",layerPageUrl);
				}
				jsonSVInArrList.add(dialSVJson);
			}
			else
			{
				dialmeasuresNAList.add(testmeasure+"#"+(tablesInfo.getUnitForMeasure(s_test,s_measure)));
			}
		}

		if(dialmeasuresNAList!=null && dialmeasuresNAList.size()>0)
		{
			JSONObject dialSVJson = new JSONObject();
			for (int na=0;na < dialmeasuresNAList.size();na++)
			{
				String NAlistdata = (String)dialmeasuresNAList.get(na);
				String testmeasure = NAlistdata.substring(0,NAlistdata.indexOf("#"));
				String unit = NAlistdata.substring(NAlistdata.indexOf("#")+1);

				String dialTitleMapping=iniObj.getValue("Dashboard_Dial_mapping",testmeasure);
				if(dialTitleMapping==null || dialTitleMapping.trim().equals(""))
				{
					String dialTest="";
					String dialMeasure="";
					dialTest = testmeasure.substring(0,testmeasure.indexOf(":"));
					dialMeasure = testmeasure.substring(testmeasure.indexOf(":")+1,testmeasure.length());
					dialTitleMapping=mappingInfo.getMeasureDescription(dialTest,dialMeasure);
				}

				dialSVJson.put("display_Err_Mes",dialTitleMapping+" ("+unit+")");

				dialSVJson.put("measureErrDisplay",mappingInfo.getTextDescription("monitor.dashboard.No Measures available"));

				jsonSVInArrList.add(dialSVJson);
			}
		}
		jsonSV.put("inArrData",jsonSVInArrList);
	}
	else if(module!=null && module.equalsIgnoreCase("uptime") || module.equalsIgnoreCase("JVM Uptime"))
	{
		String test="";
		String  display="";
		String display1="";
		if(module.equalsIgnoreCase("uptime"))
		{
			if(compType!=null && compType.equalsIgnoreCase("Network_node"))
			{
				test="DeviceUptimeTest";
				display="monitor.dashboard.Device Uptime";
				display1="monitor.dashboard.The device has been up for";
			}
			else
			{
				test="UptimeTest";
				display="monitor.dashboard.System Uptime";
				display1="monitor.dashboard.The system has been up for";
			}
		}
		else
		{
			test="JvmUptimeTest";
			display="monitor.dashboard.JVM Uptime";
			display1="monitor.dashboard.JVM has been up for";
		}
		String measure_name="Total_uptime";
		String in_info="+";
		if(from_page!=null && from_page.trim().length()>0 && from_page.equalsIgnoreCase("insideviewDashboard"))
		{
			String inivalue=iniObj.getValue(subject,"System_"+module+"_summary");
			test=inivalue.substring(0,inivalue.indexOf(":"));
			measure_name=inivalue.substring(inivalue.indexOf(":")+1,inivalue.length());
			
			if(s_info!=null && s_info.trim().length()>0 && s_info.startsWith("+"))
			{
				in_info=s_info;
			}
			else if(s_info!=null && s_info.trim().length()>0 && !s_info.startsWith("+"))
			{
				in_info="+"+s_info;
			}
		}

		measure_name=dbInfo.getColumnForMeasure(test,measure_name);

		List agents=egExternalInfo.getAgentsFor(test,compType,hostName);

		if(agents!=null && agents.size()>0)
			msmtHost=(String)agents.get(0);
		else
			msmtHost=hostName;

		String dateDiff="";

		String currentValue=dashboardDAO.getCurrentMeasure(hostName,compType,portNo,in_info,test,measure_name,msmtHost);

		if(currentValue!=null && !currentValue.trim().equals(""))
		{
			long minites=0;
			int secounds=0;

			if(currentValue!=null && currentValue.indexOf(".")>0)
			{
				minites=Long.parseLong(currentValue.substring(0,currentValue.indexOf(".")));
				if(currentValue.substring(currentValue.indexOf(".")+1).length()>2)
					secounds=Integer.parseInt(currentValue.substring(currentValue.indexOf(".")+1,currentValue.indexOf(".")+3));
				else
					secounds=Integer.parseInt(currentValue.substring(currentValue.indexOf(".")+1));

			}
			else
			{
				minites=Long.parseLong(currentValue);
			}
			long valueInSecound=(minites*60)+secounds;
			dateDiff=egDashboard.getDateDifferenceString(valueInSecound);
			if(dateDiff==null || dateDiff.trim().equals(""))
				dateDiff="-";
			dateDiff=com.egurkha.util.StringUtils.replace(dateDiff,"Day","Day(s)");
			dateDiff=com.egurkha.util.StringUtils.replace(dateDiff,"Hrs","Hour(s)");
			dateDiff=com.egurkha.util.StringUtils.replace(dateDiff,"Min","Minute(s)");
			dateDiff=com.egurkha.util.StringUtils.replace(dateDiff,"Sec","Sec(s)");

			jsonSV.put("uptimeTitle",mappingInfo.getTextDescription("monitor.dashboard."+display));
			jsonSV.put("uptimeImg","/final/monitor/eg_images/systemup.png");
			jsonSV.put("uptimeDetails",mappingInfo.getTextDescription("monitor.dashboard."+display1)+" "+dateDiff);
		}
	}
	else if(module!=null && module.equalsIgnoreCase("JVM Memory"))
	{
		String test_name="JvmMemoryDetailsTest";
		String measureForDB=dbInfo.getColumnForMeasure(testName,"Pct_used_memory");

		Vector times=egDashboard.getStartEndDateTimeForCurrent();

		String startTime="";
		String endTime="";
		String startHour="";
		String endHour="";

		if(times!=null && times.size()>=4)
		{
				startTime=(String)times.get(0);
				endTime=(String)times.get(1);
				startHour=(String)times.get(2);
				endHour=(String)times.get(3);
		}

		List agents=egExternalInfo.getAgentsFor(test_name,compType,hostName);

		if(agents!=null && agents.size()>0)
			msmtHost=(String)agents.get(0);
		else
			msmtHost=hostName;

		Vector allInfos=dashboardDAO.getDescriptorsForTest(compName,compType,test_name);
		Vector  heap=new Vector();
		Vector  non_heap=new Vector();

		if(allInfos!=null && allInfos.size()>0)
		{
			for(int k=0;k<allInfos.size();k++)
			{
				String  info=(String)allInfos.get(k);
				if(info.indexOf("(")>0)
				{
					String tmp_info=info.substring(info.indexOf("(")+1,info.length());
					if(tmp_info.startsWith("Heap memory"))
					{
						heap.add(info);
					}
					else
					{
						non_heap.add(info);
					}
				}
			}
		}

		Vector total_infos=new Vector();
		total_infos.addAll(heap);
		total_infos.addAll(non_heap);

		Vector memoryLabels=new Vector();
		memoryLabels.add("ES - Eden Space");
		memoryLabels.add("SS - Servivor Space");
		memoryLabels.add("TG - Turned Gen");
		memoryLabels.add("CC - Code Cache");
		memoryLabels.add("PG - Perm Gen");

		if(allInfos.contains("+Memory Pool_Perm Gen [shared-ro] (Non-heap memory)"))
			memoryLabels.add("PG(ro) - Perm Gen [shared-ro]");

		if(allInfos.contains("+Memory Pool_Perm Gen [shared-rw] (Non-heap memory)"))
			memoryLabels.add("PG(rw) - Perm Gen [shared-rw]");

		jsonSV.put("JVMMemoryUsageTitle",mappingInfo.getTextDescription("monitor.dashboard.Jvm Memory Usage - Summary"));
		JSONArray jsonSVInArrList = new JSONArray();
		if(allInfos!=null && allInfos.size()>0)
		{
			JSONObject headerSVJson = new JSONObject();
			JSONObject dataSVJson = new JSONObject();
			JSONObject hahSVJson = new JSONObject();

			headerSVJson.put("Label_0","");
			for(int i=0;i<memoryLabels.size();i++)
			{
				String label=(String)memoryLabels.get(i);
				if(label!=null && label.indexOf("-")!=-1)
					label=label.substring(0,label.indexOf("-"));
				headerSVJson.put("Label_"+(i+1),mappingInfo.getTextDescription("monitor.dashboard."+label));
			}

			dataSVJson.put("data_0","/final/servlet/com.egurkha.monitor.EgBarGraph?width=40&height=100&graphValue=30.5&labelOnly=true&setBackground=false&monitorSkin="+monitor_Skin);
			for(int i=0;i<total_infos.size();i++)
			{
				String info=(String)total_infos.get(i);
				info="*"+info.substring(1,info.length());

				String currentValue=dashboardDAO.getCurrentMeasure(hostName,compType,portNo,info,testName,measure,msmtHost);
			
				dataSVJson.put("data_"+(i+1),"/final/servlet/com.egurkha.monitor.EgBarGraph?width=30&height=100&graphValue="+currentValue);
				dataSVJson.put("dataTT_"+(i+1),memoryLabels.get(i));
			}

			String info="+Heap Memory Usage";
			String heapValue=dashboardDAO.getCurrentMeasure(hostName,compType,portNo,info,testName,measure,msmtHost);

				if(heapValue==null || heapValue.trim().equals("-5"))
					heapValue="-";
			info="+Non-Heap Memory Usage";
			String nonHeapValue=dashboardDAO.getCurrentMeasure(hostName,compType,portNo,info,testName,measure,msmtHost);
				if(nonHeapValue==null || nonHeapValue.trim().equals("-5"))
					nonHeapValue="-";
			hahSVJson.put("HeapTitle",mappingInfo.getTextDescription("monitor.dashboard.Heap"));
			hahSVJson.put("HeapValue",heapValue);

			hahSVJson.put("NonHeapTitle",mappingInfo.getTextDescription("monitor.dashboard.Non Heap"));
			hahSVJson.put("NonHeapValue",nonHeapValue);

			jsonSVInArrList.add(headerSVJson);
			jsonSVInArrList.add(dataSVJson);
			jsonSVInArrList.add(hahSVJson);
		}
		else
		{
			JSONObject errSVJson = new JSONObject();
			errSVJson.put("errImg","/final/monitor/eg_images/gray/exclamation-icon.gif");
			errSVJson.put("errText",mappingInfo.getTextDescription("monitor.dashboard.No Measures available"));
			jsonSVInArrList.add(errSVJson);
		}

		jsonSV.put("JVMMemoryUsageDetails",jsonSVInArrList);

		jsonSV.put("JVMMemoryMgmTitle",mappingInfo.getTextDescription("monitor.dashboard.Jvm Memory Management - Summary"));

		String detailTest="";
		Vector detailMeasures=new Vector();

		String subsystemDetails=iniObj.getValue(subject,"Application_"+module+"_Details");
		StringTokenizer st=new StringTokenizer(subsystemDetails,",");
		while(st.hasMoreTokens())
		{
			String token=st.nextToken();
			if(token.indexOf(":")!=-1)
			{
				detailTest=token.substring(0,token.indexOf(":"));
				detailMeasures.add(token.substring(token.indexOf(":")+1));
			}
		}

		Vector detailAllInfo=measureGraph.getAllInfoForTest(compType,compName,detailTest);
		jsonSVInArrList = new JSONArray();
		if(detailAllInfo!=null && detailAllInfo.size()>0)
		{
			JSONObject headerSVJson = new JSONObject();
			JSONObject dataSVJson = new JSONObject();
			JSONObject detailsSVJson = new JSONObject();
			headerSVJson.put("garbageCollector",mappingInfo.getTextDescription("monitor.dashboard.Garbage Collector"));
			for(int i=0;i<detailMeasures.size();i++)
			{
				String detailMeasure=(String)detailMeasures.get(i);
				dataSVJson.put("meaHeader_"+i,mappingInfo.getMeasureDescription(test_name,detailMeasure));
			}

			for(int i=0;i<detailAllInfo.size();i++)
			{
				String detailInfo=(String)detailAllInfo.get(i);
				detailInfo=com.egurkha.util.StringUtils.replace(detailInfo,"*","+");
				detailInfo=com.egurkha.util.StringUtils.replace(detailInfo,"|plus|","+");

				String infoForDisp=com.egurkha.util.StringUtils.replace(detailInfo,"+","");
				infoForDisp=com.egurkha.util.StringUtils.replace(infoForDisp,"*","");

				detailsSVJson.put("dispInfo_"+i,infoForDisp);
				JSONObject infoDeSVJson = new JSONObject();

				for(int j=0;j<detailMeasures.size();j++)
				{
					String detailMeasure=(String)detailMeasures.get(j);
					String detailMeasureForDB=dbInfo.getColumnForMeasure(detailTest,detailMeasure);
					String currentValue=dashboardDAO.getCurrentMeasure(hostName,compType,portNo,detailInfo,detailTest,detailMeasure,msmtHost);
					if(!testerInfo.getAllowNegativeValues(detailTest,detailMeasure) && currentValue!=null && currentValue.startsWith("-"))
							currentValue = "-";
					infoDeSVJson.put("infoValue_"+j,currentValue);
				}
				detailsSVJson.put("infoDetails_"+i,infoDeSVJson);
			}
			jsonSVInArrList.add(headerSVJson);
			jsonSVInArrList.add(dataSVJson);
			jsonSVInArrList.add(detailsSVJson);
		}
		else
		{
			JSONObject errSVJson = new JSONObject();

			errSVJson.put("errImg","/final/monitor/eg_images/gray/exclamation-icon.gif");
			errSVJson.put("errText",mappingInfo.getTextDescription("monitor.dashboard.No Measures available"));
			jsonSVInArrList.add(errSVJson);
		}
		jsonSV.put("JVMMemoryMgmDetails",jsonSVInArrList);
	}
	else if(module!=null && module.equalsIgnoreCase("JVM Classes"))
	{
		StringBuffer  legends=new StringBuffer();
		StringBuffer  samples=new StringBuffer();
		StringBuffer  colors=new StringBuffer();
		StringBuffer sampleLabels=new StringBuffer();
		boolean showNoMeasure=true;

		Vector colorsVec=new Vector();
		colorsVec.add("#660066");
		colorsVec.add("#99CC66");
		colorsVec.add("#FFFFCC");

		String  inivalue=iniObj.getValue(subject,"Application_JVM Classes_Summary");
		StringTokenizer tok=new StringTokenizer(inivalue,",");
		int count=0;
		while(tok.hasMoreTokens())
		{
			String token=tok.nextToken();
			if(token.indexOf(":")!=-1)
				measure=token.substring(token.indexOf(":")+1);

			double measureVal=Double.parseDouble((String)allCurrentValues.get(token));

			if(measureVal>0)
			{
				legends.append(measure+" ("+measureVal+")");
				legends.append(",");
				samples.append(measureVal);
				samples.append(",");
				sampleLabels.append(measureVal);
				sampleLabels.append(",");
				colors.append((String)colorsVec.get(count));
				colors.append(",");
				showNoMeasure=false;
			}
			count++;
		}

		String classesLoadedDataPieChart="../servlet/com.objectplanet.chart.ChartServlet?chart=pie&width=300&height=100&sampleValues="+samples.toString()+"&sampleColors="+EgURLEncoder.encode(colors.toString(),"UTF-8")+"&sliceSeperatorColor=white&selectionStyle=detached&multiColorOn=true&pieRotationOn=true&background=white&depth=0.15&angle=45&valueLabelsOn=false&3dModeOn=true&sampleDecimalCount=2&legendOn=true&legendLabels="+legends.toString()+"&gradientSamplesOn=true";

		jsonSV.put("JVMClassesSumTitle",mappingInfo.getTextDescription("monitor.dashboard.JVM Classes - Summary"));

		if(!showNoMeasure)
		{
			jsonSV.put("JVMClassesLoadImgUrl",classesLoadedDataPieChart);
		}
		else
		{
			jsonSV.put("JVMClassesErrImg","/final/monitor/eg_images/gray/exclamation-icon.gif");
			jsonSV.put("JVMClassesErrText",mappingInfo.getTextDescription("monitor.dashboard.No Measures available"));
		}
	}
	else if(module!=null && module.equalsIgnoreCase("JVM Thread"))
	{
		List agents=egExternalInfo.getAgentsFor(ddtest,compType,hostName);

		if(agents!=null && agents.size()>0)
			msmtHost=(String)agents.get(0);
		else
			msmtHost=hostName;

		JSONArray jsonSVInArrList = new JSONArray();

		JSONObject headerSVJson = new JSONObject();

		headerSVJson.put("JVMThread",mappingInfo.getTextDescription("monitor.dashboard.Thread Analysis"));

		headerSVJson.put("JVMAnalysis",mappingInfo.getTextDescription("monitor.dashboard.Analysis By"));
		jsonSVInArrList.add(headerSVJson);
		JSONArray jsonSVTTList = new JSONArray();
		StringTokenizer str=new StringTokenizer(threadsummary,",");
		while(str.hasMoreTokens())
		{
			JSONObject jsonSVTTJson = new JSONObject();
			String option=(String)str.nextToken();
			if(threadType!=null && threadType.equals(option))
			{
				jsonSVTTJson.put("measureValue",option);
				jsonSVTTJson.put("displayMeasures",option);
				jsonSVTTJson.put("selected",threadType);
			}
			else
			{
				jsonSVTTJson.put("measureValue",option);
				jsonSVTTJson.put("displayMeasures",option);
			}
			jsonSVTTList.add(jsonSVTTJson);
		}
		jsonSVInArrList.add(jsonSVTTList);
		SimpleDateFormat  sdf_dd=new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
		String s_startTime_DD=sdf_dd.format(start_Date);
		String Url="/final/monitor/ThreadDetails.jsp?site=NULL&host="+com.eg.EgURLEncoder.encode(hostName,"UTF-8")+"&port="+portNo+"&test="+ddtest+"&msmt_host="+com.eg.EgURLEncoder.encode(msmtHost,"UTF-8")+"&flag=1&firsttime=true&sdate=&sdate="+com.eg.EgURLEncoder.encode(s_startTime_DD,"UTF-8")+"&s_measure="+com.eg.EgURLEncoder.encode(ddmeasure,"UTF-8")+"&s_st_time="+com.eg.EgURLEncoder.encode(s_startDate,"UTF-8")+"&s_en_time="+com.eg.EgURLEncoder.encode(s_endDate,"UTF-8")+"&s_st_hr="+com.eg.EgURLEncoder.encode(s_startHr,"UTF-8")+"&s_en_hr="+com.eg.EgURLEncoder.encode(s_endHr,"UTF-8")+"&s_st_min="+s_startMin+"&s_end_min="+s_endMin;
	
		if(al!=null && al.size()>1)
		{
			JSONObject tddSVJson = new JSONObject();
			tddSVJson.put("threadDetailsUrl",Url);
			tddSVJson.put("threadDetailsImg","/final/monitor/eg_images/stack_trace.gif");
			jsonSVInArrList.add(tddSVJson);
		}

		JSONArray jsonSVDetList = new JSONArray();
		
		if(al!=null && al.size()>1)
		{
			JSONObject tdSVJson = new JSONObject();
			String date=(String)al.get(0);
			ArrayList data=(ArrayList)al.get(1);
			for(int  j=0;j<data.size();j=j+1)
			{
				JSONArray jsonSVDInArrTwo = new JSONArray();
				ArrayList all=(ArrayList)data.get(j);
				for(int j1=0;j1<all.size();j1=j1+12)
				{
					JSONObject tdDataAllSVJson = new JSONObject();
					StringBuffer samples=new StringBuffer();
					StringBuffer  colors=new StringBuffer();
					StringBuffer legendLabels=new  StringBuffer();
					String  cpu_pct=erutils.round (Double.parseDouble((String)all.get(j1+4)),2);
					String  waited_pct=erutils.round (Double.parseDouble((String)all.get(j1+7)),2);
					String  blocked_pct=erutils.round (Double.parseDouble((String)all.get(j1+10)),2);
					double idle_pct=100-(Double.parseDouble(cpu_pct)+Double.parseDouble(waited_pct)+Double.parseDouble(blocked_pct));
					String idle_str=new Double(idle_pct).toString();
					idle_str=erutils.round(Double.parseDouble(idle_str),2);
					if(cpu_pct!=null && !cpu_pct.equals("0") && !cpu_pct.equals("0.0"))
					{
						samples.append(cpu_pct);
						samples.append(",");
						colors.append("0xC0FE70");
						colors.append(",");
						legendLabels.append("%CPU ("+cpu_pct+")");
						legendLabels.append(",");
					}
					if(waited_pct!=null && !waited_pct.equals("0") && !waited_pct.equals("0.0"))
					{
						samples.append(waited_pct);
						samples.append(",");
						colors.append("0xFF83FA");
						colors.append(",");
						legendLabels.append("%Blocked ("+waited_pct+")");
						legendLabels.append(",");
					}
					if(blocked_pct!=null && !blocked_pct.equals("0") && !blocked_pct.equals("0.0"))
					{
						samples.append(blocked_pct);
						samples.append(",");
						colors.append("0xA52A2A");
						colors.append(",");
						legendLabels.append("%Waited ("+blocked_pct+")");
						legendLabels.append(",");
					}
					if(idle_str!=null && !idle_str.equals("0") && !idle_str.equals("0.0"))
					{
						samples.append(idle_str);
						samples.append(",");
						colors.append("0x8E9967A");
						colors.append(",");
						legendLabels.append("%Idle ("+idle_str+")");
						legendLabels.append(",");
					}
					String str_sample=samples.toString();
					String  str_color=colors.toString();
					String legend_str=legendLabels.toString();
					if(str_sample.endsWith(","))
						str_sample=str_sample.substring(0,str_sample.lastIndexOf(",")+1);
					if(str_color.endsWith(","))
						str_color=str_color.substring(0,str_color.lastIndexOf(",")+1);
					if(legend_str.endsWith(","))
						legend_str=legend_str.substring(0,legend_str.lastIndexOf(",")+1);

					String graphurl="../servlet/com.objectplanet.chart.ChartServlet?chart=pie&width=200&height=150&sampleValues="+str_sample+"&sampleColors="+str_color+"&sliceSeperatorColor=white&multiColorOn=true&background=white&depth=0.10&angle=15&valueLabelsOn=false&3dModeOn=true&sampleDecimalCount=2&legendOn=true&legendLabels="+EgURLEncoder.encode(legend_str,"UTF-8")+"&gradientSamplesOn=true";

					tdDataAllSVJson.put("data_"+j1,(String)all.get(j1));

					if(!str_sample.equals(""))
					{
						tdDataAllSVJson.put("dataUrl_"+j1,graphurl);
					}
					else
					{
						tdDataAllSVJson.put("dataErrImg_"+j1,"/final/monitor/eg_images/gray/exclamation-icon.gif");
						tdDataAllSVJson.put("dataErr_"+j1,mappingInfo.getTextDescription("monitor.dashboard.No Measures available"));
					}

					StringTokenizer lines=new StringTokenizer((String)all.get(j1+11),";");
					int colorCount = 0;
					JSONArray jsonSVDInnList = new JSONArray();
					while(lines.hasMoreTokens())
					{
						jsonSVDInnList.add((String)lines.nextToken());
						colorCount++;
					}
					tdDataAllSVJson.put("datArr_"+j1,jsonSVDInnList);

					jsonSVDInArrTwo.add(tdDataAllSVJson);
				}
				tdSVJson.put("indata_"+j,jsonSVDInArrTwo);
			}
			jsonSVDetList.add(tdSVJson);
		}
		else
		{
			JSONObject tdSVJson = new JSONObject();
			tdSVJson.put("tdErrImg","/final/monitor/eg_images/gray/exclamation-icon.gif");
			tdSVJson.put("tdErrText",mappingInfo.getTextDescription("monitor.dashboard.No detailed Measures available"));
			jsonSVDetList.add(tdSVJson);
		}

		jsonSVInArrList.add(jsonSVDetList);

		jsonSV.put("JVMThreadDetails",jsonSVInArrList);
	}
	response.getWriter().write(jsonSV.toString());
}
catch(Exception ex)
{
	ex.printStackTrace();
}
%>
