<%@ page language="java" contentType="applications/json;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EgServerDashboardTracker.jsp"%>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="com.eg.*"%>
<%@ page import="java.text.*"%>
<%@ page import="com.egurkha.util.DateTimeTokenizer"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "egurkha.reporter.ErUtils"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "egurkha.reporter.ErUtils"%>
<%@ page import = "com.egurkha.util.MathUtils"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
try
{
	JSONObject rootJson = new JSONObject();
	JSONObject hiddens = new JSONObject();
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniObj=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");

	IniUI iniUI = IniUI.getInstance();
	String currentDateFormat = iniUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	
	EgGraphsUtil graphUtil=new EgGraphsUtil(trackerLanguage);
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTesterInfo testerInfo=new EgTesterInfo("manager");
	EgDisableInfo disableInfo = new EgDisableInfo("manager");
	
	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	EgMeasureGraphExt measureGraphInfo = new EgMeasureGraphExt();
	DateTimeTokenizer dtd = new DateTimeTokenizer();

	EgServerDashboardModel  egDashboard=new  EgServerDashboardModel();
	EgServerDashboardMGraphModel measureGraph=new EgServerDashboardMGraphModel();

	EgFusionChartUtil fusionChart=new EgFusionChartUtil();
	MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorDaoFactory.getServerDashBoardDAO();
	MeasuresDAO MeasuresDao = monitorDaoFactory.getMeasuresDAO();
	String sub="Search_Option";
	String searchavail=iniObj.getValue(sub,"NodeAvailable");
	int searchavailable = Integer.parseInt(searchavail);

	ErUtils erutils=new ErUtils();

	String subject=request.getParameter("subject");
	String tab=request.getParameter("tab");

	if(tab==null)
		tab="Application";

	String compName=request.getParameter("hostName");
	String compType=request.getParameter("compType");
	String subsystem=request.getParameter("subsystem");
	
	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);
	ArrayList getExcludedTest = disableInfo.getExcludedTestsForComponent(compName,compType);

	String hostName="";
	String portNo="";
	String sid="";
	String startTime="";
	String endTime="";
	String startHour="";
	String endHour="";
	String startMin="";
	String endMin="";
	String startSec="";
	String endSec="";
	String startDateTime="";
	String endDateTime="";
	String state="";
	String info="";
	String msmtHost="";
	String test="";
	String measure="";
	String selectstring="";

	long HOUR=60*60*1000;
	long DAY=24*60*60*1000;

	String hostNames[]=request.getParameterValues("hostName");
	if(hostNames!=null)
	{
		for(int i=0;i<hostNames.length;i++)
		{
			if(hostNames[i]!=null && hostNames[i].indexOf(":")!=-1)
			{
				compName=hostNames[i];
				break;
			}
		}
	}

	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}

	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);

	boolean isSystemTab=(tab!=null && tab.equalsIgnoreCase("System"));
	boolean isNetworkTab=(tab!=null && tab.equalsIgnoreCase("Network"));
	boolean isApplicationTab=(tab!=null && tab.equalsIgnoreCase("Application"));

	boolean ddEnabled=EgMemInfo.ddEnabled;

	if(isSystemTab)
	{
		subject="System_Dashboard_Metrics";
	}
	else if(isNetworkTab)
	{
		subject="Network_Dashboard_Metrics";
	}
	else
	{
		subject=compType;
	}

	String s_specificsubject=iniObj.getValue("CommonDashboardConiguration",compType);

	if((isSystemTab || isNetworkTab) && s_specificsubject!=null && s_specificsubject.equalsIgnoreCase("yes"))
	{
		subject=compType;
	}

	egDashboard.setSubject(subject);


	SimpleDateFormat  sdf=new SimpleDateFormat("MM/dd/yyyy HH:mm");
	SimpleDateFormat sf=new SimpleDateFormat("MM/dd/yyyy");
	SimpleDateFormat sf1=new SimpleDateFormat("dd/MM/yyyy HH:mm");
	SimpleDateFormat testTableDateFmt=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	java.util.Date end_Date=new java.util.Date();
	java.util.Date start_Date=new java.util.Date(end_Date.getTime()-(HOUR));
	java.util.Date start_DateForDay=new java.util.Date(end_Date.getTime()-(DAY));

	String s_startTime=sdf.format(start_Date);
	String s_startTimeForDay=sdf.format(start_DateForDay);
	String s_endTime=sdf.format(end_Date);

	String fromCitrixApplication=request.getParameter("fromCitrixApplication");
	boolean isFromCitrixApplication=(fromCitrixApplication!=null && fromCitrixApplication.equalsIgnoreCase("true"));
	String user=request.getParameter("selectedInfo");
	String graphType="citrixuser";
	if(isFromCitrixApplication)
	{
		graphType="citrixapps";
	}
	if(!isFromCitrixApplication)
	{
		JSONObject citrixUserObj = new JSONObject();
		if(user!=null && !user.equalsIgnoreCase("undefined") && !user.trim().equalsIgnoreCase("null") && !user.startsWith("+"))
			user="+"+user.trim();
		
		String testName = "";
		if(compType.equalsIgnoreCase("Citrix_server"))
		{
			testName="CtxXpUserTest";				
		}
		else if(compType.equalsIgnoreCase("Citrix_XcXenApp_server"))
		{
			testName="CtxXcXAUserTest";				
		}
		boolean isExcludedTest = false;
		if(getExcludedTest!=null && getExcludedTest.contains(testName))
			isExcludedTest = true;
		if(enabledTests!=null && enabledTests.contains(testName) && !isExcludedTest)
		{
			Vector ctxUsers=(Vector)allTestInfos.get(testName);
			selectstring=request.getParameter("selectstring");//noorul

		Vector infoselect=new Vector();
	if(selectstring!=null && !selectstring.equals(""))
	{
		if(!selectstring.startsWith("*") && !selectstring.contains("*"))
		{
			for(int i=0;i<ctxUsers.size();i++)
			{
				String infor=(String)ctxUsers.get(i);
				String infosearch = infor.toLowerCase();
				selectstring = selectstring.toLowerCase();
				if(infosearch.indexOf(selectstring)!=-1)
				{
				infoselect.add(infor);
				}
			}
		}
		else if(selectstring.startsWith("*"))
		{
			for(int i=0;i<ctxUsers.size();i++)
			{
				String infor=(String)ctxUsers.get(i);
				infor=infor.substring(infor.indexOf("+")+1,infor.length());
				String infosearch = infor.toLowerCase();
				String selects=selectstring.substring(selectstring.indexOf("*")+1,selectstring.length());
				selects = selects.toLowerCase();
				boolean infose=infosearch.startsWith(selects);
				if(infose==true)
				{
					infoselect.add(infor);
				}
			}
		}
		else if(selectstring.endsWith("*"))
		{
			for(int i=0;i<ctxUsers.size();i++)
			{
				String infor=(String)ctxUsers.get(i);
				infor=infor.substring(infor.indexOf("+")+1,infor.length());
				String infosearch = infor.toLowerCase();
				String selects=selectstring.substring(0,selectstring.indexOf("*"));
				selects = selects.toLowerCase();
				boolean infose=infosearch.endsWith(selects);
				if(infose==true)
				{
					infoselect.add(infor);
				}
			}
		}
	}
		if(ctxUsers!=null && ctxUsers.size()>0)
		{
			if(selectstring!=null && !selectstring.equals(""))
			{
				String fla="citrix";
%>
<table border="0" bordercolor="green" class="padding4" cellpadding="0" cellspacing="0" width="100%" height="100%">
	<tr>
		<td width="20%" align="left" valign="top" style="padding-right:0px">
			<table width="100%" cellpadding="0" cellspacing="0" border="0" class="vm  border">
				<tr>
					<td width="100%" class="tdborder2_jvm"> 
						<div id="citrixUserDiv" class="div_scroll" style="width:100%;border:0px solid #ff0000">
								<div id="searchdiv">
									<table cellpadding="2" cellspacing="0" border="0" width="100%">
										<tr>
											<td align="right" class="eg_75bold">
												<a id="eg_monlink" onClick='searchBack("<%=fla%>");' style="cursor:pointer">
												<img src='/final/monitor/eg_images/back-arrow.gif' border='0'>
												&nbsp;<egui:intnl text="monitor.dashboard.All Users"/>
												</a>
											</td>
										</tr>
									</table>
								</div>
							<div class="dtree">
								<div id="dd0" class="clip" style="border: 0px solid rgb(255, 0, 0);">
									<div class="dTreeNode" style="font-size: 7.5pt; color: rgb(0, 0, 0);" oncontextmenu="return false;">
										<img class="png" id="id1" src="/final/monitor/eg_images/users.png" alt="" border="0">
										<span><b>Citrix Users</b></span>
									</div>
<%
				for(int i=0;i<infoselect.size();i++)
				{
					String ctinfo=(String)infoselect.get(i);
				if(user==null || user.trim().equals("") || user.trim().equalsIgnoreCase("null") || user.equalsIgnoreCase("undefined"))
					user=ctinfo;

				boolean isSelectedUser=false;
				if(user!=null && user.equals(ctinfo))
					isSelectedUser=true;
%>
									<div id="dd1" class="clip" style="border: 0px solid rgb(255, 0, 0); display: block;">
										<div class="dTreeNode"  oncontextmenu="return false;">
<%
				if(i==infoselect.size()-1)
				{
%>
										<img src="/final/admin/eg_images/tree/joinbottom.gif" alt="">
<%
				}
				else
				{
%>
										<img src="/final/admin/eg_images/tree/join.gif" alt="">
<%
				}
%>
										<img class="png" id="id2"src="/final/monitor/eg_images/user.png" alt="" border="0">
										<span><a class="<%=(isSelectedUser)?"nodeSel eg_monlink mouse":"eg_monlink mouse"%>" onclick="javascript:changeGraphType1('<%=subsystem%>','<%=tab%>','citrixuser','true','','','<%=(String)ctxUsers.get(i)%>','<%=selectstring%>')"><%=com.egurkha.util.StringUtils.replace((String)infoselect.get(i),"+","")%></a>
										</span>
										</div>
									</div>
<%
			}
			}
			else
			{
				JSONObject parentObj = new JSONObject();				
				parentObj.put("text", mappingInfo.getTextDescription("monitor.dashboard.Citrix Users"));
				parentObj.put("expanded", "true");
				parentObj.put("leaf", "false");
				JSONArray childArr = new JSONArray();
				for(int i=0;i<ctxUsers.size();i++)
				{
					JSONObject childObj = new JSONObject();
					String tempUser=(String)ctxUsers.get(i);
					if(user==null || user.trim().equals("") || user.trim().equalsIgnoreCase("null") || user.equalsIgnoreCase("undefined"))
						user=tempUser;

					boolean isSelectedUser=false;
					if(user!=null && user.equals(tempUser))
					{
						isSelectedUser=true;
						citrixUserObj.put("SELECTED_NODE",user);
					}
						
					if(i==ctxUsers.size()-1)
					{
					}
					else
					{
					}
					childObj.put("text", com.egurkha.util.StringUtils.replace((String)ctxUsers.get(i),"+",""));
					childObj.put("leaf", "true");
					childObj.put("URL", "/final/monitor/egCitrixUsersJSON.jsp?hostName="+EgURLEncoder.encode(compName, "UTF-8")+"&compType="+EgURLEncoder.encode(compType,"UTF-8")+"&tab=Application&subsystem=CitrixUsers&selectedInfo="+EgURLEncoder.encode(tempUser,"UTF-8")+"&selectstring=");
					childArr.add(childObj);
				}
				parentObj.put("children", childArr);

					JSONObject treeRootObj = new JSONObject();
					JSONArray treeRootArr = new JSONArray();
					treeRootArr.add(parentObj);
					treeRootObj.put("children", treeRootArr);
					JSONObject rootObj = new JSONObject();
					rootObj.put("root", treeRootObj);
					citrixUserObj.put("TREE", rootObj);
				}
				String descriptor=com.egurkha.util.StringUtils.replace(user,"+","");
				String s_circleIniVal=iniObj.getValue(subject,"Application_Overview_CircleChart");
				String isThresholdNeed=iniObj.getValue("Dashboard_Settings","ApplyThreshold");
				Vector circleTestMeasures=egDashboard.getTokensAsVector(s_circleIniVal,",");
				JSONArray angularArr = new JSONArray();
				Vector chartAttributes1=new Vector();
				double dialGraphWidth=150;  
				double dialGraphHeight=150;
				double defaultDialGraphWidth=191;  // default dial graph width for calculation
				double defaultDialGraphHeight=115;  // default dial graph height for calculation
				String layerName=dashboardDAO.getLayerForTest(compType,test,measure);
				for(int i=0;i<circleTestMeasures.size();i++)
				{
					JSONObject angularObj = new JSONObject();
					String tempTestMeasure=(String)circleTestMeasures.get(i);
					test=tempTestMeasure.substring(0,tempTestMeasure.indexOf(":"));
					measure=tempTestMeasure.substring(tempTestMeasure.indexOf(":")+1);
					
					if(enabledTests!=null && !enabledTests.contains(test))
						continue;
					if(getExcludedTest!=null && getExcludedTest.contains(test))
						continue;

				msmtHost=(String)allMsmtHosts.get(test);

				String measureForDB=dbInfo.getColumnForMeasure(test,measure);
				String info1=com.egurkha.util.StringUtils.replace(user,"|plus|","+");
				String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage="+tab+"_Dashboard&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site=NULL&test="+test+"-"+info1+"&tstate=&msmt_host=&backNav=cmpDashboard";
				String dialXMLData=graphUtil.getXMLDataForDial(test,measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,chartAttributes1,"000000",info1,dialGraphWidth,dialGraphHeight,defaultDialGraphWidth,defaultDialGraphHeight,layerPageUrl);
			String user_test="CtxXpUserTest";
			//	String measureValue=dashboardDAO.getCurrentMeasure(hostName,portNo,com.egurkha.util.StringUtils.replace(user,"|plus|","+"),test,measureForDB,msmtHost);

				String measureMapping=iniObj.getValue("Dashboard_measures_mapping",test+":"+measure);

				if(measureMapping==null || measureMapping.trim().equals(""))
					measureMapping=mappingInfo.getMeasureDescription(test,measure);

			/*	Vector chartAttributes=new Vector();

				chartAttributes.add("bgColor='FFFFFF'");
				chartAttributes.add("upperLimit='100'");
				chartAttributes.add("lowerLimit='0'");
				chartAttributes.add("baseFontColor='FFFFFF'");
				chartAttributes.add("majorTMNumber='11'");
				chartAttributes.add("majorTMColor='FFFFFF'");
				chartAttributes.add("majorTMHeight='8'");
				chartAttributes.add("minorTMNumber='4'");
				chartAttributes.add("minorTMColor='FFFFFF'");
				chartAttributes.add("minorTMHeight='3'");
				chartAttributes.add("toolTipBorderColor='FFFFFF'");
				chartAttributes.add("toolTipBgColor='333333'");
				chartAttributes.add("gaugeOuterRadius='55'");
				chartAttributes.add("gaugeOriginX='80'");
				chartAttributes.add("gaugeOriginY='80'");
				chartAttributes.add("gaugeScaleAngle='270'");
				chartAttributes.add("placeValuesInside='1'");
				chartAttributes.add("gaugeInnerRadius='90%25'");
				chartAttributes.add("annRenderDelay='1'");
				chartAttributes.add("gaugeFillMix=''");
				chartAttributes.add("pivotRadius='8'");
				chartAttributes.add("showPivotBorder='0'");
				chartAttributes.add("pivotFillMix='{CCCCCC},{333333}'");
				chartAttributes.add("pivotFillRatio='20,80'");
				chartAttributes.add("showShadow='0'");
				chartAttributes.add("showBorder='0'");
				chartAttributes.add("baseFontSize='8'");

				chartAttributes.add("chartLeftMargin='0'");
				chartAttributes.add("chartRightMargin='0'");
				chartAttributes.add("chartTopMargin='0'");
				chartAttributes.add("chartBottomMargin='0'");


				String xmlForSteeCase=fusionChart.getXMLForSteelCase(measureValue,chartAttributes);*/
				String unitMapping = graphUtil.getUnitMapping(tablesInfo.getUnitForMeasure(test,measure));
				angularObj.put("TITLE", measureMapping+"("+unitMapping+")");
				angularObj.put("subTitle_Dial", info1);
				angularObj.put("HEIGHT", "180");
				angularObj.put("WIDTH", "210");
				angularObj.put("XML_DATA", dialXMLData);
				angularObj.put("SWF_PATH", "/final/FusionCharts/swf/AngularGauge.swf");
				if ( !angularObj.isEmpty() )
				{
					angularArr.add(angularObj);
				}
			}
			if ( !angularArr.isEmpty() )
			{
				citrixUserObj.put("ANGULAR", angularArr);
			}

			String user_test="CtxXpUserTest";

			String s_lastMsmtTime=dashboardDAO.lastMeasurementTimeForTest(compType,hostName,test,tab);

			Date lastMsmtTime=new Date();
			if(s_lastMsmtTime!=null && !s_lastMsmtTime.trim().equals(""))
				lastMsmtTime=testTableDateFmt.parse(s_lastMsmtTime);
			else
				s_lastMsmtTime=testTableDateFmt.format(lastMsmtTime);

			lastMsmtTime.setHours(lastMsmtTime.getHours()-1);

			startTime=sf1.format(lastMsmtTime);

			String s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
			Vector vec_times=egDashboard.getTokensAsVector(s_timeonly,":");

			startHour=lastMsmtTime.getHours()+"";
			startMin=lastMsmtTime.getMinutes()+":"+lastMsmtTime.getSeconds();

			lastMsmtTime.setHours(lastMsmtTime.getHours()+1);
			lastMsmtTime.setMinutes(lastMsmtTime.getMinutes()+1);
			endTime=sf1.format(lastMsmtTime);

			s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
			vec_times=egDashboard.getTokensAsVector(s_timeonly,":");

			endHour=lastMsmtTime.getHours()+"";
			endMin=lastMsmtTime.getMinutes()+":"+lastMsmtTime.getSeconds();


				String s_BarIniVal=iniObj.getValue(subject,"Application_Overview_BarChart");
				Vector barTestMeasures=egDashboard.getTokensAsVector(s_BarIniVal,",");
				JSONArray cylinderArr = new JSONArray();
				for(int i=0;i<barTestMeasures.size();i++)
				{
					JSONObject cylinderObj = new JSONObject();
					String tempTestMeasure=(String)barTestMeasures.get(i);
					test=tempTestMeasure.substring(0,tempTestMeasure.indexOf(":"));
					measure=tempTestMeasure.substring(tempTestMeasure.indexOf(":")+1);
					if(enabledTests!=null && !enabledTests.contains(test))
						continue;
					if(getExcludedTest!=null && getExcludedTest.contains(test))
						continue;
					msmtHost=(String)allMsmtHosts.get(test);

				String measureForDB=dbInfo.getColumnForMeasure(test,measure);
				Hashtable  measData=measureGraph.getCurrentMeasureForgraph(compName,compType,test,measureForDB,com.egurkha.util.StringUtils.replace(user,"|plus|","+"),startTime,endTime,msmtHost,portNo,"NULL");

				double minValue=0;
				double maxValue=1;
				double currValue=0;
				String measureValue=(String)measData.get("currentValue");
				boolean isMeasureAvailable=(measureValue!=null && !measureValue.trim().equals("") && ((!measureValue.trim().equals("-5") && !measureValue.trim().equals("-1") && !testerInfo.getAllowNegativeValues(test,measure)) || (testerInfo.getAllowNegativeValues(test,measure))));	
				if(isMeasureAvailable && measData!=null && measData.size()>0)
				{
					maxValue=Double.parseDouble((String)measData.get("max"));
					currValue=Double.parseDouble(measureValue);
				}
				if(currValue<0.00)
				{
					if(!testerInfo.getAllowNegativeValues(test,measure))
						continue;
				}
				
			//	String measureValue=dashboardDAO.getCurrentMeasure(hostName,portNo,com.egurkha.util.StringUtils.replace(user,"|plus|","+"),test,measureForDB,msmtHost);

				String measureMapping=iniObj.getValue("Dashboard_measures_mapping",test+":"+measure);

				if(measureMapping==null || measureMapping.trim().equals(""))
					measureMapping=mappingInfo.getMeasureDescription(test,measure);

					String unitForMeasure=tablesInfo.getUnitForMeasure(test,measure);

					String unitMapping = graphUtil.getUnitMapping(unitForMeasure);
					cylinderObj.put("TITLE", measureMapping+"("+unitMapping+")");
					
					if(testerInfo.getAllowNegativeValues(test,measure) && isMeasureAvailable)
					{
						measureValue=com.egurkha.util.StringUtils.replace(measureValue,"+","");
					}
					JSONArray cylinderDataSeriesArr=new JSONArray();
					if(isMeasureAvailable)
					{
						if(unitForMeasure!=null && unitForMeasure.equalsIgnoreCase("number"))
						{
							if(maxValue<3)
							{
								maxValue=3.0;
							}
							else
							{
								maxValue=MathUtils.round(maxValue,0);
							}
						}
						double tickInterval=10.0;
						if(maxValue<=0.0)
						{
							maxValue=1.0;
							tickInterval=0.25;
						}
						else if(maxValue<=10.0)
						{
							tickInterval=1;
						}

						if((unitForMeasure!=null) && (unitForMeasure.equalsIgnoreCase("percentage")|| unitForMeasure.equals("%")))
							maxValue=100.0f;

						String valSeriesColorCode="#145A32";
						String maxSeriesColorCode="#E5E8E8";
						if(monitor_Skin!=null && monitor_Skin.equalsIgnoreCase("dark"))
						{
							valSeriesColorCode="#145A32 ";
							maxSeriesColorCode="#595959";
						}
						JSONObject toolTipObj=new JSONObject();
						toolTipObj.put("text","");
						JSONArray maxDataArr=new JSONArray();
						maxDataArr.add(new Double(maxValue));
						JSONObject maxDataObj=new JSONObject();
						maxDataObj.put("TITLE", measureMapping+"("+unitMapping+")");
						maxDataObj.put("data",maxDataArr);
						maxDataObj.put("name","MAX_"+measureMapping+"("+unitMapping+")");
						maxDataObj.put("color",maxSeriesColorCode);
						maxDataObj.put("showLegend","false");
						maxDataObj.put("showTooltip","false");
						maxDataObj.put("tooltip",toolTipObj);
						maxDataObj.put("enableMouseTracking","false");
						maxDataObj.put("maxVal",new Double(maxValue));
					//	maxDataObj.put("minVal",new Double(minValue));
						maxDataObj.put("tickInterval",new Double(tickInterval));
						cylinderDataSeriesArr.add(maxDataObj);

						JSONArray dataArr=new JSONArray();
						String measValStr=erutils.round(currValue,2);
						dataArr.add(new Double(measValStr));
						cylinderObj.put("data",dataArr);
						cylinderObj.put("name",measureMapping+"("+unitMapping+")");
						cylinderObj.put("color","#35C8C2");
						cylinderObj.put("showLegend","false");
						cylinderObj.put("showTooltip","true");
						cylinderObj.put("maxVal",new Double(maxValue));
						cylinderObj.put("minVal",new Double(minValue));
						cylinderObj.put("tickInterval",new Double(tickInterval));
						cylinderDataSeriesArr.add(cylinderObj);
						
						
						
					}
					if ( !cylinderDataSeriesArr.isEmpty() )
					{
						cylinderArr.add(cylinderDataSeriesArr);
					}
				}
				if ( !cylinderArr.isEmpty() )
				{
					citrixUserObj.put("CYLINDER", cylinderArr);
				}
				JSONObject sessSummaryObj = new JSONObject();
				sessSummaryObj.put("TITLE", mappingInfo.getTextDescription("monitor.dashboard.Citrix Sessions-Summary"));
				String ddtest="";
				if(compType.equalsIgnoreCase("Citrix_server"))
				{
					ddtest="CtxSessionTest";				
				}
				else if(compType.equalsIgnoreCase("Citrix_XcXenApp_server"))
				{
					ddtest="CtxXcXASessionTest";				
				}
				
				JSONArray sesValArr = new JSONArray();
				JSONObject sesValObj = new JSONObject();

				isExcludedTest = false;
				if(getExcludedTest!=null && getExcludedTest.contains(ddtest))
					isExcludedTest = true;
				String ddmeasure="";
				String flag="1";
				String desc="+";
				String colNamesForQuery="Username,Idle_time,Logon_time";

				if(enabledTests!=null && enabledTests.contains(ddtest) && !isExcludedTest)
				{
					ddmeasure="Active_sessions";
					msmtHost=(String)allMsmtHosts.get(ddtest);

			EgDiagnosisBean dd=new EgDiagnosisBean();
			dd.getDescription(ddtest,ddmeasure);


			s_lastMsmtTime=measureGraph.getLastRuntimeForDDTest(ddtest,ddmeasure,hostName,portNo,"NULL",desc,msmtHost);

			lastMsmtTime=new java.util.Date();
			if(s_lastMsmtTime!=null && !s_lastMsmtTime.trim().equals(""))
				lastMsmtTime=testTableDateFmt.parse(s_lastMsmtTime);
			else
				s_lastMsmtTime=testTableDateFmt.format(lastMsmtTime);

			startTime=sf.format(lastMsmtTime);
			endTime=sf.format(lastMsmtTime);

			s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
			vec_times=egDashboard.getTokensAsVector(s_timeonly,":");

			startHour=(String)vec_times.get(0);
			endHour=(String)vec_times.get(0);
			startMin=(String)vec_times.get(1);
			endMin=(String)vec_times.get(1);

			int i_endMin=Integer.parseInt(endMin)+1;
			endMin=i_endMin+"";

			ArrayList a_results=dd.getDiagnosisData(hostName,portNo,"NULL",ddtest,ddmeasure,desc,startTime,endTime, startHour, endHour,startMin+":"+lastMsmtTime.getSeconds(),endMin+":"+lastMsmtTime.getSeconds(),flag,colNamesForQuery,msmtHost);

			ArrayList allDatas=new ArrayList();
			if(a_results.size()>=2)
			{
				allDatas=(ArrayList)a_results.get(1);
			}

			ArrayList headers=new ArrayList();
			//headers.add("Username");
			headers.add(mappingInfo.getTextDescription("monitor.dashboard.Idletime"));
			headers.add(mappingInfo.getTextDescription("monitor.dashboard.Login time"));

					for(int i=0;i<allDatas.size();i++)
					{
						ArrayList singleData=(ArrayList)allDatas.get(i);

						if(singleData!=null && singleData.contains(descriptor))
						{
							singleData.remove(descriptor);
							for(int j=0;j<singleData.size();j++)
							{
								sesValObj = new JSONObject();
								sesValObj.put("COLUMN_0", mappingInfo.getTextDescription("monitor.dashboard."+(String)headers.get(j)));
								sesValObj.put("COLUMN_1", (String)singleData.get(j));
								sesValArr.add(sesValObj);
							}
							break;
						}
					}
				}

				boolean isDataAvail=false;
				
				ddmeasure="Quick_reconnects";
				if(compType.equalsIgnoreCase("Citrix_server"))
				{
					ddtest="CtxDisconnectsTest";				
				}
				else if(compType.equalsIgnoreCase("Citrix_XcXenApp_server"))
				{
					ddtest="CtxXcXADisconnTest";				
				}
				isExcludedTest = false;
				if(getExcludedTest!=null && getExcludedTest.contains(ddtest))
					isExcludedTest = true;
				if(enabledTests!=null && enabledTests.contains(ddtest) && !isExcludedTest)
				{
					msmtHost=(String)allMsmtHosts.get(ddtest);

			EgDiagnosisBean dd1=new EgDiagnosisBean();
			dd1.getDescription(ddtest,ddmeasure);

			s_lastMsmtTime=measureGraph.getLastRuntimeForDDTest(ddtest,ddmeasure,hostName,portNo,"NULL",desc,msmtHost);

			if(s_lastMsmtTime!=null && !s_lastMsmtTime.trim().equals(""))
				lastMsmtTime=testTableDateFmt.parse(s_lastMsmtTime);
			else
				s_lastMsmtTime=testTableDateFmt.format(lastMsmtTime);

			startTime=sf.format(lastMsmtTime);
			endTime=sf.format(lastMsmtTime);

			s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
			vec_times=egDashboard.getTokensAsVector(s_timeonly,":");

			startHour=(String)vec_times.get(0);
			endHour=(String)vec_times.get(0);
			startMin=(String)vec_times.get(1);
			endMin=(String)vec_times.get(1);

					int i_endMin=Integer.parseInt(endMin)+1;
					endMin=i_endMin+"";

					ArrayList a_results=dd1.getDiagnosisData(hostName,portNo,"NULL",ddtest,ddmeasure,desc,startTime,endTime, startHour, endHour,startMin+":"+lastMsmtTime.getSeconds(),endMin+":"+lastMsmtTime.getSeconds(),flag,"",msmtHost);

			ArrayList tempList=new ArrayList();
			if(a_results.size()>=2)
			{
				tempList=(ArrayList)a_results.get(1);
			}

			for(int i=0;i<tempList.size();i++)
			{
				ArrayList disconnectDDData=new ArrayList();

				if(tempList.get(i) instanceof ArrayList)
					disconnectDDData=(ArrayList)tempList.get(i);
				else if(tempList.get(i) instanceof String)
				{
					String tempStr=(String)tempList.get(i);
					disconnectDDData.addAll(egDashboard.getTokensAsVector(tempStr,"~!~"));
				}

				if(disconnectDDData!=null && disconnectDDData.contains(descriptor) && disconnectDDData.size()>4)
				{
					sesValObj = new JSONObject();
					sesValObj.put("COLUMN_0", mappingInfo.getTextDescription("monitor.dashboard.Client Type"));
					sesValObj.put("COLUMN_1", (String)disconnectDDData.get(2));
					sesValArr.add(sesValObj);

					sesValObj = new JSONObject();
					sesValObj.put("COLUMN_0", mappingInfo.getTextDescription("monitor.dashboard.Disconnected Time"));
					sesValObj.put("COLUMN_1", (String)disconnectDDData.get(3));
					sesValArr.add(sesValObj);

							sesValObj = new JSONObject();
							sesValObj.put("COLUMN_0", mappingInfo.getTextDescription("monitor.dashboard.Disconnected Duration"));
							sesValObj.put("COLUMN_1", (String)disconnectDDData.get(4));
							sesValArr.add(sesValObj);
							isDataAvail=true;
							break;
						}
					}
				}

				ddmeasure="No_of_sessions";
				if(compType.equalsIgnoreCase("Citrix_server"))
				{
					ddtest="CtxXpUserTest";				
				}
				else if(compType.equalsIgnoreCase("Citrix_XcXenApp_server"))
				{
					ddtest="CtxXcXAUserTest";				
				}
				
				isExcludedTest = false;
				if(getExcludedTest!=null && getExcludedTest.contains(ddtest))
					isExcludedTest = true;
				if(enabledTests!=null && enabledTests.contains(ddtest) && !isExcludedTest)
				{
					String infoForBilling=user;
					long userDuration=egDashboard.getCitrixUserDuration(compType,hostName,portNo,ddtest,infoForBilling,s_startTimeForDay,s_endTime);

			String userDurationStr=egDashboard.getDateDifferenceString(userDuration);

			if(userDurationStr==null || userDurationStr.trim().equals(""))
				userDurationStr="-";
			sesValObj = new JSONObject();
			sesValObj.put("COLUMN_0", mappingInfo.getTextDescription("monitor.dashboard.Total Connection Time(24 hours)"));
			sesValObj.put("COLUMN_1", userDurationStr);
			sesValArr.add(sesValObj);
			if ( !sesValArr.isEmpty() )
			{
				sessSummaryObj.put("TABLE_VALUES", sesValArr);
			}
			citrixUserObj.put("CITRIX_USER_SESSION_SUMMARY", sessSummaryObj);

			colNamesForQuery="PID,ProcName,Cpu_util,Memory_util,IO_reads,IO_writes,Page_faults,Virtual_memory,Handles,Published_dname";

			String ddTimeline="1 hour";
			Vector times=egDashboard.getStartEndDateTimeForMeasure(ddTimeline);

			if(times!=null && times.size()>=4)
			{
				startTime=(String)times.get(0);
				endTime=(String)times.get(1);
				startHour=(String)times.get(2);
				endHour=(String)times.get(3);
			}

				msmtHost=(String)allMsmtHosts.get(ddtest);

				EgDiagnosisBean dd2=new EgDiagnosisBean();
				dd2.getDescription(ddtest,ddmeasure);

					String userTitle=mappingInfo.getTextDescription("monitor.dashboard.Citrix User Applications Summary");
					JSONObject CitrixUserAppObj = new JSONObject();
					CitrixUserAppObj.put("TITLE", userTitle);

					ArrayList a_results=dd2.getDiagnosisData(hostName,portNo,"NULL",ddtest,ddmeasure,user,startTime,endTime, startHour, endHour,end_Date.getMinutes()+":"+end_Date.getSeconds(),end_Date.getMinutes()+":"+end_Date.getSeconds(),flag,colNamesForQuery,msmtHost);
					if(a_results!=null && a_results.size()>0)
					{
						Vector process=new Vector();
						Vector cpu=new Vector();
						Vector memory=new Vector();

				String processName="";

				Hashtable processData=new Hashtable();
				if(a_results!=null && a_results.size()>0)
				{
					ArrayList lastData=(ArrayList)a_results.get(1);
					if(lastData!=null && lastData.size()>0)
					{
						Iterator itr=lastData.iterator();
						while(itr.hasNext())
						{
							ArrayList data1=(ArrayList)itr.next();
							Vector value=new Vector();
							processName=(String)data1.get(1);
							if(processData.containsKey(processName))
							{
								Vector tempVec=(Vector)processData.get(processName);
								int count=((Integer)tempVec.get(0)).intValue();
								count++;
								double cpuVal=Double.parseDouble((String)tempVec.get(1));
								double memoryVal=Double.parseDouble((String)tempVec.get(2));
								double tempcpuVal=Double.parseDouble((String)data1.get(2));
								double tempmemoryVal=Double.parseDouble((String)data1.get(3));
								String cpuValStr=erutils.round((cpuVal+tempcpuVal),2);
								String memoryValStr=erutils.round((memoryVal+tempmemoryVal),2);
								processData.remove(processName); 
								value.add(new Integer(count));
								value.add(cpuValStr);
								value.add(memoryValStr);
							}
							else
							{
								value.add(new Integer(1));
								value.add(data1.get(2));
								value.add(data1.get(3));
							}

							long process_usedsummary=egDashboard.getCitrixProcessDuration(compType,hostName,portNo,ddtest,descriptor,processName,s_startTimeForDay,s_endTime);

							String s_process_usedsummary=egDashboard.getDateDifferenceString(process_usedsummary);

							if(s_process_usedsummary==null || s_process_usedsummary.trim().equals(""))
								s_process_usedsummary="-";

							value.add(data1.get(9));
							value.add(s_process_usedsummary);
							processData.put(processName,value);
						}
					}
				}
				JSONArray gridColArr = new JSONArray();
				gridColArr.add(mappingInfo.getTextDescription("monitor.dashboard.Applications"));
				gridColArr.add(mappingInfo.getTextDescription("monitor.dashboard.Instances"));
				gridColArr.add(mappingInfo.getTextDescription("monitor.dashboard.%Cpu"));
				gridColArr.add(mappingInfo.getTextDescription("monitor.dashboard.%Memory"));
				gridColArr.add(mappingInfo.getTextDescription("monitor.dashboard.Published Desktop"));
				gridColArr.add(mappingInfo.getTextDescription("monitor.dashboard.AppProcess Usage Duration (24 hours)"));
				CitrixUserAppObj.put("GRID_COLUMNS", gridColArr);
				ArrayList processDatakey=new ArrayList(processData.keySet());

				Collections.sort(processDatakey,String.CASE_INSENSITIVE_ORDER);

						Iterator processItr=processDatakey.iterator();
						JSONArray gridArr = new JSONArray();
						while(processItr.hasNext())
						{
							int cnt = 0;
							JSONObject gridObj = new JSONObject();
							processName=(String)processItr.next();
							Vector value=(Vector)processData.get(processName);
							String publishedDeskTop=(String)value.get(3);
							gridObj.put("COLUMN_"+(cnt++), processName);
							gridObj.put("COLUMN_"+(cnt++), String.valueOf(value.get(0)));
							gridObj.put("COLUMN_"+(cnt++), String.valueOf(value.get(1)));
							gridObj.put("COLUMN_"+(cnt++), String.valueOf(value.get(2)));
							if(publishedDeskTop!=null && publishedDeskTop.length()<20)
							{
								gridObj.put("COLUMN_"+(cnt++), publishedDeskTop);
							}
							else
							{
								String genHTML = "<table cellspacing='0' cellpadding='0' border='0' class='x-grid-table x-grid-table-resizer'>";
								int idx = publishedDeskTop.length()/20;
								int index = 0;
								for (int j=0; j<idx; j++)
								{
									genHTML += "<tr class='x-grid-row'><td class='x-grid-cell x-grid-cell-first'><div class='x-grid-cell-inner'>"+publishedDeskTop.substring(index,index+20)+"</div></td></tr>";
									index = index+20;
								}
								genHTML += "<tr class='x-grid-row'><td class='x-grid-cell x-grid-cell-first'><div class='x-grid-cell-inner'>"+publishedDeskTop.substring(index)+"</div></td></tr>";
								gridObj.put("COLUMN_"+(cnt++), (String)value.get(4));
							}
							gridObj.put("COLUMN_"+(cnt++), (String)value.get(4));
							gridArr.add(gridObj);
						}
						if ( !gridArr.isEmpty() )
						{
							CitrixUserAppObj.put("GRID_VALUES", gridArr);
						}
					}
					else
					{
						CitrixUserAppObj.put("NO_GRID", "true");
						CitrixUserAppObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available!")+"!");
					}
					citrixUserObj.put("CITRIX_USER_APPLICATIONS_SUMMARY", CitrixUserAppObj);
				}
			}
			else
			{
				citrixUserObj.put("NO_USERS", "true");
				citrixUserObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No Citrix users available")+"!");
			}			
		}
		else
		{
			citrixUserObj.put("NO_USERS", "true");
			citrixUserObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.Test has been disabled or excluded")+"!");
		}
		rootJson.put("CITRIX_USERS", citrixUserObj);
	}
	else
	{
		ServiceTopology topology=new ServiceTopology(request);
		JSONObject citrixAppObj = new JSONObject();
		String ddtest="";
		String ddmeasure = "";
		if(compType.equalsIgnoreCase("Citrix_server"))
		{
			ddtest="CtxAppTest";
			ddmeasure="Number_of_processes,CtxAppTest:Cpu_util,CtxAppTest:Memory_util";
		}
		else if(compType.equalsIgnoreCase("Citrix_XcXenApp_server"))
		{
			ddtest="CtxXcXAAppTest";
			ddmeasure="Number_of_processes,CtxXcXAAppTest:Cpu_util,CtxXcXAAppTest:Memory_util";
		}		
		String tableTitle=iniObj.getValue("Dashboard_Comparison_TableTitle",ddtest);
		if(tableTitle!=null && tableTitle.equals(""))
		{
			tableTitle=mappingInfo.getTestDescription(ddtest);
		}
		citrixAppObj.put("TITLE", tableTitle);

		boolean isExcludedTest = false;
		if(getExcludedTest!=null && getExcludedTest.contains(ddtest))
			isExcludedTest = true;
		if(enabledTests!=null && enabledTests.contains(ddtest) && !isExcludedTest)
		{
			String measuresForDB="";
			Vector measures=new Vector();
			StringTokenizer stkTokens=new StringTokenizer(ddmeasure,",");
			int countTokens=stkTokens.countTokens();
			while(stkTokens.hasMoreTokens())
			{
				String testMeasure=stkTokens.nextToken();
				String measName=testMeasure.substring(testMeasure.indexOf(":")+1,testMeasure.length());
				measures.add(measName);
				measuresForDB+=","+dbInfo.getColumnForMeasure(ddtest,measName);
			}
			if(measuresForDB.indexOf(",")==0)
			{
				measuresForDB=measuresForDB.substring(1,measuresForDB.length());
			}
			msmtHost=(String)allMsmtHosts.get(ddtest);

			Vector allValuesForInfo=dashboardDAO.getCurrentForAllInfos(hostName,portNo,ddtest,measuresForDB,msmtHost);

			String s_infomapping=iniObj.getValue("Dashboard_Info_Mapping",ddtest);
			String rsTableName="CitrixAppSummary";			

			JSONArray gridColArr = new JSONArray();
			if(allValuesForInfo!=null && allValuesForInfo.size()>0)
			{
				gridColArr.add(mappingInfo.getTextDescription("monitor.dashboard."+s_infomapping));
				int imgcnt=0;
				for(int i=0;i<measures.size();i++)
				{
					measure=(String)measures.get(i);
					String tableHeader=iniObj.getValue("Dashboard_tableheader_mapping",ddtest+":"+measure);
					if(tableHeader!=null && tableHeader.equals(""))
					{
						tableHeader=mappingInfo.getMeasureDescription(ddtest,measure);
						String unitMapping = graphUtil.getUnitMapping(tablesInfo.getUnitForMeasure(ddtest,measure));
						tableHeader+="("+unitMapping+")";
					}
					imgcnt++;
					gridColArr.add(tableHeader);
				}
				citrixAppObj.put("GRID_COLUMNS", gridColArr);
				if(allValuesForInfo!=null && allValuesForInfo.size()>0)
				{
					JSONArray gridArr = new JSONArray();
					for(int i=0;i<allValuesForInfo.size();i+=measures.size()+1)
					{
						JSONObject gridObj = new JSONObject();
						int cnt = 0;
						info=(String)allValuesForInfo.get(i);
						String descSate =(String)topology.getDescriptorState(compType, compName, ddtest, info);

						info=com.egurkha.util.StringUtils.replace(info,"+","");
						if(cnt==0)
						{
							gridObj.put("COLUMN_"+cnt+"_STATE",descSate); 
						}
						gridObj.put("COLUMN_"+(cnt++), info);
						for(int j=1;j<=measures.size();j++)
						{
							measure=(String)measures.get(j-1);
							String value=(String)allValuesForInfo.get(j+i);
							if(!testerInfo.getAllowNegativeValues(ddtest,measure) && (value!=null) && (value.startsWith("-") || value.trim().equals("")))
							{
								value = "-";
							}
							gridObj.put("COLUMN_"+(cnt++), value);
						}
						gridArr.add(gridObj);
					}
					citrixAppObj.put("GRID_VALUES", gridArr);
				}
			}
			else
			{
				citrixAppObj.put("NO_GRID","true");
				citrixAppObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.No measures available!"));
			}
		}
		else
		{
			citrixAppObj.put("NO_GRID","true");
			citrixAppObj.put("MSG", mappingInfo.getTextDescription("monitor.dashboard.Test has been disabled or excluded!"));
		}
		rootJson.put("CITRIX_APPLICATIONS", citrixAppObj);
	}
	hiddens.put("graphType", graphType);
	hiddens.put("selectedInfo", user);
	
	if(request.getQueryString()!=null)
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+request.getQueryString()+"&comptype="+compType+"&subsystem="+subsystem+"&host="+compName+"&selectedInfo="+user+"&tab="+tab+"&graphType="+graphType+"&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	else
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&selectedInfo="+user+"&tab="+tab+"&subsystem="+subsystem+"&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	rootJson.put("hiddens", hiddens);
	out.println(rootJson.toString());
}
catch(Throwable ex)
{
	//System.out.println("egCitrixUsersJSON request---->"+ErUtils.prepareQueryString(request.getParameterMap()));
	System.out.println("Exception in egCitrixUsersJSON.jsp "+ex);
	ex.printStackTrace();
}
%>