<%
/*****************************************************************************************************
*	Name			:	aggDataComparision.jsp
*	Version			:	eG 5.7
*	Purpose			:	Comparing aggregate and independent test measure's data
*	Date of Creation:	17th September 2012
*	Author			:	James Thomas P.
 *****************************************************************************************************/
%>
<%@ include file="EgLoginTracker.jsp"%>
<%@ page import = "com.eg.*"%>
<%@ page import = "com.egurkha.monitor.*"%>
<%@ page import = "com.egurkha.admin.*"%>
<%@ page import = "com.egurkha.util.*"%>
<%@ page import = "egurkha.reporter.ErInfo"%>
<%@ page import = "java.util.*"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.eg.supermanager.*"%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires",-1);

	ArrayList managerIDs=null;
	if(EgInstallInfo.isSuperManager)
	{
		String component_nick = request.getParameter("nick");
		if(component_nick != null)
		{
			managerIDs = EgElementInfo.getInstance().getManagerIDs("component",component_nick);
			//System.out.println();
			//System.out.println("session id " + session.getId());
			//System.out.println("aggDataComparison.jsp is called host is " +  component_nick + " managerIDs " + managerIDs);
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(session.getId(),managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
				new SMDateTimeConverter(managerIDs);
			}
		}
	}
	String ctype = request.getParameter("ctype");
	String nick = request.getParameter("nick");
	String port = request.getParameter("port");
	String test = request.getParameter("test");
	String measurement = request.getParameter("measurement");//measure column name in db
	String currentDateFormat = request.getParameter("dateformat");
	String s_info = request.getParameter("str_info");
	s_info=(StringUtils.isNull(s_info) || s_info.trim().length()==0)?"":"+"+s_info;
	String startDateStr = (String)session.getAttribute("startDate");
	String endDataStr = (String)session.getAttribute("endDate");
	SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss"); 
	Date start_date1 = dateFormat.parse(startDateStr);
	Date end_date1 = dateFormat.parse(endDataStr);
	SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
	String from_date=sdf.format(start_date1);
	String to_date=sdf.format(end_date1);
	EgDbInfo dbInfo2 = new EgDbInfo("manager");

	String measures[] = new EgThresholdInfo("manager").getMeasurementsForTest(test);
	if(measures != null)
	{
		for(int i=0;i<measures.length;i++)
		{
			if(dbInfo2.getColumnForMeasure(test,measures[i],true).equals(measurement))
			{
				measurement = measures[i];//measure column name in db >>> actual test measurement name
				break;
			}
		}
	}
	boolean SQLServer = EgDbInfo.checkDBType().equals("EgMsSqlAdapter");
	AggregateDAO aggregateDAO = null;
	if(SQLServer)
	{
		aggregateDAO = new MsSqlAggregateDAO();
	}
	else
	{
		aggregateDAO = new OracleAggregateDAO();
	}
	String measurementDBColumnName = new com.eg.EgDbInfo("manager").getColumnForMeasure(test, measurement,true);
	StringBuffer sb = new StringBuffer();
	if(EgInstallInfo.isSuperManager)
	{
		// oracle
		sb.append(EgSmConfigInfo.ORACLE);
		if(false && SQLServer)
		{
			sb.append("select trgt_host,convert(nvarchar(20),msmt_time,101)+' '+convert(nvarchar(8),msmt_time,108) as msmt_time,info,");
		}
		else
		{
			sb.append("select trgt_host, TO_CHAR(msmt_time,'MM/DD/YYYY HH24:MI:SS') as msmt_time,info,");
		}
		sb.append(measurementDBColumnName);
		sb.append(" from ");
		sb.append(test);
		if(false && SQLServer)
		{
			sb.append(" where msmt_time between CONVERT (datetime, '");
			sb.append(from_date);
			sb.append("', 103) and CONVERT (datetime, '");
			sb.append(to_date);
			sb.append("', 103) and trgt_host ='");
			sb.append(nick);
			sb.append("'");
		}
		else
		{
			sb.append(" where MSMT_TIME BETWEEN TO_DATE('");
			sb.append(from_date);
			sb.append("','DD/MM/YYYY HH24:MI:SS') AND TO_DATE('");
			sb.append(to_date);
			sb.append("','DD/MM/YYYY HH24:MI:SS') and trgt_host ='");
			sb.append(nick);
			sb.append("'");
		}
		if(s_info.length()>0)
		{
			sb.append(" and info ='");
			sb.append(s_info);
			sb.append("'");
		}
		sb.append(" order by trgt_host,msmt_time desc,info");
		sb.append(EgSmConfigInfo.EG_DOLLAR);

		// sql server
		sb.append(EgSmConfigInfo.SQL);
		if(true || SQLServer)
		{
			sb.append("select trgt_host,convert(nvarchar(20),msmt_time,101)+' '+convert(nvarchar(8),msmt_time,108) as msmt_time,info,");
		}
		else
		{
			sb.append("select trgt_host, TO_CHAR(msmt_time,'MM/DD/YYYY HH24:MI:SS') as msmt_time,info,");
		}
		sb.append(measurementDBColumnName);
		sb.append(" from ");
		sb.append(test);
		if(true || SQLServer)
		{
			sb.append(" where msmt_time between CONVERT (datetime, '");
			sb.append(from_date);
			sb.append("', 103) and CONVERT (datetime, '");
			sb.append(to_date);
			sb.append("', 103) and trgt_host ='");
			sb.append(nick);
			sb.append("'");
		}
		else
		{
			sb.append(" where MSMT_TIME BETWEEN TO_DATE('");
			sb.append(from_date);
			sb.append("','DD/MM/YYYY HH24:MI:SS') AND TO_DATE('");
			sb.append(to_date);
			sb.append("','DD/MM/YYYY HH24:MI:SS') and trgt_host ='");
			sb.append(nick);
			sb.append("'");
		}
		if(s_info.length()>0)
		{
			sb.append(" and info ='");
			sb.append(s_info);
			sb.append("'");
		}
		sb.append(" order by trgt_host,msmt_time desc,info");
	}
	else
	{
		if(SQLServer)
		{
			sb.append("select trgt_host,convert(nvarchar(20),msmt_time,101)+' '+convert(nvarchar(8),msmt_time,108) as msmt_time,info,");
		}
		else
		{
			sb.append("select trgt_host, TO_CHAR(msmt_time,'MM/DD/YYYY HH24:MI:SS') as msmt_time,info,");
		}
		sb.append(measurementDBColumnName);
		sb.append(" from ");
		sb.append(test);
		if(SQLServer)
		{
			sb.append(" where msmt_time between CONVERT (datetime, '");
			sb.append(from_date);
			sb.append("', 103) and CONVERT (datetime, '");
			sb.append(to_date);
			sb.append("', 103) and trgt_host ='");
			sb.append(nick);
			sb.append("'");
		}
		else
		{
			sb.append(" where MSMT_TIME BETWEEN TO_DATE('");
			sb.append(from_date);
			sb.append("','DD/MM/YYYY HH24:MI:SS') AND TO_DATE('");
			sb.append(to_date);
			sb.append("','DD/MM/YYYY HH24:MI:SS') and trgt_host ='");
			sb.append(nick);
			sb.append("'");
		}
		if(s_info.length()>0)
		{
			sb.append(" and info ='");
			sb.append(s_info);
			sb.append("'");
		}
		sb.append(" order by trgt_host,msmt_time desc,info");
	}
	String query = sb.toString();
	sb.setLength(0);
	if(EgInstallInfo.isSuperManager)
	{
		new SMDateTimeConverter(managerIDs,"dd/MM/yyyy HH:mm:ss",from_date,to_date,"MM/dd/yyyy HH:mm:ss",new int[]{1});
	}
	List list = aggregateDAO.getDetailsForComparision(query);
	ArrayList hostnames = new ArrayList();
	Hashtable ht = new Hashtable();
	if(list != null)
	{
		for(int i=0;i<list.size();i++)
		{
			String[] temp = (String[]) list.get(i);//[gen_37, 09/18/2012 11:14:03, +editplus, 1]
			String key = temp[0];
			if(!hostnames.contains(key))
			{
				hostnames.add(key);
			}
			if(ht.containsKey(key))
			{
				ArrayList alist = (ArrayList)ht.get(key);
				alist.add(temp);
				ht.put(key,alist);
			}
			else
			{
				ArrayList alist = new ArrayList();
				alist.add(temp);
				ht.put(key,alist);
			}
		}
	}
	boolean aggDataFound = !ht.isEmpty();
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	String memberTestName = aggregateInfo.getTestName(test);
	String aggComponent = ctype+":"+nick+":NULL";
	Hashtable dontShowCompInfo = new Hashtable();

	List mangd_comp = aggregateInfo.getAggregateComponents(test,nick+":NULL");
	List memberCommaStr = aggregateInfo.getCommaSepStrings(mangd_comp);
	String memberStr = "";
	if(memberCommaStr != null && !memberCommaStr.isEmpty())
	{
		memberStr = (String)memberCommaStr.get(0);
	}
	String memColumName = aggregateInfo.getMemberColumnName(test,measurement);
	if(EgInstallInfo.isSuperManager)
	{
		//oracle
		sb.append(EgSmConfigInfo.ORACLE);
		if(false && SQLServer)
		{
			sb.append("select trgt_host,convert(nvarchar(20),msmt_time,101)+' '+convert(nvarchar(8),msmt_time,108) as msmt_time,info,");
		}
		else
		{
			sb.append("select trgt_host, TO_CHAR(msmt_time,'MM/DD/YYYY HH24:MI:SS') as msmt_time,info,");
		}
		sb.append(memColumName);
		sb.append(" from ");
		sb.append(memberTestName);
		if(false && SQLServer)
		{
			sb.append(" where msmt_time between CONVERT (datetime, '");
			sb.append(from_date);
			sb.append("', 103) and CONVERT (datetime, '");
			sb.append(to_date);
			sb.append("', 103) and trgt_host in (");
		}
		else
		{
			sb.append(" where MSMT_TIME BETWEEN TO_DATE('");
			sb.append(from_date);
			sb.append("','DD/MM/YYYY HH24:MI:SS') AND TO_DATE('");
			sb.append(to_date);
			sb.append("','DD/MM/YYYY HH24:MI:SS') and trgt_host in (");
		}
		sb.append(memberStr);
		sb.append(")");
		String variables[] = aggregateInfo.getVariables("AGGREGATE_TEST_INFOS_EXCLUDED");
		if(variables != null && variables.length>0)
		{
			for(int i=0;i<variables.length;i++)
			{
				String str = variables[i];
				if(str.startsWith((test + ":" + aggComponent+"#")))
				{
					str = str.substring(str.indexOf("#")+1);
					String compNick = str.substring(0,str.indexOf(":+"));
					if(compNick.indexOf(":")>0)
					{
						compNick = compNick.substring(0,compNick.indexOf(":"));
					}
					str = str.substring(str.indexOf(":")+1);
					str = str.substring(str.indexOf(":")+1);
					str = str.substring(str.indexOf(":")+1);
					if(dontShowCompInfo.containsKey(compNick))
					{
						ArrayList alist = (ArrayList)dontShowCompInfo.get(compNick);
						alist.add(str);//+editplus
						dontShowCompInfo.put(compNick,alist);
					}
					else
					{
						ArrayList alist = new ArrayList();
						alist.add(str);//+editplus
						dontShowCompInfo.put(compNick,alist);
					}
				}
			}
		}
		if(s_info.length()>0)
		{
			sb.append(" and info ='");
			sb.append(s_info+"'");
			sb.append(" ");
		}
		sb.append(" order by trgt_host,msmt_time desc,info");
		sb.append(EgSmConfigInfo.EG_DOLLAR);

		///sql server
		sb.append(EgSmConfigInfo.SQL);
		if(true || SQLServer)
		{
			sb.append("select trgt_host,convert(nvarchar(20),msmt_time,101)+' '+convert(nvarchar(8),msmt_time,108) as msmt_time,info,");
		}
		else
		{
			sb.append("select trgt_host, TO_CHAR(msmt_time,'MM/DD/YYYY HH24:MI:SS') as msmt_time,info,");
		}
		sb.append(memColumName);
		sb.append(" from ");
		sb.append(memberTestName);
		if(true || SQLServer)
		{
			sb.append(" where msmt_time between CONVERT (datetime, '");
			sb.append(from_date);
			sb.append("', 103) and CONVERT (datetime, '");
			sb.append(to_date);
			sb.append("', 103) and trgt_host in (");
		}
		else
		{
			sb.append(" where MSMT_TIME BETWEEN TO_DATE('");
			sb.append(from_date);
			sb.append("','DD/MM/YYYY HH24:MI:SS') AND TO_DATE('");
			sb.append(to_date);
			sb.append("','DD/MM/YYYY HH24:MI:SS') and trgt_host in (");
		}
		sb.append(memberStr);
		sb.append(")");
		//String variables[] = aggregateInfo.getVariables("AGGREGATE_TEST_INFOS_EXCLUDED");
		if(variables != null && variables.length>0)
		{
			for(int i=0;i<variables.length;i++)
			{
				String str = variables[i];
				if(str.startsWith((test + ":" + aggComponent+"#")))
				{
					str = str.substring(str.indexOf("#")+1);
					String compNick = str.substring(0,str.indexOf(":+"));
					if(compNick.indexOf(":")>0)
					{
						compNick = compNick.substring(0,compNick.indexOf(":"));
					}
					str = str.substring(str.indexOf(":")+1);
					str = str.substring(str.indexOf(":")+1);
					str = str.substring(str.indexOf(":")+1);
					if(dontShowCompInfo.containsKey(compNick))
					{
						ArrayList alist = (ArrayList)dontShowCompInfo.get(compNick);
						alist.add(str);//+editplus
						dontShowCompInfo.put(compNick,alist);
					}
					else
					{
						ArrayList alist = new ArrayList();
						alist.add(str);//+editplus
						dontShowCompInfo.put(compNick,alist);
					}
				}
			}
		}
		if(s_info.length()>0)
		{
			sb.append(" and info ='");
			sb.append(s_info+"'");
			sb.append(" ");
		}
		sb.append(" order by trgt_host,msmt_time desc,info");
		query=sb.toString();
	}
	else
	{
		if(SQLServer)
		{
			sb.append("select trgt_host,convert(nvarchar(20),msmt_time,101)+' '+convert(nvarchar(8),msmt_time,108) as msmt_time,info,");
		}
		else
		{
			sb.append("select trgt_host, TO_CHAR(msmt_time,'MM/DD/YYYY HH24:MI:SS') as msmt_time,info,");
		}
		sb.append(memColumName);
		sb.append(" from ");
		sb.append(memberTestName);
		if(SQLServer)
		{
			sb.append(" where msmt_time between CONVERT (datetime, '");
			sb.append(from_date);
			sb.append("', 103) and CONVERT (datetime, '");
			sb.append(to_date);
			sb.append("', 103) and trgt_host in (");
		}
		else
		{
			sb.append(" where MSMT_TIME BETWEEN TO_DATE('");
			sb.append(from_date);
			sb.append("','DD/MM/YYYY HH24:MI:SS') AND TO_DATE('");
			sb.append(to_date);
			sb.append("','DD/MM/YYYY HH24:MI:SS') and trgt_host in (");
		}
		sb.append(memberStr);
		sb.append(")");
		String variables[] = aggregateInfo.getVariables("AGGREGATE_TEST_INFOS_EXCLUDED");
		if(variables != null && variables.length>0)
		{
			for(int i=0;i<variables.length;i++)
			{
				String str = variables[i];
				if(str.startsWith((test + ":" + aggComponent+"#")))
				{
					str = str.substring(str.indexOf("#")+1);
					String compNick = str.substring(0,str.indexOf(":+"));
					if(compNick.indexOf(":")>0)
					{
						compNick = compNick.substring(0,compNick.indexOf(":"));
					}
					str = str.substring(str.indexOf(":")+1);
					str = str.substring(str.indexOf(":")+1);
					str = str.substring(str.indexOf(":")+1);
					if(dontShowCompInfo.containsKey(compNick))
					{
						ArrayList alist = (ArrayList)dontShowCompInfo.get(compNick);
						alist.add(str);//+editplus
						dontShowCompInfo.put(compNick,alist);
					}
					else
					{
						ArrayList alist = new ArrayList();
						alist.add(str);//+editplus
						dontShowCompInfo.put(compNick,alist);
					}
				}
			}
		}
		if(s_info.length()>0)
		{
			sb.append(" and info ='");
			sb.append(s_info+"'");
			sb.append(" ");
		}
		sb.append(" order by trgt_host,msmt_time desc,info");
		query=sb.toString();
	}
	if(EgInstallInfo.isSuperManager)
	{
		new SMDateTimeConverter(managerIDs,"dd/MM/yyyy HH:mm:ss",from_date,to_date,"MM/dd/yyyy HH:mm:ss",new int[]{1});
	}
	list = aggregateDAO.getDetailsForComparision(query);
	aggregateDAO=null;
	if(list != null)
	{
		for(int i=0;i<list.size();i++)
		{
			String[] temp = (String[]) list.get(i);//[gen_37, 09/18/2012 11:14:03, +editplus, 1]
			String key = temp[0];
			if(dontShowCompInfo.containsKey(key))
			{
				String info = temp[2];
				ArrayList alist = (ArrayList)dontShowCompInfo.get(key);
				if(alist != null && alist.contains(info))
					continue;
			}
			if(!hostnames.contains(key))
			{
				hostnames.add(key);
			}
			if(ht.containsKey(key))
			{
				ArrayList alist = (ArrayList)ht.get(key);
				alist.add(temp);
				ht.put(key,alist);
			}
			else
			{
				ArrayList alist = new ArrayList();
				alist.add(temp);
				ht.put(key,alist);
			}
		}
	}
%>
<!Doctype html>
<head>
<title>&nbsp;<egui:intnl text='monitor.common.Comparison Graph Data'/>&nbsp;-&nbsp;<egui:intnl text='monitor.common.eG Manager'/> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</title>
<!--egui:skin ui="monitor"/-->
<script language="javascript1.2">
function callSaveData()
{
	window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language=<%=trackerLanguage%>";
}
</script>
<link rel="stylesheet" href="/final/styles/egIcons.css" />
<link rel="stylesheet" href="/final/styles/ext-custom-com.css" />
	 <style>
 body{background-color:#fff;font-family:Calibri, Candara, "Segoe UI", Arial, sans-serif; font-size:100%}
.borderradius{
border-radius: 5px 5px 5px 5px;
-moz-border-radius: 5px 5px 5px 5px;
-khtml-border-radius: 5px 5px 5px 5px;
-o-border-radius: 5px 5px 5px 5px;
-webkit-border-radius: 5px 5px 5px 5px;
border-color:#d2d2d2;
border-style:solid;
border-width:1px;
margin-bottom:5px;
}
table {
  border-collapse: collapse;
}
#cell_border td{font-family:Calibri, Candara, "Segoe UI", Arial, sans-serif; font-size:12px }
</style>
<style type="text/css" media="print">
#header {
background: #000 !important;
} 
#printbt{ display:none}
table {
  border-collapse: collapse;
}
</style>
</head>
<%
	if(!hostnames.isEmpty())
	{
		EgMappingInfo mappingInfo = new EgMappingInfo(trackerLanguage);
		String unit = new EgTablesInfo("manager").getUnitForMeasure(test,measurement);
		List csvList = new LinkedList();

%>
<body style="margin:0px;background:#fff;overflow:scroll">
<form>
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<tr>
		<td align="center" width="100%" valign="top">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="inner_bg">
				<jsp//:include page="header.jsp?title=COMPARISON GRAPH DATA&newWindow=true"/>
				<tr>
					<td width="100%" align="left" valign="top" style="padding:5px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="font-size:13px;border-bottom:#000 1px solid">
							<tr>
<script>
	var er_history = history.length;
	if (er_history > 1)
	{
		document.write("<td width=\"30\" nowrap align=\"center\"><input type=\"button\" name=\"button\" id=\"eg_darkbutton\" value=\"<<\" onClick=\"javascript:history.back();\"> &nbsp; </td>");
	}
</script>
								<td width="100%" align="left" id="data_headbg">
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="eg_moredark">
										<tr>
											<th id="inner_subhead" nowrap width="25%" align="left"><egui:intnl text="monitor.graphdata.COMPARISON GRAPH DATA"/> &nbsp; </th>

											<td width="75%" align="right"><a href="javascript:void(0)" onClick='callSaveData();' title="<egui:intnl text='monitor.graphdata.CSV'/>"><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" class="iconCsv"></a>&nbsp;&nbsp;</td>

										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
		if(!hostnames.isEmpty())
		{
			EgDbInfo dbInfo = new EgDbInfo("manager");
			String thisSite = "NULL";
			ErInfo erInfo = new ErInfo();
			String normalType = aggregateInfo.getValue("COMPONENT_TYPE_MAPPING",ctype,false);
			boolean infoBasedTest = false;
			Vector infos=null;
			for(int k=0;k<mangd_comp.size();k++)
			{
				infos= erInfo.getInfosForTest(thisSite,memberTestName,(String)mangd_comp.get(k)+":NULL:"+normalType);
				if(infos != null)
				{
					if(infos.size()>1)
					{
						infoBasedTest = true;
						break;
					}
					else if(infos.size()==1 && !infos.get(0).equals("+"))
					{
						infoBasedTest = true;
						break;
					}
				}
				infos=null;
			}
			erInfo=null;
			if(s_info.length()>0)
			{
				infoBasedTest = false;
			}
			csvList.add("Comparision Graph Data");//heading for CSV
			csvList.add(",");//leaves one line
			String	csvStr="";
			for(int i=0;i<hostnames.size();i++)
			{
				String hostname = (String)hostnames.get(i); //RED
%>
				<tr>
					<td width="100%" valign="top" align="left" id="inner_bg" style="padding:5px">
						<table align="left" cellspacing="0" cellpadding="0" width="100%" border="0" > 
 							<tr>
								<td width="100%" align="center" valign="top" class="space6" style="padding:0px 0 5px 0">
									<table align="center" cellspacing="0" cellpadding="5" width="100%" border="0" id="cell_border3" id="cell_border3" style="font-size:13px;border:#d2d2d2 1px solid">

										<col width="13%"><col width="1%"><col width="17%">
										<col width="15%"><col width="1%"><col width="22%">
										<col width="10%"><col width="1%"><col width="20%">
										<tr>
<%
				if(i==0 && aggDataFound)
				{
					String displaytype = mappingInfo.getComponentTypeDescription(ctype);
					csvStr = "Component type," + displaytype;
					if(displaytype.length()>25)
					{
						displaytype = StringUtils.replace(displaytype," ","<br>");
					}
%>
											<td id="eg_cellbglights" nowrap><b><egui:intnl text="monitor.common.Component type"/></b></td>
											<td id="eg_cellbglights" nowrap><b>:</b></td>
											<td id="eg_cellbglights" nowrap align="left"><%=displaytype%></td>

<%
				}
				else
				{
					String displaytype = mappingInfo.getComponentTypeDescription(normalType);
					csvStr = "Component type," + displaytype;
					if(displaytype.length()>25)
					{
						displaytype = StringUtils.replace(displaytype," ","<br>");
					}
%>
											<td id="eg_cellbglights" nowrap><b><egui:intnl text="monitor.common.Component type"/></b></td>
											<td id="eg_cellbglights" nowrap><b>:</b></td>
											<td id="eg_cellbglights" nowrap align="left"><%=displaytype%></td>

<%
				}
				csvStr += ",Component name,"+hostname;
				String displayHostname = hostname;
				if(displayHostname.length()>21)
				{
					displayHostname = displayHostname.substring(0,21)+"<br>"+displayHostname.substring(21);
				}
%>
											<td id="eg_cellbglights" nowrap align="right"><b><egui:intnl text="monitor.common.Component name"/></b></td>
											<td id="eg_cellbglights" nowrap><b>:</b></td>
											<td id="eg_cellbglights" nowrap align="left"><%=displayHostname%></td>
<%
				if(i==0 && aggDataFound)
				{
					String displaytest = mappingInfo.getTestDescription(test);
					csvStr += ",Test name," + displaytest;
					if(displaytest.length()>25)
					{
						displaytest = StringUtils.replace(displaytest," ","<br>");
					}
%>
											<td id="eg_cellbglights" nowrap align="right"><b><egui:intnl text="monitor.common.Test name"/></b></td>
											<td id="eg_cellbglights" nowrap><b>:</b></td>
											<td id="eg_cellbglights" nowrap align="left"><%=displaytest%></td>
<%
				}
				else
				{
					String displaytest = mappingInfo.getTestDescription(memberTestName);
					csvStr += ",Test name," + displaytest;
					if(displaytest.length()>25)
					{
						displaytest = StringUtils.replace(displaytest," ","<br>");
					}
%>
											<td id="eg_cellbglights" nowrap align="right"><b><egui:intnl text="monitor.common.Test name"/></b></td>
											<td id="eg_cellbglights" nowrap><b>:</b></td>
											<td id="eg_cellbglights" nowrap align="left"><%=displaytest%></td>

<%
				}
				csvList.add(csvStr);
%>
										</tr>
<%
				if(s_info.length()>0)
				{
					csvStr = "Descriptor,"+s_info.substring(1);
					csvList.add(csvStr);
%>
										<tr>
											<td id="eg_cellbglights" nowrap align="left"><b><egui:intnl text="monitor.common.Descriptor"/></b></td>
											<td id="eg_cellbglights" nowrap><b>:</b></td>
											<td id="eg_cellbglights" nowrap align="left"><%=s_info.substring(1)%></td>
											<td id="eg_cellbglights" nowrap align="left" colspan="6">&nbsp;</td>
										</tr>
<%
				}
%>
									</table>
								</td>
							</tr>
							<tr>
								<td width="100%" align="center" id="space6" valign="top">
									<table align="center" width="100%" cellspacing="0" cellpadding="0" border="1" id="data_border">
										<tr>
											<td nowrap class="eg_whitebg" align="center" id="eg_errorsmall" valign="top">
												<table align="center" width="100%" cellspacing="0" cellpadding="0" border="1" style="font-size:13px;border:#d2d2d2 1px solid">
<%
				if((i==0 || !infoBasedTest) && aggDataFound)
				{
%>
												<col width="50%"><col width="50%">
<%
				}
				else
				{
%>
												<col width="33%"><col width="34%"><col width="33%">
<%
				}
%>
													<tr>
														<th align="center" id="table_header" height="20"><egui:intnl text="monitor.common.Measurement Time"/></th>
<%
				csvStr = "Measurement Time,";

				if((i>0 || (i==0 && !aggDataFound)) && infoBasedTest)
				{
				csvStr += "Descriptor,";
%>
														<th align="center" id="table_header" height="20"><b><egui:intnl text="admin.common.Descriptor"/></b></th>
<%
				}
				csvStr += mappingInfo.getMeasureDescription(test,measurement)+"("+unit+")";
				csvList.add(csvStr);
%>
														<th align="center" id="table_header" height="20"><%=mappingInfo.getMeasureDescription(test,measurement)%></b>&nbsp;(<%=unit%>)</th>
													</tr>
<%
					ArrayList arrayContainer = (ArrayList)ht.get(hostname);
					boolean cellFlag=false;
					for(int j=0;j<arrayContainer.size();j++)
					{
						String arr[] = (String[])arrayContainer.get(j);
						int idx = arr[1].indexOf(" ");
						String date = DateUtil.changeDateFormat(arr[1].substring(0,idx),"MM/dd/yyyy",dateFormatForDatePicker) + arr[1].substring(idx);						
						csvStr = "\""+date+"\",";
%>
													<tr height="20">
														<td align="center" class="cell_border1"><%=date%></td>
<%
						if((i>0 || (i==0 && !aggDataFound)) && infoBasedTest)
						{
							csvStr += arr[2].substring(1)+",";
%>
														<td align="center" class="cell_border1"><%=arr[2].substring(1)%></td>
<%
						}
						csvStr += dbInfo.formatValue(arr[3]);
						csvList.add(csvStr);
%>
														<td align="center" class="cell_border1"><%=dbInfo.formatValue(arr[3])%></td>
													</tr>
<%
						cellFlag=!cellFlag;
					}
%>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
				csvList.add(",");
			}
		}
		session.setAttribute("list",csvList);
%>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
<%
	}
	else
	{
%>
<body leftmargin="0" topmargin="0" marginheight="0" marginwidth="0" class="eg_whitebg" style="overflow:auto" id="space6">
	<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
		<tr>
			<td align="center" width="100%" valign="top">
				<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="inner_bg">
					<jsp//:include page="header.jsp?title=COMPARISION GRAPH DATA&newWindow=true"/>
					<tr>
						<td width="100%" align="left" valign="top" height="100%">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
								<tr>
									<td align="center" id="eg_whitebg" height="400" valign="middle">
										<table border="0" cellspacing="0" cellpadding="4" width="50%">
											<tr>
												<td width="100%" align="center"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"></td>
											</tr>
											<tr>
												<td width="100%" align="center" id="eg_errorsmall"><egui:intnl text="admin.common.No data found"/></td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
</body>
<%
	}
%>
</html>