<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.eg.EgAggregateInfo" %>
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgHelpParser"%>	
<%@ page import="com.eg.*" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	String aggTest = request.getParameter("aggTest");
	String associatedTest = request.getParameter("associatedTest");

	if(aggTest==null)
		aggTest = "ProcessTest_ag";
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	EgAggregateInfo aggInfo = new EgAggregateInfo("manager");
	EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");
	String measureNames[] = thresholdInfo.getMeasurementsForTest(aggTest);
	if(associatedTest == null || associatedTest.trim().length()==0)
	{
		associatedTest = aggInfo.getTestName(aggTest);
	}
	HelpXMLFileReader egHelp = HelpParserThread.egHelp;
	String associatedTestId = egHelp.getIdForTest("EgDispLayers.jsp",associatedTest);

	String s_page = "EgM"+ associatedTestId + ".html?test="+associatedTest+"&from=layermodel";
	String filepath = "/../../final/eghelp/"+s_page;

	EgMappingInfo mappingInfo = new EgMappingInfo("en_US");
//

%>
<html>
<head>
<title>eG Help</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">

<link rel="stylesheet" href="eg_monitorstyle.css">
</head>

<body topmargin="0" leftmargin="0" marginwidth="0" marginheight="0" class="eg_monitorbg" background="images/monitor_bg.gif" bgproperties="fixed">
	<table align="center" width="100%" height="20" cellspacing="0" cellpadding="0" border="0">
		<tr>
			<th width="100%" height="24" align="left" background="images/title_monitor.gif" id="eg_monitortitle"> &nbsp; eG Monitoring</th>
		</tr>
		<tr>
			<td height="8" id="eg_blankspace" background="images/title_shadow_monitor.gif" nowrap>&nbsp;</td>
		</tr>
	</table>
<table cellspacing="0" cellpadding="0" width="95%" valign="top" align="center" border="0" style="padding:10px">
	<tr>
		<td width="100%" valign="top" align="left">
	<b><p align="justify">Measures reported by <%=mappingInfo.getTestDescription(aggTest)%>&nbsp;Test</b>
	<p  align="justify" class="MsoBodyText"> The <B>Metric Aggregation</B> capability provided by the eG Enterprise suite helps administrators to group one or more components of a particular type and monitor the group as a single logical component, broadly termed as an <I>aggregate</I> component. Typically, every eG agent that is monitoring a component grouped under an aggregate component, reports metrics collected from the corresponding component to the eG manager. The eG manager consolidates the metrics so received and stores them in the eG backend. To aggregate these metrics, eG Enterprise requires that a remote agent be installed. Every time an aggregate test runs, this remote agent queries the eG manager for the metrics collected from the member components of the managed aggregate component. On receipt of the metrics, the remote agent applies pre-configured aggregate functions on the metrics, and updates the eG manager with the aggregated performance results. This page helps you to view the aggregated performance metrics of the chosen test. </p>
	
	<p class="MsoBodyText">The measures of the <%=mappingInfo.getTestDescription(aggTest)%>&nbsp;Test are derived from the measures of the &nbsp;<a href='<%=filepath%>' target='_self' style='color:blue'><%=mappingInfo.getTestDescription(associatedTest)%></a> Test.</p>
	
	The measures made by the <%=mappingInfo.getTestDescription(aggTest)%>&nbsp;Test are as follows:</p>
	<div align="center">
	<table border="1" width="100%" cellspacing="0" cellpadding="6" height="72">
	<tr>
		<th width="17%" align="center" valign="middle" height="16">Measurement</th>
		<th width="17%" align="center" valign="middle" height="16">Measurement Unit</th>
		<th width="38%" align="center" valign="middle" height="16">Aggregate function used</th>
	</tr>
<%
	for(int i=0;i<measureNames.length;i++)
	{
		String measureName = measureNames[i];
		String functionUsed = aggInfo.getValue("AGGREGATE_FUNCTION",aggTest+":"+measureName.toUpperCase());
		if(functionUsed == null)
			continue;
		int colIndex = functionUsed.indexOf(":");
		int lastColIndex = functionUsed.lastIndexOf(":");
		if(colIndex==-1 || (colIndex==lastColIndex))
			continue;
		functionUsed = functionUsed.substring(functionUsed.indexOf(":")+1,functionUsed.lastIndexOf(":"));
		if(functionUsed.equalsIgnoreCase("min"))
		{
			functionUsed = "Minimum";
		}
		else if(functionUsed.equalsIgnoreCase("maximum"))
		{
			functionUsed = "Maximum";
		}
		else if(functionUsed.equalsIgnoreCase("avg"))
		{
			functionUsed = "Average";
		}
		else if(functionUsed.equalsIgnoreCase("sum"))
		{
			functionUsed = "Sum";
		}
		else if(functionUsed.equalsIgnoreCase("avg_sum"))
		{
			functionUsed = "Average Sum";
		}
		else if(functionUsed.equalsIgnoreCase("pct"))
		{
			functionUsed = "Percentage";
		}
%>
	<tr>
		<th width="17%" align="left" valign="top" height="39"><%=mappingInfo.getMeasureDescription(aggTest,measureName)%></th>
			<td width="17%" valign="top" align="center" height="39"><%=tablesInfo.getUnitForMeasure(aggTest,measureName)%>
			</td>
			<td width="38%" valign="top" align="center" id="just" height="17"><%=functionUsed%></td>
	</tr>
<%
	}
%>
	</table>
	</div>
	</td>
	</tr>
	<tr>
		<td width="100%" valign="top" align="left" height="15">&nbsp;</td>
	</tr>
	</table>
	</center>
</div>
</body>
</html>