<%
/**
 *	File name		:	EgTestStatusInfoNew.jsp
 *	Purpose			:	To show additional information for the test based on the state of the 
 *						test. Monitor Enhancements.
 *	Version			:	3.0
 *	Creation Date	:	13-07-2001
 *	Last Date		:	31/10/2003	Karthick	Weblogic group infos display
 *						26/08/2003	Williams	Version 3.0 Layout Modifications
 *						26/09/2003	Williams	Footer Include
 *						13/10/2003	Arun		Uses display labels
 *						23/12/2003	Arun		Uses display labels to show the state of the test
 *						18/03/2004	Arun		Shows IP address along with nick name of the server
 *						07/05/2004	Arun		Shows error message if the component is unmanaged or if 
 *												a test is disabled when the window is active.
 *						02/09/2004	Solomon		Agentless server's internal test is displayed as Remote.
 *						01/30/2006  Thirumal Azhagan	To display threshold value.
 *						20/12/2011  Sri Devi G User - VM Changes
 *	Author			:	Krishna Kumar 
 */
%>
<%@ include file = "EgMonitorTracker.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgAgentInfo"%>
<%@ page import = "com.eg.EgTesterInfo"%>
<%@ page import = "com.eg.EgMaintenanceInfo"%>
<%@ page import = "com.egurkha.admin.EgMaintenanceUtility"%>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgThresholdInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.EgDbAdapterTypeUI" %>
<%@ page import = "java.sql.*" %>
<%@ page import = "egurkha.EgDbAdapterUI" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.LangInfo" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgAggregateInfo" %>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.eg.EgTablesInfo"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "com.egurkha.EgUserPermission"%>
<%@ page import = "com.egurkha.admin.EgTestSpecification"%>
<%@ page import = "com.eg.supermanager.*"%>
<%@ page import = "com.eg.*" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "egurkha.*" %>
<%@ page import="net.sf.json.*"%>
<%@ page import="egurkha.config.EcUtils"%>
<%@ page import="java.text.SimpleDateFormat"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	response.setContentType("application/json");
	request.setCharacterEncoding("UTF-8");

	String strCsrfToken = "";
	String strEncodedUrl = response.encodeURL(((HttpServletRequest)pageContext.getRequest()).getRequestURI());
	if(strEncodedUrl != null)
	{
		int idx_A = strEncodedUrl.indexOf("?");
		if (idx_A != -1)
		{
			String queryString = strEncodedUrl.substring(idx_A+1);
			HashMap hashMapParameters = EcUtils.parseQueryString(queryString);
			if (hashMapParameters != null && hashMapParameters.containsKey("com.eg.CSRF_NONCE"))
			{
				strCsrfToken = (String)hashMapParameters.get("com.eg.CSRF_NONCE");
			}
		}
	}
	JSONObject screenLabels = new JSONObject();
	JSONObject json = new JSONObject();

	JSONArray jsonArrayValue = new JSONArray();			
	JSONObject  policyGroupNameObj = new JSONObject();		
	JSONObject  policyNamesObjValue = new JSONObject();		
	JSONObject  policyTimeObject = new JSONObject();		
	JSONObject policyNames1Object = new JSONObject();		
	JSONObject displayComponentObject = new JSONObject();		
	JSONObject measureHost = new JSONObject();			
	JSONObject displayValue = new JSONObject();			
	JSONObject ipAddress = new JSONObject();			
	JSONObject testTypeValue = new JSONObject();		
	JSONObject testFrequencyValue = new JSONObject();		
	JSONObject dispInfoArrayObj = new JSONObject();			
	JSONObject testStateValue = new JSONObject();		
	JSONObject tempDispObj = new JSONObject();		
	JSONObject s_descValue = new JSONObject();			
	JSONObject displayComponentValue = new JSONObject();		
	JSONObject getReverse = new JSONObject();	
	JSONObject threshValue = new JSONObject();		
	JSONObject isVMValue = new JSONObject();		
	JSONObject testNameObj = new JSONObject();		
	JSONObject memberValue = new JSONObject();		
	JSONObject s_tnameValue = new JSONObject();		
	JSONObject testNameValue = new JSONObject();		
	JSONObject timeSince = new JSONObject();		
	JSONObject matchCriteriaValue = new JSONObject();		
	JSONObject unitValue = new JSONObject();
	JSONObject testMeasureValues = new JSONObject();
	JSONObject jsonObject = new JSONObject();
	JSONObject maxObj = new JSONObject();
	JSONObject maxObjOne = new JSONObject();
	JSONObject minObj = new JSONObject();
	JSONObject minObjOne = new JSONObject();
	JSONObject alarmPolicyObj = new JSONObject();
	JSONObject aggComponentValue = new JSONObject();
	JSONObject policyNames1ObjectValue = new JSONObject();
	JSONObject policyTimeObjValue = new JSONObject();

	ArrayList aListTestWithNoThresholds = new ArrayList();
	boolean isAdminLinkEnabled = false;
	boolean isAdminTestConfigLinkEnabled = false;

	long time_diff = 0;
	if(EgInstallInfo.isSuperManager)
	{
		Object obj = session.getAttribute("mgr_id_sm");
		if(obj != null)
		{
			ArrayList managerIDs = new ArrayList();
			String s_mgrid=(String)obj;
			managerIDs.add(s_mgrid);
			if(EgSmThread.timeDiffHt.containsKey(s_mgrid))
			{
				String diffInLong = (String)EgSmThread.timeDiffHt.get(s_mgrid);
				try
				{
					time_diff = Long.parseLong(diffInLong);
				}
				catch(Exception e)
				{
				}
			}
			Hashtable paramHt = new Hashtable();
			paramHt.put("managerIds",managerIDs);
			EgSMDBHelper.paramsOfJSP.put(session.getId(),paramHt);
			SmSessionData smsData = new SmSessionData(session.getId(),managerIDs);
			EgThreadLocal egtl = new EgThreadLocal();
			egtl.set(smsData);
		}
	}
	EgTesterInfo testerInfo=new EgTesterInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgMaintenanceInfo maintenanceInfo = new EgMaintenanceInfo("manager");
	EgMaintenanceUtility egM=new EgMaintenanceUtility();
	ArrayList globalThresholds=testerInfo.getGlobalThresholds();
%>
<jsp:useBean id="teststatus" class="egurkha.TestStatusInfo"/>
<%
	// 1/30/2006 Thirumal
	EgThresholdInfo threshInfo = new EgThresholdInfo("manager"); 
	String defValue = "-";
	Vector vect = null;
	EgDbInfo dbInfo = new EgDbInfo("manager");
	// *****ends*******
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgTopoInfo topoInfo = new EgTopoInfo("manager", true);
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	String topoFile= "eg_topology.ini";
	IniFile ini_read =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/" + topoFile,true);
%>
<%
try
{
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	UserRegistry registry    = UserRegistry.getInstance();
	User user                = registry.getUser(session.getId());
	//User user = null;
	/*if(from_sm)
	{
		user = registry.getUser(sessionId_sm);
	}
	else
	{
		user = registry.getUser(session.getId());
	}*/

	String loginid = user.getLoginID();
	EgUserRole userRole = user.getUserRole();
	boolean hasAdminTab = userRole.hasAnyAdminRole(EgUserPermission.ADMIN);
	boolean hasThreshold = userRole.hasAnyAdminRole(EgUserPermission.AGENT_THRESHOLD_CONFIG);
	boolean hasSpecificTestConfiguration = userRole.hasAnyAdminRole(EgUserPermission.AGENT_TEST_CONFIG);
	boolean isCompletedUserRole = userRole.hasAllComponentAccess();
	boolean isAdmin = user.isAdmin();
	boolean isNotOpenNewWindow = false;

	boolean isDefaultThreshType = false;
	boolean isSpecificThreshType = false;
	boolean isGroupThreshType = false;
	boolean isGlobalThreshType = false; 
	String threshDispVal = null;
	LangInfo langinfo = new LangInfo(loginid);
	String LABELS = "LABELS";
	//String thisLanguage = "en_US";
	String thisLanguage = ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	EgDateInfo dateInfo = new EgDateInfo();
	EgRoleInfo roleInfo = EgRoleInfo.getInstance(session.getId(),loginid);
	/*if(from_sm)
	{
		roleInfo = EgRoleInfo.getInstance(sessionId_sm,loginid);
	}
	else
	{
		roleInfo = EgRoleInfo.getInstance(session.getId(),loginid);
	}*/
	String s_host = "";
	String info = "";
	String s_ttype = "";
	String s_tstate = "";
	String s_mstate = "";
	String s_mespresent = "";
	String s_msmttime = "";
	String s_msmthost = "";
	String s_frequencyOfTest = "";
	String s_timeSinceLastMeasure = "";
	String s_isVM = "";
	String[]	str_field_list = null;
	String str_test_table=null;
	Vector v_teststatusinfo = new Vector();
	Vector v_trans4site = new Vector();
	Vector v_tgname = new Vector();

	boolean b_isAgentRunning = false;
	boolean b_isTestRunning = false;
	boolean b_isTestConfigured = false;
	boolean b_isInfoAvailableForMeasure = false;
	boolean isVM = false;

	String s_site = request.getParameter("site");
	String s_stype = request.getParameter("stype");
	String thresholdValueSetting = request.getParameter("thresholdValueSetting");
	String s_sname =EgURLDecoder.decode(request.getParameter("sname"),"UTF-8");
	String hostName = s_sname;
	String s_sport = request.getParameter("sport");
	String compName = null;
	String portVal = null;
	if(StringUtils.isNull(s_sport))
	{
		portVal = discInfo.getPortForHost(s_sname,s_stype);
	}
	else
	{
		portVal = s_sport;
	}
	String s_sinfo = request.getParameter("sinfo");
	if(s_stype.equals("Oracle_server"))
	{
		if(s_sport.indexOf(":") == -1)
		{
			if (s_sinfo != null && !s_sinfo.equalsIgnoreCase("null"))
			{
				compName = s_sname+":"+portVal+":"+s_sinfo;
			}
			else
			{
				compName = s_sname+":"+portVal;
			}
		}
		else
		{
			compName = s_sname+":"+portVal;
		}
	}
	else
	{
		compName = s_sname+":"+portVal;
	}
	String s_tname = request.getParameter("tname");
	String s_layer = request.getParameter("layer");
	String s_desc = request.getParameter("desc");
	s_desc=com.egurkha.util.StringUtils.decodeSecurityChar(s_desc);
	String descriptor = request.getParameter("info");
	if(s_desc == null )
		s_desc = descriptor;

	s_isVM = request.getParameter("isVM");

	isVM = (new Boolean(s_isVM)).booleanValue();
	
	if(s_desc!=null)
		s_desc = EgURLDecoder.decode(s_desc.trim(),"UTF-8");
	if(descriptor!=null)
		descriptor = EgURLDecoder.decode(descriptor.trim(),"UTF-8");
	
	String callFrom = request.getParameter("callFrom");

	int ii = s_desc.indexOf("etouq");
	if (ii > 0)
	{
		s_desc = s_desc.substring(0,s_desc.indexOf("etouq"))+ "\"" +s_desc.substring(s_desc.indexOf("etouq")+5,s_desc.length());
	}

	String infoForAdminURL = s_desc;
	if(infoForAdminURL!=null && infoForAdminURL.indexOf("- ") >-1)
	{
		infoForAdminURL=infoForAdminURL.substring(infoForAdminURL.indexOf("- ")+1,infoForAdminURL.length());
		infoForAdminURL = infoForAdminURL.trim();
	}
	else if(infoForAdminURL!=null && infoForAdminURL.indexOf("-") >-1)
	{
		infoForAdminURL=infoForAdminURL.substring(infoForAdminURL.indexOf("-")+1,infoForAdminURL.length());
		infoForAdminURL = infoForAdminURL.trim();
	}
	String desc=" ";
	if(s_desc!=null && s_desc.indexOf("- ") >-1)
	{
		desc=s_desc.substring(s_desc.indexOf("- ")+1,s_desc.length());
	}
	else if(s_desc!=null)
	{
		desc=s_desc.substring(s_desc.lastIndexOf("-")+1,s_desc.length());
	}

	if(desc!=null && desc.trim().length()>0)
	{
		s_desc = desc.trim();
	}
	else
	{
		s_desc = "NONE";
	}
	if(s_desc!=null && s_desc.length()>0)
	{
		s_desc = StringUtils.replace(s_desc,"|plus|","+");
		s_desc = StringUtils.replace(s_desc,"|pct|","%");
		s_desc = StringUtils.replace(s_desc,"|amp|","&");
		s_desc = StringUtils.replace(s_desc,"|hash|","#");
	}
	
	if(infoForAdminURL!=null && infoForAdminURL.length()>0)
	{
		infoForAdminURL = StringUtils.replace(infoForAdminURL,"|plus|","+");
		infoForAdminURL = StringUtils.replace(infoForAdminURL,"|pct|","%");
		infoForAdminURL = StringUtils.replace(infoForAdminURL,"|amp|","&");
		infoForAdminURL = StringUtils.replace(infoForAdminURL,"|hash|","#");
	}
	s_tstate = request.getParameter("tstate");
	s_mstate = request.getParameter("mstate");

	if(descriptor!=null&&descriptor.length()>0)
	{
		descriptor = StringUtils.replace(descriptor,"|plus|","+");
		descriptor = StringUtils.replace(descriptor,"|pct|","%");
		descriptor = StringUtils.replace(descriptor,"|amp|","&");
		descriptor = StringUtils.replace(descriptor,"|hash|","#");
	}

	
	//if (s_tstate==null || s_tstate.length()==0||s_tstate.equalsIgnoreCase("NULL") ||s_tstate.equals("GOOD"))
	if(s_mstate != null && s_mstate.length() > 0)
		s_tstate = s_mstate;
	s_mespresent = request.getParameter("mespresent");
	s_msmttime = request.getParameter("msmttime");
	s_msmttime = s_msmttime.replace('*',' ');
	s_msmthost = "Target Host";
	String s_qString = request.getQueryString();
	s_host = s_sname;

	if (EgInstallInfo.isSuperManager)
	{
		java.text.SimpleDateFormat formatter = new java.text.SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
		try
		{
			java.util.Date date = formatter.parse(s_msmttime); 
			long time1 = date.getTime();
			//time1 = time1+(-246000);
			time1 = time1 + time_diff;
			java.util.Date newDate = new java.util.Date(time1);

			formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");  
			String new_s_msmttime = formatter.format(newDate);
			s_msmttime=new_s_msmttime;
		}
		catch(Exception e)
		{
			//e.printStackTrace();
		}
	}

	if(!EgInstallInfo.isSuperManager)
	{
		EgDbAdapterUI egDb=EgDbAdapterTypeUI.getObject();
		ResultSet rs= null;
		try
		{
			String strinfo="+"+s_desc.trim();
			String s_status = egDb.setConnection();

			if(s_tname!=null && s_layer!=null)
			{
				str_test_table = dbInfo.getTableForTest(s_tname);
				str_field_list = dbInfo.getColumnNamesForTest(s_tname,s_layer);
			}

			rs=egDb.SelectDispMeasure_1(str_field_list, str_test_table, s_host, s_sport, s_site,ui.getReverseLookedupString(strinfo), "+", "", null);
			ResultSetMetaData rsmd = rs.getMetaData();
			if(rs.next())
			{
				int columnCount = rsmd.getColumnCount();
				//String str_time = rs.getString(columnCount-2);egcomp[o
				s_msmttime = rs.getString(columnCount-2);
			}

			if (rs != null)
			{
				try
				{
					rs.close();
				}
				catch (Exception bug123) {}
			}
			rs=null;
			egDb.releaseConnection(false);
			//EgDbAdapterTypeUI.releaseObject(egDb);
		}
		catch(Exception e)
		{
			try
			{
				if (rs != null)
				{
					rs.close();
				}
				rs=null;
			}
			catch (Exception bug123) {}
			egDb.releaseConnection(true);
		}
		finally
		{
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
	}
	s_sname = s_sname + ":" + s_sport;

	if(s_stype.equals("Oracle_server"))
	{
		if(s_sinfo != null && !s_sinfo.equals(""))
		{
			s_sname = s_sname + ":" + s_sinfo;
		}
	}

	specsInfo.checkForUpdate();
	boolean b_isTestExternal = specsInfo.isTestExternal(s_tname,s_stype);
	if(b_isTestExternal)
	{
		s_ttype = "External";
	}
	else
	{
		EgAgentInfo agentInfo = new EgAgentInfo("manager");
		boolean isAgentlessServer = agentInfo.isAgentlessServer(s_host,s_stype);
		if(isAgentlessServer)
			s_ttype = "Remote";
		else
			s_ttype = "Internal";
	}

	if (s_stype != null)
	{
		s_stype = s_stype.trim();
	}

	if (s_sname != null)
	{
		s_sname = s_sname.trim();
	}

	/*
	 * Read eg_discover.ini and get host IP
	 */
	IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_discover.ini");
	String serverType = null;

	/*
	 * If faketype is set, use it instead of stype only if the server type is set to Host_system
	 */
	String fakeType = request.getParameter("faketype");

	if (fakeType!=null && fakeType.equalsIgnoreCase("host_system"))
	{
		fakeType = discInfo.getTypeForHostTest(s_host,s_tname);
	}

	if (fakeType != null)
	{
		fakeType = fakeType.trim();
	}

	if (!StringUtils.isNull(fakeType) && s_stype.equals(Server.HOST_SYSTEM))
	{
		serverType = fakeType;
	}
	else
	{
		serverType = s_stype;
	}

	StringBuffer key = new StringBuffer();
	key.append(serverType);
	key.append(":");
	key.append(s_sname);

	String value = iniFile.getValue(serverType, key.toString());

	if(!specsInfo.isPortRelevantForTest(s_tname) && value.length()==0)
	{
		Vector allvalues=(Vector)iniFile.getVariables(serverType,false);
		if(allvalues != null && allvalues.size() > 0)
		{
			for (int i=0;i<allvalues.size();i++)
			{
				String tmpcomp=(String)allvalues.get(i);
				if (tmpcomp.indexOf(s_sname.substring(0,s_sname.indexOf(":")+1))>-1)
				{
					value = iniFile.getValue(serverType, tmpcomp);
					break;
				}
			}
		}
	}
	/*
	 * Read eg_agents.ini and get test particulars
	 */
	String s_tempStr = null;
	String s_tempStr1 = null;

//	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	if(specsInfo.isPortRelevantForTest(s_tname))
	{
		s_tempStr = s_tname +":"+s_stype+":"+ s_sname;
		s_tempStr1 = s_tname +"::"+ s_sname;
	}
	else
	{
		s_tempStr = s_tname +"::"+ Server.getServerNameWithoutPort(s_sname);
		s_tempStr1 = "";
	}
	String reqMsmtHost = EgURLDecoder.decode(request.getParameter("msmt_host"),"UTF-8");
	iniFile = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_agents.ini");
	String agentsIniValue = iniFile.getValue(reqMsmtHost, s_tempStr).trim();
	if (agentsIniValue == "" && s_tempStr !=null && s_tempStr.indexOf("::")>-1)
	{
		StringTokenizer st = new StringTokenizer(s_tempStr,":");
		String s1 = st.nextToken();
		String s2 = st.nextToken();
		agentsIniValue = iniFile.getValue(reqMsmtHost,s1+":"+s_stype+":"+s2);
	}
	if(agentsIniValue == null || agentsIniValue.equals(""))
	{
		agentsIniValue = iniFile.getValue(reqMsmtHost, s_tempStr1).trim();
	}
	boolean showTestStatusInfo = (value != null && value.indexOf(",") > -1) && (agentsIniValue != null && agentsIniValue.indexOf(",") > -1);

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String strChildWindow = (String)session.getAttribute("isNewChildWindow");
	if(StringUtils.isNull(strChildWindow))
	{
		strChildWindow = "no";
	}

	screenLabels.put("Testmeasure",mappingInfo.getTextDescription("monitor.testDetails.Test Measure Status Info"));

	if(EgInstallInfo.isSuperManager)
	{
		screenLabels.put("ManagerType",mappingInfo.getTextDescription("monitor.common.eG SuperManager"));
	}
	else
	{
		screenLabels.put("ManagerType",mappingInfo.getTextDescription("monitor.common.eG Manager"));

	}
	
	if (callFrom!=null && callFrom.equals("aggregates"))
	{

	}
	else
	{

	}

	if(callFrom == null || !callFrom.equals("aggregates") || callFrom.length() <= 0 )
	{

	}
	if (!showTestStatusInfo)
	{
		String string = serverType + ":" + Server.getServerNameWithoutPort(s_sname, false);

		screenLabels.put("Nolonger",mappingInfo.getTextDescription("monitor.testDetails.This component is no longer managed"));

		s_tnameValue.put("or",mappingInfo.getTextDescription("monitor.testDetails.Or"+s_tname));
		//display.put("s_tname",s_tname);

		screenLabels.put("DisabledComponent",mappingInfo.getTextDescription("monitor.testDetails.is disabled for this component"));
	}
	else
	{
		int startIndex = value.indexOf(",") + 1;
		int endIndex = value.indexOf(",", startIndex);
		String ipAddr = value.substring(startIndex, endIndex);

		boolean b_isPortRelevantForTest = specsInfo.isPortRelevantForTest(s_tname);
		if(!b_isPortRelevantForTest)
		{
			//New code
			//to display sun08.chn.egurkha.com
			//instead of sun08.chn.egurkha.com:1521:egurkha
			if(s_stype.equals("Oracle_server"))
			{
				s_sname = s_sname.substring(0,s_sname.indexOf(":"));
			}
			else
			{
				s_sname = s_sname.substring(0,s_sname.lastIndexOf(":"));
			}
		}
//		boolean b_isTestDisabled = teststatus.isTestDisabled(s_stype,s_sname,s_tname);
		boolean b_isTestDisabled = teststatus.isTestDisabled(serverType,s_sname,s_tname);
		//boolean b_isTestDisabled = true;
		if(!b_isTestDisabled)
		{
			if(!s_stype.equalsIgnoreCase("Oracle_server"))
			{
				s_frequencyOfTest = teststatus.frequencyOfTest(s_stype,s_host + ":" + s_sport,s_tname);
			}
			else
			{
				s_frequencyOfTest = teststatus.frequencyOfTest(s_stype,s_host + ":" + s_sport + ":" + s_sinfo,s_tname);
			}
		}
		else
		{
			s_frequencyOfTest = "Not Applicable";
		}
		// If the state of the test is UNKNOWN
		//if(s_tstate.equals("UNKNOWN") && s_mespresent.equals("no"))
		if(s_tstate.equals(EgConfigInfo.UNKNOWN_STATE) && s_mespresent.equals("no"))
		{
			b_isTestConfigured = teststatus.isTestConfigured(s_stype,s_sname,s_tname);
			if(b_isTestConfigured)
			{
				v_teststatusinfo.addElement("The agent has not reported measures yet&#46");
				v_teststatusinfo.addElement("Possible reasons:");
				v_teststatusinfo.addElement("The agent might not be running on the system or it might have just been started&#46");
				v_teststatusinfo.addElement("If the agent has just been started, the state of the test will soon turn to Good/Bad&#46");
				v_teststatusinfo.addElement("If the agent has been running for a long time, either the agent is unable to connect to the manager or the agent is not reporting any measures as the component being monitored might not be running&#46");
			}
			else
			{
				v_teststatusinfo.addElement("The agent is not reporting measures to the manager&#46");
				v_teststatusinfo.addElement("The test has not been configured&#46");
			}
		}
		//else if(s_tstate.equals("UNKNOWN") && s_mespresent.equals("yes"))
		else if(s_tstate.equals(EgConfigInfo.UNKNOWN_STATE) && s_mespresent.equals("yes"))
		{
			b_isAgentRunning = teststatus.isAgentRunning(s_msmttime);
			b_isTestRunning = teststatus.isTestRunning();
			b_isTestConfigured = teststatus.isTestConfigured(s_stype,s_sname,s_tname);
			s_timeSinceLastMeasure = teststatus.returnTimeSinceLastMeasure();
			if((s_mstate != null) && (s_mstate.equals("GOOD") ||  s_mstate.equals("BAD")))
			{
				if(b_isTestRunning)
				{
					v_teststatusinfo.addElement("The agent has not reported measures in the last " + ((int)3 * Integer.parseInt(s_frequencyOfTest))+ " secs&#46 The state of this test will soon change to GOOD/BAD if the agent continues to report regularly&#46");
				}
				else
				{
					v_teststatusinfo.addElement("The agent is not reporting measures currently&#46 The last known state of this test is " + s_mstate + "&#46");
					v_teststatusinfo.addElement("Possible reasons:");
					v_teststatusinfo.addElement("The agent might not be running on the system or it might have just been started&#46");
					v_teststatusinfo.addElement("If the agent has just been started, the state of the test will soon turn to Good/Bad&#46");
					v_teststatusinfo.addElement("If the agent has been running for a long time then the agent is unable to communicate to the manager&#46");
					v_teststatusinfo.addElement("This could also mean that the agent is unable to make any valid measures as the component being monitored is not running&#46");
				}
			}
			else if((s_mstate != null) && s_mstate.equals("UNKNOWN"))
			{
				if(b_isTestRunning && b_isTestConfigured)
				{
					v_teststatusinfo.addElement("The agent is not reporting proper measures to the manager&#46");
					v_teststatusinfo.addElement("Possible reasons:");
					v_teststatusinfo.addElement("The test has not been configured properly&#46 The configurable parameters for this test have not been provided accurately&#46 Please configure the test correctly&#46");
				}
				else if(!b_isTestRunning)
				{
					v_teststatusinfo.addElement("The agent is not reporting proper measures to the manager&#46");
					v_teststatusinfo.addElement("Possible reasons:");
					v_teststatusinfo.addElement("The agent might not be running in the system&#46");
				}
				else if(!b_isTestConfigured)
				{
					v_teststatusinfo.addElement("The agent is not reporting proper measures to the manager&#46");
					v_teststatusinfo.addElement("Possible reasons:");
					v_teststatusinfo.addElement("All the parameters required for the this test to execute has not been provided. Please provide the necessary parameters&#46");	
				}
			}
		}
		// If the state of the test is GOOD
		//if(s_tstate.equals("GOOD") && s_mespresent.equals("no"))
		if(s_tstate.equals(EgConfigInfo.GOOD_STATE) && s_mespresent.equals("no"))
		{
			b_isInfoAvailableForMeasure = teststatus.isInfoAvailableForMeasure(s_tname,s_host,s_site,s_sport);
			if(b_isTestDisabled)
			{
				v_teststatusinfo.addElement("The test has been disabled for the component&#46");
			}
			else if(b_isInfoAvailableForMeasure)
			{
				v_teststatusinfo.addElement("The eG manager has received data for this test and is in the process of indexing the data&#46 Please wait for a short while for the process to complete&#46");
			}
			else
			{
				if(s_tname.equals("WebSiteTransactionTest"))
				{
					if((s_site != null) && !s_site.equals(""))
					{
						v_trans4site = teststatus.trans4Site(s_site);
						if(v_trans4site.size() == 0)
						{
							v_teststatusinfo.addElement("The agent has not reported measures yet&#46");
							v_teststatusinfo.addElement("Possible reasons:");
							v_teststatusinfo.addElement("Transactions have not been configured for the site&#46");
						}
					}
				}
				else
				{
					v_teststatusinfo.addElement("The agent has not reported measures yet&#46");
					v_teststatusinfo.addElement("Possible reasons:");
					v_teststatusinfo.addElement("The corresponding agent might not be running or the agent might not have started this test yet&#46");
					v_teststatusinfo.addElement("If the agent is not running, the state of this test will soon turn to UNKNOWN. Otherwise, the measures will appear in a short while&#46");
					v_teststatusinfo.addElement("Note that if the agent has been running for a long time but the measures are not showing up, this means that the agent is unable to communicate to the manager&#46 Please refer to the trouble shooting guide&#46");
				}
			}
		}
		//else if(s_tstate.equals("GOOD") && s_mespresent.equals("yes"))
		else if(s_tstate.equals(EgConfigInfo.GOOD_STATE) && s_mespresent.equals("yes"))
		{
			b_isAgentRunning = teststatus.isAgentRunning(s_msmttime);
			b_isTestRunning = teststatus.isTestRunning();
			s_timeSinceLastMeasure = teststatus.returnTimeSinceLastMeasure();
			if((s_mstate != null) && s_mstate.equals("GOOD"))
			{
				if((!b_isTestRunning) && b_isTestDisabled)
				{
					v_teststatusinfo.addElement("This test has been disabled for this component&#46 The last state for this test was Healthy&#46");
				}
			}
			else if((s_mstate != null) && (s_mstate.equals("BAD") || s_mstate.equals("UNKNOWN")))
			{
				if(b_isTestDisabled)
				{
					v_teststatusinfo.addElement("This test has been disabled for this component&#46 The last state for this test was " + ui.getStateDisplayLabel(s_mstate) + "&#46");
				}
			}
		}
		
		if (EgConfigInfo.isBad(s_tstate) && s_mespresent.equals("yes"))
		{
			b_isAgentRunning = teststatus.isAgentRunning(s_msmttime);
			s_timeSinceLastMeasure = teststatus.returnTimeSinceLastMeasure();
		}
		screenLabels.put("MeasurementHost",mappingInfo.getTextDescription("monitor.testDetails.Measurement Host"));
		String measureHostData = EgURLDecoder.decode(request.getParameter("msmt_host"),"UTF-8");
		measureHost.put("MeasurementHostValue",measureHostData);
		screenLabels.put("ComponentTypeDisplay",mappingInfo.getTextDescription("monitor.testDetails.Component type"));


		if(isVM)
		{
			
			displayValue.put("ComponentTypeValue",mappingInfo.getComponentTypeDescription("VM"));

		}
		else
		{

			displayValue.put("ComponentTypeValue",mappingInfo.getComponentTypeDescription(s_stype));		// Display for Component Type
			
		}
		json.put("displayValue",displayValue);

		if(isVM)
		{
			screenLabels.put("ComponentValue",mappingInfo.getTextDescription("monitor.testDetails.VM Name"));

		}
		else
		{
			screenLabels.put("ComponentValue",mappingInfo.getTextDescription("monitor.testDetails.Component"));

		}
		
		
		if(!isVM)
		{
			
			if(s_sname.indexOf("NULL")>-1)
			{
				if(s_sname.length()>=s_sname.indexOf("NULL")+4)
				{
					String  names1= s_sname.substring(0,(s_sname.indexOf("NULL")-1));

					displayComponentValue.put("Component",names1);

					if(s_sname.substring(s_sname.indexOf("NULL")+4).length()>0)
					{
						String names = s_sname.substring(s_sname.indexOf("NULL")+4);
						displayComponentValue.put("Component",names);
						
					}
				}
				else
				{
					String nameValues = s_sname.substring(0,s_sname.indexOf("NULL"));
					displayComponentValue.put("Component",nameValues);
					
				}
		}
		else
		{
			displayComponentValue.put("Component",s_sname);		//display for component
			
		}

		//json.put("displayComponentValue",displayComponentValue);

		if (!s_sname.equals(ipAddr))
		{
			if(!ipAddr.equals("0.0.0.0")) //skm (31/01/2006) If only. Block Already Present.
			{
				ipAddress.put("ipAddr",ipAddr);
			}
		}
	
		json.put("displayComponentValue",displayComponentValue);
	}
		
		else
		{
			if(s_desc!=null && s_desc.length() > 0 && s_desc.indexOf(":")>-1)
			{
				s_descValue.put("s_desc",s_desc.substring(0,s_desc.indexOf(":")));
			}
			else
			{
				s_descValue.put("s_desc",s_desc);
			}
			
		}
		json.put("s_descValue",s_descValue);

		screenLabels.put("Testname",mappingInfo.getTextDescription("monitor.testDetails.Test name"));
		testNameValue.put("TestNameData",mappingInfo.getTestDescription(s_tname));		//display for Test name

		if(s_desc!=null && !s_desc.trim().equalsIgnoreCase("null") && !s_desc.trim().equalsIgnoreCase("none") && !s_desc.trim().equals("+"))
		{
			screenLabels.put("Description",mappingInfo.getTextDescription("monitor.testDetails.Descriptor"));
			
			if(isVM)
			{
				if(descriptor!=null && descriptor.length() >0)
				{
					if(s_desc.equalsIgnoreCase(descriptor))
					{
						getReverse.put("getReverseValue","Not Applicable!");
					}
					else
					{
						if(descriptor !=null && descriptor.indexOf(s_tname)>-1)
						{
							descriptor= descriptor.substring(descriptor.indexOf("-")+1);
						}
						getReverse.put("getReverseValue",descriptor);
					}
				}
				else
				{
					getReverse.put("getReverseValue","Not Applicable!");
				}
			}
			else
			{
				if(descriptor!=null&&descriptor.length()>0)
				{
					String reverse2 = ui.getReverseLookedupString(descriptor);

					if(reverse2 !=null && reverse2.length()>0 && reverse2.indexOf(s_tname)>-1)
					{
						reverse2= reverse2.substring(reverse2.indexOf("-")+1);
					}

					getReverse.put("getReverseValue",reverse2);
				}
				else
				{
					if(ui.getReverseLookedupString(s_desc).equalsIgnoreCase("none"))
					{
						//getReverse.put("getReverseValue",mappingInfo.getTextDescription("monitor.testDetails."+ui.getReverseLookedupString(s_desc)));
						String reverse = ui.getReverseLookedupString(s_desc);

						if(reverse !=null && reverse.length()>0 && reverse.indexOf(s_tname)>-1)
						{
							reverse= reverse.substring(reverse.indexOf("-")+1);
						}

						getReverse.put("getReverseValue",reverse);

					}
					else
					{
						String reverse1 = ui.getReverseLookedupString(s_desc);
						reverse1=findAndReplaceString(reverse1,"\\\\","\\");

						if(reverse1 !=null && reverse1.length()>0 && reverse1.indexOf(s_tname)>-1)
						{
							reverse1= reverse1.substring(reverse1.indexOf("-")+1);
						}

						getReverse.put("getReverseValue",reverse1);
					}
				}
			}
			json.put("getReverse",getReverse);
		}
		String s_pat = specsInfo.getTestInfoPattern(s_tname);
		String s_pat_display = specsInfo.getTestPatternDisplay(s_pat);
		String s_del = specsInfo.getTestInfoDelimiter(s_tname);
		String s_pattern = teststatus.getPatternForInfo(s_tname.trim(), s_stype.trim(), s_host.trim()+ ":" + s_sport.trim() ,s_sinfo, s_desc.trim(), "-" + s_pat, s_del);
		
		String tempVar = s_pat_display;
		if (tempVar!=null && tempVar.length()>0)
		{
			screenLabels.put("UrlAccessed",mappingInfo.getTextDescription("monitor.testDetails."+tempVar));
		}

		JSONObject  UrlAccessed = new JSONObject();
		if(s_pat.equals("url"))
		{
			s_pattern = s_pattern.replace('!','&');
			UrlAccessed.put("urlLastAccessed",s_pattern);
			json.put("urlAccess",UrlAccessed);
		}
		if(s_pattern != null && s_pattern.length() > 0 && s_pat_display!=null && s_pat_display.length()>0)
		{
			if(s_pattern!=null && s_pattern.endsWith("\""))
			{
				s_pattern=s_pattern.substring(0,s_pattern.length()-1);
				UrlAccessed.put("urlLastAccessed",s_pattern);
				json.put("urlAccess",UrlAccessed);
			}
		}
		if(s_frequencyOfTest!=null && s_frequencyOfTest.trim().length()>0 && !s_frequencyOfTest.equalsIgnoreCase("NULL"))
		{
			String[] defaultTestPeriods = egUI.getVariables("TEST_FREQUENCY");
			if (defaultTestPeriods != null && defaultTestPeriods.length > 0)
			{
				for (int t=0;t<defaultTestPeriods.length;t++)
				{
					String strTestPeriod = egUI.getValue("TEST_FREQUENCY",defaultTestPeriods[t]);
					if (strTestPeriod != null && strTestPeriod.equals(s_frequencyOfTest))
					{
						s_frequencyOfTest = defaultTestPeriods[t];
						break;
					}
				}
			}
		}
		screenLabels.put("TestTypeDisplay",mappingInfo.getTextDescription("monitor.testDetails.Test type"));
		testTypeValue.put("TestType",mappingInfo.getTextDescription("monitor.testDetails."+s_ttype));		// display for Test Type

		screenLabels.put("TestFrequency",mappingInfo.getTextDescription("monitor.testDetails.Test frequency"));
		testFrequencyValue.put("frequencyOfTest",mappingInfo.getTextDescription("monitor.testDetails."+s_frequencyOfTest));		//display for Test frequency

		screenLabels.put("TimeSincelast",mappingInfo.getTextDescription("monitor.testDetails.Time since last measure"));
		
		if(!s_timeSinceLastMeasure.equals(""))
		{
			timeSince.put("timeSinceLastMeasure",s_timeSinceLastMeasure);
		}
		else
		{
			timeSince.put("timeSinceLastMeasure",mappingInfo.getTextDescription("monitor.testDetails.Not Available"));
		}
		json.put("timeSince",timeSince);	//display for time since last measure


		v_tgname = specsInfo.getTestsWithGroupNames();
		if(v_tgname.contains(s_tname))
		{
			String aliasName="empty";
			String[] aliasNames = ini_read.getVariables("GROUP_RELATIONSHIP");
			Hashtable groups = null;
			for (int kk=0;kk<aliasNames.length;kk++)
			{
				String relatedTests = ini_read.getValue("GROUP_RELATIONSHIP",aliasNames[kk]);
				if(relatedTests.indexOf(s_tname) > -1)
				{
					aliasName=aliasNames[kk];
					break;
				}
			}
			if(aliasName.equalsIgnoreCase("empty"))
			{
				groups = topoInfo.getTestInfos(s_tname,s_sname);
				if(groups==null || groups.size()==0)
					groups = topoInfo.getEjbGroups(s_tname,s_sname);
			}
			else
			{
				groups = topoInfo.getTestInfos(aliasName,s_sname);
			}
			if(groups != null)
			{
				info = (String) groups.get(s_desc.trim());
			}
			Vector v_disp_infos = new Vector();
			if (info != null && !info.equals(""))
			{
				JSONArray dispInfoArray = new JSONArray();
				StringTokenizer st = new StringTokenizer(info,",");
				while(st.hasMoreTokens())
				{
					v_disp_infos.add(st.nextToken().trim());
				}

				for(int i=0;i<v_disp_infos.size();i++)
				{
					String s_dispInfo=(String)v_disp_infos.get(i);
					if(i!=v_disp_infos.size()-1)
					s_dispInfo +=",&nbsp;";

					dispInfoArray.add(s_dispInfo);

				}
				dispInfoArrayObj.put("dispInfoArray",dispInfoArray);

			}
		}

		boolean isPortRelevantForTest = specsInfo.isPortRelevantForTest(s_tname);
		String tempPort =s_sport;
		String mdate  = null;
		String mtime  = null;
		String dispDate = null;
		String policyGroupName = null;
		String policyName = "";
		boolean isHostinMaintenance = false;
		boolean istestandHostinMaintenance = false;
		boolean isTestinMaintenance = false;
		boolean isComponentinMaintenance = false;
		boolean istestandComponentinMaintenance = false;
		boolean isDescriptorMaintenanceForTest = false;
		boolean isDescriptorMaintenanceForComponent = false;
		String serverSection     = "SERVERS";
		String groupSection     = "GROUPS";
		String egMaintenanceFile = "eg_maintenance.ini";
		String maintenanceFileName = new String(EgConfigInfo.egMgrConfigDir + egMaintenanceFile);
		IniFile maintenanceFilePointer = new IniFile(maintenanceFileName, false);
		ArrayList policygrps=new ArrayList();
		if(s_msmttime.indexOf(" ")>-1)
		{
			mdate = s_msmttime.substring(0,s_msmttime.indexOf(" "));
			mtime = s_msmttime.substring(s_msmttime.indexOf(" ")+1);
		}
		if(mdate!=null)
		{
			dispDate = DateUtil.changeDateFormat(mdate,"dd/mm/yyyy","mm/dd/yyyy");
			dispDate = dispDate+" "+mtime;
		}
		dispDate=dateInfo.egetDate(); // current date used instead of last  measure time for Maintenance

		if(dispDate!=null&&!dispDate.equals(" "))
		{
			isHostinMaintenance = maintenanceInfo.isItMaintenanceTime(dispDate,hostName,"","",true);
			isComponentinMaintenance = maintenanceInfo.isItMaintenanceTime(dispDate,hostName,tempPort,s_sinfo,true);
			isTestinMaintenance = maintenanceInfo.isItMaintenanceTime(s_tname,dispDate,true);
			istestandHostinMaintenance  =maintenanceInfo.isItMaintenanceTime(s_tname,dispDate,hostName,"",s_sinfo,true);
			istestandComponentinMaintenance  =maintenanceInfo.isItMaintenanceTime(s_tname,dispDate,hostName,tempPort,s_sinfo,true);
			if(!StringUtils.isNull(s_desc))
			{
				isDescriptorMaintenanceForTest=maintenanceInfo.isItMaintenanceTime(s_tname, dispDate,s_desc,true);
						
				if(!isPortRelevantForTest)
				{
					tempPort = "NULL";
					s_sport = tempPort;
				}

				isDescriptorMaintenanceForComponent=maintenanceInfo.isItMaintenanceTime(s_tname, dispDate, hostName, tempPort, s_sinfo,s_desc,true);
			}
		}
		if(hostName!=null && !hostName.equals("") && tempPort!=null && !tempPort.equalsIgnoreCase("NULL") &&!isPortRelevantForTest&&isComponentinMaintenance)
		{
			isComponentinMaintenance = false;
		}
		String temgroupName = null;
		String matchCriteria = "";
		if(isHostinMaintenance&&isTestinMaintenance)
		{
			matchCriteria = hostName+"/"+mappingInfo.getTestDescription(s_tname);

			policyGroupName = maintenanceFilePointer.getValue(serverSection, hostName);

			temgroupName =  maintenanceFilePointer.getValue(serverSection,"#"+s_tname);
			if(policyGroupName!=null&&!temgroupName.equals("")&&!policyGroupName.trim().equals(temgroupName))
			{
				policyGroupName +="," +temgroupName;
			}
		}
		else if(isHostinMaintenance&&!isTestinMaintenance)
		{
			matchCriteria = hostName;
			policyGroupName = maintenanceFilePointer.getValue(serverSection,hostName);
			if(policyGroupName!=null&&!policyGroupName.equals(""))
			{
				policyGroupName +="," +maintenanceFilePointer.getValue(serverSection,hostName);
			}
			else
			{
				policyGroupName =maintenanceFilePointer.getValue(serverSection,hostName);
			}
		}
		if(isComponentinMaintenance&&isTestinMaintenance)
		{
			matchCriteria = hostName+":"+s_sport+"/"+mappingInfo.getTestDescription(s_tname);
			if(s_stype.equals("Oracle_server"))
			{
				temgroupName = maintenanceFilePointer.getValue(serverSection, hostName+":"+s_sport+":"+s_sinfo);
				if(policyGroupName!=null&&!policyGroupName.trim().equals(temgroupName))
				{
					policyGroupName +="," +temgroupName;
				}
				else
				{
					if(policyGroupName!=null&&!policyGroupName.equals(""))
					{
						policyGroupName +="," +temgroupName;
					}
					else
					{
						policyGroupName =temgroupName;
					}
				}
			}
			else
			{
				temgroupName = maintenanceFilePointer.getValue(serverSection, hostName+":"+s_sport);
				if(policyGroupName!=null&&!policyGroupName.trim().equals(temgroupName))
				{
					policyGroupName +="," +temgroupName;
				}
				else
				{
					if(policyGroupName!=null&&!policyGroupName.equals(""))
					{
						policyGroupName +="," +temgroupName;
					}
					else
					{
						policyGroupName =temgroupName;
					}
				}
			}
			temgroupName = maintenanceFilePointer.getValue(serverSection,"#"+s_tname);
			if(policyGroupName!=null&&!policyGroupName.trim().equals(temgroupName))
			{
				policyGroupName +="," +temgroupName;
			}
			else
			{
				if(policyGroupName!=null&&!policyGroupName.equals(""))
				{
					policyGroupName +="," +temgroupName;
				}
				else
				{
					policyGroupName =temgroupName;
				}
			}
		}
		else if(isComponentinMaintenance&&!isTestinMaintenance)
		{
			matchCriteria = hostName+":"+s_sport;
			if(s_stype.equals("Oracle_server"))
			{
				temgroupName =maintenanceFilePointer.getValue(serverSection, hostName+":"+s_sport+":"+s_sinfo);
				if(policyGroupName!=null&&!policyGroupName.trim().equals(temgroupName))
				{
					policyGroupName +="," +temgroupName;
				}
				else
				{
					if(policyGroupName!=null&&!policyGroupName.equals(""))
					{
						policyGroupName +="," +temgroupName;
					}
					else
					{
						policyGroupName =temgroupName;
					}
				}
			}
			else
			{
				temgroupName =maintenanceFilePointer.getValue(serverSection, hostName+":"+s_sport);
				if(policyGroupName!=null&&!policyGroupName.trim().equals(temgroupName))
				{
					policyGroupName +="," +temgroupName;
				}
				else
				{
					if(policyGroupName!=null&&!policyGroupName.equals(""))
					{
						policyGroupName +="," +temgroupName;
					}
					else
					{
						policyGroupName =temgroupName;
					}
				}
			}
			
		}
		if(isTestinMaintenance&&matchCriteria.equals(""))
		{
			matchCriteria = mappingInfo.getTestDescription(s_tname);
			//policyGroupName =maintenanceFilePointer.getValue(serverSection,"#"+s_tname);
			if(policyGroupName!=null&&!policyGroupName.equals(""))
			{
				policyGroupName +="," +maintenanceFilePointer.getValue(serverSection,"#"+s_tname);
			}
			else
			{
				policyGroupName =maintenanceFilePointer.getValue(serverSection,"#"+s_tname);
			}
		}
		if(istestandComponentinMaintenance)
		{
			matchCriteria =  mappingInfo.getTestDescription(s_tname)+"/"+hostName+":"+s_sport;
			if(s_sport!=null&&!s_sport.equals("NULL"))
			{
					if(s_stype.equals("Oracle_server"))
					{
						temgroupName =maintenanceFilePointer.getValue(serverSection, hostName+":"+s_sport+":"+s_sinfo+"#"+s_tname);
						if(policyGroupName!=null&&!temgroupName.equals("")&&!policyGroupName.trim().equals(temgroupName))
						{
							policyGroupName +="," +temgroupName;
						}
						else
						{
							if(policyGroupName!=null&&!policyGroupName.equals(""))
							{
								policyGroupName +="," +temgroupName;
							}
							else
							{
								policyGroupName =temgroupName;
							}
						}
					}
					else
					{
						temgroupName =maintenanceFilePointer.getValue(serverSection, hostName+":"+s_sport+"#"+s_tname);
						if(policyGroupName!=null&&!temgroupName.equals("")&&!policyGroupName.trim().equals(temgroupName))
						{
							policyGroupName +="," +temgroupName;
						}
						else
						{
							if(policyGroupName!=null&&!policyGroupName.equals(""))
							{
								policyGroupName +="," +temgroupName;
							}
							else
							{
								policyGroupName =temgroupName;
							}
						}
					}
				
			}
			else
			{
				temgroupName=maintenanceFilePointer.getValue(serverSection, hostName+":"+s_sport+"#"+s_tname);
				if(policyGroupName!=null&&!temgroupName.equals("")&&!policyGroupName.trim().equals(temgroupName))
				{
					policyGroupName +="," +temgroupName;
				}
				else
				{
					if(policyGroupName!=null&&!policyGroupName.equals(""))
					{
						policyGroupName +="," +temgroupName;
					}
					else
					{
						policyGroupName =temgroupName;
					}
				}
			}
		}
		if(istestandHostinMaintenance)
		{
			matchCriteria =  mappingInfo.getTestDescription(s_tname)+"/"+hostName;
			temgroupName = maintenanceFilePointer.getValue(serverSection, hostName+"#"+s_tname);

			if(policyGroupName!=null&&!policyGroupName.trim().equals(temgroupName))
			{
					policyGroupName +="," +temgroupName;
			}
			else
			{
				if(policyGroupName!=null&&!policyGroupName.equals(""))
				{
					policyGroupName +="," +temgroupName;
				}
				else
				{
					policyGroupName =temgroupName;
				}
			}
		}
		if(isDescriptorMaintenanceForTest)
		{
			matchCriteria = mappingInfo.getTestDescription(s_tname)+"/"+ s_desc;
			temgroupName = maintenanceFilePointer.getValue(serverSection, "#"+s_tname+":"+s_desc);

			if(policyGroupName!=null&&!policyGroupName.trim().equals(temgroupName))
			{
					policyGroupName +="," +temgroupName;
			}
			else
			{
				if(policyGroupName!=null&&!policyGroupName.equals(""))
				{
					policyGroupName +="," +temgroupName;
				}
				else
				{
					policyGroupName =temgroupName;
				}
			}
		}
		if(isDescriptorMaintenanceForComponent)
		{
			matchCriteria =  hostName+":"+s_sport+"/"+mappingInfo.getTestDescription(s_tname)+"/"+s_desc;
			if(s_sport!=null&&!s_sport.equals("NULL"))
			{
					if(s_stype.equals("Oracle_server"))
					{
						temgroupName =maintenanceFilePointer.getValue(serverSection, hostName+":"+s_sport+":"+s_sinfo+"#"+s_tname+":"+s_desc);
						if(policyGroupName!=null&&!temgroupName.equals("")&&!policyGroupName.trim().equals(temgroupName))
						{
							policyGroupName +="," +temgroupName;
						}
						else
						{
							if(policyGroupName!=null&&!policyGroupName.equals(""))
							{
								policyGroupName +="," +temgroupName;
							}
							else
							{
								policyGroupName =temgroupName;
							}
						}
					}
					else
					{
						temgroupName =maintenanceFilePointer.getValue(serverSection, hostName+":"+s_sport+"#"+s_tname+":"+s_desc);
						if(policyGroupName!=null&&!temgroupName.equals("")&&!policyGroupName.trim().equals(temgroupName))
						{
							policyGroupName +="," +temgroupName;
						}
						else
						{
							if(policyGroupName!=null&&!policyGroupName.equals(""))
							{
								policyGroupName +="," +temgroupName;
							}
							else
							{
								policyGroupName =temgroupName;
							}
						}
					}
					}
			else
			{
				temgroupName=maintenanceFilePointer.getValue(serverSection, hostName+":"+s_sport+"#"+s_tname+":"+s_desc);
				if(policyGroupName!=null&&!temgroupName.equals("")&&!policyGroupName.trim().equals(temgroupName))
				{
					policyGroupName +="," +temgroupName;
				}
				else
				{
					if(policyGroupName!=null&&!policyGroupName.equals(""))
					{
						policyGroupName +="," +temgroupName;
					}
					else
					{
						policyGroupName =temgroupName;
					}
				}
			}
		}
		ArrayList policyInfos = null;
		policyInfos = new ArrayList();
		if((isHostinMaintenance||isComponentinMaintenance)&&isTestinMaintenance&&
			istestandComponentinMaintenance&&istestandHostinMaintenance && isDescriptorMaintenanceForComponent && isDescriptorMaintenanceForTest)
		{
			if(policyGroupName!=null&&policyGroupName.equals(""))
			{
				policyGroupName= "default";
			}
		}

		if(policyGroupName!=null&&!policyGroupName.equals(""))
		{
			StringTokenizer stkpgrp=new StringTokenizer(policyGroupName,",");
			while(stkpgrp.hasMoreTokens())
			{
				String policyGrp=stkpgrp.nextToken();
				if(!policygrps.contains(policyGrp))
				{
					policygrps.add(policyGrp);
				}
			}
		}
		if(policygrps!=null && policygrps.size()>0)
		{
			policyGroupName="";
			for(int j=0;j<policygrps.size();j++)
			{
				String policyGroup = (String)policygrps.get(j);
				if(policyGroupName!=null&& !policyGroupName.equals(""))
				{
					policyGroupName=policyGroupName+","+policyGroup;
				}
				else
				{
					policyGroupName=policyGroup;
				}
				String policy =maintenanceFilePointer.getValue(groupSection,policyGroup);
				if(policy.indexOf(",")>-1)
				{
					StringTokenizer tok = new StringTokenizer(policy,",");
					while(tok.hasMoreTokens())
					{
						String token = tok.nextToken();
						if(policyInfos!=null&&!policyInfos.contains(token)&&!token.equals(""))
						{
							policyInfos.add(token);
						}
					}
				}
				else
				{
					if(policyInfos!=null&&!policyInfos.contains(policy)&&!policy.equals(""))
					{
						policyInfos.add(policy);
					}
				}
			}
		}

		ArrayList Policies = new ArrayList();
		String policyNames = "";
		String policyTime = "";
		ArrayList policynams=new ArrayList();
		if(policyInfos!=null&&policyInfos.size()>0)
		{
			for(int j=0;j<policyInfos.size();j++)
			{
				Policies = new ArrayList();
				String policy = (String)policyInfos.get(j);
				String policyDetails = maintenanceFilePointer.getValue("POLICIES",policy);
				if(policyDetails.indexOf(",")>-1)
				{
					Policies = myTokenizer(policyDetails,",");
				}
				else
				{
					Policies.add(policyDetails);
				}
				for(int k=0;k<Policies.size();k++)
				{
					ArrayList policyDate = new ArrayList();
					policyDate.add(Policies.get(k));
					boolean underMaintenance = maintenanceInfo.isItMaintenanceTime(dispDate,policyDate);
					if(underMaintenance)
					{
						if(policyNames!=null&&policyNames.equals(""))
						{
							policyNames = policy;
						}
						else if(policyNames!=null&& !policyNames.equals(policy) && !policynams.contains(policy))
						{	
							policyNames += ","+policy;
							policynams.add(policy);
						}
						if(policyTime!=null&&policyTime.equals(""))
						{
							policyTime = (String)policyDate.get(0);
						}
						else
						{
							policyTime += "~"+policyDate.get(0);
						}
					}
				}
			}
		}
		policyInfos = new ArrayList();
		if(policyTime!=null)
		{
			StringTokenizer tok = new StringTokenizer(policyTime,"~");
			while(tok.hasMoreTokens())
			{
				String token = tok.nextToken();
				if(!token.equals(""))
				{
					if(token.indexOf("#*") > -1)
						token = mappingInfo.getTextDescription("monitor.testDetails.Daily")+"#"+token.substring(0,token.indexOf("-"))+"-"+token.substring(token.indexOf("-")+1,token.indexOf("#"));
					else if(token.indexOf("#FDM") > -1)
						token = mappingInfo.getTextDescription("monitor.testDetails.First day of month")+"#"+token.substring(0,token.indexOf("-"))+"-"+token.substring(token.indexOf("-")+1,token.indexOf("#"));
					else if(token.indexOf("#LDM") > -1)
						token =mappingInfo.getTextDescription("monitor.testDetails.Last day of month")+"#"+token.substring(0,token.indexOf("-"))+"-"+token.substring(token.indexOf("-")+1,token.indexOf("#"));
					else if(token.indexOf("/") == -1)
					{
						if(token.indexOf("#Sun") > -1)
							token = token + "day";
						else if(token.indexOf("#Mon") > -1)
							token = token + "day";
						else if(token.indexOf("#Tue") > -1)
							token = token + "sday";
						else if(token.indexOf("#Wed") > -1)
							token = token + "nesday";
						else if(token.indexOf("#Thu") > -1)
							token = token + "rsday";
						else if(token.indexOf("#Fri") > -1)
							token = token + "day";
						else if(token.indexOf("#Sat") > -1)
							token = token + "urday";
						else if(token.indexOf("none") > -1)
							token="none";

						if (!token.equals("none"))
						{
							String s1 = token.substring(0,token.indexOf("#"));
							String s2 = token.substring(token.indexOf("#")+1);
							token = mappingInfo.getTextDescription("monitor.common."+s2)+"#"+s1.substring(0,s1.indexOf("-")) + "-"+s1.substring(s1.indexOf("-")+1,s1.length());
						}
					}
					else
					{
						if(token!=null && token.indexOf("|")>0)
						{
							String pdat=token.substring(token.indexOf("#")+1,token.length());
							token=token.substring(0,token.indexOf("#"));
							String stdate=DateUtil.changeDateFormat(pdat.substring(0,pdat.indexOf("|")),"MM/dd/yyyy",dateFormatForDatePicker);
							String enddate=DateUtil.changeDateFormat(pdat.substring(pdat.indexOf("|")+1,pdat.length()),"MM/dd/yyyy",dateFormatForDatePicker);
							token=token+"#"+stdate+"|"+enddate;
						}
						else
						{
							token=token.substring(0,token.indexOf("#")+1)+DateUtil.changeDateFormat(token.substring(token.indexOf("#")+1,token.length()),"MM/dd/yyyy",dateFormatForDatePicker);
						}
					}
				}
				if(policyInfos!=null&&!policyInfos.contains(token))
				{
					policyInfos.add(token);
				}
			}
		}
		if(policyInfos!=null&&policyInfos.size()>0)
		{
			for(int j=0;j<policyInfos.size();j++)
			{
				if(j==0)
				{
					policyTime = (String)policyInfos.get(j);
				}
				else
				{
					policyTime += "~"+(String)policyInfos.get(j);
				}
			}
		}
		
		screenLabels.put("Teststate",mappingInfo.getLabelDescription("monitor.testDetails.Test state"));
		testStateValue.put("TestStateData",mappingInfo.getLabelDescription(s_tstate));		// display for Test state
		
		Vector v_mes_state = new Vector();
		String s_bad_mlist = request.getParameter("badmeslist");
		StringTokenizer st = new StringTokenizer(s_bad_mlist,",");
		while(st.hasMoreTokens())
		{
			v_mes_state.add(st.nextToken().trim());
		}

		String s_mes_display = "";
		String s_alarm_policy = "";
		for(int k=0;k < v_mes_state.size();k=k+1)
		{
			s_mes_display = (String)v_mes_state.get(k);
			if (specsInfo.isPortRelevantForTest(s_tname))
				s_alarm_policy = teststatus.getAlarmPolicyForTest(s_tname,s_mes_display,s_host.trim() + ":" + s_sport.trim());
			else
				s_alarm_policy = teststatus.getAlarmPolicyForTest(s_tname,s_mes_display,s_host.trim());
		}
		boolean flagDisplay=false;
		for(int i=0;i < v_teststatusinfo.size();i++)
		{

			String tempDisp=(String)v_teststatusinfo.elementAt(i);
			if(tempDisp.indexOf(":")>-1)
			{
				tempDisp=tempDisp.substring(0,tempDisp.indexOf(":"));
				flagDisplay=true;
			}
			if(flagDisplay) //if(i==0 || i==1)
			{
				tempDispObj.put("tempDisp",mappingInfo.getTextDescription("monitor.layermodel."+tempDisp));
			flagDisplay=false;
			}
			else
			{
				tempDispObj.put("tempDisp",mappingInfo.getTextDescription("monitor.layermodel."+tempDisp));
			}
			json.put("tempDispObj",tempDispObj);
			

		}
		v_teststatusinfo.removeAllElements();
		v_trans4site.removeAllElements();
		v_teststatusinfo = null;
		v_trans4site = null;

	// *************** T.Thirumal Azhagan 1/30/2006 *******************
	// To display threshold value
		StringTokenizer stn = null;
		if (s_sname.indexOf(":") > -1)
			stn = new StringTokenizer (s_sname,":");
		String h = null, p = null, sid = null;
		Hashtable ht = new Hashtable();
		String s_ssinfo = ui.getReverseLookedupString(s_desc).trim();
		s_ssinfo = findAndReplaceString(s_ssinfo,"\\\\","\\");
		String s_format = null;
		String s_val = null;
		String[] meas = dbInfo.getMeasurementsForTest(s_tname);
		String ss[] = null;
		if (stn != null && stn.countTokens() >= 2)
		{
			h = stn.nextToken();
			p = stn.nextToken();
			if (stn.hasMoreTokens())
				sid = stn.nextToken();
		}else
		{
			h = s_sname;
			p = "NULL";
		}
		if (meas != null && meas.length > 0)
		{
			for (int i=0;i<meas.length;i++)
			{
				ss = threshInfo.getThresholdAttributes(s_tname,meas[i],h, p, sid, s_ssinfo);
				ht.put(meas[i],ss);
			}
		}
		if (ht != null && ht.size() > 0)
		{
			threshDispVal = threshInfo.threshType;
			if (threshDispVal.startsWith("Group~!~"))
			{
				String strGrpDetails = threshDispVal.substring(threshDispVal.indexOf("~!~")+3);
				threshDispVal = threshDispVal.substring(0,threshDispVal.indexOf("~!~"));
				screenLabels.put("threshGroupname",mappingInfo.getLabelDescription("monitor.testDetails.Threshold group name"));
				screenLabels.put("threshRulename",mappingInfo.getLabelDescription("monitor.testDetails.Threshold rule name"));
				if ((strGrpDetails != null && strGrpDetails.length() > 0))
				{
					String ruleName = strGrpDetails.substring(0,strGrpDetails.indexOf("~!~"));
					String grpName = strGrpDetails.substring(strGrpDetails.indexOf("~!~")+3);
					threshValue.put("threshGroupname",grpName);
					threshValue.put("threshRulename",ruleName);
				}
			}
			isDefaultThreshType = (!StringUtils.isNull(threshDispVal) && threshDispVal.equalsIgnoreCase("Default"));
			isSpecificThreshType = (!StringUtils.isNull(threshDispVal) && threshDispVal.equalsIgnoreCase("Specific"));
			isGroupThreshType = (!StringUtils.isNull(threshDispVal) && threshDispVal.equalsIgnoreCase("Group"));
			isGlobalThreshType = (!StringUtils.isNull(threshDispVal) && threshDispVal.equalsIgnoreCase("Global"));

		threshValue.put("ThreshInfo",threshDispVal);
		screenLabels.put("Threshold",threshDispVal+" "+mappingInfo.getLabelDescription("threshold settings for this component"));

		boolean heading_flag = false;
		
		boolean cellFlag = false;
		String strTestName = s_tname;

		if (EgInstallInfo.isSuperManager)
		{
			hasAdminTab = false;
//			if(user.getLoginID().equals("egsm"))
//			{
//				hasAdminTab = true;
//			}
		}

		boolean isSecondaryManager = false;
		EgManagersIniForManager mi = null;
		if (EgInstallInfo.isClusterSupported)
		{
			mi = EgManagersIniForManager.getInstance();
			if (mi != null && !mi.isPrimaryManager())
			{
				hasAdminTab = false;
				isSecondaryManager = true;
			}
		}

		if (!EgInstallInfo.isSuperManager && !isSecondaryManager)
		{
			isNotOpenNewWindow = (!StringUtils.isNull(strChildWindow) && strChildWindow.equalsIgnoreCase("no"));
			if(isAdmin && isNotOpenNewWindow)
			{
				isAdminLinkEnabled = true;
			}
			else if(isCompletedUserRole && hasAdminTab && hasThreshold && isNotOpenNewWindow )
			{
				isAdminLinkEnabled = true;
			}
			else if(!isCompletedUserRole && hasAdminTab && hasThreshold && isNotOpenNewWindow )
			{
				if (globalThresholds != null && !globalThresholds.contains(strTestName))
				{
					isAdminLinkEnabled = true;
				}
			}
			
			if (isAdmin && isNotOpenNewWindow)
			{
				isAdminTestConfigLinkEnabled = true;
			}
			else if(hasAdminTab && hasSpecificTestConfiguration && isNotOpenNewWindow)
			{
				isAdminTestConfigLinkEnabled = true;
			}

			String clsTrial = (String)session.getAttribute("clsTrial");
			if (clsTrial != null && clsTrial.equalsIgnoreCase("Yes"))
			{
				isAdminTestConfigLinkEnabled = false;
			}

			if(!isCompletedUserRole && hasAdminTab && hasThreshold && isNotOpenNewWindow)
			{
				if (globalThresholds != null && globalThresholds.contains(strTestName))
				{
					hasAdminTab = false;
				}
			}
		}
		String tempCompName = h+":"+p;
		if(!StringUtils.isNull(sid))
		{
			tempCompName+=":"+sid;
		}

		List listManagedComponents = roleInfo.getAllServers();
		EgTestSpecification egTestSpecification = new EgTestSpecification(listManagedComponents);
		boolean isConfigSupported = EgInstallInfo.isConfigSupported;

		if (isConfigSupported)
		{
			isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
			egTestSpecification.setConfigSupported(isConfigSupported);
		}

		String strAdminCompName = compName;
		if (strAdminCompName.endsWith(":"))
		{
			strAdminCompName = strAdminCompName.substring(0,strAdminCompName.lastIndexOf(":"));
		}

		if (!StringUtils.isNull(infoForAdminURL))
		{
			infoForAdminURL=findAndReplaceString(infoForAdminURL,"\\\\","\\");
		}
		//boolean isUnconfiguredPerformanceTest = egTestSpecification.isUnconfiguredPerformanceTest(strTestName,s_stype,strAdminCompName);
		boolean isUnconfiguredPerformanceTest = egTestSpecification.isUnconfiguredPerformanceTestForMonitor(strTestName,s_stype,strAdminCompName);
		json.put("isAdminLinkEnabled",isAdminLinkEnabled);
		json.put("isAdminTestConfigLinkEnabled",isAdminTestConfigLinkEnabled);
		json.put("isUnconfiguredPerformanceTest",isUnconfiguredPerformanceTest);
		json.put("componentType",s_stype);
		json.put("componentName",strAdminCompName);
		json.put("strTestName",strTestName);
		json.put("monDescName",infoForAdminURL);
		json.put("monTestState",s_tstate);
		if (isUnconfiguredPerformanceTest)
		{
			json.put("testState","configurebutton");
		}
		else
		{
			json.put("testState","reconfigurebutton");
		}
		json.put("layerName",s_layer);
		s_ssinfo=com.egurkha.util.StringUtils.encodeSecurityChar(s_ssinfo);
		String link="/final/admin/EgSetSessionValForThresholdJson.jsp?threshType="+threshDispVal+"&componentType="+EgURLEncoder.encode(s_stype,"UTF-8")+"&componentName="+EgURLEncoder.encode(strAdminCompName,"UTF-8")+"&testName="+EgURLEncoder.encode(strTestName,"UTF-8")+"&descName="+EgURLEncoder.encode(s_ssinfo,"UTF-8")+"&testState="+EgURLEncoder.encode(s_tstate,"UTF-8")+"&layerName="+EgURLEncoder.encode(s_layer,"UTF-8");

			for (int i=0;i<meas.length;i++)
			{
				String measure = meas[i];

				String critMsg = "";
				String majorMsg = "";

				String criticalMsg = mappingInfo.getThresholdPriorityDescription(strTestName+":"+measure+":Critical");
				json.put("isToolTip",false);
				if (!StringUtils.isNull(criticalMsg))
				{
					json.put("isToolTip",true);
					critMsg = " <img data-qtip='"+criticalMsg+"' style='margin-left:5px;vertical-align: middle;' src='/final/images/clear.png' class='iconTooltipHelp'/>";

					criticalMsg = mappingInfo.getThresholdPriorityDescription(strTestName+":"+measure+":Major");

					if (!StringUtils.isNull(criticalMsg))
					{
						majorMsg = " <img data-qtip='"+criticalMsg+"' style='margin-left:5px;vertical-align: middle;' src='/final/images/clear.png' class='iconTooltipHelp'/>";
					}
				}




				String[] threshVal = (String[]) ht.get(measure);
				if (threshVal != null && threshVal.length == 4)
				{
					String policy = threshVal[0];
					String min = threshVal[1];
					String max = threshVal[2];
					String alarmPolicy = threshVal[3];

					String absMinCritical = "-";
					String relMinCritical = "-";

					String absMinMajor = "-";
					String relMinMajor = "-";

					String absMinMinor = "-";
					String relMinMinor = "-";

					String absMaxCritical = "-";
					String relMaxCritical = "-";

					String absMaxMajor = "-";
					String relMaxMajor = "-";

					String absMaxMinor = "-";
					String relMaxMinor = "-";

					if (policy.equalsIgnoreCase("none"))
					{
						policy = "mix";
					}
					else if (policy.equalsIgnoreCase("absolute"))
					{
						if (!min.equals("-1"))
						{
							StringTokenizer stAbsMin = new StringTokenizer(min,"/");
							absMinCritical = stAbsMin.nextToken();
							absMinMajor = stAbsMin.nextToken();
							absMinMinor = stAbsMin.nextToken();
						}

						if (!max.equals("-1"))
						{
							StringTokenizer stAbsMax = new StringTokenizer(max,"/");
							absMaxCritical = stAbsMax.nextToken();
							absMaxMajor = stAbsMax.nextToken();
							absMaxMinor = stAbsMax.nextToken();
						}
					}
					else if (policy.equalsIgnoreCase("relative"))
					{
						if (!min.equals("-1"))
						{
							StringTokenizer stRelMin = new StringTokenizer(min,"/");
							relMinCritical = stRelMin.nextToken();
							relMinMajor = stRelMin.nextToken();
							relMinMinor = stRelMin.nextToken();
						}

						if (!max.equals("-1"))
						{
							StringTokenizer stRelMax = new StringTokenizer(max,"/");
							relMaxCritical = stRelMax.nextToken();
							relMaxMajor = stRelMax.nextToken();
							relMaxMinor = stRelMax.nextToken();
						}
					}
					else if (policy.equalsIgnoreCase("mix"))
					{
						Vector vec = getAbsAndRel(min);
						String absA = (String) vec.get(0);
						String relA = (String) vec.get(1);
						Vector vec1 = getAbsAndRel(max);
						String absB = (String) vec1.get(0);
						String relB = (String) vec1.get(1);

						if (!absA.equals("none"))
						{
							StringTokenizer stmixMin = new StringTokenizer(absA,"/");
							absMinCritical = stmixMin.nextToken();
							absMinMajor = stmixMin.nextToken();
							absMinMinor = stmixMin.nextToken();
						}

						if (!absB.equals("none"))
						{
							StringTokenizer stmixMax = new StringTokenizer(absB,"/");
							absMaxCritical = stmixMax.nextToken();
							absMaxMajor = stmixMax.nextToken();
							absMaxMinor = stmixMax.nextToken();
						}

						if (!relA.equals("none"))
						{
							StringTokenizer stRelMin = new StringTokenizer(relA,"/");
							relMinCritical = stRelMin.nextToken();
							relMinMajor = stRelMin.nextToken();
							relMinMinor = stRelMin.nextToken();
						}

						if (!relB.equals("none"))
						{
							StringTokenizer stmixMax = new StringTokenizer(relB,"/");
							relMaxCritical = stmixMax.nextToken();
							relMaxMajor = stmixMax.nextToken();
							relMaxMinor = stmixMax.nextToken();
						}
					}

					String minCritical = getThresholdValue("min",absMinCritical,relMinCritical);
					String minMajor = getThresholdValue("min",absMinMajor,relMinMajor);
					String minMinor = getThresholdValue("min",absMinMinor,relMinMinor);

					String maxCritical = getThresholdValue("max",absMaxCritical,relMaxCritical);
					String maxMajor = getThresholdValue("max",absMaxMajor,relMaxMajor);
					String maxMinor = getThresholdValue("max",absMaxMinor,relMaxMinor);

					if (minCritical.equals("-") && minMajor.equals("-") && minMinor.equals("-") && 
					maxCritical.equals("-") && maxMajor.equals("-") && maxMinor.equals("-"))
					{
						aListTestWithNoThresholds.add(measure);
						cellFlag = !cellFlag;
						continue;
					}
			
					String unit = tablesInfo.getUnitForMeasure(strTestName,measure);
					if (!heading_flag)
					{
						heading_flag = true;
						screenLabels.put("MeasureValue","Measure");
						screenLabels.put("MinMax",mappingInfo.getTextDescription("admin.threshold.Min/Max"));
						screenLabels.put("Critical","Critical");
						screenLabels.put("Major","Major");
						screenLabels.put("Minor","Minor");
						screenLabels.put("AlarmPolicy","Alarm Policy");
					}

					String valueData= null ;
					if(isAdminLinkEnabled)
					{
						valueData = mappingInfo.getMeasureDescription(strTestName,measure) + "	(" +unit+ ")";
						if (hasAdminTab)
						{
							if(thresholdValueSetting!=null && thresholdValueSetting.length()>0 && !thresholdValueSetting.equals("false"))
							{
								jsonObject.put("testMeasureValues",valueData);
							}
							else
							{
								jsonObject.put("testMeasureValues","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+valueData+"</a>");
							}
						}
						else
						{
							jsonObject.put("testMeasureValues",valueData);
						}
						if(!minCritical.equals("-") || !minMajor.equals("-") || !minMinor.equals("-"))
						{
							jsonObject.put("minMax",mappingInfo.getTextDescription("monitor.dashboard.Min"));
							if (hasAdminTab)
							{
								if(thresholdValueSetting!=null && thresholdValueSetting.length()>0 && !thresholdValueSetting.equals("false"))
								{
									jsonObject.put("critical",minCritical);
									jsonObject.put("major",minMajor);
									jsonObject.put("minor",minMinor);
								}
								else
								{
									jsonObject.put("critical","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+minCritical+"</a>"+critMsg);
									jsonObject.put("major","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+minMajor+"</a>"+majorMsg);
									jsonObject.put("minor","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+minMinor+"</a>");
								}
							}
							else
							{
								jsonObject.put("critical",minCritical);
								jsonObject.put("major",minMajor);
								jsonObject.put("minor",minMinor);
							}
						}

						if(!maxCritical.equals("-") || !maxMajor.equals("-") || !maxMinor.equals("-"))
						{
							jsonObject.put("minMax",mappingInfo.getTextDescription("monitor.dashboard.Max"));
							if (hasAdminTab)
							{
								if ((minCritical!=null && minCritical.length()>0 && !minCritical.equals("-")) || (minMajor!=null && minMajor.length()>0 && !minMajor.equals("-")) ||(minMinor!=null && minMinor.length()>0 && !minMinor.equals("-")))
								{
									jsonObject.put("minMax",mappingInfo.getTextDescription("monitor.dashboard.Min<br>Max"));
									if(thresholdValueSetting!=null && thresholdValueSetting.length()>0 && !thresholdValueSetting.equals("false"))
									{
										jsonObject.put("critical",minCritical+"<br>"+maxCritical);
										jsonObject.put("critical",minMajor+"<br>"+maxMajor);
										jsonObject.put("critical",minMinor+"<br>"+maxMinor);
									}
									else
									{
										jsonObject.put("critical","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+minCritical+"</a>"+critMsg+"<br><a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+maxCritical+"</a>");
										jsonObject.put("major","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+minMajor+"</a>"+majorMsg+"<br><a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+maxMajor+"</a>");
										jsonObject.put("minor","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+minMinor+"</a><br><a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+maxMinor+"</a>");
									}
								}
								else
								{
									if(thresholdValueSetting!=null && thresholdValueSetting.length()>0 && !thresholdValueSetting.equals("false"))
									{
										jsonObject.put("critical",maxCritical);
										jsonObject.put("major",maxMajor);
										jsonObject.put("minor",maxMinor);
									}
									else
									{
										if(thresholdValueSetting!=null && thresholdValueSetting.length()>0 && !thresholdValueSetting.equals("false"))
										{
											jsonObject.put("critical",maxCritical);
											jsonObject.put("major",maxMajor);
											jsonObject.put("minor",measure);
										}
										else
										{
											jsonObject.put("critical","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+maxCritical+"</a>"+critMsg);
											jsonObject.put("major","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+maxMajor+"</a>"+majorMsg);
											jsonObject.put("minor","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+maxMinor+"</a>");
										}
									}
								}
							}
							else
							{
								jsonObject.put("critical",maxCritical);
								jsonObject.put("major",maxMajor);
								jsonObject.put("minor",maxMinor);
							}
						}
						screenLabels.put("alarmPolicy",alarmPolicy);
						alarmPolicyObj.put("alarmPolicy",alarmPolicy);
					}
					else
					{
						valueData = mappingInfo.getMeasureDescription(strTestName,measure) + "(" +unit+ ")";
						if (hasAdminTab && hasThreshold && isNotOpenNewWindow)
						{
							jsonObject.put("testMeasureValues","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+valueData+"</a>");
						}
						else
							jsonObject.put("testMeasureValues",valueData);
					
						if(!minCritical.equals("-") || !minMajor.equals("-") || !minMinor.equals("-"))
						{
							jsonObject.put("minMax",mappingInfo.getTextDescription("monitor.services.Min"));
							if (hasAdminTab && hasThreshold && isNotOpenNewWindow)
							{
								if(thresholdValueSetting!=null && thresholdValueSetting.length()>0 && !thresholdValueSetting.equals("false"))
								{
									jsonObject.put("critical",minCritical);
									jsonObject.put("major",minMajor);
									jsonObject.put("minor",minMinor);
								}
								else
								{
									jsonObject.put("critical","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+minCritical+"</a>"+critMsg);
									jsonObject.put("major","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+minMajor+"</a>"+majorMsg);
									jsonObject.put("minor","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+minMinor+"</a>");
								}
							}
							else
							{
								jsonObject.put("critical",minCritical);
								jsonObject.put("major",minMajor);
								jsonObject.put("minor",minMinor);
							}
						}

						if(!maxCritical.equals("-") || !maxMajor.equals("-") || !maxMinor.equals("-"))
						{
							jsonObject.put("minMax",mappingInfo.getTextDescription("monitor.dashboard.Max"));
							if (hasAdminTab && hasThreshold && isNotOpenNewWindow)
							{
								if(thresholdValueSetting!=null && thresholdValueSetting.length()>0 && !thresholdValueSetting.equals("false"))
								{
									jsonObject.put("critical",maxCritical);
									jsonObject.put("major",maxMajor);
									jsonObject.put("minor",maxMinor);
								}
								else
								{
									jsonObject.put("critical","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+maxCritical+"</a>"+critMsg);
									jsonObject.put("major","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+maxMajor+"</a>"+majorMsg);
									jsonObject.put("minor","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+maxMinor+"</a>");
								}
							}
							else
							{
								if ((minCritical!=null && minCritical.length()>0 && !minCritical.equals("-")) || (minMajor!=null && minMajor.length()>0 && !minMajor.equals("-")) ||(minMinor!=null && minMinor.length()>0 && !minMinor.equals("-")))
								{
									jsonObject.put("minMax",mappingInfo.getTextDescription("monitor.dashboard.Min<br>Max"));
									jsonObject.put("critical",minCritical+"<br>"+maxCritical);
									jsonObject.put("major",minMajor+"<br>"+maxMajor);
									jsonObject.put("minor",minMinor+"<br>"+maxMinor);
								}
								else
								{
									jsonObject.put("critical",maxCritical);
									jsonObject.put("major",maxMajor);
									jsonObject.put("minor",maxMinor);
								}
							}
						}
						screenLabels.put("alarmPolicy",alarmPolicy);
						alarmPolicyObj.put("alarmPolicy",alarmPolicy);
					}
		
					if (hasAdminTab && hasThreshold && isNotOpenNewWindow)
					{
						if(thresholdValueSetting!=null && thresholdValueSetting.length()>0 && !thresholdValueSetting.equals("false"))
						{
							jsonObject.put("alarmPolicy",alarmPolicy);
						}
						else
						{
							jsonObject.put("alarmPolicy","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'>"+mappingInfo.getTextDescription("monitor.dashboard."+alarmPolicy)+"</a>");
						}
					}
					else
					{
						jsonObject.put("alarmPolicy",alarmPolicy);
					}

					if (hasAdminTab && hasThreshold && isNotOpenNewWindow)
					{
						if(thresholdValueSetting!=null && thresholdValueSetting.length()>0 && !thresholdValueSetting.equals("false"))
						{
							jsonObject.put("ActionColumn","");
						}
						else
						{
							//String config_thresText=mappingInfo.getTextDescription("monitor.testDetails.Configure thresholds");
							jsonObject.put("ActionColumn","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+measure+"\")'><div class='iconModify' data-qtip='"+mappingInfo.getTextDescription("monitor.testDetails.Configure thresholds")+"' data-qclass='yellowTip'></div></a>");
						}
					}
				}
				jsonArrayValue.add(jsonObject);
				//json.put("strCsrfToken",strCsrfToken);
			}
			json.put("jsonArrayValue",jsonArrayValue);
			// for loop ends

		if (aListTestWithNoThresholds != null && !aListTestWithNoThresholds.isEmpty())
		{
			screenLabels.put("Measureswithoutthresholds","Measures without thresholds");

			JSONArray measureArray = new JSONArray();

			for (int d=0; d < aListTestWithNoThresholds.size(); d++)
			{
				String strMeasure = (String)aListTestWithNoThresholds.get(d);
				if(isAdminLinkEnabled)
				{
					String measureWithoutTreshold=mappingInfo.getMeasureDescription(strTestName,strMeasure);

					if (hasAdminTab)
					{
						if(thresholdValueSetting!=null && thresholdValueSetting.length()>0 && !thresholdValueSetting.equals("false"))
						{
							testNameObj.put("testMeasure",measureWithoutTreshold);
						}
						else
						{
							testNameObj.put("testMeasure","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+strMeasure+"\")'>"+mappingInfo.getMeasureDescription(strTestName,strMeasure)+"</a>");
						}
					}
					else
					{
						testNameObj.put("testMeasure",measureWithoutTreshold);
					}
				}
				else
				{
					if (hasAdminTab && hasThreshold && isNotOpenNewWindow)
					{
						if(thresholdValueSetting!=null && thresholdValueSetting.length()>0 && !thresholdValueSetting.equals("false"))
						{
							testNameObj.put("testMeasure",mappingInfo.getMeasureDescription(strTestName,strMeasure));
						}
						else
						{
							testNameObj.put("testMeasure","<a href='javascript:void(0)' onclick='setSession(\""+link+"\",\""+strMeasure+"\")'>"+mappingInfo.getMeasureDescription(strTestName,strMeasure)+"</a>");
						}
					}
					else
					{
						testNameObj.put("testMeasure",mappingInfo.getMeasureDescription(strTestName,strMeasure));
					}
				}
				measureArray.add(testNameObj);
			}
			json.put("measureDescription",measureArray);
			
		}
	}
	
	java.util.Date locdate = new java.util.Date(dateInfo.egetUTCDate(false));			
	SimpleDateFormat mdyFormat = new SimpleDateFormat("MM/dd/yyyy");
	String strDate = mdyFormat.format(locdate);
		
	if(isHostinMaintenance || isComponentinMaintenance || isTestinMaintenance ||istestandComponentinMaintenance || istestandHostinMaintenance || isDescriptorMaintenanceForComponent || isDescriptorMaintenanceForTest)
		{
			
			matchCriteriaValue.put("matchCriteria","matchCriteria");
				
				if(policyGroupName!=null && !policyGroupName.equals("") && policyNames!=null && !policyNames.equals("") && policyTime!=null && !policyTime.equals(""))
					{
						screenLabels.put("PolicgGroupDetails",mappingInfo.getTextDescription("monitor.testDetails.Policy Group Details"));
						screenLabels.put("PolicgGroupName",mappingInfo.getTextDescription("monitor.testDetails.Policy Group Name"));


						JSONArray poldisp1ValueArray = new JSONArray();
						JSONObject policyGroupNameValue = new JSONObject();

						/*if(policyGroupName!=null && policyGroupName.length()>60)
							{
								int idx=policyGroupName.length()/60;
								int index=0;
								for(int i=0;i<idx;i++)
								{
									String poldisp=policyGroupName.substring(index,index+60);
									String poldisp1=poldisp.substring(0,poldisp.lastIndexOf(",")+1);

									poldisp1ValueArray.add(poldisp1);
									index=index+poldisp.lastIndexOf(",")+1;
								}
								policyGroupNameValue.put("poldisp1ValueArray",poldisp1ValueArray);

							}
						else
							{
								policyGroupNameValue.put("policyGroup",policyGroupName);
							}*/
						policyGroupNameValue.put("policyGroup",policyGroupName);
						policyGroupNameObj.put("policyGroupNameValue",policyGroupNameValue);
						json.put("policyGroupNameObj",policyGroupNameObj);
					
								
				JSONArray poldisp1Array = new JSONArray();
				JSONObject policyNamesObj = new JSONObject();
				/*if(policyNames!=null && policyNames.length()>60)
					{
						int idx=policyNames.length()/60;
						int index=0;
						for(int i=0;i<idx;i++)
						{
							String poldisp=policyNames.substring(index,index+60);
							String poldisp1=poldisp.substring(0,poldisp.lastIndexOf(",")+1);

							poldisp1Array.add(poldisp1);
							index=index+poldisp.lastIndexOf(",")+1;
						}
						policyNamesObj.put("poldisp1Array",poldisp1Array);

					}
					else
					{
						policyNamesObj.put("policyNames",policyNames);

					}*/
					policyNamesObj.put("policyNames",policyNames);
					policyNamesObjValue.put("policyNamesObj",policyNamesObj);
					json.put("policyNamesObjValue",policyNamesObjValue);


				screenLabels.put("PolicyTime",mappingInfo.getTextDescription("monitor.testDetails.Policy  time"));

				JSONArray poldispArray = new JSONArray();
				JSONObject policyTimeObj = new JSONObject();
				StringTokenizer stTokens = new StringTokenizer(policyTime,"~");
				String PolicyDetails = "";
				while(stTokens.hasMoreTokens())
				{
					String policyTimes = stTokens.nextToken();
					if(policyTimes!=null && policyTimes.indexOf("|")>0)
					{
						String time = policyTimes.substring(0,policyTimes.indexOf("#"));
						String dates = policyTimes.substring(policyTimes.indexOf("#")+1);

						String stHr = time.substring(0,time.indexOf("-"));
						String stMin = stHr.substring(stHr.indexOf(":")+1);

						String endHr = time.substring(time.indexOf("-")+1);
						String endMin = endHr.substring(endHr.indexOf(":")+1);

						String stDate = dates.substring(0,dates.indexOf("|"));
						String endDate = dates.substring(dates.indexOf("|")+1);
						
						EgTimeZoneConverter converterStart = new EgTimeZoneConverter(stDate+" "+stHr,user);
						EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(endDate+" "+endHr,user);
					
						stDate = (String)converterStart.getDate(false);
						stHr = converterStart.getHour();
						stMin = converterStart.getMinute();	
						
						endDate = (String)converterEnd.getDate(false);
						endHr = converterEnd.getHour();											
						endMin = converterEnd.getMinute();	

						PolicyDetails +=stDate+" "+stHr+":"+stMin+" Hrs-"+endDate+" "+endHr+":"+endMin+" Hrs"+",";
					}
					else
					{
						String timeFreq = policyTimes.substring(0,policyTimes.indexOf("#"));
						String timeline = policyTimes.substring(policyTimes.indexOf("#")+1);

						String stHr = timeline.substring(0,timeline.indexOf("-"));
						String enHr = timeline.substring(timeline.indexOf("-")+1);

						String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", dateFormatForDatePicker);
						dispStartDate = dispStartDate.trim();
						EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+stHr,user);
						String dispEndDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", dateFormatForDatePicker);
						dispEndDate = dispEndDate.trim();
						EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+enHr,user);

						stHr = converterStart.getHour()+":"+converterStart.getMinute();
						enHr = converterEnd.getHour()+":"+converterEnd.getMinute();

						PolicyDetails +=timeFreq + " "+stHr+" Hrs - "+enHr+" Hrs"+",";
					}
				}
				PolicyDetails = PolicyDetails.substring(0,PolicyDetails.lastIndexOf(","));
				policyTimeObj.put("PolicyTime",PolicyDetails);
				/*if(policyTime!=null && !policyTime.equals("") && policyTime.length()>60)
				{
					int idx=policyTime.length()/60;
					int index=0;
					for(int i=0;i<idx;i++)
					{
						String poldisp=policyTime.substring(index,index+60);
						String poldisp1=poldisp.substring(0,poldisp.lastIndexOf(",")+1);

						poldispArray.add(poldisp1);
						index=index+poldisp.lastIndexOf(",")+1;
					}

					policyTimeObj.put("poldispArray",poldispArray);

				}
				else
				{
						policyTimeObj.put("PolicyTime",policyTime);
				}*/
				policyTimeObject.put("policyTimeObj",policyTimeObj);
				json.put("policyTimeObject",policyTimeObject);
			}

							String policyNams="",temppolicyName="";
							ArrayList policyInfos1=new ArrayList();
							if(isHostinMaintenance&&isTestinMaintenance)
							{
								matchCriteria = hostName+"/"+mappingInfo.getTestDescription(s_tname);

								policyNams = maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING",hostName);

								temppolicyName =  maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING","#"+s_tname);
								if(policyNams!=null&&!temppolicyName.equals("")&&!policyNams.trim().equals(temppolicyName))
								{
									policyNams +="," +temppolicyName;
								}
							}
							else if(isHostinMaintenance&&!isTestinMaintenance)
							{
								matchCriteria = hostName;
								policyNams = maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING",hostName);
								if(policyNams!=null&&!policyNams.equals(""))
								{
									policyNams +="," +temppolicyName;
								}
								else
								{
										if(policyNams!=null&&!policyNams.equals(""))
										{
											policyNams +="," +temppolicyName;
										}
										else
										{
											policyNams = temppolicyName;
										}
								}
							}
							if(isComponentinMaintenance&&isTestinMaintenance)
							{
								matchCriteria = hostName+":"+s_sport+"/"+mappingInfo.getTestDescription(s_tname);
								if(s_stype.equals("Oracle_server"))
								{
									temppolicyName = maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", hostName+":"+s_sport+":"+s_sinfo);
									if(policyNams!=null&&!policyNams.trim().equals(temppolicyName))
									{
										policyNams +="," +temppolicyName;
									}
									else
									{
										if(policyNams!=null&&!policyNams.equals(""))
										{
											policyNams +="," +temppolicyName;
										}
										else
										{
											policyNams =temppolicyName;
										}
									}
								}
								else
								{
									temppolicyName = maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", hostName+":"+s_sport);
									if(policyNams!=null&&!policyNams.trim().equals(temppolicyName))
									{
										policyNams +="," +temppolicyName;
									}
									else
									{
										if(policyNams!=null&&!policyNams.equals(""))
										{
											policyNams +="," +temppolicyName;
										}
										else
										{
											policyNams =temppolicyName;
										}
									}
								}
								temppolicyName = maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING","#"+s_tname);
								if(policyNams!=null&&!policyNams.trim().equals(temppolicyName))
								{
									policyNams +="," +temppolicyName;
								}
								else
								{
									if(policyNams!=null&&!policyNams.equals(""))
									{
										policyNams +="," +temppolicyName;
									}
									else
									{
										policyNams =temppolicyName;
									}
								}
							}
							else if(isComponentinMaintenance&&!isTestinMaintenance)
							{
								matchCriteria = hostName+":"+s_sport;
								if(s_stype.equals("Oracle_server"))
								{
									temppolicyName =maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", hostName+":"+s_sport+":"+s_sinfo);
									if(policyNams!=null&&!policyNams.trim().equals(temppolicyName))
									{
										policyNams +="," +temppolicyName;
									}
									else
									{
										if(policyNams!=null&&!policyNams.equals(""))
										{
											policyNams +="," +temppolicyName;
										}
										else
										{
											policyNams =temppolicyName;
										}
									}
								}
								else
								{
									temppolicyName =maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", hostName+":"+s_sport);
									if(policyNams!=null&&!policyNams.trim().equals(temppolicyName))
									{
										policyNams +="," +temppolicyName;
									}
									else
									{
										if(policyNams!=null&&!policyNams.equals(""))
										{
											policyNams +="," +temppolicyName;
										}
										else
										{
											policyNams =temppolicyName;
										}
									}
								}
								
							}
							if(isTestinMaintenance)
							{
								matchCriteria = mappingInfo.getTestDescription(s_tname);
								temppolicyName =maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING","#"+s_tname);
								if(policyNams!=null&&!policyNams.equals(""))
								{
									policyNams +="," +temppolicyName;
								}
								else
								{
									policyNams =temppolicyName;
								}
							}
							if(istestandComponentinMaintenance)
							{
								matchCriteria =  mappingInfo.getTestDescription(s_tname)+"/"+hostName+":"+s_sport;
								if(s_sport!=null&&!s_sport.equals("NULL"))
								{
										if(s_stype.equals("Oracle_server"))
										{
											temppolicyName =maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", hostName+":"+s_sport+":"+s_sinfo+"#"+s_tname);
											if(policyNams!=null&&!temppolicyName.equals("")&&!policyNams.trim().equals(temppolicyName))
											{
												policyNams +="," +temppolicyName;
											}
											else
											{
												if(policyNams!=null&&!policyNams.equals(""))
												{
													policyNams +="," +temppolicyName;
												}
												else
												{
													policyNams =temppolicyName;
												}
											}
										}
										else
										{
											temppolicyName =maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", hostName+":"+s_sport+"#"+s_tname);
											if(policyNams!=null&&!temppolicyName.equals("")&&!policyNams.trim().equals(temppolicyName))
											{
												policyNams +="," +temppolicyName;
											}
											else
											{
												if(policyNams!=null&&!policyNams.equals(""))
												{
													policyNams +="," +temppolicyName;
												}
												else
												{
													policyNams =temppolicyName;
												}
											}
										}
									
								}
								else
								{
									temppolicyName=maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", hostName+":"+s_sport+"#"+s_tname);
									if(policyNams!=null&&!temppolicyName.equals("")&&!policyNams.trim().equals(temppolicyName))
									{
										policyNams +="," +temppolicyName;
									}
									else
									{
										if(policyNams!=null&&!policyNams.equals(""))
										{
											policyNams +="," +temppolicyName;
										}
										else
										{
											policyNams =temppolicyName;
										}
									}
								}
							}
							if(istestandHostinMaintenance)
							{
								matchCriteria =  mappingInfo.getTestDescription(s_tname)+"/"+hostName;
								temppolicyName = maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", hostName+"#"+s_tname);

								if(policyNams!=null&&!policyNams.trim().equals(temppolicyName))
								{
										policyNams +="," +temppolicyName;
								}
								else
								{
							//		policyNams =temppolicyName;
									if(policyNams!=null&&!policyNams.equals(""))
									{
										policyNams +="," +temppolicyName;
									}
									else
									{
										policyNams =temppolicyName;
									}
								}
							}
							if(isDescriptorMaintenanceForTest)
							{
								matchCriteria =  mappingInfo.getTestDescription(s_tname)+"/"+s_desc;
								temppolicyName = maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", "#"+s_tname+":"+s_desc);
								if(StringUtils.isNull(temppolicyName))
								{
									String vecList[] = maintenanceFilePointer.getVariables("UNPLANNED_POLICY_MAPPING");
									for(int i=0;i<vecList.length;i++)
									{
										String key1 = vecList[i];
										if(key1!=null && key1.equalsIgnoreCase("#"+s_tname+":"+s_desc))
										{
											temppolicyName=maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", key1);
										}
									}
								}
								if(policyNams!=null&&!policyNams.trim().equals(temppolicyName))
								{
										policyNams +="," +temppolicyName;
								}
								else
								{
							//		policyNams =temppolicyName;
									if(policyNams!=null&&!policyNams.equals(""))
									{
										policyNams +="," +temppolicyName;
									}
									else
									{
										policyNams =temppolicyName;
									}
								}
							}
							if(isDescriptorMaintenanceForComponent)
							{
								if(s_stype.equals("Oracle_server"))
								{
									matchCriteria =  hostName+":"+s_sport+":"+s_sinfo+"/"+mappingInfo.getTestDescription(s_tname)+"/"+s_desc;
								}
								else
								{
									matchCriteria =  hostName+":"+s_sport+"/"+mappingInfo.getTestDescription(s_tname)+"/"+s_desc;

								}
								if(s_sport!=null&&!s_sport.equals("NULL"))
								{
										if(s_stype.equals("Oracle_server"))
										{
											temppolicyName =maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", hostName+":"+s_sport+":"+s_sinfo+"#"+s_tname+":"+s_desc);
											if(StringUtils.isNull(temppolicyName))
											{
												String vecList[] = maintenanceFilePointer.getVariables("UNPLANNED_POLICY_MAPPING");
												for(int i=0;i<vecList.length;i++)
												{
													String key1 = vecList[i];
													if(key1!=null && key1.equalsIgnoreCase(hostName+":"+s_sport+":"+s_sinfo+"#"+s_tname+":"+s_desc))
													{
														temppolicyName=maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", key1);
													}
												}
											}
											if(policyNams!=null&&!temppolicyName.equals("")&&!policyNams.trim().equals(temppolicyName))
											{
												policyNams +="," +temppolicyName;
											}
											else
											{
												if(policyNams!=null&&!policyNams.equals(""))
												{
													policyNams +="," +temppolicyName;
												}
												else
												{
													policyNams =temppolicyName;
												}
											}
										}
										else
										{
											temppolicyName =maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", hostName+":"+s_sport+"#"+s_tname+":"+s_desc);
											if(StringUtils.isNull(temppolicyName))
											{
												String vecList[] = maintenanceFilePointer.getVariables("UNPLANNED_POLICY_MAPPING");
												for(int i=0;i<vecList.length;i++)
												{
													String key1 = vecList[i];
													if(key1!=null && key1.equalsIgnoreCase(hostName+":"+s_sport+"#"+s_tname+":"+s_desc))
													{
														temppolicyName=maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", key1);
													}
												}
											}
											if(policyNams!=null&&!temppolicyName.equals("")&&!policyNams.trim().equals(temppolicyName))
											{
												policyNams +="," +temppolicyName;
											}
											else
											{
												if(policyNams!=null&&!policyNams.equals(""))
												{
													policyNams +="," +temppolicyName;
												}
												else
												{
													policyNams =temppolicyName;
												}
											}
										}
									
								}
								else
								{
									temppolicyName=maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", hostName+":"+s_sport+"#"+s_tname+":"+s_desc);
									if(StringUtils.isNull(temppolicyName))
									{
										String vecList[] = maintenanceFilePointer.getVariables("UNPLANNED_POLICY_MAPPING");
										for(int i=0;i<vecList.length;i++)
										{
											String key1 = vecList[i];
											if(key1!=null && key1.equalsIgnoreCase(hostName+":"+s_sport+"#"+s_tname+":"+s_desc))
											{
												temppolicyName=maintenanceFilePointer.getValue("UNPLANNED_POLICY_MAPPING", key1);
											}
										}
									}
									if(policyNams!=null&&!temppolicyName.equals("")&&!policyNams.trim().equals(temppolicyName))
									{
										policyNams +="," +temppolicyName;
									}
									else
									{
										if(policyNams!=null&&!policyNams.equals(""))
										{
											policyNams +="," +temppolicyName;
										}
										else
										{
											policyNams =temppolicyName;
										}
									}
								}
							}
							if((isHostinMaintenance||isComponentinMaintenance)&&isTestinMaintenance&&
								istestandComponentinMaintenance&&istestandHostinMaintenance&& isDescriptorMaintenanceForTest && isDescriptorMaintenanceForComponent)
							{
								if(policyNams!=null&&policyNams.equals(""))
								{
									policyNams= "default";
								}
							}

							if(policyNams!=null&&!policyNams.equals(""))
							{
								StringTokenizer stkppol=new StringTokenizer(policyNams,",");
								while(stkppol.hasMoreTokens())
								{
									String policyNam=stkppol.nextToken();
									if(!policyInfos1.contains(policyNam))
									{
										policyInfos1.add(policyNam);
									}
								}
							}

							ArrayList unplannedPolicies = new ArrayList();
							ArrayList quickmpolicies=new ArrayList();
							String policyNames1 = "";
							String policyTime1 = "";
							if(policyInfos1!=null&&policyInfos1.size()>0)
							{
								for(int j=0;j<policyInfos1.size();j++)
								{
									unplannedPolicies = new ArrayList();
									String policy = (String)policyInfos1.get(j);
									//Limited Admin
									String displayPolicy = policy;
									int index = policy.indexOf("|$|");
									if (index > -1)
									{
										if (roleInfo.hasAllComponentAccess())
										{
											displayPolicy = displayPolicy.substring(0,index)+" ("+displayPolicy.substring(index+3)+")";
										}
										else
										{
											displayPolicy = displayPolicy.substring(0,index);
										}
									}
									String policyDetails = maintenanceFilePointer.getValue("UNPLANNED_POLICIES",policy);
									if(policyDetails.indexOf(",")>-1)
									{
										unplannedPolicies = myTokenizer(policyDetails,",");
									}
									else
									{
										unplannedPolicies.add(policyDetails);
									}
									for(int k=0;k<unplannedPolicies.size();k++)
									{
										ArrayList policyDate = new ArrayList();
										policyDate.add(unplannedPolicies.get(k));
										boolean underMaintenance = maintenanceInfo.isItMaintenanceTime(dispDate,policyDate);
										if(underMaintenance)
										{
											if(policyNames1!=null&&policyNames1.equals(""))
											{
												policyNames1 = displayPolicy;
												quickmpolicies.add(policy);
											}											
											else if(policyNames1!=null&&!policyNames1.equals(policy) && !quickmpolicies.contains(policy))
											{
												policyNames1 += ","+displayPolicy;
												quickmpolicies.add(policy);
											}
											if(policyTime1!=null&&policyTime1.equals(""))
											{
												policyTime1 = (String)policyDate.get(0);
											}
											else
											{	
												policyTime1 += "~"+policyDate.get(0);
											}
										}
									}
									
								}
								policyInfos1 = new ArrayList();
								if(policyTime!=null)
								{
									StringTokenizer tok = new StringTokenizer(policyTime1,"~");
									while(tok.hasMoreTokens())
									{
										String token = tok.nextToken();
										if(!token.equals(""))
										{
											if(token.indexOf("#*") > -1)
												token = mappingInfo.getTextDescription("monitor.testDetails.Daily")+"#"+token.substring(0,token.indexOf("-"))+"-"+token.substring(token.indexOf("-")+1,token.indexOf("#"));
											else if(token.indexOf("#FDM") > -1)
												token = mappingInfo.getTextDescription("monitor.testDetails.First day of month")+"#"+token.substring(0,token.indexOf("-"))+"-"+token.substring(token.indexOf("-")+1,token.indexOf("#"));
											else if(token.indexOf("#LDM") > -1)
												token =mappingInfo.getTextDescription("monitor.testDetails.Last day of month")+"#"+token.substring(0,token.indexOf("-"))+"-"+token.substring(token.indexOf("-")+1,token.indexOf("#"));
											else if(token.indexOf("Every")>0)
											{
												String s1 = token.substring(0,token.indexOf("#"));
												String s2 = token.substring(token.indexOf("#")+1);
												String suffix = "th";
												if(s2.endsWith("1") || s2.endsWith("21") || s2.endsWith("31"))
												{
													suffix = "st";
												}
												else if(s2.endsWith("2") || s2.endsWith("22"))
												{
													suffix = "nd";
												}
												else if(s2.endsWith("3") || s2.endsWith("23"))
												{
													suffix = "rd";
												}

												token = mappingInfo.getTextDescription("monitor.common."+s2+suffix+" day of the Month")+"#"+s1.substring(0,s1.indexOf("-")) + "-"+s1.substring(s1.indexOf("-")+1,s1.length());	
											}
											else if(token.indexOf("/") == -1)
											{
												if(token!=null && token.indexOf("$")>0 && token.indexOf("_")>0)
												{
													String timeline = token.substring(0,token.indexOf("#"));
													String day = token.substring(token.indexOf("#")+1);
													String dayVal = day.substring(0,day.indexOf("$"));
													String week = day.substring(day.indexOf("$")+1);
													if(week.equalsIgnoreCase("week_1"))
													{
														week = "First";
													}
													else if(week.equalsIgnoreCase("week_2"))
													{
														week = "Second";
													}
													else if(week.equalsIgnoreCase("week_3"))
													{
														week = "Third";
													}
													else if(week.equalsIgnoreCase("week_4"))
													{
														week = "Fourth";
													}
													else if(week.equalsIgnoreCase("week_5"))
													{
														week = "Fifth";
													}													
													String dispCol=egM.DayForDescription(dayVal);
													dispCol = mappingInfo.getTextDescription("monitor.common."+week)+" "+mappingInfo.getTextDescription("monitor.common.week")+" "+dispCol.toLowerCase()+" "+mappingInfo.getTextDescription("monitor.common.of the month");
													token = timeline +"#"+dispCol;
												}
												else
												{
													if(token.indexOf("#Sun") > -1)
														token = token + "day";
													else if(token.indexOf("#Mon") > -1)
														token = token + "day";
													else if(token.indexOf("#Tue") > -1)
														token = token + "sday";
													else if(token.indexOf("#Wed") > -1)
														token = token + "nesday";
													else if(token.indexOf("#Thu") > -1)
														token = token + "rsday";
													else if(token.indexOf("#Fri") > -1)
														token = token + "day";
													else if(token.indexOf("#Sat") > -1)
														token = token + "urday";
													else if(token.indexOf("none") > -1)
														token="none";
												}
												if (!token.equals("none"))
												{
													String s1 = token.substring(0,token.indexOf("#"));
													String s2 = token.substring(token.indexOf("#")+1);
													token = mappingInfo.getTextDescription("monitor.common."+s2)+"#"+s1.substring(0,s1.indexOf("-")) + "-"+s1.substring(s1.indexOf("-")+1,s1.length());
												}
											}
											else
											{
												if(token!=null && token.indexOf("|")>0)
												{
													String pdat=token.substring(token.indexOf("#")+1,token.length());
													token=token.substring(0,token.indexOf("#"));
													String stTime = token.substring(0,token.indexOf("-"));
													String endTime = token.substring(token.indexOf("-")+1,token.length());
													String stdate=DateUtil.changeDateFormat(pdat.substring(0,pdat.indexOf("|")),"MM/dd/yyyy",dateFormatForDatePicker);
													String enddate=DateUtil.changeDateFormat(pdat.substring(pdat.indexOf("|")+1,pdat.length()),"MM/dd/yyyy",dateFormatForDatePicker);
													//token=stdate+" "+stTime+"Hrs - "+enddate+" "+endTime+"Hrs";
													token=stTime+"-"+endTime+"#"+stdate+"|"+enddate;
												}
												else
												{
													token=token.substring(0,token.indexOf("#")+1)+DateUtil.changeDateFormat(token.substring(token.indexOf("#")+1,token.length()),"MM/dd/yyyy",dateFormatForDatePicker);
												}
											}
										}
										if(policyInfos1!=null&&!policyInfos1.contains(token))
										{
											policyInfos1.add(token);
										}
									}
								}
								if(policyInfos1!=null&&policyInfos1.size()>0)
								{
									for(int j=0;j<policyInfos1.size();j++)
									{
										if(j==0)
										{
											policyTime = (String)policyInfos1.get(j);
										}
										else
										{
											policyTime += "~"+(String)policyInfos1.get(j);
										}
									}
								}
							}
				if(policyNames1!=null && !policyNames1.equals("") && policyTime!=null && !policyTime.equals(""))		//  Quick Maintenance
					{
						screenLabels.put("QuickMaintenanceDetails",mappingInfo.getTextDescription("monitor.testDetails.Quick Maintenance Details"));
						screenLabels.put("policyName",mappingInfo.getTextDescription("monitor.testDetails.Policy  name"));

						JSONArray poldisp1ArrayValue = new JSONArray();
						JSONObject policyNames1Obj = new JSONObject();

						/*if(policyNames1!=null && policyNames1.length()>60)
						{
								int idx=policyNames1.length()/60;
								int index=0;
								for(int i=0;i<idx;i++)
								{
									String poldisp=policyNames1.substring(index,index+60);
									String poldisp1=poldisp.substring(0,poldisp.lastIndexOf(",")+1);

									poldisp1ArrayValue.add(poldisp1);
									index=index+poldisp.lastIndexOf(",")+1;
								}
								policyNames1Object.put("policyNames1",poldisp1ArrayValue);
						}
						else
						{
							policyNames1Object.put("policyNames1",policyNames1);
						}*/
						policyNames1Object.put("policyNames1",policyNames1);
						json.put("policyNames1Object",policyNames1Object);

						screenLabels.put("PolicyTime",mappingInfo.getTextDescription("monitor.testDetails.Policy time"));
						JSONArray poldisp1Values = new JSONArray();
						JSONObject policyTimeValue = new JSONObject();
						StringTokenizer stTokens = new StringTokenizer(policyTime,"~");
						String PolicyDetails = "";
						while(stTokens.hasMoreTokens())
						{
							String policyTimes = stTokens.nextToken();
							if(policyTimes!=null && policyTimes.indexOf("|")>0)
							{
								String time = policyTimes.substring(0,policyTimes.indexOf("#"));
								String dates = policyTimes.substring(policyTimes.indexOf("#")+1);

								String stHr = time.substring(0,time.indexOf("-"));
								String stMin = stHr.substring(stHr.indexOf(":")+1);

								String endHr = time.substring(time.indexOf("-")+1);
								String endMin = endHr.substring(endHr.indexOf(":")+1);

								String stDate = dates.substring(0,dates.indexOf("|"));
								String endDate = dates.substring(dates.indexOf("|")+1);
								
								EgTimeZoneConverter converterStart = new EgTimeZoneConverter(stDate+" "+stHr,user);
								EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(endDate+" "+endHr,user);
							
								stDate = (String)converterStart.getDate(false);
								stHr = converterStart.getHour();
								stMin = converterStart.getMinute();	
								
								endDate = (String)converterEnd.getDate(false);
								endHr = converterEnd.getHour();											
								endMin = converterEnd.getMinute();	

								PolicyDetails +=stDate+" "+stHr+":"+stMin+" Hrs - "+endDate+" "+endHr+":"+endMin+" Hrs"+",";
							}
							else
							{
								String timeFreq = policyTimes.substring(0,policyTimes.indexOf("#"));
								String timeline = policyTimes.substring(policyTimes.indexOf("#")+1);

								String stHr = timeline.substring(0,timeline.indexOf("-"));
								String enHr = timeline.substring(timeline.indexOf("-")+1);

								String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", dateFormatForDatePicker);
								dispStartDate = dispStartDate.trim();
								EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+stHr,user);
								String dispEndDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", dateFormatForDatePicker);
								dispEndDate = dispEndDate.trim();
								EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+enHr,user);

								stHr = converterStart.getHour()+":"+converterStart.getMinute();
								enHr = converterEnd.getHour()+":"+converterEnd.getMinute();

								PolicyDetails +=timeFreq + " "+stHr+" Hrs - "+enHr+" Hrs"+",";
							}
						}
						PolicyDetails = PolicyDetails.substring(0,PolicyDetails.lastIndexOf(","));						
						policyNames1Obj.put("PolicyTime",PolicyDetails);
						json.put("policyNames1Obj",policyNames1Obj);

						/*if(policyTime!=null && !policyTime.equals("") && policyTime.length()>60)
						{
								int idx=policyTime.length()/60;
								int index=0;
								for(int i=0;i<idx;i++)
								{
									String poldisp=policyTime.substring(index,index+60);
									String poldisp1=poldisp.substring(0,poldisp.lastIndexOf(",")+1);

									poldisp1Values.add(poldisp1);
									index=index+poldisp.lastIndexOf(",")+1;
								}
								policyNames1Obj.put("PolicyTime",poldisp1Values);
						}
						else
						{
							policyNames1Obj.put("PolicyTime",policyTime);
						}*/
						//policyNames1ObjectValueData.put("policyNames1Obj",policyNames1Obj);						

					} // CODE FOR QUICK MAINTENANCE POLICY ENDS HERE

		}
		EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
		String str = egUI.getValue("AGGREGATE_DASHBOARD","MemberComponentsInDetails");
		boolean showAssocaitedComponents = (!StringUtils.isNull(str) && (str.trim().equalsIgnoreCase("true") || str.trim().equalsIgnoreCase("yes")))?true:false;

		String aggComponent = s_stype +":";
		if(s_sname.indexOf(":")>-1)
			aggComponent +=s_sname;
		else
			aggComponent +=s_sname+":NULL";

		if(aggregateInfo.getAggregateTypes().contains(s_stype))
		{
			List associatedComponents = aggregateInfo.getAssociatedComponents(aggComponent,true);
			Collections.sort(associatedComponents);
			String display = "block";
			String visibility = "visible";
			if(showAssocaitedComponents)
			{
				display = "block";
				visibility = "visible";
			}
			else
			{
				display = "none";
				visibility = "hidden";
			}
								screenLabels.put("ClickHere",mappingInfo.getTextDescription("admin.common.Click here"));
								if(showAssocaitedComponents)
								{
									memberValue.put("memberComponent",mappingInfo.getTextDescription("admin.common.to hide Member components"));

								}
								else
								{
									memberValue.put("memberComponent",mappingInfo.getTextDescription("admin.common.to show Member components"));

								}
								json.put("memberValue",memberValue);

							aggComponentValue.put("aggComponent",aggComponent.substring(aggComponent.indexOf(":")+1,aggComponent.lastIndexOf(":")));

							JSONArray displayComponentArray= new JSONArray();
							JSONObject displayComponentObj = new JSONObject();
							for(int i=0;i<associatedComponents.size();i++)
							{
								String displayComponent = (String) associatedComponents.get(i);
								String displayType = displayComponent.substring(0,displayComponent.indexOf(":"));
								displayComponent = displayComponent.substring(displayComponent.indexOf(":")+1);
								displayComponent = displayComponent.endsWith(":NULL")?displayComponent.substring(0,displayComponent.lastIndexOf(":")):displayComponent;
								
								displayComponentObj.put("displayComponent",displayComponent);
								displayComponentObj.put("displayType",displayType);
								displayComponentArray.add(displayComponentObj);

							}
							displayComponentObject.put("displayComponentArray",displayComponentArray);
						}
						json.put("displayComponentObject",displayComponentObject);

	}
}
catch(Throwable e)
{
	System.out.println("exception is "+e.toString());
	e.printStackTrace();
}
if(strCsrfToken!=null && strCsrfToken.trim().length()>0)
	json.put("strCsrfToken",strCsrfToken);
json.put("screenLabels",screenLabels);
json.put("measureHost",measureHost);
json.put("s_tnameValue",s_tnameValue);
json.put("testNameValue",testNameValue);
json.put("isVMValue",isVMValue);
json.put("testTypeValue",testTypeValue);
json.put("testFrequencyValue",testFrequencyValue);
json.put("dispInfoArrayObj",dispInfoArrayObj);
json.put("testStateValue",testStateValue);
json.put("threshValue",threshValue);
json.put("matchCriteriaValue",matchCriteriaValue);
String thisTestName = request.getParameter("tname");
if(thisTestName != null && (thisTestName.endsWith("_ag") || thisTestName.endsWith("_agx")))
{
	//IP address for aggregate component is 0.0.0.0. So we do not show it in UI
}
else
{
	json.put("ipAddress",ipAddress);
}
json.put("testStatusInfoTitle",mappingInfo.getTextDescription("monitor.dashboard.Test Status Details"));
int alarmPolicyLength = 15;
response.getWriter().write(json.toString());

%>

<%!
public ArrayList myTokenizer (String str, String delimiter)
{
	if (str == null || str.length() == 0)
	{
		return (null);
	}
	ArrayList a = new ArrayList();
	String sub = null;
	int i = 0;
	int j = str.indexOf(delimiter); // First substring
	while( j >= 0)
	{
		sub = str.substring(i,j);
		a.add(sub.trim());
		i = j + 1;
		j = str.indexOf(delimiter, i); // Rest of substrings
	}
	sub = str.substring(i); // Last substring
	a.add(sub.trim());
	return (a);
}


private String get1(String H)
{
	String h;
	if (!(H.equals("-")))
	{
		if (H.indexOf("&") > -1)
		{
			StringTokenizer st = new StringTokenizer(H,"&");
			H = st.nextToken();
			h = st.nextToken();
		}
		else
		{
			if (H.indexOf("sqc") > -1)
			{
				h = H;
				H = "-";
			}
			else
			{
				h = "-";
			}
		}
	}
	else
	{
		h = "-";
	}
	return(H+"_"+h);
}

private Vector getAbsAndRel(String format)
{
	Vector vect = new Vector();
	StringTokenizer stok1 = new StringTokenizer(format,"/");
	if (!format.equals("-1") && stok1.countTokens() == 3)
	{
		String H1 = stok1.nextToken();
		String h2=get1(H1);
		String M = stok1.nextToken();
		String m1=get1(M);
		String L = stok1.nextToken();
		String l1=get1(L);
		StringTokenizer h1 = new StringTokenizer(h2,"_");
		String High= h1.nextToken();
		String high = h1.nextToken();
		StringTokenizer m = new StringTokenizer(m1,"_");
		String Mid = m.nextToken();
		String mid = m.nextToken();
		StringTokenizer l = new StringTokenizer(l1,"_");
		String Low = l.nextToken();
		String low = l.nextToken();
		StringBuffer sb2 = new StringBuffer();
		StringBuffer sb1 = new StringBuffer();
		String s1 = null;
		if (High.equals("-") && Mid.equals("-") && Low.equals("-"))
		{
			s1 = "none";
		}
		else
		{
			sb1.append(High);
			sb1.append("/");
			sb1.append(Mid);
			sb1.append("/");
			sb1.append(Low);
			s1 = sb1.toString();
		}
		String s2 = null;
		if (high.equals("-") && mid.equals("-") && low.equals("-"))
		{
			vect.add(s1);
			vect.add("none");
		}
		else
		{
			sb2.append(high);
			sb2.append("/");
			sb2.append(mid);
			sb2.append("/");
			sb2.append(low);
			s2 = sb2.toString();
			vect.add(s1);
			vect.add(s2);
		}
	}
	else
	{
		vect.add("none");
		vect.add("none");
	}
	return vect;
}

private String getThresholdValue(String grpFunction, String absValue,String relValue)
{
	String strValue = "-";

	if (absValue.equals("-") && relValue.equals("-"))
	{
		strValue = "-";
	}
	else if (!absValue.equals("-") && !relValue.equals("-"))
	{
		strValue = grpFunction+"("+absValue+", "+getRelativeThreshold(relValue)+")";
	}
	else if (!absValue.equals("-"))
	{
		strValue = absValue;
	}
	else if (!relValue.equals("-"))
	{
		strValue = getRelativeThreshold(relValue);
	}

	return strValue;
}

private String getRelativeThreshold(String relValue)
{
	//relValue: 3*sqc
	String strValue = "";
	if (relValue.indexOf("*") != -1)
	{
		int idx = relValue.indexOf("*");
		String s1 = relValue.substring(0,idx);
		double d_value = Double.valueOf(s1.trim()).doubleValue();
		d_value = d_value * 100;
		int i_value = (new Double(d_value)).intValue();
		strValue = Integer.toString(i_value) + "% of auto";
	}
	else
	{
		strValue = "auto";
	}
	return strValue;
}
protected String findAndReplaceString(String s,String s_search,String s_replace)
{
	StringBuffer sb_tmp = new StringBuffer();
	while(s.indexOf(s_search) > -1)
	{
		sb_tmp.append(s.substring(0,s.indexOf(s_search)) + s_replace);
		s = s.substring(s.indexOf(s_search) + s_search.length(),s.length());
	}
	if(s.length() > 0)
		sb_tmp.append(s);
	return sb_tmp.toString();
}
%>



