<%@ page language="java" contentType="application/json;charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="EgMonitorTracker.jsp" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="java.text.SimpleDateFormat" %>
<%@ page import="com.egurkha.monitor.MonitorDAOFactory" %>
<%@ page import="com.egurkha.monitor.EgServerDashBoardDAO" %>
<%@ page import="com.eg.EgDbInfo" %>
<%@ page import="com.eg.*" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "com.egurkha.monitor.*"%>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgDisableInfo"%>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import="java.util.Date"%>
<%@ page import="net.sf.json.*"%>
<%@ page import="com.egurkha.HighChartTimeline" %>
<%@ page import="com.egurkha.monitor.EgFusionChartUtil" %>
<%@ page import="com.egurkha.monitor.EgGraphsUtil" %>

<%
	response.setHeader("Cache-Control","no-Store");
	response.setHeader("Pragma","no-Cache");
	response.setDateHeader("Expires",-1);
try
{
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();
	EgMappingInfo egMappingInfo=new EgMappingInfo(trackerLanguage);

	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONArray chartArr=new JSONArray();

	String compName=request.getParameter("hostName");
	String compType=request.getParameter("compType");
	String tab=request.getParameter("tab");
	String blockType=request.getParameter("blockType");
	String ciscoSelectedType=request.getParameter("ciscoSelectedType");
	String test=request.getParameter("testName");
	String measure=request.getParameter("measureName");
	String defaultInfo=request.getParameter("defaultInfo");
	String selectedDate=request.getParameter("selectedDate");
	String selectedInterface=request.getParameter("selectedInterface");

	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}
	if(EgInstallInfo.isSuperManager)
	{
		if(compName != null && compName.indexOf(":")>-1)
		{
			ArrayList managerIds = EgElementInfo.getInstance().getManagerIDs("component",compName.substring(0,compName.indexOf(":")));
			if(managerIds != null && !managerIds.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(session.getId(),managerIds);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
			}
		}
	}
	JSONArray subSystemArr = new JSONArray();		
	String overviewSelected = "", protocolsSelected = "", flowsSelected = "" ;
	if ( ciscoSelectedType != null && ciscoSelectedType.equalsIgnoreCase("overview") )
	{		
		overviewSelected = "selected";
		protocolsSelected = "";
		flowsSelected = "";
	}
	else if ( ciscoSelectedType != null && ciscoSelectedType.equalsIgnoreCase("protocols") )
	{
		overviewSelected = "";
		protocolsSelected = "selected";
		flowsSelected = "";
	}
	else if ( ciscoSelectedType != null && ciscoSelectedType.equalsIgnoreCase("flows") )
	{
		overviewSelected = "";
		protocolsSelected = "";
		flowsSelected = "selected";
	}	
	String options[] = {"overview", "protocols", "flows"}, dispVal = "";
	String subSystemSelected = "";
	for ( int i = 0 ; i < options.length; i++ )
	{
		JSONObject subsystemCombo = new JSONObject();
		if ( ciscoSelectedType != null && ciscoSelectedType.equalsIgnoreCase( options[ i ] ) )
		{
			subSystemSelected = "selected";
		}
		else
		{
			subSystemSelected = "";
		}

		if ( options[i].equals("overview") )
		{
			dispVal = "Overview";
		}
		else if ( options[i].equals("protocols") )
		{
			dispVal = "Protocols";
		}
		else if ( options[i].equals("flows") )
		{
			dispVal = "Flows";
		}
		//selectedValues.put("subsystemSelected", ciscoSelectedType);
		subsystemCombo.put("displayField",mappingInfo.getTextDescription("monitor.dashboard."+dispVal));
		subsystemCombo.put("valueField",options[i]);
		subSystemArr.add(subsystemCombo);
	}
	rootJson.put("subSystemArr",subSystemArr);
	rootJson.put("subsystemSelected",mappingInfo.getTextDescription("monitor.dashboard."+ciscoSelectedType));
	IniUI iniui = IniUI.getInstance();
	EgDbInfo dbinfo=new EgDbInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgTesterInfo testInfo = new EgTesterInfo("manager");
	EgDisableInfo disableInfo = new EgDisableInfo("manager");
	EgDateInfo edi = new EgDateInfo();
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniobj=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");
	MonitorDAOFactory factory=MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=factory.getServerDashBoardDAO();
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);
	EgGraphsUtil graphUtil=new EgGraphsUtil(trackerLanguage);
	EgSummaryChartUtil summaryChart=new EgSummaryChartUtil();

	EgUserRole userRole = u_ser.getUserRole();
	long perm = EgUserPermission.ADMIN;
	boolean adminPermission = userRole.hasAdminRole(perm);
	String defaultMGraphDuration=iniobj.getValue("Default_MeasureGraph_Duration","duration");
	String defaultPieGraphDuration=iniobj.getValue("Default_PieGraph_Duration","duration");
	String defaultAreaGraphDuration=iniobj.getValue("Default_AreaGraph_Duration","duration");
	
	String FullViewPriority="TOP+-+10";
	String hostName="";
	String portNo="";
	String sid="";
	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
		{
			portNo=st.nextToken();
		}

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}

	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);
	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);
	ArrayList getExcludedTest = disableInfo.getExcludedTestsForComponent(compName, compType);
	Vector runningTests = dashboardDAO.getRunningTestsForServer(compName, compType, tab);

	if(blockType!=null && blockType.equals("areaChart"))
	{
		SimpleDateFormat sdf=new SimpleDateFormat("MM/dd/yyyy HH:mm");
		int[] timeFormat={1000*60*60,1000*60*60*24*7,1000*60*60*24*30};
		int passValue=1000*60*60;
		String title="";
		String startDateTime="";
		String endDateTime="";
		String s_en_time="";
		String s_st_time="";
		String s_st_hr = "";
		String s_en_hr="";
		String timeSelect="";
		if(selectedDate!=null && !selectedDate.equals(""))
		{
			selectedDate=selectedDate.toLowerCase();
			timeSelect=selectedDate.toLowerCase();
			int blankSpaceIndex = selectedDate.indexOf(DateTimeTokenizer.BLANK_SPACE);
			if (blankSpaceIndex > 0)
			{
				String titletmp=selectedDate;
				java.util.Date today = edi.egetRealDate();
				endDateTime=sdf.format(today);
				int value = Integer.parseInt(selectedDate.substring(0, blankSpaceIndex));
				String timelineUnit = selectedDate.substring(blankSpaceIndex+1).toLowerCase();
				if (timelineUnit.startsWith("h"))
				{//hours
					value *= 3600;
					title=titletmp;
				}
				else if (timelineUnit.startsWith("d"))
				{//days
					value *= (24 * 3600);
					title=titletmp;
				}
				else if (timelineUnit.startsWith("w"))
				{//weeks
					value *= (7 * 24 * 3600);
					title=titletmp;
				}
				else if (timelineUnit.startsWith("mo"))
				{//months
					//value *= (30 * 24 * 3600);
					value *=(24*(ErUtils.getMaxDaysInMonth()) * 3600);
					title=titletmp;
				}
				long longValue=value;
				java.util.Date start = edi.egetRealDate();
				start.setTime(today.getTime() - (longValue * 1000));
				startDateTime = sdf.format(start);
				if ((startDateTime != null) && (endDateTime != null))
				{
					int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));  
					int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
					s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
					s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
					s_st_hr = String.valueOf(shr);
					s_en_hr = String.valueOf(en_hr);
				}
			}
		}
		else
		{
			timeSelect="1 hour";
			java.util.Date endDate=edi.egetRealDate();
			endDateTime=sdf.format(endDate);
			java.util.Date startDate=edi.egetRealDate();
			startDate.setTime(endDate.getTime() - (3600 * 1000));
			startDateTime=sdf.format(startDate);
			if ((startDateTime != null) && (endDateTime != null))
			{
				int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));  
				int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
				s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_hr = String.valueOf(shr);
				s_en_hr = String.valueOf(en_hr);
			}
			title="1 hour";
		}
		String interfaceEntries = iniobj.getValue(compType,"Cisco_Interface");
		if(interfaceEntries!=null && interfaceEntries.length() > 0)
		{
			String infosToArea=request.getParameter("infosToArea");
			StringBuffer tmpBuffer=new StringBuffer();
			if(infosToArea!=null && !infosToArea.equals(""))
			{
				StringTokenizer stt=new StringTokenizer(infosToArea,",");
				
				while(stt.hasMoreTokens())
				{
					String tok=stt.nextToken();
					tok=tok.trim();
					tok="+"+tok;
					//tmpBuffer.append("'");
					tmpBuffer.append(tok);
					//tmpBuffer.append("'");
					if(stt.hasMoreTokens())
						tmpBuffer.append(",");

				}
			}
			infosToArea=tmpBuffer.toString();
			StringTokenizer stoken=new StringTokenizer(interfaceEntries,",");
			double defaultTableWidth=940;
			double tableWidth=910;
			double tableWidth1024PxInPercent=defaultTableWidth/1024;
			tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
			tableWidth=MathUtils.round(tableWidth,0);
			String tblWidth=Double.toString(tableWidth);
			int cnt=0; 
			boolean isFullView=false;
			boolean isDisabled=false;
			ArrayList pieChartNAList = new ArrayList();

			while(stoken.hasMoreTokens())
			{		
				JSONObject chartObj=new JSONObject();
				String testMeasure=stoken.nextToken();
				String interface_test=testMeasure.substring(0,testMeasure.indexOf(":"));
				String interface_measure=testMeasure.substring(testMeasure.indexOf(":")+1);
				if(interface_measure.equals("Availability"))
					continue;

				boolean isExcludedTest = false;
				if(getExcludedTest != null && getExcludedTest.contains(interface_test))
					isExcludedTest = true;

				if(enabledTests!=null && enabledTests.contains(interface_test) && !isExcludedTest )
				{		
					String measureForDB=dbinfo.getColumnForMeasure(interface_test,interface_measure);
					String msmthost=(String)allMsmtHosts.get(interface_test);
					Vector currentValues=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,interface_test,measureForDB,msmthost,"",true,"");
					String info="";
					if(currentValues!=null && currentValues.size() >0)
					{
						for(int i=0;i<currentValues.size();i=i+2)
						{
							String currentInfo=(String)currentValues.get(i);
							currentInfo=com.egurkha.util.StringUtils.replace(currentInfo, "+", "*");
							if(currentValues.size()>1)
								info+=currentInfo+",";
							String value=(String)currentValues.get(0);
						}
					}	
					String tableName = iniobj.getValue("Dashboard_GraphTitle_Mapping",testMeasure);
					String unit=tablesInfo.getUnitForMeasure(interface_test,interface_measure);
				
					String mappingName = iniobj.getValue("Dashboard_TableColumn_mapping",testMeasure);
				
					if(mappingName!=null && mappingName.equals(""))
					{
						mappingName="Band Width Usage";
					}
					String s_layer=dashboardDAO.getLayerForTest(compType,interface_test,interface_measure);
					String width="440";
					String height="180";
					if(unit.equals("%"))
						unit="percent";
					
					Vector Infos=(Vector)allTestInfos.get(interface_test);
					String cisInfo="";
					if(Infos!=null && Infos.size()>0)
					{
						if(interface_test.equals("SystemTest") && Infos.contains("+Summary"))
						{
							cisInfo="+Summary";
						}
						else
						{
							cisInfo=(String)Infos.get(0);
						}
					}
					
					String s_start_time = s_st_time+" "+ s_st_hr+":00:00";
					String s_end_time = s_en_time+" "+ s_en_hr+":00:00";
					String tline = null;				
					String graphFormat = HighChartTimeline.getChartOption(tline,"MM/dd/yyyy HH:mm:ss",s_start_time,s_end_time);

					String TimePeriod = s_st_time+" "+s_st_hr+":00|"+s_en_time+" "+s_en_hr+":00";
					String compTypewithNameAndPort = compType+":"+compName;
					
					String unitMapping = graphUtil.getUnitMapping(unit);
					infosToArea = StringUtils.encodeSecurityChar(infosToArea);					
					String titleVal = mappingInfo.getTextDescription("monitor.dashboard."+mappingName)+" ("+unitMapping+")";
					String encodeTitleVal = StringUtils.encodeSecurityChar(titleVal);
					String areaChartURL = "/final/servlet/com.egurkha.monitor.CustomTimelineMeasures?"+"chartType=area&host="+EgURLEncoder.encode(compName, "UTF-8")+"&comptype="+EgURLEncoder.encode(compType, "UTF-8")+"&descriptors="+EgURLEncoder.encode(infosToArea,"UTF-8")+"&fromDashboard=true&test="+interface_test+"&measure="+interface_measure+"&Timeline="+EgURLEncoder.encode(timeSelect, "UTF-8")+"&TimePeriod="+EgURLEncoder.encode(TimePeriod, "UTF-8")+"&components="+EgURLEncoder.encode(compTypewithNameAndPort, "UTF-8")+"&Title="+EgURLEncoder.encode(encodeTitleVal,"UTF-8")+"&gtype=1&graphFormat="+graphFormat;
					
					
					chartObj.put("mappingName",titleVal);
					if(areaChartURL!=null && !areaChartURL.equals(""))
					{		
						if(unit.equals("percent"))
							unit="%";
						chartObj.put("Title",titleVal);
						chartObj.put("Type","area_chart");
						chartObj.put("areaChartURL",areaChartURL);					
						chartObj.put("GRAPH_FORMAT", graphFormat);												
					}
					else
					{
						pieChartNAList.add(title);					
					}								
				}
				else
				{
					isDisabled=true;				
					chartObj.put("NoTestMsg",mappingInfo.getTextDescription("monitor.common.Test has been excluded or disabled"+"!"));
					break;
				}
				cnt++;
				chartArr.add(chartObj);
			}	
			if(!isDisabled && pieChartNAList.size()==cnt)
			{
				String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
				rootJson.put("NoMeasureMsg",NoMeasure);
				//chartArr.add(chartObj);
			}			
		}
		rootJson.put("AREACHART_DATA",chartArr);
	}
	else if(blockType!=null && blockType.equals("Protocols"))
	{
		String timeline = request.getParameter("protocolTimeline");		
		if(StringUtils.isNull(timeline))
			timeline = defaultAreaGraphDuration;
		String[] timeline_options =new String[] {"30 mins","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks"};		
		JSONObject timelineObj = new JSONObject();
		JSONArray timelineArray = new JSONArray();
		timelineObj.put("monitor.dashboard.TimeLine",egMappingInfo.getTextDescription("monitor.dashboard.Timeline"));
		timelineObj.put("method","timelineOnchange");
		
		for(int e_ctr=0; e_ctr < timeline_options.length;e_ctr++)
		{
			JSONObject timelineCombo = new JSONObject();
			if(timeline!=null && timeline.equals((String)timeline_options[e_ctr]))
			{
				String tempOptions="";
				String tempOptions2="";

				if(timeline.indexOf(" ")>-1)
				{
					tempOptions2=timeline.substring(0,timeline.indexOf(" "))+" ";
					tempOptions=timeline.substring(timeline.indexOf(" ")+1);
				}
				else
				{
					tempOptions=timeline;
				}
				timelineCombo.put("displayField",tempOptions2+egMappingInfo.getTextDescription("monitor.common."+tempOptions));
				timelineCombo.put("valueField",timeline);
				timelineObj.put("protocolSelectedTimelineCombo",timeline);
				timelineArray.add(timelineCombo);
			}
			else
			{
				String tempOptions="";
				String tempOptions2="";

				if(timeline_options[e_ctr].indexOf(" ")>-1)
				{
					tempOptions2=timeline_options[e_ctr].substring(0,timeline_options[e_ctr].indexOf(" "))+" "; tempOptions=timeline_options[e_ctr].substring(timeline_options[e_ctr].indexOf(" ")+1);
				}
				else
				{
					tempOptions=timeline_options[e_ctr];
				}
				timelineCombo.put("displayField",tempOptions2+egMappingInfo.getTextDescription("monitor.common."+tempOptions));
				timelineCombo.put("valueField",timeline_options[e_ctr]);
				timelineArray.add(timelineCombo);
			}			
		}
		timelineObj.put("ProtocolTimelineComboArray",timelineArray);
		rootJson.put("ProtocolTimelineCombo",timelineObj);


		JSONObject protocalObj=new JSONObject();
		JSONArray protocalArr=new JSONArray();
		double defaultTableWidth=940;
		double tableWidth=910;
		double tableWidth1024PxInPercent=defaultTableWidth/1024;
		tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
		tableWidth=MathUtils.round(tableWidth,0);
		String tblWidth=Double.toString(tableWidth);
		String iniData=(String)iniobj.getValue(compType,"Cisco_Protocol");
		//newly added
		String infosToArea=request.getParameter("infosToArea");	
		StringBuffer tmpBuffer=new StringBuffer();
		if(infosToArea!=null && !infosToArea.equals(""))
		{
			StringTokenizer stt=new StringTokenizer(infosToArea,",");			
			while(stt.hasMoreTokens())
			{
				String tok=stt.nextToken();
				tok=tok.trim();
				tok="+"+tok;
				//tmpBuffer.append("'");
				tmpBuffer.append(tok);
				//tmpBuffer.append("'");
				if(stt.hasMoreTokens())
					tmpBuffer.append(",");
			}
		}
		infosToArea=tmpBuffer.toString();			
		if(iniData!=null)
		{
			StringTokenizer st=new StringTokenizer(iniData,",");
			while(st.hasMoreTokens())
			{				
				String testWithMeasure=st.nextToken();		
				String s_test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));
				String s_measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1);
				String unit=tablesInfo.getUnitForMeasure(s_test,s_measure);
				String measureForDB=dbinfo.getColumnForMeasure(s_test,s_measure);

				boolean isExcludedTest = false;
				if(getExcludedTest!=null && getExcludedTest.contains(s_test))
					isExcludedTest = true;

				if(enabledTests!=null && enabledTests.contains(s_test) && !isExcludedTest )
				{
					String msmthost=(String)allMsmtHosts.get(s_test);
					Vector currentValues=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,s_test,measureForDB,msmthost,"",true,"");
					String defaultInterface="";
					Map map=new TreeMap();
					if(currentValues!=null && currentValues.size()>0)
					{
						for(int i=0;i<currentValues.size();i=i+2)
						{
							String info=(String)currentValues.get(i);
							String interFace="";
							String protocol="";

							if(compType.equals("NetflowDevice"))
							{
								if(info!=null && info.indexOf("#")>0)
								{
									interFace=info.substring(0,info.indexOf("#"));	
									protocol=info.substring(info.indexOf("#")+1);
								}		
							}
							else
							{
								if(info!=null && info.indexOf(":")>0)
								{
									interFace=info.substring(0,info.indexOf(":"));			
									protocol=info.substring(info.indexOf(":")+1);
								}
							}				
							String value=(String)currentValues.get(i+1);
							defaultInterface=interFace;						
							if(map!=null && map.containsKey(interFace))
							{
								List existingList=(ArrayList)map.get(interFace);
								existingList.add(protocol);
								existingList.add(value);
								map.put(interFace,existingList);
							}
							else
							{
								List innerList=new ArrayList();
								innerList.add(protocol);
								innerList.add(value);
								map.put(interFace,innerList);
							}
						}					
						String url="/final/monitor/EgCiscoDashHelperJSON.jsp?tab="+tab+"&hostName="+hostName+"&compType="+compType+"&subsystem=Overview&blockType=Protocols";						
						String TITLE = mappingInfo.getTextDescription("monitor.dashboard.Bandwidth usage (%) distribution per Application/ Protocol");
						if(TITLE!=null && TITLE.indexOf("#")>-1)
							TITLE = TITLE.substring(0,TITLE.indexOf("#"));

						//TITLE +=" ("+unit+")";
						TITLE += " - Last "+timeline;
						String Interface_TITLE = mappingInfo.getTextDescription("monitor.common.Interface");
						
						protocalObj.put("TITLE",TITLE);
						protocalObj.put("COLUMNAM_0",Interface_TITLE);
						JSONArray comboArr=new JSONArray();
						String infosArea = "";
						if(map!=null && !map.isEmpty())
						{							
							Iterator itr=map.keySet().iterator();
							int j=0;
							while(itr.hasNext())
							{
								JSONObject comboObj=new JSONObject();
								if(j>3)
									continue;
								String interfaceInfo=(String)itr.next();
								String interFaceName=com.egurkha.util.StringUtils.replace(interfaceInfo, "+", "");
								if(StringUtils.isNull(selectedInterface))
								{
									selectedInterface =interFaceName;	
								}
								String selected="";						
								if(selectedInterface!=null && selectedInterface.equals(interFaceName))
								{
									selected="selected";
									//selectedInterface="+"+selectedInterface;
									defaultInterface=selectedInterface;
									protocalObj.put("selectedCombo",interFaceName);
									List valList=(ArrayList)map.get(interfaceInfo);									
									for(int i=0;i<valList.size();i=i+2)
									{   
										String protocol=(String)valList.get(i);
										infosArea+=interfaceInfo+":"+protocol+",";
									}
								}
								comboObj.put("valueField",interFaceName);
								comboObj.put("displayField",interFaceName);
								///Will check the combo value
								j++;
								comboArr.add(comboObj);
							}
							if(infosArea!=null && infosArea.indexOf(",")>0)
							{
								infosArea = infosArea.substring(0,infosArea.lastIndexOf(","));						
							}							
						}
						protocalObj.put("COLUMNVAL_0",comboArr);	
						String mappingName = iniobj.getValue("Dashboard_TableColumn_mapping",testWithMeasure);	
						int cnt=4;
						String Title="Protocol distribution by bandwidth usage ";
						//String defaultTime="1 hour";
						Vector Infos=(Vector)allTestInfos.get(s_test);
						String ddinfo="";
						if(Infos!=null && Infos.size()>0)
						{
							if(s_test.equals("SystemTest") && Infos.contains("+Summary"))
							{
								ddinfo="+Summary";
							}
							else
							{
								ddinfo=(String)Infos.get(0);
							}
						}
						infosArea = StringUtils.encodeSecurityChar(infosArea);
						String compTypewithNameAndPort = compType+":"+compName;
						String areaChartURL = "/final/servlet/com.egurkha.monitor.CustomTimelineMeasures?"+"chartType=area&host="+EgURLEncoder.encode(compName, "UTF-8")+"&comptype="+EgURLEncoder.encode(compType, "UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmthost, "UTF-8")+"&descriptors="+EgURLEncoder.encode(infosArea,"UTF-8")+"&fromDashboard=true&test="+s_test+"&measure="+s_measure+"&Timeline="+EgURLEncoder.encode(timeline, "UTF-8")+"&TimePeriod="+"&components="+EgURLEncoder.encode(compTypewithNameAndPort, "UTF-8")+"&Title="+StringUtils.encodeSecurityChar(TITLE)+"&gtype=1&graphFormat=highcharts";
						if(areaChartURL!=null && !areaChartURL.equals(""))
						{
							protocalObj.put("Title",mappingInfo.getTextDescription("monitor.dashboard."+mappingName));
							protocalObj.put("Type","area_chart");
							protocalObj.put("areaChartURL",areaChartURL);					
							protocalObj.put("GRAPH_FORMAT", "highchart");
						}									
					}
					else
					{
						String NoMeasure = mappingInfo.getTextDescription("monitor.dashboard.No measures available!");
						protocalObj.put("NoMeasureMsg",NoMeasure);
					}

				}
				else
				{
					String testMeasure = mappingInfo.getTextDescription("monitor.common.Test has been excluded or disabled"+"!");
					protocalObj.put("NoMeasureMsg",testMeasure);
				}
				protocalArr.add(protocalObj);
			}
			rootJson.put("CHARTNTABLE_DATA",protocalArr);
		}
	}
	else if(blockType!=null && blockType.equals("Flows"))
	{
		ErUtils erutils=new  ErUtils();
		String timeline = request.getParameter("timeline");		
		if(StringUtils.isNull(timeline))
			timeline = defaultPieGraphDuration;
		String[] timeline_options =new String[] {"30 mins","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks"};		
		JSONObject timelineObj = new JSONObject();
		JSONArray timelineArray = new JSONArray();
		timelineObj.put("monitor.dashboard.TimeLine",egMappingInfo.getTextDescription("monitor.dashboard.Timeline"));
		timelineObj.put("method","timelineOnchange");
		String DefaultTimeDuration=iniobj.getValue("Default_DashboardGraph_Duration", "duration");
		for(int e_ctr=0; e_ctr < timeline_options.length;e_ctr++)
		{
			JSONObject timelineCombo = new JSONObject();
			if(timeline!=null && timeline.equals((String)timeline_options[e_ctr]))
			{
				String tempOptions="";
				String tempOptions2="";

				if(timeline.indexOf(" ")>-1)
				{
					tempOptions2=timeline.substring(0,timeline.indexOf(" "))+" ";
					tempOptions=timeline.substring(timeline.indexOf(" ")+1);
				}
				else
				{
					tempOptions=timeline;
				}
				timelineCombo.put("displayField",tempOptions2+egMappingInfo.getTextDescription("monitor.common."+tempOptions));
				timelineCombo.put("valueField",timeline);
				timelineObj.put("selectedTimelineCombo",timeline);
				timelineArray.add(timelineCombo);
			}
			else
			{
				String tempOptions="";
				String tempOptions2="";

				if(timeline_options[e_ctr].indexOf(" ")>-1)
				{
					tempOptions2=timeline_options[e_ctr].substring(0,timeline_options[e_ctr].indexOf(" "))+" "; tempOptions=timeline_options[e_ctr].substring(timeline_options[e_ctr].indexOf(" ")+1);
				}
				else
				{
					tempOptions=timeline_options[e_ctr];
				}
				timelineCombo.put("displayField",tempOptions2+egMappingInfo.getTextDescription("monitor.common."+tempOptions));
				timelineCombo.put("valueField",timeline_options[e_ctr]);
				//timelineObj.put("selectedTimelineCombo",tempOptions2);
				timelineArray.add(timelineCombo);
				/*if(timeline_options[e_ctr].equalsIgnoreCase(DefaultTimeDuration) && graphType!=null && graphType.equalsIgnoreCase("Measuregraph") )
				{
					break;
				}*/
			}			
		}
		timelineObj.put("timelineComboArray",timelineArray);
		rootJson.put("timelineCombo",timelineObj);

		String flows_Count=iniobj.getValue("Interfaces","flows");
		
		JSONObject flowsObj = new JSONObject();
		JSONArray folwsArr = new JSONArray();
		JSONArray gridJsons=new JSONArray();
		double defaultTableWidth=920;
		double tableWidth=920;
		double tableWidth1024PxInPercent=defaultTableWidth/1024;
		tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
		tableWidth=MathUtils.round(tableWidth,0);
		String tblWidth=Double.toString(tableWidth);

		double defaultChartWidth=200;
		double chartWidth=200;
		double chartWith1024PxInPercent=defaultTableWidth/1024;
		chartWidth=screenWidthInDouble*chartWith1024PxInPercent;
		chartWidth=MathUtils.round(chartWidth,0);
		String iniVal=(String)iniobj.getValue(compType,"Cisco_Flows_piechart");
		
		if(iniVal!=null )
		{
			StringTokenizer stoken=new StringTokenizer(iniVal,",");
			int j=0;
			Map tableData=new HashMap();
			String align="left";
			String px="padding-left:20px;";
			while(stoken.hasMoreTokens())
			{				
				String testWithMeasure=stoken.nextToken();
				String s_test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));
				String tableTitle=(String)iniobj.getValue("Dashboard_Comparison_TableTitle",s_test);
				StringBuffer sb=new StringBuffer();
				//sb.append("Top ");
				//sb.append(" ");
				sb.append(tableTitle);
				if(enabledTests!=null && enabledTests.contains(s_test))
				{
					String s_measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1,testWithMeasure.indexOf("$"));
					String tableId=testWithMeasure.substring(testWithMeasure.indexOf("$")+1);
					String msmthost=(String)allMsmtHosts.get(s_test);
					Vector currentValues=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,s_test,s_measure,msmthost,"",true,"10");
					int size=0;
					if(currentValues!=null && currentValues.size()>0)
					{
						for(int i=0;i<currentValues.size();i=i+2)
						{
							size++;
						}
					}
					
					Vector chartAttributes=new Vector();
					//caption="Sales Per Employee for year 1996" palette="2" animation="1" formatNumberScale="0" numberPrefix="$" pieSliceDepth="30" startingAngle="125"
					//chartAttributes.add("caption='"+sb.toString()+"'");
					chartAttributes.add("decimals='2'");
					chartAttributes.add("enableRotation='1'");
					chartAttributes.add("bgColor='99CCFF,FFFFFF'");
					chartAttributes.add("bgAlpha='0,0'");
					//chartAttributes.add("bgRatio='0,100'");
					chartAttributes.add("bgAngle='360'");
					chartAttributes.add("showBorder='0'");
					chartAttributes.add("startingAngle='80'");
					//healthChartAttributes.add("baseFontColor ='545454'");//this one add in java for check the condition
					chartAttributes.add("chartLeftMargin ='0'");
					chartAttributes.add("chartTopMargin ='0'");
					chartAttributes.add("chartBottomMargin ='0'");
					chartAttributes.add("chartRightMargin ='0'");
					chartAttributes.add("showToolTipShadow ='1'");
					chartAttributes.add("pieSliceDepth='7'");
					chartAttributes.add("numberSuffix='%'");
					chartAttributes.add("showToolTipShadow ='1'");
					chartAttributes.add("pieOuterFaceAlpha  ='75'");
					chartAttributes.add("pieInnerFaceAlpha  ='100'");
					chartAttributes.add("pieYScale  ='49'");
					chartAttributes.add("smartLineColor  ='BABABA'");
					chartAttributes.add("smartLabelClearance  ='2'");
					chartAttributes.add("captionPadding  ='0'");
					chartAttributes.add("bgSWFAlpha  ='0'");
					chartAttributes.add("enableSmartLabels='1'");
					chartAttributes.add("pieRadius='80'");
					chartAttributes.add("labelDistance='3'");
					chartAttributes.add("isSmartLineSlanted='1'");
					chartAttributes.add("exportEnabled='0'");
					chartAttributes.add("exportAction='download'");
					chartAttributes.add("exportAtClient='0'");
					chartAttributes.add("showPlotBorder='1'");
					chartAttributes.add("plotBorderColor='000000'");
					chartAttributes.add("skipOverlapLabels='0'");

					chartAttributes.add("legendPosition='RIGHT'");
					chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
					flowsObj.put("mappingName",mappingInfo.getTextDescription("monitor.dashboard."+sb.toString()));
					String xml=(String)graphUtil.getXMLtoProtocol(currentValues,chartAttributes);
					if(xml!=null && !xml.equals(""))
					{						
						flowsObj.put("XML_DATA",xml);
						flowsObj.put("width","970");
						flowsObj.put("height","140"); 
						flowsObj.put("SWF_PATH","/final/FusionCharts/swf/Pie3D.swf");
						
						JSONObject gridJson = new JSONObject();
						gridJson.put("TABLE_TITLE",mappingInfo.getTextDescription("monitor.dashboard.Details"));
						String iniTables=(String)iniobj.getValue(compType,"Cisco_Flows_"+tableId);
						
						if(iniTables!=null && iniTables.length()>0)
						{							
							Vector table=new Vector();
							Vector header=new Vector();
							Vector units=new Vector();
							StringTokenizer st=new StringTokenizer(iniTables,",");
							String[] names={"Sources","Destination","Conversation"};
							units.add("-");
							String comparisonTableFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&blockType=CiscoComparisionTable&tab=Network";
							StringBuffer measureColumn=new StringBuffer();
							String fullviewTest="";
							String fullviewMsmtHost="";
							String interfaceCount_fullview="";
							int tableCount=0;
							int headerCount=0;
							while(st.hasMoreTokens())
							{	
								String testMeasures=(String)st.nextToken();
								String headerName=(String)iniobj.getValue("Dashboard_TableColumn_mapping",testMeasures);
								//String flows_Count=iniobj.getValue("Interfaces","flows");
								String testname=testMeasures.substring(0,testMeasures.indexOf(":"));
								String measurename=testMeasures.substring(testMeasures.indexOf(":")+1);
								String measureForDB=dbinfo.getColumnForMeasure(testname,measurename);
								String unit=tablesInfo.getUnitForMeasure(testname,measurename);
								String msmt_host=(String)allMsmtHosts.get(testname);
							
								fullviewTest=testname;
								fullviewMsmtHost=msmt_host;
								interfaceCount_fullview=flows_Count;
								measureColumn.append(measureForDB);
								if(st.hasMoreTokens())
									measureColumn.append(",");
								//newly added
								
								Vector currentValues1=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,testname,measureForDB,msmt_host,"",true,flows_Count);
								String key="table"+j;
								table.add(currentValues1);
								if(tableCount==0)
								{
									header.add(mappingInfo.getTextDescription("monitor.dashboard."+names[j]));
								}

								header.add(mappingInfo.getTextDescription("monitor.dashboard."+headerName));
								String unitMapping = graphUtil.getUnitMapping(unit);
								units.add(unitMapping);
								tableCount++;
								headerCount++;
							}
							int imgcnt=0;
							int stColPos=1;
							int endColPos=5;
							if(j<=1)
							{
								endColPos=4;
							}
							String rsTableName="rsTableflows"+j;
							comparisonTableFullViewURL+="&test="+fullviewTest+"&measure="+measureColumn+"&msmtHost="+fullviewMsmtHost+"&interfaces_Count="+interfaceCount_fullview+"&fromInterface=false&headerList="+header+"&inilookup=Cisco_Flows_"+tableId;
														
							JSONObject ColObj = new JSONObject();							
							for(int k=0;k<header.size();k++)
							{
								String h_unit=(String)units.get(k);
								if(h_unit.equals("-"))
									h_unit="";
								if(k==0)
								{
									ColObj.put("COLUMNNAME_"+k,(String)header.get(k));		
								}
								else
								{
									ColObj.put("COLUMNNAME_"+k,(String)header.get(k)+"("+h_unit+")");								
								}								
								imgcnt++;								
							}							
							gridJson.put("tableColumns",ColObj);							
							if(table!=null && table.size()>0)
							{
								Map map=new HashMap();
								for(int i=0;i<table.size();i++)
								{
									Vector measureVector=(Vector)table.get(i);
									
									if(measureVector!=null && measureVector.size()>0)
									{
										for(int m=0;m<measureVector.size();m=m+2)
										{
											String info=(String)measureVector.get(m);
											String value=(String)measureVector.get(m+1);
											if(map!=null && map.containsKey(info))
											{
												List existingList=(ArrayList)map.get(info);
												existingList.add(value);
												map.put(info,existingList);
											}
											else
											{
												List list=new ArrayList();
												list.add(value);
												map.put(info,list);
											}
										}
									}
								}
								
								if(map!=null && !map.isEmpty())
								{
									JSONArray gridValues = new JSONArray();
									Iterator itr=map.keySet().iterator();
									int m=0;
									int colIdx = 0;
									while(itr.hasNext())
									{
										JSONObject rowJson = new JSONObject();
										String infos=(String)itr.next();
										rowJson.put("COLUMVal_"+(colIdx++),com.egurkha.util.StringUtils.replace(infos, "+", ""));
										List valueList=(ArrayList)map.get(infos);
										if(valueList!=null && valueList.size()>0)
										{
											for(int i=0;i<valueList.size();i++)
											{
												String val=(String)valueList.get(i);
												if(val.startsWith("-"))
													val="-";
												rowJson.put("COLUMVal_"+(colIdx++),val);
											}
										}
										m++;
										colIdx=0;
										gridValues.add(rowJson);
									}
									gridJson.put("gridValues",gridValues);
								}
							}
							gridJsons.add(gridJson);
							flowsObj.put("gridvalues",gridJson);
						}					
					}else
					{
						flowsObj.put("mappingName",mappingInfo.getTextDescription("monitor.dashboard."+sb.toString()));
						flowsObj.put("noMesMsg",mappingInfo.getTextDescription("monitor.common.No measures available!"));
					}
					
				}
				else
				{
					flowsObj.put("mappingName",mappingInfo.getTextDescription("monitor.dashboard."+sb.toString()));
					flowsObj.put("noMesMsg",mappingInfo.getTextDescription("monitor.common.The test has been disabled"));
				}
				folwsArr.add(flowsObj);
				j++;
			}		
		}
		rootJson.put("folwsArr",folwsArr);
		rootJson.put("gridJsons",gridJsons);		
	}

	out.println(rootJson.toString());
	String requestData = ErUtils.prepareQueryString(request.getParameterMap());		
	if(requestData!=null)
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&comptype="+request.getParameter("compType")+"&host="+request.getParameter("hostName")+"&tab="+tab+"&graphType=&toDashBoardLayer=true&"+requestData);
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	else
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&tab="+tab+"&toDashBoardLayer=true&ciscoSelectedType="+ciscoSelectedType);
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
}
catch(Exception e)
{
	e.printStackTrace();
}
%>

