<%
/*
	File			:	ecChangesAtAGlance.jsp
	Purpose			:	Display the changes in components
	Creation Date	:	07-01-2009
	Author			:	Krishnamurthi
	UI Design		:	Jaiwin
*/
%>

<%@ include file = "EcTracker.jsp"%>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "java.net.URLEncoder"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "egurkha.config.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	private TreeMap getTreeMap(ArrayList al_components)
	{
		TreeMap tmap = null;
		if (al_components != null && !al_components.isEmpty())
		{
			tmap = new TreeMap();
			for(int i=0;i<al_components.size();i++)
			{
				String s_component = (String)al_components.get(i);
				String component_type = s_component.substring(s_component.lastIndexOf(":")+1);
				String component_name;

				if (component_type.equals("Oracle_server"))
				{
					StringTokenizer strTokens = new StringTokenizer(s_component,":");
					component_name = strTokens.nextToken() + ":" + strTokens.nextToken();
					component_type = strTokens.nextToken() + ":" + strTokens.nextToken();
				}
				else
					component_name = s_component.substring(0,s_component.lastIndexOf(":"));

				if (tmap.containsKey(component_type))
				{
					ArrayList al_temp = (ArrayList)tmap.get(component_type);
					al_temp.add(component_name);
				}
				else
				{
					ArrayList al_temp = new ArrayList();
					al_temp.add(component_name);
					tmap.put(component_type,al_temp);
				}
			}
		}
		return tmap;
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",-1);
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgUserRole userRole = user.getUserRole();
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDateInfo egDateInfo = new EgDateInfo();
	EcProcessChangeData processChangeData = new EcProcessChangeData();
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	boolean hasAllComponentAccess = userRole.hasAllComponentAccess();

	String request_from = (String)request.getParameter("request_from");
	String request_start = (String)request.getParameter("request_start");

	String defaultHours = configTestsInfo.getServerDisplayValue("CONFIGURATION_CHANGE","ChangesAtAGlance");
	String hourSelection = request.getParameter("NHour");
	StringTokenizer strTokens = new StringTokenizer(defaultHours,",");
	if (hourSelection == null)
	{
		Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.DASHBOARD_SETTING);
		String hourSetting = (String)dashboardSetting.get(EgConfigConstants.NAME_CHANGE_DURATION);
		if (hourSetting == null)
		{
			hourSelection = strTokens.nextToken();
		}
		else
		{
			hourSelection = hourSetting;
		}
	}

	String ec_criteria = request.getParameter("ec_criteria");
	String ec_userOption = request.getParameter("ec_userOption");

	Vector vecTimelineText = new Vector();
	Vector vecTimelineValue = new Vector(); //in hours
	strTokens = new StringTokenizer(defaultHours,",");
	while (strTokens.hasMoreTokens())
	{
		String hour = strTokens.nextToken().trim();
		int h = Integer.parseInt(hour);

		if (h == 1)
		{
			vecTimelineValue.add("1");
			vecTimelineText.add("1 hour");
		}
		else
		{
			vecTimelineValue.add(""+h);
			vecTimelineText.add(h+" hours");
		}
	}

	//UI Date Process - Start
	Date tempDate = new Date(egDateInfo.egetUTCDate());
	Calendar tempCalendar = new GregorianCalendar();
	tempCalendar.setTime(tempDate);
	Date tempDate2 = tempCalendar.getTime();
	long tempTime = tempDate2.getTime();

	String edate = egDateInfo.egetDate(tempTime);

	int start_time = Integer.parseInt(hourSelection);
	long msecsPerHour = (long) 1000 * 60 * 60;
	String sdate = egDateInfo.egetDate(tempTime - (long)(start_time * msecsPerHour));

	sdate = sdate.substring(0,sdate.lastIndexOf(":")+1) + "00";
	edate = edate.substring(0,edate.lastIndexOf(":")+1) + "00";

	String startDate = sdate.substring(0,sdate.indexOf(' '));
	String endDate = edate.substring(0,edate.indexOf(' '));
	startDate = startDate.substring(startDate.indexOf('/')+1,startDate.lastIndexOf('/'))+"/"+startDate.substring(0,startDate.indexOf('/'))+"/"+startDate.substring(startDate.lastIndexOf('/')+1);
	endDate = endDate.substring(endDate.indexOf('/')+1,endDate.lastIndexOf('/'))+"/"+endDate.substring(0,endDate.indexOf('/'))+"/"+endDate.substring(endDate.lastIndexOf('/')+1);

	String SHours = sdate.substring(sdate.indexOf(' ')+1);
	String EHours = edate.substring(edate.indexOf(' ')+1);
	StringTokenizer startTimeToken = new StringTokenizer(SHours,":");
	StringTokenizer endTimeToken = new StringTokenizer(EHours,":");

	String startHour = startTimeToken.nextToken();
	String startMinute = startTimeToken.nextToken();
	String endHour = endTimeToken.nextToken();
	String endMinute = endTimeToken.nextToken();

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String tempStartDate = DateUtil.changeDateFormat(startDate,"MM/dd/yyyy",currentDateFormat);
	String tempEndDate = DateUtil.changeDateFormat(endDate,"MM/dd/yyyy",currentDateFormat);
	//UI Date Process - End

	int displayLength = 15;

	//Parameters - Start
	String option1[] = new String[]{"All Components"};
	String timeline[] = new String[]{"Any"};
	String prevtimeline[] = new String[]{"Any"};

	String ec_stdate[] = new String[]{tempStartDate};
	String ec_sthr[] =  new String[]{startHour};
	String ec_startmin[] =  new String[]{startMinute};
	String ec_enddate[] =  new String[]{tempEndDate};
	String ec_endhr[] =  new String[]{endHour};
	String ec_endmin[] =  new String[]{endMinute};

	String strChangeType = configTestsInfo.getServerDisplayValue("CONFIGURATION_CHANGE","ShowChanges");
	if (strChangeType == null || strChangeType.length() == 0)
	{
		strChangeType = "All";
	}
	if (strChangeType.equalsIgnoreCase("Recent"))
	{
		strChangeType = "Latest";
	}
	else
	{
		strChangeType = "All";
	}

	String changeType[] = new String[]{strChangeType};

	String strViewChange = configTestsInfo.getServerDisplayValue("CONFIGURATION_CHANGE","ArrangeChanges");
	if (strViewChange == null || strViewChange.length() == 0)
	{
		strViewChange = "byInformation";
	}
	if (strViewChange.equalsIgnoreCase("Date"))
	{
		strViewChange = "byDate";
	}
	else
	{
		strViewChange = "byInformation";
	}

	String viewChange[] = new String[]{"byInformation"};

	Map params = new HashMap();
	params.put("ec_option1",option1);
	params.put("ec_timeline",timeline);
	params.put("ec_prevtimeline",prevtimeline);
	params.put("ec_stdate_h",ec_stdate);
	params.put("ec_sthr_h",ec_sthr);
	params.put("ec_startmin_h",ec_startmin);
	params.put("ec_enddate_h",ec_enddate);
	params.put("ec_endhr_h",ec_endhr);
	params.put("ec_endmin_h",ec_endmin);
	params.put("ec_changetype",changeType);
	params.put("ec_viewchange",viewChange);
	params.put("user_language",new String[]{userLanguage});
	//Parameters - End

	ArrayList al_components = new ArrayList();
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	for(int i=0;i<aListAssociatedComponents.size();i++)
	{
		String s_component = (String)aListAssociatedComponents.get(i);
		String component_type = s_component.substring(0,s_component.indexOf(":"));
		boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
		if(!isConfigTestEnabled)
			continue;
		String component_name = s_component.substring(s_component.indexOf(":")+1);
		al_components.add(component_name+":"+component_type);
	}
	TreeMap tmap_components = getTreeMap(al_components);

	Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");

	EcChangeConfigurationBean ccbean = new EcChangeConfigurationBean(params,hasAllComponentAccess);
	ccbean.setTreeMap(tmap_components);
	ccbean.setHostAgentsMapping(hostAgentsMapping);
	TreeMap tmap_changeConfigDetails = ccbean.getChangeConfigurationData();
%>

<html>
<head>
<title></title>
<meta name="Author" content="Krishnamurthi">
<egui:skin ui="config"/>
</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="overflow:hidden" bgcolor="#FFFFFF">

	<table width="100%" align="center" border="0" cellpadding="0" cellspacing="0" id="innertable" style="table-layout:fixed">

		<tr>
			<td height="20" colspan="3">
				<table cellspacing="0" cellpadding="0" border="0" width="100%">
					<tr>
						<td class="tdbackcolortop pLeft4" width="70%"><a href="/final/servlet/com.eg.EcConfigurationServlet?cmd=ChangesAtAGlance&NHour=<%=URLEncoder.encode(hourSelection)%>&request_from=Dashboard&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" class="eg_headlink_white"><b><egui:intnl text="configmgmt.dashboard.Changes At-A-Glance"/></b></a></td>
						<td align="right" width="30%" class="tdbackcolortop"><select name="Hour" onChange="javascript:goToChangesAtAGlance()" style="width:85px">
<%
	for (int u=0;u<vecTimelineValue.size();u++)
	{
		String strTimelineText = (String)vecTimelineText.get(u);
		String strTimelineValue = (String)vecTimelineValue.get(u);

		String selected = "";
		if (strTimelineValue.equals(hourSelection))
			selected = "selected";

		String strValue = strTimelineText.substring(0,strTimelineText.indexOf(" "));
		String strText = strTimelineText.substring(strTimelineText.indexOf(" ")+1);
%>
						<option value="<%=strTimelineValue%>" <%=selected%>>
							<%=strValue%>&nbsp;<egui:intnl text='<%="configmgmt.common."+strText%>' />
						</option>
<%
	}
%>
						</select>
						</td>
					</tr>
				</table>
			</td>
		</tr>
<%
	if (tmap_changeConfigDetails == null || tmap_changeConfigDetails.isEmpty())
	{
%>
		<tr>
			<td align="center" colspan="3" height="154" valign="middle">
				<table border="0" cellspacing="0" cellpadding="0" class="body_text" height="100%">
					<tr>
						<td align="center" height="85" valign="bottom"><img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />'></td>
					</tr>
					<tr>
						<td align="center" valign="top" height="55"><egui:intnl text="configmgmt.dashboard.No configuration changes found"/></td>
					</tr>
				</table>
			</td>
		</tr>
<%
	}
	else
	{
		TreeMap tmapTemp = new TreeMap();
		int totalCount = 0;
		Iterator component_keys = tmap_changeConfigDetails.keySet().iterator();
		while (component_keys.hasNext())
		{
			String key_component = (String)component_keys.next();
			if (key_component.equalsIgnoreCase("Change By Date")) continue;

			TreeMap tmapChanges = processChangeData.getComponentSummary(key_component,tmap_changeConfigDetails,null,null);

			if (tmapChanges == null || tmapChanges.isEmpty()) continue;

			int count = 0;
			Iterator changeCountKeys = tmapChanges.keySet().iterator();
			while (changeCountKeys.hasNext())
			{
				Integer changeCount = (Integer)changeCountKeys.next();
				ArrayList aListTestnames = (ArrayList)tmapChanges.get(changeCount);
				count = count + (changeCount.intValue() * aListTestnames.size());
			}
			totalCount = totalCount + count;

			ArrayList aListTemp = (ArrayList)tmapTemp.get(new Integer(count));
			if (aListTemp == null)
			{
				aListTemp = new ArrayList();
				aListTemp.add(key_component);
				tmapTemp.put(new Integer(count),aListTemp);
			}
			else
			{
				aListTemp.add(key_component);
			}
		}
%>
		<tr>
			<td align="center" width="100%" height="18" colspan="3" id="tdbacklightcolor3" class="text_bold"><egui:intnl text="configmgmt.dashboard.Total Changes" />&nbsp;:&nbsp;<%=totalCount%></td>
		</tr>

		<tr>
			<td colspan="3" valign="top" height="136">
				<div id="div_scroll" style="width:100%;height:136px;border:0px solid #000000">
				<table width="100%" id="body_text" cellspacing="0" cellpadding="0" border="0" align="center" style="table-layout:fixed"><col width="31%"><col width="15%"><col width="54%">
					<tr>
						<td nowrap height="20" align="left" class="table_header_dash">&nbsp;<egui:intnl text="configmgmt.dashboard.Component Name" /></td>
						<td align="left" height="20" class="table_header_dash">&nbsp;<egui:intnl text="configmgmt.dashboard.Changes" /></td>
						<td nowrap align="center" height="20" class="table_header_dash" style="border-right-width:0px">&nbsp;<egui:intnl text="configmgmt.dashboard.Changes in" /></td>
					</tr>
<%
		Iterator changeCountKeys = tmapTemp.keySet().iterator();
		ArrayList aListChangeCount = new ArrayList();
		while (changeCountKeys.hasNext())
		{
			Integer changeCount = (Integer)changeCountKeys.next();
			aListChangeCount.add(changeCount);
		}
		Collections.reverse(aListChangeCount);

		int idx = 0;
		for (int i=0; i<aListChangeCount.size(); i++)
		{
			Integer changeCount = (Integer)aListChangeCount.get(i);

			ArrayList aListComponents = (ArrayList)tmapTemp.get(changeCount);
			Collections.sort(aListComponents);

			for (int j=0; j<aListComponents.size(); j++)
			{
				String component = (String)aListComponents.get(j);

				String temp1 = component.substring(0,component.lastIndexOf(":"));
				if (temp1.endsWith(":NULL"))
					temp1 = temp1.substring(0,temp1.indexOf(":"));
				String temp2 = component.substring(component.lastIndexOf(":")+1);
				temp2 = mappingInfo.getComponentTypeDescription(temp2);
				temp1 = temp1 + ":"+ temp2;

				TreeMap tmapChanges = processChangeData.getComponentSummary(component,tmap_changeConfigDetails,null,null);

				Iterator iterChangeCountKeys = tmapChanges.keySet().iterator();
				ArrayList aList = new ArrayList();
				while (iterChangeCountKeys.hasNext())
				{
					Integer changeCountTemp = (Integer)iterChangeCountKeys.next();
					aList.add(changeCountTemp);
				}
				Collections.reverse(aList);

				ArrayList aListTestnames = new ArrayList();
				for (int k=0; k<aList.size(); k++)
				{
					Integer changeCountTemp = (Integer)aList.get(k);
					ArrayList aListTestnamesTemp = (ArrayList)tmapChanges.get(changeCountTemp);
					Collections.sort(aListTestnamesTemp);
					aListTestnames.addAll(aListTestnamesTemp);
				}

				String strTestnames = "";
				for (int s=0; s<aListTestnames.size(); s++)
				{
					String strTestname = (String)aListTestnames.get(s);
					strTestname = mappingInfo.getTestDescription(strTestname);
					if (s==0)
						strTestnames = strTestname;
					else
						strTestnames = strTestnames + ", " + strTestname;
				}

				idx = idx + 1;
				boolean isMouseOver = false;
				if (strTestnames.length() >= 37) isMouseOver = true;
%>
					<tr>
						<td valign="top" colspan="3">
							<table cellspacing="0" cellpadding="2" align="center" border="0" id="body_text" width="100%" style="table-layout:fixed;"><col width="31%"><col width="15%"><col width="54%">
								<tr>
<%
				if (temp1.length() > displayLength)
				{
					boolean isEnglish = true;
					for (int x=0;x<temp1.length();x++)
					{
						Character.UnicodeBlock cu = Character.UnicodeBlock.of(temp1.charAt(x));
						if (!cu.equals(Character.UnicodeBlock.BASIC_LATIN))
						{
							isEnglish = false;
							break;
						}
					}

					if (isEnglish)
					{
%>
									<td nowrap class="cell_border" id="tdbacklightcolor2">&nbsp;<a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=CAAGForDashboard&ec_rtype=Change&request_start=CAAGForDashboard&ec_option1=Component Name&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr_h=<%=startHour%>&ec_endhr_h=<%=endHour%>&ec_stdate_h=<%=tempStartDate%>&ec_enddate_h=<%=tempEndDate%>&ec_option2=<%=EgURLEncoder.encode(component,"UTF-8")%>&ec_startmin_h=<%=startMinute%>&ec_endmin_h=<%=endMinute%>&ec_changetype=<%=strChangeType%>&ec_viewchange=<%=strViewChange%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" class="eg_monlink" title="<%=temp1%>"><egui:display name="<%=temp1%>" length='17' /></a></td>
<%
					}
					else
					{
%>
									<td nowrap class="cell_border" id="tdbacklightcolor2">&nbsp;<a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=CAAGForDashboard&ec_rtype=Change&request_start=CAAGForDashboard&ec_option1=Component Name&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr_h=<%=startHour%>&ec_endhr_h=<%=endHour%>&ec_stdate_h=<%=tempStartDate%>&ec_enddate_h=<%=tempEndDate%>&ec_option2=<%=EgURLEncoder.encode(component,"UTF-8")%>&ec_startmin_h=<%=startMinute%>&ec_endmin_h=<%=endMinute%>&ec_changetype=<%=strChangeType%>&ec_viewchange=<%=strViewChange%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" class="eg_monlink" title="<%=temp1%>"><egui:display name="<%=temp1%>" length='10' /></a></td>
<%
					}
				}
				else
				{
%>
									<td nowrap class="cell_border" id="tdbacklightcolor2">&nbsp;<a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=CAAGForDashboard&ec_rtype=Change&request_start=CAAGForDashboard&ec_option1=Component Name&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr_h=<%=startHour%>&ec_endhr_h=<%=endHour%>&ec_stdate_h=<%=tempStartDate%>&ec_enddate_h=<%=tempEndDate%>&ec_option2=<%=EgURLEncoder.encode(component,"UTF-8")%>&ec_startmin_h=<%=startMinute%>&ec_endmin_h=<%=endMinute%>&ec_changetype=<%=strChangeType%>&ec_viewchange=<%=strViewChange%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" class="eg_monlink"><%=temp1%></a></td>
<%
				}
%>
									<td align="center" class="cell_border" target=""><a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=CAAGForDashboard&ec_rtype=Change&request_start=CAAGForDashboard&ec_option1=Component Name&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr_h=<%=startHour%>&ec_endhr_h=<%=endHour%>&ec_stdate_h=<%=tempStartDate%>&ec_enddate_h=<%=tempEndDate%>&ec_option2=<%=EgURLEncoder.encode(component,"UTF-8")%>&ec_startmin_h=<%=startMinute%>&ec_endmin_h=<%=endMinute%>&ec_changetype=<%=strChangeType%>&ec_viewchange=<%=strViewChange%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" class="eg_monlink"><%=changeCount%></a></td>
<%
				if (isMouseOver)
				{
					String strTestsForDisplay = StringUtils.egSubString(strTestnames,37);
%>
									<td wrap align="left" style="padding-left:4px" id="tdbacklightcolor2" style="border-right-width:0px">
										<a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=CAAGForDashboard&ec_rtype=Change&request_start=CAAGForDashboard&ec_option1=Component Name&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr_h=<%=startHour%>&ec_endhr_h=<%=endHour%>&ec_stdate_h=<%=tempStartDate%>&ec_enddate_h=<%=tempEndDate%>&ec_option2=<%=EgURLEncoder.encode(component,"UTF-8")%>&ec_startmin_h=<%=startMinute%>&ec_endmin_h=<%=endMinute%>&ec_changetype=<%=strChangeType%>&ec_viewchange=<%=strViewChange%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" class="eg_monlink" onMouseOver="if(!arr['<%=idx%>'])show('<%=idx%>')" onMouseOut="if(!arr['<%=idx%>'])hide('<%=idx%>')"><%=strTestsForDisplay%></a><br>
										<div id="layer<%=idx%>" align="center" style="position:absolute;display:none;width:240px;visibility:hidden;overflow:hidden; border:1px solid #000000">
											<table cellspacing="1" cellpadding="1" id="tdbacklightcolor3" align="center" border="0" width="100%">
												<tr>
													<td class="text75" style="padding-left:4px"><%=strTestnames%></td>
												</tr>
											</table>
											<script language="javascript">arr[<%=idx%>]=false;</script>
										</div>
									</td>
<%
				}
				else
				{
%>
									<td wrap width="55%" align="left" style="padding-left:4px" id="tdbacklightcolor2" style="border-right-width:0px"><a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=CAAGForDashboard&ec_rtype=Change&request_start=CAAGForDashboard&ec_option1=Component Name&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr_h=<%=startHour%>&ec_endhr_h=<%=endHour%>&ec_stdate_h=<%=tempStartDate%>&ec_enddate_h=<%=tempEndDate%>&ec_option2=<%=EgURLEncoder.encode(component,"UTF-8")%>&ec_startmin_h=<%=startMinute%>&ec_endmin_h=<%=endMinute%>&ec_changetype=<%=strChangeType%>&ec_viewchange=<%=strViewChange%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" class="eg_monlink"><%=strTestnames%></a></td>
<%
				}
%>
								</tr>
							</table>
						</td>
					</tr>
<%
			}
		}
%>
				</table>
				</div>
			</td>
		</tr>
<%
	}
%>

</table>

</body>
</html>



