<%@ include file = "../../EcTrackerJson.jsp" %>
<%@ page import = "egurkha.config.EcScheduleTask" %>
<%@ page import = "egurkha.config.EcReportParam" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "net.sf.json.*" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%
	response.setContentType("application/json");
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootJson = new JSONObject();
	JSONArray schedulesArray = new JSONArray();

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	String user_id = user.getLoginID();
	EcScheduleTask[] task = EcScheduleTask.getScheduleListForUser(user_id);

	IniUI iniUI = IniUI.getInstance();

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	//date format
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
	{
		userDateFormat = currentDateFormat;
	}

	// If user date format is set, assign it to current date format.
	if (userDateFormat != null)
	{
		currentDateFormat = userDateFormat;
	}
	//end here

	String strCsrfToken = request.getParameter("com.eg.CSRF_NONCE");
	if (strCsrfToken == null)
	{
		strCsrfToken = "";
	}

	int page1=1;

	double total_num_records=0;
	double total_num_records_per_page=0;
	int total_num_page=1;

	if((task!=null) && (task.length>0))
	{
		total_num_records=task.length;
		total_num_records_per_page=15.00;

		if(task.length<=10)
		{
			total_num_page=1;
		}
		else
		{
			total_num_page=(int)Math.round(Math.ceil(total_num_records/total_num_records_per_page));
		}
	}
	if(task == null || task.length == 0)
	{
		rootJson.put("hasSchedules",new Boolean(false));
	}
	else
	{
		rootJson.put("hasSchedules",new Boolean(true));
		EgDateInfo egDate = new EgDateInfo();
		int start_index_page=1;
		int end_index_page=total_num_page>15?15:total_num_page;
		if(request.getParameter("pageno")!=null)
		{
			try
			{
				page1=Integer.parseInt(request.getParameter("pageno"));
				if(page1==1)
				{
					start_index_page=1;
					end_index_page=total_num_page>15?15:total_num_page;
				}
				if(page1>=6)
				{
					start_index_page=page1-5;
					end_index_page=page1+4;
											
					if(end_index_page>total_num_page)
					{
						start_index_page=start_index_page-(end_index_page-total_num_page);
						end_index_page=total_num_page;
					}
					if(page1==total_num_page)
					{
						start_index_page=page1-9;
						end_index_page=total_num_page;
					}
				}
			}
			catch(Exception e)
			{
				page1=1;
			}
		}
		
		int starting_record=0;
		int ending_record=15;

		//if(page1>1)
		//{
			//starting_record=((page1-1)*15);
			//ending_record=(15*page1);
			//if(ending_record>(task.length))
			//{
				//ending_record=task.length;
			//}
		//}
		//else
		//{
			if(ending_record>(task.length))
			{
				ending_record=task.length;
			}
		//}
		for(int i=starting_record;i<task.length;i++)
		{
			JSONObject jsonObj = new JSONObject();
			long sch_id = task[i].getScheduleId();
			String schName = task[i].getName();
			if (schName != null && schName.length()  > 3)
			{
				schName = schName.substring(0,schName.length() - 3);
			}
			jsonObj.put("scheduleId",sch_id);
			jsonObj.put("scheduleName",schName);
			String scheduleUrl = "/final/servlet/com.eg.EcSchedulerCNew?cmd=Edit&id="+sch_id+"&request_from=ViewSchedulePage&currentDateFormat="+currentDateFormat+"&com.eg.CSRF_NONCE="+strCsrfToken;
			jsonObj.put("scheduleUrl",scheduleUrl);

			String reportName = new EcReportParam(task[i].getDetails()).getReportName();
			String mappedReportName = mappingInfo.getTextDescription("configmgmt.schedule."+reportName);
			jsonObj.put("reportType",mappedReportName);

			String creationDate = egDate.egetDateUS(task[i].getCreationTime().getTime());
			String dateOnly = creationDate.substring(0,creationDate.indexOf(' '));
			String timeOnly = creationDate.substring(creationDate.indexOf(' ')+1);
			dateOnly = DateUtil.changeDateFormat(dateOnly,"MM/dd/yyyy",currentDateFormat);

			/* Added by Prakash.K starts */
			EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateOnly+" "+timeOnly,user);
			String dateAndTime = timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */

			String mailFreq = mappingInfo.getTextDescription("configmgmt.schedule."+task[i].getMailFrequency());
			String printFreq = mappingInfo.getTextDescription("configmgmt.schedule."+task[i].getPrintFrequency());

			jsonObj.put("mail",mailFreq);
			jsonObj.put("print",printFreq);
			jsonObj.put("creationTime",dateAndTime);

			schedulesArray.add(jsonObj);
		}
		rootJson.put("recordsPerPage",total_num_records_per_page);
	}

	rootJson.put("schedulesArray",schedulesArray);
	out.println(rootJson);
%>



