<%
/****************************************************************************
*	Name			:	updateManConfig.jsp
*	Purpose			:	Update manual changes of config files to memory
						
*	Version			:	6.0
*	Creation Date	:	5/4/11
*	Author			:	Sri Devi G
******************************************************************************/
%>

<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.*"%>
<%@ page import ="com.egurkha.util.*"%>
<%@ page import="com.eg.EgConMonHelper"%>
<%@ page import ="java.io.*"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	
	String param = request.getParameter("param");
	String sessionInUse = request.getParameter("sessionInUse");
	String pwd = request.getParameter("pwd");
	String authenticated = (String)session.getAttribute("authenticated");

	if (authenticated == null)
	{
		// Direct access from the browser address bar or from inside the toolkit via the tool
		if (pwd == null)
		{
			if (sessionInUse == null)
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=UpdateManualConfig");
			}
			else
			{
%>
				<script>
					window.top.location.href="/final/toolkitlogin";
				</script>
<%
			}
		}
		else
		{
			// Direct access from the browser address bar
			if (!pwd.equals(EgConMonHelper.executePwd))
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=UpdateManualConfig");
			}
			else
			{
				session.setAttribute("reqFromForTk","UpdateManualConfig");
				String redirectURL = request.getContextPath()+"/toolkit";
				response.sendRedirect(redirectURL);
			}
		}
	}
	else
	{ 
		// Direct access from the browser address bar and session in use
		if (sessionInUse == null)
		{
			response.sendRedirect(request.getContextPath()+"/toolkit");
		}
	}

	session.setAttribute("reqFromForTk","UpdateManualConfig");
	String comeFrom = request.getParameter("comeFrom");
	if (!StringUtils.isNull(comeFrom) && comeFrom.equals("UpdateManualConfig"))
	{
		session.setAttribute("treeViewSrc","UpdateManualConfig");
	}
%>

<html>
<head>
<link rel="stylesheet" href="eg_styles\adminstyle_blue.css"/>
<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>
<script language="JavaScript">
function updateManConfig()
{
	var thisForm=document.ManConfig;
	thisForm.action="/final/admin/updateManConfig.jsp?sessionInUse=true"; 
	thisForm.submit();
}
function onfoc()
{
	if (document.getElementById('txt') != null ) 
	{
		document.getElementById('txt').style.display = 'none';
	}
}
</script>

</head>

<body style="overflow:auto" id="space6" >
<form name="ManConfig" method="post" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" >
	<tr>
		<td id="eg_blankspace" height="10" nowrap>&nbsp;</td>
	</tr>
	<tr>
		<td width="100%" height="24" id="eg_title" align="center"> &nbsp; UPDATE CONFIGURATION CHANGES</td>
	</tr>
	<tr>
		<td height="20" align="center" colspan="2">
			<table align="center" width="85%" cellspacing="0" cellpadding="4" border="0">
				<tr>
					<td height="24" nowrap align="right" width="25%" class="eg_cellbglits"><img src="/final/admin/eg_images/info2.gif"> </td>
					<td height="24" nowrap align="left" class="eg_cellbglits">
					This page enables the administrator to update the configuration changes made to an INI file.</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td id="eg_blankspace" height="10" nowrap>&nbsp;</td>
				</tr>
				<tr>
					<td align="center" valign="top">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
							<tr>
								<td><input type="hidden" value="hide" name="param"></td>
								<td colspan="6" align='center' id="eg_whitebg" nowrap>
									<input type="button" name="update" id="eg_back" value="Update" onClick="javascript:updateManConfig()">
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td id="eg_blankspace" height="10" nowrap>&nbsp;</td>
	</tr>

<%
	if(param != null)
	{
		if (IniFile.lastModifiedTimeSize != null)
		{
			IniFile.lastModifiedTimeSize.clear();
		}
		//if (IniFile.lastSize != null)
		//{
		//	IniFile.lastSize.clear();
		//}
		if (IniFile.lastModifiedCheckTime != null)
		{
			IniFile.lastModifiedCheckTime.clear();
		}
		//if (IniFile.lastSizeCheckTime != null)
		//{
		//	IniFile.lastSizeCheckTime.clear();
		//}
		checkLastModified();
%>
	<tr>
		<td id="eg_blankspace" height="10" nowrap>&nbsp;</td>
	</tr>
	<tr>
		<td id="txt" align="center">Manual configuration changes have been updated.</td>
	</tr>
	<tr>
		<td id="eg_blankspace" height="10" nowrap>&nbsp;</td>
	</tr>
<%
	}
%>
<table>
</form>
</body>
</html>

<%!
	private void checkLastModified()
	{
		synchronized (IniFile.syncS)
		{
			File f1 = new File(EgInstallInfo.getInstallDir()+"/manager/config/");
			File ff[] = f1.listFiles();
			if (ff != null && ff.length > 0)
			{
				for (int r=0; r<ff.length; r++)
				{
					if (ff[r].isDirectory())
					{
						continue;
					}
					String me = ff[r].getAbsolutePath();
					
					if(me.indexOf("manager")>=0 && me.indexOf("config")>=0 && me.endsWith(".ini") && me.indexOf("tmp") == -1)
					{
						me = com.egurkha.util.StringUtils.replace(me,"\\","/");

						long[] vv = new long[2];
						vv[0] = ff[r].lastModified();
						vv[1] = ff[r].length();
						IniFile.lastModifiedTimeSize.put(me,vv);
						//IniFile.lastModifiedTime.put(me,new Long(ff[r].lastModified()));
						//IniFile.lastSize.put(me,new Long(ff[r].length()));
						long curTime = System.currentTimeMillis();
						IniFile.lastModifiedCheckTime.put(me,new Long(curTime));
						//IniFile.lastSizeCheckTime.put(me,new Long(curTime));
					}
				}
			}
		}
	}
%>



