<%
/*******************************************************************************
*       Name            :       aggDeleteServer.jsp
*       Purpose         :       Deleting user defined aggregate component type
*       Version         :       5.2
*       CreationDate    :       09/02/2011
*       Author          :       James Thomas P
*******************************************************************************/
%>
<%@ include file = "EgTrackerA.jsp"%>
<%@ page errorPage = "EgProbs.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "java.util.*"%>
<%@ page import = "egurkha.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%> 
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "com.eg.UpdateAndTransmitICInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<jsp:useBean id="serviceBean" scope="page" class="egurkha.ServiceBean"/>
<%
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	auditLogThread.setValue("Activity","Component");
	/* code for auditlog ends */

	String server = request.getParameter("server");
	server = server.trim();
	ServerBean serverBean = new ServerBean(true);
	if(!serverBean.isServerUserDefined(server))
	{
		Vector errors = new Vector();
		errors.addElement(_mapping.getTextDescription("admin.error.Delete Component"));
		errors.addElement("aggDisplayServers.jsp");
		errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
		errors.addElement(_mapping.getTextDescription("admin.error.You are trying to delete a Component which is not User-Defined")+".");
		session.putValue("vec_Errors", errors);

		/* code for auditlog starts */
		if(server.endsWith("_ex"))
			auditLogThread.setValue("Description","Only user defined components can be deleted" +". "+ server+" server has not been deleted");
		else
			auditLogThread.setValue("Description","Only user defined components can be deleted" +". "+ "$ctype$:"+server +" " +"server has not been deleted");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
%>
		<jsp:forward page="EgErrors.jsp" />
<%
	}
	else if(serverBean.doesCompExistForServer(server))
	{
		Vector errors = new Vector();
		errors.addElement(_mapping.getTextDescription("admin.error.Delete Component"));
		errors.addElement("aggDisplayServers.jsp");
		errors.addElement(_mapping.getTextDescription("admin.error.Possible Reasons"));
		errors.addElement(_mapping.getTextDescription("admin.error.You are trying to delete a Component Type one or more of whose components are managed")+".");
		errors.addElement(_mapping.getTextDescription("admin.error.Please unmanage all components under this component type and try again")+".");
		session.putValue("vec_Errors", errors);

		/* code for auditlog starts */
		if(server.endsWith("_ex"))
			auditLogThread.setValue("Description","One or more components have been managed"+". " +server+" server has not been deleted");
		else
			auditLogThread.setValue("Description","One or more components have been managed"+". " + "$ctype$:"+server+" server has not been deleted");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
%>
		<jsp:forward page="EgErrors.jsp" />
<%
	}
	else
	{
		serviceBean.stopDiscovery();
		serverBean.deleteServer(server);
		UpdateAndTransmitICInfo updateICInfo = new UpdateAndTransmitICInfo();
		updateICInfo.removeServer(server);

		EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
		//aggregateInfo.deleteAggregateTypes(server); this aggDeleteServer.jsp is not used. so i simply commented.
		aggregateInfo.deleteValue("AGGREGATE_TYPES",server);
		aggregateInfo.deleteValue("COMPONENT_TYPE_MAPPING",server);
		aggregateInfo.deleteValue("COMP_DISPLAY_NICK",server);
		aggregateInfo.deleteValue("AGGREGATE_GENERIC_TYPES",server);

		aggregateInfo.saveFile();

		/* code for auditlog starts */
		if(server.endsWith("_ex"))
			auditLogThread.setValue("Description",server+" component type has been deleted");
		else
			auditLogThread.setValue("Description","$ctype$:"+server+" component type has been deleted");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */

		//IniFile agglang = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_aggregate_lang_en_US.ini",true);
		IniFile agglang = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_aggregate_lang_en_US.ini");
		agglang.deleteValue("TYPE_NAME_MAPPING",server);
		agglang.deleteValue("AGG_TEXT_NAME_MAPPING","admin.aggregate."+server);
		agglang.saveFile();
		EgConfigFilesSync.releaseInstance(agglang);

		//IniFile egInfra = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_infrastructure.ini",true);
		IniFile egInfra =  EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_infrastructure.ini");
		egInfra.deleteValue("AGGREGATES",server);
		egInfra.saveFile();
		EgConfigFilesSync.releaseInstance(egInfra);
		ArrayList siteServers = new EgDiscInfo("manager").getSiteServers();
		if(siteServers != null && siteServers.size()>0)
		{		
			if(siteServers.contains(server))
			{
				//IniFile discoverIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini",true);
				IniFile discoverIni =  EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini");
				discoverIni.deleteValue("Site_servers",server);
				discoverIni.saveFile();
				EgConfigFilesSync.releaseInstance(discoverIni);
			}
		}
%>
		<jsp:forward page="aggDisplayServers.jsp" />
<%
	}
%>
