<%
/***********************************************************************************************************
*	Name			:	renamep.jsp
*	Purpose			:	Process page for rename.jsp
*	Version			:	5.5
*	CreationDate	:	17-Feb-2012
*	Author			:	James Thomas P
***********************************************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page errorPage="../../EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgGroupInfoAdmin"%>
<%@ page import = "com.eg.EgStateZone"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.admin.Rename"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	response.setContentType("application/json;charset=UTF-8");
	JSONObject rootJson = new JSONObject();

	String rename = request.getParameter("rename");
	String old_name = EgURLDecoder.decode(request.getParameter("old_name"),"UTF-8");
	String new_name = EgURLDecoder.decode(request.getParameter("new_name"),"UTF-8");

	String message = null;
	boolean renameStatus = true;
	
	String monitorLastSession=(String)session.getAttribute("monitorLastSession");
	String newUrlLink="";
	String oldZoneName="";
	String urlLink="";

	if(monitorLastSession!=null && monitorLastSession.trim().length()>0)
	{
		if(monitorLastSession.indexOf('?') == -1)
		{
			newUrlLink=monitorLastSession;
		}
		else
		{
			newUrlLink=monitorLastSession.substring(0,monitorLastSession.indexOf('?'));
			urlLink = monitorLastSession.substring(monitorLastSession.indexOf('?')+1);
		}
		
		if(urlLink!=null && urlLink.trim().length()>0)
		{
			StringTokenizer multiTokenizer = new StringTokenizer(urlLink,"&");
			while(multiTokenizer.hasMoreTokens())
			{
				String param = multiTokenizer.nextToken();
				int ind = param.indexOf("=");
				if (ind < 0)
					continue;
				String reqparam =param.substring(0,ind);
				String value = param.substring(ind+1);
				
				if(reqparam != null && reqparam.equals("zoneName"))
				{
					String zoneValue = value;
					if(zoneValue != null && zoneValue.trim().length()>0)
					{
						oldZoneName=com.eg.EgURLDecoder.decode(zoneValue, "UTF-8");
					}
				}
			}
		}
	}
	if(StringUtils.isNull(old_name) || StringUtils.isNull(new_name) || StringUtils.isNull(rename))
	{
		renameStatus = false;
		if(StringUtils.isNull(rename))
		{
			message = _mapping.getTextDescription("admin.error.Operation is not defined")+".";
		}
		else
		{
			if(StringUtils.isNull(new_name))
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming with new name as empty or null")+".";
			}
			else
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming as current name is empty or null")+".";
			}
		}
	}
	else
	{
		rename = rename.trim();
		old_name = old_name.trim();
		new_name = new_name.trim();

		if(IniUI.isEgReservedKeyword(new_name))
		{
			renameStatus = false;
			message = "'"+new_name.toUpperCase() +"' "+_mapping.getTextDescription("admin.error.is an eG defined keyword")+". "+_mapping.getTextDescription("admin.error.Choose another name")+".";
		}
		else
		{
			boolean oldNameExist = false;
			boolean isSite = false;
			String auditlogLabel = null;
			String nameConflictLabel = null;
			String update_msmt_table = "true";
			Vector nameConflict = new Vector();//dont add anything into this vector

			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Activity","Rename Zone");

			String targetPageURL = null;
			
			auditLogThread.setValue("Module","Zones");
			oldNameExist = Rename.doesOldnameExist(new EgGroupInfoAdmin().getZoneNames(),old_name,new_name,nameConflict);
			nameConflictLabel="admin.error.You are trying to rename a zone with a name which is already assigned to another zone";
			auditlogLabel=old_name + " zone can not be renamed to "+new_name +" as this name is already assigned to some other zone";
			
			
			if(!nameConflict.isEmpty())
			{
				renameStatus = false;
				auditLogThread.setValue("Description",auditlogLabel);
				auditLogThread.sendItToDB();
				message = _mapping.getTextDescription(nameConflictLabel)+".";
			}
			else
			{
				if(oldNameExist)
				{
					boolean success = false;
									
					Rename renameObj = new Rename(u_rs,"Zone",old_name,new_name,update_msmt_table,isSite);
					success = renameObj.executeDefaultQueries();
					if(!success)
					{
						renameStatus = false;
						auditLogThread.setPreviousValue("Zone name",old_name);
						auditLogThread.setCurrentValue("Zone name",new_name);
						auditLogThread.setValue("Description","Database tables have not been updated with new zone name");
						auditLogThread.sendItToDB();
						message = _mapping.getTextDescription("admin.error.Problem while updating database tables") + ".";
					}
					if(renameStatus)
					{
						IniFile groupsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
						IniFile groupSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_group.ini");
						Vector vars = groupsIni.getVariables("ZONE_ASSOCIATION",true);
						Vector vals = groupsIni.getAllValues("ZONE_ASSOCIATION");
						if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
						{
							for(int i=0;i<vars.size();i++)
							{
								String old_var = vars.get(i).toString();
								if(old_var.equals(old_name))
								{
									groupSync.deleteValue("ZONE_ASSOCIATION",old_name);
									groupSync.setValue("ZONE_ASSOCIATION",new_name,(String)vals.get(i));
									break;
								}
							}
						}
						vars = groupsIni.getVariables("ZONE_LOCATION",true);
						vals = groupsIni.getAllValues("ZONE_LOCATION");
						if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
						{
							for(int i=0;i<vars.size();i++)
							{
								String old_var = vars.get(i).toString();
								if(old_var.equals(old_name))
								{
									String old_val = vals.get(i).toString();
									groupSync.deleteValue("ZONE_LOCATION",old_name);
									groupSync.setValue("ZONE_LOCATION",new_name,old_val);
									break;
								}
							}
						}
						groupSync.deleteValue("LIST_OF_ZONES",old_name);
						groupSync.setValue("LIST_OF_ZONES",new_name,new_name);
						vars = groupsIni.getVariables("ZONE_DETAILS",true);
						vals = groupsIni.getAllValues("ZONE_DETAILS");
						if(vars != null && vars.size()>0 && vals != null && vars.size()>0)
						{
							for(int i=0;i<vals.size();i++)
							{
								String var = (String)vars.get(i);
								String val = (String)vals.get(i);
								if(val.equals(old_name))
								{
									groupSync.deleteValue("ZONE_DETAILS",var);
									var = var.substring(0,var.lastIndexOf("#")+1)+new_name;
									groupSync.setValue("ZONE_DETAILS",var,new_name);
								}
								else if(var.startsWith("Zone:"+old_name+":NULL#"))
								{
									groupSync.deleteValue("ZONE_DETAILS",var);
									String associated_zone = var.substring(var.lastIndexOf("#")+1);
									var = "Zone:"+new_name+":NULL#"+associated_zone;
									groupSync.setValue("ZONE_DETAILS",var,val);
								}
							}
						}
						vars = null;
						vals = null;
						// Rename zone_display_image
						String imageValue = groupSync.getValue("ZONE_DISPLAY_IMAGE",old_name);
						groupSync.deleteValue("ZONE_DISPLAY_IMAGE",old_name);
						groupSync.setValue("ZONE_DISPLAY_IMAGE",new_name,imageValue);
						groupSync.saveFile();
						registry.updateAllUserMaps();
						EgStateZone.updateZoneGroupStatus();
						EgConfigFilesSync.releaseInstance(groupSync);

						IniFile mgrMiscSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_mgrmisc.ini");
						Vector zonevars = mgrMiscSync.getVariables("Auto_Created_Zone_User_Map",true);
						Vector zonevals = mgrMiscSync.getAllValues("Auto_Created_Zone_User_Map");
						if (zonevars != null && zonevars.size() > 0 && zonevals != null && zonevals.size() > 0)
						{
							int index = zonevals.indexOf(old_name);
							if (index != -1)
							{
								String userName = (String)zonevars.get(index);
								if (userName != null && userName.trim().length() > 0)
								{
									mgrMiscSync.setValue("Auto_Created_Zone_User_Map",userName,new_name);
								}
							}
						}
						mgrMiscSync.saveFile();
						EgConfigFilesSync.releaseInstance(mgrMiscSync);

						if(update_msmt_table != null && update_msmt_table.equals("true"))
						{
							success = renameObj.executeOtherQueries();
							if(!success)
							{
								renameStatus = false;
								auditLogThread.setPreviousValue("Zone name",old_name);
								auditLogThread.setCurrentValue("Zone name",new_name);
								auditLogThread.setValue("Description","Report and measurement tables have not been updated with new zone name");
								auditLogThread.sendItToDB();
								message = _mapping.getTextDescription("admin.error.Problem while updating report and measurement tables")+".";
							}
						}
						if(renameStatus)
						{
							auditLogThread.setPreviousValue("Zone name",old_name);
							auditLogThread.setCurrentValue("Zone name",new_name);
							auditLogThread.setValue("Description","Zone has been renamed");
							auditLogThread.sendItToDB();
							String label = "admin.common."+rename.toLowerCase()+" has been renamed successfully to";
							message = old_name + " " + _mapping.getTextDescription(label) + " " + new_name + ".";
						}
					}
				
					
				}
				else
				{
					renameStatus = false;
					String errorLabel = rename + " name";
					auditLogThread.setPreviousValue(errorLabel,old_name);
					auditLogThread.setCurrentValue(errorLabel,new_name);
					auditLogThread.setValue("Description",rename+" was not renamed as it had already been deleted");
					auditLogThread.sendItToDB();
					String label = "admin.common."+rename.toLowerCase()+" was not renamed to";
					message = old_name + " " +_mapping.getTextDescription(label) + " " + new_name +".";
				}
			}
			
			if(monitorLastSession != null && newUrlLink !=null && newUrlLink.indexOf("zoneDash.jsp")>-1)
			{
				if(old_name!=null && oldZoneName!=null && old_name.equals(oldZoneName))
				{
					session.removeAttribute("monitorLastSession");
				}
			}
		}
	}
	rootJson.put("message",message);
	rootJson.put("renamed",renameStatus);
	rootJson.put("rename",_mapping.getTextDescription("admin.common.Rename"));
	rootJson.put("success","true");
	out.println(rootJson.toString());
%>
