<%
/***********************************************************************************************************
*	Name			:	renamep.jsp
*	Purpose			:	Process page for rename.jsp
*	Version			:	5.5
*	CreationDate	:	17-Feb-2012
*	Author			:	James Thomas P
***********************************************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page errorPage="../../EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import = "com.eg.EgStateZone"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.admin.Rename"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	response.setContentType("application/json;charset=UTF-8");
	JSONObject rootJson = new JSONObject();

	String rename = request.getParameter("rename");
	String old_name = EgURLDecoder.decode(request.getParameter("old_name"),"UTF-8");
	String new_name = EgURLDecoder.decode(request.getParameter("new_name"),"UTF-8");

	String message = null;
	boolean renameStatus = true;
	
	String monitorLastSession=(String)session.getAttribute("monitorLastSession");	
	String newUrlLink="";
	String oldServiceName="";
	String urlLink="";

	if(monitorLastSession!=null && monitorLastSession.trim().length()>0)
	{
		if(monitorLastSession.indexOf('?') == -1)
		{
			newUrlLink=monitorLastSession;
		}
		else
		{
			newUrlLink=monitorLastSession.substring(0,monitorLastSession.indexOf('?'));
			urlLink = monitorLastSession.substring(monitorLastSession.indexOf('?')+1);
		}
		
		if(urlLink!=null && urlLink.trim().length()>0)
		{
			StringTokenizer multiTokenizer = new StringTokenizer(urlLink,"&");
			while(multiTokenizer.hasMoreTokens())
			{
				String param = multiTokenizer.nextToken();
				int ind = param.indexOf("=");
				if (ind < 0)
					continue;
				String reqparam =param.substring(0,ind);
				String paramValue = param.substring(ind+1);
				if(reqparam != null && reqparam.equals("serviceName"))
				{
					String serviceValue = paramValue;
					if(serviceValue != null && serviceValue.trim().length()>0)
					{
						oldServiceName=com.eg.EgURLDecoder.decode(serviceValue, "UTF-8");
					}
				}
			}
		}
	}

	
	
	if(StringUtils.isNull(old_name) || StringUtils.isNull(new_name) || StringUtils.isNull(rename))
	{
		renameStatus = false;
		if(StringUtils.isNull(rename))
		{
			message = _mapping.getTextDescription("admin.error.Operation is not defined")+".";
		}
		else
		{
			if(StringUtils.isNull(new_name))
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming with new name as empty or null")+".";
			}
			else
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming as current name is empty or null")+".";
			}
		}
	}
	else
	{
		rename = rename.trim();
		old_name = old_name.trim();
		new_name = new_name.trim();

		if(IniUI.isEgReservedKeyword(new_name))
		{
			renameStatus = false;
			message = "'"+new_name.toUpperCase() +"' "+_mapping.getTextDescription("admin.error.is an eG defined keyword")+". "+_mapping.getTextDescription("admin.error.Choose another name")+".";
		}
		else
		{
			boolean oldNameExist = false;
			boolean isSite = false;
			String auditlogLabel = null;
			String nameConflictLabel = null;
			String update_msmt_table = "true";
			Vector nameConflict = new Vector();//dont add anything into this vector

			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Activity","Rename Service");

			String targetPageURL = null;
			auditLogThread.setValue("Module","Services");
			EgTopoInfo egTopoInfo = new EgTopoInfo("manager");
			ArrayList serviceList = egTopoInfo.getAllServices();
			if(serviceList != null && serviceList.size()>0)
			{
				oldNameExist = Rename.doesOldnameExist((String[])serviceList.toArray(new String[serviceList.size()]),old_name,new_name,nameConflict);
			}
			if(oldNameExist)
			{
				isSite = !egTopoInfo.isSiteService(old_name);
			}
			egTopoInfo = null;
			serviceList=null;
			nameConflictLabel="admin.error.You are trying to rename a service with a name which is already assigned to another service";
			auditlogLabel=old_name + " service can not be renamed to "+new_name +" as this name is already assigned to some other service";
		
			
			if(!nameConflict.isEmpty())
			{
				renameStatus = false;
				auditLogThread.setValue("Description",auditlogLabel);
				auditLogThread.sendItToDB();
				message = _mapping.getTextDescription(nameConflictLabel)+".";
			}
			else
			{
				if(oldNameExist)
				{
					boolean success = false;
					
					Rename renameObj = new Rename(u_rs,"Service",old_name,new_name,update_msmt_table,isSite);
					success = renameObj.executeDefaultQueries();
					if(!success)
					{
						renameStatus = false;
						auditLogThread.setPreviousValue("Service name",old_name);
						auditLogThread.setCurrentValue("Service name",new_name);
						auditLogThread.setValue("Description","Database tables have not been updated with new service name");
						auditLogThread.sendItToDB();
						message = _mapping.getTextDescription("admin.error.Problem while updating database tables")+ ".";
					}
					if(renameStatus)
					{
						IniFile topologyIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini");
						IniFile topologySync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_topology.ini");
						String old_value = topologyIni.getValue("SERVICE",old_name);
						String aggregateSiteName = topologyIni.getValue("AGG_SITE_MAP",old_name);
						if(aggregateSiteName != null && aggregateSiteName.length()>0)
						{
							topologySync.setValue("AGG_SITE_MAP",new_name,old_value);
							topologySync.deleteValue("AGG_SITE_MAP",old_name);
						}
						topologySync.setValue("SERVICE",new_name,old_value);
						topologySync.deleteValue("SERVICE",old_name);
						Vector vars = topologyIni.getVariables(old_name+"_INDEPENDENT",true);
						Vector vals = topologyIni.getAllValues(old_name+"_INDEPENDENT");
						topologySync.deleteSubject(old_name+"_INDEPENDENT");
						if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
						{
							for(int i=0;i<vars.size();i++)
							{
								topologySync.setValue(new_name+"_INDEPENDENT",(String)vars.get(i),(String)vals.get(i));
							}
						}
						vars = topologyIni.getVariables("LOGICAL_TOPOLOGY",true);
						vals = topologyIni.getAllValues("LOGICAL_TOPOLOGY");
						if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
						{
							for(int i=0;i<vars.size();i++)
							{
								String var = (String)vars.get(i);
								if(var.equals("Web_site:"+old_name))
								{
									topologySync.deleteValue("LOGICAL_TOPOLOGY",var);
									topologySync.setValue("LOGICAL_TOPOLOGY","Web_site:"+new_name,(String)vals.get(i));
								}
							}
						}
						String var = "Web_site:"+old_name;
						String old_var = var;
						String val = topologyIni.getValue("WEB_SITE_MAPPING",var);
						var = "Web_site:"+new_name;
						topologySync.setValue("WEB_SITE_MAPPING",var,val);
						topologySync.deleteValue("WEB_SITE_MAPPING",old_var);

						var = "Web_site:"+old_name;
						old_var = var;
						val = topologyIni.getValue("WEB_SITE_SEGMENTS",var);
						var = "Web_site:"+new_name;
						topologySync.setValue("WEB_SITE_SEGMENTS",var,val);
						topologySync.deleteValue("WEB_SITE_SEGMENTS",old_var);

						IniFile groupsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
						IniFile groupSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_group.ini");
						vars = groupsIni.getVariables("ZONE_DETAILS",true);
						vals = groupsIni.getAllValues("ZONE_DETAILS");
						if(vars != null && vars.size()>0 && vals != null && vars.size()>0)
						{
							for(int i=0;i<vars.size();i++)
							{
								if(vars.get(i).toString().startsWith("Service:"+old_name+":NULL#"))
								{
									var = vars.get(i).toString();
									val = vals.get(i).toString();
									groupSync.deleteValue("ZONE_DETAILS",var);
									String associated_zone = var.substring(var.lastIndexOf("#")+1);
									var = "Service:"+new_name+":NULL#"+associated_zone;
									groupSync.setValue("ZONE_DETAILS",var,val);
								}
							}
						}
						vars = groupsIni.getVariables("SERVICEGROUPS_DETAILS",true);
						vals = groupsIni.getAllValues("SERVICEGROUPS_DETAILS");
						if(vars != null && vars.size()>0 && vals != null && vars.size()>0)
						{
							for(int i=0;i<vars.size();i++)
							{
								var = (String) vars.get(i);
								val = (String) vals.get(i);
								if(!StringUtils.isNull(var) && !StringUtils.isNull(val))
								{
									val = ","+val+",";
									int idx = val.indexOf((","+old_name+","));
									if(idx>-1)
									{
										val = val.substring(1,idx+1)+new_name+val.substring(idx+old_name.length()+1);
										val = val.substring(0,val.length()-1);
										groupSync.setValue("SERVICEGROUPS_DETAILS",var,val);
									}
								}
							}
						}
						vars = null;
						vals = null;
						// Rename service_display_image
						String imageValue = topologySync.getValue("SERVICE_DISPLAY_IMAGE",old_name);
						String domainValue = topologySync.getValue("SERVICE_DOMAIN",old_name);
						topologySync.deleteValue("SERVICE_DISPLAY_IMAGE",old_name);
						topologySync.deleteValue("SERVICE_DOMAIN",old_name);

						topologySync.setValue("SERVICE_DISPLAY_IMAGE",new_name,imageValue);
						topologySync.setValue("SERVICE_DOMAIN",new_name,domainValue);
						String aliasName=topologySync.getValue("SITE_ALIAS","Web_site:"+old_name);
						if(aliasName!=null && !aliasName.equals(""))
						{
							topologySync.deleteValue("SITE_ALIAS","Web_site:"+old_name);
							topologySync.setValue("SITE_ALIAS","Web_site:"+new_name,aliasName);	
						}
						if(isSite)//rename sitename for transaction pages include start
						{
							Vector tranSite = topologySync.getVariables("TRANSACTIONS",true);
							if( tranSite != null && tranSite.size() > 0 )
							{
								for( int i =0; i < tranSite.size(); i++)
								{
									String tranString = (String) tranSite.get(i);
									if( tranString != null && tranString.startsWith(old_name))
									{
										String pageInclude = topologySync.getValue("TRANSACTIONS",tranString);
										String newTranString = new_name +":"+tranString.substring(tranString.indexOf(":")+1);
										topologySync.deleteValue("TRANSACTIONS",tranString);
										topologySync.setValue("TRANSACTIONS",newTranString,pageInclude);
									}
								}
							}
						}//end
						topologySync.saveFile();
						groupSync.saveFile();
						registry.updateAllUserMaps();
						EgStateZone.updateZoneGroupStatus();
						EgConfigFilesSync.releaseInstance(topologySync);
						EgConfigFilesSync.releaseInstance(groupSync);

						IniFile jsTopology = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "js_topology.ini");
						String[] allSubjects = jsTopology.getSubjects();
						if(allSubjects != null)
						{
							for(int i = 0; i < allSubjects.length; i++)
							{
								String sub = allSubjects[i];
								if(sub.indexOf("~|#|~") == -1)
									continue;
								if(sub.startsWith(old_name+"~|#|~"))
								{
									Vector variables = jsTopology.getVariables(sub,true);
									Vector values = jsTopology.getAllValues(sub);
									jsTopology.deleteSubject(sub);

									sub = sub.substring(sub.indexOf("~|#|~"));
									sub = new_name + sub;

									if(variables != null && variables.size() > 0 && values != null && values.size() > 0)
									{
										for(int j = 0; j < variables.size(); j++)
										{
											String variable = (String) variables.get(j);
											String value = (String) values.get(j);
											jsTopology.setValue(sub,variable,value);
										}
									}
								}
							}
							jsTopology.saveFile();
						}
						EgConfigFilesSync.releaseInstance(jsTopology);

						if(update_msmt_table != null && update_msmt_table.equals("true"))
						{
							success = renameObj.executeOtherQueries();
							if(!success)
							{
								renameStatus = false;
								auditLogThread.setPreviousValue("Service name",old_name);
								auditLogThread.setCurrentValue("Service name",new_name);
								auditLogThread.setValue("Description","Report and measurement tables have not been updated with new service name");
								auditLogThread.sendItToDB();
								message=_mapping.getTextDescription("admin.error.Problem while updating report and measurement tables")+".";
							}
						}
						if(renameStatus)
						{
							auditLogThread.setPreviousValue("Service name",old_name);
							auditLogThread.setCurrentValue("Service name",new_name);
							auditLogThread.setValue("Description","Service has been renamed");
							auditLogThread.sendItToDB();
							String label = "admin.common."+rename.toLowerCase()+" has been renamed successfully to";
							message = old_name + " " + _mapping.getTextDescription(label) + " " + new_name + ".";
						}
					}
				
					
				}
				else
				{
					renameStatus = false;
					String errorLabel = rename + " name";
					auditLogThread.setPreviousValue(errorLabel,old_name);
					auditLogThread.setCurrentValue(errorLabel,new_name);
					auditLogThread.setValue("Description",rename+" was not renamed as it had already been deleted");
					auditLogThread.sendItToDB();
					String label = "admin.common."+rename.toLowerCase()+" was not renamed to";
					message = old_name + " " +_mapping.getTextDescription(label) + " " + new_name +".";
				}
			}

			if(monitorLastSession != null && newUrlLink != null  && newUrlLink.indexOf("serviceDashboard.jsp")>-1)
			{
				if(old_name!=null && oldServiceName!=null && old_name.equals(oldServiceName))
				{
					session.removeAttribute("monitorLastSession");
				}
			}
		}
	}
	rootJson.put("message",message);
	rootJson.put("renamed",renameStatus);
	rootJson.put("rename",_mapping.getTextDescription("admin.common.Rename"));
	rootJson.put("success","true");
	out.println(rootJson.toString());
%>
