<%
/*****************************************************************************************************
*	Name		:	EgTopologyJSON.jsp
*	Purpose		:	To get JSON object for service topology(admin module).
******************************************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "egurkha.EgCrawlerAdmin" %>
<%@ page import = "com.egurkha.EgConstants" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.EgNewTopology" %>
<%@ page import = "com.eg.TopoRhsComp" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page import = "com.eg.eGComponentCategory" %>
<%@ taglib prefix = "egui" uri="../../../WEB-INF/eg-taglib.tld" %>
<%@ page import = "java.util.*" %>
<%@ page import = "net.sf.json.*" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"  autoFlush="true"%>
<%

try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	String ua = request.getHeader( "User-Agent" );

	boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );
	IniFile udTests=new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_udtests.ini");
	String segmentName = request.getParameter("segment");
	String zoomLevel = request.getParameter("zoom");
	String view = request.getParameter("view");
	String defaultPos = request.getParameter("default");
	String topologyRenderingMode = request.getParameter("topologyRenderingMode");
	String autoPosition = request.getParameter("autoPosition");
	String site = request.getParameter("site");
	String phyTopology = request.getParameter("physical_topology");
	String topologySkin = _user.getAdminSkin();

	JSONObject rootJson = new JSONObject();
	IniFile egUi = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	boolean isFull = false;
	boolean isPosition = false;
	StringBuffer positionBuffer = new StringBuffer();

	if(zoomLevel == null) {
		zoomLevel = "100";
	}
	
	if(view != null && view.equals("full")) {
		isFull = true;
	}
	
	if(site == null) {
		site = "egurkha.physical.topology";
	}
	String installDir = EgInstallInfo.getInstallDir();
	String iniFileName = installDir + "/manager/config/js_topology.ini";
	if((autoPosition != null && autoPosition.equals("true")) || (topologyRenderingMode != null && topologyRenderingMode.equals("auto"))){
		iniFileName = installDir + "/manager/config/js_auto_topology.ini";
	}
	IniFile jsTopoIniObj = EgConfigFilesSync.getInstance(iniFileName);

	String subjectName = site+ "~|#|~"+segmentName;
	String[] allLines = jsTopoIniObj.getLinesUnderSubject(subjectName);
	if(allLines == null || allLines.length == 0)
	{
		subjectName = segmentName;
		allLines = jsTopoIniObj.getLinesUnderSubject(subjectName);
	}

	String iniZoom = jsTopoIniObj.getValue(subjectName, "zoom");
	if(iniZoom != null && iniZoom.length() > 0 )
	{
		zoomLevel = iniZoom;
	}
	EgConfigFilesSync.releaseInstance(jsTopoIniObj);

	if(allLines != null)
	{
		List positionList = Arrays.asList(allLines);
		positionBuffer.append(positionList.toString().substring(1, positionList.toString().indexOf("]")));
		isPosition = true;
	}

	if(defaultPos !=null && defaultPos.equals("true")) {
		isPosition = false;
	}

	String finalTopoStr = getTopologyString(segmentName, site, phyTopology);
	
	//Get row & column spacing from eg_ui.ini .... (Begin)
	IniUI iniUI = IniUI.getInstance();
	String rs = iniUI.getValue("TOPOLOGY_OPTIONS", "Row_space");
	String cs = iniUI.getValue("TOPOLOGY_OPTIONS", "Column_space");
	iniUI =  null;
	int rowspace = 50;
	int colspace = 50;
	try
	{
		if(rs != null) rowspace = Integer.parseInt(rs);
	}
	catch(Exception e){
	}

	try
	{
		if(cs != null) colspace = Integer.parseInt(cs);
	}
	catch(Exception e){
	}
	
	EgNewTopology egNewTopo = new EgNewTopology(finalTopoStr, rowspace, colspace, topologySkin, request);
	
	int divHeight = egNewTopo.getHeight();
	int divWidth = egNewTopo.getWidth();
	if((autoPosition != null && autoPosition.equals("true")) || (topologyRenderingMode != null && topologyRenderingMode.equals("auto")))
	{
		rootJson.put("rootJson", egNewTopo.getAutoTopologyJson());
		
	} else {
		rootJson.put("rootJson", egNewTopo.getTopologyJson());
	}
	response.setContentType("application/json;charset=UTF-8");
	response.getWriter().write(rootJson.toString());

}
catch(Exception e)
{
	System.out.println("Exception in admin/services/data/EgTopologyJSON.jsp....");
	e.printStackTrace();
}
%>

<%!
	private String getTopologyString(String segmentName, String site, String phyTopology)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		EgCrawlerAdmin strBean = new EgCrawlerAdmin(iniFile);
		String str = null;

		if (phyTopology.equals("1")) {
			str = strBean.getPhysicalTopology(segmentName);
		} else
		{
			if (segmentName.equals("Independent_servers"))
			{
				str = strBean.getSiteString(site, site + "_INDEPENDENT");
			}
			else
			{
				str = strBean.getSiteString(site, segmentName);
			}
		}

		AlarmPriorities ap = AlarmPriorities.getInstance();
		String newString = null;
		if (StringUtils.isNull(str))
			newString = EgConstants.BLANK_SPACE;
		else
			newString = ap.getTopologyPriority(str, site);
		newString = sortTopoString(newString);
		return newString;
	}

	/*
	To sort the topology string so that the new topology applet will understand
	*/
	public String sortTopoString(String topoStr) 
	{
		if(topoStr == null)
			return null;
		Hashtable h = new Hashtable();

		String [] topoToks = StringUtils.getTokens(topoStr, "|");

		ArrayList finalLhs = new ArrayList();
		ArrayList finalRhs = new ArrayList();
		ArrayList leftOver = new ArrayList();
		boolean changesOccured = false;
		while (!changesOccured)	 //loop until sorted properly changesOccured becomes true
		{
			changesOccured = true;	
			for (int i = 0; i < topoToks.length; i++ )
			{
				String [] relation = StringUtils.getTokens(topoToks[i], "=");
				String thisLhs = "";
				String thisRhs = "";
				if(relation != null && relation.length == 2)
				{
				 thisLhs = relation[0];
				 thisRhs = relation[1];	//Network_node:Core_Switch_1:NULL:N:GOOD,Network_node:Core_Switch_2:NULL:N:GOOD
				}
				else if(relation != null && relation.length == 1)
				{
					thisLhs = relation[0];
				}
				//System.out.println("! thisLhs:"+thisLhs);
				if (i == 0)
				{
					//add first component
					if (finalLhs.indexOf(thisLhs) == -1)	 //if lhs is already added, skip
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}
				}else
				{
					Object rhsObj = h.get(thisLhs);
					/*
						if rhsObj is null, it means that we get a wrong entry, i.e. the component comes in improper order. 
						a component which havnt come in rhs, has been given as lhs. so dont add it right now. wait until the 
						necessary rhs is getting added.
					*/
					if (rhsObj != null && finalLhs.indexOf(thisLhs) == -1)
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}else
					{
						if (rhsObj == null)				//if rhsObj is null, it means that some component is not yet added
							changesOccured = false;
					}
				}
			}
		}

		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < finalLhs.size(); i++ )
		{
			String thisStr = (String)finalLhs.get(i);
			ArrayList rhsList = (ArrayList) finalRhs.get(i);
			Iterator myIter = rhsList.iterator();
			StringBuffer sb2 = new StringBuffer();
			while (myIter.hasNext())
			{
				TopoRhsComp thisRhsComp = (TopoRhsComp) myIter.next();
				sb2.append(thisRhsComp.getComponent());
				if (myIter.hasNext())
					sb2.append(",");
			}
			sb.append(finalLhs.get(i));
			sb.append("=");
			sb.append(sb2.toString());
			sb.append("|");
		}
		String result = sb.toString();
		if (result.endsWith("|"))
		{
			result = result.substring(0, result.lastIndexOf("|"));
		}
		return result;
	}

	public ArrayList getRhsList(String thisRhs, String thisLhs, Hashtable h)
	{
		ArrayList result = new ArrayList();
		if(thisRhs != null && !thisRhs.equals(""))
		{
			String [] toks = StringUtils.getTokens(thisRhs, ",");
			for (int i = 0; i < toks.length; i++ )
			{
				String thisStr = toks[i];
				TopoRhsComp rhsCmp = new TopoRhsComp(thisStr);
				result.add(rhsCmp);
				
				if (!rhsCmp.toString().equals("null"))
				{
					h.put(rhsCmp.toString(), thisLhs);
				}
			}
		}
		return result;
	}
%>