<%
/***********************************************************************************************************
*	Name			:	renamep.jsp
*	Purpose			:	Process page for rename.jsp
*	Version			:	5.5
*	CreationDate	:	17-Feb-2012
*	Author			:	James Thomas P
***********************************************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page errorPage="../../EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import = "com.eg.EgStateZone"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.admin.Rename"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	response.setContentType("application/json;charset=UTF-8");
	JSONObject rootJson = new JSONObject();

	String rename = request.getParameter("rename");
	String old_name = EgURLDecoder.decode(request.getParameter("old_name"),"UTF-8");
	String new_name = EgURLDecoder.decode(request.getParameter("new_name"),"UTF-8");

	String message = null;
	boolean renameStatus = true;
	
	String monitorLastSession=(String)session.getAttribute("monitorLastSession");

	String newUrlLink="";
	String oldSegmentName="";
	String urlLink="";

	if(monitorLastSession!=null && monitorLastSession.trim().length()>0)
	{
		if(monitorLastSession.indexOf('?') == -1)
		{
			newUrlLink=monitorLastSession;
		}
		else
		{
			newUrlLink=monitorLastSession.substring(0,monitorLastSession.indexOf('?'));
			urlLink = monitorLastSession.substring(monitorLastSession.indexOf('?')+1);
		}
		
		if(urlLink!=null && urlLink.trim().length()>0)
		{
			StringTokenizer multiTokenizer = new StringTokenizer(urlLink,"&");
			while(multiTokenizer.hasMoreTokens())
			{
				String param = multiTokenizer.nextToken();
				int ind = param.indexOf("=");
				if (ind < 0)
					continue;
				String reqparam =param.substring(0,ind);
				String paramValue = param.substring(ind+1);
				if(reqparam!=null && reqparam.equals("segment"))
				{
					String segmentValue = paramValue;
					if(segmentValue != null && segmentValue.trim().length()>0)
					{
						oldSegmentName=com.eg.EgURLDecoder.decode(segmentValue, "UTF-8");
					}
				}
			}
		}
	}


	if(StringUtils.isNull(old_name) || StringUtils.isNull(new_name) || StringUtils.isNull(rename))
	{
		renameStatus = false;
		if(StringUtils.isNull(rename))
		{
			message = _mapping.getTextDescription("admin.error.Operation is not defined")+".";
		}
		else
		{
			if(StringUtils.isNull(new_name))
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming with new name as empty or null")+".";
			}
			else
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming as current name is empty or null")+".";
			}
		}
	}
	else
	{
		rename = rename.trim();
		old_name = old_name.trim();
		new_name = new_name.trim();

		if(IniUI.isEgReservedKeyword(new_name))
		{
			renameStatus = false;
			message = "'"+new_name.toUpperCase() +"' "+_mapping.getTextDescription("admin.error.is an eG defined keyword")+". "+_mapping.getTextDescription("admin.error.Choose another name")+".";
		}
		else
		{
			boolean oldNameExist = false;
			boolean isSite = false;
			String auditlogLabel = null;
			String nameConflictLabel = null;
			String update_msmt_table = "true";
			Vector nameConflict = new Vector();//dont add anything into this vector

			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Activity","Rename Segment");

			String targetPageURL = null;
			auditLogThread.setValue("Module","Configured Segments");
			oldNameExist = Rename.doesOldnameExist(new EgTopoInfo("manager").getSegmentNames(),old_name,new_name,nameConflict);
			nameConflictLabel="admin.error.You are trying to rename a segment with a name which is already assigned to another segment";
			auditlogLabel=old_name + " segment can not be renamed to "+new_name +" as this name is already assigned to some other segment";
			
			
			if(!nameConflict.isEmpty())
			{
				renameStatus = false;
				auditLogThread.setValue("Description",auditlogLabel);
				auditLogThread.sendItToDB();
				message = _mapping.getTextDescription(nameConflictLabel)+".";
			}
			else
			{
				if(oldNameExist)
				{
					boolean success = false;
					
					Rename renameObj = new Rename(u_rs,"Segment",old_name,new_name,update_msmt_table,isSite);
					success = renameObj.executeDefaultQueries();
					if(!success)
					{
						renameStatus = false;
						auditLogThread.setPreviousValue("Segment name",old_name);
						auditLogThread.setCurrentValue("Segment name",new_name);
						auditLogThread.setValue("Description","Database tables have not been updated with new segment name");
						auditLogThread.sendItToDB();
						message = _mapping.getTextDescription("admin.error.Problem while updating database tables")+".";
					}
					if(renameStatus)
					{
						IniFile topologyIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini");
						IniFile topologySync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_topology.ini");
						topologySync.deleteValue("TOPOLOGY_SEGMENTS",old_name);
						topologySync.setValue("TOPOLOGY_SEGMENTS",new_name,new_name);
						renameSegMapping(old_name,new_name);
						Vector vars = topologyIni.getVariables(old_name,true);
						Vector vals = topologyIni.getAllValues(old_name);
						topologySync.deleteSubject(old_name);
						if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
						{
							for(int i=0;i<vars.size();i++)
							{
								topologySync.setValue(new_name,(String)vars.get(i),(String)vals.get(i));
							}
						}
						vars = topologyIni.getVariables("WEB_SITE_SEGMENTS",true);
						vals = topologyIni.getAllValues("WEB_SITE_SEGMENTS");
						if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
						{
							for(int i=0;i<vals.size();i++)
							{
								String val = (String)vals.get(i);
								String temp = ","+val+",";
								int index = temp.indexOf((","+old_name+","));
								if(index>-1)
								{
									String new_name_str = StringUtils.replace(temp,(","+old_name+","),(","+new_name+","));
									new_name_str=new_name_str.substring(1,new_name_str.length()-1);
									topologySync.setValue("WEB_SITE_SEGMENTS",(String)vars.get(i),new_name_str);
								}
							}
						}
						IniFile groupsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
						IniFile groupSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_group.ini");
						vars = groupsIni.getVariables("ZONE_DETAILS",true);
						vals = groupsIni.getAllValues("ZONE_DETAILS");
						if(vars != null && vars.size()>0 && vals != null && vars.size()>0)
						{
							for(int i=0;i<vars.size();i++)
							{
								if(vars.get(i).toString().startsWith("Segment:"+old_name+":NULL#"))
								{
									String var = vars.get(i).toString();
									String val = vals.get(i).toString();
									groupSync.deleteValue("ZONE_DETAILS",var);
									String associated_zone = var.substring(var.lastIndexOf("#")+1);
									var = "Segment:"+new_name+":NULL#"+associated_zone;
									groupSync.setValue("ZONE_DETAILS",var,val);
								}
							}
						}
						vars = null;
						vals = null;
						// Rename segment_display_image
						String imageValue = topologySync.getValue("SEGMENT_DISPLAY_IMAGE",old_name);
						topologySync.deleteValue("SEGMENT_DISPLAY_IMAGE",old_name);
						topologySync.setValue("SEGMENT_DISPLAY_IMAGE",new_name,imageValue);

						topologySync.saveFile();
						groupSync.saveFile();
						registry.updateAllUserMaps();
						EgStateZone.updateZoneGroupStatus();
						EgConfigFilesSync.releaseInstance(topologySync);
						EgConfigFilesSync.releaseInstance(groupSync);

						IniFile jsTopology = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "js_topology.ini");
						String[] allSubjects = jsTopology.getSubjects();
						if(allSubjects != null)
						{
							for(int i = 0; i < allSubjects.length; i++)
							{
								String sub = allSubjects[i];
								if(sub.equals(old_name))
								{
									Vector variables = jsTopology.getVariables(sub,true);
									Vector values = jsTopology.getAllValues(sub);
									jsTopology.deleteSubject(sub);

									if(variables != null && variables.size() > 0 && values != null && values.size() > 0)
									{
										for(int j = 0; j < variables.size(); j++)
										{
											String variable = (String) variables.get(j);
											String value = (String) values.get(j);
											jsTopology.setValue(new_name,variable,value);
										}
									}
								}
								else if(sub.endsWith("~|#|~"+old_name))
								{
									Vector variables = jsTopology.getVariables(sub,true);
									Vector values = jsTopology.getAllValues(sub);
									jsTopology.deleteSubject(sub);

									sub = sub.substring(0,sub.indexOf("~|#|~")+5);
									sub = sub + new_name;


									if(variables != null && variables.size() > 0 && values != null && values.size() > 0)
									{
										for(int j = 0; j < variables.size(); j++)
										{
											String variable = (String) variables.get(j);
											String value = (String) values.get(j);
											jsTopology.setValue(sub,variable,value);
										}
									}
								}
							}
							jsTopology.saveFile();
						}
						EgConfigFilesSync.releaseInstance(jsTopology);

						if(update_msmt_table != null && update_msmt_table.equals("true"))
						{
							success = renameObj.executeOtherQueries();
							if(!success)
							{
								renameStatus = false;
								auditLogThread.setPreviousValue("Segment name",old_name);
								auditLogThread.setCurrentValue("Segment name",new_name);
								auditLogThread.setValue("Description","Report and measurement tables have not been updated with new segment name");
								auditLogThread.sendItToDB();
								message = _mapping.getTextDescription("admin.error.Problem while updating report and measurement tables")+".";
							}
						}
						if(renameStatus)
						{
							auditLogThread.setPreviousValue("Segment name",old_name);
							auditLogThread.setCurrentValue("Segment name",new_name);
							auditLogThread.setValue("Description","Segment has been renamed");
							auditLogThread.sendItToDB();
							String label = "admin.common."+rename.toLowerCase()+" has been renamed successfully to";
							message = old_name + " " + _mapping.getTextDescription(label) + " " + new_name + ".";
						}
					}
				
					
				}
				else
				{
					renameStatus = false;
					String errorLabel = rename + " name";
					auditLogThread.setPreviousValue(errorLabel,old_name);
					auditLogThread.setCurrentValue(errorLabel,new_name);
					auditLogThread.setValue("Description",rename+" was not renamed as it had already been deleted");
					auditLogThread.sendItToDB();
					String label = "admin.common."+rename.toLowerCase()+" was not renamed to";
					message = old_name + " " +_mapping.getTextDescription(label) + " " + new_name +".";
				}
			}
			
			if(monitorLastSession != null && newUrlLink != null && newUrlLink.indexOf("segmentDashboard.jsp")>-1)
			{
				if(old_name!=null && oldSegmentName!=null && old_name.equals(oldSegmentName))
				{
					session.removeAttribute("monitorLastSession");
				}
			}
		}
	}
	rootJson.put("message",message);
	rootJson.put("renamed",renameStatus);
	rootJson.put("rename",_mapping.getTextDescription("admin.common.Rename"));
	rootJson.put("success","true");
	out.println(rootJson.toString());
%>
<%!
	public void renameSegMapping(String oldName ,String newName)
	{
		String str_iniFileName = "eg_topology.ini";
		IniFile ini_top = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/"+ str_iniFileName,true);
		String[] segMapVar = ini_top.getVariables("Segments_Mapping");
		if(segMapVar != null && segMapVar.length>0)
		{
			for(int i=0;i<segMapVar.length;i++)
			{
				String segVar = segMapVar[i];
				String segment_name = ini_top.getValue("Segments_Mapping",segVar);
				StringTokenizer strTok = new StringTokenizer(segment_name,"#");
				while(strTok.hasMoreTokens())
				{
					String segTok = strTok.nextToken();
					if(segTok.equalsIgnoreCase(oldName))
					{
						String subMap = segment_name.replace(oldName,newName);
						ini_top.setValue("Segments_Mapping",segVar,subMap);
					}
				}
			}
		}
		ini_top.saveFile();
		EgConfigFilesSync.releaseInstance(ini_top);
	}
%>