<%
/**
 *	File name       :   EgnewremoteagentspJson.jsp
 *  Purpose         :   Process page.
 *	Modified		:	Checks to see if the nickname 
 *						assigned to an agent
 *						performing client emulation or to another remote 						   agent.

 *  -1      :     Nickname already exists ;
 *  -2      :     Nickname exists with same ip but the given nick differ in case;
 *  -3      :     Nickname managed with some other ip;
 *  -4      :     Nickname used for client emulation;
 *   0      :     successfully updated.
 */

%>

<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.egurkha.util.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.admin.RemoteAgent"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	String r_option = request.getParameter("addAsRemote");
	String externalResultStr = request.getParameter("externalResultString");
	String toExtAgnt = request.getParameter("external");
	String s_mode = request.getParameter("mode");
	String s_hostip = request.getParameter("hostip");
	String s_hostname = request.getParameter("hostname");
	String old_ip = request.getParameter("old_ip");
	String old_name = request.getParameter("old_name");
	String s_eagent = request.getParameter("eagent");
	String vmware = request.getParameter("remote_vmware");

	s_mode = (s_mode == null? "" : s_mode);
	old_ip = (old_ip == null? "" : old_ip);
	old_name = (old_name == null? "" : old_name);
	s_hostip = (s_hostip == null? "" : s_hostip);
	s_hostname = (s_hostname == null? "" : s_hostname);
	toExtAgnt = (toExtAgnt == null? "" : toExtAgnt);
	r_option = (r_option == null? "" : r_option);
	externalResultStr = (externalResultStr == null? "" : externalResultStr);

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Remote Agent Configuration");
	/* code for auditlog ends */
	EgExternalInfo extInfo = new EgExternalInfo("manager");
	String[] extAgents = extInfo.getAllExternalAgents();
	List extList = Arrays.asList(extAgents);
	String s_eagentip = extInfo.getIpForRemoteAgent(s_eagent);
	s_eagentip = (s_eagentip == null? "" : s_eagentip);
	RemoteAgent remAgntObj = new RemoteAgent(_user.getLoginID());

	JSONObject errorMsg = new JSONObject();
	JSONObject resultMsg = new JSONObject();

	String user_id = _user.getLoginID();
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),user_id);
	EgUuidInfo uuidInfo = new EgUuidInfo();
	EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
	boolean isLimitedAdmin = !egRoleInfo.hasAllComponentAccess();
	boolean isMspModel = EgUuidInfo.isMspModel();
	boolean shareNickAcrossOU = EgUuidInfo.shareNickAcrossOU();
	boolean isNickShared = false;
	//boolean orghavegivennick = false;
	if(isMspModel )//&& !shareNickAcrossOU)
	{
		Vector nicksListLower = new Vector();
		ArrayList usersSharedAgents = new ArrayList();
		Hashtable orgUsersNickMap = uuidInfo.getAllUsersNickMap(true,true);
		String s_host_name_LowerCase = s_hostname.toLowerCase();

		if(orgUsersNickMap != null)
		{
			String user_name = user_id;
			if(!orgUsersNickMap.containsKey(user_name))
			{
				user_name = uuidInfo.getSuperOU(user_id);
			}
			if (user_name !=null)
			{
				Enumeration enu = orgUsersNickMap.keys();
				while(enu.hasMoreElements())
				{
					String orgName = (String)enu.nextElement();
					if(!orgName.equalsIgnoreCase(user_name))
					{
						Vector nickList = (Vector)orgUsersNickMap.get(orgName);
						if(nickList != null)
						{
							int nicListSize = nickList.size();
							for (int a=0; a < nicListSize; a++)
							{
								String nickLower = nickList.get(a).toString().toLowerCase();
								nicksListLower.add(nickLower);
							}
							if(nicksListLower.contains(s_host_name_LowerCase))
							{
								usersSharedAgents.add(orgName);
							}
						}
					}
				}
			}
		}
		if(usersSharedAgents != null && usersSharedAgents.size() > 0)
		{
			String super_org = uuidInfo.isSuperOrg(user_id) ? user_id : uuidInfo.getSuperOU(user_id);
			String suggested_nick = uuidInfo.getUniqueNickName(egDiscInfo,s_hostname);

			Hashtable allNickIpMap = egDiscInfo.getNickIpMap(true,"");
			ArrayList allNicksList = new ArrayList(allNickIpMap.keySet());
			String existingIP = null;
			if(!allNicksList.contains(s_hostname))  //to check nick exist in different case.
			{
				int idx = nicksListLower.indexOf(s_host_name_LowerCase);
				if (idx > -1)
				{
					String existingNick = allNicksList.get(idx).toString();
					existingIP = allNickIpMap.get(existingNick).toString();
				}
			}
			else
			{
				existingIP = allNickIpMap.get(s_hostname).toString();
			}
			if (s_mode.equalsIgnoreCase("modifyip")) 
			{
				if(!s_hostname.equals(old_name) && (existingIP != null && !existingIP.equals(s_hostip)))
				{
					isNickShared = true;
					rootJson.put("error_type","alert");
					errorMsg.put("title",_mapping.getTextDescription("admin.error.Modify remote agent"));
					errorMsg.put("message1",_mapping.getTextDescription("admin.server.The nick name")+" ("+s_hostname+") "+_mapping.getTextDescription("admin.server.you are trying to modify is already associated with the agent")+" ("+existingIP+").");
					errorMsg.put("message2",_mapping.getTextDescription("admin.server.Please provide a different nick name")+".");
					rootJson.put("error",errorMsg);
					rootJson.put("requestStatus","failed");
					auditLogThread.setValue("Activity","Modify Remote Agent");
					auditLogThread.setCurrentValue("ColumnName","Agent Not Modified");
					auditLogThread.setCurrentValue("Host/Nick name",s_hostname);
					auditLogThread.setValue("Description","Remote agent has not been modified as this host/nick name is used by another user");
				}
			}
			else
			{
				if(!isLimitedAdmin)  
				{
					isNickShared = false;
				//	orghavegivennick = true;
				}
				else
				{
					//for all other user, suggesting the nick
					isNickShared = true;
					auditLogThread.setValue("Activity","Add Remote Agent");
					rootJson.put("error_type","confirmNickSuggestion");
					rootJson.put("requestStatus","failed");
					errorMsg.put("title",_mapping.getTextDescription("admin.error.Add new remote agent"));
					errorMsg.put("message1",_mapping.getTextDescription("admin.error.The host/nick name")+" ("+"<b>"+s_hostname+"</b>"+")	"+_mapping.getTextDescription("admin.error.you are trying to add is already existing")+". ");
					errorMsg.put("message2",_mapping.getTextDescription("admin.server.Would you like to use the nick name")+" '"+suggested_nick+"'?");
					errorMsg.put("IP",s_hostip);
					errorMsg.put("nickName",suggested_nick);
					String query = request.getQueryString();
					String existingQuery = "";
					StringTokenizer strTkns = new StringTokenizer(query, "&");
					while (strTkns.hasMoreTokens())
					{
						String tkn = strTkns.nextToken();
						if (tkn.startsWith("hostname=") || tkn.startsWith("hostip="))
						{
							continue;
						}
						existingQuery += tkn + "&";
					}
					String url = "EgnewremoteagentspJson.jsp?hostname="+EgURLEncoder.encode(suggested_nick,"UTF-8")+"&"+existingQuery+"hostip="+s_hostip+"&oldhostname="+EgURLEncoder.encode(old_name,"UTF-8");
					errorMsg.put("forward_URL",url);
					rootJson.put("error",errorMsg);
				}
			}
			auditLogThread.sendItToDB();
		}
	}

	if (!isNickShared)
	{
		ArrayList orgnames = new ArrayList();
		if (s_mode.equalsIgnoreCase("add"))  // Add Remote Agent
		{
			String orgwithsamenick = request.getParameter("OrgWithGivenNick");
			if(orgwithsamenick != null)
			{
				StringTokenizer orgwithsamenick1=new StringTokenizer(orgwithsamenick,",");
				if(orgwithsamenick1.countTokens() > 0)
				{
					while(orgwithsamenick1.hasMoreTokens())
					{
						orgnames.add(orgwithsamenick1.nextToken().toString());
					}
				}
			}
			String resultInStr="";
				if(orgnames!=null && orgnames.size() > 0)
				{
					resultInStr = remAgntObj.add(s_hostip,s_hostname,orgnames);
				}
				else
				{
					resultInStr = remAgntObj.add(s_hostip,s_hostname);
				}
				resultInStr = resultInStr.substring(0,resultInStr.indexOf("#"));
				int updateResult = Integer.parseInt(resultInStr);
				if (updateResult == -1 || updateResult == -2 || updateResult == -3)
				{
					String IP = remAgntObj.getManagedIPForNick();
					
					if (IP == null)
					{
						IP = s_hostip;
					}
					String originalName = remAgntObj.getOriginalHostName();
					if (originalName == null && updateResult == -1)
					{
						originalName = s_hostname;
					}

					rootJson.put("requestStatus","failed");
					errorMsg.put("title",_mapping.getTextDescription("admin.error.Add new remote agent"));
					errorMsg.put("message1",_mapping.getTextDescription("admin.error.The host/nick name")+" ("+"<b>"+s_hostname+"</b>"+") ");

					if (updateResult == -2)
					{
						errorMsg.put("message2",_mapping.getTextDescription("admin.error.you are trying to add is already associated with the IP")+" ("+"<b>"+IP+"</b>"+") "+_mapping.getTextDescription("admin.error.in the following manner")+"."+"<br>"+"<br>"+"<center><table border='1'  cellspacing='2' cellpadding='3' width='50%'><tr><td width='50%' style='text-align:left;font-size:12'><strong>&nbsp;"+_mapping.getTextDescription("admin.common.IP")+"</strong></td><td width='50%' style='text-align:left;font-size:12'><strong>&nbsp;"+_mapping.getTextDescription("admin.common.Host/Nick name")+"</strong></td></tr><tr><td width='50%' style='text-align:left;font-size:12'>&nbsp;"+IP+"</td><td width='50%' style='text-align:left;font-size:12'>&nbsp;"+originalName+"</td></tr></table></center><br><center>"+_mapping.getTextDescription("admin.error.As the host/nick name is case insensitive, please use the old host/nick name")+"(<b>" + originalName + "</b>).</center><br>");
					}
					else
					{
						errorMsg.put("message2",_mapping.getTextDescription("admin.error.you are trying to add is already associated with the IP")+" ("+"<b>"+IP+"</b>"+") "+_mapping.getTextDescription("admin.error.in the following manner")+"."+"<br>"+"<br>"+"<center><table border='1'  cellspacing='2' cellpadding='3' width='50%'><tr><td width='50%' style='text-align:left;font-size:12'><strong>&nbsp;"+_mapping.getTextDescription("admin.common.IP")+"</strong></td><td width='50%' style='text-align:left;font-size:12'><strong>&nbsp;"+_mapping.getTextDescription("admin.common.Host/Nick name")+"</strong></td></tr><tr><td width='50%' style='text-align:left;font-size:12'>&nbsp;"+IP+"</td><td width='50%' style='text-align:left;font-size:12'>&nbsp;"+originalName+"</td></tr></table></center><br><center>"+_mapping.getTextDescription("admin.error.Please use another host/nick name")+"."+"</center><br>");
					}
					rootJson.put("error",errorMsg);

					auditLogThread.setValue("Activity","Add Remote Agent");
					auditLogThread.setCurrentValue("ColumnName","Agent Not Created");
					auditLogThread.setCurrentValue("Host/Nick name",s_hostname);
					auditLogThread.setValue("Description","Remote agent has not been created as this host/nick name is used by another remote agent");
					auditLogThread.sendItToDB();
				}
				else if (updateResult == -4)
				{
					rootJson.put("requestStatus","failed");
					errorMsg.put("title",_mapping.getTextDescription("admin.error.Add new external agent"));
					errorMsg.put("message1",_mapping.getTextDescription("admin.error.This host/nick name is used by another agent for client emulation")+".");
					errorMsg.put("message2",_mapping.getTextDescription("admin.error.Please use another host/nick name")+".");
					rootJson.put("error",errorMsg);

					auditLogThread.setValue("Activity","Add Remote Agent");
					auditLogThread.setCurrentValue("Host/Nick name",s_hostname);
					auditLogThread.setValue("Description","Remote agent has not been created as this host/nick name is used by another agent for client emulation");
					auditLogThread.sendItToDB();
				}
				else if (updateResult == -5)
				{
					rootJson.put("requestStatus","failed");
					errorMsg.put("title",_mapping.getTextDescription("admin.error.Add new external agent"));

					if (remAgntObj.isVmwareAgent(vmware))
					{
						errorMsg.put("message1",_mapping.getTextDescription("admin.error.The Vmware host could not be monitored as a remote agent because you have exceeded the number of remote/premium agents allowed by your license")+".");
					}
					else
					{
						errorMsg.put("message1",_mapping.getTextDescription("admin.error.You have exceeded the number of remote/premium agents allowed by your license")+".");
					}
					if (externalResultStr.equals("eG_CLI_0010"))
					{
						errorMsg.put("message2",_mapping.getTextDescription("admin.error.To monitor additional remote agents")+", "+_mapping.getTextDescription("admin.error.admin.error.please contact <b>license@eginnovations*com</b>")+" ."+"<br><br><img src='/final/images/spacer.gif' class='iconInformation' border='0'>"+_mapping.getTextDescription("admin.error.External agent added successfully"));
					}
					else
					{
						errorMsg.put("message2",_mapping.getTextDescription("admin.error.To monitor additional remote agents")+", "+_mapping.getTextDescription("admin.error.admin.error.please contact <b>license@eginnovations*com</b>")+" .");
					}
					rootJson.put("error",errorMsg);

					auditLogThread.setValue("Activity","Add Remote Agent");
					auditLogThread.setCurrentValue("Agent Host/Nick Name",s_hostname);
					auditLogThread.setValue("Description","Remote agent has not been created as you have exceeded the number of remote/premium agents allowed by your license");
					auditLogThread.sendItToDB();
				}
				else if (updateResult == 0)
				{
					if(r_option.equals("true"))
					{
						if(externalResultStr.equals("eG_CLI_0010"))
						{
							rootJson.put("requestStatus","success");
							resultMsg.put("title",_mapping.getTextDescription("admin.server.External agent configuration"));
							resultMsg.put("message1",_mapping.getTextDescription("admin.server.The external agent")+"&nbsp;"+"'"+s_hostname+"'"+"&nbsp;"+_mapping.getTextDescription("admin.server.has been configured successfully")+"."+"<br><br>"+_mapping.getTextDescription("admin.server.The remote agent")+"&nbsp;"+"'"+s_hostname+"'"+"&nbsp;"+_mapping.getTextDescription("admin.server.has been configured successfully")+".");
							rootJson.put("result",resultMsg);
						}
						else
						{
							rootJson.put("requestStatus","success");
							resultMsg.put("title",_mapping.getTextDescription("admin.server.Remote agent configuration"));
							resultMsg.put("message1",_mapping.getTextDescription("admin.server.The remote agent")+"&nbsp;"+"'"+s_hostname+"'"+"&nbsp;"+_mapping.getTextDescription("admin.server.has been configured successfully")+".");
							rootJson.put("result",resultMsg);
						}
					}
					else if(toExtAgnt.equals("true"))
					{
						if(extList.contains(s_hostname))
						{
							rootJson.put("requestStatus","success");
							resultMsg.put("title",_mapping.getTextDescription("admin.server.Remote agent configuration"));
							resultMsg.put("message1",_mapping.getTextDescription("admin.server.The remote agent")+"&nbsp"+"'"+s_hostname+"'"+"&nbsp"+_mapping.getTextDescription("admin.server.has been configured successfully")+".<br><br>"+"<table class='x-form-display-field'><tr><td> <img src='/final/images/spacer.gif' class='iconExclamation' border='0'></td><td valign='middle' class='x-form-display-field'>"+_mapping.getTextDescription("admin.server.The external agent you are trying to add already exists")+"."+"</td></tr></table></center>");
							rootJson.put("result",resultMsg);
						}
						else
						{
							rootJson.put("requestStatus","success");
							rootJson.put("addToExternal","true");
							resultMsg.put("title",_mapping.getTextDescription("admin.server.Add to External Agents"));
							rootJson.put("result",resultMsg);
						}
					}
					else if(toExtAgnt.equals("false"))
					{
						rootJson.put("requestStatus","success");
						resultMsg.put("title",_mapping.getTextDescription("admin.server.Remote agent configuration"));
						resultMsg.put("message1",_mapping.getTextDescription("admin.server.The remote agent")+"&nbsp;"+"'"+s_hostname+"'"+"&nbsp;"+_mapping.getTextDescription("admin.server.has been configured  successfully")+".");
						rootJson.put("result",resultMsg);
					}
					auditLogThread.setValue("Activity","Add Remote Agent");
					auditLogThread.setCurrentValue("ColumnName","Created Agent");
					auditLogThread.setCurrentValue("Agent IP Address",s_hostip);
					auditLogThread.setCurrentValue("Agent Host/Nick Name",s_hostname);
					auditLogThread.setValue("Description","Remote agent has been created");
					auditLogThread.sendItToDB();
				}
			//}
		}
	}
	if (s_mode.equalsIgnoreCase("modifyip")) //Modify Remote Agent
	{
		if (!old_ip.equals(s_hostip))
		{
			boolean ischangedIpUpdated = remAgntObj.modify(s_hostname,old_ip,s_hostip);
			if(ischangedIpUpdated)
			{
				String modifyComps = remAgntObj.getModifiedComponents();
				String modExtHosts = remAgntObj.getModifiedExternalHosts();
				List resultList = new ArrayList();
				if(modifyComps != null)
				{
					int idx = modifyComps.indexOf(":");
					if(idx != -1)
					{
						modifyComps = modifyComps.substring(idx+1);
						StringTokenizer stt = new StringTokenizer(modifyComps,":");
						while(stt.hasMoreTokens())
						{
							String tmpHost = stt.nextToken();
							if (tmpHost.indexOf("|") > 0)
							{
								resultList.add(tmpHost.substring(0,tmpHost.indexOf("|"))+" ("+_mapping.getComponentTypeDescription(tmpHost.substring(tmpHost.indexOf("|")+1))+")");
							}
						}
						Collections.sort(resultList);
					}
					else
						modifyComps = "";
				}
				String sessResult = resultList.toString();
				sessResult = sessResult.substring(1,sessResult.length() -1);
				rootJson.put("requestStatus","success");
				resultMsg.put("title",_mapping.getTextDescription("admin.server.Remote agent configuration"));
					
				auditLogThread.setValue("Activity","Modify Remote Agent");
				auditLogThread.setValue("Description", "Host IP has been modified");
				auditLogThread.setCurrentValue("01~~Old host IP",old_ip);
				auditLogThread.setCurrentValue("02~~New host IP",s_hostip);
				auditLogThread.setCurrentValue("05~~Modified remote agent(s)",s_hostname);
				if (modifyComps.length() == 0 && modExtHosts.length() == 0)
				{
						resultMsg.put("message1",_mapping.getTextDescription("admin.server.The remote agent")+"&nbsp;"+"'"+s_hostname+"'"+"&nbsp;"+_mapping.getTextDescription("admin.server.has been updated successfully")+".");
				}
				else
				{
					if (modifyComps!=null && modifyComps.length() > 0)
					{
						resultMsg.put("message1",_mapping.getTextDescription("admin.server.The remote agent")+"&nbsp;"+"'"+s_hostname+"'"+"&nbsp;"+_mapping.getTextDescription("admin.server.has been updated successfully")+".<br><br>"+_mapping.getTextDescription("admin.server.The component(s) is/are updated with the new host IP")+" "+s_hostip+"<br><br>"+sessResult);

						/* auditlog - start */
						auditLogThread.setCurrentValue("03~~Modified host(s)", sessResult);
						/* auditlog - end */
					}
					if (modExtHosts!=null && modExtHosts.length() > 0)
					{
						resultMsg.put("message1",_mapping.getTextDescription("admin.server.The remote agent")+"&nbsp;"+"'"+s_hostname+"'"+"&nbsp;"+_mapping.getTextDescription("admin.server.has been updated successfully")+".<br><br>"+_mapping.getTextDescription("admin.server.The external agent")+"&nbsp;"+"'"+modExtHosts+"'"+"&nbsp;"+_mapping.getTextDescription("admin.server.has been updated successfully")+".");

							/* auditlog - start */
						auditLogThread.setCurrentValue("04~~Modified external agent(s)", modExtHosts);
						/* auditlog - end */
					}
				}
				rootJson.put("result",resultMsg);
				auditLogThread.sendItToDB();
			}
			else
			{
				rootJson.put("requestStatus","failed");
				rootJson.put("notProperlyUpdated","true");
				errorMsg.put("title",_mapping.getTextDescription("admin.server.External agent configuration"));
				errorMsg.put("message1",_mapping.getTextDescription("admin.server.Not properly updated with the new host IP")+", "+s_hostip);

				if(toExtAgnt.equals("true"))
				{
					if (!extList.contains(s_hostname))
					{
						rootJson.put("AddSameAsExt","true");
						errorMsg.put("message2",_mapping.getTextDescription("admin.error.Still you want to add this as remote agent")+".  "+_mapping.getTextDescription("admin.common.Please click OK")+".</center>");
					}
					else
					{
						errorMsg.put("message1","<table class='x-form-display-field'><tr><td> <img src='/final/admin/eg_images/spacer.gif' class='iconExclamation' border='0'></td><td valign='middle' class='x-form-display-field'>"+_mapping.getTextDescription("admin.server.The external agent you are trying to add already exists")+"."+"</td></tr></table></center>");
					}
				}
			}
		}
		else if (!old_name.equals(s_hostname))
		{
			String result = remAgntObj.modifyNick(s_hostip,old_name,s_hostname);
			String intValue = result.substring(0,result.indexOf("#"));
			String booleanValue = result.substring(result.lastIndexOf("#")+1,result.length());
			int updateResult = Integer.parseInt(intValue);

			if (updateResult < 0)
			{
				String IP = remAgntObj.getManagedIPForNick();
				
				if (IP == null)
				{
					IP = s_hostip;
				}

				rootJson.put("requestStatus","failed");
				errorMsg.put("title",_mapping.getTextDescription("admin.error.Modify remote agent"));
				errorMsg.put("message1",_mapping.getTextDescription("admin.error.The nick name")+" ("+"<b>"+s_hostname+"</b>"+") ");

				if(updateResult == -1)
				{
					errorMsg.put("message2",_mapping.getTextDescription("admin.error.is used by another remote agent"));
				}
				else if (updateResult == -2)
				{
					errorMsg.put("message2",_mapping.getTextDescription("admin.error.you are trying to modify is already associated with the IP")+" ("+"<b>"+IP+"</b>"+") "+_mapping.getTextDescription("admin.error.in the following manner")+"."+"<br>"+"<br>"+"<center><table border='1'  cellspacing='2' cellpadding='3' width='50%'><tr><td width='50%' style='text-align:left;font-size:12'><strong>&nbsp;"+_mapping.getTextDescription("admin.common.IP")+"</strong></td><td width='50%' style='text-align:left;font-size:12'><strong>&nbsp;"+_mapping.getTextDescription("admin.common.Host/Nick name")+"</strong></td></tr><tr><td width='50%' style='text-align:left;font-size:12'>&nbsp;"+IP+"</td><td width='50%' style='text-align:left;font-size:12'>&nbsp;"+old_name+"</td></tr></table></center><br><center>"+_mapping.getTextDescription("admin.error.As the nick name is case insensitive, please use the old nick name")+"(<b>" + old_name + "</b>).</center><br>");
				}
				else
				{
					errorMsg.put("message2",_mapping.getTextDescription("admin.error.you are trying to modify is already associated with the IP")+" ("+"<b>"+IP+"</b>"+") "+_mapping.getTextDescription("admin.error.in the following manner")+"."+"<br>"+"<br>"+"<center><table border='1'  cellspacing='2' cellpadding='3' width='50%'><tr><td width='50%' style='text-align:left;font-size:12'><strong>&nbsp;"+_mapping.getTextDescription("admin.common.IP")+"</strong></td><td width='50%' style='text-align:left;font-size:12'><strong>&nbsp;"+_mapping.getTextDescription("admin.common.Host/Nick name")+"</strong></td></tr><tr><td width='50%' style='text-align:left;font-size:12'>&nbsp;"+IP+"</td><td width='50%' style='text-align:left;font-size:12'>&nbsp;"+old_name+"</td></tr></table></center><br><center>"+_mapping.getTextDescription("admin.error.Please use another nick name")+"."+"</center><br>");
				}
				rootJson.put("error",errorMsg);

				auditLogThread.setValue("Activity","Modify Remote Agent");
				auditLogThread.setCurrentValue("ColumnName","Agent Not Modified");
				auditLogThread.setCurrentValue("Nick name",old_name);
				auditLogThread.setValue("Description","Remote agent has not been modified as this nick name is used by another remote agent");
				auditLogThread.sendItToDB();
			}
			else if (updateResult == 0)
			{
				String description = null;
				rootJson.put("requestStatus","success");
				resultMsg.put("title",_mapping.getTextDescription("admin.server.Remote agent configuration"));
				if(booleanValue != null && booleanValue.equals("true"))
				{
					resultMsg.put("message1",_mapping.getTextDescription("admin.server.The remote agent")+"&nbsp;"+_mapping.getTextDescription("admin.server.has been configured  successfully")+"<br><br>"+_mapping.getTextDescription("admin.server.The external agent")+"&nbsp;"+_mapping.getTextDescription("admin.server.has been configured  successfully")+".");
					description = "Remote agent and external agent ("+old_name+") has been modified";
				}
				else
				{
					resultMsg.put("message1",_mapping.getTextDescription("admin.server.The remote agent")+"&nbsp;"+_mapping.getTextDescription("admin.server.has been configured  successfully")+".");
					description = "Remote agent ("+old_name+") has been modified";
				}
				rootJson.put("result",resultMsg);

				auditLogThread.setValue("Activity","Modify Remote Agent");
				//auditLogThread.setCurrentValue("ColumnName","Modified Agent");
				auditLogThread.setPreviousValue("Nick Name",old_name);
				auditLogThread.setCurrentValue("Nick Name",s_hostname);
				auditLogThread.setValue("Description",description);
				auditLogThread.sendItToDB();
			}
		}
		else if (old_ip.equals(s_hostip))
		{
			rootJson.put("requestStatus","success");
			resultMsg.put("title",_mapping.getTextDescription("admin.server.Remote agent configuration"));
			resultMsg.put("message1",_mapping.getTextDescription("admin.server.The remote agent")+"&nbsp;"+"'"+s_hostname+"'"+"&nbsp;"+_mapping.getTextDescription("admin.server.has been updated successfully")+".");
			rootJson.put("result",resultMsg);
		}
		if(toExtAgnt.equals("true"))
		{
			rootJson.put("requestStatus","success");
			rootJson.put("toExternalModify","true");
			resultMsg.put("title",_mapping.getTextDescription("admin.server.Remote agent configuration"));
			rootJson.put("result",resultMsg);
		}
	}
	if(s_mode.equalsIgnoreCase("del")) // Delete Remote Agent
	{
		Vector sess_vec = new Vector();
		String delResult =  remAgntObj.delete(s_eagent);
		if(delResult.indexOf("#") != -1)
		{
			delResult = delResult.substring(0,delResult.indexOf("#"));
		}
		boolean isAgentdeleted = delResult.equalsIgnoreCase("1")?true:false;
		if (isAgentdeleted)
		{
			rootJson.put("requestStatus","success");
			resultMsg.put("title",_mapping.getTextDescription("admin.server.Remote agent configuration"));

			if(extList.contains(s_eagent))
			{
				rootJson.put("doubleAlert","true");
				resultMsg.put("message1",_mapping.getTextDescription("admin.server.The remote agent")+"&nbsp;"+"'"+s_eagent+"'"+"&nbsp;" +_mapping.getTextDescription("admin.server.has been deleted successfully")+".<br><br><center>"+_mapping.getTextDescription("admin.server.An external agent also exists with same configuration")+". "+_mapping.getTextDescription("admin.server.If you want to delete that agent too")+". "+_mapping.getTextDescription("admin.common.Please click OK")+".");
			}
			else
			{
				resultMsg.put("message1",_mapping.getTextDescription("admin.server.The remote agent")+"&nbsp;"+"'"+s_eagent+"'"+"&nbsp;"+_mapping.getTextDescription("admin.server.has been deleted successfully")+".");
			}
			rootJson.put("result",resultMsg);

			auditLogThread.setValue("Activity","Delete Remote Agent");
			auditLogThread.setCurrentValue("ColumnName","Deleted Agent");
			auditLogThread.setCurrentValue("Agent Host/Nick Name",s_eagent);
			auditLogThread.setValue("Description","Remote agent has been deleted");
			auditLogThread.sendItToDB();
		}
		else if (delResult.equals("eG_CLI_Err_0038"))
		{
			if (extList.contains(s_eagent))
			{
				rootJson.put("doubleAlert","true");
			}
			rootJson.put("requestStatus","failed");
			errorMsg.put("title",_mapping.getTextDescription("admin.error.Delete remote agent"));
			errorMsg.put("message1",_mapping.getTextDescription("admin.error.This remote agent has been used as an internal agent to one or more hosts")+". "+_mapping.getTextDescription("admin.error.It needs to be disassociated as the internal agent from the host(s)")+". "+_mapping.getTextDescription("admin.error.Go to the Components Add/Modify page to perform this action before deleting this agent")+".");
			rootJson.put("error",errorMsg);

			/* auditlog - start */
			auditLogThread.setValue("Activity","Delete Remote Agent");
			auditLogThread.setCurrentValue("ColumnName","Remote Agent Not Deleted");
			auditLogThread.setCurrentValue("Host/Nick name",s_eagent);
			auditLogThread.setValue("Description","Remote agent has not been deleted since it is assigned as an internal agent to one or more hosts");
			auditLogThread.sendItToDB();
			/* auditlog - end */
		}
		else
		{
			if (extList.contains(s_eagent))
			{
				rootJson.put("doubleAlert","true");
			}
			rootJson.put("requestStatus","failed");
			errorMsg.put("title",_mapping.getTextDescription("admin.error.Delete remote agent"));
			errorMsg.put("message1",_mapping.getTextDescription("admin.error.Remote agent is been used by host(s)")+". "+_mapping.getTextDescription("admin.error.This remote agent needs to be disassociated from the host(s) it is monitoring")+". "+_mapping.getTextDescription("admin.error.Go to the Associate Hosts Page to perform this action before deleting this agent")+".");
			rootJson.put("error",errorMsg);

			auditLogThread.setValue("Activity","Delete Remote Agent");
			auditLogThread.setCurrentValue("Agent Host/Nick Name",s_eagent);
			auditLogThread.setValue("Description","Remote agent has not been deleted as it is being used by host(s)");
			auditLogThread.sendItToDB();
		}
	}
	out.println(rootJson.toString());
%>



