<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import="com.egurkha.admin.mfa.AllUsers"%>
<%@ page import="com.egurkha.admin.mfa.EgMailHelper"%>
<%@ page import="com.egurkha.admin.mfa.GoogleAuthenticator"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control", "no-store");
	response.setHeader("Pragma", "no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	JSONObject rootJson = new JSONObject();
	String requestFrom = request.getParameter("requestFrom");

	if (requestFrom != null && requestFrom.equalsIgnoreCase("turnoffautologin"))
	{
		IniFile uiIniWr = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir+"eg_ui.ini",true);
		uiIniWr.setValue("LOGIN","AUTHENTICATION","Yes");
		uiIniWr.saveFile();
		EgConfigFilesSync.releaseInstance(uiIniWr);
		rootJson.put("success","true");
	}
	else if (requestFrom != null && requestFrom.equalsIgnoreCase("update2faConfig"))
	{
		rootJson.put("success","false");
		try
		{
			boolean isAuditChange = false;
			String displayName = "";
			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","Manager Settings");
			auditLogThread.setValue("Activity","Two Factor Authentication");

			IniFile egMFAIniFile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_mfa.ini",true);
			String prevTFAEnalbeFlagVal = egMFAIniFile.getValue("2FA_SETTINGS","Is2FAEnabled");
			String prevTFAOptionFlagVal = egMFAIniFile.getValue("2FA_SETTINGS","TwoFAOptionFlag");
			String prevTFAOTPModeFlagVal = egMFAIniFile.getValue("2FA_SETTINGS","TwoFAOTPModeFlag");
			String twofaEnableFlagVal = request.getParameter("twofaEnableFlagVal");
			String twofaOptionFlagVal = request.getParameter("twofaOptionFlagVal");
			String twofaOTPModeFlagVal = request.getParameter("twofaOTPModeFlagVal");

			if (prevTFAEnalbeFlagVal.trim().length() == 0)
			{
				prevTFAEnalbeFlagVal = "-";
			}
			if (prevTFAOptionFlagVal.trim().length() == 0)
			{
				prevTFAOptionFlagVal = "-";
			}
			if (prevTFAOTPModeFlagVal.trim().length() == 0)
			{
				prevTFAOTPModeFlagVal = "-";
			}
			
			if (!prevTFAEnalbeFlagVal.equalsIgnoreCase(twofaEnableFlagVal))
			{
				displayName = "Enalbe Two Factor Authentication(2FA)";
				isAuditChange = true;
				auditLogThread.setPreviousValue(displayName,prevTFAEnalbeFlagVal);
				auditLogThread.setCurrentValue(displayName,twofaEnableFlagVal);
			}

			if (!prevTFAOptionFlagVal.equalsIgnoreCase(twofaOptionFlagVal))
			{
				String tempOptionFlag = "";
				if (prevTFAOptionFlagVal.equalsIgnoreCase("c"))
				{
					prevTFAOptionFlagVal = "Yes";
				}
				else if (prevTFAOptionFlagVal.equalsIgnoreCase("o"))
				{
					prevTFAOptionFlagVal = "No";
				}

				if (twofaOptionFlagVal.equalsIgnoreCase("c"))
				{
					tempOptionFlag = "Yes";
				}
				else if (twofaOptionFlagVal.equalsIgnoreCase("o"))
				{
					tempOptionFlag = "No";
				}
				displayName = "Enforce 2FA as a enterprise security standard";
				isAuditChange = true;
				auditLogThread.setPreviousValue(displayName,prevTFAOptionFlagVal);
				auditLogThread.setCurrentValue(displayName,tempOptionFlag);
			}

			if (!prevTFAOTPModeFlagVal.equalsIgnoreCase(twofaOTPModeFlagVal))
			{
				String tempOtpVal1 = prevTFAOTPModeFlagVal;
				if (tempOtpVal1.equalsIgnoreCase("ga"))
				{
					tempOtpVal1 = "Google Authenticator";
				}

				String tempOtpVal2 = twofaOTPModeFlagVal;
				if (tempOtpVal2.equalsIgnoreCase("ga"))
				{
					tempOtpVal2 = "Google Authenticator";
				}
				displayName = "OTP Mode";
				isAuditChange = true;
				auditLogThread.setPreviousValue(displayName,tempOtpVal1);
				auditLogThread.setCurrentValue(displayName,tempOtpVal2);
			}

			egMFAIniFile.setValue("2FA_SETTINGS","Is2FAEnabled",twofaEnableFlagVal);
			egMFAIniFile.setValue("2FA_SETTINGS","TwoFAOptionFlag",twofaOptionFlagVal);
			egMFAIniFile.setValue("2FA_SETTINGS","TwoFAOTPModeFlag",twofaOTPModeFlagVal);

			if (twofaOptionFlagVal != null && twofaOptionFlagVal.equalsIgnoreCase("c")) // compulsory
			{
				AllUsers obj = new AllUsers();
				HashMap allRegUsrs = obj.getAllRegisteredUsrs();
				if (allRegUsrs.size() > 0)
				{
					Iterator itr = allRegUsrs.keySet().iterator();
					while (itr.hasNext())
					{
						String userID = (String)itr.next();
						String dispName = "";
						if (userID.equalsIgnoreCase("egsm"))
						{
							continue;
						}
						if (userID.indexOf("/Grp/") != -1)
						{
							String grpDelimiter = "/Grp/";
							int idx = userID.indexOf(grpDelimiter);
							String str_uname_A = userID.substring(0,idx);
							int nextIdx = idx + grpDelimiter.length();
							String str_uname_B = userID.substring(nextIdx);
							dispName = str_uname_A + "/" + str_uname_B + " (Group)";
						}
						else
						{
							dispName = userID;
						}

						if (userID != null && !userID.startsWith("samlsso/"))
						{
							String userMailID = (String)allRegUsrs.get(userID);
							String encryptedUserID = EgCrypt.encrypt(userID.toLowerCase());

							egMFAIniFile.setValue("2FAEnabledUsers",encryptedUserID,encryptedUserID);
							String secretKey = EgCrypt.decrypt(egMFAIniFile.getValue(encryptedUserID,"SecretKey"));
							String otpModeIniVal = EgCrypt.decrypt(egMFAIniFile.getValue(encryptedUserID,"EnabledMode"));

							if (secretKey.trim().length() == 0)
							{
								secretKey = GoogleAuthenticator.getRandomSecretKey();
								String encryptedSecretKey = EgCrypt.encrypt(secretKey);
								egMFAIniFile.setValue(encryptedUserID,"SecretKey",encryptedSecretKey);
							}

							if (!otpModeIniVal.equalsIgnoreCase(twofaOTPModeFlagVal))
							{
								egMFAIniFile.setValue(encryptedUserID,"EnabledMode",EgCrypt.encrypt(twofaOTPModeFlagVal));

								if (twofaOTPModeFlagVal != null && twofaOTPModeFlagVal.equalsIgnoreCase("ga") && userMailID != null && userMailID.trim().length() > 0)
								{
									String mailSubject = "Two Factor Authentication";
									String bodyContent = "2-step verification has been enforced as the security standard enterprise-wide, for securing accesses to the eG Enterprise system. The secret key for your eG Enterprise user name <b>"+dispName+"</b> is <b>"+secretKey+"</b>. Please refer to the attached document to know how to register this secret key in the Google Authenticator app for generating a time-based OTP. Use the OTP generated by Google authenticator as verification code to validate your eG Enterprise login.";

									EgMailHelper mailObj = new EgMailHelper(userMailID);
									mailObj.setAttachmentFile(EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/docs/GoogleAuthenticatorGuide.docx");
									int mailStatus = mailObj.sendMail(mailSubject, bodyContent);
								}
								else if (twofaOTPModeFlagVal != null && twofaOTPModeFlagVal.equalsIgnoreCase("mail") && userMailID != null && userMailID.trim().length() > 0)
								{
									String mailSubject = "Two Factor Authentication";
									String bodyContent = "2-step verification has been enforced as the security standard enterprise-wide, for securing accesses to the eG Enterprise system. When logging into the eG web console, use the time-based verification code sent to this email ID to validate your user login.";

									EgMailHelper mailObj = new EgMailHelper(userMailID);
									int mailStatus = mailObj.sendMail(mailSubject, bodyContent);
								}
							}
						}
					}
				}
			}
			egMFAIniFile.saveFile();
			EgConfigFilesSync.releaseInstance(egMFAIniFile);

			if (isAuditChange)
			{
				auditLogThread.setValue("Description","2FA settings have been configured successfully");
				auditLogThread.sendItToDB();
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		rootJson.put("success","true");
	}
	out.println(rootJson.toString());
%>



