<%
/*******************************************************************************
*   Name                        :   egPrintMaintenanceAnalysisData.jsp
*   Purpose                 :   print page for Maintenance Analysis
*   Version                     :   4.3
*   Created                 :   15.09.2008
*   Author                      :   Antony & Team
*   Design Changes  :   Jaiwin
*******************************************************************************/
%>
<%@	taglib prefix =	"egui" uri = "../../../WEB-INF/eg-taglib.tld"	%>
<%@ include file= "../../EgTrackerAJSON.jsp"%>
<%@ page import = "com.egurkha.admin.*" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import="com.eg.* "%>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page import = "java.util.*" %>
<%@	page import="com.egurkha.util.*"%>
<%@ page import="com.eg.EgDateInfo" %>
<%@ page import="java.text.SimpleDateFormat"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%  
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	IniUI iniUI = IniUI .getInstance();
    //String homepageLogo=iniUI.getMonitorHomeLogo().trim();
	String homepageLogo=iniUI.getMonitorHomeLogo();
	if(iniUI.isHKTThemeEnabled())
	{
		homepageLogo = iniUI.getHKTReporterLogo();
	}
	String  option=request.getParameter("option");
	String element=request.getParameter("element");
	String testElement=request.getParameter("testElement");
	String descElement=request.getParameter("descElement");
	String day=request.getParameter("day");
	String dateOfMonth=request.getParameter("dateOfMonth");
	String startDate=request.getParameter("startDate");
	String startHr=request.getParameter("startHr");
	String endDate=request.getParameter("endDate");
	String endHr=request.getParameter("endHr");
	String timePeriod=request.getParameter("timePeriod");
	int hostTotal=0;
	int compTotal=0;
	int testTotal=0;
	int hostTestTotal=0;
	int compDescTotal=0;
	int compHostTotal=0;
	int descHostTotal=0;
	String compName="";
	if(session.getAttribute("paramForAnalysis")!=null) 
	{
		session.removeAttribute("paramForAnalysis");
	}
	String tmp=(String)request.getQueryString();
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	String htmlFileName =mngrIProc+"/final/admin/getAnalysisData.jsp;jsessionid="+session.getId()+"?"+tmp+"&print=pdfpage";
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	User usr = UserRegistry.getInstance().getUser(session.getId());
	String userDtFormat = usr.getUserDateFormat();
	if(userDtFormat != null && userDtFormat.length() > 0)
	{
		if(userDtFormat.equalsIgnoreCase("default"))
			userDtFormat = currentDateFormat;
	}
	
	EgDateInfo date = new EgDateInfo();
	Date locdate = new Date(date.egetUTCDate(false));			
	SimpleDateFormat mdyFormat = new SimpleDateFormat("MM/dd/yyyy");
	String stDate = mdyFormat.format(locdate);	

	EgMaintenanceUtility egM=new EgMaintenanceUtility(sessionID,u_rs);
	egM.setUserDateFormat(userDtFormat);
	//session.setAttribute("PDF_URL",htmlFileName);
	session.setAttribute("REPORT_NAME","Maintenance_policy");
	//session.setAttribute("paramForAnalysis",tmp);
	session.setAttribute("paramforTab",request.getQueryString());
	String query="option="+option+"&element="+element+"&testElement="+testElement;
	Hashtable policyTimeline = new Hashtable();
	Hashtable  hostsUnderMaintenance=new Hashtable();
	Hashtable  componentsUnderMaintenance=new Hashtable();
	Hashtable  testsUnderMaintenance=new Hashtable();
	Hashtable  hostTestsUnderMaintenance=new Hashtable();
	Hashtable  componentTestsUnderMaintenance=new Hashtable();
	//*******for Descriptor and descriptors for component*********
	Hashtable descriptorUnderMaintenance=new Hashtable();
	Hashtable componentDescriptorUnderMaintenance=new Hashtable();
	//************************************************************
	Hashtable  analysisData=new Hashtable();
	Hashtable tmp_analysisData = new Hashtable();
	String dispTitle="";
	String columnName="";
	Vector data=null;
	boolean isData=false;
		int dataSize=0;
	String userID = _user.getLoginID();
	EgRoleInfo roleInfo = EgRoleInfo.getInstance(sessionID,userID);
	String elementDisplay = element; // Limited admin
	elementDisplay = egM.getPolicyDisplayName(elementDisplay,!roleInfo.hasAllComponentAccess());
	
	if(option!=null && option.equals("All")) 
	{
		hostsUnderMaintenance=egM.getAllHostsUnderMaintenance("All Hosts");
		componentsUnderMaintenance=egM.getAllComponentsUnderMaintenance("All Components");
		testsUnderMaintenance=egM.getAllTestsUnderMaintenance("All Tests");
		hostTestsUnderMaintenance=egM.getAllHostTestsUnderMaintenance("All Tests");
		componentTestsUnderMaintenance=egM.getAllComponentTestsUnderMaintenance("All Tests");
		/*****************************************/
		descriptorUnderMaintenance=egM.getAllDescriptorsUnderMaintenance("All Descriptors");
		componentDescriptorUnderMaintenance=egM.getAllComponentDescriptorsUnderMaintenance("All Descriptor Comp");
		/*****************************************/
		data=new Vector();
		data.add(hostsUnderMaintenance);
		data.add(componentsUnderMaintenance);
		data.add(testsUnderMaintenance);
		data.add(hostTestsUnderMaintenance);
		data.add(componentTestsUnderMaintenance);
		/*******************************************/
		data.add(descriptorUnderMaintenance);
		data.add(componentDescriptorUnderMaintenance);
		/*******************************************/
		if(hostsUnderMaintenance.size()>0 || componentsUnderMaintenance.size()>0 || testsUnderMaintenance.size()>0 || hostTestsUnderMaintenance.size()>0 || componentTestsUnderMaintenance.size()>0 || descriptorUnderMaintenance.size()>0 || componentDescriptorUnderMaintenance.size()>0)
			isData=true;
	}
	else if(option!=null && option.equals("Component")) 
	{
		analysisData=egM.getAllComponentsUnderMaintenance(element);		
		dispTitle="Components Under Maintenance";
		columnName="Component Name";
	} 
	else if(option!=null && option.equals("Host")) 
	{
		analysisData=egM.getAllHostsUnderMaintenance(element);		
		dispTitle="Hosts Under Maintenance";
		columnName="Host Name";
	}
	else if(option!=null && option.equals("Test")) 
	{
		if(element!=null && element.equals("All Tests"))
		{
			analysisData=egM.getAllTestsUnderMaintenance(element);
		}
		else
		{
			analysisData=egM.getAllTestsUnderMaintenance("#"+element);
		}
		dispTitle="Tests Under Maintenance";
		columnName="Test Name";
	}
	else if(option!=null && option.equals("Test For Host")) 
	{
		if(element!=null && element.equals("All Tests"))
		{
			analysisData=egM.getAllHostTestsUnderMaintenance(element);
		}
		else
		{
			analysisData=egM.getAllHostTestsUnderMaintenance(testElement+"#"+element);
			//analysisData=egM.getMaintenanceInfoForElement(testElement,element);
		}
		dispTitle="Host Tests Under Maintenance";
		columnName="Test Name";
	}
	else if(option!=null && option.equals("Test For Component")) 
	{
		if(element!=null && element.equals("All Tests"))
		{
			analysisData=egM.getAllComponentTestsUnderMaintenance(element);
		}
		else
		{
			if(testElement!=null && testElement.indexOf(":")==-1)
			{
				testElement=testElement+":NULL";
			}
			analysisData=egM.getAllComponentTestsUnderMaintenance(testElement+"#"+element);
			//analysisData=egM.getMaintenanceInfoForElement(testElement,element);
		}
		dispTitle="Component Tests Under Maintenance";
		columnName="Test Name";
	}
	else if(option!=null && option.equals("Policy")) 
	{
		policyTimeline = (Hashtable)egM.getPolicyTimelines(element);
		hostsUnderMaintenance=egM.getAllHostsUnderMaintenanceForPolicy(element);
		componentsUnderMaintenance=egM.getAllComponentsUnderMaintenanceForPolicy(element);
		testsUnderMaintenance=egM.getAllTestsUnderMaintenanceForPolicy(element);
		hostTestsUnderMaintenance=egM.getAllHostTestsUnderMaintenanceForPolicy(element);
		componentTestsUnderMaintenance=egM.getAllComponentTestsUnderMaintenanceForPolicy(element);
		descriptorUnderMaintenance=egM.getAllDescriptorsUnderMaintenanceForPolicy(element);
		componentDescriptorUnderMaintenance=egM.getAllDescriptorForComponentUnderMaintenanceForPolicy(element);
		data=new Vector();
		data.add(hostsUnderMaintenance);
		data.add(componentsUnderMaintenance);
		data.add(testsUnderMaintenance);
		data.add(hostTestsUnderMaintenance);
		data.add(componentTestsUnderMaintenance);
		data.add(descriptorUnderMaintenance);
		data.add(componentDescriptorUnderMaintenance);
			
		if(hostsUnderMaintenance.size()>0 || componentsUnderMaintenance.size()>0 || testsUnderMaintenance.size()>0 || hostTestsUnderMaintenance.size()>0 || componentTestsUnderMaintenance.size()>0 || descriptorUnderMaintenance.size()>0 || componentDescriptorUnderMaintenance.size()>0)
			isData=true;
	}
	else    if(option!=null && option.equals("Time Constraints")) 
	{
		data=new Vector();
		if(element!=null&& element.equals("FDM")) 
		{
			data=egM.getMaintenanceDetailsForFDM();
		}
		else if(element!=null&& element.equals("LDM")) 
		{
			data=egM.getMaintenanceDetailsForLDM();
		}
		else if(element!=null&& element.equals("*")) 
		{
			data=egM.getMaintenanceDetailsForDaily();
		}
		else if(element!=null&& element.equals("Day of Week")) 
		{
			data=egM.getMaintenanceDetailsForDay(day);
		}
		else if(element!=null&& element.equals("Date of Month")) 
		{
			data=egM.getMaintenanceDetailsForDateOfMonth(dateOfMonth);
		}
		else if(element!=null&& element.equals("Date")) 
		{
			data=egM.getMaintenanceDetailsForTimePeriod(startDate,startHr,endDate,endHr);
		}
		if(data!=null && data.size()>0)
			isData=true;
	}
	else if(option!=null && option.equals("Descriptor"))
	{
		if(element!=null && element.equals("All Descriptors"))
		{
			analysisData=egM.getAllDescriptorsUnderMaintenance(element);
		}
		else
		{
			analysisData=egM.getAllDescriptorsUnderMaintenance("#"+element);
		}
		dispTitle="Descriptors Under Maintenance";
		columnName="Descriptors";
	}
	else if(option!=null && option.equals("Descriptor For Component"))
	{
		if(element!=null && element.equals("All Descriptor Comp"))
		{
			analysisData=egM.getAllComponentDescriptorsUnderMaintenance(element);
		}
		else
		{	
			EgSpecsInfo specs = new EgSpecsInfo("manager");
			String testName = descElement.substring(0,descElement.indexOf(":"));
			boolean isPortRelevantForTest=specs.isPortRelevantForTest(testName);
			String Discomp=element;
			if(!isPortRelevantForTest && (Discomp!=null && !Discomp.equals("")))
			{			
				Discomp = Discomp.substring(0,Discomp.lastIndexOf(":"))+":NULL";
			}
			analysisData=egM.getAllComponentDescriptorsUnderMaintenance(Discomp+"#"+descElement);
			//analysisData=egM.getMaintenanceInfoForElementDesc(element,descElement);
		}
		dispTitle="Descriptor For Component Under Maintenance";
		columnName="Descriptors";
	}
	EgDbInfo dbInfo = new EgDbInfo("manager");
	String fontStyleDblSingl="";
	if((dbInfo.doubleByteEnabled))
	{
		fontStyleDblSingl = "multi_font";
	}
	else
	{
		fontStyleDblSingl = "";
	}
%>
<html>
	<head>
		<title>Maintenance Analysis</title>


<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightTheme.css" />
<style>

@media print {body {-webkit-print-color-adjust: exact;}}

body{font-size:11px;line-height:1.5em;color:#2a292a;background:#fff}
header{font-size:15px;}
.formLabel {font-size:12px;}
.formValue {font-weight:500;font-size:12px;}
b{font-weight:500;font-size:11px;}

/*  table tr td{font-size:11px;padding:4px;}  */

.printTable{border: 1px solid #c3c3c3; border-collapse: collapse;}

.printTable tr th{border: 0px solid #c3c3c3;padding:4px;background-color:#e2e2e2;font-weight:500;font-size:11px;}
.printTable tr td{border: 0px solid #c3c3c3;padding:4px;font-size:11px;line-height:1.5em;color:#2a292a;}

.printTable2{border: 1px solid #c3c3c3; border-collapse: collapse;}

.printTable2 tr th{border: 1px solid #c3c3c3;padding:4px;background-color:#e2e2e2;font-weight:500;font-size:11px;}
.printTable2 tr td{border: 1px solid #c3c3c3;padding:4px;font-size:11px;line-height:1.5em;color:#2a292a;}

.printTable tr td.printTableHeader{font-weight:500;border: 1px solid #c3c3c3;text-align:left;background-color:#cdcdcd;padding:4px;font-size:12px;}

.printTableHeader{font-weight:500;border: 1px solid #c3c3c3;text-align:left;background-color:#cdcdcd;padding:4px;font-size:12px;}
.printTableHeader2{font-weight:500;border: 1px solid #c3c3c3;text-align:left;background-color:#dcdcdc;padding:4px;font-size:12px;}

</style>

<script>
	function printData()
	{
		window.print();
	}
</script>
</head>
<body style="padding:10px">

<%
		Hashtable HostData=new Hashtable();
		Hashtable CompData=new Hashtable();
		Hashtable TestData=new Hashtable();
		Hashtable HostTestData=new Hashtable();
		Hashtable CompTestData=new Hashtable();
		/**************************************/
		Hashtable descriptorData=new Hashtable();
		Hashtable compDescData=new Hashtable();
		/**************************************/
		int noOfElemenstAssociated=0;
		String sumelement="";
		if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("fdm"))
		{
			sumelement="First Day of the Month";
		}
		else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("ldm"))
		{
			sumelement="Last Day of the Month";
		}
		else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("*"))
		{
			sumelement="Daily";
		}
		else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("date"))
		{
			startDate=StringUtils.replace(startDate,',',' ');
			endDate=StringUtils.replace(endDate,',',' ');
			sumelement="From " +startDate+" To "+ endDate;
		}
		else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("day of week"))
		{
			sumelement=egM.DayForDescription(day);
		}
		else
		{
			sumelement=elementDisplay;
		}


		String elementForTitle=sumelement;
		if(data!=null && data.size()>0) 
		{
			HostData=(Hashtable)data.get(0);
			CompData=(Hashtable)data.get(1);
			TestData=(Hashtable)data.get(2);
			HostTestData=(Hashtable)data.get(3);
			CompTestData=(Hashtable)data.get(4);
			/********************************/
			descriptorData=(Hashtable)data.get(5);
			compDescData=(Hashtable)data.get(6);
			/********************************/
			if(option!=null && option.equals("Policy")) 
			{
				ArrayList HostList = (ArrayList)HostData.get(element);
				if(HostList!=null && HostList.size()>0)
					noOfElemenstAssociated++;
				ArrayList compList = (ArrayList)CompData.get(element);
				if(compList!=null && compList.size()>0)
					noOfElemenstAssociated++;
				ArrayList testList = (ArrayList)TestData.get(element);
				if(testList!=null && testList.size()>0)
					noOfElemenstAssociated++;
				ArrayList HostTestList = (ArrayList)HostTestData.get(element);
				if(HostTestList!=null && HostTestList.size()>0)
					noOfElemenstAssociated++;
				ArrayList compTestList = (ArrayList)CompTestData.get(element);
				if(compTestList!=null && compTestList.size()>0)
					noOfElemenstAssociated++;
				ArrayList descList = (ArrayList)descriptorData.get(element);
				if(descList!=null && descList.size()>0)
					noOfElemenstAssociated++;
				ArrayList compDescList = (ArrayList)compDescData.get(element);
				if(compDescList!=null && compDescList.size()>0)
					noOfElemenstAssociated++;
			}
			else
			{
				if(HostData!=null && HostData.size()>0)
					noOfElemenstAssociated++;

				if(CompData!=null && CompData.size()>0)
					noOfElemenstAssociated++;

				if(TestData!=null && TestData.size()>0)
					noOfElemenstAssociated++;

				if(HostTestData!=null && HostTestData.size()>0)
					noOfElemenstAssociated++;

				if(CompTestData!=null && CompTestData.size()>0)
					noOfElemenstAssociated++;
				/*************************************************/
				if(descriptorData!=null && descriptorData.size()>0)
					noOfElemenstAssociated++;

				if(compDescData!=null && compDescData.size()>0)
					noOfElemenstAssociated++;
				/*************************************************/
			}
		}
		else if(analysisData!=null &&  analysisData.size()>0)
		{
			if(option!=null && option.equalsIgnoreCase("Host"))
			{
				HostData=analysisData;
			}
			else if(option!=null && option.equalsIgnoreCase("Component"))
			{
				CompData=analysisData;
			}
			else if(option!=null && option.equalsIgnoreCase("Test"))
			{
				TestData=analysisData;
				elementForTitle=_mapping.getTestDescription(element);
			}
			else if(option!=null && option.equalsIgnoreCase("Test For Host"))
			{
				HostTestData=analysisData;
				elementForTitle=_mapping.getTestDescription(element);
			}
			else if(option!=null && option.equalsIgnoreCase("Test For Component"))
			{
				CompTestData=analysisData;
				elementForTitle=_mapping.getTestDescription(element);
			}
			else if(option!=null && option.equalsIgnoreCase("Descriptor"))
			{
				descriptorData=analysisData;
				elementForTitle=_mapping.getTestDescription(element);
			}
			else if(option!=null && option.equalsIgnoreCase("Descriptor For Component"))
			{
				compDescData=analysisData;
				elementForTitle=_mapping.getTestDescription(element);
			}
		}
		

		if(HostData.keySet().size()>0 || CompData.keySet().size()>0 || TestData.keySet().size()>0 || HostTestData.keySet().size()>0 || CompTestData.keySet().size()>0 || descriptorData.keySet().size()>0 || compDescData.keySet().size()>0)
		{
				String sumtitle ="";
			if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("date"))
			{
				sumtitle = _mapping.getTextDescription("admin.mpolicy.Maintenance Summary");
			}
			else
			{
				sumtitle = _mapping.getTextDescription("admin.mpolicy.Maintenance Summary for ");
			}
			if(option!=null && option.equals("All"))
			{
				elementForTitle="All";
			}
%>
<table width="100%" cellpadding="0" cellspacing="0" border="0" >
	<tr>
		<td width="100%">
<%
			if(!StringUtils.isNull(homepageLogo))
			{	
%>
			<table cellpadding="0" cellspacing="0" border="0" width="100%" align="center">
				<tr>
					<td style="padding:5px 10px 10px 10px"><img src="<%=homepageLogo.trim()%>" border="0" /></td>
				</tr>
			</table>
<%
			}
%>
			<input type="hidden" id="datasize" name="datasize" value="<%=dataSize%>">
			<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #999;">
				<tr>
					<td style="padding:2px">
						<div style="float:left" > <header><egui:intnl text="admin.maintenance.MAINTENANCE ANALYSIS REPORT"/></header></div>

						<div style="float:right"><img class="iconPrinter mouse" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:printData()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
					</td>
				</tr>
			</table>
			<br/>
<%
			if((option!=null && (option.equals("All") || option.equals("Policy") || option.equals("Time Constraints"))) || (element!=null && (element.equals("All Elements") || element.equals("All Hosts") || element.equals("All Components") || element.equals("All Tests") || element.equals("All Descriptors") || element.equals("All Descriptor Comp")))) 
			{
%>
			<table width="100%"  cellpadding="0" cellspacing="0" border="0"  align="center" class="printTable">
				<tr>
					<td width="100%" align="left" class="printTableHeader" colspan="2"><%=sumtitle%><%= (elementForTitle==null?" All Elements":" "+elementForTitle)%></td>
				</tr>
				<tr>
					<th align="left" ><egui:intnl text="admin.mpolicy.Elements Under Maintenance"/></th>
					<th align="left" ><egui:intnl text="admin.mpolicy.Count"/></th>
				</tr>
<%
			if(HostData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList HostList = (ArrayList)HostData.get(element);
					if(HostList!=null && !HostList.isEmpty() && HostList.size()>0)
					{
%>
						<tr>
							<td><egui:intnl text="admin.mpolicy.Host"/></td>
							<td>
							<%=HostList.size()%>
						</td>
					</tr>				
<%
					}
				}
				else
				{
%>
					<tr>
						<td><egui:intnl text="admin.mpolicy.Host"/></td>
						<td>
<%					if(noOfElemenstAssociated>1)
					{
						hostTotal=HostData.keySet().size();
%>
							<%=HostData.keySet().size()%>
<%
					}
					else
					{
						hostTotal=HostData.keySet().size();
%>
							<%=HostData.keySet().size()%>
<%
					}
				
%>
					</td>
				</tr>
				
<%
				}
			}
			if(CompData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList compList = (ArrayList)CompData.get(element);
					if(compList!=null && !compList.isEmpty() && compList.size()>0)
					{
%>
					<tr>
						<td><egui:intnl text="admin.mpolicy.Component"/></td>
						<td>
							<%=compList.size()%>
						</td>
				</tr>
<%
					}
				}
				else
				{
%>
					<tr>
						<td><egui:intnl text="admin.mpolicy.Component"/></td>
						<td>
<%					if(noOfElemenstAssociated>1)
					{
						compTotal=CompData.keySet().size();
%>
							<%=CompData.keySet().size()%>
<%
					}
					else
					{
						compTotal=CompData.keySet().size();
%>
							<%=CompData.keySet().size()%>
<%
					}
%>
					</td>
				</tr>
<%
				}
			}
			if(TestData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList testList = (ArrayList)TestData.get(element);
					if(testList!=null && !testList.isEmpty() && testList.size()>0)
					{
%>
				<tr>
					<td><egui:intnl text="admin.mpolicy.Test"/></td>
					<td>	
					<%=testList.size()%>
										</td>
				</tr>
<%
					}
				}
				else
				{
%>
				<tr>
					<td><egui:intnl text="admin.mpolicy.Test"/></td>
					<td>
<%				if(noOfElemenstAssociated>1)
				{
					testTotal=TestData.keySet().size();
%>
							<%=TestData.keySet().size()%>
<%
				}
				else
				{
					testTotal=TestData.keySet().size();
%>
							<%=TestData.keySet().size()%>
<%
				}
%>
					</td>
				</tr>
<%
				}
			}
			if(HostTestData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList HostTestList = (ArrayList)HostTestData.get(element);
					if(HostTestList!=null && !HostTestList.isEmpty() && HostTestList.size()>0)
					{
%>
					<tr>
						<td><egui:intnl text="admin.mpolicy.Host/Test"/></td>
						<td>
						<%=HostTestList.size()%>
						</td>
				</tr>
<%
					}
				}
				else
				{
%>
				<tr>
					<td><egui:intnl text="admin.mpolicy.Host/Test"/></td>
					<td>
<%				if(noOfElemenstAssociated>1)
				{
					hostTestTotal=HostTestData.keySet().size();
%>
							<%=HostTestData.keySet().size()%>
<%
				}
				else
				{
					hostTestTotal=HostTestData.keySet().size();
%>
							<%=HostTestData.keySet().size()%>
<%
				}
%>
					</td>
				</tr>
<%
				}
			}
			if(CompTestData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList compTestList = (ArrayList)CompTestData.get(element);
					if(compTestList!=null && !compTestList.isEmpty() && compTestList.size()>0)
					{
%>
				<tr>
					<td><egui:intnl text="admin.mpolicy.Component/Test"/></td>
					<td>
						<%=compTestList.size()%>
					</td>
				</tr>
<%
					}
				}
				else
				{
%>
				<tr>
					<td><egui:intnl text="admin.mpolicy.Component/Test"/></td>
					<td>
<%				if(noOfElemenstAssociated>1)
				{
					compHostTotal=CompTestData.keySet().size();
%>
							<%=CompTestData.keySet().size()%>
<%
				}
				else
				{
					compHostTotal=CompTestData.keySet().size();
%>
							<%=CompTestData.keySet().size()%>
<%
				}
%>
					</td>
				</tr>
<%

				}
			}
			if(descriptorData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList descList = (ArrayList)descriptorData.get(element);
					if(descList!=null && !descList.isEmpty() && descList.size()>0)
					{
%>
				<tr>
					<td><egui:intnl text="admin.mpolicy.Descriptors"/></td>
					<td>
					<%=descList.size()%>
					</td>
				</tr>
<%
						
					}
				}
				else
				{
%>
				<tr>
					<td><egui:intnl text="admin.mpolicy.Descriptors"/></td>
					<td>
<%				if(noOfElemenstAssociated>1)
				{
					descHostTotal=descriptorData.keySet().size();
%>
							<%=descriptorData.keySet().size()%>
<%
				}
				else
				{
					descHostTotal=descriptorData.keySet().size();
%>
							<%=descriptorData.keySet().size()%>
<%
				}
%>
					</td>
				</tr>
<%
				}
			}
			if(compDescData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList compDescList = (ArrayList)compDescData.get(element);
					if(compDescList!=null && !compDescList.isEmpty() && compDescList.size()>0)
					{
%>
				<tr>
					<td><egui:intnl text="admin.mpolicy.Descriptor For Component"/></td>
					<td>
					<%=compDescList.size()%>
					</td>
				</tr>
<%
					}
				}
				else
				{
%>
				<tr>
					<td><egui:intnl text="admin.mpolicy.Descriptor For Component"/></td>
					<td>

<%				
				if(noOfElemenstAssociated>1)
				{
					compDescTotal=compDescData.keySet().size();
%>
							<%=compDescData.keySet().size()%>
<%
				}
				else
				{
					compDescTotal=compDescData.keySet().size();
%>
							<%=compDescData.keySet().size()%>
<%
				}
%>
					</td>
				</tr>
<%
				}
			}
%>
			</table>
			<br/>
<%
			}
			else if(element!=null && !element.equals("All Hosts") && !element.equals("All Components") && !element.equals("All Tests"))
			{
				boolean isActive=false;
				if(option!=null && option.equals("Test  For Component")  ||  option.equals("Test For Host") || option.equals("Descriptor For Component"))
				{
					if(option.equals("Descriptor For Component"))
					{
						isActive=egM.isServerElementInUnderMintenance("Test For Host",element,descElement);
					}
					else
					{
						isActive=egM.isServerElementInUnderMintenance("Test For Host",testElement,element);
					}
				}
				else if(option!=null && (option.equals("Test") || option.equals("Descriptor")))
				{
					isActive=egM.isServerElementInUnderMintenance("Test",element);
				}
				else
				{
					if(element!=null && element.indexOf("|dollar|")>0)
					{
						element = element.substring(0,element.indexOf("|dollar|"));
					}
					isActive=egM.isServerElementInUnderMintenance("Host",element);
				}

							String mstatustitle="";
							String melement=element;
							if(melement.endsWith(":NULL"))
							{
								melement = melement.substring(0,melement.indexOf(":NULL"));
							}

							if(option!=null && option.equals("Host"))
							{
								mstatustitle="Quick Maintenance Details For Host";
							}
							else if(option!=null && option.equals("Component"))
							{
								mstatustitle="Quick Maintenance Details For Component";
							}
							else if(option!=null && option.equals("Test"))
							{
								mstatustitle="Quick Maintenance Details For Test";
								melement=_mapping.getTestDescription(element);
							}
							else if(option!=null && option.equals("Test For Host"))
							{
								mstatustitle="Quick Maintenance Details For Host Test";
								melement=_mapping.getTestDescription(element);
							}
							else if(option!=null && option.equals("Test  For Component"))
							{
								mstatustitle="Quick Maintenance Details For Component Test";
								melement=_mapping.getTestDescription(element);
							}
							else if(option!=null && option.equals("Descriptor"))
							{
								mstatustitle="Quick Maintenance Details For Descriptor";
								String elem="";
								if(element!=null && element.indexOf(":")>0)
								{
									elem=element.substring(element.indexOf(":")+1);
								}
								melement=elem;
							}
							else if(option!=null && option.equals("Descriptor For Component"))
							{
								mstatustitle="Quick Maintenance Details For Descriptor For Component";
								String descElem="";
								if(element!=null && element.indexOf(":")>0)
								{
									descElem=descElement.substring(descElement.indexOf(":")+1);
								}
								melement=descElem;
							}
%>
			<table  cellpadding="0" cellspacing="0" border="0"  align="center" width="100%" class="printTable">
				<tr>
					<td  align="center" class="printTableHeader"><egui:intnl text="<%=\"admin.mpolicy.\"+mstatustitle%>"/> - <%=melement%></td>
				</tr>
				<tr>
					<td style="padding:10px">
						<table width="100%" border="0" align="left" cellpadding="0" class="printTable" cellspacing="0"  height="20"><col width="50%"><col width="50%">
							<!--tr>
								<th valign="top" align="left" colspan="2"><%=melement%></th>
							</tr>
							<tr>
								<td align="left"><%=_mapping.getTextDescription("admin.mpolicy.Status")%></td>
								<td valign="top" align="left">
<%									if(isActive) 
									{
%>
										<egui:intnl text="admin.mpolicy.Active"/>
<%
									} 
									else 
									{
%>
										<egui:intnl text="admin.mpolicy.Inactive"/>
<%
									}
%>
								</td>
							</tr!-->

<%			}
		}

if(option!=null && !option.equals("All") &&  !option.equals("Time Constraints") && !option.equals("Policy"))
{
	if(analysisData!=null && analysisData.size()>0) 
	{	
		String displayType = option;
		String displayElement1 = "";
		String displayElement2 = "";
		if(option!=null)
		{
			if(option.equals("Test For Host"))
			{
				displayElement1 = "Test";
				displayElement2 = "Host";
			}
			else if(option.equals("Test For Component"))
			{
				displayElement1 = "Test";
				displayElement2 = "Component";
			}
			else if(option.equalsIgnoreCase("Descriptor For Component"))
			{
				displayElement1 = "Descriptor";
				displayElement2 = "Component";
			}
		}
%>
		
		<table align="left" width="100%" cellspacing="0px" cellpadding="0px"><tr><td style="padding:10px 0px 0px 0px"><div style="padding:5px" class="printTableHeader"><egui:intnl text="<%=\"admin.mpolicy.\"+dispTitle%>"/></div></td></tr></table>

		<table class="printTable" border="0" align="left" width="100%" cellspacing="0px" cellpadding="0px">
			<thead>
				<tr>
<%
					if(displayType.equals("Test For Host") || displayType.equals("Test For Component") || displayType.equals("Descriptor For Component"))
					{
%>
					<th class="printTableHeader" align="left" style="height:25px;padding-left: 10px;"><egui:intnl text="<%=displayElement1%>"/></th>
					<th class="printTableHeader" align="left" style="height:25px;padding-left: 10px;"><egui:intnl text="<%=displayElement2%>"/></th>
					<th class="printTableHeader" align="left" style="height:25px;padding-left: 10px;"><div style="float:left;width:222px"><egui:intnl text="admin.mpolicy.Policy"/></div><div style="float:left;width:82px"><egui:intnl text="admin.mpolicy.Status"/> </div><div style="float:left;"><egui:intnl text="admin.mpolicy.Timeline"/> </div></th>
<%
					}
					else
					{
%>
					<th class="printTableHeader" align="left" style="height:25px;padding-left: 10px;"><egui:intnl text="<%=displayType%>"/></th>
					<th class="printTableHeader" align="left" style="height:25px;padding-left: 10px;"><div style="float:left;width:222px"><egui:intnl text="admin.mpolicy.Policy"/> </div><div style="float:left;width:82px"><egui:intnl text="admin.mpolicy.Status"/> </div><div style="float:left;"><egui:intnl text="admin.mpolicy.Timeline"/> </div></th>
<%
					}
%>
			</tr>
		</thead>
		<tbody>
<%
					Iterator mappitr=analysisData.keySet().iterator();	
					if(timePeriod!=null && timePeriod.equals("true")) 
					{
						
					}
					else
					{
						boolean trColor = true;

						while(mappitr.hasNext()) 
						{
							String mapkey=(String)mappitr.next();
							Hashtable policyDetailsTable = (Hashtable)analysisData.get(mapkey);
							String disp = mapkey;
							String orgHstName = "";							
							if(disp.endsWith(":NULL"))
							{									
								disp= disp.substring(0,disp.indexOf(":NULL"));
							}
							if(option!=null && option.equals("Test")) 
							{
								disp = _mapping.getTestDescription(disp);
							}
							String column = "";
							String hostName = "";
							if(disp!=null && disp.indexOf("#")>0)
							{								
								column = disp.substring(0,disp.indexOf("#"));
								hostName = disp.substring(disp.indexOf("#")+1);
								if(option.equals("Test For Host") || option.equals("Test For Component"))
								{
									column = _mapping.getTestDescription(column);
								}
							}
							else
							{
								column = disp;
							}

							//******--Repalcing--Hash--Starts--*****---//
							if(column!=null&& column.indexOf("|HASH|")>0)
							{
								column = StringUtils.replace(column,"|HASH|","#");
							}
							//******--Repalcing--Hash--Ends--*****---//
							orgHstName = disp;
							String evenTrColor = "";

							if (trColor)
							{
								trColor=false;
								evenTrColor = "#ffffff";
							}
							else
							{
								trColor=true;
								evenTrColor = "#f4f4f4";
							}
%>
			<tr style="background-color:<%=evenTrColor%>">
				<td><div><%=column%></div></td>
<%
							if(hostName!=null && !hostName.equals(""))
							{
%>
								
				<td><div><%=hostName%></div></td>	
										
<%
							}
%>
				<td style="padding:10px;" align="left">
					<div >
<%
							Iterator policyDetailsitr = policyDetailsTable.keySet().iterator();
							boolean trColor2 = true;
							while(policyDetailsitr.hasNext()) 
							{
								String policyNameWithStatus=(String)policyDetailsitr.next();
								
								String policyName= policyNameWithStatus.substring(0,policyNameWithStatus.lastIndexOf("|"));
								String status = policyNameWithStatus.substring(policyNameWithStatus.lastIndexOf("|")+1);
								if(status!=null && status.equals("true"))
								{
									status = _mapping.getTextDescription("admin.mpolicy.Active");
								}
								else
								{
									status = _mapping.getTextDescription("admin.mpolicy.Inactive");
								}
								if(policyName!=null && !policyName.equals(""))
								{
									String tmpDisplay = egM.getPolicyDisplayName(policyName,!roleInfo.hasAllComponentAccess(), true);
									policyName = tmpDisplay;
								}
								String evenTrColor2="";
									if (trColor2)
									{
										trColor2=false;
										evenTrColor2 = "#e8e8e8";
									}
									else
									{
										trColor2=true;
										evenTrColor2 = "#e1e1e1";
									}
%>
									<table border="0" width="100%" cellpadding="0px" cellspacing="0px" style="background-color:<%=evenTrColor2%>">
										<tbody>
											<tr>
												<td style="width:200px;border-right:0px !important">
<%
								Hashtable timelineTable = (Hashtable)policyDetailsTable.get(policyNameWithStatus);	
								String groupList = (String)timelineTable.get("groups");
								if(groupList!=null && !groupList.equals(""))
								{
%>
													<div><b>Groups:</b><%=groupList%></div><br>
<%
									
								}
%>
								<%=policyName%>
												</td>
												<td style="width:60px;border-right:0px !important">
													<%=status%>
												</td>
												<td >
													<div>
													<table  border="0" align="center" cellpadding="0px" cellspacing="0px" width="100%" ><col width="50%"><col width="50%" >
<%								
									Hashtable htDate = new Hashtable();
									Iterator timeItr=timelineTable.keySet().iterator();
									boolean trColor3 = true;
									while(timeItr.hasNext()) 
									{
										String colName = (String)timeItr.next();
										if(colName!=null && colName.equals("groups"))
										{
											
										}
										else
										{
											String dispCol="";	
											if(colName.equals("FDM"))
											{
												dispCol="First Day Of Month";
											}
											else if(colName.equals("LDM")) 
											{
												dispCol="Last Day Of Month";
											}
											else if(colName.equals("*")) 
											{
												dispCol="Daily";
											}
											else if(colName.startsWith("Every"))
											{
												String suffix = "th";
												if(colName.endsWith("1") || colName.endsWith("21") || colName.endsWith("31"))
												{
													suffix = "st";
												}
												else if(colName.endsWith("2") || colName.endsWith("22"))
												{
													suffix = "nd";
												}
												else if(colName.endsWith("3") || colName.endsWith("23"))
												{
													suffix = "rd";
												}
												dispCol = com.egurkha.util.StringUtils.replace(colName,"_"," ")+suffix+" day of the month";
											}
											else if(colName.startsWith("Sun") || colName.startsWith("Mon") || colName.startsWith("Tue") || colName.startsWith("Wed") || colName.startsWith("Thu") || colName.startsWith("Fri") || colName.startsWith("Sat")) 
											{
												if(colName!=null && colName.indexOf("$")>0 && colName.indexOf("_")>0)
												{
													String dayVal = colName.substring(0,colName.indexOf("$"));
													String week = colName.substring(colName.indexOf("$")+1);
													if(week.equalsIgnoreCase("week_1"))
													{
														week = "First";
													}
													else if(week.equalsIgnoreCase("week_2"))
													{
														week = "Second";
													}
													else if(week.equalsIgnoreCase("week_3"))
													{
														week = "Third";
													}
													else if(week.equalsIgnoreCase("week_4"))
													{
														week = "Fourth";
													}
													else if(week.equalsIgnoreCase("week_5"))
													{
														week = "Fifth";
													}

													dispCol=egM.DayForDescription(dayVal);
													dispCol = week+" week "+dispCol.toLowerCase()+" of the month";
												}
												else
												{
													dispCol=egM.DayForDescription(colName);
												}
											}
											else 
											{
												dispCol=colName.replace('|','-');
											}
											String strDate = "";
											endDate = "";
											Vector timelineVec = (Vector)timelineTable.get(colName);
											Vector val = new Vector();
											if(dispCol.indexOf("-")>0)
											{
												strDate = dispCol.substring(0,dispCol.indexOf("-"));
												endDate = dispCol.substring(dispCol.indexOf("-")+1);
												
												for(int i=0;i<timelineVec.size();i++)
												{
													String time = (String)timelineVec.get(i);
													String startTime=time.substring(0,time.indexOf("-"));
													String endTime=time.substring(time.indexOf("-")+1,time.length());
													String timeMsg= "";
													
													String strHr = startTime.substring(0,startTime.indexOf(":"));
													String strMin = startTime.substring(startTime.indexOf(":")+1);
													endHr = endTime.substring(0,endTime.indexOf(":"));
													String endMin = endTime.substring(endTime.indexOf(":")+1);
													
													String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
													EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr+":"+strMin,_user);
													String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
													EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr+":"+endMin,_user);	
													String start_Date = (String) converterStart.getDate(false);
													String end_Date = (String) converterEnd.getDate(false);

													start_Date = DateUtil.changeDateFormat(start_Date, "MM/dd/yyyy", userDtFormat);
													end_Date = DateUtil.changeDateFormat(end_Date, "MM/dd/yyyy", userDtFormat);
													dispCol = start_Date+"-"+end_Date;
													strHr = converterStart.getHour();
													endHr = converterEnd.getHour();
													strMin = converterStart.getMinute();
													endMin = converterEnd.getMinute();
													timeMsg=strHr+":"+strMin+"-"+endHr+":"+endMin;

													if(htDate!=null && htDate.containsKey(dispCol))
													{
														Vector existVector = (Vector)htDate.get(dispCol);
														existVector.add(timeMsg);
														htDate.put(dispCol, existVector);
													}
													else
													{
														val = new Vector();
														val.add(timeMsg);
														htDate.put(dispCol, val);
													}
												}
											}
											else
											{											
												for(int i=0;i<timelineVec.size();i++)
												{
													String time = (String)timelineVec.get(i);
													String startTime=time.substring(0,time.indexOf("-"));
													String endTime=time.substring(time.indexOf("-")+1,time.length());
													String timeMsg= "";
													if(strDate.equals("") && endDate.equals(""))
													{
														strDate = stDate;
														endDate = stDate;
													}
													if(!strDate.equals("") && !endDate.equals(""))
													{
														String strHr = startTime.substring(0,startTime.indexOf(":"));
														String strMin = startTime.substring(startTime.indexOf(":")+1);

														endHr = endTime.substring(0,endTime.indexOf(":"));
														String endMin = endTime.substring(endTime.indexOf(":")+1);

														String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
														EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr+":"+strMin,_user);
														String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
														EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr+":"+endMin,_user);
														
														strHr = converterStart.getHour();
														endHr = converterEnd.getHour();
														strMin = converterStart.getMinute();
														endMin = converterEnd.getMinute();
														timeMsg=strHr+":"+strMin+"-"+endHr+":"+endMin;
													}
													dispCol = _mapping.getTextDescription("admin.mpolicy."+dispCol);
													if(htDate!=null && htDate.containsKey(dispCol))
													{
														Vector existVector = (Vector)htDate.get(dispCol);
														existVector.add(timeMsg);
														htDate.put(dispCol, existVector);
													}
													else
													{
														val = new Vector();
														val.add(timeMsg);
														htDate.put(dispCol, val);
													}
												}
											}

										}
								}
								if(htDate!=null)
								{
									Set timeKeyset=htDate.keySet();
									Iterator timeKeysetItr=timeKeyset.iterator();
									while(timeKeysetItr.hasNext())
									{
										String key=(String)timeKeysetItr.next();
										Vector timeVec = (Vector)htDate.get(key);
										String evenTrColor3="";
										if (trColor3)
										{
											trColor3=false;
											evenTrColor3 = "#ffffff";
										}
										else
										{
											trColor3=true;
											evenTrColor3 = "#f4f4f4";
										}
%>													
																		
																	<tr style="background-color:<%=evenTrColor3%>">
																		<td style="width:50%" valign="top">
																			<div class="padding2"><%=key%></div>
																		</td>
																		<td valign="top" >
<%
										for(int i =0;i<timeVec.size();i++)
										{
											String time = (String)timeVec.get(i);
%>										
																			<div style="clear:both" class="padding2"><%=time%></div>
<%
										}
%>
		
																		</td>
																	</tr>
<%									}
								}
%>
																</table>
																</div>
															</td>
														</tr>
													</tbody>
												</table>
<%
							}
%>
										</div>
									</td>
								</tr>
<%
						}
					}
%>
			</tbody>
			</table>
			<br/>

		
<%
	}
			
}
else if(option!=null && (option.equals("All") || option.equals("Time Constraints")))
{
	if(isData)
	{
		if(data!=null && data.size()>0)
		{
			for(int k=0;k<data.size();k++) 
			{
				Hashtable mappedkeys=(Hashtable)data.get(k);	
				if(mappedkeys!=null && mappedkeys.size()>0) 
				{
					String DisplayTitle = "";
					String displayType = "";
					String displayElement1 = "";
					String displayElement2 = "";
					if(k==0) 
					{
						displayType = "Host";
						DisplayTitle = "Hosts Under Maintenance";
					}
					else if(k==1)
					{
						displayType = "Component";
						DisplayTitle = "Components Under Maintenance";
					}
					else if(k==2)
					{
						displayType = "Test";
						DisplayTitle = "Tests Under Maintenance";
					}
					else if(k==3)
					{
						displayType = "Test For Host";
						displayElement1 = "Test";
						displayElement2 = "Host";
						DisplayTitle = "Host Tests Under Maintenance";
					}
					else if(k==4)
					{
						displayType = "Test For Component";
						displayElement1 = "Test";
						displayElement2 = "Component";
						DisplayTitle = "Component Tests Under Maintenance";
					}
					else if(k==5)
					{
						displayType = "Descriptor";
						DisplayTitle = "Descriptors Under Maintenance";	
					}
					else if(k==6)
					{
						displayType = "Descriptor For Component";
						displayElement1 = "Descriptor";
						displayElement2 = "Component";								
						DisplayTitle = "Descriptor For Component Under Maintenance";
					}
%>
	
	
		<table align="left" width="100%" cellspacing="0px" cellpadding="0px"><tr><td style="padding:10px 0px 0px 0px"><div style="padding:5px" class="printTableHeader"><egui:intnl text="<%=\"admin.mpolicy.\"+DisplayTitle%>"/></div></td></tr></table>

		<table class="printTable" border="0" align="left" width="100%" cellspacing="0px" cellpadding="0px">
			<thead>
				<tr>

<%
					if(displayType.equals("Test For Host") || displayType.equals("Test For Component") || displayType.equals("Descriptor For Component"))
					{
%>
					<th class="printTableHeader" align="left" style="height:25px;padding-left: 10px;"><egui:intnl text="<%=displayElement1%>"/></th>
					<th class="printTableHeader" align="left" style="height:25px;padding-left: 10px;"><egui:intnl text="<%=displayElement2%>"/></th>
					<th class="printTableHeader" align="left" style="height:25px;padding-left: 10px;"><div style="float:left;width:222px"><egui:intnl text="admin.mpolicy.Policy"/></div><div style="float:left;width:82px"><egui:intnl text="admin.mpolicy.Status"/> </div><div style="float:left;"><egui:intnl text="admin.mpolicy.Timeline"/> </div></th>
<%
					}
					else
					{
%>
					<th class="printTableHeader" align="left" style="height:25px;padding-left: 10px;"><egui:intnl text="<%=displayType%>"/></th>
					<th class="printTableHeader" align="left" style="height:25px;padding-left: 10px;"><div style="float:left;width:222px"><egui:intnl text="admin.mpolicy.Policy"/> </div><div style="float:left;width:82px"><egui:intnl text="admin.mpolicy.Status"/> </div><div style="float:left;"><egui:intnl text="admin.mpolicy.Timeline"/> </div></th>
<%
					}

					
%>
				</tr>
			</thead>
			<tbody>
<%
					Iterator mappitr=mappedkeys.keySet().iterator();	
					if(timePeriod!=null && timePeriod.equals("true")) 
					{
						
					}
					else
					{
						boolean trColor = true;
						
						while(mappitr.hasNext()) 
						{
							String mapkey=(String)mappitr.next();
							Hashtable policyDetailsTable = (Hashtable)mappedkeys.get(mapkey);
							String disp = mapkey;
							String orgHstName = "";							
							if(disp.endsWith(":NULL"))
							{									
								disp= disp.substring(0,disp.indexOf(":NULL"));
							}
							if(k==2)
							{
								disp = _mapping.getTestDescription(disp);
							}
							String column = "";
							String hostName = "";
							if(disp!=null && disp.indexOf("#")>0)
							{
								column = disp.substring(0,disp.indexOf("#"));
								hostName = disp.substring(disp.indexOf("#")+1);
								if(k==3 || k==4)
								{
									column = _mapping.getTestDescription(column);
								}
							}
							else
							{
								column = disp;
							}
							orgHstName = disp;	

							String evenTrColor = "";

							if (trColor)
							{
								trColor=false;
								evenTrColor = "#ffffff";
							}
							else
							{
								trColor=true;
								evenTrColor = "#f4f4f4";
							}

							//******--Repalcing--Hash--Starts--*****---//
							if(column!=null&& column.indexOf("|HASH|")>0)
							{
								column = StringUtils.replace(column,"|HASH|","#");
							}
							//******--Repalcing--Hash--Ends--*****---//	
%>
				<tr style="background-color:<%=evenTrColor%>">
					<td style="border-right:1px !important"><div><%=column%></div></td>
<%
							if(hostName!=null && !hostName.equals(""))
							{
%>
								
					<td style="border-right:1px !important"><div><%=hostName%></div></td>
<%
							}
%>
					<td style="padding:10px">
						<div >
<%
							String groupList = "";
							Iterator policyDetailsitr = policyDetailsTable.keySet().iterator();
							boolean trColor2 = true;
							while(policyDetailsitr.hasNext()) 
							{
								String policyNameWithStatus=(String)policyDetailsitr.next();
								
								String policyName= policyNameWithStatus.substring(0,policyNameWithStatus.lastIndexOf("|"));
								String status = policyNameWithStatus.substring(policyNameWithStatus.lastIndexOf("|")+1);
								if(status!=null && status.equals("true"))
								{
									status = _mapping.getTextDescription("admin.mpolicy.Active");
								}
								else
								{
									status = _mapping.getTextDescription("admin.mpolicy.Inactive");
								}
								if(policyName!=null && !policyName.equals(""))
								{
									String tmpDisplay = egM.getPolicyDisplayName(policyName,!roleInfo.hasAllComponentAccess(), true);
									policyName = tmpDisplay;
								}
								
								String evenTrColor2="";
									if (trColor2)
									{
										trColor2=false;
										evenTrColor2 = "#e8e8e8";
									}
									else
									{
										trColor2=true;
										evenTrColor2 = "#e1e1e1";
									}
%>
							<table class="" border="0" width="100%" cellpadding="0px" cellspacing="0px" style="background-color:<%=evenTrColor2%>">
								<tbody>
									<tr>
										<td width="200px" >
<%								
									Hashtable timelineTable = (Hashtable)policyDetailsTable.get(policyNameWithStatus);
									groupList = (String)timelineTable.get("groups");
									if(groupList!=null && !groupList.equals(""))
									{	
%>
										<div><b>Groups:</b><%=groupList%></div><br>
<%										
									}
%>
								<%=policyName%>
										</td>
										<td style="width:60px;">
											<%=status%>
										</td>
										<td >
											<div class=" ">
												<table  border="0" cellpadding="0px" cellspacing="0px" align="center" width="100%" ><col width="50%"><col width="50%">
<%
									Iterator timeItr=timelineTable.keySet().iterator();
									Hashtable htDate = new Hashtable();	
									boolean trColor3 = true;
									while(timeItr.hasNext()) 
									{
										String colName = (String)timeItr.next();
										if(colName!=null && colName.equals("groups"))
										{
										}
										else
										{
											String dispCol="";	
											if(colName.equals("FDM"))
											{
												dispCol="First Day Of Month";
											}
											else if(colName.equals("LDM")) 
											{
												dispCol="Last Day Of Month";
											}
											else if(colName.equals("*")) 
											{
												dispCol="Daily";
											}
											else if(colName.startsWith("Every"))
											{
												String suffix = "th";
												if(colName.endsWith("1") || colName.endsWith("21") || colName.endsWith("31"))
												{
													suffix = "st";
												}
												else if(colName.endsWith("2") || colName.endsWith("22"))
												{
													suffix = "nd";
												}
												else if(colName.endsWith("3") || colName.endsWith("23"))
												{
													suffix = "rd";
												}
												dispCol = com.egurkha.util.StringUtils.replace(colName,"_"," ")+suffix+" day of the month";
											}
											else if(colName.startsWith("Sun") || colName.startsWith("Mon") || colName.startsWith("Tue") || colName.startsWith("Wed") || colName.startsWith("Thu") || colName.startsWith("Fri") || colName.startsWith("Sat")) 
											{
												if(colName!=null && colName.indexOf("$")>0 && colName.indexOf("_")>0)
												{
													String dayVal = colName.substring(0,colName.indexOf("$"));
													String week = colName.substring(colName.indexOf("$")+1);
													if(week.equalsIgnoreCase("week_1"))
													{
														week = "First";
													}
													else if(week.equalsIgnoreCase("week_2"))
													{
														week = "Second";
													}
													else if(week.equalsIgnoreCase("week_3"))
													{
														week = "Third";
													}
													else if(week.equalsIgnoreCase("week_4"))
													{
														week = "Fourth";
													}
													else if(week.equalsIgnoreCase("week_5"))
													{
														week = "Fifth";
													}

													dispCol=egM.DayForDescription(dayVal);
													dispCol = week+" week "+dispCol.toLowerCase()+" of the month";
												}
												else
												{
													dispCol=egM.DayForDescription(colName);
												}
											}
											else 
											{
												dispCol=colName.replace('|','-');
											}
											String strDate = "";
											endDate = "";
											Vector timelineVec = (Vector)timelineTable.get(colName);
											Vector val = new Vector();
											if(dispCol.indexOf("-")>0)
											{
												strDate = dispCol.substring(0,dispCol.indexOf("-"));
												endDate = dispCol.substring(dispCol.indexOf("-")+1);
												
												for(int i=0;i<timelineVec.size();i++)
												{
													String time = (String)timelineVec.get(i);
													String startTime=time.substring(0,time.indexOf("-"));
													String endTime=time.substring(time.indexOf("-")+1,time.length());
													String timeMsg= "";
													
													String strHr = startTime.substring(0,startTime.indexOf(":"));
													String strMin = startTime.substring(startTime.indexOf(":")+1);
													endHr = endTime.substring(0,endTime.indexOf(":"));
													String endMin = endTime.substring(endTime.indexOf(":")+1);
													
													String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
													EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr+":"+strMin,_user);
													String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
													EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr+":"+endMin,_user);	
													String start_Date = (String) converterStart.getDate(false);
													String end_Date = (String) converterEnd.getDate(false);

													start_Date = DateUtil.changeDateFormat(start_Date, "MM/dd/yyyy", userDtFormat);
													end_Date = DateUtil.changeDateFormat(end_Date, "MM/dd/yyyy", userDtFormat);
													dispCol = start_Date+"-"+end_Date;
													strHr = converterStart.getHour();
													endHr = converterEnd.getHour();
													strMin = converterStart.getMinute();
													endMin = converterEnd.getMinute();
													timeMsg=strHr+":"+strMin+"-"+endHr+":"+endMin;

													if(htDate!=null && htDate.containsKey(dispCol))
													{
														Vector existVector = (Vector)htDate.get(dispCol);
														existVector.add(timeMsg);
														htDate.put(dispCol, existVector);
													}
													else
													{
														val = new Vector();
														val.add(timeMsg);
														htDate.put(dispCol, val);
													}
												}
											}
											else
											{											
												for(int i=0;i<timelineVec.size();i++)
												{
													String time = (String)timelineVec.get(i);
													String startTime=time.substring(0,time.indexOf("-"));
													String endTime=time.substring(time.indexOf("-")+1,time.length());
													String timeMsg= "";
													if(strDate.equals("") && endDate.equals(""))
													{
														strDate = stDate;
														endDate = stDate;
													}
													if(!strDate.equals("") && !endDate.equals(""))
													{
														String strHr = startTime.substring(0,startTime.indexOf(":"));
														String strMin = startTime.substring(startTime.indexOf(":")+1);

														endHr = endTime.substring(0,endTime.indexOf(":"));
														String endMin = endTime.substring(endTime.indexOf(":")+1);

														String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
														EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr+":"+strMin,_user);
														String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
														EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr+":"+endMin,_user);
														
														strHr = converterStart.getHour();
														endHr = converterEnd.getHour();
														strMin = converterStart.getMinute();
														endMin = converterEnd.getMinute();
														timeMsg=strHr+":"+strMin+"-"+endHr+":"+endMin;
													}
													dispCol = _mapping.getTextDescription("admin.mpolicy."+dispCol);
													if(htDate!=null && htDate.containsKey(dispCol))
													{
														Vector existVector = (Vector)htDate.get(dispCol);
														existVector.add(timeMsg);
														htDate.put(dispCol, existVector);
													}
													else
													{
														val = new Vector();
														val.add(timeMsg);
														htDate.put(dispCol, val);
													}
												}
											}
									}
								}
								if(htDate!=null)
								{
									Set timeKeyset=htDate.keySet();
									Iterator timeKeysetItr=timeKeyset.iterator();
									while(timeKeysetItr.hasNext())
									{
										String evenTrColor3="";
										if (trColor3)
										{
											trColor3=false;
											evenTrColor3 = "#ffffff";
										}
										else
										{
											trColor3=true;
											evenTrColor3 = "#f4f4f4";
										}
										String key=(String)timeKeysetItr.next();
										Vector timeVec = (Vector)htDate.get(key);


											//******--Repalcing--Hash--Starts--*****---//
											if(key!=null&& key.indexOf("|HASH|")>0)
											{
												key = StringUtils.replace(key,"|HASH|","#");
											}
											//******--Repalcing--Hash--Ends--*****---//
%>
													<tr style="background-color:<%=evenTrColor3%>">
														<td style="width:50%" valign="top" >
															<div class="padding2"><%=key%></div>
														</td>
														<td valign="top">
<%										for(int i =0;i<timeVec.size();i++)
										{
											String time = (String)timeVec.get(i);
%>										
															<div style="clear:both" class="padding2"><%=time%></div>
<%
										}
%>
		
														</td>
													</tr>
<%
									}
								}
%>
												</table>
											</div>
										</td>
									</tr>
								</tbody>
							</table>
<%
							}
%>
						</div>
					</td>
				</tr>
<%
						}
					}
%>
			</tbody>
		</table>
		<br/>

<%
					
				}
			}
%>
		
<%
		}
	}
	else
	{
		
%>
		<table align="center" width="80%" cellpadding="0" cellspacing="0" border="0" valign="middle" height="200">
			<tr>
				<td align="center"  width="100%"  valign="bottom"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif">
				</td>
			</tr>
			<tr>
				<td align="center" width="100%" valign="top">
					<egui:intnl text="admin.mpolicy.No Data Found"/>
				</td>
			</tr>
		</table>
		<input type="hidden" id="printData" name="printData" value="noData" />
		<input type="hidden" id="pdfData" name="pdfData" value="noData" />
		<input type="hidden" id="csvData" name="csvData" value="noData" />
		<script language="javascript">
				window.parent.document.getElementById("hid3").value="false";
		</script>
	
<%
	}
}
	else if(option!=null && option.equals("Policy"))
	{	
		boolean isGrupAvail = false;
		Hashtable policyDetails = (Hashtable)policyTimeline.get(element);
		ArrayList groupList = (ArrayList)policyDetails.get("groups");
		String groups = "";
		if(groupList!=null && !groupList.isEmpty())
		{
			for(int i=0;i<groupList.size();i++)
			{
				groups += (String)groupList.get(i)+",";
			}
			isGrupAvail = true;
		}
%>
		<table class="printTable2" border="0" align="left" width="100%" cellspacing="0px" cellpadding="0px">
			<thead>
				<tr>
<%
				if(isGrupAvail)
				{
%>
					<th class="printTableHeader" align="left" style="height:25px;padding-left: 10px;"><egui:intnl text="admin.mpolicy.Groups"/></th>
<%
				}
%>
					<th class="printTableHeader" align="left" style="height:25px;padding-left: 10px;"><egui:intnl text="admin.mpolicy.Status"/></th>	
					<th class="printTableHeader" align="left" style="height:25px;padding-left: 10px;"><egui:intnl text="admin.mpolicy.Timeline"/></th>
					<th class="printTableHeader" align="left" style="height:25px;padding-left: 10px;"><egui:intnl text="admin.mpolicy.Associated Elements"/></th>
				</tr>
			</thead>
			<tbody>
			<tr>
<%
		
		if(isGrupAvail)
		{	
			groups = groups.substring(0,groups.lastIndexOf(","));
%>
			<td>
				<div><%=groups%></div>
			</td>
<%
		}
		String status = (String)policyDetails.get("Status"); 
		if(status!=null && status.equals("true"))
		{
			status = _mapping.getTextDescription("admin.mpolicy.Active");
		}
		else
		{
			status = _mapping.getTextDescription("admin.mpolicy.Inactive");
		}
%>
			<td>
				<div><%=status%></div>
			</td>
			<td  valign="top">
				<div>
				<table class="printTable" border="0" cellspacing="0" align="left" width="100%" >
<%
			Hashtable policyDetailsTable = (Hashtable)policyDetails.get("TimeFreq");
			if(policyDetailsTable!=null && !policyDetailsTable.isEmpty())
			{
				Iterator policyDetailsTableItr=policyDetailsTable.keySet().iterator();
				boolean trColor = true;
				
				Hashtable htDate = new Hashtable();
				while(policyDetailsTableItr.hasNext()) 
				{
					String mapkey=(String)policyDetailsTableItr.next();

					Vector timelineVec = (Vector)policyDetailsTable.get(mapkey);
					String dispCol="";	
					if(mapkey.equals("FDM"))
					{
						dispCol="First Day Of Month";
					}
					else if(mapkey.equals("LDM")) 
					{
						dispCol="Last Day Of Month";
					}
					else if(mapkey.equals("*")) 
					{
						dispCol="Daily";
					}
					else if(mapkey.startsWith("Every"))
					{
						String suffix = "th";
						if(mapkey.endsWith("1") || mapkey.endsWith("21") || mapkey.endsWith("31"))
						{
							suffix = "st";
						}
						else if(mapkey.endsWith("2") || mapkey.endsWith("22"))
						{
							suffix = "nd";
						}
						else if(mapkey.endsWith("3") || mapkey.endsWith("23"))
						{
							suffix = "rd";
						}
						dispCol = com.egurkha.util.StringUtils.replace(mapkey,"_"," ")+suffix+" day of the month";
					}
					else if(mapkey.startsWith("Sun") || mapkey.startsWith("Mon") || mapkey.startsWith("Tue") || mapkey.startsWith("Wed") || mapkey.startsWith("Thu") || mapkey.startsWith("Fri") || mapkey.startsWith("Sat")) 
					{
						if(mapkey!=null && mapkey.indexOf("$")>0 && mapkey.indexOf("_")>0)
						{
							String dayVal = mapkey.substring(0,mapkey.indexOf("$"));
							String week = mapkey.substring(mapkey.indexOf("$")+1);
							if(week.equalsIgnoreCase("week_1"))
							{
								week = "First";
							}
							else if(week.equalsIgnoreCase("week_2"))
							{
								week = "Second";
							}
							else if(week.equalsIgnoreCase("week_3"))
							{
								week = "Third";
							}
							else if(week.equalsIgnoreCase("week_4"))
							{
								week = "Fourth";
							}
							else if(week.equalsIgnoreCase("week_5"))
							{
								week = "Fifth";
							}

							dispCol=egM.DayForDescription(dayVal);
							dispCol = week+" week "+dispCol.toLowerCase()+" of the month";
						}
						else
						{
							dispCol=egM.DayForDescription(mapkey);
						}
					}
					else 
					{
						dispCol=mapkey.replace('|','-');
					}
					String strDate = "";
					endDate = "";

					Vector val = new Vector();
					if(dispCol.indexOf("-")>0)
					{
						strDate = dispCol.substring(0,dispCol.indexOf("-"));
						endDate = dispCol.substring(dispCol.indexOf("-")+1);
						
						for(int i=0;i<timelineVec.size();i++)
						{
							String time = (String)timelineVec.get(i);
							String startTime=time.substring(0,time.indexOf("-"));
							String endTime=time.substring(time.indexOf("-")+1,time.length());
							String timeMsg= "";
							
							String strHr = startTime.substring(0,startTime.indexOf(":"));
							String strMin = startTime.substring(startTime.indexOf(":")+1);
							endHr = endTime.substring(0,endTime.indexOf(":"));
							String endMin = endTime.substring(endTime.indexOf(":")+1);
							
							String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
							EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr+":"+strMin,_user);
							String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
							EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr+":"+endMin,_user);	
							String start_Date = (String) converterStart.getDate(false);
							String end_Date = (String) converterEnd.getDate(false);

							start_Date = DateUtil.changeDateFormat(start_Date, "MM/dd/yyyy", userDtFormat);
							end_Date = DateUtil.changeDateFormat(end_Date, "MM/dd/yyyy", userDtFormat);
							dispCol = start_Date+"-"+end_Date;
							strHr = converterStart.getHour();
							endHr = converterEnd.getHour();
							strMin = converterStart.getMinute();
							endMin = converterEnd.getMinute();
							timeMsg=strHr+":"+strMin+"-"+endHr+":"+endMin;

							if(htDate!=null && htDate.containsKey(dispCol))
							{
								Vector existVector = (Vector)htDate.get(dispCol);
								existVector.add(timeMsg);
								htDate.put(dispCol, existVector);
							}
							else
							{
								val = new Vector();
								val.add(timeMsg);
								htDate.put(dispCol, val);
							}
						}
					}
					else
					{											
						for(int i=0;i<timelineVec.size();i++)
						{
							String time = (String)timelineVec.get(i);
							String startTime=time.substring(0,time.indexOf("-"));
							String endTime=time.substring(time.indexOf("-")+1,time.length());
							String timeMsg= "";
							if(strDate.equals("") && endDate.equals(""))
							{
								strDate = stDate;
								endDate = stDate;
							}
							if(!strDate.equals("") && !endDate.equals(""))
							{
								String strHr = startTime.substring(0,startTime.indexOf(":"));
								String strMin = startTime.substring(startTime.indexOf(":")+1);

								endHr = endTime.substring(0,endTime.indexOf(":"));
								String endMin = endTime.substring(endTime.indexOf(":")+1);

								String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
								EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr+":"+strMin,_user);
								String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
								EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr+":"+endMin,_user);
								
								strHr = converterStart.getHour();
								endHr = converterEnd.getHour();
								strMin = converterStart.getMinute();
								endMin = converterEnd.getMinute();
								timeMsg=strHr+":"+strMin+"-"+endHr+":"+endMin;
							}
							dispCol = _mapping.getTextDescription("admin.mpolicy."+dispCol);
							if(htDate!=null && htDate.containsKey(dispCol))
							{
								Vector existVector = (Vector)htDate.get(dispCol);
								existVector.add(timeMsg);
								htDate.put(dispCol, existVector);
							}
							else
							{
								val = new Vector();
								val.add(timeMsg);
								htDate.put(dispCol, val);
							}
						}
					}
				}
				String evenTrColor = "";
				if(htDate!=null)
				{
					Set timeKeyset=htDate.keySet();
					Iterator timeKeysetItr=timeKeyset.iterator();
					while(timeKeysetItr.hasNext())
					{
						if (trColor)
						{
							trColor=false;
							evenTrColor = "#e8e8e8";
						}
						else
						{
							trColor=true;
							evenTrColor = "#e1e1e1";
						}
						String key=(String)timeKeysetItr.next();
						Vector timeVec = (Vector)htDate.get(key);
%>
							<tr style="background-color:<%=evenTrColor%>">
								<td  valign="top" >
									<div class="padding2"><%=key%></div>
								</td>

								<td valign="top">
<%
						for(int i =0;i<timeVec.size();i++)
						{
							String time = (String)timeVec.get(i);
%>
							<div style="clear:both" class="padding2"><%=time%></div>
<%
						}
%>
								</td>
							</tr>
<%
					}
				}
			}
%>

							
			</table>
			</div>
		</td>
<%
				
		if(isData)
		{
			if(data!=null && data.size()>0)
			{
%>
					<td valign="top" style="border:0px !important">
						<div>
						<table class="printTable" border="0" align="left" width="100%"  cellspacing="0">
<%
				
				boolean isTrColor = true;

				for(int k=0;k<data.size();k++) 
				{
					Hashtable mappedkeys=(Hashtable)data.get(k);
					if(mappedkeys!=null && mappedkeys.size()>0) 
					{						
						String tmpElemnts ="";						
						
						String AssciatedName = "";
						String AssociatedTitle = "";
						String AssciatedName1 = "";
						String AssciatedName2 = "";
						if(k==0) 
						{
							AssciatedName = _mapping.getTextDescription("admin.mpolicy.Host");	
						}
						else if(k==1)
						{
							AssciatedName = _mapping.getTextDescription("admin.mpolicy.Component");
						}
						else if(k==2)
						{
							AssciatedName = _mapping.getTextDescription("admin.mpolicy.Test");
						}
						else if(k==3)
						{							
							AssociatedTitle=_mapping.getTextDescription("admin.mpolicy.Test For Host");
							AssciatedName1=_mapping.getTextDescription("admin.mpolicy.Test");
							AssciatedName2=_mapping.getTextDescription("admin.mpolicy.Host");
						}
						else if(k==4)
						{
							AssociatedTitle=_mapping.getTextDescription("admin.mpolicy.Test For Component");
							AssciatedName1=_mapping.getTextDescription("admin.mpolicy.Test");
							AssciatedName2=_mapping.getTextDescription("admin.mpolicy.Component");
						}
						else if(k==5)
						{
							AssciatedName = _mapping.getTextDescription("admin.mpolicy.Descriptor");
						}
						else if(k==6)
						{
							AssociatedTitle=_mapping.getTextDescription("admin.mpolicy.Descriptor For Component");
							AssciatedName1=_mapping.getTextDescription("admin.mpolicy.Descriptor");
							AssciatedName2=_mapping.getTextDescription("admin.mpolicy.Component");
						}
						String evenTrColor = "";
						
						ArrayList associatedElements = (ArrayList)mappedkeys.get(element);
						if(associatedElements!=null && associatedElements.size()>0)
						{							
							if(isTrColor)
							{
								evenTrColor = "#ffffff";
								isTrColor = false;
							}
							else
							{
								isTrColor = true;
								evenTrColor = "#f4f4f4";
							}
						}
						
						if(associatedElements!=null && associatedElements.size()>0)
						{
							if(!AssociatedTitle.equals("") && !AssciatedName1.equals("") && !AssciatedName2.equals(""))
							{
	%>
								<tr style="background-color:<%=evenTrColor%>">
									<td class="font_bold12" style="width:25%">
										<div style="width: 100px;"><%=AssociatedTitle%></div>
									</td>
									<td class="font_bold12" style="width:25%">
										<div><%=AssciatedName1%></div>
									</td>
									<td class="font_bold12" colspan="2">
										<div><%=AssciatedName2%></div>
									</td>
								</tr>
	<%
							}

							ArrayList elemList = new ArrayList();
							//boolean trColor2 = true;
							for(int i=0;i<associatedElements.size();i++)
							{
								String elemnts = (String)associatedElements.get(i);
								String assElements = "";
								if(elemnts!=null && elemnts.indexOf("#")>0)
								{
									String columname = elemnts.substring(0,elemnts.indexOf("#"));
									String hostName = elemnts.substring(elemnts.indexOf("#")+1);
									if(elemList!=null && !elemList.contains(columname))
										elemList.add(columname);
									if(k==3 || k==4)
									{
										columname = _mapping.getTestDescription(columname);
									}

									//******--Repalcing--Hash--Starts--*****---//
									if(columname!=null&& columname.indexOf("|HASH|")>0)
									{
										columname = StringUtils.replace(columname,"|HASH|","#");
									}
									//******--Repalcing--Hash--Ends--*****---//	

%>
							<tr style="background-color:<%=evenTrColor%>">
								<td style="width:25%"  valign="top"></td>
								<td class="mainten_font" style="width:25%"  valign="top">
									<div style="white-space:wrap;word-wrap: break-word !important;"><%=columname%></div>
								</td>

								<td class="mainten_font" colspan="2"  valign="top">
									<div style="white-space:wrap;word-wrap: break-word !important;width:400px;"><%=hostName%></div>
								</td>
							</tr>
<%
								}
								else
								{
									if(k==2)
									{
										elemnts = _mapping.getTestDescription(elemnts);
									}

									//******--Repalcing--Hash--Starts--*****---//
									if(elemnts!=null&& elemnts.indexOf("|HASH|")>0)
									{
										elemnts = StringUtils.replace(elemnts,"|HASH|","#");
									}
									//******--Repalcing--Hash--Ends--*****---//
									tmpElemnts +=elemnts+", ";	
								}
							}
						}
						if(k==0 || k==1 || k==2 || k==5) 
						{							
							if(tmpElemnts!=null && tmpElemnts.lastIndexOf(",")>0)
							{
								tmpElemnts = tmpElemnts.substring(0,tmpElemnts.lastIndexOf(","));
							}	
							String AssciatedValue = "";
							AssciatedValue = tmpElemnts;
												
							if(!AssciatedName.equals("") && !AssciatedValue.equals(""))
							{
	%>
							<tr style="background-color:<%=evenTrColor%>">
								<td class="font_bold12" style="width:70px;">
									<div ><%=AssciatedName%></div>
								</td>
								<td class="mainten_font" colspan="3">
									<div ><%=AssciatedValue%></div>
								</td>
							</tr>
	<%
							}
						}
					}
				}
%>
						</table>
						</div>
					</td>
<%
			}
		}
%>		
				</tr>
			</tbody>
		</table>
		<br/>
<%
	}
}
catch(Exception e)
{
	e.printStackTrace();
}
%>
<%!
	/*public String getTimeLineForCsv(Hashtable timeVal,String displayName,EgMaintenanceUtility egM,String currentDateFormat,User _user)
	{
		String userDtFormat = _user.getUserDateFormat();
		if(userDtFormat != null && userDtFormat.length() > 0)
		{
			if(userDtFormat.equalsIgnoreCase("default"))
				userDtFormat = currentDateFormat;
		}
		StringBuffer timeString=new StringBuffer();
		Iterator itr2=null;
		Object timeDur=(Object)timeVal.get(displayName);
		Hashtable timeDur1=null;
		if(timeDur instanceof Hashtable)
		{
			timeDur1=(Hashtable)timeDur;
		}
		else if(timeDur instanceof Vector)
		{
			Vector tmp=(Vector)timeDur;
			timeDur1=(Hashtable)tmp.get(1);
		}
		if(timeDur1!=null)
		{
			itr2=timeDur1.keySet().iterator();
			Vector timeColumn1=new Vector();
			String timeKey1="";
			while(itr2.hasNext())
			{
				timeKey1=(String)itr2.next();
				timeColumn1.add(timeKey1);
			}
			String dispCol1="";
			for(int m=0;m<timeColumn1.size();m++)
			{
				String colName1=(String)timeColumn1.get(m);
				if(colName1.equals("FDM"))
				{
					dispCol1="First Day Of Month";
				}
				else if(colName1.equals("LDM"))
				{
					dispCol1="Last Day Of Month";
				}
				else if(colName1.equals("*"))
				{
					dispCol1="Daily";
				}
				else if(colName1.equals("Sun") || colName1.equals("Mon") || colName1.equals("Tue") || colName1.equals("Wed") || colName1.equals("Thu") || colName1.equals("Fri") || colName1.equals("Sat"))
				{
					dispCol1=egM.DayForDescription(colName1);
				}
				else
				{
					dispCol1=colName1;//.replace('|','-');
				}				

				//timeString.append(dispCol1);
				String strDate = "";
				String endDate = "";
				if(dispCol1.indexOf("|")>0)
				{
					strDate = dispCol1.substring(0,dispCol1.indexOf("|"));
					endDate = dispCol1.substring(dispCol1.indexOf("|")+1);
					String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
					EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" 00:00",_user);
					String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
					EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" 00:00",_user);
					strDate = (String) converterStart.getDate(false);
					endDate = (String) converterEnd.getDate(false);					
					dispCol1 = strDate+"-"+endDate;					
				}				
				dispCol1=StringUtils.replace(dispCol1,",","");
				timeString.append(dispCol1);
				Vector  timeVal1=(Vector)timeDur1.get(colName1);
				if(timeVal1!=null && timeVal1.size()>0)
				{
					for(int n=0;n<timeVal1.size();n++)
					{
						String time1=(String)   timeVal1.get(n);
						String startTime1=time1.substring(0,time1.indexOf("-"));
						String endTime1=time1.substring(time1.indexOf("-")+1,time1.length());
						String timeMsg1="";
						if(strDate!="" && endDate!="")
						{
							String strHr = startTime1.substring(0,startTime1.indexOf(":"));
							String strMin = startTime1.substring(startTime1.indexOf(":")+1);

							String endHr = endTime1.substring(0,endTime1.indexOf(":"));
							String endMin = endTime1.substring(endTime1.indexOf(":")+1);

							String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
							EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr+":"+strMin,_user);
							String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
							EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr+":"+endMin,_user);							
							strHr = converterStart.getHour();
							endHr = converterEnd.getHour();
							strMin = converterStart.getMinute();
							endMin = converterEnd.getMinute();	

							
							timeMsg1=strHr+":"+strMin+"-"+endHr+":"+endMin;
						}
						else
						{
							timeMsg1=startTime1+"-"+endTime1;
						}						
						timeString.append("|");
						timeString.append(timeMsg1);
					}
				}
				if(timeColumn1.size()>1)
					timeString.append(",");
			}
		}
		return timeString.toString();
	}
	public String getNextScheduleDateForCsv(String option,Hashtable temp,String allkey,String dispallkey,EgMaintenanceUtility egM,String currentDateFormat)
	{
		StringBuffer nextTimeStr=new StringBuffer();
		Hashtable dates=new Hashtable();
		if(option !=null && option.equals("Test For Host") || option.equals("Test  For Component") || option.equals("Descriptor For Component"))
		{
			Vector elementNames=new Vector();
			Vector elementnames=new Vector();
			Vector hashValue1=new Vector();
			elementnames=egM.getAssociatedHostsOrComponentsForTests(allkey);
			dates=egM.getNextScheduleTimeForHosttestOrComponenttest(allkey,elementnames);
			if(dates!=null && dates.size()==0)
			{
				hashValue1=(Vector)temp.get(dispallkey);
				Vector  comps1=(Vector)hashValue1.get(0);
				if(comps1!=null && comps1.size()>0)
				{
					if(comps1.size()==1)
					{
						String host1=(String)comps1.get(0);
						elementNames.add(host1);
						dates=egM.getUnplannedNextScheduleTimeForHosttestOrComponenttest(allkey,elementNames);
					}
					else
					{
						for(int c1=0;c1<comps1.size();c1++)
						{
							String host1=(String)comps1.get(c1);
							elementNames.add(host1);
							dates=egM.getUnplannedNextScheduleTimeForHosttestOrComponenttest(allkey,elementNames);
						}
					}
				}
			}
		}
		else if(option!=null && option.equals("Host") || option.equals("Component") || option.equals("Test") || option.equals("Descriptor"))
		{
			if(option.equals("Test"))
			{
				dates=egM.getNextScheduleTimeForTest(allkey);
				if(dates!=null && dates.size()==0)
					dates=egM.getUnplannedNextScheduleTimeForTest(allkey);
				
			}
			else
			{
				dates=egM.getNextScheduleTimeForHost(allkey);
				if(dates!=null && dates.size()==0)
				{
					if(option.equals("Descriptor"))
					{
						
						String modKey="#"+allkey;
						dates=egM.getUnplannedNextScheduleTimeForTest(allkey);
					}
					else
					{
						dates=egM.getUnplannedNextScheduleTimeForHost(allkey);
					}
					if(dates.size()==0)  
						dates=egM.getNextScheduleTimeForHost(allkey);
				}
			}
		}
		if(dates!=null && dates.size()>0)  
		{
			SimpleDateFormat simpleDateFmt=new SimpleDateFormat(currentDateFormat+" "+"H:mm");
			Date startDate1=(Date)dates.keySet().iterator().next();
			Date endDate1=(Date)dates.get(startDate1);
			if(endDate1.before(new Date()) || endDate1.equals(new Date()))
			{
				nextTimeStr.append("Completed");
			}
			else if(startDate1.getDate()==endDate1.getDate() && startDate1.getMonth()==endDate1.getMonth() && startDate1.getYear()==endDate1.getYear()) 
			{
				SimpleDateFormat simpleDateFmt1=new SimpleDateFormat("H:mm");
				nextTimeStr.append(simpleDateFmt.format(startDate1)+"-"+simpleDateFmt1.format(endDate1));
			}
			else
			{
				nextTimeStr.append(simpleDateFmt.format(startDate1)+"-"+simpleDateFmt.format(endDate1));
			}
		}
		return nextTimeStr.toString();
	}*/
%>
</body>
</html>

