<%
/***********************************************************************************************************
*       Name            :       EgIncludeExcludeComponentsJson.jsp 
*       Purpose         :       To include/exclude components Json page. 
***********************************************************************************************************/
%>

<%@ include file = "../../EgTrackerAJSON.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.IniFile"%> 
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.*"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgUsersInfo"%>
<%@ page import = "net.sf.json.*"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8"%>

<%!
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	EgExternalInfo egExternalInfo = new EgExternalInfo("manager");

	private String getResultantPattern(String componentType,String componentName,String testName,String[] testVariables)
	{
		String tempResultantPattern = null;
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String specificPattern_A = testName + ":" + componentType + ":" + componentName;
		String specificPattern_B = testName + ":" + componentType + ":" + componentNickName;
		String defaultPattern_A = testName + "::" + componentName;
		String defaultPattern_B = testName + "::" + componentNickName;

		List listTestVariables = Arrays.asList(testVariables);
		if (listTestVariables.contains(specificPattern_A))
		{
			tempResultantPattern = specificPattern_A;
		}
		else if (listTestVariables.contains(specificPattern_B))
		{
			tempResultantPattern = specificPattern_B;
		}
		else if (listTestVariables.contains(defaultPattern_A))
		{
			tempResultantPattern = defaultPattern_A;
		}
		else if (listTestVariables.contains(defaultPattern_B))
		{
			tempResultantPattern = defaultPattern_B;
		}
		return tempResultantPattern;
	}

	//Will provide the right agent (subject) for a component and its test
	private String getAgentNickName(String componentType,String componentName,String testName)
	{
		boolean isExternalTest = egSpecs.isExternalTest(testName,componentType);
		List aListTempAgentsForComponent = getAgents(componentName);
		String agentName = null;
		if (isExternalTest)
		{
			//external agent for external test
			agentName = (String)aListTempAgentsForComponent.get(1);
		}
		else
		{
			//internal agent or remote agent for host level test and application level test.
			agentName = (String)aListTempAgentsForComponent.get(0);
		}
		return agentName;
	}

	//provide a set of agents(internal or remote agent,external agent(s)) for a component
	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";
		boolean isRemote = false;

		//To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(componentNickName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(componentNickName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = componentNickName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		//To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends
		return agentsList;
	}

	public boolean hasUnConfiguredParam(String paramValue)
	{
		boolean hasUnconfiguredParam = false;
		StringTokenizer st = new StringTokenizer(paramValue,",");
		st.nextToken();
		StringTokenizer st1 = new StringTokenizer(st.nextToken());
		ArrayList aListParamNameValue = new ArrayList();

		StringBuffer eachStr = null;
		while (st1.hasMoreTokens())
		{
			String token = st1.nextToken();
			token = token.trim();
			if (token.startsWith("-"))
			{
				if (eachStr != null && eachStr.toString().length() > 0)
				{
					aListParamNameValue.add((eachStr.toString()).substring(0,(eachStr.toString()).length()-1));
				}
				aListParamNameValue.add(token.toLowerCase());
				eachStr = new StringBuffer();
			}
			else
			{
				eachStr.append(token + " ");
			}
		}
		aListParamNameValue.add((eachStr.toString()).trim());
		String snmpVersion = null;
		boolean isSnmp = aListParamNameValue.contains("-snmpversion");

		if (isSnmp)
		{
			//put snmp version before snmp community.
			int snmpCommunityIdx = aListParamNameValue.indexOf("-snmpcommunity");
			String snmpCommunityVal = (String)aListParamNameValue.get(snmpCommunityIdx+1);
			aListParamNameValue.remove(snmpCommunityIdx);
			aListParamNameValue.remove(snmpCommunityIdx);

			int snmpVerIdx = aListParamNameValue.indexOf("-snmpversion");
			snmpVersion = (String)aListParamNameValue.get(snmpVerIdx+1);

			aListParamNameValue.add(snmpVerIdx+2,"-snmpcommunity");
			aListParamNameValue.add(snmpVerIdx+3,snmpCommunityVal);
		}

		for (int i=0;i < aListParamNameValue.size();i=i+2)
		{
			String strParamName = (String)aListParamNameValue.get(i);
			String strParamValue = (String)aListParamNameValue.get(i+1);

			if (strParamName.equalsIgnoreCase("-password") || 
				strParamName.equalsIgnoreCase("-proxypassword") || 
				strParamName.equalsIgnoreCase("-authpass") || 
				strParamName.equalsIgnoreCase("-encryptpassword") || 
				strParamName.equalsIgnoreCase("-admin_password") || 
				strParamName.equalsIgnoreCase("-vc_password") || 
				strParamName.equalsIgnoreCase("-esx_password") || 
				strParamName.equalsIgnoreCase("-sendpassword") || 
				strParamName.equalsIgnoreCase("-receivepassword") || 
				strParamName.equalsIgnoreCase("-xen_password") || 
				strParamName.equalsIgnoreCase("-From_User_Password"))
			{
				continue;
			}

			if (isSnmp && snmpVersion != null)
			{
				if (snmpVersion.equalsIgnoreCase("v3"))
				{
					if (strParamName.equalsIgnoreCase("-snmpcommunity"))
					{
						continue;
					}
				}
			}

			strParamValue = strParamValue.trim();
			if (strParamValue.startsWith("$"))
			{
				hasUnconfiguredParam = true;
				break;
			}
		}
		return hasUnconfiguredParam;
	}

	String[] criterias = {"Zone","Service","Segment","Component"};
	
	private ArrayList getAssociatedComponents(HttpSession session, User user,String view,String option)
	{
		ArrayList aListAssociatedComponents = new ArrayList();

		EgGroupInfo egGroupInfo = new EgGroupInfo();
		EgTopoInfo egTopoInfo = egGroupInfo.getTopoInfoObject();

		if (option != null)
		{
			try
			{
				option = EgURLDecoder.decode(option,"UTF-8");
			}
			catch (Exception e)
			{
			}
		}

		Vector vecUserOptions = null;
		Vector vecUserAssociatedComponents = new Vector(user.getServers(false));

		if (view != null && view.equalsIgnoreCase("Zone"))
		{
			List zoneList = user.getZones();

			//To fetch all components from user associated zones
			ArrayList aListComponentsFromZone = new ArrayList();
			if (zoneList != null && !zoneList.isEmpty())
			{
				vecUserOptions = new Vector(zoneList);
				Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);

				for (int i=0;i<vecUserOptions.size();i++)
				{
					String strZone = (String)vecUserOptions.get(i);
					aListComponentsFromZone.addAll(egGroupInfo.getAllComponentsUnderZone(strZone,true));
				}
			}

			if (aListComponentsFromZone != null && !aListComponentsFromZone.isEmpty())
			{
				boolean defaultZoneExists = false;
				for (int i=0;i<vecUserAssociatedComponents.size();i++)
				{
					String component = (String)vecUserAssociatedComponents.get(i);
					if (!aListComponentsFromZone.contains(component))
					{
						defaultZoneExists = true;
						break;
					}
				}

				if (defaultZoneExists)
				{
					vecUserOptions.add(0,"--Default--");
				}
			}
			else
			{
				if (vecUserAssociatedComponents != null && !vecUserAssociatedComponents.isEmpty())
				{
					vecUserOptions = new Vector();
					vecUserOptions.add("--Default--");
				}
			}

			if (option == null && vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				option = (String)vecUserOptions.get(0);
			}

			if (option != null)
			{
				if (!option.equalsIgnoreCase("--Default--"))
				{
					aListAssociatedComponents = egGroupInfo.getAllComponentsUnderZone(option,true);
				}
				else
				{
					aListAssociatedComponents = new ArrayList();
					for (int i=0;i<vecUserAssociatedComponents.size();i++)
					{
						String userComponent = (String)vecUserAssociatedComponents.get(i);
						int index = aListComponentsFromZone.indexOf(userComponent);
						if (index == -1)
						{
							aListAssociatedComponents.add(userComponent);
						}
					}
				}
			}
		}
		else if (view != null && view.equalsIgnoreCase("Service"))
		{
			List serviceList = new ArrayList();
			serviceList.addAll(user.getServices());
			ArrayList aListSites = new ArrayList();
			aListSites.addAll(user.getSites());
			aListSites.removeAll(serviceList);
			serviceList.addAll(aListSites);
			if (serviceList != null && !serviceList.isEmpty())
			{
				vecUserOptions = new Vector(serviceList);
				Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);
			}

			if (option == null && vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				option = (String)vecUserOptions.get(0);
			}

			if (option != null)
			{
				Vector vecServiceComponents = egTopoInfo.getAssociatesForSite(option);
				if (vecServiceComponents != null)
				{
					aListAssociatedComponents = new ArrayList(vecServiceComponents);
				}
			}
		}
		else if (view != null && view.equalsIgnoreCase("Segment"))
		{
			List segmentList = user.getSegments();
			if (segmentList != null && !segmentList.isEmpty())
			{
				vecUserOptions = new Vector(segmentList);
				Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);
			}

			if (option == null && vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				option = (String)vecUserOptions.get(0);
			}
			if (option != null)
			{
				Vector vecSegmentComponents = egTopoInfo.getAssociatesForSegment(option,2);
				if (vecSegmentComponents != null)
				{
					aListAssociatedComponents = new ArrayList(vecSegmentComponents);
				}
			}
		}
		else
		{
			aListAssociatedComponents = new ArrayList(vecUserAssociatedComponents);
		}
		session.setAttribute("ec_criteria",view);
		session.setAttribute("ec_userOption",option);
		session.setAttribute("vecUserOptions",vecUserOptions);

		return aListAssociatedComponents;
	}

%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	IniFile agentIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_agents.ini");
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	//tells information about the corresponding authenticated user
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());
	listComponentTypes = sorter.getSortedCompTypeList(listComponentTypes);

	String action = request.getParameter("action");
	action = (action != null)?action:"";
	rootJson.put("action",action);


	String criteria = request.getParameter("criteria");
	if (criteria == null)
	{
		criteria = "Component";
	}

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String strCriteria = criterias[g];
		vecCriterias.add(strCriteria);
	}

	String userOption = request.getParameter("userOption");
	if (StringUtils.isNull(userOption) || userOption.equals("-1"))
	{
		userOption = null;
	}

	rootJson.put("criteria",criteria);


	//String[] totalComponents = null;
	int totalComponents = 0;
	String componentType = request.getParameter("componentType");
	componentType = (componentType != null)?componentType:"";
	boolean isValidCompType = (!componentType.equals("") && !componentType.equals("-1"));

	String previousComponentType = request.getParameter("previousComponentType");
	previousComponentType = (previousComponentType != null)?previousComponentType:"";

	JSONObject viewByObj = new JSONObject();
	JSONArray viewByArr = new JSONArray();

	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(criteria != null && strCriteria.equals(criteria))
			{
				rootJson.put("selectedCriteria",criteria);
			}
			viewByObj.put("displayField",_mapping.getTextDescription("admin.common."+strCriteria));
			viewByObj.put("valueField",strCriteria);
			viewByArr.add(viewByObj);
		}
	}
	else
	{
		rootJson.put("selectedCriteria","-1");
		viewByObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
		viewByObj.put("valueField","-1");
		viewByArr.add(viewByObj);
	}
	rootJson.put("viewByArr",viewByArr);

	HashSet vec_componentTypes = new HashSet();
	Vector allcomps = new Vector();
	Vector vec_components = new Vector();

	ArrayList associatedComponents = getAssociatedComponents(session, _user, criteria, userOption);

	if (!criteria.equals("Component"))
	{
		allcomps.addAll(associatedComponents);
		if (!allcomps.isEmpty())
		{
			for (int i=0;i<allcomps.size();i++)
			{
				String str = (String) allcomps.get(i);
				String component_type = str.substring(0,str.indexOf(":"));
				vec_componentTypes.add(component_type);
				String component_name = str.substring(str.indexOf(":")+1);
				if (isValidCompType && str.startsWith(componentType))
				{
					vec_components.add(str);
				}
			}
		}

		Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
		if (StringUtils.isNull(userOption) && vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			userOption = (String)vecUserOptions.get(0);
		}

		System.out.println("associatedComponents  "+associatedComponents);
		JSONArray specviewByArr = new JSONArray();

		if (criteria != null && !criteria.equalsIgnoreCase(criterias[3]) && !criteria.equals("-1"))
		{
			if (criteria.equalsIgnoreCase(criterias[0]))
			{
				rootJson.put("specViewByTitle",criterias[0]);
			}
			else if (criteria.equalsIgnoreCase(criterias[1]))
			{
				rootJson.put("specViewByTitle",criterias[1]);
			}
			else
			{
				rootJson.put("specViewByTitle",criterias[2]);
			}

			JSONObject specviewByObj = new JSONObject();

			if (vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				for(int i=0; i<vecUserOptions.size(); i++)
				{
					String selected = "";
					String strUserOption = (String)vecUserOptions.get(i);
					if(userOption != null && strUserOption.equals(userOption))
					{
						rootJson.put("selectedUserOptionText",userOption);
					}
					specviewByObj.put("displayField",strUserOption);
					specviewByObj.put("valueField",strUserOption);
					specviewByArr.add(specviewByObj);
				}
			}
			else
			{
				rootJson.put("selectedUserOptionText","-1");
				specviewByObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
				specviewByObj.put("valueField","-1");
				specviewByArr.add(specviewByObj);
			}
			rootJson.put("specViewByArr",specviewByArr);
		}

		// filtering server types...
		listComponentTypes = new ArrayList();
		if (vec_componentTypes != null && !vec_componentTypes.isEmpty())
		{
			listComponentTypes = sorter.getSortedCompTypeList(vec_componentTypes);
		}

	}
	
	rootJson.put("userOption",userOption);

	String testType = request.getParameter("testType");
	testType = (testType == null)?"PerformanceTest":testType;

	String perviousTestType = request.getParameter("previousTestType");
	perviousTestType = (perviousTestType == null)?"PerformanceTest":perviousTestType;

	String pfSelected = "";
	String cfSelected = "";
	if (testType.equalsIgnoreCase("PerformanceTest"))
	{
		pfSelected = "selected";
	}
	else
	{
		cfSelected = "selected";
	}

	String testName = "";
	String strSelectedTestsInList = request.getParameter("selectedTest");

	if (strSelectedTestsInList == null || strSelectedTestsInList.equals("-1"))
	{
		strSelectedTestsInList = "";
	}

	//ensure whether the user is configuration management enabled
	EgUserRole userRole = _user.getUserRole();

	boolean isConfigSupport = EgInstallInfo.isConfigSupported;
	if (isConfigSupport)
	{
		isConfigSupport = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);

		if (!previousComponentType.equalsIgnoreCase(componentType))
		{
			strSelectedTestsInList = "";
		}
	}
	rootJson.put("isConfigSupported",isConfigSupport);

	Vector aListselectedTests = new Vector();
	StringTokenizer stk = new StringTokenizer(strSelectedTestsInList,",");
	while (stk.hasMoreTokens())
	{
		String tname = stk.nextToken();
		if (!aListselectedTests.contains(tname))
		{
			aListselectedTests.add(tname);
		}
	}

	if (aListselectedTests != null && !aListselectedTests.isEmpty())
	{
		if (aListselectedTests.contains("RUMAppTest"))
		{
			aListselectedTests.remove("RUMAppTest");
		}
	}
	EgUsersInfo usersInfo = new EgUsersInfo();
	String selectedUsrTests = "";
	if (usersInfo.isUserBasedLicense())
	{
		if(!componentType.equals(""))
		{
			ArrayList userBasedTests = usersInfo.getUserBasedTests(componentType);
			for (int i=0; i < userBasedTests.size(); i++)
			{
				String usrTest = (String)userBasedTests.get(i).toString();
				if (aListselectedTests.contains(usrTest))
				{
					aListselectedTests.remove(usrTest);
					if (selectedUsrTests.equals(""))
						selectedUsrTests += _mapping.getTestDescription(usrTest);
					else
						selectedUsrTests += ","+ _mapping.getTestDescription(usrTest);				
				}
			}
			rootJson.put("usrBasedTests",userBasedTests);
		}
	}

	String previousTestName = request.getParameter("previousTestName");
	previousTestName = (previousTestName != null)?previousTestName:"";

	ArrayList aListEnabledTestForCompType = null;
	ArrayList aListResultantIncludedComponents = null;
	ArrayList aListResultantExcludedComponents = null;

	//contains enabled test for a component type
	if (!componentType.equals("") && !componentType.equals("-1"))
	{
		if (testType.equals("PerformanceTest"))
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
		}
		else
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,true);
		}
		aListEnabledTestForCompType = sorter.getSortedTestList(aListEnabledTestForCompType);
	}

	Hashtable htableTestWithExcludedComponents = new Hashtable();
	Hashtable htableTestWithIncludedComponents = new Hashtable();
	ArrayList aListIncludedTest = new ArrayList();
	ArrayList aListExcludedTest = new ArrayList();

	boolean isPageRefresh = false;
	String pageRefresh = request.getParameter("refreshed");
	if (pageRefresh != null)
	{
		isPageRefresh = pageRefresh.equals("true")?true:false;
	}

	if (isPageRefresh)
	{
		String strIncluCompList = request.getParameter("enabledCompList");
		String strExcluCompList = request.getParameter("disabledCompList");

		if (strExcluCompList != null && strExcluCompList.length() > 1)
		{
			StringTokenizer st = new StringTokenizer(strExcluCompList,",");
			while (st.hasMoreTokens())
			{
				String token = st.nextToken();
				String strCompName = token.substring(0,token.indexOf("$"));
				String strTestWithState = token.substring(token.indexOf("$")+1);
				String strTestName = strTestWithState.substring(0,strTestWithState.indexOf(" - ")).trim();
				if(!aListExcludedTest.contains(strTestName))
				{
					aListExcludedTest.add(strTestName);
				}
				ArrayList aListTemp = (ArrayList)htableTestWithExcludedComponents.get(strTestWithState);
				if (aListTemp == null)
				{
					aListTemp = new ArrayList();
					aListTemp.add(strCompName);
					htableTestWithExcludedComponents.put(strTestWithState,aListTemp);
				}
				else
				{
					aListTemp.add(strCompName);
				}
			}
		}

		if (strIncluCompList != null && strIncluCompList.length() > 1)
		{
			StringTokenizer st = new StringTokenizer(strIncluCompList,",");
			while (st.hasMoreTokens())
			{
				String token = st.nextToken();
				String strCompName = token.substring(0,token.indexOf("$"));
				String strTestWithState = token.substring(token.indexOf("$")+1);
				ArrayList aListTemp = (ArrayList)htableTestWithIncludedComponents.get(strTestWithState);
				String strTestName = strTestWithState.substring(0,strTestWithState.indexOf(" - ")).trim();
				if(!aListIncludedTest.contains(strTestName))
				{
					aListIncludedTest.add(strTestName);
				}
				if (aListTemp == null)
				{
					aListTemp = new ArrayList();
					aListTemp.add(strCompName);
					htableTestWithIncludedComponents.put(strTestWithState,aListTemp);
				}
				else
				{
					aListTemp.add(strCompName);
				}
			}
		}
	}
	else
	{
		if (componentType != null && !componentType.equals("-1"))
		{
			String[] componentsList = ri.getAllServersOfType(componentType);
			if (!criteria.equals("Component"))
			{
				componentsList =  (String[]) vec_components.toArray(new String[vec_components.size()]);
			}

			totalComponents = componentsList.length; // gets components count for checking the limit exceed.. 

			boolean isPortRelevantForTest ;
			IniFile disableIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_disable.ini");
			for (int i=0;i < componentsList.length;i++)
			{
				String strComponent = componentsList[i];
				strComponent = strComponent.substring(strComponent.indexOf(":")+1);

				for (int k=0;k < aListselectedTests.size();k++)
				{
					testName = aListselectedTests.get(k).toString();
					isPortRelevantForTest = egSpecs.isPortRelevantForTest(testName);

					String strTestPattern1 = "#" + testName + "#";
					String strTestPattern2 = "#" + testName + ",";
					String strTestPattern3 = "," + testName + ",";
					String strTestPattern4 = "," + testName + "#";

					String tempAgentNickName = getAgentNickName(componentType,strComponent,testName);
					String[] tempTestVariables = agentIni.getVariables(tempAgentNickName);
					String tempResultantPattern = getResultantPattern(componentType,strComponent,testName,tempTestVariables);
					String tempTestValue = agentIni.getValue(tempAgentNickName,tempResultantPattern);

					String strTestStatus = "Excluded component(s)";
					if (tempTestValue.indexOf("-auto") > -1 && 
						tempTestValue.indexOf(" $") > -1 && hasUnConfiguredParam(tempTestValue))
					{
						strTestStatus = "Unconfigured component(s)";
					}
					else if (tempTestValue.indexOf("-auto") > -1 || tempTestValue.indexOf("-manual") > -1)
					{
						strTestStatus = "Configured component(s)";
					}

					if (isPortRelevantForTest)
					{
						String pattern = componentType + ":" + strComponent;
						String value = disableIni.getValue(componentType,pattern);
						if (value == null || value.length() == 0)
						{
							if (tempTestValue.length() == 0)
							{
								continue;
							}
							if (aListResultantIncludedComponents == null )
							{
								aListResultantIncludedComponents = new ArrayList();
							}
							strTestStatus = StringUtils.replace(strTestStatus,"Excluded","Configured");
							aListResultantIncludedComponents.add(strComponent+"||"+testName+" - "+strTestStatus);
						}
						else
						{
							value = "#" + value + "#";
							if (value.indexOf(strTestPattern1) > -1 || 
								value.indexOf(strTestPattern2) > -1 || 
								value.indexOf(strTestPattern3) > -1 || 
								value.indexOf(strTestPattern4) > -1)
							{
								if (aListResultantExcludedComponents == null )
								{
									aListResultantExcludedComponents = new ArrayList();
								}
								aListResultantExcludedComponents.add(strComponent+"||"+testName+" - "+strTestStatus);
							}
							else
							{
								if (tempTestValue.length() == 0)
								{
									continue;
								}
								if (aListResultantIncludedComponents == null )
								{
									aListResultantIncludedComponents = new ArrayList();
								}
								strTestStatus = StringUtils.replace(strTestStatus,"Excluded","Configured");
								aListResultantIncludedComponents.add(strComponent+"||"+testName+" - "+strTestStatus);
							}
						}
					}
					else
					{
						String pattern = "Default_server" + ":" + strComponent.substring(0,strComponent.indexOf(":"));
						String value = disableIni.getValue("Default_server",pattern);
						if (value == null || value.length() == 0)
						{
							if (tempTestValue.length() == 0)
							{
								continue;
							}
							if (aListResultantIncludedComponents == null )
							{
								aListResultantIncludedComponents = new ArrayList();
							}
							strTestStatus = StringUtils.replace(strTestStatus,"Excluded","Configured");
							aListResultantIncludedComponents.add(strComponent+"||"+testName+" - "+strTestStatus);
						}
						else
						{
							value = "#" + value + "#";
							if (value.indexOf(strTestPattern1) > -1 || 
								value.indexOf(strTestPattern2) > -1 || 
								value.indexOf(strTestPattern3) > -1 || 
								value.indexOf(strTestPattern4) > -1)
							{
								if (aListResultantExcludedComponents == null )
								{
									aListResultantExcludedComponents = new ArrayList();
								}
								aListResultantExcludedComponents.add(strComponent+"||"+testName+" - "+strTestStatus);
							}
							else
							{
								if (tempTestValue.length() == 0)
								{
									continue;
								}
								if (aListResultantIncludedComponents == null )
								{
									aListResultantIncludedComponents = new ArrayList();
								}
								strTestStatus = StringUtils.replace(strTestStatus,"Excluded","Configured");
								aListResultantIncludedComponents.add(strComponent+"||"+testName+" - "+strTestStatus);
							}
						}
					}
				}
			}
		}

		if (aListResultantExcludedComponents != null && aListResultantExcludedComponents.size() > 0)
		{
			for (int i=0;i < aListResultantExcludedComponents.size();i++)
			{
				String strcompTest = aListResultantExcludedComponents.get(i).toString();
				String strTestWithState = strcompTest.substring(strcompTest.indexOf("||")+2);
				String strTestName = strTestWithState.substring(0,strTestWithState.indexOf(" - ")).trim();
				if(!aListExcludedTest.contains(strTestName))
				{
					aListExcludedTest.add(strTestName);
				}
				ArrayList aListcomponents = (ArrayList)htableTestWithExcludedComponents.get(strTestWithState);
				if(aListcomponents == null)
				{
					aListcomponents = new ArrayList();
					aListcomponents.add(strcompTest.substring(0,strcompTest.indexOf("||")));
					htableTestWithExcludedComponents.put(strTestWithState,aListcomponents);
				}
				else
				{
					aListcomponents.add(strcompTest.substring(0,strcompTest.indexOf("||")));
				}
			}
		}

		if (aListResultantIncludedComponents != null && aListResultantIncludedComponents.size() > 0)
		{
			for (int i=0;i < aListResultantIncludedComponents.size();i++)
			{
				String strcompTest = aListResultantIncludedComponents.get(i).toString();
				String strTestWithState = strcompTest.substring(strcompTest.indexOf("||")+2);
				String strTestName = strTestWithState.substring(0,strTestWithState.indexOf(" - ")).trim();
				if(!aListIncludedTest.contains(strTestName))
				{
					aListIncludedTest.add(strTestName);
				}
				ArrayList aListcomponents = (ArrayList)htableTestWithIncludedComponents.get(strTestWithState);
				if(aListcomponents == null)
				{
					aListcomponents = new ArrayList();
					aListcomponents.add(strcompTest.substring(0,strcompTest.indexOf("||")));
					htableTestWithIncludedComponents.put(strTestWithState,aListcomponents);
				}
				else
				{
					aListcomponents.add(strcompTest.substring(0,strcompTest.indexOf("||")));
				}
			}
		}

		session.setAttribute("htableInitialExcludedComponents",htableTestWithExcludedComponents);
		session.setAttribute("htableInitialIncludedComponents",htableTestWithIncludedComponents);
	}

	// - Code Start -  To filter the component list which actually included/excluded in the UI design
	String strIncludedMovedComp = request.getParameter("strIncludedMovedComp");
	if (strIncludedMovedComp ==null )
	{
		strIncludedMovedComp = "";
	}

	String strExcludedMovedComp = request.getParameter("strExcludedMovedComp");
	if (strExcludedMovedComp ==null )
	{
		strExcludedMovedComp = "";
	}

	Hashtable htableSessionTestWithExcludedComponents = (Hashtable)session.getAttribute("htableSessionTestWithExcludedComponents");
	if (htableSessionTestWithExcludedComponents == null)
	{
		htableSessionTestWithExcludedComponents = new Hashtable();
	}

	Hashtable htableSessionTestWithIncludedComponents = (Hashtable)session.getAttribute("htableSessionTestWithIncludedComponents");
	if (htableSessionTestWithIncludedComponents == null)
	{
		htableSessionTestWithIncludedComponents = new Hashtable();
	}

	Hashtable htableInitialExcludedComponents = (Hashtable)session.getAttribute("htableInitialExcludedComponents");
	if (htableInitialExcludedComponents == null)
	{
		htableInitialExcludedComponents = new Hashtable();
	}

	Hashtable htableInitialIncludedComponents = (Hashtable)session.getAttribute("htableInitialIncludedComponents");
	if (htableInitialIncludedComponents == null)
	{
		htableInitialIncludedComponents = new Hashtable();
	}

	String strPrevSelectedTestList = request.getParameter("strPrevSelectedTestList");
	if (strPrevSelectedTestList == null)
	{
		strPrevSelectedTestList = "";
	}
	if (!strSelectedTestsInList.equals(strPrevSelectedTestList))
	{
		htableSessionTestWithExcludedComponents.clear();
		htableSessionTestWithIncludedComponents.clear();
	}

	//if (strExcludedMovedComp.length()>0)
	//{
		//StringTokenizer stObj = new StringTokenizer(strExcludedMovedComp,",");
		//while (stObj.hasMoreTokens())
		//{
			//String token = stObj.nextToken().toString();
			//String comps =token.substring(0,token.indexOf("$"));
			//String strTestNameWithState =token.substring(token.indexOf("$")+1);

			//ArrayList aListTemp = (ArrayList)htableInitialExcludedComponents.get(strTestNameWithState);
			//if (aListTemp == null)
			//{
				//aListTemp = new ArrayList();
			//}
			//if (strTestNameWithState.indexOf(" - ")>-1)
			//{
				//strTestNameWithState = strTestNameWithState.substring(0,strTestNameWithState.indexOf(" - "));
			//}

			//ArrayList aListSessExcludedComp = (ArrayList)htableSessionTestWithExcludedComponents.get(strTestNameWithState);
			//if (aListSessExcludedComp == null)
			//{
				//aListSessExcludedComp = new ArrayList();
			//}

			//ArrayList aListCheckIncludeList = (ArrayList)htableSessionTestWithIncludedComponents.get(strTestNameWithState);
			//if (aListCheckIncludeList == null)
			//{
				//aListCheckIncludeList = new ArrayList();
			//}

			//if (aListCheckIncludeList.contains(comps) && aListCheckIncludeList.size() > 0)
			//{
				//aListCheckIncludeList.remove(comps);
				//if (aListCheckIncludeList.size() > 0)
				//{
					//htableSessionTestWithIncludedComponents.put(strTestNameWithState,aListCheckIncludeList);
				//}
				//else
				//{
					//htableSessionTestWithIncludedComponents.remove(strTestNameWithState);
				//}
			//}
			//if (!aListSessExcludedComp.contains(comps) && !aListTemp.contains(comps))
			//{
				//aListSessExcludedComp.add(comps);
			//}
			//if (aListSessExcludedComp.size() > 0)
			//{
				//htableSessionTestWithExcludedComponents.put(strTestNameWithState,aListSessExcludedComp);
			//}
			//else
			//{
				//htableSessionTestWithExcludedComponents.remove(strTestNameWithState);
			//}
		//}
	//}


	//if (strIncludedMovedComp.length() > 0)
	//{
		//StringTokenizer stObj = new StringTokenizer(strIncludedMovedComp,",");
		//while (stObj.hasMoreTokens())
		//{
			//String token = stObj.nextToken();
			//String comps =token.substring(0,token.indexOf("$"));
			//String strTestNameWithState = token.substring(token.indexOf("$")+1);

			//ArrayList aListTemp = (ArrayList)htableInitialIncludedComponents.get(strTestNameWithState);
			//if (aListTemp == null)
			//{
				//aListTemp = new ArrayList();
			//}
			//if (strTestNameWithState.indexOf(" - ") > -1)
			//{
				//strTestNameWithState = strTestNameWithState.substring(0,strTestNameWithState.indexOf(" - "));
			//}

			//ArrayList aListSessIncludedComp = (ArrayList)htableSessionTestWithIncludedComponents.get(strTestNameWithState);
			//if (aListSessIncludedComp == null)
			//{
				//aListSessIncludedComp = new ArrayList();
			//}

			//ArrayList aListCheckExcludeList = (ArrayList)htableSessionTestWithExcludedComponents.get(strTestNameWithState);
			//if (aListCheckExcludeList == null)
			//{
				//aListCheckExcludeList = new ArrayList();
			//}

			//if (aListCheckExcludeList.contains(comps) && aListCheckExcludeList.size() > 0)
			//{
				//aListCheckExcludeList.remove(comps);
				//if (aListCheckExcludeList.size() > 0)
				//{
					//htableSessionTestWithExcludedComponents.put(strTestNameWithState,aListCheckExcludeList);
				//}
				//else
				//{
					//htableSessionTestWithExcludedComponents.remove(strTestNameWithState);
				//}
			//}
			//if (!aListSessIncludedComp.contains(comps) && !aListTemp.contains(comps))
			//{
				//aListSessIncludedComp.add(comps);
			//}
			//if (aListSessIncludedComp.size() > 0)
			//{
				//htableSessionTestWithIncludedComponents.put(strTestNameWithState,aListSessIncludedComp);
			//}
			//else
			//{
				//htableSessionTestWithIncludedComponents.remove(strTestNameWithState);
			//}
		//}
	//}

	//rootJson.put("htableSessionTestWithExcludedComponents",htableSessionTestWithExcludedComponents);
	//rootJson.put("htableSessionTestWithIncludedComponents",htableSessionTestWithIncludedComponents);

	//session.setAttribute("htableSessionTestWithExcludedComponents",htableSessionTestWithExcludedComponents);
	//session.setAttribute("htableSessionTestWithIncludedComponents",htableSessionTestWithIncludedComponents);

	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgIncludeExcludeComponents.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgIncludeExcludeComponents.jsp?reqfrom=navlink");
	}
	// - Code Ends -  To filter the component list which actually included/excluded in the UI design
	screenLabels.put("admin.test.INCLUDED COMPONENTS",_mapping.getTextDescription("admin.test.INCLUDED COMPONENTS"));
	screenLabels.put("admin.test.EXCLUDED COMPONENTS",_mapping.getTextDescription("admin.test.EXCLUDED COMPONENTS"));
	screenLabels.put("admin.test.Please select the component(s) to exclude",_mapping.getTextDescription("admin.test.Please select the component(s) to exclude"));
	screenLabels.put("admin.test.Please select the component(s) to include",_mapping.getTextDescription("admin.test.Please select the component(s) to include"));
	screenLabels.put("admin.test.Please choose a component type",_mapping.getTextDescription("admin.test.Please choose a component type"));
	screenLabels.put("admin.test.Please choose a test",_mapping.getTextDescription("admin.test.Please choose a test"));
	screenLabels.put("admin.test.Please include/exclude component(s)",_mapping.getTextDescription("admin.test.Please include/exclude component(s)"));
	screenLabels.put("admin.test.Please choose the test name",_mapping.getTextDescription("admin.test.Please choose the test name"));
	screenLabels.put("NamedUserAlert",_mapping.getTextDescription("admin.test.The following test(s) cannot be included/excluded as these tests are required for validating named user counts for eG licensing")+".");
	screenLabels.put("NamedUserAlertName",_mapping.getTextDescription("admin.test.Test name(s)")+":");
	screenLabels.put("admin.test.Update",_mapping.getTextDescription("admin.test.Update"));


	com.eg.IniFile egMgrMiscIni = new com.eg.IniFile (EgInstallInfo.getInstallDir()+"/manager/config/eg_mgrmisc.ini");
	String componentsLimit = egMgrMiscIni.getValue("MISC_ARGS","IncludeExcludeComponentsLimit");
	int componentsAllowedLimit = 100;
	if (!StringUtils.isNull(componentsLimit))
	{
		componentsAllowedLimit = Integer.parseInt(componentsLimit);
	}
	rootJson.put("componentsAllowedLimit",componentsAllowedLimit);


	if (isConfigSupport)
	{
		screenLabels.put("admin.server.Component type",_mapping.getTextDescription("admin.server.Component type"));

		JSONArray componentTypeArray = new JSONArray();
		JSONObject compObj = new JSONObject();

		if (listComponentTypes != null && listComponentTypes.size() > 0)
		{
			compObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a component type"));
			compObj.put("valueField","-1");
			componentTypeArray.add(compObj);
		}
		else
		{
			compObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			compObj.put("valueField","-1");
			componentTypeArray.add(compObj);
		}
		//EgName class is used to hold name and its localised name.
		for (int j=0; j < listComponentTypes.size(); j++)
		{
			EgName nameObj = (EgName)listComponentTypes.get(j);
			String actualname = nameObj.getActualName();
			String localname = nameObj.getLocalName();
			if (actualname.equals(componentType))
			{
				compObj.put("displayField",localname);
				compObj.put("valueField",actualname);
				componentTypeArray.add(compObj);
			}
			else
			{
				compObj.put("displayField",localname);
				compObj.put("valueField",actualname);
				componentTypeArray.add(compObj);			
			}
		}
		rootJson.put("componentTypeArray",componentTypeArray);

		screenLabels.put("admin.server.Test type",_mapping.getTextDescription("admin.server.Test type"));

		JSONArray testTypeVal = new JSONArray();
		JSONObject testTypeObj = new JSONObject();
		testTypeObj.put("displayField",_mapping.getTextDescription("admin.test.Performance"));
		testTypeObj.put("valueField","PerformanceTest");
		testTypeVal.add(testTypeObj);

		testTypeObj.put("displayField",_mapping.getTextDescription("admin.test.Configuration"));
		testTypeObj.put("valueField","ConfigurationTest");
		testTypeVal.add(testTypeObj);
		rootJson.put("TestType",testTypeVal);

		screenLabels.put("admin.server.Test name",_mapping.getTextDescription("admin.server.Test name"));

		JSONArray testNameArray = new JSONArray();
		JSONObject testNameObj = new JSONObject();

		if (aListEnabledTestForCompType == null || aListEnabledTestForCompType.size()==0)
		{
			testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			testNameObj.put("valueField","-1");
			testNameArray.add(testNameObj);
		}
		else
		{
			//if (totalComponents != null && totalComponents.length > componentsAllowedLimit)
			if (totalComponents > componentsAllowedLimit)
			{
				testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a test"));
				testNameObj.put("valueField","-1");
				testNameArray.add(testNameObj);
			}

			for (int i=0; i < aListEnabledTestForCompType.size(); i++)
			{
				EgName nameObj = (EgName)aListEnabledTestForCompType.get(i);
				String strTestName = nameObj.getActualName();
				String strTestDisplayValue = nameObj.getLocalName();
				if (aListselectedTests != null && aListselectedTests.contains(strTestName))
				{
					testNameObj.put("displayField",strTestDisplayValue);
					testNameObj.put("valueField",strTestName);
					testNameArray.add(testNameObj);
				}
				else
				{
					testNameObj.put("displayField",strTestDisplayValue);
					testNameObj.put("valueField",strTestName);
					testNameArray.add(testNameObj);
				}
			}
		}
		rootJson.put("TestName",testNameArray);
		rootJson.put("componentsAllowedLimitsExceed",false);
		if (totalComponents > componentsAllowedLimit)
		{
			rootJson.put("componentsAllowedLimitsExceed",true);
		}

	}
	else
	{
		screenLabels.put("admin.server.Component type",_mapping.getTextDescription("admin.server.Component type"));
		
		JSONArray componentTypeArray = new JSONArray();
		JSONObject compObj = new JSONObject();

		if (listComponentTypes != null && listComponentTypes.size() > 0)
		{
			compObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a component type"));
			compObj.put("valueField","-1");
			componentTypeArray.add(compObj);
		}
		else
		{
			compObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			compObj.put("valueField","-1");
			componentTypeArray.add(compObj);
		}
		//EgName class is used to hold name and its localised name.
		for (int j=0; j < listComponentTypes.size(); j++)
		{
			EgName nameObj = (EgName)listComponentTypes.get(j);
			String actualname = nameObj.getActualName();
			String localname = nameObj.getLocalName();
			if (actualname.equals(componentType))
			{
				compObj.put("displayField",localname);
				compObj.put("valueField",actualname);
				componentTypeArray.add(compObj);
			}
			else
			{
				compObj.put("displayField",localname);
				compObj.put("valueField",actualname);
				componentTypeArray.add(compObj);
			}
		}
		rootJson.put("componentTypeArray",componentTypeArray);
		screenLabels.put("admin.server.Test name",_mapping.getTextDescription("admin.server.Test name"));


		JSONArray testNameArray = new JSONArray();
		JSONObject testNameObj = new JSONObject();
		if (aListEnabledTestForCompType == null)
		{
			testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			testNameObj.put("valueField","-1");
			testNameArray.add(testNameObj);
		}
		else
		{
			if (totalComponents > componentsAllowedLimit)
			{
				testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a test"));
				testNameObj.put("valueField","-1");
				testNameArray.add(testNameObj);
			}

			for (int i=0; i < aListEnabledTestForCompType.size(); i++)
			{
				EgName nameObj = (EgName)aListEnabledTestForCompType.get(i);
				String strTestName = nameObj.getActualName();
				String strTestDisplayValue = nameObj.getLocalName();
				if (aListselectedTests != null && aListselectedTests.contains(strTestName))
				{
					testNameObj.put("displayField",strTestDisplayValue);
					testNameObj.put("valueField",strTestName);
					testNameArray.add(testNameObj);

				}
				else
				{
					testNameObj.put("displayField",strTestDisplayValue);
					testNameObj.put("valueField",strTestName);
					testNameArray.add(testNameObj);
				}
			}
		}
		rootJson.put("TestName",testNameArray);
		rootJson.put("TestType",testType);

		rootJson.put("componentsAllowedLimitsExceed",false);

		if (totalComponents > componentsAllowedLimit)
		{
			rootJson.put("componentsAllowedLimitsExceed",true);
		}
	}

	//JSONArray commonArray = new JSONArray();
	JSONArray includedArray = new JSONArray();
	JSONObject includedObj = new JSONObject();

	JSONObject configuredObj = new JSONObject();
	JSONArray configuredArray = new JSONArray();
	JSONObject unconfiguredObj = new JSONObject();
	JSONArray unconfiguredArray = new JSONArray();

	//JSONObject commonObj = new JSONObject();
	//String existingComponents = "";

	aListIncludedTest = sorter.getSortedTestList(aListIncludedTest);
	for (int k=0;k<aListIncludedTest.size();k++)
	{
		String strIncludedComponentGroup = "";
		String strIncludedComponentGrouprepl = "";
		EgName nameObj = (EgName)aListIncludedTest.get(k);
		String strTestName = nameObj.getActualName();

		includedObj.put("groupField1",_mapping.getTestDescription(strTestName));
		//commonObj.put("groupField1",_mapping.getTestDescription(strTestName));

		for (int m=0;m < 3;m++)
		{
			if (m == 0)
			{
				strIncludedComponentGroup = strTestName + " - Unconfigured component(s)";
			}
			else if (m == 1)
			{
				strIncludedComponentGroup = strTestName + " - Configured component(s)";
			}
			else
			{
				strIncludedComponentGroup = strTestName + " - Excluded component(s)";
			}
			ArrayList aListOfIncludedComp = (ArrayList)htableTestWithIncludedComponents.get(strIncludedComponentGroup);
			if (aListOfIncludedComp != null && !aListOfIncludedComp.isEmpty())
			{
				String testMap = strIncludedComponentGroup.substring(0,strIncludedComponentGroup.indexOf(" - "));
				String testStatus  = StringUtils.replace(strIncludedComponentGroup,testMap,"");
				testStatus = testStatus.substring(3);

				if (testStatus.startsWith("Configured"))
				{
					configuredObj.put("groupField1",_mapping.getTestDescription(strTestName));
				}
				else if (testStatus.startsWith("Unconfigured"))
				{
					unconfiguredObj.put("groupField1",_mapping.getTestDescription(strTestName));
				}

				for (int i=0;i < aListOfIncludedComp.size();i++)
				{
					String strComponent = (String)aListOfIncludedComp.get(i);
					String displayName = strComponent;
					if (displayName.endsWith(":NULL"))
					{
						displayName = displayName.substring(0,displayName.indexOf(":NULL"));
					}
					includedObj.put("displayField",displayName);
					strIncludedComponentGrouprepl = strIncludedComponentGroup;
					if(strIncludedComponentGrouprepl != null){
						if(strIncludedComponentGrouprepl.contains("("))
							strIncludedComponentGrouprepl = StringUtils.replace(strIncludedComponentGrouprepl,"(","|lbr|");
						if(strIncludedComponentGrouprepl.contains(")"))
							strIncludedComponentGrouprepl = StringUtils.replace(strIncludedComponentGrouprepl,")","|rbr|");
					}
					includedObj.put("valueField",strComponent+"$"+strIncludedComponentGrouprepl);
					includedArray.add(includedObj);


					if (testStatus.startsWith("Configured"))
					{
						//configuredObj.put("groupField1",_mapping.getTestDescription(strTestName));
						configuredObj.put("displayField",displayName);
						configuredObj.put("valueField",strComponent+"$"+strIncludedComponentGrouprepl);
						configuredArray.add(configuredObj);
					}
					else if (testStatus.startsWith("Unconfigured"))
					{
						//unconfiguredObj.put("groupField1",_mapping.getTestDescription(strTestName));
						unconfiguredObj.put("displayField",displayName);
						unconfiguredObj.put("valueField",strComponent+"$"+strIncludedComponentGrouprepl);
						unconfiguredArray.add(unconfiguredObj);

					}
					//existingComponents += strComponent+"$"+strIncludedComponentGroup + ",";

					//commonObj.put("displayField",displayName);
					//commonObj.put("valueField",strComponent+"$"+strIncludedComponentGroup);
					//commonArray.add(commonObj);
				}
			}
		}
	}

	//if(existingComponents.indexOf(",")!=-1)
	//{
		//existingComponents = existingComponents.substring(0,existingComponents.lastIndexOf(","));
		//rootJson.put("existingComponents",existingComponents);
	//}

	rootJson.put("configuredArray",configuredArray);
	rootJson.put("unconfiguredArray",unconfiguredArray);
	rootJson.put("includedArray",includedArray);

	JSONArray excludedArray = new JSONArray();
	JSONObject excludedObj = new JSONObject();

	aListExcludedTest = sorter.getSortedTestList(aListExcludedTest);
	for (int k=0;k<aListExcludedTest.size();k++)
	{
		String strExcludedComponentGroup = "";
		String strExcludedComponentGrouprepl = "";
		EgName nameObj = (EgName)aListExcludedTest.get(k);
		String strTestName = nameObj.getActualName();

		excludedObj.put("groupField1",_mapping.getTestDescription(strTestName));
		//commonObj.put("groupField1",_mapping.getTestDescription(strTestName));

		for (int m=0;m < 3;m++)
		{
			if (m == 0)
			{
				strExcludedComponentGroup = strTestName + " - Unconfigured component(s)";
			}
			else if (m == 1)
			{
				strExcludedComponentGroup = strTestName + " - Configured component(s)";
			}
			else
			{
				strExcludedComponentGroup = strTestName + " - Excluded component(s)";
			}

			ArrayList aListOfExcludedComp = (ArrayList)htableTestWithExcludedComponents.get(strExcludedComponentGroup);

			if (aListOfExcludedComp != null && !aListOfExcludedComp.isEmpty())
			{
				String testMap = strExcludedComponentGroup.substring(0,strExcludedComponentGroup.indexOf(" - "));
				String testStatus  = StringUtils.replace(strExcludedComponentGroup,testMap,"");
				testStatus = testStatus.substring(3);

				for (int i=0;i < aListOfExcludedComp.size();i++)
				{
					String strComponent = (String)aListOfExcludedComp.get(i);
					String displayName = strComponent;
					if (displayName.endsWith(":NULL"))
					{
						displayName = displayName.substring(0,displayName.indexOf(":NULL"));
					}
					excludedObj.put("displayField",displayName);
					strExcludedComponentGrouprepl = strExcludedComponentGroup;
					if(strExcludedComponentGrouprepl != null){
						if(strExcludedComponentGrouprepl.contains("("))
							strExcludedComponentGrouprepl = StringUtils.replace(strExcludedComponentGrouprepl,"(","|lbr|");
						if(strExcludedComponentGrouprepl.contains(")"))
							strExcludedComponentGrouprepl = StringUtils.replace(strExcludedComponentGrouprepl,")","|rbr|");
					}
					excludedObj.put("valueField",strComponent+"$"+strExcludedComponentGrouprepl);
					excludedArray.add(excludedObj);

					//commonObj.put("displayField",displayName);
					//commonObj.put("valueField",strComponent+"$"+strExcludedComponentGroup);
					//commonArray.add(commonObj);
				}
			}
		}
	}
	rootJson.put("excludedArray",excludedArray);
	//rootJson.put("commonArray",commonArray);

	//session.setAttribute("adminLastAccessedURL","/final/admin/EgIncludeAndExcludeComponents.jsp?componentType="+componentType+"&previousComponentType="+componentType+"&testName="+strSelectedTestsInList+"&previousTestName="+strSelectedTestsInList+"&selectedTest="+strSelectedTestsInList+"&testType="+testType+"&previousTestType="+testType+"&action="+action);
	session.setAttribute("adminLastAccessedURL","/final/admin/EgIncludeAndExcludeComponents.jsp?componentType="+componentType+"&previousComponentType="+componentType+"&previousTestName="+strSelectedTestsInList+"&testType="+testType+"&previousTestType="+testType+"&action="+action);

	rootJson.put("screenLabels",screenLabels);
	rootJson.put("success",true);
	out.println(rootJson.toString());
%>




