<%
/*****************************************************************************
*  File         : 	Egdefaultp.jsp
*  Purpose      :       This is the process page for configuring default
			thresholds.

*  Version      : 	0.0
*  Creation Date: 	22/11/2000
*  Last Modified:       28/10/2003 //Saravanan - Multiple threshold changes
			05/06/2001 // Bala - IniFile save
			10/06/2004 //Saravanan K - Manager Clustering changes   
			25/03/2006	// T.Thirumal Azhagan Changes for MIX policy.
*  Author       :	Lavanya.T.K
******************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import ="egurkha.EgDbAdapterUI"%>
<%@ page import ="com.eg.EgDbAdapterTypeUI"%>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgDateInfo" %>
<%@ page import="com.eg.EgDbInfo" %>
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgConfigInfo" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.eg.UpdateAndTransmitTrendInfo" %>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.eg.EgTesterInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import="egurkha.*" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	EgDbAdapterUI egDb;
	IniFile servicesIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	boolean isUpdateToDb= "true".equalsIgnoreCase(servicesIni.getValue("MISC_ARGS","updateDefaultThreshToDb"));
	int count = 0;

	/* code for auditlog starts */

	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Thresholds");
	ArrayList arrayList = (ArrayList) session.getAttribute("previousValues");

	if(arrayList != null && arrayList.size() >0)
	{
		for(int i=0;i<arrayList.size();i++)
		{
			ArrayList innerArrayList = (ArrayList) arrayList.get(i);
			String measurement = innerArrayList.get(0).toString().trim();;
			String absA = innerArrayList.get(1).toString().trim();
			String relA = innerArrayList.get(2).toString().trim();
			String absB = innerArrayList.get(3).toString().trim();
			String relB = innerArrayList.get(4).toString().trim();
			String alarmPolicy = innerArrayList.get(5).toString().trim();

			String absACurrent = request.getParameter("absA"+i).trim();
			String relACurrent = request.getParameter("relA"+i).trim();
			String absBCurrent = request.getParameter("absB"+i).trim();
			String relBCurrent = request.getParameter("relB"+i).trim();
			String alarmPolicyCurrent = request.getParameter("alarm"+i).trim();

			measurement = measurement.substring(measurement.indexOf(":")+1);

			if (absACurrent.equals("-/-/-"))
			{
				absACurrent = "none";
			}
			if (relACurrent.equals("-/-/-"))
			{
				relACurrent = "none";
			}
			if (absBCurrent.equals("-/-/-"))
			{
				absBCurrent = "none";
			}
			if (relBCurrent.equals("-/-/-"))
			{
				relBCurrent = "none";
			}

			if(!absA.equals(absACurrent))
			{
				count = count +1;
				auditLogThread.setPreviousValue(measurement,"Minimum-Absolute " + absA);
				auditLogThread.setCurrentValue(measurement,"Minimum-Absolute " + absACurrent);
			}

			if(!relA.equals(relACurrent))
			{
				count = count +1;
				auditLogThread.setPreviousValue(measurement,"Minimum-Relative " + relA);
				auditLogThread.setCurrentValue(measurement,"Minimum-Relative " + relACurrent);
			}

			if(!absB.equals(absBCurrent))
			{
				count = count +1;
				auditLogThread.setPreviousValue(measurement,"Maximum-Absolute " + absB);
				auditLogThread.setCurrentValue(measurement,"Maximum-Absolute " + absBCurrent);
			}

			if(!relB.equals(relBCurrent))
			{
				count = count +1;
				auditLogThread.setPreviousValue(measurement,"Maximum-Relative " + relB);
				auditLogThread.setCurrentValue(measurement,"Maximum-Relative " + relBCurrent);
			}

			if(!alarmPolicy.equals(alarmPolicyCurrent))
			{
				count = count +1;
				auditLogThread.setPreviousValue(measurement,"Alarms " + alarmPolicy);
				auditLogThread.setCurrentValue(measurement,"Alarms " + alarmPolicyCurrent);
			}
		}
	}
	auditLogThread.setValue("Activity","Configure Thresholds");
	/* code for auditlog ends */
%>

<jsp:useBean id="prgBean" class="egurkha.EgTestParamBean" scope="page" />
<jsp:useBean id="threshBean" class="egurkha.EgThresholdBean" scope="page" />

<%!
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	EgDateInfo dat=new EgDateInfo();
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgThresholdInfo dbThresh =new EgThresholdInfo("manager");
	EgTesterInfo testerInfo =new EgTesterInfo("manager");
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	TestBean testbean=new TestBean();
	String subject = "DEFAULT_THRESHOLDS";
	String subjects = "MEASUREMENT_DB_MAPPING";
	String user_thresh = "USER_THRESHOLDS";
	String descr_thresh = "DESCRIPTOR_THRESHOLDS"; // SIFY
	String strIniVar[];
	String que="";
	String testName = "";
	String strIniVal = "";
	StringTokenizer st = null;
	StringTokenizer st1 = null;
	String strTok = "";
	int stCount = 0;
	String measure = "";
	String policy = "";
	String iniVal = "";
	String alarm = "";
	String server = "";
	String min="";
	String max="";
	String pol="";
	String minStr="";
	String maxStr="";
	int counter=0;
	String str="";
	String query="";
	String temp="";
	String measUpdat="";
	String threshUpdat="";
	String minUpdat="";
	String maxUpdat="";
	String alarmUpdat="";
	String priorUpdat="";
	String currentTime="";
	String strFull="";
	String prev="";
	String threshTable="";
	String trgtHost="";
	String port="";
	int f=0;
	int l=0;
	String startTime="";
	Vector vec= new Vector(); 
	Vector vec1=new Vector();
	Vector v_values = new Vector();
	Vector v_absol = new Vector();
	Vector v_temporary = new Vector();
	Vector v_prev = new Vector();
	Vector host = new Vector();
	// Vector portNo = new Vector(); // Removed - SIFY
	Vector sid = new Vector(); // Added - SIFY
	int historyInDays=14; // number of days of history we'll use in computing thresholds
	long msecPerHr = ((long)3600)*1000;
	long msecPerDay = msecPerHr*24;
	long tim;
	long current;
	String time="";
	String measur="";
	String status="";
	String userThreshVal[];
	ArrayList globalThresholds=testerInfo.getGlobalThresholds();
	// Thirumal Monday, March 13, 2006
	String absoluteA = "";
	String absoluteB = "";
	String relativeA = "";
	String relativeB = "";
%>
<%
	UpdateAndTransmitTrendInfo updateHelper = new UpdateAndTransmitTrendInfo();
	String s_tempPrior = "";
	String threshType = request.getParameter("threshType");

	String updateParam = request.getParameter("updateparam");
	vec=new Vector();
	vec1=new Vector();
	v_prev = new Vector();
	v_temporary=(Vector)session.getValue("v_compare");
	v_absol=(Vector)session.getValue("v_absolute");
	server = (String)v_absol.elementAt(0);
	testName = (String)v_absol.elementAt(1);
	v_values = new Vector();
	host = new Vector();
	sid = new Vector();
	currentTime=dat.egetDate();

	if(updateParam == null || updateParam.length() == 0)
	{
		v_values.addElement(_mapping.getTextDescription("admin.threshold.Threshold configuration for tests"));
		v_values.addElement("EgTestList.jsp?qctr=1&server="+server);
	}
	else
	{
		v_values.addElement(_mapping.getTextDescription("admin.threshold.Add new tests"));
		v_values.addElement("EgUDTest.jsp");
	}
	/* code for auditlog starts */

	String serverName = (String) session.getAttribute("server");
	if(serverName != null)
	if(!serverName.endsWith("_ex"))
		serverName = "$ctype$:" + serverName;

	String currentTestName = testName;
	if(currentTestName != null)
	if(!currentTestName.endsWith("_ex"))
		currentTestName = "$test$:" + currentTestName;
	if (count >= 1)
	{
		if (!StringUtils.isNull((String) session.getAttribute("server")))
		{
			auditLogThread.setValue("Description","Default thresholds for " + currentTestName + " of " + serverName + " have been modified");
		}
		else
		{
			auditLogThread.setValue("Description","Default thresholds for " + currentTestName + " have been modified");
		}
		auditLogThread.sendItToDB();
	}
	/* code for auditlog ends */

	if(egSpecs.isPortRelevantForTest(testName))
	{
		if(updateParam == null || updateParam.length() == 0)
		{
			v_values.addElement(_mapping.getTextDescription("admin.threshold.Default thresholds for the test")+" " +_mapping.getTestDescription(testName)+"("+_mapping.getComponentTypeDescription(server)+")");
		}
		else
		{
			v_values.addElement(_mapping.getTextDescription("admin.threshold.Default thresholds for the test")+" "+_mapping.getTestDescription(testName));
		}
	}
	else
	{
		v_values.addElement(_mapping.getTextDescription("admin.threshold.Default thresholds for the test")+" "+_mapping.getTestDescription(testName));
	}
	prgBean.createFile("eg_thresholds.ini");
	strIniVar = prgBean.getVariables(subject);
	String[] userThreshVal = prgBean.getVariables(user_thresh);
	if(userThreshVal.length > 0)
	{
		for(int r=0; r<userThreshVal.length; r++)
		{
			if(userThreshVal[r].startsWith(testName))
			{
				st1 = new StringTokenizer(userThreshVal[r],":");
				String test = st1.nextToken();
				if (st1.countTokens() == 1) {
					host.add(st1.nextToken()+":NULL");
					sid.add(EgConfigInfo.infoFieldSeparator);
				}
				else if (st1.countTokens() == 2) {
					host.add(st1.nextToken()+":"+st1.nextToken());
					sid.add(EgConfigInfo.infoFieldSeparator);
				}
				else {
					host.add(st1.nextToken()+":"+st1.nextToken());
					sid.add(st1.nextToken()+EgConfigInfo.infoFieldSeparator);
				}
			}
		}
	}
	String []descThreshVal = prgBean.getVariables(descr_thresh);
	if(descThreshVal.length > 0)
	{
		for(int r=0; r<descThreshVal.length; r++)
		{
			if(descThreshVal[r].startsWith(testName))
			{
				StringTokenizer sss = new StringTokenizer(descThreshVal[r],"#");
				if (sss.countTokens() < 2)
					continue;
				st1 = new StringTokenizer (sss.nextToken(),":");
				String test = st1.nextToken();
				if (st1.countTokens() == 1) {
					host.add(st1.nextToken()+":NULL");
					sid.add(EgConfigInfo.infoFieldSeparator);
				}
				else if (st1.countTokens() == 2) {
					host.add(st1.nextToken()+":"+st1.nextToken());
					sid.add(EgConfigInfo.infoFieldSeparator);
				}
				else {
					host.add(st1.nextToken()+":"+st1.nextToken());
					sid.add(st1.nextToken()+EgConfigInfo.infoFieldSeparator);
				}
			}
		}
	}

	for(int i=0; i<strIniVar.length; i++)
	{
		if(strIniVar[i].equals(testName))
		{
			strIniVal = prgBean.getStrValue(subject,strIniVar[i]);
			StringTokenizer st1=new StringTokenizer(strIniVal,",");
			while(st1.hasMoreTokens())
			{
				vec1.add(st1.nextToken());
			}
			counter=0;
			for(int l=2;l<v_absol.size();l=l+6)
			{
				pol=request.getParameter("pol"+counter);
				v_absol.set(l+1,"mix");
				absoluteA = request.getParameter("absA"+counter);
				absoluteB = request.getParameter("absB"+counter);
				relativeA = request.getParameter("relA"+counter);
				relativeB = request.getParameter("relB"+counter);
				if (absoluteA.length() == 0)
					absoluteA = "none";
				if (absoluteB.length() == 0)
					absoluteB = "none";
				if (relativeA.length() == 0)
					relativeA = "none";
				if (relativeB.length() == 0)
					relativeB = "none";
				relativeA = relativeA.toLowerCase();
				relativeB = relativeB.toLowerCase();
				max = getInMIXFormat(absoluteB,relativeB);
				min = getInMIXFormat(absoluteA,relativeA);

				if(pol.equals("none"))
				{
					//min="none";
					//max="none";
				}
				// Code specific for multiple thresholds ..... starts 
				/*
				if(threshType != null && !threshType.equalsIgnoreCase("Multiple") 
					&& ((pol.equals("absolute")) || (pol.equals("relative"))))
				{
					s_tempPrior = request.getParameter("prior"+counter);
					if(s_tempPrior.equalsIgnoreCase(ui.getStateDisplayLabel("LOW")))
						s_tempPrior = "Low";
					if(s_tempPrior.equalsIgnoreCase(ui.getStateDisplayLabel("INTERMEDIATE")))
						s_tempPrior = "Medium";
					if(s_tempPrior.equalsIgnoreCase(ui.getStateDisplayLabel("HIGH")))
						s_tempPrior = "High";

					if(s_tempPrior.equals("Low"))
					{
						if(!min.equals("none") && (min.indexOf("/") < 0))
							min = "-/-/"+min;
						if(!max.equals("none") && (max.indexOf("/") < 0))
							max = "-/-/"+max;
					}
					else if(s_tempPrior.equals("High"))
					{
						if(!min.equals("none") && (min.indexOf("/") < 0))
							min = min+"/-/-";
						if(!max.equals("none") && (max.indexOf("/") < 0))
							max = max+"/-/-";
					}
					else // May be used for medium but no use now....
					{
						if(!min.equals("none") && (min.indexOf("/") < 0))
							min = "-/"+min+"/-";
						if(!max.equals("none") && (max.indexOf("/") < 0))
							max = "-/"+max+"/-";
					}
				}	*/
				// Multiple thresholds .......ends

				if(min.equals("none"))
					min="-1";
				v_absol.set(l+2,min);
				if(max.equals("none"))
					max="-1";
				v_absol.set(l+3,max);
				v_absol.set(l+4,request.getParameter("alarm"+counter));
				//v_absol.set(l+5,request.getParameter("prior"+//counter));
				v_absol.set(l+5, "HML"); // This has now become a dummy entry....
				counter=counter+1;
			}
			for(int m=2;m<v_absol.size();m=m+6)
			{
				minStr=(String)v_absol.elementAt(m+2);
				if(minStr.equals("-1"))
					minStr="none";
				maxStr=(String)v_absol.elementAt(m+3);
				if(maxStr.equals("-1"))
					maxStr="none";
				str=(String)v_absol.elementAt(m)+":" + (String)v_absol.elementAt(m+1)+ ":" + minStr + ":" + maxStr;
				strFull=str+":"+(String)v_absol.elementAt(m+4)+ ":" + (String)v_absol.elementAt(m+5);
				//v_values.addElement(strFull);
				v_prev.addElement(str);
			}
			
			ArrayList childlist=testbean.getDupChildTests(currentTestName);
			if(childlist != null && childlist.size()>0)
			{
				String child=childlist.toString();
				child=child.substring(1,child.length()-1);
				v_values.addElement(_mapping.getTextDescription("admin.threshold.Your changes have been updated successfully for ")+" "+currentTestName+" . Please reconfigure its associates which are "+child);
			
			}
			else
			{
				v_values.addElement(_mapping.getTextDescription("admin.threshold.Your changes have been updated successfully")+".");
			}
			
			
			
			if(isUpdateToDb && !globalThresholds.contains(testName))
			{
				egDb=EgDbAdapterTypeUI.getObject();
				try
				{
					ArrayList a = new ArrayList();
					ArrayList minarray=new ArrayList();
					ArrayList maxarray=new ArrayList();
					ArrayList parametersToSec= new ArrayList();
					startTime=dbInfo.measurementStartTimeColumn;
					trgtHost=dbInfo.targetHostColumn;
					port= dbInfo.portNoColumn;
					for(int y=0;y<v_temporary.size();y++)
					{
						ArrayList params = new ArrayList();
						if(v_prev.indexOf(v_temporary.get(y))<0)
						{
							prev=(String)v_temporary.get(y);
							temp=(String)v_prev.get(y);
							threshTable = dbInfo.getThresholdTableForTest(testName);
							st = new StringTokenizer(temp,":");
							measUpdat=st.nextToken();
							threshUpdat=st.nextToken();
							minUpdat=st.nextToken();
							if(minUpdat.equals("none"))
								minUpdat="-1";
							maxUpdat=st.nextToken();
							if(maxUpdat.equals("none"))
								maxUpdat="-1";
							time=dbInfo.dbDate(currentTime);
							tim=dat.egetUTCDate();
							current=(threshBean.trimTimeToHr(tim))-1000;
							time = dat.egetDate(current);
							String measures[] =dbThresh.
							getMeasurementsForTest(testName);
							String[] mColumns=new String[2];
							mColumns = dbInfo.getThresholdColumnsForMeasure(testName,measures[y]);
							String variab = testName+":"+measures[y];
							//String measur=prgBean.getStrValue(subjects,variab);
							int place=mColumns[0].lastIndexOf("_MIN");
							measur=mColumns[0].substring(0,place);

							/*if(((prev.indexOf(
								"absolute")>-1) &&
								threshUpdat.equals(
								"relative")) ||
								((prev.indexOf(
								"none")>-1) &&
								threshUpdat.equals(
									"relative")))
							*/
							if(threshUpdat != null && threshUpdat.equals("mix"))
							{
								a.add(measur);
								if (minUpdat.indexOf("sqc") > -1 || maxUpdat.indexOf("sqc") > -1)
								{
									if(minUpdat.equals("-1") || minUpdat.indexOf("sqc") > -1)
									{
										minarray.add(minUpdat);
									}
									else
									{
										minarray.add("sqc");
									}
									if(maxUpdat.equals("-1") || maxUpdat.indexOf("sqc") > -1)
									{
										maxarray.add(maxUpdat);
									}
									else
									{
										maxarray.add("sqc");
									}
								}
								else
								{
									params.add(threshTable);
									params.add(mColumns);
									params.add(minUpdat);
									params.add(maxUpdat);
									params.add(startTime);
									params.add(time);
									params.add(que);
									params.add(trgtHost);
									params.add(port);
									params.add(host);
									params.add(dbInfo.infoColumn);
									params.add(sid);
									parametersToSec.add(params);
								}
							}
							/*
							else
							{
								query=egDb.UpdateEgDefaultP(threshTable,mColumns,
									minUpdat,maxUpdat,startTime,time,que,trgtHost,port,host,
									dbInfo.infoColumn, sid);
								updateArr.add(query);
							}*/
						}
						/*
						else
						{
							//out.println("It is the same");
						}*/
					}
					/*if(updateArr.size()>0)
					{
						status = egDb.setConnection();
						for(int y=0; y<updateArr.size();y++)
						{
							String quer =(String)updateArr.get(y);
							boolean insert=egDb.UpdateToDb(quer);
						}
						boolean release=egDb.releaseConnection(false);
					}*/
					if(parametersToSec.size()>0)
					{
						boolean result = updateHelper.updateThresholds(parametersToSec,"Default");
					}
					if(a.size()>0)
					{
						String [] measures = new String[a.size()];
						String [] minVal = new String[minarray.size()];
						String [] maxVal = new String[maxarray.size()];
						for(int g=0; g<a.size();g++)
						{
							measures[g]=(String)a.get(g);
							minVal[g]=(String)minarray.get(g);
							maxVal[g]=(String)maxarray.get(g);
						}
						updateHelper.computeThresholds(testName,
							measures,minVal,maxVal,tim,
							"default","null","null","null","null"); // SIFY
					}
					EgDbAdapterTypeUI.releaseObject(egDb);
				}
				catch(Exception e)
				{
					/*if(!status.equals("CONNECTED"))
					{
						out.println("Connection could not be established");
					}
					try
					{
						egDb.releaseConnection(true);
					}
					catch(Exception e1){}
					out.println("Error in updating database");*/
					if(egDb != null)
						EgDbAdapterTypeUI.releaseObject(egDb);
				}
			}
			iniVal="";
			for(int r=2;r<v_absol.size();r=r+6)
			{
				iniVal =iniVal+(String)v_absol.elementAt(r) +
					":" + (String)v_absol.elementAt(r+1) +
					":" + (String)v_absol.elementAt(r+2) +
					":" + (String)v_absol.elementAt(r+3)+
					":" + (String)v_absol.elementAt(r+4)+
					":" + (String)v_absol.elementAt(r+5);
				if(r<(v_absol.size()-6))
					iniVal=iniVal+",";
			}

			prgBean.createSyncFile("eg_thresholds.ini","save");
			prgBean.setValues(subject,testName,iniVal);
			prgBean.saveFile();
			prgBean.releaseInstance();
			EgThresholdInfo.setUpdated();
			session.putValue("vec_Results",v_values);
			//response.sendRedirect("EgResults.jsp");

			String agg_test_name=request.getParameter("agg_test_name");
			String normalTestName=request.getParameter("normalTestName");
			if(!StringUtils.isNull(agg_test_name) && !StringUtils.isNull(normalTestName))
			{
				String url = "aggShowComponentTypes.jsp?agg_test_name="+agg_test_name;
%>
				<jsp:forward page="<%=url%>" />
<%			
			}
			else
			{
%>
			<jsp:forward page="EgResults.jsp" />
<%
			}
		}
	}
%>

<%!
	/*
	*	T.Thirumal Azhagan Monday, March 13, 2006  . Method for MIX policy
	*/
	public String getInMIXFormat(String abs,String rel)
	{
		String ret = "";
		if (!abs.equalsIgnoreCase("none") && !rel.equalsIgnoreCase("none"))
		{
			StringTokenizer s1 = new StringTokenizer(abs,"/");
			StringTokenizer s2 = new StringTokenizer(rel,"/");
			if (s1.countTokens() == 3 && s2.countTokens() == 3)
			{
				String H0 = s1.nextToken();
				String M = s1.nextToken();
				String L = s1.nextToken();
				String h0 = s2.nextToken();
				String m = s2.nextToken();
				String l = s2.nextToken();
				String one = getFormat(H0,h0);
				String two = getFormat(M,m);
				String three = getFormat(L,l);
				ret = one+"/"+two+"/"+three;
			}
		}
		else if (abs.equalsIgnoreCase("none") && rel.equalsIgnoreCase("none"))
		{
			ret = abs;
		}
		else if (abs.equalsIgnoreCase("none"))
		{
			ret = rel;
		}
		else if (rel.equalsIgnoreCase("none"))
		{
			ret = abs;
		}
		return ret;
	}

	public String getFormat(String H,String h)
	{
		String one = new String();
		if (!(H.equals("-")) && !(h.equals("-")))
		{
			one = H+"&"+h;
		}
		else if (H.equals("-") && h.equals("-"))
		{
			one = "-";
		}
		else if (H.equals("-"))
		{
			one = h;
		}
		else
		{
			one = H;
		}
		return one;
	}
%>