<%
/*
 *       Name            :		EgUDTestJson.jsp
 *       CreationDate    :       01/10/2001
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>

<%@ page import="egurkha.TransactionBean"%>
<%@ page import="egurkha.TestBean"%>
<%@ page import="egurkha.EgUIUtils" %>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray "%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	
	String egTitleSearchStr = request.getParameter("searchStr");
	egTitleSearchStr = EgUIUtils.decodeSecurityChar(egTitleSearchStr);
	boolean isSearchResult =(egTitleSearchStr!=null && !egTitleSearchStr.trim().equals(""));
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}
	TestBean testBean = new TestBean();
	ArrayList tests = testBean.getUDTests();

	//tell whether _cf test enabled or not
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;

	//ensure whether the user is configuration management enabled
	if (_user != null && isConfigSupported)
	{
		EgUserRole userRole = _user.getUserRole();
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}
	rootJSON.put("isConfigSupported",isConfigSupported);
	TransactionBean trans = new TransactionBean();

	Collections.sort(tests,String.CASE_INSENSITIVE_ORDER);
	if(tests == null || tests.size() == 0)
	{
		rootJSON.put("noUDTestsFound",true);
	}
	else
	{
		rootJSON.put("noUDTestsFound",false);
		String strVal = "";
		boolean searchItemFound = false;
		JSONArray testList = new JSONArray();
		JSONObject obj = new JSONObject();
		for(int i=0; i<tests.size(); i++)
		{
			String test = (String) tests.get(i);
			if (!isConfigSupported && test.indexOf("_cf_ex") > -1)
			{
				continue;
			}
			if (isSearchResult && !doesExist(searchList,test))
			{
				continue;
			}
			searchItemFound=true;
			String testType = testBean.getTestType(test);
			String jsp = null;
			if(testType.equals("Custom"))
			{
				jsp = "EgConfigTestMeasure.jsp";
			}
			else if(testType.equals("Script/Batch File"))
			{
				jsp = "EgConfigScriptMeasure.jsp";
			}
			else if(testType.equalsIgnoreCase("Sql Query"))
			{
				jsp = "EgConfigSqlMeasure.jsp";
				testType = "SQL Query";
			}
			else if(testType.equals("Perfmon"))
			{
				jsp = "EgConfigPerfmonMeasure.jsp";
			}
			else if(testType.equalsIgnoreCase("Jmx"))
			{
				jsp = "EgMBeanDiscovery.jsp";
				testType = "JMX";
			}
			else if(testType.equals("Snmp"))
			{
				jsp = "EgConfigSnmpMeasure.jsp";
			}
			else if(testType.equals("Aggregate"))	//skm
			{
				jsp = "EgConfigAggregateMeasure.jsp";	//skm
			}
			
			trans.createFile("eg_udtests.ini");
			strVal = trans.getStrValue("MEASURES",test);
			String strTypeVal = trans.getStrValue("TEST_TYPE",test);
			if(strTypeVal.length() == 0)
			{
				strTypeVal = "Performance";
			}
			obj.put("test",test);
			obj.put("type",strTypeVal);
			obj.put("testType",testType);
			obj.put("jspPage",jsp);
			testList.add(obj);
		}
		rootJSON.put("testsList",testList);
		if (!searchItemFound && egTitleSearchStr!=null && !egTitleSearchStr.equals(""))
		{
			rootJSON.put("noSrchItemFound",true);
		}
	}
	out.println(rootJSON);
%>
			
<%!
	private boolean doesExist(List searchList, String test)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (test.indexOf(nextStr)!=-1||(test.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
			{
				return true;
			}
		}
		return false;
	}
%>
<%	
	session.setAttribute("adminLastAccessedURL","/final/admin/EgUDTest.jsp?"+request.getQueryString());
%>




