<%
/*
 *			Name		:	EgDuplicateServerJson.jsp
 *			Purpose		:	For duplicating IC Server.
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="java.io.*" %>

<%@ page import="egurkha.*"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	auditLogThread.setValue("Activity","Duplicate Component type");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	String strDupServertName = request.getParameter("duplicate");
	String strServerName = request.getParameter("serverName");
	String exImage = request.getParameter("eximage");
	String isDuplicate = request.getParameter("isduplicate");
	ServerBean serverBean = new ServerBean(true);

	if(serverBean.doesServerExist(strDupServertName))
	{
		rootJSON.put("AlertType","Error");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Integration Console - Component"));
		String msg = _mapping.getTextDescription("admin.error.You are trying to add a server which already exists");
		msg += _mapping.getTextDescription("admin.error.Please enter a unique server name");
		rootJSON.put("AlertMsg",msg);
		out.println(rootJSON);

		auditLogThread.setCurrentValue("Component type","$component$:"+strDupServertName);
		auditLogThread.setValue("Description","Attempt has been made to add a component type which already exists");
		auditLogThread.sendItToDB();
		return;
	}
	UpdateAndTransmitICInfo updateICInfo = new UpdateAndTransmitICInfo(); 
 
	//For Eg_specs.ini
	IniFile ini_spec=EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");
	String testMap=ini_spec.getValue("TEST_MAPPING",strServerName);
	String deftestMap=ini_spec.getValue("DEFAULT_TEST_MAPPING",strServerName);
	ini_spec.setValue("TEST_MAPPING",strDupServertName,testMap);
	ini_spec.setValue("DEFAULT_TEST_MAPPING",strDupServertName,deftestMap);
	String[] vars = ini_spec.getVariables("TEST_SPECIFICATION");
	Vector vals = ini_spec.getAllValues("TEST_SPECIFICATION");
	StringTokenizer stt = new StringTokenizer(deftestMap,",");
	ArrayList testlist=new ArrayList();
	while (stt.hasMoreTokens())
	{
		String tname=stt.nextToken().trim();
		if (!testlist.contains(tname))
			testlist.add(tname);
	}

	if (vars != null && vals != null)
	{
		Vector vars2Add = new Vector();
		Vector vals2Add = new Vector();
		//String key = ":"+strServerName+":";
		String key = "::";
		int keyLen = key.length();
		for (int v=0; v<vars.length; v++)
		{
			String var = vars[v];
			int idx = var.indexOf(key);
			if(var.indexOf(key) != -1)
			{
				String prfx = var.substring(0,idx);
				String sufx = var.substring(idx+keyLen);
				if (testlist.contains(prfx))
				{
					var = prfx +":"+strDupServertName+":"+sufx;
					vars2Add.add(var);	
					vals2Add.add(vals.get(v));
				}
			}
		}
		if (vars2Add.size()>0)
		{
			ini_spec.setValues("TEST_SPECIFICATION",vars2Add,vals2Add,false);
		}
	}
	ini_spec.saveFile();
	EgConfigFilesSync.releaseInstance(ini_spec);

	//For Eg_tables.ini
	ArrayList layer=new ArrayList((new com.eg.EgTablesInfo("manager")).getLayersForComponent(strServerName));
	Collections.reverse(layer);
	IniFile ini_table=EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_tables.ini");
	for(int i=0;i<layer.size();i++)
	{
		String meas=(String)layer.get(i);
		String measure=ini_table.getValue("COMPONENT_LAYER_TABLE",strServerName+":"+meas);
		ini_table.setValue("COMPONENT_LAYER_TABLE",strDupServertName+":"+meas,measure);
		
	}
	ini_table.saveFile();
	EgConfigFilesSync.releaseInstance(ini_table);
	
	String LayerList=layer.toString();
	LayerList=LayerList.substring(LayerList.indexOf("[")+1,LayerList.lastIndexOf("]"));
	
	StringTokenizer st=new StringTokenizer(LayerList,",");
	StringBuffer sb=new StringBuffer();
	int total=st.countTokens();
	int cnt=0;
	while(st.hasMoreTokens())
	{
		String s=st.nextToken();
		s=s.trim();
		if(cnt!=total&&cnt!=0)
			sb.append(",");
		sb.append(s);
		cnt++;
	}

	String finallist=sb.toString();
	if(!updateICInfo.updateLayersForServer(strDupServertName,finallist))
	{
			System.out.println("[EgDuplicateServer]Layer not Added");
			
	}

	//For eg_discover.ini
	IniFile ini_discover=EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_discover.ini");
	String discover=ini_discover.getValue(strServerName,"Format:name");
	boolean boo = ini_discover.setValue(strDupServertName,"Format:name",discover);
	ini_discover.saveFile();
	String valTmp = ini_discover.getValue(strDupServertName,"Format:name");
	EgConfigFilesSync.releaseInstance(ini_discover);
	ini_discover = null;
	
	//For eg_services.ini
	IniFile ini_service=EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	String discovery=ini_service.getValue("DISCOVERY_SPECIFICATION",strServerName);
	String noPortServers[] = ini_service.getVariables("NOPORT_SERVERS");
	List noPortServersList = Arrays.asList(noPortServers);
	ini_service.setValue("DISCOVERY_SPECIFICATION",strDupServertName,discovery);
	if (noPortServersList.contains(strServerName))
	{
		ini_service.setValue("NOPORT_SERVERS",strDupServertName,"null");
	}
	ini_service.saveFile();
	EgConfigFilesSync.releaseInstance(ini_service);
	
	//For eg_udservers.ini
	IniFile ini_udServ=EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_udservers.ini");
	ini_udServ.setValue("UD_SERVERS",strDupServertName,strDupServertName);

	String[] strDupServers = ini_udServ.getVariables("IC_DUPLICATE_SERVERS");
	
	if (strDupServers == null || strDupServers.length == 0)
	{
			ini_udServ.setValue("IC_DUPLICATE_SERVERS",strServerName,strDupServertName);
	}
	else
	{
		ArrayList aListDupServers = new ArrayList(Arrays.asList(strDupServers));
		
		if (aListDupServers.contains(strServerName))
		{
			
			String str = ini_udServ.getValue("IC_DUPLICATE_SERVERS",strServerName);
			
			if(str==null || str.length()==0)
				str=strDupServertName;
			else
				str = str + "," + strDupServertName;
				
			ini_udServ.setValue("IC_DUPLICATE_SERVERS",strServerName,str);
			
		}
		else
		{
			ini_udServ.setValue("IC_DUPLICATE_SERVERS",strServerName,strDupServertName);
		}
	}

	ini_udServ.saveFile();
	EgConfigFilesSync.releaseInstance(ini_udServ);

	IniFile ini_udTest=EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_udtests.ini");
	if(isDuplicate == null || isDuplicate.equals("yes"))
	{
		if(strServerName!=null && strServerName.length() > 0)
		{
			exImage = ini_udTest.getValue("COMP_DISPLAYIMAGE_NICK",strServerName);
		}
	}

	ini_udTest.setValue("COMP_DISPLAYIMAGE_NICK",strDupServertName,exImage);
	ini_udTest.saveFile();
	EgConfigFilesSync.releaseInstance(ini_udTest);

	rootJSON.put("AlertType","Result");
	rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Integration Console - Component"));
	rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Component type has been added successfully"));

	auditLogThread.setCurrentValue("Component type",strDupServertName);
	auditLogThread.setValue("Description","Component type has been added successfully");
	auditLogThread.sendItToDB();

	out.println(rootJSON);
%>


