<%
/*
 *		Name			:	EgConfigUDTest.jsp
 *		Purpose			:	IC - Component - Config performance tests
 *		CreationDate	:	01/10/2001
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>


<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
	
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	JSONObject hiddens = new JSONObject();
	boolean isCMEnabled = EgInstallInfo.isConfigSupported;
	//ensure whether the user is configuration management enabled
	if (_user != null && isCMEnabled)
	{
		EgUserRole userRole = _user.getUserRole();
		isCMEnabled = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}

	String server = request.getParameter("server");
	TestBean testBean = new TestBean(true);
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	ArrayList t_tests = testBean.getTestsForServer(server);
	ArrayList t_allTests = testBean.getAllowedTests(server);
	ArrayList aggregateTest= testBean.getAggregationAllTest();
	ArrayList desktopTest = testBean.getDeskTopAgentTests();
	Vector aggTypes = aggregateInfo.getAggregateTypes();
	ArrayList tests=new ArrayList();
	ArrayList allTests=new ArrayList();
	String tStr="";

	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	if(t_tests!=null && t_tests.size()>0)
	{
		if(!isCMEnabled)
		{
			for(int i=0;i<t_tests.size();i++)
			{
				tStr=(String)t_tests.get(i);
				if(!(tStr.endsWith("_cf")))
					tests.add(tStr);
			}
		}
		else
			tests=t_tests;
	}

	if(t_allTests!=null && t_allTests.size()>0)
	{
		if(!isCMEnabled)
		{
			for(int i=0;i<t_allTests.size();i++)
			{
				tStr=(String)t_allTests.get(i);
				if(!(tStr.endsWith("_cf")))
					allTests.add(tStr);
			}
		}
		else
			allTests=t_allTests;
	}

	//James Thomas
	String fileName = EgInstallInfo.getInstallDir() + "/manager/config/eg_specs.ini";
	IniFile ini_egSpecs= new IniFile(fileName);
	String str_subject = "TEST_MAPPING";
	String strValue = ini_egSpecs.getValue(str_subject, server);
	//James Thomas

	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	allTests = specsInfo.getLicensedTests(allTests);
	
	rootJSON.put("serverDispValue",_mapping.getComponentTypeDescription(server));
	String testlist = "";
	ArrayList testsList = new ArrayList();
	for (int i=0;i<tests.size();i++)
	{
		String test = (String) tests.get(i);
		if(desktopTest!=null && desktopTest.contains(test))
			continue;
		testlist += test + ",";
		if (test!=null && (EgInstallInfo.isConfigTest(test))) continue;

		testsList.add(test);
	}
	testsList = sorter.getSortedTestList(testsList);
	JSONArray assoList = new JSONArray();
	JSONObject obj = new JSONObject();
	for(int j=0;j<testsList.size();j++)
	{
		EgName nameObj = (EgName)testsList.get(j);
		String tmpVal = nameObj.getActualName();
		String tmpDis = nameObj.getLocalName();
		obj = new JSONObject();
		obj.put("valueField",tmpVal);
		obj.put("displayField",tmpDis);
		assoList.add(obj);
	}
	rootJSON.put("assoTests",assoList);
	if(testlist.length() > 0)
		testlist = testlist.substring(0, testlist.length()-1);
	hiddens.put("testlist",testlist);

	Collections.sort(allTests);
	ArrayList testsList2 = new ArrayList();
	for(int i=0; i<allTests.size(); i++)
	{
		String test = (String) allTests.get(i);
		if(tests.contains(test))
			continue;
		else if(aggTypes!=null && aggTypes.contains(server))
		{
			if(aggregateTest!=null && !aggregateTest.contains(test))
				continue;
		}
		else if(aggregateTest!=null && aggregateTest.contains(test))
			continue;
		else if(desktopTest!=null && desktopTest.contains(test))
			continue;
		if(test.endsWith("_ag") || test.endsWith("_agx"))
			continue;

		testsList2.add(test);
	}
	testsList2 = sorter.getSortedTestList(testsList2);
	JSONArray disoList = new JSONArray();
	for (int j=0;j<testsList2.size();j++)
	{
		EgName nameObj = (EgName)testsList2.get(j);
		String tmpVal = nameObj.getActualName();
		String tmpDis = nameObj.getLocalName();
		obj = new JSONObject();
		obj.put("valueField",tmpVal);
		obj.put("displayField",tmpDis);
		disoList.add(obj);
	}
	rootJSON.put("disoTests",disoList);
	hiddens.put("server",server);//fassociate,fdissociate
	hiddens.put("strValue",strValue);
	rootJSON.put("hiddens",hiddens);
	out.println(rootJSON);
%>



