<%
/**********************************************************************************
*	Name			:	Egconfigzonep.jsp
*	Purpose			:	process page for EgConfigZone.jsp
*	Last Modified	:	July-23-2007		N.Gokulanand	For zone map changes.
***********************************************************************************/
%>
<%@ include file = "EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "java.util.Vector"%>
<%@ page import = "java.util.Hashtable"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgStateZone" %>
<%@ page import = "com.eg.UpdateAndTransmitUserInfo" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.eg.EgViewInfo" %>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "com.eg.DeleteMailFilterElements"%>
<%@ page import ="com.egurkha.monitor.EgComponentUserMappingBean"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>


<jsp:useBean class="egurkha.ZoneInfoBean" id="zoneInfo" scope="page"/>
<jsp:setProperty name="zoneInfo" property="mode" value='<%=request.getParameter("mode")%>'/>
<jsp:setProperty name="zoneInfo" property="zone" value='<%=request.getParameter("zone")%>'/>
<jsp:setProperty name="zoneInfo" property="compType" value='<%=request.getParameter("comp_type")%>'/>
<jsp:setProperty name="zoneInfo" property="association" value='<%=request.getParameter("association")%>'/>
<jsp:setProperty name="zoneInfo" property="returnto" value='<%=request.getParameter("returnto")%>'/>
<jsp:setProperty name="zoneInfo" property="deleteZones" value='<%=request.getParameter("deleteZones")%>'/>
<jsp:setProperty name="zoneInfo" property="chosenHosts" value='<%=request.getParameter("chosenHosts")%>'/>

<jsp:useBean id="ecumb" scope="page" class="com.egurkha.monitor.EgComponentUserMappingBean" />
<%
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Zones");
	/* code for auditlog endss */
	EgViewInfo    egview= new EgViewInfo("manager");
	boolean coordinateFlag = false;
	String latitude = request.getParameter("latitude");
	String longitude = request.getParameter("longitude");
	String latitudePrev = request.getParameter("latitude_prev");
	String longitudePrev = request.getParameter("longitude_prev");
	String association = request.getParameter("association");
	String zone = request.getParameter("zone");
	String delview=request.getParameter("delview");
	String returnto=request.getParameter("returnto");
	EgGroupInfo	groupinfo = new EgGroupInfo();
	if(returnto != null && ( returnto.equalsIgnoreCase("service") || returnto.startsWith("segment") ) )
	{
		Vector ses_vec = new Vector();
		ArrayList al = groupinfo.getAllElementsUnderZone(zone);
		if(al != null && al.size() < 2 )
		{
			
			ses_vec.addElement(_mapping.getTextDescription("admin.zone.Configure zones"));
			if(returnto.equalsIgnoreCase("service"))
			{
				String site_url = request.getParameter("site");
				ses_vec.addElement("EgConfigSites.jsp?zone="+EgURLEncoder.encode(zone,"UTF-8")+"&site="+EgURLEncoder.encode(site_url,"UTF-8")+"&modify=true");
			}
			else
			{
				String segment_url = returnto.substring(returnto.lastIndexOf("_")+1);
				ses_vec.addElement("EgAdminTopology.jsp?qctr=0&zone="+EgURLEncoder.encode(zone,"UTF-8")+"&segment="+EgURLEncoder.encode(segment_url,"UTF-8"));
			}
			ses_vec.addElement(_mapping.getTextDescription("admin.zone.All elements cannot be removed from the zone"));	
			ses_vec.addElement(_mapping.getTextDescription("admin.zone.All elements cannot be removed from the zone")+".");
			ses_vec.addElement(_mapping.getTextDescription("admin.zone.Hence this operation cannot be performed")+".");
			session.putValue("vec_Errors",ses_vec);
			%>
			<jsp:forward page="EgErrors.jsp" />
			<%
		}
	}

	if(delview==null)
	  delview="no";
	if(latitude != null && longitude != null)
	{
		coordinateFlag = true;
	}
	if(coordinateFlag)
	{
		String iniCoordinate = latitude+"|"+longitude;
		if (latitude!=null && !latitude.equals("null"))
			auditLogThread.setCurrentValue("Lattitude",latitude);
		if (longitude!=null && !longitude.equals("null"))
			auditLogThread.setCurrentValue("Longitude",longitude);
		if (latitudePrev!=null && !latitudePrev.equals("null"))
			auditLogThread.setPreviousValue("Lattitude",latitudePrev);
		if (longitudePrev!=null && !longitudePrev.equals("null"))
			auditLogThread.setPreviousValue("Longitude",longitudePrev);
	%>
		<jsp:setProperty name="zoneInfo" property="iniCoordinate" value="<%=iniCoordinate%>"/>
	<%
	}
	else
	{
		String iniCoordinate = "null|null";
	%>
		<jsp:setProperty name="zoneInfo" property="iniCoordinate" value="<%=iniCoordinate%>"/>
	<%
	}

	String mode = request.getParameter("mode");

	String deletedzone=request.getParameter("deleteZones");

	// mail filter - start
	List allServersForRemovedElems = null;
	DeleteMailFilterElements delMailFilterElements = new DeleteMailFilterElements();
	if (mode != null)
	{
		if (mode.equalsIgnoreCase("delete"))
		{
			allServersForRemovedElems = delMailFilterElements.getServersForZones(deletedzone);
		}
		else if (mode.equalsIgnoreCase("modify"))
		{
			String disAssociatedElems = request.getParameter("disAssociatedElems");
			if(disAssociatedElems != null && disAssociatedElems.length() > 0)
			{
				if(disAssociatedElems.endsWith(","))
				{
					disAssociatedElems = disAssociatedElems.substring(0,disAssociatedElems.length()-1);
				}
				allServersForRemovedElems = new ArrayList();
				StringTokenizer tokens = new StringTokenizer(disAssociatedElems,",");
				while(tokens.hasMoreTokens())
				{
					String each = tokens.nextToken();
					if(each.startsWith("Segment:"))
					{
						each = each.substring(each.indexOf(":")+1,each.lastIndexOf(":"));
						List l = delMailFilterElements.getServersForSegments(each);
						if(l!=null)
							allServersForRemovedElems.addAll(l);
						continue;
					}
					if(each.startsWith("Service:"))
					{
						each = each.substring(each.indexOf(":")+1,each.lastIndexOf(":"));
						List l = delMailFilterElements.getServersForServices(each);
						if(l!=null)
							allServersForRemovedElems.addAll(l);
						continue;
					}
					if(each.startsWith("Group:"))
					{
						each = each.substring(each.indexOf(":")+1,each.lastIndexOf(":"));
						List l = groupinfo.getAllComponentsUnderGroup(each);
						if(l!=null)
							allServersForRemovedElems.addAll(l);
						continue;
					}
					allServersForRemovedElems.add(each);
				}
			}
		}
	}
	//end

	zoneInfo.configZone();
	session.setAttribute("zoneMessage", zoneInfo.getZoneMessage());
%>
	<input type="hidden" name="association" value="<%=zoneInfo.getAutoAssociationCheck()%>">

<%
	String zoneName=request.getParameter("zone");
	String comptype=request.getParameter("comp_type");
	String assco=request.getParameter("association");
	
	String chosenhost=request.getParameter("chosenHosts");
	String previousHosts=request.getParameter("previousHosts");
	String url=null;
	if (mode!=null && mode.equalsIgnoreCase("delete"))
	{
		auditLogThread.setValue("Activity","Delete Zones");
		auditLogThread.setValue("Description","Zone(s) have been deleted");
		if(deletedzone.lastIndexOf(',')!=-1)
		{
			deletedzone=deletedzone.substring(0,deletedzone.lastIndexOf(','));
		}
		auditLogThread.setCurrentValue("ColumnName","Deleted Zone(s)");
		auditLogThread.setCurrentValue("Zone name",deletedzone);
		auditLogThread.sendItToDB();

		EgAggregateInfo aggInfo = new EgAggregateInfo("manager");
		String ca_variables[] = aggInfo.getVariables("COMPONENT_ASSOCIATION");
		ArrayList delList = new ArrayList();
		String delZones[] = StringUtils.getTokens(deletedzone,",");
		ArrayList deletedZones = new ArrayList(Arrays.asList(delZones));
		if(ca_variables != null && ca_variables.length>0)
		{
			for(int i=0;i<ca_variables.length;i++)
			{
				String ca_variable = ca_variables[i];
				String zone_name = ca_variable.substring(ca_variable.lastIndexOf("#")+1);
				if(deletedZones.contains(zone_name))
				{
					aggInfo.deleteValue("COMPONENT_ASSOCIATION",ca_variable);
					aggInfo.deleteValue("ANCHOR_COMPONENT",ca_variable);
				}
			}
		}
		aggInfo.saveFile();

		url = "EgDispZones.jsp";
		egview.deleteviewsUnderZone(deletedzone);

		//start - mail filter
		delMailFilterElements.removeElementsFromMailFilter(null,allServersForRemovedElems);
		//end
	}
	else
	{
		String zoneMsg = zoneInfo.getZoneMessage();
		if(zoneMsg != null && zoneMsg.equals("All elements cannot be removed from the zone"))
		{
			Vector ses_vec = new Vector();
			ses_vec.addElement(_mapping.getTextDescription("admin.error.Configure zones"));
			ses_vec.addElement("EgConfigZone.jsp?comptype=" + EgURLEncoder.encode(comptype,"UTF-8") + "&qctr=1&zone="+EgURLEncoder.encode(zoneName,"UTF-8"));
			ses_vec.addElement(_mapping.getTextDescription("admin.error.All elements cannot be removed from the zone"));
			ses_vec.addElement(_mapping.getTextDescription("admin.error.All elements cannot be removed from the zone")+".");
			ses_vec.addElement(_mapping.getTextDescription("admin.error.Hence this operation cannot be performed")+".");
			session.putValue("vec_Errors",ses_vec);
			//response.sendRedirect("EgErrors.jsp");
%>
			<jsp:forward page="EgErrors.jsp" />
<%
		}
		auditLogThread.setValue("Activity","Zone configuration");
		auditLogThread.setValue("Description", "zone "+zoneName+" has been added with auto association enabled");
		url = "EgConfigZone.jsp?comptype=" + request.getParameter("comp_type") + "&qctr=1&zone=" + request.getParameter("zone")+"&association="+request.getParameter("association");

		/* code for auditlog starts */
		boolean isItNewZone = true;
		String currval="";
		egview.deleteviewcomponent(zone);
		if(chosenhost!=null && !chosenhost.equals("null") && !chosenhost.equals(""))
		{
			currval=chosenhost;
		}
		ArrayList prevList = new ArrayList();
		if (previousHosts != null)
		{
			StringTokenizer st = new StringTokenizer(previousHosts,",");
			while (st.hasMoreTokens())
			{
				String x = st.nextToken();
				if (x.trim().length() == 0)
					continue;
				prevList.add(x);
			}
		}

		ArrayList currList = new ArrayList();
		if (currval != null)
		{
			StringTokenizer st = new StringTokenizer(currval,",");
			while (st.hasMoreTokens())
			{
				String x = st.nextToken();
				if (x.trim().length() == 0)
					continue;
				int ind = prevList.indexOf(x);
				if (ind >= 0)
				{
						prevList.remove(ind);
				}
				else
					currList.add(x);
			}
		}

		if(currval!=null && !currval.equals("null") && !currval.equals("") && currList.size() > 0)
		{
			//fin.add("Current_Value\t TYPES OF ELEMENTS|"+currval);
			String s = "";
			for (int i=0; i<currList.size(); i++)
			{
				String me = (String) currList.get(i);
				if (me.endsWith(":NULL"))
				{
					int ind = me.lastIndexOf(":");
					if (ind >= 0)
						me = me.substring(0,ind);
				}
				s+="$ctype$:"+me+",";
			}
			if (s.length() > 0)
			{
				s = s.substring(0,s.length()-1);
				auditLogThread.setCurrentValue("Associated elements", s);
			}
		}
		if (previousHosts!=null && !previousHosts.trim().equals(""))
		{
			isItNewZone = false;
			if (prevList.size() > 0)
			{
				String s = "";
				for (int i=0; i<prevList.size(); i++)
				{
					String me = (String) prevList.get(i);
					if (me.endsWith(":NULL"))
					{
						int ind = me.lastIndexOf(":");
						if (ind >= 0)
							me = me.substring(0,ind);
					}
					s+= "$ctype$:"+me +",";
				}
				if (s.length() > 0)
				{
					s = s.substring(0,s.length()-1);
					auditLogThread.setCurrentValue("Disassociated elements", s);
				}
			}
		}
		auditLogThread.setValue("Activity","Zone Configuration");
		if(association != null && !association.equals("null"))
		{
			if(isItNewZone)
				auditLogThread.setValue("Description", "Zone "+zoneName+" has been added with auto association enabled");
			else
				auditLogThread.setValue("Description","Zone "+ zoneName+" has been modified with auto association enabled");
		}
		else
		{
			if(isItNewZone)
				auditLogThread.setValue("Description", "Zone "+ zoneName+" has been added");
			else
				auditLogThread.setValue("Description","Zone "+zoneName+" has been modified");
		}
		auditLogThread.sendItToDB();
		/* code for auditlog ends */

		if(EgInstallInfo.isAggregationSupported())
		{
			EgGroupInfo groupinfo1 = new EgGroupInfo();
			ArrayList componentsUnderZone = groupinfo1.getAllComponentsUnderZone(zone,true);
			EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
			String variables[] = aggregateInfo.getVariables("COMPONENT_ASSOCIATION");
			String variables_uica[] = aggregateInfo.getVariables("UI_COMPONENT_ASSOCIATION");
			if(variables != null && variables.length>0 || variables_uica != null && variables_uica.length>0)
			{
				Set mySet = new TreeSet();
				if(variables != null && variables.length>0)
				{
					mySet.addAll(Arrays.asList(variables));
				}
				if(variables_uica != null && variables_uica.length>0)
				{
					mySet.addAll(Arrays.asList(variables_uica));
				}
				variables = (String[])mySet.toArray(new String[mySet.size()]);
				boolean changed = false;
				boolean remove_entry = false;
				String aggregateComponent = null;
				String key1 = "#zone#"+zone;
				String key2 = "#Zone#"+zone;
				for(int i=0;i<variables.length;i++)
				{
					String ca = variables[i];
					if(ca.endsWith(key1) || ca.endsWith(key2))
					{
						aggregateComponent = ca.substring(0,ca.indexOf("#"));
						List associatedComps = aggregateInfo.getAssociatedComponents(aggregateComponent, true);
						if(associatedComps != null && !associatedComps.isEmpty())
						{
							remove_entry = false;
							for(int j=0;j<associatedComps.size();j++)
							{
								String associatedComp = (String)associatedComps.get(j);
								if(componentsUnderZone.contains(associatedComp))
								{
									remove_entry = false;
									break;
								}
								remove_entry = true;
								changed = true;
							}
							if(remove_entry)
							{
								aggregateInfo.deleteValue("UI_COMPONENT_ASSOCIATION",ca);
								aggregateInfo.deleteValue("COMPONENT_ASSOCIATION",ca);
								aggregateInfo.deleteValue("ANCHOR_COMPONENT",ca);
							}
						}
					}
				}
				if(changed)
				{
					aggregateInfo.saveFile();
				}
				if(aggregateInfo.isAutoAssociateComponentToAnchor())
				{
					aggregateInfo = new EgAggregateInfo("manager");
					changed = false;
					Hashtable anchorHt = aggregateInfo.getAnchorComponentsOfElement("zone",zone);//ht from associated components of anchor components created from selected zone
					if(anchorHt != null && !anchorHt.isEmpty())
					{
						Hashtable zht = new Hashtable();//ht from components of selected zone
						Iterator itr = componentsUnderZone.iterator();
						while(itr.hasNext())
						{
							String s = (String)itr.next();
							String type = "Agg_"+s.substring(0,s.indexOf(":"));
							if(zht.containsKey(type))
							{
								ArrayList alist = (ArrayList)zht.get(type);
								alist.add(s);
							}
							else
							{
								ArrayList alist = new ArrayList();
								alist.add(s);
								zht.put(type,alist);
							}
						}
						itr = anchorHt.keySet().iterator();
						while(itr.hasNext())
						{
							String s = (String)itr.next();
							List comps_in_anchor = (List)anchorHt.get(s);
							String type = s.substring(0,s.indexOf(":"));
							ArrayList comps_in_zone = (ArrayList)zht.get(type);
							if(comps_in_zone.size() > comps_in_anchor.size())
							{
								//if selected zone has component, but anchor has not, add this into [AGGREGATE_COMPONENTS]
								comps_in_zone.removeAll(comps_in_anchor);
								for(int i=0;i<comps_in_zone.size();i++)
								{
									changed = true;
									aggregateInfo.setValue("AGGREGATE_COMPONENTS",s+"#"+(String)comps_in_zone.get(i),"associated");
								}
							}
							else if(comps_in_zone.size() < comps_in_anchor.size())
							{
								//if selected zone does not have component, but anchor coponent does, remove this from [AGGREGATE_COMPONENTS]
								comps_in_anchor.removeAll(comps_in_zone);
								for(int i=0;i<comps_in_anchor.size();i++)
								{
									changed = true;
									aggregateInfo.deleteValue("AGGREGATE_COMPONENTS",s+"#"+(String)comps_in_anchor.get(i));
								}
							}
						}
						if(changed)
						{
							aggregateInfo.saveFile();
						}
					}
				}
			}
		}

		if(delview!=null && delview.equalsIgnoreCase("yes"))
		{
			egview.deleteviewsUnderZone(zone);
		}
		else
		{
			egview.deleteviewcomponent(zone);  
		}

		// mail filter - start
		if (mode != null && mode.equalsIgnoreCase("modify"))
		{
			if(allServersForRemovedElems != null && allServersForRemovedElems.size() > 0)
			{
				delMailFilterElements.removeElementsFromMailFilter(null,allServersForRemovedElems);
			}
		}
		//end

	}
		if (returnto!=null)
		{
			String thisSite = request.getParameter("site");
			if (returnto.startsWith("segment"))
			{
				String thisSegment = returnto.substring(returnto.lastIndexOf("_")+1);
				url = "EgAdminTopology.jsp?qctr=0&zone=-1&segment="+EgURLEncoder.encode(thisSegment,"UTF-8");
			}else
			{
				if (thisSite!=null)
				{
					// Auditlog  added by ahamed
					AuditLogThread auditLogThread1 = new AuditLogThread();	
					auditLogThread1.setValue("Category","Admin");
					auditLogThread1.setValue("User_id",_user.getLoginID());
					auditLogThread1.setValue("Host_ip",_user.getUserIP(session.getId()));
					auditLogThread1.setValue("Session_id",session.getId());
					auditLogThread1.setValue("Module","Services");
					auditLogThread1.setValue("Activity","Modify Service");
					auditLogThread.setCurrentValue("ColumnName","Service Disassociated from zone");
					auditLogThread.setCurrentValue("Service Name",thisSite);					
					auditLogThread.setCurrentValue("Zone Name",zone);					
					auditLogThread1.setValue("Description","Service is disassociated from the zone");
					auditLogThread1.sendItToDB();
					//end
					url = "EgConfigSites.jsp?zone=-1&site="+EgURLEncoder.encode(thisSite,"UTF-8") +"&modify=true";
				}else
				{
					url=returnto;
				}
			}
		}
	
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUISave = new IniFile(s_iniFile_dir + uiFile);
	String showUsers=egUISave.getValue("ALARM_HISTORY","Show_Users");
	String curr_date=null;
	if(showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
	{
		curr_date=String.valueOf(new java.util.Date());
		if(ecumb.hashLastComponentUserUpdated!=null && ecumb.hashLastComponentUserUpdated.size()>0)
		{
			ecumb.hashLastComponentUserUpdated.put("Updated",(String)curr_date);
		}
		else
		{
			ecumb.hashLastComponentUserUpdated=new Hashtable();
			ecumb.hashLastComponentUserUpdated.put("Updated",(String)curr_date);
		}
	}

	registry.updateAllUserMaps();
	EgStateZone.updateZoneGroupStatus();
%>
	<jsp:forward page="<%=url%>" />

