<%
/*
 *   File		:	EgUnconfigCompSummary.jsp
 *   Purpose	:	Provides a glance of unconfigured components wrt test
 *   Author		:	Anand (2009)
 *   UI Design	:	Jaiwin & Krishnamurthi
*/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp" %>
<%@ page import="com.egurkha.admin.EgTestSpecification" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgURLEncoder" %>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	EgTestSpecification egTestSpecification = null;
	List listUnconfiguredComponents = ri.getAllServers();
	boolean hasManagedComponents = listUnconfiguredComponents!=null && listUnconfiguredComponents.size() > 0 ? true:false;
	boolean hasUnConfiguredComponents = false;
	boolean hasUnConfiguredTests = false;
	int unConfiguredTestsCount = 0;
	boolean isConfigSupported = false;
	ArrayList aListCount = null;
	TreeMap tmapUnconfigTestCount = null;
	TreeMap tmapTemp = null;

	if (hasManagedComponents)
	{
		egTestSpecification = new EgTestSpecification(listUnconfiguredComponents);

		//tell whether _cf test enabled or not
		isConfigSupported = EgInstallInfo.isConfigSupported;

		//ensure whether the user is configuration management enabled
		if (_user != null && isConfigSupported)
		{
			EgUserRole userRole = _user.getUserRole();
			isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);

			egTestSpecification.setConfigSupported(isConfigSupported);
		}

		TreeMap tmapUnConfigTests = egTestSpecification.getUnconfiguredTest();
		unConfiguredTestsCount = egTestSpecification.getTotalUnconfiguredTestsCount();
		hasUnConfiguredTests = (unConfiguredTestsCount > 0)?true:false;
		if (hasUnConfiguredTests)
		{
			ArrayList aListUnconfigTestCount = new ArrayList();
			tmapTemp = new TreeMap();
			Iterator itrUnConfigTests = tmapUnConfigTests.keySet().iterator();
			for(int i=0; i<tmapUnConfigTests.size(); i++)
			{
				String tempCompType=(String)itrUnConfigTests.next();
				TreeMap tmapTempCompUnconfigTests = (TreeMap)tmapUnConfigTests.get(tempCompType);
				int unConfigTestsCount = 0;
				int unConfigPerTestsCount = 0;
				int unConfigConTestsCount = 0;
				Iterator itr_tempCompUnconfigTests = tmapTempCompUnconfigTests.keySet().iterator();
				for(int j=0; j<tmapTempCompUnconfigTests.size(); j++)
				{
					String tempComponentName=(String)itr_tempCompUnconfigTests.next();
					ArrayList aListResultantTests = (ArrayList)tmapTempCompUnconfigTests.get(tempComponentName);
					ArrayList aListTempPerTests = (ArrayList)aListResultantTests.get(0);
					ArrayList aListTempConTests = (ArrayList)aListResultantTests.get(1);
					unConfigPerTestsCount = unConfigPerTestsCount + aListTempPerTests.size();
					unConfigConTestsCount = unConfigConTestsCount + aListTempConTests.size();
					unConfigTestsCount = unConfigTestsCount + aListTempPerTests.size() + aListTempConTests.size();
				}
				aListUnconfigTestCount.add(tempCompType + "#" + unConfigTestsCount + "#" + unConfigPerTestsCount + "#" + unConfigConTestsCount);
				tmapTemp.put(tempCompType,unConfigTestsCount + "#" + unConfigPerTestsCount + "#" + unConfigConTestsCount);
			}

			tmapUnconfigTestCount = new TreeMap();
			aListCount = new ArrayList();
			for (int i=0;i<aListUnconfigTestCount.size();i++)
			{
				String strUnConfigTestCount = (String)aListUnconfigTestCount.get(i);
				String tempCompType = strUnConfigTestCount.substring(0,strUnConfigTestCount.indexOf("#"));
				String testCountPattern = strUnConfigTestCount.substring(strUnConfigTestCount.indexOf("#")+1);
				String strTestCount = testCountPattern.substring(0,testCountPattern.indexOf("#"));
				strTestCount = strTestCount.trim();
				Integer testCount = new Integer(strTestCount);

				ArrayList aListTemp = (ArrayList)tmapUnconfigTestCount.get(testCount);
				if (aListTemp == null)
				{
					aListTemp = new ArrayList();
					aListTemp.add(tempCompType);
					tmapUnconfigTestCount.put(testCount,aListTemp);
					aListCount.add(testCount);
				}
				else
				{
					aListTemp.add(tempCompType);
				}
			}

			Collections.sort(aListCount);
			Collections.reverse(aListCount);
		}
	}
%>
<html>
<head>
<egui:skin ui="admin"/>
<script language="JavaScript">
function loadURL(myURL)
{
	if(window.parent != null)
	{
		window.parent.location.href = myURL;
	}
}
</script>
</head>
<body style="overflow:auto" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" id="margin6" class="eg_whitebg">
<%
	if (hasManagedComponents && hasUnConfiguredTests)
	{
%>
<table width="100%" border="0" cellpadding="0" cellspacing="0" align="center">
	<tr>
		<td>
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
<%
		if (isConfigSupported)
		{
%>
					<td id="eg_11" nowrap align="left" width="50%"><b><egui:intnl text="admin.unconfig.Total Unconfigured Tests"/>&nbsp;:&nbsp;<%=unConfiguredTestsCount%></b></td>
					<td align="right" width="50%">
						<table align="right" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td width="10" valign="middle"><img src="/final/admin/eg_images/<%=admin_Skin%>/run.gif" border="0" vspace="4"></td>
								<td width="90" id="eg_10" valign="top">&nbsp;<egui:intnl text="admin.dashboard.Performance"/></td>
								<td width="10" valign="middle"><img src="/final/admin/eg_images/<%=admin_Skin%>/notrun.gif" border="0" vspace="4"></td>
								<td width="90" id="eg_10" valign="top">&nbsp;<egui:intnl text="admin.dashboard.Configuration"/></td>
							</tr>
						</table>
					</td>
<%
		}
		else
		{
%>
					<td id="eg_11" nowrap align="center" width="50%"><b><egui:intnl text="admin.unconfig.Total Unconfigured Tests"/>&nbsp;:&nbsp;<%=unConfiguredTestsCount%></b></td>
<%
		}
%>

				</tr>
			</table>
		</td>
	</tr>

<%
		int maxCount = ((Integer)aListCount.get(0)).intValue();
		for (int i=0;i<aListCount.size();i++)
		{
			Integer strCountObj = (Integer)aListCount.get(i);
			int strCount = strCountObj.intValue();
			int width = 0;
			if (i==0)
			{
				width = 100;
			}
			else
			{
				width = (strCount*100)/maxCount;
			}
			if (tmapUnconfigTestCount.containsKey(strCountObj))
			{
				ArrayList aListComponentTypes = (ArrayList)tmapUnconfigTestCount.get(strCountObj);
				for (int j=0;j<aListComponentTypes.size();j++)
				{
					String strComponentType = (String)aListComponentTypes.get(j);
					String displayComponentType = _mapping.getComponentTypeDescription(strComponentType);
					String tempTestCount = (String)tmapTemp.get(strComponentType);
%>
	<tr>
		<td>
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
<%
					if (isConfigSupported)
					{
						String perTestCount = tempTestCount.substring(tempTestCount.indexOf("#")+1,tempTestCount.lastIndexOf("#"));
						String conTestCount = tempTestCount.substring(tempTestCount.lastIndexOf("#")+1);
						int perTest = Integer.parseInt(perTestCount.trim());
						int conTest = Integer.parseInt(conTestCount.trim());
						int perTestWidth = (perTest*100)/strCount;
						int conTestWidth = (conTest*100)/strCount;
%>
					<td width="40%" id="cell_border1">&nbsp;
<%
						if (displayComponentType.length() > 25)
						{
%>
					<a href="/final/admin/EgUnconfiguredTestsSummary.jsp?fromPage=unConfiguredSummary&componentType=<%=EgURLEncoder.encode(strComponentType,"UTF-8")%>&showTestType=perTestAndConTest" STYLE="text-decoration:none" class="dash_link" target="_parent" title="<%=displayComponentType%>"><egui:display name="<%=displayComponentType%>" length="<%=Integer.toString(25)%>"/></a>
<%
						}
						else
						{
%>
					<a href="/final/admin/EgUnconfiguredTestsSummary.jsp?fromPage=unConfiguredSummary&componentType=<%=EgURLEncoder.encode(strComponentType,"UTF-8")%>&showTestType=perTestAndConTest" STYLE="text-decoration:none" class="dash_link" target="_parent"><%=displayComponentType%></a>
<%
						}
%>
					</td>
					<td>
						<table width="<%=width%>%" border="0" cellspacing="0" cellpadding="0">
							<tr>
<%
						if (perTestWidth > 0)
						{
%>
								<td id="cell_bg_medium" class="mouse eg_white eg_75bold" height="20px" width='<%=perTestWidth%>%' align="center" onclick="loadURL('/final/admin/EgUnconfiguredTestsSummary.jsp?fromPage=unConfiguredSummary&componentType=<%=EgURLEncoder.encode(strComponentType,"UTF-8")%>&showTestType=perTest')" title="<%=perTest%> tests"> <%=perTest%> </td>
<%
						}

						if (conTestWidth > 0)
						{
%>
								<td id="cell_bg_light" class="mouse eg_75bold" height="20px" width='<%=conTestWidth%>%' align="center" onclick="loadURL('/final/admin/EgUnconfiguredTestsSummary.jsp?fromPage=unConfiguredSummary&componentType=<%=EgURLEncoder.encode(strComponentType,"UTF-8")%>&showTestType=conTest')" title="<%=conTest%> tests"><%=conTest%></td>
<%
						}
%>
							</tr>
						</table>
					</td>
<%
					}
					else
					{
%>
					<td width="40%" id="cell_border1">&nbsp;
<%
						if (displayComponentType.length() > 25)
						{
%>
						<a href ="/final/admin/EgUnconfiguredTestsSummary.jsp?fromPage=unConfiguredSummary&componentType=<%=EgURLEncoder.encode(strComponentType,"UTF-8")%>&showTestType=perTest" STYLE="text-decoration:none" class="dash_link" target="_parent" title="<%=displayComponentType%>"><egui:display name="<%=displayComponentType%>" length="<%=Integer.toString(25)%>"/></a>
<%
						}
						else
						{
%>
						<a href ="/final/admin/EgUnconfiguredTestsSummary.jsp?fromPage=unConfiguredSummary&componentType=<%=EgURLEncoder.encode(strComponentType,"UTF-8")%>&showTestType=perTest" STYLE="text-decoration:none" class="dash_link" target="_parent"><%=displayComponentType%></a>
<%
						}
%>
					</td>
					<td>
						<table width="<%=width%>%" border="0" cellspacing="0" cellpadding="0">
							<tr>
								<td id="cell_bg_medium" class="mouse eg_white eg_75bold" height="20px" width='100%' align="center" onclick="loadURL('/final/admin/EgUnconfiguredTestsSummary.jsp?fromPage=unConfiguredSummary&componentType=<%=EgURLEncoder.encode(strComponentType,"UTF-8")%>&showTestType=perTest')" title="<%=strCount%> tests"><%=strCount%></td>
							</tr>
						</table>
					</td>
<%
					}
%>
				</tr>
				<tr>
					<td background="eg_images/in_titleshadowbg1.gif" height="7" id="eg_blankspace">&nbsp;</td>
					<td height="7">
						<table width="<%=(strCount*100)/maxCount%>%" border="0" cellspacing="0" cellpadding="0">
							<tr>
								<td id="eg_blankspace" nowrap height="7" background="eg_images/in_titleshadowbg1.gif">&nbsp;</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
				}
			}
		}
%>
</table>
<%
	}
	else if (hasManagedComponents && !hasUnConfiguredTests)
	{
%>
<table cellspacing="0" cellpadding="0" border="0" width="100%" height="100%">
	<tr>
		<td align="center" valign="middle"><img src="eg_images/tick-icon.gif"><br><egui:intnl text="admin.unconfig.All components have been configured"/>.</td>
	</tr>
</table>
<%
	}
	else if (!hasManagedComponents && !hasUnConfiguredTests)
	{
%>
<table cellspacing="0" cellpadding="0" border="0" width="100%" height="100%">
	<tr>
		<td align="center" valign="middle"><img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><egui:intnl text="admin.unconfig.No managed components"/>.</td>
	</tr>
</table>
<%
	}
%>
</body>
</html>



