<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.supermanager.EgSmSuperInfo"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "java.util.Hashtable"%>
<%@ page import="net.sf.json.*" %>

<%
	JSONObject rootJson = new JSONObject();
	String mode = request.getParameter("mode");
	if(mode != null)
	{
		if(mode.equalsIgnoreCase("add"))
		{
			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","SuperManager");
			auditLogThread.setValue("Activity","Add SuperManager");

			String SMID = request.getParameter("SMID");
			String altMgrIps = request.getParameter("altMgrIps");
			String supermanagerURL = request.getParameter("supermanagerURL");
			if(altMgrIps == null || altMgrIps.trim().length()==0)
			{
				altMgrIps="None";
			}
			EgSmSuperInfo superInfo = EgSmSuperInfo.getInstance();
			superInfo.setValue(EgSmSuperInfo.CONFIGURED_SUPERMANAGERS,SMID,"null");
			superInfo.setValue(SMID,"SUPERMANAGERURL",supermanagerURL);
			superInfo.setValue(SMID,"ALTIPS",altMgrIps);
			superInfo.saveFile();
			if(!EgInstallInfo.isSMConfigured)
			{
				synchronized(IniFile.smIniSync)
				{
					EgInstallInfo.isSMConfigured=true;
				}
			}
			auditLogThread.setCurrentValue("ColumnName","SuperManager Added");
			auditLogThread.setCurrentValue("01~~ID of supermanager", SMID);
			auditLogThread.setCurrentValue("02~~URL to connect to the supermanager", supermanagerURL);
			auditLogThread.setCurrentValue("03~~IP(s) of supermanager for access validation", altMgrIps);
			auditLogThread.setValue("Description","Supermanager has been added successfully");
			auditLogThread.sendItToDB();
		}
		else if(mode.equalsIgnoreCase("modify"))
		{
			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","Supermanager");
			auditLogThread.setValue("Activity","Modify SuperManager");

			boolean isModified = false;
			String SMID = request.getParameter("SMID");
			String altMgrIps = request.getParameter("altMgrIps");
			String supermanagerURL = request.getParameter("supermanagerURL");
			String oldSupermanagerURL = null;
			String oldAltMgrIps = null;

			EgSmSuperInfo superInfo = EgSmSuperInfo.getInstance();
			String configuredSmIds[] = superInfo.getVariables(EgSmSuperInfo.CONFIGURED_SUPERMANAGERS);
			if(configuredSmIds != null && configuredSmIds.length>0)
			{
				oldSupermanagerURL = superInfo.getValue(SMID,"SUPERMANAGERURL");
				oldAltMgrIps = superInfo.getValue(SMID,"ALTIPS");
				if(!oldSupermanagerURL.equals(supermanagerURL))
				{
					isModified = true;
					auditLogThread.setPreviousValue("01~~URL of supermanager",oldSupermanagerURL);
					auditLogThread.setCurrentValue("01~~URL of supermanager",supermanagerURL);
					superInfo.setValue(SMID,"SUPERMANAGERURL",supermanagerURL);
				}
				if(!oldAltMgrIps.equalsIgnoreCase(altMgrIps))
				{
					isModified = true;
					auditLogThread.setPreviousValue("02~~IPs of supermanager",oldAltMgrIps);
					auditLogThread.setCurrentValue("02~~IPs of supermanager",altMgrIps);
					superInfo.setValue(SMID,"ALTIPS",altMgrIps);
				}
			}
			superInfo.saveFile();
			Hashtable confSms = superInfo.getConfiguredSuperManagers();
			if(confSms!=null && !confSms.isEmpty())
			{
				if(!EgInstallInfo.isSMConfigured)
				{
					synchronized(IniFile.smIniSync)
					{
						EgInstallInfo.isSMConfigured=true;
					}
				}
			}
			if(isModified)
			{
				auditLogThread.setValue("Description","SuperManager has been modified successfully");
				auditLogThread.sendItToDB();
			}
		}
		else if(mode.equalsIgnoreCase("delete"))
		{
			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","Modify SuperManager");
			auditLogThread.setValue("Activity","Delete SuperManager");
			String deletedSmIds = request.getParameter("supermgrs");
			if(deletedSmIds != null && (deletedSmIds=deletedSmIds.trim()).length()>0)
			{
				String deletedSmId[] = com.egurkha.util.StringUtils.getTokens(deletedSmIds,",");
				if(deletedSmId.length>1)
				{
					auditLogThread.setCurrentValue("ColumnName","SuperManagers Deleted");
				}
				else
				{
					auditLogThread.setCurrentValue("ColumnName","SuperManager Deleted");
				}
				EgSmSuperInfo superInfo = EgSmSuperInfo.getInstance();
				for(int i=0;i<deletedSmId.length;i++)
				{
					String SMID = deletedSmId[i];
					superInfo.deleteValue(EgSmSuperInfo.CONFIGURED_SUPERMANAGERS,SMID);
					superInfo.deleteSubject(SMID);
					auditLogThread.setCurrentValue("SuperManager ID", SMID);
				}
				superInfo.saveFile();
				Hashtable confSms = superInfo.getConfiguredSuperManagers();
				if(confSms==null || confSms.isEmpty())
				{
					synchronized(IniFile.smIniSync)
					{
						EgInstallInfo.isSMConfigured=false;
					}
				}
				if(deletedSmId.length==1)
				{
					auditLogThread.setValue("Description","SuperManager has been deleted successfully");
				}
				else
				{
					auditLogThread.setValue("Description","SuperManagers have been deleted successfully");
				}
			}
			auditLogThread.sendItToDB();
		}
	}
	rootJson.put("success","true");
	out.println(rootJson.toString());
%>