<%
/*****************************************************************************
*  File			: 	EgFileUpload.jsp
*  Purpose		: 	Uploading files to server
*  Version		: 	1.0
*  Creation Date: 	03/02/2005
*
*  Author		: 	Solomon.S, Murugapandian R
******************************************************************************/
%>
<%@ include file="EgTrackerA.jsp"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="java.io.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.egurkha.util.multipart.*" %>
<%@ page import="javax.servlet.*" %>
<%@ page import="javax.servlet.http.*" %>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.*"%>
<%@ page import = "com.eg.EgInstallInfo"%>


<%
	User user = registry.getUser(session.getId());
	EgUserRole userRole = user.getUserRole();
	boolean hasMonitorTab = userRole.hasAnyMonitorRole(EgUserPermission.MONITOR);
	boolean hasReporterTab = userRole.hasAnyReporterRole(EgUserPermission.REPORTER);
	boolean hasConfigTab = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);

	String fileToUpload=request.getParameter("fileUpload");
	String[] availableUIArr={"monitor","reporter","configMgmt"};
	ArrayList availableUIList = new ArrayList();
	String windowTitle=request.getParameter("title");
	if(windowTitle==null)
		windowTitle="File Upload";
	String captions=request.getParameter("dispCaption");
	String uploadfiles=request.getParameter("uploadDir");
	String fileExt=request.getParameter("fileExt");
	StringUtils stringutil=new StringUtils();
	String [] caption_array=stringutil.getTokens(captions, ":");
	String [] file_array=stringutil.getTokens(uploadfiles, ":");
	int captions_length=caption_array.length;
	int uploadfiles_length=file_array.length;

	//Only for upload logo and alert sound settings (EgConfigLogoMsg.jsp) starts - Anand
	String fromPage = request.getParameter("requestFrom");
	String uploadAll = request.getParameter("uploadAll");
	String from=request.getParameter("from");
	from=(from==null)?"":from;
	String uploadFor = request.getParameter("uploadFor");
	for(int i=0;i<availableUIArr.length;i++)
	{
		String tmpUIVal = availableUIArr[i];
		if(tmpUIVal.equals("monitor") && hasMonitorTab)
		{
			if(!tmpUIVal.equals(uploadFor))
			{
				availableUIList.add(tmpUIVal);
			}
		}
		else if(tmpUIVal.equals("reporter") && hasReporterTab)
		{
			if(!tmpUIVal.equals(uploadFor))
			{
				availableUIList.add(tmpUIVal);
			}
		}
		else if(tmpUIVal.equals("configMgmt") && hasConfigTab)
		{
			if(!tmpUIVal.equals(uploadFor))
			{
				availableUIList.add(tmpUIVal);
			}
		}
	}
	fromPage = (fromPage != null)?fromPage:"";
	uploadFor = (uploadFor != null)?uploadFor:"";
	EgDbInfo egdbInfo=new EgDbInfo("manager");
	boolean isDouble=egdbInfo.isDoubleByteEnabled();
	session.setAttribute("availableUIList",availableUIList);
%>
<html>
<head>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script language="JavaScript1.2">
var $j = jQuery.noConflict();

function valform()
{
	var thisForm = document.fileupload;
	var fileExt="<%=fileExt%>";
	var isUpload=false;
	//only for upload logo settings (EgConfigLogoMsg.jsp) - Anand
	var fromPage = "<%=fromPage%>";
	var uploadFor = "<%=uploadFor%>";
	var uploadAll = thisForm.uploadAll.value;
	for (i=0; i<=(thisForm.length-1); i++)
	{
		if (thisForm[i].type==("file"))
		{
			if('<%=isDouble%>'=="false")
			{
				if(!validateSingleByte(thisForm[i].value))
				{
					alert('<egui:intnl text="admin.logo.File name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
					thisForm[i].focus();
					return false;
				}
			}
			if (thisForm[i].value.length>0)
				isUpload=true;
			if ((thisForm[i].value.toLowerCase().indexOf(fileExt))==-1)
			{
				if ('<%=caption_array.length%>' > 1)
				{
					alert('<egui:intnl text="admin.logo.One of the field is empty or the selected file does not have the extension"/>'+": '" +fileExt+ "'" );
					thisForm[i].focus();
					return;
				}
				else
				{
					alert('<egui:intnl text="admin.logo.Field is empty or the selected file does not have the extension"/>'+": '" +fileExt+ "'" );
					thisForm[i].focus();
					return;
				}
			}
		}
	}

	if (isUpload)
	{
		if (fromPage == "EgConfigLogoMsg.jsp")
		{
			var isUploadCheck = $j("#uploadAll");
			var isCateChkAll = document.fileupload.cateChk[0].checked;

			if (uploadFor == "monitor")
			{
				window.opener.document.getElementById("monitorImageStatus").value = "Uploaded";
				window.opener.document.getElementById("monitorImageUploadStatusForAudit").value = "yes";
				if (isUploadCheck.is(':checked'))
				{
					if(isCateChkAll)
					{
						var availUIStr = thisForm.availableUIStr.value;
						if(availUIStr.indexOf(",") != -1)
						{
							var cateChkVal1 = availUIStr.substring(0,availUIStr.indexOf(","));
							var cateChkVal2 = availUIStr.substring(availUIStr.indexOf(",")+1);
							if(cateChkVal1 == "reporter")
							{
								window.opener.document.getElementById("repSelected").value = "enabled";
							}
							if(cateChkVal2 == "configMgmt")
							{
								window.opener.document.getElementById("conSelected").value = "enabled";
							}
						}
						else
						{
							var cateChkVal1 = thisForm.hasOneUIVal.value;
							if(cateChkVal1 == 'reporter')
							{
								window.opener.document.getElementById("repSelected").value = "enabled";
							}
							else
							{
								window.opener.document.getElementById("conSelected").value = "enabled";
							}
						}
					}
					else
					{
						var isSelectedChk1 = document.fileupload.selectedUIChk1.checked;
						var isSelectedChk2 = document.fileupload.selectedUIChk2.checked;
						if(isSelectedChk1)
						{
							var chkVal1 = thisForm.selectedUIChk1.value;
							if(chkVal1 == 'reporter')
							{
								window.opener.document.getElementById("repSelected").value = "enabled";
							}
						}

						if(isSelectedChk2)
						{
							var chkVal2 = thisForm.selectedUIChk2.value;
							if(chkVal2 == 'config')
							{
								window.opener.document.getElementById("conSelected").value = "enabled";
							}
						}
					}
				}
			}
			else if (uploadFor == "reporter")
			{
				window.opener.document.getElementById("reporterImageStatus").value = "Uploaded";
				window.opener.document.getElementById("reporterImageUploadStatusForAudit").value = "yes";
				if (isUploadCheck.is(':checked'))
				{
					if(isCateChkAll)
					{
						var availUIStr = thisForm.availableUIStr.value;
						if(availUIStr.indexOf(",") != -1)
						{
							var cateChkVal1 = availUIStr.substring(0,availUIStr.indexOf(","));
							var cateChkVal2 = availUIStr.substring(availUIStr.indexOf(",")+1);
							if(cateChkVal1 == "monitor")
							{
								window.opener.document.getElementById("monSelected").value = "enabled";
							}
							if(cateChkVal1 == "configMgmt")
							{
								window.opener.document.getElementById("conSelected").value = "enabled";
							}
						}
						else
						{
							var cateChkVal1 = thisForm.hasOneUIVal.value;
							if(cateChkVal1 == 'monitor')
							{
								window.opener.document.getElementById("monSelected").value = "enabled";
							}
							else
							{
								window.opener.document.getElementById("conSelected").value = "enabled";
							}
						}
					}
					else
					{
						var isSelectedChk1 = document.fileupload.selectedUIChk1.checked;
						var isSelectedChk2 = document.fileupload.selectedUIChk2.checked;
						if(isSelectedChk1)
						{
							var chkVal1 = thisForm.selectedUIChk1.value;
							if(chkVal1 == 'monitor')
							{
								window.opener.document.getElementById("monSelected").value = "enabled";
							}
						}

						if(isSelectedChk2)
						{
							var chkVal2 = thisForm.selectedUIChk2.value;
							if(chkVal2 == 'config')
							{
								window.opener.document.getElementById("conSelected").value = "enabled";
							}
						}
					}
				}
			}
			else if (uploadFor == "configMgmt")
			{
				window.opener.document.getElementById("configMgmtImageStatus").value = "Uploaded";
				window.opener.document.getElementById("configMgmtImageUploadStatusForAudit").value = "yes";
				if (isUploadCheck.is(':checked'))
				{
					if(isCateChkAll)
					{
						var availUIStr = thisForm.availableUIStr.value;
						if(availUIStr.indexOf(",") != -1)
						{
							var cateChkVal1 = availUIStr.substring(0,availUIStr.indexOf(","));
							var cateChkVal2 = availUIStr.substring(availUIStr.indexOf(",")+1);
							if(cateChkVal1 == "monitor")
							{
								window.opener.document.getElementById("monSelected").value = "enabled";
							}
							if(cateChkVal1 == "reporter")
							{
								window.opener.document.getElementById("repSelected").value = "enabled";
							}
						}
						else
						{
							var cateChkVal1 = thisForm.hasOneUIVal.value;
							if(cateChkVal1 == 'monitor')
							{
								window.opener.document.getElementById("monSelected").value = "enabled";
							}
							else
							{
								window.opener.document.getElementById("repSelected").value = "enabled";
							}
						}
					}
					else
					{
						var isSelectedChk1 = document.fileupload.selectedUIChk1.checked;
						var isSelectedChk2 = document.fileupload.selectedUIChk2.checked;
						if(isSelectedChk1)
						{
							var chkVal1 = thisForm.selectedUIChk1.value;
							if(chkVal1 == 'moniter')
							{
								window.opener.document.getElementById("monSelected").value = "enabled";
							}
						}

						if(isSelectedChk2)
						{
							var chkVal2 = thisForm.selectedUIChk2.value;
							if(chkVal2 == 'reporter')
							{
								window.opener.document.getElementById("repSelected").value = "enabled";
							}
						}
					}
				}
			}
		}
		thisForm.submit();
	}
	else
	{
		alert('<egui:intnl text="admin.logo.no files selected"/>');
	}
}

function applyToModule(txtVal)
{
	var logoCheck=$j("#uploadAll");
	if(txtVal == '2')
	{
		if (logoCheck.is(':checked'))
		{
			$j("#logoDiv1").show();
			$j("#sp1").show();
		}
		else
		{
			document.fileupload.cateChk[0].checked=true;
			document.fileupload.selectedUIChk1.checked=false;
			document.fileupload.selectedUIChk2.checked=false;
			$j("#logoDiv1").hide();
			$j("#logoDiv2").hide();
			
			$j("#sp1").hide();
			$j("#sp2").hide();
		}
	}
	else
	{
		if (logoCheck.is(':checked'))
		{
			var hiddenVal = "";
			if(txtVal == "Monitor")
			{
				hiddenVal = "monitor";
			}
			else if(txtVal == "Reporter")
			{
				hiddenVal = "reporter";
			}
			else if(txtVal == "configMgmt")
			{
				hiddenVal = "config";
			}
			document.fileupload.hasOneUIVal.value = hiddenVal;
		}
		$j("#logoDiv1").hide();
		$j("#logoDiv2").hide();
		
		$j("#sp1").hide();
		$j("#sp2").hide();
	}
}

function selCategory(txt)
{
	if(txt == "specific")
	{
		document.fileupload.selectedUIChk1.checked=false;
		document.fileupload.selectedUIChk2.checked=false;
		$j("#logoDiv2").show();
		$j("#sp2").show();
	}
	else
	{
		$j("#logoDiv2").hide();
		$j("#sp2").hide();
	}
}
</script>
<title><%=windowTitle%></title>
<egui:skin ui="admin"/>
<!-- <link rel=stylesheet href="styles/egadmin.css">
<link rel="stylesheet" href="eg_styles/eg_adminstyle.css" /> -->
</head>
<body leftmargin="10" topmargin="10" marginwidth="0" marginheight="0" onload="javascript:applyToModule();selCategory();">
<form name="fileupload" method="post" action="../servlet/com.eg.EgFileUpload" ENCTYPE="multipart/form-data">
<table width="450" cellpadding="1" cellspacing="1" align="center" border="0">
	<tr>
		<td nowrap height="10" id="eg_blankspace">&nbsp;</td>
	</tr>
	<tr>
		<td>
			<table width="440" cellpadding="0" cellspacing="0" align="center" border="0" id="table_outer_border" style="padding:0px">
				<tr>
					<td  colspan="2" align="left" id="eg_subheadbg" class="head_padding4"><b><egui:intnl text="admin.logo.Files to be uploaded"/>:</b></td>
				</tr>
<%
	int ctrl=0;
	for (ctrl=0; ctrl<caption_array.length; ctrl++)
	{
		String adminLogo="admin.logo.";
%>
				<tr>
					<td id="head_padding4"><b><egui:intnl text="<%=adminLogo+caption_array[ctrl]%>"/></b></td>
					<td id="head_padding4">:
<%
		// if the uploadfiles is less than captions, this file will be uploaded in eginstall/tmp with its original name
		if (ctrl<uploadfiles_length)
		{
%>
						<input type="hidden" name="FILE_<%=ctrl%>_dstFile" value="<%= file_array[ctrl]%>" >
<%
		}
%>
						<input id="file" type="FILE" name="FILE_<%=ctrl%>" <%=(from.equals("addlogo")?"accept='image/gif'":"")%> >
					</td>
				</tr>
<%
	}
	if(from.equals("addlogo"))
	{
		String resolution=uploadFor.equals("login")?"200x100":"120x40";
		int size=uploadFor.equals("login")?15:10;
%>
				<tr>
					<td class="eg_lightlight head_padding4"><b><egui:intnl text="admin.common.Specifications"/></b></td>
					<td class="eg_lightlight head_padding4">:&nbsp;<egui:intnl text="admin.common.Type"/>:<egui:intnl text="admin.common.GIF"/>;&nbsp; <egui:intnl text="admin.common.Size"/>:<%=size%>KB;&nbsp; <egui:intnl text="admin.common.Resolution"/>:<%=resolution%> <egui:intnl text="admin.common.pixels"/></td>
				</tr>
<%
	}
%>
			</table>
		</td>
	</tr>
<%
	if (availableUIList != null && availableUIList.size() > 0)
	{
		String availableUIStr  = StringUtils.getString(availableUIList);
%>
	<tr>
		<td class="eg_blankspace" height="4px">&nbsp;</td>
	</tr>
	<tr>
		<td>
			<table width="440" cellpadding="0" cellspacing="0" align="center" border="0" class="table_outer_border eg_lightlight" style="padding:0px">
<%
		if (availableUIList != null && availableUIList.size() == 1)
		{
			String tmpDisplayVal = (String) availableUIList.get(0);
			if (tmpDisplayVal != null && tmpDisplayVal.equals("configMgmt"))
			{
				tmpDisplayVal = "configuration";
			}
%>
				<tr>
					<td align="left" width="25">
						<input type="checkbox" name="uploadAll" id="uploadAll" class="eg_input" onclick="javascript:applyToModule('<%=tmpDisplayVal%>');">
					</td>
					<td valign="middle" align="left" class="eg_75bold" width="100%">
						<egui:intnl text="admin.logo.Apply to"/>&nbsp;<%=tmpDisplayVal%>&nbsp;<egui:intnl text="admin.logo.module"/>
					</td>
				</tr>
				<input type="hidden" name="hasOneUIVal" id="hasOneUIVal" value="">
<%
		}
		else
		{
%>
				<tr>
					<td align="left" width="25">
						<input type="checkbox" name="uploadAll" id="uploadAll" class="eg_input" onclick="javascript:applyToModule('2');">
					</td>
					<td valign="middle" nowrap="" align="left" width="100%" class="eg_75bold">
						<egui:intnl text="admin.logo.Apply to other modules"/>
					</td>
				</tr>
<%
		}
%>
				<tr id="sp1">
					<td height="4" id="eg_blankspace" colspan="2">&nbsp;</td>
				</tr>
				<tr id="logoDiv1">
					<td width="25">&nbsp;</td>
					<td id="eg_subcont entbg" class="eg_bodybg" width="100%">
						<table cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td nowrap width="10"><input class="eg_input" type="radio" value="all" name="cateChk" id="cateChk" checked onclick="selCategory('all');"></td>
								<td nowrap width="80"><egui:intnl text="admin.logo.All modules"/></td><input type="hidden" name="availableUIStr" id="availableUIStr" value="<%=availableUIStr%>">
								<td nowrap width="10"><input class="eg_input" type="radio" value="specific" name="cateChk" id="cateChk" onclick="selCategory('specific');"></td>
								<td nowrap><egui:intnl text="admin.logo.Specific modules"/></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr id="sp1">
					<td height="4" id="eg_blankspace" colspan="2" width="25">&nbsp;</td>
				</tr>
				<tr id="sp2">
					<td height="4" id="eg_blankspace" colspan="2" width="25">&nbsp;</td>
				</tr>
				<tr id="logoDiv2">
					<td width="25">&nbsp;</td>
					<td class="eg_bodybg" width="100%">
						<table cellspacing="0" cellpadding="0" border="0" width="100%">
							<tr>
								<td class="eg_75bold" nowrap colspan="4">
									&nbsp;<egui:intnl text="Select the modules" />
								</td>
							</tr>
							<tr>
								<td colspan="4" height="4" id="eg_blankspace">&nbsp;</td>
							</tr>
<%
		if(availableUIList != null && availableUIList.size() > 1)
		{

			String tmpDisplayVal1 = (String) availableUIList.get(0);
			String processVal1 = "";
			String processVal2 = "";
			if(tmpDisplayVal1.equals("monitor"))
			{
				processVal1 = tmpDisplayVal1;
				tmpDisplayVal1 = "Monitor";
			}
			else if(tmpDisplayVal1.equals("reporter"))
			{
				processVal1 = tmpDisplayVal1;
				tmpDisplayVal1 = "Reporter";
			}

			String tmpDisplayVal2 = (String) availableUIList.get(1);
			if(tmpDisplayVal2.equals("reporter"))
			{
				processVal2 = tmpDisplayVal2;
				tmpDisplayVal2 = "Reporter";
			}
			else if(tmpDisplayVal2.equals("configMgmt"))
			{
				processVal2 = "config";
				tmpDisplayVal2 = "Configuration";
			}

%>
							<tr>
								<td nowrap width="10"><input class="eg_input" type="checkbox" value="<%=processVal1%>" name="selectedUIChk1"></td>
								<td nowrap width="80"><%=tmpDisplayVal1%></td>
								<td width="10"><input class="eg_input" type="checkbox" value="<%=processVal2%>" name="selectedUIChk2"></td>
								<td><%=tmpDisplayVal2%></td>
							</tr>
<%
		}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
%>
	<tr>
		<td colspan="2" align="center"><br/>
			<input type="button" name="upload" class="eg_back" value='<egui:intnl text="admin.common.Upload"/>' style="width: 80px;" onClick="javascript:valform()">
		</td>
	</tr>
</table>
</form>
</body>
</html>
