<%
/*
 *   File		:	EgIncludeComponentTests.jsp
 *   Purpose	:	To include tests for components
 *   Author		:	S.Anand (2008)
*/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="java.util.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.EgUtils"%>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import="com.eg.EgExternalInfo" %>
<%@ page import = "com.eg.EgAgentInfo" %>
<%@ page import="com.eg.EgServicesInfo"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>
<jsp:useBean id="sBean" scope="page" class="egurkha.ServiceBean"/>

<%
	//for auditlog - starts
	EgServicesInfo egServicesInfo = new EgServicesInfo("manager");
	boolean isAuditLogEnabled = egServicesInfo.isAuditlogEnabled();
	AuditLogThread auditLogThread = null;
	if (isAuditLogEnabled)
	{
		auditLogThread = new AuditLogThread();
	}
	//for auditlog -ends

	String compType = request.getParameter("componentType");
	String componentsToBeConfigured = request.getParameter("componentName");
	ArrayList aListComponents = new ArrayList();
	StringTokenizer stComponents = new StringTokenizer(componentsToBeConfigured,",");
	TreeMap tmapComponentTests = null;
	while (stComponents.hasMoreTokens())
	{
		String eachComponent = stComponents.nextToken();

		int hashIdx = eachComponent.indexOf("#");
		if (hashIdx > -1)
		{
			if (tmapComponentTests == null)
			{
				tmapComponentTests = new TreeMap();
			}

			String tempComp = eachComponent.substring(0,hashIdx);
			String tempTest = eachComponent.substring(hashIdx+1);
			eachComponent = tempComp;

			boolean isPortRelevantForTempTest = egSpecs.isPortRelevantForTest(tempTest);
			ArrayList aListResultant = (ArrayList)tmapComponentTests.get(tempComp);
			if (aListResultant == null)
			{
				ArrayList aListTempHostTests = null;
				ArrayList aListTempApplTests = null;

				if (isPortRelevantForTempTest)
				{
					aListTempApplTests = new ArrayList();
					aListTempApplTests.add(tempTest);
				}
				else
				{
					aListTempHostTests = new ArrayList();
					aListTempHostTests.add(tempTest);
				}

				aListResultant = new ArrayList();
				aListResultant.add(aListTempHostTests);
				aListResultant.add(aListTempApplTests);

				tmapComponentTests.put(tempComp,aListResultant);
			}
			else
			{
				if (isPortRelevantForTempTest)
				{
					ArrayList aListTempApplTests = (ArrayList)aListResultant.get(1);
					if (aListTempApplTests == null)
					{
						aListResultant.remove(1);//remove the null reference
						aListTempApplTests = new ArrayList();
						aListResultant.add(1,aListTempApplTests);
					}

					aListTempApplTests.add(tempTest);
				}
				else
				{
					ArrayList aListTempHostTests = (ArrayList)aListResultant.get(0);
					if (aListTempHostTests == null)
					{
						aListResultant.remove(0);//remove the null reference
						aListTempHostTests = new ArrayList();
						aListResultant.add(0,aListTempHostTests);
					}

					aListTempHostTests.add(tempTest);
				}
			}
		}
		aListComponents.add(eachComponent);
	}

	String mainComponentName = "";
	if (request.getParameter("mainComponentName") != null)
	{
		mainComponentName = request.getParameter("mainComponentName");
	}
	else
	{
		mainComponentName = (String)aListComponents.get(0);
	}

	String testType = request.getParameter("testType");
	testType = testType != null?testType:"PerformanceTest";
	String testsForInclusion = request.getParameter("TestsForInclusion");

	//stoping the discovery process
	sBean.stopDiscovery();

	//remove tests from eg_disable.ini - starts
	//prgBean.createFile("eg_disable.ini","save");

	ArrayList aListSelectedHostTests = new ArrayList();
	ArrayList aListSelectedApplnTests = new ArrayList();
	ArrayList aListTestForInclusion = new ArrayList();
	StringTokenizer st = new StringTokenizer(testsForInclusion,",");
	while (st.hasMoreTokens())
	{
		String strTest = st.nextToken();
		aListTestForInclusion.add(strTest);
		boolean isPortRelevantForStrTest = egSpecs.isPortRelevantForTest(strTest);
		if (isPortRelevantForStrTest)
		{
			aListSelectedApplnTests.add(strTest);
		}
		else
		{
			aListSelectedHostTests.add(strTest);
		}
	}

	//for auditlog 
	ArrayList aListAuditTest = null;
	if (isAuditLogEnabled)
	{
		aListAuditTest = new ArrayList(aListTestForInclusion);
	}
	prgBean.createSyncFile("eg_disable.ini","save");
	for (int z=0;z<aListComponents.size();z++)
	{
		String compName = (String)aListComponents.get(z);
		if (tmapComponentTests != null)
		{
			ArrayList aListResultant = (ArrayList)tmapComponentTests.get(compName);
			if (aListResultant != null)
			{
				aListSelectedHostTests = (ArrayList)aListResultant.get(0);
				aListSelectedApplnTests = (ArrayList)aListResultant.get(1);
			}
		}

		if (aListSelectedHostTests != null && aListSelectedHostTests.size() > 0)
		{
			String hostLevelTestSubject = "Default_server";
			String hostLevelTestVariable = hostLevelTestSubject + ":" + compName.substring(0,compName.indexOf(":"));
			String strValue = prgBean.getStrValue(hostLevelTestSubject, hostLevelTestVariable);
			ArrayList aListHostLevelTests = new ArrayList();
			StringTokenizer strTokens = new StringTokenizer(strValue,",");
			while (strTokens.hasMoreTokens())
			{
				String str = strTokens.nextToken();
				aListHostLevelTests.add(str);
			}

			aListHostLevelTests.removeAll(aListSelectedHostTests);
			if (aListHostLevelTests.isEmpty())
			{
				prgBean.deleteValues(hostLevelTestSubject,hostLevelTestVariable);
			}
			else
			{
				String str = aListHostLevelTests.toString();
				str = str.substring(1,str.length()-1);
				str = StringUtils.replace(str," ","");
				prgBean.setValues(hostLevelTestSubject,hostLevelTestVariable,str);
			}
		}

		if (aListSelectedApplnTests != null && aListSelectedApplnTests.size() > 0)
		{
			String applnLevelTestSubject = compType;
			String applnLevelTestVariable = applnLevelTestSubject + ":" + compName;
			String strValue = prgBean.getStrValue(applnLevelTestSubject,applnLevelTestVariable);
			ArrayList aListApplnLevelTests = new ArrayList();
			StringTokenizer strTokens = new StringTokenizer(strValue,",");
			while (strTokens.hasMoreTokens())
			{
				String str = strTokens.nextToken();
				aListApplnLevelTests.add(str);
			}

			aListApplnLevelTests.removeAll(aListSelectedApplnTests);
			if (aListApplnLevelTests.isEmpty())
			{
				prgBean.deleteValues(applnLevelTestSubject,applnLevelTestVariable);
			}
			else
			{
				String str = aListApplnLevelTests.toString();
				str = str.substring(1,str.length()-1);
				str = StringUtils.replace(str," ","");
				prgBean.setValues(applnLevelTestSubject,applnLevelTestVariable,str);
			}
		}
	}

	prgBean.saveFile();
	prgBean.releaseInstance();
	//remove tests from eg_disable.ini - starts

	boolean allowAggregateOperation = false;
	boolean isAggregateComponentType = false;
	Hashtable ht_aggCompsAndExcludedTests = null;
	if (allowAggregateOperation)
	{
		//For aggregate test frequency setting - starts
		//IniFile agentIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini",true);
		IniFile agentIni = null;
		IniFile specsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_specs.ini");
		IniFile aggIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_aggregate.ini");
		IniFile disableIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_disable.ini");

		EgDiscInfo discInfo = new EgDiscInfo("manager");
		EgAgentInfo agentInfo = new EgAgentInfo("manager");
		EgAggregateInfo aggInfo = new EgAggregateInfo("manager");
		if (EgInstallInfo.isAggSupported)
		{

			ArrayList managedComponents =  discInfo.getAllManagedNames(true);

			boolean hasAggServerType = false;
			String allAggServerTypes[] = aggIni.getVariables("COMPONENT_TYPE_MAPPING");
			allAggServerTypes = allAggServerTypes != null?allAggServerTypes:new String[0];
			String allAggTests[] = aggIni.getVariables("AGGREGATE_TEST");
			allAggTests = allAggTests != null?allAggTests:new String[0];
			String aggComponentType = "";
			String nonAggcompTypeOfAggCompType = "";

			for(int m=0;m<allAggServerTypes.length;m++)
			{
				if (compType.startsWith("Agg_"))
				{
					nonAggcompTypeOfAggCompType = aggIni.getValue("COMPONENT_TYPE_MAPPING",compType);
					break;
				}
				else
				{
					String aggregatedServers = aggIni.getValue("COMPONENT_TYPE_MAPPING",allAggServerTypes[m]);
					if (aggregatedServers == null || aggregatedServers.equals("")) continue;
					StringTokenizer stc = new StringTokenizer(aggregatedServers, ",");
					while(stc.hasMoreTokens())
					{
						String thisToken = stc.nextToken();
						if(!thisToken.equals(compType)) continue;
						aggComponentType = allAggServerTypes[m];
						hasAggServerType = true;
					}
				}
			}
			agentIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
			for (int i=0;i<aListTestForInclusion.size();i++)
			{
				String strTestName = (String)aListTestForInclusion.get(i);
				boolean hasAggTest = false;
				Hashtable keyValue = new Hashtable();
				String testMappedWithAggTest = "";
				for(int m=0;m<allAggTests.length;m++)
				{
					if (compType.startsWith("Agg_"))
					{
						testMappedWithAggTest = aggIni.getValue("AGGREGATE_TEST",strTestName);
						break;
					}
					else
					{
						if(!aggIni.getValue("AGGREGATE_TEST",allAggTests[m]).equals(strTestName)) continue;
						keyValue.put(allAggTests[m],strTestName);
						hasAggTest = true;
					}
				}

				boolean isAggregate = aggInfo.isAggregateTest(strTestName) && compType.startsWith("Agg_");

				if (!isAggregate && hasAggServerType && hasAggTest)
				{
					boolean isPortRelevantForStrTest = egSpecs.isPortRelevantForTest(strTestName);

					String [] specsVar = specsIni.getVariables("TEST_SPECIFICATION");
					String defaultTestParam = "";
					String defaultTestPeriod = "";
					if (!EgUtils.isNull((Object) specsVar))
					{
						String defaultPattern = getDefaultPattern(compType,strTestName,specsVar);
						defaultTestParam = specsIni.getValue("TEST_SPECIFICATION", defaultPattern);
						defaultTestPeriod = defaultTestParam.substring(defaultTestParam.lastIndexOf(",")+1).trim();
					}

					String variables[] = aggIni.getVariables("AGGREGATE_COMPONENTS");

					for (int j=0;j<aListComponents.size();j++)
					{
						String compName = (String)aListComponents.get(j);
						ArrayList aListAggComponents = new ArrayList();
						for (int m=0;m<variables.length;m++)
						{
							String strTemp = variables[m];
							if (strTemp.startsWith(aggComponentType + ":") && strTemp.endsWith("#" + compType + ":" + compName))
							{
								String tempAggComponentName = strTemp.substring(strTemp.indexOf(":")+1,strTemp.indexOf("#"));
								aListAggComponents.add(tempAggComponentName);
							}
						}

						for (int z=0;z<aListAggComponents.size();z++)
						{
							ArrayList aListComponentsUnderAgg = new ArrayList();
							String aggComponentName = (String)aListAggComponents.get(z);
							String pattern = aggComponentType + ":" + aggComponentName + "#" + compType + ":";
							for (int m=0;m<variables.length;m++)
							{
								String strTemp = variables[m];

								if (strTemp.startsWith(pattern))
								{
									String tempComp = strTemp.substring(pattern.length(),strTemp.length());
									aListComponentsUnderAgg.add(tempComp);
								}
							}

							//removing the userintiated component whose entry is not in the eg_egents.ini - starts
							if (aListComponentsUnderAgg.contains(compName))
							{
								aListComponentsUnderAgg.remove(aListComponentsUnderAgg.indexOf(compName));
							}
							//removing the userintiated component whose entry is not in the eg_egents.ini - ends

							//compagg = comp1,comp2
							//comp1 = userintiated component
							//ensuring "whether test for the comp2 is also excluded?"
							//removing the component whose entry is not in the eg_egents.ini - starts
							String subject = "";
							if (isPortRelevantForStrTest)
							{
								subject = compType;
							}
							else
							{
								subject = "Default_server";
							}
							ArrayList aListCompToBeRemoved = new ArrayList();
							for (int m=0;m<aListComponentsUnderAgg.size();m++)
							{
								String strPattern = "";
								String tempComponent = (String)aListComponentsUnderAgg.get(m);
								if (isPortRelevantForStrTest)
								{
									strPattern = compType + ":" + tempComponent;
								}
								else
								{
									strPattern = subject + ":" + tempComponent.substring(0,tempComponent.indexOf(":"));
								}
								String value = disableIni.getValue(subject,strPattern);
								ArrayList aListTestExcluded = getArrayList(value,",");
								if (aListTestExcluded.contains(strTestName))
								{
									aListCompToBeRemoved.add(tempComponent);
								}
							}

							aListComponentsUnderAgg.removeAll(aListCompToBeRemoved);
							//removing the component whose entry is not in the eg_egents.ini - ends

							String maxTestPeriod = "";
							if (aListComponentsUnderAgg.isEmpty())
							{
								maxTestPeriod = defaultTestPeriod;
							}

							for (int m=0;m<aListComponentsUnderAgg.size();m++)
							{
								String tempComponent = (String)aListComponentsUnderAgg.get(m);
								List aListAgents = getAgents(tempComponent);
								boolean isExternalTest = egSpecs.isExternalTest(strTestName,compType);
								String strAgentNickName = "";
								if (isExternalTest)
								{
									strAgentNickName = (String)aListAgents.get(1);
								}
								else
								{
									strAgentNickName = (String)aListAgents.get(0);
								}

								if (strAgentNickName == null || strAgentNickName.equalsIgnoreCase("")) continue;

								String agentIniVariables[] = agentIni.getVariables(strAgentNickName);

								String resultantPattern = getResultantPattern(compType,tempComponent,strTestName,agentIniVariables);
								if (resultantPattern.equalsIgnoreCase("")) continue;

								String tempTestParam = agentIni.getValue(strAgentNickName,resultantPattern);
								String tempTestPeriod = tempTestParam.substring(tempTestParam.lastIndexOf(",")+1).trim();
								boolean hasMaxPeriodValue = false;
								if (!maxTestPeriod.equals("") && Integer.parseInt(maxTestPeriod) > Integer.parseInt(tempTestPeriod) && Integer.parseInt(maxTestPeriod) > Integer.parseInt(defaultTestPeriod))
								{
									hasMaxPeriodValue = true;
								}
								if (hasMaxPeriodValue) continue;

								if(Integer.parseInt(tempTestPeriod) > Integer.parseInt(defaultTestPeriod))
								{
									maxTestPeriod = tempTestPeriod;
								}
								else
								{
									maxTestPeriod = defaultTestPeriod;
								}
							}

							List aListAgents = getAgents(aggComponentName);
							Enumeration enu = keyValue.keys();
							while(enu.hasMoreElements())
							{
								String aggregateTestName = (String) enu.nextElement();
								List aListTempAgents = null;
								boolean isExternalTest = egSpecs.isExternalTest(aggregateTestName,aggComponentType);
								if (isExternalTest)
								{
									aListTempAgents = aListAgents.subList(1,aListAgents.size());
								}
								else
								{
									aListTempAgents = aListAgents.subList(0,1);
								}

								if (aListTempAgents == null) continue;
								for (int k=0;k<aListTempAgents.size();k++)
								{
									String tempPattern = "";
									String tempTestParam = "";
									String strComp = "";
									String tempAggAgent = (String)aListTempAgents.get(k);

									boolean b_isPortRelevantForAggTest = egSpecs.isPortRelevantForTest(aggregateTestName);

									if (b_isPortRelevantForAggTest)
									{
										if (aggComponentName.indexOf(":") == -1)
										{
											strComp = aggComponentName + ":NULL";
										}
										else
										{
											strComp = aggComponentName;
										}
										if(aggComponentType.endsWith("_ex"))
										{
											tempPattern = aggregateTestName+":"+aggComponentType+":"+strComp;
										}
										else
										{
											tempPattern = aggregateTestName+"::"+strComp;
										}
									}
									else
									{
										if (aggComponentName.indexOf(":") == -1)
										{
											strComp = aggComponentName;
										}
										else
										{
											strComp = aggComponentName.substring(0,aggComponentName.indexOf(":"));
										}
										tempPattern = aggregateTestName+"::"+strComp;
									}

									tempTestParam = agentIni.getValue(tempAggAgent,tempPattern);
									if(tempTestParam == null || tempTestParam.trim().length()==0) continue;
									String oldTestFrequency = tempTestParam.substring(tempTestParam.lastIndexOf(",")+1).trim();
									oldTestFrequency = oldTestFrequency.trim();
									if (Integer.parseInt(maxTestPeriod) > Integer.parseInt(oldTestFrequency))
									{
										tempTestParam = "-manual,"+tempTestParam.substring(tempTestParam.indexOf(",")+1,tempTestParam.lastIndexOf(",")) + ", " + maxTestPeriod;
										agentIni.setValue(tempAggAgent,tempPattern,tempTestParam);
									}
								}
							}
						}
					}
				}
				else if(isAggregate)
				{
					String [] specsVar = specsIni.getVariables("TEST_SPECIFICATION");
					String defaultTestParam = "";
					String defaultTestPeriod = "";
					if (!EgUtils.isNull((Object) specsVar))
					{
						String defaultPattern = getDefaultPattern(compType,strTestName,specsVar);
						defaultTestParam = specsIni.getValue("TEST_SPECIFICATION", defaultPattern);
						defaultTestPeriod = defaultTestParam.substring(defaultTestParam.lastIndexOf(",")+1).trim();
					}

					boolean isPortRelevantForStrTest = egSpecs.isPortRelevantForTest(testMappedWithAggTest);

					String variables[] = aggIni.getVariables("AGGREGATE_COMPONENTS");
					for (int z=0;z<aListComponents.size();z++)
					{
						String compName = (String)aListComponents.get(z);
						ArrayList aListComponentsUnderAgg = new ArrayList();
						for (int m=0;m<variables.length;m++)
						{
							String strTemp = variables[m];
							String pattern = compType + ":" + compName + "#" + nonAggcompTypeOfAggCompType + ":";
							if (strTemp.startsWith(pattern))
							{
								String tempComponentName = strTemp.substring(pattern.length(),strTemp.length());
								aListComponentsUnderAgg.add(tempComponentName);
							}
						}

						String maxTestPeriod = "";
						for (int m=0;m<aListComponentsUnderAgg.size();m++)
						{
							String tempComponent = (String)aListComponentsUnderAgg.get(m);
							List aListAgents = getAgents(tempComponent);
							boolean isExternalTest = egSpecs.isExternalTest(testMappedWithAggTest,nonAggcompTypeOfAggCompType);
							String strAgentNickName = "";
							if (isExternalTest)
							{
								strAgentNickName = (String)aListAgents.get(1);
							}
							else
							{
								strAgentNickName = (String)aListAgents.get(0);
							}

							if (strAgentNickName == null || strAgentNickName.equalsIgnoreCase("")) continue;

							String agentIniVariables[] = agentIni.getVariables(strAgentNickName);
							String resultantPattern = getResultantPattern(nonAggcompTypeOfAggCompType,tempComponent,testMappedWithAggTest,agentIniVariables);

							if (resultantPattern.equalsIgnoreCase("")) continue;

							String tempTestParam = agentIni.getValue(strAgentNickName,resultantPattern);
							String tempTestPeriod = tempTestParam.substring(tempTestParam.lastIndexOf(",")+1).trim();

							boolean hasMaxPeriodValue = false;
							if (!maxTestPeriod.equals("") && Integer.parseInt(maxTestPeriod) > Integer.parseInt(tempTestPeriod) && Integer.parseInt(maxTestPeriod) > Integer.parseInt(defaultTestPeriod))
							{
								hasMaxPeriodValue = true;
							}
							if (hasMaxPeriodValue) continue;

							if(Integer.parseInt(tempTestPeriod) > Integer.parseInt(defaultTestPeriod))
							{
								maxTestPeriod = tempTestPeriod;
							}
							else
							{
								maxTestPeriod = defaultTestPeriod;
							}
						}

						List aListAgents = getAgents(compName);
						boolean isExternalTest = egSpecs.isExternalTest(strTestName,compType);
						String strAgentNickName = "";
						if (isExternalTest)
						{
							strAgentNickName = (String)aListAgents.get(1);
						}
						else
						{
							strAgentNickName = (String)aListAgents.get(0);
						}

						if (strAgentNickName == null || strAgentNickName.equalsIgnoreCase("")) continue;

						String agentIniVariables[] = agentIni.getVariables(strAgentNickName);

						String resultantPattern = getResultantPattern(compType,compName,strTestName,agentIniVariables);
						if (resultantPattern.equalsIgnoreCase("")) continue;

						String tempTestParam = agentIni.getValue(strAgentNickName,resultantPattern);
						String tempTestPeriod = tempTestParam.substring(tempTestParam.lastIndexOf(",")+1).trim();
						if(Integer.parseInt(tempTestPeriod) < Integer.parseInt(maxTestPeriod))
						{
							tempTestParam = "-manual," + tempTestParam.substring(tempTestParam.indexOf(",")+1,tempTestParam.lastIndexOf(",")) + ", " + maxTestPeriod;
							agentIni.setValue(strAgentNickName,resultantPattern,tempTestParam);
						}
					}
				}
			}

			agentIni.saveFile();
			EgConfigFilesSync.releaseInstance(agentIni);
		}
		//For aggregate test frequency setting - ends

		//For aggregate - starts
		//Consider web components webcomp1:80,webcomp2:80
		//webagg:NULL is wrapped with webcomp1:80 and webcomp2:80
		//When a test say DiskActivityTest of webcomp1:80 and webcomp2:80 is excluded,
		//We know that corresponding DiskActivityAggTest of webagg:NULL should also get excluded.
		//Here we should not allow DiskActivityAggTest of webagg:NULL should be included,
		//because DiskActivityTest test for webcomp1:80 and webcomp2:80 was already excluded .

		isAggregateComponentType = compType.startsWith("Agg_");
		if (EgInstallInfo.isAggSupported && isAggregateComponentType)
		{
			List listAggPatterns = Arrays.asList(aggIni.getVariables("AGGREGATE_COMPONENTS"));
			String allAggTests[] = aggIni.getVariables("AGGREGATE_TEST");
			allAggTests = allAggTests != null?allAggTests:new String[0];
			ArrayList aListAggTest = new ArrayList();
			for(int m=0;m<allAggTests.length;m++)
			{
				String tempAggTest = allAggTests[m];
				String tempTest = aggIni.getValue("AGGREGATE_TEST",allAggTests[m]);
				aListAggTest.add(tempTest);
				aListAggTest.add(tempAggTest);
			}

			//for error page EgAggregateAlert.jsp
			ht_aggCompsAndExcludedTests = new Hashtable();
			agentIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
			IniFile disableIniWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_disable.ini");
			for (int z=0;z<aListComponents.size();z++)
			{
				String compName = (String)aListComponents.get(z);
				ArrayList aListComponentsUnderAggregate = new ArrayList();
				String componentTypeClubbedToAgg = "";
				String tempAggTests = "";
				for (int i=0;i<listAggPatterns.size();i++)
				{
					String strPattern = (String)listAggPatterns.get(i);
					String patternSearch = compType + ":" + compName + "#";
					if (strPattern.startsWith(patternSearch))
					{
						String tempComponentWithType = strPattern.substring(patternSearch.length(),strPattern.length());
						componentTypeClubbedToAgg = tempComponentWithType.substring(0,tempComponentWithType.indexOf(":"));
						String tempComponentName = tempComponentWithType.substring(tempComponentWithType.indexOf(":")+1,tempComponentWithType.length());
						aListComponentsUnderAggregate.add(tempComponentName);
					}
				}

				int numberOfPatternsToBefound = aListComponentsUnderAggregate.size();
				for (int i=0;i<aListTestForInclusion.size();i++)
				{
					String strAggTest = (String)aListTestForInclusion.get(i);
					String mappedTestForAggTest = "";
					if (aListAggTest.contains(strAggTest))
					{
						mappedTestForAggTest = (String)aListAggTest.get(aListAggTest.indexOf(strAggTest)-1);
					}
					boolean isPortRelevantForStrTest = egSpecs.isPortRelevantForTest(mappedTestForAggTest);
					int patternsFound = 0;
					for (int j=0;j<aListComponentsUnderAggregate.size();j++)
					{
						String tempComponent = (String)aListComponentsUnderAggregate.get(j);
						String searchPattern = "";
						String subject = "";
						if (isPortRelevantForStrTest)
						{
							subject = componentTypeClubbedToAgg;
							searchPattern  = componentTypeClubbedToAgg + ":" +  tempComponent;
						}
						else
						{
							subject = "Default_server";
							searchPattern  = "Default_server" + ":" + tempComponent.substring(0,tempComponent.indexOf(":"));
						}
						String value = disableIniWr.getValue(subject,searchPattern);
						ArrayList aListTestExcluded = getArrayList(value,",");
						if (aListTestExcluded.contains(mappedTestForAggTest))
						{
							patternsFound++;
						}
					}

					if (patternsFound == numberOfPatternsToBefound)
					{
						String agg_searchPattern = "";
						String agg_subject = "";
						boolean isPortRelevantForAggTest = egSpecs.isPortRelevantForTest(strAggTest);
						if (isPortRelevantForAggTest)
						{
							agg_subject = compType;
							agg_searchPattern  = compType + ":" +  compName;
						}
						else
						{
							agg_subject = "Default_server";
							agg_searchPattern  = "Default_server" + ":" + compName.substring(0,compName.indexOf(":"));
						}
						String strValue = disableIniWr.getValue(agg_subject, agg_searchPattern);
						ArrayList aListResultantTest = new ArrayList();

						if (strValue != null && strValue.length() > 0)
						{
							StringTokenizer strTokens = new StringTokenizer(strValue,",");
							while (strTokens.hasMoreTokens())
							{
								String str = strTokens.nextToken();
								aListResultantTest.add(str);
							}
						}
						aListResultantTest.add(strAggTest);

						tempAggTests = tempAggTests + strAggTest + ",";

						//removing the tests which should be disabled
						if (isAuditLogEnabled && !aListResultantTest.isEmpty() && compName.equals(mainComponentName))
						{
							aListAuditTest.removeAll(aListResultantTest);
						}

						String str = aListResultantTest.toString();
						str = str.substring(1,str.length()-1);
						str = StringUtils.replace(str," ","");
						disableIniWr.setValue(agg_subject,agg_searchPattern,str);
						String tempAgentName = getAgentNickName(compType,compName,strAggTest);
						if (tempAgentName == null) continue;

						String[] testVariables = agentIni.getVariables(tempAgentName);
						String resultantPattern = getResultantPattern(compType,compName,strAggTest,testVariables);
						if (resultantPattern == null || resultantPattern.equals("")) continue;
						agentIni.deleteValue(tempAgentName,resultantPattern);
					}
				}

				if (tempAggTests.length() > 0)
				{
					tempAggTests = tempAggTests.substring(0,tempAggTests.length()-1);
					ht_aggCompsAndExcludedTests.put(compName,tempAggTests);
				}
			}

			//save the ini files
			disableIniWr.saveFile();
			agentIni.saveFile();
			EgConfigFilesSync.releaseInstance(agentIni);
			EgConfigFilesSync.releaseInstance(disableIniWr);
		}
	}

	//for auditlog - starts
	if (isAuditLogEnabled && !aListAuditTest.isEmpty())
	{
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Tests");
		auditLogThread.setValue("Activity","Configure Test");
		auditLogThread.setValue("Description","Test(s) have been included from test configuration");
		auditLogThread.setCurrentValue("01~~Component Type","$ctype$:"+compType);

		if (tmapComponentTests == null)
		{
			if(mainComponentName.indexOf(":NULL") > -1)
			{
				auditLogThread.setCurrentValue("02~~Component Name",mainComponentName.substring(0,mainComponentName.indexOf(":")));
			}
			else
			{
				auditLogThread.setCurrentValue("02~~Component Name",mainComponentName);
			}

			for (int i=0;i<aListAuditTest.size();i++)
			{
				String strTest = (String)aListAuditTest.get(i);
				if(strTest.endsWith("_ex"))
				{
					auditLogThread.setCurrentValue("03~~Included Test(s)",strTest);
				}
				else
				{
					auditLogThread.setCurrentValue("03~~Included Test(s)","$test$:" + strTest);
				}
			}
		}
		else
		{
			Set set = tmapComponentTests.keySet();
			Iterator itr = set.iterator();
			while (itr.hasNext())
			{
				String strComp = (String)itr.next();
				ArrayList aListTests = (ArrayList)tmapComponentTests.get(strComp);
				if (aListTests != null)
				{
					ArrayList aListAuditTests = null;
					ArrayList aListAuditHostTests = (ArrayList)aListTests.get(0);
					ArrayList aListAuditApplnTests = (ArrayList)aListTests.get(1);
					if (aListAuditHostTests != null && aListAuditApplnTests == null)
					{
						aListAuditTests = aListAuditHostTests;
					}
					else if(aListAuditHostTests == null && aListAuditApplnTests != null)
					{
						aListAuditTests = aListAuditApplnTests;
					}
					else if (aListAuditHostTests != null && aListAuditApplnTests != null)
					{
						aListAuditHostTests.addAll(aListAuditApplnTests);
						aListAuditTests = aListAuditHostTests;
					}

					StringBuffer sBValue = new StringBuffer();
					int intAuditTestSize = aListAuditTests.size();
					for (int i=0;i<intAuditTestSize;i++)
					{
						String tempTest = (String)aListAuditTests.get(i);
						sBValue.append(_mapping.getTestDescription(tempTest));
						if (i+1!=intAuditTestSize)
						{
							sBValue.append(",");
						}
					}

					if (strComp.indexOf(":NULL") > -1)
					{
						auditLogThread.setCurrentValue("Included tests for the "+strComp.substring(0,strComp.indexOf(":")),sBValue.toString());
					}
					else
					{
						auditLogThread.setCurrentValue("Included tests for the "+strComp,sBValue.toString());
					}
				}
			}
		}

		auditLogThread.sendItToDB();
	}
	//for auditlog - ends

	//starting the discovery process
	sBean.startDiscovery("1",true);

	//this sleep is to synch with the discovery process
	try
	{
		Thread.sleep(1000);
	}
	catch(Exception e)
	{
	}

	String query = "";
	if (EgInstallInfo.isAggSupported && isAggregateComponentType && allowAggregateOperation)
	{
		if (ht_aggCompsAndExcludedTests.isEmpty())
		{
			query = "EgConfigureComponentTests.jsp?componentType="+EgURLEncoder.encode(compType,"UTF-8")+"&componentName="+EgURLEncoder.encode(mainComponentName,"UTF-8")+"&testType="+EgURLEncoder.encode(testType,"UTF-8");
		}
		else
		{
			query = "EgAggregateAlert.jsp?fromPage=EgIncludeComponentTests.jsp&componentType="+EgURLEncoder.encode(compType,"UTF-8")+"&componentName="+EgURLEncoder.encode(mainComponentName,"UTF-8")+"&testType="+EgURLEncoder.encode(testType,"UTF-8");
			session.setAttribute("ht_aggCompsAndExcludedTests",ht_aggCompsAndExcludedTests);
		}
	}
	else
	{
		query = "EgConfigureComponentTests.jsp?componentType="+EgURLEncoder.encode(compType,"UTF-8")+"&componentName="+EgURLEncoder.encode(mainComponentName,"UTF-8")+"&testType="+EgURLEncoder.encode(testType,"UTF-8");
	}
%>

<jsp:forward page="<%=query%>" />

<%!
	EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");

	private ArrayList getArrayList(String strValue,String delimiter)
	{
		ArrayList aL = new ArrayList();
		StringTokenizer stTempTokens = new StringTokenizer(strValue,delimiter);
		while (stTempTokens.hasMoreTokens())
		{
			String str = stTempTokens.nextToken().trim();
			aL.add(str);
		}
		return aL;
	}

	//Will provide the right agent (subject) for a component and its test
	private String getAgentNickName(String componentType,String compName,String testName)
	{
		boolean isExternalTest = egSpecs.isExternalTest(testName,componentType);
		List aListTempAgentsForComponent = getAgents(compName);
		String agentName = null;
		if (isExternalTest)
		{
			//external agent for external test
			agentName = (String)aListTempAgentsForComponent.get(1);
		}
		else
		{
			//internal agent or remote agent for host level test and application level test.
			agentName = (String)aListTempAgentsForComponent.get(0);
		}

		return agentName;
	}

	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();

		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";
		boolean isRemote = false;

		// To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(componentNickName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(componentNickName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = componentNickName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		// To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}

	//fetch the default entry for the component to be included - starts
	private String getDefaultPattern(String componentType,String testName,String[] variables)
	{
		String defaultPattern = "";
		String port = "";
		if (componentType.equals("Oracle_server"))
		{
			port = "$portNo:$sid";
		}
		else
		{
			port = "$portNo";
		}

		String patternA = testName + ":" + componentType + ":" + "$hostName" + ":" + port;
		String patternB = testName + ":" + componentType + ":" + "$hostName";
		String patternC = testName + "::" + "$hostName" + ":" + port;
		String patternD = testName + "::" + "$hostName";

		List listSpecficationVariables = Arrays.asList(variables);
		String resultantPattern = "";
		if (listSpecficationVariables.contains(patternA))
		{
			defaultPattern = patternA;
		}
		else if (listSpecficationVariables.contains(patternB))
		{
			defaultPattern = patternB;
		}
		else if (listSpecficationVariables.contains(patternC))
		{
			defaultPattern = patternC;
		}
		else if (listSpecficationVariables.contains(patternD))
		{
			defaultPattern = patternD;
		}

		return defaultPattern;
	}
	//fetch the default entry for the component to be included - ends

	private String getResultantPattern(String componentType,String componentName,String testName,String[] variables)
	{
		String resultantPattern = "";
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));

		String specificPattern_A = testName + ":" + componentType + ":" + componentName;
		String specificPattern_B = testName + ":" + componentType + ":" + componentNickName;
		String defaultPattern_A = testName + "::" + componentName;
		String defaultPattern_B = testName + "::" + componentNickName;

		List listAgentIniVariables = Arrays.asList(variables);

		if(listAgentIniVariables.contains(specificPattern_A))
		{
			resultantPattern = specificPattern_A;
		}
		else if(listAgentIniVariables.contains(specificPattern_B))
		{
			resultantPattern = specificPattern_B;
		}
		else if(listAgentIniVariables.contains(defaultPattern_A))
		{
			resultantPattern = defaultPattern_A;
		}
		else if(listAgentIniVariables.contains(defaultPattern_B))
		{
			resultantPattern = defaultPattern_B;
		}

		return resultantPattern;
	}
%>



