<%
/*************************************************************************************************/
/*                 Name          : EgAutoManagePage.jsp                                          */
/*                 Purpose       : This page is used to create Java script Auto Topology         */
/*                 Version       : 5.4                                                           */
/*                 Created On    : 05-08-2011                                                    */
/*************************************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<jsp:useBean id="zoneI" class="egurkha.ZoneInfoBean" scope="page" />
<jsp:useBean id="user" class="egurkha.UserBean" scope="page"/>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
try
{
	boolean isDouble=EgDbInfo.doubleByteEnabled;
	String [] groups = zoneI.getZoneNames();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String segment = request.getParameter("segment");
	String action = request.getParameter("action");
	String zone  = request.getParameter("zone");
	
	String dragFn = request.getParameter("enableDrag");
	if(dragFn==null)
		dragFn="false";

	String saveFrom = request.getParameter("saveFrom");
	if(saveFrom==null) saveFrom="";

	EgGroupInfo groupInfo = new EgGroupInfo();
	ArrayList thisZoneComponents = new ArrayList();	// Contains all components from the given zone.

	// Collect Zone componets, if zone is not Default
	boolean isZone = false;
	if(zone!=null && !zone.equals("-1"))
	{
		thisZoneComponents = groupInfo.getAllComponentsUnderZone(zone);
		isZone = true;

		// If any group exists in the zone, add the Group names with type
		TreeSet mySet =  groupInfo.getAllGroupsUnderZone(zone, true);
		if(mySet!=null && mySet.size() > 0)
		{
			Iterator thisItr = mySet.iterator();
			while(thisItr.hasNext())
			{
				String thisStr = (String) thisItr.next();
				thisZoneComponents.add(thisStr);
			}
		}
	}

	boolean isNoCompInSegment=false;
	boolean isNewCompExists = false;
	boolean isUnManageExists = false;
	boolean isComplete = false;
	boolean isSave = false;
	boolean addToZone = false;
	boolean addToGroup=false;
	boolean saveAs = false;
	boolean segLimitExceed = false;

	Hashtable compHash = new Hashtable();
	ArrayList compGroupList = new ArrayList();
	ArrayList newCompList = new ArrayList();
	ArrayList unManageList = new ArrayList();
	ArrayList segComponents = new ArrayList();
	ArrayList incompleteList = new ArrayList();
	ArrayList addTothisZone = new ArrayList();

	if(segment!=null && segment.length() > 0)
	{
		segComponents = getSegmentComponents(segment);
		if(segComponents!=null && segComponents.size() == 0)
			isNoCompInSegment = true;
	}

	if(isNoCompInSegment)
	{
		// There is no components in the given segment..
	}
	else
	{
		if(segment!=null && action!=null && action.equals("save"))
		{
			isSave = true;
			if(isZone)
			{
				for(int k=0;k<segComponents.size();k++)
				{
					String thisComp = (String) segComponents.get(k);
					if(thisZoneComponents.contains(thisComp))
						continue;
					addTothisZone.add(thisComp);
				}
			}
		}
		if(segment!=null && action!=null && action.equals("saveAs"))
		{
			saveAs = true;
			if(isZone)
			{
				for(int k=0;k<segComponents.size();k++)
				{
					String thisComp = (String) segComponents.get(k);
					if(thisZoneComponents.contains(thisComp))
						continue;
					addTothisZone.add(thisComp);
				}
			}
			if(!user.checkSegmentCount())
			{
				segLimitExceed = true;
			}
		}

		if(segment!=null)
		{
			Hashtable myTable = getUnmanageAndNewComponents(segment);
			newCompList = (ArrayList) myTable.get("NEW");
			if(newCompList!=null && newCompList.size() > 0)
				isNewCompExists = true;

			unManageList = (ArrayList) myTable.get("UNMANAGE");
			if(unManageList!=null && unManageList.size() > 0)
				isUnManageExists = true;

			incompleteList = getSingleLeadingComponents(segment);
			if(incompleteList!=null && incompleteList.size() > 0)
				isComplete = true;
		}

		if(addTothisZone!=null && addTothisZone.size() > 0)
			addToZone = true;
		
		// To Check if the component is already added to group
		String subArr[];
		ArrayList groupList = new ArrayList();
		IniFile topoIni1 = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
		subArr = topoIni1.getVariables("GROUP_DETAILS");
		if(subArr == null)
			return;
		for(int i=0; i<subArr.length; i++)
		{
			if(segComponents.contains(subArr[i]))
			{
				compGroupList.add(subArr[i]);
				String value = topoIni1.getValue("GROUP_DETAILS",subArr[i]);
				if(compHash.containsKey(value))
				{
					ArrayList list = (ArrayList) compHash.get(value);
					list.add(subArr[i]);
					compHash.put(value,(ArrayList)list);
				}
				else
				{
					ArrayList list = new ArrayList();
					list.add(subArr[i]);
					compHash.put(value,(ArrayList)list);
				}
			}
		}
		if(compHash!=null && compHash.size()>0)
			addToGroup = true;
	}
%>
<html>
<head>
<title>Manage all components</title>
<egui:skin ui="admin"/>
<script language="JavaScript" src="/final/admin/eg_scripts/ajaxutils.js"></script>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script  src="/final/jquery/jquery.js"></script>
<script  src="/final/jquery/ui/jquery.ui.core.js"></script>
<script type="text/javascript">

var $j = jQuery.noConflict();

$j(document).ready(function(){
	changeDivSize();
});

function closeManageAllDiv(){
	hideDivAndRefresh('manageAllDiv');
}

jQuery.fn.center = function (){
	this.css("position","absolute");
	this.css("top", (($j(window).height() - this.outerHeight()) / 2) + $j(window).scrollTop() + "px");
	this.css("left", (($j(window).width() - this.outerWidth()) / 2) + $j(window).scrollLeft() + "px");
	return this;
}

function changeDivSize()
{
	var saveAsTableHt = $j("#saveAsTable").height();
	var saveAsTableWdth = $j("#saveAsTable").width();
	var tableHeight = $j("#manageTable").height();
	var tableWidth = $j("#manageTable").width();
	var closeButton = $j(".closeButton").attr('name');

	if(saveAsTableHt != null || saveAsTableHt != null )
	{
		$j("#manageAllDiv").height(180);
		$j("#manageAllDiv").width(470);
		$j("#innerManageAllDiv").height(130);
		$j("#innerManageAllDiv").width(450);
	}
	else
	{
		if(closeButton == 'closeButton')
		{
			$j("#manageAllDiv").height(185);
			$j("#manageAllDiv").width(458);
			$j("#innerManageAllDiv").height(145);
			$j("#innerManageAllDiv").width(440);
		}
		else
		{
			if(tableHeight == null || tableWidth == null ){
				$j("#manageAllDiv").height(140);
				$j("#manageAllDiv").width(458);
				$j("#innerManageAllDiv").height(100);
				$j("#innerManageAllDiv").width(440);
			}
			else
			{
				$j("#manageAllDiv").height(260);
				$j("#manageAllDiv").width(670);
				$j("#innerManageAllDiv").height(210);
				$j("#innerManageAllDiv").width(650);
			}
		}
	}
	if('<%=saveFrom%>' != 'previewPage')
		$j("#manageAllDiv").center();
	//centerScreen('#manageAllDiv');
}

function centerScreen(selector) {
    var newTop =   $j(window).height() - $j(selector).height() / 2;
    var newLeft = ($j(window).width()  - $j(selector).width()) / 2;
    $j(selector).css({
        'position': 'absolute',
        'left': newLeft,
        'top': newTop
    });
}

function selectAllChkBoxes()
{
	var manageForm = document.manageForm;
	var chkall = manageForm.chkall;
	var length = manageForm.chkbox.length;
	if(chkall!=null)
	{
		if(chkall.checked)
		{
			if(length==null){
				manageForm.chkbox.checked = true;
			}
			else{
				for(var k=0;k<length;k++){
					manageForm.chkbox[k].checked = true;
				}
			}
		}
		else
		{
			if(length==null){
				manageForm.chkbox.checked = false;
			}
			else{
				for(var k=0;k<length;k++){
					manageForm.chkbox[k].checked = false;
				}
			}
		}
	}
}

function manageComponents()
{
	var chkall =  $j('form #chkall').is(':checked');
	var segment = $j("#segment").attr("value");
	var urlToDisplay = "EgAutoManageComponents.jsp?segment="+encodeURI(segment);
	var saveFrom = '<%=saveFrom%>';

	if(chkall)
	{
		showLoadingDiv();
		$j('#manageButton').attr("disabled", true);
		$j.ajax({
			type: "POST",
			url: urlToDisplay,
			data: "chkall=true"+"&saveFrom="+saveFrom,
			success: function(msg) { 
				$j("#innerManageAllDiv").html(msg); 
				hideDivs('loading_image');
			}
		});
	}
	else
	{
		var test = $j("input[name='chkbox']:checked")
					.map(function() { return $j(this).val() })
					.get()
					.join(",");

		if(test.length == 0) { 
			alert('<egui:intnl text="admin.server.Please select a component to manage"/>');
			return;
		}

		showLoadingDiv();
		$j('#manageButton').attr("disabled", true);
		$j.ajax({
			type: "POST",
			url: urlToDisplay,
			data: "test=" + test+"&saveFrom="+saveFrom,
			success: function(msg) { 
				$j("#innerManageAllDiv").html(msg); 
				hideDivs('loading_image');
			}
		});
	}
}

function showAlertDiv()
{
	var maxInd = maxIndex();
	$j("#alertDiv").css({"display":"block" , "position":"absolute" });
	$j("#alertDiv").css({"z-index":maxInd+1});
	$j("#alertDiv").show('slow');
	centerScreen('#alertDiv');
}

function hideAlertDiv()
{
	$j("#alertDiv").hide('slow');
	closeManageAllDiv();
}

function centerScreen(selector) 
{
	var newTop =   $j("#innerManageAllDiv").height() - $j(selector).height() / 2;
	var newLeft =  ($j("#innerManageAllDiv").width()  - $j(selector).width()) / 2;
	$j(selector).css({
		'position': 'absolute',
		'left': newLeft,
		'top': newTop / 2 
	});
}

function showLoadingDiv()
{
	$j("#loading_image").css({"display":"block" , "position":"absolute" });
	var maxInd = maxIndex();
	$j("#loading_image").css({"z-index":maxInd+1});
	$j("#loading_image").show('slow');
	//var dataDivWidth = $j(".dataDiv").innerWidth();
	//var mainDivWidth = $j(window).width();
	//var left_pos = parseInt(mainDivWidth) - parseInt(dataDivWidth) + parseInt(dataDivWidth) / 2;
	//$j("#loading_image").css('left',left_pos);
	centerScreen("#loading_image");
}

function saveTopology()
{
	var segment='';
	var newName='';
	var zone = $j("#zone").attr("value");
	var action = "save";
	var enableDrag = $j("#enableDrag").attr("value");
	var proceed = false;
	if('<%=saveAs%>'=='true')
	{
		var retValue = renameTopology();
		if(retValue)
		{
			var oldName = $j("#segment").attr("value");//document.getElementById("oldName").value;
			segment = oldName;
			newName = document.getElementById("newName").value;
			proceed = true;
		}
		else
			return;
	}
	else
	{
		segment = $j("#segment").attr("value");
		newName="";
		proceed = true;
	}

	if(proceed){
	$j('#saveButton').attr("disabled", true);
	//var segment = $j("#segment").attr("value");
	
	var url = '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURI(segment)+"&action="+encodeURI(action)+"&zone="+encodeURI(zone)+"&newNameToSave="+encodeURI(newName);

	var httpObj = createRequestObject();
	var params = "";
	var tempurl = "";
	if (url.indexOf("?") > -1){
		params=url.substring(url.indexOf("?")+1);
		tempurl=url.substring(0,url.indexOf("?"));
	}
	else{
		tempurl=url;
	}
	httpObj.open('POST',tempurl,true);
	httpObj.setRequestHeader('Content-type','application/x-www-form-urlencoded');
	httpObj.setRequestHeader('Content-length',params.length);
	httpObj.setRequestHeader('Connection','close');
	httpObj.onreadystatechange = function() {
		if (httpObj.readyState == 4 && httpObj.status == 200)
		{
			document.getElementById('successResultDiv').innerHTML=httpObj.responseText;
			showAlertDiv();
		}
	}
	httpObj.send(params);
	}
}

function checkTop(obj)
{
	var manageForm = document.manageForm;
	var chkall = manageForm.chkall;
	if(obj.checked)
	{
		var flag = 0;
		for(var k=0;k<manageForm.chkbox.length;k++)
		{
			if(manageForm.chkbox[k].checked){
			
			}
			else{
				flag = 1;
				break;
			}
		}
		if(flag == 0){
			chkall.checked = true;
		}
		else{
			chkall.checked = false;
		}
	}
	else{
		chkall.checked = false;
	}
}

function renameTopology()
{
	var thisForm = document.manageForm;
	var segment = thisForm.newName.value;	
	var zone = $j("#zone").attr("value");
	var seg_Name=true;
	if('<%=isDouble%>'=="false")
	{
		seg_Name = validateSingleByte(thisForm.newName.value);
	}
	<%
		if ((groups != null) && (groups.length>0))
		{
	%>
			zone = thisForm.zone.value;
	<%
		}
	%>
	if('<%=segLimitExceed%>'=="true")
	{
		alert("<egui:intnl text='admin.common.Exceeded the number of segments allowed by your license' />");
		return false;
	}
	if(!checkblank(thisForm.newName))
	{
		alert("<egui:intnl text='admin.segment.Field value cannot be blank'/>");
		thisForm.newName.focus();
		return false;
		
	}
	else if(!checkspace(thisForm.newName))
	{
		thisForm.newName.focus();
		return false;
		
	}
	else if(!checkspecial(thisForm.newName,"	`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/"))
	{
		thisForm.newName.focus();
		return false;
	}
	else if(thisForm.newName.value == "independent_servers")
	{
		alert("<egui:intnl text='admin.segment.Cannot add segment by name'/> "+ segment + ".");
		thisForm.newName.focus();
		return false;
		
	}
	else if(!seg_Name)
	{
		alert('<egui:intnl text="admin.segment.Segment name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
		thisForm.newName.focus();
		return false;
	}
	else
	{
		return true;
	}
}
</script>
</head>
<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" >
<!-- Loading Div -->
<div id ="loading_image" style = "position:absolute;top:100px;left:150px;visibility:visible;display:none;border:0px solid #ff0000;"> 
	<table height="100%">
		<tr>
			<td height="100%" valign="middle"> 
				<img src='/final/admin/eg_images/indicator_medium.gif'>
			</td>
		</tr>
	</table>
</div>

<!-- Alert Div -->
<div id="alertDiv" name="alertDiv" style="display:none;left:50px;top:50px;width:300px;height:80px;border:0px solid #ff0000; position:absolute;">
	<table  border="0" cellspacing="0" cellpadding="0" width="100%">
		<tr>
			<td class="pop2_lefttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_top_bg" width="100%"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_righttop_curve" ><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
		<tr>
			<td class="pop2_left_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="50px"></td>
			<td class="eg_whitebg" align="center">
				<div style="height:60px;border:1px solid black;">
					<table border="0" cellspacing="0" cellpadding="4" align="center" width="100%">
						<tr align="center">
							<td>
							<div id="successResultDiv"></div>
							</td>
						</tr>
						<tr align="center">
							<td><input type="button" class="eg_lightbutton" name="okButton" id="okButton" value=" OK " onclick="javascript:hideAlertDiv();"style="padding-left:4px;padding-right:4px"></td>
						</tr>
					</table>
				</div>
			</td>
			<td class="pop2_right_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="50px"></td>
		</tr>
		<tr>
			<td class="pop2_leftbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_bottom_bg"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_rightbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
	</table>
</div>
<form name="manageForm" id="manageForm" style="margin:0px">
<input type="hidden" name="segment" id="segment" value="<%=segment%>">
<input type="hidden" name="zone" id="zone" value="<%=zone%>">
<input type="hidden" name="enableDrag" id="enableDrag" value="<%=dragFn%>">
<table border="0" cellspacing="0" cellpadding="4" align="center" width="100%" height="100%" valign="top">
<%
	if(isNoCompInSegment)
	{
%>
		<tr>
			<td  nowrap align="center" id="eg_subcontentbg" class="form_spacing">
				<table border="0" cellspacing="0" cellpadding="0" bordercolor="red">
					<tr>
						<td  align="center" valign="top"><img src="/final/admin/eg_images/exclamation-icon.gif"> <br/> <b><egui:intnl text="No component is available in the given segment !"/></b></td>
					</tr>
				</table>
			</td>
		</tr>
<%
	}
	else
	{
		if(isNewCompExists || isUnManageExists)
		{
			String saveString = " Manage the following new (or) unmanaged components !";
			if(isSave || saveAs){
				saveString = "To save this topology, manage the following new (or) unmanaged components !";
			}
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="top">
			<table id="manageTable" name="manageTable" align="center" width="95%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td valign="top" width="100%" align="center" >&nbsp;</td>
				</tr>
				<tr>
					<td >
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" style="table-layout:collapse"><col width="7"><col width="175"><col width="40"><col width="100%"><col width="7">
							<tr>
								<td height="6" id="inner_top_left" width="7" ><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" id="inner_top_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<tr>
								<td colspan="5" height="50" nowrap align="center" id="eg_subcontentbg" class="form_spacing">
									<table border="0" cellspacing="0" cellpadding="5" bordercolor="red">
										<tr>
											<td style="width:100px" align="left" valign="top"><img src="/final/admin/eg_images/<%=admin_Skin%>/icon_okay.gif"></td>
											<td width="100%"><b><egui:intnl text="<%=saveString%>"/></b></td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td height="6" class="inner_bott_left" width="7" > <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" class="inner_bott_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td valign="top" width="100%" align="center" >&nbsp;</td>
				</tr>
				<tr>
					<td valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed;" >
							<col width="7"><col width="30"><col width="100%"><col width="90"><col width="250"><col width="7">
							<tr>
								<td id="subhead_left" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								<td id="eg_subheadbg" height="22" align="center"><input type="checkbox" class="eg_input" id="chkall" name="chkall" value="selectall" onclick="javascript:selectAllChkBoxes();"></td>
								<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Host / Nick Name"/></strong></td>
								<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Port"/></strong></td>
								<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Component Type"/></strong></td>
								<td id="subhead_right" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
							</tr>
<%
			for(int k=0;k<newCompList.size();k++)
			{
				String element = (String) newCompList.get(k);
				StringTokenizer st = new StringTokenizer(element,":");
				int count = st.countTokens();
				String compType = "";
				String hostName = "";
				String portNo = "";
				String sid = "-";
				boolean isOraServer = false;
				if(count == 3)
				{
					compType = st.nextToken();
					hostName = st.nextToken();
					portNo = st.nextToken();
				}
				else if(count == 4)	// Only for Oracle_Database Component
				{
					compType = st.nextToken();
					hostName = st.nextToken();
					portNo = st.nextToken();
					sid = st.nextToken();
					isOraServer = true;
				}
				if(portNo.equals("NULL"))
						portNo ="-";
%>
							<tr>
								<td width="7" id="cell_border4"  style="border-left-width:1px;border-right-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								<td id="cell_border4" align="center" class="head_padding3" style="border-left-width:0px"><input type="checkbox" class="eg_input" name="chkbox" id="chkbox" class="case"
								value="<%=element%>" onclick="javascript:checkTop(this)";></td>
								<td id="cell_border3" align="left" class="left_space10"><b><%=hostName%>&nbsp;<%=isOraServer?"("+sid+")":""%></b></td>
								<td id="cell_border4" align="left"class="left_space10"><%=portNo%></td>
								<td style="border-right-width:0px" id="cell_border3" align="left" class="left_space10"><egui:intnl type="<%=compType%>"/></td>
								<td width="7" id="cell_border3"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
							</tr>
<%
		}
		//UnManage componenet List ....
		for(int k=0;k<unManageList.size();k++)
		{
			String element = (String) unManageList.get(k);
			StringTokenizer st = new StringTokenizer(element,":");
			int count = st.countTokens();
			String compType = "";
			String hostName = "";
			String portNo = "";
			String sid = "-";
			boolean isOraServer = false;
			if(count == 3)
			{
				compType = st.nextToken();
				hostName = st.nextToken();
				portNo = st.nextToken();
			}
			else if(count == 4)	// Only for Oracle_Database Component
			{
				compType = st.nextToken();
				hostName = st.nextToken();
				portNo = st.nextToken();
				sid = st.nextToken();
				isOraServer = true;
			}
			if(portNo.equals("NULL"))
					portNo ="-";
%>
							<tr>
								<td width="7" id="cell_border4"  style="border-left-width:1px;border-right-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								<td id="cell_border4" align="center" class="head_padding3" style="border-left-width:0px"><input type="checkbox" class="eg_input" name="chkbox" id="chkbox" value="<%=element%>" onclick="javascript:checkTop(this)";></td>
								<td id="cell_border3" align="left" class="left_space10"><b><%=hostName%>&nbsp;<%=isOraServer?"("+sid+")":""%></b></td>
								<td id="cell_border4" align="left"class="left_space10"><%=portNo%></td>
								<td style="border-right-width:0px" id="cell_border3" align="left" class="left_space10"><egui:intnl type="<%=compType%>"/></td>
								<td width="7" id="cell_border3"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
							</tr>
<%
		}
%>

						</table>
					</td>
				</tr>
				<tr>
					<td valign="top" width="100%" align="center" >&nbsp;</td>
				</tr>
				<tr>
					<td valign="top" width="100%" align="center" ><input type="button" class="eg_back" name="manageButton" id="manageButton" value='<egui:intnl text="admin.servers.Add / Manage"/>' onClick="javascript:manageComponents();" style="width:110px;"></td>
				</tr>
			</table>
		</td>
	</tr>
<%
		}
		else if(isComplete)
		{
			String inCompleteString = " No link(s) from the following leading components !";
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="top">
			<table id="manageTable" name="manageTable" align="center" width="90%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td valign="top" width="100%" align="center" >&nbsp;</td>
				</tr>
				<tr>
					<td >
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" style="table-layout:collapse"><col width="7"><col width="175"><col width="40"><col width="100%"><col width="7">
							<tr>
								<td height="6" id="inner_top_left" width="7" ><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" id="inner_top_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<tr>
								<td colspan="5" height="50" nowrap align="center" id="eg_subcontentbg" class="form_spacing">
									<table border="0" cellspacing="0" cellpadding="5" bordercolor="red">
										<tr>
											<td style="width:100px" align="left" valign="top"><img src="/final/admin/eg_images/<%=admin_Skin%>/icon_okay.gif"></td>
											<td width="100%"><b><egui:intnl text="<%=inCompleteString%>"/></b></td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td height="6" class="inner_bott_left" width="7" > <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" class="inner_bott_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td valign="top" width="100%" align="center" >&nbsp;</td>
				</tr>
				<tr>
					<td valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed;" >
							<col width="7"><col width="100%"><col width="150"><col width="250"><col width="7">
							<tr>
								<td id="subhead_left" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								<td id="eg_subheadbg" height="22" align="center" style="border-left-width:0px"><strong><egui:intnl text="admin.servers.Host / Nick Name"/></strong></td>
								<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Port"/></strong></td>
								<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Component Type"/></strong></td>
								<td id="subhead_right" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
							</tr>
<%
				for(int k=0;k<incompleteList.size();k++)
				{
					String element = (String) incompleteList.get(k);
					StringTokenizer st = new StringTokenizer(element,":");
					int count = st.countTokens();
					String compType = "";
					String hostName = "";
					String portNo = "";
					String sid = "-";
					boolean isOraServer = false;
					if(count == 3)
					{
						compType = st.nextToken();
						hostName = st.nextToken();
						portNo = st.nextToken();
					}
					else if(count == 4)	// Only for Oracle_Database Component
					{
						compType = st.nextToken();
						hostName = st.nextToken();
						portNo = st.nextToken();
						sid = st.nextToken();
						isOraServer = true;
					}
					if(portNo.equals("NULL"))
							portNo ="-";
%>
							<tr>
								<td width="7" id="cell_border4"  style="border-left-width:1px;border-right-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								<td id="cell_border4" align="left" class="left_space10 head_padding3" style="border-left-width:0px"><b><%=hostName%>&nbsp;<%=isOraServer?"("+sid+")":""%></b></td>
								<td id="cell_border3" align="left"class="left_space10"><%=portNo%></td>
								<td style="border-right-width:0px" id="cell_border4" align="left" class="left_space10"> <egui:intnl type= "<%=compType%>"/></td>
								<td width="7" id="cell_border4"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
							</tr>
<%
				}
%>
						</table>
					</td>
				</tr>
				<tr>
					<td valign="top" width="100%" align="center" >&nbsp;</td>
				</tr>
				<tr>
					<td valign="top" width="100%" align="center" ><input type="button" id="eg_back" name="exitButton" value='<egui:intnl text="admin.servers.Exit"/>' style="width:110px;" onclick="javascript:closeManageAllDiv();"></td>
				</tr>
			</table>
		</td>
	</tr>
<%
		}
		else
		{
			String msgString ="";
			if(isSave)
			{
				msgString = "admin.servertypes.Do you want to save this segment?";
			}
			else
			{
				msgString = "admin.servertypes.All the components are already managed in this segment !";
			}
%>
<%
			if(!saveAs)
			{
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table id="manageTable" name="manageTable" align="center" width="95%" cellspacing="0" cellpadding="0" border="0">
				<!-- <tr>
					<td>
						<table align="center" width="100%" cellspacing="0" cellpadding="4" border="0" class="tableborder_ad2"><col width="50%"><col width="50%">
							<tr>
								<td align="left" class="tdborder_ad2"><egui:intnl text="admin.servers.Segment Name"/> : <b><%=segment%></b></td>
								<td align="left" class="tdborder_ad2"> <egui:intnl text="admin.servers.Zone"/> : <b><%=zone.equals("-1")?"Default":zone%></b></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td valign="top" width="100%" align="center" >&nbsp;</td>
				</tr>-->
				<tr>
					<td>
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" style="table-layout:collapse"><col width="7"><col width="175"><col width="40"><col width="100%"><col width="7">
							<tr>
								<td height="6" id="inner_top_left" width="7" ><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" id="inner_top_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<tr>
								<td colspan="5"  nowrap align="center" id="eg_subcontentbg" class="form_spacing">
									<table border="0" cellspacing="0" cellpadding="5" bordercolor="red">
										<tr>
											<td  align="center" valign="top"><img src="/final/admin/eg_images/exclamation-icon.gif"> <br/> <b><egui:intnl text="<%=msgString%>"/></b></td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td height="6" class="inner_bott_left" width="7" > <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" class="inner_bott_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
<%
				if(isSave)
				{
%>
							<tr>
								<td colspan="5" valign="top" width="100%" align="center" >&nbsp;</td>
							</tr>
							<tr>
								<td colspan="5" align="center" valign="middle">
									<table cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td>
												<input type="button" class="eg_back" id="saveButton"  name="saveButton" value='<egui:intnl text="admin.servers.Save"/>' style="width:75px;" onclick="javascript:saveTopology();">  </td>
											<td> <img src="/final/admin/eg_images/spacer.gif" border="0" width="20"> </td>
											<td> 
												<input type="button" id="eg_back" name="saveButton" value='<egui:intnl text="admin.servers.Cancel"/>' style="width:75px;" onclick="javascript:closeManageAllDiv();"> </td>
										</tr>
									</table>
								</td>
							</tr>
<%
				}
				else
				{
%>
							<tr>
								<td colspan="5" valign="top" width="100%" align="center" >&nbsp;</td>
							</tr>
							<tr>
								<td colspan="5" align="center" valign="middle"><input type="button" id="eg_back" class="closeButton" name="closeButton" value='<egui:intnl text="admin.servers.Close"/>' style="width:75px;" onclick="javascript:closeManageAllDiv();"> </td>
							</tr>
<%
				}
%>
						</table>
					</td>
				</tr>
				<tr>
					<td valign="top" width="100%" align="center" >&nbsp;</td>
				</tr>
<%
				if(isSave)
				{
					if(addToGroup)
					{
						Enumeration keys = compHash.keys();
						while(keys.hasMoreElements())
						{
							String group = (String)keys.nextElement();
							ArrayList componentList = (ArrayList)compHash.get(group);
%>					
					<tr>
						<td valign="top">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed;" >
								<col width="7"><col width="100%"><col width="150"><col width="250"><col width="7">
								<tr>
									<td  valign="top" colspan="5" width="100%" height="20" align="left"  class="eg_lightlight" style="border-bottom-width:1px">  
										<table align="center" cellspacing="0" cellpadding="4" border="0" >
											<tr>
												<td height="24" nowrap align="right"><img src="/final/admin/eg_images/info2.gif"> </td>
												<td height="24" nowrap><egui:intnl text="admin.servers.The following components are recently added in to the group "/>&nbsp;-<b>&nbsp;<%=group%><b></td>
											</tr>
										</table>
									</td>
								</tr>
								<tr>
									<td valign="top" width="100%" align="center" >&nbsp;</td>
								</tr>
								<tr>
									<td id="subhead_left" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
									<td id="eg_subheadbg" height="22" align="center" style="border-left-width:0px"><strong><egui:intnl text="admin.servers.Host / Nick Name"/></strong></td>
									<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Port"/></strong></td>
									<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Component Type"/></strong></td>
									<td id="subhead_right" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								</tr>
<%
							for(int k=0;k<componentList.size();k++)
							{
								String element = (String) componentList.get(k);
								StringTokenizer st = new StringTokenizer(element,":");
								int count = st.countTokens();
								String compType = "";
								String hostName = "";
								String portNo = "";
								String sid = "-";
								boolean isOraServer = false;
								if(count == 3)
								{
									compType = st.nextToken();
									hostName = st.nextToken();
									portNo = st.nextToken();
								}
								else if(count == 4)	// Only for Oracle_Database Component
								{
									compType = st.nextToken();
									hostName = st.nextToken();
									portNo = st.nextToken();
									sid = st.nextToken();
									isOraServer = true;
								}
								if(portNo.equals("NULL"))
										portNo ="-";
%>
								<tr>
									<td width="7" id="cell_border4"  style="border-left-width:1px;border-right-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
									<td id="cell_border4" align="left" class="left_space10 head_padding3" style="border-left-width:0px"><b><%=hostName%>&nbsp;<%=isOraServer?"("+sid+")":""%></b></td>
									<td id="cell_border3" align="left"class="left_space10"><%=portNo%></td>
									<td style="border-right-width:0px" id="cell_border4" align="left" class="left_space10"> <egui:intnl type= "<%=compType%>"/></td>
									<td width="7" id="cell_border4"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								</tr>
<%
							}
%>
							</table>
						</td>
					</tr>
					<tr>
						<td valign="top" width="100%" align="center" >&nbsp;</td>
					</tr>
<%						}
					}
					if(addToZone)
					{
%>
				<tr>
					<td valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed;" >
							<col width="7"><col width="100%"><col width="150"><col width="250"><col width="7">
							<tr>
								<td  valign="top" colspan="5" width="100%" height="20" align="left"  class="eg_lightlight" style="border-bottom-width:1px">  
									<table align="center" cellspacing="0" cellpadding="4" border="0" >
										<tr>
											<td height="24" nowrap align="right"><img src="/final/admin/eg_images/info2.gif"> </td>
											<td height="24" nowrap><egui:intnl text="admin.servers.The following components are added in to the zone "/>&nbsp;-<b>&nbsp;<%=zone.equals("-1")?"Default":zone%><b></td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td valign="top" width="100%" align="center" >&nbsp;</td>
							</tr>
							<tr>
								<td id="subhead_left" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								<td id="eg_subheadbg" height="22" align="center" style="border-left-width:0px"><strong><egui:intnl text="admin.servers.Host / Nick Name"/></strong></td>
								<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Port"/></strong></td>
								<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Component Type"/></strong></td>
								<td id="subhead_right" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
							</tr>
<%
						for(int k=0;k<addTothisZone.size();k++)
						{
							String element = (String) addTothisZone.get(k);
							StringTokenizer st = new StringTokenizer(element,":");
							int count = st.countTokens();
							String compType = "";
							String hostName = "";
							String portNo = "";
							String sid = "-";
							boolean isOraServer = false;
							if(count == 3)
							{
								compType = st.nextToken();
								hostName = st.nextToken();
								portNo = st.nextToken();
							}
							else if(count == 4)	// Only for Oracle_Database Component
							{
								compType = st.nextToken();
								hostName = st.nextToken();
								portNo = st.nextToken();
								sid = st.nextToken();
								isOraServer = true;
							}
							if(portNo.equals("NULL"))
									portNo ="-";
							if(!compGroupList.contains(element))
							{
%>
							<tr>
								<td width="7" id="cell_border4"  style="border-left-width:1px;border-right-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								<td id="cell_border4" align="left" class="left_space10 head_padding3" style="border-left-width:0px"><b><%=hostName%>&nbsp;<%=isOraServer?"("+sid+")":""%></b></td>
								<td id="cell_border3" align="left"class="left_space10"><%=portNo%></td>
								<td style="border-right-width:0px" id="cell_border4" align="left" class="left_space10"> <egui:intnl type= "<%=compType%>"/></td>
								<td width="7" id="cell_border4"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
							</tr>
<%							}
						}
%>
						</table>
					</td>
				</tr>
				<tr>
					<td valign="top" width="100%" align="center" >&nbsp;</td>
				</tr>
<%
					}
%>
				<tr>
					<td  valign="top" width="100%" height="20" align="left"  class="eg_lightlight" style="border-bottom-width:1px">  
						<table align="center" cellspacing="0" cellpadding="4" border="0" >
							<tr>
								<td height="24" nowrap align="right"><img src="/final/admin/eg_images/info2.gif"> </td>
								<td height="24" nowrap><egui:intnl text="admin.servers.The following components are included in the segment "/>&nbsp;-<b>&nbsp;<%=segment%><b></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td valign="top" width="100%" align="center" >&nbsp;</td>
				</tr>
				<tr>
					<td valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed;" >
							<col width="7"><col width="100%"><col width="90"><col width="250"><col width="7">
							<tr>
								<td id="subhead_left" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								<td id="eg_subheadbg" height="22" align="center" style="border-left-width:0px"><strong><egui:intnl text="admin.servers.Host / Nick Name"/></strong></td>
								<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Port"/></strong></td>
								<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Component Type"/></strong></td>
								<td id="subhead_right" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
							</tr>
<%
					for(int k=0;k<segComponents.size();k++)
					{
						String element = (String) segComponents.get(k);
						StringTokenizer st = new StringTokenizer(element,":");
						int count = st.countTokens();
						String compType = "";
						String hostName = "";
						String portNo = "";
						String sid = "-";
						boolean isOraServer = false;
						if(count == 3)
						{
							compType = st.nextToken();
							hostName = st.nextToken();
							portNo = st.nextToken();
						}
						else if(count == 4)	// Only for Oracle_Database Component
						{
							compType = st.nextToken();
							hostName = st.nextToken();
							portNo = st.nextToken();
							sid = st.nextToken();
							isOraServer = true;
						}
						if(portNo.equals("NULL"))
								portNo ="-";
						if(!compGroupList.contains(element))
						{
%>
							<tr>
								<td width="7" id="cell_border4"  style="border-left-width:1px;border-right-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								<td id="cell_border4" align="left" class="left_space10 head_padding3" style="border-left-width:0px"><b><%=hostName%>&nbsp;<%=isOraServer?"("+sid+")":""%></b></td>
								<td id="cell_border3" align="left"class="left_space10"><%=portNo%></td>
								<td style="border-right-width:0px" id="cell_border4" align="left" class="left_space10"> <egui:intnl type= "<%=compType%>"/></td>
								<td width="7" id="cell_border4"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
							</tr>
<%						}
					}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
				}
			}
			else if(saveAs)
			{
%>			
			<tr>
				<td valign="top" width="100%" align="center" ></td>
			</tr>
			<tr>
				<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
					<table id="saveAsTable" name="saveAsTable" align="center" width="95%" cellspacing="0" cellpadding="0" border="0">
					<tr>
					<td>
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" style="table-layout:collapse"><col width="7"><col width="175"><col width="40"><col width="100%"><col width="7">
							<tr>
								<td height="6" id="inner_top_left" width="7" ><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" id="inner_top_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<tr>
								<td colspan="5" align="center" valign="middle" id="eg_subcontentbg" class="form_spacing">
									<table cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td class="eg_darktextbold" nowrap ><egui:intnl text="admin.common.Segment Name"/>&nbsp;</td>
											<td width="5" class="eg_subcontent">:&nbsp;</td>
											<td><input type="text" id="newName"  name="newName" value="<%//=segment%>" style="width:220px" maxlength="32">  </td>
										</tr>
										<tr>
											<td colspan="5" valign="top" width="100%" align="center" >&nbsp;</td>
										</tr>
										<!--<tr>
											<td class="eg_darktextbold"><egui:intnl text="admin.common.New Name"/>&nbsp;</td>
											<td width="5" class="eg_subcontent">:&nbsp;</td>
											<td><input type="text" id="newName"  name="newName" value="" maxlength="32" style="width:220px">  </td>
										</tr>-->
									</table>
								</td>
							</tr>
							<tr>
								<td height="6" class="inner_bott_left" width="7" > <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" class="inner_bott_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<tr>
								<td colspan="5" valign="top" width="100%" align="center" >&nbsp;</td>
							</tr>
							<tr>
								<td colspan="5" align="center" valign="middle">
									<table cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td>
												<input type="button" class="eg_back" id="saveButton"  name="saveButton" value='<egui:intnl text="admin.servers.Save"/>' style="width:75px;" onclick="javascript:saveTopology();">  </td>
											<td> <img src="/final/admin/eg_images/spacer.gif" border="0" width="20"> </td>
											<td> 
												<input type="button" id="eg_back" name="saveButton" value='<egui:intnl text="admin.servers.Cancel"/>' style="width:75px;" onclick="javascript:closeManageAllDiv();"> </td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
					</tr>
					</table>
				</td>
			</tr>
<%
			}
		}
	}
%>
</table>
</form>
</body>
</html>

<%
}
catch(Exception e)
{
	System.out.println("Exception in EgAutoManagePage.jsp");
	e.printStackTrace();
}
%>

<%!
	/*
		This method returns, list of New & Unmanaged components form the given segment name
	*/
	private Hashtable getUnmanageAndNewComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		String unmanagestr = "#Unmanage|";
		
		Hashtable result = new Hashtable();
		ArrayList newList = new ArrayList();
		ArrayList unmanageList = new ArrayList();
		Set newSet = new TreeSet();
		Set unmanageSet = new TreeSet();

		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String newValue = disIniFile.getValue(thisCompName,newstr+varName);
			if(newValue!=null && newValue.length() > 0)	// Check for new component
			{
				newSet.add(varName);
			}
			else	// Check for unmanage component
			{
				String unmanageValue = disIniFile.getValue(thisCompName,unmanagestr+varName);
				if(unmanageValue!=null && unmanageValue.length() > 0)
				{
					unmanageSet.add(varName);
				}
			}

			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String newval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				if(newval!=null && newval.length() > 0)
				{
					newSet.add(tmpvar);
				}
				else
				{
					String unmanageValue = disIniFile.getValue(tmpcompname,unmanagestr+tmpvar);
					if(unmanageValue!=null && unmanageValue.length() > 0)
					{
						unmanageSet.add(tmpvar);
					}
				}
			}
		}

		if(newSet!=null && newSet.size() > 0)
			newList = new ArrayList(newSet);
		if(unmanageSet!=null && unmanageSet.size() > 0)
			unmanageList = new ArrayList(unmanageSet);
		result.put("NEW" , newList);
		result.put("UNMANAGE" , unmanageList);
		return result;
	}

	private ArrayList getSegmentComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		ArrayList result = new ArrayList();
		Set thisSet = new TreeSet();
		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompType = varName.substring(0,varName.indexOf(":"));
			thisSet.add(varName);
			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcomptype = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				thisSet.add(tmpvar);
			}
		}
		if(thisSet!=null && thisSet.size() > 0){
			result = new ArrayList(thisSet);
		}
		return result;
	}

	public ArrayList getSingleLeadingComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		ArrayList result = new ArrayList();
		String[] varArray = iniFile.getVariables(segmentName);
		ArrayList valueList =new ArrayList();
		for(int v=0;v<varArray.length;v++)
		{
			String variable = (String)varArray[v];
			String value = iniFile.getValue(segmentName,variable);
			if(value!=null && !value.equals("") && !value.equals("null"))
			{
				StringTokenizer stz = new StringTokenizer(value,",");
				while(stz.hasMoreTokens())
				{
					String tkn = (String)stz.nextToken();
					String finalTkn = tkn.substring(0,tkn.lastIndexOf(":"));
					if(!valueList.contains(finalTkn))
						valueList.add(finalTkn);
				}
			}
		}
		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
			{
				if(!valueList.contains(varName))
					result.add(varName);
			}
		}
		return result;
	}
%>