<%
/*****************************************************************************
 *	File name			:	EgAgentDiscover.jsp
 *  Purpose				:	To update the agent discovery settings
 *	Version				:	4.2.1
 *	Creation Date		:	18/2/2009
 *  Last Modified Date	:	24/2/2009 
 *	Author				:	Nehru.C
 *****************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>

<jsp:useBean id="port" scope="page" class="egurkha.ServiceBean"/>
<jsp:useBean id="configTopo" scope="page" class="egurkha.ConfigTopology"/>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	String uiFile = "eg_tests.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
	IniFile testIniFile = new IniFile(s_iniFile_dir + uiFile);
	EgMappingInfo egMappingInfo=new EgMappingInfo(trackerLanguage);
	String tableWidth = request.getParameter("tableWidth");

	ArrayList server_list = new ArrayList();
	ArrayList srvTypeList = new ArrayList();
	ArrayList portList = new ArrayList();
	ArrayList serverList = new ArrayList();
	ArrayList compList = new ArrayList();
	String discBase = "";
	String from = request.getParameter("from");
	String validate = request.getParameter("validate");
	if (from == null || from.equals("null")) from = "";
	if (validate == null || validate.equals("null")) validate = "";
	String userLanguage = _user.getLanguage();
	IniUI  iniUI = IniUI.getInstance();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();

	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	if(from.equalsIgnoreCase("General"))
	{
		configTopo.createFile("eg_services.ini");
		String[] servers = configTopo.getVariables("DISCOVERY_SPECIFICATION");

		if (servers != null)
		{
			for (int i=0; i<servers.length; i++)
			{
				String varServer = servers[i];
				if (varServer.startsWith("Format:"))
				{
					continue;
				}
				String val = configTopo.getValues("DISCOVERY_SPECIFICATION", varServer);
				val = val.toLowerCase();
				if (val.startsWith("nodiscovery,") || val.endsWith("-port null"))
				{
					continue;
				}
				if (varServer.startsWith("#"))
				{
					varServer = varServer.substring(1);
				}
				srvTypeList.add(varServer);

				String tmpPort = val.substring(val.indexOf("-port")+5).trim();
				if (tmpPort.indexOf(":") > 0)
				{
					tmpPort = tmpPort.replace(':',',');
				}
				portList.add(tmpPort);
			}
		}

		serverList = sorter.getSortedCompTypeList(srvTypeList);
		port.createAdmin();
		discBase = port.getDiscBase();
		if (discBase == null) discBase = "";
		// Active Direcotry Subnets or manual IP range

		IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_authenticate.ini");
		String[] domains=iniFile.getSubjects();
		String useADDiscovery = "no";
		useADDiscovery = request.getParameter("useADDiscovery");
		String actDomain = request.getParameter("sDomain");
		String actSite = request.getParameter("sSite");
		String actSubnet = request.getParameter("sSubnet");

		// To remove the aggregate comp types from the servers List
		EgAggregateInfo aggInfo = new EgAggregateInfo("manager");
		Vector aggTypes = aggInfo.getAggregateTypes();
		aggInfo = null;

		String[] server_types=port.getValidServerTypesForDiscovery();
		for(int j=1;j<server_types.length;j++)
		{
			if(server_types[j].startsWith("#"))
			{
				compList.add(server_types[j].substring(1));
			}
			else
			{
				compList.add(server_types[j]);
			}
		}

		if(aggTypes != null && compList != null)
		{
			compList.removeAll(aggTypes);
		}

		server_types = null;
		server_types=port.getServertypes();
		for(int k=1;k<server_types.length;k++)
		{
			if(server_types[k].startsWith("#"))
			{
				server_types[k]=new String(server_types[k].substring(1));
				continue;
			}
			else
			{
				server_types[k]=new String(server_types[k]);
				if(server_types[k] != null)
				{
					server_list.add(server_types[k]);
				}
			}
		}
		//Collections.sort(compList,String.CASE_INSENSITIVE_ORDER);
		//Collections.sort(server_list,String.CASE_INSENSITIVE_ORDER);
	}
%>
<html>
<head>
<title>Agent Discover</title>
<meta name="created" content="28/6/2k">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<egui:skin ui="admin"/>
<script src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="Javascript1.2">

function isNetscape()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for Navigator ver 4+.
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for IE ver 4+. 
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function valform(action)
{
	var thisForm = document.discover;
	if (action == "General")
	{
		var flag = true;
		var splChar = "abcdefghijklmnoprstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
		var where='changeAgentSettings';
		var agentdisc = thisForm.AgentDiscDelay;
		var agentredisc = thisForm.AgentReDiscoverPeriod;
		var disctime  = thisForm.DiscTimeout;
		var agentdiscvalue = thisForm.AgentDiscDelay.value;
		var agentrediscvalue=thisForm.AgentReDiscoverPeriod.value;
		var disctimevalue = thisForm.DiscTimeout.value;

		var toposleeptime = thisForm.TopologySleepTime;
		var toporediscover = thisForm.TopologyReDiscoverPeriod;
		var toposleeptimevalue = thisForm.TopologySleepTime.value;
		var toporediscovervalue = thisForm.TopologyReDiscoverPeriod.value;

		for(var i=0;i < agentdiscvalue.length;i++)
		{
			if(agentdiscvalue.charAt(i) == ',' && agentdiscvalue.charAt(i + 1) == ',')
			{
				alert("<egui:intnl text='admin.AgentDiscovery.Agent discovery startup delay'/> Cannot have \' , \' in consecutive positions");
				thisForm.AgentDiscDelay.focus();
				flag=false;
				break;
			}
			else
			{
				continue;
			}
		}
		for(var j=0;j < agentrediscvalue.length;j++)
		{
			if(agentrediscvalue.charAt(j) == ',' && agentrediscvalue.charAt(j + 1) == ',')
			{
				alert('<egui:intnl text="admin.AgentDiscovery.Agent rediscovery period "/> Cannot have \' , \' in consecutive positions');
				thisForm.AgentReDiscoverPeriod.focus();
				flag=false;
				break;
			}
			else
			{
				continue;
			}
		}
		for(var k=0;k < disctimevalue.length;k++)
		{
			if(disctimevalue.charAt(k) == ',' && disctimevalue.charAt(k + 1) == ',')
			{
				alert("<egui:intnl text='admin.AgentDiscovery.Discovery timeout'/> Cannot have \' , \' in consecutive positions");
				thisForm.DiscTimeout.focus();
				flag=false;
				break;
				
			}
			else
			{
				continue;
			}
		}

		for(var k=0;k<toposleeptimevalue.length;k++)
		{
			if(toposleeptimevalue.charAt(k) == ',' && toposleeptimevalue.charAt(k + 1) == ',')
			{
				alert("<egui:intnl text='admin.AgentDiscovery.Delay between topology discovery '/> Cannot have \' , \' in consecutive positions");
				thisForm.TopologySleepTime.focus();
				flag=false;
				break;
				
			}
			else
			{
				continue;
			}
		}

		for(var k=0;k <toporediscovervalue.length;k++)
		{
			if(toporediscovervalue.charAt(k) == ',' && toporediscovervalue.charAt(k + 1) == ',')
			{
				alert("<egui:intnl text='admin.AgentDiscovery.Topology rediscovery period'/> Cannot have \' , \' in consecutive positions");
				thisForm.TopologyReDiscoverPeriod.focus();
				flag=false;
				break;
				
			}
			else
			{
				continue;
			}
		}

		if(!checkblank(agentdisc))
		{
			alert('<egui:intnl text="admin.AgentDiscovery.Agent discovery startup delay"/> Cannot be blank');
			thisForm.AgentDiscDelay.focus();
			flag=false;
		}
		else if(!checkblank(agentredisc))
		{
			alert('<egui:intnl text="admin.AgentDiscovery.Agent rediscovery period"/> cannot be blank');
			thisForm.AgentReDiscoverPeriod.focus();
			flag=false;
		}
		else if(!checkblank(disctime))
		{
			alert('<egui:intnl text="admin.AgentDiscovery.Discovery timeout"/> cannot be blank');
			thisForm.DiscTimeout.focus();
			flag=false;
		}
		else if(!checkblank(toposleeptime))
		{
			alert('<egui:intnl text="admin.AgentDiscovery.Delay between topology discovery"/> cannot be blank');
			thisForm.TopologySleepTime.focus();
			flag=false;
		}
		else if(!checkblank(toporediscover))
		{
			alert('<egui:intnl text="admin.AgentDiscovery.Topology rediscovery period"/> cannot be blank');
			thisForm.TopologyReDiscoverPeriod.focus();
			flag=false;
		}
		else if(!checkspace(agentdisc))
		{
			thisForm.AgentDiscDelay.focus();
			flag=false;
		}
		else if(!checkspace(agentredisc))
		{
			thisForm.AgentReDiscoverPeriod.focus();
			flag=false;
		}
		else if(!checkspace(disctime))
		{
			thisForm.DiscTimeout.focus();
			flag=false;
		}
		else if(!checkspace(toposleeptime))
		{
			thisForm.TopologySleepTime.focus();
			flag=false;
		}
		else if(!checkspace(toporediscover))
		{
			thisForm.TopologyReDiscoverPeriod.focus();
			flag=false;
		}
		else if(!checkcomma(agentdisc))
		{
			alert('Please enter a value in <egui:intnl text="admin.AgentDiscovery.Agent discovery startup delay"/>');
			thisForm.AgentDiscDelay.focus();
			flag=false;
		}
		else if(!checkcomma(agentredisc))
		{
			alert('Please enter a value in <egui:intnl text="admin.AgentDiscovery.Agent rediscover period"/>');
			thisForm.AgentReDiscoverPeriod.focus();
			flag=false;
		}
		else if(!checkcomma(disctime))
		{
			alert('<egui:intnl text="admin.AgentDiscovery.Discovery timeout"/> Please enter a value in Disc timeout');
			thisForm.DiscTimeout.focus();
			flag=false;
		}
		else if(!checkcomma(toposleeptime))
		{
			alert('Please enter a value in <egui:intnl text="admin.AgentDiscovery.Delay between topology discovery"/>');
			thisForm.TopologySleepTime.focus();
			flag=false;
		}
		else if(!checkcomma(toporediscover))
		{
			alert('Please enter a value in <egui:intnl text="admin.AgentDiscovery.Topology rediscovery period"/>');
			thisForm.TopologyReDiscoverPeriod.focus();
			flag=false;
		}
		else if (((!checknumber("+",agentdisc) && agentdiscvalue.indexOf(',') == -1) || agentdiscvalue == 0 || agentdiscvalue.indexOf('.') > -1) && (agentdiscvalue != 'NULL'))
		{
			alert('<egui:intnl text="admin.AgentDiscovery.Agent discovery startup delay "/> can have only numeric values');
			thisForm.AgentDiscDelay.focus();
			flag=false;
		}
		else if (((!checknumber("+",agentredisc) && agentrediscvalue.indexOf(',') == -1) || agentrediscvalue == 0 || agentrediscvalue.indexOf('.') > -1) && (agentrediscvalue != 'NULL'))
		{
			alert('<egui:intnl text="admin.AgentDiscovery.Agent rediscovery period"/> can have only numeric values');
			thisForm.AgentReDiscoverPeriod.focus();
			flag=false;
		}
		else if (((!checknumber("+",disctime) && disctimevalue.indexOf(',') == -1) || disctimevalue == 0 || disctimevalue.indexOf('.') > -1) && (disctimevalue != 'NULL'))
		{
			alert('<egui:intnl text="admin.AgentDiscovery.Discovery timeout"/> can have only numeric values');
			thisForm.DiscTimeout.focus();
			flag=false;
		}
		else if (((!checknumber("+",toposleeptime) && toposleeptimevalue.indexOf(',') == -1) || toposleeptimevalue == 0 || toposleeptimevalue.indexOf('.') > -1) && (toposleeptimevalue != 'NULL'))
		{
			alert('<egui:intnl text="admin.AgentDiscovery.Delay between topology discovery"/> can have only numeric values');
			thisForm.TopologySleepTime.focus();
			flag=false;
		}
		else if (((!checknumber("+",toporediscover) && toporediscovervalue.indexOf(',') == -1) || toporediscovervalue == 0 || toporediscovervalue.indexOf('.') > -1) && (toporediscovervalue != 'NULL'))
		{
			alert('<egui:intnl text="admin.AgentDiscovery.Topology rediscovery period"/> can have only numeric values');
			thisForm.TopologyReDiscoverPeriod.focus();
			flag=false;
		}
		else if(!checkspecialnomess(agentdisc,splChar) && (agentdiscvalue != 'NULL'))
		{
			alert('Special characters are not allowed in <egui:intnl text="admin.AgentDiscovery.Agent discovery startup delay"/> ');
			thisForm.AgentDiscDelay.focus();
			flag = false;
		}
		else if(!checkspecialnomess(agentredisc,splChar) && (agentrediscvalue != 'NULL'))
		{
			alert('Special characters are not allowed in <egui:intnl text="admin.AgentDiscovery.Agent rediscovery period "/> ');
			thisForm.AgentReDiscoverPeriod.focus();
			flag = false;
		}
		else if(!checkspecialnomess(disctime,splChar) && (disctimevalue != 'NULL'))
		{
			alert('Special characters are  not allowed in <egui:intnl text="admin.AgentDiscovery.Discovery timeout"/> ');
			thisForm.DiscTimeout.focus();
			flag = false;
		}
		else if(!checkspecialnomess(toposleeptime,splChar) && (toposleeptimevalue != 'NULL'))
		{
			alert('Special characters are  not allowed in <egui:intnl text="admin.AgentDiscovery.Delay between topology discovery"/> ');
			thisForm.TopologySleepTime.focus();
			flag = false;
		}
		else if(!checkspecialnomess(toporediscover,splChar) && (toporediscovervalue != 'NULL'))
		{
			alert('Special characters are  not allowed in <egui:intnl text="admin.AgentDiscovery.Topology rediscovery period"/> ');
			thisForm.TopologyReDiscoverPeriod.focus();
			flag = false;
		}

		// Port validation starts
		var count= thisForm.Ports.length;
		for(var i=0;i < count ;i++)
		{
			var serverport = thisForm.Ports[i];
			var serverportvalue = thisForm.Ports[i].value;

			for(var k=0;k < serverportvalue.length;k++)
			{
				if(serverportvalue.charAt(k) == ',' && serverportvalue.charAt(k + 1) == ',')
				{
					alert("<egui:intnl text='admin.discovery.Cannot have \' , \' in consecutive positions'/>.");
					showPortSummary();
					thisForm.Ports[i].focus();
					flag=false;
					break;
				}
				else
				{
					continue;
				}
			}

			if(!checkblank(serverport))
			{
				alert('<egui:intnl text="admin.discovery.Blank values are not allowed"/>');
				showPortSummary();
				thisForm.Ports[i].focus();
				flag=false;
				break;
			}
			else if(!checkspace(serverport))
			{
				showPortSummary();
				thisForm.Ports[i].focus();
				flag=false;
				break;
			}
			else if(!checkcomma(serverport))
			{
				alert('<egui:intnl text="admin.discovery.Please enter a port number"/>');
				showPortSummary();
				thisForm.Ports[i].focus();
				flag=false;
				break;
			}
			else if (serverport.value.indexOf(",") > -1)
			{
				var splittedVal = serverport.value.split(",");
				for (n=0;n<splittedVal.length;n++)
				{
					var element = splittedVal[n];
					if (element > 65535)
					{
						alert('<egui:intnl text="admin.common.Invalid port number"/>');
						showPortSummary();
						thisForm.Ports[i].focus();
						flag=false;
						break;
					}
				}
			}
			else if (((!checknumber("+",serverport) && serverportvalue.indexOf(',') == -1) || serverportvalue == 0 || serverportvalue.indexOf('.') > -1) && (serverportvalue != 'NULL'))
			{
				alert('<egui:intnl text="admin.discovery.Port number can consist of only valid numbers"/>');
				showPortSummary();
				thisForm.Ports[i].focus();
				flag=false;
				break;
			}
			else if(!checkspecialnomess(serverport,splChar) && (serverportvalue != 'NULL'))
			{
				alert('<egui:intnl text="admin.discovery.Special characters not allowed"/>');
				showPortSummary();
				thisForm.Ports[i].focus();
				flag = false;
				break;
			}
		}
		// Port validation ends
		if(flag == true)
		{
			if (isNetscape()) targetObj = document.discover.update;
			if (isIE()) targetObj = document.discover.update;
			//targetObj.disabled = true;
			thisForm.action="./EgAgentDiscoverp.jsp?from=general";
			document.discover.submit();
		}
	}
	else
	{
		if (isNetscape()) targetObj = document.discover.update;
		if (isIE()) targetObj = document.discover.update;
		//targetObj.disabled = true;
		thisForm.action="./EgAgentDiscoverp.jsp?from=actions";
		document.discover.submit();
	}
}

function showTopoSetting(val)
{
	if(val == 'true')
	{
		var borderBottom = document.getElementById("agentDiscoveryRow");
		var topologyDiscoveryRow = document.getElementById("topologyDiscoveryRow");
		topologyDiscoveryRow.style.display='';

		if (borderBottom != null && borderBottom != "undefined")
		{
			var td = borderBottom.getElementsByTagName("td");
			var th = borderBottom.getElementsByTagName("th");
			th[0].className="form_border";
			td[0].className="form_border";
			td[1].className="form_border";
			td[6].className="form_border";
		}
	}
	else
	{
		var borderBottom = document.getElementById("agentDiscoveryRow");
		var agentSettings = document.getElementById("topologyDiscoveryRow");
		agentSettings.style.display='none';
		if (borderBottom != null && borderBottom != "undefined")
		{
			var td = borderBottom.getElementsByTagName("td");
			var th = borderBottom.getElementsByTagName("th");
			th[0].className="form_spacing";
			td[0].className="form_spacing";
			td[1].className="form_spacing";
			td[6].className="form_spacing";
		}
	}
}

function setTotal(val)
{
	var TotalBox = document.getElementById('TotalBox');
	TotalBox.options.length = 0;
	var from = parseInt(val);
	for(var k=from ; k<=12;k++)
	{
		var optValue = k+"";
		TotalBox.options[TotalBox.options.length] = new Option(optValue, optValue);
	}
}

function enableTopology(val)
{
	if(val == 'true')
	{
		for(var k=4;k<=7;k++)
		{
			document.getElementById('row'+k).style.display='';
		}
		var borderBottom = document.getElementById("row3");
		if (borderBottom != null && borderBottom != "undefined")
		{
			var td = borderBottom.getElementsByTagName("td");
			var th = borderBottom.getElementsByTagName("th");
			th[0].className="form_border";
			td[0].className="form_border";
			td[1].className="form_border";
			td[6].className="form_border";
		}
	}
	else
	{
		for(var k=4;k<=7;k++)
		{
			document.getElementById('row'+k).style.display='none';
			document.getElementById("eg_subcontentbg").style.width='375px';
		}
		var borderBottom = document.getElementById("row3");
		if (borderBottom != null && borderBottom != "undefined")
		{
			var td = borderBottom.getElementsByTagName("td");
			var th = borderBottom.getElementsByTagName("th");
			th[0].className="form_spacing";
			td[0].className="form_spacing";
			td[1].className="form_spacing";
			td[6].className="form_spacing";
		}
	}
}

function showPortSummary()
{
	document.getElementById('AgentSummaryHeading_2').style.display = 'none';
	if (isNetscape())
	{
		document.getElementById('AgentSummaryHeading_1').style.display = 'table-row';
		document.getElementById('serverPorts').style.display = 'table-row';
	}
	else if (isIE())
	{
		document.getElementById('AgentSummaryHeading_1').style.display = 'block';
		document.getElementById('serverPorts').style.display = 'block';
	}
}

function hidePortSummary()
{
	document.getElementById('AgentSummaryHeading_1').style.display = 'none';
	if (isNetscape())
	{
		document.getElementById('AgentSummaryHeading_2').style.display = 'table-row';
		document.getElementById('serverPorts').style.display = 'table-row';
	}
	else if (isIE())
	{
		document.getElementById('AgentSummaryHeading_2').style.display = 'block';
		document.getElementById('serverPorts').style.display = 'block';
	}
	document.getElementById('serverPorts').style.display = 'none';
}

function showMoreSelectedComps()
{
	var selectedComponetsInfo = document.getElementById("selectedComponetsInfo");
	var componets_list = document.getElementById("componets_list");
	var comList = document.getElementById("c_types");
	var len = comList.options.length;
	var strGroups = "<table align=\"center\" name=\"adgroups1\" id=\"adgroups1\" border=\"0\" width=\"100%\" class=\"tableborder_ad\" cellpadding=\"4\" cellspacing=\"0\"><col width=\"33%\"><col width=\"33%\"><col width=\"34%\"><tr>";
	var count = 1;
	var innerTbl = "";
	for (var i=0;i<len;i++)
	{
		if (comList.options[i].selected == true)
		{
			var val = comList.options[i].text;
			if (count <= 3)
			{
				strGroups = strGroups + "<td class=\"tdborder_ad\" valign=\"top\" style=\"width:250px\">&nbsp;"+val+"</td>";
				count = count + 1;
			}
			if (count > 3)
			{
				strGroups = strGroups + "</tr>";
				innerTbl = innerTbl + strGroups;
				strGroups = "<tr>";
				count = 1;
			}
		}
	}
	if (strGroups != "<tr>")
	{
		if (count <= 3)
		{
			strGroups = strGroups;
			count=3-count;
			for (var j=0;j<=count;j++)
			{
				strGroups = strGroups + "<td class=\"tdborder_ad\" valign=\"top\" style=\"width:250px\">&nbsp;</td>";
			}
			strGroups = strGroups + "</tr>";
			innerTbl = innerTbl + strGroups;
		}
		else
		{
			strGroups = strGroups + "</tr>";
			innerTbl = innerTbl + strGroups;
		}
	}
	innerTbl = innerTbl + "</table>";
	componets_list.innerHTML = innerTbl;
	selectedComponetsInfo.style.display = "block";
}

function hideComponets()
{
	var actionDiv = document.getElementById("selectedComponetsInfo");
	actionDiv.style.display = "none";
}

function showComponents()
{
	document.getElementById("compDiv").style.display = "block";
}

function hideCompList()
{
	var comList = document.getElementById("c_types");
	var len = comList.options.length;
	var indexValue = "";
	var isAllChecked = "true";
	var count = 0;
	for (var i=0;i<len;i++)
	{
		if (comList.options[i].selected == true)
		{
			count = count + 1;
			if (count <= 2)
			{
				indexValue = indexValue + comList.options[i].text + ", ";
			}
		}
	}
	if (count == 0)
	{
		return false;
	}

	if (indexValue.length > 0)
	{
		indexValue = indexValue.substring(0,indexValue.length - 2);
	}
	//if (isAllChecked == "false")
	//{
		if (count == 1)
		{
			document.getElementById("dis_comp").innerHTML = indexValue;
		}
		else
		{
			document.getElementById("dis_comp").innerHTML = indexValue+" <span id='moreComp'  title='Show more selected components' style='cursor:pointer;'><a href='javascript:void(0)' onclick='javascript:showMoreSelectedComps()'  class='more_link'>...</a></span>";
		}
	//}
	//else
	//{
	//	document.getElementById("dis_comp").innerHTML = "All";
	//}
	indexValue = "";
	count = 0;
	document.getElementById("compDiv").style.display = "none";
}

function enableDisableDiscovery()
{
	//parent.frames[0].location.href = "EgLeftDiscoveryPane.jsp?linkFrom=AgentSettings&date="+new Date();
	window.location.href = "EgAgentDiscover.jsp?from=General&tableWidth=Medium&validate=true";
}

function enableAgentDiscovery()
{
	parent.frames[0].location.href = "EgLeftDiscoveryPane.jsp?linkFrom=AgentSettings&date="+new Date();
	window.location.href = "EgAgentDiscover.jsp?from=actions&tableWidth=Medium&validate=agent&action=enable";
}

function disableAgentDiscovery()
{
	parent.frames[0].location.href = "EgLeftDiscoveryPane.jsp?linkFrom=AgentSettings&date="+new Date();
	window.location.href = "EgAgentDiscover.jsp?from=actions&tableWidth=Medium&validate=agent&action=disable";
}

function enableTopologyDiscovery(action)
{
	parent.frames[0].location.href = "EgLeftDiscoveryPane.jsp?linkFrom=AgentSettings&date="+new Date();
	window.location.href = "EgAgentDiscover.jsp?from=actions&tableWidth=Medium&validate=topology&action="+action;
}
</script>
</head>
<body style="overflow:auto" id="space6">
<%
	String subject ="AGENT_SETTINGS";
	String agentdiscval = testIniFile.getValue(subject,"AgentDiscover");
	String AgentDiscDelayval = testIniFile.getValue(subject,"AgentDiscDelay");
	String AgentReDiscoverPeriodval = testIniFile.getValue(subject,"AgentReDiscoverPeriod");
	String DiscTimeoutval = testIniFile.getValue(subject,"DiscTimeout");
	String title=egMappingInfo.getTextDescription("admin.title. AGENT DISCOVERY - GENERAL SETTINGS");

	if(from != null && from.equalsIgnoreCase("Actions"))
	{
		title=egMappingInfo.getTextDescription("admin.title.AGENT DISCOVERY - ENABLE / DISABLE");
	}
	// Topology  Discovery settings (Begin)
	String topodiscval = testIniFile.getValue(subject,"TopoDiscoveryEnabled");
	String topodiscSendFrequncy = testIniFile.getValue(subject,"TopoDiscoverySendFreqeuncy");
	String nrStr = topodiscSendFrequncy.substring(0,topodiscSendFrequncy.indexOf("/"));
	String drStr = topodiscSendFrequncy.substring(topodiscSendFrequncy.indexOf("/")+1);
	String topoSleepTime = testIniFile.getValue(subject,"TopoDiscoveryFrequency");
	String topoRediscoveryPeriod = testIniFile.getValue(subject,"TopoReDiscoverPeriod");
	// Topology  Discovery settings (End)

	//boolean showTopoSettings = false;
	//if(agentdiscval!=null && agentdiscval.equalsIgnoreCase("true"))
	//{
	//	showTopoSettings = true;
	//}

	String newIni = "eg_DiscoveryHelper.ini";
	IniFile newIniFile = EgConfigFilesSync.getInstance(s_iniFile_dir + newIni,true);
	newIniFile.setValue("DISCOVERY_SETTINGS","AgentDiscoveryEnabled",agentdiscval);
	newIniFile.setValue("DISCOVERY_SETTINGS","TopologyDiscoveryEnabled",topodiscval);
	newIniFile.saveFile();
	EgConfigFilesSync.releaseInstance(newIniFile);

if(from.equalsIgnoreCase("General"))
{
	if (validate.equalsIgnoreCase("true"))
	{
		agentdiscval = "true";
		IniFile testIniFile1 = EgConfigFilesSync.getInstance(s_iniFile_dir + uiFile,true);
		testIniFile1.setValue("AGENT_SETTINGS","AgentDiscover",agentdiscval);
		testIniFile1.saveFile();
		EgConfigFilesSync.releaseInstance(testIniFile1);

		long currenttime = System.currentTimeMillis();
		String str = String.valueOf(currenttime);
		newIni = "eg_DiscoveryHelper.ini";
		IniFile newIniFile1 = EgConfigFilesSync.getInstance(s_iniFile_dir + newIni,true);
		newIniFile1.setValue("DISCOVERY_SETTINGS","AgentDiscoveryEnabled",agentdiscval);
		newIniFile1.setValue("DISCOVERY_SETTINGS","UpdatedTime",str);
		newIniFile1.saveFile();
		EgConfigFilesSync.releaseInstance(newIniFile1);
	}
%>
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page='<%="listSearch.jsp?title="+title+"&backButton=false&subtitle=false"%>'/>
<%
	if (agentdiscval.equalsIgnoreCase("true") || agentdiscval.equalsIgnoreCase("yes"))
	{
%>
	<tr>
		<td id="eg_whitebg" align="center" height="100%" valign="top">
			<form name="discover" method="post" action="./EgAgentDiscoverp.jsp">
			<input type="hidden" value="<%=tableWidth%>" name="tableWidth">
			<table align="center" cellspacing="0" cellpadding="4" border="0">
				<tr>
					<td align="center" valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
							<tr>
								<td class="eg_subcontent" colspan="4" nowrap>
									<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
											<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
												<egui:intnl text="admin.AgentDiscovery.AGENT DISCOVERY SETTINGS"/>
											</td>
											<td id="subhead_right" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
										</tr>
									</table>
								</td>
							</tr>

							<tr id="row8" name="row8" style="display:<%=agentdiscval.equalsIgnoreCase("true")?"":"none"%>">
								<th id="eg_subcontentbg"  class="form_border" nowrap>
									<egui:intnl text="admin.AgentDiscovery.Agent discovery startup delay (Mins)"/>
								</th>
								<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
								<td id="eg_subcontentbg" class="form_border" width="100%" height="21">
									<input type="text" name="AgentDiscDelay" maxlength="32" style="<%=(tableWidth != null && tableWidth.equalsIgnoreCase("Medium"))?"width:300px;":"width: 400px;"%>" value="<%=AgentDiscDelayval%>" class="list" maxlength="100">
									<input type="hidden" name="$_AgentDiscDelay" value="<%=AgentDiscDelayval%>">
								</td>
								<td id="eg_subcontentbg" class="form_border" >&nbsp;</td>
							</tr>

							<tr id="row9" name="row9" style="display:<%=agentdiscval.equalsIgnoreCase("true")?"":"none"%>">
								<th id="eg_subcontentbg" class="form_border" nowrap>
									<egui:intnl text="admin.AgentDiscovery.Agent rediscovery period (Mins)"/>
								</th>
								<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
								<td id="eg_subcontentbg" class="form_border" width="100%" height="21">
									<input type="text" name="AgentReDiscoverPeriod" maxlength="32" style="<%=(tableWidth != null && tableWidth.equalsIgnoreCase("Medium"))?"width:300px;":"width: 400px;"%>" value="<%=AgentReDiscoverPeriodval%>" class="list" maxlength="100">
									<input type="hidden" name="$_AgentReDiscoverPeriod" value="<%=AgentReDiscoverPeriodval%>">
								</td>
								<td id="eg_subcontentbg" class="form_border">&nbsp;</td>
							</tr>

							<tr id="row10" name="row10" style="display:<%=agentdiscval.equalsIgnoreCase("true")?"":"none"%>">
								<th id="eg_subcontentbg" class="form_spacing" nowrap>
									<egui:intnl text="admin.AgentDiscovery.Discovery timeout (Millisecs)"/>
								</th>
								<td id="eg_subcontentbg" class="form_spacing" width="20" align="center" nowrap>:</td>
								<td id="eg_subcontentbg" class="form_spacing" width="100%" height="21">
									<input type="text" name="DiscTimeout" maxlength="32" style="<%=(tableWidth != null && tableWidth.equalsIgnoreCase("Medium"))?"width:300px;":"width: 400px;"%>" value="<%=DiscTimeoutval%>" class="list" maxlength="100">
									<input type="hidden" name="$_DiscTimeout" value="<%=DiscTimeoutval%>">
								</td>
								<td id="eg_subcontentbg" class="form_spacing">&nbsp;</td>
							</tr>
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" colspan="2" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<!-- Topology Discovery Entries -->
<!-- 							<tr id="row1" name="row1">
								<td  colspan="4" class="form_spacing">&nbsp;</td>
							</tr> -->
<%
		if (topodiscval.equalsIgnoreCase("true"))
		{
%>
							<tr>
								<td colspan="4">&nbsp;</td>
							</tr>
<%
		}
	//if (agentdiscval.equalsIgnoreCase("true") && topodiscval.equalsIgnoreCase("true"))
	//{
%>
							<tr id="row2" name="row2" style="display:<%=(agentdiscval.equalsIgnoreCase("true") && topodiscval.equalsIgnoreCase("true"))?"":"none"%>">
								<td class="eg_subcontent" colspan="4" nowrap>
									<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
											<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
												<egui:intnl text="admin.AgentDiscovery.TOPOLOGY DISCOVERY SETTINGS"/>
											</td>
											<td id="subhead_right" width="7">
												<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
										</tr>
									</table>
								</td>
							</tr>

							<tr id="row4" name="row4" style="display:<%=(agentdiscval.equalsIgnoreCase("true") && topodiscval.equalsIgnoreCase("true"))?"":"none"%>">
								<th id="eg_subcontentbg" class="form_border" nowrap>
									<egui:intnl text="admin.AgentDiscovery.Topology rediscovery period (Mins)"/>
								</th>
								<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
								<td id="eg_subcontentbg" class="form_border" width="100%" height="21">
									<input type="text" name="TopologyReDiscoverPeriod" maxlength="32" style="<%=(tableWidth != null && tableWidth.equalsIgnoreCase("Medium"))?"width:300px;":"width: 400px;"%>" value="<%=topoRediscoveryPeriod%>" class="list" maxlength="100">
									<input type="hidden" name="$_TopologyReDiscoverPeriod" value="<%=topoRediscoveryPeriod%>">
								</td>
								<td id="eg_subcontentbg" class="form_border">&nbsp;</td>
							</tr>

							<tr id="row5" name="row5" style="display:<%=(agentdiscval.equalsIgnoreCase("true") && topodiscval.equalsIgnoreCase("true"))?"":"none"%>">
								<th id="eg_subcontentbg"  class="form_border" nowrap>
									<egui:intnl text="admin.AgentDiscovery.Dependencies must be present"/>
								</th>
								<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
								<td id="eg_subcontentbg" class="form_border" width="100%" height="21">
									<table cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td> 
												<select name="SendBox" id="SendBox" onchange="javascript:setTotal(this.value);">
<%
	String selected="";
	for(int k=3;k<=12;k++)
	{
		String numStr = Integer.toString(k);
		if(nrStr!=null && nrStr.equals(numStr))
			selected="selected";
		else
			selected="";
%>
													<option value="<%=numStr%>" <%=selected%>> <%=numStr%> </option>
<%
	}
%>
												</select>
											</td>
											<input type="hidden" name="$_SendBox" value="<%=nrStr%>"/>
											<td>&nbsp; <egui:intnl text="admin.AgentDiscovery.times "/> &nbsp; </td>
										</tr>
									</table>
								</td>
								<td id="eg_subcontentbg" class="form_border" >&nbsp;</td>
							</tr>

							<tr id="row6" name="row6" style="display:<%=(agentdiscval.equalsIgnoreCase("true") && topodiscval.equalsIgnoreCase("true"))?"":"none"%>">
								<th id="eg_subcontentbg"  class="form_border" nowrap>
									<egui:intnl text="admin.AgentDiscovery.Number of dependency discovery attempts"/>

								</th>
								<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
								<td id="eg_subcontentbg" class="form_border" width="100%" height="21">
									<table cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td> 
												<select name="TotalBox" id="TotalBox">
<%
		selected="";
		int fromValue = Integer.parseInt(nrStr);
		for(int k=fromValue;k<=12;k++)
		{
			String numStr = Integer.toString(k);
			if(drStr!=null && drStr.equals(numStr))
				selected="selected";
			else
				selected="";
%>
													<option value="<%=numStr%>" <%=selected%>> <%=numStr%> </option>
<%
		}
%>
												</select>
											</td>
											<input type="hidden" name="$_TotalBox" value="<%=drStr%>"/>
											<td>&nbsp; <egui:intnl text="admin.AgentDiscovery.times "/> &nbsp; </td>
											</tr>
									</table>
								</td>
								<td id="eg_subcontentbg" class="form_border" >&nbsp;</td>
							</tr>


							<tr id="row7" name="row7" style="display:<%=(agentdiscval.equalsIgnoreCase("true") && topodiscval.equalsIgnoreCase("true"))?"":"none"%>">
								<th id="eg_subcontentbg" class="form_spacing" nowrap>
									<egui:intnl text="admin.AgentDiscovery.Delay between successive dependency discovery attempts (Mins)"/>
								</th>
								<td id="eg_subcontentbg" class="form_spacing" width="20" align="center" nowrap>:</td>
								<td id="eg_subcontentbg" class="form_spacing" width="100%" height="21">
									<input type="text" name="TopologySleepTime" maxlength="32" style="<%=(tableWidth != null && tableWidth.equalsIgnoreCase("Medium"))?"width:300px;":"width: 400px;"%>" value="<%=topoSleepTime%>" class="list" maxlength="100">
									<input type="hidden" name="$_TopologySleepTime" value="<%=topoSleepTime%>">
								</td>
								<td id="eg_subcontentbg" class="form_spacing">&nbsp;</td>
							</tr>

							<tr id="row11" name="row11" style="display:<%=topodiscval.equalsIgnoreCase("true")?"":"none"%>">
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" colspan="2" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<tr>
								<td colspan="4">&nbsp;</td>
							</tr>
<%
	//}
%>

							<tr id="agentSettings" style="display:<%=agentdiscval.equalsIgnoreCase("true")?"":"none"%>">
								<td colspan="4">
									<table cellpadding="0" cellspacing="0" border="0" width="100%">
										<tr>
											<td class="eg_subcontent" colspan="5" nowrap>
												<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
													<tr>
														<td id="subhead_left" width="7">
														<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
														</td>
														<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
														<egui:intnl text="admin.discovery.COMMON DISCOVERY SETTINGS OF YOUR ENVIRONMENT"/>*
														</td>
														<td id="subhead_right" width="7">
														<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
											<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
											<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
										</tr>
										<tr>
										<th id="eg_subcontentbg" class="form_border" width="250" nowrap>
											<egui:intnl text="admin.discovery.Component types"/>
										</th>
										<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
										<td id="eg_subcontentbg" class="form_border" width="100%"  align="left" nowrap ><div id="dis_comp" style="float:left">
			<%
					if (server_list.size() == 0)
					{
						server_list.addAll(compList);
					}

					List tmpServerList = sorter.getSortedCompTypeList(server_list);
					if (server_list.size() ==1)
					{
						EgName tmpName = (EgName)tmpServerList.get(0);
						out.print(tmpName.getLocalName());
					}
					else
					{
						EgName tmpName = (EgName)tmpServerList.get(0);
						EgName tmpName2 = (EgName)tmpServerList.get(1);
						String strTemp =tmpName.getLocalName() + ", "+ tmpName2.getLocalName()+" <span id='moreComp'  title='Show more selected components' style='cursor:pointer;'><a href='javascript:void(0)' onclick='javascript:showMoreSelectedComps()'  class='more_link'>...</a></span>";
						out.print(strTemp);
					}
			%>
										</div>
										<div style="float:left;margin-left:5px" class="mouse"><img align="left" onclick="javascript:showComponents()" src="/final/images/pencil_gray.png" title="Select components for discovery"></div>
										<style>
											.more_link{ padding:3px;background:#E2e2e2;color:#000;text-decoration:none!important}
											.more_link:hover{background:#e6e6e6}
										</style>
										</td>
										<td class="mouse form_border" id="eg_subcontentbg">
											
										</td>
										<td id="eg_subcontentbg" class="form_border">&nbsp;</td>
									</tr>
									<tr>
										<th id="eg_subcontentbg" class="form_border" width="250" nowrap>
											<egui:intnl text="admin.discovery.Index components using"/>
										</td>
										<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
										<td id="eg_subcontentbg" class="form_border" width="100%">
											<select name="discbase" style="width:300px">
												<option value="IP"<%=discBase.equalsIgnoreCase("IP")?"selected":""%>><egui:intnl text="admin.discovery.IP address"/></option>
												<option value="DNS"<%=discBase.equalsIgnoreCase("DNS")?"selected":""%>><egui:intnl text="admin.discovery.Host name"/> </option>
											</select>
										</td>
										<td id="eg_subcontentbg" class="form_border" colspan="2">&nbsp;</td>
									</tr>

									<tr id="AgentSummaryHeading_1" style="display:none">
										<th id="eg_subcontentbg" class="form_spacing" width="250" nowrap>
											<egui:intnl text="admin.test.TCP ports for application discovery"/>
										</th>
										<td id="eg_subcontentbg" class="form_spacing" width="20" align="center" nowrap>:</td>
										<td id="eg_subcontentbg" class="form_spacing" width="100%">
											<span class="mouse" onclick="javascript:hidePortSummary();"><b>Click here</b></span> to hide port settings
										</td>
										<td class="mouse form_spacing" id="eg_subcontentbg">&nbsp;
										</td>
										<td id="eg_subcontentbg" class="form_spacing">&nbsp;</td>
									</tr>

									<tr id="AgentSummaryHeading_2">
										<th id="eg_subcontentbg" class="form_spacing" width="250" nowrap>
											<egui:intnl text="admin.test.TCP ports for application discovery"/>
										</th>
										<td id="eg_subcontentbg" class="form_spacing" width="20" align="center" nowrap>:</td>
										<td id="eg_subcontentbg" class="form_spacing" width="100%">
											<span class="mouse" onclick="javascript:showPortSummary();"><b>Click here</b></span> to view/modify ports
										</td>
										<td class="mouse form_spacing" id="eg_subcontentbg">
											&nbsp;
										</td>
										<td id="eg_subcontentbg" class="form_spacing">&nbsp;</td>
									</tr>
									<tr id="serverPorts" style="display:none">
										<td colspan="5" align="center" width="100%" >
											<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
												<tr>
													<td colspan="4">&nbsp;</td>
												</tr>
			<%
				for(int k=0;k<serverList.size();k++)
				{
					//out.print(k);
					boolean space=(k+1)<serverList.size();
					EgName nameObj = (EgName)serverList.get(k);
					String tmpVal = nameObj.getActualName();	
					String tmpDis = nameObj.getLocalName();	
					int index = srvTypeList.indexOf(tmpVal);
					String portNo = (String)portList.get(index); 
			%>
												<tr>
													<th  id="eg_subcontentbg" class="<%=space?"form_border":"form_spacing"%>" nowrap><%=tmpDis%>
													</th>
													<td id="eg_subcontentbg" class="<%=space?"form_border":"form_spacing"%>" width="20" align="center" nowrap>:</td>
													<td id="eg_subcontentbg" class="<%=space?"form_border":"form_spacing"%>" width="100%" height="21" > <input type="text" name="Ports" maxlength="32" style="width: 350px; " value="<%=portNo%>" class="list" maxlength="100">
													</td>
													<td id="eg_subcontentbg" class="<%=space?"form_border":"form_spacing"%>" >&nbsp;</td>
													<input type="hidden" name="serverName" value="<%=tmpVal%>">
												</tr>
												<input type="hidden" name="$_Ports" value="<%=tmpVal%>$<%=portNo%>">
			<%
				}
			%>
											</table>
										</td>
									</tr>
									<tr>
										<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
										<td id="eg_subcontentbg"  width="100%" colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
										<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
									</tr>
									<tr>
										<td colspan="5" style="padding-top:5px;">* Indicates that these settings are also applicable for manager discovery.</td>
									</tr>
									</table>
								</td>
							</tr>
						</table><br>
						<input type="button" name="update" value='<egui:intnl text="admin.common.Update"/>' style="width: 100px;" class="eg_back" onClick="javascript:valform('General');">
					</td>
				</tr>
			</table>
			<div id="compDiv" style="display:none;width:430px;height:50px;left:180px;right:200px;top:71px;position:absolute;border:0px solid #ff0000;z-index:1000;">
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td colspan="3">
							<table border="0" cellpadding="0" cellspacing="0" width="100%">
								<tr>
									<td width="5" height="22" class="panel_top_left"><img src="/final/admin/eg_images/spacer.gif" width="5" height="22" border="0"></td>
									<td class="panel_top_bg whitefont" height="22px" width="55%" id="setTitle"><egui:intnl text="admin.common.Select components to be discovered" /></td>
									<td align="left" class="panel_top_bg" style="padding-right:55px"></td>
									<td align="right" class="panel_top_bg" style="padding-top:2px">
									<img class="mouse" src="/final/monitor/eg_images/<%=admin_Skin%>/popup_close.png" border="0" title="Close" onclick="javascript:hideCompList();"></td>
									<td width="9" height="22" class="panel_top_right"><img src="/final/admin/eg_images/spacer.gif" width="9" height="22" border="0"></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td class="panel_left_bg eg_blankspace" width="5px"><img src="/final/admin/eg_images/spacer.gif"></td>
						<td align="center" valign="middle" style="padding:8px 4px 4px 4px;" class="panelbg" >
							<table border="0" cellpadding="0" cellspacing="0" width="100%">
								<tr>
									<td id="errMsg" style="" width="100%" align="center" valign="middle">
										<table border="0" cellpadding="0" cellspacing="0" width="100%">
											<tr><td>
											<select name="c_types" id="c_types" multiple style="width:400px;" size="20">
<%
					int count = 0;
					compList = sorter.getSortedCompTypeList(compList);
					for (int i=0;i<compList.size();i++)
					{
						EgName tmpServer = (EgName)compList.get(i);
						String actualName = (String)tmpServer.getActualName();
						String displayName = (String)tmpServer.getLocalName();
						if (server_list.contains(actualName))
						{
%>
							<option SELECTED value="<%=actualName%>"><%=displayName%></option>
<%
						}
						else
						{
%>
							<option value="<%=actualName%>"><%=displayName%></option>
<%
						}
					}
%>
											</select>
											</td></tr>
											<tr>
												<td height="30" align="center">&nbsp;
												<input type="button" value='<egui:intnl text="admin.common.Apply"/>' style="width: 90px;" class="eg_back" onClick="javascript:hideCompList();">
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
						<td class="panel_right_bg" width="9px"><img src="/final/admin/eg_images/spacer.gif" width="9"></td>
					</tr>
					<tr>
						<td class="panel_bottom_left"><img src="/final/admin/eg_images/spacer.gif" width="5" height="10"></td>
						<td class="panel_bottom_bg" height="10"><img src="/final/admin/eg_images/spacer.gif"></td>
						<td class="panel_bottom_right"><img src="/final/admin/eg_images/spacer.gif" width="9" height="10"></td>
					</tr>
				</table>
			</div>
			<div id="selectedComponetsInfo" style="display:none;width:620px;height:50px;left:86px;right:200px;top:62px;position:absolute;border:0px solid #ff0000;z-index:1000;">
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td colspan="3">
							<table border="0" cellpadding="0" cellspacing="0" width="100%">
								<tr>
									<td width="5" height="22" class="panel_top_left"><img src="/final/admin/eg_images/spacer.gif" width="5" height="22" border="0"></td>
									<td class="panel_top_bg whitefont" height="22px" width="80%" id="setTitle"><egui:intnl text="admin.common.Selected components" /></td>
									<td align="left" class="panel_top_bg" style="padding-right:4px"></td>
									<td align="right" class="panel_top_bg" style="padding-top:2px">
									<img class="mouse" src="/final/monitor/eg_images/<%=admin_Skin%>/popup_close.png" border="0" title="Close" onclick="javascript:hideComponets();"></td>
									<td width="9" height="22" class="panel_top_right"><img src="/final/admin/eg_images/spacer.gif" width="9" height="22" border="0"></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td class="panel_left_bg eg_blankspace" width="5px"><img src="/final/admin/eg_images/spacer.gif"></td>
						<td style="background:#EEEEEE">
							<div id="componets_list" class='div_scroll panelbg'  style='overflow-x: auto; overflow-y:auto;width:100%;height:300px;padding-top:5px;padding-bottom:5px'>
							</div>
						</td>
						<td class="panel_right_bg" width="9px"><img src="/final/admin/eg_images/spacer.gif" width="9"></td>
					</tr>
					<tr>
						<td class="panel_bottom_left"><img src="/final/admin/eg_images/spacer.gif" width="5" height="10"></td>
						<td class="panel_bottom_bg" height="10"><img src="/final/admin/eg_images/spacer.gif"></td>
						<td class="panel_bottom_right"><img src="/final/admin/eg_images/spacer.gif" width="9" height="10"></td>
					</tr>
				</table>
			</div>
			<input type="hidden" name="$_discBase" value="<%=discBase%>">
			<input type="hidden" name="$_AgentDiscover" value="<%=agentdiscval.equalsIgnoreCase("true")?"Yes":"No"%>"/>
			<input type="hidden" name="$_TopologyDiscover" value="<%=topodiscval.equalsIgnoreCase("true")?"Yes":"No"%>"/>

			<input type="hidden" name="AgentDiscover" value="<%=agentdiscval%>"/>
			<input type="hidden" name="TopologyDiscover" value="<%=topodiscval%>"/>
			</form>
		</td>
	</tr>
<%
	}
	else
	{
		String message = "Agent discovery is currently disabled for your environment.";
	%>
	<tr>
		<td height="400px;">
			<table align="center" width="75%" cellspacing="0" cellpadding="0" border="0" style="table-layout:collapse"><colgroup><col width="7"><col width="175"><col width="40"><col width="100%"><col width="7"></colgroup>
			<tbody>
				<tr>
					<td height="6" id="inner_top_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td colspan="5" height="100" align="center" id="eg_subcontentbg" class="form_spacing">
						<table border="0" cellspacing="0" cellpadding="5">
							<tbody>
								<tr>
									<td><b><%=message%></b></td>
								</tr>
								<tr>
									<td align="center" style="padding-top:14px;" colspan="5" >
										<b>Would you like to enable it?</b>&nbsp;&nbsp;<input type="button" name='discoveryOpt' id="discoveryOpt" value='Enable' style="width: 90px;" class="eg_back" onClick="javascript:enableDisableDiscovery();">
									</td>
								</tr>
							</tbody>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" class="inner_bott_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" width="100%" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" class="inner_bott_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</tbody></table>
		</td>
	</tr>
<%
	}
%>
</table>
<%
}
else
{
	if (validate.equalsIgnoreCase("agent"))
	{
		String action = request.getParameter("action");
		if (action != null && action.equalsIgnoreCase("enable"))
		{
			agentdiscval = "true";
		}
		else
		{
			agentdiscval = "false";
		}
		IniFile testIniFile1 = EgConfigFilesSync.getInstance(s_iniFile_dir + uiFile,true);
		testIniFile1.setValue("AGENT_SETTINGS","AgentDiscover",agentdiscval);
		testIniFile1.saveFile();
		EgConfigFilesSync.releaseInstance(testIniFile1);

		long currenttime = System.currentTimeMillis();
		String str = String.valueOf(currenttime);
		newIni = "eg_DiscoveryHelper.ini";
		IniFile newIniFile1 = EgConfigFilesSync.getInstance(s_iniFile_dir + newIni,true);
		newIniFile1.setValue("DISCOVERY_SETTINGS","AgentDiscoveryEnabled",agentdiscval);
		newIniFile1.setValue("DISCOVERY_SETTINGS","UpdatedTime",str);
		newIniFile1.saveFile();
		EgConfigFilesSync.releaseInstance(newIniFile1);
	}
	else if (validate.equalsIgnoreCase("topology"))
	{
		String action = request.getParameter("action");
		if (action != null && action.equalsIgnoreCase("enable"))
		{
			topodiscval = "true";
		}
		else
		{
			topodiscval = "false";
		}
		IniFile testIniFile1 = EgConfigFilesSync.getInstance(s_iniFile_dir + uiFile,true);
		testIniFile1.setValue("AGENT_SETTINGS","TopoDiscoveryEnabled",topodiscval);
		testIniFile1.saveFile();
		EgConfigFilesSync.releaseInstance(testIniFile1);

		long currenttime = System.currentTimeMillis();
		String str = String.valueOf(currenttime);
		newIni = "eg_DiscoveryHelper.ini";
		IniFile newIniFile1 = EgConfigFilesSync.getInstance(s_iniFile_dir + newIni,true);
		newIniFile1.setValue("DISCOVERY_SETTINGS","TopologyDiscoveryEnabled",topodiscval);
		newIniFile1.setValue("DISCOVERY_SETTINGS","UpdatedTime",str);
		newIniFile1.saveFile();
		EgConfigFilesSync.releaseInstance(newIniFile1);
	}
	//if (validate.equalsIgnoreCase("true"))
	//{
		if (agentdiscval.equalsIgnoreCase("true"))
		{
			String message = "Agent discovery is currently enabled for your environment.";
			String message2 = "Topology discovery is currently "+ (topodiscval.equalsIgnoreCase("true")?"enabled":"disabled").toString() +" for your environment.";
%>
	<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page='<%="listSearch.jsp?title="+title+"&backButton=false&subtitle=false&from=EnableDisableDiscovery"%>'/>
	<tr>
		<td>
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td class="eg_subcontentbg">
						<table  width="100%" cellspacing="0" cellpadding="4" border="0" height="22" >
								<col width=250><col width=100><col width=120>
							<tr>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;border-top-width:1px;" align="center"><b><egui:intnl text="admin.discovery.Discovery Option"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;border-top-width:1px;" align="center"><b><egui:intnl text="admin.discovery.Current Status"/></b></td>
								<td id="cell_border3" style="border-right-width:1px;border-top-width:1px;" align="center"><b><egui:intnl text="admin.discovery.Action"/></b></td>
							</tr>
							<tr>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.Agent discovery"/></b></td>
								<td id="cell_border4" style="border-left-width:1px;" align="center">
<%
					if(agentdiscval.equalsIgnoreCase("yes") || agentdiscval.equalsIgnoreCase("true"))
					{
%>
									<b>Enabled</b>
								
<%					}
					else
					{
%>
									<b>Disabled</b>
<%								
					}
%>
								</td>
								<td id="cell_border4" style="border-right-width:1px;" align="center"><input type="button" name='discoveryOpt' id="discoveryOpt" value='Disable' style="width: 90px;" class="eg_back" onClick="javascript:disableAgentDiscovery();"></td>
							</tr>
							<tr>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.Topology discovery"/></b></td>
								<td id="cell_border4" style="border-left-width:1px;" align="center">
<%
					if(topodiscval.equalsIgnoreCase("yes") || topodiscval.equalsIgnoreCase("true"))
					{
%>
									<b>Enabled</b>								
<%					}
					else
					{
%>
									<b>Disabled</b>
<%								
					}
%>
								</td>
								<td id="cell_border4" style="border-right-width:1px;" align="center"><input type="button" name='discoveryOpt' id="discoveryOpt" value='<%=topodiscval.equalsIgnoreCase("true")?"Disable":"Enable"%>' style="width: 90px;" class="eg_back" onClick="javascript:enableTopologyDiscovery('<%=topodiscval.equalsIgnoreCase("true")?"Disable":"Enable"%>');"></td>
							</tr>
						</table>
					</td>
				<tr>
			</table>
		</td>
	</tr>
	</table>
<%
		}
		else
		{
			String message = "Agent discovery is currently disabled for your environment.";
%>
	<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page='<%="listSearch.jsp?title="+title+"&backButton=false&subtitle=false&from=EnableDisableDiscovery"%>'/>
	
		<tr>
		<td>
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td class="eg_subcontentbg">
						<table  width="100%" cellspacing="0" cellpadding="4" border="0" height="22" >
								<col width=250><col width=100><col width=120>
							<tr>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;border-top-width:1px;" align="center"><b><egui:intnl text="admin.discovery.Discovery Option"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;border-top-width:1px;" align="center"><b><egui:intnl text="admin.discovery.Current Status"/></b></td>
								<td id="cell_border3" style="border-right-width:1px;border-top-width:1px;" align="center"><b><egui:intnl text="admin.discovery.Action"/></b></td>
							</tr>
							<tr>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.Agent discovery"/></b></td>
								<td id="cell_border4" style="border-left-width:1px;" align="center">
<%
					if(agentdiscval.equalsIgnoreCase("yes") || agentdiscval.equalsIgnoreCase("true"))
					{
%>
									<b>Enabled</b>
								
<%					}
					else
					{
%>
									<b>Disabled</b>
<%								
					}
%>
								</td>
								<td id="cell_border4" style="border-right-width:1px;" align="center"><input type="button" name='discoveryOpt' id="discoveryOpt" value='Enable' style="width: 90px;" class="eg_back" onClick="javascript:enableAgentDiscovery();"></td>
							</tr>
						</table>
					</td>
				<tr>
			</table>
		</td>
	</tr>
	</table>
<%
	}
}
%>
</body>
</html>

