<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="org.json.simple.*"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="java.io.*"%>
<%@ page import="java.util.*"%>
<%
	JSONObject rootJson = new JSONObject();
	
	JSONArray jsonArr = new JSONArray();
	
	String versionName = request.getParameter("agentVersion");
	if (versionName == null || versionName.equals("null"))
	{
		versionName = "Latest";
	}

	IniFile mgrIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
	
	String defaultAgents = mgrIni.getValue("MISC_ARGS","DefaultAgentFolders");
	String ShowVersionSpecificAgents = mgrIni.getValue("MISC_ARGS","ShowVersionSpecificAgents");
	
	rootJson.put("selectedAgentVersion",versionName);

	ArrayList versionList = new ArrayList();

	String sep = System.getProperty("file.separator");

	if (defaultAgents != null && defaultAgents.length() > 0)
	{
		StringTokenizer st = new StringTokenizer(defaultAgents,",");
		ArrayList defaultAgentFolders = new ArrayList();
		while (st.hasMoreTokens())
		{
			defaultAgentFolders.add(st.nextToken());
		}

		String unix [] = mgrIni.getVariables("UNIX_AGENT_FOLDER_NAMES");
		String win [] = mgrIni.getVariables("WINDOWS_AGENT_FOLDER_NAMES");

		ArrayList unixList = unix==null?new ArrayList():new ArrayList(Arrays.asList(unix));
		ArrayList winList = win==null?new ArrayList():new ArrayList(Arrays.asList(win));
		
		for (int j = 0; j < defaultAgentFolders.size(); j++)
		{
			String folderName = (String)defaultAgentFolders.get(j);

			File agentVersionfolder = new File(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"agents"+sep+folderName);
			File[] listOfVersionFiles = agentVersionfolder.listFiles();

			if (listOfVersionFiles != null && listOfVersionFiles.length > 0)
			{
				for (int l = 0; l < listOfVersionFiles.length; l++)
				{
					versionList.add(listOfVersionFiles[l].getName());
				}
			}
			
			File folder = new File(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"agents"+sep+folderName+sep+versionName);
			File[] listOfFiles = folder.listFiles();
			
			if (listOfFiles != null && listOfFiles.length > 0)
			{
				for (int k = 0; k < listOfFiles.length; k++)
				{
					JSONObject jsonObj = new JSONObject();
					if (listOfFiles[k].getName().endsWith(".zip"))
					{
						String dirName = listOfFiles[k].getName();
						String imageName = mgrIni.getValue("AGENT_IMAGE_CLASS",dirName);
						if (unixList.contains(dirName))
						{
							String displayName = mgrIni.getValue("UNIX_AGENT_FOLDER_NAMES",dirName);
							if (displayName == null || displayName.length() <= 0)
							{
								displayName = dirName;
							}
							jsonObj.put("displayField",displayName);
							jsonObj.put("valueField",dirName);
							jsonObj.put("className",imageName);
							jsonObj.put("folder",folderName);
							jsonObj.put("agentVersion",versionName);
							jsonObj.put("category","Unix");

							if (dirName.indexOf("Linux") != -1)
							{
								if (dirName.indexOf("x64") != -1)
								{
									jsonObj.put("bit","64-bit");
								}
								else
								{
									jsonObj.put("bit","32-bit");
								}
							}

							jsonObj.put("version",displayName);

							jsonArr.add(jsonObj);
						}
						else if (winList.contains(dirName))
						{
							if (dirName.toLowerCase().startsWith("vm") && !folderName.equalsIgnoreCase("vm"))
							{
								continue;
							}

							String displayName = mgrIni.getValue("WINDOWS_AGENT_FOLDER_NAMES",dirName);
							if (displayName == null || displayName.length() <= 0)
							{
								displayName = dirName;
							}
							jsonObj.put("displayField",displayName);
							jsonObj.put("valueField",dirName);
							jsonObj.put("className",imageName);
							jsonObj.put("folder",folderName);
							jsonObj.put("agentVersion",versionName);
							jsonObj.put("category","Windows");
							
							if (dirName.indexOf("x64")!= -1)
							{
								jsonObj.put("bit","64-bit");
							}
							else
							{
								jsonObj.put("bit","32-bit");
							}

							String version = mgrIni.getValue("WINDOWS_AGENT_VERSION",displayName);
							if (version != null && version.length() > 0)
							{
								jsonObj.put("version",version);
							}
							else
							{
								jsonObj.put("version",displayName);
							}

							jsonArr.add(jsonObj);
						}
					}
				}
			}
		}
	}

	JSONArray verArr = new JSONArray();
	JSONObject verObj = new JSONObject();

	versionList = com.egurkha.util.ListUtils.removeDuplicates(versionList,1);
	Collections.reverse(versionList);

	if(versionList != null)
	{
		for (int i=0;i<versionList.size();i++)
		{
			String versionFolder = (String) versionList.get(i);
			verObj = new JSONObject();
			verObj.put("displayField",versionFolder);
			verObj.put("valueField",versionFolder);
			verArr.add(verObj);
		}
	}
	rootJson.put("agentVersion",verArr);
	rootJson.put("listOfOS",jsonArr);
	out.println(rootJson.toString());
%>



