<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.*"%>
<%@ page import = "com.egurkha.EgConstants"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.admin.UpdateCompositeTestPeriod"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "java.util.*"%>
<%@ page import="net.sf.json.*" %>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJson = new JSONObject();
	JSONObject commonObjectType = new JSONObject();
	JSONArray arrayType =new  JSONArray();
	JSONObject commonObjectName = new JSONObject();
	JSONArray arrayName =new  JSONArray();
	
	IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String[] testFormatPeriod = uiIni.getVariables("TEST_FREQUENCY");
	TreeMap reversePeriodMap = new TreeMap();
	if(!EgUtils.isNull((Object) testFormatPeriod))
	{
		for (int i=0;i<testFormatPeriod.length;i++)
		{
			String secondsStr = uiIni.getValue("TEST_FREQUENCY", testFormatPeriod[i]);
			reversePeriodMap.put(secondsStr, testFormatPeriod[i]);
		}
	}
	String operation = request.getParameter("operation");
	String sessionId = request.getParameter("sessid");
	operation = "update";
	if(!StringUtils.isNull(operation) && operation.equalsIgnoreCase("update"))
	{
		String selectedTests = request.getParameter("selectedTests");
		if(!StringUtils.isNull(selectedTests))
		{
			/* code for auditlog starts */
			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","Composite Test Period");
			auditLogThread.setValue("Activity","Update Test Period");
			/* code for auditlog ends */
			StringTokenizer tokens = new StringTokenizer(selectedTests,"$");

			TreeMap map = new TreeMap();
			while(tokens.hasMoreTokens())
			{
				String information = (String) tokens.nextToken();
				String testPeriod = information.substring(information.lastIndexOf(":")+1);
				String previousTestPeriod = testPeriod.substring(testPeriod.lastIndexOf("|")+1);
				testPeriod = testPeriod.substring(0,testPeriod.lastIndexOf("|"));
				information = information.substring(0,information.lastIndexOf(":"));
				String testName = information.substring(information.lastIndexOf(":")+1);
				String componentName = information.substring(0,information.lastIndexOf(":"));
				if(map.containsKey(componentName))
				{
					TreeMap imap = (TreeMap) map.get(componentName);
					imap.put(testName,testPeriod);
					if(componentName.endsWith(":NULL"))
						componentName = componentName.substring(0,componentName.lastIndexOf(":"));
					auditLogThread.setCurrentValue("$test$:"+testName+EgConstants.BLANK_SPACE+"($ctype$:"+componentName+")",(String)reversePeriodMap.get(testPeriod));
					auditLogThread.setPreviousValue("$test$:"+testName+EgConstants.BLANK_SPACE+"($ctype$:"+componentName+")",(String)reversePeriodMap.get(previousTestPeriod));
				}
				else
				{
					TreeMap imap = new TreeMap();
					imap.put(testName,testPeriod);
					map.put(componentName,imap);
					if(componentName.endsWith(":NULL"))
						componentName = componentName.substring(0,componentName.lastIndexOf(":"));
					auditLogThread.setCurrentValue("$test$:"+testName+EgConstants.BLANK_SPACE+"($ctype$:"+componentName+")",(String)reversePeriodMap.get(testPeriod));
					auditLogThread.setPreviousValue("$test$:"+testName+EgConstants.BLANK_SPACE+"($ctype$:"+componentName+")",(String)reversePeriodMap.get(previousTestPeriod));
				}
			}
%>
			<jsp:useBean id="serviceBean" scope="request" class="egurkha.ServiceBean"/>
<%
			//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
			IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
			serviceBean.stopDiscovery();
			UpdateCompositeTestPeriod updateTestPeriod = new UpdateCompositeTestPeriod();
			updateTestPeriod.updateTestPeriod(map);
			serviceBean.startDiscovery("1");
			EgConfigFilesSync.releaseInstance(infraIni);

			/* code for auditlog starts */
			auditLogThread.setValue("Description","Composite tests periods have been updated");
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
		}
	}
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgCompositeInfo compositeInfo = new EgCompositeInfo("manager");
	Vector vars = compositeInfo.getVariables("TEST_COMP_TYPE_LAYER_MAPPING",true);
	Vector vals = compositeInfo.getAllValues("TEST_COMP_TYPE_LAYER_MAPPING");
	Vector serverTypes = new Vector();
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());
	if(vals != null)
	{
		for(int i=0;i<vals.size();i++)
		{
			String type = (String)vals.get(i);
			type = type.substring(0,type.indexOf("#"));
			if(!listComponentTypes.contains(type))
			{
				continue;
			}
			if(serverTypes.contains(type))
			{
				continue;
			}
			serverTypes.add(type);
		}
	}
	for(int i=serverTypes.size()-1;i>=0;i--)
		if(discInfo.getAllServersOfType((String) serverTypes.get(i)).length==0)
			serverTypes.remove(i);
	String selectedServer = request.getParameter("selectedServer");
	if(StringUtils.isNull(selectedServer))
		selectedServer = "-1";
	TreeMap periodMap = new TreeMap();
	if(!EgUtils.isNull((Object) testFormatPeriod))
	{
		for (int i=0;i<testFormatPeriod.length;i++)
		{
			String secondsStr = uiIni.getValue("TEST_FREQUENCY", testFormatPeriod[i]);
			long seconds = Long.parseLong(secondsStr);
			periodMap.put(new Long(seconds), testFormatPeriod[i]);
		}
	}

	TreeMap localSettings = new TreeMap();
	String selectedComponent = request.getParameter("selectedComponent");
	if(StringUtils.isNull(selectedComponent))
		selectedComponent = "-1";
	String userLanguage = _user.getLanguage();
	if(userLanguage == null)
		userLanguage = IniUI.getInstance().getDefaultLanguage();
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	ArrayList serverList = new ArrayList(serverTypes);
	serverList = sorter.getSortedCompTypeList(serverList);
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	String test_component = request.getParameter("test_component");
	String selectedTest = null;
	if(!StringUtils.isNull(test_component))
	{
		selectedTest = test_component.substring(0,test_component.indexOf(":"));
		selectedComponent = test_component.substring(test_component.indexOf(":")+1);
		selectedServer = selectedComponent.substring(0,selectedComponent.indexOf(":"));
	}
	if(serverList != null && serverList.size()>0)
	{
		commonObjectType.put("displayField",mappingInfo.getTextDescription("admin.common.Choose a component type"));
		commonObjectType.put("valueField","-1");
		arrayType.add(commonObjectType);
	}
	else
	{
		commonObjectType.put("displayField",mappingInfo.getTextDescription("admin.common.Not applicable"));
		commonObjectType.put("valueField","-1");
		arrayType.add(commonObjectType);
	}
	if(serverList != null && serverList.size()>1)
	{
		commonObjectType.put("displayField",mappingInfo.getTextDescription("admin.common.ALL"));
		commonObjectType.put("valueField","all");
		arrayType.add(commonObjectType);
	}
	for(int i=0;i<serverList.size();i++)
	{
		EgName nameObj = (EgName)serverList.get(i);
		String serverName = nameObj.getActualName();
		String displayName = nameObj.getLocalName();
		localSettings.put(serverName,displayName);

		commonObjectType.put("displayField",displayName);
		commonObjectType.put("valueField",serverName);
		arrayType.add(commonObjectType);
	}
	rootJson.put("ComponentTypeList",arrayType);
	if(serverList != null && serverList.size()>0)
	{
		commonObjectName.put("displayField",mappingInfo.getTextDescription("admin.common.Choose a component name"));
		commonObjectName.put("valueField","-1");
		arrayName.add(commonObjectName);
	}
	else
	{
		commonObjectName.put("displayField",mappingInfo.getTextDescription("admin.common.Not applicable"));
		commonObjectName.put("valueField","-1");
		arrayName.add(commonObjectName);

	}
	String componentNames[] = null;
	if(selectedServer.equalsIgnoreCase("all"))
	{
		Vector allComponents = new Vector();
		for(int i=serverTypes.size()-1;i>=0;i--)
		{
			String components[] = discInfo.getAllServersOfType(serverTypes.get(i).toString());
			if(components != null && components.length>0)
				allComponents.addAll(java.util.Arrays.asList(components));
		}
		Collections.sort(allComponents);
		componentNames = (String[])allComponents.toArray(new String[allComponents.size()]);
	}
	else
		componentNames = discInfo.getAllServersOfType(selectedServer);
	if(componentNames != null && componentNames.length>1)
	{
		commonObjectName.put("displayField",mappingInfo.getTextDescription("admin.common.ALL"));
		commonObjectName.put("valueField","all");
		arrayName.add(commonObjectName);
	}
	String disp = null;
	for(int i=0;i<componentNames.length;i++)
	{
		String componentName = componentNames[i];
		int firstIndex = componentName.indexOf(":");
		String compType = componentName.substring(0,firstIndex);
		String nickName = componentName.substring(firstIndex+1,componentName.lastIndexOf(":"));
		String groupName = mappingInfo.getComponentTypeDescription(compType);
		if(selectedServer.equalsIgnoreCase("all"))
		{
			commonObjectName.put("displayField",nickName);
			commonObjectName.put("valueField",componentName);
			commonObjectName.put("groupField",groupName);
			arrayName.add(commonObjectName);
		}
		else
		{
			commonObjectName.put("displayField",nickName);
			commonObjectName.put("valueField",componentName);
			commonObjectName.put("groupField",groupName);
			arrayName.add(commonObjectName);
		}
	}
	rootJson.put("ComponentNameList",arrayName);

	boolean showUpdateButton = false;
	JSONArray gridData2 = new JSONArray();
	JSONArray gridColumns = new JSONArray();
	if(!selectedComponent.equals("-1"))
	{
		UpdateCompositeTestPeriod updateTestPeriod = new UpdateCompositeTestPeriod();
		TreeMap details = new TreeMap();
		if(selectedComponent.equalsIgnoreCase("all"))
			updateTestPeriod.setComponentTestMapping(selectedServer,"all");
		else
			updateTestPeriod.setComponentTestMapping(selectedServer,selectedComponent);
		details = updateTestPeriod.getComponentTestMapping();
		Iterator detailsItr = details.keySet().iterator();
		int i=0;
		int columnCount = 0;
		while(detailsItr.hasNext())
		{
			JSONArray gridData = new JSONArray();
			showUpdateButton = true;
			String component = (String) detailsItr.next();
			String displayComponent = component.substring(component.indexOf(":")+1,component.lastIndexOf(":"));
			String localStr = (String) localSettings.get((String)component.substring(0,component.indexOf(":")));

			JSONObject gridCols = new JSONObject();
			gridCols.put("col_1",displayComponent);
			gridCols.put("col_4", "");// for current test period
			gridCols.put("col_2",component);
			gridCols.put("col_3","");// for recommended test period
			gridColumns.add(gridCols);
			columnCount++;
			if(i==0)
			{
				i=1;
			}
			TreeMap innerDetails = (TreeMap) details.get(component);
			Iterator innerDetailsItr = innerDetails.keySet().iterator();
			ArrayList testList = new ArrayList(innerDetails.keySet());
			testList = sorter.getSortedTestList(testList);
			for(int c=0;c<testList.size();c++)
			{
				JSONObject testsForSelComponent1 = new JSONObject();
				EgName nameObj = (EgName)testList.get(c);
				String testName = nameObj.getActualName();
				String displayName = nameObj.getLocalName();
				String frequencyStr = (String) innerDetails.get(testName);
				String perviousFrequency = "";
				if(frequencyStr != null && frequencyStr.indexOf("#") > 0)
				{
					perviousFrequency= frequencyStr.substring(0,frequencyStr.indexOf("#"));
					frequencyStr = frequencyStr.substring(frequencyStr.indexOf("#")+1);
				}
				long frequency = Integer.parseInt(frequencyStr);

				String status = (selectedTest != null && testName.equals(selectedTest))?"checked":"";
				String display1 = (String) periodMap.get(Long.parseLong(perviousFrequency));
				String numeric1 = display1.substring(0,display1.indexOf(EgConstants.BLANK_SPACE));
				String str1 = "admin.common."+display1.substring(display1.indexOf(EgConstants.BLANK_SPACE)+1);
				String periods1 = numeric1+" "+display1.substring(display1.indexOf(EgConstants.BLANK_SPACE)+1);
				testsForSelComponent1.put("col_4", periods1);
				testsForSelComponent1.put("col_3",testName);
				testsForSelComponent1.put("col_1", displayName);
				Iterator itr = periodMap.keySet().iterator();
				JSONArray arrayTime1 = new JSONArray();
				String tmpStr = "";
				while(itr.hasNext())
				{
					JSONObject commonObjectTime1 = new JSONObject();
					Long seconds = (Long) itr.next();
					String display = (String) periodMap.get(seconds);
					String numeric = display.substring(0,display.indexOf(EgConstants.BLANK_SPACE));
					String str = "admin.common."+display.substring(display.indexOf(EgConstants.BLANK_SPACE)+1);
					String periods = numeric+" "+display.substring(display.indexOf(EgConstants.BLANK_SPACE)+1);
					if(seconds.longValue()<frequency)
						continue;

					if (tmpStr.length() == 0)
					{
						testsForSelComponent1.put("col_2",periods);
						tmpStr = periods;
					}
					commonObjectTime1.put("displayField",periods);
					commonObjectTime1.put("valueField",periods);
					arrayTime1.add(commonObjectTime1);
				}
				rootJson.put("TimePeriodList_"+columnCount+"_"+c,arrayTime1);
				gridData.add(testsForSelComponent1);
			}
			gridData2.add(gridData);
		}
	}
	rootJson.put("gridData2",gridData2);
	rootJson.put("gridColumns",gridColumns);
	if(request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/compositeUpdateTestPeriod.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/compositeUpdateTestPeriod.jsp");
	}
	out.println(rootJson.toString());
%>