<%
/*******************************************************************************
 *      File name               :   EgAssignAgentsJson.jsp
 *      Purpose                 :   To assign agent to redundant managers
 ******************************************************************************/
%>

<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgManagersIniForManager"%>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	String primaryIP = null;
	EgManagersIniForManager managerIni = EgManagersIniForManager.getInstance();
	primaryIP = managerIni.getPrimaryManagerIP();
	rootJson.put("primaryManagerIP",primaryIP);

	String[] managerIPs = managerIni.getAllManagerIPs();
	String s_manager = request.getParameter("manager_IP");

	if(s_manager == null || s_manager.equals("null"))
	{
		s_manager=managerIPs[0];
	}

	// Contains Hashtable of Hashtables...of the form <mgrip> = [<agentip>={nick1,nick2,nick3}]
	Hashtable mgrAgentMapForUI = managerIni.getManagerAgentMap();

	if(s_manager != null && !s_manager.equals("null"))
	{
		screenLabels.put("admin.agents.Manager",_mapping.getTextDescription("admin.agents.Manager"));
	}
	else
	{
		screenLabels.put("admin.agents.Manager",_mapping.getTextDescription("admin.agents.Select a Manager"));
	}

	String label = " SECONDARY MANAGER";
	if( s_manager != null && !s_manager.equals("null") && s_manager.trim().equals(primaryIP.trim()))
	{
		label = " PRIMARY MANAGER";
	}
	screenLabels.put("admin.agents.AGENTS ASSIGNED TO",_mapping.getTextDescription("admin.agents.AGENTS ASSIGNED TO")+label);
	screenLabels.put("admin.agents.AGENTS ASSIGNED TO OTHER MANAGERS",_mapping.getTextDescription("admin.agents.AGENTS ASSIGNED TO OTHER MANAGERS"));

	screenLabels.put("admin.common.Update",_mapping.getTextDescription("admin.common.Update"));

	JSONArray managerChosenArr = new JSONArray();
	JSONObject managerChosenObj = new JSONObject();
	for(int i=0;i < managerIPs.length; i++)
	{
		String strCaption = _mapping.getTextDescription("admin.agents.Secondary");
		if (primaryIP != null && primaryIP.trim().equals(managerIPs[i].trim()))
		{
			strCaption = _mapping.getTextDescription("admin.agents.Primary");
		}

		if (s_manager.equals(managerIPs[i]))
		{
			managerChosenObj.put("displayField", managerIPs[i]+" ("+strCaption+") ");
			managerChosenObj.put("valueField", managerIPs[i]);
			managerChosenArr.add(managerChosenObj);
		}
		else
		{
			managerChosenObj.put("displayField", managerIPs[i]+" ("+strCaption+") ");
			managerChosenObj.put("valueField", managerIPs[i]);
			managerChosenArr.add(managerChosenObj);
		}
	}
	rootJson.put("managerChosenArr",managerChosenArr);

	JSONArray assignedAgents = new JSONArray();
	JSONArray agentsForThisMgr = new JSONArray();
	JSONObject agentsForThisMgrObj = new JSONObject();
	HashSet agentForThisMgr = (HashSet)mgrAgentMapForUI.get(s_manager);
	if(agentForThisMgr != null)
	{
		Object [] nicksArray = agentForThisMgr.toArray();
		Arrays.sort(nicksArray);
		for(int y=0; y < nicksArray.length; y++)
		{
			assignedAgents.add(nicksArray[y]);

			agentsForThisMgrObj.put("displayField",nicksArray[y]);
			agentsForThisMgrObj.put("valueField",nicksArray[y]);
			agentsForThisMgr.add(agentsForThisMgrObj);
		}
	}
	rootJson.put("agentsForThisMgr",agentsForThisMgr);
	rootJson.put("assignedAgents",assignedAgents);

	JSONArray agentsForOtherMgr = new JSONArray();
	JSONObject agentsForOtherMgrObj = new JSONObject();
	JSONArray unAssignedAgentsArray = new JSONArray();
	JSONArray unAssignedAgents = new JSONArray();
	JSONObject unAssignedObject = new JSONObject();
	for(Enumeration e1=mgrAgentMapForUI.keys(); e1.hasMoreElements();)
	{
		String s_otherManagers = (String)e1.nextElement();
		if(s_otherManagers.equals(s_manager))
			continue;
		agentForThisMgr = (HashSet)mgrAgentMapForUI.get(s_otherManagers);
		if(agentForThisMgr != null)
		{
			Object [] nicksArray = agentForThisMgr.toArray();
			Arrays.sort(nicksArray);
			for(int y=0; y < nicksArray.length; y++)
			{
				unAssignedObject.put("displayField",nicksArray[y]);
				unAssignedObject.put("valueField",nicksArray[y]);
				unAssignedAgents.add(unAssignedObject);

				agentsForOtherMgrObj.put("displayField",nicksArray[y]);
				agentsForOtherMgrObj.put("valueField",nicksArray[y]);
				agentsForOtherMgr.add(agentsForOtherMgrObj);
			}
		}
	}
	rootJson.put("agentsForOtherMgr",agentsForOtherMgr);
	rootJson.put("unAssignedAgents",unAssignedAgents);

	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgAssignAgents.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgAssignAgents.jsp");
	}

	rootJson.put("screenLabels",screenLabels);
	System.out.println("rootJson_______"+rootJson);
	out.println(rootJson.toString());
%>



