<%
/*
*		Name			:	EgHostCheck.jsp
*		Purpose			:	To list the host names given for a particular ip address and check if the given hostname is present in the host names list.
							If present we alert the user about the hostname and ask for confirmation for using the same host name for the server or not.
*		CreationDate	:	18/12/2001
*/
%>
<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	JSONObject  hiddens = new JSONObject();
	IniFile egdisc = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_discover.ini");
	IniFile extIni = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_external.ini");
	Vector temp_v_host_name = null;
	Vector v_host_name = new Vector();
	Vector v_host_name_nocase = new Vector();
	//component case issue. dont allow components to have same name with different case
	EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
	ArrayList al_all_hosts=egDiscInfo.getAllHostsWithPort();
	String s_host_ip = "";
	String s_host_name = "";
	s_host_ip = request.getParameter("hostip");
	s_host_name = request.getParameter("hostname");
	String isRum = request.getParameter("isRumServer");
	String rumAgent = request.getParameter("rumRemAgent");
	String rumURL = request.getParameter("rumUrl");
	String dispCompName = request.getParameter("dispCompName");
	String mserver = request.getParameter("modifyserver");
	boolean isRumServer = false;
	boolean isNodeServer = false;
	String monitorLastSession="";
	String newUrlLink="";
	String strCompType="";
	String strHostName="";
	String oldNick="";

	if(isRum != null && isRum != "")
	{
		if(isRum.equals("yes"))
		{
			isRumServer = true;
			s_host_ip = "0.0.0.0";
			s_host_name = request.getParameter("rumNickName");
		}
	}

	String s_server_name = request.getParameter("server");
	String s_server_type = request.getParameter("stype");
	if(s_server_type != null && s_server_type.equalsIgnoreCase("nodejs"))
	{
		isNodeServer = true;
	}
	String s_sid=request.getParameter("sid");
	String oldhostname = request.getParameter("oldhostname");
	String port_for_asset = request.getParameter("hportno");
	String sPortNo = request.getParameter("sportno");
	if (s_server_name!= null && s_server_name.equalsIgnoreCase("new"))
		port_for_asset = sPortNo;

	//Nickname formation with suffix for special comp types
	String[] splCompArr = new String[]{"MS_Office_365","Microsoft_Sharepoint_Online","MSExchangeOnline","MS_Skype_Online"};
	ArrayList splCompList = new ArrayList(Arrays.asList(splCompArr));
	if (splCompList.contains(s_server_type))
	{
		String hostnameSuffix = request.getParameter("hostnameSuffix");
		s_host_name = (hostnameSuffix != null && hostnameSuffix.length()>0) ? (s_host_name + hostnameSuffix) : s_host_name;
	}

	String lowerCaseHostName=request.getParameter("lowerCaseHostName");
	String newHostName = request.getParameter("newHostName");
	String siteflag = request.getParameter("siteflag");
	String treeViewSrc = request.getParameter("treeViewSrc");
	String fromResultPage = request.getParameter("fromResultPage");
	String serverNameWithPort = s_host_name;

	String[] nickAloneTypes = extIni.getVariables("NickName_Alone_Servers");
	List nickAloneTypesList = new ArrayList();
	if (nickAloneTypes != null)
	{
		nickAloneTypesList = Arrays.asList(nickAloneTypes);
	}
	if (nickAloneTypesList.contains(s_server_type) && (s_host_ip == null || s_host_ip.trim().equals("")) )
	{
		s_host_ip = s_host_name;
	}

	if (s_server_name != null && s_server_name.equals("new"))
	{
		oldhostname = "";
	}
	boolean isModifyServer = false;
	if(mserver != null && mserver.equals("true"))
	{
		isModifyServer = true;
	}
	if (port_for_asset == null || port_for_asset == "null")
		serverNameWithPort = s_host_name+":NULL";
	else
		serverNameWithPort = s_host_name+":"+port_for_asset;

	String selectedServerGroup = request.getParameter("selectedServerGroup");
	if (selectedServerGroup == null)
	{
		selectedServerGroup = "";
	}
	String frmTopology = request.getParameter("frmTopology");
	String topoSegName = request.getParameter("topoSegName");
	String initialPortNo = request.getParameter("portnumber");
	if (lowerCaseHostName!=null && lowerCaseHostName.equals("true"))
		s_host_name = newHostName;

	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	Vector aggTypes = aggregateInfo.getAggregateTypes();
	boolean exist=false;

	egurkha.EgUIUtils uiUtils = new egurkha.EgUIUtils();
	v_host_name = uiUtils.getAllHostsForIp(s_host_ip,s_host_name);

	Vector ext = externalInfo.getAllExternalHostsForIP(s_host_ip,s_host_name);
	Vector rem = externalInfo.getAllRemoteHostsForIP(s_host_ip,s_host_name);

	if(v_host_name == null)
		v_host_name = new Vector();

	temp_v_host_name = new Vector(v_host_name);

	if(ext != null)
		temp_v_host_name = getUniqueHosts(temp_v_host_name,ext);

	if(rem != null)
		temp_v_host_name = getUniqueHosts(temp_v_host_name,rem);


	if (v_host_name!=null)
	{
		for (int i=0; i<v_host_name.size(); i++)
		{
			String thisName = ((String)v_host_name.get(i)).toLowerCase();
			v_host_name_nocase.add(thisName);
		}
	}

	int nameIndex = v_host_name_nocase.indexOf(s_host_name.toLowerCase());

	if(v_host_name.size() > 0)
	{
		for(int vi=0;vi<v_host_name.size();vi++)
		{
			String host_na=(String)v_host_name_nocase.get(vi);
			exist=s_host_name.toLowerCase().equalsIgnoreCase(host_na);
			if(exist)
				break;
		}
	}
	if(isRumServer || isNodeServer)
		v_host_name_nocase = new Vector();
	if(!exist)
	{
		for(int vi=0;vi<temp_v_host_name.size();vi=vi+2)
		{
			String host_na=(String)temp_v_host_name.get(vi);
			exist=s_host_name.equalsIgnoreCase(host_na);
			if(exist)
			{
				nameIndex = (nameIndex == -1?vi:nameIndex);
				break;
			}
		}
	}


	boolean nickManaged =false;
	Hashtable nickIPMap=egDiscInfo.getNickIpMap();

	ArrayList allNicks=egDiscInfo.getAllNicks();
	boolean newNickAdded = !allNicks.contains(s_host_name.toLowerCase());
	Enumeration keys = nickIPMap.keys();
	while (keys.hasMoreElements())
	{
		String thisKey = (String) keys.nextElement();
		if (thisKey.equalsIgnoreCase(s_host_name))
		{
			String thisIp = (String)nickIPMap.get(thisKey);
			if (!thisIp.equals(s_host_ip))
			{
				nickManaged = true;
			}
		}
	}
	ArrayList allNicksList = new ArrayList(nickIPMap.keySet());
	boolean isCompAlreadyExist = egDiscInfo.isComponentExist(s_server_type,serverNameWithPort);

	String user_id = _user.getLoginID();
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),user_id);
	EgUuidInfo uuidInfo = new EgUuidInfo();
	EgCertUsage egCertUsage = new EgCertUsage();
	ArrayList usersList = egCertUsage.getAllLimitedCompAccessUsers(true);
	boolean isLimitedAdmin = (usersList != null && usersList.contains(user_id));
	boolean isMspModel = EgUuidInfo.isMspModel();
	boolean shareNickAcrossOU = EgUuidInfo.shareNickAcrossOU();
	ArrayList allCompNicks = egRoleInfo.getAllServerNicks();
	boolean isNickShared = false;

	if(isMspModel && !shareNickAcrossOU)
	{
		ArrayList usersSharedAgents = new ArrayList();
		Hashtable orgUsersNickMap = uuidInfo.getAllUsersNickMap(true,true);
		String s_host_name_LowerCase = s_host_name.toLowerCase();
		if(orgUsersNickMap != null)
		{
			String user_name = user_id;
			if(!orgUsersNickMap.containsKey(user_name))
			{
				user_name = uuidInfo.getSuperOU(user_id);
			}
			if(user_name != null && (!user_id.equalsIgnoreCase("admin")))
			{
				Enumeration enu = orgUsersNickMap.keys();
				while(enu.hasMoreElements())
				{
					String orgName = (String)enu.nextElement();
					if(!orgName.equalsIgnoreCase(user_name))
					{
						Vector nickList = (Vector)orgUsersNickMap.get(orgName);
						if(nickList != null)
						{
							Vector nicksListLower = new Vector();
							int nicListSize = nickList.size();
							for (int a=0; a < nicListSize; a++)
							{
								String nickLower = nickList.get(a).toString().toLowerCase();
								nicksListLower.add(nickLower);
							}
							if(nicksListLower.contains(s_host_name_LowerCase))
							{
								usersSharedAgents.add(orgName);
							}
						}
					}
				}
			}
		}
		if(usersSharedAgents != null && usersSharedAgents.size() > 0)
		{
			isNickShared = true;
			String super_org = uuidInfo.isSuperOrg(user_id) ? user_id : uuidInfo.getSuperOU(user_id);
			String suggested_nick = uuidInfo.getUniqueNickName(egDiscInfo,s_host_name);

			rootJSON.put("requestStatus","failed");
			JSONObject obj = new JSONObject();
			obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
			obj.put("error_Msg_Count","2");

			rootJSON.put("error_type","confirmNickSuggestion");
			obj.put("error_Msg_1",_mapping.getTextDescription("admin.error.The nick name")+" ("+s_host_name+") "+_mapping.getTextDescription("admin.error.you are trying to add/modify is already existing")+". ");
			obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.Would you like to use the nick name")+" '"+suggested_nick+"'?");

			obj.put("IP",s_host_ip);
			obj.put("nickName",suggested_nick);

			String url = "EgnewserverpJson.jsp?action=singleserver&hostname="+EgURLEncoder.encode(suggested_nick,"UTF-8")+"&"+request.getQueryString()+"&treeViewSrc="+treeViewSrc+"&servertype="+EgURLEncoder.encode(s_server_type,"UTF-8")+"&servername="+EgURLEncoder.encode(serverNameWithPort,"UTF-8")+"&hostIp="+s_host_ip+"&oldhostname="+EgURLEncoder.encode(oldhostname,"UTF-8");
			if(frmTopology!=null && frmTopology.equals("yes"))
			{
				url = url + "&topoSegName="+EgURLEncoder.encode(topoSegName,"UTF-8")+"&initPort="+initialPortNo;
			}
			obj.put("forward_URL",url);
			rootJSON.put("error_Info",obj);

			hiddens.put("treeViewSrc",treeViewSrc);
			hiddens.put("fromResultPage",fromResultPage);
			hiddens.put("server_type",s_server_type);
			hiddens.put("initPort",initialPortNo);
			Enumeration en = request.getParameterNames();
			while(en.hasMoreElements())
			{
				String name = (String)en.nextElement();
				String [] val2 = request.getParameterValues(name);
				String val ="";
				if (val!=null && val2.length==1)
					val = request.getParameter(name);
				else
					val = com.egurkha.util.StringUtils.getUniqueArrayAsString(val2);
				hiddens.put(name,val);
			}
			rootJSON.put("hiddenValues",hiddens);
			out.println(rootJSON);
			return;
		}
	}
	if (!isNickShared && !newNickAdded && !isCompAlreadyExist && !isModifyServer) // Existing nick name
	{
		if (!allNicksList.contains(s_host_name)) // Existing nick name but case differs
		{
			ArrayList allNicksListLower = new ArrayList();
			for (int a=0; a < allNicksList.size(); a++)
			{
				String nickLower = allNicksList.get(a).toString().toLowerCase();
				allNicksListLower.add(nickLower);
			}
			int idx = allNicksListLower.indexOf(s_host_name.toLowerCase());
			if (idx > -1)
			{
				String existingNick = allNicksList.get(idx).toString();
				String existingIP = nickIPMap.get(existingNick).toString();

				rootJSON.put("requestStatus","failed");
				rootJSON.put("error_type","confirm");
				JSONObject obj = new JSONObject();
				obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
				obj.put("error_URL","");
				obj.put("error_Msg_Count","2");
				obj.put("error_Msg_1",_mapping.getTextDescription("admin.error.The nick name")+" ("+s_host_name+") "+_mapping.getTextDescription("admin.error.you are trying to add is already associated in the following manner")+".");
				obj.put("IP",existingIP);
				obj.put("nickName",existingNick);
				obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.Do you wish to use this existing  Host IP/name and Nick name for the component")+"?");
				String	ur = "EgnewserverpJson.jsp?action=singleserver&hostname="+EgURLEncoder.encode(existingNick,"UTF-8")+"&"+request.getQueryString()+"&treeViewSrc="+treeViewSrc+"&servertype="+EgURLEncoder.encode(s_server_type,"UTF-8")+"&servername="+EgURLEncoder.encode(serverNameWithPort,"UTF-8")+"&hostIp="+existingNick+"&oldhostname="+EgURLEncoder.encode(oldhostname,"UTF-8");
				if(frmTopology!=null && frmTopology.equals("yes"))
				{
					ur = ur + "&topoSegName="+EgURLEncoder.encode(topoSegName,"UTF-8")+"&initPort="+initialPortNo;
				}

				obj.put("forward_URL",ur);
				rootJSON.put("error_Info",obj);

				hiddens.put("treeViewSrc",treeViewSrc);
				hiddens.put("fromResultPage",fromResultPage);
				hiddens.put("server_type",s_server_type);
				hiddens.put("initPort",initialPortNo);

				Enumeration en = request.getParameterNames();
				while(en.hasMoreElements())
				{
					String name = (String)en.nextElement();
					String [] val2 = request.getParameterValues(name);
					String val ="";
					if (val!=null && val2.length==1)
						val = request.getParameter(name);
					else
						val = com.egurkha.util.StringUtils.getUniqueArrayAsString(val2);
					hiddens.put(name,val);
				}

				rootJSON.put("hiddenValues",hiddens);
				out.println(rootJSON);
				return;
			}
		}
	}
	else if (!isNickShared && isModifyServer)
	{
		oldNick = oldhostname;
		String newNick = s_host_name;
		String newNickLower = s_host_name.toLowerCase();

		monitorLastSession=(String)session.getAttribute("monitorLastSession");
		String urlLink = "";
		if(monitorLastSession!=null && monitorLastSession.trim().length()>0)
		{
			if(monitorLastSession.indexOf('?') == -1)
			{
				newUrlLink=monitorLastSession;
			}
			else
			{
				newUrlLink=monitorLastSession.substring(0,monitorLastSession.indexOf('?'));
				urlLink = monitorLastSession.substring(monitorLastSession.indexOf('?')+1);
			}

			if(urlLink!=null && urlLink.trim().length()>0)
			{
				StringTokenizer multiTokenizer = new StringTokenizer(urlLink,"&");
				while(multiTokenizer.hasMoreTokens())
				{
					String param = multiTokenizer.nextToken();
					int ind = param.indexOf("=");
					if (ind < 0)
						continue;
					String reqparam =param.substring(0,ind);
					String paramValue = param.substring(ind+1);

					if(reqparam != null && reqparam.equals("comptype"))
					{
						String compType = paramValue;
						if(compType != null && compType.trim().length()>0)
						{
							strCompType=com.eg.EgURLDecoder.decode(compType, "UTF-8");
						}
					}
					else if(reqparam.equals("host"))
					{
						String hostValue = paramValue;
						if(hostValue != null && hostValue.trim().length()>0)
						{
							String hostName=com.eg.EgURLDecoder.decode(hostValue, "UTF-8");
							if(hostName.indexOf(':') == -1)
							{
								strHostName=hostName;
							}
							else
							{
								strHostName=hostName.substring(0,hostName.indexOf(':'));
							}
						}
					}
				}
			}
		}


		ArrayList allNicksLower = new ArrayList();
		for (int a=0; a<allNicksList.size(); a++)
		{
			String nick = allNicksList.get(a).toString().toLowerCase();
			allNicksLower.add(nick);
		}
		if (oldNick.equalsIgnoreCase(newNick))
		{
			if (allNicksLower.contains(newNickLower) && !allNicksList.contains(newNick))
			{
				String existing = allNicksList.get(allNicksLower.indexOf(newNickLower)).toString();
				rootJSON.put("requestStatus","failed");
				rootJSON.put("error_type","alert");
				JSONObject obj = new JSONObject();
				obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
				obj.put("error_Msg_Count","2");
				obj.put("error_Msg_1",_mapping.getTextDescription("admin.error.The nick name")+" ("+newNick+") "+_mapping.getTextDescription("admin.error.you are trying to add is already existing in different case")+" ("+existing+"). ");
				obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.Please choose a different nick name"));
				rootJSON.put("error_Info",obj);
				out.println(rootJSON);
				return;
			}
		}
	}

	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Add/Modify Servers");
	auditLogThread.setValue("Activity","Server Configuration");

	String vars[] = egdisc.getVariables(s_server_type);
	ArrayList newUnmangeNicks = new ArrayList();
	if (vars != null)
	{
		for(int k=0; k<vars.length; k++)
		{
			String var = vars[k];
			if(var.startsWith("#"))
			{
				StringTokenizer st = new StringTokenizer(var,":");
				st.nextToken(); // Type
				String nick = st.nextToken();
				nick =nick.toLowerCase();
				if (!newUnmangeNicks.contains(nick))
				{
					newUnmangeNicks.add(nick);
				}
			}
		}
	}
	String nickAlone = s_host_name;
	int colonIdx1 = nickAlone.indexOf(":");
	if (colonIdx1 > 0)
	{
		nickAlone = nickAlone.substring(0,colonIdx1);
	}
	String[] remComps = externalInfo.getRemoteComponents();
	ArrayList agentlessCompsList = new ArrayList();
	if(remComps != null)
	{
		agentlessCompsList = new ArrayList(Arrays.asList(remComps));
	}
	ArrayList extCompsList = egDiscInfo.getAllExternalHosts();
	ArrayList agentBasedCompsList = egDiscInfo.getAllComponentNicks(false);
	agentBasedCompsList.removeAll(agentlessCompsList);
	agentBasedCompsList.removeAll(extCompsList);
	agentBasedCompsList.removeAll(newUnmangeNicks);
	String remoteType = request.getParameter("enableRemoteAgent");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	String[] externalTypes = specsInfo.getAllExternalServerTypes();
	ArrayList extTypesList = new ArrayList();
	if (externalTypes != null)
	{
		extTypesList = new ArrayList(Arrays.asList(externalTypes));
	}
	boolean isExternalComp = false;
	boolean isAgentlessComp = false;
	boolean isAgentBasedComp = false;
	if (extTypesList.contains(s_server_type))
	{
		isExternalComp = true;
	}
	if (remoteType != null && remoteType.equalsIgnoreCase("true"))
	{
		isAgentlessComp = true;
	}
	if (!isExternalComp && !isAgentlessComp)
	{
		isAgentBasedComp = true;
	}

	boolean canCheck = true;
	if(!isNickShared && isModifyServer)
	{
		List servTypesList = egDiscInfo.getServerTypesForNick(nickAlone);
		if(servTypesList != null && servTypesList.size() < 2 && servTypesList.contains(s_server_type))
		{
			canCheck = false;
		}
	}
	if(canCheck)
	{
		if(agentlessCompsList.contains(nickAlone) && (isAgentBasedComp || isExternalComp))
		{
			rootJSON.put("requestStatus","failed");
			rootJSON.put("error_type","alert");
			JSONObject obj = new JSONObject();
			obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
			obj.put("error_Msg_Count","2");
			obj.put("error_Msg_1",_mapping.getTextDescription("admin.server.Possible reason")+":");
			if (isModifyServer)
			{
				obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.You cannot change the monitoring approach of this component, because its nick name has already been assigned to an agentless component")+".");
			}
			else
			{
				obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.You are trying to add a component with a nick name that has already been assigned to an agentless component")+". "+_mapping.getTextDescription("admin.server.Please use a different nick name")+".");
			}
			rootJSON.put("error_Info",obj);
			out.println(rootJSON);
			return;
		}
		else if (isAgentlessComp && (agentBasedCompsList.contains(nickAlone) || extCompsList.contains(nickAlone)))
		{
			rootJSON.put("requestStatus","failed");
			rootJSON.put("error_type","alert");
			JSONObject obj = new JSONObject();
			obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
			obj.put("error_Msg_Count","2");
			obj.put("error_Msg_1",_mapping.getTextDescription("admin.server.Possible reason")+":");
			if (isModifyServer)
			{
				obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.You cannot change the monitoring approach of this component, because its nick name has already been assigned to an agent-based or network component")+".");
			}
			else
			{
				obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.You are trying to add a component with a nick name that has already been assigned to an agent-based or network component")+". "+_mapping.getTextDescription("admin.server.Please use a different nick name")+".");
			}
			rootJSON.put("error_Info",obj);
			out.println(rootJSON);
			return;
		}
	}

	if(s_server_name != null && s_host_name != null && (s_server_name.equals("new") || isModifyServer) && IniUI.isEgReservedKeyword(s_host_name))
	{
		rootJSON.put("requestStatus","failed");
		rootJSON.put("error_type","alert");
		JSONObject obj = new JSONObject();
		obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
		if(!StringUtils.isNull(treeViewSrc))
		{
			obj.put("error_URL","EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);
		}
		else
		{
			obj.put("error_URL","EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&selectedServerGroup="+selectedServerGroup);
		}
		obj.put("error_Msg_Count","2");
		obj.put("error_Msg_1",_mapping.getTextDescription("admin.server.Possible reason")+":");
		obj.put("error_Msg_2","'"+s_host_name+"' "+_mapping.getTextDescription("admin.server.is an eG defined keyword choose another name")+".");
		rootJSON.put("error_Info",obj);
		out.println(rootJSON);
		return;
	}
	Hashtable unhtNick = new Hashtable();
	Hashtable unht = new Hashtable();
	Vector unmanagedComps = new EgDiscInfo2("manager").getAllUnManagedComponents();
	if(unmanagedComps != null)
	{
		for(int i=0;i<unmanagedComps.size();i++)
		{
			String compName = (String)unmanagedComps.get(i);
			if(compName.startsWith("Agg_"))
			{
				int idx = compName.indexOf(":");
				String compType = compName.substring(0,idx);
				String compNick = compName.substring(idx+1,compName.lastIndexOf(":"));
				unhtNick.put(compNick.toLowerCase(),compType);
				if(unht.containsKey(compType))
				{
					ArrayList nlist = (ArrayList)unht.get(compType);
					nlist.add(compName);
				}
				else
				{
					ArrayList nlist = new ArrayList();
					nlist.add(compName);
					unht.put(compType,nlist);
				}
			}
		}
	}
	//testing, if new nickname is already used or not
	if(aggTypes != null && !aggTypes.isEmpty() && s_host_name != null && s_host_name.length()>0)
	{
		if(s_host_name.indexOf(":")>0)
		{
			s_host_name = s_host_name.substring(0,s_host_name.indexOf(":"));
		}
		if((s_server_name != null && s_server_name.equals("new")) || (isModifyServer && !s_host_name.equals(oldhostname)))
		{
			for(int j=0;j<aggTypes.size();j++)
			{
				String aggServerType=(String)aggTypes.get(j);
				String[] aggComps = egDiscInfo.getAllServersOfType(aggServerType);
				if(unht != null && !unht.isEmpty())
				{
					if(unht.containsKey(aggServerType))
					{
						ArrayList unComps = (ArrayList)unht.get(aggServerType);
						if(aggComps == null || aggComps.length==0)
						{
							aggComps = (String[])unComps.toArray(new String[unComps.size()]);
						}
						else
						{
							unComps.addAll(Arrays.asList(aggComps));
							aggComps = (String[])unComps.toArray(new String[unComps.size()]);
						}
					}
				}
				if(aggComps !=null)
				{
					for(int i=0;i<aggComps.length;i++)
					{
						String aggregateComponent = aggComps[i];
						String aggregateComponentNick=aggregateComponent.substring(0,aggregateComponent.lastIndexOf(":"));
						int colonIdx = aggregateComponentNick.indexOf(":");
						String aggregatecomponentType = aggregateComponentNick.substring(0,colonIdx);
						aggregateComponentNick = aggregateComponentNick.substring(colonIdx+1);
						if(aggregateComponentNick.equalsIgnoreCase(s_host_name))
						{
							rootJSON.put("requestStatus","failed");
							rootJSON.put("error_type","alert");
							JSONObject obj = new JSONObject();
							obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
							if(!StringUtils.isNull(treeViewSrc))
							{
								obj.put("error_URL","EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);
							}
							else
							{
								obj.put("error_URL","EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&selectedServerGroup="+selectedServerGroup);
							}
							obj.put("error_Msg_Count","2");
							obj.put("error_Msg_1","");
							if(aggregatecomponentType.equals(s_server_type))
							{
								obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.The nick name")+" '"+s_host_name+"' "+_mapping.getTextDescription("admin.server.is already used")+".");
							}
							else
							{
								if(unhtNick.containsKey(aggregateComponentNick.toLowerCase()))
								{
									obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.The nick name")+" '"+s_host_name+"' "+_mapping.getTextDescription("admin.server.is already used for the unmanaged component of type ")+" " + _mapping.getComponentTypeDescription((String)unhtNick.get(aggregateComponentNick.toLowerCase()))+".");
								}
								else
								{
									obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.The nick name")+" '"+s_host_name+"' "+_mapping.getTextDescription("admin.server.is already used for the component of type ")+" " + _mapping.getComponentTypeDescription(aggregatecomponentType)+".");
								}
							}
							rootJSON.put("error_Info",obj);
							auditLogThread.setCurrentValue("ColumnName","Component Not Added");
							auditLogThread.setCurrentValue("01~~Component type","$ctype$:"+s_server_type);
							auditLogThread.setCurrentValue("02~~Nick name",s_host_name);
							auditLogThread.setCurrentValue("04~~Component type in which nick name is used","$ctype$:"+aggregatecomponentType);
							if(aggregatecomponentType.equals(s_server_type))
							{
								auditLogThread.setValue("Description","Component has not been added as the nickname is already used");
							}
							else
							{
								auditLogThread.setValue("Description","Component has not been added as the nickname is already used for another aggregate component");
							}
							auditLogThread.sendItToDB();
							out.println(rootJSON);
							return;
						}
					}
				}
			}
		}
	}

	if (!(nickManaged || (v_host_name_nocase.size() > 0 && !exist)))
	{
		if(s_server_name != null && s_server_name.equalsIgnoreCase("new"))
		{
			boolean isManagedServer = false;
			String arr_comps[]=egDiscInfo.getAllServersOfType(s_server_type);
			String s_port = request.getParameter("hportno");
			if (s_server_name.equalsIgnoreCase("new"))
				s_port = sPortNo;
			String s_key ="";
			if(s_port==null) s_port = "NULL";
			if(arr_comps != null)
			{
				if(s_sid!=null && s_sid.length()>0)
				{
					s_key = s_server_type+ ":" + s_host_name + ":" + s_port + ":" + s_sid;
				}
				else
				{
					s_key = s_server_type+ ":" + s_host_name + ":" + s_port;
				}
				for(int i=0;i<arr_comps.length;i++)
				{
					if(arr_comps[i].equalsIgnoreCase(s_key))
					{
						isManagedServer = true;
						break;
					}
				}
			}
			String tmpPort = "";
			if (s_port != null && !s_port.equalsIgnoreCase("null"))
			{
				tmpPort = ":"+s_port;
			}
			if(isManagedServer)
			{
				rootJSON.put("requestStatus","failed");
				rootJSON.put("error_type","alert");
				JSONObject obj = new JSONObject();
				obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
				if(!StringUtils.isNull(treeViewSrc))
				{
					obj.put("error_URL","EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);
				}
				else
				{
					obj.put("error_URL","EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&selectedServerGroup="+selectedServerGroup);
				}
				obj.put("error_Msg_Count","2");
				obj.put("error_Msg_1","");
				obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.The component")+" '"+s_host_name+tmpPort+"' ("+_mapping.getComponentTypeDescription(s_server_type)+") "+_mapping.getTextDescription("admin.server.you are trying to add is already managed")+".");
				rootJSON.put("error_Info",obj);
				auditLogThread.setCurrentValue("ColumnName","Component Already Managed");
				auditLogThread.setCurrentValue("Component type","$ctype$:"+s_server_type);
				auditLogThread.setCurrentValue("Component name",s_host_name);
				auditLogThread.setCurrentValue("Port number",s_port);
				auditLogThread.setValue("Description","Component was not added as it had been already managed");
				auditLogThread.sendItToDB();
				out.println(rootJSON);
				return;
			}
		}

		boolean caseIssue = (nameIndex!=-1) && !temp_v_host_name.contains(s_host_name);
		UpdateAndTransmitUserInfo userinfo = new UpdateAndTransmitUserInfo();

		if ((lowerCaseHostName == null || !lowerCaseHostName.equals("true")) && caseIssue)
		{
			if (allNicks == null || !allNicks.contains(s_host_name.toLowerCase()))
			{
				removeOldEntries(newNickAdded, s_host_name, userinfo);
				rootJSON.put("requestStatus","success");
				rootJSON.put("forward",true);
				rootJSON.put("forward_URL","EgnewserverpJson.jsp?action=allservers&"+request.getQueryString()+"&treeViewSrc="+treeViewSrc+"&oldhostname="+EgURLEncoder.encode(oldhostname,"UTF-8"));
			}
		}
		else
		{
			removeOldEntries(newNickAdded, s_host_name, userinfo);
			String ur ="EgnewserverpJson.jsp?action=singleserver&hostname="+EgURLEncoder.encode(s_host_name,"UTF-8")+"&"+request.getQueryString()+"&treeViewSrc="+treeViewSrc+"&servertype="+EgURLEncoder.encode(s_server_type,"UTF-8")+"&servername="+EgURLEncoder.encode(serverNameWithPort,"UTF-8")+"&hostIp="+s_host_ip+"&oldhostname="+EgURLEncoder.encode(oldhostname,"UTF-8");
			if(frmTopology!=null && frmTopology.equals("yes"))
			{
				ur = ur + "&topoSegName="+EgURLEncoder.encode(topoSegName,"UTF-8")+"&initPort="+initialPortNo;
			}
			rootJSON.put("requestStatus","success");
			rootJSON.put("forward",true);
			rootJSON.put("forward_URL",ur);
		}
	}
	boolean notYetForwarded = true;
	if(!nickManaged && s_server_type.startsWith("Agg_"))
	{
		UpdateAndTransmitUserInfo userinfo = new UpdateAndTransmitUserInfo();
		removeOldEntries(newNickAdded, s_host_name, userinfo);
		String url ="EgnewserverpJson.jsp?action=singleserver&hostname="+EgURLEncoder.encode(s_host_name,"UTF-8")+"&"+request.getQueryString()+"&treeViewSrc="+treeViewSrc+"&oldhostname="+EgURLEncoder.encode(oldhostname,"UTF-8");
		rootJSON.put("requestStatus","success");
		rootJSON.put("forward",true);
		rootJSON.put("forward_URL",url);
		notYetForwarded = false;
	}
	hiddens.clear();
	hiddens.put("treeViewSrc",treeViewSrc);
	hiddens.put("fromResultPage",fromResultPage);
	hiddens.put("server_type",s_server_type);
	hiddens.put("initPort",initialPortNo);

	String elementModify = request.getParameter("elementModify");
	if(elementModify != null && elementModify.trim().equals("yes"))
	{
		elementModify = "yes";
	}
	else
	{
		elementModify = "no";
	}
	Enumeration en = request.getParameterNames();
	while(en.hasMoreElements())
	{
		String name = (String)en.nextElement();
		if(elementModify.equals("yes") && name.equals("hostname"))
		{
			continue;
		}
		String [] val2 = request.getParameterValues(name);
		String val ="";
		if (val!=null && val2.length==1)
			val = request.getParameter(name);
		else
			val = com.egurkha.util.StringUtils.getUniqueArrayAsString(val2);
		hiddens.put(name,val);
	}
	if(notYetForwarded)
	{
		boolean caseCheck = true;
		if (s_host_name.equals(oldhostname))
		{
			caseCheck = false;
		}
		if(caseCheck && (nickManaged || v_host_name_nocase.size() > 0))
		{
			String hostname = "";
			String dispHostName = "";
			boolean proceed = true;

			for(int i=1;i < temp_v_host_name.size();i=i+2)
			{
				if(((String)temp_v_host_name.get(i)).equals("false"))
				{
					proceed = false;
					hostname = (String)temp_v_host_name.get(i-1);
					break;
				}
			}
			if(hostname.length() > 0)
			{
				Hashtable nickIPMapTemp = egDiscInfo.getAllNicksIpMap();
				Hashtable lowerCaseNickIPMap = new Hashtable();
				Hashtable originalNickMap = new Hashtable();
				if(nickIPMapTemp != null)
				{
					dispHostName = (String)nickIPMapTemp.get(s_host_name);
					if (dispHostName == null)
					{
						Enumeration eunmMap  = nickIPMapTemp.keys();
						while(eunmMap.hasMoreElements())
						{
							String key = (String)eunmMap.nextElement();
							String value = (String)nickIPMapTemp.get(key);
							lowerCaseNickIPMap.put(key.toLowerCase(),value);
							originalNickMap.put(key.toLowerCase(),key);
						}
					}
					dispHostName = (String)lowerCaseNickIPMap.get(s_host_name.toLowerCase());
					if(dispHostName != null)
					{
						dispHostName = (String)originalNickMap.get(s_host_name.toLowerCase());
					}
					else
					{
						dispHostName = s_host_name;
					}
				}
			}
			hiddens.put("hostcheck","true");

			String enable="";
			String port=request.getParameter("hportno");
			if (s_server_name.equalsIgnoreCase("new"))
			port = sPortNo;
			if( port!=null &&!port.equals(sPortNo))
			{
				enable="disabled";
			}
			if(!s_server_name.equalsIgnoreCase("new"))
			{
				enable="disabled";
			}
			rootJSON.put("proceed",proceed);
			rootJSON.put("main_Msg_Title",s_host_ip+" "+_mapping.getTextDescription("admin.server.IP is already mapped to the following nick name(s)")+":");
			boolean isIpNotShared = true;
			Vector v_host_name_only = new Vector();

			if(proceed)
			{
				JSONArray gridData = new JSONArray();
				for(int i=0;i < v_host_name.size();i=i+2)
				{
					String compName = (String)v_host_name.get(i);
					v_host_name_only.add(compName);
					JSONObject gridVal = new JSONObject();
					gridVal.put("column_1",compName);
					gridData.add(gridVal);
				}
				rootJSON.put("gridData",gridData);
				if(isLimitedAdmin)
				{
					for(int u=0; u<v_host_name_only.size(); u++)
					{
						if(allCompNicks.contains(v_host_name_only.get(u)))
						{
							isIpNotShared = true;
						}
						else
						{
							isIpNotShared = false;
							break;
						}
					}
				}
			}
			if(v_host_name_nocase.contains(s_host_name.toLowerCase()))
			{
				if(proceed)
				{
					if(v_host_name_nocase.size() > 2)
					{
						rootJSON.put("requestStatus","failed");
						rootJSON.put("error_type","radio");
						rootJSON.put("radio_Msg_Title",_mapping.getTextDescription("admin.server.The nick name")+" ("+s_host_name+") "+_mapping.getTextDescription("admin.server.you have added is already present in this list"));
						rootJSON.put("radio1_Msg",_mapping.getTextDescription("admin.server.Do you wish to continue adding the same nick name for this component?"));
						rootJSON.put("radio1_value","singleserver");
						if(isLimitedAdmin && !isIpNotShared)
						{
							enable = "disabled";
						}
						rootJSON.put("radio2_Msg",_mapping.getTextDescription("admin.server.Do you wish to continue adding the same nick name for this component and apply for all components?"));
						rootJSON.put("radio2_value","allservers");
						rootJSON.put("radio2_enable",enable);
					}
					else
					{
						UpdateAndTransmitUserInfo userinfo = new UpdateAndTransmitUserInfo();
						removeOldEntries(newNickAdded, s_host_name, userinfo);
						String ur ="EgnewserverpJson.jsp?action=singleserver&hostname="+EgURLEncoder.encode(s_host_name,"UTF-8")+"&"+request.getQueryString()+"&treeViewSrc="+treeViewSrc+"&servertype="+EgURLEncoder.encode(s_server_type,"UTF-8")+"&servername="+EgURLEncoder.encode(serverNameWithPort,"UTF-8")+"&hostIp="+s_host_ip+"&oldhostname="+EgURLEncoder.encode(oldhostname,"UTF-8");;
						if(frmTopology!=null && frmTopology.equals("yes"))
						{
							ur = ur + "&topoSegName="+EgURLEncoder.encode(topoSegName,"UTF-8")+"&initPort="+initialPortNo;
						}
						rootJSON.put("requestStatus","success");
						rootJSON.put("forward",true);
						rootJSON.put("forward_URL",ur);
					}
				}
				else
				{
					rootJSON.put("requestStatus","failed");
					rootJSON.put("error_type","alert");
					JSONObject obj = new JSONObject();
					obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
					obj.put("error_URL","");
					obj.put("error_Msg_Count","2");
					obj.put("error_Msg_1",_mapping.getTextDescription("admin.server.The nick name")+" ("+s_host_name+") "+_mapping.getTextDescription("admin.server.you have added is already associated with")+" "+hostname);
					obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.Please choose a different nick name")+".");
					rootJSON.put("error_Info",obj);
				}
			}
			else if(!v_host_name_nocase.contains(s_host_name.toLowerCase()))
			{
				if(proceed)
				{
					String radioValue = "singleserver";
					if(!s_server_name.equalsIgnoreCase("new"))
					{
						radioValue ="allservers";
					}
					ArrayList nicks = egDiscInfo.getAllComponentNicks(false);
					int count = 0;
					for (int i=0;i<nicks.size();i++)
					{
						String nick = (String)nicks.get(i);
						if (nick.equalsIgnoreCase(oldhostname))
							count++;
						if(count > 1)
							break;
					}

					if (count > 1)
					{
						radioValue = "allservers";
					}
					else
					{
						radioValue = "singleserver";
					}
					rootJSON.put("requestStatus","failed");
					rootJSON.put("error_type","radio");
					rootJSON.put("radio_Msg_Title",_mapping.getTextDescription("admin.server.The nick name")+" ("+s_host_name+") "+_mapping.getTextDescription("admin.server.you have added is not present in the below list"));
					rootJSON.put("radio1_value",radioValue);
					rootJSON.put("radio1_checked",true);

					if(s_server_name.equalsIgnoreCase("new"))
					{
						rootJSON.put("radio1_Msg",_mapping.getTextDescription("admin.server.Do you wish to add the new nick name for this component alone?"));
					}
					else
					{
						if (v_host_name_nocase.size() > 2)
						{
							rootJSON.put("radio1_Msg",_mapping.getTextDescription("admin.server.Do you wish to rename all the components that have the old nick name?"));
							hiddens.put("modify","yes");
						}
						else
						{
							UpdateAndTransmitUserInfo userinfo = new UpdateAndTransmitUserInfo();
							removeOldEntries(newNickAdded, s_host_name, userinfo);
							String ur = "";
							if(radioValue.equalsIgnoreCase("singleserver"))
							{
								ur ="EgnewserverpJson.jsp?action=singleserver&hostname="+EgURLEncoder.encode(s_host_name,"UTF-8")+"&"+request.getQueryString()+"&treeViewSrc="+treeViewSrc+"&servertype="+EgURLEncoder.encode(s_server_type,"UTF-8")+"&servername="+EgURLEncoder.encode(serverNameWithPort,"UTF-8")+"&hostIp="+s_host_ip+"&oldhostname="+EgURLEncoder.encode(oldhostname,"UTF-8");
								if(frmTopology!=null && frmTopology.equals("yes"))
								{
									ur = ur + "&topoSegName="+EgURLEncoder.encode(topoSegName,"UTF-8")+"&initPort="+initialPortNo;
								}
							}
							else if(radioValue.equalsIgnoreCase("allservers"))
							{
								ur = "EgnewserverpJson.jsp?action=allservers&"+request.getQueryString()+"&treeViewSrc="+treeViewSrc+"&oldhostname="+EgURLEncoder.encode(oldhostname,"UTF-8");
							}
							rootJSON.put("requestStatus","success");
							rootJSON.put("forward",true);
							rootJSON.put("forward_URL",ur);
						}
					}
					if(isLimitedAdmin && !isIpNotShared)
					{
						enable = "disabled";
					}
					rootJSON.put("radio2_Msg",_mapping.getTextDescription("admin.server.Do you wish to add the new nick name for this component and apply for all components?"));
					rootJSON.put("radio2_value","allservers");
					rootJSON.put("radio2_enable",enable);
				}
				else
				{
					auditLogThread.setCurrentValue("ColumnName","Component Already Managed");
					auditLogThread.setCurrentValue("01~~Component type","$ctype$:"+s_server_type);
					auditLogThread.setCurrentValue("02~~Component name",s_host_name);
					if(s_host_ip != null && !s_host_ip.equals("0.0.0.0"))
					{
						auditLogThread.setCurrentValue("03~~IP in which component to be managed",s_host_ip);
					}
					if(hostname != null && hostname.equals("0.0.0.0"))
					{
						List aggCompTypes = egDiscInfo.getServerTypesForNick(dispHostName);
						rootJSON.put("requestStatus","failed");
						rootJSON.put("error_type","alert");
						JSONObject obj = new JSONObject();
						obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
						obj.put("error_URL","");
						obj.put("error_Msg_Count","2");
						obj.put("error_Msg_1",_mapping.getTextDescription("admin.error.The host/nick name")+" ("+s_host_name+") "+_mapping.getTextDescription("admin.error.you are trying to add is already associated with an aggregate component in the following manner")+".");
						obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.Please choose a different host/nick name"));

						if(aggCompTypes != null && !aggCompTypes.isEmpty())
						{
							JSONArray aggArray = new JSONArray();
							for(int i=0;i<aggCompTypes.size();i++)
							{
								String aggCompType = (String) aggCompTypes.get(i);
								auditLogThread.setCurrentValue("Component already managed","$ctype$:"+aggCompType+":"+dispHostName);
								JSONObject obj2 = new JSONObject();
								obj2.put("compType",_mapping.getComponentTypeDescription(aggCompType));
								obj2.put("comoName",dispHostName);
								aggArray.add(obj2);
							}
						}
						rootJSON.put("error_Info",obj);
						auditLogThread.setValue("Description","Component was not added as it had been already managed");
						auditLogThread.sendItToDB();
					}
					else
					{
						auditLogThread.setCurrentValue("IP in which component already managed",hostname);
						auditLogThread.setValue("Description","Component was not added as it had been already managed");
						auditLogThread.sendItToDB();

						rootJSON.put("requestStatus","failed");
						rootJSON.put("error_type","alert");
						JSONObject obj = new JSONObject();
						obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
						obj.put("error_URL","");
						obj.put("error_Msg_Count","2");
						obj.put("error_Msg_1",_mapping.getTextDescription("admin.error.The host/nick name")+" ("+s_host_name+") "+_mapping.getTextDescription("admin.error.you are trying to add is already associated with the IP")+" ("+hostname+"). ");
						obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.Please choose a different host/nick name"));
						obj.put("IP",hostname);
						obj.put("nickName",dispHostName);
						rootJSON.put("error_Info",obj);
					}
				}
			}
			hiddens.put("server_name",s_server_name);
			hiddens.put("server_type",s_server_type);
		}
		else
		{
			boolean caseIssue = (nameIndex!=-1) && !temp_v_host_name.contains(s_host_name);
			if ((lowerCaseHostName==null || !lowerCaseHostName.equals("true")) && caseIssue)
			{
				if(allNicks != null && allNicks.contains(s_host_name.toLowerCase()))
				{
					newHostName = (String)temp_v_host_name.get(nameIndex);
					rootJSON.put("requestStatus","failed");
					rootJSON.put("error_type","confirm");
					JSONObject obj = new JSONObject();
					obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
					obj.put("error_URL","");
					obj.put("error_Msg_Count","2");
					obj.put("error_Msg_1",_mapping.getTextDescription("admin.error.The host/nick name")+" ("+s_host_name+") "+_mapping.getTextDescription("admin.error.you are trying to add is already associated with the IP")+" ("+s_host_ip+"). ");
					obj.put("IP",s_host_ip);
					obj.put("nickName",newHostName);
					obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.Please choose a different host/nick name"));
					rootJSON.put("error_Info",obj);
				}
			}
		}
	}
	if(monitorLastSession != null && newUrlLink != null && newUrlLink.indexOf("com.eg.EgDashboardController")>-1)
	{
		if(s_server_type != null && strCompType != null && s_server_type.equals(strCompType) && oldNick!=null && strHostName!=null && oldNick.equals(strHostName))
		{
			session.removeAttribute("monitorLastSession");
		}
	}
	rootJSON.put("hiddenValues",hiddens);
	out.println(rootJSON);
%>

<%!
	public void removeOldEntries(boolean newNickAdded, String s_host_name, UpdateAndTransmitUserInfo userinfo)
	{
		if (newNickAdded)
		{
			ArrayList queryList = new ArrayList();
			queryList.add("delete from measure_last where trgt_host='"+s_host_name+"'");
			queryList.add("delete from metatest where comp_name like '"+s_host_name+":%'");
			for (int j=0; j<queryList.size(); j++)
			{
				String thisQry = (String) queryList.get(j);
				userinfo.deleteFromDb(thisQry);
			}
		}
	}
	public Vector getUniqueHosts(Vector v_host_name,Vector hosts)
	{
		for(int i=0;i<hosts.size();i=i+2)
		{
			String temp1 = (String)hosts.get(i);
			String temp2 = (String)hosts.get(i+1);
			if(!v_host_name.contains(temp1))
			{
				v_host_name.add(temp1);
				v_host_name.add(temp2);
			}
		}
		return v_host_name;
	}
%>


