<%
/*****************************************************************************
*	Name		:	changeAgentOutputFile.jsp
*	Purpose		:	Sending request to write agent output(or error) either in agentout.log(or agenterr.log) 
					or output.log(or error.log)  file of agent
*	Version		:	5.2
*	CreationDate:	12/05/2011
*	Author		:	James Thomas P.
******************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.eg.RemoteControlTaskHelper"%>

<%@ page import="net.sf.json.JSONObject"%>

<%
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	String agentID= request.getParameter("agentID");
	String agent_ip_address = request.getParameter("agent_ip_address");
	String output = request.getParameter("s_output");
	output = !StringUtils.isNull(output) && output.equalsIgnoreCase("yes")?"yes":"no";

	RemoteControlTaskHelper helper = new RemoteControlTaskHelper();

	if(helper.setAgentIntoControlMode(agentID) && helper.executeTask("AgentDebug", session.getId(), output+"@#@Y"))
	{
		String workStatus = "unknown";
		if(helper.isOutputAvailable())
		{
			ArrayList outputLines = helper.getOutput();
			if(outputLines != null && !outputLines.isEmpty())
			{
				workStatus = (String)outputLines.get(0);
			}
		}
		if(workStatus == null || workStatus.equals("null") || workStatus.equals("unknown") || workStatus.equals("failed"))
		{
			workStatus = "failed";
		}
		if(workStatus.equals("done"))
		{
			IniFile restartIniFile = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_agent_restart_time.ini");
			String ipStr[] = restartIniFile.getVariables("AGENT_RESTARTED_TIME");
			for(int i=0;i<ipStr.length;i++)
			{
				String remoteSystem = ipStr[i];
				String sep = ":";
				if(remoteSystem.indexOf(com.eg.EgInstallInfo.ipV6Sep)>=0)
				{
					sep = com.eg.EgInstallInfo.ipV6Sep;
				}
				if((sep+remoteSystem+sep).indexOf(sep+agent_ip_address+sep) >=0)
				{
					IniFile agentStatus = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agentoutputstatus.ini");
					agentStatus.setValue("AGENT_OUTPUT_STATUS", remoteSystem,output);
					agentStatus.saveFile();
					EgConfigFilesSync.releaseInstance(agentStatus);
					break;
				}
			}
		}
		String ss = "enabled";
		if(workStatus.equals("done") && output.equalsIgnoreCase("No"))
			ss = "disabled";
		try
		{
			Thread.sleep(2000);
		}
		catch(Exception e)
		{
			//e.printStackTrace();
		}

		/* code for auditlog starts */
		AuditLogThread auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Agent Status");
		auditLogThread.setValue("Activity","Agent Output Enable/Disable");
		if(!workStatus.equals("done"))
		{
			auditLogThread.setValue("Description","Request for disabling agent output and error log files has been failed as the agent was manually started on debug mode");
		}
		else
		{
			auditLogThread.setValue("Description","Agent output and error logging has been "+ss);
		}
		auditLogThread.setCurrentValue("Agent ID", agentID);
		auditLogThread.sendItToDB();
		/* code for auditlog ends */

		rootJSON.put("ResultAlert",true);
		rootJSON.put("ResultTitle",_mapping.getTextDescription("admin.agent.Agent output status"));
		if(workStatus.equals("done"))
		{
			rootJSON.put("ResultMsg",_mapping.getTextDescription("admin.agent.Agent output & error logging has been "+ss));
		}
		else
		{
			rootJSON.put("ResultMsg",_mapping.getTextDescription("admin.agent.Request for disabling agent output and error log files has been failed as the agent was manually started on debug mode"));
		}
	}
	else
	{
		/* code for auditlog starts */
		AuditLogThread auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Agent Status");
		auditLogThread.setValue("Activity","Agent Output Enable/Disable");
		auditLogThread.setCurrentValue("Agent ID", agentID);
		auditLogThread.setValue("Description","Agent output change request has been timedout");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */

		rootJSON.put("ResultAlert",true);
		rootJSON.put("ResultTitle",_mapping.getTextDescription("admin.agent.Agent output status"));
		rootJSON.put("ResultMsg",_mapping.getTextDescription("admin.agent.Agent output change request has been timedout"));
	}
	
	out.println(rootJSON);

	session.setAttribute("adminLastAccessedURL","/final/admin/EgServerList.jsp?agent="+request.getParameter("agentType"));
%>
