CREATE OR REPLACE TRIGGER TRIG_ BEFORE INSERT ON TABLE_NAME FOR EACH ROW
BEGIN
 	IF INSERTING OR UPDATING THEN
		UPDATE 
			MEASURE_LAST 
		SET 
			MSMT_TIME =:NEW.MSMT_TIME 
		WHERE 
			TEST_NAME='TABLE_NAME'      
			AND TRGT_HOST=:NEW.TRGT_HOST
			AND PORT_NO=:NEW.PORT_NO        
			AND SITE_NAME=:NEW.SITE_NAME      
			AND INFO=:NEW.INFO           
			AND MSMT_HOST=:NEW.MSMT_HOST;
		IF SQL%NOTFOUND THEN
			INSERT INTO MEASURE_LAST VALUES ('TABLE_NAME', 
			:NEW.TRGT_HOST, :NEW.PORT_NO, :NEW.SITE_NAME, 
			:NEW.INFO, :NEW.MSMT_HOST, :NEW.MSMT_TIME);
 		END IF;
 	END IF;
EXCEPTION
 WHEN OTHERS THEN
  RAISE_APPLICATION_ERROR(-20111,'TABLE_NAME: Cannot insert the values into Measure_last');
END;
