DROP TABLE FileUpdateTest CASCADE CONSTRAINTS;
CREATE TABLE FileUpdateTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
FileCount		Number(20,4) NOT NULL,
FileCount_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_FileUpdateTest ON FileUpdateTest(MSMT_TIME);
ALTER TABLE FileUpdateTest ADD constraint PK_FileUpdateTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE FileUpdateTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE FileUpdateTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
FileCount_MIN		Number(20,4) NOT NULL,
FileCount_MAX		Number(20,4) NOT NULL,
FileCount_STCNT	varchar2(32) NOT NULL);

ALTER TABLE FileUpdateTest_TREND ADD constraint PK_FileUpdateTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE FileUpdateTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE FileUpdateTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
FileCount_MIN		VARCHAR2(256) NOT NULL,
FileCount_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE FileUpdateTest_THRESH ADD constraint PK_FileUpdateTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_FileUpdateTest_THRESH ON FileUpdateTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_FileUpdateTest ON FileUpdateTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_FileUpdateTest ON FileUpdateTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE EXOMailActSumTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMailActSumTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Mails_sent Number(20,4) NOT NULL,
Mails_sent_ST varchar2(32) NOT NULL,
Mails_received Number(20,4) NOT NULL,
Mails_received_ST varchar2(32) NOT NULL,
Mails_read Number(20,4) NOT NULL,
Mails_read_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOMailActSumTest ON EXOMailActSumTest(MSMT_TIME);
ALTER TABLE EXOMailActSumTest ADD constraint PK_EXOMailActSumTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailActSumTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMailActSumTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Mails_sent_MIN Number(20,4) NOT NULL,
Mails_sent_MAX Number(20,4) NOT NULL,
Mails_sent_STCNT varchar2(32) NOT NULL,
Mails_received_MIN Number(20,4) NOT NULL,
Mails_received_MAX Number(20,4) NOT NULL,
Mails_received_STCNT varchar2(32) NOT NULL,
Mails_read_MIN Number(20,4) NOT NULL,
Mails_read_MAX Number(20,4) NOT NULL,
Mails_read_STCNT varchar2(32) NOT NULL
);

ALTER TABLE EXOMailActSumTest_TREND ADD constraint PK_EXOMailActSumTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMailActSumTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMailActSumTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Mails_sent_MIN VARCHAR2(256) NOT NULL,
Mails_sent_MAX VARCHAR2(256) NOT NULL,
Mails_received_MIN VARCHAR2(256) NOT NULL,
Mails_received_MAX VARCHAR2(256) NOT NULL,
Mails_read_MIN VARCHAR2(256) NOT NULL,
Mails_read_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE EXOMailActSumTest_THRESH ADD constraint PK_EXOMailActSumTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMailActSumTest_THRESH ON EXOMailActSumTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailActSumTest ON EXOMailActSumTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailActSumTest ON EXOMailActSumTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE NetworkConnTest CASCADE CONSTRAINTS;
CREATE TABLE NetworkConnTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
RESULT_MSG		Number(20,4) NOT NULL,
RESULT_MSG_ST		varchar2(32) NOT NULL,
RESP_TIME		Number(20,4) NOT NULL,
RESP_TIME_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_NetworkConnTest ON NetworkConnTest(MSMT_TIME);
ALTER TABLE NetworkConnTest ADD constraint PK_NetworkConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE NetworkConnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE NetworkConnTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
RESULT_MSG_MIN		Number(20,4) NOT NULL,
RESULT_MSG_MAX		Number(20,4) NOT NULL,
RESULT_MSG_STCNT	varchar2(32) NOT NULL,
RESP_TIME_MIN		Number(20,4) NOT NULL,
RESP_TIME_MAX		Number(20,4) NOT NULL,
RESP_TIME_STCNT		varchar2(32) NOT NULL);

ALTER TABLE NetworkConnTest_TREND ADD constraint PK_NetworkConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE NetworkConnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE NetworkConnTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
RESULT_MSG_MIN		VARCHAR2(256) NOT NULL,
RESULT_MSG_MAX		VARCHAR2(256) NOT NULL,
RESP_TIME_MIN		VARCHAR2(256) NOT NULL,
RESP_TIME_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE NetworkConnTest_THRESH ADD constraint PK_NetworkConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_NetworkConnTest_THRESH ON NetworkConnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_NetworkConnTest ON NetworkConnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_NetworkConnTest ON NetworkConnTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HybDataSrcTest CASCADE CONSTRAINTS;
CREATE TABLE HybDataSrcTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Status Number(20,4) NOT NULL,
Status_ST varchar2(32) NOT NULL,
ConnRate Number(20,4) NOT NULL,
ConnRate_ST varchar2(32) NOT NULL,
OpenConn Number(20,4) NOT NULL,
OpenConn_ST varchar2(32) NOT NULL,
UsedConn Number(20,4) NOT NULL,
UsedConn_ST varchar2(32) NOT NULL,
MaxAllowOpenConn Number(20,4) NOT NULL,
MaxAllowOpenConn_ST varchar2(32) NOT NULL,
OpenConnPerc Number(20,4) NOT NULL,
OpenConnPerc_ST varchar2(32) NOT NULL,
UsedConnPerc Number(20,4) NOT NULL,
UsedConnPerc_ST varchar2(32) NOT NULL,
AvgWaitTimeConn Number(20,4) NOT NULL,
AvgWaitTimeConn_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybDataSrcTest ON HybDataSrcTest(MSMT_TIME);
ALTER TABLE HybDataSrcTest ADD constraint PK_HybDataSrcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HybDataSrcTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybDataSrcTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Status_MIN Number(20,4) NOT NULL,
Status_MAX Number(20,4) NOT NULL,
Status_STCNT varchar2(32) NOT NULL,
ConnRate_MIN Number(20,4) NOT NULL,
ConnRate_MAX Number(20,4) NOT NULL,
ConnRate_STCNT varchar2(32) NOT NULL,
OpenConn_MIN Number(20,4) NOT NULL,
OpenConn_MAX Number(20,4) NOT NULL,
OpenConn_STCNT varchar2(32) NOT NULL,
UsedConn_MIN Number(20,4) NOT NULL,
UsedConn_MAX Number(20,4) NOT NULL,
UsedConn_STCNT varchar2(32) NOT NULL,
MaxAllowOpenConn_MIN Number(20,4) NOT NULL,
MaxAllowOpenConn_MAX Number(20,4) NOT NULL,
MaxAllowOpenConn_STCNT varchar2(32) NOT NULL,
OpenConnPerc_MIN Number(20,4) NOT NULL,
OpenConnPerc_MAX Number(20,4) NOT NULL,
OpenConnPerc_STCNT varchar2(32) NOT NULL,
UsedConnPerc_MIN Number(20,4) NOT NULL,
UsedConnPerc_MAX Number(20,4) NOT NULL,
UsedConnPerc_STCNT varchar2(32) NOT NULL,
AvgWaitTimeConn_MIN Number(20,4) NOT NULL,
AvgWaitTimeConn_MAX Number(20,4) NOT NULL,
AvgWaitTimeConn_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybDataSrcTest_TREND ADD constraint PK_HybDataSrcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybDataSrcTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybDataSrcTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Status_MIN varchar2(256) NOT NULL,
Status_MAX varchar2(256) NOT NULL,
ConnRate_MIN varchar2(256) NOT NULL,
ConnRate_MAX varchar2(256) NOT NULL,
OpenConn_MIN varchar2(256) NOT NULL,
OpenConn_MAX varchar2(256) NOT NULL,
UsedConn_MIN varchar2(256) NOT NULL,
UsedConn_MAX varchar2(256) NOT NULL,
MaxAllowOpenConn_MIN varchar2(256) NOT NULL,
MaxAllowOpenConn_MAX varchar2(256) NOT NULL,
OpenConnPerc_MIN varchar2(256) NOT NULL,
OpenConnPerc_MAX varchar2(256) NOT NULL,
UsedConnPerc_MIN varchar2(256) NOT NULL,
UsedConnPerc_MAX varchar2(256) NOT NULL,
AvgWaitTimeConn_MIN varchar2(256) NOT NULL,
AvgWaitTimeConn_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybDataSrcTest_THRESH ADD constraint PK_HybDataSrcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybDataSrcTest_THRESH ON HybDataSrcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybDataSrcTest ON HybDataSrcTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybDataSrcTest ON HybDataSrcTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE HybFlexQueryTest CASCADE CONSTRAINTS;
CREATE TABLE HybFlexQueryTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
CurrentSize Number(20,4) NOT NULL,
CurrentSize_ST varchar2(32) NOT NULL,
CurrentSizeInPercent Number(20,4) NOT NULL,
CurrentSizeInPercent_ST varchar2(32) NOT NULL,
MaxSize Number(20,4) NOT NULL,
MaxSize_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybFlexQueryTest ON HybFlexQueryTest(MSMT_TIME);
ALTER TABLE HybFlexQueryTest ADD constraint PK_HybFlexQueryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HybFlexQueryTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybFlexQueryTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
CurrentSize_MIN Number(20,4) NOT NULL,
CurrentSize_MAX Number(20,4) NOT NULL,
CurrentSize_STCNT varchar2(32) NOT NULL,
CurrentSizeInPercent_MIN Number(20,4) NOT NULL,
CurrentSizeInPercent_MAX Number(20,4) NOT NULL,
CurrentSizeInPercent_STCNT varchar2(32) NOT NULL,
MaxSize_MIN Number(20,4) NOT NULL,
MaxSize_MAX Number(20,4) NOT NULL,
MaxSize_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybFlexQueryTest_TREND ADD constraint PK_HybFlexQueryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybFlexQueryTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybFlexQueryTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
CurrentSize_MIN varchar2(256) NOT NULL,
CurrentSize_MAX varchar2(256) NOT NULL,
CurrentSizeInPercent_MIN varchar2(256) NOT NULL,
CurrentSizeInPercent_MAX varchar2(256) NOT NULL,
MaxSize_MIN varchar2(256) NOT NULL,
MaxSize_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybFlexQueryTest_THRESH ADD constraint PK_HybFlexQueryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybFlexQueryTest_THRESH ON HybFlexQueryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybFlexQueryTest ON HybFlexQueryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybFlexQueryTest ON HybFlexQueryTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HybMainCacheTest CASCADE CONSTRAINTS;
CREATE TABLE HybMainCacheTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
CurCacheSize Number(20,4) NOT NULL,
CurCacheSize_ST varchar2(32) NOT NULL,
CurCacheSizeInPercent Number(20,4) NOT NULL,
CurCacheSizeInPercent_ST varchar2(32) NOT NULL,
MaximumCacheSize Number(20,4) NOT NULL,
MaximumCacheSize_ST varchar2(32) NOT NULL,
EntitiesGetCount Number(20,4) NOT NULL,
EntitiesGetCount_ST varchar2(32) NOT NULL,
EntitiesHitCount Number(20,4) NOT NULL,
EntitiesHitCount_ST varchar2(32) NOT NULL,
HitInPerc Number(20,4) NOT NULL,
HitInPerc_ST varchar2(32) NOT NULL,
MissInPerc Number(20,4) NOT NULL,
MissInPerc_ST varchar2(32) NOT NULL,
EntitiesAddCount Number(20,4) NOT NULL,
EntitiesAddCount_ST varchar2(32) NOT NULL,
EntitiesRemoveCount Number(20,4) NOT NULL,
EntitiesRemoveCount_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybMainCacheTest ON HybMainCacheTest(MSMT_TIME);
ALTER TABLE HybMainCacheTest ADD constraint PK_HybMainCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybMainCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybMainCacheTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
CurCacheSize_MIN Number(20,4) NOT NULL,
CurCacheSize_MAX Number(20,4) NOT NULL,
CurCacheSize_STCNT varchar2(32) NOT NULL,
CurCacheSizeInPercent_MIN Number(20,4) NOT NULL,
CurCacheSizeInPercent_MAX Number(20,4) NOT NULL,
CurCacheSizeInPercent_STCNT varchar2(32) NOT NULL,
MaximumCacheSize_MIN Number(20,4) NOT NULL,
MaximumCacheSize_MAX Number(20,4) NOT NULL,
MaximumCacheSize_STCNT varchar2(32) NOT NULL,
EntitiesGetCount_MIN Number(20,4) NOT NULL,
EntitiesGetCount_MAX Number(20,4) NOT NULL,
EntitiesGetCount_STCNT varchar2(32) NOT NULL,
EntitiesHitCount_MIN Number(20,4) NOT NULL,
EntitiesHitCount_MAX Number(20,4) NOT NULL,
EntitiesHitCount_STCNT varchar2(32) NOT NULL,
HitInPerc_MIN Number(20,4) NOT NULL,
HitInPerc_MAX Number(20,4) NOT NULL,
HitInPerc_STCNT varchar2(32) NOT NULL,
MissInPerc_MIN Number(20,4) NOT NULL,
MissInPerc_MAX Number(20,4) NOT NULL,
MissInPerc_STCNT varchar2(32) NOT NULL,
EntitiesAddCount_MIN Number(20,4) NOT NULL,
EntitiesAddCount_MAX Number(20,4) NOT NULL,
EntitiesAddCount_STCNT varchar2(32) NOT NULL,
EntitiesRemoveCount_MIN Number(20,4) NOT NULL,
EntitiesRemoveCount_MAX Number(20,4) NOT NULL,
EntitiesRemoveCount_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybMainCacheTest_TREND ADD constraint PK_HybMainCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybMainCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybMainCacheTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
CurCacheSize_MIN varchar2(256) NOT NULL,
CurCacheSize_MAX varchar2(256) NOT NULL,
CurCacheSizeInPercent_MIN varchar2(256) NOT NULL,
CurCacheSizeInPercent_MAX varchar2(256) NOT NULL,
MaximumCacheSize_MIN varchar2(256) NOT NULL,
MaximumCacheSize_MAX varchar2(256) NOT NULL,
EntitiesGetCount_MIN varchar2(256) NOT NULL,
EntitiesGetCount_MAX varchar2(256) NOT NULL,
EntitiesHitCount_MIN varchar2(256) NOT NULL,
EntitiesHitCount_MAX varchar2(256) NOT NULL,
HitInPerc_MIN varchar2(256) NOT NULL,
HitInPerc_MAX varchar2(256) NOT NULL,
MissInPerc_MIN varchar2(256) NOT NULL,
MissInPerc_MAX varchar2(256) NOT NULL,
EntitiesAddCount_MIN varchar2(256) NOT NULL,
EntitiesAddCount_MAX varchar2(256) NOT NULL,
EntitiesRemoveCount_MIN varchar2(256) NOT NULL,
EntitiesRemoveCount_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybMainCacheTest_THRESH ADD constraint PK_HybMainCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybMainCacheTest_THRESH ON HybMainCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybMainCacheTest ON HybMainCacheTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybMainCacheTest ON HybMainCacheTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HybEntCacheTest CASCADE CONSTRAINTS;
CREATE TABLE HybEntCacheTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
CurrentCacheSize Number(20,4) NOT NULL,
CurrentCacheSize_ST varchar2(32) NOT NULL,
CacheFillRatio Number(20,4) NOT NULL,
CacheFillRatio_ST varchar2(32) NOT NULL,
MaximumCacheSize Number(20,4) NOT NULL,
MaximumCacheSize_ST varchar2(32) NOT NULL,
FetchCount Number(20,4) NOT NULL,
FetchCount_ST varchar2(32) NOT NULL,
HitCount Number(20,4) NOT NULL,
HitCount_ST varchar2(32) NOT NULL,
MissCount Number(20,4) NOT NULL,
MissCount_ST varchar2(32) NOT NULL,
HitRatio Number(20,4) NOT NULL,
HitRatio_ST varchar2(32) NOT NULL,
InvalidationCount Number(20,4) NOT NULL,
InvalidationCount_ST varchar2(32) NOT NULL,
EvictionCount Number(20,4) NOT NULL,
EvictionCount_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybEntCacheTest ON HybEntCacheTest(MSMT_TIME);
ALTER TABLE HybEntCacheTest ADD constraint PK_HybEntCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybEntCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybEntCacheTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
CurrentCacheSize_MIN Number(20,4) NOT NULL,
CurrentCacheSize_MAX Number(20,4) NOT NULL,
CurrentCacheSize_STCNT varchar2(32) NOT NULL,
CacheFillRatio_MIN Number(20,4) NOT NULL,
CacheFillRatio_MAX Number(20,4) NOT NULL,
CacheFillRatio_STCNT varchar2(32) NOT NULL,
MaximumCacheSize_MIN Number(20,4) NOT NULL,
MaximumCacheSize_MAX Number(20,4) NOT NULL,
MaximumCacheSize_STCNT varchar2(32) NOT NULL,
FetchCount_MIN Number(20,4) NOT NULL,
FetchCount_MAX Number(20,4) NOT NULL,
FetchCount_STCNT varchar2(32) NOT NULL,
HitCount_MIN Number(20,4) NOT NULL,
HitCount_MAX Number(20,4) NOT NULL,
HitCount_STCNT varchar2(32) NOT NULL,
MissCount_MIN Number(20,4) NOT NULL,
MissCount_MAX Number(20,4) NOT NULL,
MissCount_STCNT varchar2(32) NOT NULL,
HitRatio_MIN Number(20,4) NOT NULL,
HitRatio_MAX Number(20,4) NOT NULL,
HitRatio_STCNT varchar2(32) NOT NULL,
InvalidationCount_MIN Number(20,4) NOT NULL,
InvalidationCount_MAX Number(20,4) NOT NULL,
InvalidationCount_STCNT varchar2(32) NOT NULL,
EvictionCount_MIN Number(20,4) NOT NULL,
EvictionCount_MAX Number(20,4) NOT NULL,
EvictionCount_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybEntCacheTest_TREND ADD constraint PK_HybEntCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybEntCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybEntCacheTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
CurrentCacheSize_MIN varchar2(256) NOT NULL,
CurrentCacheSize_MAX varchar2(256) NOT NULL,
CacheFillRatio_MIN varchar2(256) NOT NULL,
CacheFillRatio_MAX varchar2(256) NOT NULL,
MaximumCacheSize_MIN varchar2(256) NOT NULL,
MaximumCacheSize_MAX varchar2(256) NOT NULL,
FetchCount_MIN varchar2(256) NOT NULL,
FetchCount_MAX varchar2(256) NOT NULL,
HitCount_MIN varchar2(256) NOT NULL,
HitCount_MAX varchar2(256) NOT NULL,
MissCount_MIN varchar2(256) NOT NULL,
MissCount_MAX varchar2(256) NOT NULL,
HitRatio_MIN varchar2(256) NOT NULL,
HitRatio_MAX varchar2(256) NOT NULL,
InvalidationCount_MIN varchar2(256) NOT NULL,
InvalidationCount_MAX varchar2(256) NOT NULL,
EvictionCount_MIN varchar2(256) NOT NULL,
EvictionCount_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybEntCacheTest_THRESH ADD constraint PK_HybEntCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybEntCacheTest_THRESH ON HybEntCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybEntCacheTest ON HybEntCacheTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybEntCacheTest ON HybEntCacheTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HybQyCacheTest CASCADE CONSTRAINTS;
CREATE TABLE HybQyCacheTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
CurrentCacheSize Number(20,4) NOT NULL,
CurrentCacheSize_ST varchar2(32) NOT NULL,
CacheFillRatio Number(20,4) NOT NULL,
CacheFillRatio_ST varchar2(32) NOT NULL,
MaximumCacheSize Number(20,4) NOT NULL,
MaximumCacheSize_ST varchar2(32) NOT NULL,
FetchCount Number(20,4) NOT NULL,
FetchCount_ST varchar2(32) NOT NULL,
HitCount Number(20,4) NOT NULL,
HitCount_ST varchar2(32) NOT NULL,
MissCount Number(20,4) NOT NULL,
MissCount_ST varchar2(32) NOT NULL,
HitRatio Number(20,4) NOT NULL,
HitRatio_ST varchar2(32) NOT NULL,
InvalidationCount Number(20,4) NOT NULL,
InvalidationCount_ST varchar2(32) NOT NULL,
EvictionCount Number(20,4) NOT NULL,
EvictionCount_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybQyCacheTest ON HybQyCacheTest(MSMT_TIME);
ALTER TABLE HybQyCacheTest ADD constraint PK_HybQyCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybQyCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybQyCacheTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
CurrentCacheSize_MIN Number(20,4) NOT NULL,
CurrentCacheSize_MAX Number(20,4) NOT NULL,
CurrentCacheSize_STCNT varchar2(32) NOT NULL,
CacheFillRatio_MIN Number(20,4) NOT NULL,
CacheFillRatio_MAX Number(20,4) NOT NULL,
CacheFillRatio_STCNT varchar2(32) NOT NULL,
MaximumCacheSize_MIN Number(20,4) NOT NULL,
MaximumCacheSize_MAX Number(20,4) NOT NULL,
MaximumCacheSize_STCNT varchar2(32) NOT NULL,
FetchCount_MIN Number(20,4) NOT NULL,
FetchCount_MAX Number(20,4) NOT NULL,
FetchCount_STCNT varchar2(32) NOT NULL,
HitCount_MIN Number(20,4) NOT NULL,
HitCount_MAX Number(20,4) NOT NULL,
HitCount_STCNT varchar2(32) NOT NULL,
MissCount_MIN Number(20,4) NOT NULL,
MissCount_MAX Number(20,4) NOT NULL,
MissCount_STCNT varchar2(32) NOT NULL,
HitRatio_MIN Number(20,4) NOT NULL,
HitRatio_MAX Number(20,4) NOT NULL,
HitRatio_STCNT varchar2(32) NOT NULL,
InvalidationCount_MIN Number(20,4) NOT NULL,
InvalidationCount_MAX Number(20,4) NOT NULL,
InvalidationCount_STCNT varchar2(32) NOT NULL,
EvictionCount_MIN Number(20,4) NOT NULL,
EvictionCount_MAX Number(20,4) NOT NULL,
EvictionCount_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybQyCacheTest_TREND ADD constraint PK_HybQyCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybQyCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybQyCacheTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
CurrentCacheSize_MIN varchar2(256) NOT NULL,
CurrentCacheSize_MAX varchar2(256) NOT NULL,
CacheFillRatio_MIN varchar2(256) NOT NULL,
CacheFillRatio_MAX varchar2(256) NOT NULL,
MaximumCacheSize_MIN varchar2(256) NOT NULL,
MaximumCacheSize_MAX varchar2(256) NOT NULL,
FetchCount_MIN varchar2(256) NOT NULL,
FetchCount_MAX varchar2(256) NOT NULL,
HitCount_MIN varchar2(256) NOT NULL,
HitCount_MAX varchar2(256) NOT NULL,
MissCount_MIN varchar2(256) NOT NULL,
MissCount_MAX varchar2(256) NOT NULL,
HitRatio_MIN varchar2(256) NOT NULL,
HitRatio_MAX varchar2(256) NOT NULL,
InvalidationCount_MIN varchar2(256) NOT NULL,
InvalidationCount_MAX varchar2(256) NOT NULL,
EvictionCount_MIN varchar2(256) NOT NULL,
EvictionCount_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybQyCacheTest_THRESH ADD constraint PK_HybQyCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybQyCacheTest_THRESH ON HybQyCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybQyCacheTest ON HybQyCacheTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybQyCacheTest ON HybQyCacheTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HybCronJobTest CASCADE CONSTRAINTS;
CREATE TABLE HybCronJobTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
cronjob Number(20,4) NOT NULL,
cronjob_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybCronJobTest ON HybCronJobTest(MSMT_TIME);
ALTER TABLE HybCronJobTest ADD constraint PK_HybCronJobTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybCronJobTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybCronJobTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
cronjob_MIN Number(20,4) NOT NULL,
cronjob_MAX Number(20,4) NOT NULL,
cronjob_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybCronJobTest_TREND ADD constraint PK_HybCronJobTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybCronJobTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybCronJobTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
cronjob_MIN varchar2(256) NOT NULL,
cronjob_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybCronJobTest_THRESH ADD constraint PK_HybCronJobTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybCronJobTest_THRESH ON HybCronJobTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybCronJobTest ON HybCronJobTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybCronJobTest ON HybCronJobTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HybTaskEngDBTest CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngDBTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
TblCondSize Number(20,4) NOT NULL,
TblCondSize_ST varchar2(32) NOT NULL,
TblTaskSize Number(20,4) NOT NULL,
TblTaskSize_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybTaskEngDBTest ON HybTaskEngDBTest(MSMT_TIME);
ALTER TABLE HybTaskEngDBTest ADD constraint PK_HybTaskEngDBTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybTaskEngDBTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngDBTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
TblCondSize_MIN Number(20,4) NOT NULL,
TblCondSize_MAX Number(20,4) NOT NULL,
TblCondSize_STCNT varchar2(32) NOT NULL,
TblTaskSize_MIN Number(20,4) NOT NULL,
TblTaskSize_MAX Number(20,4) NOT NULL,
TblTaskSize_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybTaskEngDBTest_TREND ADD constraint PK_HybTaskEngDBTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybTaskEngDBTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngDBTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
TblCondSize_MIN varchar2(256) NOT NULL,
TblCondSize_MAX varchar2(256) NOT NULL,
TblTaskSize_MIN varchar2(256) NOT NULL,
TblTaskSize_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybTaskEngDBTest_THRESH ADD constraint PK_HybTaskEngDBTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybTaskEngDBTest_THRESH ON HybTaskEngDBTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybTaskEngDBTest ON HybTaskEngDBTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybTaskEngDBTest ON HybTaskEngDBTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HybTaskEngExeTest CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngExeTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ExeHits Number(20,4) NOT NULL,
ExeHits_ST varchar2(32) NOT NULL,
ExeLockTime Number(20,4) NOT NULL,
ExeLockTime_ST varchar2(32) NOT NULL,
ExeTime Number(20,4) NOT NULL,
ExeTime_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybTaskEngExeTest ON HybTaskEngExeTest(MSMT_TIME);
ALTER TABLE HybTaskEngExeTest ADD constraint PK_HybTaskEngExeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybTaskEngExeTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngExeTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ExeHits_MIN Number(20,4) NOT NULL,
ExeHits_MAX Number(20,4) NOT NULL,
ExeHits_STCNT varchar2(32) NOT NULL,
ExeLockTime_MIN Number(20,4) NOT NULL,
ExeLockTime_MAX Number(20,4) NOT NULL,
ExeLockTime_STCNT varchar2(32) NOT NULL,
ExeTime_MIN Number(20,4) NOT NULL,
ExeTime_MAX Number(20,4) NOT NULL,
ExeTime_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybTaskEngExeTest_TREND ADD constraint PK_HybTaskEngExeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybTaskEngExeTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngExeTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ExeHits_MIN varchar2(256) NOT NULL,
ExeHits_MAX varchar2(256) NOT NULL,
ExeLockTime_MIN varchar2(256) NOT NULL,
ExeLockTime_MAX varchar2(256) NOT NULL,
ExeTime_MIN varchar2(256) NOT NULL,
ExeTime_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybTaskEngExeTest_THRESH ADD constraint PK_HybTaskEngExeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybTaskEngExeTest_THRESH ON HybTaskEngExeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybTaskEngExeTest ON HybTaskEngExeTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybTaskEngExeTest ON HybTaskEngExeTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HybTaskEngPlTest CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngPlTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PlBufSize Number(20,4) NOT NULL,
PlBufSize_ST varchar2(32) NOT NULL,
PlQueueSize Number(20,4) NOT NULL,
PlQueueSize_ST varchar2(32) NOT NULL,
PlConditionSize Number(20,4) NOT NULL,
PlConditionSize_ST varchar2(32) NOT NULL,
PlTime Number(20,4) NOT NULL,
PlTime_ST varchar2(32) NOT NULL,
QueueSize Number(20,4) NOT NULL,
QueueSize_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybTaskEngPlTest ON HybTaskEngPlTest(MSMT_TIME);
ALTER TABLE HybTaskEngPlTest ADD constraint PK_HybTaskEngPlTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybTaskEngPlTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngPlTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
PlBufSize_MIN Number(20,4) NOT NULL,
PlBufSize_MAX Number(20,4) NOT NULL,
PlBufSize_STCNT varchar2(32) NOT NULL,
PlQueueSize_MIN Number(20,4) NOT NULL,
PlQueueSize_MAX Number(20,4) NOT NULL,
PlQueueSize_STCNT varchar2(32) NOT NULL,
PlConditionSize_MIN Number(20,4) NOT NULL,
PlConditionSize_MAX Number(20,4) NOT NULL,
PlConditionSize_STCNT varchar2(32) NOT NULL,
PlTime_MIN Number(20,4) NOT NULL,
PlTime_MAX Number(20,4) NOT NULL,
PlTime_STCNT varchar2(32) NOT NULL,
QueueSize_MIN Number(20,4) NOT NULL,
QueueSize_MAX Number(20,4) NOT NULL,
QueueSize_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybTaskEngPlTest_TREND ADD constraint PK_HybTaskEngPlTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybTaskEngPlTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngPlTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
PlBufSize_MIN varchar2(256) NOT NULL,
PlBufSize_MAX varchar2(256) NOT NULL,
PlQueueSize_MIN varchar2(256) NOT NULL,
PlQueueSize_MAX varchar2(256) NOT NULL,
PlConditionSize_MIN varchar2(256) NOT NULL,
PlConditionSize_MAX varchar2(256) NOT NULL,
PlTime_MIN varchar2(256) NOT NULL,
PlTime_MAX varchar2(256) NOT NULL,
QueueSize_MIN varchar2(256) NOT NULL,
QueueSize_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybTaskEngPlTest_THRESH ADD constraint PK_HybTaskEngPlTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybTaskEngPlTest_THRESH ON HybTaskEngPlTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybTaskEngPlTest ON HybTaskEngPlTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybTaskEngPlTest ON HybTaskEngPlTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HybTaskPlSchdTest CASCADE CONSTRAINTS;
CREATE TABLE HybTaskPlSchdTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ActWorkTime Number(20,4) NOT NULL,
ActWorkTime_ST varchar2(32) NOT NULL,
CopyTaskTime Number(20,4) NOT NULL,
CopyTaskTime_ST varchar2(32) NOT NULL,
CountTaskTime Number(20,4) NOT NULL,
CountTaskTime_ST varchar2(32) NOT NULL,
DeactWorkTime Number(20,4) NOT NULL,
DeactWorkTime_ST varchar2(32) NOT NULL,
LockTime Number(20,4) NOT NULL,
LockTime_ST varchar2(32) NOT NULL,
PlTime Number(20,4) NOT NULL,
PlTime_ST varchar2(32) NOT NULL

);
CREATE INDEX IDX_HybTaskPlSchdTest ON HybTaskPlSchdTest(MSMT_TIME);
ALTER TABLE HybTaskPlSchdTest ADD constraint PK_HybTaskPlSchdTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybTaskPlSchdTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybTaskPlSchdTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ActWorkTime_MIN Number(20,4) NOT NULL,
ActWorkTime_MAX Number(20,4) NOT NULL,
ActWorkTime_STCNT varchar2(32) NOT NULL,
CopyTaskTime_MIN Number(20,4) NOT NULL,
CopyTaskTime_MAX Number(20,4) NOT NULL,
CopyTaskTime_STCNT varchar2(32) NOT NULL,
CountTaskTime_MIN Number(20,4) NOT NULL,
CountTaskTime_MAX Number(20,4) NOT NULL,
CountTaskTime_STCNT varchar2(32) NOT NULL,
DeactWorkTime_MIN Number(20,4) NOT NULL,
DeactWorkTime_MAX Number(20,4) NOT NULL,
DeactWorkTime_STCNT varchar2(32) NOT NULL,
LockTime_MIN Number(20,4) NOT NULL,
LockTime_MAX Number(20,4) NOT NULL,
LockTime_STCNT varchar2(32) NOT NULL,
PlTime_MIN Number(20,4) NOT NULL,
PlTime_MAX Number(20,4) NOT NULL,
PlTime_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybTaskPlSchdTest_TREND ADD constraint PK_HybTaskPlSchdTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybTaskPlSchdTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybTaskPlSchdTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ActWorkTime_MIN varchar2(256) NOT NULL,
ActWorkTime_MAX varchar2(256) NOT NULL,
CopyTaskTime_MIN varchar2(256) NOT NULL,
CopyTaskTime_MAX varchar2(256) NOT NULL,
CountTaskTime_MIN varchar2(256) NOT NULL,
CountTaskTime_MAX varchar2(256) NOT NULL,
DeactWorkTime_MIN varchar2(256) NOT NULL,
DeactWorkTime_MAX varchar2(256) NOT NULL,
LockTime_MIN varchar2(256) NOT NULL,
LockTime_MAX varchar2(256) NOT NULL,
PlTime_MIN varchar2(256) NOT NULL,
PlTime_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybTaskPlSchdTest_THRESH ADD constraint PK_HybTaskPlSchdTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybTaskPlSchdTest_THRESH ON HybTaskPlSchdTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybTaskPlSchdTest ON HybTaskPlSchdTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybTaskPlSchdTest ON HybTaskPlSchdTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SaaSTcpCnctvtyTest CASCADE CONSTRAINTS;
CREATE TABLE SaaSTcpCnctvtyTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
tcp_psent Number(20,4) NOT NULL,
tcp_psent_ST varchar2(32) NOT NULL,
tcp_plost Number(20,4) NOT NULL,
tcp_plost_ST varchar2(32) NOT NULL,
tcp_plost_p Number(20,4) NOT NULL,
tcp_plost_p_ST varchar2(32) NOT NULL,
tcp_tmax Number(20,4) NOT NULL,
tcp_tmax_ST varchar2(32) NOT NULL,
tcp_tmin Number(20,4) NOT NULL,
tcp_tmin_ST varchar2(32) NOT NULL,
tcp_tavg Number(20,4) NOT NULL,
tcp_tavg_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_SaaSTcpCnctvtyTest ON SaaSTcpCnctvtyTest(MSMT_TIME);
ALTER TABLE SaaSTcpCnctvtyTest ADD constraint PK_SaaSTcpCnctvtyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SaaSTcpCnctvtyTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SaaSTcpCnctvtyTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
tcp_psent_MIN Number(20,4) NOT NULL,
tcp_psent_MAX Number(20,4) NOT NULL,
tcp_psent_STCNT varchar2(32) NOT NULL,
tcp_plost_MIN Number(20,4) NOT NULL,
tcp_plost_MAX Number(20,4) NOT NULL,
tcp_plost_STCNT varchar2(32) NOT NULL,
tcp_plost_p_MIN Number(20,4) NOT NULL,
tcp_plost_p_MAX Number(20,4) NOT NULL,
tcp_plost_p_STCNT varchar2(32) NOT NULL,
tcp_tmax_MIN Number(20,4) NOT NULL,
tcp_tmax_MAX Number(20,4) NOT NULL,
tcp_tmax_STCNT varchar2(32) NOT NULL,
tcp_tmin_MIN Number(20,4) NOT NULL,
tcp_tmin_MAX Number(20,4) NOT NULL,
tcp_tmin_STCNT varchar2(32) NOT NULL,
tcp_tavg_MIN Number(20,4) NOT NULL,
tcp_tavg_MAX Number(20,4) NOT NULL,
tcp_tavg_STCNT varchar2(32) NOT NULL
);

ALTER TABLE SaaSTcpCnctvtyTest_TREND ADD constraint PK_SaaSTcpCnctvtyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SaaSTcpCnctvtyTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SaaSTcpCnctvtyTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
tcp_psent_MIN VARCHAR2(256) NOT NULL,
tcp_psent_MAX VARCHAR2(256) NOT NULL,
tcp_plost_MIN VARCHAR2(256) NOT NULL,
tcp_plost_MAX VARCHAR2(256) NOT NULL,
tcp_plost_p_MIN VARCHAR2(256) NOT NULL,
tcp_plost_p_MAX VARCHAR2(256) NOT NULL,
tcp_tmax_MIN VARCHAR2(256) NOT NULL,
tcp_tmax_MAX VARCHAR2(256) NOT NULL,
tcp_tmin_MIN VARCHAR2(256) NOT NULL,
tcp_tmin_MAX VARCHAR2(256) NOT NULL,
tcp_tavg_MIN VARCHAR2(256) NOT NULL,
tcp_tavg_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE SaaSTcpCnctvtyTest_THRESH ADD constraint PK_SaaSTcpCnctvtyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SaaSTcpCnctvtyTest_THRESH ON SaaSTcpCnctvtyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SaaSTcpCnctvtyTest ON SaaSTcpCnctvtyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SaaSTcpCnctvtyTest ON SaaSTcpCnctvtyTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ShareFileStatusTest CASCADE CONSTRAINTS;
CREATE TABLE ShareFileStatusTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
status Number(20,4) NOT NULL,
status_ST varchar2(32) NOT NULL,
incidents Number(20,4) NOT NULL,
incidents_ST varchar2(32) NOT NULL,
maintanence Number(20,4) NOT NULL,
maintanence_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ShareFileStatusTest ON ShareFileStatusTest(MSMT_TIME);
ALTER TABLE ShareFileStatusTest ADD constraint PK_ShareFileStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ShareFileStatusTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ShareFileStatusTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
status_MIN Number(20,4) NOT NULL,
status_MAX Number(20,4) NOT NULL,
status_STCNT varchar2(32) NOT NULL,
incidents_MIN Number(20,4) NOT NULL,
incidents_MAX Number(20,4) NOT NULL,
incidents_STCNT varchar2(32) NOT NULL,
maintanence_MIN Number(20,4) NOT NULL,
maintanence_MAX Number(20,4) NOT NULL,
maintanence_STCNT varchar2(32) NOT NULL
);

ALTER TABLE ShareFileStatusTest_TREND ADD constraint PK_ShareFileStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ShareFileStatusTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ShareFileStatusTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
status_MIN VARCHAR2(256) NOT NULL,
status_MAX VARCHAR2(256) NOT NULL,
incidents_MIN VARCHAR2(256) NOT NULL,
incidents_MAX VARCHAR2(256) NOT NULL,
maintanence_MIN VARCHAR2(256) NOT NULL,
maintanence_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE ShareFileStatusTest_THRESH ADD constraint PK_SharFilStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SharFilStatusTest_THRESH ON ShareFileStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ShareFileStatusTest ON ShareFileStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ShareFileStatusTest ON ShareFileStatusTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EgSysLogLevelTest CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogLevelTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
error Number(20,4) NOT NULL,
error_ST varchar2(32) NOT NULL,
emergency Number(20,4) NOT NULL,
emergency_ST varchar2(32) NOT NULL,
critical Number(20,4) NOT NULL,
critical_ST varchar2(32) NOT NULL,
debug Number(20,4) NOT NULL,
debug_ST varchar2(32) NOT NULL,
infomation Number(20,4) NOT NULL,
infomation_ST varchar2(32) NOT NULL,
warning Number(20,4) NOT NULL,
warning_ST varchar2(32) NOT NULL,
alert Number(20,4) NOT NULL,
alert_ST varchar2(32) NOT NULL,
notice Number(20,4) NOT NULL,
notice_ST varchar2(32) NOT NULL,
other Number(20,4) NOT NULL,
other_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EgSysLogLevelTest ON EgSysLogLevelTest(MSMT_TIME);
ALTER TABLE EgSysLogLevelTest ADD constraint PK_EgSysLogLevelTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSysLogLevelTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogLevelTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
error_MIN Number(20,4) NOT NULL,
error_MAX Number(20,4) NOT NULL,
error_STCNT varchar2(32) NOT NULL,
emergency_MIN Number(20,4) NOT NULL,
emergency_MAX Number(20,4) NOT NULL,
emergency_STCNT varchar2(32) NOT NULL,
critical_MIN Number(20,4) NOT NULL,
critical_MAX Number(20,4) NOT NULL,
critical_STCNT varchar2(32) NOT NULL,
debug_MIN Number(20,4) NOT NULL,
debug_MAX Number(20,4) NOT NULL,
debug_STCNT varchar2(32) NOT NULL,
infomation_MIN Number(20,4) NOT NULL,
infomation_MAX Number(20,4) NOT NULL,
infomation_STCNT varchar2(32) NOT NULL,
warning_MIN Number(20,4) NOT NULL,
warning_MAX Number(20,4) NOT NULL,
warning_STCNT varchar2(32) NOT NULL,
alert_MIN Number(20,4) NOT NULL,
alert_MAX Number(20,4) NOT NULL,
alert_STCNT varchar2(32) NOT NULL,
notice_MIN Number(20,4) NOT NULL,
notice_MAX Number(20,4) NOT NULL,
notice_STCNT varchar2(32) NOT NULL,
other_MIN Number(20,4) NOT NULL,
other_MAX Number(20,4) NOT NULL,
other_STCNT varchar2(32) NOT NULL);

ALTER TABLE EgSysLogLevelTest_TREND ADD constraint PK_EgSysLogLevelTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSysLogLevelTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogLevelTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
error_MIN VARCHAR2(256) NOT NULL,
error_MAX VARCHAR2(256) NOT NULL,
emergency_MIN VARCHAR2(256) NOT NULL,
emergency_MAX VARCHAR2(256) NOT NULL,
critical_MIN VARCHAR2(256) NOT NULL,
critical_MAX VARCHAR2(256) NOT NULL,
debug_MIN VARCHAR2(256) NOT NULL,
debug_MAX VARCHAR2(256) NOT NULL,
infomation_MIN VARCHAR2(256) NOT NULL,
infomation_MAX VARCHAR2(256) NOT NULL,
warning_MIN VARCHAR2(256) NOT NULL,
warning_MAX VARCHAR2(256) NOT NULL,
alert_MIN VARCHAR2(256) NOT NULL,
alert_MAX VARCHAR2(256) NOT NULL,
notice_MIN VARCHAR2(256) NOT NULL,
notice_MAX VARCHAR2(256) NOT NULL,
other_MIN VARCHAR2(256) NOT NULL,
other_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE EgSysLogLevelTest_THRESH ADD constraint PK_EgSysLogLevelTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSysLogLevelTest_THRESH ON EgSysLogLevelTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSysLogLevelTest ON EgSysLogLevelTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSysLogLevelTest ON EgSysLogLevelTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE SPOUsrDtlsTest CASCADE CONSTRAINTS;
CREATE TABLE SPOUsrDtlsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Active_Usrs Number(20,4) NOT NULL,
Active_Usrs_ST varchar2(32) NOT NULL,
InActive_Usrs Number(20,4) NOT NULL,
InActive_Usrs_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOUsrDtlsTest ON SPOUsrDtlsTest(MSMT_TIME);
ALTER TABLE SPOUsrDtlsTest ADD constraint PK_SPOUsrDtlsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOUsrDtlsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOUsrDtlsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Active_Usrs_MIN Number(20,4) NOT NULL,
Active_Usrs_MAX Number(20,4) NOT NULL,
Active_Usrs_STCNT varchar2(32) NOT NULL,
InActive_Usrs_MIN Number(20,4) NOT NULL,
InActive_Usrs_MAX Number(20,4) NOT NULL,
InActive_Usrs_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOUsrDtlsTest_TREND ADD constraint PK_SPOUsrDtlsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOUsrDtlsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOUsrDtlsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Active_Usrs_MIN VARCHAR2(256) NOT NULL,
Active_Usrs_MAX VARCHAR2(256) NOT NULL,
InActive_Usrs_MIN VARCHAR2(256) NOT NULL,
InActive_Usrs_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOUsrDtlsTest_THRESH ADD constraint PK_SPOUsrDtlsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOUsrDtlsTest_THRESH ON SPOUsrDtlsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOUsrDtlsTest ON SPOUsrDtlsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOUsrDtlsTest ON SPOUsrDtlsTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE ODBSiteConnvtyTest CASCADE CONSTRAINTS;
CREATE TABLE ODBSiteConnvtyTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Web_availability Number(20,4) NOT NULL,
Web_availability_ST varchar2(32) NOT NULL,
Response_code Number(20,4) NOT NULL,
Response_code_ST varchar2(32) NOT NULL,
Response_time Number(20,4) NOT NULL,
Response_time_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBSiteConnvtyTest ON ODBSiteConnvtyTest(MSMT_TIME);
ALTER TABLE ODBSiteConnvtyTest ADD constraint PK_ODBSiteConnvtyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSiteConnvtyTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBSiteConnvtyTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Web_availability_MIN Number(20,4) NOT NULL,
Web_availability_MAX Number(20,4) NOT NULL,
Web_availability_STCNT varchar2(32) NOT NULL,
Response_code_MIN Number(20,4) NOT NULL,
Response_code_MAX Number(20,4) NOT NULL,
Response_code_STCNT varchar2(32) NOT NULL,
Response_time_MIN Number(20,4) NOT NULL,
Response_time_MAX Number(20,4) NOT NULL,
Response_time_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBSiteConnvtyTest_TREND ADD constraint PK_ODBSiteConnvtyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSiteConnvtyTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBSiteConnvtyTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Web_availability_MIN VARCHAR2(256) NOT NULL,
Web_availability_MAX VARCHAR2(256) NOT NULL,
Response_code_MIN VARCHAR2(256) NOT NULL,
Response_code_MAX VARCHAR2(256) NOT NULL,
Response_time_MIN VARCHAR2(256) NOT NULL,
Response_time_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBSiteConnvtyTest_THRESH ADD constraint PK_ODBSiteConnvtyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSiteConnvtyTest_THRESH ON ODBSiteConnvtyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSiteConnvtyTest ON ODBSiteConnvtyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSiteConnvtyTest ON ODBSiteConnvtyTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBFileActTest CASCADE CONSTRAINTS;
CREATE TABLE ODBFileActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
File_accesses Number(20,4) NOT NULL,
File_accesses_ST varchar2(32) NOT NULL,
File_check_ins Number(20,4) NOT NULL,
File_check_ins_ST varchar2(32) NOT NULL,
File_checkouts Number(20,4) NOT NULL,
File_checkouts_ST varchar2(32) NOT NULL,
File_copies Number(20,4) NOT NULL,
File_copies_ST varchar2(32) NOT NULL,
File_deletes Number(20,4) NOT NULL,
File_deletes_ST varchar2(32) NOT NULL,
File_deletes_frm_I_stage Number(20,4) NOT NULL,
File_deletes_frm_I_stage_ST varchar2(32) NOT NULL,
File_deletes_frm_II_stag Number(20,4) NOT NULL,
File_deletes_frm_II_stag_ST varchar2(32) NOT NULL,
File_checkout_discards Number(20,4) NOT NULL,
File_checkout_discards_ST varchar2(32) NOT NULL,
File_downloads Number(20,4) NOT NULL,
File_downloads_ST varchar2(32) NOT NULL,
File_modifications Number(20,4) NOT NULL,
File_modifications_ST varchar2(32) NOT NULL,
File_moves Number(20,4) NOT NULL,
File_moves_ST varchar2(32) NOT NULL,
File_renames Number(20,4) NOT NULL,
File_renames_ST varchar2(32) NOT NULL,
File_restores Number(20,4) NOT NULL,
File_restores_ST varchar2(32) NOT NULL,
File_uploads Number(20,4) NOT NULL,
File_uploads_ST varchar2(32) NOT NULL,
Page_views Number(20,4) NOT NULL,
Page_views_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBFileActTest ON ODBFileActTest(MSMT_TIME);
ALTER TABLE ODBFileActTest ADD constraint PK_ODBFileActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBFileActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBFileActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
File_accesses_MIN Number(20,4) NOT NULL,
File_accesses_MAX Number(20,4) NOT NULL,
File_accesses_STCNT varchar2(32) NOT NULL,
File_check_ins_MIN Number(20,4) NOT NULL,
File_check_ins_MAX Number(20,4) NOT NULL,
File_check_ins_STCNT varchar2(32) NOT NULL,
File_checkouts_MIN Number(20,4) NOT NULL,
File_checkouts_MAX Number(20,4) NOT NULL,
File_checkouts_STCNT varchar2(32) NOT NULL,
File_copies_MIN Number(20,4) NOT NULL,
File_copies_MAX Number(20,4) NOT NULL,
File_copies_STCNT varchar2(32) NOT NULL,
File_deletes_MIN Number(20,4) NOT NULL,
File_deletes_MAX Number(20,4) NOT NULL,
File_deletes_STCNT varchar2(32) NOT NULL,
File_deletes_frm_I_stage_MIN Number(20,4) NOT NULL,
File_deletes_frm_I_stage_MAX Number(20,4) NOT NULL,
File_deletes_frm_I_stage_STCNT varchar2(32) NOT NULL,
File_deletes_frm_II_stag_MIN Number(20,4) NOT NULL,
File_deletes_frm_II_stag_MAX Number(20,4) NOT NULL,
File_deletes_frm_II_stag_STCNT varchar2(32) NOT NULL,
File_checkout_discards_MIN Number(20,4) NOT NULL,
File_checkout_discards_MAX Number(20,4) NOT NULL,
File_checkout_discards_STCNT varchar2(32) NOT NULL,
File_downloads_MIN Number(20,4) NOT NULL,
File_downloads_MAX Number(20,4) NOT NULL,
File_downloads_STCNT varchar2(32) NOT NULL,
File_modifications_MIN Number(20,4) NOT NULL,
File_modifications_MAX Number(20,4) NOT NULL,
File_modifications_STCNT varchar2(32) NOT NULL,
File_moves_MIN Number(20,4) NOT NULL,
File_moves_MAX Number(20,4) NOT NULL,
File_moves_STCNT varchar2(32) NOT NULL,
File_renames_MIN Number(20,4) NOT NULL,
File_renames_MAX Number(20,4) NOT NULL,
File_renames_STCNT varchar2(32) NOT NULL,
File_restores_MIN Number(20,4) NOT NULL,
File_restores_MAX Number(20,4) NOT NULL,
File_restores_STCNT varchar2(32) NOT NULL,
File_uploads_MIN Number(20,4) NOT NULL,
File_uploads_MAX Number(20,4) NOT NULL,
File_uploads_STCNT varchar2(32) NOT NULL,
Page_views_MIN Number(20,4) NOT NULL,
Page_views_MAX Number(20,4) NOT NULL,
Page_views_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBFileActTest_TREND ADD constraint PK_ODBFileActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBFileActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBFileActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
File_accesses_MIN VARCHAR2(256) NOT NULL,
File_accesses_MAX VARCHAR2(256) NOT NULL,
File_check_ins_MIN VARCHAR2(256) NOT NULL,
File_check_ins_MAX VARCHAR2(256) NOT NULL,
File_checkouts_MIN VARCHAR2(256) NOT NULL,
File_checkouts_MAX VARCHAR2(256) NOT NULL,
File_copies_MIN VARCHAR2(256) NOT NULL,
File_copies_MAX VARCHAR2(256) NOT NULL,
File_deletes_MIN VARCHAR2(256) NOT NULL,
File_deletes_MAX VARCHAR2(256) NOT NULL,
File_deletes_frm_I_stage_MIN VARCHAR2(256) NOT NULL,
File_deletes_frm_I_stage_MAX VARCHAR2(256) NOT NULL,
File_deletes_frm_II_stag_MIN VARCHAR2(256) NOT NULL,
File_deletes_frm_II_stag_MAX VARCHAR2(256) NOT NULL,
File_checkout_discards_MIN VARCHAR2(256) NOT NULL,
File_checkout_discards_MAX VARCHAR2(256) NOT NULL,
File_downloads_MIN VARCHAR2(256) NOT NULL,
File_downloads_MAX VARCHAR2(256) NOT NULL,
File_modifications_MIN VARCHAR2(256) NOT NULL,
File_modifications_MAX VARCHAR2(256) NOT NULL,
File_moves_MIN VARCHAR2(256) NOT NULL,
File_moves_MAX VARCHAR2(256) NOT NULL,
File_renames_MIN VARCHAR2(256) NOT NULL,
File_renames_MAX VARCHAR2(256) NOT NULL,
File_restores_MIN VARCHAR2(256) NOT NULL,
File_restores_MAX VARCHAR2(256) NOT NULL,
File_uploads_MIN VARCHAR2(256) NOT NULL,
File_uploads_MAX VARCHAR2(256) NOT NULL,
Page_views_MIN VARCHAR2(256) NOT NULL,
Page_views_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBFileActTest_THRESH ADD constraint PK_ODBFileActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFileActTest_THRESH ON ODBFileActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFileActTest ON ODBFileActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFileActTest ON ODBFileActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBUsrsByServTest CASCADE CONSTRAINTS;
CREATE TABLE ODBUsrsByServTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Active_Usrs Number(20,4) NOT NULL,
Active_Usrs_ST varchar2(32) NOT NULL,
InActive_Usrs Number(20,4) NOT NULL,
InActive_Usrs_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBUsrsByServTest ON ODBUsrsByServTest(MSMT_TIME);
ALTER TABLE ODBUsrsByServTest ADD constraint PK_ODBUsrsByServTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBUsrsByServTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBUsrsByServTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Active_Usrs_MIN Number(20,4) NOT NULL,
Active_Usrs_MAX Number(20,4) NOT NULL,
Active_Usrs_STCNT varchar2(32) NOT NULL,
InActive_Usrs_MIN Number(20,4) NOT NULL,
InActive_Usrs_MAX Number(20,4) NOT NULL,
InActive_Usrs_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBUsrsByServTest_TREND ADD constraint PK_ODBUsrsByServTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBUsrsByServTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBUsrsByServTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Active_Usrs_MIN VARCHAR2(256) NOT NULL,
Active_Usrs_MAX VARCHAR2(256) NOT NULL,
InActive_Usrs_MIN VARCHAR2(256) NOT NULL,
InActive_Usrs_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBUsrsByServTest_THRESH ADD constraint PK_ODBUsrsByServTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBUsrsByServTest_THRESH ON ODBUsrsByServTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBUsrsByServTest ON ODBUsrsByServTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBUsrsByServTest ON ODBUsrsByServTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBFileOperatnsTest CASCADE CONSTRAINTS;
CREATE TABLE ODBFileOperatnsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
File_upload_status Number(20,4) NOT NULL,
File_upload_status_ST varchar2(32) NOT NULL,
File_upload_time Number(20,4) NOT NULL,
File_upload_time_ST varchar2(32) NOT NULL,
File_download_status Number(20,4) NOT NULL,
File_download_status_ST varchar2(32) NOT NULL,
File_download_time Number(20,4) NOT NULL,
File_download_time_ST varchar2(32) NOT NULL,
File_deletion_status Number(20,4) NOT NULL,
File_deletion_status_ST varchar2(32) NOT NULL,
File_deletion_time Number(20,4) NOT NULL,
File_deletion_time_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBFileOperatnsTest ON ODBFileOperatnsTest(MSMT_TIME);
ALTER TABLE ODBFileOperatnsTest ADD constraint PK_ODBFileOperatnsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBFileOperatnsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBFileOperatnsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
File_upload_status_MIN Number(20,4) NOT NULL,
File_upload_status_MAX Number(20,4) NOT NULL,
File_upload_status_STCNT varchar2(32) NOT NULL,
File_upload_time_MIN Number(20,4) NOT NULL,
File_upload_time_MAX Number(20,4) NOT NULL,
File_upload_time_STCNT varchar2(32) NOT NULL,
File_download_status_MIN Number(20,4) NOT NULL,
File_download_status_MAX Number(20,4) NOT NULL,
File_download_status_STCNT varchar2(32) NOT NULL,
File_download_time_MIN Number(20,4) NOT NULL,
File_download_time_MAX Number(20,4) NOT NULL,
File_download_time_STCNT varchar2(32) NOT NULL,
File_deletion_status_MIN Number(20,4) NOT NULL,
File_deletion_status_MAX Number(20,4) NOT NULL,
File_deletion_status_STCNT varchar2(32) NOT NULL,
File_deletion_time_MIN Number(20,4) NOT NULL,
File_deletion_time_MAX Number(20,4) NOT NULL,
File_deletion_time_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBFileOperatnsTest_TREND ADD constraint PK_ODBFileOperatnsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBFileOperatnsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBFileOperatnsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
File_upload_status_MIN VARCHAR2(256) NOT NULL,
File_upload_status_MAX VARCHAR2(256) NOT NULL,
File_upload_time_MIN VARCHAR2(256) NOT NULL,
File_upload_time_MAX VARCHAR2(256) NOT NULL,
File_download_status_MIN VARCHAR2(256) NOT NULL,
File_download_status_MAX VARCHAR2(256) NOT NULL,
File_download_time_MIN VARCHAR2(256) NOT NULL,
File_download_time_MAX VARCHAR2(256) NOT NULL,
File_deletion_status_MIN VARCHAR2(256) NOT NULL,
File_deletion_status_MAX VARCHAR2(256) NOT NULL,
File_deletion_time_MIN VARCHAR2(256) NOT NULL,
File_deletion_time_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBFileOperatnsTest_THRESH ADD constraint PK_ODBFileOperatnsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFileOperatnsTest_THRESH ON ODBFileOperatnsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFileOperatnsTest ON ODBFileOperatnsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFileOperatnsTest ON ODBFileOperatnsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBSyncActTest CASCADE CONSTRAINTS;
CREATE TABLE ODBSyncActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
File_sync_permits Number(20,4) NOT NULL,
File_sync_permits_ST varchar2(32) NOT NULL,
File_sync_blocks Number(20,4) NOT NULL,
File_sync_blocks_ST varchar2(32) NOT NULL,
File_downloads Number(20,4) NOT NULL,
File_downloads_ST varchar2(32) NOT NULL,
File_changes_downloads Number(20,4) NOT NULL,
File_changes_downloads_ST varchar2(32) NOT NULL,
File_uploads Number(20,4) NOT NULL,
File_uploads_ST varchar2(32) NOT NULL,
File_changes_uploads Number(20,4) NOT NULL,
File_changes_uploads_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBSyncActTest ON ODBSyncActTest(MSMT_TIME);
ALTER TABLE ODBSyncActTest ADD constraint PK_ODBSyncActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSyncActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBSyncActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
File_sync_permits_MIN Number(20,4) NOT NULL,
File_sync_permits_MAX Number(20,4) NOT NULL,
File_sync_permits_STCNT varchar2(32) NOT NULL,
File_sync_blocks_MIN Number(20,4) NOT NULL,
File_sync_blocks_MAX Number(20,4) NOT NULL,
File_sync_blocks_STCNT varchar2(32) NOT NULL,
File_downloads_MIN Number(20,4) NOT NULL,
File_downloads_MAX Number(20,4) NOT NULL,
File_downloads_STCNT varchar2(32) NOT NULL,
File_changes_downloads_MIN Number(20,4) NOT NULL,
File_changes_downloads_MAX Number(20,4) NOT NULL,
File_changes_downloads_STCNT varchar2(32) NOT NULL,
File_uploads_MIN Number(20,4) NOT NULL,
File_uploads_MAX Number(20,4) NOT NULL,
File_uploads_STCNT varchar2(32) NOT NULL,
File_changes_uploads_MIN Number(20,4) NOT NULL,
File_changes_uploads_MAX Number(20,4) NOT NULL,
File_changes_uploads_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBSyncActTest_TREND ADD constraint PK_ODBSyncActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSyncActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBSyncActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
File_sync_permits_MIN VARCHAR2(256) NOT NULL,
File_sync_permits_MAX VARCHAR2(256) NOT NULL,
File_sync_blocks_MIN VARCHAR2(256) NOT NULL,
File_sync_blocks_MAX VARCHAR2(256) NOT NULL,
File_downloads_MIN VARCHAR2(256) NOT NULL,
File_downloads_MAX VARCHAR2(256) NOT NULL,
File_changes_downloads_MIN VARCHAR2(256) NOT NULL,
File_changes_downloads_MAX VARCHAR2(256) NOT NULL,
File_uploads_MIN VARCHAR2(256) NOT NULL,
File_uploads_MAX VARCHAR2(256) NOT NULL,
File_changes_uploads_MIN VARCHAR2(256) NOT NULL,
File_changes_uploads_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBSyncActTest_THRESH ADD constraint PK_ODBSyncActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSyncActTest_THRESH ON ODBSyncActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSyncActTest ON ODBSyncActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSyncActTest ON ODBSyncActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBSrvcHlhTest CASCADE CONSTRAINTS;
CREATE TABLE ODBSrvcHlhTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Service_incidents Number(20,4) NOT NULL,
Service_incidents_ST varchar2(32) NOT NULL,
Maintenance_events Number(20,4) NOT NULL,
Maintenance_events_ST varchar2(32) NOT NULL,
Service_Status Number(20,4) NOT NULL,
Service_Status_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBSrvcHlhTest ON ODBSrvcHlhTest(MSMT_TIME);
ALTER TABLE ODBSrvcHlhTest ADD constraint PK_ODBSrvcHlhTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSrvcHlhTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBSrvcHlhTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Service_incidents_MIN Number(20,4) NOT NULL,
Service_incidents_MAX Number(20,4) NOT NULL,
Service_incidents_STCNT varchar2(32) NOT NULL,
Maintenance_events_MIN Number(20,4) NOT NULL,
Maintenance_events_MAX Number(20,4) NOT NULL,
Maintenance_events_STCNT varchar2(32) NOT NULL,
Service_Status_MIN Number(20,4) NOT NULL,
Service_Status_MAX Number(20,4) NOT NULL,
Service_Status_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBSrvcHlhTest_TREND ADD constraint PK_ODBSrvcHlhTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSrvcHlhTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBSrvcHlhTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Service_incidents_MIN VARCHAR2(256) NOT NULL,
Service_incidents_MAX VARCHAR2(256) NOT NULL,
Maintenance_events_MIN VARCHAR2(256) NOT NULL,
Maintenance_events_MAX VARCHAR2(256) NOT NULL,
Service_Status_MIN VARCHAR2(256) NOT NULL,
Service_Status_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBSrvcHlhTest_THRESH ADD constraint PK_ODBSrvcHlhTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSrvcHlhTest_THRESH ON ODBSrvcHlhTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSrvcHlhTest ON ODBSrvcHlhTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSrvcHlhTest ON ODBSrvcHlhTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBFileInteractnTest CASCADE CONSTRAINTS;
CREATE TABLE ODBFileInteractnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
File_vieworedit Number(20,4) NOT NULL,
File_vieworedit_ST varchar2(32) NOT NULL,
File_synced Number(20,4) NOT NULL,
File_synced_ST varchar2(32) NOT NULL,
File_shared_intern Number(20,4) NOT NULL,
File_shared_intern_ST varchar2(32) NOT NULL,
File_shared_extern Number(20,4) NOT NULL,
File_shared_extern_ST varchar2(32) NOT NULL,
Usr_vieworedit Number(20,4) NOT NULL,
Usr_vieworedit_ST varchar2(32) NOT NULL,
Usr_synced Number(20,4) NOT NULL,
Usr_synced_ST varchar2(32) NOT NULL,
Usr_shared_intern Number(20,4) NOT NULL,
Usr_shared_intern_ST varchar2(32) NOT NULL,
Usr_shared_extern Number(20,4) NOT NULL,
Usr_shared_extern_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBFileInteractnTest ON ODBFileInteractnTest(MSMT_TIME);
ALTER TABLE ODBFileInteractnTest ADD constraint PK_ODBFileInteractnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBFileInteractnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBFileInteractnTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
File_vieworedit_MIN Number(20,4) NOT NULL,
File_vieworedit_MAX Number(20,4) NOT NULL,
File_vieworedit_STCNT varchar2(32) NOT NULL,
File_synced_MIN Number(20,4) NOT NULL,
File_synced_MAX Number(20,4) NOT NULL,
File_synced_STCNT varchar2(32) NOT NULL,
File_shared_intern_MIN Number(20,4) NOT NULL,
File_shared_intern_MAX Number(20,4) NOT NULL,
File_shared_intern_STCNT varchar2(32) NOT NULL,
File_shared_extern_MIN Number(20,4) NOT NULL,
File_shared_extern_MAX Number(20,4) NOT NULL,
File_shared_extern_STCNT varchar2(32) NOT NULL,
Usr_vieworedit_MIN Number(20,4) NOT NULL,
Usr_vieworedit_MAX Number(20,4) NOT NULL,
Usr_vieworedit_STCNT varchar2(32) NOT NULL,
Usr_synced_MIN Number(20,4) NOT NULL,
Usr_synced_MAX Number(20,4) NOT NULL,
Usr_synced_STCNT varchar2(32) NOT NULL,
Usr_shared_intern_MIN Number(20,4) NOT NULL,
Usr_shared_intern_MAX Number(20,4) NOT NULL,
Usr_shared_intern_STCNT varchar2(32) NOT NULL,
Usr_shared_extern_MIN Number(20,4) NOT NULL,
Usr_shared_extern_MAX Number(20,4) NOT NULL,
Usr_shared_extern_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBFileInteractnTest_TREND ADD constraint PK_ODBFileInteractnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBFileInteractnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBFileInteractnTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
File_vieworedit_MIN VARCHAR2(256) NOT NULL,
File_vieworedit_MAX VARCHAR2(256) NOT NULL,
File_synced_MIN VARCHAR2(256) NOT NULL,
File_synced_MAX VARCHAR2(256) NOT NULL,
File_shared_intern_MIN VARCHAR2(256) NOT NULL,
File_shared_intern_MAX VARCHAR2(256) NOT NULL,
File_shared_extern_MIN VARCHAR2(256) NOT NULL,
File_shared_extern_MAX VARCHAR2(256) NOT NULL,
Usr_vieworedit_MIN VARCHAR2(256) NOT NULL,
Usr_vieworedit_MAX VARCHAR2(256) NOT NULL,
Usr_synced_MIN VARCHAR2(256) NOT NULL,
Usr_synced_MAX VARCHAR2(256) NOT NULL,
Usr_shared_intern_MIN VARCHAR2(256) NOT NULL,
Usr_shared_intern_MAX VARCHAR2(256) NOT NULL,
Usr_shared_extern_MIN VARCHAR2(256) NOT NULL,
Usr_shared_extern_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBFileInteractnTest_THRESH ADD constraint PK_ODBFileInteractnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFilIntractnTst_THRESH ON ODBFileInteractnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFileInteractnTest ON ODBFileInteractnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFileInteractnTest ON ODBFileInteractnTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBSharngActTest CASCADE CONSTRAINTS;
CREATE TABLE ODBSharngActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
Access_req_acceptance Number(20,4) NOT NULL,
Access_req_acceptance_ST varchar2(32) NOT NULL,
Sharng_invitatn_acceptnc Number(20,4) NOT NULL,
Sharng_invitatn_acceptnc_ST varchar2(32) NOT NULL,
Sharng_invitatn_blocked Number(20,4) NOT NULL,
Sharng_invitatn_blocked_ST varchar2(32) NOT NULL,
Company_link_creations Number(20,4) NOT NULL,
Company_link_creations_ST varchar2(32) NOT NULL,
Access_request_creations Number(20,4) NOT NULL,
Access_request_creations_ST varchar2(32) NOT NULL,
Anonymous_link_creations Number(20,4) NOT NULL,
Anonymous_link_creations_ST varchar2(32) NOT NULL,
Sharng_invitatn_creation Number(20,4) NOT NULL,
Sharng_invitatn_creation_ST varchar2(32) NOT NULL,
Access_request_denials Number(20,4) NOT NULL,
Access_request_denials_ST varchar2(32) NOT NULL,
Company_link_removals Number(20,4) NOT NULL,
Company_link_removals_ST varchar2(32) NOT NULL,
Anonymous_link_removals Number(20,4) NOT NULL,
Anonymous_link_removals_ST varchar2(32) NOT NULL,
File_Folder_Site_share Number(20,4) NOT NULL,
File_Folder_Site_share_ST varchar2(32) NOT NULL,
Anonymous_link_updates Number(20,4) NOT NULL,
Anonymous_link_updates_ST varchar2(32) NOT NULL,
Anonymous_link_usage Number(20,4) NOT NULL,
Anonymous_link_usage_ST varchar2(32) NOT NULL,
Sharing_revokes Number(20,4) NOT NULL,
Sharing_revokes_ST varchar2(32) NOT NULL,
Company_link_usage Number(20,4) NOT NULL,
Company_link_usage_ST varchar2(32) NOT NULL,
Sharng_invitatn_withdrw Number(20,4) NOT NULL,
Sharng_invitatn_withdrw_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBSharngActTest ON ODBSharngActTest(MSMT_TIME);
ALTER TABLE ODBSharngActTest ADD constraint PK_ODBSharngActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSharngActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBSharngActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
Access_req_acceptance_MIN Number(20,4) NOT NULL,
Access_req_acceptance_MAX Number(20,4) NOT NULL,
Access_req_acceptance_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_acceptnc_MIN Number(20,4) NOT NULL,
Sharng_invitatn_acceptnc_MAX Number(20,4) NOT NULL,
Sharng_invitatn_acceptnc_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_blocked_MIN Number(20,4) NOT NULL,
Sharng_invitatn_blocked_MAX Number(20,4) NOT NULL,
Sharng_invitatn_blocked_STCNT varchar2(32) NOT NULL,
Company_link_creations_MIN Number(20,4) NOT NULL,
Company_link_creations_MAX Number(20,4) NOT NULL,
Company_link_creations_STCNT varchar2(32) NOT NULL,
Access_request_creations_MIN Number(20,4) NOT NULL,
Access_request_creations_MAX Number(20,4) NOT NULL,
Access_request_creations_STCNT varchar2(32) NOT NULL,
Anonymous_link_creations_MIN Number(20,4) NOT NULL,
Anonymous_link_creations_MAX Number(20,4) NOT NULL,
Anonymous_link_creations_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_creation_MIN Number(20,4) NOT NULL,
Sharng_invitatn_creation_MAX Number(20,4) NOT NULL,
Sharng_invitatn_creation_STCNT varchar2(32) NOT NULL,
Access_request_denials_MIN Number(20,4) NOT NULL,
Access_request_denials_MAX Number(20,4) NOT NULL,
Access_request_denials_STCNT varchar2(32) NOT NULL,
Company_link_removals_MIN Number(20,4) NOT NULL,
Company_link_removals_MAX Number(20,4) NOT NULL,
Company_link_removals_STCNT varchar2(32) NOT NULL,
Anonymous_link_removals_MIN Number(20,4) NOT NULL,
Anonymous_link_removals_MAX Number(20,4) NOT NULL,
Anonymous_link_removals_STCNT varchar2(32) NOT NULL,
File_Folder_Site_share_MIN Number(20,4) NOT NULL,
File_Folder_Site_share_MAX Number(20,4) NOT NULL,
File_Folder_Site_share_STCNT varchar2(32) NOT NULL,
Anonymous_link_updates_MIN Number(20,4) NOT NULL,
Anonymous_link_updates_MAX Number(20,4) NOT NULL,
Anonymous_link_updates_STCNT varchar2(32) NOT NULL,
Anonymous_link_usage_MIN Number(20,4) NOT NULL,
Anonymous_link_usage_MAX Number(20,4) NOT NULL,
Anonymous_link_usage_STCNT varchar2(32) NOT NULL,
Sharing_revokes_MIN Number(20,4) NOT NULL,
Sharing_revokes_MAX Number(20,4) NOT NULL,
Sharing_revokes_STCNT varchar2(32) NOT NULL,
Company_link_usage_MIN Number(20,4) NOT NULL,
Company_link_usage_MAX Number(20,4) NOT NULL,
Company_link_usage_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_withdrw_MIN Number(20,4) NOT NULL,
Sharng_invitatn_withdrw_MAX Number(20,4) NOT NULL,
Sharng_invitatn_withdrw_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBSharngActTest_TREND ADD constraint PK_ODBSharngActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSharngActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBSharngActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
Access_req_acceptance_MIN VARCHAR2(256) NOT NULL,
Access_req_acceptance_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_acceptnc_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_acceptnc_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_blocked_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_blocked_MAX VARCHAR2(256) NOT NULL,
Company_link_creations_MIN VARCHAR2(256) NOT NULL,
Company_link_creations_MAX VARCHAR2(256) NOT NULL,
Access_request_creations_MIN VARCHAR2(256) NOT NULL,
Access_request_creations_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_creations_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_creations_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_creation_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_creation_MAX VARCHAR2(256) NOT NULL,
Access_request_denials_MIN VARCHAR2(256) NOT NULL,
Access_request_denials_MAX VARCHAR2(256) NOT NULL,
Company_link_removals_MIN VARCHAR2(256) NOT NULL,
Company_link_removals_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_removals_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_removals_MAX VARCHAR2(256) NOT NULL,
File_Folder_Site_share_MIN VARCHAR2(256) NOT NULL,
File_Folder_Site_share_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_updates_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_updates_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_usage_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_usage_MAX VARCHAR2(256) NOT NULL,
Sharing_revokes_MIN VARCHAR2(256) NOT NULL,
Sharing_revokes_MAX VARCHAR2(256) NOT NULL,
Company_link_usage_MIN VARCHAR2(256) NOT NULL,
Company_link_usage_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_withdrw_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_withdrw_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBSharngActTest_THRESH ADD constraint PK_ODBSharngActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSharngActTest_THRESH ON ODBSharngActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSharngActTest ON ODBSharngActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSharngActTest ON ODBSharngActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBSAdminActTest CASCADE CONSTRAINTS;
CREATE TABLE ODBSAdminActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
Usr_agent_exmpt_addition Number(20,4) NOT NULL,
Usr_agent_exmpt_addition_ST varchar2(32) NOT NULL,
Usr_agent_exmpt_modifitn Number(20,4) NOT NULL,
Usr_agent_exmpt_modifitn_ST varchar2(32) NOT NULL,
Sit_collectn_admin_addtn Number(20,4) NOT NULL,
Sit_collectn_admin_addtn_ST varchar2(32) NOT NULL,
User_group_additions Number(20,4) NOT NULL,
User_group_additions_ST varchar2(32) NOT NULL,
Add_usergroup_permits Number(20,4) NOT NULL,
Add_usergroup_permits_ST varchar2(32) NOT NULL,
Sharing_policy_modifctn Number(20,4) NOT NULL,
Sharing_policy_modifctn_ST varchar2(32) NOT NULL,
Group_additions Number(20,4) NOT NULL,
Group_additions_ST varchar2(32) NOT NULL,
Send_to_conn_creation Number(20,4) NOT NULL,
Send_to_conn_creation_ST varchar2(32) NOT NULL,
Site_collection_creation Number(20,4) NOT NULL,
Site_collection_creation_ST varchar2(32) NOT NULL,
Group_deletes Number(20,4) NOT NULL,
Group_deletes_ST varchar2(32) NOT NULL,
Send_to_conn_deletes Number(20,4) NOT NULL,
Send_to_conn_deletes_ST varchar2(32) NOT NULL,
Site_deletes Number(20,4) NOT NULL,
Site_deletes_ST varchar2(32) NOT NULL,
Document_preview_permits Number(20,4) NOT NULL,
Document_preview_permits_ST varchar2(32) NOT NULL,
Workflow_task_contnt Number(20,4) NOT NULL,
Workflow_task_contnt_ST varchar2(32) NOT NULL,
Office_ondemand_permits Number(20,4) NOT NULL,
Office_ondemand_permits_ST varchar2(32) NOT NULL,
News_feed_permits Number(20,4) NOT NULL,
News_feed_permits_ST varchar2(32) NOT NULL,
Site_permissn_modifictn Number(20,4) NOT NULL,
Site_permissn_modifictn_ST varchar2(32) NOT NULL,
Removals_from_group Number(20,4) NOT NULL,
Removals_from_group_ST varchar2(32) NOT NULL,
Site_renames Number(20,4) NOT NULL,
Site_renames_ST varchar2(32) NOT NULL,
Site_admin_requests Number(20,4) NOT NULL,
Site_admin_requests_ST varchar2(32) NOT NULL,
Host_site_changes Number(20,4) NOT NULL,
Host_site_changes_ST varchar2(32) NOT NULL,
Group_settings_changes Number(20,4) NOT NULL,
Group_settings_changes_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBSAdminActTest ON ODBSAdminActTest(MSMT_TIME);
ALTER TABLE ODBSAdminActTest ADD constraint PK_ODBSAdminActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSAdminActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBSAdminActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
Usr_agent_exmpt_addition_MIN Number(20,4) NOT NULL,
Usr_agent_exmpt_addition_MAX Number(20,4) NOT NULL,
Usr_agent_exmpt_addition_STCNT varchar2(32) NOT NULL,
Usr_agent_exmpt_modifitn_MIN Number(20,4) NOT NULL,
Usr_agent_exmpt_modifitn_MAX Number(20,4) NOT NULL,
Usr_agent_exmpt_modifitn_STCNT varchar2(32) NOT NULL,
Sit_collectn_admin_addtn_MIN Number(20,4) NOT NULL,
Sit_collectn_admin_addtn_MAX Number(20,4) NOT NULL,
Sit_collectn_admin_addtn_STCNT varchar2(32) NOT NULL,
User_group_additions_MIN Number(20,4) NOT NULL,
User_group_additions_MAX Number(20,4) NOT NULL,
User_group_additions_STCNT varchar2(32) NOT NULL,
Add_usergroup_permits_MIN Number(20,4) NOT NULL,
Add_usergroup_permits_MAX Number(20,4) NOT NULL,
Add_usergroup_permits_STCNT varchar2(32) NOT NULL,
Sharing_policy_modifctn_MIN Number(20,4) NOT NULL,
Sharing_policy_modifctn_MAX Number(20,4) NOT NULL,
Sharing_policy_modifctn_STCNT varchar2(32) NOT NULL,
Group_additions_MIN Number(20,4) NOT NULL,
Group_additions_MAX Number(20,4) NOT NULL,
Group_additions_STCNT varchar2(32) NOT NULL,
Send_to_conn_creation_MIN Number(20,4) NOT NULL,
Send_to_conn_creation_MAX Number(20,4) NOT NULL,
Send_to_conn_creation_STCNT varchar2(32) NOT NULL,
Site_collection_creation_MIN Number(20,4) NOT NULL,
Site_collection_creation_MAX Number(20,4) NOT NULL,
Site_collection_creation_STCNT varchar2(32) NOT NULL,
Group_deletes_MIN Number(20,4) NOT NULL,
Group_deletes_MAX Number(20,4) NOT NULL,
Group_deletes_STCNT varchar2(32) NOT NULL,
Send_to_conn_deletes_MIN Number(20,4) NOT NULL,
Send_to_conn_deletes_MAX Number(20,4) NOT NULL,
Send_to_conn_deletes_STCNT varchar2(32) NOT NULL,
Site_deletes_MIN Number(20,4) NOT NULL,
Site_deletes_MAX Number(20,4) NOT NULL,
Site_deletes_STCNT varchar2(32) NOT NULL,
Document_preview_permits_MIN Number(20,4) NOT NULL,
Document_preview_permits_MAX Number(20,4) NOT NULL,
Document_preview_permits_STCNT varchar2(32) NOT NULL,
Workflow_task_contnt_MIN Number(20,4) NOT NULL,
Workflow_task_contnt_MAX Number(20,4) NOT NULL,
Workflow_task_contnt_STCNT varchar2(32) NOT NULL,
Office_ondemand_permits_MIN Number(20,4) NOT NULL,
Office_ondemand_permits_MAX Number(20,4) NOT NULL,
Office_ondemand_permits_STCNT varchar2(32) NOT NULL,
News_feed_permits_MIN Number(20,4) NOT NULL,
News_feed_permits_MAX Number(20,4) NOT NULL,
News_feed_permits_STCNT varchar2(32) NOT NULL,
Site_permissn_modifictn_MIN Number(20,4) NOT NULL,
Site_permissn_modifictn_MAX Number(20,4) NOT NULL,
Site_permissn_modifictn_STCNT varchar2(32) NOT NULL,
Removals_from_group_MIN Number(20,4) NOT NULL,
Removals_from_group_MAX Number(20,4) NOT NULL,
Removals_from_group_STCNT varchar2(32) NOT NULL,
Site_renames_MIN Number(20,4) NOT NULL,
Site_renames_MAX Number(20,4) NOT NULL,
Site_renames_STCNT varchar2(32) NOT NULL,
Site_admin_requests_MIN Number(20,4) NOT NULL,
Site_admin_requests_MAX Number(20,4) NOT NULL,
Site_admin_requests_STCNT varchar2(32) NOT NULL,
Host_site_changes_MIN Number(20,4) NOT NULL,
Host_site_changes_MAX Number(20,4) NOT NULL,
Host_site_changes_STCNT varchar2(32) NOT NULL,
Group_settings_changes_MIN Number(20,4) NOT NULL,
Group_settings_changes_MAX Number(20,4) NOT NULL,
Group_settings_changes_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBSAdminActTest_TREND ADD constraint PK_ODBSAdminActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSAdminActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBSAdminActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_addition_MIN VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_addition_MAX VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_modifitn_MIN VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_modifitn_MAX VARCHAR2(256) NOT NULL,
Sit_collectn_admin_addtn_MIN VARCHAR2(256) NOT NULL,
Sit_collectn_admin_addtn_MAX VARCHAR2(256) NOT NULL,
User_group_additions_MIN VARCHAR2(256) NOT NULL,
User_group_additions_MAX VARCHAR2(256) NOT NULL,
Add_usergroup_permits_MIN VARCHAR2(256) NOT NULL,
Add_usergroup_permits_MAX VARCHAR2(256) NOT NULL,
Sharing_policy_modifctn_MIN VARCHAR2(256) NOT NULL,
Sharing_policy_modifctn_MAX VARCHAR2(256) NOT NULL,
Group_additions_MIN VARCHAR2(256) NOT NULL,
Group_additions_MAX VARCHAR2(256) NOT NULL,
Send_to_conn_creation_MIN VARCHAR2(256) NOT NULL,
Send_to_conn_creation_MAX VARCHAR2(256) NOT NULL,
Site_collection_creation_MIN VARCHAR2(256) NOT NULL,
Site_collection_creation_MAX VARCHAR2(256) NOT NULL,
Group_deletes_MIN VARCHAR2(256) NOT NULL,
Group_deletes_MAX VARCHAR2(256) NOT NULL,
Send_to_conn_deletes_MIN VARCHAR2(256) NOT NULL,
Send_to_conn_deletes_MAX VARCHAR2(256) NOT NULL,
Site_deletes_MIN VARCHAR2(256) NOT NULL,
Site_deletes_MAX VARCHAR2(256) NOT NULL,
Document_preview_permits_MIN VARCHAR2(256) NOT NULL,
Document_preview_permits_MAX VARCHAR2(256) NOT NULL,
Workflow_task_contnt_MIN VARCHAR2(256) NOT NULL,
Workflow_task_contnt_MAX VARCHAR2(256) NOT NULL,
Office_ondemand_permits_MIN VARCHAR2(256) NOT NULL,
Office_ondemand_permits_MAX VARCHAR2(256) NOT NULL,
News_feed_permits_MIN VARCHAR2(256) NOT NULL,
News_feed_permits_MAX VARCHAR2(256) NOT NULL,
Site_permissn_modifictn_MIN VARCHAR2(256) NOT NULL,
Site_permissn_modifictn_MAX VARCHAR2(256) NOT NULL,
Removals_from_group_MIN VARCHAR2(256) NOT NULL,
Removals_from_group_MAX VARCHAR2(256) NOT NULL,
Site_renames_MIN VARCHAR2(256) NOT NULL,
Site_renames_MAX VARCHAR2(256) NOT NULL,
Site_admin_requests_MIN VARCHAR2(256) NOT NULL,
Site_admin_requests_MAX VARCHAR2(256) NOT NULL,
Host_site_changes_MIN VARCHAR2(256) NOT NULL,
Host_site_changes_MAX VARCHAR2(256) NOT NULL,
Group_settings_changes_MIN VARCHAR2(256) NOT NULL,
Group_settings_changes_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBSAdminActTest_THRESH ADD constraint PK_ODBSAdminActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSAdminActTest_THRESH ON ODBSAdminActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSAdminActTest ON ODBSAdminActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSAdminActTest ON ODBSAdminActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBMsgCenTest CASCADE CONSTRAINTS;
CREATE TABLE ODBMsgCenTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MsgCenterCommunication Number(20,4) NOT NULL,
MsgCenterCommunication_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBMsgCenTest ON ODBMsgCenTest(MSMT_TIME);
ALTER TABLE ODBMsgCenTest ADD constraint PK_ODBMsgCenTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBMsgCenTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBMsgCenTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MsgCenterCommunication_MIN Number(20,4) NOT NULL,
MsgCenterCommunication_MAX Number(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBMsgCenTest_TREND ADD constraint PK_ODBMsgCenTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBMsgCenTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBMsgCenTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MsgCenterCommunication_MIN VARCHAR2(256) NOT NULL,
MsgCenterCommunication_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBMsgCenTest_THRESH ADD constraint PK_ODBMsgCenTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBMsgCenTest_THRESH ON ODBMsgCenTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBMsgCenTest ON ODBMsgCenTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBMsgCenTest ON ODBMsgCenTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBFolderActTest CASCADE CONSTRAINTS;
CREATE TABLE ODBFolderActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
Folder_copies Number(20,4) NOT NULL,
Folder_copies_ST varchar2(32) NOT NULL,
Folder_creations Number(20,4) NOT NULL,
Folder_creations_ST varchar2(32) NOT NULL,
Folder_deletions Number(20,4) NOT NULL,
Folder_deletions_ST varchar2(32) NOT NULL,
Folder_deletions_I_bin Number(20,4) NOT NULL,
Folder_deletions_I_bin_ST varchar2(32) NOT NULL,
Folder_deletions_II_bin Number(20,4) NOT NULL,
Folder_deletions_II_bin_ST varchar2(32) NOT NULL,
Folder_modifications Number(20,4) NOT NULL,
Folder_modifications_ST varchar2(32) NOT NULL,
Folder_moves Number(20,4) NOT NULL,
Folder_moves_ST varchar2(32) NOT NULL,
Folder_renames Number(20,4) NOT NULL,
Folder_renames_ST varchar2(32) NOT NULL,
Folder_restores Number(20,4) NOT NULL,
Folder_restores_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBFolderActTest ON ODBFolderActTest(MSMT_TIME);
ALTER TABLE ODBFolderActTest ADD constraint PK_ODBFolderActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBFolderActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBFolderActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
Folder_copies_MIN Number(20,4) NOT NULL,
Folder_copies_MAX Number(20,4) NOT NULL,
Folder_copies_STCNT varchar2(32) NOT NULL,
Folder_creations_MIN Number(20,4) NOT NULL,
Folder_creations_MAX Number(20,4) NOT NULL,
Folder_creations_STCNT varchar2(32) NOT NULL,
Folder_deletions_MIN Number(20,4) NOT NULL,
Folder_deletions_MAX Number(20,4) NOT NULL,
Folder_deletions_STCNT varchar2(32) NOT NULL,
Folder_deletions_I_bin_MIN Number(20,4) NOT NULL,
Folder_deletions_I_bin_MAX Number(20,4) NOT NULL,
Folder_deletions_I_bin_STCNT varchar2(32) NOT NULL,
Folder_deletions_II_bin_MIN Number(20,4) NOT NULL,
Folder_deletions_II_bin_MAX Number(20,4) NOT NULL,
Folder_deletions_II_bin_STCNT varchar2(32) NOT NULL,
Folder_modifications_MIN Number(20,4) NOT NULL,
Folder_modifications_MAX Number(20,4) NOT NULL,
Folder_modifications_STCNT varchar2(32) NOT NULL,
Folder_moves_MIN Number(20,4) NOT NULL,
Folder_moves_MAX Number(20,4) NOT NULL,
Folder_moves_STCNT varchar2(32) NOT NULL,
Folder_renames_MIN Number(20,4) NOT NULL,
Folder_renames_MAX Number(20,4) NOT NULL,
Folder_renames_STCNT varchar2(32) NOT NULL,
Folder_restores_MIN Number(20,4) NOT NULL,
Folder_restores_MAX Number(20,4) NOT NULL,
Folder_restores_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBFolderActTest_TREND ADD constraint PK_ODBFolderActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBFolderActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBFolderActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
Folder_copies_MIN VARCHAR2(256) NOT NULL,
Folder_copies_MAX VARCHAR2(256) NOT NULL,
Folder_creations_MIN VARCHAR2(256) NOT NULL,
Folder_creations_MAX VARCHAR2(256) NOT NULL,
Folder_deletions_MIN VARCHAR2(256) NOT NULL,
Folder_deletions_MAX VARCHAR2(256) NOT NULL,
Folder_deletions_I_bin_MIN VARCHAR2(256) NOT NULL,
Folder_deletions_I_bin_MAX VARCHAR2(256) NOT NULL,
Folder_deletions_II_bin_MIN VARCHAR2(256) NOT NULL,
Folder_deletions_II_bin_MAX VARCHAR2(256) NOT NULL,
Folder_modifications_MIN VARCHAR2(256) NOT NULL,
Folder_modifications_MAX VARCHAR2(256) NOT NULL,
Folder_moves_MIN VARCHAR2(256) NOT NULL,
Folder_moves_MAX VARCHAR2(256) NOT NULL,
Folder_renames_MIN VARCHAR2(256) NOT NULL,
Folder_renames_MAX VARCHAR2(256) NOT NULL,
Folder_restores_MIN VARCHAR2(256) NOT NULL,
Folder_restores_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBFolderActTest_THRESH ADD constraint PK_ODBFolderActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFolderActTest_THRESH ON ODBFolderActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFolderActTest ON ODBFolderActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFolderActTest ON ODBFolderActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBSiteUsageTest CASCADE CONSTRAINTS;
CREATE TABLE ODBSiteUsageTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_sites Number(20,4) NOT NULL,
Total_sites_ST varchar2(32) NOT NULL,
Active_sites Number(20,4) NOT NULL,
Active_sites_ST varchar2(32) NOT NULL,
Active_site_percent Number(20,4) NOT NULL,
Active_site_percent_ST varchar2(32) NOT NULL,
Inactiv_sites Number(20,4) NOT NULL,
Inactiv_sites_ST varchar2(32) NOT NULL,
Strgusd_site Number(20,4) NOT NULL,
Strgusd_site_ST varchar2(32) NOT NULL,
Strgalctd_site Number(20,4) NOT NULL,
Strgalctd_site_ST varchar2(32) NOT NULL,
Strg_used Number(20,4) NOT NULL,
Strg_used_ST varchar2(32) NOT NULL,
Strg_limit Number(20,4) NOT NULL,
Strg_limit_ST varchar2(32) NOT NULL,
Orph_sites Number(20,4) NOT NULL,
Orph_sites_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBSiteUsageTest ON ODBSiteUsageTest(MSMT_TIME);
ALTER TABLE ODBSiteUsageTest ADD constraint PK_ODBSiteUsageTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSiteUsageTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBSiteUsageTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_sites_MIN Number(20,4) NOT NULL,
Total_sites_MAX Number(20,4) NOT NULL,
Total_sites_STCNT varchar2(32) NOT NULL,
Active_sites_MIN Number(20,4) NOT NULL,
Active_sites_MAX Number(20,4) NOT NULL,
Active_sites_STCNT varchar2(32) NOT NULL,
Active_site_percent_MIN Number(20,4) NOT NULL,
Active_site_percent_MAX Number(20,4) NOT NULL,
Active_site_percent_STCNT varchar2(32) NOT NULL,
Inactiv_sites_MIN Number(20,4) NOT NULL,
Inactiv_sites_MAX Number(20,4) NOT NULL,
Inactiv_sites_STCNT varchar2(32) NOT NULL,
Strgusd_site_MIN Number(20,4) NOT NULL,
Strgusd_site_MAX Number(20,4) NOT NULL,
Strgusd_site_STCNT varchar2(32) NOT NULL,
Strgalctd_site_MIN Number(20,4) NOT NULL,
Strgalctd_site_MAX Number(20,4) NOT NULL,
Strgalctd_site_STCNT varchar2(32) NOT NULL,
Strg_used_MIN Number(20,4) NOT NULL,
Strg_used_MAX Number(20,4) NOT NULL,
Strg_used_STCNT varchar2(32) NOT NULL,
Strg_limit_MIN Number(20,4) NOT NULL,
Strg_limit_MAX Number(20,4) NOT NULL,
Strg_limit_STCNT varchar2(32) NOT NULL,
Orph_sites_MIN Number(20,4) NOT NULL,
Orph_sites_MAX Number(20,4) NOT NULL,
Orph_sites_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBSiteUsageTest_TREND ADD constraint PK_ODBSiteUsageTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSiteUsageTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBSiteUsageTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_sites_MIN VARCHAR2(256) NOT NULL,
Total_sites_MAX VARCHAR2(256) NOT NULL,
Active_sites_MIN VARCHAR2(256) NOT NULL,
Active_sites_MAX VARCHAR2(256) NOT NULL,
Active_site_percent_MIN VARCHAR2(256) NOT NULL,
Active_site_percent_MAX VARCHAR2(256) NOT NULL,
Inactiv_sites_MIN VARCHAR2(256) NOT NULL,
Inactiv_sites_MAX VARCHAR2(256) NOT NULL,
Strgusd_site_MIN VARCHAR2(256) NOT NULL,
Strgusd_site_MAX VARCHAR2(256) NOT NULL,
Strgalctd_site_MIN VARCHAR2(256) NOT NULL,
Strgalctd_site_MAX VARCHAR2(256) NOT NULL,
Strg_used_MIN VARCHAR2(256) NOT NULL,
Strg_used_MAX VARCHAR2(256) NOT NULL,
Strg_limit_MIN VARCHAR2(256) NOT NULL,
Strg_limit_MAX VARCHAR2(256) NOT NULL,
Orph_sites_MIN VARCHAR2(256) NOT NULL,
Orph_sites_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBSiteUsageTest_THRESH ADD constraint PK_ODBSiteUsageTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSiteUsageTest_THRESH ON ODBSiteUsageTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSiteUsageTest ON ODBSiteUsageTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSiteUsageTest ON ODBSiteUsageTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBFileUsageTest CASCADE CONSTRAINTS;
CREATE TABLE ODBFileUsageTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_file Number(20,4) NOT NULL,
Total_file_ST varchar2(32) NOT NULL,
Active_file Number(20,4) NOT NULL,
Active_file_ST varchar2(32) NOT NULL,
Active_file_percent Number(20,4) NOT NULL,
Active_file_percent_ST varchar2(32) NOT NULL,
File_growth_rate Number(20,4) NOT NULL,
File_growth_rate_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBFileUsageTest ON ODBFileUsageTest(MSMT_TIME);
ALTER TABLE ODBFileUsageTest ADD constraint PK_ODBFileUsageTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBFileUsageTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBFileUsageTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_file_MIN Number(20,4) NOT NULL,
Total_file_MAX Number(20,4) NOT NULL,
Total_file_STCNT varchar2(32) NOT NULL,
Active_file_MIN Number(20,4) NOT NULL,
Active_file_MAX Number(20,4) NOT NULL,
Active_file_STCNT varchar2(32) NOT NULL,
Active_file_percent_MIN Number(20,4) NOT NULL,
Active_file_percent_MAX Number(20,4) NOT NULL,
Active_file_percent_STCNT varchar2(32) NOT NULL,
File_growth_rate_MIN Number(20,4) NOT NULL,
File_growth_rate_MAX Number(20,4) NOT NULL,
File_growth_rate_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBFileUsageTest_TREND ADD constraint PK_ODBFileUsageTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBFileUsageTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBFileUsageTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_file_MIN VARCHAR2(256) NOT NULL,
Total_file_MAX VARCHAR2(256) NOT NULL,
Active_file_MIN VARCHAR2(256) NOT NULL,
Active_file_MAX VARCHAR2(256) NOT NULL,
Active_file_percent_MIN VARCHAR2(256) NOT NULL,
Active_file_percent_MAX VARCHAR2(256) NOT NULL,
File_growth_rate_MIN VARCHAR2(256) NOT NULL,
File_growth_rate_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBFileUsageTest_THRESH ADD constraint PK_ODBFileUsageTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFileUsageTest_THRESH ON ODBFileUsageTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFileUsageTest ON ODBFileUsageTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFileUsageTest ON ODBFileUsageTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE EXOUsrConByAppTest CASCADE CONSTRAINTS;
CREATE TABLE EXOUsrConByAppTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date,
usrcount Number(20,4) NOT NULL,
usrcount_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_EXOUsrConByAppTest ON EXOUsrConByAppTest(MSMT_TIME);
ALTER TABLE EXOUsrConByAppTest ADD constraint PK_EXOUsrConByAppTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOUsrConByAppTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOUsrConByAppTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date,
PERIOD       	varchar2(32) NOT NULL,
usrcount_MIN Number(20,4) NOT NULL,
usrcount_MAX Number(20,4) NOT NULL,
usrcount_STCNT varchar2(32) NOT NULL
);

ALTER TABLE EXOUsrConByAppTest_TREND ADD constraint PK_EXOUsrConByAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOUsrConByAppTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOUsrConByAppTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date,
MSMT_TIME_END   date,
usrcount_MIN varchar2(256) NOT NULL,
usrcount_MAX varchar2(256) NOT NULL
);

ALTER TABLE EXOUsrConByAppTest_THRESH ADD constraint PK_EXOUsrConByAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOUsrConByAppTest_THRESH ON EXOUsrConByAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOUsrConByAppTest ON EXOUsrConByAppTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOUsrConByAppTest ON EXOUsrConByAppTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXOUsrLyncVersnTest CASCADE CONSTRAINTS;
CREATE TABLE EXOUsrLyncVersnTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date,
usrcount Number(20,4) NOT NULL,
usrcount_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_EXOUsrLyncVersnTest ON EXOUsrLyncVersnTest(MSMT_TIME);
ALTER TABLE EXOUsrLyncVersnTest ADD constraint PK_EXOUsrLyncVersnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOUsrLyncVersnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOUsrLyncVersnTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date,
PERIOD       	varchar2(32) NOT NULL,
usrcount_MIN Number(20,4) NOT NULL,
usrcount_MAX Number(20,4) NOT NULL,
usrcount_STCNT varchar2(32) NOT NULL
);

ALTER TABLE EXOUsrLyncVersnTest_TREND ADD constraint PK_EXOUsrLyncVersnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOUsrLyncVersnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOUsrLyncVersnTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date,
MSMT_TIME_END   date,
usrcount_MIN varchar2(256) NOT NULL,
usrcount_MAX varchar2(256) NOT NULL
);

ALTER TABLE EXOUsrLyncVersnTest_THRESH ADD constraint PK_EXOUsrLyncVersnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOUsrLyncVersnTest_THRESH ON EXOUsrLyncVersnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOUsrLyncVersnTest ON EXOUsrLyncVersnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOUsrLyncVersnTest ON EXOUsrLyncVersnTest_TREND (MSMT_TIME,PERIOD);






DROP TABLE SPOSitUsageSumTest CASCADE CONSTRAINTS;
CREATE TABLE SPOSitUsageSumTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date,
TOTAL_SITES Number(20,4) NOT NULL,
TOTAL_SITES_ST varchar2(32) NOT NULL,
ACTIVE_SITES Number(20,4) NOT NULL,
ACTIVE_SITES_ST varchar2(32) NOT NULL,
TOTAL_FILES Number(20,4) NOT NULL,
TOTAL_FILES_ST varchar2(32) NOT NULL,
ACTIVE_FILES Number(20,4) NOT NULL,
ACTIVE_FILES_ST varchar2(32) NOT NULL,
ACTIVE_FILES_PERCENT Number(20,4) NOT NULL,
ACTIVE_FILES_PERCENT_ST varchar2(32) NOT NULL,
PAGE_VIEWS Number(20,4) NOT NULL,
PAGE_VIEWS_ST varchar2(32) NOT NULL,
VISITED_PAGES Number(20,4) NOT NULL,
VISITED_PAGES_ST varchar2(32) NOT NULL,
SITE_CONSUMING Number(20,4) NOT NULL,
SITE_CONSUMING_ST varchar2(32) NOT NULL,
STORAGE_USED Number(20,4) NOT NULL,
STORAGE_USED_ST varchar2(32) NOT NULL,
STORAGE_ALLOCATED Number(20,4) NOT NULL,
STORAGE_ALLOCATED_ST varchar2(32) NOT NULL,
STORAGE_USED_PERCENT Number(20,4) NOT NULL,
STORAGE_USED_PERCENT_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOSitUsageSumTest ON SPOSitUsageSumTest(MSMT_TIME);
ALTER TABLE SPOSitUsageSumTest ADD constraint PK_SPOSitUsageSumTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSitUsageSumTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOSitUsageSumTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date,
PERIOD       	varchar2(32) NOT NULL,
TOTAL_SITES_MIN Number(20,4) NOT NULL,
TOTAL_SITES_MAX Number(20,4) NOT NULL,
TOTAL_SITES_STCNT varchar2(32) NOT NULL,
ACTIVE_SITES_MIN Number(20,4) NOT NULL,
ACTIVE_SITES_MAX Number(20,4) NOT NULL,
ACTIVE_SITES_STCNT varchar2(32) NOT NULL,
TOTAL_FILES_MIN Number(20,4) NOT NULL,
TOTAL_FILES_MAX Number(20,4) NOT NULL,
TOTAL_FILES_STCNT varchar2(32) NOT NULL,
ACTIVE_FILES_MIN Number(20,4) NOT NULL,
ACTIVE_FILES_MAX Number(20,4) NOT NULL,
ACTIVE_FILES_STCNT varchar2(32) NOT NULL,
ACTIVE_FILES_PERCENT_MIN Number(20,4) NOT NULL,
ACTIVE_FILES_PERCENT_MAX Number(20,4) NOT NULL,
ACTIVE_FILES_PERCENT_STCNT varchar2(32) NOT NULL,
PAGE_VIEWS_MIN Number(20,4) NOT NULL,
PAGE_VIEWS_MAX Number(20,4) NOT NULL,
PAGE_VIEWS_STCNT varchar2(32) NOT NULL,
VISITED_PAGES_MIN Number(20,4) NOT NULL,
VISITED_PAGES_MAX Number(20,4) NOT NULL,
VISITED_PAGES_STCNT varchar2(32) NOT NULL,
SITE_CONSUMING_MIN Number(20,4) NOT NULL,
SITE_CONSUMING_MAX Number(20,4) NOT NULL,
SITE_CONSUMING_STCNT varchar2(32) NOT NULL,
STORAGE_USED_MIN Number(20,4) NOT NULL,
STORAGE_USED_MAX Number(20,4) NOT NULL,
STORAGE_USED_STCNT varchar2(32) NOT NULL,
STORAGE_ALLOCATED_MIN Number(20,4) NOT NULL,
STORAGE_ALLOCATED_MAX Number(20,4) NOT NULL,
STORAGE_ALLOCATED_STCNT varchar2(32) NOT NULL,
STORAGE_USED_PERCENT_MIN Number(20,4) NOT NULL,
STORAGE_USED_PERCENT_MAX Number(20,4) NOT NULL,
STORAGE_USED_PERCENT_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOSitUsageSumTest_TREND ADD constraint PK_SPOSitUsgSumTst_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSitUsageSumTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOSitUsageSumTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_SITES_MIN varchar2(256) NOT NULL,
TOTAL_SITES_MAX varchar2(256) NOT NULL,
ACTIVE_SITES_MIN varchar2(256) NOT NULL,
ACTIVE_SITES_MAX varchar2(256) NOT NULL,
TOTAL_FILES_MIN varchar2(256) NOT NULL,
TOTAL_FILES_MAX varchar2(256) NOT NULL,
ACTIVE_FILES_MIN varchar2(256) NOT NULL,
ACTIVE_FILES_MAX varchar2(256) NOT NULL,
ACTIVE_FILES_PERCENT_MIN varchar2(256) NOT NULL,
ACTIVE_FILES_PERCENT_MAX varchar2(256) NOT NULL,
PAGE_VIEWS_MIN varchar2(256) NOT NULL,
PAGE_VIEWS_MAX varchar2(256) NOT NULL,
VISITED_PAGES_MIN varchar2(256) NOT NULL,
VISITED_PAGES_MAX varchar2(256) NOT NULL,
SITE_CONSUMING_MIN varchar2(256) NOT NULL,
SITE_CONSUMING_MAX varchar2(256) NOT NULL,
STORAGE_USED_MIN varchar2(256) NOT NULL,
STORAGE_USED_MAX varchar2(256) NOT NULL,
STORAGE_ALLOCATED_MIN varchar2(256) NOT NULL,
STORAGE_ALLOCATED_MAX varchar2(256) NOT NULL,
STORAGE_USED_PERCENT_MIN varchar2(256) NOT NULL,
STORAGE_USED_PERCENT_MAX varchar2(256) NOT NULL);

ALTER TABLE SPOSitUsageSumTest_THRESH ADD constraint PK_SPOSitUsgSumTst_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSitUsSumTst_THRESH ON SPOSitUsageSumTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSitUsgSumTst ON SPOSitUsageSumTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSitUsgSumTst ON SPOSitUsageSumTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE MTMSrvcHlhTest CASCADE CONSTRAINTS;
CREATE TABLE MTMSrvcHlhTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SERVICE_INCIDENTS Number(20,4) NOT NULL,
SERVICE_INCIDENTS_ST varchar2(32) NOT NULL,
MAINTENANCE_EVENTS Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_ST varchar2(32) NOT NULL,
SERVICE_STATUS Number(20,4) NOT NULL,
SERVICE_STATUS_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_MTMSrvcHlhTest ON MTMSrvcHlhTest(MSMT_TIME);
ALTER TABLE MTMSrvcHlhTest ADD constraint PK_MTMSrvcHlhTest PRIMARY KEY(
TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMSrvcHlhTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMSrvcHlhTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SERVICE_INCIDENTS_MIN Number(20,4) NOT NULL,
SERVICE_INCIDENTS_MAX Number(20,4) NOT NULL,
SERVICE_INCIDENTS_STCNT varchar2(32) NOT NULL,
MAINTENANCE_EVENTS_MIN Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_MAX Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_STCNT varchar2(32) NOT NULL,
SERVICE_STATUS_MIN Number(20,4) NOT NULL,
SERVICE_STATUS_MAX Number(20,4) NOT NULL,
SERVICE_STATUS_STCNT varchar2(32) NOT NULL);
ALTER TABLE MTMSrvcHlhTest_TREND ADD constraint PK_MTMSrvcHlhTest_TREND PRIMARY KEY(
TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMSrvcHlhTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMSrvcHlhTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SERVICE_INCIDENTS_MIN varchar2(256) NOT NULL,
SERVICE_INCIDENTS_MAX varchar2(256) NOT NULL,
MAINTENANCE_EVENTS_MIN varchar2(256) NOT NULL,
MAINTENANCE_EVENTS_MAX varchar2(256) NOT NULL,
SERVICE_STATUS_MIN varchar2(256) NOT NULL,
SERVICE_STATUS_MAX varchar2(256) NOT NULL);
ALTER TABLE MTMSrvcHlhTest_THRESH ADD constraint PK_MTMSrvcHlhTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMSrvcHlhTest_THRESH ON MTMSrvcHlhTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMSrvcHlhTest ON MTMSrvcHlhTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMSrvcHlhTest ON MTMSrvcHlhTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMAudioStrmsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMAudioStrmsTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
AStrm Number(20,4) NOT NULL,
AStrm_ST varchar2(32) NOT NULL,
APrStm Number(20,4) NOT NULL,
APrStm_ST varchar2(32) NOT NULL,
AGdStm Number(20,4) NOT NULL,
AGdStm_ST varchar2(32) NOT NULL,
AUcfStm Number(20,4) NOT NULL,
AUcfStm_ST varchar2(32) NOT NULL,
APrPrct Number(20,4) NOT NULL,
APrPrct_ST varchar2(32) NOT NULL,
APrDJtr Number(20,4) NOT NULL,
APrDJtr_ST varchar2(32) NOT NULL,
APrDPktLs Number(20,4) NOT NULL,
APrDPktLs_ST varchar2(32) NOT NULL,
APrDDgdtn Number(20,4) NOT NULL,
APrDDgdtn_ST varchar2(32) NOT NULL,
APrDRndTp Number(20,4) NOT NULL,
APrDRndTp_ST varchar2(32) NOT NULL,
APrDCnclRt Number(20,4) NOT NULL,
APrDCnclRt_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_MTMAudioStrmsTest ON MTMAudioStrmsTest(MSMT_TIME);
ALTER TABLE MTMAudioStrmsTest ADD constraint PK_MTMAudioStrmsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMAudioStrmsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMAudioStrmsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AStrm_MIN Number(20,4) NOT NULL,
AStrm_MAX Number(20,4) NOT NULL,
AStrm_STCNT varchar2(32) NOT NULL,
APrStm_MIN Number(20,4) NOT NULL,
APrStm_MAX Number(20,4) NOT NULL,
APrStm_STCNT varchar2(32) NOT NULL,
AGdStm_MIN Number(20,4) NOT NULL,
AGdStm_MAX Number(20,4) NOT NULL,
AGdStm_STCNT varchar2(32) NOT NULL,
AUcfStm_MIN Number(20,4) NOT NULL,
AUcfStm_MAX Number(20,4) NOT NULL,
AUcfStm_STCNT varchar2(32) NOT NULL,
APrPrct_MIN Number(20,4) NOT NULL,
APrPrct_MAX Number(20,4) NOT NULL,
APrPrct_STCNT varchar2(32) NOT NULL,
APrDJtr_MIN Number(20,4) NOT NULL,
APrDJtr_MAX Number(20,4) NOT NULL,
APrDJtr_STCNT varchar2(32) NOT NULL,
APrDPktLs_MIN Number(20,4) NOT NULL,
APrDPktLs_MAX Number(20,4) NOT NULL,
APrDPktLs_STCNT varchar2(32) NOT NULL,
APrDDgdtn_MIN Number(20,4) NOT NULL,
APrDDgdtn_MAX Number(20,4) NOT NULL,
APrDDgdtn_STCNT varchar2(32) NOT NULL,
APrDRndTp_MIN Number(20,4) NOT NULL,
APrDRndTp_MAX Number(20,4) NOT NULL,
APrDRndTp_STCNT varchar2(32) NOT NULL,
APrDCnclRt_MIN Number(20,4) NOT NULL,
APrDCnclRt_MAX Number(20,4) NOT NULL,
APrDCnclRt_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MTMAudioStrmsTest_TREND ADD constraint PK_MTMAudioStrmsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMAudioStrmsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMAudioStrmsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
AStrm_MIN varchar2(256) NOT NULL,
AStrm_MAX varchar2(256) NOT NULL,
APrStm_MIN varchar2(256) NOT NULL,
APrStm_MAX varchar2(256) NOT NULL,
AGdStm_MIN varchar2(256) NOT NULL,
AGdStm_MAX varchar2(256) NOT NULL,
AUcfStm_MIN varchar2(256) NOT NULL,
AUcfStm_MAX varchar2(256) NOT NULL,
APrPrct_MIN varchar2(256) NOT NULL,
APrPrct_MAX varchar2(256) NOT NULL,
APrDJtr_MIN varchar2(256) NOT NULL,
APrDJtr_MAX varchar2(256) NOT NULL,
APrDPktLs_MIN varchar2(256) NOT NULL,
APrDPktLs_MAX varchar2(256) NOT NULL,
APrDDgdtn_MIN varchar2(256) NOT NULL,
APrDDgdtn_MAX varchar2(256) NOT NULL,
APrDRndTp_MIN varchar2(256) NOT NULL,
APrDRndTp_MAX varchar2(256) NOT NULL,
APrDCnclRt_MIN varchar2(256) NOT NULL,
APrDCnclRt_MAX varchar2(256) NOT NULL
);

ALTER TABLE MTMAudioStrmsTest_THRESH ADD constraint PK_MTMAudioStrmsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMAudioStrmsTest_THRESH ON MTMAudioStrmsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMAudioStrmsTest ON MTMAudioStrmsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMAudioStrmsTest ON MTMAudioStrmsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMNtwkQtySmyTest CASCADE CONSTRAINTS;
CREATE TABLE MTMNtwkQtySmyTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
AvgAudDgtn Number(20,4) NOT NULL,
AvgAudDgtn_ST varchar2(32) NOT NULL,
AvgJitter Number(20,4) NOT NULL,
AvgJitter_ST varchar2(32) NOT NULL,
MxmJitter Number(20,4) NOT NULL,
MxmJitter_ST varchar2(32) NOT NULL,
AvgPtLsRt Number(20,4) NOT NULL,
AvgPtLsRt_ST varchar2(32) NOT NULL,
MxPtLsRte Number(20,4) NOT NULL,
MxPtLsRte_ST varchar2(32) NOT NULL,
AvgSdLnMOS Number(20,4) NOT NULL,
AvgSdLnMOS_ST varchar2(32) NOT NULL,
OrlAvgNtMOS Number(20,4) NOT NULL,
OrlAvgNtMOS_ST varchar2(32) NOT NULL,
CnldSmplAvg Number(20,4) NOT NULL,
CnldSmplAvg_ST varchar2(32) NOT NULL,
AvgRtStchSpl Number(20,4) NOT NULL,
AvgRtStchSpl_ST varchar2(32) NOT NULL,
AvgRndTrip Number(20,4) NOT NULL,
AvgRndTrip_ST varchar2(32) NOT NULL,
AvgRndTripMx Number(20,4) NOT NULL,
AvgRndTripMx_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_MTMNtwkQtySmyTest ON MTMNtwkQtySmyTest(MSMT_TIME);
ALTER TABLE MTMNtwkQtySmyTest ADD constraint PK_MTMNtwkQtySmyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMNtwkQtySmyTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMNtwkQtySmyTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AvgAudDgtn_MIN Number(20,4) NOT NULL,
AvgAudDgtn_MAX Number(20,4) NOT NULL,
AvgAudDgtn_STCNT varchar2(32) NOT NULL,
AvgJitter_MIN Number(20,4) NOT NULL,
AvgJitter_MAX Number(20,4) NOT NULL,
AvgJitter_STCNT varchar2(32) NOT NULL,
MxmJitter_MIN Number(20,4) NOT NULL,
MxmJitter_MAX Number(20,4) NOT NULL,
MxmJitter_STCNT varchar2(32) NOT NULL,
AvgPtLsRt_MIN Number(20,4) NOT NULL,
AvgPtLsRt_MAX Number(20,4) NOT NULL,
AvgPtLsRt_STCNT varchar2(32) NOT NULL,
MxPtLsRte_MIN Number(20,4) NOT NULL,
MxPtLsRte_MAX Number(20,4) NOT NULL,
MxPtLsRte_STCNT varchar2(32) NOT NULL,
AvgSdLnMOS_MIN Number(20,4) NOT NULL,
AvgSdLnMOS_MAX Number(20,4) NOT NULL,
AvgSdLnMOS_STCNT varchar2(32) NOT NULL,
OrlAvgNtMOS_MIN Number(20,4) NOT NULL,
OrlAvgNtMOS_MAX Number(20,4) NOT NULL,
OrlAvgNtMOS_STCNT varchar2(32) NOT NULL,
CnldSmplAvg_MIN Number(20,4) NOT NULL,
CnldSmplAvg_MAX Number(20,4) NOT NULL,
CnldSmplAvg_STCNT varchar2(32) NOT NULL,
AvgRtStchSpl_MIN Number(20,4) NOT NULL,
AvgRtStchSpl_MAX Number(20,4) NOT NULL,
AvgRtStchSpl_STCNT varchar2(32) NOT NULL,
AvgRndTrip_MIN Number(20,4) NOT NULL,
AvgRndTrip_MAX Number(20,4) NOT NULL,
AvgRndTrip_STCNT varchar2(32) NOT NULL,
AvgRndTripMx_MIN Number(20,4) NOT NULL,
AvgRndTripMx_MAX Number(20,4) NOT NULL,
AvgRndTripMx_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MTMNtwkQtySmyTest_TREND ADD constraint PK_MTMNtwkQtySmyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMNtwkQtySmyTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMNtwkQtySmyTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
AvgAudDgtn_MIN varchar2(256) NOT NULL,
AvgAudDgtn_MAX varchar2(256) NOT NULL,
AvgJitter_MIN varchar2(256) NOT NULL,
AvgJitter_MAX varchar2(256) NOT NULL,
MxmJitter_MIN varchar2(256) NOT NULL,
MxmJitter_MAX varchar2(256) NOT NULL,
AvgPtLsRt_MIN varchar2(256) NOT NULL,
AvgPtLsRt_MAX varchar2(256) NOT NULL,
MxPtLsRte_MIN varchar2(256) NOT NULL,
MxPtLsRte_MAX varchar2(256) NOT NULL,
AvgSdLnMOS_MIN varchar2(256) NOT NULL,
AvgSdLnMOS_MAX varchar2(256) NOT NULL,
OrlAvgNtMOS_MIN varchar2(256) NOT NULL,
OrlAvgNtMOS_MAX varchar2(256) NOT NULL,
CnldSmplAvg_MIN varchar2(256) NOT NULL,
CnldSmplAvg_MAX varchar2(256) NOT NULL,
AvgRtStchSpl_MIN varchar2(256) NOT NULL,
AvgRtStchSpl_MAX varchar2(256) NOT NULL,
AvgRndTrip_MIN varchar2(256) NOT NULL,
AvgRndTrip_MAX varchar2(256) NOT NULL,
AvgRndTripMx_MIN varchar2(256) NOT NULL,
AvgRndTripMx_MAX varchar2(256) NOT NULL
);

ALTER TABLE MTMNtwkQtySmyTest_THRESH ADD constraint PK_MTMNtwkQtySmyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMNtwkQtySmyTest_THRESH ON MTMNtwkQtySmyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMNtwkQtySmyTest ON MTMNtwkQtySmyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMNtwkQtySmyTest ON MTMNtwkQtySmyTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMVideoStreamsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMVideoStreamsTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Strmcnt Number(20,4) NOT NULL,
Strmcnt_ST varchar2(32) NOT NULL,
ViPstFclr Number(20,4) NOT NULL,
ViPstFclr_ST varchar2(32) NOT NULL,
ViLFrPrAg Number(20,4) NOT NULL,
ViLFrPrAg_ST varchar2(32) NOT NULL,
ViFrRteAg Number(20,4) NOT NULL,
ViFrRteAg_ST varchar2(32) NOT NULL,
PrStrmcnt Number(20,4) NOT NULL,
PrStrmcnt_ST varchar2(32) NOT NULL,
GdStrmCnt Number(20,4) NOT NULL,
GdStrmCnt_ST varchar2(32) NOT NULL,
UncfdSmCnt Number(20,4) NOT NULL,
UncfdSmCnt_ST varchar2(32) NOT NULL,
PrPercent Number(20,4) NOT NULL,
PrPercent_ST varchar2(32) NOT NULL,
AvPsFECPLR Number(20,4) NOT NULL,
AvPsFECPLR_ST varchar2(32) NOT NULL,
AvLclFmLs Number(20,4) NOT NULL,
AvLclFmLs_ST varchar2(32) NOT NULL,
AvRcvFmRtAg Number(20,4) NOT NULL,
AvRcvFmRtAg_ST varchar2(32) NOT NULL,
AvLwFmRtCPt Number(20,4) NOT NULL,
AvLwFmRtCPt_ST varchar2(32) NOT NULL,
AvPktLsRt Number(20,4) NOT NULL,
AvPktLsRt_ST varchar2(32) NOT NULL,
AvDycCpyPnt Number(20,4) NOT NULL,
AvDycCpyPnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMVideoStreamsTest ON MTMVideoStreamsTest(MSMT_TIME);
ALTER TABLE MTMVideoStreamsTest ADD constraint PK_MTMVideoStreamsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMVideoStreamsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMVideoStreamsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Strmcnt_MIN Number(20,4) NOT NULL,
Strmcnt_MAX Number(20,4) NOT NULL,
Strmcnt_STCNT varchar2(32) NOT NULL,
ViPstFclr_MIN Number(20,4) NOT NULL,
ViPstFclr_MAX Number(20,4) NOT NULL,
ViPstFclr_STCNT varchar2(32) NOT NULL,
ViLFrPrAg_MIN Number(20,4) NOT NULL,
ViLFrPrAg_MAX Number(20,4) NOT NULL,
ViLFrPrAg_STCNT varchar2(32) NOT NULL,
ViFrRteAg_MIN Number(20,4) NOT NULL,
ViFrRteAg_MAX Number(20,4) NOT NULL,
ViFrRteAg_STCNT varchar2(32) NOT NULL,
PrStrmcnt_MIN Number(20,4) NOT NULL,
PrStrmcnt_MAX Number(20,4) NOT NULL,
PrStrmcnt_STCNT varchar2(32) NOT NULL,
GdStrmCnt_MIN Number(20,4) NOT NULL,
GdStrmCnt_MAX Number(20,4) NOT NULL,
GdStrmCnt_STCNT varchar2(32) NOT NULL,
UncfdSmCnt_MIN Number(20,4) NOT NULL,
UncfdSmCnt_MAX Number(20,4) NOT NULL,
UncfdSmCnt_STCNT varchar2(32) NOT NULL,
PrPercent_MIN Number(20,4) NOT NULL,
PrPercent_MAX Number(20,4) NOT NULL,
PrPercent_STCNT varchar2(32) NOT NULL,
AvPsFECPLR_MIN Number(20,4) NOT NULL,
AvPsFECPLR_MAX Number(20,4) NOT NULL,
AvPsFECPLR_STCNT varchar2(32) NOT NULL,
AvLclFmLs_MIN Number(20,4) NOT NULL,
AvLclFmLs_MAX Number(20,4) NOT NULL,
AvLclFmLs_STCNT varchar2(32) NOT NULL,
AvRcvFmRtAg_MIN Number(20,4) NOT NULL,
AvRcvFmRtAg_MAX Number(20,4) NOT NULL,
AvRcvFmRtAg_STCNT varchar2(32) NOT NULL,
AvLwFmRtCPt_MIN Number(20,4) NOT NULL,
AvLwFmRtCPt_MAX Number(20,4) NOT NULL,
AvLwFmRtCPt_STCNT varchar2(32) NOT NULL,
AvPktLsRt_MIN Number(20,4) NOT NULL,
AvPktLsRt_MAX Number(20,4) NOT NULL,
AvPktLsRt_STCNT varchar2(32) NOT NULL,
AvDycCpyPnt_MIN Number(20,4) NOT NULL,
AvDycCpyPnt_MAX Number(20,4) NOT NULL,
AvDycCpyPnt_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMVideoStreamsTest_TREND ADD constraint PK_MTMVideoStreamsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMVideoStreamsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMVideoStreamsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Strmcnt_MIN varchar2(256) NOT NULL,
Strmcnt_MAX varchar2(256) NOT NULL,
ViPstFclr_MIN varchar2(256) NOT NULL,
ViPstFclr_MAX varchar2(256) NOT NULL,
ViLFrPrAg_MIN varchar2(256) NOT NULL,
ViLFrPrAg_MAX varchar2(256) NOT NULL,
ViFrRteAg_MIN varchar2(256) NOT NULL,
ViFrRteAg_MAX varchar2(256) NOT NULL,
PrStrmcnt_MIN varchar2(256) NOT NULL,
PrStrmcnt_MAX varchar2(256) NOT NULL,
GdStrmCnt_MIN varchar2(256) NOT NULL,
GdStrmCnt_MAX varchar2(256) NOT NULL,
UncfdSmCnt_MIN varchar2(256) NOT NULL,
UncfdSmCnt_MAX varchar2(256) NOT NULL,
PrPercent_MIN varchar2(256) NOT NULL,
PrPercent_MAX varchar2(256) NOT NULL,
AvPsFECPLR_MIN varchar2(256) NOT NULL,
AvPsFECPLR_MAX varchar2(256) NOT NULL,
AvLclFmLs_MIN varchar2(256) NOT NULL,
AvLclFmLs_MAX varchar2(256) NOT NULL,
AvRcvFmRtAg_MIN varchar2(256) NOT NULL,
AvRcvFmRtAg_MAX varchar2(256) NOT NULL,
AvLwFmRtCPt_MIN varchar2(256) NOT NULL,
AvLwFmRtCPt_MAX varchar2(256) NOT NULL,
AvPktLsRt_MIN varchar2(256) NOT NULL,
AvPktLsRt_MAX varchar2(256) NOT NULL,
AvDycCpyPnt_MIN varchar2(256) NOT NULL,
AvDycCpyPnt_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMVideoStreamsTest_THRESH ADD constraint PK_MTMVideoStreamsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMVideoStreamsTest_THRESH ON MTMVideoStreamsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMVideoStreamsTest ON MTMVideoStreamsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMVideoStreamsTest ON MTMVideoStreamsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMAppShrngStrmsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMAppShrngStrmsTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
StreamCount Number(20,4) NOT NULL,
StreamCount_ST varchar2(32) NOT NULL,
PDSpldTlePrTlCt Number(20,4) NOT NULL,
PDSpldTlePrTlCt_ST varchar2(32) NOT NULL,
PDRlOnWyAvgCnt Number(20,4) NOT NULL,
PDRlOnWyAvgCnt_ST varchar2(32) NOT NULL,
PDRDPTlPngLyAgCt Number(20,4) NOT NULL,
PDRDPTlPngLyAgCt_ST varchar2(32) NOT NULL,
PoorStreamCount Number(20,4) NOT NULL,
PoorStreamCount_ST varchar2(32) NOT NULL,
GoodStreamCount Number(20,4) NOT NULL,
GoodStreamCount_ST varchar2(32) NOT NULL,
UnclasfedStmCnt Number(20,4) NOT NULL,
UnclasfedStmCnt_ST varchar2(32) NOT NULL,
PoorPercentage Number(20,4) NOT NULL,
PoorPercentage_ST varchar2(32) NOT NULL,
SpldTlPrcntTtl Number(20,4) NOT NULL,
SpldTlPrcntTtl_ST varchar2(32) NOT NULL,
RDPTlPcngLtncy Number(20,4) NOT NULL,
RDPTlPcngLtncy_ST varchar2(32) NOT NULL,
AvReltveOneWy Number(20,4) NOT NULL,
AvReltveOneWy_ST varchar2(32) NOT NULL,
AvRltvOneWyMx Number(20,4) NOT NULL,
AvRltvOneWyMx_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMAppShrngStrmsTest ON MTMAppShrngStrmsTest(MSMT_TIME);
ALTER TABLE MTMAppShrngStrmsTest ADD constraint PK_MTMAppShrngStrmsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMAppShrngStrmsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMAppShrngStrmsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
StreamCount_MIN Number(20,4) NOT NULL,
StreamCount_MAX Number(20,4) NOT NULL,
StreamCount_STCNT varchar2(32) NOT NULL,
PDSpldTlePrTlCt_MIN Number(20,4) NOT NULL,
PDSpldTlePrTlCt_MAX Number(20,4) NOT NULL,
PDSpldTlePrTlCt_STCNT varchar2(32) NOT NULL,
PDRlOnWyAvgCnt_MIN Number(20,4) NOT NULL,
PDRlOnWyAvgCnt_MAX Number(20,4) NOT NULL,
PDRlOnWyAvgCnt_STCNT varchar2(32) NOT NULL,
PDRDPTlPngLyAgCt_MIN Number(20,4) NOT NULL,
PDRDPTlPngLyAgCt_MAX Number(20,4) NOT NULL,
PDRDPTlPngLyAgCt_STCNT varchar2(32) NOT NULL,
PoorStreamCount_MIN Number(20,4) NOT NULL,
PoorStreamCount_MAX Number(20,4) NOT NULL,
PoorStreamCount_STCNT varchar2(32) NOT NULL,
GoodStreamCount_MIN Number(20,4) NOT NULL,
GoodStreamCount_MAX Number(20,4) NOT NULL,
GoodStreamCount_STCNT varchar2(32) NOT NULL,
UnclasfedStmCnt_MIN Number(20,4) NOT NULL,
UnclasfedStmCnt_MAX Number(20,4) NOT NULL,
UnclasfedStmCnt_STCNT varchar2(32) NOT NULL,
PoorPercentage_MIN Number(20,4) NOT NULL,
PoorPercentage_MAX Number(20,4) NOT NULL,
PoorPercentage_STCNT varchar2(32) NOT NULL,
SpldTlPrcntTtl_MIN Number(20,4) NOT NULL,
SpldTlPrcntTtl_MAX Number(20,4) NOT NULL,
SpldTlPrcntTtl_STCNT varchar2(32) NOT NULL,
RDPTlPcngLtncy_MIN Number(20,4) NOT NULL,
RDPTlPcngLtncy_MAX Number(20,4) NOT NULL,
RDPTlPcngLtncy_STCNT varchar2(32) NOT NULL,
AvReltveOneWy_MIN Number(20,4) NOT NULL,
AvReltveOneWy_MAX Number(20,4) NOT NULL,
AvReltveOneWy_STCNT varchar2(32) NOT NULL,
AvRltvOneWyMx_MIN Number(20,4) NOT NULL,
AvRltvOneWyMx_MAX Number(20,4) NOT NULL,
AvRltvOneWyMx_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMAppShrngStrmsTest_TREND ADD constraint PK_MTMAppShrngStrmsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMAppShrngStrmsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMAppShrngStrmsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
StreamCount_MIN varchar2(256) NOT NULL,
StreamCount_MAX varchar2(256) NOT NULL,
PDSpldTlePrTlCt_MIN varchar2(256) NOT NULL,
PDSpldTlePrTlCt_MAX varchar2(256) NOT NULL,
PDRlOnWyAvgCnt_MIN varchar2(256) NOT NULL,
PDRlOnWyAvgCnt_MAX varchar2(256) NOT NULL,
PDRDPTlPngLyAgCt_MIN varchar2(256) NOT NULL,
PDRDPTlPngLyAgCt_MAX varchar2(256) NOT NULL,
PoorStreamCount_MIN varchar2(256) NOT NULL,
PoorStreamCount_MAX varchar2(256) NOT NULL,
GoodStreamCount_MIN varchar2(256) NOT NULL,
GoodStreamCount_MAX varchar2(256) NOT NULL,
UnclasfedStmCnt_MIN varchar2(256) NOT NULL,
UnclasfedStmCnt_MAX varchar2(256) NOT NULL,
PoorPercentage_MIN varchar2(256) NOT NULL,
PoorPercentage_MAX varchar2(256) NOT NULL,
SpldTlPrcntTtl_MIN varchar2(256) NOT NULL,
SpldTlPrcntTtl_MAX varchar2(256) NOT NULL,
RDPTlPcngLtncy_MIN varchar2(256) NOT NULL,
RDPTlPcngLtncy_MAX varchar2(256) NOT NULL,
AvReltveOneWy_MIN varchar2(256) NOT NULL,
AvReltveOneWy_MAX varchar2(256) NOT NULL,
AvRltvOneWyMx_MIN varchar2(256) NOT NULL,
AvRltvOneWyMx_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMAppShrngStrmsTest_THRESH ADD constraint PK_MTMAppShngStrmTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMAppShngStrmTest_THRESH ON MTMAppShrngStrmsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMAppShrngStrmsTest ON MTMAppShrngStrmsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMAppShrngStrmsTest ON MTMAppShrngStrmsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMFeedBckSmryTest CASCADE CONSTRAINTS;
CREATE TABLE MTMFeedBckSmryTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
FFbckRgAv Number(20,4) NOT NULL,
FFbckRgAv_ST varchar2(32) NOT NULL,
SFbckRgAv Number(20,4) NOT NULL,
SFbckRgAv_ST varchar2(32) NOT NULL,
FFbckRg Number(20,4) NOT NULL,
FFbckRg_ST varchar2(32) NOT NULL,
SFbckRg Number(20,4) NOT NULL,
SFbckRg_ST varchar2(32) NOT NULL,
FFbkRgPrCt Number(20,4) NOT NULL,
FFbkRgPrCt_ST varchar2(32) NOT NULL,
SFbkRgPrCt Number(20,4) NOT NULL,
SFbkRgPrCt_ST varchar2(32) NOT NULL,
FFbkRgPrPt Number(20,4) NOT NULL,
FFbkRgPrPt_ST varchar2(32) NOT NULL,
SFbkRgPrPt Number(20,4) NOT NULL,
SFbkRgPrPt_ST varchar2(32) NOT NULL,
FFbkTnAdCt Number(20,4) NOT NULL,
FFbkTnAdCt_ST varchar2(32) NOT NULL,
SFbkTnAdCt Number(20,4) NOT NULL,
SFbkTnAdCt_ST varchar2(32) NOT NULL,
FFbkTnVdCt Number(20,4) NOT NULL,
FFbkTnVdCt_ST varchar2(32) NOT NULL,
SFbkTnVdCt Number(20,4) NOT NULL,
SFbkTnVdCt_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_MTMFeedBckSmryTest ON MTMFeedBckSmryTest(MSMT_TIME);
ALTER TABLE MTMFeedBckSmryTest ADD constraint PK_MTMFeedBckSmryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMFeedBckSmryTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMFeedBckSmryTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
FFbckRgAv_MIN Number(20,4) NOT NULL,
FFbckRgAv_MAX Number(20,4) NOT NULL,
FFbckRgAv_STCNT varchar2(32) NOT NULL,
SFbckRgAv_MIN Number(20,4) NOT NULL,
SFbckRgAv_MAX Number(20,4) NOT NULL,
SFbckRgAv_STCNT varchar2(32) NOT NULL,
FFbckRg_MIN Number(20,4) NOT NULL,
FFbckRg_MAX Number(20,4) NOT NULL,
FFbckRg_STCNT varchar2(32) NOT NULL,
SFbckRg_MIN Number(20,4) NOT NULL,
SFbckRg_MAX Number(20,4) NOT NULL,
SFbckRg_STCNT varchar2(32) NOT NULL,
FFbkRgPrCt_MIN Number(20,4) NOT NULL,
FFbkRgPrCt_MAX Number(20,4) NOT NULL,
FFbkRgPrCt_STCNT varchar2(32) NOT NULL,
SFbkRgPrCt_MIN Number(20,4) NOT NULL,
SFbkRgPrCt_MAX Number(20,4) NOT NULL,
SFbkRgPrCt_STCNT varchar2(32) NOT NULL,
FFbkRgPrPt_MIN Number(20,4) NOT NULL,
FFbkRgPrPt_MAX Number(20,4) NOT NULL,
FFbkRgPrPt_STCNT varchar2(32) NOT NULL,
SFbkRgPrPt_MIN Number(20,4) NOT NULL,
SFbkRgPrPt_MAX Number(20,4) NOT NULL,
SFbkRgPrPt_STCNT varchar2(32) NOT NULL,
FFbkTnAdCt_MIN Number(20,4) NOT NULL,
FFbkTnAdCt_MAX Number(20,4) NOT NULL,
FFbkTnAdCt_STCNT varchar2(32) NOT NULL,
SFbkTnAdCt_MIN Number(20,4) NOT NULL,
SFbkTnAdCt_MAX Number(20,4) NOT NULL,
SFbkTnAdCt_STCNT varchar2(32) NOT NULL,
FFbkTnVdCt_MIN Number(20,4) NOT NULL,
FFbkTnVdCt_MAX Number(20,4) NOT NULL,
FFbkTnVdCt_STCNT varchar2(32) NOT NULL,
SFbkTnVdCt_MIN Number(20,4) NOT NULL,
SFbkTnVdCt_MAX Number(20,4) NOT NULL,
SFbkTnVdCt_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MTMFeedBckSmryTest_TREND ADD constraint PK_MTMFeedBckSmryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMFeedBckSmryTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMFeedBckSmryTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
FFbckRgAv_MIN varchar2(256) NOT NULL,
FFbckRgAv_MAX varchar2(256) NOT NULL,
SFbckRgAv_MIN varchar2(256) NOT NULL,
SFbckRgAv_MAX varchar2(256) NOT NULL,
FFbckRg_MIN varchar2(256) NOT NULL,
FFbckRg_MAX varchar2(256) NOT NULL,
SFbckRg_MIN varchar2(256) NOT NULL,
SFbckRg_MAX varchar2(256) NOT NULL,
FFbkRgPrCt_MIN varchar2(256) NOT NULL,
FFbkRgPrCt_MAX varchar2(256) NOT NULL,
SFbkRgPrCt_MIN varchar2(256) NOT NULL,
SFbkRgPrCt_MAX varchar2(256) NOT NULL,
FFbkRgPrPt_MIN varchar2(256) NOT NULL,
FFbkRgPrPt_MAX varchar2(256) NOT NULL,
SFbkRgPrPt_MIN varchar2(256) NOT NULL,
SFbkRgPrPt_MAX varchar2(256) NOT NULL,
FFbkTnAdCt_MIN varchar2(256) NOT NULL,
FFbkTnAdCt_MAX varchar2(256) NOT NULL,
SFbkTnAdCt_MIN varchar2(256) NOT NULL,
SFbkTnAdCt_MAX varchar2(256) NOT NULL,
FFbkTnVdCt_MIN varchar2(256) NOT NULL,
FFbkTnVdCt_MAX varchar2(256) NOT NULL,
SFbkTnVdCt_MIN varchar2(256) NOT NULL,
SFbkTnVdCt_MAX varchar2(256) NOT NULL
);

ALTER TABLE MTMFeedBckSmryTest_THRESH ADD constraint PK_MTMFeedBckSmryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMFeedBckSmryTest_THRESH ON MTMFeedBckSmryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMFeedBckSmryTest ON MTMFeedBckSmryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMFeedBckSmryTest ON MTMFeedBckSmryTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMVBSSStrmsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMVBSSStrmsTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
VBSStms Number(20,4) NOT NULL,
VBSStms_ST varchar2(32) NOT NULL,
VBSStmPrVpF Number(20,4) NOT NULL,
VBSStmPrVpF_ST varchar2(32) NOT NULL,
VBSPrVLsAv Number(20,4) NOT NULL,
VBSPrVLsAv_ST varchar2(32) NOT NULL,
VBSPrVFmeAv Number(20,4) NOT NULL,
VBSPrVFmeAv_ST varchar2(32) NOT NULL,
VBSPrStm Number(20,4) NOT NULL,
VBSPrStm_ST varchar2(32) NOT NULL,
VBSGdStm Number(20,4) NOT NULL,
VBSGdStm_ST varchar2(32) NOT NULL,
VBSUclfdStm Number(20,4) NOT NULL,
VBSUclfdStm_ST varchar2(32) NOT NULL,
VBSPrPrcnt Number(20,4) NOT NULL,
VBSPrPrcnt_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_MTMVBSSStrmsTest ON MTMVBSSStrmsTest(MSMT_TIME);
ALTER TABLE MTMVBSSStrmsTest ADD constraint PK_MTMVBSSStrmsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMVBSSStrmsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMVBSSStrmsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
VBSStms_MIN Number(20,4) NOT NULL,
VBSStms_MAX Number(20,4) NOT NULL,
VBSStms_STCNT varchar2(32) NOT NULL,
VBSStmPrVpF_MIN Number(20,4) NOT NULL,
VBSStmPrVpF_MAX Number(20,4) NOT NULL,
VBSStmPrVpF_STCNT varchar2(32) NOT NULL,
VBSPrVLsAv_MIN Number(20,4) NOT NULL,
VBSPrVLsAv_MAX Number(20,4) NOT NULL,
VBSPrVLsAv_STCNT varchar2(32) NOT NULL,
VBSPrVFmeAv_MIN Number(20,4) NOT NULL,
VBSPrVFmeAv_MAX Number(20,4) NOT NULL,
VBSPrVFmeAv_STCNT varchar2(32) NOT NULL,
VBSPrStm_MIN Number(20,4) NOT NULL,
VBSPrStm_MAX Number(20,4) NOT NULL,
VBSPrStm_STCNT varchar2(32) NOT NULL,
VBSGdStm_MIN Number(20,4) NOT NULL,
VBSGdStm_MAX Number(20,4) NOT NULL,
VBSGdStm_STCNT varchar2(32) NOT NULL,
VBSUclfdStm_MIN Number(20,4) NOT NULL,
VBSUclfdStm_MAX Number(20,4) NOT NULL,
VBSUclfdStm_STCNT varchar2(32) NOT NULL,
VBSPrPrcnt_MIN Number(20,4) NOT NULL,
VBSPrPrcnt_MAX Number(20,4) NOT NULL,
VBSPrPrcnt_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MTMVBSSStrmsTest_TREND ADD constraint PK_MTMVBSSStrmsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMVBSSStrmsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMVBSSStrmsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
VBSStms_MIN varchar2(256) NOT NULL,
VBSStms_MAX varchar2(256) NOT NULL,
VBSStmPrVpF_MIN varchar2(256) NOT NULL,
VBSStmPrVpF_MAX varchar2(256) NOT NULL,
VBSPrVLsAv_MIN varchar2(256) NOT NULL,
VBSPrVLsAv_MAX varchar2(256) NOT NULL,
VBSPrVFmeAv_MIN varchar2(256) NOT NULL,
VBSPrVFmeAv_MAX varchar2(256) NOT NULL,
VBSPrStm_MIN varchar2(256) NOT NULL,
VBSPrStm_MAX varchar2(256) NOT NULL,
VBSGdStm_MIN varchar2(256) NOT NULL,
VBSGdStm_MAX varchar2(256) NOT NULL,
VBSUclfdStm_MIN varchar2(256) NOT NULL,
VBSUclfdStm_MAX varchar2(256) NOT NULL,
VBSPrPrcnt_MIN varchar2(256) NOT NULL,
VBSPrPrcnt_MAX varchar2(256) NOT NULL
);

ALTER TABLE MTMVBSSStrmsTest_THRESH ADD constraint PK_MTMVBSSStrmsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMVBSSStrmsTest_THRESH ON MTMVBSSStrmsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMVBSSStrmsTest ON MTMVBSSStrmsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMVBSSStrmsTest ON MTMVBSSStrmsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMCalSumryTest CASCADE CONSTRAINTS;
CREATE TABLE MTMCalSumryTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TotStrmCt Number(20,4) NOT NULL,
TotStrmCt_ST varchar2(32) NOT NULL,
CDRAvlblstrmCt Number(20,4) NOT NULL,
CDRAvlblstrmCt_ST varchar2(32) NOT NULL,
MedFldStrmCt Number(20,4) NOT NULL,
MedFldStrmCt_ST varchar2(32) NOT NULL,
ClSupFldStrmCt Number(20,4) NOT NULL,
ClSupFldStrmCt_ST varchar2(32) NOT NULL,
ClDrpdStrmCt Number(20,4) NOT NULL,
ClDrpdStrmCt_ST varchar2(32) NOT NULL,
MedSudedStrmCt Number(20,4) NOT NULL,
MedSudedStrmCt_ST varchar2(32) NOT NULL,
ClSupSudStrmCt Number(20,4) NOT NULL,
ClSupSudStrmCt_ST varchar2(32) NOT NULL,
ClSupFlrPer Number(20,4) NOT NULL,
ClSupFlrPer_ST varchar2(32) NOT NULL,
ClDrpdFlrPer Number(20,4) NOT NULL,
ClDrpdFlrPer_ST varchar2(32) NOT NULL,
AnsSeiRatio Number(20,4) NOT NULL,
AnsSeiRatio_ST varchar2(32) NOT NULL,
ShrtCalPer Number(20,4) NOT NULL,
ShrtCalPer_ST varchar2(32) NOT NULL,
MedFlrPer Number(20,4) NOT NULL,
MedFlrPer_ST varchar2(32) NOT NULL,
AvgCalDurtn Number(20,4) NOT NULL,
AvgCalDurtn_ST varchar2(32) NOT NULL,
MedFldFWStrmCt Number(20,4) NOT NULL,
MedFldFWStrmCt_ST varchar2(32) NOT NULL,
FWMedFlrPer Number(20,4) NOT NULL,
FWMedFlrPer_ST varchar2(32) NOT NULL,
FWIPBldStrmCt Number(20,4) NOT NULL,
FWIPBldStrmCt_ST varchar2(32) NOT NULL,
FWIPBldMFlrPer Number(20,4) NOT NULL,
FWIPBldMFlrPer_ST varchar2(32) NOT NULL,
MFldOtrStrmCnt Number(20,4) NOT NULL,
MFldOtrStrmCnt_ST varchar2(32) NOT NULL,
OtrMedFlrPer Number(20,4) NOT NULL,
OtrMedFlrPer_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_MTMCalSumryTest ON MTMCalSumryTest(MSMT_TIME);
ALTER TABLE MTMCalSumryTest ADD constraint PK_MTMCalSumryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MTMCalSumryTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMCalSumryTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TotStrmCt_MIN Number(20,4) NOT NULL,
TotStrmCt_MAX Number(20,4) NOT NULL,
TotStrmCt_STCNT varchar2(32) NOT NULL,
CDRAvlblstrmCt_MIN Number(20,4) NOT NULL,
CDRAvlblstrmCt_MAX Number(20,4) NOT NULL,
CDRAvlblstrmCt_STCNT varchar2(32) NOT NULL,
MedFldStrmCt_MIN Number(20,4) NOT NULL,
MedFldStrmCt_MAX Number(20,4) NOT NULL,
MedFldStrmCt_STCNT varchar2(32) NOT NULL,
ClSupFldStrmCt_MIN Number(20,4) NOT NULL,
ClSupFldStrmCt_MAX Number(20,4) NOT NULL,
ClSupFldStrmCt_STCNT varchar2(32) NOT NULL,
ClDrpdStrmCt_MIN Number(20,4) NOT NULL,
ClDrpdStrmCt_MAX Number(20,4) NOT NULL,
ClDrpdStrmCt_STCNT varchar2(32) NOT NULL,
MedSudedStrmCt_MIN Number(20,4) NOT NULL,
MedSudedStrmCt_MAX Number(20,4) NOT NULL,
MedSudedStrmCt_STCNT varchar2(32) NOT NULL,
ClSupSudStrmCt_MIN Number(20,4) NOT NULL,
ClSupSudStrmCt_MAX Number(20,4) NOT NULL,
ClSupSudStrmCt_STCNT varchar2(32) NOT NULL,
ClSupFlrPer_MIN Number(20,4) NOT NULL,
ClSupFlrPer_MAX Number(20,4) NOT NULL,
ClSupFlrPer_STCNT varchar2(32) NOT NULL,
ClDrpdFlrPer_MIN Number(20,4) NOT NULL,
ClDrpdFlrPer_MAX Number(20,4) NOT NULL,
ClDrpdFlrPer_STCNT varchar2(32) NOT NULL,
AnsSeiRatio_MIN Number(20,4) NOT NULL,
AnsSeiRatio_MAX Number(20,4) NOT NULL,
AnsSeiRatio_STCNT varchar2(32) NOT NULL,
ShrtCalPer_MIN Number(20,4) NOT NULL,
ShrtCalPer_MAX Number(20,4) NOT NULL,
ShrtCalPer_STCNT varchar2(32) NOT NULL,
MedFlrPer_MIN Number(20,4) NOT NULL,
MedFlrPer_MAX Number(20,4) NOT NULL,
MedFlrPer_STCNT varchar2(32) NOT NULL,
AvgCalDurtn_MIN Number(20,4) NOT NULL,
AvgCalDurtn_MAX Number(20,4) NOT NULL,
AvgCalDurtn_STCNT varchar2(32) NOT NULL,
MedFldFWStrmCt_MIN Number(20,4) NOT NULL,
MedFldFWStrmCt_MAX Number(20,4) NOT NULL,
MedFldFWStrmCt_STCNT varchar2(32) NOT NULL,
FWMedFlrPer_MIN Number(20,4) NOT NULL,
FWMedFlrPer_MAX Number(20,4) NOT NULL,
FWMedFlrPer_STCNT varchar2(32) NOT NULL,
FWIPBldStrmCt_MIN Number(20,4) NOT NULL,
FWIPBldStrmCt_MAX Number(20,4) NOT NULL,
FWIPBldStrmCt_STCNT varchar2(32) NOT NULL,
FWIPBldMFlrPer_MIN Number(20,4) NOT NULL,
FWIPBldMFlrPer_MAX Number(20,4) NOT NULL,
FWIPBldMFlrPer_STCNT varchar2(32) NOT NULL,
MFldOtrStrmCnt_MIN Number(20,4) NOT NULL,
MFldOtrStrmCnt_MAX Number(20,4) NOT NULL,
MFldOtrStrmCnt_STCNT varchar2(32) NOT NULL,
OtrMedFlrPer_MIN Number(20,4) NOT NULL,
OtrMedFlrPer_MAX Number(20,4) NOT NULL,
OtrMedFlrPer_STCNT varchar2(32) NOT NULL
);
ALTER TABLE MTMCalSumryTest_TREND ADD constraint PK_MTMCalSumryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE MTMCalSumryTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMCalSumryTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TotStrmCt_MIN varchar2(256) NOT NULL,
TotStrmCt_MAX varchar2(256) NOT NULL,
CDRAvlblstrmCt_MIN varchar2(256) NOT NULL,
CDRAvlblstrmCt_MAX varchar2(256) NOT NULL,
MedFldStrmCt_MIN varchar2(256) NOT NULL,
MedFldStrmCt_MAX varchar2(256) NOT NULL,
ClSupFldStrmCt_MIN varchar2(256) NOT NULL,
ClSupFldStrmCt_MAX varchar2(256) NOT NULL,
ClDrpdStrmCt_MIN varchar2(256) NOT NULL,
ClDrpdStrmCt_MAX varchar2(256) NOT NULL,
MedSudedStrmCt_MIN varchar2(256) NOT NULL,
MedSudedStrmCt_MAX varchar2(256) NOT NULL,
ClSupSudStrmCt_MIN varchar2(256) NOT NULL,
ClSupSudStrmCt_MAX varchar2(256) NOT NULL,
ClSupFlrPer_MIN varchar2(256) NOT NULL,
ClSupFlrPer_MAX varchar2(256) NOT NULL,
ClDrpdFlrPer_MIN varchar2(256) NOT NULL,
ClDrpdFlrPer_MAX varchar2(256) NOT NULL,
AnsSeiRatio_MIN varchar2(256) NOT NULL,
AnsSeiRatio_MAX varchar2(256) NOT NULL,
ShrtCalPer_MIN varchar2(256) NOT NULL,
ShrtCalPer_MAX varchar2(256) NOT NULL,
MedFlrPer_MIN varchar2(256) NOT NULL,
MedFlrPer_MAX varchar2(256) NOT NULL,
AvgCalDurtn_MIN varchar2(256) NOT NULL,
AvgCalDurtn_MAX varchar2(256) NOT NULL,
MedFldFWStrmCt_MIN varchar2(256) NOT NULL,
MedFldFWStrmCt_MAX varchar2(256) NOT NULL,
FWMedFlrPer_MIN varchar2(256) NOT NULL,
FWMedFlrPer_MAX varchar2(256) NOT NULL,
FWIPBldStrmCt_MIN varchar2(256) NOT NULL,
FWIPBldStrmCt_MAX varchar2(256) NOT NULL,
FWIPBldMFlrPer_MIN varchar2(256) NOT NULL,
FWIPBldMFlrPer_MAX varchar2(256) NOT NULL,
MFldOtrStrmCnt_MIN varchar2(256) NOT NULL,
MFldOtrStrmCnt_MAX varchar2(256) NOT NULL,
OtrMedFlrPer_MIN varchar2(256) NOT NULL,
OtrMedFlrPer_MAX varchar2(256) NOT NULL
);
ALTER TABLE MTMCalSumryTest_THRESH ADD constraint PK_MTMCalSumryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMCalSumryTest_THRESH ON MTMCalSumryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMCalSumryTest ON MTMCalSumryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMCalSumryTest ON MTMCalSumryTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMSrvPrvStats CASCADE CONSTRAINTS;
CREATE TABLE MTMSrvPrvStats(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PNDING_ACTVTION Number(20,4) NOT NULL,
PNDING_ACTVTION_ST varchar2(32) NOT NULL,
PNDING_PRVISION Number(20,4) NOT NULL,
PNDING_PRVISION_ST varchar2(32) NOT NULL,
PNDING_INPUT Number(20,4) NOT NULL,
PNDING_INPUT_ST varchar2(32) NOT NULL,
SUCCESS Number(20,4) NOT NULL,
SUCCESS_ST varchar2(32) NOT NULL,
DISABLED Number(20,4) NOT NULL,
DISABLED_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMSrvPrvStats ON MTMSrvPrvStats(MSMT_TIME);
ALTER TABLE MTMSrvPrvStats ADD CONSTRAINT PK_MTMSrvPrvStats PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMSrvPrvStats_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMSrvPrvStats_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
PNDING_ACTVTION_MIN Number(20,4) NOT NULL,
PNDING_ACTVTION_MAX Number(20,4) NOT NULL,
PNDING_ACTVTION_STCNT varchar2(32) NOT NULL,
PNDING_PRVISION_MIN Number(20,4) NOT NULL,
PNDING_PRVISION_MAX Number(20,4) NOT NULL,
PNDING_PRVISION_STCNT varchar2(32) NOT NULL,
PNDING_INPUT_MIN Number(20,4) NOT NULL,
PNDING_INPUT_MAX Number(20,4) NOT NULL,
PNDING_INPUT_STCNT varchar2(32) NOT NULL,
SUCCESS_MIN Number(20,4) NOT NULL,
SUCCESS_MAX Number(20,4) NOT NULL,
SUCCESS_STCNT varchar2(32) NOT NULL,
DISABLED_MIN Number(20,4) NOT NULL,
DISABLED_MAX Number(20,4) NOT NULL,
DISABLED_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMSrvPrvStats_TREND ADD CONSTRAINT PK_MTMSrvPrvStats_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMSrvPrvStats_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMSrvPrvStats_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
PNDING_ACTVTION_MIN varchar2(256) NOT NULL,
PNDING_ACTVTION_MAX varchar2(256) NOT NULL,
PNDING_PRVISION_MIN varchar2(256) NOT NULL,
PNDING_PRVISION_MAX varchar2(256) NOT NULL,
PNDING_INPUT_MIN varchar2(256) NOT NULL,
PNDING_INPUT_MAX varchar2(256) NOT NULL,
SUCCESS_MIN varchar2(256) NOT NULL,
SUCCESS_MAX varchar2(256) NOT NULL,
DISABLED_MIN varchar2(256) NOT NULL,
DISABLED_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMSrvPrvStats_THRESH ADD CONSTRAINT PK_MTMSrvPrvStats_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMSrvPrvStats_THRESH ON MTMSrvPrvStats_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMSrvPrvStats ON MTMSrvPrvStats_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMSrvPrvStats ON MTMSrvPrvStats_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMUsrActvitiesTest CASCADE CONSTRAINTS;
CREATE TABLE MTMUsrActvitiesTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
uuteamchat Number(20,4) NOT NULL,
uuteamchat_ST varchar2(32) NOT NULL,
uuprvchat Number(20,4) NOT NULL,
uuprvchat_ST varchar2(32) NOT NULL,
uucalls Number(20,4) NOT NULL,
uucalls_ST varchar2(32) NOT NULL,
uumetings Number(20,4) NOT NULL,
uumetings_ST varchar2(32) NOT NULL,
uuothrAct Number(20,4) NOT NULL,
uuothrAct_ST varchar2(32) NOT NULL,
teamchat Number(20,4) NOT NULL,
teamchat_ST varchar2(32) NOT NULL,
privchat Number(20,4) NOT NULL,
privchat_ST varchar2(32) NOT NULL,
calls Number(20,4) NOT NULL,
calls_ST varchar2(32) NOT NULL,
meetings Number(20,4) NOT NULL,
meetings_ST varchar2(32) NOT NULL,
otherAct Number(20,4) NOT NULL,
otherAct_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMUsrActvitiesTest ON MTMUsrActvitiesTest(MSMT_TIME);
ALTER TABLE MTMUsrActvitiesTest ADD constraint PK_MTMUsrActvitiesTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMUsrActvitiesTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMUsrActvitiesTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
uuteamchat_MIN Number(20,4) NOT NULL,
uuteamchat_MAX Number(20,4) NOT NULL,
uuteamchat_STCNT varchar2(32) NOT NULL,
uuprvchat_MIN Number(20,4) NOT NULL,
uuprvchat_MAX Number(20,4) NOT NULL,
uuprvchat_STCNT varchar2(32) NOT NULL,
uucalls_MIN Number(20,4) NOT NULL,
uucalls_MAX Number(20,4) NOT NULL,
uucalls_STCNT varchar2(32) NOT NULL,
uumetings_MIN Number(20,4) NOT NULL,
uumetings_MAX Number(20,4) NOT NULL,
uumetings_STCNT varchar2(32) NOT NULL,
uuothrAct_MIN Number(20,4) NOT NULL,
uuothrAct_MAX Number(20,4) NOT NULL,
uuothrAct_STCNT varchar2(32) NOT NULL,
teamchat_MIN Number(20,4) NOT NULL,
teamchat_MAX Number(20,4) NOT NULL,
teamchat_STCNT varchar2(32) NOT NULL,
privchat_MIN Number(20,4) NOT NULL,
privchat_MAX Number(20,4) NOT NULL,
privchat_STCNT varchar2(32) NOT NULL,
calls_MIN Number(20,4) NOT NULL,
calls_MAX Number(20,4) NOT NULL,
calls_STCNT varchar2(32) NOT NULL,
meetings_MIN Number(20,4) NOT NULL,
meetings_MAX Number(20,4) NOT NULL,
meetings_STCNT varchar2(32) NOT NULL,
otherAct_MIN Number(20,4) NOT NULL,
otherAct_MAX Number(20,4) NOT NULL,
otherAct_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMUsrActvitiesTest_TREND ADD constraint PK_MTMUsrActvitiesTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMUsrActvitiesTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMUsrActvitiesTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
uuteamchat_MIN varchar2(256) NOT NULL,
uuteamchat_MAX varchar2(256) NOT NULL,
uuprvchat_MIN varchar2(256) NOT NULL,
uuprvchat_MAX varchar2(256) NOT NULL,
uucalls_MIN varchar2(256) NOT NULL,
uucalls_MAX varchar2(256) NOT NULL,
uumetings_MIN varchar2(256) NOT NULL,
uumetings_MAX varchar2(256) NOT NULL,
uuothrAct_MIN varchar2(256) NOT NULL,
uuothrAct_MAX varchar2(256) NOT NULL,
teamchat_MIN varchar2(256) NOT NULL,
teamchat_MAX varchar2(256) NOT NULL,
privchat_MIN varchar2(256) NOT NULL,
privchat_MAX varchar2(256) NOT NULL,
calls_MIN varchar2(256) NOT NULL,
calls_MAX varchar2(256) NOT NULL,
meetings_MIN varchar2(256) NOT NULL,
meetings_MAX varchar2(256) NOT NULL,
otherAct_MIN varchar2(256) NOT NULL,
otherAct_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMUsrActvitiesTest_THRESH ADD constraint PK_MTMUsrActvitiesTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMUsrActvitiesTest_THRESH ON MTMUsrActvitiesTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMUsrActvitiesTest ON MTMUsrActvitiesTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMUsrActvitiesTest ON MTMUsrActvitiesTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMTeamsInvTest CASCADE CONSTRAINTS;
CREATE TABLE MTMTeamsInvTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
teamscount Number(20,4) NOT NULL,
teamscount_ST varchar2(32) NOT NULL,
publictems Number(20,4) NOT NULL,
publictems_ST varchar2(32) NOT NULL,
privtetems Number(20,4) NOT NULL,
privtetems_ST varchar2(32) NOT NULL,
chanlsCnt Number(20,4) NOT NULL,
chanlsCnt_ST varchar2(32) NOT NULL,
activetems Number(20,4) NOT NULL,
activetems_ST varchar2(32) NOT NULL,
inactivtems Number(20,4) NOT NULL,
inactivtems_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMTeamsInvTest ON MTMTeamsInvTest(MSMT_TIME);
ALTER TABLE MTMTeamsInvTest ADD constraint PK_MTMTeamsInvTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMTeamsInvTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMTeamsInvTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
teamscount_MIN Number(20,4) NOT NULL,
teamscount_MAX Number(20,4) NOT NULL,
teamscount_STCNT varchar2(32) NOT NULL,
publictems_MIN Number(20,4) NOT NULL,
publictems_MAX Number(20,4) NOT NULL,
publictems_STCNT varchar2(32) NOT NULL,
privtetems_MIN Number(20,4) NOT NULL,
privtetems_MAX Number(20,4) NOT NULL,
privtetems_STCNT varchar2(32) NOT NULL,
chanlsCnt_MIN Number(20,4) NOT NULL,
chanlsCnt_MAX Number(20,4) NOT NULL,
chanlsCnt_STCNT varchar2(32) NOT NULL,
activetems_MIN Number(20,4) NOT NULL,
activetems_MAX Number(20,4) NOT NULL,
activetems_STCNT varchar2(32) NOT NULL,
inactivtems_MIN Number(20,4) NOT NULL,
inactivtems_MAX Number(20,4) NOT NULL,
inactivtems_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMTeamsInvTest_TREND ADD constraint PK_MTMTeamsInvTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMTeamsInvTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMTeamsInvTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
teamscount_MIN varchar2(256) NOT NULL,
teamscount_MAX varchar2(256) NOT NULL,
publictems_MIN varchar2(256) NOT NULL,
publictems_MAX varchar2(256) NOT NULL,
privtetems_MIN varchar2(256) NOT NULL,
privtetems_MAX varchar2(256) NOT NULL,
chanlsCnt_MIN varchar2(256) NOT NULL,
chanlsCnt_MAX varchar2(256) NOT NULL,
activetems_MIN varchar2(256) NOT NULL,
activetems_MAX varchar2(256) NOT NULL,
inactivtems_MIN varchar2(256) NOT NULL,
inactivtems_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMTeamsInvTest_THRESH ADD constraint PK_MTMTeamsInvTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMTeamsInvTest_THRESH ON MTMTeamsInvTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMTeamsInvTest ON MTMTeamsInvTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMTeamsInvTest ON MTMTeamsInvTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMtemsOAMactTest CASCADE CONSTRAINTS;
CREATE TABLE MTMtemsOAMactTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MemAdtions Number(20,4) NOT NULL,
MemAdtions_ST varchar2(32) NOT NULL,
MemRolChgd Number(20,4) NOT NULL,
MemRolChgd_ST varchar2(32) NOT NULL,
TemStgsChgd Number(20,4) NOT NULL,
TemStgsChgd_ST varchar2(32) NOT NULL,
temdelcnt Number(20,4) NOT NULL,
temdelcnt_ST varchar2(32) NOT NULL,
MembrRmvdCnt Number(20,4) NOT NULL,
MembrRmvdCnt_ST varchar2(32) NOT NULL,
CnlStgsCngCnt Number(20,4) NOT NULL,
CnlStgsCngCnt_ST varchar2(32) NOT NULL,
TmtentStgMds Number(20,4) NOT NULL,
TmtentStgMds_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMtemsOAMactTest ON MTMtemsOAMactTest(MSMT_TIME);
ALTER TABLE MTMtemsOAMactTest ADD constraint PK_MTMtemsOAMactTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMtemsOAMactTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMtemsOAMactTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MemAdtions_MIN Number(20,4) NOT NULL,
MemAdtions_MAX Number(20,4) NOT NULL,
MemAdtions_STCNT varchar2(32) NOT NULL,
MemRolChgd_MIN Number(20,4) NOT NULL,
MemRolChgd_MAX Number(20,4) NOT NULL,
MemRolChgd_STCNT varchar2(32) NOT NULL,
TemStgsChgd_MIN Number(20,4) NOT NULL,
TemStgsChgd_MAX Number(20,4) NOT NULL,
TemStgsChgd_STCNT varchar2(32) NOT NULL,
temdelcnt_MIN Number(20,4) NOT NULL,
temdelcnt_MAX Number(20,4) NOT NULL,
temdelcnt_STCNT varchar2(32) NOT NULL,
MembrRmvdCnt_MIN Number(20,4) NOT NULL,
MembrRmvdCnt_MAX Number(20,4) NOT NULL,
MembrRmvdCnt_STCNT varchar2(32) NOT NULL,
CnlStgsCngCnt_MIN Number(20,4) NOT NULL,
CnlStgsCngCnt_MAX Number(20,4) NOT NULL,
CnlStgsCngCnt_STCNT varchar2(32) NOT NULL,
TmtentStgMds_MIN Number(20,4) NOT NULL,
TmtentStgMds_MAX Number(20,4) NOT NULL,
TmtentStgMds_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMtemsOAMactTest_TREND ADD constraint PK_MTMtemsOAMactTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMtemsOAMactTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMtemsOAMactTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MemAdtions_MIN varchar2(256) NOT NULL,
MemAdtions_MAX varchar2(256) NOT NULL,
MemRolChgd_MIN varchar2(256) NOT NULL,
MemRolChgd_MAX varchar2(256) NOT NULL,
TemStgsChgd_MIN varchar2(256) NOT NULL,
TemStgsChgd_MAX varchar2(256) NOT NULL,
temdelcnt_MIN varchar2(256) NOT NULL,
temdelcnt_MAX varchar2(256) NOT NULL,
MembrRmvdCnt_MIN varchar2(256) NOT NULL,
MembrRmvdCnt_MAX varchar2(256) NOT NULL,
CnlStgsCngCnt_MIN varchar2(256) NOT NULL,
CnlStgsCngCnt_MAX varchar2(256) NOT NULL,
TmtentStgMds_MIN varchar2(256) NOT NULL,
TmtentStgMds_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMtemsOAMactTest_THRESH ADD constraint PK_MTMtemsOAMactTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMtemsOAMactTest_THRESH ON MTMtemsOAMactTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMtemsOAMactTest ON MTMtemsOAMactTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMtemsOAMactTest ON MTMtemsOAMactTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMtmChnlOperTest CASCADE CONSTRAINTS;
CREATE TABLE MTMtmChnlOperTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
botsAdditnCnt Number(20,4) NOT NULL,
botsAdditnCnt_ST varchar2(32) NOT NULL,
botsRemvedCnt Number(20,4) NOT NULL,
botsRemvedCnt_ST varchar2(32) NOT NULL,
chanlsAdtCnt Number(20,4) NOT NULL,
chanlsAdtCnt_ST varchar2(32) NOT NULL,
chanlsDelCnt Number(20,4) NOT NULL,
chanlsDelCnt_ST varchar2(32) NOT NULL,
temCreatCnt Number(20,4) NOT NULL,
temCreatCnt_ST varchar2(32) NOT NULL,
CnctAdtsClCnt Number(20,4) NOT NULL,
CnctAdtsClCnt_ST varchar2(32) NOT NULL,
TabAddtoClCnt Number(20,4) NOT NULL,
TabAddtoClCnt_ST varchar2(32) NOT NULL,
CnctrRmdClCnt Number(20,4) NOT NULL,
CnctrRmdClCnt_ST varchar2(32) NOT NULL,
TabRmdClCnt Number(20,4) NOT NULL,
TabRmdClCnt_ST varchar2(32) NOT NULL,
CnctMfInClCnt Number(20,4) NOT NULL,
CnctMfInClCnt_ST varchar2(32) NOT NULL,
TabMfInClCnt Number(20,4) NOT NULL,
TabMfInClCnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMtmChnlOperTest ON MTMtmChnlOperTest(MSMT_TIME);
ALTER TABLE MTMtmChnlOperTest ADD constraint PK_MTMtmChnlOperTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMtmChnlOperTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMtmChnlOperTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
botsAdditnCnt_MIN Number(20,4) NOT NULL,
botsAdditnCnt_MAX Number(20,4) NOT NULL,
botsAdditnCnt_STCNT varchar2(32) NOT NULL,
botsRemvedCnt_MIN Number(20,4) NOT NULL,
botsRemvedCnt_MAX Number(20,4) NOT NULL,
botsRemvedCnt_STCNT varchar2(32) NOT NULL,
chanlsAdtCnt_MIN Number(20,4) NOT NULL,
chanlsAdtCnt_MAX Number(20,4) NOT NULL,
chanlsAdtCnt_STCNT varchar2(32) NOT NULL,
chanlsDelCnt_MIN Number(20,4) NOT NULL,
chanlsDelCnt_MAX Number(20,4) NOT NULL,
chanlsDelCnt_STCNT varchar2(32) NOT NULL,
temCreatCnt_MIN Number(20,4) NOT NULL,
temCreatCnt_MAX Number(20,4) NOT NULL,
temCreatCnt_STCNT varchar2(32) NOT NULL,
CnctAdtsClCnt_MIN Number(20,4) NOT NULL,
CnctAdtsClCnt_MAX Number(20,4) NOT NULL,
CnctAdtsClCnt_STCNT varchar2(32) NOT NULL,
TabAddtoClCnt_MIN Number(20,4) NOT NULL,
TabAddtoClCnt_MAX Number(20,4) NOT NULL,
TabAddtoClCnt_STCNT varchar2(32) NOT NULL,
CnctrRmdClCnt_MIN Number(20,4) NOT NULL,
CnctrRmdClCnt_MAX Number(20,4) NOT NULL,
CnctrRmdClCnt_STCNT varchar2(32) NOT NULL,
TabRmdClCnt_MIN Number(20,4) NOT NULL,
TabRmdClCnt_MAX Number(20,4) NOT NULL,
TabRmdClCnt_STCNT varchar2(32) NOT NULL,
CnctMfInClCnt_MIN Number(20,4) NOT NULL,
CnctMfInClCnt_MAX Number(20,4) NOT NULL,
CnctMfInClCnt_STCNT varchar2(32) NOT NULL,
TabMfInClCnt_MIN Number(20,4) NOT NULL,
TabMfInClCnt_MAX Number(20,4) NOT NULL,
TabMfInClCnt_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMtmChnlOperTest_TREND ADD constraint PK_MTMtmChnlOperTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMtmChnlOperTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMtmChnlOperTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
botsAdditnCnt_MIN varchar2(256) NOT NULL,
botsAdditnCnt_MAX varchar2(256) NOT NULL,
botsRemvedCnt_MIN varchar2(256) NOT NULL,
botsRemvedCnt_MAX varchar2(256) NOT NULL,
chanlsAdtCnt_MIN varchar2(256) NOT NULL,
chanlsAdtCnt_MAX varchar2(256) NOT NULL,
chanlsDelCnt_MIN varchar2(256) NOT NULL,
chanlsDelCnt_MAX varchar2(256) NOT NULL,
temCreatCnt_MIN varchar2(256) NOT NULL,
temCreatCnt_MAX varchar2(256) NOT NULL,
CnctAdtsClCnt_MIN varchar2(256) NOT NULL,
CnctAdtsClCnt_MAX varchar2(256) NOT NULL,
TabAddtoClCnt_MIN varchar2(256) NOT NULL,
TabAddtoClCnt_MAX varchar2(256) NOT NULL,
CnctrRmdClCnt_MIN varchar2(256) NOT NULL,
CnctrRmdClCnt_MAX varchar2(256) NOT NULL,
TabRmdClCnt_MIN varchar2(256) NOT NULL,
TabRmdClCnt_MAX varchar2(256) NOT NULL,
CnctMfInClCnt_MIN varchar2(256) NOT NULL,
CnctMfInClCnt_MAX varchar2(256) NOT NULL,
TabMfInClCnt_MIN varchar2(256) NOT NULL,
TabMfInClCnt_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMtmChnlOperTest_THRESH ADD constraint PK_MTMtmChnlOperTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMtmChnlOperTest_THRESH ON MTMtmChnlOperTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMtmChnlOperTest ON MTMtmChnlOperTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMtmChnlOperTest ON MTMtmChnlOperTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMUsrLoginsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMUsrLoginsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
UsrloginsCnt Number(20,4) NOT NULL,
UsrloginsCnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMUsrLoginsTest ON MTMUsrLoginsTest(MSMT_TIME);
ALTER TABLE MTMUsrLoginsTest ADD constraint PK_MTMUsrLoginsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMUsrLoginsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMUsrLoginsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
UsrloginsCnt_MIN Number(20,4) NOT NULL,
UsrloginsCnt_MAX Number(20,4) NOT NULL,
UsrloginsCnt_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMUsrLoginsTest_TREND ADD constraint PK_MTMUsrLoginsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMUsrLoginsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMUsrLoginsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
UsrloginsCnt_MIN varchar2(256) NOT NULL,
UsrloginsCnt_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMUsrLoginsTest_THRESH ADD constraint PK_MTMUsrLoginsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMUsrLoginsTest_THRESH ON MTMUsrLoginsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMUsrLoginsTest ON MTMUsrLoginsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMUsrLoginsTest ON MTMUsrLoginsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMMsgCentTest CASCADE CONSTRAINTS;
CREATE TABLE MTMMsgCentTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MsgCenterCommunication Number(20,4) NOT NULL,
MsgCenterCommunication_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMMsgCentTest ON MTMMsgCentTest(MSMT_TIME);
ALTER TABLE MTMMsgCentTest ADD constraint PK_MTMMsgCentTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMMsgCentTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMMsgCentTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MsgCenterCommunication_MIN Number(20,4) NOT NULL,
MsgCenterCommunication_MAX Number(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMMsgCentTest_TREND ADD constraint PK_MTMMsgCentTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMMsgCentTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMMsgCentTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MsgCenterCommunication_MIN varchar2(256) NOT NULL,
MsgCenterCommunication_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMMsgCentTest_THRESH ADD constraint PK_MTMMsgCentTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMMsgCentTest_THRESH ON MTMMsgCentTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMMsgCentTest ON MTMMsgCentTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMMsgCentTest ON MTMMsgCentTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMConneChecksTest CASCADE CONSTRAINTS;
CREATE TABLE MTMConneChecksTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Connection_Status Number(20,4) NOT NULL,
Connection_Status_ST varchar2(32) NOT NULL,
Time_taken_to_connect Number(20,4) NOT NULL,
Time_taken_to_connect_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMConneChecksTest ON MTMConneChecksTest(MSMT_TIME);
ALTER TABLE MTMConneChecksTest ADD constraint PK_MTMConneChecksTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMConneChecksTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMConneChecksTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Connection_Status_MIN Number(20,4) NOT NULL,
Connection_Status_MAX Number(20,4) NOT NULL,
Connection_Status_STCNT varchar2(32) NOT NULL,
Time_taken_to_connect_MIN Number(20,4) NOT NULL,
Time_taken_to_connect_MAX Number(20,4) NOT NULL,
Time_taken_to_connect_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMConneChecksTest_TREND ADD constraint PK_MTMConneChecksTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMConneChecksTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMConneChecksTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Connection_Status_MIN varchar2(256) NOT NULL,
Connection_Status_MAX varchar2(256) NOT NULL,
Time_taken_to_connect_MIN varchar2(256) NOT NULL,
Time_taken_to_connect_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMConneChecksTest_THRESH ADD constraint PK_MTMConneChecksTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMConneChecksTest_THRESH ON MTMConneChecksTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMConneChecksTest ON MTMConneChecksTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMConneChecksTest ON MTMConneChecksTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MTMCallConnTest CASCADE CONSTRAINTS;
CREATE TABLE MTMCallConnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CALLS_INITIATED Number(20,4) NOT NULL,
CALLS_INITIATED_ST varchar2(32) NOT NULL,
CALLS_COMPLETED Number(20,4) NOT NULL,
CALLS_COMPLETED_ST varchar2(32) NOT NULL,
CALLS_FAILED Number(20,4) NOT NULL,
CALLS_FAILED_ST varchar2(32) NOT NULL,
CONN_CHECKS_STATUS Number(20,4) NOT NULL,
CONN_CHECKS_STATUS_ST varchar2(32) NOT NULL,
PACKT_LOSS_RATE Number(20,4) NOT NULL,
PACKT_LOSS_RATE_ST varchar2(32) NOT NULL,
RTT_LATENCY Number(20,4) NOT NULL,
RTT_LATENCY_ST varchar2(32) NOT NULL,
JITTER Number(20,4) NOT NULL,
JITTER_ST varchar2(32) NOT NULL,
PACKT_REORDER_RATIO Number(20,4) NOT NULL,
PACKT_REORDER_RATIO_ST varchar2(32) NOT NULL,
MOS_SCORE Number(20,4) NOT NULL,
MOS_SCORE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMCallConnTest ON MTMCallConnTest(MSMT_TIME);
ALTER TABLE MTMCallConnTest ADD constraint PK_MTMCallConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMCallConnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMCallConnTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CALLS_INITIATED_MIN Number(20,4) NOT NULL,
CALLS_INITIATED_MAX Number(20,4) NOT NULL,
CALLS_INITIATED_STCNT varchar2(32) NOT NULL,
CALLS_COMPLETED_MIN Number(20,4) NOT NULL,
CALLS_COMPLETED_MAX Number(20,4) NOT NULL,
CALLS_COMPLETED_STCNT varchar2(32) NOT NULL,
CALLS_FAILED_MIN Number(20,4) NOT NULL,
CALLS_FAILED_MAX Number(20,4) NOT NULL,
CALLS_FAILED_STCNT varchar2(32) NOT NULL,
CONN_CHECKS_STATUS_MIN Number(20,4) NOT NULL,
CONN_CHECKS_STATUS_MAX Number(20,4) NOT NULL,
CONN_CHECKS_STATUS_STCNT varchar2(32) NOT NULL,
PACKT_LOSS_RATE_MIN Number(20,4) NOT NULL,
PACKT_LOSS_RATE_MAX Number(20,4) NOT NULL,
PACKT_LOSS_RATE_STCNT varchar2(32) NOT NULL,
RTT_LATENCY_MIN Number(20,4) NOT NULL,
RTT_LATENCY_MAX Number(20,4) NOT NULL,
RTT_LATENCY_STCNT varchar2(32) NOT NULL,
JITTER_MIN Number(20,4) NOT NULL,
JITTER_MAX Number(20,4) NOT NULL,
JITTER_STCNT varchar2(32) NOT NULL,
PACKT_REORDER_RATIO_MIN Number(20,4) NOT NULL,
PACKT_REORDER_RATIO_MAX Number(20,4) NOT NULL,
PACKT_REORDER_RATIO_STCNT varchar2(32) NOT NULL,
MOS_SCORE_MIN Number(20,4) NOT NULL,
MOS_SCORE_MAX Number(20,4) NOT NULL,
MOS_SCORE_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMCallConnTest_TREND ADD constraint PK_MTMCallConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMCallConnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMCallConnTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CALLS_INITIATED_MIN varchar2(256) NOT NULL,
CALLS_INITIATED_MAX varchar2(256) NOT NULL,
CALLS_COMPLETED_MIN varchar2(256) NOT NULL,
CALLS_COMPLETED_MAX varchar2(256) NOT NULL,
CALLS_FAILED_MIN varchar2(256) NOT NULL,
CALLS_FAILED_MAX varchar2(256) NOT NULL,
CONN_CHECKS_STATUS_MIN varchar2(256) NOT NULL,
CONN_CHECKS_STATUS_MAX varchar2(256) NOT NULL,
PACKT_LOSS_RATE_MIN varchar2(256) NOT NULL,
PACKT_LOSS_RATE_MAX varchar2(256) NOT NULL,
RTT_LATENCY_MIN varchar2(256) NOT NULL,
RTT_LATENCY_MAX varchar2(256) NOT NULL,
JITTER_MIN varchar2(256) NOT NULL,
JITTER_MAX varchar2(256) NOT NULL,
PACKT_REORDER_RATIO_MIN varchar2(256) NOT NULL,
PACKT_REORDER_RATIO_MAX varchar2(256) NOT NULL,
MOS_SCORE_MIN varchar2(256) NOT NULL,
MOS_SCORE_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMCallConnTest_THRESH ADD constraint PK_MTMCallConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMCallConnTest_THRESH ON MTMCallConnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMCallConnTest ON MTMCallConnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMCallConnTest ON MTMCallConnTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMDeviceUsrDtlsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMDeviceUsrDtlsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMDeviceUsrDtlsTest ON MTMDeviceUsrDtlsTest(MSMT_TIME);
ALTER TABLE MTMDeviceUsrDtlsTest ADD constraint PK_MTMDeviceUsrDtlsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMDeviceUsrDtlsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMDeviceUsrDtlsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMDeviceUsrDtlsTest_TREND ADD constraint PK_MTMDeviceUsrDtlsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMDeviceUsrDtlsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMDeviceUsrDtlsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Unique_users_MIN varchar2(256) NOT NULL,
Unique_users_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMDeviceUsrDtlsTest_THRESH ADD constraint PK_MTMDevicUsrDtlTst_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMDevicUsrDtlTst_THRESH ON MTMDeviceUsrDtlsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMDeviceUsrDtlsTest ON MTMDeviceUsrDtlsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMDeviceUsrDtlsTest ON MTMDeviceUsrDtlsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE O365GrpsActsTest CASCADE CONSTRAINTS;
CREATE TABLE O365GrpsActsTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
mbstrgeusdbyGrps Number(20,4) NOT NULL,
mbstrgeusdbyGrps_ST varchar2(32) NOT NULL,
mbItemsinGrps Number(20,4) NOT NULL,
mbItemsinGrps_ST varchar2(32) NOT NULL,
ShrePointfilsCnt Number(20,4) NOT NULL,
ShrePointfilsCnt_ST varchar2(32) NOT NULL,
ShrePointSteStgeUsd Number(20,4) NOT NULL,
ShrePointSteStgeUsd_ST varchar2(32) NOT NULL,
ShrePntActfilsCnt Number(20,4) NOT NULL,
ShrePntActfilsCnt_ST varchar2(32) NOT NULL,
mailRcvdCnt Number(20,4) NOT NULL,
mailRcvdCnt_ST varchar2(32) NOT NULL,
ymmerPstedMsgCnt Number(20,4) NOT NULL,
ymmerPstedMsgCnt_ST varchar2(32) NOT NULL,
ymlReadmsgCnt Number(20,4) NOT NULL,
ymlReadmsgCnt_ST varchar2(32) NOT NULL,
ymrlikedMsgCnt Number(20,4) NOT NULL,
ymrlikedMsgCnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365GrpsActsTest ON O365GrpsActsTest(MSMT_TIME);
ALTER TABLE O365GrpsActsTest ADD constraint PK_O365GrpsActsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365GrpsActsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365GrpsActsTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
mbstrgeusdbyGrps_MIN Number(20,4) NOT NULL,
mbstrgeusdbyGrps_MAX Number(20,4) NOT NULL,
mbstrgeusdbyGrps_STCNT varchar2(32) NOT NULL,
mbItemsinGrps_MIN Number(20,4) NOT NULL,
mbItemsinGrps_MAX Number(20,4) NOT NULL,
mbItemsinGrps_STCNT varchar2(32) NOT NULL,
ShrePointfilsCnt_MIN Number(20,4) NOT NULL,
ShrePointfilsCnt_MAX Number(20,4) NOT NULL,
ShrePointfilsCnt_STCNT varchar2(32) NOT NULL,
ShrePointSteStgeUsd_MIN Number(20,4) NOT NULL,
ShrePointSteStgeUsd_MAX Number(20,4) NOT NULL,
ShrePointSteStgeUsd_STCNT varchar2(32) NOT NULL,
ShrePntActfilsCnt_MIN Number(20,4) NOT NULL,
ShrePntActfilsCnt_MAX Number(20,4) NOT NULL,
ShrePntActfilsCnt_STCNT varchar2(32) NOT NULL,
mailRcvdCnt_MIN Number(20,4) NOT NULL,
mailRcvdCnt_MAX Number(20,4) NOT NULL,
mailRcvdCnt_STCNT varchar2(32) NOT NULL,
ymmerPstedMsgCnt_MIN Number(20,4) NOT NULL,
ymmerPstedMsgCnt_MAX Number(20,4) NOT NULL,
ymmerPstedMsgCnt_STCNT varchar2(32) NOT NULL,
ymlReadmsgCnt_MIN Number(20,4) NOT NULL,
ymlReadmsgCnt_MAX Number(20,4) NOT NULL,
ymlReadmsgCnt_STCNT varchar2(32) NOT NULL,
ymrlikedMsgCnt_MIN Number(20,4) NOT NULL,
ymrlikedMsgCnt_MAX Number(20,4) NOT NULL,
ymrlikedMsgCnt_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365GrpsActsTest_TREND ADD constraint PK_O365GrpsActsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365GrpsActsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365GrpsActsTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
mbstrgeusdbyGrps_MIN varchar2(256) NOT NULL,
mbstrgeusdbyGrps_MAX varchar2(256) NOT NULL,
mbItemsinGrps_MIN varchar2(256) NOT NULL,
mbItemsinGrps_MAX varchar2(256) NOT NULL,
ShrePointfilsCnt_MIN varchar2(256) NOT NULL,
ShrePointfilsCnt_MAX varchar2(256) NOT NULL,
ShrePointSteStgeUsd_MIN varchar2(256) NOT NULL,
ShrePointSteStgeUsd_MAX varchar2(256) NOT NULL,
ShrePntActfilsCnt_MIN varchar2(256) NOT NULL,
ShrePntActfilsCnt_MAX varchar2(256) NOT NULL,
mailRcvdCnt_MIN varchar2(256) NOT NULL,
mailRcvdCnt_MAX varchar2(256) NOT NULL,
ymmerPstedMsgCnt_MIN varchar2(256) NOT NULL,
ymmerPstedMsgCnt_MAX varchar2(256) NOT NULL,
ymlReadmsgCnt_MIN varchar2(256) NOT NULL,
ymlReadmsgCnt_MAX varchar2(256) NOT NULL,
ymrlikedMsgCnt_MIN varchar2(256) NOT NULL,
ymrlikedMsgCnt_MAX varchar2(256) NOT NULL);

ALTER TABLE O365GrpsActsTest_THRESH ADD constraint PK_O365GrpsActsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365GrpsActsTest_THRESH ON O365GrpsActsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365GrpsActsTest ON O365GrpsActsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365GrpsActsTest ON O365GrpsActsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365UsrStusBySrvTest CASCADE CONSTRAINTS;
CREATE TABLE O365UsrStusBySrvTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Active_Usrs Number(20,4) NOT NULL,
Active_Usrs_ST varchar2(32) NOT NULL,
InActive_Usrs Number(20,4) NOT NULL,
InActive_Usrs_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365UsrStusBySrvTest ON O365UsrStusBySrvTest(MSMT_TIME);
ALTER TABLE O365UsrStusBySrvTest ADD constraint PK_O365UsrStusBySrvTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UsrStusBySrvTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365UsrStusBySrvTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Active_Usrs_MIN Number(20,4) NOT NULL,
Active_Usrs_MAX Number(20,4) NOT NULL,
Active_Usrs_STCNT varchar2(32) NOT NULL,
InActive_Usrs_MIN Number(20,4) NOT NULL,
InActive_Usrs_MAX Number(20,4) NOT NULL,
InActive_Usrs_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365UsrStusBySrvTest_TREND ADD constraint PK_O365UsrStusBySrvTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UsrStusBySrvTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365UsrStusBySrvTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Active_Usrs_MIN varchar2(256) NOT NULL,
Active_Usrs_MAX varchar2(256) NOT NULL,
InActive_Usrs_MIN varchar2(256) NOT NULL,
InActive_Usrs_MAX varchar2(256) NOT NULL);

ALTER TABLE O365UsrStusBySrvTest_THRESH ADD constraint PK_O365UsrStusBySrvTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UsrStuBySrvTest_THRESH ON O365UsrStusBySrvTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UsrStusBySrvTest ON O365UsrStusBySrvTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UsrStusBySrvTest ON O365UsrStusBySrvTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE O365FailedLoginTest CASCADE CONSTRAINTS;
CREATE TABLE O365FailedLoginTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SUCCESS_LOG Number(20,4) NOT NULL,
SUCCESS_LOG_ST varchar2(32) NOT NULL,
FAILED_LOG Number(20,4) NOT NULL,
FAILED_LOG_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365FailedLoginTest ON O365FailedLoginTest(MSMT_TIME);
ALTER TABLE O365FailedLoginTest ADD constraint PK_O365FailedLoginTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE O365FailedLoginTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365FailedLoginTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SUCCESS_LOG_MIN Number(20,4) NOT NULL,
SUCCESS_LOG_MAX Number(20,4) NOT NULL,
SUCCESS_LOG_STCNT varchar2(32) NOT NULL,
FAILED_LOG_MIN Number(20,4) NOT NULL,
FAILED_LOG_MAX Number(20,4) NOT NULL,
FAILED_LOG_STCNT varchar2(32) NOT NULL);
ALTER TABLE O365FailedLoginTest_TREND ADD constraint PK_O365FailedLoginTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE O365FailedLoginTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365FailedLoginTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SUCCESS_LOG_MIN VARCHAR2(256) NOT NULL,
SUCCESS_LOG_MAX VARCHAR2(256) NOT NULL,
FAILED_LOG_MIN VARCHAR2(256) NOT NULL,
FAILED_LOG_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE O365FailedLoginTest_THRESH ADD constraint PK_O365FailedLoginTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365FailedLoginTest_THRESH ON O365FailedLoginTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365FailedLoginTest ON O365FailedLoginTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365FailedLoginTest ON O365FailedLoginTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SBOUsersTest CASCADE CONSTRAINTS;
CREATE TABLE SBOUsersTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
totalUsers Number(20,4) NOT NULL,
totalUsers_ST varchar2(32) NOT NULL,
unAssigned Number(20,4) NOT NULL,
unAssigned_ST varchar2(32) NOT NULL,
dialUpConf Number(20,4) NOT NULL,
dialUpConf_ST varchar2(32) NOT NULL,
createdUsers Number(20,4) NOT NULL,
createdUsers_ST varchar2(32) NOT NULL,
modifiedUsers Number(20,4) NOT NULL,
modifiedUsers_ST varchar2(32) NOT NULL,
softDeleteUsers Number(20,4) NOT NULL,
softDeleteUsers_ST varchar2(32) NOT NULL,
activeUsers Number(20,4) NOT NULL,
activeUsers_ST varchar2(32) NOT NULL,
inActiveUsers Number(20,4) NOT NULL,
inActiveUsers_ST varchar2(32) NOT NULL,
NvrLogUser Number(20,4) NOT NULL,
NvrLogUser_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOUsersTest ON SBOUsersTest(MSMT_TIME);
ALTER TABLE SBOUsersTest ADD constraint PK_SBOUsersTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOUsersTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOUsersTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
totalUsers_MIN Number(20,4) NOT NULL,
totalUsers_MAX Number(20,4) NOT NULL,
totalUsers_STCNT varchar2(32) NOT NULL,
unAssigned_MIN Number(20,4) NOT NULL,
unAssigned_MAX Number(20,4) NOT NULL,
unAssigned_STCNT varchar2(32) NOT NULL,
dialUpConf_MIN Number(20,4) NOT NULL,
dialUpConf_MAX Number(20,4) NOT NULL,
dialUpConf_STCNT varchar2(32) NOT NULL,
createdUsers_MIN Number(20,4) NOT NULL,
createdUsers_MAX Number(20,4) NOT NULL,
createdUsers_STCNT varchar2(32) NOT NULL,
modifiedUsers_MIN Number(20,4) NOT NULL,
modifiedUsers_MAX Number(20,4) NOT NULL,
modifiedUsers_STCNT varchar2(32) NOT NULL,
softDeleteUsers_MIN Number(20,4) NOT NULL,
softDeleteUsers_MAX Number(20,4) NOT NULL,
softDeleteUsers_STCNT varchar2(32) NOT NULL,
activeUsers_MIN Number(20,4) NOT NULL,
activeUsers_MAX Number(20,4) NOT NULL,
activeUsers_STCNT varchar2(32) NOT NULL,
inActiveUsers_MIN Number(20,4) NOT NULL,
inActiveUsers_MAX Number(20,4) NOT NULL,
inActiveUsers_STCNT varchar2(32) NOT NULL,
NvrLogUser_MIN Number(20,4) NOT NULL,
NvrLogUser_MAX Number(20,4) NOT NULL,
NvrLogUser_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOUsersTest_TREND ADD constraint PK_SBOUsersTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOUsersTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOUsersTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
totalUsers_MIN VARCHAR2(256) NOT NULL,
totalUsers_MAX VARCHAR2(256) NOT NULL,
unAssigned_MIN VARCHAR2(256) NOT NULL,
unAssigned_MAX VARCHAR2(256) NOT NULL,
dialUpConf_MIN VARCHAR2(256) NOT NULL,
dialUpConf_MAX VARCHAR2(256) NOT NULL,
createdUsers_MIN VARCHAR2(256) NOT NULL,
createdUsers_MAX VARCHAR2(256) NOT NULL,
modifiedUsers_MIN VARCHAR2(256) NOT NULL,
modifiedUsers_MAX VARCHAR2(256) NOT NULL,
softDeleteUsers_MIN VARCHAR2(256) NOT NULL,
softDeleteUsers_MAX VARCHAR2(256) NOT NULL,
activeUsers_MIN VARCHAR2(256) NOT NULL,
activeUsers_MAX VARCHAR2(256) NOT NULL,
inActiveUsers_MIN VARCHAR2(256) NOT NULL,
inActiveUsers_MAX VARCHAR2(256) NOT NULL,
NvrLogUser_MIN VARCHAR2(256) NOT NULL,
NvrLogUser_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOUsersTest_THRESH ADD constraint PK_SBOUsersTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOUsersTest_THRESH ON SBOUsersTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOUsersTest ON SBOUsersTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOUsersTest ON SBOUsersTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOSrvPrvStats CASCADE CONSTRAINTS;
CREATE TABLE SBOSrvPrvStats(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Pnding_Actvtion Number(20,4) NOT NULL,
Pnding_Actvtion_ST varchar2(32) NOT NULL,
Pnding_Prvision Number(20,4) NOT NULL,
Pnding_Prvision_ST varchar2(32) NOT NULL,
Pnding_input Number(20,4) NOT NULL,
Pnding_input_ST varchar2(32) NOT NULL,
Success Number(20,4) NOT NULL,
Success_ST varchar2(32) NOT NULL,
Disabled Number(20,4) NOT NULL,
Disabled_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOSrvPrvStats ON SBOSrvPrvStats(MSMT_TIME);
ALTER TABLE SBOSrvPrvStats ADD constraint PK_SBOSrvPrvStats PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOSrvPrvStats_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOSrvPrvStats_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Pnding_Actvtion_MIN Number(20,4) NOT NULL,
Pnding_Actvtion_MAX Number(20,4) NOT NULL,
Pnding_Actvtion_STCNT varchar2(32) NOT NULL,
Pnding_Prvision_MIN Number(20,4) NOT NULL,
Pnding_Prvision_MAX Number(20,4) NOT NULL,
Pnding_Prvision_STCNT varchar2(32) NOT NULL,
Pnding_input_MIN Number(20,4) NOT NULL,
Pnding_input_MAX Number(20,4) NOT NULL,
Pnding_input_STCNT varchar2(32) NOT NULL,
Success_MIN Number(20,4) NOT NULL,
Success_MAX Number(20,4) NOT NULL,
Success_STCNT varchar2(32) NOT NULL,
Disabled_MIN Number(20,4) NOT NULL,
Disabled_MAX Number(20,4) NOT NULL,
Disabled_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOSrvPrvStats_TREND ADD constraint PK_SBOSrvPrvStats_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOSrvPrvStats_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOSrvPrvStats_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Pnding_Actvtion_MIN VARCHAR2(256) NOT NULL,
Pnding_Actvtion_MAX VARCHAR2(256) NOT NULL,
Pnding_Prvision_MIN VARCHAR2(256) NOT NULL,
Pnding_Prvision_MAX VARCHAR2(256) NOT NULL,
Pnding_input_MIN VARCHAR2(256) NOT NULL,
Pnding_input_MAX VARCHAR2(256) NOT NULL,
Success_MIN VARCHAR2(256) NOT NULL,
Success_MAX VARCHAR2(256) NOT NULL,
Disabled_MIN VARCHAR2(256) NOT NULL,
Disabled_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOSrvPrvStats_THRESH ADD constraint PK_SBOSrvPrvStats_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOSrvPrvStats_THRESH ON SBOSrvPrvStats_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOSrvPrvStats ON SBOSrvPrvStats_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOSrvPrvStats ON SBOSrvPrvStats_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOFeedBackTest CASCADE CONSTRAINTS;
CREATE TABLE SBOFeedBackTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_Feedback Number(20,4) NOT NULL,
Total_Feedback_ST varchar2(32) NOT NULL,
Total_goodfeedback Number(20,4) NOT NULL,
Total_goodfeedback_ST varchar2(32) NOT NULL,
Total_poorfeedback Number(20,4) NOT NULL,
Total_poorfeedback_ST varchar2(32) NOT NULL,
Total_avoidfeedback Number(20,4) NOT NULL,
Total_avoidfeedback_ST varchar2(32) NOT NULL,
Per_of_goodfb Number(20,4) NOT NULL,
Per_of_goodfb_ST varchar2(32) NOT NULL,
Per_of_poodfb Number(20,4) NOT NULL,
Per_of_poodfb_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOFeedBackTest ON SBOFeedBackTest(MSMT_TIME);
ALTER TABLE SBOFeedBackTest ADD constraint PK_SBOFeedBackTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOFeedBackTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOFeedBackTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_Feedback_MIN Number(20,4) NOT NULL,
Total_Feedback_MAX Number(20,4) NOT NULL,
Total_Feedback_STCNT varchar2(32) NOT NULL,
Total_goodfeedback_MIN Number(20,4) NOT NULL,
Total_goodfeedback_MAX Number(20,4) NOT NULL,
Total_goodfeedback_STCNT varchar2(32) NOT NULL,
Total_poorfeedback_MIN Number(20,4) NOT NULL,
Total_poorfeedback_MAX Number(20,4) NOT NULL,
Total_poorfeedback_STCNT varchar2(32) NOT NULL,
Total_avoidfeedback_MIN Number(20,4) NOT NULL,
Total_avoidfeedback_MAX Number(20,4) NOT NULL,
Total_avoidfeedback_STCNT varchar2(32) NOT NULL,
Per_of_goodfb_MIN Number(20,4) NOT NULL,
Per_of_goodfb_MAX Number(20,4) NOT NULL,
Per_of_goodfb_STCNT varchar2(32) NOT NULL,
Per_of_poodfb_MIN Number(20,4) NOT NULL,
Per_of_poodfb_MAX Number(20,4) NOT NULL,
Per_of_poodfb_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOFeedBackTest_TREND ADD constraint PK_SBOFeedBackTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOFeedBackTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOFeedBackTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_Feedback_MIN VARCHAR2(256) NOT NULL,
Total_Feedback_MAX VARCHAR2(256) NOT NULL,
Total_goodfeedback_MIN VARCHAR2(256) NOT NULL,
Total_goodfeedback_MAX VARCHAR2(256) NOT NULL,
Total_poorfeedback_MIN VARCHAR2(256) NOT NULL,
Total_poorfeedback_MAX VARCHAR2(256) NOT NULL,
Total_avoidfeedback_MIN VARCHAR2(256) NOT NULL,
Total_avoidfeedback_MAX VARCHAR2(256) NOT NULL,
Per_of_goodfb_MIN VARCHAR2(256) NOT NULL,
Per_of_goodfb_MAX VARCHAR2(256) NOT NULL,
Per_of_poodfb_MIN VARCHAR2(256) NOT NULL,
Per_of_poodfb_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOFeedBackTest_THRESH ADD constraint PK_SBOFeedBackTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOFeedBackTest_THRESH ON SBOFeedBackTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOFeedBackTest ON SBOFeedBackTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOFeedBackTest ON SBOFeedBackTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOCallConnTest CASCADE CONSTRAINTS;
CREATE TABLE SBOCallConnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Calls_initiated Number(20,4) NOT NULL,
Calls_initiated_ST varchar2(32) NOT NULL,
Calls_completed Number(20,4) NOT NULL,
Calls_completed_ST varchar2(32) NOT NULL,
Calls_failed Number(20,4) NOT NULL,
Calls_failed_ST varchar2(32) NOT NULL,
Conn_checks_status Number(20,4) NOT NULL,
Conn_checks_status_ST varchar2(32) NOT NULL,
Packt_loss_rate Number(20,4) NOT NULL,
Packt_loss_rate_ST varchar2(32) NOT NULL,
RTT_latency Number(20,4) NOT NULL,
RTT_latency_ST varchar2(32) NOT NULL,
Jitter Number(20,4) NOT NULL,
Jitter_ST varchar2(32) NOT NULL,
Packt_reorder_ratio Number(20,4) NOT NULL,
Packt_reorder_ratio_ST varchar2(32) NOT NULL,
Mos_score Number(20,4) NOT NULL,
Mos_score_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOCallConnTest ON SBOCallConnTest(MSMT_TIME);
ALTER TABLE SBOCallConnTest ADD constraint PK_SBOCallConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOCallConnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOCallConnTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Calls_initiated_MIN Number(20,4) NOT NULL,
Calls_initiated_MAX Number(20,4) NOT NULL,
Calls_initiated_STCNT varchar2(32) NOT NULL,
Calls_completed_MIN Number(20,4) NOT NULL,
Calls_completed_MAX Number(20,4) NOT NULL,
Calls_completed_STCNT varchar2(32) NOT NULL,
Calls_failed_MIN Number(20,4) NOT NULL,
Calls_failed_MAX Number(20,4) NOT NULL,
Calls_failed_STCNT varchar2(32) NOT NULL,
Conn_checks_status_MIN Number(20,4) NOT NULL,
Conn_checks_status_MAX Number(20,4) NOT NULL,
Conn_checks_status_STCNT varchar2(32) NOT NULL,
Packt_loss_rate_MIN Number(20,4) NOT NULL,
Packt_loss_rate_MAX Number(20,4) NOT NULL,
Packt_loss_rate_STCNT varchar2(32) NOT NULL,
RTT_latency_MIN Number(20,4) NOT NULL,
RTT_latency_MAX Number(20,4) NOT NULL,
RTT_latency_STCNT varchar2(32) NOT NULL,
Jitter_MIN Number(20,4) NOT NULL,
Jitter_MAX Number(20,4) NOT NULL,
Jitter_STCNT varchar2(32) NOT NULL,
Packt_reorder_ratio_MIN Number(20,4) NOT NULL,
Packt_reorder_ratio_MAX Number(20,4) NOT NULL,
Packt_reorder_ratio_STCNT varchar2(32) NOT NULL,
Mos_score_MIN Number(20,4) NOT NULL,
Mos_score_MAX Number(20,4) NOT NULL,
Mos_score_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOCallConnTest_TREND ADD constraint PK_SBOCallConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOCallConnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOCallConnTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Calls_initiated_MIN VARCHAR2(256) NOT NULL,
Calls_initiated_MAX VARCHAR2(256) NOT NULL,
Calls_completed_MIN VARCHAR2(256) NOT NULL,
Calls_completed_MAX VARCHAR2(256) NOT NULL,
Calls_failed_MIN VARCHAR2(256) NOT NULL,
Calls_failed_MAX VARCHAR2(256) NOT NULL,
Conn_checks_status_MIN VARCHAR2(256) NOT NULL,
Conn_checks_status_MAX VARCHAR2(256) NOT NULL,
Packt_loss_rate_MIN VARCHAR2(256) NOT NULL,
Packt_loss_rate_MAX VARCHAR2(256) NOT NULL,
RTT_latency_MIN VARCHAR2(256) NOT NULL,
RTT_latency_MAX VARCHAR2(256) NOT NULL,
Jitter_MIN VARCHAR2(256) NOT NULL,
Jitter_MAX VARCHAR2(256) NOT NULL,
Packt_reorder_ratio_MIN VARCHAR2(256) NOT NULL,
Packt_reorder_ratio_MAX VARCHAR2(256) NOT NULL,
Mos_score_MIN VARCHAR2(256) NOT NULL,
Mos_score_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOCallConnTest_THRESH ADD constraint PK_SBOCallConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOCallConnTest_THRESH ON SBOCallConnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOCallConnTest ON SBOCallConnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOCallConnTest ON SBOCallConnTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOSesDomainsTest CASCADE CONSTRAINTS;
CREATE TABLE SBOSesDomainsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
domaincnt Number(20,4) NOT NULL,
domaincnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOSesDomainsTest ON SBOSesDomainsTest(MSMT_TIME);
ALTER TABLE SBOSesDomainsTest ADD constraint PK_SBOSesDomainsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOSesDomainsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOSesDomainsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
domaincnt_MIN Number(20,4) NOT NULL,
domaincnt_MAX Number(20,4) NOT NULL,
domaincnt_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOSesDomainsTest_TREND ADD constraint PK_SBOSesDomainsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOSesDomainsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOSesDomainsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
domaincnt_MIN VARCHAR2(256) NOT NULL,
domaincnt_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOSesDomainsTest_THRESH ADD constraint PK_SBOSesDomainsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOSesDomainsTest_THRESH ON SBOSesDomainsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOSesDomainsTest ON SBOSesDomainsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOSesDomainsTest ON SBOSesDomainsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOAppshrngQltyTest CASCADE CONSTRAINTS;
CREATE TABLE SBOAppshrngQltyTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
totalclsCnt Number(20,4) NOT NULL,
totalclsCnt_ST varchar2(32) NOT NULL,
Currentcals Number(20,4) NOT NULL,
Currentcals_ST varchar2(32) NOT NULL,
poorCalsCnt Number(20,4) NOT NULL,
poorCalsCnt_ST varchar2(32) NOT NULL,
poorCalsPerc Number(20,4) NOT NULL,
poorCalsPerc_ST varchar2(32) NOT NULL,
failedCalsCnt Number(20,4) NOT NULL,
failedCalsCnt_ST varchar2(32) NOT NULL,
failedClsPerct Number(20,4) NOT NULL,
failedClsPerct_ST varchar2(32) NOT NULL,
longCalsCnt Number(20,4) NOT NULL,
longCalsCnt_ST varchar2(32) NOT NULL,
totaldurtn Number(20,4) NOT NULL,
totaldurtn_ST varchar2(32) NOT NULL,
totalcnfcals Number(20,4) NOT NULL,
totalcnfcals_ST varchar2(32) NOT NULL,
CnfOrgUsrCnt Number(20,4) NOT NULL,
CnfOrgUsrCnt_ST varchar2(32) NOT NULL,
CnfPartUsrCnt Number(20,4) NOT NULL,
CnfPartUsrCnt_ST varchar2(32) NOT NULL,
BandWdUsage Number(20,4) NOT NULL,
BandWdUsage_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOAppshrngQltyTest ON SBOAppshrngQltyTest(MSMT_TIME);
ALTER TABLE SBOAppshrngQltyTest ADD constraint PK_SBOAppshrngQltyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOAppshrngQltyTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOAppshrngQltyTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
totalclsCnt_MIN Number(20,4) NOT NULL,
totalclsCnt_MAX Number(20,4) NOT NULL,
totalclsCnt_STCNT varchar2(32) NOT NULL,
Currentcals_MIN Number(20,4) NOT NULL,
Currentcals_MAX Number(20,4) NOT NULL,
Currentcals_STCNT varchar2(32) NOT NULL,
poorCalsCnt_MIN Number(20,4) NOT NULL,
poorCalsCnt_MAX Number(20,4) NOT NULL,
poorCalsCnt_STCNT varchar2(32) NOT NULL,
poorCalsPerc_MIN Number(20,4) NOT NULL,
poorCalsPerc_MAX Number(20,4) NOT NULL,
poorCalsPerc_STCNT varchar2(32) NOT NULL,
failedCalsCnt_MIN Number(20,4) NOT NULL,
failedCalsCnt_MAX Number(20,4) NOT NULL,
failedCalsCnt_STCNT varchar2(32) NOT NULL,
failedClsPerct_MIN Number(20,4) NOT NULL,
failedClsPerct_MAX Number(20,4) NOT NULL,
failedClsPerct_STCNT varchar2(32) NOT NULL,
longCalsCnt_MIN Number(20,4) NOT NULL,
longCalsCnt_MAX Number(20,4) NOT NULL,
longCalsCnt_STCNT varchar2(32) NOT NULL,
totaldurtn_MIN Number(20,4) NOT NULL,
totaldurtn_MAX Number(20,4) NOT NULL,
totaldurtn_STCNT varchar2(32) NOT NULL,
totalcnfcals_MIN Number(20,4) NOT NULL,
totalcnfcals_MAX Number(20,4) NOT NULL,
totalcnfcals_STCNT varchar2(32) NOT NULL,
CnfOrgUsrCnt_MIN Number(20,4) NOT NULL,
CnfOrgUsrCnt_MAX Number(20,4) NOT NULL,
CnfOrgUsrCnt_STCNT varchar2(32) NOT NULL,
CnfPartUsrCnt_MIN Number(20,4) NOT NULL,
CnfPartUsrCnt_MAX Number(20,4) NOT NULL,
CnfPartUsrCnt_STCNT varchar2(32) NOT NULL,
BandWdUsage_MIN Number(20,4) NOT NULL,
BandWdUsage_MAX Number(20,4) NOT NULL,
BandWdUsage_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOAppshrngQltyTest_TREND ADD constraint PK_SBOAppshrngQltyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOAppshrngQltyTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOAppshrngQltyTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
totalclsCnt_MIN VARCHAR2(256) NOT NULL,
totalclsCnt_MAX VARCHAR2(256) NOT NULL,
Currentcals_MIN VARCHAR2(256) NOT NULL,
Currentcals_MAX VARCHAR2(256) NOT NULL,
poorCalsCnt_MIN VARCHAR2(256) NOT NULL,
poorCalsCnt_MAX VARCHAR2(256) NOT NULL,
poorCalsPerc_MIN VARCHAR2(256) NOT NULL,
poorCalsPerc_MAX VARCHAR2(256) NOT NULL,
failedCalsCnt_MIN VARCHAR2(256) NOT NULL,
failedCalsCnt_MAX VARCHAR2(256) NOT NULL,
failedClsPerct_MIN VARCHAR2(256) NOT NULL,
failedClsPerct_MAX VARCHAR2(256) NOT NULL,
longCalsCnt_MIN VARCHAR2(256) NOT NULL,
longCalsCnt_MAX VARCHAR2(256) NOT NULL,
totaldurtn_MIN VARCHAR2(256) NOT NULL,
totaldurtn_MAX VARCHAR2(256) NOT NULL,
totalcnfcals_MIN VARCHAR2(256) NOT NULL,
totalcnfcals_MAX VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MAX VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MAX VARCHAR2(256) NOT NULL,
BandWdUsage_MIN VARCHAR2(256) NOT NULL,
BandWdUsage_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOAppshrngQltyTest_THRESH ADD constraint PK_SBOAppshrngQltyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOAppshrngQltyTest_THRESH ON SBOAppshrngQltyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOAppshrngQltyTest ON SBOAppshrngQltyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOAppshrngQltyTest ON SBOAppshrngQltyTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOusersbydevsTest CASCADE CONSTRAINTS;
CREATE TABLE SBOusersbydevsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Uniq_user Number(20,4) NOT NULL,
Uniq_user_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOusersbydevsTest ON SBOusersbydevsTest(MSMT_TIME);
ALTER TABLE SBOusersbydevsTest ADD constraint PK_SBOusersbydevsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOusersbydevsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOusersbydevsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Uniq_user_MIN Number(20,4) NOT NULL,
Uniq_user_MAX Number(20,4) NOT NULL,
Uniq_user_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOusersbydevsTest_TREND ADD constraint PK_SBOusersbydevsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOusersbydevsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOusersbydevsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Uniq_user_MIN VARCHAR2(256) NOT NULL,
Uniq_user_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOusersbydevsTest_THRESH ADD constraint PK_SBOusersbydevsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOusersbydevsTest_THRESH ON SBOusersbydevsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOusersbydevsTest ON SBOusersbydevsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOusersbydevsTest ON SBOusersbydevsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOImFileSesnTest CASCADE CONSTRAINTS;
CREATE TABLE SBOImFileSesnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
totalclsCnt Number(20,4) NOT NULL,
totalclsCnt_ST varchar2(32) NOT NULL,
Currentcals Number(20,4) NOT NULL,
Currentcals_ST varchar2(32) NOT NULL,
totaldurtn Number(20,4) NOT NULL,
totaldurtn_ST varchar2(32) NOT NULL,
totalcnfcals Number(20,4) NOT NULL,
totalcnfcals_ST varchar2(32) NOT NULL,
CnfOrgUsrCnt Number(20,4) NOT NULL,
CnfOrgUsrCnt_ST varchar2(32) NOT NULL,
CnfPartUsrCnt Number(20,4) NOT NULL,
CnfPartUsrCnt_ST varchar2(32) NOT NULL,
filetransfers Number(20,4) NOT NULL,
filetransfers_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOImFileSesnTest ON SBOImFileSesnTest(MSMT_TIME);
ALTER TABLE SBOImFileSesnTest ADD constraint PK_SBOImFileSesnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOImFileSesnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOImFileSesnTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
totalclsCnt_MIN Number(20,4) NOT NULL,
totalclsCnt_MAX Number(20,4) NOT NULL,
totalclsCnt_STCNT varchar2(32) NOT NULL,
Currentcals_MIN Number(20,4) NOT NULL,
Currentcals_MAX Number(20,4) NOT NULL,
Currentcals_STCNT varchar2(32) NOT NULL,
totaldurtn_MIN Number(20,4) NOT NULL,
totaldurtn_MAX Number(20,4) NOT NULL,
totaldurtn_STCNT varchar2(32) NOT NULL,
totalcnfcals_MIN Number(20,4) NOT NULL,
totalcnfcals_MAX Number(20,4) NOT NULL,
totalcnfcals_STCNT varchar2(32) NOT NULL,
CnfOrgUsrCnt_MIN Number(20,4) NOT NULL,
CnfOrgUsrCnt_MAX Number(20,4) NOT NULL,
CnfOrgUsrCnt_STCNT varchar2(32) NOT NULL,
CnfPartUsrCnt_MIN Number(20,4) NOT NULL,
CnfPartUsrCnt_MAX Number(20,4) NOT NULL,
CnfPartUsrCnt_STCNT varchar2(32) NOT NULL,
filetransfers_MIN Number(20,4) NOT NULL,
filetransfers_MAX Number(20,4) NOT NULL,
filetransfers_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOImFileSesnTest_TREND ADD constraint PK_SBOImFileSesnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOImFileSesnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOImFileSesnTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
totalclsCnt_MIN VARCHAR2(256) NOT NULL,
totalclsCnt_MAX VARCHAR2(256) NOT NULL,
Currentcals_MIN VARCHAR2(256) NOT NULL,
Currentcals_MAX VARCHAR2(256) NOT NULL,
totaldurtn_MIN VARCHAR2(256) NOT NULL,
totaldurtn_MAX VARCHAR2(256) NOT NULL,
totalcnfcals_MIN VARCHAR2(256) NOT NULL,
totalcnfcals_MAX VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MAX VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MAX VARCHAR2(256) NOT NULL,
filetransfers_MIN VARCHAR2(256) NOT NULL,
filetransfers_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOImFileSesnTest_THRESH ADD constraint PK_SBOImFileSesnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOImFileSesnTest_THRESH ON SBOImFileSesnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOImFileSesnTest ON SBOImFileSesnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOImFileSesnTest ON SBOImFileSesnTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOVidCalQlityTest CASCADE CONSTRAINTS;
CREATE TABLE SBOVidCalQlityTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
totalclsCnt Number(20,4) NOT NULL,
totalclsCnt_ST varchar2(32) NOT NULL,
Currentcals Number(20,4) NOT NULL,
Currentcals_ST varchar2(32) NOT NULL,
poorCalsCnt Number(20,4) NOT NULL,
poorCalsCnt_ST varchar2(32) NOT NULL,
poorCalsPerc Number(20,4) NOT NULL,
poorCalsPerc_ST varchar2(32) NOT NULL,
failedCalsCnt Number(20,4) NOT NULL,
failedCalsCnt_ST varchar2(32) NOT NULL,
failedClsPerct Number(20,4) NOT NULL,
failedClsPerct_ST varchar2(32) NOT NULL,
longCalsCnt Number(20,4) NOT NULL,
longCalsCnt_ST varchar2(32) NOT NULL,
totaldurtn Number(20,4) NOT NULL,
totaldurtn_ST varchar2(32) NOT NULL,
totalcnfcals Number(20,4) NOT NULL,
totalcnfcals_ST varchar2(32) NOT NULL,
CnfOrgUsrCnt Number(20,4) NOT NULL,
CnfOrgUsrCnt_ST varchar2(32) NOT NULL,
CnfPartUsrCnt Number(20,4) NOT NULL,
CnfPartUsrCnt_ST varchar2(32) NOT NULL,
BandWdUsage Number(20,4) NOT NULL,
BandWdUsage_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOVidCalQlityTest ON SBOVidCalQlityTest(MSMT_TIME);
ALTER TABLE SBOVidCalQlityTest ADD constraint PK_SBOVidCalQlityTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOVidCalQlityTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOVidCalQlityTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
totalclsCnt_MIN Number(20,4) NOT NULL,
totalclsCnt_MAX Number(20,4) NOT NULL,
totalclsCnt_STCNT varchar2(32) NOT NULL,
Currentcals_MIN Number(20,4) NOT NULL,
Currentcals_MAX Number(20,4) NOT NULL,
Currentcals_STCNT varchar2(32) NOT NULL,
poorCalsCnt_MIN Number(20,4) NOT NULL,
poorCalsCnt_MAX Number(20,4) NOT NULL,
poorCalsCnt_STCNT varchar2(32) NOT NULL,
poorCalsPerc_MIN Number(20,4) NOT NULL,
poorCalsPerc_MAX Number(20,4) NOT NULL,
poorCalsPerc_STCNT varchar2(32) NOT NULL,
failedCalsCnt_MIN Number(20,4) NOT NULL,
failedCalsCnt_MAX Number(20,4) NOT NULL,
failedCalsCnt_STCNT varchar2(32) NOT NULL,
failedClsPerct_MIN Number(20,4) NOT NULL,
failedClsPerct_MAX Number(20,4) NOT NULL,
failedClsPerct_STCNT varchar2(32) NOT NULL,
longCalsCnt_MIN Number(20,4) NOT NULL,
longCalsCnt_MAX Number(20,4) NOT NULL,
longCalsCnt_STCNT varchar2(32) NOT NULL,
totaldurtn_MIN Number(20,4) NOT NULL,
totaldurtn_MAX Number(20,4) NOT NULL,
totaldurtn_STCNT varchar2(32) NOT NULL,
totalcnfcals_MIN Number(20,4) NOT NULL,
totalcnfcals_MAX Number(20,4) NOT NULL,
totalcnfcals_STCNT varchar2(32) NOT NULL,
CnfOrgUsrCnt_MIN Number(20,4) NOT NULL,
CnfOrgUsrCnt_MAX Number(20,4) NOT NULL,
CnfOrgUsrCnt_STCNT varchar2(32) NOT NULL,
CnfPartUsrCnt_MIN Number(20,4) NOT NULL,
CnfPartUsrCnt_MAX Number(20,4) NOT NULL,
CnfPartUsrCnt_STCNT varchar2(32) NOT NULL,
BandWdUsage_MIN Number(20,4) NOT NULL,
BandWdUsage_MAX Number(20,4) NOT NULL,
BandWdUsage_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOVidCalQlityTest_TREND ADD constraint PK_SBOVidCalQlityTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOVidCalQlityTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOVidCalQlityTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
totalclsCnt_MIN VARCHAR2(256) NOT NULL,
totalclsCnt_MAX VARCHAR2(256) NOT NULL,
Currentcals_MIN VARCHAR2(256) NOT NULL,
Currentcals_MAX VARCHAR2(256) NOT NULL,
poorCalsCnt_MIN VARCHAR2(256) NOT NULL,
poorCalsCnt_MAX VARCHAR2(256) NOT NULL,
poorCalsPerc_MIN VARCHAR2(256) NOT NULL,
poorCalsPerc_MAX VARCHAR2(256) NOT NULL,
failedCalsCnt_MIN VARCHAR2(256) NOT NULL,
failedCalsCnt_MAX VARCHAR2(256) NOT NULL,
failedClsPerct_MIN VARCHAR2(256) NOT NULL,
failedClsPerct_MAX VARCHAR2(256) NOT NULL,
longCalsCnt_MIN VARCHAR2(256) NOT NULL,
longCalsCnt_MAX VARCHAR2(256) NOT NULL,
totaldurtn_MIN VARCHAR2(256) NOT NULL,
totaldurtn_MAX VARCHAR2(256) NOT NULL,
totalcnfcals_MIN VARCHAR2(256) NOT NULL,
totalcnfcals_MAX VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MAX VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MAX VARCHAR2(256) NOT NULL,
BandWdUsage_MIN VARCHAR2(256) NOT NULL,
BandWdUsage_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOVidCalQlityTest_THRESH ADD constraint PK_SBOVidCalQlityTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOVidCalQlityTest_THRESH ON SBOVidCalQlityTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOVidCalQlityTest ON SBOVidCalQlityTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOVidCalQlityTest ON SBOVidCalQlityTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE SBOAudCalQltyTest CASCADE CONSTRAINTS;
CREATE TABLE SBOAudCalQltyTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
totalclsCnt Number(20,4) NOT NULL,
totalclsCnt_ST varchar2(32) NOT NULL,
Currentcals Number(20,4) NOT NULL,
Currentcals_ST varchar2(32) NOT NULL,
poorCalsCnt Number(20,4) NOT NULL,
poorCalsCnt_ST varchar2(32) NOT NULL,
poorCalsPerc Number(20,4) NOT NULL,
poorCalsPerc_ST varchar2(32) NOT NULL,
failedCalsCnt Number(20,4) NOT NULL,
failedCalsCnt_ST varchar2(32) NOT NULL,
failedClsPerct Number(20,4) NOT NULL,
failedClsPerct_ST varchar2(32) NOT NULL,
longCalsCnt Number(20,4) NOT NULL,
longCalsCnt_ST varchar2(32) NOT NULL,
totaldurtn Number(20,4) NOT NULL,
totaldurtn_ST varchar2(32) NOT NULL,
totalcnfcals Number(20,4) NOT NULL,
totalcnfcals_ST varchar2(32) NOT NULL,
CnfOrgUsrCnt Number(20,4) NOT NULL,
CnfOrgUsrCnt_ST varchar2(32) NOT NULL,
CnfPartUsrCnt Number(20,4) NOT NULL,
CnfPartUsrCnt_ST varchar2(32) NOT NULL,
BandWdUsage Number(20,4) NOT NULL,
BandWdUsage_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOAudCalQltyTest ON SBOAudCalQltyTest(MSMT_TIME);
ALTER TABLE SBOAudCalQltyTest ADD constraint PK_SBOAudCalQltyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOAudCalQltyTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOAudCalQltyTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
totalclsCnt_MIN Number(20,4) NOT NULL,
totalclsCnt_MAX Number(20,4) NOT NULL,
totalclsCnt_STCNT varchar2(32) NOT NULL,
Currentcals_MIN Number(20,4) NOT NULL,
Currentcals_MAX Number(20,4) NOT NULL,
Currentcals_STCNT varchar2(32) NOT NULL,
poorCalsCnt_MIN Number(20,4) NOT NULL,
poorCalsCnt_MAX Number(20,4) NOT NULL,
poorCalsCnt_STCNT varchar2(32) NOT NULL,
poorCalsPerc_MIN Number(20,4) NOT NULL,
poorCalsPerc_MAX Number(20,4) NOT NULL,
poorCalsPerc_STCNT varchar2(32) NOT NULL,
failedCalsCnt_MIN Number(20,4) NOT NULL,
failedCalsCnt_MAX Number(20,4) NOT NULL,
failedCalsCnt_STCNT varchar2(32) NOT NULL,
failedClsPerct_MIN Number(20,4) NOT NULL,
failedClsPerct_MAX Number(20,4) NOT NULL,
failedClsPerct_STCNT varchar2(32) NOT NULL,
longCalsCnt_MIN Number(20,4) NOT NULL,
longCalsCnt_MAX Number(20,4) NOT NULL,
longCalsCnt_STCNT varchar2(32) NOT NULL,
totaldurtn_MIN Number(20,4) NOT NULL,
totaldurtn_MAX Number(20,4) NOT NULL,
totaldurtn_STCNT varchar2(32) NOT NULL,
totalcnfcals_MIN Number(20,4) NOT NULL,
totalcnfcals_MAX Number(20,4) NOT NULL,
totalcnfcals_STCNT varchar2(32) NOT NULL,
CnfOrgUsrCnt_MIN Number(20,4) NOT NULL,
CnfOrgUsrCnt_MAX Number(20,4) NOT NULL,
CnfOrgUsrCnt_STCNT varchar2(32) NOT NULL,
CnfPartUsrCnt_MIN Number(20,4) NOT NULL,
CnfPartUsrCnt_MAX Number(20,4) NOT NULL,
CnfPartUsrCnt_STCNT varchar2(32) NOT NULL,
BandWdUsage_MIN Number(20,4) NOT NULL,
BandWdUsage_MAX Number(20,4) NOT NULL,
BandWdUsage_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOAudCalQltyTest_TREND ADD constraint PK_SBOAudCalQltyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOAudCalQltyTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOAudCalQltyTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
totalclsCnt_MIN VARCHAR2(256) NOT NULL,
totalclsCnt_MAX VARCHAR2(256) NOT NULL,
Currentcals_MIN VARCHAR2(256) NOT NULL,
Currentcals_MAX VARCHAR2(256) NOT NULL,
poorCalsCnt_MIN VARCHAR2(256) NOT NULL,
poorCalsCnt_MAX VARCHAR2(256) NOT NULL,
poorCalsPerc_MIN VARCHAR2(256) NOT NULL,
poorCalsPerc_MAX VARCHAR2(256) NOT NULL,
failedCalsCnt_MIN VARCHAR2(256) NOT NULL,
failedCalsCnt_MAX VARCHAR2(256) NOT NULL,
failedClsPerct_MIN VARCHAR2(256) NOT NULL,
failedClsPerct_MAX VARCHAR2(256) NOT NULL,
longCalsCnt_MIN VARCHAR2(256) NOT NULL,
longCalsCnt_MAX VARCHAR2(256) NOT NULL,
totaldurtn_MIN VARCHAR2(256) NOT NULL,
totaldurtn_MAX VARCHAR2(256) NOT NULL,
totalcnfcals_MIN VARCHAR2(256) NOT NULL,
totalcnfcals_MAX VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MAX VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MAX VARCHAR2(256) NOT NULL,
BandWdUsage_MIN VARCHAR2(256) NOT NULL,
BandWdUsage_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOAudCalQltyTest_THRESH ADD constraint PK_SBOAudCalQltyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOAudCalQltyTest_THRESH ON SBOAudCalQltyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOAudCalQltyTest ON SBOAudCalQltyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOAudCalQltyTest ON SBOAudCalQltyTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOMsgCentTest CASCADE CONSTRAINTS;
CREATE TABLE SBOMsgCentTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MsgCenterCommunication Number(20,4) NOT NULL,
MsgCenterCommunication_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOMsgCentTest ON SBOMsgCentTest(MSMT_TIME);
ALTER TABLE SBOMsgCentTest ADD constraint PK_SBOMsgCentTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOMsgCentTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOMsgCentTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MsgCenterCommunication_MIN Number(20,4) NOT NULL,
MsgCenterCommunication_MAX Number(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOMsgCentTest_TREND ADD constraint PK_SBOMsgCentTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOMsgCentTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOMsgCentTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MsgCenterCommunication_MIN VARCHAR2(256) NOT NULL,
MsgCenterCommunication_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOMsgCentTest_THRESH ADD constraint PK_SBOMsgCentTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOMsgCentTest_THRESH ON SBOMsgCentTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOMsgCentTest ON SBOMsgCentTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOMsgCentTest ON SBOMsgCentTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOConcStatusTest CASCADE CONSTRAINTS;
CREATE TABLE SBOConcStatusTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
status Number(20,4) NOT NULL,
status_ST varchar2(32) NOT NULL,
pblmtcServ Number(20,4) NOT NULL,
pblmtcServ_ST varchar2(32) NOT NULL,
reslvedSrvc Number(20,4) NOT NULL,
reslvedSrvc_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOConcStatusTest ON SBOConcStatusTest(MSMT_TIME);
ALTER TABLE SBOConcStatusTest ADD constraint PK_SBOConcStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOConcStatusTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOConcStatusTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
status_MIN Number(20,4) NOT NULL,
status_MAX Number(20,4) NOT NULL,
status_STCNT varchar2(32) NOT NULL,
pblmtcServ_MIN Number(20,4) NOT NULL,
pblmtcServ_MAX Number(20,4) NOT NULL,
pblmtcServ_STCNT varchar2(32) NOT NULL,
reslvedSrvc_MIN Number(20,4) NOT NULL,
reslvedSrvc_MAX Number(20,4) NOT NULL,
reslvedSrvc_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOConcStatusTest_TREND ADD constraint PK_SBOConcStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOConcStatusTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOConcStatusTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
status_MIN VARCHAR2(256) NOT NULL,
status_MAX VARCHAR2(256) NOT NULL,
pblmtcServ_MIN VARCHAR2(256) NOT NULL,
pblmtcServ_MAX VARCHAR2(256) NOT NULL,
reslvedSrvc_MIN VARCHAR2(256) NOT NULL,
reslvedSrvc_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOConcStatusTest_THRESH ADD constraint PK_SBOConcStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOConcStatusTest_THRESH ON SBOConcStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOConcStatusTest ON SBOConcStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOConcStatusTest ON SBOConcStatusTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOConneChecksTest CASCADE CONSTRAINTS;
CREATE TABLE SBOConneChecksTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Connection_Status Number(20,4) NOT NULL,
Connection_Status_ST varchar2(32) NOT NULL,
Time_taken_to_connect Number(20,4) NOT NULL,
Time_taken_to_connect_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOConneChecksTest ON SBOConneChecksTest(MSMT_TIME);
ALTER TABLE SBOConneChecksTest ADD constraint PK_SBOConneChecksTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOConneChecksTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOConneChecksTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Connection_Status_MIN Number(20,4) NOT NULL,
Connection_Status_MAX Number(20,4) NOT NULL,
Connection_Status_STCNT varchar2(32) NOT NULL,
Time_taken_to_connect_MIN Number(20,4) NOT NULL,
Time_taken_to_connect_MAX Number(20,4) NOT NULL,
Time_taken_to_connect_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOConneChecksTest_TREND ADD constraint PK_SBOConneChecksTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOConneChecksTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOConneChecksTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Connection_Status_MIN VARCHAR2(256) NOT NULL,
Connection_Status_MAX VARCHAR2(256) NOT NULL,
Time_taken_to_connect_MIN VARCHAR2(256) NOT NULL,
Time_taken_to_connect_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOConneChecksTest_THRESH ADD constraint PK_SBOConneChecksTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOConneChecksTest_THRESH ON SBOConneChecksTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOConneChecksTest ON SBOConneChecksTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOConneChecksTest ON SBOConneChecksTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOSrvcHlhTest CASCADE CONSTRAINTS;
CREATE TABLE SBOSrvcHlhTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Service_incidents Number(20,4) NOT NULL,
Service_incidents_ST varchar2(32) NOT NULL,
Maintenance_events Number(20,4) NOT NULL,
Maintenance_events_ST varchar2(32) NOT NULL,
Service_Status Number(20,4) NOT NULL,
Service_Status_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOSrvcHlhTest ON SBOSrvcHlhTest(MSMT_TIME);
ALTER TABLE SBOSrvcHlhTest ADD constraint PK_SBOSrvcHlhTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOSrvcHlhTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOSrvcHlhTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Service_incidents_MIN Number(20,4) NOT NULL,
Service_incidents_MAX Number(20,4) NOT NULL,
Service_incidents_STCNT varchar2(32) NOT NULL,
Maintenance_events_MIN Number(20,4) NOT NULL,
Maintenance_events_MAX Number(20,4) NOT NULL,
Maintenance_events_STCNT varchar2(32) NOT NULL,
Service_Status_MIN Number(20,4) NOT NULL,
Service_Status_MAX Number(20,4) NOT NULL,
Service_Status_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOSrvcHlhTest_TREND ADD constraint PK_SBOSrvcHlhTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOSrvcHlhTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOSrvcHlhTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Service_incidents_MIN VARCHAR2(256) NOT NULL,
Service_incidents_MAX VARCHAR2(256) NOT NULL,
Maintenance_events_MIN VARCHAR2(256) NOT NULL,
Maintenance_events_MAX VARCHAR2(256) NOT NULL,
Service_Status_MIN VARCHAR2(256) NOT NULL,
Service_Status_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOSrvcHlhTest_THRESH ADD constraint PK_SBOSrvcHlhTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOSrvcHlhTest_THRESH ON SBOSrvcHlhTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOSrvcHlhTest ON SBOSrvcHlhTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOSrvcHlhTest ON SBOSrvcHlhTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE NginxZOPCacheTest CASCADE CONSTRAINTS;
CREATE TABLE NginxZOPCacheTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
OPCODE_CACHING Number(20,4) NOT NULL,
OPCODE_CACHING_ST varchar2(32) NOT NULL,
OPTIMIZATION Number(20,4) NOT NULL,
OPTIMIZATION_ST varchar2(32) NOT NULL,
CACHE_HITS Number(20,4) NOT NULL,
CACHE_HITS_ST varchar2(32) NOT NULL,
CACHE_MISSES Number(20,4) NOT NULL,
CACHE_MISSES_ST varchar2(32) NOT NULL,
CACHE_HIT_RATE Number(20,4) NOT NULL,
CACHE_HIT_RATE_ST varchar2(32) NOT NULL,
MISSES_RATIO Number(20,4) NOT NULL,
MISSES_RATIO_ST varchar2(32) NOT NULL,
USED_MEMORY Number(20,4) NOT NULL,
USED_MEMORY_ST varchar2(32) NOT NULL,
FREE_MEMORY Number(20,4) NOT NULL,
FREE_MEMORY_ST varchar2(32) NOT NULL,
WASTED_MEMORY Number(20,4) NOT NULL,
WASTED_MEMORY_ST varchar2(32) NOT NULL,
WASTED_MEM_PERC Number(20,4) NOT NULL,
WASTED_MEM_PERC_ST varchar2(32) NOT NULL,
INTRN_STR_USEDMEM Number(20,4) NOT NULL,
INTRN_STR_USEDMEM_ST varchar2(32) NOT NULL,
INTRN_STR_FREEMEM Number(20,4) NOT NULL,
INTRN_STR_FREEMEM_ST varchar2(32) NOT NULL,
CACHED_SCRIPTS Number(20,4) NOT NULL,
CACHED_SCRIPTS_ST varchar2(32) NOT NULL,
CACHED_KEYS Number(20,4) NOT NULL,
CACHED_KEYS_ST varchar2(32) NOT NULL,
MAX_KEYS Number(20,4) NOT NULL,
MAX_KEYS_ST varchar2(32) NOT NULL,
OOM_RESTARTS Number(20,4) NOT NULL,
OOM_RESTARTS_ST varchar2(32) NOT NULL,
HASH_KEYS_RESTARTS Number(20,4) NOT NULL,
HASH_KEYS_RESTARTS_ST varchar2(32) NOT NULL,
MANUAL_RESTARTS Number(20,4) NOT NULL,
MANUAL_RESTARTS_ST varchar2(32) NOT NULL);


CREATE INDEX IDX_NginxZOPCacheTest ON NginxZOPCacheTest(MSMT_TIME);
ALTER TABLE NginxZOPCacheTest ADD constraint PK_NginxZOPCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE NginxZOPCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE NginxZOPCacheTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD                varchar2(32),
OPCODE_CACHING_MIN Number(20,4) NOT NULL,
OPCODE_CACHING_MAX Number(20,4) NOT NULL,
OPCODE_CACHING_STCNT varchar2(32) NOT NULL,
OPTIMIZATION_MIN Number(20,4) NOT NULL,
OPTIMIZATION_MAX Number(20,4) NOT NULL,
OPTIMIZATION_STCNT varchar2(32) NOT NULL,
CACHE_HITS_MIN Number(20,4) NOT NULL,
CACHE_HITS_MAX Number(20,4) NOT NULL,
CACHE_HITS_STCNT varchar2(32) NOT NULL,
CACHE_MISSES_MIN Number(20,4) NOT NULL,
CACHE_MISSES_MAX Number(20,4) NOT NULL,
CACHE_MISSES_STCNT varchar2(32) NOT NULL,
CACHE_HIT_RATE_MIN Number(20,4) NOT NULL,
CACHE_HIT_RATE_MAX Number(20,4) NOT NULL,
CACHE_HIT_RATE_STCNT varchar2(32) NOT NULL,
MISSES_RATIO_MIN Number(20,4) NOT NULL,
MISSES_RATIO_MAX Number(20,4) NOT NULL,
MISSES_RATIO_STCNT varchar2(32) NOT NULL,
USED_MEMORY_MIN Number(20,4) NOT NULL,
USED_MEMORY_MAX Number(20,4) NOT NULL,
USED_MEMORY_STCNT varchar2(32) NOT NULL,
FREE_MEMORY_MIN Number(20,4) NOT NULL,
FREE_MEMORY_MAX Number(20,4) NOT NULL,
FREE_MEMORY_STCNT varchar2(32) NOT NULL,
WASTED_MEMORY_MIN Number(20,4) NOT NULL,
WASTED_MEMORY_MAX Number(20,4) NOT NULL,
WASTED_MEMORY_STCNT varchar2(32) NOT NULL,
WASTED_MEM_PERC_MIN Number(20,4) NOT NULL,
WASTED_MEM_PERC_MAX Number(20,4) NOT NULL,
WASTED_MEM_PERC_STCNT varchar2(32) NOT NULL,
INTRN_STR_USEDMEM_MIN Number(20,4) NOT NULL,
INTRN_STR_USEDMEM_MAX Number(20,4) NOT NULL,
INTRN_STR_USEDMEM_STCNT varchar2(32) NOT NULL,
INTRN_STR_FREEMEM_MIN Number(20,4) NOT NULL,
INTRN_STR_FREEMEM_MAX Number(20,4) NOT NULL,
INTRN_STR_FREEMEM_STCNT varchar2(32) NOT NULL,
CACHED_SCRIPTS_MIN Number(20,4) NOT NULL,
CACHED_SCRIPTS_MAX Number(20,4) NOT NULL,
CACHED_SCRIPTS_STCNT varchar2(32) NOT NULL,
CACHED_KEYS_MIN Number(20,4) NOT NULL,
CACHED_KEYS_MAX Number(20,4) NOT NULL,
CACHED_KEYS_STCNT varchar2(32) NOT NULL,
MAX_KEYS_MIN Number(20,4) NOT NULL,
MAX_KEYS_MAX Number(20,4) NOT NULL,
MAX_KEYS_STCNT varchar2(32) NOT NULL,
OOM_RESTARTS_MIN Number(20,4) NOT NULL,
OOM_RESTARTS_MAX Number(20,4) NOT NULL,
OOM_RESTARTS_STCNT varchar2(32) NOT NULL,
HASH_KEYS_RESTARTS_MIN Number(20,4) NOT NULL,
HASH_KEYS_RESTARTS_MAX Number(20,4) NOT NULL,
HASH_KEYS_RESTARTS_STCNT varchar2(32) NOT NULL,
MANUAL_RESTARTS_MIN Number(20,4) NOT NULL,
MANUAL_RESTARTS_MAX Number(20,4) NOT NULL,
MANUAL_RESTARTS_STCNT varchar2(32) NOT NULL);


ALTER TABLE NginxZOPCacheTest_TREND ADD constraint PK_NgxZOPCachTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE NginxZOPCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE NginxZOPCacheTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
OPCODE_CACHING_MIN VARCHAR2(256) NOT NULL,
OPCODE_CACHING_MAX VARCHAR2(256) NOT NULL,
OPTIMIZATION_MIN VARCHAR2(256) NOT NULL,
OPTIMIZATION_MAX VARCHAR2(256) NOT NULL,
CACHE_HITS_MIN VARCHAR2(256) NOT NULL,
CACHE_HITS_MAX VARCHAR2(256) NOT NULL,
CACHE_MISSES_MIN VARCHAR2(256) NOT NULL,
CACHE_MISSES_MAX VARCHAR2(256) NOT NULL,
CACHE_HIT_RATE_MIN VARCHAR2(256) NOT NULL,
CACHE_HIT_RATE_MAX VARCHAR2(256) NOT NULL,
MISSES_RATIO_MIN VARCHAR2(256) NOT NULL,
MISSES_RATIO_MAX VARCHAR2(256) NOT NULL,
USED_MEMORY_MIN VARCHAR2(256) NOT NULL,
USED_MEMORY_MAX VARCHAR2(256) NOT NULL,
FREE_MEMORY_MIN VARCHAR2(256) NOT NULL,
FREE_MEMORY_MAX VARCHAR2(256) NOT NULL,
WASTED_MEMORY_MIN VARCHAR2(256) NOT NULL,
WASTED_MEMORY_MAX VARCHAR2(256) NOT NULL,
WASTED_MEM_PERC_MIN VARCHAR2(256) NOT NULL,
WASTED_MEM_PERC_MAX VARCHAR2(256) NOT NULL,
INTRN_STR_USEDMEM_MIN VARCHAR2(256) NOT NULL,
INTRN_STR_USEDMEM_MAX VARCHAR2(256) NOT NULL,
INTRN_STR_FREEMEM_MIN VARCHAR2(256) NOT NULL,
INTRN_STR_FREEMEM_MAX VARCHAR2(256) NOT NULL,
CACHED_SCRIPTS_MIN VARCHAR2(256) NOT NULL,
CACHED_SCRIPTS_MAX VARCHAR2(256) NOT NULL,
CACHED_KEYS_MIN VARCHAR2(256) NOT NULL,
CACHED_KEYS_MAX VARCHAR2(256) NOT NULL,
MAX_KEYS_MIN VARCHAR2(256) NOT NULL,
MAX_KEYS_MAX VARCHAR2(256) NOT NULL,
OOM_RESTARTS_MIN VARCHAR2(256) NOT NULL,
OOM_RESTARTS_MAX VARCHAR2(256) NOT NULL,
HASH_KEYS_RESTARTS_MIN VARCHAR2(256) NOT NULL,
HASH_KEYS_RESTARTS_MAX VARCHAR2(256) NOT NULL,
MANUAL_RESTARTS_MIN VARCHAR2(256) NOT NULL,
MANUAL_RESTARTS_MAX VARCHAR2(256) NOT NULL);


ALTER TABLE NginxZOPCacheTest_THRESH ADD constraint PK_NgxZOPCachTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_NgxZOPCachTest_THRESH ON NginxZOPCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_NginxZOPCacheTest ON NginxZOPCacheTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_NginxZOPCacheTest ON NginxZOPCacheTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE NginxPHPFPMTest CASCADE CONSTRAINTS;
CREATE TABLE NginxPHPFPMTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PRCS_MANAGER Number(20,4) NOT NULL,
PRCS_MANAGER_ST varchar2(32) NOT NULL,
REQ_ACCPT Number(20,4) NOT NULL,
REQ_ACCPT_ST varchar2(32) NOT NULL,
LISTEN_QUE Number(20,4) NOT NULL,
LISTEN_QUE_ST varchar2(32) NOT NULL,
MAX_LISTN_QUE Number(20,4) NOT NULL,
MAX_LISTN_QUE_ST varchar2(32) NOT NULL,
LISTN_QUE_LEN Number(20,4) NOT NULL,
LISTN_QUE_LEN_ST varchar2(32) NOT NULL,
PCNT_LISTN_QUE_USG Number(20,4) NOT NULL,
PCNT_LISTN_QUE_USG_ST varchar2(32) NOT NULL,
IDLE_PROCS Number(20,4) NOT NULL,
IDLE_PROCS_ST varchar2(32) NOT NULL,
ACTIV_PROCS Number(20,4) NOT NULL,
ACTIV_PROCS_ST varchar2(32) NOT NULL,
TOT_PROCS Number(20,4) NOT NULL,
TOT_PROCS_ST varchar2(32) NOT NULL,
PCNT_ACTIV_PROC Number(20,4) NOT NULL,
PCNT_ACTIV_PROC_ST varchar2(32) NOT NULL,
MAX_ACTIV_PROC Number(20,4) NOT NULL,
MAX_ACTIV_PROC_ST varchar2(32) NOT NULL,
MAX_CHILD_RCH Number(20,4) NOT NULL,
MAX_CHILD_RCH_ST varchar2(32) NOT NULL,
SLOW_REQ Number(20,4) NOT NULL,
SLOW_REQ_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_NginxPHPFPMTest ON NginxPHPFPMTest(MSMT_TIME);
ALTER TABLE NginxPHPFPMTest ADD constraint PK_NginxPHPFPMTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE NginxPHPFPMTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE NginxPHPFPMTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
PRCS_MANAGER_MIN Number(20,4) NOT NULL,
PRCS_MANAGER_MAX Number(20,4) NOT NULL,
PRCS_MANAGER_STCNT varchar2(32) NOT NULL,
REQ_ACCPT_MIN Number(20,4) NOT NULL,
REQ_ACCPT_MAX Number(20,4) NOT NULL,
REQ_ACCPT_STCNT varchar2(32) NOT NULL,
LISTEN_QUE_MIN Number(20,4) NOT NULL,
LISTEN_QUE_MAX Number(20,4) NOT NULL,
LISTEN_QUE_STCNT varchar2(32) NOT NULL,
MAX_LISTN_QUE_MIN Number(20,4) NOT NULL,
MAX_LISTN_QUE_MAX Number(20,4) NOT NULL,
MAX_LISTN_QUE_STCNT varchar2(32) NOT NULL,
LISTN_QUE_LEN_MIN Number(20,4) NOT NULL,
LISTN_QUE_LEN_MAX Number(20,4) NOT NULL,
LISTN_QUE_LEN_STCNT varchar2(32) NOT NULL,
PCNT_LISTN_QUE_USG_MIN Number(20,4) NOT NULL,
PCNT_LISTN_QUE_USG_MAX Number(20,4) NOT NULL,
PCNT_LISTN_QUE_USG_STCNT varchar2(32) NOT NULL,
IDLE_PROCS_MIN Number(20,4) NOT NULL,
IDLE_PROCS_MAX Number(20,4) NOT NULL,
IDLE_PROCS_STCNT varchar2(32) NOT NULL,
ACTIV_PROCS_MIN Number(20,4) NOT NULL,
ACTIV_PROCS_MAX Number(20,4) NOT NULL,
ACTIV_PROCS_STCNT varchar2(32) NOT NULL,
TOT_PROCS_MIN Number(20,4) NOT NULL,
TOT_PROCS_MAX Number(20,4) NOT NULL,
TOT_PROCS_STCNT varchar2(32) NOT NULL,
PCNT_ACTIV_PROC_MIN Number(20,4) NOT NULL,
PCNT_ACTIV_PROC_MAX Number(20,4) NOT NULL,
PCNT_ACTIV_PROC_STCNT varchar2(32) NOT NULL,
MAX_ACTIV_PROC_MIN Number(20,4) NOT NULL,
MAX_ACTIV_PROC_MAX Number(20,4) NOT NULL,
MAX_ACTIV_PROC_STCNT varchar2(32) NOT NULL,
MAX_CHILD_RCH_MIN Number(20,4) NOT NULL,
MAX_CHILD_RCH_MAX Number(20,4) NOT NULL,
MAX_CHILD_RCH_STCNT varchar2(32) NOT NULL,
SLOW_REQ_MIN Number(20,4) NOT NULL,
SLOW_REQ_MAX Number(20,4) NOT NULL,
SLOW_REQ_STCNT varchar2(32) NOT NULL);

ALTER TABLE NginxPHPFPMTest_TREND ADD constraint PK_NginxPHPFPMTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE NginxPHPFPMTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE NginxPHPFPMTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
PRCS_MANAGER_MIN VARCHAR2(256) NOT NULL,
PRCS_MANAGER_MAX VARCHAR2(256) NOT NULL,
REQ_ACCPT_MIN VARCHAR2(256) NOT NULL,
REQ_ACCPT_MAX VARCHAR2(256) NOT NULL,
LISTEN_QUE_MIN VARCHAR2(256) NOT NULL,
LISTEN_QUE_MAX VARCHAR2(256) NOT NULL,
MAX_LISTN_QUE_MIN VARCHAR2(256) NOT NULL,
MAX_LISTN_QUE_MAX VARCHAR2(256) NOT NULL,
LISTN_QUE_LEN_MIN VARCHAR2(256) NOT NULL,
LISTN_QUE_LEN_MAX VARCHAR2(256) NOT NULL,
PCNT_LISTN_QUE_USG_MIN VARCHAR2(256) NOT NULL,
PCNT_LISTN_QUE_USG_MAX VARCHAR2(256) NOT NULL,
IDLE_PROCS_MIN VARCHAR2(256) NOT NULL,
IDLE_PROCS_MAX VARCHAR2(256) NOT NULL,
ACTIV_PROCS_MIN VARCHAR2(256) NOT NULL,
ACTIV_PROCS_MAX VARCHAR2(256) NOT NULL,
TOT_PROCS_MIN VARCHAR2(256) NOT NULL,
TOT_PROCS_MAX VARCHAR2(256) NOT NULL,
PCNT_ACTIV_PROC_MIN VARCHAR2(256) NOT NULL,
PCNT_ACTIV_PROC_MAX VARCHAR2(256) NOT NULL,
MAX_ACTIV_PROC_MIN VARCHAR2(256) NOT NULL,
MAX_ACTIV_PROC_MAX VARCHAR2(256) NOT NULL,
MAX_CHILD_RCH_MIN VARCHAR2(256) NOT NULL,
MAX_CHILD_RCH_MAX VARCHAR2(256) NOT NULL,
SLOW_REQ_MIN VARCHAR2(256) NOT NULL,
SLOW_REQ_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE NginxPHPFPMTest_THRESH ADD constraint PK_NginxPHPFPMTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_NginxPHPFPMTest_THRESH ON NginxPHPFPMTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_NginxPHPFPMTest ON NginxPHPFPMTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_NginxPHPFPMTest ON NginxPHPFPMTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE SaaSNetworkTest CASCADE CONSTRAINTS;
CREATE TABLE SaaSNetworkTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
AVG_DELAY Number(20,4) NOT NULL,
AVG_DELAY_ST varchar2(32) NOT NULL,
MIN_DELAY Number(20,4) NOT NULL,
MIN_DELAY_ST varchar2(32) NOT NULL,
PKT_LOSS_PCT Number(20,4) NOT NULL,
PKT_LOSS_PCT_ST varchar2(32) NOT NULL,
AVAILABILITY Number(20,4) NOT NULL,
AVAILABILITY_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SaaSNetworkTest ON SaaSNetworkTest(MSMT_TIME);
ALTER TABLE SaaSNetworkTest ADD constraint PK_SaaSNetworkTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SaaSNetworkTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SaaSNetworkTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AVG_DELAY_MIN Number(20,4) NOT NULL,
AVG_DELAY_MAX Number(20,4) NOT NULL,
AVG_DELAY_STCNT varchar2(32) NOT NULL,
MIN_DELAY_MIN Number(20,4) NOT NULL,
MIN_DELAY_MAX Number(20,4) NOT NULL,
MIN_DELAY_STCNT varchar2(32) NOT NULL,
PKT_LOSS_PCT_MIN Number(20,4) NOT NULL,
PKT_LOSS_PCT_MAX Number(20,4) NOT NULL,
PKT_LOSS_PCT_STCNT varchar2(32) NOT NULL,
AVAILABILITY_MIN Number(20,4) NOT NULL,
AVAILABILITY_MAX Number(20,4) NOT NULL,
AVAILABILITY_STCNT varchar2(32) NOT NULL);

ALTER TABLE SaaSNetworkTest_TREND ADD constraint PK_SaaSNetworkTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SaaSNetworkTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SaaSNetworkTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
AVG_DELAY_MIN VARCHAR2(256) NOT NULL,
AVG_DELAY_MAX VARCHAR2(256) NOT NULL,
MIN_DELAY_MIN VARCHAR2(256) NOT NULL,
MIN_DELAY_MAX VARCHAR2(256) NOT NULL,
PKT_LOSS_PCT_MIN VARCHAR2(256) NOT NULL,
PKT_LOSS_PCT_MAX VARCHAR2(256) NOT NULL,
AVAILABILITY_MIN VARCHAR2(256) NOT NULL,
AVAILABILITY_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SaaSNetworkTest_THRESH ADD constraint PK_SaaSNetworkTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SaaSNetworkTest_THRESH ON SaaSNetworkTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SaaSNetworkTest ON SaaSNetworkTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SaaSNetworkTest ON SaaSNetworkTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE O365SecurityGrpsTest CASCADE CONSTRAINTS;
CREATE TABLE O365SecurityGrpsTest(
TRGT_HOST       VARCHAR2(32),
PORT_NO         VARCHAR2(32),
SITE_NAME       VARCHAR2(64),
INFO            VARCHAR2(128),
MSMT_HOST       VARCHAR2(32),
MSMT_TIME       DATE,
NEWLY_CREATED_GROUPS NUMBER(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_ST VARCHAR2(32) NOT NULL,
SOFT_DELETED_GROUPS NUMBER(20,4) NOT NULL,
SOFT_DELETED_GROUPS_ST VARCHAR2(32) NOT NULL,
TOTAL_GROUPS NUMBER(20,4) NOT NULL,
TOTAL_GROUPS_ST VARCHAR2(32) NOT NULL,
ORPHANED_GROUPS NUMBER(20,4) NOT NULL,
ORPHANED_GROUPS_ST VARCHAR2(32) NOT NULL,
EMPTY_GROUPS NUMBER(20,4) NOT NULL,
EMPTY_GROUPS_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_O365SecrtyGrpsTest ON O365SecurityGrpsTest(MSMT_TIME);
ALTER TABLE O365SecurityGrpsTest ADD CONSTRAINT PK_O365SecrtyGrpsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365SecurityGrpsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365SecurityGrpsTest_TREND(
TRGT_HOST       VARCHAR2(32),
PORT_NO         VARCHAR2(32),
SITE_NAME       VARCHAR2(64),
INFO            VARCHAR2(128),
MSMT_HOST       VARCHAR2(32),
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32),
NEWLY_CREATED_GROUPS_MIN NUMBER(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_MAX NUMBER(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_STCNT VARCHAR2(32) NOT NULL,
SOFT_DELETED_GROUPS_MIN NUMBER(20,4) NOT NULL,
SOFT_DELETED_GROUPS_MAX NUMBER(20,4) NOT NULL,
SOFT_DELETED_GROUPS_STCNT VARCHAR2(32) NOT NULL,
TOTAL_GROUPS_MIN NUMBER(20,4) NOT NULL,
TOTAL_GROUPS_MAX NUMBER(20,4) NOT NULL,
TOTAL_GROUPS_STCNT VARCHAR2(32) NOT NULL,
ORPHANED_GROUPS_MIN NUMBER(20,4) NOT NULL,
ORPHANED_GROUPS_MAX NUMBER(20,4) NOT NULL,
ORPHANED_GROUPS_STCNT VARCHAR2(32) NOT NULL,
EMPTY_GROUPS_MIN NUMBER(20,4) NOT NULL,
EMPTY_GROUPS_MAX NUMBER(20,4) NOT NULL,
EMPTY_GROUPS_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE O365SecurityGrpsTest_TREND ADD CONSTRAINT PK_O365SecrtyGrpsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365SecurityGrpsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365SecurityGrpsTest_THRESH(
TRGT_HOST       VARCHAR2(32),
PORT_NO         VARCHAR2(32),
SITE_NAME       VARCHAR2(64),
INFO            VARCHAR2(128),
MSMT_HOST       VARCHAR2(32),
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
NEWLY_CREATED_GROUPS_MIN VARCHAR2(256) NOT NULL,
NEWLY_CREATED_GROUPS_MAX VARCHAR2(256) NOT NULL,
SOFT_DELETED_GROUPS_MIN VARCHAR2(256) NOT NULL,
SOFT_DELETED_GROUPS_MAX VARCHAR2(256) NOT NULL,
TOTAL_GROUPS_MIN VARCHAR2(256) NOT NULL,
TOTAL_GROUPS_MAX VARCHAR2(256) NOT NULL,
ORPHANED_GROUPS_MIN VARCHAR2(256) NOT NULL,
ORPHANED_GROUPS_MAX VARCHAR2(256) NOT NULL,
EMPTY_GROUPS_MIN VARCHAR2(256) NOT NULL,
EMPTY_GROUPS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365SecurityGrpsTest_THRESH ADD CONSTRAINT PK_O365SecrtyGrpsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365SecrtyGrpsTest_THRESH ON O365SecurityGrpsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365SecurityGrpsTest ON O365SecurityGrpsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365SecurityGrpsTest ON O365SecurityGrpsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOSiteConnectivityTest CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteConnectivityTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
WEB_AVAILABILITY Number(20,4) NOT NULL,
WEB_AVAILABILITY_ST varchar2(32) NOT NULL,
RESPONSE_CODE Number(20,4) NOT NULL,
RESPONSE_CODE_ST varchar2(32) NOT NULL,
RESPONSE_TIME Number(20,4) NOT NULL,
RESPONSE_TIME_ST varchar2(32) NOT NULL,
CONTENT_VALIDITY Number(20,4) NOT NULL,
CONTENT_VALIDITY_ST varchar2(32) NOT NULL,
CONTENT_LENGTH Number(20,4) NOT NULL,
CONTENT_LENGTH_ST varchar2(32) NOT NULL,
SPO_health_score Number(20,4) NOT NULL,
SPO_health_score_ST varchar2(32) NOT NULL,
SPO_request_duration Number(20,4) NOT NULL,
SPO_request_duration_ST varchar2(32) NOT NULL,
SPO_iis_latency Number(20,4) NOT NULL,
SPO_iis_latency_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOSiteConnTest ON SPOSiteConnectivityTest(MSMT_TIME);
ALTER TABLE SPOSiteConnectivityTest ADD constraint PK_SPOSiteConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSiteConnectivityTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteConnectivityTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
WEB_AVAILABILITY_MIN Number(20,4) NOT NULL,
WEB_AVAILABILITY_MAX Number(20,4) NOT NULL,
WEB_AVAILABILITY_STCNT varchar2(32) NOT NULL,
RESPONSE_CODE_MIN Number(20,4) NOT NULL,
RESPONSE_CODE_MAX Number(20,4) NOT NULL,
RESPONSE_CODE_STCNT varchar2(32) NOT NULL,
RESPONSE_TIME_MIN Number(20,4) NOT NULL,
RESPONSE_TIME_MAX Number(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar2(32) NOT NULL,
CONTENT_VALIDITY_MIN Number(20,4) NOT NULL,
CONTENT_VALIDITY_MAX Number(20,4) NOT NULL,
CONTENT_VALIDITY_STCNT varchar2(32) NOT NULL,
CONTENT_LENGTH_MIN Number(20,4) NOT NULL,
CONTENT_LENGTH_MAX Number(20,4) NOT NULL,
CONTENT_LENGTH_STCNT varchar2(32) NOT NULL,
SPO_health_score_MIN Number(20,4) NOT NULL,
SPO_health_score_MAX Number(20,4) NOT NULL,
SPO_health_score_STCNT varchar2(32) NOT NULL,
SPO_request_duration_MIN Number(20,4) NOT NULL,
SPO_request_duration_MAX Number(20,4) NOT NULL,
SPO_request_duration_STCNT varchar2(32) NOT NULL,
SPO_iis_latency_MIN Number(20,4) NOT NULL,
SPO_iis_latency_MAX Number(20,4) NOT NULL,
SPO_iis_latency_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOSiteConnectivityTest_TREND ADD constraint PK_SPOSiteConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSiteConnectivityTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteConnectivityTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
WEB_AVAILABILITY_MIN varchar2(256) NOT NULL,
WEB_AVAILABILITY_MAX varchar2(256) NOT NULL,
RESPONSE_CODE_MIN varchar2(256) NOT NULL,
RESPONSE_CODE_MAX varchar2(256) NOT NULL,
RESPONSE_TIME_MIN varchar2(256) NOT NULL,
RESPONSE_TIME_MAX varchar2(256) NOT NULL,
CONTENT_VALIDITY_MIN varchar2(256) NOT NULL,
CONTENT_VALIDITY_MAX varchar2(256) NOT NULL,
CONTENT_LENGTH_MIN varchar2(256) NOT NULL,
CONTENT_LENGTH_MAX varchar2(256) NOT NULL,
SPO_health_score_MIN varchar2(256) NOT NULL,
SPO_health_score_MAX varchar2(256) NOT NULL,
SPO_request_duration_MIN varchar2(256) NOT NULL,
SPO_request_duration_MAX varchar2(256) NOT NULL,
SPO_iis_latency_MIN varchar2(256) NOT NULL,
SPO_iis_latency_MAX varchar2(256) NOT NULL);

ALTER TABLE SPOSiteConnectivityTest_THRESH ADD constraint PK_SPOSiteConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSiteConnTest_THRESH ON SPOSiteConnectivityTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSiteConnTest ON SPOSiteConnectivityTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSiteConnTest ON SPOSiteConnectivityTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365DycDistbGrpTest CASCADE CONSTRAINTS;
CREATE TABLE O365DycDistbGrpTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Modified_groups Number(20,4) NOT NULL,
Modified_groups_ST varchar2(32) NOT NULL,
Newly_created_groups Number(20,4) NOT NULL,
Newly_created_groups_ST varchar2(32) NOT NULL,
Soft_deleted_groups Number(20,4) NOT NULL,
Soft_deleted_groups_ST varchar2(32) NOT NULL,
Total_groups Number(20,4) NOT NULL,
Total_groups_ST varchar2(32) NOT NULL,
Orphaned_groups Number(20,4) NOT NULL,
Orphaned_groups_ST varchar2(32) NOT NULL,
Empty_groups Number(20,4) NOT NULL,
Empty_groups_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365DycDistbGrpTest ON O365DycDistbGrpTest(MSMT_TIME);
ALTER TABLE O365DycDistbGrpTest ADD constraint PK_O365DycDistbGrpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365DycDistbGrpTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365DycDistbGrpTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Modified_groups_MIN Number(20,4) NOT NULL,
Modified_groups_MAX Number(20,4) NOT NULL,
Modified_groups_STCNT varchar2(32) NOT NULL,
Newly_created_groups_MIN Number(20,4) NOT NULL,
Newly_created_groups_MAX Number(20,4) NOT NULL,
Newly_created_groups_STCNT varchar2(32) NOT NULL,
Soft_deleted_groups_MIN Number(20,4) NOT NULL,
Soft_deleted_groups_MAX Number(20,4) NOT NULL,
Soft_deleted_groups_STCNT varchar2(32) NOT NULL,
Total_groups_MIN Number(20,4) NOT NULL,
Total_groups_MAX Number(20,4) NOT NULL,
Total_groups_STCNT varchar2(32) NOT NULL,
Orphaned_groups_MIN Number(20,4) NOT NULL,
Orphaned_groups_MAX Number(20,4) NOT NULL,
Orphaned_groups_STCNT varchar2(32) NOT NULL,
Empty_groups_MIN Number(20,4) NOT NULL,
Empty_groups_MAX Number(20,4) NOT NULL,
Empty_groups_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365DycDistbGrpTest_TREND ADD constraint PK_O365DycDistbGrpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365DycDistbGrpTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365DycDistbGrpTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Modified_groups_MIN VARCHAR2(256) NOT NULL,
Modified_groups_MAX VARCHAR2(256) NOT NULL,
Newly_created_groups_MIN VARCHAR2(256) NOT NULL,
Newly_created_groups_MAX VARCHAR2(256) NOT NULL,
Soft_deleted_groups_MIN VARCHAR2(256) NOT NULL,
Soft_deleted_groups_MAX VARCHAR2(256) NOT NULL,
Total_groups_MIN VARCHAR2(256) NOT NULL,
Total_groups_MAX VARCHAR2(256) NOT NULL,
Orphaned_groups_MIN VARCHAR2(256) NOT NULL,
Orphaned_groups_MAX VARCHAR2(256) NOT NULL,
Empty_groups_MIN VARCHAR2(256) NOT NULL,
Empty_groups_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365DycDistbGrpTest_THRESH ADD constraint PK_O365DycDistbGrpTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365DycDistbGrpTest_THRESH ON O365DycDistbGrpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365DycDistbGrpTest ON O365DycDistbGrpTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365DycDistbGrpTest ON O365DycDistbGrpTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365UserLogtest CASCADE CONSTRAINTS;
CREATE TABLE O365UserLogtest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Unlicensed_users Number(20,4) NOT NULL,
Unlicensed_users_ST varchar2(32) NOT NULL,
Deleted_users Number(20,4) NOT NULL,
Deleted_users_ST varchar2(32) NOT NULL,
Password_exp Number(20,4) NOT NULL,
Password_exp_ST varchar2(32) NOT NULL,
Allowed_users Number(20,4) NOT NULL,
Allowed_users_ST varchar2(32) NOT NULL,
Blocked_users Number(20,4) NOT NULL,
Blocked_users_ST varchar2(32) NOT NULL,
user_pwdexpire Number(20,4) NOT NULL,
user_pwdexpire_ST varchar2(32) NOT NULL,
TOTAL_USERS Number(20,4) NOT NULL,
TOTAL_USERS_ST varchar2(32) NOT NULL,
LICENSED_USERS Number(20,4) NOT NULL,
LICENSED_USERS_ST varchar2(32) NOT NULL,
MFA_ENABLED_USERS Number(20,4) NOT NULL,
MFA_ENABLED_USERS_ST varchar2(32) NOT NULL,
MFA_ENFORCED_USERS Number(20,4) NOT NULL,
MFA_ENFORCED_USERS_ST varchar2(32) NOT NULL,
MFA_DISABLED_USERS Number(20,4) NOT NULL,
MFA_DISABLED_USERS_ST varchar2(32) NOT NULL);


CREATE INDEX IDX_O365UserLogtest ON O365UserLogtest(MSMT_TIME);
ALTER TABLE O365UserLogtest ADD constraint PK_O365UserLogtest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UserLogtest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365UserLogtest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Unlicensed_users_MIN Number(20,4) NOT NULL,
Unlicensed_users_MAX Number(20,4) NOT NULL,
Unlicensed_users_STCNT varchar2(32) NOT NULL,
Deleted_users_MIN Number(20,4) NOT NULL,
Deleted_users_MAX Number(20,4) NOT NULL,
Deleted_users_STCNT varchar2(32) NOT NULL,
Password_exp_MIN Number(20,4) NOT NULL,
Password_exp_MAX Number(20,4) NOT NULL,
Password_exp_STCNT varchar2(32) NOT NULL,
Allowed_users_MIN Number(20,4) NOT NULL,
Allowed_users_MAX Number(20,4) NOT NULL,
Allowed_users_STCNT varchar2(32) NOT NULL,
Blocked_users_MIN Number(20,4) NOT NULL,
Blocked_users_MAX Number(20,4) NOT NULL,
Blocked_users_STCNT varchar2(32) NOT NULL,
user_pwdexpire_MIN Number(20,4) NOT NULL,
user_pwdexpire_MAX Number(20,4) NOT NULL,
user_pwdexpire_STCNT varchar2(32) NOT NULL,
TOTAL_USERS_MIN Number(20,4) NOT NULL,
TOTAL_USERS_MAX Number(20,4) NOT NULL,
TOTAL_USERS_STCNT varchar2(32) NOT NULL,
LICENSED_USERS_MIN Number(20,4) NOT NULL,
LICENSED_USERS_MAX Number(20,4) NOT NULL,
LICENSED_USERS_STCNT varchar2(32) NOT NULL,
MFA_ENABLED_USERS_MIN Number(20,4) NOT NULL,
MFA_ENABLED_USERS_MAX Number(20,4) NOT NULL,
MFA_ENABLED_USERS_STCNT varchar2(32) NOT NULL,
MFA_ENFORCED_USERS_MIN Number(20,4) NOT NULL,
MFA_ENFORCED_USERS_MAX Number(20,4) NOT NULL,
MFA_ENFORCED_USERS_STCNT varchar2(32) NOT NULL,
MFA_DISABLED_USERS_MIN Number(20,4) NOT NULL,
MFA_DISABLED_USERS_MAX Number(20,4) NOT NULL,
MFA_DISABLED_USERS_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365UserLogtest_TREND ADD constraint PK_O365UserLogtest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UserLogtest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365UserLogtest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Unlicensed_users_MIN VARCHAR2(256) NOT NULL,
Unlicensed_users_MAX VARCHAR2(256) NOT NULL,
Deleted_users_MIN VARCHAR2(256) NOT NULL,
Deleted_users_MAX VARCHAR2(256) NOT NULL,
Password_exp_MIN VARCHAR2(256) NOT NULL,
Password_exp_MAX VARCHAR2(256) NOT NULL,
Allowed_users_MIN VARCHAR2(256) NOT NULL,
Allowed_users_MAX VARCHAR2(256) NOT NULL,
Blocked_users_MIN VARCHAR2(256) NOT NULL,
Blocked_users_MAX VARCHAR2(256) NOT NULL,
user_pwdexpire_MIN VARCHAR2(256) NOT NULL,
user_pwdexpire_MAX VARCHAR2(256) NOT NULL,
TOTAL_USERS_MIN varchar2(256) NOT NULL,
TOTAL_USERS_MAX varchar2(256) NOT NULL,
LICENSED_USERS_MIN varchar2(256) NOT NULL,
LICENSED_USERS_MAX varchar2(256) NOT NULL,
MFA_ENABLED_USERS_MIN varchar2(256) NOT NULL,
MFA_ENABLED_USERS_MAX varchar2(256) NOT NULL,
MFA_ENFORCED_USERS_MIN varchar2(256) NOT NULL,
MFA_ENFORCED_USERS_MAX varchar2(256) NOT NULL,
MFA_DISABLED_USERS_MIN varchar2(256) NOT NULL,
MFA_DISABLED_USERS_MAX varchar2(256) NOT NULL);

ALTER TABLE O365UserLogtest_THRESH ADD constraint PK_O365UserLogtest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UserLogtest_THRESH ON O365UserLogtest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UserLogtest ON O365UserLogtest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UserLogtest ON O365UserLogtest_TREND (MSMT_TIME,PERIOD);


DROP TABLE O365LicnsUsgTest CASCADE CONSTRAINTS;
CREATE TABLE O365LicnsUsgTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Licensed_users Number(20,4) NOT NULL,
Licensed_users_ST varchar2(32) NOT NULL,
Active_units Number(20,4) NOT NULL,
Active_units_ST varchar2(32) NOT NULL,
Warning_units Number(20,4) NOT NULL,
Warning_units_ST varchar2(32) NOT NULL,
Status Number(20,4) NOT NULL,
Status_ST varchar2(32) NOT NULL,
Trail Number(20,4) NOT NULL,
Trail_ST varchar2(32) NOT NULL,
Total_License Number(20,4) NOT NULL,
Total_License_ST varchar2(32) NOT NULL,
Days_to_Expire Number(20,4) NOT NULL,
Days_to_Expire_ST varchar2(32) NOT NULL,
License_usage Number(20,4) NOT NULL,
License_usage_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365LicnsUsgTest ON O365LicnsUsgTest(MSMT_TIME);
ALTER TABLE O365LicnsUsgTest ADD constraint PK_O365LicnsUsgTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365LicnsUsgTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365LicnsUsgTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Licensed_users_MIN Number(20,4) NOT NULL,
Licensed_users_MAX Number(20,4) NOT NULL,
Licensed_users_STCNT varchar2(32) NOT NULL,
Active_units_MIN Number(20,4) NOT NULL,
Active_units_MAX Number(20,4) NOT NULL,
Active_units_STCNT varchar2(32) NOT NULL,
Warning_units_MIN Number(20,4) NOT NULL,
Warning_units_MAX Number(20,4) NOT NULL,
Warning_units_STCNT varchar2(32) NOT NULL,
Status_MIN Number(20,4) NOT NULL,
Status_MAX Number(20,4) NOT NULL,
Status_STCNT varchar2(32) NOT NULL,
Trail_MIN Number(20,4) NOT NULL,
Trail_MAX Number(20,4) NOT NULL,
Trail_STCNT varchar2(32) NOT NULL,
Total_License_MIN Number(20,4) NOT NULL,
Total_License_MAX Number(20,4) NOT NULL,
Total_License_STCNT varchar2(32) NOT NULL,
Days_to_Expire_MIN Number(20,4) NOT NULL,
Days_to_Expire_MAX Number(20,4) NOT NULL,
Days_to_Expire_STCNT varchar2(32) NOT NULL,
License_usage_MIN Number(20,4) NOT NULL,
License_usage_MAX Number(20,4) NOT NULL,
License_usage_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365LicnsUsgTest_TREND ADD constraint PK_O365LicnsUsgTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365LicnsUsgTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365LicnsUsgTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Licensed_users_MIN VARCHAR2(256) NOT NULL,
Licensed_users_MAX VARCHAR2(256) NOT NULL,
Active_units_MIN VARCHAR2(256) NOT NULL,
Active_units_MAX VARCHAR2(256) NOT NULL,
Warning_units_MIN VARCHAR2(256) NOT NULL,
Warning_units_MAX VARCHAR2(256) NOT NULL,
Status_MIN VARCHAR2(256) NOT NULL,
Status_MAX VARCHAR2(256) NOT NULL,
Trail_MIN VARCHAR2(256) NOT NULL,
Trail_MAX VARCHAR2(256) NOT NULL,
Total_License_MIN VARCHAR2(256) NOT NULL,
Total_License_MAX VARCHAR2(256) NOT NULL,
Days_to_Expire_MIN VARCHAR2(256) NOT NULL,
Days_to_Expire_MAX VARCHAR2(256) NOT NULL,
License_usage_MIN VARCHAR2(256) NOT NULL,
License_usage_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365LicnsUsgTest_THRESH ADD constraint PK_O365LicnsUsgTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365LicnsUsgTest_THRESH ON O365LicnsUsgTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365LicnsUsgTest ON O365LicnsUsgTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365LicnsUsgTest ON O365LicnsUsgTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365UserActivTest CASCADE CONSTRAINTS;
CREATE TABLE O365UserActivTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Operations Number(20,4) NOT NULL,
Operations_ST varchar2(32) NOT NULL,
Unique_oprs Number(20,4) NOT NULL,
Unique_oprs_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_O365UserActivTest ON O365UserActivTest(MSMT_TIME);
ALTER TABLE O365UserActivTest ADD constraint PK_O365UserActivTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UserActivTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365UserActivTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Operations_MIN Number(20,4) NOT NULL,
Operations_MAX Number(20,4) NOT NULL,
Operations_STCNT varchar2(32) NOT NULL,
Unique_oprs_MIN Number(20,4) NOT NULL,
Unique_oprs_MAX Number(20,4) NOT NULL,
Unique_oprs_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL);
ALTER TABLE O365UserActivTest_TREND ADD constraint PK_O365UserActivTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UserActivTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365UserActivTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Operations_MIN VARCHAR2(256) NOT NULL,
Operations_MAX VARCHAR2(256) NOT NULL,
Unique_oprs_MIN VARCHAR2(256) NOT NULL,
Unique_oprs_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE O365UserActivTest_THRESH ADD constraint PK_O365UserActivTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UserActivTest_THRESH ON O365UserActivTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UserActivTest ON O365UserActivTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UserActivTest ON O365UserActivTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365ConecChecksTest CASCADE CONSTRAINTS;
CREATE TABLE O365ConecChecksTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Connection_Status Number(20,4) NOT NULL,
Connection_Status_ST varchar2(32) NOT NULL,
Time_taken_to_connect Number(20,4) NOT NULL,
Time_taken_to_connect_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365ConecChecksTest ON O365ConecChecksTest(MSMT_TIME);
ALTER TABLE O365ConecChecksTest ADD constraint PK_O365ConecChecksTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365ConecChecksTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365ConecChecksTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Connection_Status_MIN Number(20,4) NOT NULL,
Connection_Status_MAX Number(20,4) NOT NULL,
Connection_Status_STCNT varchar2(32) NOT NULL,
Time_taken_to_connect_MIN Number(20,4) NOT NULL,
Time_taken_to_connect_MAX Number(20,4) NOT NULL,
Time_taken_to_connect_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365ConecChecksTest_TREND ADD constraint PK_O365ConecChecksTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365ConecChecksTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365ConecChecksTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Connection_Status_MIN VARCHAR2(256) NOT NULL,
Connection_Status_MAX VARCHAR2(256) NOT NULL,
Time_taken_to_connect_MIN VARCHAR2(256) NOT NULL,
Time_taken_to_connect_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365ConecChecksTest_THRESH ADD constraint PK_O365ConecChecksTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365ConecChecksTest_THRESH ON O365ConecChecksTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365ConecChecksTest ON O365ConecChecksTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365ConecChecksTest ON O365ConecChecksTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365DomainTest CASCADE CONSTRAINTS;
CREATE TABLE O365DomainTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Authent Number(20,4) NOT NULL,
Authent_ST varchar2(32) NOT NULL,
cap_cnt Number(20,4) NOT NULL,
cap_cnt_ST varchar2(32) NOT NULL,
IsDefault Number(20,4) NOT NULL,
IsDefault_ST varchar2(32) NOT NULL,
IsInitial Number(20,4) NOT NULL,
IsInitial_ST varchar2(32) NOT NULL,
Stat Number(20,4) NOT NULL,
Stat_ST varchar2(32) NOT NULL,
VerifMethod Number(20,4) NOT NULL,
VerifMethod_ST varchar2(32) NOT NULL,
rootDom_cnt Number(20,4) NOT NULL,
rootDom_cnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365DomainTest ON O365DomainTest(MSMT_TIME);
ALTER TABLE O365DomainTest ADD constraint PK_O365DomainTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365DomainTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365DomainTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Authent_MIN Number(20,4) NOT NULL,
Authent_MAX Number(20,4) NOT NULL,
Authent_STCNT varchar2(32) NOT NULL,
cap_cnt_MIN Number(20,4) NOT NULL,
cap_cnt_MAX Number(20,4) NOT NULL,
cap_cnt_STCNT varchar2(32) NOT NULL,
IsDefault_MIN Number(20,4) NOT NULL,
IsDefault_MAX Number(20,4) NOT NULL,
IsDefault_STCNT varchar2(32) NOT NULL,
IsInitial_MIN Number(20,4) NOT NULL,
IsInitial_MAX Number(20,4) NOT NULL,
IsInitial_STCNT varchar2(32) NOT NULL,
Stat_MIN Number(20,4) NOT NULL,
Stat_MAX Number(20,4) NOT NULL,
Stat_STCNT varchar2(32) NOT NULL,
VerifMethod_MIN Number(20,4) NOT NULL,
VerifMethod_MAX Number(20,4) NOT NULL,
VerifMethod_STCNT varchar2(32) NOT NULL,
rootDom_cnt_MIN Number(20,4) NOT NULL,
rootDom_cnt_MAX Number(20,4) NOT NULL,
rootDom_cnt_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365DomainTest_TREND ADD constraint PK_O365DomainTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365DomainTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365DomainTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Authent_MIN VARCHAR2(256) NOT NULL,
Authent_MAX VARCHAR2(256) NOT NULL,
cap_cnt_MIN VARCHAR2(256) NOT NULL,
cap_cnt_MAX VARCHAR2(256) NOT NULL,
IsDefault_MIN VARCHAR2(256) NOT NULL,
IsDefault_MAX VARCHAR2(256) NOT NULL,
IsInitial_MIN VARCHAR2(256) NOT NULL,
IsInitial_MAX VARCHAR2(256) NOT NULL,
Stat_MIN VARCHAR2(256) NOT NULL,
Stat_MAX VARCHAR2(256) NOT NULL,
VerifMethod_MIN VARCHAR2(256) NOT NULL,
VerifMethod_MAX VARCHAR2(256) NOT NULL,
rootDom_cnt_MIN VARCHAR2(256) NOT NULL,
rootDom_cnt_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365DomainTest_THRESH ADD constraint PK_O365DomainTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365DomainTest_THRESH ON O365DomainTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365DomainTest ON O365DomainTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365DomainTest ON O365DomainTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365MsgCenTest CASCADE CONSTRAINTS;
CREATE TABLE O365MsgCenTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MsgCenterCommunication Number(20,4) NOT NULL,
MsgCenterCommunication_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365MsgCenTest ON O365MsgCenTest(MSMT_TIME);
ALTER TABLE O365MsgCenTest ADD constraint PK_O365MsgCenTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365MsgCenTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365MsgCenTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MsgCenterCommunication_MIN Number(20,4) NOT NULL,
MsgCenterCommunication_MAX Number(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365MsgCenTest_TREND ADD constraint PK_O365MsgCenTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365MsgCenTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365MsgCenTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MsgCenterCommunication_MIN VARCHAR2(256) NOT NULL,
MsgCenterCommunication_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365MsgCenTest_THRESH ADD constraint PK_O365MsgCenTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365MsgCenTest_THRESH ON O365MsgCenTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365MsgCenTest ON O365MsgCenTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365MsgCenTest ON O365MsgCenTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365DistbnGrpsTest CASCADE CONSTRAINTS;
CREATE TABLE O365DistbnGrpsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Modified_groups Number(20,4) NOT NULL,
Modified_groups_ST varchar2(32) NOT NULL,
Newly_created_groups Number(20,4) NOT NULL,
Newly_created_groups_ST varchar2(32) NOT NULL,
Soft_deleted_groups Number(20,4) NOT NULL,
Soft_deleted_groups_ST varchar2(32) NOT NULL,
Total_groups Number(20,4) NOT NULL,
Total_groups_ST varchar2(32) NOT NULL,
Orphaned_groups Number(20,4) NOT NULL,
Orphaned_groups_ST varchar2(32) NOT NULL,
Empty_groups Number(20,4) NOT NULL,
Empty_groups_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365DistbnGrpsTest ON O365DistbnGrpsTest(MSMT_TIME);
ALTER TABLE O365DistbnGrpsTest ADD constraint PK_O365DistbnGrpsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365DistbnGrpsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365DistbnGrpsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Modified_groups_MIN Number(20,4) NOT NULL,
Modified_groups_MAX Number(20,4) NOT NULL,
Modified_groups_STCNT varchar2(32) NOT NULL,
Newly_created_groups_MIN Number(20,4) NOT NULL,
Newly_created_groups_MAX Number(20,4) NOT NULL,
Newly_created_groups_STCNT varchar2(32) NOT NULL,
Soft_deleted_groups_MIN Number(20,4) NOT NULL,
Soft_deleted_groups_MAX Number(20,4) NOT NULL,
Soft_deleted_groups_STCNT varchar2(32) NOT NULL,
Total_groups_MIN Number(20,4) NOT NULL,
Total_groups_MAX Number(20,4) NOT NULL,
Total_groups_STCNT varchar2(32) NOT NULL,
Orphaned_groups_MIN Number(20,4) NOT NULL,
Orphaned_groups_MAX Number(20,4) NOT NULL,
Orphaned_groups_STCNT varchar2(32) NOT NULL,
Empty_groups_MIN Number(20,4) NOT NULL,
Empty_groups_MAX Number(20,4) NOT NULL,
Empty_groups_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365DistbnGrpsTest_TREND ADD constraint PK_O365DistbnGrpsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365DistbnGrpsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365DistbnGrpsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Modified_groups_MIN VARCHAR2(256) NOT NULL,
Modified_groups_MAX VARCHAR2(256) NOT NULL,
Newly_created_groups_MIN VARCHAR2(256) NOT NULL,
Newly_created_groups_MAX VARCHAR2(256) NOT NULL,
Soft_deleted_groups_MIN VARCHAR2(256) NOT NULL,
Soft_deleted_groups_MAX VARCHAR2(256) NOT NULL,
Total_groups_MIN VARCHAR2(256) NOT NULL,
Total_groups_MAX VARCHAR2(256) NOT NULL,
Orphaned_groups_MIN VARCHAR2(256) NOT NULL,
Orphaned_groups_MAX VARCHAR2(256) NOT NULL,
Empty_groups_MIN VARCHAR2(256) NOT NULL,
Empty_groups_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365DistbnGrpsTest_THRESH ADD constraint PK_O365DistbnGrpsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365DistbnGrpsTest_THRESH ON O365DistbnGrpsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365DistbnGrpsTest ON O365DistbnGrpsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365DistbnGrpsTest ON O365DistbnGrpsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365SrvHealTest CASCADE CONSTRAINTS;
CREATE TABLE O365SrvHealTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Service_incidents Number(20,4) NOT NULL,
Service_incidents_ST varchar2(32) NOT NULL,
Maintenance_events Number(20,4) NOT NULL,
Maintenance_events_ST varchar2(32) NOT NULL,
Service_Status Number(20,4) NOT NULL,
Service_Status_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365SrvHealTest ON O365SrvHealTest(MSMT_TIME);
ALTER TABLE O365SrvHealTest ADD constraint PK_O365SrvHealTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365SrvHealTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365SrvHealTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Service_incidents_MIN Number(20,4) NOT NULL,
Service_incidents_MAX Number(20,4) NOT NULL,
Service_incidents_STCNT varchar2(32) NOT NULL,
Maintenance_events_MIN Number(20,4) NOT NULL,
Maintenance_events_MAX Number(20,4) NOT NULL,
Maintenance_events_STCNT varchar2(32) NOT NULL,
Service_Status_MIN Number(20,4) NOT NULL,
Service_Status_MAX Number(20,4) NOT NULL,
Service_Status_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365SrvHealTest_TREND ADD constraint PK_O365SrvHealTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365SrvHealTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365SrvHealTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Service_incidents_MIN VARCHAR2(256) NOT NULL,
Service_incidents_MAX VARCHAR2(256) NOT NULL,
Maintenance_events_MIN VARCHAR2(256) NOT NULL,
Maintenance_events_MAX VARCHAR2(256) NOT NULL,
Service_Status_MIN VARCHAR2(256) NOT NULL,
Service_Status_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365SrvHealTest_THRESH ADD constraint PK_O365SrvHealTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365SrvHealTest_THRESH ON O365SrvHealTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365SrvHealTest ON O365SrvHealTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365SrvHealTest ON O365SrvHealTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365UNFIEDGRPSTEST CASCADE CONSTRAINTS;
CREATE TABLE O365UNFIEDGRPSTEST(
TRGT_HOST       VARCHAR2(32),
PORT_NO         VARCHAR2(32),
SITE_NAME       VARCHAR2(64),
INFO            VARCHAR2(128),
MSMT_HOST       VARCHAR2(32),
MSMT_TIME       DATE,
MODIFIED_GROUPS NUMBER(20,4) NOT NULL,
MODIFIED_GROUPS_ST VARCHAR2(32) NOT NULL,
NEWLY_CREATED_GROUPS NUMBER(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_ST VARCHAR2(32) NOT NULL,
SOFT_DELETED_GROUPS NUMBER(20,4) NOT NULL,
SOFT_DELETED_GROUPS_ST VARCHAR2(32) NOT NULL,
TOTAL_GROUPS NUMBER(20,4) NOT NULL,
TOTAL_GROUPS_ST VARCHAR2(32) NOT NULL,
PUBLIC_GROUPS NUMBER(20,4) NOT NULL,
PUBLIC_GROUPS_ST VARCHAR2(32) NOT NULL,
PRIVATE_GROUPS NUMBER(20,4) NOT NULL,
PRIVATE_GROUPS_ST VARCHAR2(32) NOT NULL,
ORPHANED_GROUPS NUMBER(20,4) NOT NULL,
ORPHANED_GROUPS_ST VARCHAR2(32) NOT NULL,
EMPTY_GROUPS NUMBER(20,4) NOT NULL,
EMPTY_GROUPS_ST VARCHAR2(32) NOT NULL,
GROUPS_EXTERNAL NUMBER(20,4) NOT NULL,
GROUPS_EXTERNAL_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_O365UNFIEDGRPSTEST ON O365UNFIEDGRPSTEST(MSMT_TIME);
ALTER TABLE O365UNFIEDGRPSTEST ADD CONSTRAINT PK_O365UNFIEDGRPSTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UNFIEDGRPSTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365UNFIEDGRPSTEST_TREND(
TRGT_HOST       VARCHAR2(32),
PORT_NO         VARCHAR2(32),
SITE_NAME       VARCHAR2(64),
INFO            VARCHAR2(128),
MSMT_HOST       VARCHAR2(32),
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32),
MODIFIED_GROUPS_MIN NUMBER(20,4) NOT NULL,
MODIFIED_GROUPS_MAX NUMBER(20,4) NOT NULL,
MODIFIED_GROUPS_STCNT VARCHAR2(32) NOT NULL,
NEWLY_CREATED_GROUPS_MIN NUMBER(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_MAX NUMBER(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_STCNT VARCHAR2(32) NOT NULL,
SOFT_DELETED_GROUPS_MIN NUMBER(20,4) NOT NULL,
SOFT_DELETED_GROUPS_MAX NUMBER(20,4) NOT NULL,
SOFT_DELETED_GROUPS_STCNT VARCHAR2(32) NOT NULL,
TOTAL_GROUPS_MIN NUMBER(20,4) NOT NULL,
TOTAL_GROUPS_MAX NUMBER(20,4) NOT NULL,
TOTAL_GROUPS_STCNT VARCHAR2(32) NOT NULL,
PUBLIC_GROUPS_MIN NUMBER(20,4) NOT NULL,
PUBLIC_GROUPS_MAX NUMBER(20,4) NOT NULL,
PUBLIC_GROUPS_STCNT VARCHAR2(32) NOT NULL,
PRIVATE_GROUPS_MIN NUMBER(20,4) NOT NULL,
PRIVATE_GROUPS_MAX NUMBER(20,4) NOT NULL,
PRIVATE_GROUPS_STCNT VARCHAR2(32) NOT NULL,
ORPHANED_GROUPS_MIN NUMBER(20,4) NOT NULL,
ORPHANED_GROUPS_MAX NUMBER(20,4) NOT NULL,
ORPHANED_GROUPS_STCNT VARCHAR2(32) NOT NULL,
EMPTY_GROUPS_MIN NUMBER(20,4) NOT NULL,
EMPTY_GROUPS_MAX NUMBER(20,4) NOT NULL,
EMPTY_GROUPS_STCNT VARCHAR2(32) NOT NULL,
GROUPS_EXTERNAL_MIN NUMBER(20,4) NOT NULL,
GROUPS_EXTERNAL_MAX NUMBER(20,4) NOT NULL,
GROUPS_EXTERNAL_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE O365UNFIEDGRPSTEST_TREND ADD CONSTRAINT PK_O365UNFIEDGRPSTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UNFIEDGRPSTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365UNFIEDGRPSTEST_THRESH(
TRGT_HOST       VARCHAR2(32),
PORT_NO         VARCHAR2(32),
SITE_NAME       VARCHAR2(64),
INFO            VARCHAR2(128),
MSMT_HOST       VARCHAR2(32),
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
MODIFIED_GROUPS_MIN VARCHAR2(256) NOT NULL,
MODIFIED_GROUPS_MAX VARCHAR2(256) NOT NULL,
NEWLY_CREATED_GROUPS_MIN VARCHAR2(256) NOT NULL,
NEWLY_CREATED_GROUPS_MAX VARCHAR2(256) NOT NULL,
SOFT_DELETED_GROUPS_MIN VARCHAR2(256) NOT NULL,
SOFT_DELETED_GROUPS_MAX VARCHAR2(256) NOT NULL,
TOTAL_GROUPS_MIN VARCHAR2(256) NOT NULL,
TOTAL_GROUPS_MAX VARCHAR2(256) NOT NULL,
PUBLIC_GROUPS_MIN VARCHAR2(256) NOT NULL,
PUBLIC_GROUPS_MAX VARCHAR2(256) NOT NULL,
PRIVATE_GROUPS_MIN VARCHAR2(256) NOT NULL,
PRIVATE_GROUPS_MAX VARCHAR2(256) NOT NULL,
ORPHANED_GROUPS_MIN VARCHAR2(256) NOT NULL,
ORPHANED_GROUPS_MAX VARCHAR2(256) NOT NULL,
EMPTY_GROUPS_MIN VARCHAR2(256) NOT NULL,
EMPTY_GROUPS_MAX VARCHAR2(256) NOT NULL,
GROUPS_EXTERNAL_MIN VARCHAR2(256) NOT NULL,
GROUPS_EXTERNAL_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365UNFIEDGRPSTEST_THRESH ADD CONSTRAINT PK_O365UNFIEDGRPSTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UNFIEDGRPSTEST_THRESH ON O365UNFIEDGRPSTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UNFIEDGRPSTEST ON O365UNFIEDGRPSTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UNFIEDGRPSTEST ON O365UNFIEDGRPSTEST_TREND (MSMT_TIME,PERIOD);


DROP TABLE O365SrvPrvStats CASCADE CONSTRAINTS;
CREATE TABLE O365SrvPrvStats(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Pnding_Actvtion Number(20,4) NOT NULL,
Pnding_Actvtion_ST varchar2(32) NOT NULL,
Pnding_Prvision Number(20,4) NOT NULL,
Pnding_Prvision_ST varchar2(32) NOT NULL,
Pnding_input Number(20,4) NOT NULL,
Pnding_input_ST varchar2(32) NOT NULL,
Success Number(20,4) NOT NULL,
Success_ST varchar2(32) NOT NULL,
Disabled Number(20,4) NOT NULL,
Disabled_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365SrvPrvStats ON O365SrvPrvStats(MSMT_TIME);
ALTER TABLE O365SrvPrvStats ADD constraint PK_O365SrvPrvStats PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365SrvPrvStats_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365SrvPrvStats_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Pnding_Actvtion_MIN Number(20,4) NOT NULL,
Pnding_Actvtion_MAX Number(20,4) NOT NULL,
Pnding_Actvtion_STCNT varchar2(32) NOT NULL,
Pnding_Prvision_MIN Number(20,4) NOT NULL,
Pnding_Prvision_MAX Number(20,4) NOT NULL,
Pnding_Prvision_STCNT varchar2(32) NOT NULL,
Pnding_input_MIN Number(20,4) NOT NULL,
Pnding_input_MAX Number(20,4) NOT NULL,
Pnding_input_STCNT varchar2(32) NOT NULL,
Success_MIN Number(20,4) NOT NULL,
Success_MAX Number(20,4) NOT NULL,
Success_STCNT varchar2(32) NOT NULL,
Disabled_MIN Number(20,4) NOT NULL,
Disabled_MAX Number(20,4) NOT NULL,
Disabled_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365SrvPrvStats_TREND ADD constraint PK_O365SrvPrvStats_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365SrvPrvStats_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365SrvPrvStats_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Pnding_Actvtion_MIN VARCHAR2(256) NOT NULL,
Pnding_Actvtion_MAX VARCHAR2(256) NOT NULL,
Pnding_Prvision_MIN VARCHAR2(256) NOT NULL,
Pnding_Prvision_MAX VARCHAR2(256) NOT NULL,
Pnding_input_MIN VARCHAR2(256) NOT NULL,
Pnding_input_MAX VARCHAR2(256) NOT NULL,
Success_MIN VARCHAR2(256) NOT NULL,
Success_MAX VARCHAR2(256) NOT NULL,
Disabled_MIN VARCHAR2(256) NOT NULL,
Disabled_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365SrvPrvStats_THRESH ADD constraint PK_O365SrvPrvStats_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365SrvPrvStats_THRESH ON O365SrvPrvStats_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365SrvPrvStats ON O365SrvPrvStats_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365SrvPrvStats ON O365SrvPrvStats_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365SpfAdtLgTest CASCADE CONSTRAINTS;
CREATE TABLE O365SpfAdtLgTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Operation_Cnt Number(20,4) NOT NULL,
Operation_Cnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365SpfAdtLgTest ON O365SpfAdtLgTest(MSMT_TIME);
ALTER TABLE O365SpfAdtLgTest ADD constraint PK_O365SpfAdtLgTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365SpfAdtLgTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365SpfAdtLgTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Operation_Cnt_MIN Number(20,4) NOT NULL,
Operation_Cnt_MAX Number(20,4) NOT NULL,
Operation_Cnt_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365SpfAdtLgTest_TREND ADD constraint PK_O365SpfAdtLgTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365SpfAdtLgTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365SpfAdtLgTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Operation_Cnt_MIN VARCHAR2(256) NOT NULL,
Operation_Cnt_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365SpfAdtLgTest_THRESH ADD constraint PK_O365SpfAdtLgTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365SpfAdtLgTest_THRESH ON O365SpfAdtLgTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365SpfAdtLgTest ON O365SpfAdtLgTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365SpfAdtLgTest ON O365SpfAdtLgTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365LoginTest CASCADE CONSTRAINTS;
CREATE TABLE O365LoginTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Authentication_status Number(20,4) NOT NULL,
Authentication_status_ST varchar2(32) NOT NULL,
Authentication_time Number(20,4) NOT NULL,
Authentication_time_ST varchar2(32) NOT NULL,
Login_status Number(20,4) NOT NULL,
Login_status_ST varchar2(32) NOT NULL,
Login_time Number(20,4) NOT NULL,
Login_time_ST varchar2(32) NOT NULL,
Total_login_time Number(20,4) NOT NULL,
Total_login_time_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365LoginTest ON O365LoginTest(MSMT_TIME);
ALTER TABLE O365LoginTest ADD constraint PK_O365LoginTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365LoginTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365LoginTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Authentication_status_MIN Number(20,4) NOT NULL,
Authentication_status_MAX Number(20,4) NOT NULL,
Authentication_status_STCNT varchar2(32) NOT NULL,
Authentication_time_MIN Number(20,4) NOT NULL,
Authentication_time_MAX Number(20,4) NOT NULL,
Authentication_time_STCNT varchar2(32) NOT NULL,
Login_status_MIN Number(20,4) NOT NULL,
Login_status_MAX Number(20,4) NOT NULL,
Login_status_STCNT varchar2(32) NOT NULL,
Login_time_MIN Number(20,4) NOT NULL,
Login_time_MAX Number(20,4) NOT NULL,
Login_time_STCNT varchar2(32) NOT NULL,
Total_login_time_MIN Number(20,4) NOT NULL,
Total_login_time_MAX Number(20,4) NOT NULL,
Total_login_time_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365LoginTest_TREND ADD constraint PK_O365LoginTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365LoginTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365LoginTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Authentication_status_MIN VARCHAR2(256) NOT NULL,
Authentication_status_MAX VARCHAR2(256) NOT NULL,
Authentication_time_MIN VARCHAR2(256) NOT NULL,
Authentication_time_MAX VARCHAR2(256) NOT NULL,
Login_status_MIN VARCHAR2(256) NOT NULL,
Login_status_MAX VARCHAR2(256) NOT NULL,
Login_time_MIN VARCHAR2(256) NOT NULL,
Login_time_MAX VARCHAR2(256) NOT NULL,
Total_login_time_MIN VARCHAR2(256) NOT NULL,
Total_login_time_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365LoginTest_THRESH ADD constraint PK_O365LoginTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365LoginTest_THRESH ON O365LoginTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365LoginTest ON O365LoginTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365LoginTest ON O365LoginTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOServiceTest CASCADE CONSTRAINTS;
CREATE TABLE SPOServiceTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Service_incidents Number(20,4) NOT NULL,
Service_incidents_ST varchar2(32) NOT NULL,
Maintenance_events Number(20,4) NOT NULL,
Maintenance_events_ST varchar2(32) NOT NULL,
SERVICE_STATUS Number(20,4) NOT NULL,
SERVICE_STATUS_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_SPOServiceTest ON SPOServiceTest(MSMT_TIME);
ALTER TABLE SPOServiceTest ADD constraint PK_SPOServiceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOServiceTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOServiceTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Service_incidents_MIN Number(20,4) NOT NULL,
Service_incidents_MAX Number(20,4) NOT NULL,
Service_incidents_STCNT varchar2(32) NOT NULL,
Maintenance_events_MIN Number(20,4) NOT NULL,
Maintenance_events_MAX Number(20,4) NOT NULL,
Maintenance_events_STCNT varchar2(32) NOT NULL,
SERVICE_STATUS_MIN Number(20,4) NOT NULL,
SERVICE_STATUS_MAX Number(20,4) NOT NULL,
SERVICE_STATUS_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOServiceTest_TREND ADD constraint PK_SPOServiceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOServiceTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOServiceTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Service_incidents_MIN VARCHAR2(256) NOT NULL,
Service_incidents_MAX VARCHAR2(256) NOT NULL,
Maintenance_events_MIN VARCHAR2(256) NOT NULL,
Maintenance_events_MAX VARCHAR2(256) NOT NULL,
SERVICE_STATUS_MIN VARCHAR2(256) NOT NULL,
SERVICE_STATUS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOServiceTest_THRESH ADD constraint PK_SPOServiceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOServiceTest_THRESH ON SPOServiceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOServiceTest ON SPOServiceTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOServiceTest ON SPOServiceTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOFileFieldsTest CASCADE CONSTRAINTS;
CREATE TABLE SPOFileFieldsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
File_upload_status Number(20,4) NOT NULL,
File_upload_status_ST varchar2(32) NOT NULL,
File_upload_time Number(20,4) NOT NULL,
File_upload_time_ST varchar2(32) NOT NULL,
File_download_status Number(20,4) NOT NULL,
File_download_status_ST varchar2(32) NOT NULL,
File_download_time Number(20,4) NOT NULL,
File_download_time_ST varchar2(32) NOT NULL,
File_checkout_status Number(20,4) NOT NULL,
File_checkout_status_ST varchar2(32) NOT NULL,
File_checkout_time Number(20,4) NOT NULL,
File_checkout_time_ST varchar2(32) NOT NULL,
File_checkin_status Number(20,4) NOT NULL,
File_checkin_status_ST varchar2(32) NOT NULL,
File_checkin_time Number(20,4) NOT NULL,
File_checkin_time_ST varchar2(32) NOT NULL,
File_deletion_status Number(20,4) NOT NULL,
File_deletion_status_ST varchar2(32) NOT NULL,
File_deletion_time Number(20,4) NOT NULL,
File_deletion_time_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOFileFieldsTest ON SPOFileFieldsTest(MSMT_TIME);
ALTER TABLE SPOFileFieldsTest ADD constraint PK_SPOFileFieldsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOFileFieldsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOFileFieldsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
File_upload_status_MIN Number(20,4) NOT NULL,
File_upload_status_MAX Number(20,4) NOT NULL,
File_upload_status_STCNT varchar2(32) NOT NULL,
File_upload_time_MIN Number(20,4) NOT NULL,
File_upload_time_MAX Number(20,4) NOT NULL,
File_upload_time_STCNT varchar2(32) NOT NULL,
File_download_status_MIN Number(20,4) NOT NULL,
File_download_status_MAX Number(20,4) NOT NULL,
File_download_status_STCNT varchar2(32) NOT NULL,
File_download_time_MIN Number(20,4) NOT NULL,
File_download_time_MAX Number(20,4) NOT NULL,
File_download_time_STCNT varchar2(32) NOT NULL,
File_checkout_status_MIN Number(20,4) NOT NULL,
File_checkout_status_MAX Number(20,4) NOT NULL,
File_checkout_status_STCNT varchar2(32) NOT NULL,
File_checkout_time_MIN Number(20,4) NOT NULL,
File_checkout_time_MAX Number(20,4) NOT NULL,
File_checkout_time_STCNT varchar2(32) NOT NULL,
File_checkin_status_MIN Number(20,4) NOT NULL,
File_checkin_status_MAX Number(20,4) NOT NULL,
File_checkin_status_STCNT varchar2(32) NOT NULL,
File_checkin_time_MIN Number(20,4) NOT NULL,
File_checkin_time_MAX Number(20,4) NOT NULL,
File_checkin_time_STCNT varchar2(32) NOT NULL,
File_deletion_status_MIN Number(20,4) NOT NULL,
File_deletion_status_MAX Number(20,4) NOT NULL,
File_deletion_status_STCNT varchar2(32) NOT NULL,
File_deletion_time_MIN Number(20,4) NOT NULL,
File_deletion_time_MAX Number(20,4) NOT NULL,
File_deletion_time_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOFileFieldsTest_TREND ADD constraint PK_SPOFileFieldsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOFileFieldsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOFileFieldsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
File_upload_status_MIN VARCHAR2(256) NOT NULL,
File_upload_status_MAX VARCHAR2(256) NOT NULL,
File_upload_time_MIN VARCHAR2(256) NOT NULL,
File_upload_time_MAX VARCHAR2(256) NOT NULL,
File_download_status_MIN VARCHAR2(256) NOT NULL,
File_download_status_MAX VARCHAR2(256) NOT NULL,
File_download_time_MIN VARCHAR2(256) NOT NULL,
File_download_time_MAX VARCHAR2(256) NOT NULL,
File_checkout_status_MIN VARCHAR2(256) NOT NULL,
File_checkout_status_MAX VARCHAR2(256) NOT NULL,
File_checkout_time_MIN VARCHAR2(256) NOT NULL,
File_checkout_time_MAX VARCHAR2(256) NOT NULL,
File_checkin_status_MIN VARCHAR2(256) NOT NULL,
File_checkin_status_MAX VARCHAR2(256) NOT NULL,
File_checkin_time_MIN VARCHAR2(256) NOT NULL,
File_checkin_time_MAX VARCHAR2(256) NOT NULL,
File_deletion_status_MIN VARCHAR2(256) NOT NULL,
File_deletion_status_MAX VARCHAR2(256) NOT NULL,
File_deletion_time_MIN VARCHAR2(256) NOT NULL,
File_deletion_time_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOFileFieldsTest_THRESH ADD constraint PK_SPOFileFieldsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOFileFieldsTest_THRESH ON SPOFileFieldsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOFileFieldsTest ON SPOFileFieldsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOFileFieldsTest ON SPOFileFieldsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOTenantTest CASCADE CONSTRAINTS;
CREATE TABLE SPOTenantTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
OneDrive_storage_quota Number(20,4) NOT NULL,
OneDrive_storage_quota_ST varchar2(32) NOT NULL,
Resource_quota Number(20,4) NOT NULL,
Resource_quota_ST varchar2(32) NOT NULL,
Resource_quota_allocated Number(20,4) NOT NULL,
Resource_quota_allocated_ST varchar2(32) NOT NULL,
Storage_quota Number(20,4) NOT NULL,
Storage_quota_ST varchar2(32) NOT NULL,
Storage_quota_allocated Number(20,4) NOT NULL,
Storage_quota_allocated_ST varchar2(32) NOT NULL,
Deleted_sites Number(20,4) NOT NULL,
Deleted_sites_ST varchar2(32) NOT NULL,
Applications Number(20,4) NOT NULL,
Applications_ST varchar2(32) NOT NULL,
Web_templates Number(20,4) NOT NULL,
Web_templates_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOTenantTest ON SPOTenantTest(MSMT_TIME);
ALTER TABLE SPOTenantTest ADD constraint PK_SPOTenantTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOTenantTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOTenantTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
OneDrive_storage_quota_MIN Number(20,4) NOT NULL,
OneDrive_storage_quota_MAX Number(20,4) NOT NULL,
OneDrive_storage_quota_STCNT varchar2(32) NOT NULL,
Resource_quota_MIN Number(20,4) NOT NULL,
Resource_quota_MAX Number(20,4) NOT NULL,
Resource_quota_STCNT varchar2(32) NOT NULL,
Resource_quota_allocated_MIN Number(20,4) NOT NULL,
Resource_quota_allocated_MAX Number(20,4) NOT NULL,
Resource_quota_allocated_STCNT varchar2(32) NOT NULL,
Storage_quota_MIN Number(20,4) NOT NULL,
Storage_quota_MAX Number(20,4) NOT NULL,
Storage_quota_STCNT varchar2(32) NOT NULL,
Storage_quota_allocated_MIN Number(20,4) NOT NULL,
Storage_quota_allocated_MAX Number(20,4) NOT NULL,
Storage_quota_allocated_STCNT varchar2(32) NOT NULL,
Deleted_sites_MIN Number(20,4) NOT NULL,
Deleted_sites_MAX Number(20,4) NOT NULL,
Deleted_sites_STCNT varchar2(32) NOT NULL,
Applications_MIN Number(20,4) NOT NULL,
Applications_MAX Number(20,4) NOT NULL,
Applications_STCNT varchar2(32) NOT NULL,
Web_templates_MIN Number(20,4) NOT NULL,
Web_templates_MAX Number(20,4) NOT NULL,
Web_templates_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOTenantTest_TREND ADD constraint PK_SPOTenantTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOTenantTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOTenantTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
OneDrive_storage_quota_MIN VARCHAR2(256) NOT NULL,
OneDrive_storage_quota_MAX VARCHAR2(256) NOT NULL,
Resource_quota_MIN VARCHAR2(256) NOT NULL,
Resource_quota_MAX VARCHAR2(256) NOT NULL,
Resource_quota_allocated_MIN VARCHAR2(256) NOT NULL,
Resource_quota_allocated_MAX VARCHAR2(256) NOT NULL,
Storage_quota_MIN VARCHAR2(256) NOT NULL,
Storage_quota_MAX VARCHAR2(256) NOT NULL,
Storage_quota_allocated_MIN VARCHAR2(256) NOT NULL,
Storage_quota_allocated_MAX VARCHAR2(256) NOT NULL,
Deleted_sites_MIN VARCHAR2(256) NOT NULL,
Deleted_sites_MAX VARCHAR2(256) NOT NULL,
Applications_MIN VARCHAR2(256) NOT NULL,
Applications_MAX VARCHAR2(256) NOT NULL,
Web_templates_MIN VARCHAR2(256) NOT NULL,
Web_templates_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOTenantTest_THRESH ADD constraint PK_SPOTenantTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOTenantTest_THRESH ON SPOTenantTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOTenantTest ON SPOTenantTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOTenantTest ON SPOTenantTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOHealthStatusTest CASCADE CONSTRAINTS;
CREATE TABLE SPOHealthStatusTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SP_health_score Number(20,4) NOT NULL,
SP_health_score_ST varchar2(32) NOT NULL,
SP_request_duration Number(20,4) NOT NULL,
SP_request_duration_ST varchar2(32) NOT NULL,
SP_iis_latency Number(20,4) NOT NULL,
SP_iis_latency_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOHealthStatusTest ON SPOHealthStatusTest(MSMT_TIME);
ALTER TABLE SPOHealthStatusTest ADD constraint PK_SPOHealthStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOHealthStatusTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOHealthStatusTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SP_health_score_MIN Number(20,4) NOT NULL,
SP_health_score_MAX Number(20,4) NOT NULL,
SP_health_score_STCNT varchar2(32) NOT NULL,
SP_request_duration_MIN Number(20,4) NOT NULL,
SP_request_duration_MAX Number(20,4) NOT NULL,
SP_request_duration_STCNT varchar2(32) NOT NULL,
SP_iis_latency_MIN Number(20,4) NOT NULL,
SP_iis_latency_MAX Number(20,4) NOT NULL,
SP_iis_latency_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOHealthStatusTest_TREND ADD constraint PK_SPOHealthStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOHealthStatusTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOHealthStatusTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SP_health_score_MIN VARCHAR2(256) NOT NULL,
SP_health_score_MAX VARCHAR2(256) NOT NULL,
SP_request_duration_MIN VARCHAR2(256) NOT NULL,
SP_request_duration_MAX VARCHAR2(256) NOT NULL,
SP_iis_latency_MIN VARCHAR2(256) NOT NULL,
SP_iis_latency_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOHealthStatusTest_THRESH ADD constraint PK_SPOHealthStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOHealthStatusTest_THRESH ON SPOHealthStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOHealthStatusTest ON SPOHealthStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOHealthStatusTest ON SPOHealthStatusTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOMsgCommTest CASCADE CONSTRAINTS;
CREATE TABLE SPOMsgCommTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MsgCenterCommunication Number(20,4) NOT NULL,
MsgCenterCommunication_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOMsgCommTest ON SPOMsgCommTest(MSMT_TIME);
ALTER TABLE SPOMsgCommTest ADD constraint PK_SPOMsgCommTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOMsgCommTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOMsgCommTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MsgCenterCommunication_MIN Number(20,4) NOT NULL,
MsgCenterCommunication_MAX Number(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOMsgCommTest_TREND ADD constraint PK_SPOMsgCommTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOMsgCommTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOMsgCommTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MsgCenterCommunication_MIN VARCHAR2(256) NOT NULL,
MsgCenterCommunication_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOMsgCommTest_THRESH ADD constraint PK_SPOMsgCommTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOMsgCommTest_THRESH ON SPOMsgCommTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOMsgCommTest ON SPOMsgCommTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOMsgCommTest ON SPOMsgCommTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOSiteTest CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Status Number(20,4) NOT NULL,
Status_ST varchar2(32) NOT NULL,
Webs_count Number(20,4) NOT NULL,
Webs_count_ST varchar2(32) NOT NULL,
Storage_quota Number(20,4) NOT NULL,
Storage_quota_ST varchar2(32) NOT NULL,
Current_storage_usage Number(20,4) NOT NULL,
Current_storage_usage_ST varchar2(32) NOT NULL,
storage_usage_percent Number(20,4) NOT NULL,
storage_usage_percent_ST varchar2(32) NOT NULL,
Current_resource_usage Number(20,4) NOT NULL,
Current_resource_usage_ST varchar2(32) NOT NULL,
Average_resource_usage Number(20,4) NOT NULL,
Average_resource_usage_ST varchar2(32) NOT NULL,
Resource_quota Number(20,4) NOT NULL,
Resource_quota_ST varchar2(32) NOT NULL,
RsQuotaWarningLevel Number(20,4) NOT NULL,
RsQuotaWarningLevel_ST varchar2(32) NOT NULL,
Locked Number(20,4) NOT NULL,
Locked_ST varchar2(32) NOT NULL,
LastContentModifiedDate Number(20,4) NOT NULL,
LastContentModifiedDate_ST varchar2(32) NOT NULL,
External_users Number(20,4) NOT NULL,
External_users_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOSiteTest ON SPOSiteTest(MSMT_TIME);
ALTER TABLE SPOSiteTest ADD constraint PK_SPOSiteTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSiteTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Status_MIN Number(20,4) NOT NULL,
Status_MAX Number(20,4) NOT NULL,
Status_STCNT varchar2(32) NOT NULL,
Webs_count_MIN Number(20,4) NOT NULL,
Webs_count_MAX Number(20,4) NOT NULL,
Webs_count_STCNT varchar2(32) NOT NULL,
Storage_quota_MIN Number(20,4) NOT NULL,
Storage_quota_MAX Number(20,4) NOT NULL,
Storage_quota_STCNT varchar2(32) NOT NULL,
Current_storage_usage_MIN Number(20,4) NOT NULL,
Current_storage_usage_MAX Number(20,4) NOT NULL,
Current_storage_usage_STCNT varchar2(32) NOT NULL,
storage_usage_percent_MIN Number(20,4) NOT NULL,
storage_usage_percent_MAX Number(20,4) NOT NULL,
storage_usage_percent_STCNT varchar2(32) NOT NULL,
Current_resource_usage_MIN Number(20,4) NOT NULL,
Current_resource_usage_MAX Number(20,4) NOT NULL,
Current_resource_usage_STCNT varchar2(32) NOT NULL,
Average_resource_usage_MIN Number(20,4) NOT NULL,
Average_resource_usage_MAX Number(20,4) NOT NULL,
Average_resource_usage_STCNT varchar2(32) NOT NULL,
Resource_quota_MIN Number(20,4) NOT NULL,
Resource_quota_MAX Number(20,4) NOT NULL,
Resource_quota_STCNT varchar2(32) NOT NULL,
RsQuotaWarningLevel_MIN Number(20,4) NOT NULL,
RsQuotaWarningLevel_MAX Number(20,4) NOT NULL,
RsQuotaWarningLevel_STCNT varchar2(32) NOT NULL,
Locked_MIN Number(20,4) NOT NULL,
Locked_MAX Number(20,4) NOT NULL,
Locked_STCNT varchar2(32) NOT NULL,
LastContentModifiedDate_MIN Number(20,4) NOT NULL,
LastContentModifiedDate_MAX Number(20,4) NOT NULL,
LastContentModifiedDate_STCNT varchar2(32) NOT NULL,
External_users_MIN Number(20,4) NOT NULL,
External_users_MAX Number(20,4) NOT NULL,
External_users_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOSiteTest_TREND ADD constraint PK_SPOSiteTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSiteTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Status_MIN VARCHAR2(256) NOT NULL,
Status_MAX VARCHAR2(256) NOT NULL,
Webs_count_MIN VARCHAR2(256) NOT NULL,
Webs_count_MAX VARCHAR2(256) NOT NULL,
Storage_quota_MIN VARCHAR2(256) NOT NULL,
Storage_quota_MAX VARCHAR2(256) NOT NULL,
Current_storage_usage_MIN VARCHAR2(256) NOT NULL,
Current_storage_usage_MAX VARCHAR2(256) NOT NULL,
storage_usage_percent_MIN VARCHAR2(256) NOT NULL,
storage_usage_percent_MAX VARCHAR2(256) NOT NULL,
Current_resource_usage_MIN VARCHAR2(256) NOT NULL,
Current_resource_usage_MAX VARCHAR2(256) NOT NULL,
Average_resource_usage_MIN VARCHAR2(256) NOT NULL,
Average_resource_usage_MAX VARCHAR2(256) NOT NULL,
Resource_quota_MIN VARCHAR2(256) NOT NULL,
Resource_quota_MAX VARCHAR2(256) NOT NULL,
RsQuotaWarningLevel_MIN VARCHAR2(256) NOT NULL,
RsQuotaWarningLevel_MAX VARCHAR2(256) NOT NULL,
Locked_MIN VARCHAR2(256) NOT NULL,
Locked_MAX VARCHAR2(256) NOT NULL,
LastContentModifiedDate_MIN VARCHAR2(256) NOT NULL,
LastContentModifiedDate_MAX VARCHAR2(256) NOT NULL,
External_users_MIN VARCHAR2(256) NOT NULL,
External_users_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOSiteTest_THRESH ADD constraint PK_SPOSiteTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSiteTest_THRESH ON SPOSiteTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSiteTest ON SPOSiteTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSiteTest ON SPOSiteTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOLoginTest CASCADE CONSTRAINTS;
CREATE TABLE SPOLoginTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Authentication_status Number(20,4) NOT NULL,
Authentication_status_ST varchar2(32) NOT NULL,
Authentication_time Number(20,4) NOT NULL,
Authentication_time_ST varchar2(32) NOT NULL,
Login_status Number(20,4) NOT NULL,
Login_status_ST varchar2(32) NOT NULL,
Login_time Number(20,4) NOT NULL,
Login_time_ST varchar2(32) NOT NULL,
Total_login_time Number(20,4) NOT NULL,
Total_login_time_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOLoginTest ON SPOLoginTest(MSMT_TIME);
ALTER TABLE SPOLoginTest ADD constraint PK_SPOLoginTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOLoginTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOLoginTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Authentication_status_MIN Number(20,4) NOT NULL,
Authentication_status_MAX Number(20,4) NOT NULL,
Authentication_status_STCNT varchar2(32) NOT NULL,
Authentication_time_MIN Number(20,4) NOT NULL,
Authentication_time_MAX Number(20,4) NOT NULL,
Authentication_time_STCNT varchar2(32) NOT NULL,
Login_status_MIN Number(20,4) NOT NULL,
Login_status_MAX Number(20,4) NOT NULL,
Login_status_STCNT varchar2(32) NOT NULL,
Login_time_MIN Number(20,4) NOT NULL,
Login_time_MAX Number(20,4) NOT NULL,
Login_time_STCNT varchar2(32) NOT NULL,
Total_login_time_MIN Number(20,4) NOT NULL,
Total_login_time_MAX Number(20,4) NOT NULL,
Total_login_time_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOLoginTest_TREND ADD constraint PK_SPOLoginTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOLoginTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOLoginTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Authentication_status_MIN VARCHAR2(256) NOT NULL,
Authentication_status_MAX VARCHAR2(256) NOT NULL,
Authentication_time_MIN VARCHAR2(256) NOT NULL,
Authentication_time_MAX VARCHAR2(256) NOT NULL,
Login_status_MIN VARCHAR2(256) NOT NULL,
Login_status_MAX VARCHAR2(256) NOT NULL,
Login_time_MIN VARCHAR2(256) NOT NULL,
Login_time_MAX VARCHAR2(256) NOT NULL,
Total_login_time_MIN VARCHAR2(256) NOT NULL,
Total_login_time_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOLoginTest_THRESH ADD constraint PK_SPOLoginTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOLoginTest_THRESH ON SPOLoginTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOLoginTest ON SPOLoginTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOLoginTest ON SPOLoginTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOSiteHealthCheckTest CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteHealthCheckTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Passed Number(20,4) NOT NULL,
Passed_ST varchar2(32) NOT NULL,
Failed_warnings Number(20,4) NOT NULL,
Failed_warnings_ST varchar2(32) NOT NULL,
Failed_errors Number(20,4) NOT NULL,
Failed_errors_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOSiteHealthCheckTest ON SPOSiteHealthCheckTest(MSMT_TIME);
ALTER TABLE SPOSiteHealthCheckTest ADD constraint PK_SPOSiteHealthCheckTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSiteHealthCheckTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteHealthCheckTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Passed_MIN Number(20,4) NOT NULL,
Passed_MAX Number(20,4) NOT NULL,
Passed_STCNT varchar2(32) NOT NULL,
Failed_warnings_MIN Number(20,4) NOT NULL,
Failed_warnings_MAX Number(20,4) NOT NULL,
Failed_warnings_STCNT varchar2(32) NOT NULL,
Failed_errors_MIN Number(20,4) NOT NULL,
Failed_errors_MAX Number(20,4) NOT NULL,
Failed_errors_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOSiteHealthCheckTest_TREND ADD constraint PK_SPOSitHlthChckTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSiteHealthCheckTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteHealthCheckTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Passed_MIN VARCHAR2(256) NOT NULL,
Passed_MAX VARCHAR2(256) NOT NULL,
Failed_warnings_MIN VARCHAR2(256) NOT NULL,
Failed_warnings_MAX VARCHAR2(256) NOT NULL,
Failed_errors_MIN VARCHAR2(256) NOT NULL,
Failed_errors_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOSiteHealthCheckTest_THRESH ADD constraint PK_SPOSitHlthChckTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSitHlthChkTest_THRESH ON SPOSiteHealthCheckTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSiteHealthCheckTest ON SPOSiteHealthCheckTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSiteHealthCheckTest ON SPOSiteHealthCheckTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE SPOSyncActTest CASCADE CONSTRAINTS;
CREATE TABLE SPOSyncActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
File_sync_permits Number(20,4) NOT NULL,
File_sync_permits_ST varchar2(32) NOT NULL,
File_sync_blocks Number(20,4) NOT NULL,
File_sync_blocks_ST varchar2(32) NOT NULL,
File_downloads Number(20,4) NOT NULL,
File_downloads_ST varchar2(32) NOT NULL,
File_changes_downloads Number(20,4) NOT NULL,
File_changes_downloads_ST varchar2(32) NOT NULL,
File_uploads Number(20,4) NOT NULL,
File_uploads_ST varchar2(32) NOT NULL,
File_changes_uploads Number(20,4) NOT NULL,
File_changes_uploads_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOSyncActTest ON SPOSyncActTest(MSMT_TIME);
ALTER TABLE SPOSyncActTest ADD constraint PK_SPOSyncActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSyncActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOSyncActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
File_sync_permits_MIN Number(20,4) NOT NULL,
File_sync_permits_MAX Number(20,4) NOT NULL,
File_sync_permits_STCNT varchar2(32) NOT NULL,
File_sync_blocks_MIN Number(20,4) NOT NULL,
File_sync_blocks_MAX Number(20,4) NOT NULL,
File_sync_blocks_STCNT varchar2(32) NOT NULL,
File_downloads_MIN Number(20,4) NOT NULL,
File_downloads_MAX Number(20,4) NOT NULL,
File_downloads_STCNT varchar2(32) NOT NULL,
File_changes_downloads_MIN Number(20,4) NOT NULL,
File_changes_downloads_MAX Number(20,4) NOT NULL,
File_changes_downloads_STCNT varchar2(32) NOT NULL,
File_uploads_MIN Number(20,4) NOT NULL,
File_uploads_MAX Number(20,4) NOT NULL,
File_uploads_STCNT varchar2(32) NOT NULL,
File_changes_uploads_MIN Number(20,4) NOT NULL,
File_changes_uploads_MAX Number(20,4) NOT NULL,
File_changes_uploads_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOSyncActTest_TREND ADD constraint PK_SPOSyncActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSyncActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOSyncActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
File_sync_permits_MIN VARCHAR2(256) NOT NULL,
File_sync_permits_MAX VARCHAR2(256) NOT NULL,
File_sync_blocks_MIN VARCHAR2(256) NOT NULL,
File_sync_blocks_MAX VARCHAR2(256) NOT NULL,
File_downloads_MIN VARCHAR2(256) NOT NULL,
File_downloads_MAX VARCHAR2(256) NOT NULL,
File_changes_downloads_MIN VARCHAR2(256) NOT NULL,
File_changes_downloads_MAX VARCHAR2(256) NOT NULL,
File_uploads_MIN VARCHAR2(256) NOT NULL,
File_uploads_MAX VARCHAR2(256) NOT NULL,
File_changes_uploads_MIN VARCHAR2(256) NOT NULL,
File_changes_uploads_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOSyncActTest_THRESH ADD constraint PK_SPOSyncActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSyncActTest_THRESH ON SPOSyncActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSyncActTest ON SPOSyncActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSyncActTest ON SPOSyncActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOSAdminActTest CASCADE CONSTRAINTS;
CREATE TABLE SPOSAdminActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
Usr_agent_exmpt_addition Number(20,4) NOT NULL,
Usr_agent_exmpt_addition_ST varchar2(32) NOT NULL,
Usr_agent_exmpt_modifitn Number(20,4) NOT NULL,
Usr_agent_exmpt_modifitn_ST varchar2(32) NOT NULL,
Sit_collectn_admin_addtn Number(20,4) NOT NULL,
Sit_collectn_admin_addtn_ST varchar2(32) NOT NULL,
User_group_additions Number(20,4) NOT NULL,
User_group_additions_ST varchar2(32) NOT NULL,
Add_usergroup_permits Number(20,4) NOT NULL,
Add_usergroup_permits_ST varchar2(32) NOT NULL,
Sharing_policy_modifctn Number(20,4) NOT NULL,
Sharing_policy_modifctn_ST varchar2(32) NOT NULL,
Group_additions Number(20,4) NOT NULL,
Group_additions_ST varchar2(32) NOT NULL,
Send_to_conn_creation Number(20,4) NOT NULL,
Send_to_conn_creation_ST varchar2(32) NOT NULL,
Site_collection_creation Number(20,4) NOT NULL,
Site_collection_creation_ST varchar2(32) NOT NULL,
Group_deletes Number(20,4) NOT NULL,
Group_deletes_ST varchar2(32) NOT NULL,
Send_to_conn_deletes Number(20,4) NOT NULL,
Send_to_conn_deletes_ST varchar2(32) NOT NULL,
Site_deletes Number(20,4) NOT NULL,
Site_deletes_ST varchar2(32) NOT NULL,
Document_preview_permits Number(20,4) NOT NULL,
Document_preview_permits_ST varchar2(32) NOT NULL,
Workflow_task_contnt Number(20,4) NOT NULL,
Workflow_task_contnt_ST varchar2(32) NOT NULL,
Office_ondemand_permits Number(20,4) NOT NULL,
Office_ondemand_permits_ST varchar2(32) NOT NULL,
News_feed_permits Number(20,4) NOT NULL,
News_feed_permits_ST varchar2(32) NOT NULL,
Site_permissn_modifictn Number(20,4) NOT NULL,
Site_permissn_modifictn_ST varchar2(32) NOT NULL,
Removals_from_group Number(20,4) NOT NULL,
Removals_from_group_ST varchar2(32) NOT NULL,
Site_renames Number(20,4) NOT NULL,
Site_renames_ST varchar2(32) NOT NULL,
Site_admin_requests Number(20,4) NOT NULL,
Site_admin_requests_ST varchar2(32) NOT NULL,
Host_site_changes Number(20,4) NOT NULL,
Host_site_changes_ST varchar2(32) NOT NULL,
Group_settings_changes Number(20,4) NOT NULL,
Group_settings_changes_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOSAdminActTest ON SPOSAdminActTest(MSMT_TIME);
ALTER TABLE SPOSAdminActTest ADD constraint PK_SPOSAdminActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSAdminActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOSAdminActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
Usr_agent_exmpt_addition_MIN Number(20,4) NOT NULL,
Usr_agent_exmpt_addition_MAX Number(20,4) NOT NULL,
Usr_agent_exmpt_addition_STCNT varchar2(32) NOT NULL,
Usr_agent_exmpt_modifitn_MIN Number(20,4) NOT NULL,
Usr_agent_exmpt_modifitn_MAX Number(20,4) NOT NULL,
Usr_agent_exmpt_modifitn_STCNT varchar2(32) NOT NULL,
Sit_collectn_admin_addtn_MIN Number(20,4) NOT NULL,
Sit_collectn_admin_addtn_MAX Number(20,4) NOT NULL,
Sit_collectn_admin_addtn_STCNT varchar2(32) NOT NULL,
User_group_additions_MIN Number(20,4) NOT NULL,
User_group_additions_MAX Number(20,4) NOT NULL,
User_group_additions_STCNT varchar2(32) NOT NULL,
Add_usergroup_permits_MIN Number(20,4) NOT NULL,
Add_usergroup_permits_MAX Number(20,4) NOT NULL,
Add_usergroup_permits_STCNT varchar2(32) NOT NULL,
Sharing_policy_modifctn_MIN Number(20,4) NOT NULL,
Sharing_policy_modifctn_MAX Number(20,4) NOT NULL,
Sharing_policy_modifctn_STCNT varchar2(32) NOT NULL,
Group_additions_MIN Number(20,4) NOT NULL,
Group_additions_MAX Number(20,4) NOT NULL,
Group_additions_STCNT varchar2(32) NOT NULL,
Send_to_conn_creation_MIN Number(20,4) NOT NULL,
Send_to_conn_creation_MAX Number(20,4) NOT NULL,
Send_to_conn_creation_STCNT varchar2(32) NOT NULL,
Site_collection_creation_MIN Number(20,4) NOT NULL,
Site_collection_creation_MAX Number(20,4) NOT NULL,
Site_collection_creation_STCNT varchar2(32) NOT NULL,
Group_deletes_MIN Number(20,4) NOT NULL,
Group_deletes_MAX Number(20,4) NOT NULL,
Group_deletes_STCNT varchar2(32) NOT NULL,
Send_to_conn_deletes_MIN Number(20,4) NOT NULL,
Send_to_conn_deletes_MAX Number(20,4) NOT NULL,
Send_to_conn_deletes_STCNT varchar2(32) NOT NULL,
Site_deletes_MIN Number(20,4) NOT NULL,
Site_deletes_MAX Number(20,4) NOT NULL,
Site_deletes_STCNT varchar2(32) NOT NULL,
Document_preview_permits_MIN Number(20,4) NOT NULL,
Document_preview_permits_MAX Number(20,4) NOT NULL,
Document_preview_permits_STCNT varchar2(32) NOT NULL,
Workflow_task_contnt_MIN Number(20,4) NOT NULL,
Workflow_task_contnt_MAX Number(20,4) NOT NULL,
Workflow_task_contnt_STCNT varchar2(32) NOT NULL,
Office_ondemand_permits_MIN Number(20,4) NOT NULL,
Office_ondemand_permits_MAX Number(20,4) NOT NULL,
Office_ondemand_permits_STCNT varchar2(32) NOT NULL,
News_feed_permits_MIN Number(20,4) NOT NULL,
News_feed_permits_MAX Number(20,4) NOT NULL,
News_feed_permits_STCNT varchar2(32) NOT NULL,
Site_permissn_modifictn_MIN Number(20,4) NOT NULL,
Site_permissn_modifictn_MAX Number(20,4) NOT NULL,
Site_permissn_modifictn_STCNT varchar2(32) NOT NULL,
Removals_from_group_MIN Number(20,4) NOT NULL,
Removals_from_group_MAX Number(20,4) NOT NULL,
Removals_from_group_STCNT varchar2(32) NOT NULL,
Site_renames_MIN Number(20,4) NOT NULL,
Site_renames_MAX Number(20,4) NOT NULL,
Site_renames_STCNT varchar2(32) NOT NULL,
Site_admin_requests_MIN Number(20,4) NOT NULL,
Site_admin_requests_MAX Number(20,4) NOT NULL,
Site_admin_requests_STCNT varchar2(32) NOT NULL,
Host_site_changes_MIN Number(20,4) NOT NULL,
Host_site_changes_MAX Number(20,4) NOT NULL,
Host_site_changes_STCNT varchar2(32) NOT NULL,
Group_settings_changes_MIN Number(20,4) NOT NULL,
Group_settings_changes_MAX Number(20,4) NOT NULL,
Group_settings_changes_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOSAdminActTest_TREND ADD constraint PK_SPOSAdminActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSAdminActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOSAdminActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_addition_MIN VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_addition_MAX VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_modifitn_MIN VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_modifitn_MAX VARCHAR2(256) NOT NULL,
Sit_collectn_admin_addtn_MIN VARCHAR2(256) NOT NULL,
Sit_collectn_admin_addtn_MAX VARCHAR2(256) NOT NULL,
User_group_additions_MIN VARCHAR2(256) NOT NULL,
User_group_additions_MAX VARCHAR2(256) NOT NULL,
Add_usergroup_permits_MIN VARCHAR2(256) NOT NULL,
Add_usergroup_permits_MAX VARCHAR2(256) NOT NULL,
Sharing_policy_modifctn_MIN VARCHAR2(256) NOT NULL,
Sharing_policy_modifctn_MAX VARCHAR2(256) NOT NULL,
Group_additions_MIN VARCHAR2(256) NOT NULL,
Group_additions_MAX VARCHAR2(256) NOT NULL,
Send_to_conn_creation_MIN VARCHAR2(256) NOT NULL,
Send_to_conn_creation_MAX VARCHAR2(256) NOT NULL,
Site_collection_creation_MIN VARCHAR2(256) NOT NULL,
Site_collection_creation_MAX VARCHAR2(256) NOT NULL,
Group_deletes_MIN VARCHAR2(256) NOT NULL,
Group_deletes_MAX VARCHAR2(256) NOT NULL,
Send_to_conn_deletes_MIN VARCHAR2(256) NOT NULL,
Send_to_conn_deletes_MAX VARCHAR2(256) NOT NULL,
Site_deletes_MIN VARCHAR2(256) NOT NULL,
Site_deletes_MAX VARCHAR2(256) NOT NULL,
Document_preview_permits_MIN VARCHAR2(256) NOT NULL,
Document_preview_permits_MAX VARCHAR2(256) NOT NULL,
Workflow_task_contnt_MIN VARCHAR2(256) NOT NULL,
Workflow_task_contnt_MAX VARCHAR2(256) NOT NULL,
Office_ondemand_permits_MIN VARCHAR2(256) NOT NULL,
Office_ondemand_permits_MAX VARCHAR2(256) NOT NULL,
News_feed_permits_MIN VARCHAR2(256) NOT NULL,
News_feed_permits_MAX VARCHAR2(256) NOT NULL,
Site_permissn_modifictn_MIN VARCHAR2(256) NOT NULL,
Site_permissn_modifictn_MAX VARCHAR2(256) NOT NULL,
Removals_from_group_MIN VARCHAR2(256) NOT NULL,
Removals_from_group_MAX VARCHAR2(256) NOT NULL,
Site_renames_MIN VARCHAR2(256) NOT NULL,
Site_renames_MAX VARCHAR2(256) NOT NULL,
Site_admin_requests_MIN VARCHAR2(256) NOT NULL,
Site_admin_requests_MAX VARCHAR2(256) NOT NULL,
Host_site_changes_MIN VARCHAR2(256) NOT NULL,
Host_site_changes_MAX VARCHAR2(256) NOT NULL,
Group_settings_changes_MIN VARCHAR2(256) NOT NULL,
Group_settings_changes_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOSAdminActTest_THRESH ADD constraint PK_SPOSAdminActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSAdminActTest_THRESH ON SPOSAdminActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSAdminActTest ON SPOSAdminActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSAdminActTest ON SPOSAdminActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOFolderActTest CASCADE CONSTRAINTS;
CREATE TABLE SPOFolderActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
Folder_copies Number(20,4) NOT NULL,
Folder_copies_ST varchar2(32) NOT NULL,
Folder_creations Number(20,4) NOT NULL,
Folder_creations_ST varchar2(32) NOT NULL,
Folder_deletions Number(20,4) NOT NULL,
Folder_deletions_ST varchar2(32) NOT NULL,
Folder_deletions_I_bin Number(20,4) NOT NULL,
Folder_deletions_I_bin_ST varchar2(32) NOT NULL,
Folder_deletions_II_bin Number(20,4) NOT NULL,
Folder_deletions_II_bin_ST varchar2(32) NOT NULL,
Folder_modifications Number(20,4) NOT NULL,
Folder_modifications_ST varchar2(32) NOT NULL,
Folder_moves Number(20,4) NOT NULL,
Folder_moves_ST varchar2(32) NOT NULL,
Folder_renames Number(20,4) NOT NULL,
Folder_renames_ST varchar2(32) NOT NULL,
Folder_restores Number(20,4) NOT NULL,
Folder_restores_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOFolderActTest ON SPOFolderActTest(MSMT_TIME);
ALTER TABLE SPOFolderActTest ADD constraint PK_SPOFolderActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOFolderActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOFolderActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
Folder_copies_MIN Number(20,4) NOT NULL,
Folder_copies_MAX Number(20,4) NOT NULL,
Folder_copies_STCNT varchar2(32) NOT NULL,
Folder_creations_MIN Number(20,4) NOT NULL,
Folder_creations_MAX Number(20,4) NOT NULL,
Folder_creations_STCNT varchar2(32) NOT NULL,
Folder_deletions_MIN Number(20,4) NOT NULL,
Folder_deletions_MAX Number(20,4) NOT NULL,
Folder_deletions_STCNT varchar2(32) NOT NULL,
Folder_deletions_I_bin_MIN Number(20,4) NOT NULL,
Folder_deletions_I_bin_MAX Number(20,4) NOT NULL,
Folder_deletions_I_bin_STCNT varchar2(32) NOT NULL,
Folder_deletions_II_bin_MIN Number(20,4) NOT NULL,
Folder_deletions_II_bin_MAX Number(20,4) NOT NULL,
Folder_deletions_II_bin_STCNT varchar2(32) NOT NULL,
Folder_modifications_MIN Number(20,4) NOT NULL,
Folder_modifications_MAX Number(20,4) NOT NULL,
Folder_modifications_STCNT varchar2(32) NOT NULL,
Folder_moves_MIN Number(20,4) NOT NULL,
Folder_moves_MAX Number(20,4) NOT NULL,
Folder_moves_STCNT varchar2(32) NOT NULL,
Folder_renames_MIN Number(20,4) NOT NULL,
Folder_renames_MAX Number(20,4) NOT NULL,
Folder_renames_STCNT varchar2(32) NOT NULL,
Folder_restores_MIN Number(20,4) NOT NULL,
Folder_restores_MAX Number(20,4) NOT NULL,
Folder_restores_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOFolderActTest_TREND ADD constraint PK_SPOFolderActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOFolderActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOFolderActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
Folder_copies_MIN VARCHAR2(256) NOT NULL,
Folder_copies_MAX VARCHAR2(256) NOT NULL,
Folder_creations_MIN VARCHAR2(256) NOT NULL,
Folder_creations_MAX VARCHAR2(256) NOT NULL,
Folder_deletions_MIN VARCHAR2(256) NOT NULL,
Folder_deletions_MAX VARCHAR2(256) NOT NULL,
Folder_deletions_I_bin_MIN VARCHAR2(256) NOT NULL,
Folder_deletions_I_bin_MAX VARCHAR2(256) NOT NULL,
Folder_deletions_II_bin_MIN VARCHAR2(256) NOT NULL,
Folder_deletions_II_bin_MAX VARCHAR2(256) NOT NULL,
Folder_modifications_MIN VARCHAR2(256) NOT NULL,
Folder_modifications_MAX VARCHAR2(256) NOT NULL,
Folder_moves_MIN VARCHAR2(256) NOT NULL,
Folder_moves_MAX VARCHAR2(256) NOT NULL,
Folder_renames_MIN VARCHAR2(256) NOT NULL,
Folder_renames_MAX VARCHAR2(256) NOT NULL,
Folder_restores_MIN VARCHAR2(256) NOT NULL,
Folder_restores_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOFolderActTest_THRESH ADD constraint PK_SPOFolderActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOFolderActTest_THRESH ON SPOFolderActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOFolderActTest ON SPOFolderActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOFolderActTest ON SPOFolderActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOSharngActTest CASCADE CONSTRAINTS;
CREATE TABLE SPOSharngActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
Access_req_acceptance Number(20,4) NOT NULL,
Access_req_acceptance_ST varchar2(32) NOT NULL,
Sharng_invitatn_acceptnc Number(20,4) NOT NULL,
Sharng_invitatn_acceptnc_ST varchar2(32) NOT NULL,
Sharng_invitatn_blocked Number(20,4) NOT NULL,
Sharng_invitatn_blocked_ST varchar2(32) NOT NULL,
Company_link_creations Number(20,4) NOT NULL,
Company_link_creations_ST varchar2(32) NOT NULL,
Access_request_creations Number(20,4) NOT NULL,
Access_request_creations_ST varchar2(32) NOT NULL,
Anonymous_link_creations Number(20,4) NOT NULL,
Anonymous_link_creations_ST varchar2(32) NOT NULL,
Sharng_invitatn_creation Number(20,4) NOT NULL,
Sharng_invitatn_creation_ST varchar2(32) NOT NULL,
Access_request_denials Number(20,4) NOT NULL,
Access_request_denials_ST varchar2(32) NOT NULL,
Company_link_removals Number(20,4) NOT NULL,
Company_link_removals_ST varchar2(32) NOT NULL,
Anonymous_link_removals Number(20,4) NOT NULL,
Anonymous_link_removals_ST varchar2(32) NOT NULL,
File_Folder_Site_share Number(20,4) NOT NULL,
File_Folder_Site_share_ST varchar2(32) NOT NULL,
Anonymous_link_updates Number(20,4) NOT NULL,
Anonymous_link_updates_ST varchar2(32) NOT NULL,
Anonymous_link_usage Number(20,4) NOT NULL,
Anonymous_link_usage_ST varchar2(32) NOT NULL,
Sharing_revokes Number(20,4) NOT NULL,
Sharing_revokes_ST varchar2(32) NOT NULL,
Company_link_usage Number(20,4) NOT NULL,
Company_link_usage_ST varchar2(32) NOT NULL,
Sharng_invitatn_withdrw Number(20,4) NOT NULL,
Sharng_invitatn_withdrw_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOSharngActTest ON SPOSharngActTest(MSMT_TIME);
ALTER TABLE SPOSharngActTest ADD constraint PK_SPOSharngActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSharngActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOSharngActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
Access_req_acceptance_MIN Number(20,4) NOT NULL,
Access_req_acceptance_MAX Number(20,4) NOT NULL,
Access_req_acceptance_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_acceptnc_MIN Number(20,4) NOT NULL,
Sharng_invitatn_acceptnc_MAX Number(20,4) NOT NULL,
Sharng_invitatn_acceptnc_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_blocked_MIN Number(20,4) NOT NULL,
Sharng_invitatn_blocked_MAX Number(20,4) NOT NULL,
Sharng_invitatn_blocked_STCNT varchar2(32) NOT NULL,
Company_link_creations_MIN Number(20,4) NOT NULL,
Company_link_creations_MAX Number(20,4) NOT NULL,
Company_link_creations_STCNT varchar2(32) NOT NULL,
Access_request_creations_MIN Number(20,4) NOT NULL,
Access_request_creations_MAX Number(20,4) NOT NULL,
Access_request_creations_STCNT varchar2(32) NOT NULL,
Anonymous_link_creations_MIN Number(20,4) NOT NULL,
Anonymous_link_creations_MAX Number(20,4) NOT NULL,
Anonymous_link_creations_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_creation_MIN Number(20,4) NOT NULL,
Sharng_invitatn_creation_MAX Number(20,4) NOT NULL,
Sharng_invitatn_creation_STCNT varchar2(32) NOT NULL,
Access_request_denials_MIN Number(20,4) NOT NULL,
Access_request_denials_MAX Number(20,4) NOT NULL,
Access_request_denials_STCNT varchar2(32) NOT NULL,
Company_link_removals_MIN Number(20,4) NOT NULL,
Company_link_removals_MAX Number(20,4) NOT NULL,
Company_link_removals_STCNT varchar2(32) NOT NULL,
Anonymous_link_removals_MIN Number(20,4) NOT NULL,
Anonymous_link_removals_MAX Number(20,4) NOT NULL,
Anonymous_link_removals_STCNT varchar2(32) NOT NULL,
File_Folder_Site_share_MIN Number(20,4) NOT NULL,
File_Folder_Site_share_MAX Number(20,4) NOT NULL,
File_Folder_Site_share_STCNT varchar2(32) NOT NULL,
Anonymous_link_updates_MIN Number(20,4) NOT NULL,
Anonymous_link_updates_MAX Number(20,4) NOT NULL,
Anonymous_link_updates_STCNT varchar2(32) NOT NULL,
Anonymous_link_usage_MIN Number(20,4) NOT NULL,
Anonymous_link_usage_MAX Number(20,4) NOT NULL,
Anonymous_link_usage_STCNT varchar2(32) NOT NULL,
Sharing_revokes_MIN Number(20,4) NOT NULL,
Sharing_revokes_MAX Number(20,4) NOT NULL,
Sharing_revokes_STCNT varchar2(32) NOT NULL,
Company_link_usage_MIN Number(20,4) NOT NULL,
Company_link_usage_MAX Number(20,4) NOT NULL,
Company_link_usage_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_withdrw_MIN Number(20,4) NOT NULL,
Sharng_invitatn_withdrw_MAX Number(20,4) NOT NULL,
Sharng_invitatn_withdrw_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOSharngActTest_TREND ADD constraint PK_SPOSharngActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSharngActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOSharngActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
Access_req_acceptance_MIN VARCHAR2(256) NOT NULL,
Access_req_acceptance_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_acceptnc_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_acceptnc_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_blocked_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_blocked_MAX VARCHAR2(256) NOT NULL,
Company_link_creations_MIN VARCHAR2(256) NOT NULL,
Company_link_creations_MAX VARCHAR2(256) NOT NULL,
Access_request_creations_MIN VARCHAR2(256) NOT NULL,
Access_request_creations_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_creations_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_creations_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_creation_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_creation_MAX VARCHAR2(256) NOT NULL,
Access_request_denials_MIN VARCHAR2(256) NOT NULL,
Access_request_denials_MAX VARCHAR2(256) NOT NULL,
Company_link_removals_MIN VARCHAR2(256) NOT NULL,
Company_link_removals_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_removals_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_removals_MAX VARCHAR2(256) NOT NULL,
File_Folder_Site_share_MIN VARCHAR2(256) NOT NULL,
File_Folder_Site_share_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_updates_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_updates_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_usage_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_usage_MAX VARCHAR2(256) NOT NULL,
Sharing_revokes_MIN VARCHAR2(256) NOT NULL,
Sharing_revokes_MAX VARCHAR2(256) NOT NULL,
Company_link_usage_MIN VARCHAR2(256) NOT NULL,
Company_link_usage_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_withdrw_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_withdrw_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOSharngActTest_THRESH ADD constraint PK_SPOSharngActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSharngActTest_THRESH ON SPOSharngActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSharngActTest ON SPOSharngActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSharngActTest ON SPOSharngActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOFileActTest CASCADE CONSTRAINTS;
CREATE TABLE SPOFileActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
File_accesses Number(20,4) NOT NULL,
File_accesses_ST varchar2(32) NOT NULL,
File_check_ins Number(20,4) NOT NULL,
File_check_ins_ST varchar2(32) NOT NULL,
File_checkouts Number(20,4) NOT NULL,
File_checkouts_ST varchar2(32) NOT NULL,
File_copies Number(20,4) NOT NULL,
File_copies_ST varchar2(32) NOT NULL,
File_deletes Number(20,4) NOT NULL,
File_deletes_ST varchar2(32) NOT NULL,
File_deletes_frm_I_stage Number(20,4) NOT NULL,
File_deletes_frm_I_stage_ST varchar2(32) NOT NULL,
File_deletes_frm_II_stag Number(20,4) NOT NULL,
File_deletes_frm_II_stag_ST varchar2(32) NOT NULL,
File_checkout_discards Number(20,4) NOT NULL,
File_checkout_discards_ST varchar2(32) NOT NULL,
File_downloads Number(20,4) NOT NULL,
File_downloads_ST varchar2(32) NOT NULL,
File_modifications Number(20,4) NOT NULL,
File_modifications_ST varchar2(32) NOT NULL,
File_moves Number(20,4) NOT NULL,
File_moves_ST varchar2(32) NOT NULL,
File_renames Number(20,4) NOT NULL,
File_renames_ST varchar2(32) NOT NULL,
File_restores Number(20,4) NOT NULL,
File_restores_ST varchar2(32) NOT NULL,
File_uploads Number(20,4) NOT NULL,
File_uploads_ST varchar2(32) NOT NULL,
Page_views Number(20,4) NOT NULL,
Page_views_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOFileActTest ON SPOFileActTest(MSMT_TIME);
ALTER TABLE SPOFileActTest ADD constraint PK_SPOFileActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOFileActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOFileActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
File_accesses_MIN Number(20,4) NOT NULL,
File_accesses_MAX Number(20,4) NOT NULL,
File_accesses_STCNT varchar2(32) NOT NULL,
File_check_ins_MIN Number(20,4) NOT NULL,
File_check_ins_MAX Number(20,4) NOT NULL,
File_check_ins_STCNT varchar2(32) NOT NULL,
File_checkouts_MIN Number(20,4) NOT NULL,
File_checkouts_MAX Number(20,4) NOT NULL,
File_checkouts_STCNT varchar2(32) NOT NULL,
File_copies_MIN Number(20,4) NOT NULL,
File_copies_MAX Number(20,4) NOT NULL,
File_copies_STCNT varchar2(32) NOT NULL,
File_deletes_MIN Number(20,4) NOT NULL,
File_deletes_MAX Number(20,4) NOT NULL,
File_deletes_STCNT varchar2(32) NOT NULL,
File_deletes_frm_I_stage_MIN Number(20,4) NOT NULL,
File_deletes_frm_I_stage_MAX Number(20,4) NOT NULL,
File_deletes_frm_I_stage_STCNT varchar2(32) NOT NULL,
File_deletes_frm_II_stag_MIN Number(20,4) NOT NULL,
File_deletes_frm_II_stag_MAX Number(20,4) NOT NULL,
File_deletes_frm_II_stag_STCNT varchar2(32) NOT NULL,
File_checkout_discards_MIN Number(20,4) NOT NULL,
File_checkout_discards_MAX Number(20,4) NOT NULL,
File_checkout_discards_STCNT varchar2(32) NOT NULL,
File_downloads_MIN Number(20,4) NOT NULL,
File_downloads_MAX Number(20,4) NOT NULL,
File_downloads_STCNT varchar2(32) NOT NULL,
File_modifications_MIN Number(20,4) NOT NULL,
File_modifications_MAX Number(20,4) NOT NULL,
File_modifications_STCNT varchar2(32) NOT NULL,
File_moves_MIN Number(20,4) NOT NULL,
File_moves_MAX Number(20,4) NOT NULL,
File_moves_STCNT varchar2(32) NOT NULL,
File_renames_MIN Number(20,4) NOT NULL,
File_renames_MAX Number(20,4) NOT NULL,
File_renames_STCNT varchar2(32) NOT NULL,
File_restores_MIN Number(20,4) NOT NULL,
File_restores_MAX Number(20,4) NOT NULL,
File_restores_STCNT varchar2(32) NOT NULL,
File_uploads_MIN Number(20,4) NOT NULL,
File_uploads_MAX Number(20,4) NOT NULL,
File_uploads_STCNT varchar2(32) NOT NULL,
Page_views_MIN Number(20,4) NOT NULL,
Page_views_MAX Number(20,4) NOT NULL,
Page_views_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOFileActTest_TREND ADD constraint PK_SPOFileActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOFileActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOFileActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
File_accesses_MIN VARCHAR2(256) NOT NULL,
File_accesses_MAX VARCHAR2(256) NOT NULL,
File_check_ins_MIN VARCHAR2(256) NOT NULL,
File_check_ins_MAX VARCHAR2(256) NOT NULL,
File_checkouts_MIN VARCHAR2(256) NOT NULL,
File_checkouts_MAX VARCHAR2(256) NOT NULL,
File_copies_MIN VARCHAR2(256) NOT NULL,
File_copies_MAX VARCHAR2(256) NOT NULL,
File_deletes_MIN VARCHAR2(256) NOT NULL,
File_deletes_MAX VARCHAR2(256) NOT NULL,
File_deletes_frm_I_stage_MIN VARCHAR2(256) NOT NULL,
File_deletes_frm_I_stage_MAX VARCHAR2(256) NOT NULL,
File_deletes_frm_II_stag_MIN VARCHAR2(256) NOT NULL,
File_deletes_frm_II_stag_MAX VARCHAR2(256) NOT NULL,
File_checkout_discards_MIN VARCHAR2(256) NOT NULL,
File_checkout_discards_MAX VARCHAR2(256) NOT NULL,
File_downloads_MIN VARCHAR2(256) NOT NULL,
File_downloads_MAX VARCHAR2(256) NOT NULL,
File_modifications_MIN VARCHAR2(256) NOT NULL,
File_modifications_MAX VARCHAR2(256) NOT NULL,
File_moves_MIN VARCHAR2(256) NOT NULL,
File_moves_MAX VARCHAR2(256) NOT NULL,
File_renames_MIN VARCHAR2(256) NOT NULL,
File_renames_MAX VARCHAR2(256) NOT NULL,
File_restores_MIN VARCHAR2(256) NOT NULL,
File_restores_MAX VARCHAR2(256) NOT NULL,
File_uploads_MIN VARCHAR2(256) NOT NULL,
File_uploads_MAX VARCHAR2(256) NOT NULL,
Page_views_MIN VARCHAR2(256) NOT NULL,
Page_views_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOFileActTest_THRESH ADD constraint PK_SPOFileActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOFileActTest_THRESH ON SPOFileActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOFileActTest ON SPOFileActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOFileActTest ON SPOFileActTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXOMailBoxTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_Mailboxes Number(20,4) NOT NULL,
Total_Mailboxes_ST varchar2(32) NOT NULL,
FrwdMailbx Number(20,4) NOT NULL,
FrwdMailbx_ST varchar2(32) NOT NULL,
litigation_hold Number(20,4) NOT NULL,
litigation_hold_ST varchar2(32) NOT NULL,
Inplace_hold Number(20,4) NOT NULL,
Inplace_hold_ST varchar2(32) NOT NULL,
AllMailbox_hold Number(20,4) NOT NULL,
AllMailbox_hold_ST varchar2(32) NOT NULL,
Shrdmailbx Number(20,4) NOT NULL,
Shrdmailbx_ST varchar2(32) NOT NULL,
NewlyCreateMailbx Number(20,4) NOT NULL,
NewlyCreateMailbx_ST varchar2(32) NOT NULL,
RecntModifyMailbx Number(20,4) NOT NULL,
RecntModifyMailbx_ST varchar2(32) NOT NULL,
SoftDeleteMailbx Number(20,4) NOT NULL,
SoftDeleteMailbx_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOMailBoxTest ON EXOMailBoxTest(MSMT_TIME);
ALTER TABLE EXOMailBoxTest ADD constraint PK_EXOMailBoxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailBoxTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_Mailboxes_MIN Number(20,4) NOT NULL,
Total_Mailboxes_MAX Number(20,4) NOT NULL,
Total_Mailboxes_STCNT varchar2(32) NOT NULL,
FrwdMailbx_MIN Number(20,4) NOT NULL,
FrwdMailbx_MAX Number(20,4) NOT NULL,
FrwdMailbx_STCNT varchar2(32) NOT NULL,
litigation_hold_MIN Number(20,4) NOT NULL,
litigation_hold_MAX Number(20,4) NOT NULL,
litigation_hold_STCNT varchar2(32) NOT NULL,
Inplace_hold_MIN Number(20,4) NOT NULL,
Inplace_hold_MAX Number(20,4) NOT NULL,
Inplace_hold_STCNT varchar2(32) NOT NULL,
AllMailbox_hold_MIN Number(20,4) NOT NULL,
AllMailbox_hold_MAX Number(20,4) NOT NULL,
AllMailbox_hold_STCNT varchar2(32) NOT NULL,
Shrdmailbx_MIN Number(20,4) NOT NULL,
Shrdmailbx_MAX Number(20,4) NOT NULL,
Shrdmailbx_STCNT varchar2(32) NOT NULL,
NewlyCreateMailbx_MIN Number(20,4) NOT NULL,
NewlyCreateMailbx_MAX Number(20,4) NOT NULL,
NewlyCreateMailbx_STCNT varchar2(32) NOT NULL,
RecntModifyMailbx_MIN Number(20,4) NOT NULL,
RecntModifyMailbx_MAX Number(20,4) NOT NULL,
RecntModifyMailbx_STCNT varchar2(32) NOT NULL,
SoftDeleteMailbx_MIN Number(20,4) NOT NULL,
SoftDeleteMailbx_MAX Number(20,4) NOT NULL,
SoftDeleteMailbx_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOMailBoxTest_TREND ADD constraint PK_EXOMailBoxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMailBoxTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_Mailboxes_MIN VARCHAR2(256) NOT NULL,
Total_Mailboxes_MAX VARCHAR2(256) NOT NULL,
FrwdMailbx_MIN VARCHAR2(256) NOT NULL,
FrwdMailbx_MAX VARCHAR2(256) NOT NULL,
litigation_hold_MIN VARCHAR2(256) NOT NULL,
litigation_hold_MAX VARCHAR2(256) NOT NULL,
Inplace_hold_MIN VARCHAR2(256) NOT NULL,
Inplace_hold_MAX VARCHAR2(256) NOT NULL,
AllMailbox_hold_MIN VARCHAR2(256) NOT NULL,
AllMailbox_hold_MAX VARCHAR2(256) NOT NULL,
Shrdmailbx_MIN VARCHAR2(256) NOT NULL,
Shrdmailbx_MAX VARCHAR2(256) NOT NULL,
NewlyCreateMailbx_MIN VARCHAR2(256) NOT NULL,
NewlyCreateMailbx_MAX VARCHAR2(256) NOT NULL,
RecntModifyMailbx_MIN VARCHAR2(256) NOT NULL,
RecntModifyMailbx_MAX VARCHAR2(256) NOT NULL,
SoftDeleteMailbx_MIN VARCHAR2(256) NOT NULL,
SoftDeleteMailbx_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE EXOMailBoxTest_THRESH ADD constraint PK_EXOMailBoxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMailBoxTest_THRESH ON EXOMailBoxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailBoxTest ON EXOMailBoxTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailBoxTest ON EXOMailBoxTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOMailBoxStatsTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxStatsTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
TOTAL_MAILBOX_SIZE Number(20,4) NOT NULL,
TOTAL_MAILBOX_SIZE_ST varchar2(32) NOT NULL,
MAILBOXES_GROWTH_RATE Number(20,4) NOT NULL,
MAILBOXES_GROWTH_RATE_ST varchar2(32) NOT NULL,
MAILBOXES_OVER_QUOTA Number(20,4) NOT NULL,
MAILBOXES_OVER_QUOTA_ST varchar2(32) NOT NULL,
INACTIVE_MAILBOXES Number(20,4) NOT NULL,
INACTIVE_MAILBOXES_ST varchar2(32) NOT NULL,
INACTIVE_MAILBOXES_SIZE Number(20,4) NOT NULL,
INACTIVE_MAILBOXES_SIZE_ST varchar2(32) NOT NULL,
ARCHIVE_MAILBOXES Number(20,4) NOT NULL,
ARCHIVE_MAILBOXES_ST varchar2(32) NOT NULL,
ARCHIVE_MAILBOXES_SIZE Number(20,4) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_ST varchar2(32) NOT NULL,
CLUTTER_ENABLED_MAILBOX Number(20,4) NOT NULL,
CLUTTER_ENABLED_MAILBOX_ST varchar2(32) NOT NULL,
CLUTTER_DISABLED_MAILBOX Number(20,4) NOT NULL,
CLUTTER_DISABLED_MAILBOX_ST varchar2(32) NOT NULL,
DBSNDQTE Number(20,4) NOT NULL,
DBSNDQTE_ST varchar2(32) NOT NULL,
DBSNDRECQTE Number(20,4) NOT NULL,
DBSNDRECQTE_ST varchar2(32) NOT NULL,
ArrMailsExWnQta Number(20,4) NOT NULL,
ArrMailsExWnQta_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOMailBoxStatsTest ON EXOMailBoxStatsTest(MSMT_TIME);
ALTER TABLE EXOMailBoxStatsTest ADD constraint PK_EXOMailBoxStatsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailBoxStatsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxStatsTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
TOTAL_MAILBOX_SIZE_MIN Number(20,4) NOT NULL,
TOTAL_MAILBOX_SIZE_MAX Number(20,4) NOT NULL,
TOTAL_MAILBOX_SIZE_STCNT varchar2(32) NOT NULL,
MAILBOXES_GROWTH_RATE_MIN Number(20,4) NOT NULL,
MAILBOXES_GROWTH_RATE_MAX Number(20,4) NOT NULL,
MAILBOXES_GROWTH_RATE_STCNT varchar2(32) NOT NULL,
MAILBOXES_OVER_QUOTA_MIN Number(20,4) NOT NULL,
MAILBOXES_OVER_QUOTA_MAX Number(20,4) NOT NULL,
MAILBOXES_OVER_QUOTA_STCNT varchar2(32) NOT NULL,
INACTIVE_MAILBOXES_MIN Number(20,4) NOT NULL,
INACTIVE_MAILBOXES_MAX Number(20,4) NOT NULL,
INACTIVE_MAILBOXES_STCNT varchar2(32) NOT NULL,
INACTIVE_MAILBOXES_SIZE_MIN Number(20,4) NOT NULL,
INACTIVE_MAILBOXES_SIZE_MAX Number(20,4) NOT NULL,
INACTIVE_MAILBOXES_SIZE_STCNT varchar2(32) NOT NULL,
ARCHIVE_MAILBOXES_MIN Number(20,4) NOT NULL,
ARCHIVE_MAILBOXES_MAX Number(20,4) NOT NULL,
ARCHIVE_MAILBOXES_STCNT varchar2(32) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_MIN Number(20,4) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_MAX Number(20,4) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_STCNT varchar2(32) NOT NULL,
CLUTTER_ENABLED_MAILBOX_MIN Number(20,4) NOT NULL,
CLUTTER_ENABLED_MAILBOX_MAX Number(20,4) NOT NULL,
CLUTTER_ENABLED_MAILBOX_STCNT varchar2(32) NOT NULL,
CLUTTER_DISABLED_MAILBOX_MIN Number(20,4) NOT NULL,
CLUTTER_DISABLED_MAILBOX_MAX Number(20,4) NOT NULL,
CLUTTER_DISABLED_MAILBOX_STCNT varchar2(32) NOT NULL,
DBSNDQTE_MIN Number(20,4) NOT NULL,
DBSNDQTE_MAX Number(20,4) NOT NULL,
DBSNDQTE_STCNT varchar2(32) NOT NULL,
DBSNDRECQTE_MIN Number(20,4) NOT NULL,
DBSNDRECQTE_MAX Number(20,4) NOT NULL,
DBSNDRECQTE_STCNT varchar2(32) NOT NULL,
ArrMailsExWnQta_MIN Number(20,4) NOT NULL,
ArrMailsExWnQta_MAX Number(20,4) NOT NULL,
ArrMailsExWnQta_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOMailBoxStatsTest_TREND ADD constraint PK_EXOMailBoxStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMailBoxStatsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxStatsTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
TOTAL_MAILBOX_SIZE_MIN varchar2(256) NOT NULL,
TOTAL_MAILBOX_SIZE_MAX varchar2(256) NOT NULL,
MAILBOXES_GROWTH_RATE_MIN varchar2(256) NOT NULL,
MAILBOXES_GROWTH_RATE_MAX varchar2(256) NOT NULL,
MAILBOXES_OVER_QUOTA_MIN varchar2(256) NOT NULL,
MAILBOXES_OVER_QUOTA_MAX varchar2(256) NOT NULL,
INACTIVE_MAILBOXES_MIN varchar2(256) NOT NULL,
INACTIVE_MAILBOXES_MAX varchar2(256) NOT NULL,
INACTIVE_MAILBOXES_SIZE_MIN varchar2(256) NOT NULL,
INACTIVE_MAILBOXES_SIZE_MAX varchar2(256) NOT NULL,
ARCHIVE_MAILBOXES_MIN varchar2(256) NOT NULL,
ARCHIVE_MAILBOXES_MAX varchar2(256) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_MIN varchar2(256) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_MAX varchar2(256) NOT NULL,
CLUTTER_ENABLED_MAILBOX_MIN varchar2(256) NOT NULL,
CLUTTER_ENABLED_MAILBOX_MAX varchar2(256) NOT NULL,
CLUTTER_DISABLED_MAILBOX_MIN varchar2(256) NOT NULL,
CLUTTER_DISABLED_MAILBOX_MAX varchar2(256) NOT NULL,
DBSNDQTE_MIN varchar2(256) NOT NULL,
DBSNDQTE_MAX varchar2(256) NOT NULL,
DBSNDRECQTE_MIN varchar2(256) NOT NULL,
DBSNDRECQTE_MAX varchar2(256) NOT NULL,
ArrMailsExWnQta_MIN varchar2(256) NOT NULL,
ArrMailsExWnQta_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOMailBoxStatsTest_THRESH ADD constraint PK_EXOMailBoxStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMailBoxStatsTest_THRESH ON EXOMailBoxStatsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailBoxStatsTest ON EXOMailBoxStatsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailBoxStatsTest ON EXOMailBoxStatsTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE EXOUsersTest CASCADE CONSTRAINTS;
CREATE TABLE EXOUsersTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Activesync Number(20,4) NOT NULL,
Activesync_ST varchar2(32) NOT NULL,
Non_Activesync Number(20,4) NOT NULL,
Non_Activesync_ST varchar2(32) NOT NULL,
SendAsUsers Number(20,4) NOT NULL,
SendAsUsers_ST varchar2(32) NOT NULL,
SendOnBehlfUsers Number(20,4) NOT NULL,
SendOnBehlfUsers_ST varchar2(32) NOT NULL,
AdminUsers Number(20,4) NOT NULL,
AdminUsers_ST varchar2(32) NOT NULL,
ActvUser Number(20,4) NOT NULL,
ActvUser_ST varchar2(32) NOT NULL,
InActvUser Number(20,4) NOT NULL,
InActvUser_ST varchar2(32) NOT NULL,
NvrLogUser Number(20,4) NOT NULL,
NvrLogUser_ST varchar2(32) NOT NULL,
PassExpUsers Number(20,4) NOT NULL,
PassExpUsers_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOUsersTest ON EXOUsersTest(MSMT_TIME);
ALTER TABLE EXOUsersTest ADD constraint PK_EXOUsersTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOUsersTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOUsersTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Activesync_MIN Number(20,4) NOT NULL,
Activesync_MAX Number(20,4) NOT NULL,
Activesync_STCNT varchar2(32) NOT NULL,
Non_Activesync_MIN Number(20,4) NOT NULL,
Non_Activesync_MAX Number(20,4) NOT NULL,
Non_Activesync_STCNT varchar2(32) NOT NULL,
SendAsUsers_MIN Number(20,4) NOT NULL,
SendAsUsers_MAX Number(20,4) NOT NULL,
SendAsUsers_STCNT varchar2(32) NOT NULL,
SendOnBehlfUsers_MIN Number(20,4) NOT NULL,
SendOnBehlfUsers_MAX Number(20,4) NOT NULL,
SendOnBehlfUsers_STCNT varchar2(32) NOT NULL,
AdminUsers_MIN Number(20,4) NOT NULL,
AdminUsers_MAX Number(20,4) NOT NULL,
AdminUsers_STCNT varchar2(32) NOT NULL,
ActvUser_MIN Number(20,4) NOT NULL,
ActvUser_MAX Number(20,4) NOT NULL,
ActvUser_STCNT varchar2(32) NOT NULL,
InActvUser_MIN Number(20,4) NOT NULL,
InActvUser_MAX Number(20,4) NOT NULL,
InActvUser_STCNT varchar2(32) NOT NULL,
NvrLogUser_MIN Number(20,4) NOT NULL,
NvrLogUser_MAX Number(20,4) NOT NULL,
NvrLogUser_STCNT varchar2(32) NOT NULL,
PassExpUsers_MIN Number(20,4) NOT NULL,
PassExpUsers_MAX Number(20,4) NOT NULL,
PassExpUsers_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOUsersTest_TREND ADD constraint PK_EXOUsersTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOUsersTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOUsersTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Activesync_MIN varchar2(256) NOT NULL,
Activesync_MAX varchar2(256) NOT NULL,
Non_Activesync_MIN varchar2(256) NOT NULL,
Non_Activesync_MAX varchar2(256) NOT NULL,
SendAsUsers_MIN varchar2(256) NOT NULL,
SendAsUsers_MAX varchar2(256) NOT NULL,
SendOnBehlfUsers_MIN varchar2(256) NOT NULL,
SendOnBehlfUsers_MAX varchar2(256) NOT NULL,
AdminUsers_MIN varchar2(256) NOT NULL,
AdminUsers_MAX varchar2(256) NOT NULL,
ActvUser_MIN varchar2(256) NOT NULL,
ActvUser_MAX varchar2(256) NOT NULL,
InActvUser_MIN varchar2(256) NOT NULL,
InActvUser_MAX varchar2(256) NOT NULL,
NvrLogUser_MIN varchar2(256) NOT NULL,
NvrLogUser_MAX varchar2(256) NOT NULL,
PassExpUsers_MIN varchar2(256) NOT NULL,
PassExpUsers_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOUsersTest_THRESH ADD constraint PK_EXOUsersTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOUsersTest_THRESH ON EXOUsersTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOUsersTest ON EXOUsersTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOUsersTest ON EXOUsersTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOReciTypeTest CASCADE CONSTRAINTS;
CREATE TABLE EXOReciTypeTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Count Number(20,4) NOT NULL,
Count_ST varchar2(32) NOT NULL,
Mailboxes_Size Number(20,4) NOT NULL,
Mailboxes_Size_ST varchar2(32) NOT NULL,
Item_Count Number(20,4) NOT NULL,
Item_Count_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOReciTypeTest ON EXOReciTypeTest(MSMT_TIME);
ALTER TABLE EXOReciTypeTest ADD constraint PK_EXOReciTypeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOReciTypeTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOReciTypeTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Count_MIN Number(20,4) NOT NULL,
Count_MAX Number(20,4) NOT NULL,
Count_STCNT varchar2(32) NOT NULL,
Mailboxes_Size_MIN Number(20,4) NOT NULL,
Mailboxes_Size_MAX Number(20,4) NOT NULL,
Mailboxes_Size_STCNT varchar2(32) NOT NULL,
Item_Count_MIN Number(20,4) NOT NULL,
Item_Count_MAX Number(20,4) NOT NULL,
Item_Count_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOReciTypeTest_TREND ADD constraint PK_EXOReciTypeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOReciTypeTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOReciTypeTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Count_MIN varchar2(256) NOT NULL,
Count_MAX varchar2(256) NOT NULL,
Mailboxes_Size_MIN varchar2(256) NOT NULL,
Mailboxes_Size_MAX varchar2(256) NOT NULL,
Item_Count_MIN varchar2(256) NOT NULL,
Item_Count_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOReciTypeTest_THRESH ADD constraint PK_EXOReciTypeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOReciTypeTest_THRESH ON EXOReciTypeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOReciTypeTest ON EXOReciTypeTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOReciTypeTest ON EXOReciTypeTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOMailTrfcStatisTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMailTrfcStatisTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Unique_Senders Number(20,4) NOT NULL,
Unique_Senders_ST varchar2(32) NOT NULL,
Unique_Receivers Number(20,4) NOT NULL,
Unique_Receivers_ST varchar2(32) NOT NULL,
Unique_Sender_IPs Number(20,4) NOT NULL,
Unique_Sender_IPs_ST varchar2(32) NOT NULL,
Inbound_Mail_Items Number(20,4) NOT NULL,
Inbound_Mail_Items_ST varchar2(32) NOT NULL,
Inbound_Mails_Size Number(20,4) NOT NULL,
Inbound_Mails_Size_ST varchar2(32) NOT NULL,
Outbound_Mail_Items Number(20,4) NOT NULL,
Outbound_Mail_Items_ST varchar2(32) NOT NULL,
Outbound_Mails_Size Number(20,4) NOT NULL,
Outbound_Mails_Size_ST varchar2(32) NOT NULL,
Total_Mail_Items Number(20,4) NOT NULL,
Total_Mail_Items_ST varchar2(32) NOT NULL,
Total_Mails_Size Number(20,4) NOT NULL,
Total_Mails_Size_ST varchar2(32) NOT NULL,
Internal_emails_sent Number(20,4) NOT NULL,
Internal_emails_sent_ST varchar2(32) NOT NULL,
Size_Intl_mailsent Number(20,4) NOT NULL,
Size_Intl_mailsent_ST varchar2(32) NOT NULL,
Internal_emails_recvd Number(20,4) NOT NULL,
Internal_emails_recvd_ST varchar2(32) NOT NULL,
Size_Intl_mailrecvd Number(20,4) NOT NULL,
Size_Intl_mailrecvd_ST varchar2(32) NOT NULL,
External_emails_sent Number(20,4) NOT NULL,
External_emails_sent_ST varchar2(32) NOT NULL,
Size_exrtl_mailsent Number(20,4) NOT NULL,
Size_exrtl_mailsent_ST varchar2(32) NOT NULL,
External_emails_recvd Number(20,4) NOT NULL,
External_emails_recvd_ST varchar2(32) NOT NULL,
Size_extl_mailrecvd Number(20,4) NOT NULL,
Size_extl_mailrecvd_ST varchar2(32) NOT NULL,
Nonecnt Number(20,4) NOT NULL,
Nonecnt_ST varchar2(32) NOT NULL,
Failedcnt Number(20,4) NOT NULL,
Failedcnt_ST varchar2(32) NOT NULL,
Pendingcnt Number(20,4) NOT NULL,
Pendingcnt_ST varchar2(32) NOT NULL,
Delvrycnt Number(20,4) NOT NULL,
Delvrycnt_ST varchar2(32) NOT NULL,
Expandcnt Number(20,4) NOT NULL,
Expandcnt_ST varchar2(32) NOT NULL,
Unq_outbud_doms Number(20,4) NOT NULL,
Unq_outbud_doms_ST varchar2(32) NOT NULL,
Unq_innbud_doms Number(20,4) NOT NULL,
Unq_innbud_doms_ST varchar2(32) NOT NULL,
Resloved Number(20,4) NOT NULL,
Resloved_ST varchar2(32) NOT NULL,
Filtered_as_spam Number(20,4) NOT NULL,
Filtered_as_spam_ST varchar2(32) NOT NULL,
Getting_status Number(20,4) NOT NULL,
Getting_status_ST varchar2(32) NOT NULL,
Quarantined Number(20,4) NOT NULL,
Quarantined_ST varchar2(32) NOT NULL,
Unknown Number(20,4) NOT NULL,
Unknown_ST varchar2(32) NOT NULL);


CREATE INDEX IDX_EXOMailTrfcStatisTest ON EXOMailTrfcStatisTest(MSMT_TIME);
ALTER TABLE EXOMailTrfcStatisTest ADD constraint PK_EXOMailTrfcStatisTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailTrfcStatisTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMailTrfcStatisTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Unique_Senders_MIN Number(20,4) NOT NULL,
Unique_Senders_MAX Number(20,4) NOT NULL,
Unique_Senders_STCNT varchar2(32) NOT NULL,
Unique_Receivers_MIN Number(20,4) NOT NULL,
Unique_Receivers_MAX Number(20,4) NOT NULL,
Unique_Receivers_STCNT varchar2(32) NOT NULL,
Unique_Sender_IPs_MIN Number(20,4) NOT NULL,
Unique_Sender_IPs_MAX Number(20,4) NOT NULL,
Unique_Sender_IPs_STCNT varchar2(32) NOT NULL,
Inbound_Mail_Items_MIN Number(20,4) NOT NULL,
Inbound_Mail_Items_MAX Number(20,4) NOT NULL,
Inbound_Mail_Items_STCNT varchar2(32) NOT NULL,
Inbound_Mails_Size_MIN Number(20,4) NOT NULL,
Inbound_Mails_Size_MAX Number(20,4) NOT NULL,
Inbound_Mails_Size_STCNT varchar2(32) NOT NULL,
Outbound_Mail_Items_MIN Number(20,4) NOT NULL,
Outbound_Mail_Items_MAX Number(20,4) NOT NULL,
Outbound_Mail_Items_STCNT varchar2(32) NOT NULL,
Outbound_Mails_Size_MIN Number(20,4) NOT NULL,
Outbound_Mails_Size_MAX Number(20,4) NOT NULL,
Outbound_Mails_Size_STCNT varchar2(32) NOT NULL,
Total_Mail_Items_MIN Number(20,4) NOT NULL,
Total_Mail_Items_MAX Number(20,4) NOT NULL,
Total_Mail_Items_STCNT varchar2(32) NOT NULL,
Total_Mails_Size_MIN Number(20,4) NOT NULL,
Total_Mails_Size_MAX Number(20,4) NOT NULL,
Total_Mails_Size_STCNT varchar2(32) NOT NULL,
Internal_emails_sent_MIN Number(20,4) NOT NULL,
Internal_emails_sent_MAX Number(20,4) NOT NULL,
Internal_emails_sent_STCNT varchar2(32) NOT NULL,
Size_Intl_mailsent_MIN Number(20,4) NOT NULL,
Size_Intl_mailsent_MAX Number(20,4) NOT NULL,
Size_Intl_mailsent_STCNT varchar2(32) NOT NULL,
Internal_emails_recvd_MIN Number(20,4) NOT NULL,
Internal_emails_recvd_MAX Number(20,4) NOT NULL,
Internal_emails_recvd_STCNT varchar2(32) NOT NULL,
Size_Intl_mailrecvd_MIN Number(20,4) NOT NULL,
Size_Intl_mailrecvd_MAX Number(20,4) NOT NULL,
Size_Intl_mailrecvd_STCNT varchar2(32) NOT NULL,
External_emails_sent_MIN Number(20,4) NOT NULL,
External_emails_sent_MAX Number(20,4) NOT NULL,
External_emails_sent_STCNT varchar2(32) NOT NULL,
Size_exrtl_mailsent_MIN Number(20,4) NOT NULL,
Size_exrtl_mailsent_MAX Number(20,4) NOT NULL,
Size_exrtl_mailsent_STCNT varchar2(32) NOT NULL,
External_emails_recvd_MIN Number(20,4) NOT NULL,
External_emails_recvd_MAX Number(20,4) NOT NULL,
External_emails_recvd_STCNT varchar2(32) NOT NULL,
Size_extl_mailrecvd_MIN Number(20,4) NOT NULL,
Size_extl_mailrecvd_MAX Number(20,4) NOT NULL,
Size_extl_mailrecvd_STCNT varchar2(32) NOT NULL,
Nonecnt_MIN Number(20,4) NOT NULL,
Nonecnt_MAX Number(20,4) NOT NULL,
Nonecnt_STCNT varchar2(32) NOT NULL,
Failedcnt_MIN Number(20,4) NOT NULL,
Failedcnt_MAX Number(20,4) NOT NULL,
Failedcnt_STCNT varchar2(32) NOT NULL,
Pendingcnt_MIN Number(20,4) NOT NULL,
Pendingcnt_MAX Number(20,4) NOT NULL,
Pendingcnt_STCNT varchar2(32) NOT NULL,
Delvrycnt_MIN Number(20,4) NOT NULL,
Delvrycnt_MAX Number(20,4) NOT NULL,
Delvrycnt_STCNT varchar2(32) NOT NULL,
Expandcnt_MIN Number(20,4) NOT NULL,
Expandcnt_MAX Number(20,4) NOT NULL,
Expandcnt_STCNT varchar2(32) NOT NULL,
Unq_outbud_doms_MIN Number(20,4) NOT NULL,
Unq_outbud_doms_MAX Number(20,4) NOT NULL,
Unq_outbud_doms_STCNT varchar2(32) NOT NULL,
Unq_innbud_doms_MIN Number(20,4) NOT NULL,
Unq_innbud_doms_MAX Number(20,4) NOT NULL,
Unq_innbud_doms_STCNT varchar2(32) NOT NULL,
Resloved_MIN Number(20,4) NOT NULL,
Resloved_MAX Number(20,4) NOT NULL,
Resloved_STCNT varchar2(32) NOT NULL,
Filtered_as_spam_MIN Number(20,4) NOT NULL,
Filtered_as_spam_MAX Number(20,4) NOT NULL,
Filtered_as_spam_STCNT varchar2(32) NOT NULL,
Getting_status_MIN Number(20,4) NOT NULL,
Getting_status_MAX Number(20,4) NOT NULL,
Getting_status_STCNT varchar2(32) NOT NULL,
Quarantined_MIN Number(20,4) NOT NULL,
Quarantined_MAX Number(20,4) NOT NULL,
Quarantined_STCNT varchar2(32) NOT NULL,
Unknown_MIN Number(20,4) NOT NULL,
Unknown_MAX Number(20,4) NOT NULL,
Unknown_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOMailTrfcStatisTest_TREND ADD constraint PK_EXOMalTrfcStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMailTrfcStatisTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMailTrfcStatisTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Unique_Senders_MIN varchar2(256) NOT NULL,
Unique_Senders_MAX varchar2(256) NOT NULL,
Unique_Receivers_MIN varchar2(256) NOT NULL,
Unique_Receivers_MAX varchar2(256) NOT NULL,
Unique_Sender_IPs_MIN varchar2(256) NOT NULL,
Unique_Sender_IPs_MAX varchar2(256) NOT NULL,
Inbound_Mail_Items_MIN varchar2(256) NOT NULL,
Inbound_Mail_Items_MAX varchar2(256) NOT NULL,
Inbound_Mails_Size_MIN varchar2(256) NOT NULL,
Inbound_Mails_Size_MAX varchar2(256) NOT NULL,
Outbound_Mail_Items_MIN varchar2(256) NOT NULL,
Outbound_Mail_Items_MAX varchar2(256) NOT NULL,
Outbound_Mails_Size_MIN varchar2(256) NOT NULL,
Outbound_Mails_Size_MAX varchar2(256) NOT NULL,
Total_Mail_Items_MIN varchar2(256) NOT NULL,
Total_Mail_Items_MAX varchar2(256) NOT NULL,
Total_Mails_Size_MIN varchar2(256) NOT NULL,
Total_Mails_Size_MAX varchar2(256) NOT NULL,
Internal_emails_sent_MIN varchar2(256) NOT NULL,
Internal_emails_sent_MAX varchar2(256) NOT NULL,
Size_Intl_mailsent_MIN varchar2(256) NOT NULL,
Size_Intl_mailsent_MAX varchar2(256) NOT NULL,
Internal_emails_recvd_MIN varchar2(256) NOT NULL,
Internal_emails_recvd_MAX varchar2(256) NOT NULL,
Size_Intl_mailrecvd_MIN varchar2(256) NOT NULL,
Size_Intl_mailrecvd_MAX varchar2(256) NOT NULL,
External_emails_sent_MIN varchar2(256) NOT NULL,
External_emails_sent_MAX varchar2(256) NOT NULL,
Size_exrtl_mailsent_MIN varchar2(256) NOT NULL,
Size_exrtl_mailsent_MAX varchar2(256) NOT NULL,
External_emails_recvd_MIN varchar2(256) NOT NULL,
External_emails_recvd_MAX varchar2(256) NOT NULL,
Size_extl_mailrecvd_MIN varchar2(256) NOT NULL,
Size_extl_mailrecvd_MAX varchar2(256) NOT NULL,
Nonecnt_MIN varchar2(256) NOT NULL,
Nonecnt_MAX varchar2(256) NOT NULL,
Failedcnt_MIN varchar2(256) NOT NULL,
Failedcnt_MAX varchar2(256) NOT NULL,
Pendingcnt_MIN varchar2(256) NOT NULL,
Pendingcnt_MAX varchar2(256) NOT NULL,
Delvrycnt_MIN varchar2(256) NOT NULL,
Delvrycnt_MAX varchar2(256) NOT NULL,
Expandcnt_MIN varchar2(256) NOT NULL,
Expandcnt_MAX varchar2(256) NOT NULL,
Unq_outbud_doms_MIN varchar2(256) NOT NULL,
Unq_outbud_doms_MAX varchar2(256) NOT NULL,
Unq_innbud_doms_MIN varchar2(256) NOT NULL,
Unq_innbud_doms_MAX varchar2(256) NOT NULL,
Resloved_MIN varchar2(256) NOT NULL,
Resloved_MAX varchar2(256) NOT NULL,
Filtered_as_spam_MIN varchar2(256) NOT NULL,
Filtered_as_spam_MAX varchar2(256) NOT NULL,
Getting_status_MIN varchar2(256) NOT NULL,
Getting_status_MAX varchar2(256) NOT NULL,
Quarantined_MIN varchar2(256) NOT NULL,
Quarantined_MAX varchar2(256) NOT NULL,
Unknown_MIN varchar2(256) NOT NULL,
Unknown_MAX varchar2(256) NOT NULL);
ALTER TABLE EXOMailTrfcStatisTest_THRESH ADD constraint PK_EXOMalTrfcStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMalTrfStatTest_THRESH ON EXOMailTrfcStatisTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailTrfcStatisTest ON EXOMailTrfcStatisTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailTrfcStatisTest ON EXOMailTrfcStatisTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOUserMAPIConTest CASCADE CONSTRAINTS;
CREATE TABLE EXOUserMAPIConTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Status Number(20,4) NOT NULL,
Status_ST varchar2(32) NOT NULL,
Connect_time Number(20,4) NOT NULL,
Connect_time_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOUserMAPIConTest ON EXOUserMAPIConTest(MSMT_TIME);
ALTER TABLE EXOUserMAPIConTest ADD constraint PK_EXOUserMAPIConTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOUserMAPIConTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOUserMAPIConTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Status_MIN Number(20,4) NOT NULL,
Status_MAX Number(20,4) NOT NULL,
Status_STCNT varchar2(32) NOT NULL,
Connect_time_MIN Number(20,4) NOT NULL,
Connect_time_MAX Number(20,4) NOT NULL,
Connect_time_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOUserMAPIConTest_TREND ADD constraint PK_EXOUserMAPIConTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOUserMAPIConTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOUserMAPIConTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Status_MIN varchar2(256) NOT NULL,
Status_MAX varchar2(256) NOT NULL,
Connect_time_MIN varchar2(256) NOT NULL,
Connect_time_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOUserMAPIConTest_THRESH ADD constraint PK_EXOUserMAPIConTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOUserMAPIConTest_THRESH ON EXOUserMAPIConTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOUserMAPIConTest ON EXOUserMAPIConTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOUserMAPIConTest ON EXOUserMAPIConTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXODevicConTest CASCADE CONSTRAINTS;
CREATE TABLE EXODevicConTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
Unique_device_types Number(20,4) NOT NULL,
Unique_device_types_ST varchar2(32) NOT NULL,
Unique_OS Number(20,4) NOT NULL,
Unique_OS_ST varchar2(32) NOT NULL,
Unique_clients Number(20,4) NOT NULL,
Unique_clients_ST varchar2(32) NOT NULL,
Unique_dev_OS_lang Number(20,4) NOT NULL,
Unique_dev_OS_lang_ST varchar2(32) NOT NULL,
Synchronized_devices Number(20,4) NOT NULL,
Synchronized_devices_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXODevicConTest ON EXODevicConTest(MSMT_TIME);
ALTER TABLE EXODevicConTest ADD constraint PK_EXODevicConTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXODevicConTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXODevicConTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
Unique_device_types_MIN Number(20,4) NOT NULL,
Unique_device_types_MAX Number(20,4) NOT NULL,
Unique_device_types_STCNT varchar2(32) NOT NULL,
Unique_OS_MIN Number(20,4) NOT NULL,
Unique_OS_MAX Number(20,4) NOT NULL,
Unique_OS_STCNT varchar2(32) NOT NULL,
Unique_clients_MIN Number(20,4) NOT NULL,
Unique_clients_MAX Number(20,4) NOT NULL,
Unique_clients_STCNT varchar2(32) NOT NULL,
Unique_dev_OS_lang_MIN Number(20,4) NOT NULL,
Unique_dev_OS_lang_MAX Number(20,4) NOT NULL,
Unique_dev_OS_lang_STCNT varchar2(32) NOT NULL,
Synchronized_devices_MIN Number(20,4) NOT NULL,
Synchronized_devices_MAX Number(20,4) NOT NULL,
Synchronized_devices_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXODevicConTest_TREND ADD constraint PK_EXODevicConTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXODevicConTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXODevicConTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Unique_user_agents_MIN varchar2(256) NOT NULL,
Unique_user_agents_MAX varchar2(256) NOT NULL,
Unique_device_types_MIN varchar2(256) NOT NULL,
Unique_device_types_MAX varchar2(256) NOT NULL,
Unique_OS_MIN varchar2(256) NOT NULL,
Unique_OS_MAX varchar2(256) NOT NULL,
Unique_clients_MIN varchar2(256) NOT NULL,
Unique_clients_MAX varchar2(256) NOT NULL,
Unique_dev_OS_lang_MIN varchar2(256) NOT NULL,
Unique_dev_OS_lang_MAX varchar2(256) NOT NULL,
Synchronized_devices_MIN varchar2(256) NOT NULL,
Synchronized_devices_MAX varchar2(256) NOT NULL);

ALTER TABLE EXODevicConTest_THRESH ADD constraint PK_EXODevicConTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXODevicConTest_THRESH ON EXODevicConTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXODevicConTest ON EXODevicConTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXODevicConTest ON EXODevicConTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE EXOSrvcHlhTest CASCADE CONSTRAINTS;
CREATE TABLE EXOSrvcHlhTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
SERVICE_INCIDENTS Number(20,4) NOT NULL,
SERVICE_INCIDENTS_ST varchar2(32) NOT NULL,
MAINTENANCE_EVENTS Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_ST varchar2(32) NOT NULL,
SERVICE_STATUS Number(20,4) NOT NULL,
SERVICE_STATUS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOSrvcHlhTest ON EXOSrvcHlhTest(MSMT_TIME);
ALTER TABLE EXOSrvcHlhTest ADD constraint PK_EXOSrvcHlhTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOSrvcHlhTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOSrvcHlhTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
SERVICE_INCIDENTS_MIN Number(20,4) NOT NULL,
SERVICE_INCIDENTS_MAX Number(20,4) NOT NULL,
SERVICE_INCIDENTS_STCNT varchar2(32) NOT NULL,
MAINTENANCE_EVENTS_MIN Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_MAX Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_STCNT varchar2(32) NOT NULL,
SERVICE_STATUS_MIN Number(20,4) NOT NULL,
SERVICE_STATUS_MAX Number(20,4) NOT NULL,
SERVICE_STATUS_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOSrvcHlhTest_TREND ADD constraint PK_EXOSrvcHlhTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOSrvcHlhTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOSrvcHlhTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
SERVICE_INCIDENTS_MIN varchar2(256) NOT NULL,
SERVICE_INCIDENTS_MAX varchar2(256) NOT NULL,
MAINTENANCE_EVENTS_MIN varchar2(256) NOT NULL,
MAINTENANCE_EVENTS_MAX varchar2(256) NOT NULL,
SERVICE_STATUS_MIN varchar2(256) NOT NULL,
SERVICE_STATUS_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOSrvcHlhTest_THRESH ADD constraint PK_EXOSrvcHlhTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOSrvcHlhTest_THRESH ON EXOSrvcHlhTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOSrvcHlhTest ON EXOSrvcHlhTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOSrvcHlhTest ON EXOSrvcHlhTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE EXOLicenseTest CASCADE CONSTRAINTS;
CREATE TABLE EXOLicenseTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
NON_TRIAL_ENTITLEMENTS Number(20,4) NOT NULL,
NON_TRIAL_ENTITLEMENTS_ST varchar2(32) NOT NULL,
TRIAL_ENTITLEMENTS Number(20,4) NOT NULL,
TRIAL_ENTITLEMENTS_ST varchar2(32) NOT NULL,
ACTIVE_USERS Number(20,4) NOT NULL,
ACTIVE_USERS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOLicenseTest ON EXOLicenseTest(MSMT_TIME);
ALTER TABLE EXOLicenseTest ADD constraint PK_EXOLicenseTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOLicenseTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOLicenseTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
NON_TRIAL_ENTITLEMENTS_MIN Number(20,4) NOT NULL,
NON_TRIAL_ENTITLEMENTS_MAX Number(20,4) NOT NULL,
NON_TRIAL_ENTITLEMENTS_STCNT varchar2(32) NOT NULL,
TRIAL_ENTITLEMENTS_MIN Number(20,4) NOT NULL,
TRIAL_ENTITLEMENTS_MAX Number(20,4) NOT NULL,
TRIAL_ENTITLEMENTS_STCNT varchar2(32) NOT NULL,
ACTIVE_USERS_MIN Number(20,4) NOT NULL,
ACTIVE_USERS_MAX Number(20,4) NOT NULL,
ACTIVE_USERS_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOLicenseTest_TREND ADD constraint PK_EXOLicenseTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOLicenseTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOLicenseTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
NON_TRIAL_ENTITLEMENTS_MIN varchar2(256) NOT NULL,
NON_TRIAL_ENTITLEMENTS_MAX varchar2(256) NOT NULL,
TRIAL_ENTITLEMENTS_MIN varchar2(256) NOT NULL,
TRIAL_ENTITLEMENTS_MAX varchar2(256) NOT NULL,
ACTIVE_USERS_MIN varchar2(256) NOT NULL,
ACTIVE_USERS_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOLicenseTest_THRESH ADD constraint PK_EXOLicenseTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOLicenseTest_THRESH ON EXOLicenseTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOLicenseTest ON EXOLicenseTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOLicenseTest ON EXOLicenseTest_TREND (MSMT_TIME,PERIOD);







DROP TABLE EXOLoginTest CASCADE CONSTRAINTS;
CREATE TABLE EXOLoginTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
AUTHENTICATION_STATUS Number(20,4) NOT NULL,
AUTHENTICATION_STATUS_ST varchar2(32) NOT NULL,
AUTHENTICATION_TIME Number(20,4) NOT NULL,
AUTHENTICATION_TIME_ST varchar2(32) NOT NULL,
LOGIN_STATUS Number(20,4) NOT NULL,
LOGIN_STATUS_ST varchar2(32) NOT NULL,
LOGIN_TIME Number(20,4) NOT NULL,
LOGIN_TIME_ST varchar2(32) NOT NULL,
TOTAL_LOGIN_TIME Number(20,4) NOT NULL,
TOTAL_LOGIN_TIME_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOLoginTest ON EXOLoginTest(MSMT_TIME);
ALTER TABLE EXOLoginTest ADD constraint PK_EXOLoginTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOLoginTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOLoginTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
AUTHENTICATION_STATUS_MIN Number(20,4) NOT NULL,
AUTHENTICATION_STATUS_MAX Number(20,4) NOT NULL,
AUTHENTICATION_STATUS_STCNT varchar2(32) NOT NULL,
AUTHENTICATION_TIME_MIN Number(20,4) NOT NULL,
AUTHENTICATION_TIME_MAX Number(20,4) NOT NULL,
AUTHENTICATION_TIME_STCNT varchar2(32) NOT NULL,
LOGIN_STATUS_MIN Number(20,4) NOT NULL,
LOGIN_STATUS_MAX Number(20,4) NOT NULL,
LOGIN_STATUS_STCNT varchar2(32) NOT NULL,
LOGIN_TIME_MIN Number(20,4) NOT NULL,
LOGIN_TIME_MAX Number(20,4) NOT NULL,
LOGIN_TIME_STCNT varchar2(32) NOT NULL,
TOTAL_LOGIN_TIME_MIN Number(20,4) NOT NULL,
TOTAL_LOGIN_TIME_MAX Number(20,4) NOT NULL,
TOTAL_LOGIN_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOLoginTest_TREND ADD constraint PK_EXOLoginTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOLoginTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOLoginTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
AUTHENTICATION_STATUS_MIN varchar2(256) NOT NULL,
AUTHENTICATION_STATUS_MAX varchar2(256) NOT NULL,
AUTHENTICATION_TIME_MIN varchar2(256) NOT NULL,
AUTHENTICATION_TIME_MAX varchar2(256) NOT NULL,
LOGIN_STATUS_MIN varchar2(256) NOT NULL,
LOGIN_STATUS_MAX varchar2(256) NOT NULL,
LOGIN_TIME_MIN varchar2(256) NOT NULL,
LOGIN_TIME_MAX varchar2(256) NOT NULL,
TOTAL_LOGIN_TIME_MIN varchar2(256) NOT NULL,
TOTAL_LOGIN_TIME_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOLoginTest_THRESH ADD constraint PK_EXOLoginTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOLoginTest_THRESH ON EXOLoginTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOLoginTest ON EXOLoginTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOLoginTest ON EXOLoginTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXOAdminActTest CASCADE CONSTRAINTS;
CREATE TABLE EXOAdminActTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Total_Operations Number(20,4) NOT NULL,
Total_Operations_ST varchar2(32) NOT NULL,
Unique_Operations Number(20,4) NOT NULL,
Unique_Operations_ST varchar2(32) NOT NULL,
Unique_Users Number(20,4) NOT NULL,
Unique_Users_ST varchar2(32) NOT NULL,
Unique_ClientIP Number(20,4) NOT NULL,
Unique_ClientIP_ST varchar2(32) NOT NULL,
Ms_AdminOperation Number(20,4) NOT NULL,
Ms_AdminOperation_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOAdminActTest ON EXOAdminActTest(MSMT_TIME);
ALTER TABLE EXOAdminActTest ADD constraint PK_EXOAdminActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOAdminActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOAdminActTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Total_Operations_MIN Number(20,4) NOT NULL,
Total_Operations_MAX Number(20,4) NOT NULL,
Total_Operations_STCNT varchar2(32) NOT NULL,
Unique_Operations_MIN Number(20,4) NOT NULL,
Unique_Operations_MAX Number(20,4) NOT NULL,
Unique_Operations_STCNT varchar2(32) NOT NULL,
Unique_Users_MIN Number(20,4) NOT NULL,
Unique_Users_MAX Number(20,4) NOT NULL,
Unique_Users_STCNT varchar2(32) NOT NULL,
Unique_ClientIP_MIN Number(20,4) NOT NULL,
Unique_ClientIP_MAX Number(20,4) NOT NULL,
Unique_ClientIP_STCNT varchar2(32) NOT NULL,
Ms_AdminOperation_MIN Number(20,4) NOT NULL,
Ms_AdminOperation_MAX Number(20,4) NOT NULL,
Ms_AdminOperation_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOAdminActTest_TREND ADD constraint PK_EXOAdminActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOAdminActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOAdminActTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Total_Operations_MIN varchar2(256) NOT NULL,
Total_Operations_MAX varchar2(256) NOT NULL,
Unique_Operations_MIN varchar2(256) NOT NULL,
Unique_Operations_MAX varchar2(256) NOT NULL,
Unique_Users_MIN varchar2(256) NOT NULL,
Unique_Users_MAX varchar2(256) NOT NULL,
Unique_ClientIP_MIN varchar2(256) NOT NULL,
Unique_ClientIP_MAX varchar2(256) NOT NULL,
Ms_AdminOperation_MIN varchar2(256) NOT NULL,
Ms_AdminOperation_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOAdminActTest_THRESH ADD constraint PK_EXOAdminActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOAdminActTest_THRESH ON EXOAdminActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOAdminActTest ON EXOAdminActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOAdminActTest ON EXOAdminActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOMailBoxLocTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxLocTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
TOT_DATCENT Number(20,4) NOT NULL,
TOT_DATCENT_ST varchar2(32) NOT NULL,
UNIQ_LOC Number(20,4) NOT NULL,
UNIQ_LOC_ST varchar2(32) NOT NULL,
UNIQ_USR_LOC Number(20,4) NOT NULL,
UNIQ_USR_LOC_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_EXOMailBoxLocTest ON EXOMailBoxLocTest(MSMT_TIME);
ALTER TABLE EXOMailBoxLocTest ADD constraint PK_EXOMailBoxLocTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailBoxLocTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxLocTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
TOT_DATCENT_MIN Number(20,4) NOT NULL,
TOT_DATCENT_MAX Number(20,4) NOT NULL,
TOT_DATCENT_STCNT varchar2(32) NOT NULL,
UNIQ_LOC_MIN Number(20,4) NOT NULL,
UNIQ_LOC_MAX Number(20,4) NOT NULL,
UNIQ_LOC_STCNT varchar2(32) NOT NULL,
UNIQ_USR_LOC_MIN Number(20,4) NOT NULL,
UNIQ_USR_LOC_MAX Number(20,4) NOT NULL,
UNIQ_USR_LOC_STCNT varchar2(32) NOT NULL);
ALTER TABLE EXOMailBoxLocTest_TREND ADD constraint PK_EXOMailBoxLocTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMailBoxLocTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxLocTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
TOT_DATCENT_MIN varchar2(256) NOT NULL,
TOT_DATCENT_MAX varchar2(256) NOT NULL,
UNIQ_LOC_MIN varchar2(256) NOT NULL,
UNIQ_LOC_MAX varchar2(256) NOT NULL,
UNIQ_USR_LOC_MIN varchar2(256) NOT NULL,
UNIQ_USR_LOC_MAX varchar2(256) NOT NULL);
ALTER TABLE EXOMailBoxLocTest_THRESH ADD constraint PK_EXOMailBoxLocTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMailBoxLocTest_THRESH ON EXOMailBoxLocTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailBoxLocTest ON EXOMailBoxLocTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailBoxLocTest ON EXOMailBoxLocTest_TREND (MSMT_TIME,PERIOD);






DROP TABLE EXOSpamTest CASCADE CONSTRAINTS;
CREATE TABLE EXOSpamTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
INBOUND_SPAM Number(20,4) NOT NULL,
INBOUND_SPAM_ST varchar2(32) NOT NULL,
OUTBOUND_SPAM Number(20,4) NOT NULL,
OUTBOUND_SPAM_ST varchar2(32) NOT NULL,
INBOUND_SIZE Number(20,4) NOT NULL,
INBOUND_SIZE_ST varchar2(32) NOT NULL,
OUTBOUND_SIZE Number(20,4) NOT NULL,
OUTBOUND_SIZE_ST varchar2(32) NOT NULL,
UNIQUE_SND Number(20,4) NOT NULL,
UNIQUE_SND_ST varchar2(32) NOT NULL,
UNIQUE_REC Number(20,4) NOT NULL,
UNIQUE_REC_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOSpamTest ON EXOSpamTest(MSMT_TIME);
ALTER TABLE EXOSpamTest ADD constraint PK_EXOSpamTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOSpamTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOSpamTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
INBOUND_SPAM_MIN Number(20,4) NOT NULL,
INBOUND_SPAM_MAX Number(20,4) NOT NULL,
INBOUND_SPAM_STCNT varchar2(32) NOT NULL,
OUTBOUND_SPAM_MIN Number(20,4) NOT NULL,
OUTBOUND_SPAM_MAX Number(20,4) NOT NULL,
OUTBOUND_SPAM_STCNT varchar2(32) NOT NULL,
INBOUND_SIZE_MIN Number(20,4) NOT NULL,
INBOUND_SIZE_MAX Number(20,4) NOT NULL,
INBOUND_SIZE_STCNT varchar2(32) NOT NULL,
OUTBOUND_SIZE_MIN Number(20,4) NOT NULL,
OUTBOUND_SIZE_MAX Number(20,4) NOT NULL,
OUTBOUND_SIZE_STCNT varchar2(32) NOT NULL,
UNIQUE_SND_MIN Number(20,4) NOT NULL,
UNIQUE_SND_MAX Number(20,4) NOT NULL,
UNIQUE_SND_STCNT varchar2(32) NOT NULL,
UNIQUE_REC_MIN Number(20,4) NOT NULL,
UNIQUE_REC_MAX Number(20,4) NOT NULL,
UNIQUE_REC_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOSpamTest_TREND ADD constraint PK_EXOSpamTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOSpamTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOSpamTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
INBOUND_SPAM_MIN varchar2(256) NOT NULL,
INBOUND_SPAM_MAX varchar2(256) NOT NULL,
OUTBOUND_SPAM_MIN varchar2(256) NOT NULL,
OUTBOUND_SPAM_MAX varchar2(256) NOT NULL,
INBOUND_SIZE_MIN varchar2(256) NOT NULL,
INBOUND_SIZE_MAX varchar2(256) NOT NULL,
OUTBOUND_SIZE_MIN varchar2(256) NOT NULL,
OUTBOUND_SIZE_MAX varchar2(256) NOT NULL,
UNIQUE_SND_MIN varchar2(256) NOT NULL,
UNIQUE_SND_MAX varchar2(256) NOT NULL,
UNIQUE_REC_MIN varchar2(256) NOT NULL,
UNIQUE_REC_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOSpamTest_THRESH ADD constraint PK_EXOSpamTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOSpamTest_THRESH ON EXOSpamTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOSpamTest ON EXOSpamTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOSpamTest ON EXOSpamTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXOMalwareTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMalwareTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Inbound_malware Number(20,4) NOT NULL,
Inbound_malware_ST varchar2(32) NOT NULL,
Outbound_malware Number(20,4) NOT NULL,
Outbound_malware_ST varchar2(32) NOT NULL,
INBOUND_SIZE Number(20,4) NOT NULL,
INBOUND_SIZE_ST varchar2(32) NOT NULL,
OUTBOUND_SIZE Number(20,4) NOT NULL,
OUTBOUND_SIZE_ST varchar2(32) NOT NULL,
UNIQUE_SND Number(20,4) NOT NULL,
UNIQUE_SND_ST varchar2(32) NOT NULL,
UNIQUE_REC Number(20,4) NOT NULL,
UNIQUE_REC_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOMalwareTest ON EXOMalwareTest(MSMT_TIME);
ALTER TABLE EXOMalwareTest ADD constraint PK_EXOMalwareTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMalwareTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMalwareTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Inbound_malware_MIN Number(20,4) NOT NULL,
Inbound_malware_MAX Number(20,4) NOT NULL,
Inbound_malware_STCNT varchar2(32) NOT NULL,
Outbound_malware_MIN Number(20,4) NOT NULL,
Outbound_malware_MAX Number(20,4) NOT NULL,
Outbound_malware_STCNT varchar2(32) NOT NULL,
INBOUND_SIZE_MIN Number(20,4) NOT NULL,
INBOUND_SIZE_MAX Number(20,4) NOT NULL,
INBOUND_SIZE_STCNT varchar2(32) NOT NULL,
OUTBOUND_SIZE_MIN Number(20,4) NOT NULL,
OUTBOUND_SIZE_MAX Number(20,4) NOT NULL,
OUTBOUND_SIZE_STCNT varchar2(32) NOT NULL,
UNIQUE_SND_MIN Number(20,4) NOT NULL,
UNIQUE_SND_MAX Number(20,4) NOT NULL,
UNIQUE_SND_STCNT varchar2(32) NOT NULL,
UNIQUE_REC_MIN Number(20,4) NOT NULL,
UNIQUE_REC_MAX Number(20,4) NOT NULL,
UNIQUE_REC_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOMalwareTest_TREND ADD constraint PK_EXOMalwareTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMalwareTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMalwareTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Inbound_malware_MIN varchar2(256) NOT NULL,
Inbound_malware_MAX varchar2(256) NOT NULL,
Outbound_malware_MIN varchar2(256) NOT NULL,
Outbound_malware_MAX varchar2(256) NOT NULL,
INBOUND_SIZE_MIN varchar2(256) NOT NULL,
INBOUND_SIZE_MAX varchar2(256) NOT NULL,
OUTBOUND_SIZE_MIN varchar2(256) NOT NULL,
OUTBOUND_SIZE_MAX varchar2(256) NOT NULL,
UNIQUE_SND_MIN varchar2(256) NOT NULL,
UNIQUE_SND_MAX varchar2(256) NOT NULL,
UNIQUE_REC_MIN varchar2(256) NOT NULL,
UNIQUE_REC_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOMalwareTest_THRESH ADD constraint PK_EXOMalwareTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMalwareTest_THRESH ON EXOMalwareTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMalwareTest ON EXOMalwareTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMalwareTest ON EXOMalwareTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOTranRuleTest CASCADE CONSTRAINTS;
CREATE TABLE EXOTranRuleTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
TOTAL_HIT Number(20,4) NOT NULL,
TOTAL_HIT_ST varchar2(32) NOT NULL,
INBOUND_RULE Number(20,4) NOT NULL,
INBOUND_RULE_ST varchar2(32) NOT NULL,
OUTBOUND_RULE Number(20,4) NOT NULL,
OUTBOUND_RULE_ST varchar2(32) NOT NULL,
UNIQUE_SENDERS Number(20,4) NOT NULL,
UNIQUE_SENDERS_ST varchar2(32) NOT NULL,
UNIQUE_RECEIVERS Number(20,4) NOT NULL,
UNIQUE_RECEIVERS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOTranRuleTest ON EXOTranRuleTest(MSMT_TIME);
ALTER TABLE EXOTranRuleTest ADD constraint PK_EXOTranRuleTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOTranRuleTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOTranRuleTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
TOTAL_HIT_MIN Number(20,4) NOT NULL,
TOTAL_HIT_MAX Number(20,4) NOT NULL,
TOTAL_HIT_STCNT varchar2(32) NOT NULL,
INBOUND_RULE_MIN Number(20,4) NOT NULL,
INBOUND_RULE_MAX Number(20,4) NOT NULL,
INBOUND_RULE_STCNT varchar2(32) NOT NULL,
OUTBOUND_RULE_MIN Number(20,4) NOT NULL,
OUTBOUND_RULE_MAX Number(20,4) NOT NULL,
OUTBOUND_RULE_STCNT varchar2(32) NOT NULL,
UNIQUE_SENDERS_MIN Number(20,4) NOT NULL,
UNIQUE_SENDERS_MAX Number(20,4) NOT NULL,
UNIQUE_SENDERS_STCNT varchar2(32) NOT NULL,
UNIQUE_RECEIVERS_MIN Number(20,4) NOT NULL,
UNIQUE_RECEIVERS_MAX Number(20,4) NOT NULL,
UNIQUE_RECEIVERS_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOTranRuleTest_TREND ADD constraint PK_EXOTranRuleTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOTranRuleTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOTranRuleTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
TOTAL_HIT_MIN varchar2(256) NOT NULL,
TOTAL_HIT_MAX varchar2(256) NOT NULL,
INBOUND_RULE_MIN varchar2(256) NOT NULL,
INBOUND_RULE_MAX varchar2(256) NOT NULL,
OUTBOUND_RULE_MIN varchar2(256) NOT NULL,
OUTBOUND_RULE_MAX varchar2(256) NOT NULL,
UNIQUE_SENDERS_MIN varchar2(256) NOT NULL,
UNIQUE_SENDERS_MAX varchar2(256) NOT NULL,
UNIQUE_RECEIVERS_MIN varchar2(256) NOT NULL,
UNIQUE_RECEIVERS_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOTranRuleTest_THRESH ADD constraint PK_EXOTranRuleTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOTranRuleTest_THRESH ON EXOTranRuleTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOTranRuleTest ON EXOTranRuleTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOTranRuleTest ON EXOTranRuleTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE EXODlpTest CASCADE CONSTRAINTS;
CREATE TABLE EXODlpTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
DLP_DETECT Number(20,4) NOT NULL,
DLP_DETECT_ST varchar2(32) NOT NULL,
UNIQUE_SENDERS Number(20,4) NOT NULL,
UNIQUE_SENDERS_ST varchar2(32) NOT NULL,
UNIQUE_RECEIVER Number(20,4) NOT NULL,
UNIQUE_RECEIVER_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXODlpTest ON EXODlpTest(MSMT_TIME);
ALTER TABLE EXODlpTest ADD constraint PK_EXODlpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXODlpTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXODlpTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
DLP_DETECT_MIN Number(20,4) NOT NULL,
DLP_DETECT_MAX Number(20,4) NOT NULL,
DLP_DETECT_STCNT varchar2(32) NOT NULL,
UNIQUE_SENDERS_MIN Number(20,4) NOT NULL,
UNIQUE_SENDERS_MAX Number(20,4) NOT NULL,
UNIQUE_SENDERS_STCNT varchar2(32) NOT NULL,
UNIQUE_RECEIVER_MIN Number(20,4) NOT NULL,
UNIQUE_RECEIVER_MAX Number(20,4) NOT NULL,
UNIQUE_RECEIVER_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXODlpTest_TREND ADD constraint PK_EXODlpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXODlpTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXODlpTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
DLP_DETECT_MIN varchar2(256) NOT NULL,
DLP_DETECT_MAX varchar2(256) NOT NULL,
UNIQUE_SENDERS_MIN varchar2(256) NOT NULL,
UNIQUE_SENDERS_MAX varchar2(256) NOT NULL,
UNIQUE_RECEIVER_MIN varchar2(256) NOT NULL,
UNIQUE_RECEIVER_MAX varchar2(256) NOT NULL);

ALTER TABLE EXODlpTest_THRESH ADD constraint PK_EXODlpTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXODlpTest_THRESH ON EXODlpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXODlpTest ON EXODlpTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXODlpTest ON EXODlpTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXONonOwnerActivtsTest CASCADE CONSTRAINTS;
CREATE TABLE EXONonOwnerActivtsTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Total_Operations Number(20,4) NOT NULL,
Total_Operations_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXONonOwnerActivtsTest ON EXONonOwnerActivtsTest(MSMT_TIME);
ALTER TABLE EXONonOwnerActivtsTest ADD constraint PK_EXONonOwnerActivtsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXONonOwnerActivtsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXONonOwnerActivtsTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Total_Operations_MIN Number(20,4) NOT NULL,
Total_Operations_MAX Number(20,4) NOT NULL,
Total_Operations_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXONonOwnerActivtsTest_TREND ADD constraint PK_EXONonOwnerActiTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXONonOwnerActivtsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXONonOwnerActivtsTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Total_Operations_MIN varchar2(256) NOT NULL,
Total_Operations_MAX varchar2(256) NOT NULL);

ALTER TABLE EXONonOwnerActivtsTest_THRESH ADD constraint PK_EXONonOwnerActiTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXONonOwnerActiTest_THRESH ON EXONonOwnerActivtsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXONonOwnerActivtsTest ON EXONonOwnerActivtsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXONonOwnerActivtsTest ON EXONonOwnerActivtsTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXOownerActivtsTest CASCADE CONSTRAINTS;
CREATE TABLE EXOownerActivtsTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Total_Operations Number(20,4) NOT NULL,
Total_Operations_ST varchar2(32) NOT NULL,
Unique_Users Number(20,4) NOT NULL,
Unique_Users_ST varchar2(32) NOT NULL,
Unique_Client_IPs Number(20,4) NOT NULL,
Unique_Client_IPs_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOownerActivtsTest ON EXOownerActivtsTest(MSMT_TIME);
ALTER TABLE EXOownerActivtsTest ADD constraint PK_EXOownerActivtsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOownerActivtsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOownerActivtsTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Total_Operations_MIN Number(20,4) NOT NULL,
Total_Operations_MAX Number(20,4) NOT NULL,
Total_Operations_STCNT varchar2(32) NOT NULL,
Unique_Users_MIN Number(20,4) NOT NULL,
Unique_Users_MAX Number(20,4) NOT NULL,
Unique_Users_STCNT varchar2(32) NOT NULL,
Unique_Client_IPs_MIN Number(20,4) NOT NULL,
Unique_Client_IPs_MAX Number(20,4) NOT NULL,
Unique_Client_IPs_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOownerActivtsTest_TREND ADD constraint PK_EXOownerActivtsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOownerActivtsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOownerActivtsTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Total_Operations_MIN varchar2(256) NOT NULL,
Total_Operations_MAX varchar2(256) NOT NULL,
Unique_Users_MIN varchar2(256) NOT NULL,
Unique_Users_MAX varchar2(256) NOT NULL,
Unique_Client_IPs_MIN varchar2(256) NOT NULL,
Unique_Client_IPs_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOownerActivtsTest_THRESH ADD constraint PK_EXOownerActivtsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOownerActivtsTest_THRESH ON EXOownerActivtsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOownerActivtsTest ON EXOownerActivtsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOownerActivtsTest ON EXOownerActivtsTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE EXOMsgCenTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMsgCenTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
MsgCenterCommunication Number(20,4) NOT NULL,
MsgCenterCommunication_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOMsgCenTest ON EXOMsgCenTest(MSMT_TIME);
ALTER TABLE EXOMsgCenTest ADD constraint PK_EXOMsgCenTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMsgCenTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMsgCenTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
MsgCenterCommunication_MIN Number(20,4) NOT NULL,
MsgCenterCommunication_MAX Number(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOMsgCenTest_TREND ADD constraint PK_EXOMsgCenTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMsgCenTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMsgCenTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
MsgCenterCommunication_MIN varchar2(256) NOT NULL,
MsgCenterCommunication_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOMsgCenTest_THRESH ADD constraint PK_EXOMsgCenTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMsgCenTest_THRESH ON EXOMsgCenTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMsgCenTest ON EXOMsgCenTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMsgCenTest ON EXOMsgCenTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE AsSysDBBkUpTest CASCADE CONSTRAINTS;
CREATE TABLE AsSysDBBkUpTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
BKUP Number(20,4) NOT NULL,
BKUP_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_AsSysDBBkUpTest ON AsSysDBBkUpTest(MSMT_TIME);
ALTER TABLE AsSysDBBkUpTest ADD constraint PK_AsSysDBBkUpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AsSysDBBkUpTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE AsSysDBBkUpTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
BKUP_MIN Number(20,4) NOT NULL,
BKUP_MAX Number(20,4) NOT NULL,
BKUP_STCNT varchar2(32) NOT NULL);

ALTER TABLE AsSysDBBkUpTest_TREND ADD constraint PK_AsSysDBBkUpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AsSysDBBkUpTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AsSysDBBkUpTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
BKUP_MIN VARCHAR2(256) NOT NULL,
BKUP_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AsSysDBBkUpTest_THRESH ADD constraint PK_AsSysDBBkUpTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AsSysDBBkUpTest_THRESH ON AsSysDBBkUpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AsSysDBBkUpTest ON AsSysDBBkUpTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AsSysDBBkUpTest ON AsSysDBBkUpTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE AsSysDBSpaTest CASCADE CONSTRAINTS;
CREATE TABLE AsSysDBSpaTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
USED_SPACE Number(20,4) NOT NULL,
USED_SPACE_ST varchar2(32) NOT NULL,
FREE_SPACE Number(20,4) NOT NULL,
FREE_SPACE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_AsSysDBSpaTest ON AsSysDBSpaTest(MSMT_TIME);
ALTER TABLE AsSysDBSpaTest ADD constraint PK_AsSysDBSpaTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AsSysDBSpaTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE AsSysDBSpaTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
USED_SPACE_MIN Number(20,4) NOT NULL,
USED_SPACE_MAX Number(20,4) NOT NULL,
USED_SPACE_STCNT varchar2(32) NOT NULL,
FREE_SPACE_MIN Number(20,4) NOT NULL,
FREE_SPACE_MAX Number(20,4) NOT NULL,
FREE_SPACE_STCNT varchar2(32) NOT NULL);

ALTER TABLE AsSysDBSpaTest_TREND ADD constraint PK_AsSysDBSpaTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AsSysDBSpaTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AsSysDBSpaTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
USED_SPACE_MIN VARCHAR2(256) NOT NULL,
USED_SPACE_MAX VARCHAR2(256) NOT NULL,
FREE_SPACE_MIN VARCHAR2(256) NOT NULL,
FREE_SPACE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AsSysDBSpaTest_THRESH ADD constraint PK_AsSysDBSpaTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AsSysDBSpaTest_THRESH ON AsSysDBSpaTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AsSysDBSpaTest ON AsSysDBSpaTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AsSysDBSpaTest ON AsSysDBSpaTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE XMAppLaunchTest CASCADE CONSTRAINTS;
CREATE TABLE XMAppLaunchTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
SUCCESSFUL_APPLICATION NUMBER(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_ST varchar2(32) NOT NULL,
FAILED_APPLICATION NUMBER(20,4) NOT NULL,
FAILED_APPLICATION_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_XMAppLaunchTest ON XMAppLaunchTest(MSMT_TIME);
ALTER TABLE XMAppLaunchTest ADD constraint PK_XMAppLaunchTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE XMAppLaunchTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE XMAppLaunchTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
SUCCESSFUL_APPLICATION_MIN NUMBER(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_MAX NUMBER(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_STCNT varchar2(32) NOT NULL,
FAILED_APPLICATION_MIN NUMBER(20,4) NOT NULL,
FAILED_APPLICATION_MAX NUMBER(20,4) NOT NULL,
FAILED_APPLICATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE XMAppLaunchTest_TREND ADD constraint PK_XMAppLaunchTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE XMAppLaunchTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE XMAppLaunchTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
SUCCESSFUL_APPLICATION_MIN varchar2(256) NOT NULL,
SUCCESSFUL_APPLICATION_MAX varchar2(256) NOT NULL,
FAILED_APPLICATION_MIN varchar2(256) NOT NULL,
FAILED_APPLICATION_MAX varchar2(256) NOT NULL);

ALTER TABLE XMAppLaunchTest_THRESH ADD constraint PK_XMAppLaunchTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_XMAppLaunchTest_THRESH ON XMAppLaunchTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_XMAppLaunchTest ON XMAppLaunchTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_XMAppLaunchTest ON XMAppLaunchTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE XMAppNameTest CASCADE CONSTRAINTS;
CREATE TABLE XMAppNameTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
SUCCESSFUL_APPLICATION NUMBER(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_ST varchar2(32) NOT NULL,
FAILED_APPLICATION NUMBER(20,4) NOT NULL,
FAILED_APPLICATION_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_XMAppNameTest ON XMAppNameTest(MSMT_TIME);
ALTER TABLE XMAppNameTest ADD constraint PK_XMAppNameTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE XMAppNameTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE XMAppNameTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
SUCCESSFUL_APPLICATION_MIN NUMBER(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_MAX NUMBER(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_STCNT varchar2(32) NOT NULL,
FAILED_APPLICATION_MIN NUMBER(20,4) NOT NULL,
FAILED_APPLICATION_MAX NUMBER(20,4) NOT NULL,
FAILED_APPLICATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE XMAppNameTest_TREND ADD constraint PK_XMAppNameTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE XMAppNameTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE XMAppNameTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
SUCCESSFUL_APPLICATION_MIN varchar2(256) NOT NULL,
SUCCESSFUL_APPLICATION_MAX varchar2(256) NOT NULL,
FAILED_APPLICATION_MIN varchar2(256) NOT NULL,
FAILED_APPLICATION_MAX varchar2(256) NOT NULL);

ALTER TABLE XMAppNameTest_THRESH ADD constraint PK_XMAppNameTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_XMAppNameTest_THRESH ON XMAppNameTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_XMAppNameTest ON XMAppNameTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_XMAppNameTest ON XMAppNameTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SapWasUserSessTest CASCADE CONSTRAINTS;
CREATE TABLE SapWasUserSessTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32),
	MSMT_TIME 			date,
	LoggedInUsers			NUMBER(20,4) NOT NULL,
	LoggedInUsers_ST			varchar2(32) NOT NULL,
	OpenedSessions			NUMBER(20,4) NOT NULL,
	OpenedSessions_ST			varchar2(32) NOT NULL,
	ActiveSessions			NUMBER(20,4) NOT NULL,
	ActiveSessions_ST			varchar2(32) NOT NULL,
	SecuritySessions			NUMBER(20,4) NOT NULL,
	SecuritySessions_ST			varchar2(32) NOT NULL,
	EjbSessions			NUMBER(20,4) NOT NULL,
	EjbSessions_ST			varchar2(32) NOT NULL
);
CREATE INDEX IDX_SapWasUserSessTest ON SapWasUserSessTest(MSMT_TIME);
ALTER TABLE SapWasUserSessTest ADD constraint PK_SapWasUserSessTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE   SapWasUserSessTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SapWasUserSessTest_TREND
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	LoggedInUsers_MIN			NUMBER(20,4) NOT NULL,
	LoggedInUsers_MAX			NUMBER(20,4) NOT NULL,
	LoggedInUsers_STCNT			varchar2(32) NOT NULL,
	OpenedSessions_MIN			NUMBER(20,4) NOT NULL,
	OpenedSessions_MAX			NUMBER(20,4) NOT NULL,
	OpenedSessions_STCNT			varchar2(32) NOT NULL,
	ActiveSessions_MIN			NUMBER(20,4) NOT NULL,
	ActiveSessions_MAX			NUMBER(20,4) NOT NULL,
	ActiveSessions_STCNT			varchar2(32) NOT NULL,
	SecuritySessions_MIN			NUMBER(20,4) NOT NULL,
	SecuritySessions_MAX			NUMBER(20,4) NOT NULL,
	SecuritySessions_STCNT			varchar2(32) NOT NULL,
	EjbSessions_MIN			NUMBER(20,4) NOT NULL,
	EjbSessions_MAX			NUMBER(20,4) NOT NULL,
	EjbSessions_STCNT			varchar2(32) NOT NULL
);
ALTER TABLE SapWasUserSessTest_TREND ADD constraint PK_SapWasUserSessTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
DROP TABLE   SapWasUserSessTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SapWasUserSessTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32),
	MSMT_TIME_START			date,
	MSMT_TIME_END   		date,
	LoggedInUsers_MIN			VARCHAR2(256)	 NOT NULL,
	LoggedInUsers_MAX	VARCHAR2(256)	 NOT NULL,
	OpenedSessions_MIN			VARCHAR2(256)	 NOT NULL,
	OpenedSessions_MAX	VARCHAR2(256)	 NOT NULL,
	ActiveSessions_MIN			VARCHAR2(256)	 NOT NULL,
	ActiveSessions_MAX	VARCHAR2(256)	 NOT NULL,
	SecuritySessions_MIN			VARCHAR2(256)	 NOT NULL,
	SecuritySessions_MAX	VARCHAR2(256)	 NOT NULL,
	EjbSessions_MIN			VARCHAR2(256)	 NOT NULL,
	EjbSessions_MAX	VARCHAR2(256)	 NOT NULL
);
ALTER TABLE SapWasUserSessTest_THRESH ADD constraint PK_SapWasUserSessTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SapWasUserSessTest_THRESH ON SapWasUserSessTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SapWasUserSessTest ON SapWasUserSessTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SapWasUserSessTest ON SapWasUserSessTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HttpResponsesTest CASCADE CONSTRAINTS;
CREATE TABLE HttpResponsesTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
RESPONSES Number(20,4) NOT NULL,
RESPONSES_ST varchar2(32) NOT NULL,
RESPONSERATE Number(20,4) NOT NULL,
RESPONSERATE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_HttpResponsesTest ON HttpResponsesTest(MSMT_TIME);
ALTER TABLE HttpResponsesTest ADD constraint PK_HttpResponsesTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HttpResponsesTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HttpResponsesTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
RESPONSES_MIN Number(20,4) NOT NULL,
RESPONSES_MAX Number(20,4) NOT NULL,
RESPONSES_STCNT varchar2(32) NOT NULL,
RESPONSERATE_MIN Number(20,4) NOT NULL,
RESPONSERATE_MAX Number(20,4) NOT NULL,
RESPONSERATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE HttpResponsesTest_TREND ADD constraint PK_HttpResponsesTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HttpResponsesTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HttpResponsesTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
RESPONSES_MIN VARCHAR2(256) NOT NULL,
RESPONSES_MAX VARCHAR2(256) NOT NULL,
RESPONSERATE_MIN VARCHAR2(256) NOT NULL,
RESPONSERATE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE HttpResponsesTest_THRESH ADD constraint PK_HttpResponsesTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HttpResponsesTest_THRESH ON HttpResponsesTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HttpResponsesTest ON HttpResponsesTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HttpResponsesTest ON HttpResponsesTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE AsAbapCenProcTest CASCADE CONSTRAINTS;
CREATE TABLE AsAbapCenProcTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Display_Status NUMBER(20,4) NOT NULL,
Display_Status_ST varchar2(32) NOT NULL,
Process_Status NUMBER(20,4) NOT NULL,
Process_Status_ST varchar2(32) NOT NULL,
is_Restarted NUMBER(20,4) NOT NULL,
is_Restarted_ST varchar2(32) NOT NULL,
Total_uptime NUMBER(20,4) NOT NULL,
Total_uptime_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_AsAbapCenProcTest ON AsAbapCenProcTest(MSMT_TIME);
ALTER TABLE AsAbapCenProcTest ADD constraint PK_AsAbapCenProcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AsAbapCenProcTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE AsAbapCenProcTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Display_Status_MIN NUMBER(20,4) NOT NULL,
Display_Status_MAX NUMBER(20,4) NOT NULL,
Display_Status_STCNT varchar2(32) NOT NULL,
Process_Status_MIN NUMBER(20,4) NOT NULL,
Process_Status_MAX NUMBER(20,4) NOT NULL,
Process_Status_STCNT varchar2(32) NOT NULL,
is_Restarted_MIN NUMBER(20,4) NOT NULL,
is_Restarted_MAX NUMBER(20,4) NOT NULL,
is_Restarted_STCNT varchar2(32) NOT NULL,
Total_uptime_MIN NUMBER(20,4) NOT NULL,
Total_uptime_MAX NUMBER(20,4) NOT NULL,
Total_uptime_STCNT varchar2(32) NOT NULL);

ALTER TABLE AsAbapCenProcTest_TREND ADD constraint PK_AsAbapCenProcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AsAbapCenProcTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AsAbapCenProcTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Display_Status_MIN varchar2(256) NOT NULL,
Display_Status_MAX varchar2(256) NOT NULL,
Process_Status_MIN varchar2(256) NOT NULL,
Process_Status_MAX varchar2(256) NOT NULL,
is_Restarted_MIN varchar2(256) NOT NULL,
is_Restarted_MAX varchar2(256) NOT NULL,
Total_uptime_MIN varchar2(256) NOT NULL,
Total_uptime_MAX varchar2(256) NOT NULL);

ALTER TABLE AsAbapCenProcTest_THRESH ADD constraint PK_AsAbapCenProcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AsAbapCenProcTest_THRESH ON AsAbapCenProcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AsAbapCenProcTest ON AsAbapCenProcTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AsAbapCenProcTest ON AsAbapCenProcTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SAPLocksTest CASCADE CONSTRAINTS;
CREATE TABLE SAPLocksTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32),
	MSMT_TIME 			date,
	exclusiveLocks			NUMBER(20,4) NOT NULL,
	exclusiveLocks_ST			varchar2(32) NOT NULL,
	exclNonCumLocks			NUMBER(20,4) NOT NULL,
	exclNonCumLocks_ST			varchar2(32) NOT NULL,
	otherLocks			NUMBER(20,4) NOT NULL,
	otherLocks_ST			varchar2(32) NOT NULL,
	allLocks			NUMBER(20,4) NOT NULL,
	allLocks_ST			varchar2(32) NOT NULL,
	maxLocks			NUMBER(20,4) NOT NULL,
	maxLocks_ST			varchar2(32) NOT NULL,
	currLockUtil			NUMBER(20,4) NOT NULL,
	currLockUtil_ST			varchar2(32) NOT NULL,
	highLocks			NUMBER(20,4) NOT NULL,
	highLocks_ST			varchar2(32) NOT NULL,
	highLockUtil			NUMBER(20,4) NOT NULL,
	highLockUtil_ST			varchar2(32) NOT NULL,
	currOwners			NUMBER(20,4) NOT NULL,
	currOwners_ST			varchar2(32) NOT NULL,
	currOwnerUtil			NUMBER(20,4) NOT NULL,
	currOwnerUtil_ST			varchar2(32) NOT NULL,
	currArgs			NUMBER(20,4) NOT NULL,
	currArgs_ST			varchar2(32) NOT NULL,
	currArgUtil			NUMBER(20,4) NOT NULL,
	currArgUtil_ST			varchar2(32) NOT NULL,
	enqReqs			NUMBER(20,4) NOT NULL,
	enqReqs_ST			varchar2(32) NOT NULL,
	enqReqRate			NUMBER(20,4) NOT NULL,
	enqReqRate_ST			varchar2(32) NOT NULL,
	enqReqRej			NUMBER(20,4) NOT NULL,
	enqReqRej_ST			varchar2(32) NOT NULL,
	enqReqRejRate			NUMBER(20,4) NOT NULL,
	enqReqRejRate_ST			varchar2(32) NOT NULL,
	pctEnqReqRej			NUMBER(20,4) NOT NULL,
	pctEnqReqRej_ST			varchar2(32) NOT NULL,
	enqErrs			NUMBER(20,4) NOT NULL,
	enqErrs_ST			varchar2(32) NOT NULL,
	enqErrRate			NUMBER(20,4) NOT NULL,
	enqErrRate_ST			varchar2(32) NOT NULL,
	deqReqs			NUMBER(20,4) NOT NULL,
	deqReqs_ST			varchar2(32) NOT NULL,
	deqReqRate			NUMBER(20,4) NOT NULL,
	deqReqRate_ST			varchar2(32) NOT NULL,
	deqErrs			NUMBER(20,4) NOT NULL,
	deqErrs_ST			varchar2(32) NOT NULL,
	deqErrRate			NUMBER(20,4) NOT NULL,
	deqErrRate_ST			varchar2(32) NOT NULL,
	UpdReqRate			NUMBER(20,4) NOT NULL,
	UpdReqRate_ST			varchar2(32) NOT NULL,
	lckTblTime			NUMBER(20,4) NOT NULL,
	lckTblTime_ST			varchar2(32) NOT NULL,
	lckTblWaitTime			NUMBER(20,4) NOT NULL,
	lckTblWaitTime_ST			varchar2(32) NOT NULL,
	lckSrvTime			NUMBER(20,4) NOT NULL,
	lckSrvTime_ST			varchar2(32) NOT NULL
);
ALTER TABLE SAPLocksTest ADD constraint PK_SAPLocksTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE   SAPLocksTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SAPLocksTest_TREND
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	exclusiveLocks_MIN			NUMBER(20,4) NOT NULL,
	exclusiveLocks_MAX			NUMBER(20,4) NOT NULL,
	exclusiveLocks_STCNT			varchar2(32) NOT NULL,
	exclNonCumLocks_MIN			NUMBER(20,4) NOT NULL,
	exclNonCumLocks_MAX			NUMBER(20,4) NOT NULL,
	exclNonCumLocks_STCNT			varchar2(32) NOT NULL,
	otherLocks_MIN			NUMBER(20,4) NOT NULL,
	otherLocks_MAX			NUMBER(20,4) NOT NULL,
	otherLocks_STCNT			varchar2(32) NOT NULL,
	allLocks_MIN			NUMBER(20,4) NOT NULL,
	allLocks_MAX			NUMBER(20,4) NOT NULL,
	allLocks_STCNT			varchar2(32) NOT NULL,
	maxLocks_MIN			NUMBER(20,4) NOT NULL,
	maxLocks_MAX			NUMBER(20,4) NOT NULL,
	maxLocks_STCNT			varchar2(32) NOT NULL,
	currLockUtil_MIN			NUMBER(20,4) NOT NULL,
	currLockUtil_MAX			NUMBER(20,4) NOT NULL,
	currLockUtil_STCNT			varchar2(32) NOT NULL,
	highLocks_MIN			NUMBER(20,4) NOT NULL,
	highLocks_MAX			NUMBER(20,4) NOT NULL,
	highLocks_STCNT			varchar2(32) NOT NULL,
	highLockUtil_MIN			NUMBER(20,4) NOT NULL,
	highLockUtil_MAX			NUMBER(20,4) NOT NULL,
	highLockUtil_STCNT			varchar2(32) NOT NULL,
	currOwners_MIN			NUMBER(20,4) NOT NULL,
	currOwners_MAX			NUMBER(20,4) NOT NULL,
	currOwners_STCNT			varchar2(32) NOT NULL,
	currOwnerUtil_MIN			NUMBER(20,4) NOT NULL,
	currOwnerUtil_MAX			NUMBER(20,4) NOT NULL,
	currOwnerUtil_STCNT			varchar2(32) NOT NULL,
	currArgs_MIN			NUMBER(20,4) NOT NULL,
	currArgs_MAX			NUMBER(20,4) NOT NULL,
	currArgs_STCNT			varchar2(32) NOT NULL,
	currArgUtil_MIN			NUMBER(20,4) NOT NULL,
	currArgUtil_MAX			NUMBER(20,4) NOT NULL,
	currArgUtil_STCNT			varchar2(32) NOT NULL,
	enqReqs_MIN			NUMBER(20,4) NOT NULL,
	enqReqs_MAX			NUMBER(20,4) NOT NULL,
	enqReqs_STCNT			varchar2(32) NOT NULL,
	enqReqRate_MIN			NUMBER(20,4) NOT NULL,
	enqReqRate_MAX			NUMBER(20,4) NOT NULL,
	enqReqRate_STCNT			varchar2(32) NOT NULL,
	enqReqRej_MIN			NUMBER(20,4) NOT NULL,
	enqReqRej_MAX			NUMBER(20,4) NOT NULL,
	enqReqRej_STCNT			varchar2(32) NOT NULL,
	enqReqRejRate_MIN			NUMBER(20,4) NOT NULL,
	enqReqRejRate_MAX			NUMBER(20,4) NOT NULL,
	enqReqRejRate_STCNT			varchar2(32) NOT NULL,
	pctEnqReqRej_MIN			NUMBER(20,4) NOT NULL,
	pctEnqReqRej_MAX			NUMBER(20,4) NOT NULL,
	pctEnqReqRej_STCNT			varchar2(32) NOT NULL,
	enqErrs_MIN			NUMBER(20,4) NOT NULL,
	enqErrs_MAX			NUMBER(20,4) NOT NULL,
	enqErrs_STCNT			varchar2(32) NOT NULL,
	enqErrRate_MIN			NUMBER(20,4) NOT NULL,
	enqErrRate_MAX			NUMBER(20,4) NOT NULL,
	enqErrRate_STCNT			varchar2(32) NOT NULL,
	deqReqs_MIN			NUMBER(20,4) NOT NULL,
	deqReqs_MAX			NUMBER(20,4) NOT NULL,
	deqReqs_STCNT			varchar2(32) NOT NULL,
	deqReqRate_MIN			NUMBER(20,4) NOT NULL,
	deqReqRate_MAX			NUMBER(20,4) NOT NULL,
	deqReqRate_STCNT			varchar2(32) NOT NULL,
	deqErrs_MIN			NUMBER(20,4) NOT NULL,
	deqErrs_MAX			NUMBER(20,4) NOT NULL,
	deqErrs_STCNT			varchar2(32) NOT NULL,
	deqErrRate_MIN			NUMBER(20,4) NOT NULL,
	deqErrRate_MAX			NUMBER(20,4) NOT NULL,
	deqErrRate_STCNT			varchar2(32) NOT NULL,
	UpdReqRate_MIN			NUMBER(20,4) NOT NULL,
	UpdReqRate_MAX			NUMBER(20,4) NOT NULL,
	UpdReqRate_STCNT			varchar2(32) NOT NULL,
	lckTblTime_MIN			NUMBER(20,4) NOT NULL,
	lckTblTime_MAX			NUMBER(20,4) NOT NULL,
	lckTblTime_STCNT			varchar2(32) NOT NULL,
	lckTblWaitTime_MIN			NUMBER(20,4) NOT NULL,
	lckTblWaitTime_MAX			NUMBER(20,4) NOT NULL,
	lckTblWaitTime_STCNT			varchar2(32) NOT NULL,
	lckSrvTime_MIN			NUMBER(20,4) NOT NULL,
	lckSrvTime_MAX			NUMBER(20,4) NOT NULL,
	lckSrvTime_STCNT			varchar2(32) NOT NULL
);
ALTER TABLE SAPLocksTest_TREND ADD constraint PK_SAPLocksTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
DROP TABLE   SAPLocksTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SAPLocksTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32),
	MSMT_TIME_START			date,
	MSMT_TIME_END   		date,
	exclusiveLocks_MIN			VARCHAR2(256)	 NOT NULL,
	exclusiveLocks_MAX	VARCHAR2(256)	 NOT NULL,
	exclNonCumLocks_MIN			VARCHAR2(256)	 NOT NULL,
	exclNonCumLocks_MAX	VARCHAR2(256)	 NOT NULL,
	otherLocks_MIN			VARCHAR2(256)	 NOT NULL,
	otherLocks_MAX	VARCHAR2(256)	 NOT NULL,
	allLocks_MIN			VARCHAR2(256)	 NOT NULL,
	allLocks_MAX	VARCHAR2(256)	 NOT NULL,
	maxLocks_MIN			VARCHAR2(256)	 NOT NULL,
	maxLocks_MAX	VARCHAR2(256)	 NOT NULL,
	currLockUtil_MIN			VARCHAR2(256)	 NOT NULL,
	currLockUtil_MAX	VARCHAR2(256)	 NOT NULL,
	highLocks_MIN			VARCHAR2(256)	 NOT NULL,
	highLocks_MAX	VARCHAR2(256)	 NOT NULL,
	highLockUtil_MIN			VARCHAR2(256)	 NOT NULL,
	highLockUtil_MAX	VARCHAR2(256)	 NOT NULL,
	currOwners_MIN			VARCHAR2(256)	 NOT NULL,
	currOwners_MAX	VARCHAR2(256)	 NOT NULL,
	currOwnerUtil_MIN			VARCHAR2(256)	 NOT NULL,
	currOwnerUtil_MAX	VARCHAR2(256)	 NOT NULL,
	currArgs_MIN			VARCHAR2(256)	 NOT NULL,
	currArgs_MAX	VARCHAR2(256)	 NOT NULL,
	currArgUtil_MIN			VARCHAR2(256)	 NOT NULL,
	currArgUtil_MAX	VARCHAR2(256)	 NOT NULL,
	enqReqs_MIN			VARCHAR2(256)	 NOT NULL,
	enqReqs_MAX	VARCHAR2(256)	 NOT NULL,
	enqReqRate_MIN			VARCHAR2(256)	 NOT NULL,
	enqReqRate_MAX	VARCHAR2(256)	 NOT NULL,
	enqReqRej_MIN			VARCHAR2(256)	 NOT NULL,
	enqReqRej_MAX	VARCHAR2(256)	 NOT NULL,
	enqReqRejRate_MIN			VARCHAR2(256)	 NOT NULL,
	enqReqRejRate_MAX	VARCHAR2(256)	 NOT NULL,
	pctEnqReqRej_MIN			VARCHAR2(256)	 NOT NULL,
	pctEnqReqRej_MAX	VARCHAR2(256)	 NOT NULL,
	enqErrs_MIN			VARCHAR2(256)	 NOT NULL,
	enqErrs_MAX	VARCHAR2(256)	 NOT NULL,
	enqErrRate_MIN			VARCHAR2(256)	 NOT NULL,
	enqErrRate_MAX	VARCHAR2(256)	 NOT NULL,
	deqReqs_MIN			VARCHAR2(256)	 NOT NULL,
	deqReqs_MAX	VARCHAR2(256)	 NOT NULL,
	deqReqRate_MIN			VARCHAR2(256)	 NOT NULL,
	deqReqRate_MAX	VARCHAR2(256)	 NOT NULL,
	deqErrs_MIN			VARCHAR2(256)	 NOT NULL,
	deqErrs_MAX	VARCHAR2(256)	 NOT NULL,
	deqErrRate_MIN			VARCHAR2(256)	 NOT NULL,
	deqErrRate_MAX	VARCHAR2(256)	 NOT NULL,
	UpdReqRate_MIN			VARCHAR2(256)	 NOT NULL,
	UpdReqRate_MAX	VARCHAR2(256)	 NOT NULL,
	lckTblTime_MIN			VARCHAR2(256)	 NOT NULL,
	lckTblTime_MAX	VARCHAR2(256)	 NOT NULL,
	lckTblWaitTime_MIN			VARCHAR2(256)	 NOT NULL,
	lckTblWaitTime_MAX	VARCHAR2(256)	 NOT NULL,
	lckSrvTime_MIN			VARCHAR2(256)	 NOT NULL,
	lckSrvTime_MAX	VARCHAR2(256)	 NOT NULL
);
ALTER TABLE SAPLocksTest_THRESH ADD constraint PK_SAPLocksTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SAPLocksTest_THRESH ON SAPLocksTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_SAPLOCKSTEST ON SAPLOCKSTEST (MSMT_TIME);
CREATE INDEX IDX_TR_SAPLOCKSTEST ON SAPLOCKSTEST_TREND (MSMT_TIME,PERIOD);
CREATE INDEX IDX_TH_SAPLOCKSTEST ON SAPLOCKSTEST_THRESH (MSMT_TIME_START);

DROP TABLE SAPICMTest CASCADE CONSTRAINTS;
CREATE TABLE SAPICMTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32),
	MSMT_TIME 			date,
	RUNTHRD			NUMBER(20,4) NOT NULL,
	RUNTHRD_ST			varchar2(32) NOT NULL,
	IDLTHRD			NUMBER(20,4) NOT NULL,
	IDLTHRD_ST			varchar2(32) NOT NULL,
	USDTHRD			NUMBER(20,4) NOT NULL,
	USDTHRD_ST			varchar2(32) NOT NULL,
	MAXTHRD			NUMBER(20,4) NOT NULL,
	MAXTHRD_ST			varchar2(32) NOT NULL,
	USDTHRDPCT			NUMBER(20,4) NOT NULL,
	USDTHRDPCT_ST			varchar2(32) NOT NULL,
	RUNTHRDPCT			NUMBER(20,4) NOT NULL,
	RUNTHRDPCT_ST			varchar2(32) NOT NULL,
	RUNCRTTHRDPCT			NUMBER(20,4) NOT NULL,
	RUNCRTTHRDPCT_ST			varchar2(32) NOT NULL,
	USDCONNS			NUMBER(20,4) NOT NULL,
	USDCONNS_ST			varchar2(32) NOT NULL,
	USDCONNSPCT			NUMBER(20,4) NOT NULL,
	USDCONNSPCT_ST			varchar2(32) NOT NULL,
	MAXCONNS			NUMBER(20,4) NOT NULL,
	MAXCONNS_ST			varchar2(32) NOT NULL,
	QUENOW			NUMBER(20,4) NOT NULL,
	QUENOW_ST			varchar2(32) NOT NULL,
	USDQUESPCT			NUMBER(20,4) NOT NULL,
	USDQUESPCT_ST			varchar2(32) NOT NULL,
	MAXQUES			NUMBER(20,4) NOT NULL,
	MAXQUES_ST			varchar2(32) NOT NULL
);
ALTER TABLE SAPICMTest ADD constraint PK_SAPICMTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE   SAPICMTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SAPICMTest_TREND
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	RUNTHRD_MIN			NUMBER(20,4) NOT NULL,
	RUNTHRD_MAX			NUMBER(20,4) NOT NULL,
	RUNTHRD_STCNT			varchar2(32) NOT NULL,
	IDLTHRD_MIN			NUMBER(20,4) NOT NULL,
	IDLTHRD_MAX			NUMBER(20,4) NOT NULL,
	IDLTHRD_STCNT			varchar2(32) NOT NULL,
	USDTHRD_MIN			NUMBER(20,4) NOT NULL,
	USDTHRD_MAX			NUMBER(20,4) NOT NULL,
	USDTHRD_STCNT			varchar2(32) NOT NULL,
	MAXTHRD_MIN			NUMBER(20,4) NOT NULL,
	MAXTHRD_MAX			NUMBER(20,4) NOT NULL,
	MAXTHRD_STCNT			varchar2(32) NOT NULL,
	USDTHRDPCT_MIN			NUMBER(20,4) NOT NULL,
	USDTHRDPCT_MAX			NUMBER(20,4) NOT NULL,
	USDTHRDPCT_STCNT			varchar2(32) NOT NULL,
	RUNTHRDPCT_MIN			NUMBER(20,4) NOT NULL,
	RUNTHRDPCT_MAX			NUMBER(20,4) NOT NULL,
	RUNTHRDPCT_STCNT			varchar2(32) NOT NULL,
	RUNCRTTHRDPCT_MIN			NUMBER(20,4) NOT NULL,
	RUNCRTTHRDPCT_MAX			NUMBER(20,4) NOT NULL,
	RUNCRTTHRDPCT_STCNT			varchar2(32) NOT NULL,
	USDCONNS_MIN			NUMBER(20,4) NOT NULL,
	USDCONNS_MAX			NUMBER(20,4) NOT NULL,
	USDCONNS_STCNT			varchar2(32) NOT NULL,
	USDCONNSPCT_MIN			NUMBER(20,4) NOT NULL,
	USDCONNSPCT_MAX			NUMBER(20,4) NOT NULL,
	USDCONNSPCT_STCNT			varchar2(32) NOT NULL,
	MAXCONNS_MIN			NUMBER(20,4) NOT NULL,
	MAXCONNS_MAX			NUMBER(20,4) NOT NULL,
	MAXCONNS_STCNT			varchar2(32) NOT NULL,
	QUENOW_MIN			NUMBER(20,4) NOT NULL,
	QUENOW_MAX			NUMBER(20,4) NOT NULL,
	QUENOW_STCNT			varchar2(32) NOT NULL,
	USDQUESPCT_MIN			NUMBER(20,4) NOT NULL,
	USDQUESPCT_MAX			NUMBER(20,4) NOT NULL,
	USDQUESPCT_STCNT			varchar2(32) NOT NULL,
	MAXQUES_MIN			NUMBER(20,4) NOT NULL,
	MAXQUES_MAX			NUMBER(20,4) NOT NULL,
	MAXQUES_STCNT			varchar2(32) NOT NULL
);
ALTER TABLE SAPICMTest_TREND ADD constraint PK_SAPICMTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
DROP TABLE   SAPICMTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SAPICMTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32),
	MSMT_TIME_START			date,
	MSMT_TIME_END   		date,
	RUNTHRD_MIN			VARCHAR2(256)	 NOT NULL,
	RUNTHRD_MAX	VARCHAR2(256)	 NOT NULL,
	IDLTHRD_MIN			VARCHAR2(256)	 NOT NULL,
	IDLTHRD_MAX	VARCHAR2(256)	 NOT NULL,
	USDTHRD_MIN			VARCHAR2(256)	 NOT NULL,
	USDTHRD_MAX	VARCHAR2(256)	 NOT NULL,
	MAXTHRD_MIN			VARCHAR2(256)	 NOT NULL,
	MAXTHRD_MAX	VARCHAR2(256)	 NOT NULL,
	USDTHRDPCT_MIN			VARCHAR2(256)	 NOT NULL,
	USDTHRDPCT_MAX	VARCHAR2(256)	 NOT NULL,
	RUNTHRDPCT_MIN			VARCHAR2(256)	 NOT NULL,
	RUNTHRDPCT_MAX	VARCHAR2(256)	 NOT NULL,
	RUNCRTTHRDPCT_MIN			VARCHAR2(256)	 NOT NULL,
	RUNCRTTHRDPCT_MAX	VARCHAR2(256)	 NOT NULL,
	USDCONNS_MIN			VARCHAR2(256)	 NOT NULL,
	USDCONNS_MAX	VARCHAR2(256)	 NOT NULL,
	USDCONNSPCT_MIN			VARCHAR2(256)	 NOT NULL,
	USDCONNSPCT_MAX	VARCHAR2(256)	 NOT NULL,
	MAXCONNS_MIN			VARCHAR2(256)	 NOT NULL,
	MAXCONNS_MAX	VARCHAR2(256)	 NOT NULL,
	QUENOW_MIN			VARCHAR2(256)	 NOT NULL,
	QUENOW_MAX	VARCHAR2(256)	 NOT NULL,
	USDQUESPCT_MIN			VARCHAR2(256)	 NOT NULL,
	USDQUESPCT_MAX	VARCHAR2(256)	 NOT NULL,
	MAXQUES_MIN			VARCHAR2(256)	 NOT NULL,
	MAXQUES_MAX	VARCHAR2(256)	 NOT NULL
);
ALTER TABLE SAPICMTest_THRESH ADD constraint PK_SAPICMTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SAPICMTEST ON SAPICMTEST (MSMT_TIME);
CREATE INDEX IDX_SAPICMTest_THRESH ON SAPICMTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SAPICMTest ON SAPICMTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SAPICMTest ON SAPICMTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE EgSysLogSvrTest CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogSvrTest(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
NO_OF_MESSAGES NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_EgSysLogSvrTest ON EgSysLogSvrTest(MSMT_TIME);
ALTER TABLE EgSysLogSvrTest ADD constraint PK_EgSysLogSvrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSysLogSvrTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogSvrTest_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
NO_OF_MESSAGES_MIN NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MAX NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE EgSysLogSvrTest_TREND ADD constraint PK_EgSysLogSvrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSysLogSvrTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogSvrTest_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
NO_OF_MESSAGES_MIN VARCHAR2(256) NOT NULL,
NO_OF_MESSAGES_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE EgSysLogSvrTest_THRESH ADD constraint PK_EgSysLogSvrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSysLogSvrTest_THRESH ON EgSysLogSvrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSysLogSvrTest ON EgSysLogSvrTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSysLogSvrTest ON EgSysLogSvrTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE EgSysLogAppTest CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogAppTest(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
NO_OF_MESSAGES NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_EgSysLogAppTest ON EgSysLogAppTest(MSMT_TIME);
ALTER TABLE EgSysLogAppTest ADD constraint PK_EgSysLogAppTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSysLogAppTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogAppTest_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
NO_OF_MESSAGES_MIN NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MAX NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE EgSysLogAppTest_TREND ADD constraint PK_EgSysLogAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSysLogAppTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogAppTest_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
NO_OF_MESSAGES_MIN VARCHAR2(256) NOT NULL,
NO_OF_MESSAGES_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE EgSysLogAppTest_THRESH ADD constraint PK_EgSysLogAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSysLogAppTest_THRESH ON EgSysLogAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSysLogAppTest ON EgSysLogAppTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSysLogAppTest ON EgSysLogAppTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE EgSyslogFilterTest CASCADE CONSTRAINTS;
CREATE TABLE EgSyslogFilterTest(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
NO_OF_MESSAGES_MIN NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_EgSyslogFilterTest ON EgSyslogFilterTest(MSMT_TIME);
ALTER TABLE EgSyslogFilterTest ADD constraint PK_EgSyslogFilterTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSyslogFilterTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EgSyslogFilterTest_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
NO_OF_MESSAGES_MIN_MIN NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_MAX NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_STCNT VARCHAR2(32) NOT NULL);



ALTER TABLE EgSyslogFilterTest_TREND ADD constraint PK_EgSyslogFilterTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSyslogFilterTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EgSyslogFilterTest_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,	
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
NO_OF_MESSAGES_MIN_MIN VARCHAR2(256) NOT NULL,
NO_OF_MESSAGES_MIN_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE EgSyslogFilterTest_THRESH ADD constraint PK_EgSyslogFilterTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSyslogFilterTest_THRESH ON EgSyslogFilterTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSyslogFilterTest ON EgSyslogFilterTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSyslogFilterTest ON EgSyslogFilterTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EgSyslogFilterSvrTest CASCADE CONSTRAINTS;
CREATE TABLE EgSyslogFilterSvrTest(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
NO_OF_MESSAGES_MIN NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_EgSyslogFilterSvrTest ON EgSyslogFilterSvrTest(MSMT_TIME);
ALTER TABLE EgSyslogFilterSvrTest ADD constraint PK_EgSyslogFilterSvrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSyslogFilterSvrTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EgSyslogFilterSvrTest_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
NO_OF_MESSAGES_MIN_MIN NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_MAX NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_STCNT VARCHAR2(32) NOT NULL);



ALTER TABLE EgSyslogFilterSvrTest_TREND ADD constraint PK_EgSyslogFilterSvrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSyslogFilterSvrTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EgSyslogFilterSvrTest_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,	
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
NO_OF_MESSAGES_MIN_MIN VARCHAR2(256) NOT NULL,
NO_OF_MESSAGES_MIN_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE EgSyslogFilterSvrTest_THRESH ADD constraint PK_EgSyslgFiltrSvrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSyslgFiltrSvrTest_THRESH ON EgSyslogFilterSvrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSyslogFilterSvrTest ON EgSyslogFilterSvrTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSyslogFilterSvrTest ON EgSyslogFilterSvrTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE   asset_info_default   CASCADE CONSTRAINTS;
create table asset_info_default (trgt_host varchar2(256) not null,asset_name varchar2(32),asset_desc varchar2(1024),asset_type varchar2(32),asset_state varchar2(32),ip_address varchar2(32),mac_address varchar2(32),operating_system varchar2(256),os_version varchar2(32),os_servicepack varchar2(32),memory varchar2(32),disk_space varchar2(32),cpu_speed varchar2(32),cpu_corecount varchar2(32),uuid varchar2(32),manufacturer varchar2(32),serial_number varchar2(32),asm_expiry_date varchar2(32),product varchar2(32),vendor varchar2(32),version varchar2(32),domain varchar2(32),cost varchar2(32),license_validity varchar2(32),license_key varchar2(32),license_type varchar2(32),license_serial_number varchar2(32),installation_date varchar2(32),installed_machine varchar2(32),installation_path varchar2(32),warranty varchar2(32),acquisition_date varchar2(32),license_expiry_date varchar2(32),firmware varchar2(32),firmware_version varchar2(32),subnet_mask varchar2(32),bandwidth varchar2(32),network_range varchar2(32),battery_status varchar2(32),battery_voltage varchar2(32),battery_current varchar2(32),last_audit_date varchar2(32),account varchar2(32),region varchar2(32),availability_zone varchar2(32),asset_user varchar2(32),location varchar2(32),email_id varchar2(32),phone_number varchar2(32),asset_support_group varchar2(32),asset_business_impact varchar2(32),asset_busines_service varchar2(32));
ALTER TABLE asset_info_default ADD constraint PK_asset_info_default PRIMARY KEY (trgt_host);

DROP TABLE   asset_info_custom  CASCADE CONSTRAINTS;
create table asset_info_custom (trgt_host varchar2(256) not null);
alter table asset_info_custom add constraint FK_asset_info_custom foreign key(trgt_host) references asset_info_default(trgt_host) ON DELETE CASCADE;

DROP TABLE MYDASHBOARDTEMPLATES CASCADE CONSTRAINTS;
CREATE TABLE MYDASHBOARDTEMPLATES(USERID VARCHAR2(256) NOT NULL,TEMPLATENAME VARCHAR2(2000) NOT NULL,ACCESSTYPE VARCHAR2(2048) NOT NULL);

DROP TABLE CUSTOMDASHBOARDTEMPLATES CASCADE CONSTRAINTS;
CREATE TABLE CUSTOMDASHBOARDTEMPLATES(USERID VARCHAR2(256) NOT NULL,TEMPLATENAME VARCHAR2(2000) NOT NULL,ACCESSTYPE VARCHAR2(2048) NOT NULL);
 
DROP TABLE ActiveDirectoryTest CASCADE CONSTRAINTS;
CREATE TABLE ActiveDirectoryTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	schemaCacheHitRatio		NUMBER(20,4) NOT NULL,
	schemaCacheHitRatio_ST		varchar2(32) NOT NULL,
	notifyQSize			Number(20,4) not null,
	notifyQSize_ST			varchar2(32) not null,
	currThreads			Number(20,4) not null,
	currThreads_ST			varchar2(32) not null,
	directoryWrites			number(20,4) not null,
	directoryWrites_ST		varchar2(32) not null,
	kerberosAuth			number(20,4) not null,
	kerberosAuth_ST			varchar2(32) not null,
	ntlmAuth			number(20,4) not null,
	ntlmAuth_ST			varchar2(32) not null,
	ticketReq			number(20,4) not null,
	ticketReq_ST			varchar2(32) not null,
	authSrvReq			number(20,4) not null,
	authSrvReq_ST			varchar2(32) not null,
	ldapSessions			Number(20,4) not null,
	ldapSessions_ST			varchar2(32) not null
);

ALTER TABLE ActiveDirectoryTest ADD constraint PK_ActiveDirectory
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   ActiveDirectoryTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE ActiveDirectoryTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	schemaCacheHitRatio_MIN		NUMBER(20,4) NOT NULL,
	schemaCacheHitRatio_MAX		NUMBER(20,4) NOT NULL,
	schemaCacheHitRatio_STCNT	varchar2(32) NOT NULL,
	notifyQSize_MIN			Number(20,4) not null,
	notifyQSize_MAX			Number(20,4) not null,
	notifyQSize_STCNT		varchar2(32) not null,
	currThreads_MIN			Number(20,4) not null,
	currThreads_MAX			Number(20,4) not null,
	currThreads_STCNT		varchar2(32) not null,
	directoryWrites_MIN		number(20,4) not null,
	directoryWrites_MAX		number(20,4) not null,
	directoryWrites_STCNT		varchar2(32) not null,
	kerberosAuth_MIN		number(20,4) not null,
	kerberosAuth_MAX		number(20,4) not null,
	kerberosAuth_STCNT		varchar2(32) not null,
	ntlmAuth_MIN			number(20,4) not null,
	ntlmAuth_MAX			number(20,4) not null,
	ntlmAuth_STCNT			varchar2(32) not null,
	ticketReq_MIN			number(20,4) not null,
	ticketReq_MAX			number(20,4) not null,
	ticketReq_STCNT			varchar2(32) not null,
	authSrvReq_MIN			number(20,4) not null,
	authSrvReq_MAX			number(20,4) not null,
	authSrvReq_STCNT		varchar2(32) not null,
	ldapSessions_MIN		Number(20,4) not null,
	ldapSessions_MAX		Number(20,4) not null,
	ldapSessions_STCNT		varchar2(32) not null
);

ALTER TABLE ActiveDirectoryTest_TREND ADD constraint PK_ActiveDirectoryTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   ActiveDirectoryTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ActiveDirectoryTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	SCHEMACACHEHITRATIO_MIN	VARCHAR2(256)	 NOT NULL,
	SCHEMACACHEHITRATIO_MAX	VARCHAR2(256)	 NOT NULL,
	NOTIFYQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	NOTIFYQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	CURRTHREADS_MIN	VARCHAR2(256)	 NOT NULL,
	CURRTHREADS_MAX	VARCHAR2(256)	 NOT NULL,
	DIRECTORYWRITES_MIN	VARCHAR2(256)	 NOT NULL,
	DIRECTORYWRITES_MAX	VARCHAR2(256)	 NOT NULL,
	KERBEROSAUTH_MIN	VARCHAR2(256)	 NOT NULL,
	KERBEROSAUTH_MAX	VARCHAR2(256)	 NOT NULL,
	NTLMAUTH_MIN	VARCHAR2(256)	 NOT NULL,
	NTLMAUTH_MAX	VARCHAR2(256)	 NOT NULL,
	TICKETREQ_MIN	VARCHAR2(256)	 NOT NULL,
	TICKETREQ_MAX	VARCHAR2(256)	 NOT NULL,
	AUTHSRVREQ_MIN	VARCHAR2(256)	 NOT NULL,
	AUTHSRVREQ_MAX	VARCHAR2(256)	 NOT NULL,
	LDAPSESSIONS_MIN	VARCHAR2(256)	 NOT NULL,
	LDAPSESSIONS_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE ActiveDirectoryTest_THRESH ADD constraint PK_ActiveDirectoryTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_ActiveDirectoryTest_THRESH ON ActiveDirectoryTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE ALARM CASCADE CONSTRAINTS;

CREATE TABLE ALARM 
(
	COMP_NAME	    VARCHAR2(1024),
	COMP_TYPE	    VARCHAR2(32),
	LAYER_NAME	    VARCHAR2(64),
	PROBLEM_DESC	    VARCHAR2(4000), 
	PRIORITY	    VARCHAR2(32) NOT NULL,
        MSMT_TIME	    DATE,
	ALARM_ID            NUMBER(18)			
 );
CREATE INDEX IDX_ALARM ON ALARM (PRIORITY,COMP_TYPE, COMP_NAME, LAYER_NAME, PROBLEM_DESC,MSMT_TIME);
CREATE INDEX IDX1_ALARM ON ALARM (MSMT_TIME); 
ALTER TABLE ALARM ADD CONSTRAINT PK_ALARM
PRIMARY KEY (ALARM_ID);

DROP TABLE ATGJDBCTEST CASCADE CONSTRAINTS;

CREATE TABLE ATGJDBCTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	CONN_USE_PCT 	number(20,4) 	NOT NULL,
	CONN_USE_PCT_ST varchar2(32) 	NOT NULL,
	IDLE_CONN_PCT 	number(20,4) 	NOT NULL,
	IDLE_CONN_PCT_ST varchar2(32) 	NOT NULL
);

ALTER TABLE ATGJDBCTEST ADD constraint PK_ATG_JDBC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ATGJDBCTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ATGJDBCTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	CONN_USE_PCT_MIN 	number(20,4) 	NOT NULL,
	CONN_USE_PCT_MAX 	number(20,4) 	NOT NULL,
	CONN_USE_PCT_STCNT 	varchar2(32) 	NOT NULL,
	IDLE_CONN_PCT_MIN 	number(20,4) 	NOT NULL,
	IDLE_CONN_PCT_MAX 	number(20,4) 	NOT NULL,
	IDLE_CONN_PCT_STCNT 	varchar2(32) 	NOT NULL
);

ALTER TABLE ATGJDBCTEST_TREND ADD constraint PK_ATG_JDBC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
 
DROP TABLE ATGJDBCTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ATGJDBCTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	CONN_USE_PCT_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_USE_PCT_MAX	VARCHAR2(256)	 	NOT NULL,
	IDLE_CONN_PCT_MIN	VARCHAR2(256)	 	NOT NULL,
	IDLE_CONN_PCT_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE ATGJDBCTEST_THRESH ADD constraint PK_ATG_JDBC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_ATGJDBCTEST_THRESH ON ATGJDBCTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);    
DROP TABLE ATGTEST CASCADE CONSTRAINTS;

CREATE TABLE ATGTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	PCT_MEM_USE 	number(20,4) 	NOT NULL,
	PCT_MEM_USE_ST 	varchar2(32) 	NOT NULL,
	SESSION_RATE 	number(20,4) 	NOT NULL,
	SESSION_RATE_ST	varchar2(32) 	NOT NULL,
	SESSION_COUNT 	Number(20,4) 	NOT NULL,
	SESSION_COUNT_ST varchar2(32) 	NOT NULL,
	DRP_REQUEST_RATE number(20,4) 	NOT NULL,
	DRP_REQUEST_RATE_ST varchar2(32) NOT NULL,
	DRP_RESP_RATE number(20,4) 	NOT NULL,
	DRP_RESP_RATE_ST varchar2(32) 	NOT NULL
);

ALTER TABLE ATGTEST ADD constraint PK_ATG
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ATGTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ATGTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	PCT_MEM_USE_MIN	        number(20,4) 	NOT NULL,
	PCT_MEM_USE_MAX	        number(20,4) 	NOT NULL,
	PCT_MEM_USE_STCNT 	varchar2(32) 	NOT NULL,
	SESSION_RATE_MIN	number(20,4) 	NOT NULL,
	SESSION_RATE_MAX	number(20,4) 	NOT NULL,
	SESSION_RATE_STCNT 	varchar2(32) 	NOT NULL,
	SESSION_COUNT_MIN	Number(20,4) 	NOT NULL,
	SESSION_COUNT_MAX	Number(20,4) 	NOT NULL,
	SESSION_COUNT_STCNT 	varchar2(32) 	NOT NULL,
	DRP_REQUEST_RATE_MIN	number(20,4) 	NOT NULL,
	DRP_REQUEST_RATE_MAX	number(20,4) 	NOT NULL,
	DRP_REQUEST_RATE_STCNT 	varchar2(32) 	NOT NULL,
	DRP_RESP_RATE_MIN	number(20,4) 	NOT NULL,
	DRP_RESP_RATE_MAX	number(20,4) 	NOT NULL,
	DRP_RESP_RATE_STCNT 	varchar2(32) 	NOT NULL
);

ALTER TABLE ATGTEST_TREND ADD constraint PK_ATG_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ATGTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ATGTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	PCT_MEM_USE_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_MEM_USE_MAX	VARCHAR2(256)	 	NOT NULL,
	SESSION_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	SESSION_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	SESSION_COUNT_MIN	VARCHAR2(256)	 	NOT NULL,
	SESSION_COUNT_MAX	VARCHAR2(256)	 	NOT NULL,
	DRP_REQUEST_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DRP_REQUEST_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DRP_RESP_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DRP_RESP_RATE_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE ATGTEST_THRESH ADD constraint PK_ATG_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ATGTEST_THRESH ON ATGTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE CHECKPOINTTEST  CASCADE CONSTRAINTS;

CREATE TABLE CHECKPOINTTEST 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME 		date,
	PKT_PROCESSING_RATE 	number(20,4) 	NOT NULL,
	PKT_PROCESSING_RATE_ST 	varchar2(32)    NOT NULL,
	PCT_ACC_PKTS 		number(20,4) 	NOT NULL,
	PCT_ACC_PKTS_ST 	varchar2(32)    NOT NULL,
	PCT_REJ_PKTS 		number(20,4) 	NOT NULL,
	PCT_REJ_PKTS_ST 	varchar2(32)    NOT NULL,
	PCT_DROP_PKTS 		number(20,4) 	NOT NULL,
	PCT_DROP_PKTS_ST 	varchar2(32)    NOT NULL
);

ALTER TABLE CHECKPOINTTEST ADD CONSTRAINT PK_CHECK_POINT
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE CHECKPOINTTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE CHECKPOINTTEST_TREND 
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                 	varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD 				varchar2(32), 
	PKT_PROCESSING_RATE_MIN 		number(20,4) 	NOT NULL,
	PKT_PROCESSING_RATE_MAX 		number(20,4) 	NOT NULL,
	PKT_PROCESSING_RATE_STCNT		varchar2(32) NOT NULL,
	PCT_ACC_PKTS_MIN 		number(20,4) 	NOT NULL,
	PCT_ACC_PKTS_MAX 		number(20,4) 	NOT NULL,
	PCT_ACC_PKTS_STCNT		varchar2(32) NOT NULL,
	PCT_REJ_PKTS_MIN 		number(20,4) 	NOT NULL,
	PCT_REJ_PKTS_MAX 		number(20,4) 	NOT NULL,
	PCT_REJ_PKTS_STCNT 		varchar2(32) NOT NULL,
	PCT_DROP_PKTS_MIN 		number(20,4) 	NOT NULL,
	PCT_DROP_PKTS_MAX 		number(20,4) 	NOT NULL,
	PCT_DROP_PKTS_STCNT 		varchar2(32) NOT NULL
);

ALTER TABLE CHECKPOINTTEST_TREND ADD CONSTRAINT PK_CHECK_POINT_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE CHECKPOINTTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CHECKPOINTTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START 	date,
        MSMT_TIME_END           date,
	PKT_PROCESSING_RATE_MIN	VARCHAR2(256)		NOT NULL,
	PKT_PROCESSING_RATE_MAX	VARCHAR2(256)		NOT NULL,
	PCT_ACC_PKTS_MIN	VARCHAR2(256)		NOT NULL,
	PCT_ACC_PKTS_MAX	VARCHAR2(256)		NOT NULL,
	PCT_REJ_PKTS_MIN	VARCHAR2(256)		NOT NULL,
	PCT_REJ_PKTS_MAX	VARCHAR2(256)		NOT NULL,
	PCT_DROP_PKTS_MIN	VARCHAR2(256)		NOT NULL,
	PCT_DROP_PKTS_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE CHECKPOINTTEST_THRESH ADD CONSTRAINT PK_CHECK_POINT_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_CHECKPOINTTEST_THRESH ON CHECKPOINTTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE CISCOCPUTEST CASCADE CONSTRAINTS;

CREATE TABLE CISCOCPUTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	UTIL_PCT 	number(20,4) 	NOT NULL,
	UTIL_PCT_ST 	varchar2(32) 	NOT NULL
);

ALTER TABLE CISCOCPUTEST ADD constraint PK_CISCO_CPU
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE CISCOCPUTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE CISCOCPUTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	UTIL_PCT_MIN 		number(20,4) 	NOT NULL,
	UTIL_PCT_MAX 		number(20,4) 	NOT NULL,
	UTIL_PCT_STCNT 		varchar2(32) 	NOT NULL
);

ALTER TABLE CISCOCPUTEST_TREND ADD constraint PK_CISCO_CPU_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE CISCOCPUTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE CISCOCPUTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	UTIL_PCT_MIN	VARCHAR2(256)	 	NOT NULL,
	UTIL_PCT_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE CISCOCPUTEST_THRESH ADD constraint PK_CISCO_CPU_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_CISCOCPUTEST_THRESH ON CISCOCPUTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE CISCOMEMORYTEST CASCADE CONSTRAINTS;

CREATE TABLE CISCOMEMORYTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	USED_PCT 	number(20,4) 	NOT NULL,
	USED_PCT_ST 	varchar2(32) 	NOT NULL,
	USED_MEMORY	number(20,4) 	NOT NULL,
	USED_MEMORY_ST	varchar2(32) 	NOT NULL,
	FREE_MEMORY	number(20,4) 	NOT NULL,
	FREE_MEMORY_ST	varchar2(32) 	NOT NULL
);

ALTER TABLE CISCOMEMORYTEST ADD constraint PK_CISCO_MEM
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE CISCOMEMORYTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE CISCOMEMORYTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	USED_PCT_MIN 		number(20,4) 	NOT NULL,
	USED_PCT_MAX 		number(20,4) 	NOT NULL,
	USED_PCT_STCNT 		varchar2(32) 	NOT NULL,
	USED_MEMORY_MIN		number(20,4) 	NOT NULL,
	USED_MEMORY_MAX		number(20,4) 	NOT NULL,
	USED_MEMORY_STCNT	varchar2(32) 	NOT NULL,
	FREE_MEMORY_MIN		number(20,4) 	NOT NULL,
	FREE_MEMORY_MAX		number(20,4) 	NOT NULL,
	FREE_MEMORY_STCNT	varchar2(32) 	NOT NULL
);

ALTER TABLE CISCOMEMORYTEST_TREND ADD constraint PK_CISCO_MEM_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE CISCOMEMORYTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CISCOMEMORYTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	USED_PCT_MIN	VARCHAR2(256)	 	NOT NULL,
	USED_PCT_MAX	VARCHAR2(256)	 	NOT NULL,
	USED_MEMORY_MIN	VARCHAR2(256)	 	NOT NULL,
	USED_MEMORY_MAX	VARCHAR2(256)	 	NOT NULL,
	FREE_MEMORY_MIN	VARCHAR2(256)	 	NOT NULL,
	FREE_MEMORY_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE CISCOMEMORYTEST_THRESH ADD constraint PK_CISCO_MEM_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_CISCOMEMORYTEST_THRESH ON CISCOMEMORYTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE COLDFUSIONTEST  CASCADE CONSTRAINTS;

CREATE TABLE COLDFUSIONTEST
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(64),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME 		date,
        PAGE_HIT_RATE           number(20,4)    NOT NULL, 
	PAGE_HIT_RATE_ST       	varchar2(32)  	NOT NULL,
        DB_HIT_RATE 		number(20,4)    NOT NULL,
        DB_HIT_RATE_ST 		varchar2(32)  	NOT NULL,
        BYTES_IN_RATE           number(20,4)    NOT NULL, 
        BYTES_IN_RATE_ST        varchar2(32)     NOT NULL,
        BYTES_OUT_RATE          number(20,4)    NOT NULL, 
        BYTES_OUT_RATE_ST       varchar2(32)     NOT NULL,
        REQUESTS_QUEUED         number(20,4)    NOT NULL, 
        REQUESTS_QUEUED_ST      varchar2(32)     NOT NULL,
        REQUESTS_RUNNING        number(20,4)    NOT NULL, 
       	REQUESTS_RUNNING_ST  	varchar2(32)     NOT NULL,
	REQ_TOUT_RATE		number(20,4)   	NOT NULL,
	REQ_TOUT_RATE_ST	varchar2(32)	NOT NULL,
	AVG_QUEUE_TIME		number(20,4)   	NOT NULL,
	AVG_QUEUE_TIME_ST	varchar2(32)	NOT NULL,
        AVG_REQ_TIME        	number(20,4)    NOT NULL, 
       	AVG_REQ_TIME_ST  	varchar2(32)     NOT NULL,
        AVG_DB_TIME        	number(20,4)    NOT NULL, 
       	AVG_DB_TIME_ST  	varchar2(32)     NOT NULL
);

ALTER TABLE COLDFUSIONTEST ADD CONSTRAINT PK_CFTEST_STATS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE COLDFUSIONTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE COLDFUSIONTEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(64),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD			varchar2(32), 
        PAGE_HIT_RATE_MIN       number(20,4)    NOT NULL, 
        PAGE_HIT_RATE_MAX       number(20,4)    NOT NULL,
	PAGE_HIT_RATE_STCNT	varchar2(32)     NOT NULL, 
        DB_HIT_RATE_MIN 	number(20,4)    NOT NULL,
        DB_HIT_RATE_MAX 	number(20,4)    NOT NULL,
	DB_HIT_RATE_STCNT	varchar2(32)     NOT NULL,
        BYTES_IN_RATE_MIN       number(20,4)    NOT NULL, 
        BYTES_IN_RATE_MAX       number(20,4)    NOT NULL, 
	BYTES_IN_RATE_STCNT	varchar2(32)     NOT NULL,
        BYTES_OUT_RATE_MIN      number(20,4)    NOT NULL, 
        BYTES_OUT_RATE_MAX      number(20,4)    NOT NULL, 
	BYTES_OUT_RATE_STCNT	varchar2(32)     NOT NULL,
        REQUESTS_QUEUED_MIN     number(20,4)    NOT NULL, 
        REQUESTS_QUEUED_MAX     number(20,4)    NOT NULL, 
	REQUESTS_QUEUED_STCNT	varchar2(32)     NOT NULL,
        REQUESTS_RUNNING_MIN    number(20,4)    NOT NULL, 
        REQUESTS_RUNNING_MAX    number(20,4)    NOT NULL, 
	REQUESTS_RUNNING_STCNT	varchar2(32)     NOT NULL,
	REQ_TOUT_RATE_MIN	number(20,4)   	NOT NULL,
	REQ_TOUT_RATE_MAX	number(20,4)   	NOT NULL,
	REQ_TOUT_RATE_STCNT	varchar2(32)     NOT NULL,
	AVG_QUEUE_TIME_MIN	number(20,4)   	NOT NULL,
	AVG_QUEUE_TIME_MAX	number(20,4)   	NOT NULL,
	AVG_QUEUE_TIME_STCNT	varchar2(32)     NOT NULL,
        AVG_REQ_TIME_MIN       	number(20,4)    NOT NULL, 
        AVG_REQ_TIME_MAX       	number(20,4)    NOT NULL, 
	AVG_REQ_TIME_STCNT	varchar2(32)     NOT NULL,
        AVG_DB_TIME_MIN        	number(20,4)    NOT NULL, 
        AVG_DB_TIME_MAX        	number(20,4)    NOT NULL, 
	AVG_DB_TIME_STCNT	varchar2(32)     NOT NULL
);

ALTER TABLE COLDFUSIONTEST_TREND ADD CONSTRAINT PK_CFTEST_STATS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE COLDFUSIONTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE COLDFUSIONTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(64),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START 	date,
        MSMT_TIME_END           date,
        PAGE_HIT_RATE_MIN	VARCHAR2(256)	    NOT NULL,
        PAGE_HIT_RATE_MAX	VARCHAR2(256)	    NOT NULL,
        DB_HIT_RATE_MIN	VARCHAR2(256)	    NOT NULL,
        DB_HIT_RATE_MAX	VARCHAR2(256)	    NOT NULL,
        BYTES_IN_RATE_MIN	VARCHAR2(256)	    NOT NULL,
        BYTES_IN_RATE_MAX	VARCHAR2(256)	    NOT NULL,
        BYTES_OUT_RATE_MIN	VARCHAR2(256)	    NOT NULL,
        BYTES_OUT_RATE_MAX	VARCHAR2(256)	    NOT NULL,
        REQUESTS_QUEUED_MIN	VARCHAR2(256)	    NOT NULL,
        REQUESTS_QUEUED_MAX	VARCHAR2(256)	    NOT NULL,
        REQUESTS_RUNNING_MIN	VARCHAR2(256)	    NOT NULL,
        REQUESTS_RUNNING_MAX	VARCHAR2(256)	    NOT NULL,
	REQ_TOUT_RATE_MIN	VARCHAR2(256)	   	NOT NULL,
	REQ_TOUT_RATE_MAX	VARCHAR2(256)	   	NOT NULL,
	AVG_QUEUE_TIME_MIN	VARCHAR2(256)	   	NOT NULL,
	AVG_QUEUE_TIME_MAX	VARCHAR2(256)	   	NOT NULL,
        AVG_REQ_TIME_MIN	VARCHAR2(256)	    NOT NULL,
        AVG_REQ_TIME_MAX	VARCHAR2(256)	    NOT NULL,
        AVG_DB_TIME_MIN	VARCHAR2(256)	    NOT NULL,
        AVG_DB_TIME_MAX	VARCHAR2(256)	    NOT NULL
);

ALTER TABLE COLDFUSIONTEST_THRESH ADD CONSTRAINT PK_CFTEST_STATS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_COLDFUSIONTEST_THRESH ON COLDFUSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 

DROP TABLE DB2BUFFERPOOLTEST  CASCADE CONSTRAINTS;
CREATE TABLE DB2BUFFERPOOLTEST
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
        MSMT_TIME 			date,
	PCT_POOL_HIT_RATIO 		number(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_ST 		varchar2(32)  	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX 		number(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_ST 	varchar2(32) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO         number(20,4)	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_ST      varchar2(32)	NOT NULL
);

ALTER TABLE DB2BUFFERPOOLTEST ADD CONSTRAINT PK_DB2BUFFERPOOLTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DB2BUFFERPOOLTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DB2BUFFERPOOLTEST_TREND 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME 				date,
	PERIOD 					varchar2(32), 
	PCT_POOL_HIT_RATIO_MIN 		number(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_MAX 		number(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_STCNT		varchar2(32) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MIN 		number(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MAX 		number(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_STCNT		varchar2(32) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MIN 		number(20,4) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MAX 		number(20,4) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE DB2BUFFERPOOLTEST_TREND ADD CONSTRAINT PK_DB2BUFFER_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2BUFFERPOOLTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DB2BUFFERPOOLTEST_THRESH 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME_START 			date,
        MSMT_TIME_END           		date,
	PCT_POOL_HIT_RATIO_MIN	VARCHAR2(256)		NOT NULL,
	PCT_POOL_HIT_RATIO_MAX	VARCHAR2(256)		NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MIN	VARCHAR2(256)		NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MAX	VARCHAR2(256)		NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MIN	VARCHAR2(256)		NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE DB2BUFFERPOOLTEST_THRESH ADD CONSTRAINT PK_DB2_BUFFER_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2BUFFERPOOLTEST_THRESH ON DB2BUFFERPOOLTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DB2INSTANCETEST CASCADE CONSTRAINTS;

CREATE TABLE DB2INSTANCETEST
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
        MSMT_TIME 			date,
	PCT_AGENTS_WAITING	 	number(20,4) 	NOT NULL,
	PCT_AGENTS_WAITING_ST 		varchar2(32)  	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED 	number(20,4) 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_ST 	varchar2(32) 	NOT NULL,
	PCT_PIPED_SORTS_REJECTED 	number(20,4)	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_ST	varchar2(32)	NOT NULL,
	AGENTS_REGISTERED		number(20,4) 	NOT NULL,
	AGENTS_REGISTERED_ST 		varchar2(32)  	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL		number(20,4) 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_ST	varchar2(32) 	NOT NULL
);

ALTER TABLE DB2INSTANCETEST ADD CONSTRAINT PK_DB2_INSTANCE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DB2INSTANCETEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DB2INSTANCETEST_TREND 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME 				date,
	PERIOD 					varchar2(32), 
	PCT_AGENTS_WAITING_MIN	 		number(20,4) 	NOT NULL,
	PCT_AGENTS_WAITING_MAX	 		number(20,4) 	NOT NULL,
	PCT_AGENTS_WAITING_STCNT 		varchar2(32)  	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MIN 		number(20,4) 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MAX 		number(20,4) 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_STCNT 		varchar2(32) 	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MIN 		number(20,4)	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MAX 		number(20,4)	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_STCNT		varchar2(32)	NOT NULL,
	AGENTS_REGISTERED_MIN			number(20,4) 	NOT NULL,
	AGENTS_REGISTERED_MAX			number(20,4) 	NOT NULL,
	AGENTS_REGISTERED_STCNT 		varchar2(32)  	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MIN		number(20,4) 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MAX		number(20,4) 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE DB2INSTANCETEST_TREND ADD CONSTRAINT PK_DB2_INSTANCE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2INSTANCETEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DB2INSTANCETEST_THRESH 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME_START 			date,
        MSMT_TIME_END           		date,
	PCT_AGENTS_WAITING_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_AGENTS_WAITING_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MIN	VARCHAR2(256)		NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MAX	VARCHAR2(256)		NOT NULL,
	AGENTS_REGISTERED_MIN	VARCHAR2(256)	 	NOT NULL,
	AGENTS_REGISTERED_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE DB2INSTANCETEST_THRESH ADD CONSTRAINT PK_DB2_INSTANCE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_DB2INSTANCETEST_THRESH ON DB2INSTANCETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DB2IOTEST  CASCADE CONSTRAINTS;

CREATE TABLE DB2IOTEST
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
        MSMT_TIME 			date,
	DIRECT_READ_RATE 		number(20,4) 	NOT NULL,
	DIRECT_READ_RATE_ST 		varchar2(32)  	NOT NULL,
	DIRECT_WRITE_RATE 		number(20,4) 	NOT NULL,
	DIRECT_WRITE_RATE_ST 		varchar2(32)  	NOT NULL,
	BUF_POOL_IO_RATE         	number(20,4)	NOT NULL,
	BUF_POOL_IO_RATE_ST         	varchar2(32)	NOT NULL
);

ALTER TABLE DB2IOTEST ADD CONSTRAINT PK_DB2IOTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DB2IOTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DB2IOTEST_TREND 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME 				date,
	PERIOD 					varchar2(32), 
	DIRECT_READ_RATE_MIN 			number(20,4) 	NOT NULL,
	DIRECT_READ_RATE_MAX 			number(20,4) 	NOT NULL,
	DIRECT_READ_RATE_STCNT			varchar2(32) 	NOT NULL,
	DIRECT_WRITE_RATE_MIN 			number(20,4) 	NOT NULL,
	DIRECT_WRITE_RATE_MAX	 		number(20,4) 	NOT NULL,
	DIRECT_WRITE_RATE_STCNT			varchar2(32) 	NOT NULL,
	BUF_POOL_IO_RATE_MIN 			number(20,4) 	NOT NULL,
	BUF_POOL_IO_RATE_MAX 			number(20,4) 	NOT NULL,
	BUF_POOL_IO_RATE_STCNT			varchar2(32) 	NOT NULL
);

ALTER TABLE DB2IOTEST_TREND ADD CONSTRAINT PK_DB2IOTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2IOTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DB2IOTEST_THRESH 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME_START 			date,
        MSMT_TIME_END           		date,
	DIRECT_READ_RATE_MIN	VARCHAR2(256)		NOT NULL,
	DIRECT_READ_RATE_MAX	VARCHAR2(256)		NOT NULL,
	DIRECT_WRITE_RATE_MIN	VARCHAR2(256)		NOT NULL,
	DIRECT_WRITE_RATE_MAX	VARCHAR2(256)		NOT NULL,
	BUF_POOL_IO_RATE_MIN	VARCHAR2(256)		NOT NULL,
	BUF_POOL_IO_RATE_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE DB2IOTEST_THRESH ADD CONSTRAINT PK_DB2IOTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2IOTEST_THRESH ON DB2IOTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DB2LOCKANDDEADLOCKTEST  CASCADE CONSTRAINTS;

CREATE TABLE DB2LOCKANDDEADLOCKTEST
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
        MSMT_TIME 			date,
	TOTAL_DEADLOCKS 		number(20,4) 	NOT NULL,
	TOTAL_DEADLOCKS_ST 		varchar2(32)  	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL	 	number(20,4) 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_ST 	varchar2(32) 	NOT NULL,
	LOCKS_HELD        		number(20,4)	NOT NULL,
	LOCKS_HELD_ST   		varchar2(32)	NOT NULL,
	LOCK_TIMEOUTS	 		number(20,4) 	NOT NULL,
	LOCK_TIMEOUTS_ST 		varchar2(32)  	NOT NULL,
	LOCK_ESCALATIONS 		number(20,4) 	NOT NULL,
	LOCK_ESCALATIONS_ST 		varchar2(32) 	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT  		number(20,4)	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_ST 	varchar2(32)	NOT NULL
);

ALTER TABLE DB2LOCKANDDEADLOCKTEST ADD CONSTRAINT PK_DB2_LOCK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DB2LOCKANDDEADLOCKTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DB2LOCKANDDEADLOCKTEST_TREND 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME 				date,
	PERIOD 					varchar2(32), 
	TOTAL_DEADLOCKS_MIN 			number(20,4) 	NOT NULL,
	TOTAL_DEADLOCKS_MAX 			number(20,4) 	NOT NULL,
	TOTAL_DEADLOCKS_STCNT 			varchar2(32)  	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MIN		number(20,4) 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MAX		number(20,4) 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_STCNT		varchar2(32) 	NOT NULL,
	LOCKS_HELD_MIN        			number(20,4)	NOT NULL,
	LOCKS_HELD_MAX        			number(20,4)	NOT NULL,
	LOCKS_HELD_STCNT   			varchar2(32)	NOT NULL,
	LOCK_TIMEOUTS_MIN	 		number(20,4) 	NOT NULL,
	LOCK_TIMEOUTS_MAX	 		number(20,4) 	NOT NULL,
	LOCK_TIMEOUTS_STCNT 			varchar2(32)  	NOT NULL,
	LOCK_ESCALATIONS_MIN 			number(20,4) 	NOT NULL,
	LOCK_ESCALATIONS_MAX 			number(20,4) 	NOT NULL,
	LOCK_ESCALATIONS_STCNT 			varchar2(32) 	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MIN  		number(20,4)	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MAX  		number(20,4)	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_STCNT 		varchar2(32)	NOT NULL
);

ALTER TABLE DB2LOCKANDDEADLOCKTEST_TREND ADD CONSTRAINT PK_DB2_LOCK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2LOCKANDDEADLOCKTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DB2LOCKANDDEADLOCKTEST_THRESH 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME_START 			date,
        MSMT_TIME_END           		date,
	TOTAL_DEADLOCKS_MIN	VARCHAR2(256)	 	NOT NULL,
	TOTAL_DEADLOCKS_MAX	VARCHAR2(256)	 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MIN	VARCHAR2(256)	 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MAX	VARCHAR2(256)	 	NOT NULL,
	LOCKS_HELD_MIN	VARCHAR2(256)		NOT NULL,
	LOCKS_HELD_MAX	VARCHAR2(256)		NOT NULL,
	LOCK_TIMEOUTS_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCK_TIMEOUTS_MAX	VARCHAR2(256)	 	NOT NULL,
	LOCK_ESCALATIONS_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCK_ESCALATIONS_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MIN	VARCHAR2(256)		NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE DB2LOCKANDDEADLOCKTEST_THRESH ADD CONSTRAINT PK_DB2_LOCK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_DB2LOCKTEST_THRESH ON DB2LOCKANDDEADLOCKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DB2SORTTEST  CASCADE CONSTRAINTS;

CREATE TABLE DB2SORTTEST
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
        MSMT_TIME 			date,
	AVG_SORT_TIME	 		number(20,4) 	NOT NULL,
	AVG_SORT_TIME_ST	 	varchar2(32)  	NOT NULL,
	PCT_SORT_OVERFLOW	 	number(20,4) 	NOT NULL,
	PCT_SORT_OVERFLOW_ST 		varchar2(32) 	NOT NULL
);

ALTER TABLE DB2SORTTEST ADD CONSTRAINT PK_DB2SORTTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DB2SORTTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DB2SORTTEST_TREND 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME 				date,
	PERIOD 					varchar2(32), 
	AVG_SORT_TIME_MIN 			number(20,4) 	NOT NULL,
	AVG_SORT_TIME_MAX 			number(20,4) 	NOT NULL,
	AVG_SORT_TIME_STCNT			varchar2(32) 	NOT NULL,
	PCT_SORT_OVERFLOW_MIN 			number(20,4) 	NOT NULL,
	PCT_SORT_OVERFLOW_MAX 			number(20,4) 	NOT NULL,
	PCT_SORT_OVERFLOW_STCNT			varchar2(32) 	NOT NULL
);

ALTER TABLE DB2SORTTEST_TREND ADD CONSTRAINT PK_DB2SORTTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2SORTTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DB2SORTTEST_THRESH 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME_START 			date,
        MSMT_TIME_END           		date,
	AVG_SORT_TIME_MIN	VARCHAR2(256)		NOT NULL,
	AVG_SORT_TIME_MAX	VARCHAR2(256)		NOT NULL,
	PCT_SORT_OVERFLOW_MIN	VARCHAR2(256)		NOT NULL,
	PCT_SORT_OVERFLOW_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE DB2SORTTEST_THRESH ADD CONSTRAINT PK_DB2SORTTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2SORTTEST_THRESH ON DB2SORTTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DB2SQLACTIVITYTEST CASCADE CONSTRAINTS;

CREATE TABLE DB2SQLACTIVITYTEST
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
        MSMT_TIME 			date,
	DYNAMIC_SQL_RATE	 	number(20,4) 	NOT NULL,
	DYNAMIC_SQL_RATE_ST 		varchar2(32)  	NOT NULL,
	SELECT_SQL_RATE		 	number(20,4) 	NOT NULL,
	SELECT_SQL_RATE_ST	 	varchar2(32) 	NOT NULL,
	FAILED_SQL_RATE        		number(20,4)	NOT NULL,
	FAILED_SQL_RATE_ST   		varchar2(32)	NOT NULL,
	UID_SQL_RATE	 		number(20,4) 	NOT NULL,
	UID_SQL_RATE_ST 		varchar2(32)  	NOT NULL,
	PCT_FAILED_SQL	 		number(20,4) 	NOT NULL,
	PCT_FAILED_SQL_ST 		varchar2(32) 	NOT NULL,
	PCT_DDL_SQL  			number(20,4)	NOT NULL,
	PCT_DDL_SQL_ST			varchar2(32)	NOT NULL,
	PCT_UID_SQL  			number(20,4)	NOT NULL,
	PCT_UID_SQL_ST	 		varchar2(32)	NOT NULL
);

ALTER TABLE DB2SQLACTIVITYTEST ADD CONSTRAINT PK_DB2_SQLACTIVITY
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DB2SQLACTIVITYTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DB2SQLACTIVITYTEST_TREND 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME 				date,
	PERIOD 					varchar2(32), 
	DYNAMIC_SQL_RATE_MIN	 		number(20,4) 	NOT NULL,
	DYNAMIC_SQL_RATE_MAX	 		number(20,4) 	NOT NULL,
	DYNAMIC_SQL_RATE_STCNT 			varchar2(32)  	NOT NULL,
	SELECT_SQL_RATE_MIN	 		number(20,4) 	NOT NULL,
	SELECT_SQL_RATE_MAX	 		number(20,4) 	NOT NULL,
	SELECT_SQL_RATE_STCNT	 		varchar2(32) 	NOT NULL,
	FAILED_SQL_RATE_MIN        		number(20,4)	NOT NULL,
	FAILED_SQL_RATE_MAX        		number(20,4)	NOT NULL,
	FAILED_SQL_RATE_STCNT   		varchar2(32)	NOT NULL,
	UID_SQL_RATE_MIN	 		number(20,4) 	NOT NULL,
	UID_SQL_RATE_MAX	 		number(20,4) 	NOT NULL,
	UID_SQL_RATE_STCNT 			varchar2(32)  	NOT NULL,
	PCT_FAILED_SQL_MIN	 		number(20,4) 	NOT NULL,
	PCT_FAILED_SQL_MAX	 		number(20,4) 	NOT NULL,
	PCT_FAILED_SQL_STCNT 			varchar2(32) 	NOT NULL,
	PCT_DDL_SQL_MIN  			number(20,4)	NOT NULL,
	PCT_DDL_SQL_MAX  			number(20,4)	NOT NULL,
	PCT_DDL_SQL_STCNT			varchar2(32)	NOT NULL,
	PCT_UID_SQL_MIN  			number(20,4)	NOT NULL,
	PCT_UID_SQL_MAX  			number(20,4)	NOT NULL,
	PCT_UID_SQL_STCNT	 		varchar2(32)	NOT NULL
);

ALTER TABLE DB2SQLACTIVITYTEST_TREND ADD CONSTRAINT PK_DB2_SQLACTIVITY_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2SQLACTIVITYTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DB2SQLACTIVITYTEST_THRESH 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME_START 			date,
        MSMT_TIME_END           		date,
	DYNAMIC_SQL_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DYNAMIC_SQL_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	SELECT_SQL_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	SELECT_SQL_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	FAILED_SQL_RATE_MIN	VARCHAR2(256)		NOT NULL,
	FAILED_SQL_RATE_MAX	VARCHAR2(256)		NOT NULL,
	UID_SQL_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	UID_SQL_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_FAILED_SQL_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_FAILED_SQL_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_DDL_SQL_MIN	VARCHAR2(256)		NOT NULL,
	PCT_DDL_SQL_MAX	VARCHAR2(256)		NOT NULL,
	PCT_UID_SQL_MIN	VARCHAR2(256)		NOT NULL,
	PCT_UID_SQL_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE DB2SQLACTIVITYTEST_THRESH ADD CONSTRAINT PK_DB2_SQLACTIVITY_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_DB2SQLACTIVITYTEST_THRESH ON DB2SQLACTIVITYTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DB2TRANSACTIONTEST  CASCADE CONSTRAINTS;

CREATE TABLE DB2TRANSACTIONTEST
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
        MSMT_TIME 			date,
	COMM_STMT_RATE	 		number(20,4) 	NOT NULL,
	COMM_STMT_RATE_ST 		varchar2(32)  	NOT NULL,
	ROLLBACK_RATE		 	number(20,4) 	NOT NULL,
	ROLLBACK_RATE_ST	 	varchar2(32) 	NOT NULL,
	TRANSACTION_RATE 	        number(20,4)	NOT NULL,
	TRANSACTION_RATE_ST     	 varchar2(32)	NOT NULL
);

ALTER TABLE DB2TRANSACTIONTEST ADD CONSTRAINT PK_DB2TRANSACTIONTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DB2TRANSACTIONTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DB2TRANSACTIONTEST_TREND 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME 				date,
	PERIOD 					varchar2(32), 
	COMM_STMT_RATE_MIN 			number(20,4) 	NOT NULL,
	COMM_STMT_RATE_MAX 			number(20,4) 	NOT NULL,
	COMM_STMT_RATE_STCNT			varchar2(32) 	NOT NULL,
	ROLLBACK_RATE_MIN 			number(20,4) 	NOT NULL,
	ROLLBACK_RATE_MAX 			number(20,4) 	NOT NULL,
	ROLLBACK_RATE_STCNT			varchar2(32) 	NOT NULL,
	TRANSACTION_RATE_MIN 			number(20,4) 	NOT NULL,
	TRANSACTION_RATE_MAX 			number(20,4) 	NOT NULL,
	TRANSACTION_RATE_STCNT			varchar2(32) 	NOT NULL
);

ALTER TABLE DB2TRANSACTIONTEST_TREND ADD CONSTRAINT PK_DB2TRANSACTIONTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2TRANSACTIONTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DB2TRANSACTIONTEST_THRESH 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME_START 			date,
        MSMT_TIME_END           		date,
	COMM_STMT_RATE_MIN	VARCHAR2(256)		NOT NULL,
	COMM_STMT_RATE_MAX	VARCHAR2(256)		NOT NULL,
	ROLLBACK_RATE_MIN	VARCHAR2(256)		NOT NULL,
	ROLLBACK_RATE_MAX	VARCHAR2(256)		NOT NULL,
	TRANSACTION_RATE_MIN	VARCHAR2(256)		NOT NULL,
	TRANSACTION_RATE_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE DB2TRANSACTIONTEST_THRESH ADD CONSTRAINT PK_DB2TRANSACTIONTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2TRANSACTIONTEST_THRESH ON DB2TRANSACTIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DISKTEST CASCADE CONSTRAINTS;

CREATE TABLE DISKTEST
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	UTIL_PCT	number(20,4) 	NOT NULL,
	UTIL_PCT_ST	varchar2(32)    NOT NULL,
	READ_RATE 	number(20,4) 	NOT NULL,
	READ_RATE_ST 	varchar2(32)    NOT NULL,
	WRITE_RATE 	number(20,4) 	NOT NULL,
	WRITE_RATE_ST 	varchar2(32)    NOT NULL,
	BYTES_READ_RATE 	number(20,4) 	NOT NULL,
	BYTES_READ_RATE_ST 	varchar2(32)    NOT NULL,
	BYTES_WRITE_RATE 	number(20,4) 	NOT NULL,
	BYTES_WRITE_RATE_ST 	varchar2(32)    NOT NULL
);

ALTER TABLE DISKTEST ADD constraint PK_DISK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DISKTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE DISKTEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO         	varchar2(32),
        SITE_NAME       	varchar2(64),
        INFO            	varchar2(128), 
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD 			varchar2(32),
	UTIL_PCT_MIN		number(20,4) 	NOT NULL,
	UTIL_PCT_MAX		number(20,4) 	NOT NULL,
	UTIL_PCT_STCNT		varchar2(32)   	NOT NULL,
	READ_RATE_MIN 		number(20,4) 	NOT NULL,
	READ_RATE_MAX 		number(20,4) 	NOT NULL,
	READ_RATE_STCNT 	varchar2(32)   	NOT NULL,
	WRITE_RATE_MIN 		number(20,4) 	NOT NULL,
	WRITE_RATE_MAX 		number(20,4) 	NOT NULL,
	WRITE_RATE_STCNT 	varchar2(32)   	NOT NULL,
	BYTES_READ_RATE_MIN 		number(20,4) 	NOT NULL,
	BYTES_READ_RATE_MAX 		number(20,4) 	NOT NULL,
	BYTES_READ_RATE_STCNT 	varchar2(32)   	NOT NULL,
	BYTES_WRITE_RATE_MIN 		number(20,4) 	NOT NULL,
	BYTES_WRITE_RATE_MAX 		number(20,4) 	NOT NULL,
	BYTES_WRITE_RATE_STCNT 	varchar2(32)   	NOT NULL
);

ALTER TABLE DISKTEST_TREND ADD constraint PK_DISK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE DISKTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE DISKTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	UTIL_PCT_MIN	VARCHAR2(256)	 	NOT NULL,
	UTIL_PCT_MAX	VARCHAR2(256)	 	NOT NULL,
	READ_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	READ_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	WRITE_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	WRITE_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	BYTES_READ_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	BYTES_READ_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	BYTES_WRITE_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	BYTES_WRITE_RATE_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE DISKTEST_THRESH ADD constraint PK_DISK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DISKTEST_THRESH ON DISKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 
DROP TABLE DNSTEST CASCADE CONSTRAINTS;

CREATE TABLE DNSTEST 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO   	varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	AVAILABLE 	number(3)  	NOT NULL,
	AVAILABLE_ST 	varchar2(32)   	NOT NULL,
	RESP_TIME 	number(20,4) 	NOT NULL,
	RESP_TIME_ST	varchar2(32) 	NOT NULL
);

alter table DNSTEST add constraint PK_DNS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DNSTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE DNSTEST_TREND
(
	TRGT_HOST 			varchar2(32),
	PORT_NO   			varchar2(32),
        SITE_NAME       		varchar2(64),
        INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD				varchar2(32),
	AVAILABLE_MIN 			number(20,4)  	NOT NULL,
	AVAILABLE_MAX 			number(20,4)  	NOT NULL,
	AVAILABLE_STCNT 		varchar2(32)   	NOT NULL,
	RESP_TIME_MIN 			number(20,4) 	NOT NULL,
	RESP_TIME_MAX 			number(20,4) 	NOT NULL,
	RESP_TIME_STCNT			varchar2(32) 	NOT NULL
);

alter table DNSTEST_TREND add constraint PK_DNS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE DNSTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE DNSTEST_THRESH
(
	TRGT_HOST 	varchar2(32),
	PORT_NO   	varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date, 
	AVAILABLE_MIN	VARCHAR2(256)	    NOT NULL,
        AVAILABLE_MAX	VARCHAR2(256)	    NOT NULL,
        RESP_TIME_MIN	VARCHAR2(256)	 NOT NULL,
        RESP_TIME_MAX	VARCHAR2(256)	 NOT NULL
);

alter table DNSTEST_THRESH add constraint PK_DNS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DNSTEST_THRESH ON DNSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE   DocReceiveTest CASCADE CONSTRAINTS;

CREATE TABLE DocReceiveTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	receive_Rate			NUMBER(20,4) NOT NULL,
	receive_Rate_ST			VARCHAR2(32) NOT NULL
);

ALTER TABLE  DocReceiveTest ADD constraint PK_DocReceiveTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   DocReceiveTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE DocReceiveTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	receive_Rate_MIN		NUMBER(20,4) NOT NULL,
	receive_Rate_MAX		NUMBER(20,4) NOT NULL,
	receive_Rate_STCNT		VARCHAR2(32) NOT NULL
	);

ALTER TABLE DocReceiveTest_TREND ADD constraint PK_DocReceiveTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   DocReceiveTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE DocReceiveTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	RECEIVE_RATE_MIN	VARCHAR2(256)	 NOT NULL,
      	RECEIVE_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE DocReceiveTest_THRESH ADD constraint PK_DocReceiveTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DocReceiveTest_THRESH ON DocReceiveTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE DocSubmitTest CASCADE CONSTRAINTS;

CREATE TABLE DocSubmitTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	submit_Rate			NUMBER(20,4) NOT NULL,
	submit_Rate_ST			VARCHAR2(32) NOT NULL,
	mapped_Rate			NUMBER(20,4) NOT NULL,
	mapped_Rate_ST			VARCHAR2(32) NOT NULL,
	parsed_Rate			NUMBER(20,4) NOT NULL,
	parsed_Rate_ST			VARCHAR2(32) NOT NULL,
	process_Rate			NUMBER(20,4) NOT NULL,
	process_Rate_ST			VARCHAR2(32) NOT NULL
	);

ALTER TABLE DocSubmitTest ADD constraint PK_DOCSUBMIT
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   DocSubmitTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE DocSubmitTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	submit_Rate_MIN			NUMBER(20,4) NOT NULL,
	submit_Rate_MAX			NUMBER(20,4) NOT NULL,
	submit_Rate_STCNT		VARCHAR2(32) NOT NULL,
	mapped_Rate_MIN		NUMBER(20,4) NOT NULL,
	mapped_Rate_MAX		NUMBER(20,4) NOT NULL,
	mapped_Rate_STCNT		VARCHAR2(32) NOT NULL,
	parsed_Rate_MIN		NUMBER(20,4) NOT NULL,
	parsed_Rate_MAX		NUMBER(20,4) NOT NULL,
	parsed_Rate_STCNT		VARCHAR2(32) NOT NULL,
	process_Rate_MIN		NUMBER(20,4) NOT NULL,
	process_Rate_MAX		NUMBER(20,4) NOT NULL,
	process_Rate_STCNT		VARCHAR2(32) NOT NULL
	);

ALTER TABLE DocSubmitTest_TREND ADD constraint PK_DocSubmitTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   DocSubmitTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE DocSubmitTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	SUBMIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	SUBMIT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	MAPPED_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	MAPPED_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	PARSED_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	PARSED_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	PROCESS_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	PROCESS_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE DocSubmitTest_THRESH ADD constraint PK_DocSubmitTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DocSubmitTest_THRESH ON DocSubmitTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE DOMINODBTEST  CASCADE CONSTRAINTS;

CREATE TABLE DOMINODBTEST
(
	TRGT_HOST 					varchar2(32),
    PORT_NO                		varchar2(32),
    SITE_NAME               	varchar2(64),
    INFO                    	varchar2(128),
	MSMT_HOST 					varchar2(32), 
    MSMT_TIME 					date,
	CACHE_CURR_ENTRIES	 		number(20,4) 	NOT NULL,
	CACHE_CURR_ENTRIES_ST 		varchar2(32) 	NOT NULL,
	CACHE_MAX_ENTRIES		 	number(20,4) 	NOT NULL,
	CACHE_MAX_ENTRIES_ST 		varchar2(32) 	NOT NULL,
	CACHE_HT_RATIO		 		number(20,4) 	NOT NULL,
	CACHE_HT_RATIO_ST 			varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINODBTEST ADD CONSTRAINT PK_DOMINODBTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DOMINODBTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DOMINODBTEST_TREND 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME 						date,
	PERIOD 							varchar2(32), 
	CACHE_CURR_ENTRIES_MIN	 		number(20,4) 	NOT NULL,
	CACHE_CURR_ENTRIES_MAX 			varchar2(32) 	NOT NULL,
	CACHE_CURR_ENTRIES_STCNT		varchar2(32) 	NOT NULL,
	CACHE_MAX_ENTRIES_MIN	 		number(20,4) 	NOT NULL,
	CACHE_MAX_ENTRIES_MAX 			varchar2(32) 	NOT NULL,
	CACHE_MAX_ENTRIES_STCNT			varchar2(32) 	NOT NULL,
	CACHE_HT_RATIO_MIN	 			number(20,4) 	NOT NULL,
	CACHE_HT_RATIO_MAX 				varchar2(32) 	NOT NULL,
	CACHE_HT_RATIO_STCNT			varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINODBTEST_TREND ADD CONSTRAINT PK_DOMINODBTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINODBTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DOMINODBTEST_THRESH 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME_START 				date,
    MSMT_TIME_END           		date,
	CACHE_CURR_ENTRIES_MIN	VARCHAR2(256)	 	NOT NULL,
	CACHE_CURR_ENTRIES_MAX	VARCHAR2(256)	 	NOT NULL,
	CACHE_MAX_ENTRIES_MIN	VARCHAR2(256)	 	NOT NULL,
	CACHE_MAX_ENTRIES_MAX	VARCHAR2(256)	 	NOT NULL,
	CACHE_HT_RATIO_MIN	VARCHAR2(256)	 	NOT NULL,
	CACHE_HT_RATIO_MAX	VARCHAR2(256)	 	NOT NULL
);
ALTER TABLE DOMINODBTEST_THRESH ADD CONSTRAINT PK_DOMINODBTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINODBTEST_THRESH ON DOMINODBTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DOMINOMAILSTATSTEST  CASCADE CONSTRAINTS;

CREATE TABLE DOMINOMAILSTATSTEST
(
	TRGT_HOST 					varchar2(32),
    PORT_NO                		varchar2(32),
    SITE_NAME               	varchar2(64),
    INFO                    	varchar2(128),
	MSMT_HOST 					varchar2(32), 
    MSMT_TIME 					date,
	DELIVERED_MAIL_RATE	 		number(20,4) 	NOT NULL,
	DELIVERED_MAIL_RATE_ST 		varchar2(32) 	NOT NULL,
	PCT_DEAD_MAILS		 		number(20,4) 	NOT NULL,
	PCT_DEAD_MAILS_ST 			varchar2(32) 	NOT NULL,
	NUM_MAIL_WAITING 		 	number(20,4) 	NOT NULL,
	NUM_MAIL_WAITING_ST 		varchar2(32) 	NOT NULL,
	MAIL_DELIVERY_TIME			number(20,4) 	NOT NULL,
	MAIL_DELIVERY_TIME_ST 		varchar2(32) 	NOT NULL,
	PCT_TRANSFER_FAIL 			number(20,4) 	NOT NULL,
	PCT_TRANSFER_FAIL_ST 		varchar2(32) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV		number(20,4) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_ST 	varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINOMAILSTATSTEST ADD CONSTRAINT PK_DOMINOMAILSTATSTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DOMINOMAILSTATSTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DOMINOMAILSTATSTEST_TREND 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME 						date,
	PERIOD 							varchar2(32), 
	DELIVERED_MAIL_RATE_MIN	 		number(20,4) 	NOT NULL,
	DELIVERED_MAIL_RATE_MAX 		varchar2(32) 	NOT NULL,
	DELIVERED_MAIL_RATE_STCNT		varchar2(32) 	NOT NULL,
	PCT_DEAD_MAILS_MIN	 			number(20,4) 	NOT NULL,
	PCT_DEAD_MAILS_MAX 				varchar2(32) 	NOT NULL,
	PCT_DEAD_MAILS_STCNT			varchar2(32) 	NOT NULL,
	NUM_MAIL_WAITING_MIN	 		number(20,4) 	NOT NULL,
	NUM_MAIL_WAITING_MAX 			varchar2(32) 	NOT NULL,
	NUM_MAIL_WAITING_STCNT			varchar2(32) 	NOT NULL,
	MAIL_DELIVERY_TIME_MIN	 		number(20,4) 	NOT NULL,
	MAIL_DELIVERY_TIME_MAX 			varchar2(32) 	NOT NULL,
	MAIL_DELIVERY_TIME_STCNT		varchar2(32) 	NOT NULL,
	PCT_TRANSFER_FAIL_MIN	 		number(20,4) 	NOT NULL,
	PCT_TRANSFER_FAIL_MAX 			varchar2(32) 	NOT NULL,
	PCT_TRANSFER_FAIL_STCNT			varchar2(32) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MIN	 		number(20,4) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MAX 		varchar2(32) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINOMAILSTATSTEST_TREND ADD CONSTRAINT PK_DOMINOMAILSTATSTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINOMAILSTATSTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DOMINOMAILSTATSTEST_THRESH 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME_START 				date,
    MSMT_TIME_END           		date,
	DELIVERED_MAIL_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DELIVERED_MAIL_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_DEAD_MAILS_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_DEAD_MAILS_MAX	VARCHAR2(256)	 	NOT NULL,
	NUM_MAIL_WAITING_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_MAIL_WAITING_MAX	VARCHAR2(256)	 	NOT NULL,
	MAIL_DELIVERY_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	MAIL_DELIVERY_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_TRANSFER_FAIL_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_TRANSFER_FAIL_MAX	VARCHAR2(256)	 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MIN	VARCHAR2(256)	 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MAX	VARCHAR2(256)	 	NOT NULL
);
ALTER TABLE DOMINOMAILSTATSTEST_THRESH ADD CONSTRAINT PK_DOMINOMAILSTATSTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINOMAILSTATSTEST_THRESH ON DOMINOMAILSTATSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DOMINOMEMTEST  CASCADE CONSTRAINTS;
CREATE TABLE DOMINOMEMTEST
(
	TRGT_HOST 					varchar2(32),
    PORT_NO                		varchar2(32),
    SITE_NAME               	varchar2(64),
    INFO                    	varchar2(128),
	MSMT_HOST 					varchar2(32), 
    MSMT_TIME 					date,
	TOTAL_MEM_ALLOCATED	 		number(20,4) 	NOT NULL,
	TOTAL_MEM_ALLOCATED_ST 		varchar2(32) 	NOT NULL,
	MEM_ALLOC_PROCESS		 	number(20,4) 	NOT NULL,
	MEM_ALLOC_PROCESS_ST 		varchar2(32) 	NOT NULL,
	MEM_ALLOC_SHARED		 	number(20,4) 	NOT NULL,
	MEM_ALLOC_SHARED_ST 		varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINOMEMTEST ADD CONSTRAINT PK_DOMINOMEMTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DOMINOMEMTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DOMINOMEMTEST_TREND 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME 						date,
	PERIOD 							varchar2(32), 
	TOTAL_MEM_ALLOCATED_MIN	 		number(20,4) 	NOT NULL,
	TOTAL_MEM_ALLOCATED_MAX 		varchar2(32) 	NOT NULL,
	TOTAL_MEM_ALLOCATED_STCNT		varchar2(32) 	NOT NULL,
	MEM_ALLOC_PROCESS_MIN	 		number(20,4) 	NOT NULL,
	MEM_ALLOC_PROCESS_MAX 			varchar2(32) 	NOT NULL,
	MEM_ALLOC_PROCESS_STCNT			varchar2(32) 	NOT NULL,
	MEM_ALLOC_SHARED_MIN	 		number(20,4) 	NOT NULL,
	MEM_ALLOC_SHARED_MAX 			varchar2(32) 	NOT NULL,
	MEM_ALLOC_SHARED_STCNT			varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINOMEMTEST_TREND ADD CONSTRAINT PK_DOMINOMEMTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINOMEMTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DOMINOMEMTEST_THRESH 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME_START 				date,
    MSMT_TIME_END           		date,
	TOTAL_MEM_ALLOCATED_MIN	VARCHAR2(256)	 	NOT NULL,
	TOTAL_MEM_ALLOCATED_MAX	VARCHAR2(256)	 	NOT NULL,
	MEM_ALLOC_PROCESS_MIN	VARCHAR2(256)	 	NOT NULL,
	MEM_ALLOC_PROCESS_MAX	VARCHAR2(256)	 	NOT NULL,
	MEM_ALLOC_SHARED_MIN	VARCHAR2(256)	 	NOT NULL,
	MEM_ALLOC_SHARED_MAX	VARCHAR2(256)	 	NOT NULL
);
ALTER TABLE DOMINOMEMTEST_THRESH ADD CONSTRAINT PK_DOMINOMEMTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINOMEMTEST_THRESH ON DOMINOMEMTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DOMINONETTEST  CASCADE CONSTRAINTS;

CREATE TABLE DOMINONETTEST
(
	TRGT_HOST 					varchar2(32),
    PORT_NO                		varchar2(32),
    SITE_NAME               	varchar2(64),
    INFO                    	varchar2(128),
	MSMT_HOST 					varchar2(32), 
    MSMT_TIME 					date,
	DATA_RCVD_RATE	 			number(20,4) 	NOT NULL,
	DATA_RCVD_RATE_ST 			varchar2(32) 	NOT NULL,
	DATA_SENT_RATE		 		number(20,4) 	NOT NULL,
	DATA_SENT_RATE_ST 			varchar2(32) 	NOT NULL,
	IN_SESSION_RATE 		 	number(20,4) 	NOT NULL,
	IN_SESSION_RATE_ST 			varchar2(32) 	NOT NULL,
	OUT_SESSION_RATE			number(20,4) 	NOT NULL,
	OUT_SESSION_RATE_ST 		varchar2(32) 	NOT NULL,
	DROP_SESSION_RATE			number(20,4) 	NOT NULL,
	DROP_SESSION_RATE_ST 		varchar2(32) 	NOT NULL,
	CONCURR_SESSION_LIMIT		number(20,4) 	NOT NULL,
	CONCURR_SESSION_LIMIT_ST 	varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINONETTEST ADD CONSTRAINT PK_DOMINONETTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DOMINONETTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DOMINONETTEST_TREND 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME 						date,
	PERIOD 							varchar2(32), 
	DATA_RCVD_RATE_MIN	 			number(20,4) 	NOT NULL,
	DATA_RCVD_RATE_MAX 			varchar2(32) 	NOT NULL,
	DATA_RCVD_RATE_STCNT			varchar2(32) 	NOT NULL,
	DATA_SENT_RATE_MIN	 			number(20,4) 	NOT NULL,
	DATA_SENT_RATE_MAX 			varchar2(32) 	NOT NULL,
	DATA_SENT_RATE_STCNT			varchar2(32) 	NOT NULL,
	IN_SESSION_RATE_MIN	 			number(20,4) 	NOT NULL,
	IN_SESSION_RATE_MAX 			varchar2(32) 	NOT NULL,
	IN_SESSION_RATE_STCNT			varchar2(32) 	NOT NULL,
	OUT_SESSION_RATE_MIN	 		number(20,4) 	NOT NULL,
	OUT_SESSION_RATE_MAX 			varchar2(32) 	NOT NULL,
	OUT_SESSION_RATE_STCNT			varchar2(32) 	NOT NULL,
	DROP_SESSION_RATE_MIN	 		number(20,4) 	NOT NULL,
	DROP_SESSION_RATE_MAX 			varchar2(32) 	NOT NULL,
	DROP_SESSION_RATE_STCNT			varchar2(32) 	NOT NULL,
	CONCURR_SESSION_LIMIT_MIN 		number(20,4) 	NOT NULL,
	CONCURR_SESSION_LIMIT_MAX 		varchar2(32) 	NOT NULL,
	CONCURR_SESSION_LIMIT_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINONETTEST_TREND ADD CONSTRAINT PK_DOMINONETTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINONETTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DOMINONETTEST_THRESH 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME_START 				date,
    MSMT_TIME_END           		date,
	DATA_RCVD_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DATA_RCVD_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DATA_SENT_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DATA_SENT_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	IN_SESSION_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	IN_SESSION_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	OUT_SESSION_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	OUT_SESSION_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DROP_SESSION_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DROP_SESSION_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	CONCURR_SESSION_LIMIT_MIN	VARCHAR2(256)	 	NOT NULL,
	CONCURR_SESSION_LIMIT_MAX	VARCHAR2(256)	 	NOT NULL
);
ALTER TABLE DOMINONETTEST_THRESH ADD CONSTRAINT PK_DOMINONETTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINONETTEST_THRESH ON DOMINONETTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE EG_HELP CASCADE CONSTRAINTS;

CREATE TABLE EG_HELP
(
        SECTION            varchar2(32),
        MODULE              varchar2(32),
        SUB_MODULE	     varchar2(64),
	ID		     number,
	TITLE		    VARCHAR2(256) NOT NULL,
	PARA1		    VARCHAR2(1024) NOT NULL, 
	PARA2		    VARCHAR2(1024),
	PARA3	            VARCHAR2(1024),
	PARA4	            VARCHAR2(1024),
	PARA5		    VARCHAR2(1024), 
	PARA6		    VARCHAR2(1024),
	PARA7	            VARCHAR2(1024),
	PARA8	            VARCHAR2(1024),
	PARA9		    VARCHAR2(1024), 
	PARA10		    VARCHAR2(1024),
	PARA11	            VARCHAR2(1024),
	PARA12	            VARCHAR2(1024)
);

ALTER TABLE EG_HELP ADD CONSTRAINT PK_EG_HELP
primary key (
        SECTION            ,
        MODULE             ,
        SUB_MODULE	   ,
	ID		   
) ;

DROP TABLE EG_HELP_REF CASCADE CONSTRAINTS;

CREATE TABLE EG_HELP_REF 
(
        PAGE_REF      varchar2(128),
        ID            number
);

ALTER TABLE EG_HELP_REF ADD CONSTRAINT PK_EG_HELP_REF 
PRIMARY KEY (PAGE_REF) ;

DROP TABLE EJBNAMES CASCADE CONSTRAINTS;

CREATE TABLE EJBNAMES
(
	TEST_NAME 	varchar2(64),
	TRGT_HOST 	varchar2(32),
	PORT_NO 	varchar2(32),
        EJB             varchar2(256)
);
ALTER TABLE EJBNAMES ADD CONSTRAINT PK_EJBNAMES
PRIMARY KEY (TEST_NAME,TRGT_HOST,PORT_NO,EJB);

DROP TABLE ERR_TBL CASCADE CONSTRAINTS;

CREATE TABLE ERR_TBL 
(
      TRGT_HOST            varchar2(32),
      PORT_NO              varchar2(32),
      SITE_NAME            varchar2(64),
      INFO                 varchar2(128),
      MSMT_TIME            date,
      TEST_NAME            varchar2(128) NOT NULL,
      MSMT_NAME            varchar2(128) NOT NULL,  
      MSMT_HOST            varchar2(32)  NOT NULL,
      STATE                VARCHAR2(32)  NOT NULL
);

alter table ERR_TBL add constraint PK_ERRTBLE
primary key (TRGT_HOST,PORT_NO,SITE_NAME,INFO,TEST_NAME,MSMT_NAME,MSMT_HOST);
CREATE INDEX IDX_err_tbl ON err_tbl(MSMT_TIME); 
create index idx1_err_tbl on err_tbl(site_name);

DROP TABLE FIXTABLE CASCADE CONSTRAINTS;

CREATE TABLE FIXTABLE 
(
        SITE_NAME		varchar2(64),
        COMP_NAME		varchar2(64),
        COMP_TYPE		varchar2(32),
        INFO			varchar2(128),
        TEST_name		varchar2(64),
        MEASURE            	varchar2(64),
	MSMT_TIME            	date,
	FIX_DATE            	date NOT NULL,
	PROB_REASON            	varchar2(4000)    NOT NULL,
	PROB_FIX            	varchar2(4000)    NOT NULL,
	PROB_FIXED_BY           varchar2(600)    NOT NULL
);
ALTER TABLE FIXTABLE ADD CONSTRAINT PK_FIXTABLE 
PRIMARY KEY (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_name,MEASURE,MSMT_TIME) ;
create index idx_fixtable on fixtable (site_name);
CREATE INDEX IDX1_FIXTABLE ON FIXTABLE (MSMT_TIME);
DROP TABLE FTPTEST CASCADE CONSTRAINTS;

CREATE TABLE FTPTEST
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	AVAILABILITY			number(3)	      NOT NULL,
	AVAILABILITY_ST			varchar2(32)	NOT NULL,
	TOT_RESPONSE_TIME 		number(20,4)		NOT NULL,
	TOT_RESPONSE_TIME_ST 		varchar2(32)	NOT NULL,
	TCP_AVAIL			number(3)		NOT NULL,
	TCP_AVAIL_ST			varchar2(32)	NOT NULL,
	TCP_CONN_TIME			number(20,4)		NOT NULL,
	TCP_CONN_TIME_ST 		varchar2(23)	NOT NULL,
	AUTHENTICATE_STATUS		number(3)		NOT NULL,
	AUTHENTICATE_STATUS_ST  	varchar2(32)	NOT NULL,
	AUTHENTICATE_TIME		number(20,4)		NOT NULL,
	AUTHENTICATE_TIME_ST		varchar2(32)	NOT NULL
);

ALTER TABLE FTPTEST ADD constraint PK_FTP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE FTPTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE FTPTEST_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 			varchar2(32),
	AVAILABILITY_MIN		number(20,4)		NOT NULL,	
	AVAILABILITY_MAX		number(20,4)		NOT NULL,
	AVAILABILITY_STCNT		varchar2(32)	NOT NULL,
	TOT_RESPONSE_TIME_MIN	number(20,4)		NOT NULL,
	TOT_RESPONSE_TIME_MAX	number(20,4)		NOT NULL,
	TOT_RESPONSE_TIME_STCNT	varchar2(32)	NOT NULL,
	TCP_AVAIL_MIN		number(20,4)		NOT NULL,
	TCP_AVAIL_MAX		number(20,4)		NOT NULL,
	TCP_AVAIL_STCNT		varchar2(32)	NOT NULL,
	TCP_CONN_TIME_MIN		number(20,4)		NOT NULL,
	TCP_CONN_TIME_MAX	number(20,4)		NOT NULL,
	TCP_CONN_TIME_STCNT		varchar2(32)	NOT NULL,
	AUTHENTICATE_STATUS_MIN	number(20,4)		NOT NULL,
	AUTHENTICATE_STATUS_MAX	number(20,4)		NOT NULL,
	AUTHENTICATE_STATUS_STCNT varchar2(32)    NOT NULL,
	AUTHENTICATE_TIME_MIN	number(20,4)		NOT NULL,
	AUTHENTICATE_TIME_MAX	number(20,4)		NOT NULL,
	AUTHENTICATE_TIME_STCNT varchar2(32)	NOT NULL
);

ALTER TABLE FTPTEST_TREND ADD constraint PK_FTP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE FTPTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE FTPTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
        MSMT_TIME_END   		date,
	AVAILABILITY_MIN	VARCHAR2(256)			NOT NULL,
	AVAILABILITY_MAX	VARCHAR2(256)			NOT NULL,
	TOT_RESPONSE_TIME_MIN	VARCHAR2(256)			NOT NULL,
	TOT_RESPONSE_TIME_MAX	VARCHAR2(256)			NOT NULL,
	TCP_AVAIL_MIN	VARCHAR2(256)			NOT NULL,
	TCP_AVAIL_MAX	VARCHAR2(256)			NOT NULL,
	TCP_CONN_TIME_MIN	VARCHAR2(256)			NOT NULL,
	TCP_CONN_TIME_MAX	VARCHAR2(256)			NOT NULL,
	AUTHENTICATE_STATUS_MIN	VARCHAR2(256)			NOT NULL,
	AUTHENTICATE_STATUS_MAX	VARCHAR2(256)			NOT NULL,
	AUTHENTICATE_TIME_MIN	VARCHAR2(256)			NOT NULL,
	AUTHENTICATE_TIME_MAX	VARCHAR2(256)			NOT NULL
);

ALTER TABLE FTPTEST_THRESH ADD constraint PK_FTP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_FTPTEST_THRESH ON FTPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     

DROP TABLE HTTPTEST CASCADE CONSTRAINTS;
CREATE TABLE HTTPTEST 
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME       	date,
	AVAILABLE       	number(3)     	NOT NULL,
	AVAILABLE_ST       	varchar2(32)     	NOT NULL,
	RESP_TIME       	number(20,4)  	NOT NULL,
	RESP_TIME_ST    	varchar2(32)  	NOT NULL,
	TCP_CONN_AVAIL  	number(3)     	NOT NULL,	
        TCP_CONN_AVAIL_ST  	varchar2(32)     	NOT NULL,
	TCP_CONN_TIME   	number(20,4)  	NOT NULL,
	TCP_CONN_TIME_ST   	varchar2(32)  	NOT NULL,
	SVR_RESP_TIME   	number(20,4)  	NOT NULL,
	SVR_RESP_TIME_ST   	varchar2(32)  	NOT NULL,
	CONTENT_VAL   		number(3)  	NOT NULL,
	CONTENT_VAL_ST   	varchar2(32)  	NOT NULL,
	RESP_CODE   		number(3)  	NOT NULL,
	RESP_CODE_ST   		varchar2(32)  	NOT NULL,
	CONTENT_LEN   		number(20,4)  	NOT NULL,
	CONTENT_LEN_ST   	varchar2(32)  	NOT NULL,
	DATA_XFER_TIME   	number(20,4)  	NOT NULL,
	DATA_XFER_TIME_ST   	varchar2(32)  	NOT NULL,
	DNS_AVAILABILITY   	number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_ST   	varchar2(32)  	NOT NULL,
	DNS_RESP_TIME   	number(20,4)  	NOT NULL,
	DNS_RESP_TIME_ST   	varchar2(32)  	NOT NULL
);
alter table HTTPTEST add constraint PK_HTTP PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HTTPTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE HTTPTEST_TREND
(
	TRGT_HOST       		varchar2(32),
	PORT_NO         		varchar2(32),
        SITE_NAME              		varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME       		date,
	PERIOD       			varchar2(32), 
	AVAILABLE_MIN       		number(20,4)     	NOT NULL,
	AVAILABLE_MAX       		number(20,4)     	NOT NULL,
	AVAILABLE_STCNT       		varchar2(32)    NOT NULL,
	RESP_TIME_MIN       		number(20,4)  	NOT NULL,
	RESP_TIME_MAX       		number(20,4)  	NOT NULL,
	RESP_TIME_STCNT    		varchar2(32)  	NOT NULL,
	TCP_CONN_AVAIL_MIN  		number(20,4)     	NOT NULL,	
	TCP_CONN_AVAIL_MAX  		number(20,4)     	NOT NULL,	
        TCP_CONN_AVAIL_STCNT		varchar2(32)    NOT NULL,
	TCP_CONN_TIME_MIN   		number(20,4)  	NOT NULL,
	TCP_CONN_TIME_MAX   		number(20,4)  	NOT NULL,
	TCP_CONN_TIME_STCNT		varchar2(32)  	NOT NULL,
	SVR_RESP_TIME_MIN   		number(20,4)  	NOT NULL,
	SVR_RESP_TIME_MAX   		number(20,4)  	NOT NULL,
	SVR_RESP_TIME_STCNT   		varchar2(32)  	NOT NULL,
	CONTENT_VAL_MIN   		number(20,4)  	NOT NULL,
	CONTENT_VAL_MAX   		number(20,4)  	NOT NULL,
	CONTENT_VAL_STCNT   		varchar2(32)  	NOT NULL,
	RESP_CODE_MIN   		number(20,4)  	NOT NULL,
	RESP_CODE_MAX   		number(20,4)  	NOT NULL,
	RESP_CODE_STCNT   		varchar2(32)  	NOT NULL,
	CONTENT_LEN_MIN   		number(20,4)  	NOT NULL,
	CONTENT_LEN_MAX   		number(20,4)  	NOT NULL,
	CONTENT_LEN_STCNT   		varchar2(32)  	NOT NULL,
	DATA_XFER_TIME_MIN   		number(20,4)  	NOT NULL,
	DATA_XFER_TIME_MAX   		number(20,4)  	NOT NULL,
	DATA_XFER_TIME_STCNT   		varchar2(32)  	NOT NULL,
	DNS_AVAILABILITY_MIN   		number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_MAX   		number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_STCNT   	varchar2(32)  	NOT NULL,
	DNS_RESP_TIME_MIN   		number(20,4)  	NOT NULL,
	DNS_RESP_TIME_MAX   		number(20,4)  	NOT NULL,
	DNS_RESP_TIME_STCNT   	        varchar2(32)  	NOT NULL
);
alter table HTTPTEST_TREND add constraint PK_HTTP_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE HTTPTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HTTPTEST_THRESH
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START       	date,
        MSMT_TIME_END           date,
        AVAILABLE_MIN	VARCHAR2(256)	     NOT NULL,
        AVAILABLE_MAX	VARCHAR2(256)	     NOT NULL,
        RESP_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        RESP_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        TCP_CONN_AVAIL_MIN	VARCHAR2(256)	     NOT NULL,
        TCP_CONN_AVAIL_MAX	VARCHAR2(256)	     NOT NULL,
        TCP_CONN_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        TCP_CONN_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        SVR_RESP_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        SVR_RESP_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        CONTENT_VAL_MIN	VARCHAR2(256)	  NOT NULL,
        CONTENT_VAL_MAX	VARCHAR2(256)	  NOT NULL,
        RESP_CODE_MIN	VARCHAR2(256)	  NOT NULL,
        RESP_CODE_MAX	VARCHAR2(256)	  NOT NULL,
        CONTENT_LEN_MIN	VARCHAR2(256)	  NOT NULL,
        CONTENT_LEN_MAX	VARCHAR2(256)	  NOT NULL,
	DATA_XFER_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        DATA_XFER_TIME_MAX	VARCHAR2(256)	  NOT NULL,
	DNS_AVAILABILITY_MIN	VARCHAR2(256)	  NOT NULL,
        DNS_AVAILABILITY_MAX	VARCHAR2(256)	  NOT NULL,
	DNS_RESP_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        DNS_RESP_TIME_MAX	VARCHAR2(256)	  NOT NULL
);
alter table HTTPTEST_THRESH add constraint PK_HTTP_THRESH PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_HTTPTEST_THRESH ON HTTPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);   

DROP TABLE HTTPPOSTTEST CASCADE CONSTRAINTS;
CREATE TABLE HTTPPOSTTEST 
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME       	date,
	AVAILABLE       	number(3)     	NOT NULL,
	AVAILABLE_ST       	varchar2(32)     	NOT NULL,
	RESP_TIME       	number(20,4)  	NOT NULL,
	RESP_TIME_ST    	varchar2(32)  	NOT NULL,
	TCP_CONN_AVAIL  	number(3)     	NOT NULL,	
        TCP_CONN_AVAIL_ST  	varchar2(32)     	NOT NULL,
	TCP_CONN_TIME   	number(20,4)  	NOT NULL,
	TCP_CONN_TIME_ST   	varchar2(32)  	NOT NULL,
	SVR_RESP_TIME   	number(20,4)  	NOT NULL,
	SVR_RESP_TIME_ST   	varchar2(32)  	NOT NULL,
	CONTENT_VAL   		number(3)  	NOT NULL,
	CONTENT_VAL_ST   	varchar2(32)  	NOT NULL,
	RESP_CODE   		number(3)  	NOT NULL,
	RESP_CODE_ST   		varchar2(32)  	NOT NULL,
	CONTENT_LEN   		number(20,4)  	NOT NULL,
	CONTENT_LEN_ST   	varchar2(32)  	NOT NULL,
	DATA_XFER_TIME   	number(20,4)  	NOT NULL,
	DATA_XFER_TIME_ST   	varchar2(32)  	NOT NULL,
	DNS_AVAILABILITY   	number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_ST   	varchar2(32)  	NOT NULL
);

alter table HTTPPOSTTEST add constraint PK_HTTPPOST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HTTPPOSTTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE HTTPPOSTTEST_TREND
(
	TRGT_HOST       		varchar2(32),
	PORT_NO         		varchar2(32),
        SITE_NAME              		varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME       		date,
	PERIOD       			varchar2(32), 
	AVAILABLE_MIN       		number(20,4)     	NOT NULL,
	AVAILABLE_MAX       		number(20,4)     	NOT NULL,
	AVAILABLE_STCNT       		varchar2(32)    NOT NULL,
	RESP_TIME_MIN       		number(20,4)  	NOT NULL,
	RESP_TIME_MAX       		number(20,4)  	NOT NULL,
	RESP_TIME_STCNT    		varchar2(32)  	NOT NULL,
	TCP_CONN_AVAIL_MIN  		number(20,4)     	NOT NULL,	
	TCP_CONN_AVAIL_MAX  		number(20,4)     	NOT NULL,	
        TCP_CONN_AVAIL_STCNT		varchar2(32)    NOT NULL,
	TCP_CONN_TIME_MIN   		number(20,4)  	NOT NULL,
	TCP_CONN_TIME_MAX   		number(20,4)  	NOT NULL,
	TCP_CONN_TIME_STCNT		varchar2(32)  	NOT NULL,
	SVR_RESP_TIME_MIN   		number(20,4)  	NOT NULL,
	SVR_RESP_TIME_MAX   		number(20,4)  	NOT NULL,
	SVR_RESP_TIME_STCNT   		varchar2(32)  	NOT NULL,
	CONTENT_VAL_MIN   		number(20,4)  	NOT NULL,
	CONTENT_VAL_MAX   		number(20,4)  	NOT NULL,
	CONTENT_VAL_STCNT   		varchar2(32)  	NOT NULL,
	RESP_CODE_MIN   		number(20,4)  	NOT NULL,
	RESP_CODE_MAX   		number(20,4)  	NOT NULL,
	RESP_CODE_STCNT   		varchar2(32)  	NOT NULL,
	CONTENT_LEN_MIN   		number(20,4)  	NOT NULL,
	CONTENT_LEN_MAX   		number(20,4)  	NOT NULL,
	CONTENT_LEN_STCNT   		varchar2(32)  	NOT NULL,
	DATA_XFER_TIME_MIN   		number(20,4)  	NOT NULL,
	DATA_XFER_TIME_MAX   		number(20,4)  	NOT NULL,
	DATA_XFER_TIME_STCNT   		varchar2(32)  	NOT NULL,
	DNS_AVAILABILITY_MIN   		number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_MAX   		number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_STCNT   	varchar2(32)  	NOT NULL
);

alter table HTTPPOSTTEST_TREND add constraint PK_HTTPPOST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE HTTPPOSTTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HTTPPOSTTEST_THRESH
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START       	date,
        MSMT_TIME_END           date,
        AVAILABLE_MIN	VARCHAR2(256)	     NOT NULL,
        AVAILABLE_MAX	VARCHAR2(256)	     NOT NULL,
        RESP_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        RESP_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        TCP_CONN_AVAIL_MIN	VARCHAR2(256)	     NOT NULL,
        TCP_CONN_AVAIL_MAX	VARCHAR2(256)	     NOT NULL,
        TCP_CONN_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        TCP_CONN_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        SVR_RESP_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        SVR_RESP_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        CONTENT_VAL_MIN	VARCHAR2(256)	  NOT NULL,
        CONTENT_VAL_MAX	VARCHAR2(256)	  NOT NULL,
        RESP_CODE_MIN	VARCHAR2(256)	  NOT NULL,
        RESP_CODE_MAX	VARCHAR2(256)	  NOT NULL,
        CONTENT_LEN_MIN	VARCHAR2(256)	  NOT NULL,
        CONTENT_LEN_MAX	VARCHAR2(256)	  NOT NULL,
	DATA_XFER_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        DATA_XFER_TIME_MAX	VARCHAR2(256)	  NOT NULL,
	DNS_AVAILABILITY_MIN	VARCHAR2(256)	  NOT NULL,
        DNS_AVAILABILITY_MAX	VARCHAR2(256)	  NOT NULL
);

alter table HTTPPOSTTEST_THRESH add constraint PK_HTTPPOST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_HTTPPOSTTEST_THRESH ON HTTPPOSTTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 

DROP TABLE IISXChgLayerTest CASCADE CONSTRAINTS;
CREATE TABLE IISXChgLayerTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	clientQSize			Number(20,4) not null,
	clientQSize_st		varchar2(32) not null,
	rpcOperationsRate		number(20,4) not null,
	rpcOperationsRate_st		varchar2(32) not null
);

ALTER TABLE IISXChgLayerTest ADD constraint PK_IISXChgLayerTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   IISXChgLayerTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE IISXChgLayerTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	clientQSize_min		Number(20,4) not null,
	clientQSize_max		Number(20,4) not null,
	clientQSize_stcnt		varchar2(32) not null,
	rpcOperationsRate_min		number(20,4) not null,
	rpcOperationsRate_max		number(20,4) not null,
	rpcOperationsRate_stcnt		varchar2(32) not null
);

ALTER TABLE IISXChgLayerTest_TREND ADD constraint PK_IISXChgLayerTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   IISXChgLayerTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE IISXChgLayerTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	CLIENTQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	CLIENTQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	RPCOPERATIONSRATE_MIN	VARCHAR2(256)	 NOT NULL,
	RPCOPERATIONSRATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE IISXChgLayerTest_THRESH ADD constraint PK_IISXChgLayerTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_IISXChgLayerTest_THRESH ON IISXChgLayerTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE InterChangeRcvdTest CASCADE CONSTRAINTS;

CREATE TABLE InterChangeRcvdTest
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	decode_Rate		number(20,4) not null,
	decode_Rate_ST		varchar2(32) not null,
	decrypt_Rate		number(20,4) not null,
	decrypt_Rate_ST		varchar2(32) not null,
	receive_Rate		number(20,4) not null,
	receive_Rate_ST		varchar2(32) not null
);

ALTER TABLE InterChangeRcvdTest ADD constraint PK_InterChangeRcvdTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE InterChangeRcvdTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE InterChangeRcvdTest_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	decode_Rate_MIN		number(20,4) not null,
	decode_Rate_MAX		number(20,4) not null,
	decode_Rate_STCNT	varchar2(32) not null,
	decrypt_Rate_MIN	number(20,4) not null,
	decrypt_Rate_MAX	number(20,4) not null,
	decrypt_Rate_STCNT	varchar2(32) not null,
	receive_Rate_MIN	number(20,4) not null,
	receive_Rate_MAX	number(20,4) not null,
	receive_Rate_STCNT	varchar2(32) not null
);

ALTER TABLE InterChangeRcvdTest_TREND ADD constraint PK_InterChangeRcvdTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE InterChangeRcvdTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE InterChangeRcvdTest_THRESH 
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME        	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START		date,
      	MSMT_TIME_END   	date,
      	DECODE_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	DECODE_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	DECRYPT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	DECRYPT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	RECEIVE_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	RECEIVE_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE InterChangeRcvdTest_THRESH ADD constraint PK_InterChangeRcvdTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_InterChangeRcvdTest_THRESH ON InterChangeRcvdTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE  InterChangeXmitTest CASCADE CONSTRAINTS;

CREATE TABLE InterChangeXmitTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	encode_Rate			NUMBER(20,4) NOT NULL,
	encode_Rate_ST			VARCHAR2(32) NOT NULL,
	encrypt_Rate			NUMBER(20,4) NOT NULL,
	encrypt_Rate_ST			VARCHAR2(32) NOT NULL,
	serialize_Rate			NUMBER(20,4) NOT NULL,
	serialize_Rate_ST		VARCHAR2(32) NOT NULL,
	xmit_Rate			NUMBER(20,4) NOT NULL,
	xmit_Rate_ST			VARCHAR2(32) NOT NULL
);

ALTER TABLE InterChangeXmitTest ADD constraint PK_InterChangeXmitTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE  InterChangeXmitTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE InterChangeXmitTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	encode_Rate_MIN			NUMBER(20,4) NOT NULL,
	encode_Rate_MAX			NUMBER(20,4) NOT NULL,
	encode_Rate_STCNT		VARCHAR2(32) NOT NULL,
	encrypt_Rate_MIN		NUMBER(20,4) NOT NULL,
	encrypt_Rate_MAX		NUMBER(20,4) NOT NULL,
	encrypt_Rate_STCNT		VARCHAR2(32) NOT NULL,
	serialize_Rate_MIN		NUMBER(20,4) NOT NULL,
	serialize_Rate_MAX		NUMBER(20,4) NOT NULL,
	serialize_Rate_STCNT		VARCHAR2(32) NOT NULL,
	xmit_Rate_MIN			NUMBER(20,4) NOT NULL,
	xmit_Rate_MAX			NUMBER(20,4) NOT NULL,
	xmit_Rate_STCNT			VARCHAR2(32) NOT NULL
);

ALTER TABLE InterChangeXmitTest_TREND ADD constraint PK_InterChangeXmitTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   InterChangeXmitTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE InterChangeXmitTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	ENCODE_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	ENCODE_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	ENCRYPT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	ENCRYPT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	SERIALIZE_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	SERIALIZE_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	XMIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	XMIT_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE InterChangeXmitTest_THRESH ADD constraint PK_InterChangeXmitTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_InterChangeXmitTest_THRESH ON InterChangeXmitTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE InterSiteReplTest CASCADE CONSTRAINTS;

CREATE TABLE InterSiteReplTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	in_rate				NUMBER(20,4) NOT NULL,
	in_rate_ST			varchar2(32) NOT NULL,
	out_rate			number(20,4) not null,
	out_rate_ST			varchar2(32) not null
);

ALTER TABLE InterSiteReplTest ADD constraint PK_InterSiteRepl
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   InterSiteReplTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE InterSiteReplTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	in_rate_MIN			NUMBER(20,4) NOT NULL,
	in_rate_MAX			NUMBER(20,4) NOT NULL,
	in_rate_STCNT		varchar2(32) NOT NULL,
	out_rate_MIN		number(20,4) not null,
	out_rate_MAX		number(20,4) not null,
	out_rate_STCNT		varchar2(32) not null
);

ALTER TABLE InterSiteReplTest_TREND ADD constraint PK_InterSiteReplTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   InterSiteReplTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE InterSiteReplTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	IN_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	IN_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	OUT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	OUT_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE InterSiteReplTest_THRESH ADD constraint PK_InterSiteReplTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_InterSiteReplTest_THRESH ON InterSiteReplTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE IntraSiteReplTest CASCADE CONSTRAINTS;

CREATE TABLE IntraSiteReplTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	in_rate			NUMBER(20,4) NOT NULL,
	in_rate_ST			varchar2(32) NOT NULL,
	out_rate			number(20,4) not null,
	out_rate_ST			varchar2(32) not null
);

ALTER TABLE IntraSiteReplTest ADD constraint PK_IntraSiteRepl
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   IntraSiteReplTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE IntraSiteReplTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	in_rate_MIN			NUMBER(20,4) NOT NULL,
	in_rate_MAX			NUMBER(20,4) NOT NULL,
	in_rate_STCNT		varchar2(32) NOT NULL,
	out_rate_MIN		number(20,4) not null,
	out_rate_MAX		number(20,4) not null,
	out_rate_STCNT		varchar2(32) not null
);

ALTER TABLE IntraSiteReplTest_TREND ADD constraint PK_IntraSiteReplTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   IntraSiteReplTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE IntraSiteReplTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	IN_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	IN_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	OUT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	OUT_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE IntraSiteReplTest_THRESH ADD constraint PK_IntraSiteReplTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_IntraSiteReplTest_THRESH ON IntraSiteReplTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE LDAPTEST CASCADE CONSTRAINTS;

CREATE TABLE LDAPTEST
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME       	date,
	AVAILABLE       	number(3)     	NOT NULL,
	AVAILABLE_ST       	varchar2(32)     	NOT NULL,
	RESP_TIME       	number(20,4)  	NOT NULL,
	RESP_TIME_ST       	varchar2(32)  	NOT NULL,
	TCP_AVAIL       	number(3)  	NOT NULL,
	TCP_AVAIL_ST       	varchar2(32)  	NOT NULL,
	CURR_CONN		Number(20,4)    	NOT NULL,
	CURR_CONN_ST		varchar2(32)    	NOT NULL,
	CONN_RATE 		number(20,4)  	NOT NULL,
	CONN_RATE_ST 		varchar2(32)  	NOT NULL,
	BYTE_RATE_OUT   	number(20,4)  	NOT NULL,
	BYTE_RATE_OUT_ST   	varchar2(32)  	NOT NULL,
	OUT_STND_OPNS		Number(20,4)    	NOT NULL,
	OUT_STND_OPNS_ST	varchar2(32)    	NOT NULL
);

alter table LDAPTEST add constraint PK_LDAP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE LDAPTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE LDAPTEST_TREND
(
	TRGT_HOST       		varchar2(32),
	PORT_NO         		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 	
	MSMT_TIME       		date,
	PERIOD       			varchar2(32), 
	AVAILABLE_MIN       		number(20,4)     	NOT NULL,
	AVAILABLE_MAX       		number(20,4)     	NOT NULL,
	AVAILABLE_STCNT   		varchar2(32)    NOT NULL,
	RESP_TIME_MIN       		number(20,4)  	NOT NULL,
	RESP_TIME_MAX       		number(20,4)  	NOT NULL,
	RESP_TIME_STCNT       		varchar2(32)  	NOT NULL,
	TCP_AVAIL_MIN		       	number(20,4)  	NOT NULL,
	TCP_AVAIL_MAX			number(20,4)	NOT NULL,
	TCP_AVAIL_STCNT       		varchar2(32)  	NOT NULL,
	CURR_CONN_MIN			Number(20,4)    	NOT NULL,
	CURR_CONN_MAX			Number(20,4)    	NOT NULL,
	CURR_CONN_STCNT			varchar2(32)    NOT NULL,
	CONN_RATE_MIN	 		number(20,4)  	NOT NULL,
	CONN_RATE_MAX 			number(20,4)  	NOT NULL,
	CONN_RATE_STCNT 		varchar2(32)  	NOT NULL,
	BYTE_RATE_OUT_MIN   		number(20,4)  	NOT NULL,
	BYTE_RATE_OUT_MAX   		number(20,4)  	NOT NULL,
	BYTE_RATE_OUT_STCNT   		varchar2(32)  	NOT NULL,
	OUT_STND_OPNS_MIN		Number(20,4)    	NOT NULL,
	OUT_STND_OPNS_MAX		Number(20,4)    	NOT NULL,
	OUT_STND_OPNS_STCNT		varchar2(32)    NOT NULL
);

alter table LDAPTEST_TREND add constraint PK_LDAP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE LDAPTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE LDAPTEST_THRESH
(
        TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,
        AVAILABLE_MIN	VARCHAR2(256)	     NOT NULL,
        AVAILABLE_MAX	VARCHAR2(256)	     NOT NULL,
        RESP_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        RESP_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        TCP_AVAIL_MIN	VARCHAR2(256)	  NOT NULL,
        TCP_AVAIL_MAX	VARCHAR2(256)	  NOT NULL,
        CURR_CONN_MIN	VARCHAR2(256)	    NOT NULL,
        CURR_CONN_MAX	VARCHAR2(256)	    NOT NULL,
        CONN_RATE_MIN	VARCHAR2(256)	  NOT NULL,
        CONN_RATE_MAX	VARCHAR2(256)	  NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR2(256)	  NOT NULL,
        BYTE_RATE_OUT_MAX	VARCHAR2(256)	  NOT NULL,
        OUT_STND_OPNS_MIN	VARCHAR2(256)	    NOT NULL,
        OUT_STND_OPNS_MAX	VARCHAR2(256)	    NOT NULL
);

alter table LDAPTEST_THRESH add constraint PK_LDAP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_LDAPTEST_THRESH ON LDAPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);       
DROP TABLE LDREALSERVERTEST CASCADE CONSTRAINTS;

CREATE TABLE LDREALSERVERTEST
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	STATE		Number(20,4) 	NOT NULL,
	STATE_ST	varchar2(32)    NOT NULL,
	CONN_RATE 	number(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar2(32)    NOT NULL,
	DATA_RATE 	number(20,4) 	NOT NULL,
	DATA_RATE_ST 	varchar2(32)    NOT NULL
);

ALTER TABLE LDREALSERVERTEST ADD constraint PK_REAL
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE LDREALSERVERTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE LDREALSERVERTEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO         	varchar2(32),
        SITE_NAME       	varchar2(64),
        INFO            	varchar2(128), 
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD 			varchar2(32),
	STATE_MIN		Number(20,4) 	NOT NULL,
	STATE_MAX		Number(20,4) 	NOT NULL,
	STATE_STCNT		varchar2(32)   	NOT NULL,
	CONN_RATE_MIN 		number(20,4) 	NOT NULL,
	CONN_RATE_MAX 		number(20,4) 	NOT NULL,
	CONN_RATE_STCNT 	varchar2(32)   	NOT NULL,
	DATA_RATE_MIN 		number(20,4) 	NOT NULL,
	DATA_RATE_MAX 		number(20,4) 	NOT NULL,
	DATA_RATE_STCNT 	varchar2(32)   	NOT NULL
);

ALTER TABLE LDREALSERVERTEST_TREND ADD constraint PK_REAL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE LDREALSERVERTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE LDREALSERVERTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	STATE_MIN	VARCHAR2(256)	 	NOT NULL,
	STATE_MAX	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DATA_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DATA_RATE_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE LDREALSERVERTEST_THRESH ADD constraint PK_REAL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_LDREALSERVERTEST_THRESH ON LDREALSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);      
DROP TABLE LDVIRTUALSERVERTEST CASCADE CONSTRAINTS;

CREATE TABLE LDVIRTUALSERVERTEST
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	STATE		Number(20,4) 	NOT NULL,
	STATE_ST	varchar2(32)    NOT NULL,
	CONN_RATE 	number(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar2(32)    NOT NULL,
	DATA_RATE 	number(20,4) 	NOT NULL,
	DATA_RATE_ST 	varchar2(32)    NOT NULL
);

ALTER TABLE LDVIRTUALSERVERTEST ADD constraint PK_VIRTUAL
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE LDVIRTUALSERVERTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE LDVIRTUALSERVERTEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO         	varchar2(32),
        SITE_NAME       	varchar2(64),
        INFO            	varchar2(128), 
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD 			varchar2(32),
	STATE_MIN		Number(20,4) 	NOT NULL,
	STATE_MAX		Number(20,4) 	NOT NULL,
	STATE_STCNT		varchar2(32)   	NOT NULL,
	CONN_RATE_MIN 		number(20,4) 	NOT NULL,
	CONN_RATE_MAX 		number(20,4) 	NOT NULL,
	CONN_RATE_STCNT 	varchar2(32)   	NOT NULL,
	DATA_RATE_MIN 		number(20,4) 	NOT NULL,
	DATA_RATE_MAX 		number(20,4) 	NOT NULL,
	DATA_RATE_STCNT 	varchar2(32)   	NOT NULL
);

ALTER TABLE LDVIRTUALSERVERTEST_TREND ADD constraint PK_VIRTUAL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE LDVIRTUALSERVERTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE LDVIRTUALSERVERTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	STATE_MIN	VARCHAR2(256)	 	NOT NULL,
	STATE_MAX	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DATA_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DATA_RATE_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE LDVIRTUALSERVERTEST_THRESH ADD constraint PK_VIRTUAL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_LDVIRTUALSERVERTEST_THRESH ON LDVIRTUALSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);        
DROP TABLE MAILTEST CASCADE CONSTRAINTS;

CREATE TABLE MAILTEST 
(
        TRGT_HOST            varchar2(32),
        PORT_NO              varchar2(32),
        SITE_NAME            varchar2(64),
        INFO                 varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME            date,
        SMTP_AVAIL           NUMBER(3)    NOT NULL,
        SMTP_AVAIL_ST        VARCHAR2(32)    NOT NULL,
        POP3_AVAIL           NUMBER(3)    NOT NULL,
        POP3_AVAIL_ST        VARCHAR2(32)    NOT NULL,
        OUT_MAIL             NUMBER(20,4)    NOT NULL,
        OUT_MAIL_ST          VARCHAR2(32)    NOT NULL,
        RT_DELAY             NUMBER(20,4)    NOT NULL,
        RT_DELAY_ST          VARCHAR2(32)    NOT NULL
);

alter table MAILTEST add constraint PK_MAILTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MAILTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MAILTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
        SMTP_AVAIL_MIN           	NUMBER(20,4)    NOT NULL,
        SMTP_AVAIL_MAX           	NUMBER(20,4)    NOT NULL,
        SMTP_AVAIL_STCNT        	VARCHAR2(32)    NOT NULL,
        POP3_AVAIL_MIN          	NUMBER(20,4)    NOT NULL,
        POP3_AVAIL_MAX           	NUMBER(20,4)    NOT NULL,
        POP3_AVAIL_STCNT        	VARCHAR2(32)    NOT NULL,
        OUT_MAIL_MIN                    NUMBER(20,4)    NOT NULL,
        OUT_MAIL_MAX             	NUMBER(20,4)    NOT NULL,
        OUT_MAIL_STCNT          	VARCHAR2(32)    NOT NULL,
        RT_DELAY_MIN              	NUMBER(20,4)    NOT NULL,
        RT_DELAY_MAX             	NUMBER(20,4)    NOT NULL,
        RT_DELAY_STCNT          	VARCHAR2(32)    NOT NULL
);


alter table MAILTEST_TREND add constraint PK_MAILTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MAILTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MAILTEST_THRESH 
(
        TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,
        SMTP_AVAIL_MIN	VARCHAR2(256)	    NOT NULL,
        SMTP_AVAIL_MAX	VARCHAR2(256)	    NOT NULL,
        POP3_AVAIL_MIN	VARCHAR2(256)	    NOT NULL,
        POP3_AVAIL_MAX	VARCHAR2(256)	    NOT NULL,
        OUT_MAIL_MIN	VARCHAR2(256)	    NOT NULL,
        OUT_MAIL_MAX	VARCHAR2(256)	    NOT NULL,
        RT_DELAY_MIN	VARCHAR2(256)	    NOT NULL,
        RT_DELAY_MAX	VARCHAR2(256)	    NOT NULL
);

alter table MAILTEST_THRESH add constraint PK_MAILTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MAILTEST_THRESH ON MAILTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);    

DROP TABLE MEASURE_LAST CASCADE CONSTRAINTS;
CREATE TABLE MEASURE_LAST
(
	TEST_NAME 	varchar2(64),
	TRGT_HOST 	varchar2(32),
	PORT_NO 	varchar2(32),
        SITE_NAME       varchar2(64),  
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
        MSMT_TIME 	date
);

alter table MEASURE_LAST add constraint PK_MEASURE_LAST 
PRIMARY KEY (TEST_NAME,TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST);
create index idx_measure_last on measure_last (site_name);
create index idx1_measure_last on measure_last(trgt_host);
create index idx2_measure_last on measure_last (test_name,port_no);
CREATE INDEX IDX3_MEASURE_LAST ON MEASURE_LAST ( INFO, MSMT_TIME);
Create index idx4_measure_last on measure_last(msmt_time);
CREATE INDEX idx5_measure_last ON MEASURE_LAST (PORT_NO, TEST_NAME, MSMT_TIME );

DROP TABLE METATEST  CASCADE CONSTRAINTS;
CREATE TABLE METATEST 
(
        COMP_NAME          varchar2(64),
	COMP_TYPE		varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST		varchar2(64),
        TEST_NAME               varchar2(128),
        MSMT_TIME 		date
);

ALTER TABLE METATEST ADD CONSTRAINT PK_METATEST
PRIMARY KEY (COMP_NAME,COMP_TYPE,SITE_NAME,INFO,MSMT_HOST,TEST_NAME);

CREATE INDEX IDX_METATEST ON METATEST(SITE_NAME,INFO);    
CREATE INDEX IDX1_METATEST ON METATEST (MSMT_TIME);

DROP TABLE MSMQTEST CASCADE CONSTRAINTS;
CREATE TABLE MSMQTEST
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	IN_MSG_RATE		number(20,4)	NOT NULL,	
	IN_MSG_RATE_ST		varchar2(32)	NOT NULL,	
	OUT_MSG_RATE		number(20,4)	NOT NULL,
	OUT_MSG_RATE_ST		varchar2(32)	NOT NULL,
	CURRENT_SESSIONS	number(20,4)	NOT NULL,
	CURRENT_SESSIONS_ST	varchar2(32)	NOT NULL,
	ERROR_MSG_CNT		number(20,4)	NOT NULL,
	ERROR_MSG_CNT_ST	varchar2(32)	NOT NULL,
	TOTAL_NO_MSGS		number(20,4)	NOT NULL,
	TOTAL_NO_MSGS_ST	varchar2(32)	NOT NULL,
	GROWTH_RATE		number(20,4)	NOT NULL,
	GROWTH_RATE_ST		varchar2(32)	NOT NULL,
	IP_SESSION	number(20,4)	NOT NULL,
	IP_SESSION_ST	varchar2(32)	NOT NULL,
	IN_MULTICAST_SESSION	NUMBER(20,4)	NOT NULL,
	IN_MULTICAST_SESSION_ST	VARCHAR2(32)	NOT NULL,
	MSMQ_IN_MSG	NUMBER(20,4)	NOT NULL,
	MSMQ_IN_MSG_ST VARCHAR2(32)	NOT NULL,
	MSMQ_OUT_MSG	NUMBER(20,4)	NOT NULL,
	MSMQ_OUT_MSG_ST	VARCHAR2(32)	NOT NULL,
	OUT_HTTP_SESSION	NUMBER(20,4)	NOT NULL,
	OUT_HTTP_SESSION_ST	VARCHAR2(32)	NOT NULL,
	OUT_MULTICAST_SESSION NUMBER(20,4)	NOT NULL,
	OUT_MULTICAST_SESSION_ST VARCHAR2(32)	NOT NULL,
	TOT_BYTES	NUMBER(20,4)	NOT NULL,
	TOT_BYTES_ST VARCHAR2(32)	NOT NULL
);

ALTER TABLE MSMQTEST ADD constraint PK_MSMQ
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MSMQTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MSMQTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	IN_MSG_RATE_MIN		number(20,4)	NOT NULL,	
	IN_MSG_RATE_MAX		number(20,4)	NOT NULL,	
	IN_MSG_RATE_STCNT	varchar2(32)	NOT NULL,	
	OUT_MSG_RATE_MIN	number(20,4)	NOT NULL,
	OUT_MSG_RATE_MAX	number(20,4)	NOT NULL,
	OUT_MSG_RATE_STCNT	varchar2(32)	NOT NULL,
	CURRENT_SESSIONS_MIN	number(20,4)	NOT NULL,
	CURRENT_SESSIONS_MAX	number(20,4)	NOT NULL,
	CURRENT_SESSIONS_STCNT	varchar2(32)	NOT NULL,
	ERROR_MSG_CNT_MIN	number(20,4)	NOT NULL,
	ERROR_MSG_CNT_MAX	number(20,4)	NOT NULL,
	ERROR_MSG_CNT_STCNT	varchar2(32)	NOT NULL,
	TOTAL_NO_MSGS_MIN	number(20,4)	NOT NULL,
	TOTAL_NO_MSGS_MAX	number(20,4)	NOT NULL,
	TOTAL_NO_MSGS_STCNT	varchar2(32)	NOT NULL,
	GROWTH_RATE_MIN		number(20,4)	NOT NULL,
	GROWTH_RATE_MAX		number(20,4)	NOT NULL,
	GROWTH_RATE_STCNT	varchar2(32)	NOT NULL,
	IP_SESSION_MIN	number(20,4)	NOT NULL,
	IP_SESSION_MAX	number(20,4)	NOT NULL,
	IP_SESSION_STCNT	varchar2(32)	NOT NULL,
	IN_MULTICAST_SESSION_MIN	NUMBER(20,4)	NOT NULL,
	IN_MULTICAST_SESSION_MAX	NUMBER(20,4)	NOT NULL,
	IN_MULTICAST_SESSION_STCNT	VARCHAR2(32)	NOT NULL,
	MSMQ_IN_MSG_MIN	NUMBER(20,4)	NOT NULL,
	MSMQ_IN_MSG_MAX	NUMBER(20,4)	NOT NULL,
	MSMQ_IN_MSG_STCNT VARCHAR2(32)	NOT NULL,
	MSMQ_OUT_MSG_MIN	NUMBER(20,4)	NOT NULL,
	MSMQ_OUT_MSG_MAX	NUMBER(20,4)	NOT NULL,
	MSMQ_OUT_MSG_STCNT	VARCHAR2(32)	NOT NULL,
	OUT_HTTP_SESSION_MIN	NUMBER(20,4)	NOT NULL,
	OUT_HTTP_SESSION_MAX	NUMBER(20,4)	NOT NULL,
	OUT_HTTP_SESSION_STCNT	VARCHAR2(32)	NOT NULL,
	OUT_MULTICAST_SESSION_MIN NUMBER(20,4)	NOT NULL,
	OUT_MULTICAST_SESSION_MAX NUMBER(20,4)	NOT NULL,
	OUT_MULTICAST_SESSION_STCNT VARCHAR2(32)	NOT NULL,
	TOT_BYTES_MIN	NUMBER(20,4)	NOT NULL,
	TOT_BYTES_MAX	NUMBER(20,4)	NOT NULL,
	TOT_BYTES_STCNT VARCHAR2(32)	NOT NULL
);

ALTER TABLE MSMQTEST_TREND ADD constraint PK_MSMQ_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSMQTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MSMQTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME        	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START		date,
      	MSMT_TIME_END   	date,
	IN_MSG_RATE_MIN	VARCHAR2(256)		NOT NULL,
	IN_MSG_RATE_MAX	VARCHAR2(256)		NOT NULL,
	OUT_MSG_RATE_MIN	VARCHAR2(256)		NOT NULL,
	OUT_MSG_RATE_MAX	VARCHAR2(256)		NOT NULL,
	CURRENT_SESSIONS_MIN	VARCHAR2(256)		NOT NULL,
	CURRENT_SESSIONS_MAX	VARCHAR2(256)		NOT NULL,
	ERROR_MSG_CNT_MIN	VARCHAR2(256)		NOT NULL,
	ERROR_MSG_CNT_MAX	VARCHAR2(256)		NOT NULL,
	TOTAL_NO_MSGS_MIN	VARCHAR2(256)		NOT NULL,
	TOTAL_NO_MSGS_MAX	VARCHAR2(256)		NOT NULL,
	GROWTH_RATE_MIN	VARCHAR2(256)		NOT NULL,
	GROWTH_RATE_MAX	VARCHAR2(256)		NOT NULL,
	IP_SESSION_MIN	VARCHAR2(256)		NOT NULL,
	IP_SESSION_MAX	VARCHAR2(256)		NOT NULL,
	IN_MULTICAST_SESSION_MIN	VARCHAR2(256)		NOT NULL,
	IN_MULTICAST_SESSION_MAX	VARCHAR2(256)		NOT NULL,
	MSMQ_IN_MSG_MIN	VARCHAR2(256)		NOT NULL,
	MSMQ_IN_MSG_MAX	VARCHAR2(256)		NOT NULL,
	MSMQ_OUT_MSG_MIN	VARCHAR2(256)		NOT NULL,
	MSMQ_OUT_MSG_MAX	VARCHAR2(256)		NOT NULL,
	OUT_HTTP_SESSION_MIN	VARCHAR2(256)		NOT NULL,
	OUT_HTTP_SESSION_MAX	VARCHAR2(256)		NOT NULL,
	OUT_MULTICAST_SESSION_MIN VARCHAR2(256)		NOT NULL,
	OUT_MULTICAST_SESSION_MAX VARCHAR2(256)		NOT NULL,
	TOT_BYTES_MIN	VARCHAR2(256)		NOT NULL,
	TOT_BYTES_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE MSMQTEST_THRESH ADD constraint PK_MSMQ_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MSMQTEST_THRESH ON MSMQTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);              
DROP TABLE MSSQLBUFFERTEST CASCADE CONSTRAINTS;

CREATE TABLE MSSQLBUFFERTEST 
(
        TRGT_HOST		varchar2(32),
        PORT_NO             	varchar2(32),
        SITE_NAME          	varchar2(64),
        INFO              	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME         	date,
	BUFFER_CHEHIT_RT	NUMBER(20,4)    NOT NULL,	
	BUFFER_CHEHIT_RT_ST	VARCHAR2(32)    NOT NULL,
	PAGE_RD			NUMBER(20,4)    NOT NULL,	
	PAGE_RD_ST		VARCHAR2(32)    NOT NULL,
	PAGE_WRT_RT		NUMBER(20,4)    NOT NULL,	
	PAGE_WRT_RT_ST		VARCHAR2(32)    NOT NULL,
	CACHE_HTRT		NUMBER(20,4)    NOT NULL,	
	CACHE_HTRT_ST		VARCHAR2(32)    NOT NULL,
	CACHE_OBJCT		NUMBER(20,4)    NOT NULL,	
	CACHE_OBJCT_ST		VARCHAR2(32)    NOT NULL,
	LOG_CACHITRT		NUMBER(20,4)    NOT NULL,	
	LOG_CACHITRT_ST		VARCHAR2(32)    NOT NULL
	);
												
alter table MSSQLBUFFERTEST add constraint PK_MSSQLBUFFERTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MSSQLBUFFERTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MSSQLBUFFERTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
	BUFFER_CHEHIT_RT_MIN	NUMBER(20,4)    NOT NULL,	
	BUFFER_CHEHIT_RT_MAX	NUMBER(20,4)    NOT NULL,	
	BUFFER_CHEHIT_RT_STCNT	VARCHAR2(32)    NOT NULL,
	PAGE_RD_MIN		NUMBER(20,4)    NOT NULL,	
	PAGE_RD_MAX		NUMBER(20,4)    NOT NULL,	
	PAGE_RD_STCNT		VARCHAR2(32)    NOT NULL,
	PAGE_WRT_RT_MIN		NUMBER(20,4)    NOT NULL,	
	PAGE_WRT_RT_MAX		NUMBER(20,4)    NOT NULL,	
	PAGE_WRT_RT_STCNT	VARCHAR2(32)    NOT NULL,
	CACHE_HTRT_MIN		NUMBER(20,4)    NOT NULL,	
	CACHE_HTRT_MAX		NUMBER(20,4)    NOT NULL,	
	CACHE_HTRT_STCNT	VARCHAR2(32)    NOT NULL,
	CACHE_OBJCT_MIN		NUMBER(20,4)    NOT NULL,	
	CACHE_OBJCT_MAX		NUMBER(20,4)    NOT NULL,	
	CACHE_OBJCT_STCNT	VARCHAR2(32)    NOT NULL,
	LOG_CACHITRT_MIN	NUMBER(20,4)    NOT NULL,	
	LOG_CACHITRT_MAX	NUMBER(20,4)    NOT NULL,	
	LOG_CACHITRT_STCNT	VARCHAR2(32)    NOT NULL
);

alter table MSSQLBUFFERTEST_TREND add constraint PK_MSSQLBUFFERTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLBUFFERTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MSSQLBUFFERTEST_THRESH 
(
        TRGT_HOST               	varchar2(32),
        PORT_NO             	    	varchar2(32),
        SITE_NAME           	    	varchar2(64),
        INFO                	    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START         	date,
        MSMT_TIME_END           	date,
        BUFFER_CHEHIT_RT_MIN	VARCHAR2(256)	    NOT NULL,
	BUFFER_CHEHIT_RT_MAX	VARCHAR2(256)	    NOT NULL,
	PAGE_RD_MIN	VARCHAR2(256)	    NOT NULL,
	PAGE_RD_MAX	VARCHAR2(256)	    NOT NULL,
	PAGE_WRT_RT_MIN	VARCHAR2(256)	    NOT NULL,
	PAGE_WRT_RT_MAX	VARCHAR2(256)	    NOT NULL,
	CACHE_HTRT_MIN	VARCHAR2(256)	    NOT NULL,
	CACHE_HTRT_MAX	VARCHAR2(256)	    NOT NULL,
	CACHE_OBJCT_MIN	VARCHAR2(256)	    NOT NULL,
	CACHE_OBJCT_MAX	VARCHAR2(256)	    NOT NULL,
	LOG_CACHITRT_MIN	VARCHAR2(256)	    NOT NULL,
	LOG_CACHITRT_MAX	VARCHAR2(256)	    NOT NULL
);

alter table MSSQLBUFFERTEST_THRESH add constraint PK_MSSQLBUFFERTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MSSQLBUFFERTEST_THRESH ON MSSQLBUFFERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     

DROP TABLE MSSQLLOCKTEST CASCADE CONSTRAINTS;
CREATE TABLE MSSQLLOCKTEST 
(
        TRGT_HOST		varchar2(32),
        PORT_NO             	varchar2(32),
        SITE_NAME          	varchar2(64),
        INFO              	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME         	date,
	AVG_WTTIME		NUMBER(20,4)    NOT NULL,	
	AVG_WTTIME_ST		VARCHAR2(32)    NOT NULL,
	LOCK_REQ		NUMBER(20,4)    NOT NULL,	
	LOCK_REQ_ST		VARCHAR2(32)    NOT NULL,
	LOCK_WAIT		NUMBER(20,4)    NOT NULL,	
	LOCK_WAIT_ST		VARCHAR2(32)    NOT NULL,
	NUM_DEADLOCK		NUMBER(20,4)    NOT NULL,	
	NUM_DEADLOCK_ST		VARCHAR2(32)    NOT NULL,
	LOCK_TIMEOUTS		NUMBER(20,4)    NOT NULL,	
	LOCK_TIMEOUTS_ST	VARCHAR2(32)    NOT NULL);

CREATE  INDEX IDX_MSSQLLOCKTEST ON MSSQLLOCKTEST(MSMT_TIME);
alter table MSSQLLOCKTEST add constraint PK_MSSQLLOCKTEST PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MSSQLLOCKTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MSSQLLOCKTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
	AVG_WTTIME_MIN			NUMBER(20,4)    NOT NULL,
	AVG_WTTIME_MAX			NUMBER(20,4)    NOT NULL,
	AVG_WTTIME_STCNT		VARCHAR2(32)    NOT NULL,
	LOCK_REQ_MIN			NUMBER(20,4)    NOT NULL,
	LOCK_REQ_MAX			NUMBER(20,4)    NOT NULL,
	LOCK_REQ_STCNT			VARCHAR2(32)    NOT NULL,
	LOCK_WAIT_MIN			NUMBER(20,4)    NOT NULL,
	LOCK_WAIT_MAX			NUMBER(20,4)    NOT NULL,
	LOCK_WAIT_STCNT			VARCHAR2(32)    NOT NULL,
	NUM_DEADLOCK_MIN		NUMBER(20,4)    NOT NULL,
	NUM_DEADLOCK_MAX		NUMBER(20,4)    NOT NULL,
	NUM_DEADLOCK_STCNT		VARCHAR2(32)    NOT NULL,
	LOCK_TIMEOUTS_MIN		NUMBER(20,4)    NOT NULL,
	LOCK_TIMEOUTS_MAX		NUMBER(20,4)    NOT NULL,
	LOCK_TIMEOUTS_STCNT		VARCHAR2(32)    NOT NULL);
alter table MSSQLLOCKTEST_TREND add constraint PK_MSSQLLOCKTEST_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLLOCKTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MSSQLLOCKTEST_THRESH 
(
        TRGT_HOST               	varchar2(32),
        PORT_NO             	    	varchar2(32),
        SITE_NAME           	    	varchar2(64),
        INFO                	    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START         	date,
        MSMT_TIME_END           	date,
        AVG_WTTIME_MIN		VARCHAR2(256)	    NOT NULL,
	AVG_WTTIME_MAX		VARCHAR2(256)	    NOT NULL,
	LOCK_REQ_MIN		VARCHAR2(256)	    NOT NULL,
	LOCK_REQ_MAX		VARCHAR2(256)	    NOT NULL,
	LOCK_WAIT_MIN		VARCHAR2(256)	    NOT NULL,
	LOCK_WAIT_MAX		VARCHAR2(256)	    NOT NULL,
	NUM_DEADLOCK_MIN	VARCHAR2(256)	    NOT NULL,
	NUM_DEADLOCK_MAX	VARCHAR2(256)	    NOT NULL,
	LOCK_TIMEOUTS_MIN	VARCHAR2(256)	    NOT NULL,
	LOCK_TIMEOUTS_MAX	VARCHAR2(256)	    NOT NULL);

alter table MSSQLLOCKTEST_THRESH add constraint PK_MSSQLLOCKTEST_THRESH PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_MSSQLLOCKTEST_THRESH ON MSSQLLOCKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE MSSQLMEMORYTEST CASCADE CONSTRAINTS;
CREATE TABLE MSSQLMEMORYTEST 
(
        TRGT_HOST		varchar2(32),
        PORT_NO             	varchar2(32),
        SITE_NAME          	varchar2(64),
        INFO              	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME         	date,
	TOT_SERVMEM			NUMBER(20,4)    NOT NULL,	
	TOT_SERVMEM_ST			VARCHAR2(32)    NOT NULL,
	TGT_SERVMEM			NUMBER(20,4)    NOT NULL,	
	TGT_SERVMEM_ST			VARCHAR2(32)    NOT NULL,
	SQL_CACHEMEM			NUMBER(20,4)    NOT NULL,	
	SQL_CACHEMEM_ST			VARCHAR2(32)    NOT NULL,
	OPTZ_MEM			NUMBER(20,4)    NOT NULL,	
	OPTZ_MEM_ST			VARCHAR2(32)    NOT NULL,
	MAX_WORKSPMEM			NUMBER(20,4)    NOT NULL,	
	MAX_WORKSPMEM_ST		VARCHAR2(32)    NOT NULL,
	LOCK_MEM			NUMBER(20,4)    NOT NULL,	
	LOCK_MEM_ST			VARCHAR2(32)    NOT NULL,
	GRANT_WKSPACEMEM		NUMBER(20,4)    NOT NULL,	
	GRANT_WKSPACEMEM_ST		VARCHAR2(32)    NOT NULL,
	CONNEC_MEM			NUMBER(20,4)    NOT NULL,	
	CONNEC_MEM_ST			VARCHAR2(32)    NOT NULL,
	MEMORY_GRANTS_PENDING		NUMBER(20,4)    NOT NULL,	
	MEMORY_GRANTS_PENDING_ST	VARCHAR2(32)    NOT NULL
	);
CREATE  INDEX IDX_MSSQLMEMORYTEST ON MSSQLMEMORYTEST(MSMT_TIME);
ALTER TABLE MSSQLMEMORYTEST add constraint PK_MSSQLMEMORYTEST PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MSSQLMEMORYTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MSSQLMEMORYTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
	TOT_SERVMEM_MIN			NUMBER(20,4)    NOT NULL,	
	TOT_SERVMEM_MAX			NUMBER(20,4)    NOT NULL,	
	TOT_SERVMEM_STCNT		VARCHAR2(32)    NOT NULL,
	TGT_SERVMEM_MIN			NUMBER(20,4)    NOT NULL,	
	TGT_SERVMEM_MAX			NUMBER(20,4)    NOT NULL,	
	TGT_SERVMEM_STCNT		VARCHAR2(32)    NOT NULL,
	SQL_CACHEMEM_MIN		NUMBER(20,4)    NOT NULL,	
	SQL_CACHEMEM_MAX		NUMBER(20,4)    NOT NULL,	
	SQL_CACHEMEM_STCNT		VARCHAR2(32)    NOT NULL,
	OPTZ_MEM_MIN			NUMBER(20,4)    NOT NULL,	
	OPTZ_MEM_MAX			NUMBER(20,4)    NOT NULL,	
	OPTZ_MEM_STCNT			VARCHAR2(32)    NOT NULL,
	MAX_WORKSPMEM_MIN		NUMBER(20,4)    NOT NULL,	
	MAX_WORKSPMEM_MAX		NUMBER(20,4)    NOT NULL,	
	MAX_WORKSPMEM_STCNT		VARCHAR2(32)    NOT NULL,
	LOCK_MEM_MIN			NUMBER(20,4)    NOT NULL,	
	LOCK_MEM_MAX			NUMBER(20,4)    NOT NULL,	
	LOCK_MEM_STCNT			VARCHAR2(32)    NOT NULL,
	GRANT_WKSPACEMEM_MIN		NUMBER(20,4)    NOT NULL,	
	GRANT_WKSPACEMEM_MAX		NUMBER(20,4)    NOT NULL,	
	GRANT_WKSPACEMEM_STCNT		VARCHAR2(32)    NOT NULL,
	CONNEC_MEM_MIN			NUMBER(20,4)    NOT NULL,	
	CONNEC_MEM_MAX			NUMBER(20,4)    NOT NULL,	
	CONNEC_MEM_STCNT		VARCHAR2(32)    NOT NULL,
	MEMORY_GRANTS_PENDING_MIN	NUMBER(20,4)    NOT NULL,	
	MEMORY_GRANTS_PENDING_MAX	NUMBER(20,4)    NOT NULL,	
	MEMORY_GRANTS_PENDING_STCNT	VARCHAR2(32)    NOT NULL
);


ALTER TABLE MSSQLMEMORYTEST_TREND add constraint PK_MSSQLMEMORYTEST_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLMEMORYTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MSSQLMEMORYTEST_THRESH 
(
        TRGT_HOST               	varchar2(32),
        PORT_NO             	    	varchar2(32),
        SITE_NAME           	    	varchar2(64),
        INFO                	    	varchar2(128),
	MSMT_HOST 			varchar2(32),         
	MSMT_TIME_START         	date,
        MSMT_TIME_END           	date,
        TOT_SERVMEM_MIN			VARCHAR2(256)	    NOT NULL,
	TOT_SERVMEM_MAX			VARCHAR2(256)	    NOT NULL,
	TGT_SERVMEM_MIN			VARCHAR2(256)	    NOT NULL,
	TGT_SERVMEM_MAX			VARCHAR2(256)	    NOT NULL,
	SQL_CACHEMEM_MIN		VARCHAR2(256)	    NOT NULL,
	SQL_CACHEMEM_MAX		VARCHAR2(256)	    NOT NULL,
	OPTZ_MEM_MIN			VARCHAR2(256)	    NOT NULL,
	OPTZ_MEM_MAX			VARCHAR2(256)	    NOT NULL,
	MAX_WORKSPMEM_MIN		VARCHAR2(256)	    NOT NULL,
	MAX_WORKSPMEM_MAX		VARCHAR2(256)	    NOT NULL,
	LOCK_MEM_MIN			VARCHAR2(256)	    NOT NULL,
	LOCK_MEM_MAX			VARCHAR2(256)	    NOT NULL,
	GRANT_WKSPACEMEM_MIN		VARCHAR2(256)	    NOT NULL,
	GRANT_WKSPACEMEM_MAX		VARCHAR2(256)	    NOT NULL,
	CONNEC_MEM_MIN			VARCHAR2(256)	    NOT NULL,
	CONNEC_MEM_MAX			VARCHAR2(256)	    NOT NULL,
	MEMORY_GRANTS_PENDING_MIN	VARCHAR2(256)	    NOT NULL,
	MEMORY_GRANTS_PENDING_MAX	VARCHAR2(256)	    NOT NULL
	);

ALTER TABLE MSSQLMEMORYTEST_THRESH add constraint PK_MSSQLMEMORYTEST_THRESH PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_MSSQLMEMORYTEST_THRESH ON MSSQLMEMORYTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MSSQLSESSIONTEST CASCADE CONSTRAINTS;
CREATE TABLE MSSQLSESSIONTEST 
(
        TRGT_HOST		varchar2(32),
        PORT_NO             	varchar2(32),
        SITE_NAME          	varchar2(64),
        INFO              	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME         	date,
	LOGIN_COUNTER		NUMBER(20,4)    NOT NULL,
	LOGIN_COUNTER_ST	VARCHAR2(32)    NOT NULL,
	LOGOUT_COUNTER		NUMBER(20,4)    NOT NULL,
	LOGOUT_COUNTER_ST	VARCHAR2(32)    NOT NULL,	
	USER_CONNECTION		NUMBER(20,4)     NOT NULL,
	USER_CONNECTION_ST	VARCHAR2(32)    NOT NULL,
	LOGICAL_CONNECTIONS	NUMBER(20,4)     NOT NULL,
	LOGICAL_CONNECTIONS_ST	VARCHAR2(32)    NOT NULL
	);
CREATE INDEX IDX_MSSQLSESSIONTEST ON MSSQLSESSIONTEST(MSMT_TIME);
CREATE INDEX IDX1_MSSQLSESSIONTEST ON MSSQLSESSIONTEST (TRGT_HOST,MSMT_TIME);
ALTER TABLE MSSQLSESSIONTEST add constraint PK_MSSQLSESSIONTEST PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MSSQLSESSIONTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MSSQLSESSIONTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
	LOGIN_COUNTER_MIN		NUMBER(20,4)    NOT NULL,
	LOGIN_COUNTER_MAX		NUMBER(20,4)    NOT NULL,
	LOGIN_COUNTER_STCNT		VARCHAR2(32)    NOT NULL,
	LOGOUT_COUNTER_MIN		NUMBER(20,4)    NOT NULL,
	LOGOUT_COUNTER_MAX		NUMBER(20,4)    NOT NULL,
	LOGOUT_COUNTER_STCNT		VARCHAR2(32)    NOT NULL,
	USER_CONNECTION_MIN		NUMBER(20,4)    NOT NULL,
	USER_CONNECTION_MAX		NUMBER(20,4)    NOT NULL,
	USER_CONNECTION_STCNT		VARCHAR2(32)    NOT NULL,
	LOGICAL_CONNECTIONS_MIN		NUMBER(20,4)    NOT NULL,
	LOGICAL_CONNECTIONS_MAX		NUMBER(20,4)    NOT NULL,
	LOGICAL_CONNECTIONS_STCNT	VARCHAR2(32)    NOT NULL
);


ALTER TABLE MSSQLSESSIONTEST_TREND add constraint PK_MSSQLSESSIONTEST_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLSESSIONTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MSSQLSESSIONTEST_THRESH 
(
        TRGT_HOST               	varchar2(32),
        PORT_NO             	    	varchar2(32),
        SITE_NAME           	    	varchar2(64),
        INFO                	    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START         	date,
        MSMT_TIME_END           	date,
        LOGIN_COUNTER_MIN	VARCHAR2(256)	    NOT NULL,
	LOGIN_COUNTER_MAX	VARCHAR2(256)	    NOT NULL,
	LOGOUT_COUNTER_MIN	VARCHAR2(256)	    NOT NULL,
	LOGOUT_COUNTER_MAX	VARCHAR2(256)	    NOT NULL,
	USER_CONNECTION_MIN	VARCHAR2(256)	    NOT NULL,
	USER_CONNECTION_MAX	VARCHAR2(256)	    NOT NULL,
	LOGICAL_CONNECTIONS_MIN	VARCHAR2(256)	    NOT NULL,
	LOGICAL_CONNECTIONS_MAX	VARCHAR2(256)	    NOT NULL
);

ALTER TABLE MSSQLSESSIONTEST_THRESH add constraint PK_MSSQLSESSIONTEST_THRESH PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_MSSQLSESSIONTEST_THRESH ON MSSQLSESSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MSSQLTRANSACTIONTEST CASCADE CONSTRAINTS;
CREATE TABLE MSSQLTRANSACTIONTEST 
(
        TRGT_HOST		varchar2(32),
        PORT_NO             	varchar2(32),
        SITE_NAME          	varchar2(64),
        INFO              	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME         	date,
	ACTIVE_TRAN		NUMBER(20,4)    NOT NULL,	
	ACTIVE_TRAN_ST		VARCHAR2(32)    NOT NULL,
	LOG_FLUSHWT		NUMBER(20,4)    NOT NULL,	
	LOG_FLUSHWT_ST		VARCHAR2(32)    NOT NULL,
	REPL_PNDXACTS		NUMBER(20,4)    NOT NULL,	
	REPL_PNDXACTS_ST	VARCHAR2(32)    NOT NULL,
	REPL_TRANRT		NUMBER(20,4)    NOT NULL,	
	REPL_TRANRT_ST		VARCHAR2(32)    NOT NULL,
	NUM_TRANSACT		NUMBER(20,4)    NOT NULL,	
	NUM_TRANSACT_ST		VARCHAR2(32)    NOT NULL
	);

alter table MSSQLTRANSACTIONTEST add constraint PK_MSSQLTRANSACTIONTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MSSQLTRANSACTIONTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MSSQLTRANSACTIONTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
	ACTIVE_TRAN_MIN		NUMBER(20,4)    NOT NULL,	
	ACTIVE_TRAN_MAX		NUMBER(20,4)    NOT NULL,	
	ACTIVE_TRAN_STCNT	VARCHAR2(32)    NOT NULL,
	LOG_FLUSHWT_MIN		NUMBER(20,4)    NOT NULL,	
	LOG_FLUSHWT_MAX		NUMBER(20,4)    NOT NULL,	
	LOG_FLUSHWT_STCNT	VARCHAR2(32)    NOT NULL,
	REPL_PNDXACTS_MIN	NUMBER(20,4)    NOT NULL,	
	REPL_PNDXACTS_MAX	NUMBER(20,4)    NOT NULL,	
	REPL_PNDXACTS_STCNT	VARCHAR2(32)    NOT NULL,
	REPL_TRANRT_MIN		NUMBER(20,4)    NOT NULL,	
	REPL_TRANRT_MAX		NUMBER(20,4)    NOT NULL,	
	REPL_TRANRT_STCNT	VARCHAR2(32)    NOT NULL,
	NUM_TRANSACT_MIN	NUMBER(20,4)    NOT NULL,	
	NUM_TRANSACT_MAX	NUMBER(20,4)    NOT NULL,	
	NUM_TRANSACT_STCNT	VARCHAR2(32)    NOT NULL
	);


alter table MSSQLTRANSACTIONTEST_TREND add constraint PK_MSSQLTRANSACTIONTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLTRANSACTIONTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MSSQLTRANSACTIONTEST_THRESH 
(
        TRGT_HOST               	varchar2(32),
        PORT_NO             	    	varchar2(32),
        SITE_NAME           	    	varchar2(64),
        INFO                	    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START         	date,
        MSMT_TIME_END           	date,
        ACTIVE_TRAN_MIN	VARCHAR2(256)	    NOT NULL,
	ACTIVE_TRAN_MAX	VARCHAR2(256)	    NOT NULL,
	LOG_FLUSHWT_MIN	VARCHAR2(256)	    NOT NULL,
	LOG_FLUSHWT_MAX	VARCHAR2(256)	    NOT NULL,
	REPL_PNDXACTS_MIN	VARCHAR2(256)	    NOT NULL,
	REPL_PNDXACTS_MAX	VARCHAR2(256)	    NOT NULL,
	REPL_TRANRT_MIN	VARCHAR2(256)	    NOT NULL,
	REPL_TRANRT_MAX	VARCHAR2(256)	    NOT NULL,
	NUM_TRANSACT_MIN	VARCHAR2(256)	    NOT NULL,
	NUM_TRANSACT_MAX	VARCHAR2(256)	    NOT NULL
);

alter table MSSQLTRANSACTIONTEST_THRESH add constraint PK_MSSQLTRANSACTIONTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MSSQLTRANS2TEST_THRESH ON MSSQLTRANSACTIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);   
DROP TABLE MsXCacheTest CASCADE CONSTRAINTS;

CREATE TABLE MsXCacheTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	cacheHitRatio			number(20,4) not null,
	cacheHitRatio_ST		varchar2(32) not null
);

ALTER TABLE MsXCacheTest ADD constraint PK_MsXCacheTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   MsXCacheTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MsXCacheTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	cacheHitRatio_min		number(20,4) not null,
	cacheHitRatio_max		number(20,4) not null,
	cacheHitRatio_stcnt		varchar2(32) not null
);

ALTER TABLE MsXCacheTest_TREND ADD constraint PK_MsXCacheTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXCacheTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MsXCacheTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
 	MSMT_TIME_END   		date,
 	CACHEHITRATIO_MIN	VARCHAR2(256)	 NOT NULL,
	CACHEHITRATIO_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE MsXCacheTest_THRESH ADD constraint PK_MsXCacheTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXCacheTest_THRESH ON MsXCacheTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE MsXDBTest CASCADE CONSTRAINTS;

CREATE TABLE MsXDBTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	dbCacheHit			number(20,4) not null,
	dbCacheHit_ST			varchar2(32) not null,
	dbTablesCacheHit		number(20,4) not null,
	dbTablesCacheHit_st		varchar2(32) not null,
	logRecrdWaitingRate		number(20,4) not null,
	logRecrdWaitingRate_st		varchar2(32) not null,
	logThreadWaiting		Number(20,4) not null,
	logThreadWaiting_st		varchar2(32) not null
);

ALTER TABLE MsXDBTest ADD constraint PK_MsXDBTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   MsXDBTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MsXDBTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	dbCacheHit_min			number(20,4) not null,
	dbCacheHit_max			number(20,4) not null,
	dbCacheHit_stcnt		varchar2(32) not null,
	dbTablesCacheHit_min		number(20,4) not null,
	dbTablesCacheHit_max		number(20,4) not null,
	dbTablesCacheHit_stcnt		varchar2(32) not null,
	logRecrdWaitingRate_min		number(20,4) not null,
	logRecrdWaitingRate_max		number(20,4) not null,
	logRecrdWaitingRate_stcnt	varchar2(32) not null,
	logThreadWaiting_min		Number(20,4) not null,
	logThreadWaiting_max		Number(20,4) not null,
	logThreadWaiting_stcnt		varchar2(32) not null
);

ALTER TABLE MsXDBTest_TREND ADD constraint PK_MsXDBTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXDBTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MsXDBTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
  MSMT_TIME_END   		date,
  DBCACHEHIT_MIN	VARCHAR2(256)	 NOT NULL,
	DBCACHEHIT_MAX	VARCHAR2(256)	 NOT NULL,
	DBTABLESCACHEHIT_MIN	VARCHAR2(256)	 NOT NULL,
	DBTABLESCACHEHIT_MAX	VARCHAR2(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MIN	VARCHAR2(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MAX	VARCHAR2(256)	 NOT NULL,
	LOGTHREADWAITING_MIN	VARCHAR2(256)	 NOT NULL,
	LOGTHREADWAITING_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE MsXDBTest_THRESH ADD constraint PK_MsXDBTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXDBTest_THRESH ON MsXDBTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE MsXMailRetrvlTest CASCADE CONSTRAINTS;

CREATE TABLE MsXMailRetrvlTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	currPop3Conn			Number(20,4) not null,
	currPop3Conn_st			varchar2(32) not null,
	currImapConn			Number(20,4) not null,
	currImapConn_st			varchar2(32) not null,
	pop3ClientWaitingReq		Number(20,4) not null,
	pop3ClientWaitingReq_st		varchar2(32) not null,
	imapClientWaitingReq		Number(20,4) not null,
	imapClientWaitingReq_st		varchar2(32) not null
);

ALTER TABLE MsXMailRetrvlTest ADD constraint PK_MsXMailRetrvlTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   MsXMailRetrvlTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MsXMailRetrvlTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	currPop3Conn_min		Number(20,4) not null,
	currPop3Conn_max		Number(20,4) not null,
	currPop3Conn_stcnt		varchar2(32) not null,
	currImapConn_min		Number(20,4) not null,
	currImapConn_max		Number(20,4) not null,
	currImapConn_stcnt		varchar2(32) not null,
	pop3ClientWaitingReq_min		Number(20,4) not null,
	pop3ClientWaitingReq_max		Number(20,4) not null,
	pop3ClientWaitingReq_stcnt		varchar2(32) not null,
	imapClientWaitingReq_min		Number(20,4) not null,
	imapClientWaitingReq_max		Number(20,4) not null,
	imapClientWaitingReq_stcnt		varchar2(32) not null
);

ALTER TABLE MsXMailRetrvlTest_TREND ADD constraint PK_MsXMailRetrvlTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXMailRetrvlTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MsXMailRetrvlTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	CURRPOP3CONN_MIN	VARCHAR2(256)	 NOT NULL,
	CURRPOP3CONN_MAX	VARCHAR2(256)	 NOT NULL,
	CURRIMAPCONN_MIN	VARCHAR2(256)	 NOT NULL,
	CURRIMAPCONN_MAX	VARCHAR2(256)	 NOT NULL,
	POP3CLIENTWAITINGREQ_MIN	VARCHAR2(256)	 NOT NULL,
	POP3CLIENTWAITINGREQ_MAX	VARCHAR2(256)	 NOT NULL,
	IMAPCLIENTWAITINGREQ_MIN	VARCHAR2(256)	 NOT NULL,
	IMAPCLIENTWAITINGREQ_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE MsXMailRetrvlTest_THRESH ADD constraint PK_MsXMailRetrvlTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXMailRetrvlTest_THRESH ON MsXMailRetrvlTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE MsXMailSvcTest CASCADE CONSTRAINTS;
CREATE TABLE MsXMailSvcTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
INBOUND_QSIZE Number(20,4) NOT NULL,
INBOUND_QSIZE_ST varchar2(32) NOT NULL,
OUTBOUND_QSIZE Number(20,4) NOT NULL,
OUTBOUND_QSIZE_ST varchar2(32) NOT NULL,
MTS_IN_QSIZE Number(20,4) NOT NULL,
MTS_IN_QSIZE_ST varchar2(32) NOT NULL,
MTS_OUT_QSIZE Number(20,4) NOT NULL,
MTS_OUT_QSIZE_ST varchar2(32) NOT NULL,
IN_CONNS Number(20,4) NOT NULL,
IN_CONNS_ST varchar2(32) NOT NULL,
OUT_CONNS Number(20,4) NOT NULL,
OUT_CONNS_ST varchar2(32) NOT NULL,
CONNS_FAILED Number(20,4) NOT NULL,
CONNS_FAILED_ST varchar2(32) NOT NULL,
CONNS_REJECTED Number(20,4) NOT NULL,
CONNS_REJECTED_ST varchar2(32) NOT NULL,
IN_MSGS Number(20,4) NOT NULL,
IN_MSGS_ST varchar2(32) NOT NULL,
OUT_MSGS Number(20,4) NOT NULL,
OUT_MSGS_ST varchar2(32) NOT NULL);

ALTER TABLE MsXMailSvcTest ADD constraint PK_MsXMailSvcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MsXMailSvcTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MsXMailSvcTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
INBOUND_QSIZE_MIN Number(20,4) NOT NULL,
INBOUND_QSIZE_MAX Number(20,4) NOT NULL,
INBOUND_QSIZE_STCNT varchar2(32) NOT NULL,
OUTBOUND_QSIZE_MIN Number(20,4) NOT NULL,
OUTBOUND_QSIZE_MAX Number(20,4) NOT NULL,
OUTBOUND_QSIZE_STCNT varchar2(32) NOT NULL,
MTS_IN_QSIZE_MIN Number(20,4) NOT NULL,
MTS_IN_QSIZE_MAX Number(20,4) NOT NULL,
MTS_IN_QSIZE_STCNT varchar2(32) NOT NULL,
MTS_OUT_QSIZE_MIN Number(20,4) NOT NULL,
MTS_OUT_QSIZE_MAX Number(20,4) NOT NULL,
MTS_OUT_QSIZE_STCNT varchar2(32) NOT NULL,
IN_CONNS_MIN Number(20,4) NOT NULL,
IN_CONNS_MAX Number(20,4) NOT NULL,
IN_CONNS_STCNT varchar2(32) NOT NULL,
OUT_CONNS_MIN Number(20,4) NOT NULL,
OUT_CONNS_MAX Number(20,4) NOT NULL,
OUT_CONNS_STCNT varchar2(32) NOT NULL,
CONNS_FAILED_MIN Number(20,4) NOT NULL,
CONNS_FAILED_MAX Number(20,4) NOT NULL,
CONNS_FAILED_STCNT varchar2(32) NOT NULL,
CONNS_REJECTED_MIN Number(20,4) NOT NULL,
CONNS_REJECTED_MAX Number(20,4) NOT NULL,
CONNS_REJECTED_STCNT varchar2(32) NOT NULL,
IN_MSGS_MIN Number(20,4) NOT NULL,
IN_MSGS_MAX Number(20,4) NOT NULL,
IN_MSGS_STCNT varchar2(32) NOT NULL,
OUT_MSGS_MIN Number(20,4) NOT NULL,
OUT_MSGS_MAX Number(20,4) NOT NULL,
OUT_MSGS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MsXMailSvcTest_TREND ADD constraint PK_MsXMailSvcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsXMailSvcTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MsXMailSvcTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
INBOUND_QSIZE_MIN	VARCHAR2(256)	 NOT NULL,
INBOUND_QSIZE_MAX	VARCHAR2(256)	 NOT NULL,
OUTBOUND_QSIZE_MIN	VARCHAR2(256)	 NOT NULL,
OUTBOUND_QSIZE_MAX	VARCHAR2(256)	 NOT NULL,
MTS_IN_QSIZE_MIN	VARCHAR2(256)	 NOT NULL,
MTS_IN_QSIZE_MAX	VARCHAR2(256)	 NOT NULL,
MTS_OUT_QSIZE_MIN	VARCHAR2(256)	 NOT NULL,
MTS_OUT_QSIZE_MAX	VARCHAR2(256)	 NOT NULL,
IN_CONNS_MIN	VARCHAR2(256)	 NOT NULL,
IN_CONNS_MAX	VARCHAR2(256)	 NOT NULL,
OUT_CONNS_MIN	VARCHAR2(256)	 NOT NULL,
OUT_CONNS_MAX	VARCHAR2(256)	 NOT NULL,
CONNS_FAILED_MIN	VARCHAR2(256)	 NOT NULL,
CONNS_FAILED_MAX	VARCHAR2(256)	 NOT NULL,
CONNS_REJECTED_MIN	VARCHAR2(256)	 NOT NULL,
CONNS_REJECTED_MAX	VARCHAR2(256)	 NOT NULL,
IN_MSGS_MIN	VARCHAR2(256)	 NOT NULL,
IN_MSGS_MAX	VARCHAR2(256)	 NOT NULL,
OUT_MSGS_MIN	VARCHAR2(256)	 NOT NULL,
OUT_MSGS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE MsXMailSvcTest_THRESH ADD constraint PK_MsXMailSvcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsXMailSvcTest_THRESH ON MsXMailSvcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsXMailXferTest CASCADE CONSTRAINTS;

CREATE TABLE MsXMailXferTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	localQSize			Number(20,4) not null,
	localQSize_st			varchar2(32) not null,
	remoteQSize			Number(20,4) not null,
	remoteQSize_st			varchar2(32) not null,
	currSmtpConn			Number(20,4) not null,
	currSmtpConn_st			varchar2(32) not null,
	dataRcvdRate			number(20,4) not null,
	dataRcvdRate_st			varchar2(32) not null,
	dataSentRate			number(20,4) not null,
	dataSentRate_st			varchar2(32) not null,
	avgRetryMsgDelvry		number(20,4) not null,
	avgRetryMsgDelvry_st		varchar2(32) not null,
	avgRetryMsgSent			number(20,4) not null,
	avgRetryMsgSent_st		varchar2(32) not null
);

ALTER TABLE MsXMailXferTest ADD constraint PK_MsXMailXferTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   MsXMailXferTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MsXMailXferTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	localQSize_min			Number(20,4) not null,
	localQSize_max			Number(20,4) not null,
	localQSize_stcnt		varchar2(32) not null,
	remoteQSize_min			Number(20,4) not null,
	remoteQSize_max			Number(20,4) not null,
	remoteQSize_stcnt		varchar2(32) not null,
	currSmtpConn_min		Number(20,4) not null,
	currSmtpConn_max		Number(20,4) not null,
	currSmtpConn_stcnt		varchar2(32) not null,
	dataRcvdRate_min		number(20,4) not null,
	dataRcvdRate_max		number(20,4) not null,
	dataRcvdRate_stcnt		varchar2(32) not null,
	dataSentRate_min		number(20,4) not null,
	dataSentRate_max		number(20,4) not null,
	dataSentRate_stcnt		varchar2(32) not null,
	avgRetryMsgDelvry_min		number(20,4) not null,
	avgRetryMsgDelvry_max		number(20,4) not null,
	avgRetryMsgDelvry_stcnt		varchar2(32) not null,
	avgRetryMsgSent_min		number(20,4) not null,
	avgRetryMsgSent_max		number(20,4) not null,
	avgRetryMsgSent_stcnt		varchar2(32) not null
);

ALTER TABLE MsXMailXferTest_TREND ADD constraint PK_MsXMailXferTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXMailXferTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MsXMailXferTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	LOCALQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	LOCALQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	REMOTEQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	REMOTEQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	CURRSMTPCONN_MIN	VARCHAR2(256)	 NOT NULL,
	CURRSMTPCONN_MAX	VARCHAR2(256)	 NOT NULL,
	DATARCVDRATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATARCVDRATE_MAX	VARCHAR2(256)	 NOT NULL,
	DATASENTRATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATASENTRATE_MAX	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MIN	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MAX	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGSENT_MIN	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGSENT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE MsXMailXferTest_THRESH ADD constraint PK_MsXMailXferTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXMailXferTest_THRESH ON MsXMailXferTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE MsXStoreTest CASCADE CONSTRAINTS;

CREATE TABLE MsXStoreTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	currUsers			Number(20,4) not null,
	currUsers_st			varchar2(32) not null,
	mailSendQSize			Number(20,4) not null,
	mailSendQSize_st		varchar2(32) not null,
	mailRcvdQSize			Number(20,4) not null,
	mailRcvdQSize_st		varchar2(32) not null,
	mailSentRate			number(20,4) not null,
	mailSentRate_st			varchar2(32) not null,
	mailOpensRate			number(20,4) not null,
	mailOpensRate_st		varchar2(32) not null,
	folderOpensRate			number(20,4) not null,
	folderOpensRate_st		varchar2(32) not null,
	avgMailDelvryTime			number(20,4) not null,
	avgMailDelvryTime_st		varchar2(32) not null,
	avgMailLocalDelvryTime		number(20,4) not null,
	avgMailLocalDelvryTime_st		varchar2(32) not null
);

ALTER TABLE MsXStoreTest ADD constraint PK_MsXStoreTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   MsXStoreTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MsXStoreTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	currUsers_min			Number(20,4) not null,
	currUsers_max			Number(20,4) not null,
	currUsers_stcnt			varchar2(32) not null,
	mailSendQSize_min		Number(20,4) not null,
	mailSendQSize_max		Number(20,4) not null,
	mailSendQSize_stcnt		varchar2(32) not null,
	mailRcvdQSize_min		Number(20,4) not null,
	mailRcvdQSize_max		Number(20,4) not null,
	mailRcvdQSize_stcnt		varchar2(32) not null,
	mailSentRate_min		number(20,4) not null,
	mailSentRate_max		number(20,4) not null,
	mailSentRate_stcnt		varchar2(32) not null,
	mailOpensRate_min		number(20,4) not null,
	mailOpensRate_max		number(20,4) not null,
	mailOpensRate_stcnt		varchar2(32) not null,
	folderOpensRate_min		number(20,4) not null,
	folderOpensRate_max		number(20,4) not null,
	folderOpensRate_stcnt		varchar2(32) not null,
	avgMailDelvryTime_min		number(20,4) not null,
	avgMailDelvryTime_max		number(20,4) not null,
	avgMailDelvryTime_stcnt		varchar2(32) not null,
	avgMailLocalDelvryTime_min		number(20,4) not null,
	avgMailLocalDelvryTime_max		number(20,4) not null,
	avgMailLocalDelvryTime_stcnt	varchar2(32) not null
);

ALTER TABLE MsXStoreTest_TREND ADD constraint PK_MsXStoreTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXStoreTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MsXStoreTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	CURRUSERS_MIN	VARCHAR2(256)	 NOT NULL,
	CURRUSERS_MAX	VARCHAR2(256)	 NOT NULL,
	MAILSENDQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILSENDQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	MAILRCVDQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILRCVDQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	MAILSENTRATE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILSENTRATE_MAX	VARCHAR2(256)	 NOT NULL,
	MAILOPENSRATE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILOPENSRATE_MAX	VARCHAR2(256)	 NOT NULL,
	FOLDEROPENSRATE_MIN	VARCHAR2(256)	 NOT NULL,
	FOLDEROPENSRATE_MAX	VARCHAR2(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MIN	VARCHAR2(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MAX	VARCHAR2(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MIN	VARCHAR2(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE MsXStoreTest_THRESH ADD constraint PK_MsXStoreTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXStoreTest_THRESH ON MsXStoreTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE MTSPROCESSTEST CASCADE CONSTRAINTS;

CREATE TABLE MTSPROCESSTEST
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	NUM_PROC	Number(20,4) 	NOT NULL,
	NUM_PROC_ST	varchar2(32)    NOT NULL,
	CPU_UTIL 	number(20,4) 	NOT NULL,
	CPU_UTIL_ST 	varchar2(32)    NOT NULL,
	MEM_UTIL 	number(20,4) 	NOT NULL,
	MEM_UTIL_ST 	varchar2(32)    NOT NULL
);

ALTER TABLE MTSPROCESSTEST ADD constraint PK_MTSPROCESS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MTSPROCESSTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MTSPROCESSTEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO         	varchar2(32),
        SITE_NAME       	varchar2(64),
        INFO            	varchar2(128), 
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD 			varchar2(32),
	NUM_PROC_MIN		Number(20,4) 	NOT NULL,
	NUM_PROC_MAX		Number(20,4) 	NOT NULL,
	NUM_PROC_STCNT		varchar2(32)   	NOT NULL,
	CPU_UTIL_MIN 		number(20,4) 	NOT NULL,
	CPU_UTIL_MAX 		number(20,4) 	NOT NULL,
	CPU_UTIL_STCNT 		varchar2(32)   	NOT NULL,
	MEM_UTIL_MIN 		number(20,4) 	NOT NULL,
	MEM_UTIL_MAX 		number(20,4) 	NOT NULL,
	MEM_UTIL_STCNT 		varchar2(32)   	NOT NULL
);

ALTER TABLE MTSPROCESSTEST_TREND ADD constraint PK_MTSPROCESS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MTSPROCESSTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MTSPROCESSTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	NUM_PROC_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_PROC_MAX	VARCHAR2(256)	 	NOT NULL,
	CPU_UTIL_MIN	VARCHAR2(256)	 	NOT NULL,
	CPU_UTIL_MAX	VARCHAR2(256)	 	NOT NULL,
	MEM_UTIL_MIN	VARCHAR2(256)	 	NOT NULL,
	MEM_UTIL_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE MTSPROCESSTEST_THRESH ADD constraint PK_MTSPROCESS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MTSPROCESSTEST_THRESH ON MTSPROCESSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 
DROP TABLE MTSTEST CASCADE CONSTRAINTS;

CREATE TABLE MTSTEST
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	TOTAL_PACKAGES_COUNT		number(4)	NOT NULL, 	
	TOTAL_PACKAGES_COUNT_ST		varchar2(32)	NOT NULL,
	TOTAL_COMPONENTS_COUNT		number(6)	NOT NULL,
	TOTAL_COMPONENTS_COUNT_ST	varchar2(32)	NOT NULL,
	TOTAL_RUNNING_PACK_COUNT	number(4)	NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_ST 	varchar2(32)	NOT NULL
);

ALTER TABLE MTSTEST ADD constraint PK_MTS	
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MTSTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MTSTEST_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 			varchar2(32),
	TOTAL_PACKAGES_COUNT_MIN	number(4)		NOT NULL, 	
	TOTAL_PACKAGES_COUNT_MAX	number(4)		NOT NULL, 	
	TOTAL_PACKAGES_COUNT_STCNT	varchar2(32)	NOT NULL, 	
	TOTAL_COMPONENTS_COUNT_MIN	number(6)		NOT NULL,
	TOTAL_COMPONENTS_COUNT_MAX	number(6)		NOT NULL,	
	TOTAL_COMPONENTS_COUNT_STCNT	varchar2(32)	NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MIN	number(4)		NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MAX	number(4)		NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_STCNT	varchar2(32)	NOT NULL
);

ALTER TABLE MTSTEST_TREND ADD constraint PK_MTS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MTSTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MTSTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
	TOTAL_PACKAGES_COUNT_MIN	VARCHAR2(256)			NOT NULL,
	TOTAL_PACKAGES_COUNT_MAX	VARCHAR2(256)			NOT NULL,
	TOTAL_COMPONENTS_COUNT_MIN	VARCHAR2(256)			NOT NULL,
	TOTAL_COMPONENTS_COUNT_MAX	VARCHAR2(256)			NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MIN	VARCHAR2(256)			NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MAX	VARCHAR2(256)			NOT NULL
);

ALTER TABLE MTSTEST_THRESH ADD constraint PK_MTS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MTSTEST_THRESH ON MTSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE NASSNMPTEST  CASCADE CONSTRAINTS;

CREATE TABLE NASSNMPTEST 
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                         varchar2(32),
        SITE_NAME                       varchar2(64),
        INFO                            varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	REQ_RATE 			number(20,4)	NOT NULL,
	REQ_RATE_ST 			varchar2(32)		NOT NULL,
	RESP_TIME 			number(20,4)	NOT NULL,
	RESP_TIME_ST 			varchar2(32)		NOT NULL,
	PCT_ACTIVE_THREADS		number(20,4)	NOT NULL,
	PCT_ACTIVE_THREADS_ST		varchar2(32)		NOT NULL,
	DATA_RATE_OUT 			number(20,4)	NOT NULL,
	DATA_RATE_OUT_ST 		varchar2(32)		NOT NULL,
	DATA_RATE_IN 			number(20,4)	NOT NULL,
	DATA_RATE_IN_ST 		varchar2(32)		NOT NULL
);

ALTER TABLE NASSNMPTEST ADD CONSTRAINT PK_NAS_SNMP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE NASSNMPTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE NASSNMPTEST_TREND 
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                         varchar2(32),
        SITE_NAME                       varchar2(64),
        INFO                            varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD 				varchar2(32), 
	REQ_RATE_MIN 			number(20,4)	NOT NULL,
	REQ_RATE_MAX 			number(20,4)	NOT NULL,
	REQ_RATE_STCNT		 	varchar2(32)	NOT NULL,
	RESP_TIME_MIN 			number(20,4)	NOT NULL,
	RESP_TIME_MAX 			number(20,4)	NOT NULL,
	RESP_TIME_STCNT 		varchar2(32)	NOT NULL,
	PCT_ACTIVE_THREADS_MIN		number(20,4)	NOT NULL,
	PCT_ACTIVE_THREADS_MAX		number(20,4)	NOT NULL,
	PCT_ACTIVE_THREADS_STCNT 	varchar2(32)	NOT NULL,
	DATA_RATE_OUT_MIN 		number(20,4)	NOT NULL,
	DATA_RATE_OUT_MAX 		number(20,4)	NOT NULL,
	DATA_RATE_OUT_STCNT 		varchar2(32)	NOT NULL,
	DATA_RATE_IN_MIN 		number(20,4)	NOT NULL,
	DATA_RATE_IN_MAX 		number(20,4)	NOT NULL,
	DATA_RATE_IN_STCNT 		varchar2(32)	NOT NULL
);

ALTER TABLE NASSNMPTEST_TREND ADD CONSTRAINT PK_NAS_SNMP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE NASSNMPTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE NASSNMPTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START 	date,
        MSMT_TIME_END           date,
	REQ_RATE_MIN	VARCHAR2(256)		NOT NULL,
	REQ_RATE_MAX	VARCHAR2(256)		NOT NULL,
	RESP_TIME_MIN	VARCHAR2(256)		NOT NULL,
	RESP_TIME_MAX	VARCHAR2(256)		NOT NULL,
	PCT_ACTIVE_THREADS_MIN	VARCHAR2(256)		NOT NULL,
	PCT_ACTIVE_THREADS_MAX	VARCHAR2(256)		NOT NULL,
	DATA_RATE_OUT_MIN	VARCHAR2(256)		NOT NULL,
	DATA_RATE_OUT_MAX	VARCHAR2(256)		NOT NULL,
	DATA_RATE_IN_MIN	VARCHAR2(256)		NOT NULL,
	DATA_RATE_IN_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE NASSNMPTEST_THRESH ADD CONSTRAINT PK_NAS_SNMP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NASSNMPTEST_THRESH ON NASSNMPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE NETWORKBANDWIDTHTEST CASCADE CONSTRAINTS;

CREATE TABLE NETWORKBANDWIDTHTEST 
(
        TRGT_HOST            varchar2(32),
        PORT_NO              varchar2(32),
        SITE_NAME            varchar2(64),
        INFO                 varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME            date,
        RCVD_RATE           	NUMBER(20,4)    NOT NULL,
        RCVD_RATE_ST        VARCHAR2(32)    NOT NULL,
        XMIT_RATE           NUMBER(20,4)    NOT NULL,
        XMIT_RATE_ST        VARCHAR2(32)    NOT NULL,
        PCT_BANDW             NUMBER(20,4)    NOT NULL,
        PCT_BANDW_ST          VARCHAR2(32)    NOT NULL
);

alter table NETWORKBANDWIDTHTEST add constraint PK_NETWORKBANDWIDTHTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE NETWORKBANDWIDTHTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE NETWORKBANDWIDTHTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
        RCVD_RATE_MIN           	NUMBER(20,4)    NOT NULL,
        RCVD_RATE_MAX           	NUMBER(20,4)    NOT NULL,
        RCVD_RATE_STCNT        	VARCHAR2(32)    NOT NULL,
        XMIT_RATE_MIN          	NUMBER(20,4)    NOT NULL,
        XMIT_RATE_MAX           	NUMBER(20,4)    NOT NULL,
        XMIT_RATE_STCNT        	VARCHAR2(32)    NOT NULL,
        PCT_BANDW_MIN                    NUMBER(20,4)    NOT NULL,
        PCT_BANDW_MAX             	NUMBER(20,4)    NOT NULL,
        PCT_BANDW_STCNT          	VARCHAR2(32)    NOT NULL
);


alter table NETWORKBANDWIDTHTEST_TREND add constraint PK_NETWORKBANDWIDTHTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE NETWORKBANDWIDTHTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE NETWORKBANDWIDTHTEST_THRESH 
(
        TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,
        RCVD_RATE_MIN	VARCHAR2(256)	    NOT NULL,
        RCVD_RATE_MAX	VARCHAR2(256)	    NOT NULL,
        XMIT_RATE_MIN	VARCHAR2(256)	    NOT NULL,
        XMIT_RATE_MAX	VARCHAR2(256)	    NOT NULL,
        PCT_BANDW_MIN	VARCHAR2(256)	    NOT NULL,
        PCT_BANDW_MAX	VARCHAR2(256)	    NOT NULL
);

alter table NETWORKBANDWIDTHTEST_THRESH add constraint PK_NETWORKBANDWIDTHTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NETBANDWIDTHTEST_THRESH ON NETWORKBANDWIDTHTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 
DROP TABLE NETWORKTEST CASCADE CONSTRAINTS;

CREATE TABLE NETWORKTEST 
(
	TRGT_HOST            varchar2(32),
    PORT_NO              varchar2(32),
    SITE_NAME            varchar2(64),
    INFO                 varchar2(128),
	MSMT_HOST 		varchar2(32), 
    MSMT_TIME            date,
	AVG_RND_TRIP	     number(20,4)      NOT NULL,
	AVG_RND_TRIP_ST      varchar2(32)      NOT NULL,
	MIN_RND_TRIP	     number(20,4)      NOT NULL,
	MIN_RND_TRIP_ST	     varchar2(32)      NOT NULL,
	PKT_LOSS_PCT	     number(20,4)       NOT NULL,
	PKT_LOSS_PCT_ST	     varchar2(32)      NOT NULL,
	AVAILABILITY	     NUMBER(3)	     NOT NULL,
	AVAILABILITY_ST	     VARCHAR2(32)    NOT NULL
);
CREATE  INDEX IDX1_NETWORKTEST ON NETWORKTEST(PKT_LOSS_PCT,AVAILABILITY,AVG_RND_TRIP);
alter table NETWORKTEST add constraint PK_NETWORK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE NETWORKTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE NETWORKTEST_TREND 
(
	TRGT_HOST            		varchar2(32),
    PORT_NO              		varchar2(32),
    SITE_NAME            		varchar2(64),
    INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD	             		varchar2(32), 
	AVG_RND_TRIP_MIN		number(20,4)      NOT NULL,
	AVG_RND_TRIP_MAX		number(20,4)      NOT NULL,
	AVG_RND_TRIP_STCNT 		varchar2(32)      NOT NULL,
	MIN_RND_TRIP_MIN     		number(20,4)      NOT NULL,
	MIN_RND_TRIP_MAX     		number(20,4)      NOT NULL,
	MIN_RND_TRIP_STCNT 		varchar2(32)      NOT NULL,
	PKT_LOSS_PCT_MIN		number(20,4)       NOT NULL,
	PKT_LOSS_PCT_MAX		number(20,4)       NOT NULL,
	PKT_LOSS_PCT_STCNT 		varchar2(32)      NOT NULL,
	AVAILABILITY_MIN	NUMBER(20,4)	    NOT NULL,
	AVAILABILITY_MAX	NUMBER(20,4)	    NOT NULL,
	AVAILABILITY_STCNT	VARCHAR2(32)    NOT NULL
);

alter table NETWORKTEST_TREND add constraint PK_NETWORK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE NETWORKTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE NETWORKTEST_THRESH 
(
	TRGT_HOST               varchar2(32),
    PORT_NO                 varchar2(32),
    SITE_NAME               varchar2(64),
    INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
    MSMT_TIME_END           date,
	AVG_RND_TRIP_MIN	VARCHAR2(256)	 NOT NULL,
	AVG_RND_TRIP_MAX	VARCHAR2(256)	 NOT NULL,
	MIN_RND_TRIP_MIN	VARCHAR2(256)	 NOT NULL,
	MIN_RND_TRIP_MAX	VARCHAR2(256)	 NOT NULL,
	PKT_LOSS_PCT_MIN	VARCHAR2(256)	  NOT NULL,
	PKT_LOSS_PCT_MAX	VARCHAR2(256)	  NOT NULL,
	AVAILABILITY_MIN	VARCHAR2(256)	     NOT NULL,
	AVAILABILITY_MAX	VARCHAR2(256)	     NOT NULL
);

alter table NETWORKTEST_THRESH add constraint PK_NETWORK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NETWORKTEST_THRESH ON NETWORKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE UdNETWORKTRAFFICTEST  CASCADE CONSTRAINTS;

CREATE TABLE UdNETWORKTRAFFICTEST 
(
	TRGT_HOST       varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME       date,
	INP_PKT_RATE	number(20,4) NOT NULL,
	INP_PKT_RATE_ST	varchar2(32)      NOT NULL,
	OUT_PKT_RATE 	number(20,4) NOT NULL,
	OUT_PKT_RATE_ST	varchar2(32)      NOT NULL
);

alter table UdNETWORKTRAFFICTEST add constraint PK_UdNETWORKTRAFFIC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

  
DROP TABLE NETWORKTRAFFICTEST  CASCADE CONSTRAINTS;

CREATE TABLE NETWORKTRAFFICTEST 
(
	TRGT_HOST       varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME       date,
	INP_PKT_RATE	number(20,4) NOT NULL,
	INP_PKT_RATE_ST	varchar2(32)      NOT NULL,
	OUT_PKT_RATE 	number(20,4) NOT NULL,
	OUT_PKT_RATE_ST	varchar2(32)      NOT NULL
);

alter table NETWORKTRAFFICTEST add constraint PK_NETWORK_TRAFFIC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE NETWORKTRAFFICTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE NETWORKTRAFFICTEST_TREND 
(
	TRGT_HOST       		varchar2(32),
        PORT_NO         		varchar2(32),
        SITE_NAME       		varchar2(64),
        INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME       		date,
	PERIOD       			varchar2(32),
	INP_PKT_RATE_MIN		number(20,4) NOT NULL,
	INP_PKT_RATE_MAX		number(20,4) NOT NULL,
	INP_PKT_RATE_STCNT 		varchar2(32) NOT NULL,
	OUT_PKT_RATE_MIN 		number(20,4) NOT NULL,
	OUT_PKT_RATE_MAX 		number(20,4) NOT NULL,
	OUT_PKT_RATE_STCNT 		varchar2(32) NOT NULL
);

alter table NETWORKTRAFFICTEST_TREND add constraint PK_NETWORK_TRAFFIC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE NETWORKTRAFFICTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE NETWORKTRAFFICTEST_THRESH
(
	TRGT_HOST       varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START date,
        MSMT_TIME_END   date,
	INP_PKT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	INP_PKT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	OUT_PKT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	OUT_PKT_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

alter table NETWORKTRAFFICTEST_THRESH add constraint PK_NET_TRAFFIC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NETWORKTRAFFICTEST_THRESH ON NETWORKTRAFFICTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);      
DROP TABLE NewsGroupTest CASCADE CONSTRAINTS;

CREATE TABLE NewsGroupTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	logonFailureRate		number(20,4) not null,
	logonFailureRate_st		varchar2(32) not null,
	dataRcvdRate			number(20,4) not null,
	dataRcvdRate_st			varchar2(32) not null,
	dataSentRate			number(20,4) not null,
	dataSentRate_st			varchar2(32) not null
);

ALTER TABLE NewsGroupTest ADD constraint PK_NewsGroupTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   NewsGroupTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE NewsGroupTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	logonFailureRate_min		number(20,4) not null,
	logonFailureRate_max		number(20,4) not null,
	logonFailureRate_stcnt		varchar2(32) not null,
	dataRcvdRate_min		number(20,4) not null,
	dataRcvdRate_max		number(20,4) not null,
	dataRcvdRate_stcnt		varchar2(32) not null,
	dataSentRate_min		number(20,4) not null,
	dataSentRate_max		number(20,4) not null,
	dataSentRate_stcnt		varchar2(32) not null
);

ALTER TABLE NewsGroupTest_TREND ADD constraint PK_NewsGroupTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   NewsGroupTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE NewsGroupTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	LOGONFAILURERATE_MIN	VARCHAR2(256)	 NOT NULL,
	LOGONFAILURERATE_MAX	VARCHAR2(256)	 NOT NULL,
	DATARCVDRATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATARCVDRATE_MAX	VARCHAR2(256)	 NOT NULL,
	DATASENTRATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATASENTRATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE NewsGroupTest_THRESH ADD constraint PK_NewsGroupTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_NewsGroupTest_THRESH ON NewsGroupTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE ORADATAFILETEST CASCADE CONSTRAINTS;

CREATE TABLE ORADATAFILETEST
(
        TRGT_HOST            varchar2(32),
        PORT_NO              varchar2(32),
        SITE_NAME            varchar2(64),
        INFO                 varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME            date,
        PHY_BLKRDS_RATE	     NUMBER(20,4)    NOT NULL,
        PHY_BLKRDS_RATE_ST   VARCHAR2(32)    NOT NULL, 
        PHY_BLKWRTS_RATE     NUMBER(20,4)    NOT NULL,
        PHY_BLKWRTS_RATE_ST  VARCHAR2(32)    NOT NULL,
		PCT_USAGE			 NUMBER(20,4)	 NOT NULL,
		PCT_USAGE_ST		 VARCHAR2(32)	 NOT NULL      
);

alter table ORADATAFILETEST add constraint PK_ORA_DATAFILE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ORADATAFILETEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ORADATAFILETEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD            		varchar2(32), 
        PHY_BLKRDS_RATE_MIN	        NUMBER(20,4)    NOT NULL,
        PHY_BLKRDS_RATE_MAX	        NUMBER(20,4)    NOT NULL,
        PHY_BLKRDS_RATE_STCNT   	VARCHAR2(32)    NOT NULL, 
        PHY_BLKWRTS_RATE_MIN     	NUMBER(20,4)    NOT NULL,
        PHY_BLKWRTS_RATE_MAX     	NUMBER(20,4)    NOT NULL,
        PHY_BLKWRTS_RATE_STCNT  	VARCHAR2(32)    NOT NULL,
		PCT_USAGE_MIN				NUMBER(20,4)	NOT NULL,
		PCT_USAGE_MAX				NUMBER(20,4)	NOT NULL,
		PCT_USAGE_STCNT				VARCHAR2(32)	NOT NULL     
);


alter table ORADATAFILETEST_TREND add constraint PK_ORA_DATAFILE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORADATAFILETEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ORADATAFILETEST_THRESH
(
        TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,
        PHY_BLKRDS_RATE_MIN	VARCHAR2(256)	  NOT NULL,
        PHY_BLKRDS_RATE_MAX	VARCHAR2(256)	  NOT NULL,
        PHY_BLKWRTS_RATE_MIN	VARCHAR2(256)	  NOT NULL,
        PHY_BLKWRTS_RATE_MAX	VARCHAR2(256)	  NOT NULL,
		PCT_USAGE_MIN	VARCHAR2(256)	  NOT NULL,
		PCT_USAGE_MAX	VARCHAR2(256)	  NOT NULL
);

alter table ORADATAFILETEST_THRESH add constraint PK_ORA_DATAFILE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORADATAFILETEST_THRESH ON ORADATAFILETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE ORALOCKTEST CASCADE CONSTRAINTS;

CREATE TABLE ORALOCKTEST 
(
        TRGT_HOST            varchar2(32),
        PORT_NO              varchar2(32),
        SITE_NAME            varchar2(64),
        INFO                 varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME            date,
        CURR_LOCK            NUMBER(20,4)    NOT NULL,
        CURR_LOCK_ST         VARCHAR2(32)    NOT NULL,
        AVG_LOCK_TIME        NUMBER(20,4)    NOT NULL,
        AVG_LOCK_TIME_ST     VARCHAR2(32)    NOT NULL 
);

alter table ORALOCKTEST add constraint PK_ORA_LOCK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ORALOCKTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ORALOCKTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
        CURR_LOCK_MIN           	NUMBER(20,4)    NOT NULL,
        CURR_LOCK_MAX           	NUMBER(20,4)    NOT NULL,
        CURR_LOCK_STCNT         	VARCHAR2(32)    NOT NULL,
        AVG_LOCK_TIME_MIN        	NUMBER(20,4)    NOT NULL,
        AVG_LOCK_TIME_MAX        	NUMBER(20,4)    NOT NULL,
        AVG_LOCK_TIME_STCNT     	VARCHAR2(32)    NOT NULL 
);


alter table ORALOCKTEST_TREND add constraint PK_ORA_LOCK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORALOCKTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ORALOCKTEST_THRESH
(
        TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,
        CURR_LOCK_MIN	VARCHAR2(256)	  NOT NULL,
        CURR_LOCK_MAX	VARCHAR2(256)	  NOT NULL,
        AVG_LOCK_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        AVG_LOCK_TIME_MAX	VARCHAR2(256)	  NOT NULL
);

alter table ORALOCKTEST_THRESH add constraint PK_ORA_LOCK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORALOCKTEST_THRESH ON ORALOCKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);         
DROP TABLE ORAPROCESSTEST CASCADE CONSTRAINTS;

CREATE TABLE ORAPROCESSTEST
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	NUM_PROC	Number(20,4) 	NOT NULL,
	NUM_PROC_ST	varchar2(32)     	NOT NULL,
	CPU_UTIL 	number(20,4) 	NOT NULL,
	CPU_UTIL_ST 	varchar2(32)     	NOT NULL,
	MEM_UTIL 	number(20,4) 	NOT NULL,
	MEM_UTIL_ST 	varchar2(32)     	NOT NULL
);

ALTER TABLE ORAPROCESSTEST ADD constraint PK_ORAPROCESS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ORAPROCESSTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ORAPROCESSTEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO         	varchar2(32),
        SITE_NAME       	varchar2(64),
        INFO            	varchar2(128), 
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD 			varchar2(32), 
	NUM_PROC_MIN		Number(20,4) 	NOT NULL,
	NUM_PROC_MAX		Number(20,4) 	NOT NULL,
	NUM_PROC_STCNT		varchar2(32)   	NOT NULL,
	CPU_UTIL_MIN 		number(20,4) 	NOT NULL,
	CPU_UTIL_MAX 		number(20,4) 	NOT NULL,
	CPU_UTIL_STCNT 		varchar2(32)   	NOT NULL,
	MEM_UTIL_MIN 		number(20,4) 	NOT NULL,
	MEM_UTIL_MAX 		number(20,4) 	NOT NULL,
	MEM_UTIL_STCNT 		varchar2(32)   	NOT NULL
);

ALTER TABLE ORAPROCESSTEST_TREND ADD constraint PK_ORAPROCESS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORAPROCESSTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ORAPROCESSTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	NUM_PROC_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_PROC_MAX	VARCHAR2(256)	 	NOT NULL,
	CPU_UTIL_MIN	VARCHAR2(256)	 	NOT NULL,
	CPU_UTIL_MAX	VARCHAR2(256)	 	NOT NULL,
	MEM_UTIL_MIN	VARCHAR2(256)	 	NOT NULL,
	MEM_UTIL_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE ORAPROCESSTEST_THRESH ADD constraint PK_ORAPROCESS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORAPROCESSTEST_THRESH ON ORAPROCESSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE ORAROLLBACKTEST CASCADE CONSTRAINTS;

CREATE TABLE ORAROLLBACKTEST
(
        TRGT_HOST                 varchar2(32),
        PORT_NO                   varchar2(32),
        SITE_NAME                 varchar2(64),
        INFO                      varchar2(128),
	MSMT_HOST 		  varchar2(32), 
	MSMT_TIME                 date,
	PCT_SYS_SEG_WAIT       	  NUMBER(20,4)     NOT NULL,
	PCT_SYS_SEG_WAIT_ST       VARCHAR2(32)    NOT NULL,
	PCT_NON_SYS_SEG_WAIT      NUMBER(20,4)     NOT NULL,
        PCT_NON_SYS_SEG_WAIT_ST   VARCHAR2(32)    NOT NULL
);

alter table ORAROLLBACKTEST add constraint PK_ORA_ROLLBACK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ORAROLLBACKTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ORAROLLBACKTEST_TREND
(
        TRGT_HOST                 		varchar2(32),
        PORT_NO                   		varchar2(32),
        SITE_NAME                 		varchar2(64),
        INFO                      		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME                 		date,
	PERIOD                 			varchar2(32), 
	PCT_SYS_SEG_WAIT_MIN        		NUMBER(20,4)     NOT NULL,
	PCT_SYS_SEG_WAIT_MAX        		NUMBER(20,4)     NOT NULL,
	PCT_SYS_SEG_WAIT_STCNT       		VARCHAR2(32)    NOT NULL,
	PCT_NON_SYS_SEG_WAIT_MIN      		NUMBER(20,4)     NOT NULL,
	PCT_NON_SYS_SEG_WAIT_MAX      		NUMBER(20,4)     NOT NULL,
        PCT_NON_SYS_SEG_WAIT_STCNT   		VARCHAR2(32)    NOT NULL
);


alter table ORAROLLBACKTEST_TREND add constraint PK_ORA_ROLL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORAROLLBACKTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ORAROLLBACKTEST_THRESH
(
        TRGT_HOST                  varchar2(32),
        PORT_NO                    varchar2(32),
        SITE_NAME                  varchar2(64),
        INFO                       varchar2(128),
	MSMT_HOST 		   varchar2(32), 
	MSMT_TIME_START            date,
        MSMT_TIME_END              date,
	PCT_SYS_SEG_WAIT_MIN	VARCHAR2(256)	     NOT NULL,
	PCT_SYS_SEG_WAIT_MAX	VARCHAR2(256)		   NOT NULL,
	PCT_NON_SYS_SEG_WAIT_MIN	VARCHAR2(256)	     NOT NULL,
        PCT_NON_SYS_SEG_WAIT_MAX	VARCHAR2(256)		   NOT NULL
);

alter table ORAROLLBACKTEST_THRESH add constraint PK_ORA_ROLL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_ORAROLLBACKTEST_THRESH ON ORAROLLBACKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE ORASESSIONTEST CASCADE CONSTRAINTS;

CREATE TABLE ORASESSIONTEST 
(
        TRGT_HOST              varchar2(32),
        PORT_NO                varchar2(32),
        SITE_NAME              varchar2(64),
        INFO                   varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME              date,
        CURR_SESSIONS           NUMBER(20,4)    NOT NULL,
        CURR_SESSIONS_ST        VARCHAR2(32)    NOT NULL,
        CURR_ACT_SESSION       NUMBER(20,4)    NOT NULL,
        CURR_ACT_SESSION_ST    VARCHAR2(32)    NOT NULL,
	BACKGROUND_SESSION       NUMBER(20,4)    NOT NULL,
        BACKGROUND_SESSION_ST    VARCHAR2(32)    NOT NULL,
	INACTIVE_SESSION       NUMBER(20,4)    NOT NULL,
	INACTIVE_SESSION_ST    VARCHAR2(32)    NOT NULL,
	KILLED_SESSION       NUMBER(20,4)    NOT NULL,
	KILLED_SESSION_ST    VARCHAR2(32)    NOT NULL,
	CACHED_SESSION       NUMBER(20,4)    NOT NULL,
	CACHED_SESSION_ST    VARCHAR2(32)    NOT NULL,
	SNIPED_SESSION       NUMBER(20,4)    NOT NULL,
	SNIPED_SESSION_ST    VARCHAR2(32)    NOT NULL,
	BLOCKED_SESSION       NUMBER(20,4)    NOT NULL,
	BLOCKED_SESSION_ST    VARCHAR2(32)    NOT NULL
);

alter table ORASESSIONTEST add constraint PK_ORA_SESSION
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ORASESSIONTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ORASESSIONTEST_TREND
(
        TRGT_HOST              		varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME              		varchar2(64),
        INFO                   		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME              		date,
	PERIOD              		varchar2(32), 
        CURR_SESSIONS_MIN      		NUMBER(20,4)    NOT NULL,
        CURR_SESSIONS_MAX      		NUMBER(20,4)    NOT NULL,
        CURR_SESSIONS_STCNT       	VARCHAR2(32)    NOT NULL,
        CURR_ACT_SESSION_MIN            NUMBER(20,4)    NOT NULL,
        CURR_ACT_SESSION_MAX            NUMBER(20,4)    NOT NULL,
        CURR_ACT_SESSION_STCNT    	VARCHAR2(32)    NOT NULL,
	BACKGROUND_SESSION_MIN		NUMBER(20,4)    NOT NULL,
	BACKGROUND_SESSION_MAX		NUMBER(20,4)    NOT NULL,
	BACKGROUND_SESSION_STCNT	VARCHAR2(32)    NOT NULL,
	INACTIVE_SESSION_MIN		NUMBER(20,4)    NOT NULL,
	INACTIVE_SESSION_MAX		NUMBER(20,4)    NOT NULL,
	INACTIVE_SESSION_STCNT		VARCHAR2(32)    NOT NULL,
	KILLED_SESSION_MIN		NUMBER(20,4)    NOT NULL,
	KILLED_SESSION_MAX		NUMBER(20,4)    NOT NULL,
	KILLED_SESSION_STCNT		VARCHAR2(32)    NOT NULL,
	CACHED_SESSION_MIN		NUMBER(20,4)    NOT NULL,
	CACHED_SESSION_MAX		NUMBER(20,4)    NOT NULL,
	CACHED_SESSION_STCNT		VARCHAR2(32)    NOT NULL,
	SNIPED_SESSION_MIN		NUMBER(20,4)    NOT NULL,
	SNIPED_SESSION_MAX		NUMBER(20,4)    NOT NULL,
	SNIPED_SESSION_STCNT		VARCHAR2(32)    NOT NULL,
	BLOCKED_SESSION_MIN		NUMBER(20,4)    NOT NULL,
	BLOCKED_SESSION_MAX		NUMBER(20,4)    NOT NULL,
	BLOCKED_SESSION_STCNT		VARCHAR2(32)    NOT NULL
);


alter table ORASESSIONTEST_TREND add constraint PK_ORA_SESSION_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORASESSIONTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ORASESSIONTEST_THRESH
(
        TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,
        CURR_SESSIONS_MIN	VARCHAR2(256)	  NOT NULL,
        CURR_SESSIONS_MAX	VARCHAR2(256)	  NOT NULL,
        CURR_ACT_SESSION_MIN	VARCHAR2(256)	  NOT NULL,
        CURR_ACT_SESSION_MAX	VARCHAR2(256)	  NOT NULL,
	BACKGROUND_SESSION_MIN	VARCHAR2(256)	  NOT NULL,
	BACKGROUND_SESSION_MAX	VARCHAR2(256)	  NOT NULL,
	INACTIVE_SESSION_MIN	VARCHAR2(256)	  NOT NULL,
	INACTIVE_SESSION_MAX	VARCHAR2(256)	  NOT NULL,
	KILLED_SESSION_MIN	VARCHAR2(256)	  NOT NULL,
	KILLED_SESSION_MAX	VARCHAR2(256)	  NOT NULL,
	CACHED_SESSION_MIN	VARCHAR2(256)	  NOT NULL,
	CACHED_SESSION_MAX	VARCHAR2(256)	  NOT NULL,
	SNIPED_SESSION_MIN	VARCHAR2(256)	  NOT NULL,
	SNIPED_SESSION_MAX	VARCHAR2(256)	  NOT NULL,
	BLOCKED_SESSION_MIN	VARCHAR2(256)	  NOT NULL,
	BLOCKED_SESSION_MAX	VARCHAR2(256)	  NOT NULL
);

alter table ORASESSIONTEST_THRESH add constraint PK_ORA_SESSION_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORASESSIONTEST_THRESH ON ORASESSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE ORASGATEST CASCADE CONSTRAINTS;
CREATE TABLE ORASGATEST
(
        TRGT_HOST                 varchar2(32),
        PORT_NO                   varchar2(32),
        SITE_NAME                 varchar2(64),
        INFO                      varchar2(128),
	MSMT_HOST 		  varchar2(32), 
	MSMT_TIME                 date,
	PCT_LIBCACHE_RATIO        NUMBER(20,4)      NOT NULL,
        PCT_LIBCACHE_RATIO_ST     VARCHAR2(32)     NOT NULL,
	PCT_DICTCACHE_RATIO       NUMBER(20,4)      NOT NULL,
        PCT_DICTCACHE_RATIO_ST    VARCHAR2(32)     NOT NULL,
	PCT_DBBUFFCACHE_RATIO     NUMBER(20,4)      NOT NULL,
        PCT_DBBUFFCACHE_RATIO_ST  VARCHAR2(32)     NOT NULL,
	PCT_REDOLOG_MISS_RATIO    NUMBER(20,4)    NOT NULL,
	PCT_REDOLOG_MISS_RATIO_ST VARCHAR2(32)   NOT NULL,
	PCT_SORTS_DISK            NUMBER(20,4)      NOT NULL,
        PCT_SORTS_DISK_ST         VARCHAR2(32)     NOT NULL,
	SGA_CURR_USAGE            NUMBER(20,4)      NOT NULL,
        SGA_CURR_USAGE_ST         VARCHAR2(32)     NOT NULL,
	BUFFER_NOWAIT_PCT         NUMBER(20,4)      NOT NULL,
        BUFFER_NOWAIT_PCT_ST      VARCHAR2(32)     NOT NULL,
	SOFT_PARSE_RATIO          NUMBER(20,4)      NOT NULL,
        SOFT_PARSE_RATIO_ST       VARCHAR2(32)     NOT NULL,
	EXECUTE_PARSE_RATIO       NUMBER(20,4)      NOT NULL,
        EXECUTE_PARSE_RATIO_ST    VARCHAR2(32)     NOT NULL,
	CPU_PARSE_RATIO           NUMBER(20,4)      NOT NULL,
        CPU_PARSE_RATIO_ST        VARCHAR2(32)     NOT NULL,
	NON_PARSE_CPU_RATIO       NUMBER(20,4)      NOT NULL,
        NON_PARSE_CPU_RATIO_ST    VARCHAR2(32)     NOT NULL,
	HARD_PARSE_RATIO          NUMBER(20,4)      NOT NULL,
        HARD_PARSE_RATIO_ST       VARCHAR2(32)     NOT NULL,
	TARGET_SIZE_PCT           NUMBER(20,4)      NOT NULL,
        TARGET_SIZE_PCT_ST        VARCHAR2(32)     NOT NULL
);

alter table ORASGATEST add constraint PK_ORA_SGA
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ORASGATEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE ORASGATEST_TREND
(
        TRGT_HOST                 		varchar2(32),
        PORT_NO                   		varchar2(32),
        SITE_NAME                 		varchar2(64),
        INFO                      		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME                 		date,
	PERIOD                 			varchar2(32), 
	PCT_LIBCACHE_RATIO_MIN        		NUMBER(20,4)      NOT NULL,
	PCT_LIBCACHE_RATIO_MAX        		NUMBER(20,4)      NOT NULL,
        PCT_LIBCACHE_RATIO_STCNT           	VARCHAR2(32)     NOT NULL,
	PCT_DICTCACHE_RATIO_MIN                 NUMBER(20,4)      NOT NULL,
	PCT_DICTCACHE_RATIO_MAX                 NUMBER(20,4)      NOT NULL,
        PCT_DICTCACHE_RATIO_STCNT          	VARCHAR2(32)     NOT NULL,
	PCT_DBBUFFCACHE_RATIO_MIN               NUMBER(20,4)      NOT NULL,
	PCT_DBBUFFCACHE_RATIO_MAX               NUMBER(20,4)      NOT NULL,
        PCT_DBBUFFCACHE_RATIO_STCNT        	VARCHAR2(32)     NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MIN              NUMBER(20,4)    NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MAX              NUMBER(20,4)    NOT NULL,
	PCT_REDOLOG_MISS_RATIO_STCNT       	VARCHAR2(32)   NOT NULL,
	PCT_SORTS_DISK_MIN                      NUMBER(20,4)      NOT NULL,
	PCT_SORTS_DISK_MAX                      NUMBER(20,4)      NOT NULL,
        PCT_SORTS_DISK_STCNT               	VARCHAR2(32)     NOT NULL,
	SGA_CURR_USAGE_MIN                      NUMBER(20,4)      NOT NULL,
	SGA_CURR_USAGE_MAX                      NUMBER(20,4)      NOT NULL,
        SGA_CURR_USAGE_STCNT               	VARCHAR2(32)     NOT NULL,
	BUFFER_NOWAIT_PCT_MIN                   NUMBER(20,4)      NOT NULL,
	BUFFER_NOWAIT_PCT_MAX                   NUMBER(20,4)      NOT NULL,
        BUFFER_NOWAIT_PCT_STCNT               	VARCHAR2(32)     NOT NULL,
	SOFT_PARSE_RATIO_MIN                    NUMBER(20,4)      NOT NULL,
	SOFT_PARSE_RATIO_MAX                    NUMBER(20,4)      NOT NULL,
        SOFT_PARSE_RATIO_STCNT               	VARCHAR2(32)     NOT NULL,
	EXECUTE_PARSE_RATIO_MIN                 NUMBER(20,4)      NOT NULL,
	EXECUTE_PARSE_RATIO_MAX                 NUMBER(20,4)      NOT NULL,
        EXECUTE_PARSE_RATIO_STCNT		VARCHAR2(32)     NOT NULL,
	CPU_PARSE_RATIO_MIN                      NUMBER(20,4)      NOT NULL,
	CPU_PARSE_RATIO_MAX                      NUMBER(20,4)      NOT NULL,
        CPU_PARSE_RATIO_STCNT               	VARCHAR2(32)     NOT NULL,
	NON_PARSE_CPU_RATIO_MIN                 NUMBER(20,4)      NOT NULL,
	NON_PARSE_CPU_RATIO_MAX                 NUMBER(20,4)      NOT NULL,
        NON_PARSE_CPU_RATIO_STCNT               VARCHAR2(32)     NOT NULL,
	HARD_PARSE_RATIO_MIN                    NUMBER(20,4)      NOT NULL,
	HARD_PARSE_RATIO_MAX                    NUMBER(20,4)      NOT NULL,
	HARD_PARSE_RATIO_STCNT               	VARCHAR2(32)     NOT NULL,
	TARGET_SIZE_PCT_MIN                     NUMBER(20,4)      NOT NULL,
	TARGET_SIZE_PCT_MAX                     NUMBER(20,4)      NOT NULL,
	TARGET_SIZE_PCT_STCNT               	VARCHAR2(32)     NOT NULL
);

alter table ORASGATEST_TREND add constraint PK_ORA_SGA_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORASGATEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ORASGATEST_THRESH
(
        TRGT_HOST			varchar2(32),
        PORT_NO				varchar2(32),
        SITE_NAME			varchar2(64),
        INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
        MSMT_TIME_END			date,
        PCT_LIBCACHE_RATIO_MIN		VARCHAR2(256)	     NOT NULL,
	PCT_LIBCACHE_RATIO_MAX		VARCHAR2(256)	     NOT NULL,
        PCT_DICTCACHE_RATIO_MIN		VARCHAR2(256)	     NOT NULL,
	PCT_DICTCACHE_RATIO_MAX		VARCHAR2(256)	     NOT NULL,
        PCT_DBBUFFCACHE_RATIO_MIN	VARCHAR2(256)	     NOT NULL,
	PCT_DBBUFFCACHE_RATIO_MAX	VARCHAR2(256)	     NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MIN	VARCHAR2(256)	     NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MAX	VARCHAR2(256)	     NOT NULL,
        PCT_SORTS_DISK_MIN		VARCHAR2(256)	     NOT NULL,
	PCT_SORTS_DISK_MAX		VARCHAR2(256)	     NOT NULL,
	SGA_CURR_USAGE_MIN		VARCHAR2(256)	     NOT NULL,
	SGA_CURR_USAGE_MAX		VARCHAR2(256)	     NOT NULL,
	BUFFER_NOWAIT_PCT_MIN		VARCHAR2(256)	     NOT NULL,
	BUFFER_NOWAIT_PCT_MAX		VARCHAR2(256)	     NOT NULL,
	SOFT_PARSE_RATIO_MIN		VARCHAR2(256)	     NOT NULL,
	SOFT_PARSE_RATIO_MAX		VARCHAR2(256)	     NOT NULL,
	EXECUTE_PARSE_RATIO_MIN		VARCHAR2(256)	     NOT NULL,
	EXECUTE_PARSE_RATIO_MAX		VARCHAR2(256)	     NOT NULL,
	CPU_PARSE_RATIO_MIN		VARCHAR2(256)	     NOT NULL,
	CPU_PARSE_RATIO_MAX		VARCHAR2(256)	     NOT NULL,
	NON_PARSE_CPU_RATIO_MIN		VARCHAR2(256)	     NOT NULL,
	NON_PARSE_CPU_RATIO_MAX		VARCHAR2(256)	     NOT NULL,
	HARD_PARSE_RATIO_MIN		VARCHAR2(256)	     NOT NULL,
	HARD_PARSE_RATIO_MAX		VARCHAR2(256)	     NOT NULL,
	TARGET_SIZE_PCT_MIN		VARCHAR2(256)	     NOT NULL,
	TARGET_SIZE_PCT_MAX		VARCHAR2(256)	     NOT NULL
);

alter table ORASGATEST_THRESH add constraint PK_ORA_SGA_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORASGATEST_THRESH ON ORASGATEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);   
DROP TABLE ORATABLESPACETEST CASCADE CONSTRAINTS;

CREATE TABLE ORATABLESPACETEST
(
        TRGT_HOST            varchar2(32),
        PORT_NO              varchar2(32),
        SITE_NAME            varchar2(64),
        INFO                 varchar2(128),
	MSMT_HOST 	     varchar2(32), 
	MSMT_TIME            date,
	PCT_SPACE_USED       NUMBER(20,4)     NOT NULL,
        PCT_SPACE_USED_ST    VARCHAR2(32)     NOT NULL,
        PHY_RDS_RATE	     NUMBER(20,4)    NOT NULL,
        PHY_RDS_RATE_ST      VARCHAR2(32)    NOT NULL, 
        PHY_WRTS_RATE        NUMBER(20,4)    NOT NULL,
        PHY_WRTS_RATE_ST     VARCHAR2(32)    NOT NULL       
);

alter table ORATABLESPACETEST add constraint PK_ORA_TABLESPACE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ORATABLESPACETEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ORATABLESPACETEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
	PCT_SPACE_USED_MIN     		NUMBER(20,4)     NOT NULL,
	PCT_SPACE_USED_MAX     		NUMBER(20,4)     NOT NULL,
        PCT_SPACE_USED_STCNT    	VARCHAR2(32)     NOT NULL,
        PHY_RDS_RATE_MIN	     	NUMBER(20,4)    NOT NULL,
        PHY_RDS_RATE_MAX	     	NUMBER(20,4)    NOT NULL,
        PHY_RDS_RATE_STCNT      	VARCHAR2(32)    NOT NULL, 
        PHY_WRTS_RATE_MIN        	NUMBER(20,4)    NOT NULL,
        PHY_WRTS_RATE_MAX        	NUMBER(20,4)    NOT NULL,
        PHY_WRTS_RATE_STCNT     	VARCHAR2(32)    NOT NULL       
);


alter table ORATABLESPACETEST_TREND add constraint PK_ORA_TABLESPACE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORATABLESPACETEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ORATABLESPACETEST_THRESH
(
        TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,
        PCT_SPACE_USED_MIN	VARCHAR2(256)	   NOT NULL,
        PCT_SPACE_USED_MAX	VARCHAR2(256)	   NOT NULL,
        PHY_RDS_RATE_MIN	VARCHAR2(256)	  NOT NULL,
        PHY_RDS_RATE_MAX	VARCHAR2(256)	  NOT NULL,
        PHY_WRTS_RATE_MIN	VARCHAR2(256)	  NOT NULL,
        PHY_WRTS_RATE_MAX	VARCHAR2(256)	  NOT NULL
);

alter table ORATABLESPACETEST_THRESH add constraint PK_ORA_TABLESPACE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORATABLESPACETEST_THRESH ON ORATABLESPACETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 
DROP TABLE PROCESSTEST CASCADE CONSTRAINTS;

CREATE TABLE PROCESSTEST
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	NUM_PROC	Number(20,4) 	NOT NULL,
	NUM_PROC_ST	varchar2(32)     	NOT NULL,
	CPU_UTIL 	number(20,4) 	NOT NULL,
	CPU_UTIL_ST 	varchar2(32)     	NOT NULL,
	MEM_UTIL 	number(20,4) 	NOT NULL,
	MEM_UTIL_ST 	varchar2(32)     	NOT NULL
);
CREATE INDEX IDX1_PROCESSTEST ON PROCESSTEST (TRGT_HOST, MSMT_TIME);
ALTER TABLE PROCESSTEST ADD constraint PK_PROCESS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE PROCESSTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE PROCESSTEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO         	varchar2(32),
        SITE_NAME       	varchar2(64),
        INFO            	varchar2(128), 
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD 			varchar2(32),
	NUM_PROC_MIN		Number(20,4) 	NOT NULL,
	NUM_PROC_MAX		Number(20,4) 	NOT NULL,
	NUM_PROC_STCNT		varchar2(32)   	NOT NULL,
	CPU_UTIL_MIN 		number(20,4) 	NOT NULL,
	CPU_UTIL_MAX 		number(20,4) 	NOT NULL,
	CPU_UTIL_STCNT 		varchar2(32)   	NOT NULL,
	MEM_UTIL_MIN 		number(20,4) 	NOT NULL,
	MEM_UTIL_MAX 		number(20,4) 	NOT NULL,
	MEM_UTIL_STCNT 		varchar2(32)   	NOT NULL
);

ALTER TABLE PROCESSTEST_TREND ADD constraint PK_PROCESS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE PROCESSTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE PROCESSTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	NUM_PROC_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_PROC_MAX	VARCHAR2(256)	 	NOT NULL,
	CPU_UTIL_MIN	VARCHAR2(256)	 	NOT NULL,
	CPU_UTIL_MAX	VARCHAR2(256)	 	NOT NULL,
	MEM_UTIL_MIN	VARCHAR2(256)	 	NOT NULL,
	MEM_UTIL_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE PROCESSTEST_THRESH ADD constraint PK_PROCESS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_PROCESSTEST_THRESH ON PROCESSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);    
DROP TABLE ReplicationTest CASCADE CONSTRAINTS;

CREATE TABLE ReplicationTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	in_Obj_Appld_rate		NUMBER(20,4) NOT NULL,
	in_Obj_Appld_rate_ST		varchar2(32) NOT NULL,
	in_Prop_Appld_rate		number(20,4) not null,
	in_Prop_Appld_rate_ST		varchar2(32) not null,
	in_Obj_Filtrd_rate		number(20,4) not null,
	in_Obj_Filtrd_rate_ST		varchar2(32) not null,
	in_Prop_Filtrd_rate		number(20,4) not null,
	in_Prop_Filtrd_rate_ST		varchar2(32) not null,
	out_Obj_Filtrd_rate		number(20,4) not null,
	out_Obj_Filtrd_rate_ST		varchar2(32) not null,
	pending_Rep_Sync		Number(20,4) not null,
	pending_Rep_Sync_ST		varchar2(32) not null
);

ALTER TABLE ReplicationTest ADD constraint PK_Replication
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   ReplicationTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE ReplicationTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	in_Obj_Appld_rate_MIN		NUMBER(20,4) NOT NULL,
	in_Obj_Appld_rate_MAX		NUMBER(20,4) NOT NULL,
	in_Obj_Appld_rate_STCNT		varchar2(32) NOT NULL,
	in_Prop_Appld_rate_MIN		number(20,4) not null,
	in_Prop_Appld_rate_MAX		number(20,4) not null,
	in_Prop_Appld_rate_STCNT	varchar2(32) not null,
	in_Obj_Filtrd_rate_MIN		number(20,4) not null,
	in_Obj_Filtrd_rate_MAX		number(20,4) not null,
	in_Obj_Filtrd_rate_STCNT	varchar2(32) not null,
	in_Prop_Filtrd_rate_MIN		number(20,4) not null,
	in_Prop_Filtrd_rate_MAX		number(20,4) not null,
	in_Prop_Filtrd_rate_STCNT	varchar2(32) not null,
	out_Obj_Filtrd_rate_MIN		number(20,4) not null,
	out_Obj_Filtrd_rate_MAX		number(20,4) not null,
	out_Obj_Filtrd_rate_STCNT	varchar2(32) not null,
	pending_Rep_Sync_MIN		Number(20,4) not null,
	pending_Rep_Sync_MAX		Number(20,4) not null,
	pending_Rep_Sync_STCNT		varchar2(32) not null
);

ALTER TABLE ReplicationTest_TREND ADD constraint PK_ReplicationTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   ReplicationTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ReplicationTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	IN_OBJ_APPLD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	IN_OBJ_APPLD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	IN_PROP_APPLD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	IN_PROP_APPLD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	IN_OBJ_FILTRD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	IN_OBJ_FILTRD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	IN_PROP_FILTRD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	IN_PROP_FILTRD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	OUT_OBJ_FILTRD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	OUT_OBJ_FILTRD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	PENDING_REP_SYNC_MIN	VARCHAR2(256)	 NOT NULL,
	PENDING_REP_SYNC_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE ReplicationTest_THRESH ADD constraint PK_ReplicationTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_ReplicationTest_THRESH ON ReplicationTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE REPORT CASCADE CONSTRAINTS;

CREATE TABLE REPORT 
(
	SITE_NAME      	    varchar2(64),
	COMP_NAME 	    varchar2(64),
	COMP_TYPE      	    varchar2(32),
	INFO                varchar2(128),
	LAYER_NAME	    varchar2(64),	
	TEST_NAME	    varchar2(64),	
	MEASURE             varchar2(64), 
	MSMT_HOST           varchar2(32),
	STATE               varchar2(32)
);    

alter table REPORT add constraint PK_REPORT
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,LAYER_NAME,TEST_NAME,MEASURE,MSMT_HOST);
create index idx_report on report(site_name);
CREATE INDEX IDX1_REPORT ON REPORT (STATE);
CREATE INDEX IDX2_REPORT ON REPORT (COMP_TYPE, TEST_NAME );
CREATE INDEX IDX3_REPORT ON REPORT (SITE_NAME, LAYER_NAME);
CREATE INDEX IDX4_REPORT ON REPORT(COMP_TYPE,COMP_NAME,TEST_NAME,MEASURE);	
CREATE INDEX IDX5_REPORT ON REPORT (SITE_NAME, LAYER_NAME,TEST_NAME);


DROP TABLE EVENT_HIST CASCADE CONSTRAINTS;

CREATE TABLE EVENT_HIST
(
	SITE_NAME	varchar2(64),	
	COMP_NAME	varchar2(64),
	COMP_TYPE	varchar2(32),
	INFO		varchar2(128),
	TEST_NAME	varchar2(64),
	MEASURE		varchar2(64),
	MSMT_TIME_START date,
	MSMT_TIME_END 	date,
	MSMT_HOST	varchar2(32),
	EVENT_ID	number(16),
	EVENT_SVRTY varchar2(32) 
);

alter table EVENT_HIST add constraint PK_EVENT_HIST
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_NAME,MEASURE,MSMT_TIME_START,MSMT_HOST,EVENT_SVRTY);
create unique index IDX_EVENT_HIST  on EVENT_HIST(EVENT_ID,MSMT_TIME_START);

DROP TABLE UD_EVENT_HIST CASCADE CONSTRAINTS;

CREATE TABLE UD_EVENT_HIST
(
	SITE_NAME	varchar2(64),	
	COMP_NAME	varchar2(64),
	COMP_TYPE	varchar2(32),
	INFO		varchar2(128),
	TEST_NAME	varchar2(64),
	MEASURE		varchar2(64),
	MSMT_TIME_START date,
	MSMT_TIME_END 	date,
	MSMT_HOST	varchar2(32),
	EVENT_ID	number(16),
	EVENT_SVRTY varchar2(32) 
);

alter table UD_EVENT_HIST add constraint PK_UD_EVENT_HIST
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_NAME,MEASURE,MSMT_TIME_START,MSMT_HOST,EVENT_SVRTY);
create unique index IDX_UD_EVENT_HIST  on UD_EVENT_HIST(EVENT_ID,MSMT_TIME_START);


DROP TABLE UNKNOWN_HISTORY CASCADE CONSTRAINTS;

CREATE TABLE UNKNOWN_HISTORY
(
	SITE_NAME	varchar2(64),	
	COMP_NAME	varchar2(64),
	COMP_TYPE	varchar2(32),
	INFO		varchar2(128),
	TEST_NAME	varchar2(64),
	MEASURE		varchar2(64),
	MSMT_TIME_START date,
	MSMT_TIME_END 	date,
	MSMT_HOST	varchar2(32),
	EVENT_ID	number(16)
);

alter table UNKNOWN_HISTORY add constraint PK_UNKNOWN_HISTORY
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_NAME,MEASURE,MSMT_TIME_START,MSMT_HOST);
create unique index IDX_UNKNOWN_HISTORY on UNKNOWN_HISTORY(EVENT_ID);

DROP TABLE EG_UD_MEASURE CASCADE CONSTRAINTS;
CREATE TABLE EG_UD_MEASURE
(
	SITE_NAME  VARCHAR2(64) NOT NULL,
	TRGT_HOST    VARCHAR2(32) NOT NULL,
	PORT_NO      VARCHAR2(32)NOT NULL,
	TEST_NAME    VARCHAR2(64) NOT NULL,
	MEASURE      VARCHAR2(64) NOT NULL,
	INFO         VARCHAR2(128) NOT NULL,
	STATE        VARCHAR2(32) NOT NULL,
	INDX_MEAS    NUMBER(16) NOT NULL,
	MSMT_HOST    VARCHAR2(32) NOT NULL,
	MSMT_TIME    DATE NOT NULL,
	DETL_MEAS    VARCHAR2(2000)
);
ALTER TABLE EG_UD_MEASURE ADD constraint PK_EG_UD_MEASURE
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,INDX_MEAS,MSMT_HOST,MSMT_TIME);

CREATE INDEX IDX_EG_UD_MEASURE ON EG_UD_MEASURE
(
	MSMT_TIME
);


DROP TABLE REGISTERED_DESKTOPS CASCADE CONSTRAINTS;
CREATE TABLE REGISTERED_DESKTOPS(HOST_NAME VARCHAR2(256) NOT NULL, REGISTERED_TIME DATE);
ALTER TABLE REGISTERED_DESKTOPS ADD CONSTRAINT PK_REGISTERED_DESKTOPS PRIMARY KEY (HOST_NAME);
CREATE INDEX IDX_REGISTERED_DESKTOPS ON REGISTERED_DESKTOPS(REGISTERED_TIME);

DROP TABLE ALLOWED_DESKTOPS CASCADE CONSTRAINTS;
CREATE TABLE ALLOWED_DESKTOPS(HOST_NAME VARCHAR2(256) NOT NULL, ALLOWED_TIME DATE);
ALTER TABLE ALLOWED_DESKTOPS ADD CONSTRAINT PK_ALLOWED_DESKTOPS PRIMARY KEY (HOST_NAME);
CREATE INDEX IDX_ALLOWED_DESKTOPS ON ALLOWED_DESKTOPS(ALLOWED_TIME);

DROP TABLE DISALLOWED_DESKTOPS CASCADE CONSTRAINTS;
CREATE TABLE DISALLOWED_DESKTOPS(HOST_NAME VARCHAR2(256) NOT NULL, DISALLOWED_TIME DATE);
ALTER TABLE DISALLOWED_DESKTOPS ADD CONSTRAINT PK_DISALLOWED_DESKTOPS PRIMARY KEY (HOST_NAME);
CREATE INDEX IDX_DISALLOWED_DESKTOPS ON DISALLOWED_DESKTOPS(DISALLOWED_TIME);


DROP TABLE EG_UD_UD_MEASURE CASCADE CONSTRAINTS;
CREATE TABLE EG_UD_UD_MEASURE
(
	SITE_NAME  VARCHAR2(64) NOT NULL,
	TRGT_HOST    VARCHAR2(32) NOT NULL,
	PORT_NO      VARCHAR2(32)NOT NULL,
	TEST_NAME    VARCHAR2(64) NOT NULL,
	MEASURE      VARCHAR2(64) NOT NULL,
	INFO         VARCHAR2(128) NOT NULL,
	STATE        VARCHAR2(32) NOT NULL,
	INDX_MEAS    NUMBER(16) NOT NULL,
	MSMT_HOST    VARCHAR2(32) NOT NULL,
	MSMT_TIME    DATE NOT NULL,
	DETL_MEAS    VARCHAR2(2000)
);
ALTER TABLE EG_UD_UD_MEASURE ADD constraint PK_EG_UD_UD_MEASURE
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,INDX_MEAS,MSMT_HOST,MSMT_TIME);

CREATE INDEX IDX_EG_UD_UD_MEASURE ON EG_UD_UD_MEASURE
(
	MSMT_TIME
);



DROP TABLE SILVERSTREAMTEST  CASCADE CONSTRAINTS;
CREATE TABLE SILVERSTREAMTEST 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME 		date,
	SERVER_USAGE_METRIC	number(20,4) 	NOT NULL,
	SERVER_USAGE_METRIC_ST	varchar2(32)    NOT NULL,
	USED_THREAD_PCT 	number(20,4) 	NOT NULL,
	USED_THREAD_PCT_ST 	varchar2(32)    NOT NULL,
	IDLE_THREAD_PCT 	number(20,4) 	NOT NULL,
	IDLE_THREAD_PCT_ST 	varchar2(32)    NOT NULL,
	REQUEST_RATE            number(20,4)    NOT NULL,
	REQUEST_RATE_ST         varchar2(32)    NOT NULL,
	MEAN_RESPONSE_TIME      number(20,4)      NOT NULL,
	MEAN_RESPONSE_TIME_ST   varchar2(32)    NOT NULL,
	MAX_RESPONSE_TIME       number(20,4)      NOT NULL,
        MAX_RESPONSE_TIME_ST    varchar2(32)    NOT NULL,
	DATA_XMIT_RATE    	number(20,4)    NOT NULL,
	DATA_XMIT_RATE_ST 	varchar2(32)    NOT NULL,
	MEMORY_UTIL         	number(20,4)     NOT NULL,
	MEMORY_UTIL_ST      	varchar2(32)    NOT NULL,
	TOTAL_SESS_COUNT        number(20,4)      NOT NULL,
	TOTAL_SESS_COUNT_ST     varchar2(32)    NOT NULL,
	IDLE_SESS_COUNT         number(20,4)      NOT NULL,
	IDLE_SESS_COUNT_ST      varchar2(32)    NOT NULL
);

ALTER TABLE SILVERSTREAMTEST ADD CONSTRAINT PK_SILVER_STREAM PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE SILVERSTREAMTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE SILVERSTREAMTEST_TREND 
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                 	varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD 				varchar2(32), 
	SERVER_USAGE_METRIC_MIN		number(20,4)     NOT NULL,
	SERVER_USAGE_METRIC_MAX		number(20,4)     NOT NULL,
 	SERVER_USAGE_METRIC_STCNT	varchar2(32)    NOT NULL,
 	USED_THREAD_PCT_MIN		number(20,4)      NOT NULL,
 	USED_THREAD_PCT_MAX		number(20,4)      NOT NULL,
 	USED_THREAD_PCT_STCNT    	varchar2(32)    NOT NULL,
        IDLE_THREAD_PCT_MIN		number(20,4)      NOT NULL,
 	IDLE_THREAD_PCT_MAX		number(20,4)      NOT NULL,
 	IDLE_THREAD_PCT_STCNT    	varchar2(32)    NOT NULL,
 	REQUEST_RATE_MIN		number(20,4)    NOT NULL,
 	REQUEST_RATE_MAX		number(20,4)    NOT NULL,
 	REQUEST_RATE_STCNT		varchar2(32)    NOT NULL,
 	MEAN_RESPONSE_TIME_MIN		number(20,4)      NOT NULL,
 	MEAN_RESPONSE_TIME_MAX		number(20,4)      NOT NULL,
 	MEAN_RESPONSE_TIME_STCNT	varchar2(32)    NOT NULL,
 	MAX_RESPONSE_TIME_MIN		number(20,4)      NOT NULL,
 	MAX_RESPONSE_TIME_MAX		number(20,4)      NOT NULL,
 	MAX_RESPONSE_TIME_STCNT		varchar2(32)    NOT NULL,
 	DATA_XMIT_RATE_MIN    		number(20,4)    NOT NULL,
 	DATA_XMIT_RATE_MAX    		number(20,4)    NOT NULL,
        DATA_XMIT_RATE_STCNT 		varchar2(32)    NOT NULL,
        MEMORY_UTIL_MIN         	number(20,4)     NOT NULL,
        MEMORY_UTIL_MAX         	number(20,4)     NOT NULL,
        MEMORY_UTIL_STCNT      		varchar2(32)    NOT NULL,
 	TOTAL_SESS_COUNT_MIN		number(20,4)      NOT NULL,
 	TOTAL_SESS_COUNT_MAX		number(20,4)      NOT NULL,
	TOTAL_SESS_COUNT_STCNT		varchar2(32)    NOT NULL,
        IDLE_SESS_COUNT_MIN            	number(20,4)      NOT NULL,
        IDLE_SESS_COUNT_MAX            	number(20,4)      NOT NULL,
	IDLE_SESS_COUNT_STCNT		varchar2(32)    NOT NULL
);

ALTER TABLE SILVERSTREAMTEST_TREND ADD CONSTRAINT PK_SILVER_STREAM_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE SILVERSTREAMTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SILVERSTREAMTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                 	varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START 		date,
        MSMT_TIME_END           	date,
	SERVER_USAGE_METRIC_MIN	VARCHAR2(256)	     NOT NULL,
	SERVER_USAGE_METRIC_MAX	VARCHAR2(256)	     NOT NULL,
 	USED_THREAD_PCT_MIN	VARCHAR2(256)	      NOT NULL,
 	USED_THREAD_PCT_MAX	VARCHAR2(256)	      NOT NULL,
 	IDLE_THREAD_PCT_MIN	VARCHAR2(256)	      NOT NULL,
 	IDLE_THREAD_PCT_MAX	VARCHAR2(256)	      NOT NULL,
 	REQUEST_RATE_MIN	VARCHAR2(256)	    NOT NULL,
 	REQUEST_RATE_MAX	VARCHAR2(256)	    NOT NULL,
 	MEAN_RESPONSE_TIME_MIN	VARCHAR2(256)	      NOT NULL,
 	MEAN_RESPONSE_TIME_MAX	VARCHAR2(256)	      NOT NULL,
 	MAX_RESPONSE_TIME_MIN	VARCHAR2(256)	      NOT NULL,
 	MAX_RESPONSE_TIME_MAX	VARCHAR2(256)	      NOT NULL,
 	DATA_XMIT_RATE_MIN	VARCHAR2(256)	    NOT NULL,
 	DATA_XMIT_RATE_MAX	VARCHAR2(256)	    NOT NULL,
        MEMORY_UTIL_MIN	VARCHAR2(256)	     NOT NULL,
        MEMORY_UTIL_MAX	VARCHAR2(256)	     NOT NULL,
 	TOTAL_SESS_COUNT_MIN	VARCHAR2(256)	      NOT NULL,
 	TOTAL_SESS_COUNT_MAX	VARCHAR2(256)	      NOT NULL,
        IDLE_SESS_COUNT_MIN	VARCHAR2(256)	      NOT NULL,
        IDLE_SESS_COUNT_MAX	VARCHAR2(256)	      NOT NULL
);

ALTER TABLE SILVERSTREAMTEST_THRESH ADD CONSTRAINT PK_SILVER_STREAM_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_SILVERSTREAMTEST_THRESH ON SILVERSTREAMTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybDataCacheTest CASCADE CONSTRAINTS;
CREATE TABLE SybDataCacheTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
UTILIZATION Number(20,4) NOT NULL,
UTILIZATION_ST varchar2(32) NOT NULL,
CACHE_HIT_RATIO Number(20,4) NOT NULL,
CACHE_HIT_RATIO_ST varchar2(32) NOT NULL,
SPINLOCK_CONTENTION Number(20,4) NOT NULL,
SPINLOCK_CONTENTION_ST varchar2(32) NOT NULL,
BUFFERS_GRABBED Number(20,4) NOT NULL,
BUFFERS_GRABBED_ST varchar2(32) NOT NULL,
BUFFERS_GRABBED_DIRTY Number(20,4) NOT NULL,
BUFFERS_GRABBED_DIRTY_ST varchar2(32) NOT NULL,
PCT_LARGE_IO_DENIED Number(20,4) NOT NULL,
PCT_LARGE_IO_DENIED_ST varchar2(32) NOT NULL,
LARGE_IO_EFFECTIVENESS Number(20,4) NOT NULL,
LARGE_IO_EFFECTIVENESS_ST varchar2(32) NOT NULL);

ALTER TABLE SybDataCacheTest ADD constraint PK_SybDataCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybDataCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybDataCacheTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
UTILIZATION_MIN Number(20,4) NOT NULL,
UTILIZATION_MAX Number(20,4) NOT NULL,
UTILIZATION_STCNT varchar2(32) NOT NULL,
CACHE_HIT_RATIO_MIN Number(20,4) NOT NULL,
CACHE_HIT_RATIO_MAX Number(20,4) NOT NULL,
CACHE_HIT_RATIO_STCNT varchar2(32) NOT NULL,
SPINLOCK_CONTENTION_MIN Number(20,4) NOT NULL,
SPINLOCK_CONTENTION_MAX Number(20,4) NOT NULL,
SPINLOCK_CONTENTION_STCNT varchar2(32) NOT NULL,
BUFFERS_GRABBED_MIN Number(20,4) NOT NULL,
BUFFERS_GRABBED_MAX Number(20,4) NOT NULL,
BUFFERS_GRABBED_STCNT varchar2(32) NOT NULL,
BUFFERS_GRABBED_DIRTY_MIN Number(20,4) NOT NULL,
BUFFERS_GRABBED_DIRTY_MAX Number(20,4) NOT NULL,
BUFFERS_GRABBED_DIRTY_STCNT varchar2(32) NOT NULL,
PCT_LARGE_IO_DENIED_MIN Number(20,4) NOT NULL,
PCT_LARGE_IO_DENIED_MAX Number(20,4) NOT NULL,
PCT_LARGE_IO_DENIED_STCNT varchar2(32) NOT NULL,
LARGE_IO_EFFECTIVENESS_MIN Number(20,4) NOT NULL,
LARGE_IO_EFFECTIVENESS_MAX Number(20,4) NOT NULL,
LARGE_IO_EFFECTIVENESS_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybDataCacheTest_TREND ADD constraint PK_SybDataCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybDataCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybDataCacheTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
UTILIZATION_MIN VARCHAR2(256) NOT NULL,
UTILIZATION_MAX VARCHAR2(256) NOT NULL,
CACHE_HIT_RATIO_MIN VARCHAR2(256) NOT NULL,
CACHE_HIT_RATIO_MAX VARCHAR2(256) NOT NULL,
SPINLOCK_CONTENTION_MIN VARCHAR2(256) NOT NULL,
SPINLOCK_CONTENTION_MAX VARCHAR2(256) NOT NULL,
BUFFERS_GRABBED_MIN VARCHAR2(256) NOT NULL,
BUFFERS_GRABBED_MAX VARCHAR2(256) NOT NULL,
BUFFERS_GRABBED_DIRTY_MIN VARCHAR2(256) NOT NULL,
BUFFERS_GRABBED_DIRTY_MAX VARCHAR2(256) NOT NULL,
PCT_LARGE_IO_DENIED_MIN VARCHAR2(256) NOT NULL,
PCT_LARGE_IO_DENIED_MAX VARCHAR2(256) NOT NULL,
LARGE_IO_EFFECTIVENESS_MIN VARCHAR2(256) NOT NULL,
LARGE_IO_EFFECTIVENESS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybDataCacheTest_THRESH ADD constraint PK_SybDataCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybDataCacheTest_THRESH ON SybDataCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE SybDeviceTest CASCADE CONSTRAINTS;
CREATE TABLE SybDeviceTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
IO_REQUESTS Number(20,4) NOT NULL,
IO_REQUESTS_ST varchar2(32) NOT NULL,
PHY_READ_RATE Number(20,4) NOT NULL,
PHY_READ_RATE_ST varchar2(32) NOT NULL,
PHY_WRITE_RATE Number(20,4) NOT NULL,
PHY_WRITE_RATE_ST varchar2(32) NOT NULL,
IO_ERRORS Number(20,4) NOT NULL,
IO_ERRORS_ST varchar2(32) NOT NULL,
IO_WAITS Number(20,4) NOT NULL,
IO_WAITS_ST varchar2(32) NOT NULL);

ALTER TABLE SybDeviceTest ADD constraint PK_SybDeviceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybDeviceTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybDeviceTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
IO_REQUESTS_MIN Number(20,4) NOT NULL,
IO_REQUESTS_MAX Number(20,4) NOT NULL,
IO_REQUESTS_STCNT varchar2(32) NOT NULL,
PHY_READ_RATE_MIN Number(20,4) NOT NULL,
PHY_READ_RATE_MAX Number(20,4) NOT NULL,
PHY_READ_RATE_STCNT varchar2(32) NOT NULL,
PHY_WRITE_RATE_MIN Number(20,4) NOT NULL,
PHY_WRITE_RATE_MAX Number(20,4) NOT NULL,
PHY_WRITE_RATE_STCNT varchar2(32) NOT NULL,
IO_ERRORS_MIN Number(20,4) NOT NULL,
IO_ERRORS_MAX Number(20,4) NOT NULL,
IO_ERRORS_STCNT varchar2(32) NOT NULL,
IO_WAITS_MIN Number(20,4) NOT NULL,
IO_WAITS_MAX Number(20,4) NOT NULL,
IO_WAITS_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybDeviceTest_TREND ADD constraint PK_SybDeviceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybDeviceTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybDeviceTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
IO_REQUESTS_MIN VARCHAR2(256) NOT NULL,
IO_REQUESTS_MAX VARCHAR2(256) NOT NULL,
PHY_READ_RATE_MIN VARCHAR2(256) NOT NULL,
PHY_READ_RATE_MAX VARCHAR2(256) NOT NULL,
PHY_WRITE_RATE_MIN VARCHAR2(256) NOT NULL,
PHY_WRITE_RATE_MAX VARCHAR2(256) NOT NULL,
IO_ERRORS_MIN VARCHAR2(256) NOT NULL,
IO_ERRORS_MAX VARCHAR2(256) NOT NULL,
IO_WAITS_MIN VARCHAR2(256) NOT NULL,
IO_WAITS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybDeviceTest_THRESH ADD constraint PK_SybDeviceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybDeviceTest_THRESH ON SybDeviceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybLockTest CASCADE CONSTRAINTS;
CREATE TABLE SybLockTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
LOCK_REQUESTS Number(20,4) NOT NULL,
LOCK_REQUESTS_ST varchar2(32) NOT NULL,
LOCK_WAITS Number(20,4) NOT NULL,
LOCK_WAITS_ST varchar2(32) NOT NULL,
AVG_LOCK_WAIT_TIME Number(20,4) NOT NULL,
AVG_LOCK_WAIT_TIME_ST varchar2(32) NOT NULL,
LOCK_TIMEOUTS Number(20,4) NOT NULL,
LOCK_TIMEOUTS_ST varchar2(32) NOT NULL,
DEAD_LOCKS Number(20,4) NOT NULL,
DEAD_LOCKS_ST varchar2(32) NOT NULL);

ALTER TABLE SybLockTest ADD constraint PK_SybLockTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybLockTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybLockTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
LOCK_REQUESTS_MIN Number(20,4) NOT NULL,
LOCK_REQUESTS_MAX Number(20,4) NOT NULL,
LOCK_REQUESTS_STCNT varchar2(32) NOT NULL,
LOCK_WAITS_MIN Number(20,4) NOT NULL,
LOCK_WAITS_MAX Number(20,4) NOT NULL,
LOCK_WAITS_STCNT varchar2(32) NOT NULL,
AVG_LOCK_WAIT_TIME_MIN Number(20,4) NOT NULL,
AVG_LOCK_WAIT_TIME_MAX Number(20,4) NOT NULL,
AVG_LOCK_WAIT_TIME_STCNT varchar2(32) NOT NULL,
LOCK_TIMEOUTS_MIN Number(20,4) NOT NULL,
LOCK_TIMEOUTS_MAX Number(20,4) NOT NULL,
LOCK_TIMEOUTS_STCNT varchar2(32) NOT NULL,
DEAD_LOCKS_MIN Number(20,4) NOT NULL,
DEAD_LOCKS_MAX Number(20,4) NOT NULL,
DEAD_LOCKS_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybLockTest_TREND ADD constraint PK_SybLockTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybLockTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybLockTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
LOCK_REQUESTS_MIN VARCHAR2(256) NOT NULL,
LOCK_REQUESTS_MAX VARCHAR2(256) NOT NULL,
LOCK_WAITS_MIN VARCHAR2(256) NOT NULL,
LOCK_WAITS_MAX VARCHAR2(256) NOT NULL,
AVG_LOCK_WAIT_TIME_MIN VARCHAR2(256) NOT NULL,
AVG_LOCK_WAIT_TIME_MAX VARCHAR2(256) NOT NULL,
LOCK_TIMEOUTS_MIN VARCHAR2(256) NOT NULL,
LOCK_TIMEOUTS_MAX VARCHAR2(256) NOT NULL,
DEAD_LOCKS_MIN VARCHAR2(256) NOT NULL,
DEAD_LOCKS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybLockTest_THRESH ADD constraint PK_SybLockTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybLockTest_THRESH ON SybLockTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE SybLockStatsTest CASCADE CONSTRAINTS;
CREATE TABLE SybLockStatsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NUM_OF_LOCKS Number(20,4) NOT NULL,
NUM_OF_LOCKS_ST varchar2(32) NOT NULL,
AVG_BLOCK_TIME Number(20,4) NOT NULL,
AVG_BLOCK_TIME_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SybLockStatsTest ON SybLockStatsTest(MSMT_TIME);
ALTER TABLE SybLockStatsTest ADD constraint PK_SybLockStatsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybLockStatsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybLockStatsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NUM_OF_LOCKS_MIN Number(20,4) NOT NULL,
NUM_OF_LOCKS_MAX Number(20,4) NOT NULL,
NUM_OF_LOCKS_STCNT varchar2(32) NOT NULL,
AVG_BLOCK_TIME_MIN Number(20,4) NOT NULL,
AVG_BLOCK_TIME_MAX Number(20,4) NOT NULL,
AVG_BLOCK_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybLockStatsTest_TREND ADD constraint PK_SybLockStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybLockStatsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybLockStatsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NUM_OF_LOCKS_MIN VARCHAR2(256) NOT NULL,
NUM_OF_LOCKS_MAX VARCHAR2(256) NOT NULL,
AVG_BLOCK_TIME_MIN VARCHAR2(256) NOT NULL,
AVG_BLOCK_TIME_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybLockStatsTest_THRESH ADD constraint PK_SybLockStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybLockStatsTest_THRESH ON SybLockStatsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);




DROP TABLE SybNetworkTest CASCADE CONSTRAINTS;
CREATE TABLE SybNetworkTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
IO_REQUESTS Number(20,4) NOT NULL,
IO_REQUESTS_ST varchar2(32) NOT NULL,
IO_DELAY Number(20,4) NOT NULL,
IO_DELAY_ST varchar2(32) NOT NULL,
DATA_RECVD_RATE Number(20,4) NOT NULL,
DATA_RECVD_RATE_ST varchar2(32) NOT NULL,
DATA_SENT_RATE Number(20,4) NOT NULL,
DATA_SENT_RATE_ST varchar2(32) NOT NULL,
AVG_PACKET_SIZE Number(20,4) NOT NULL,
AVG_PACKET_SIZE_ST varchar2(32) NOT NULL);

ALTER TABLE SybNetworkTest ADD constraint PK_SybNetworkTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybNetworkTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybNetworkTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
IO_REQUESTS_MIN Number(20,4) NOT NULL,
IO_REQUESTS_MAX Number(20,4) NOT NULL,
IO_REQUESTS_STCNT varchar2(32) NOT NULL,
IO_DELAY_MIN Number(20,4) NOT NULL,
IO_DELAY_MAX Number(20,4) NOT NULL,
IO_DELAY_STCNT varchar2(32) NOT NULL,
DATA_RECVD_RATE_MIN Number(20,4) NOT NULL,
DATA_RECVD_RATE_MAX Number(20,4) NOT NULL,
DATA_RECVD_RATE_STCNT varchar2(32) NOT NULL,
DATA_SENT_RATE_MIN Number(20,4) NOT NULL,
DATA_SENT_RATE_MAX Number(20,4) NOT NULL,
DATA_SENT_RATE_STCNT varchar2(32) NOT NULL,
AVG_PACKET_SIZE_MIN Number(20,4) NOT NULL,
AVG_PACKET_SIZE_MAX Number(20,4) NOT NULL,
AVG_PACKET_SIZE_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybNetworkTest_TREND ADD constraint PK_SybNetworkTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybNetworkTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybNetworkTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
IO_REQUESTS_MIN VARCHAR2(256) NOT NULL,
IO_REQUESTS_MAX VARCHAR2(256) NOT NULL,
IO_DELAY_MIN VARCHAR2(256) NOT NULL,
IO_DELAY_MAX VARCHAR2(256) NOT NULL,
DATA_RECVD_RATE_MIN VARCHAR2(256) NOT NULL,
DATA_RECVD_RATE_MAX VARCHAR2(256) NOT NULL,
DATA_SENT_RATE_MIN VARCHAR2(256) NOT NULL,
DATA_SENT_RATE_MAX VARCHAR2(256) NOT NULL,
AVG_PACKET_SIZE_MIN VARCHAR2(256) NOT NULL,
AVG_PACKET_SIZE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybNetworkTest_THRESH ADD constraint PK_SybNetworkTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybNetworkTest_THRESH ON SybNetworkTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybProcCacheTest CASCADE CONSTRAINTS;
CREATE TABLE SybProcCacheTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PROCEDURE_REQUESTS Number(20,4) NOT NULL,
PROCEDURE_REQUESTS_ST varchar2(32) NOT NULL,
DISK_READS Number(20,4) NOT NULL,
DISK_READS_ST varchar2(32) NOT NULL,
CACHE_HIT_RATIO Number(20,4) NOT NULL,
CACHE_HIT_RATIO_ST varchar2(32) NOT NULL,
PROCEDURES_CREATED Number(20,4) NOT NULL,
PROCEDURES_CREATED_ST varchar2(32) NOT NULL,
PROCEDURES_AGED_OUT Number(20,4) NOT NULL,
PROCEDURES_AGED_OUT_ST varchar2(32) NOT NULL);

ALTER TABLE SybProcCacheTest ADD constraint PK_SybProcCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybProcCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybProcCacheTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
PROCEDURE_REQUESTS_MIN Number(20,4) NOT NULL,
PROCEDURE_REQUESTS_MAX Number(20,4) NOT NULL,
PROCEDURE_REQUESTS_STCNT varchar2(32) NOT NULL,
DISK_READS_MIN Number(20,4) NOT NULL,
DISK_READS_MAX Number(20,4) NOT NULL,
DISK_READS_STCNT varchar2(32) NOT NULL,
CACHE_HIT_RATIO_MIN Number(20,4) NOT NULL,
CACHE_HIT_RATIO_MAX Number(20,4) NOT NULL,
CACHE_HIT_RATIO_STCNT varchar2(32) NOT NULL,
PROCEDURES_CREATED_MIN Number(20,4) NOT NULL,
PROCEDURES_CREATED_MAX Number(20,4) NOT NULL,
PROCEDURES_CREATED_STCNT varchar2(32) NOT NULL,
PROCEDURES_AGED_OUT_MIN Number(20,4) NOT NULL,
PROCEDURES_AGED_OUT_MAX Number(20,4) NOT NULL,
PROCEDURES_AGED_OUT_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybProcCacheTest_TREND ADD constraint PK_SybProcCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybProcCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybProcCacheTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
PROCEDURE_REQUESTS_MIN VARCHAR2(256) NOT NULL,
PROCEDURE_REQUESTS_MAX VARCHAR2(256) NOT NULL,
DISK_READS_MIN VARCHAR2(256) NOT NULL,
DISK_READS_MAX VARCHAR2(256) NOT NULL,
CACHE_HIT_RATIO_MIN VARCHAR2(256) NOT NULL,
CACHE_HIT_RATIO_MAX VARCHAR2(256) NOT NULL,
PROCEDURES_CREATED_MIN VARCHAR2(256) NOT NULL,
PROCEDURES_CREATED_MAX VARCHAR2(256) NOT NULL,
PROCEDURES_AGED_OUT_MIN VARCHAR2(256) NOT NULL,
PROCEDURES_AGED_OUT_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybProcCacheTest_THRESH ADD constraint PK_SybProcCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybProcCacheTest_THRESH ON SybProcCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybSpaceTest CASCADE CONSTRAINTS;
CREATE TABLE SybSpaceTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_SIZE Number(20,4) NOT NULL,
TOTAL_SIZE_ST varchar2(32) NOT NULL,
PCT_RESERVED Number(20,4) NOT NULL,
PCT_RESERVED_ST varchar2(32) NOT NULL,
RESERVED_SPACE Number(20,4) NOT NULL,
RESERVED_SPACE_ST varchar2(32) NOT NULL,
DATA_SPACE Number(20,4) NOT NULL,
DATA_SPACE_ST varchar2(32) NOT NULL,
INDEX_SPACE Number(20,4) NOT NULL,
INDEX_SPACE_ST varchar2(32) NOT NULL,
UNUSED_SPACE Number(20,4) NOT NULL,
UNUSED_SPACE_ST varchar2(32) NOT NULL);

ALTER TABLE SybSpaceTest ADD constraint PK_SybSpaceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybSpaceTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybSpaceTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_SIZE_MIN Number(20,4) NOT NULL,
TOTAL_SIZE_MAX Number(20,4) NOT NULL,
TOTAL_SIZE_STCNT varchar2(32) NOT NULL,
PCT_RESERVED_MIN Number(20,4) NOT NULL,
PCT_RESERVED_MAX Number(20,4) NOT NULL,
PCT_RESERVED_STCNT varchar2(32) NOT NULL,
RESERVED_SPACE_MIN Number(20,4) NOT NULL,
RESERVED_SPACE_MAX Number(20,4) NOT NULL,
RESERVED_SPACE_STCNT varchar2(32) NOT NULL,
DATA_SPACE_MIN Number(20,4) NOT NULL,
DATA_SPACE_MAX Number(20,4) NOT NULL,
DATA_SPACE_STCNT varchar2(32) NOT NULL,
INDEX_SPACE_MIN Number(20,4) NOT NULL,
INDEX_SPACE_MAX Number(20,4) NOT NULL,
INDEX_SPACE_STCNT varchar2(32) NOT NULL,
UNUSED_SPACE_MIN Number(20,4) NOT NULL,
UNUSED_SPACE_MAX Number(20,4) NOT NULL,
UNUSED_SPACE_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybSpaceTest_TREND ADD constraint PK_SybSpaceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybSpaceTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybSpaceTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_SIZE_MIN VARCHAR2(256) NOT NULL,
TOTAL_SIZE_MAX VARCHAR2(256) NOT NULL,
PCT_RESERVED_MIN VARCHAR2(256) NOT NULL,
PCT_RESERVED_MAX VARCHAR2(256) NOT NULL,
RESERVED_SPACE_MIN VARCHAR2(256) NOT NULL,
RESERVED_SPACE_MAX VARCHAR2(256) NOT NULL,
DATA_SPACE_MIN VARCHAR2(256) NOT NULL,
DATA_SPACE_MAX VARCHAR2(256) NOT NULL,
INDEX_SPACE_MIN VARCHAR2(256) NOT NULL,
INDEX_SPACE_MAX VARCHAR2(256) NOT NULL,
UNUSED_SPACE_MIN VARCHAR2(256) NOT NULL,
UNUSED_SPACE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybSpaceTest_THRESH ADD constraint PK_SybSpaceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybSpaceTest_THRESH ON SybSpaceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybTasksTest CASCADE CONSTRAINTS;
CREATE TABLE SybTasksTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CONNECTION_OPEN_RATE Number(20,4) NOT NULL,
CONNECTION_OPEN_RATE_ST varchar2(32) NOT NULL,
TASK_SWITCH_RATE Number(20,4) NOT NULL,
TASK_SWITCH_RATE_ST varchar2(32) NOT NULL);

ALTER TABLE SybTasksTest ADD constraint PK_SybTasksTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybTasksTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybTasksTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CONNECTION_OPEN_RATE_MIN Number(20,4) NOT NULL,
CONNECTION_OPEN_RATE_MAX Number(20,4) NOT NULL,
CONNECTION_OPEN_RATE_STCNT varchar2(32) NOT NULL,
TASK_SWITCH_RATE_MIN Number(20,4) NOT NULL,
TASK_SWITCH_RATE_MAX Number(20,4) NOT NULL,
TASK_SWITCH_RATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybTasksTest_TREND ADD constraint PK_SybTasksTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybTasksTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybTasksTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CONNECTION_OPEN_RATE_MIN VARCHAR2(256) NOT NULL,
CONNECTION_OPEN_RATE_MAX VARCHAR2(256) NOT NULL,
TASK_SWITCH_RATE_MIN VARCHAR2(256) NOT NULL,
TASK_SWITCH_RATE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybTasksTest_THRESH ADD constraint PK_SybTasksTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybTasksTest_THRESH ON SybTasksTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybTxLogTest CASCADE CONSTRAINTS;
CREATE TABLE SybTxLogTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
ULC_LOG_WRITES Number(20,4) NOT NULL,
ULC_LOG_WRITES_ST varchar2(32) NOT NULL,
ULC_LOG_WRITE_WAITS Number(20,4) NOT NULL,
ULC_LOG_WRITE_WAITS_ST varchar2(32) NOT NULL,
ULC_FLUSHES Number(20,4) NOT NULL,
ULC_FLUSHES_ST varchar2(32) NOT NULL,
ULC_FLUSH_WAITS Number(20,4) NOT NULL,
ULC_FLUSH_WAITS_ST varchar2(32) NOT NULL,
MAX_ULC_SIZE Number(20,4) NOT NULL,
MAX_ULC_SIZE_ST varchar2(32) NOT NULL,
LOG_ALLOCATIONS Number(20,4) NOT NULL,
LOG_ALLOCATIONS_ST varchar2(32) NOT NULL,
TRANSACTION_LOG_WRITES Number(20,4) NOT NULL,
TRANSACTION_LOG_WRITES_ST varchar2(32) NOT NULL,
AVG_WRITES_PER_LOGPAGE Number(20,4) NOT NULL,
AVG_WRITES_PER_LOGPAGE_ST varchar2(32) NOT NULL);

ALTER TABLE SybTxLogTest ADD constraint PK_SybTxLogTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybTxLogTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybTxLogTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
ULC_LOG_WRITES_MIN Number(20,4) NOT NULL,
ULC_LOG_WRITES_MAX Number(20,4) NOT NULL,
ULC_LOG_WRITES_STCNT varchar2(32) NOT NULL,
ULC_LOG_WRITE_WAITS_MIN Number(20,4) NOT NULL,
ULC_LOG_WRITE_WAITS_MAX Number(20,4) NOT NULL,
ULC_LOG_WRITE_WAITS_STCNT varchar2(32) NOT NULL,
ULC_FLUSHES_MIN Number(20,4) NOT NULL,
ULC_FLUSHES_MAX Number(20,4) NOT NULL,
ULC_FLUSHES_STCNT varchar2(32) NOT NULL,
ULC_FLUSH_WAITS_MIN Number(20,4) NOT NULL,
ULC_FLUSH_WAITS_MAX Number(20,4) NOT NULL,
ULC_FLUSH_WAITS_STCNT varchar2(32) NOT NULL,
MAX_ULC_SIZE_MIN Number(20,4) NOT NULL,
MAX_ULC_SIZE_MAX Number(20,4) NOT NULL,
MAX_ULC_SIZE_STCNT varchar2(32) NOT NULL,
LOG_ALLOCATIONS_MIN Number(20,4) NOT NULL,
LOG_ALLOCATIONS_MAX Number(20,4) NOT NULL,
LOG_ALLOCATIONS_STCNT varchar2(32) NOT NULL,
TRANSACTION_LOG_WRITES_MIN Number(20,4) NOT NULL,
TRANSACTION_LOG_WRITES_MAX Number(20,4) NOT NULL,
TRANSACTION_LOG_WRITES_STCNT varchar2(32) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MIN Number(20,4) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MAX Number(20,4) NOT NULL,
AVG_WRITES_PER_LOGPAGE_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybTxLogTest_TREND ADD constraint PK_SybTxLogTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybTxLogTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybTxLogTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
ULC_LOG_WRITES_MIN VARCHAR2(256) NOT NULL,
ULC_LOG_WRITES_MAX VARCHAR2(256) NOT NULL,
ULC_LOG_WRITE_WAITS_MIN VARCHAR2(256) NOT NULL,
ULC_LOG_WRITE_WAITS_MAX VARCHAR2(256) NOT NULL,
ULC_FLUSHES_MIN VARCHAR2(256) NOT NULL,
ULC_FLUSHES_MAX VARCHAR2(256) NOT NULL,
ULC_FLUSH_WAITS_MIN VARCHAR2(256) NOT NULL,
ULC_FLUSH_WAITS_MAX VARCHAR2(256) NOT NULL,
MAX_ULC_SIZE_MIN VARCHAR2(256) NOT NULL,
MAX_ULC_SIZE_MAX VARCHAR2(256) NOT NULL,
LOG_ALLOCATIONS_MIN VARCHAR2(256) NOT NULL,
LOG_ALLOCATIONS_MAX VARCHAR2(256) NOT NULL,
TRANSACTION_LOG_WRITES_MIN VARCHAR2(256) NOT NULL,
TRANSACTION_LOG_WRITES_MAX VARCHAR2(256) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MIN VARCHAR2(256) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybTxLogTest_THRESH ADD constraint PK_SybTxLogTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybTxLogTest_THRESH ON SybTxLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybTxTest CASCADE CONSTRAINTS;
CREATE TABLE SybTxTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
COMMITTED_TRANSACTIONS Number(20,4) NOT NULL,
COMMITTED_TRANSACTIONS_ST varchar2(32) NOT NULL,
ROLLEDBACK_TRANSACTIONS Number(20,4) NOT NULL,
ROLLEDBACK_TRANSACTIONS_ST varchar2(32) NOT NULL,
INSERTS Number(20,4) NOT NULL,
INSERTS_ST varchar2(32) NOT NULL,
UPDATES Number(20,4) NOT NULL,
UPDATES_ST varchar2(32) NOT NULL,
DELETES Number(20,4) NOT NULL,
DELETES_ST varchar2(32) NOT NULL);

ALTER TABLE SybTxTest ADD constraint PK_SybTxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybTxTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybTxTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
COMMITTED_TRANSACTIONS_MIN Number(20,4) NOT NULL,
COMMITTED_TRANSACTIONS_MAX Number(20,4) NOT NULL,
COMMITTED_TRANSACTIONS_STCNT varchar2(32) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MIN Number(20,4) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MAX Number(20,4) NOT NULL,
ROLLEDBACK_TRANSACTIONS_STCNT varchar2(32) NOT NULL,
INSERTS_MIN Number(20,4) NOT NULL,
INSERTS_MAX Number(20,4) NOT NULL,
INSERTS_STCNT varchar2(32) NOT NULL,
UPDATES_MIN Number(20,4) NOT NULL,
UPDATES_MAX Number(20,4) NOT NULL,
UPDATES_STCNT varchar2(32) NOT NULL,
DELETES_MIN Number(20,4) NOT NULL,
DELETES_MAX Number(20,4) NOT NULL,
DELETES_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybTxTest_TREND ADD constraint PK_SybTxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybTxTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybTxTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
COMMITTED_TRANSACTIONS_MIN VARCHAR2(256) NOT NULL,
COMMITTED_TRANSACTIONS_MAX VARCHAR2(256) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MIN VARCHAR2(256) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MAX VARCHAR2(256) NOT NULL,
INSERTS_MIN VARCHAR2(256) NOT NULL,
INSERTS_MAX VARCHAR2(256) NOT NULL,
UPDATES_MIN VARCHAR2(256) NOT NULL,
UPDATES_MAX VARCHAR2(256) NOT NULL,
DELETES_MIN VARCHAR2(256) NOT NULL,
DELETES_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybTxTest_THRESH ADD constraint PK_SybTxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybTxTest_THRESH ON SybTxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybSysProcessTest CASCADE CONSTRAINTS;
CREATE TABLE SybSysProcessTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_PROCESSES Number(20,4) NOT NULL,
TOTAL_PROCESSES_ST varchar2(32) NOT NULL,
BACKGROUND_PROCESSES Number(20,4) NOT NULL,
BACKGROUND_PROCESSES_ST varchar2(32) NOT NULL,
RUNNING_PROCESSES Number(20,4) NOT NULL,
RUNNING_PROCESSES_ST varchar2(32) NOT NULL,
SLEEPING_PROCESSES Number(20,4) NOT NULL,
SLEEPING_PROCESSES_ST varchar2(32) NOT NULL,
INFECTED_PROCESSES Number(20,4) NOT NULL,
INFECTED_PROCESSES_ST varchar2(32) NOT NULL,
BLOCKED_PROCESSES Number(20,4) NOT NULL,
BLOCKED_PROCESSES_ST varchar2(32) NOT NULL,
REMOTE_PROCESSES Number(20,4) NOT NULL,
REMOTE_PROCESSES_ST varchar2(32) NOT NULL,
STOPPED_PROCESSES Number(20,4) NOT NULL,
STOPPED_PROCESSES_ST varchar2(32) NOT NULL);

ALTER TABLE SybSysProcessTest ADD constraint PK_SybSysProcessTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybSysProcessTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybSysProcessTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_PROCESSES_MIN Number(20,4) NOT NULL,
TOTAL_PROCESSES_MAX Number(20,4) NOT NULL,
TOTAL_PROCESSES_STCNT varchar2(32) NOT NULL,
BACKGROUND_PROCESSES_MIN Number(20,4) NOT NULL,
BACKGROUND_PROCESSES_MAX Number(20,4) NOT NULL,
BACKGROUND_PROCESSES_STCNT varchar2(32) NOT NULL,
RUNNING_PROCESSES_MIN Number(20,4) NOT NULL,
RUNNING_PROCESSES_MAX Number(20,4) NOT NULL,
RUNNING_PROCESSES_STCNT varchar2(32) NOT NULL,
SLEEPING_PROCESSES_MIN Number(20,4) NOT NULL,
SLEEPING_PROCESSES_MAX Number(20,4) NOT NULL,
SLEEPING_PROCESSES_STCNT varchar2(32) NOT NULL,
INFECTED_PROCESSES_MIN Number(20,4) NOT NULL,
INFECTED_PROCESSES_MAX Number(20,4) NOT NULL,
INFECTED_PROCESSES_STCNT varchar2(32) NOT NULL,
BLOCKED_PROCESSES_MIN Number(20,4) NOT NULL,
BLOCKED_PROCESSES_MAX Number(20,4) NOT NULL,
BLOCKED_PROCESSES_STCNT varchar2(32) NOT NULL,
REMOTE_PROCESSES_MIN Number(20,4) NOT NULL,
REMOTE_PROCESSES_MAX Number(20,4) NOT NULL,
REMOTE_PROCESSES_STCNT varchar2(32) NOT NULL,
STOPPED_PROCESSES_MIN Number(20,4) NOT NULL,
STOPPED_PROCESSES_MAX Number(20,4) NOT NULL,
STOPPED_PROCESSES_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybSysProcessTest_TREND ADD constraint PK_SybSysProcessTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybSysProcessTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybSysProcessTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_PROCESSES_MIN VARCHAR2(256) NOT NULL,
TOTAL_PROCESSES_MAX VARCHAR2(256) NOT NULL,
BACKGROUND_PROCESSES_MIN VARCHAR2(256) NOT NULL,
BACKGROUND_PROCESSES_MAX VARCHAR2(256) NOT NULL,
RUNNING_PROCESSES_MIN VARCHAR2(256) NOT NULL,
RUNNING_PROCESSES_MAX VARCHAR2(256) NOT NULL,
SLEEPING_PROCESSES_MIN VARCHAR2(256) NOT NULL,
SLEEPING_PROCESSES_MAX VARCHAR2(256) NOT NULL,
INFECTED_PROCESSES_MIN VARCHAR2(256) NOT NULL,
INFECTED_PROCESSES_MAX VARCHAR2(256) NOT NULL,
BLOCKED_PROCESSES_MIN VARCHAR2(256) NOT NULL,
BLOCKED_PROCESSES_MAX VARCHAR2(256) NOT NULL,
REMOTE_PROCESSES_MIN VARCHAR2(256) NOT NULL,
REMOTE_PROCESSES_MAX VARCHAR2(256) NOT NULL,
STOPPED_PROCESSES_MIN VARCHAR2(256) NOT NULL,
STOPPED_PROCESSES_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybSysProcessTest_THRESH ADD constraint PK_SybSysProcessTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybSysProcessTest_THRESH ON SybSysProcessTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE UdSYSTEMTEST CASCADE CONSTRAINTS; 
CREATE TABLE UdSYSTEMTEST 
(
	TRGT_HOST           varchar2(32),
        PORT_NO             varchar2(32),
        SITE_NAME           varchar2(64),
        INFO                varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME           date,
	CPU_UTIL	    number(20,4) 	NOT NULL,
	CPU_UTIL_ST	    varchar2(32)        NOT NULL,
	SYS_CPU_UTIL	    number(20,4)         NOT NULL,
	SYS_CPU_UTIL_ST	    varchar2(32)     	NOT NULL,
	RUNNING_PROC	    Number(20,4)  	NOT NULL,
	RUNNING_PROC_ST	    varchar2(32)     	NOT NULL,
	BLOCKED_PROC	    Number(20,4)  	NOT NULL,
	BLOCKED_PROC_ST	    varchar2(32)     	NOT NULL,
	SWAP_AVAIL	    number(20,4)  	NOT NULL,
	SWAP_AVAIL_ST	    varchar2(32)        NOT NULL,
	FREE_MEM_AVAIL	    number(20,4)  	NOT NULL,
	FREE_MEM_AVAIL_ST   varchar2(32)        NOT NULL,
	MEM_SCAN_RATE 	    number(20,4)  	NOT NULL,
	MEM_SCAN_RATE_ST    varchar2(32)        NOT NULL
);
alter table UdSYSTEMTEST add constraint PK_UdSYSTEM
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);


DROP TABLE SYSTEMTEST CASCADE CONSTRAINTS; 

CREATE TABLE SYSTEMTEST 
(
	TRGT_HOST           varchar2(32),
        PORT_NO             varchar2(32),
        SITE_NAME           varchar2(64),
        INFO                varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME           date,
	CPU_UTIL	    number(20,4) 	NOT NULL,
	CPU_UTIL_ST	    varchar2(32)        NOT NULL,
	SYS_CPU_UTIL	    number(20,4)         NOT NULL,
	SYS_CPU_UTIL_ST	    varchar2(32)     	NOT NULL,
	RUNNING_PROC	    Number(20,4)  	NOT NULL,
	RUNNING_PROC_ST	    varchar2(32)     	NOT NULL,
	BLOCKED_PROC	    Number(20,4)  	NOT NULL,
	BLOCKED_PROC_ST	    varchar2(32)     	NOT NULL,
	SWAP_AVAIL	    number(20,4)  	NOT NULL,
	SWAP_AVAIL_ST	    varchar2(32)        NOT NULL,
	FREE_MEM_AVAIL	    number(20,4)  	NOT NULL,
	FREE_MEM_AVAIL_ST   varchar2(32)        NOT NULL,
	MEM_SCAN_RATE 	    number(20,4)  	NOT NULL,
	MEM_SCAN_RATE_ST    varchar2(32)        NOT NULL,
	STEAL_TIME 	    number(20,4)  	NOT NULL,
	STEAL_TIME_ST    varchar2(32)        NOT NULL
);

alter table SYSTEMTEST add constraint PK_SYSTEM
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE INDEX IDX1_SYSTEMTEST ON SYSTEMTEST(TRGT_HOST,MSMT_TIME);

DROP TABLE SYSTEMTEST_TREND CASCADE CONSTRAINTS; 

CREATE TABLE SYSTEMTEST_TREND 
(
	TRGT_HOST           		varchar2(32),
        PORT_NO             		varchar2(32),
        SITE_NAME           		varchar2(64),
        INFO                		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME           		date,
	PERIOD              		varchar2(32),
	CPU_UTIL_MIN	    		number(20,4) 	NOT NULL,
	CPU_UTIL_MAX	    		number(20,4) 	NOT NULL,
	CPU_UTIL_STCNT    		varchar2(32)    NOT NULL,
	SYS_CPU_UTIL_MIN    		number(20,4)     NOT NULL,
	SYS_CPU_UTIL_MAX    		number(20,4)     NOT NULL,
	SYS_CPU_UTIL_STCNT	    	varchar2(32)   	NOT NULL,
	RUNNING_PROC_MIN	    	Number(20,4)  	NOT NULL,
	RUNNING_PROC_MAX	    	Number(20,4)  	NOT NULL,
	RUNNING_PROC_STCNT	    	varchar2(32)   	NOT NULL,
	BLOCKED_PROC_MIN	    	Number(20,4)  	NOT NULL,
	BLOCKED_PROC_MAX	    	Number(20,4)  	NOT NULL,
	BLOCKED_PROC_STCNT	    	varchar2(32)   	NOT NULL,
	SWAP_AVAIL_MIN	    		number(20,4)  	NOT NULL,
	SWAP_AVAIL_MAX	    		number(20,4)  	NOT NULL,
	SWAP_AVAIL_STCNT	 	varchar2(32)    NOT NULL,
	FREE_MEM_AVAIL_MIN	    	number(20,4)  	NOT NULL,
	FREE_MEM_AVAIL_MAX	    	number(20,4)  	NOT NULL,
	FREE_MEM_AVAIL_STCNT   		varchar2(32)    NOT NULL,
	MEM_SCAN_RATE_MIN 	    	number(20,4)  	NOT NULL,
	MEM_SCAN_RATE_MAX 	    	number(20,4)  	NOT NULL,
	MEM_SCAN_RATE_STCNT		varchar2(32)    NOT NULL,
	STEAL_TIME_MIN 	    	number(20,4)  	NOT NULL,
	STEAL_TIME_MAX 	    	number(20,4)  	NOT NULL,
	STEAL_TIME_STCNT		varchar2(32)    NOT NULL
);

alter table SYSTEMTEST_TREND add constraint PK_SYSTEM_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE SYSTEMTEST_THRESH CASCADE CONSTRAINTS; 

CREATE TABLE SYSTEMTEST_THRESH 
(
	TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,  
	CPU_UTIL_MIN	VARCHAR2(256)	   NOT NULL,
	CPU_UTIL_MAX	VARCHAR2(256)	   NOT NULL,
	SYS_CPU_UTIL_MIN	VARCHAR2(256)	   NOT NULL,
	SYS_CPU_UTIL_MAX	VARCHAR2(256)	   NOT NULL,
	RUNNING_PROC_MIN	VARCHAR2(256)	    NOT NULL,
	RUNNING_PROC_MAX	VARCHAR2(256)	    NOT NULL,
	BLOCKED_PROC_MIN	VARCHAR2(256)	    NOT NULL,
	BLOCKED_PROC_MAX	VARCHAR2(256)	    NOT NULL,
	SWAP_AVAIL_MIN	VARCHAR2(256)	    NOT NULL,
	SWAP_AVAIL_MAX	VARCHAR2(256)	    NOT NULL,
	FREE_MEM_AVAIL_MIN	VARCHAR2(256)	    NOT NULL,
	FREE_MEM_AVAIL_MAX	VARCHAR2(256)	    NOT NULL,
	MEM_SCAN_RATE_MIN	VARCHAR2(256)	    NOT NULL,
	MEM_SCAN_RATE_MAX	VARCHAR2(256)	    NOT NULL,
	STEAL_TIME_MIN	VARCHAR2(256)	    NOT NULL,
	STEAL_TIME_MAX	VARCHAR2(256)	    NOT NULL
);

alter table SYSTEMTEST_THRESH add constraint PK_SYSTEM_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_SYSTEMTEST_THRESH ON SYSTEMTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE TCPTEST  CASCADE CONSTRAINTS;

CREATE TABLE TCPTEST 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME 		date,
	CONN_RATE_IN 		number(20,4) 	NOT NULL,
	CONN_RATE_IN_ST 	varchar2(32)    NOT NULL,
	CONN_RATE_OUT 		number(20,4) 	NOT NULL,
	CONN_RATE_OUT_ST 	varchar2(32)    NOT NULL,
	CURR_CONN 		Number(20,4) 	NOT NULL,
	CURR_CONN_ST 		varchar2(32)    NOT NULL,
	COMP_CONN_DROPS 	number(20,4) 	NOT NULL,
	COMP_CONN_DROPS_ST 	varchar2(32)    NOT NULL,
	HALF_CONN_DROPS 	number(20,4) 	NOT NULL,
	HALF_CONN_DROPS_ST 	varchar2(32)    NOT NULL
);
CREATE INDEX IDX1_TCPTEST ON TCPTEST (TRGT_HOST,MSMT_TIME);
ALTER TABLE TCPTEST ADD CONSTRAINT PK_TCP_STATS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TCPTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE TCPTEST_TREND 
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                 	varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD 				varchar2(32), 
	CONN_RATE_IN_MIN 		number(20,4) 	NOT NULL,
	CONN_RATE_IN_MAX 		number(20,4) 	NOT NULL,
	CONN_RATE_IN_STCNT 		varchar2(32)    NOT NULL,
	CONN_RATE_OUT_MIN 		number(20,4) 	NOT NULL,
	CONN_RATE_OUT_MAX 		number(20,4) 	NOT NULL,
	CONN_RATE_OUT_STCNT 		varchar2(32)    NOT NULL,
	CURR_CONN_MIN 			Number(20,4) 	NOT NULL,
	CURR_CONN_MAX 			Number(20,4) 	NOT NULL,
	CURR_CONN_STCNT 		varchar2(32)    NOT NULL,
	COMP_CONN_DROPS_MIN 		number(20,4) 	NOT NULL,
	COMP_CONN_DROPS_MAX 		number(20,4) 	NOT NULL,
	COMP_CONN_DROPS_STCNT 		varchar2(32)    NOT NULL,
	HALF_CONN_DROPS_MIN 		number(20,4) 	NOT NULL,
	HALF_CONN_DROPS_MAX 		number(20,4) 	NOT NULL,
	HALF_CONN_DROPS_STCNT 		varchar2(32)    NOT NULL
);

ALTER TABLE TCPTEST_TREND ADD CONSTRAINT PK_TCP_STATS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE TCPTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TCPTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START 	date,
        MSMT_TIME_END           date,
	CONN_RATE_IN_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_IN_MAX	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_OUT_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_OUT_MAX	VARCHAR2(256)	 	NOT NULL,
	CURR_CONN_MIN	VARCHAR2(256)	 	NOT NULL,
	CURR_CONN_MAX	VARCHAR2(256)	 	NOT NULL,
	COMP_CONN_DROPS_MIN	VARCHAR2(256)	 	NOT NULL,
	COMP_CONN_DROPS_MAX	VARCHAR2(256)	 	NOT NULL,
	HALF_CONN_DROPS_MIN	VARCHAR2(256)	 	NOT NULL,
	HALF_CONN_DROPS_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE TCPTEST_THRESH ADD CONSTRAINT PK_TCP_STATS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_TCPTEST_THRESH ON TCPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE TESTDESC  CASCADE CONSTRAINTS;

CREATE TABLE TESTDESC 
(
	TEST_NAME 		varchar2(64),
	TEST_SDESC 		varchar2(1000),
	TEST_LDESC 		varchar2(2048)
);

ALTER TABLE TESTDESC ADD CONSTRAINT PK_TESTDESC
PRIMARY KEY (TEST_NAME); 

DROP TABLE TESTMEASURE  CASCADE CONSTRAINTS;

CREATE TABLE TESTMEASURE
(
        TEST_NAME               varchar2(64),
        MSMT_NAME               varchar2(64),
        MSMT_DESC               varchar2(1000)
);

ALTER TABLE TESTMEASURE ADD CONSTRAINT PK_TESTMEASURE
PRIMARY KEY (TEST_NAME);

DROP TABLE topology CASCADE CONSTRAINTS;

CREATE TABLE TOPOLOGY
(
	COMP_TYPE 	    varchar2(32),
	COMP_NAME           varchar2(64),
        DEPD                varchar2(64)  NOT NULL,
        DIRCT               varchar2(32)  NOT NULL
);

alter table TOPOLOGY add constraint PK_TOPOLOGY
primary key (COMP_TYPE,COMP_NAME,DEPD);

DROP TABLE EGTRANSACTION CASCADE CONSTRAINTS;

CREATE TABLE EGTRANSACTION 
(
	TRANS_NAME 	          varchar2(64),
	SITE_NAME                 varchar2(64),
	USER_ID			   varchar2(256) NOT NULL,
        IMG                       varchar2(64)
);    

alter table EGTRANSACTION add constraint PK_EGTRANSACTION
primary key (TRANS_NAME,SITE_name,USER_ID);


DROP TABLE UDPTEST CASCADE CONSTRAINTS;

CREATE TABLE UDPTEST
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME       	date,
	PKT_RATE_IN 		number(20,4)  	NOT NULL,
	PKT_RATE_IN_ST 		varchar2(32)  	NOT NULL,
	PKT_RATE_OUT    	number(20,4)  	NOT NULL,
	PKT_RATE_OUT_ST    	varchar2(32)  	NOT NULL,
	PKT_OFLOW_RATE    	number(20,4)  	NOT NULL,
	PKT_OFLOW_RATE_ST   	varchar2(32)  	NOT NULL
);

alter table UDPTEST add constraint PK_UDP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE UDPTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE UDPTEST_TREND
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME       	date,
	PERIOD       		varchar2(32), 
	PKT_RATE_IN_MIN 	number(20,4)  	NOT NULL,
	PKT_RATE_IN_MAX 	number(20,4)  	NOT NULL,
	PKT_RATE_IN_STCNT 	varchar2(32)  	NOT NULL,
	PKT_RATE_OUT_MIN    	number(20,4)  	NOT NULL,
	PKT_RATE_OUT_MAX    	number(20,4)  	NOT NULL,
	PKT_RATE_OUT_STCNT	varchar2(32)  	NOT NULL,
	PKT_OFLOW_RATE_MIN    	number(20,4)  	NOT NULL,
	PKT_OFLOW_RATE_MAX    	number(20,4)  	NOT NULL,
	PKT_OFLOW_RATE_STCNT	varchar2(32)  	NOT NULL
);

alter table UDPTEST_TREND add constraint PK_UDP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE UDPTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE UDPTEST_THRESH
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START       	date,
	MSMT_TIME_END          	date,
	PKT_RATE_IN_MIN	VARCHAR2(256)	  	NOT NULL,
	PKT_RATE_IN_MAX	VARCHAR2(256)	  	NOT NULL,
	PKT_RATE_OUT_MIN	VARCHAR2(256)	  	NOT NULL,
	PKT_RATE_OUT_MAX	VARCHAR2(256)	  	NOT NULL,
	PKT_OFLOW_RATE_MIN	VARCHAR2(256)	  	NOT NULL,
	PKT_OFLOW_RATE_MAX	VARCHAR2(256)	  	NOT NULL
);

alter table UDPTEST_THRESH add constraint PK_UDP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_UDPTEST_THRESH ON UDPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE USER_ROLE CASCADE CONSTRAINTS;

create table USER_ROLE
(
	role_name varchar2(32) primary key,
	admin_perm number(20) not null,
	monitor_perm number(20) not null,
	reporter_perm number(20) not null,
	admin_action number(20) not null,
	monitor_action number(20) not null,
	reporter_action number(20) not null,
	all_components char(1) not null,
	config_perm number(20) not null,
	config_action number(20) not null
);          

insert into user_role values('Admin',9223372036854775807, 9223372036854775807,9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('ServerAdmin',9223372036854775806,9223372036854775807,9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('Supermonitor',0,9223372036854775807,9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('Monitor',0,9223372036854775807,9223372036854775807,0,0,0,'n',9223372036854775807,0);
insert into user_role values('SupermonitorNoConfig',0,9223372036854775807,9223372036854775807,0,0,0,'y',0,0);
insert into user_role values('MonitorNoConfig',0,9223372036854775807,9223372036854775807,0,0,0,'n',0,0);
insert into user_role values('AlarmViewer',0,224,0,0,7,0,'n',0,0);
insert into user_role values('SuperAlarmViewer',0,224,0,0,7,0,'y',0,0);
insert into user_role values('egsm',0,9223372036854775807, 9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('MonitorWithLimitedAdmin',772,9223372036854775807,9223372036854775807,0,0,0,'n',9223372036854775807,0);
insert into user_role values('MonitorWithLimitedAdminNoConfig',772,9223372036854775807,9223372036854775807,0,0,0,'n',0,0);
insert into user_role values('OrgAdmin',619492,9223372036854775807,9223372036854775807,0,0,0,'n',9223372036854775807,0);
insert into user_role values('OrgAdminNoConfig',619492,9223372036854775807,9223372036854775807,0,0,0,'n',0,0);
insert into user_role values('OrgAdminWithUserMgmt',619493,9223372036854775807,9223372036854775807,0,0,0,'n',9223372036854775807,0);
insert into user_role values('OrgAdminWithUserMgmtNoConfig',619493,9223372036854775807,9223372036854775807,0,0,0,'n',0,0);


DROP TABLE USER_INFO CASCADE CONSTRAINTS;

CREATE TABLE USER_INFO
(
        USER_ID             varchar2(256),
        USER_PASS           varchar2(1024)  NOT NULL,
        USER_TYPE           varchar2(32)  NOT NULL,
        USER_MAILID         varchar2(2000),
        USER_ALARM_TYPE     varchar2(32),
        USER_ALARM_PREF     varchar2(32),
        USER_ALARM_MODE     varchar2(32),
 USER_VALID_TILL     DATE,  
 USER_REG_DATE     DATE,
 USER_SERV_TYPE     varchar2(1024),
 CA_ENABLED         varchar2(16),
 REPT_TIMELINE    varchar2(16)
);

alter table USER_INFO add constraint PK_USER_INFO
primary key (USER_ID);


DROP TABLE CLOUD_USER_INFO CASCADE CONSTRAINTS;

CREATE TABLE CLOUD_USER_INFO
(
	EMAIL_ID		varchar2(256) NOT NULL,
	FIRST_NAME		varchar2(256),
	LAST_NAME		varchar2(256),
	PWD			varchar2(1024)  NOT NULL,
	COMPANY			varchar2(256),
	CONTACT_NO		varchar2(256),
	TIMEZONE		varchar2(256),
	REG_DATE		DATE,  
	ACT_DATE		DATE,
	UUID			varchar2(1024),
	ACCT_EXPIRY_DATE	DATE,
	INFO1			varchar2(256),
	INFO2			varchar2(256)
);

alter table CLOUD_USER_INFO add constraint PK_CLOUD_USER_INFO
primary key (EMAIL_ID);

DROP TABLE USER_SITE CASCADE CONSTRAINTS;

CREATE TABLE USER_SITE
(
	USER_ID 		varchar2(256),
	SITE_NAME		varchar2(128)
);

alter table USER_SITE add constraint PK_USER_SITE
primary key (
		USER_ID,
		SITE_NAME
	);

alter table USER_SITE add constraint FK_USER_SITE
foreign key(USER_ID) references USER_INFO(USER_ID) ON DELETE CASCADE;

DROP TABLE USER_SERVICEGROUP CASCADE CONSTRAINTS;

CREATE TABLE USER_SERVICEGROUP
(
	USER_ID			varchar2(256),
	SERVICEGROUP_NAME	varchar2(128)
);

alter table USER_SERVICEGROUP add constraint PK_USER_SERVICEGROUP
primary key (USER_ID,SERVICEGROUP_NAME);
 
alter table USER_SERVICEGROUP add constraint FK_USER_SERVICEGROUP
foreign key(USER_ID) references USER_INFO(USER_ID) ON DELETE CASCADE;

DROP TABLE USER_SEG CASCADE CONSTRAINTS;

CREATE TABLE USER_SEG
(
        USER_ID                varchar2(256),
        SEG_NAME               varchar2(128)
);

alter table USER_SEG add constraint PK_USER_SEG
primary key (
                USER_ID,
                SEG_NAME
        );

alter table USER_SEG add constraint FK_USER_SEG
foreign key(USER_ID) references USER_INFO(USER_ID) ON DELETE CASCADE;

DROP TABLE USER_GROUP CASCADE CONSTRAINTS;

CREATE TABLE USER_GROUP
(
        USER_ID                varchar2(256),
        GROUP_NAME               varchar2(128)
);

alter table USER_GROUP add constraint PK_USER_GROUP
primary key (
                USER_ID,
                GROUP_NAME
        );

alter table USER_GROUP add constraint FK_USER_GROUP
foreign key(USER_ID) references USER_INFO(USER_ID) ON DELETE CASCADE;


DROP TABLE USER_SERV CASCADE CONSTRAINTS;

CREATE TABLE USER_SERV
(
	USER_ID 		varchar2(256),
	SERV_NAME		varchar2(128),
	SERV_TYPE		varchar2(128)
);

alter table USER_SERV add constraint PK_USER_SERV
primary key (
		USER_ID,
		SERV_NAME,
		SERV_TYPE
	);

alter table USER_SERV add constraint FK_USER_SERV
foreign key(USER_ID) references USER_INFO(USER_ID) ON DELETE CASCADE;

DROP TABLE USER_ELEMENTS CASCADE CONSTRAINTS;

CREATE TABLE USER_ELEMENTS
(
	USER_ID			varchar2(256),
	ELEMENT_TYPE		varchar2(128),
	ELEMENT_NAME		varchar2(128)
);

alter table USER_ELEMENTS add constraint PK_USER_ELEMENTS
primary key (
	USER_ID,
	ELEMENT_TYPE,
	ELEMENT_NAME);
alter table USER_ELEMENTS add constraint FK_USER_ELEMENTS
foreign key(USER_ID) references USER_INFO(USER_ID) ON DELETE CASCADE;

DROP TABLE USER_VM CASCADE CONSTRAINTS; 
CREATE TABLE USER_VM 
( 
	USER_ID			 varchar2(256), 
	SERV_NAME		 varchar2(128), 
	SERV_TYPE		 varchar2(128), 
	VM_NAME			 varchar2(128) 
); 

alter table USER_VM add constraint PK_USER_VM 
primary key ( 
		USER_ID, 
		SERV_NAME, 
		SERV_TYPE, 
		VM_NAME
	); 
alter table USER_VM add constraint FK_USER_VM 
foreign key(USER_ID) references USER_INFO(USER_ID) ON DELETE CASCADE;
create index IDX_USER_VM on USER_VM (VM_NAME);   

insert into user_info (user_id,user_pass,user_type,ca_enabled,rept_timeline) values('admin','D0F28DD6B50F3D807B4CE61454A4365B','Admin','true#true','-1');
insert into user_info (user_id,user_pass,user_type,ca_enabled,rept_timeline) values('supermonitor','A8FCB53008C9B77047288D0C58B71BD2','Supermonitor','true#true','-1');
insert into USER_INFO (user_id,user_pass,user_type,ca_enabled,rept_timeline) values('egsm','5989FC09AFAAC1B733EB12115CFD48A9','egsm','false','-1');
insert into user_info (user_id,user_pass,user_type,ca_enabled,rept_timeline) values('egenterprise','70F8D62C2CE2BCECF8D7C2F0AAA703BE','Admin','true#true','-1');

DROP TABLE QINSIGHT_DETAILS CASCADE CONSTRAINTS;
DROP TABLE QINSIGHT_REPORT CASCADE CONSTRAINTS;

CREATE TABLE QINSIGHT_REPORT(
	user_id varchar2(512) primary key ,
	No_of_tiers number(2),
	No_of_servers_per_tier number(2),
	No_of_metrics_per_server number(2),
	refresh_rate number(5)
);


CREATE TABLE QINSIGHT_DETAILS(
	user_id varchar2(512),
	tier_name varchar2(128),
	tier_index number(2),
	server_name varchar2(128),
	server_index number(2),
	component varchar2(256),
	metric_name varchar2(128),
	metric_index number(2),
	test varchar2(31),
	measure varchar2(31),
	info varchar2(128),
	site varchar2(64),
	type char(1)
);

DROP TABLE USER_REPORTS CASCADE CONSTRAINTS;
DROP TABLE USER_REPORT_DETAILS CASCADE CONSTRAINTS;

CREATE TABLE USER_REPORTS(
	rept_id number(16) NOT NULL,
	user_id varchar2(256),
	rept_name varchar2(128),
	unique(user_id,rept_name)
);
ALTER TABLE USER_REPORTS ADD constraint PK_USER_REPORTS
PRIMARY KEY (rept_id);

INSERT INTO USER_REPORTS (rept_id,user_id,rept_name) values(1,'admin','USER_PREF');
INSERT INTO USER_REPORTS (rept_id,user_id,rept_name) values(2,'supermonitor','USER_PREF');

CREATE TABLE USER_REPORT_DETAILS(
	rept_id number(16) NOT NULL,
	rept_param varchar2(128),
	rept_value varchar2(1024)
);

alter table USER_REPORT_DETAILS add constraint FK_USER_REPORT_DETAILS
foreign key(rept_id) references user_reports(rept_id) ON DELETE CASCADE;

INSERT INTO USER_REPORT_DETAILS (rept_id,rept_param,rept_value) values(1,'ALARM_WINDOW','HIL');
INSERT INTO USER_REPORT_DETAILS (rept_id,rept_param,rept_value) values(2,'ALARM_WINDOW','HIL');

DROP TABLE WAPTEST  CASCADE CONSTRAINTS;

CREATE TABLE WAPTEST 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME 		date,
        AVAILABILITY            number(20,4)    NOT NULL,
        AVAILABILITY_ST        	varchar2(32)  	NOT NULL,
        CONN_AVAILABILITY 	number(20,4)    NOT NULL,
        CONN_AVAILABILITY_ST 	varchar2(32)  	NOT NULL,
        RESPONSE_TIME           number(20,4)    NOT NULL, 
        RESPONSE_TIME_ST        varchar2(32)     NOT NULL 
);

ALTER TABLE WAPTEST ADD CONSTRAINT PK_WAP_STATS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WAPTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE WAPTEST_TREND 
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                 	varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD 				varchar2(32), 
        AVAILABILITY_MIN            	number(20,4)    NOT NULL,
        AVAILABILITY_MAX            	number(20,4)    NOT NULL,
        AVAILABILITY_STCNT        	varchar2(32)  	NOT NULL,
        CONN_AVAILABILITY_MIN 		number(20,4)    NOT NULL,
        CONN_AVAILABILITY_MAX 		number(20,4)    NOT NULL,
        CONN_AVAILABILITY_STCNT 	varchar2(32)  	NOT NULL,
        RESPONSE_TIME_MIN           	number(20,4)    NOT NULL, 
        RESPONSE_TIME_MAX           	number(20,4)    NOT NULL, 
        RESPONSE_TIME_STCNT       	varchar2(32)     NOT NULL 
);

ALTER TABLE WAPTEST_TREND ADD CONSTRAINT PK_WAP_STATS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE WAPTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE WAPTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START 	date,
        MSMT_TIME_END           date,
        AVAILABILITY_MIN	VARCHAR2(256)	    NOT NULL,
        AVAILABILITY_MAX	VARCHAR2(256)	    NOT NULL,
        CONN_AVAILABILITY_MIN	VARCHAR2(256)	    NOT NULL,
        CONN_AVAILABILITY_MAX	VARCHAR2(256)	    NOT NULL,
        RESPONSE_TIME_MIN	VARCHAR2(256)	    NOT NULL,
        RESPONSE_TIME_MAX	VARCHAR2(256)	    NOT NULL
);

ALTER TABLE WAPTEST_THRESH ADD CONSTRAINT PK_WAP_STATS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WAPTEST_THRESH ON WAPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 
DROP TABLE WEBLOGICEJBTEST CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICEJBTEST
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	TX_COMMIT_RATE			number(20,4)	NOT NULL,
	TX_COMMIT_RATE_ST		varchar2(32)	NOT NULL,
	TX_ROLLBACK_RATE 		number(20,4)	NOT NULL,
	TX_ROLLBACK_RATE_ST 		varchar2(32)	NOT NULL,
	TX_INFLIGHT			number(8)	NOT NULL,
	TX_INFLIGHT_ST			varchar2(32)	NOT NULL,
	NUM_WAITING_RATE		number(20,4)	NOT NULL,
	NUM_WAITING_RATE_ST 		varchar2(23)	NOT NULL,
	TIME_OUT_RATE			number(20,4)	NOT NULL,
	TIME_OUT_RATE_ST  		varchar2(32)	NOT NULL,
	IDLE_BEAN_PCT			number(20,4)	NOT NULL,
	IDLE_BEAN_PCT_ST		varchar2(32)	NOT NULL
);

ALTER TABLE WEBLOGICEJBTEST ADD constraint PK_WLEJB
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WEBLOGICEJBTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICEJBTEST_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	TX_COMMIT_RATE_MIN		number(20,4)	NOT NULL,	
	TX_COMMIT_RATE_MAX		number(20,4)	NOT NULL,
	TX_COMMIT_RATE_STCNT		varchar2(32)	NOT NULL,
	TX_ROLLBACK_RATE_MIN		number(20,4)	NOT NULL,
	TX_ROLLBACK_RATE_MAX		number(20,4)	NOT NULL,
	TX_ROLLBACK_RATE_STCNT		varchar2(32)	NOT NULL,
	TX_INFLIGHT_MIN			number(8)	NOT NULL,
	TX_INFLIGHT_MAX			number(8)	NOT NULL,
	TX_INFLIGHT_STCNT		varchar2(32)	NOT NULL,
	NUM_WAITING_RATE_MIN		number(20,4)	NOT NULL,
	NUM_WAITING_RATE_MAX		number(20,4)	NOT NULL,
	NUM_WAITING_RATE_STCNT		varchar2(32)	NOT NULL,
	TIME_OUT_RATE_MIN		number(20,4)	NOT NULL,
	TIME_OUT_RATE_MAX		number(20,4)	NOT NULL,
	TIME_OUT_RATE_STCNT 		varchar2(32)    NOT NULL,
	IDLE_BEAN_PCT_MIN		number(20,4)	NOT NULL,
	IDLE_BEAN_PCT_MAX		number(20,4)	NOT NULL,
	IDLE_BEAN_PCT_STCNT 		varchar2(32)	NOT NULL
);

ALTER TABLE WEBLOGICEJBTEST_TREND ADD constraint PK_WLEJB_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBLOGICEJBTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICEJBTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
	TX_COMMIT_RATE_MIN	VARCHAR2(256)			NOT NULL,
	TX_COMMIT_RATE_MAX	VARCHAR2(256)			NOT NULL,
	TX_ROLLBACK_RATE_MIN	VARCHAR2(256)			NOT NULL,
	TX_ROLLBACK_RATE_MAX	VARCHAR2(256)			NOT NULL,
	TX_INFLIGHT_MIN	VARCHAR2(256)			NOT NULL,
	TX_INFLIGHT_MAX	VARCHAR2(256)			NOT NULL,
	NUM_WAITING_RATE_MIN	VARCHAR2(256)			NOT NULL,
	NUM_WAITING_RATE_MAX	VARCHAR2(256)			NOT NULL,
	TIME_OUT_RATE_MIN	VARCHAR2(256)			NOT NULL,
	TIME_OUT_RATE_MAX	VARCHAR2(256)			NOT NULL,
	IDLE_BEAN_PCT_MIN	VARCHAR2(256)			NOT NULL,
	IDLE_BEAN_PCT_MAX	VARCHAR2(256)			NOT NULL
);

ALTER TABLE WEBLOGICEJBTEST_THRESH ADD constraint PK_WLEJB_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBLOGICEJBTEST_THRESH ON WEBLOGICEJBTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WEBLOGICJDBCTEST CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICJDBCTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	CONN_USE_PCT 	number(20,4) 	NOT NULL,
	CONN_USE_PCT_ST varchar2(32) 	NOT NULL,
	CONN_PENDING 	number(20,4) 	NOT NULL,
	CONN_PENDING_ST varchar2(32) 	NOT NULL,
	MAX_CONNS		number(20,4)		NOT NULL,
	MAX_CONNS_ST	varchar2(32) 	NOT NULL,
	CURR_CONNS		number(20,4)		NOT NULL,
	CURR_CONNS_ST	varchar2(32)	NOT NULL,
	POOL_STATE	number(20,4)	NOT NULL,
	POOL_STATE_ST	varchar2(32)	NOT NULL,
	FAIL_RECONNS	number(20,4)	NOT NULL,
	FAIL_RECONNS_ST	varchar2(32)	NOT NULL,
	CONNS_COUNT	number(20,4)	NOT NULL,
	CONNS_COUNT_ST	varchar2(32)	NOT NULL,
	CONNS_DELAY	number(20,4)	NOT NULL,
	CONNS_DELAY_ST	varchar2(32)	NOT NULL,
	LEAK_CONNS	number(20,4)	NOT NULL,
	LEAK_CONNS_ST	varchar2(32)	NOT NULL,
	ACTIVE_HIGH	number(20,4)	NOT NULL,
	ACTIVE_HIGH_ST	varchar2(32)	NOT NULL,
	WAIT_HIGH	number(20,4)	NOT NULL,
	WAIT_HIGH_ST	varchar2(32)	NOT NULL
);

ALTER TABLE WEBLOGICJDBCTEST ADD constraint PK_WEBLOGIC_JDBC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WEBLOGICJDBCTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICJDBCTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	CONN_USE_PCT_MIN 	number(20,4) 	NOT NULL,
	CONN_USE_PCT_MAX 	number(20,4) 	NOT NULL,
	CONN_USE_PCT_STCNT 	varchar2(32) 	NOT NULL,
	CONN_PENDING_MIN 	number(20,4) 	NOT NULL,
	CONN_PENDING_MAX 	number(20,4) 	NOT NULL,
	CONN_PENDING_STCNT 	varchar2(32) 	NOT NULL,
	MAX_CONNS_MIN		number(20,4)		NOT NULL,
	MAX_CONNS_MAX		number(20,4)		NOT NULL,
	MAX_CONNS_STCNT		varchar2(32)		NOT NULL,
	CURR_CONNS_MIN		number(20,4)		NOT NULL,
	CURR_CONNS_MAX		number(20,4)		NOT NULL,
	CURR_CONNS_STCNT	varchar2(32)	NOT NULL,
	POOL_STATE_MIN		number(20,4)	NOT NULL,
	POOL_STATE_MAX		number(20,4)	NOT NULL,
	POOL_STATE_STCNT	varchar2(32)	NOT NULL,
	FAIL_RECONNS_MIN	number(20,4)	NOT NULL,
	FAIL_RECONNS_MAX	number(20,4)	NOT NULL,
	FAIL_RECONNS_STCNT	varchar2(32)	NOT NULL,
	CONNS_COUNT_MIN		number(20,4)	NOT NULL,
	CONNS_COUNT_MAX		number(20,4)	NOT NULL,
	CONNS_COUNT_STCNT	varchar2(32)	NOT NULL,
	CONNS_DELAY_MIN		number(20,4)	NOT NULL,
	CONNS_DELAY_MAX		number(20,4)	NOT NULL,
	CONNS_DELAY_STCNT	varchar2(32)	NOT NULL,
	LEAK_CONNS_MIN		number(20,4)	NOT NULL,
	LEAK_CONNS_MAX		number(20,4)	NOT NULL,
	LEAK_CONNS_STCNT	varchar2(32)	NOT NULL,
	ACTIVE_HIGH_MIN		number(20,4)	NOT NULL,
	ACTIVE_HIGH_MAX		number(20,4)	NOT NULL,
	ACTIVE_HIGH_STCNT	varchar2(32)	NOT NULL,
	WAIT_HIGH_MIN		number(20,4)	NOT NULL,
	WAIT_HIGH_MAX		number(20,4)	NOT NULL,
	WAIT_HIGH_STCNT		varchar2(32)	NOT NULL
);

ALTER TABLE WEBLOGICJDBCTEST_TREND ADD constraint PK_WEBLOGIC_JDBC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBLOGICJDBCTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICJDBCTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	CONN_USE_PCT_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_USE_PCT_MAX	VARCHAR2(256)	 	NOT NULL,
	CONN_PENDING_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_PENDING_MAX	VARCHAR2(256)	 	NOT NULL,
	MAX_CONNS_MIN	VARCHAR2(256)			NOT NULL,
	MAX_CONNS_MAX	VARCHAR2(256)			NOT NULL,
	CURR_CONNS_MIN	VARCHAR2(256)			NOT NULL,
	CURR_CONNS_MAX	VARCHAR2(256)			NOT NULL,
	POOL_STATE_MIN	VARCHAR2(256)		NOT NULL,
	POOL_STATE_MAX	VARCHAR2(256)		NOT NULL,
	FAIL_RECONNS_MIN	VARCHAR2(256)		NOT NULL,
	FAIL_RECONNS_MAX	VARCHAR2(256)		NOT NULL,
	CONNS_COUNT_MIN	VARCHAR2(256)		NOT NULL,
	CONNS_COUNT_MAX	VARCHAR2(256)		NOT NULL,
	CONNS_DELAY_MIN	VARCHAR2(256)		NOT NULL,
	CONNS_DELAY_MAX	VARCHAR2(256)		NOT NULL,
	LEAK_CONNS_MIN	VARCHAR2(256)		NOT NULL,
	LEAK_CONNS_MAX	VARCHAR2(256)		NOT NULL,
	ACTIVE_HIGH_MIN	VARCHAR2(256)		NOT NULL,
	ACTIVE_HIGH_MAX	VARCHAR2(256)		NOT NULL,
	WAIT_HIGH_MIN	VARCHAR2(256)		NOT NULL,
	WAIT_HIGH_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE WEBLOGICJDBCTEST_THRESH ADD constraint PK_WEBLOGIC_JDBC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBLOGICJDBCTEST_THRESH ON WEBLOGICJDBCTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE WEBLOGICTEST CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	THROUGHPUT 		number(20,4) 	NOT NULL,
	THROUGHPUT_ST 	varchar2(32) 	NOT NULL,
	PCT_HEAP_USE 	number(20,4) 	NOT NULL,
	PCT_HEAP_USE_ST	varchar2(32) 	NOT NULL,
	EXECUTE_Q_LEN 	number(20,4) 	NOT NULL,
	EXECUTE_Q_LEN_ST varchar2(32) 	NOT NULL,
	TOTAL_HEAP		number(20,4) 	NOT NULL,
	TOTAL_HEAP_ST	varchar2(32)	NOT NULL,
	FREE_HEAP		number(20,4)	NOT NULL,	
	FREE_HEAP_ST	varchar2(32)	NOT NULL
);

ALTER TABLE WEBLOGICTEST ADD constraint PK_WEB_LOGIC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WEBLOGICTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	THROUGHPUT_MIN	        number(20,4) 	NOT NULL,
	THROUGHPUT_MAX	        number(20,4) 	NOT NULL,
	THROUGHPUT_STCNT 	varchar2(32) 	NOT NULL,
	PCT_HEAP_USE_MIN	number(20,4) 	NOT NULL,
	PCT_HEAP_USE_MAX	number(20,4) 	NOT NULL,
	PCT_HEAP_USE_STCNT 	varchar2(32) 	NOT NULL,
	EXECUTE_Q_LEN_MIN	number(20,4) 	NOT NULL,
	EXECUTE_Q_LEN_MAX	number(20,4) 	NOT NULL,
	EXECUTE_Q_LEN_STCNT 	varchar2(32) 	NOT NULL,
	TOTAL_HEAP_MIN		number(20,4) 	NOT NULL,
	TOTAL_HEAP_MAX	number(20,4) 	NOT NULL,
	TOTAL_HEAP_STCNT 	varchar2(32) 	NOT NULL,
	FREE_HEAP_MIN		number(20,4) 	NOT NULL,
	FREE_HEAP_MAX		number(20,4) 	NOT NULL,
	FREE_HEAP_STCNT 	varchar2(32) 	NOT NULL
);

ALTER TABLE WEBLOGICTEST_TREND ADD constraint PK_WEB_LOGIC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBLOGICTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	THROUGHPUT_MIN	VARCHAR2(256)	 	NOT NULL,
	THROUGHPUT_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_HEAP_USE_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_HEAP_USE_MAX	VARCHAR2(256)	 	NOT NULL,
	EXECUTE_Q_LEN_MIN	VARCHAR2(256)	 	NOT NULL,
	EXECUTE_Q_LEN_MAX	VARCHAR2(256)	 	NOT NULL,
	TOTAL_HEAP_MIN	VARCHAR2(256)	 	NOT NULL,
	TOTAL_HEAP_MAX	VARCHAR2(256)	 	NOT NULL,
	FREE_HEAP_MIN	VARCHAR2(256)	 	NOT NULL,
	FREE_HEAP_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE WEBLOGICTEST_THRESH ADD constraint PK_WEB_LOGIC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBLOGICTEST_THRESH ON WEBLOGICTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WEBSERVERTEST CASCADE CONSTRAINTS;

CREATE TABLE WEBSERVERTEST 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO 	varchar2(32),
        SITE_NAME       varchar2(64),  
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
        MSMT_TIME 	date,
        CONN_RATE 	number(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar2(32)    NOT NULL,
	REQ_RATE 	number(20,4) 	NOT NULL,
	REQ_RATE_ST 	varchar2(32)    NOT NULL,
        BYTE_RATE_OUT 	number(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST varchar2(32)    NOT NULL,
	BYTE_RATE_IN 	number(20,4) 	NOT NULL,
	BYTE_RATE_IN_ST	varchar2(32)    NOT NULL,
	PCT_ERR 	number(20,4) 	NOT NULL,
	PCT_ERR_ST 	varchar2(32)    NOT NULL,
	PCT_ABORT 	number(20,4) 	NOT NULL,
	PCT_ABORT_ST 	varchar2(32)    NOT NULL,
	PCT_300_ERR 	number(20,4) 	NOT NULL,
	PCT_300_ERR_ST 	varchar2(32)    NOT NULL,
	PCT_400_ERR 	number(20,4) 	NOT NULL,
	PCT_400_ERR_ST 	varchar2(32)    NOT NULL,
	PCT_500_ERR 	number(20,4) 	NOT NULL,
	PCT_500_ERR_ST 	varchar2(32)    NOT NULL,
        CURR_REQ 	number(20,4) 	NOT NULL,
	CURR_REQ_ST 	varchar2(32)    NOT NULL
	);

ALTER TABLE WEBSERVERTEST ADD CONSTRAINT PK_WEBMON_SERVER 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WEBSERVERTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WEBSERVERTEST_TREND 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO 			varchar2(32),
        SITE_NAME       		varchar2(64),  
        INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD	 			varchar2(32), 
        CONN_RATE_MIN 			number(20,4) 	NOT NULL,
        CONN_RATE_MAX 			number(20,4) 	NOT NULL,
	CONN_RATE_STCNT 		varchar2(32)    NOT NULL,
	REQ_RATE_MIN 			number(20,4) 	NOT NULL,
	REQ_RATE_MAX 			number(20,4) 	NOT NULL,
	REQ_RATE_STCNT 			varchar2(32)    NOT NULL,
        BYTE_RATE_OUT_MIN 		number(20,4) 	NOT NULL,
        BYTE_RATE_OUT_MAX 		number(20,4) 	NOT NULL,
	BYTE_RATE_OUT_STCNT		varchar2(32)    NOT NULL,
	BYTE_RATE_IN_MIN    		number(20,4) 	NOT NULL,
	BYTE_RATE_IN_MAX    		number(20,4) 	NOT NULL,
	BYTE_RATE_IN_STCNT		varchar2(32)    NOT NULL,
	PCT_ERR_MIN 			number(20,4) 	NOT NULL,
	PCT_ERR_MAX 			number(20,4) 	NOT NULL,
	PCT_ERR_STCNT 			varchar2(32)    NOT NULL,
	PCT_ABORT_MIN    		number(20,4) 	NOT NULL,
	PCT_ABORT_MAX    		number(20,4) 	NOT NULL,
	PCT_ABORT_STCNT 		varchar2(32)    NOT NULL,
	PCT_300_ERR_MIN 		number(20,4) 	NOT NULL,
	PCT_300_ERR_MAX 		number(20,4) 	NOT NULL,
	PCT_300_ERR_STCNT 		varchar2(32)    NOT NULL,
	PCT_400_ERR_MIN 		number(20,4) 	NOT NULL,
	PCT_400_ERR_MAX 		number(20,4) 	NOT NULL,
	PCT_400_ERR_STCNT 		varchar2(32)    NOT NULL,
	PCT_500_ERR_MIN 		number(20,4) 	NOT NULL,
	PCT_500_ERR_MAX 		number(20,4) 	NOT NULL,
	PCT_500_ERR_STCNT 		varchar2(32)    NOT NULL,
        CURR_REQ_MIN     		number(20,4) 	NOT NULL,
        CURR_REQ_MAX     		number(20,4) 	NOT NULL,
	CURR_REQ_STCNT 			varchar2(32)    NOT NULL
);

ALTER TABLE WEBSERVERTEST_TREND ADD CONSTRAINT PK_WEBMON_SERVER_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBSERVERTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WEBSERVERTEST_THRESH
(
	TRGT_HOST 	  varchar2(32),
	PORT_NO 	  varchar2(32),
        SITE_NAME         varchar2(64),  
        INFO              varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	  date,
        MSMT_TIME_END     date,
        CONN_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	REQ_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	REQ_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR2(256)	 	NOT NULL,
	BYTE_RATE_OUT_MAX	VARCHAR2(256)	 	NOT NULL,
        BYTE_RATE_IN_MIN	VARCHAR2(256)	 	NOT NULL,
	BYTE_RATE_IN_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_ABORT_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_ABORT_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_300_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_300_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_400_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_400_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_500_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_500_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	CURR_REQ_MIN	VARCHAR2(256)	  NOT NULL,
        CURR_REQ_MAX	VARCHAR2(256)	  NOT NULL
     );
ALTER TABLE WEBSERVERTEST_THRESH ADD CONSTRAINT PK_WEBMON_SERVER_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBSERVERTEST_THRESH ON WEBSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  



DROP TABLE WEBSITETEST CASCADE CONSTRAINTS;

CREATE TABLE WEBSITETEST 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO 	varchar2(32),
        SITE_NAME       varchar2(64),  
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
        MSMT_TIME 	date,
        CONN_RATE 	number(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar2(32)    NOT NULL,
	REQ_RATE 	number(20,4) 	NOT NULL,
	REQ_RATE_ST 	varchar2(32)    NOT NULL,
        BYTE_RATE_OUT 	number(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST varchar2(32)    NOT NULL,
	BYTE_RATE_IN 	number(20,4) 	NOT NULL,
	BYTE_RATE_IN_ST	varchar2(32)    NOT NULL,
	PCT_ERR 	number(20,4) 	NOT NULL,
	PCT_ERR_ST 	varchar2(32)    NOT NULL,
	PCT_ABORT 	number(20,4) 	NOT NULL,
	PCT_ABORT_ST 	varchar2(32)    NOT NULL,
	PCT_300_ERR 	number(20,4) 	NOT NULL,
	PCT_300_ERR_ST 	varchar2(32)    NOT NULL,
	PCT_400_ERR 	number(20,4) 	NOT NULL,
	PCT_400_ERR_ST 	varchar2(32)    NOT NULL,
	PCT_500_ERR 	number(20,4) 	NOT NULL,
	PCT_500_ERR_ST 	varchar2(32)    NOT NULL,
        CURR_REQ 	number(20,4) 	NOT NULL,
	CURR_REQ_ST 	varchar2(32)    NOT NULL
	);

ALTER TABLE WEBSITETEST ADD CONSTRAINT PK_WEBSITE 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WEBSITETEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WEBSITETEST_TREND 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO 			varchar2(32),
        SITE_NAME       		varchar2(64),  
        INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD  			varchar2(32), 
        CONN_RATE_MIN 			number(20,4) 	NOT NULL,
        CONN_RATE_MAX 			number(20,4) 	NOT NULL,
	CONN_RATE_STCNT 		varchar2(32)    NOT NULL,
	REQ_RATE_MIN 			number(20,4) 	NOT NULL,
	REQ_RATE_MAX 			number(20,4) 	NOT NULL,
	REQ_RATE_STCNT 			varchar2(32)    NOT NULL,
        BYTE_RATE_OUT_MIN 		number(20,4) 	NOT NULL,
        BYTE_RATE_OUT_MAX 		number(20,4) 	NOT NULL,
	BYTE_RATE_OUT_STCNT 		varchar2(32)    NOT NULL,
	BYTE_RATE_IN_MIN 		number(20,4) 	NOT NULL,
	BYTE_RATE_IN_MAX 		number(20,4) 	NOT NULL,
	BYTE_RATE_IN_STCNT		varchar2(32)    NOT NULL,
	PCT_ERR_MIN 			number(20,4) 	NOT NULL,
	PCT_ERR_MAX 			number(20,4) 	NOT NULL,
	PCT_ERR_STCNT 			varchar2(32)    NOT NULL,
	PCT_ABORT_MIN 			number(20,4) 	NOT NULL,
	PCT_ABORT_MAX 			number(20,4) 	NOT NULL,
	PCT_ABORT_STCNT 		varchar2(32)    NOT NULL,
	PCT_300_ERR_MIN 		number(20,4) 	NOT NULL,
	PCT_300_ERR_MAX 		number(20,4) 	NOT NULL,
	PCT_300_ERR_STCNT		varchar2(32)    NOT NULL,
	PCT_400_ERR_MIN 		number(20,4) 	NOT NULL,
	PCT_400_ERR_MAX 		number(20,4) 	NOT NULL,
	PCT_400_ERR_STCNT 		varchar2(32)    NOT NULL,
	PCT_500_ERR_MIN 		number(20,4) 	NOT NULL,
	PCT_500_ERR_MAX 		number(20,4) 	NOT NULL,
	PCT_500_ERR_STCNT 		varchar2(32)    NOT NULL,
        CURR_REQ_MIN 			number(20,4) 	NOT NULL,
        CURR_REQ_MAX 			number(20,4) 	NOT NULL,
	CURR_REQ_STCNT 			varchar2(32)    NOT NULL
);

ALTER TABLE WEBSITETEST_TREND ADD CONSTRAINT PK_WEBSITE_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBSITETEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WEBSITETEST_THRESH
(
	TRGT_HOST 	  varchar2(32),
	PORT_NO 	  varchar2(32),
        SITE_NAME         varchar2(64),  
        INFO              varchar2(128),
	MSMT_HOST 	  varchar2(32), 
	MSMT_TIME_START	  date,
        MSMT_TIME_END     date,
        CONN_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	REQ_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	REQ_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR2(256)	 	NOT NULL,
	BYTE_RATE_OUT_MAX	VARCHAR2(256)	 	NOT NULL,
        BYTE_RATE_IN_MIN	VARCHAR2(256)	 	NOT NULL,
	BYTE_RATE_IN_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_ABORT_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_ABORT_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_300_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_300_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_400_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_400_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_500_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_500_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	CURR_REQ_MIN	VARCHAR2(256)	  NOT NULL,
        CURR_REQ_MAX	VARCHAR2(256)	  NOT NULL
     );
ALTER TABLE WEBSITETEST_THRESH ADD CONSTRAINT PK_WEBSITE_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBSITETEST_THRESH ON WEBSITETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);       

DROP TABLE   WEBSITETRANSACTIONTEST CASCADE CONSTRAINTS;

CREATE TABLE WEBSITETRANSACTIONTEST 
(
	TRGT_HOST 		varchar2(32),
	PORT_NO 		varchar2(32),
        SITE_NAME               varchar2(64),  
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME 		date,
        REQ_RATE 		number(20,4) 	NOT NULL,
	REQ_RATE_ST 	        varchar2(32)    NOT NULL,
        PCT_ERR 		number(20,4) 	NOT NULL,
	PCT_ERR_ST 		varchar2(32)    NOT NULL,
        PCT_ABORT 		number(20,4) 	NOT NULL,
	PCT_ABORT_ST 	        varchar2(32)    NOT NULL,
        BYTE_RATE_OUT 	        number(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST	varchar2(32)    NOT NULL,
        AVG_RESP_TIME 	        number(20,4) 	NOT NULL,
	AVG_RESP_TIME_ST        varchar2(32) 	NOT NULL,
        CURR_REQ 		number(20,4) 	NOT NULL,
	CURR_REQ_ST 	        varchar2(32)    NOT NULL
    );

ALTER TABLE WEBSITETRANSACTIONTEST ADD CONSTRAINT PK_WEBSITE_TRAN 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   WEBSITETRANSACTIONTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WEBSITETRANSACTIONTEST_TREND 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO 			varchar2(32),
        SITE_NAME               	varchar2(64),  
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD 				varchar2(32), 
        REQ_RATE_MIN 			number(20,4) 	NOT NULL,
        REQ_RATE_MAX 			number(20,4) 	NOT NULL,
	REQ_RATE_STCNT 	       		varchar2(32)    NOT NULL,
        PCT_ERR_MIN 			number(20,4) 	NOT NULL,
        PCT_ERR_MAX 			number(20,4) 	NOT NULL,
	PCT_ERR_STCNT 			varchar2(32)    NOT NULL,
        PCT_ABORT_MIN 			number(20,4) 	NOT NULL,
        PCT_ABORT_MAX 			number(20,4) 	NOT NULL,
	PCT_ABORT_STCNT 	       	varchar2(32)    NOT NULL,
        BYTE_RATE_OUT_MIN 	       	number(20,4) 	NOT NULL,
        BYTE_RATE_OUT_MAX 	       	number(20,4) 	NOT NULL,
	BYTE_RATE_OUT_STCNT		varchar2(32)    NOT NULL,
        AVG_RESP_TIME_MIN 	       	number(20,4) 	NOT NULL,
        AVG_RESP_TIME_MAX 	       	number(20,4) 	NOT NULL,
	AVG_RESP_TIME_STCNT        	varchar2(32) 	NOT NULL,
        CURR_REQ_MIN 			number(20,4) 	NOT NULL,
        CURR_REQ_MAX 			number(20,4) 	NOT NULL,
	CURR_REQ_STCNT 	       		varchar2(32)    NOT NULL
      );
ALTER TABLE WEBSITETRANSACTIONTEST_TREND ADD CONSTRAINT PK_WEBSITE_TRAN_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBSITETRANSACTIONTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE WEBSITETRANSACTIONTEST_THRESH
(
	TRGT_HOST 		varchar2(32),
	PORT_NO 		varchar2(32),
        SITE_NAME               varchar2(64),  
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START 	date,
        MSMT_TIME_END           date,
        REQ_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	REQ_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
        PCT_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
        PCT_ABORT_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_ABORT_MAX	VARCHAR2(256)	 	NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR2(256)	 	NOT NULL,
	BYTE_RATE_OUT_MAX	VARCHAR2(256)	 	NOT NULL,
        AVG_RESP_TIME_MIN	VARCHAR2(256)	    NOT NULL,
        AVG_RESP_TIME_MAX	VARCHAR2(256)	    NOT NULL,
        CURR_REQ_MIN	VARCHAR2(256)	    NOT NULL,
        CURR_REQ_MAX	VARCHAR2(256)	    NOT NULL
     );
ALTER TABLE WEBSITETRANSACTIONTEST_THRESH ADD CONSTRAINT PK_WEBSITE_TRAN_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBSITETRANSTEST_THRESH ON WEBSITETRANSACTIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE   WEBSITETRANSACTIONTEST_LAST CASCADE CONSTRAINTS;

CREATE TABLE WEBSITETRANSACTIONTEST_LAST 
(
	TRGT_HOST 		varchar2(32),
	PORT_NO 		varchar2(32),
        SITE_NAME               varchar2(64),  
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME 		date,
        REQ_RATE 		number(20,4) 	NOT NULL,
	REQ_RATE_ST 	        varchar2(32)    NOT NULL,
        PCT_ERR 		number(20,4) 	NOT NULL,
	PCT_ERR_ST 		varchar2(32)    NOT NULL,
        PCT_ABORT 		number(20,4) 	NOT NULL,
	PCT_ABORT_ST 	        varchar2(32)    NOT NULL,
        BYTE_RATE_OUT 	        number(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST	varchar2(32)    NOT NULL,
        AVG_RESP_TIME 	        number(20,4) 	NOT NULL,
	AVG_RESP_TIME_ST        varchar2(32) 	NOT NULL,
        CURR_REQ 		number(20,4) 	NOT NULL,
	CURR_REQ_ST 	        varchar2(32)    NOT NULL
    );

ALTER TABLE WEBSITETRANSACTIONTEST_LAST ADD CONSTRAINT PK_WEBSITE_TRAN_LAST 
primary key (TRGT_HOST,PORT_NO,SITE_NAME,INFO);
create index idx_websitetranstest_last on websitetransactiontest_last(site_name);


DROP TABLE WINSERVICETEST CASCADE CONSTRAINTS;

CREATE TABLE WINSERVICETEST
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	AVAIL		number(3) 	NOT NULL,
	AVAIL_ST	varchar2(32)    NOT NULL,
	SERVICE_STATE		number(3) 	NOT NULL,
	SERVICE_STATE_ST	varchar2(32)    NOT NULL

);

ALTER TABLE WINSERVICETEST ADD constraint PK_WINSERVICE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WINSERVICETEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WINSERVICETEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO         	varchar2(32),
        SITE_NAME       	varchar2(64),
        INFO            	varchar2(128), 
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD 			varchar2(32),
	AVAIL_MIN		number(20,4) 	NOT NULL,
	AVAIL_MAX		number(20,4) 	NOT NULL,
	AVAIL_STCNT		varchar2(32)   	NOT NULL,
	SERVICE_STATE_MIN	number(20,4) 	NOT NULL,
	SERVICE_STATE_MAX	number(20,4) 	NOT NULL,
	SERVICE_STATE_STCNT	varchar2(32)   	NOT NULL
);

ALTER TABLE WINSERVICETEST_TREND ADD constraint PK_WINSERVICE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WINSERVICETEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WINSERVICETEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	AVAIL_MIN	VARCHAR2(256)	 	NOT NULL,
	AVAIL_MAX	VARCHAR2(256)	 	NOT NULL,
	SERVICE_STATE_MIN	VARCHAR2(256)	NOT NULL,
	SERVICE_STATE_MAX	VARCHAR2(256)	NOT NULL
);

ALTER TABLE WINSERVICETEST_THRESH ADD constraint PK_WINSERVICE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WINSERVICETEST_THRESH ON WINSERVICETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     

DROP TABLE WSEJBTEST CASCADE CONSTRAINTS;

CREATE TABLE WSEJBTEST
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	INSTANTIATES		number(20,4) 	NOT NULL,
	INSTANTIATES_ST		varchar2(32) 	NOT NULL,
	DESTROYS		number(20,4) 	NOT NULL,
	DESTROYS_ST		varchar2(32) 	NOT NULL,
	TOT_METHOD_CALLS	number(20,4) 	NOT NULL,
	TOT_METHOD_CALLS_ST	varchar2(32) 	NOT NULL,
	AVG_METHOD_RT		number(20,4) 	NOT NULL,
	AVG_METHOD_RT_ST	varchar2(32) 	NOT NULL,
	AVG_CREATE_TIME		number(20,4) 	NOT NULL,
	AVG_CREATE_TIME_ST	varchar2(32) 	NOT NULL,
	POOL_SIZE		number(20,4) 	NOT NULL,
	POOl_SIZE_ST		varchar2(32) 	NOT NULL
);

ALTER TABLE WSEJBTEST ADD constraint PK_WS_EJB
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSEJBTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSEJBTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	INSTANTIATES_MIN	number(20,4) 	NOT NULL,
	INSTANTIATES_MAX	number(20,4) 	NOT NULL,
	INSTANTIATES_STCNT	varchar2(32) 	NOT NULL,
	DESTROYS_MIN		number(20,4) 	NOT NULL,
	DESTROYS_MAX		number(20,4) 	NOT NULL,
	DESTROYS_STCNT		varchar2(32) 	NOT NULL,
	TOT_METHOD_CALLS_MIN	number(20,4) 	NOT NULL,
	TOT_METHOD_CALLS_MAX	number(20,4) 	NOT NULL,
	TOT_METHOD_CALLS_STCNT	varchar2(32) 	NOT NULL,
	AVG_METHOD_RT_MIN	number(20,4) 	NOT NULL,
	AVG_METHOD_RT_MAX	number(20,4) 	NOT NULL,
	AVG_METHOD_RT_STCNT	varchar2(32) 	NOT NULL,
	AVG_CREATE_TIME_MIN	number(20,4) 	NOT NULL,
	AVG_CREATE_TIME_MAX	number(20,4) 	NOT NULL,
	AVG_CREATE_TIME_STCNT	varchar2(32) 	NOT NULL,
	POOL_SIZE_MIN		number(20,4) 	NOT NULL,
	POOL_SIZE_MAX		number(20,4) 	NOT NULL,
	POOL_SIZE_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE WSEJBTEST_TREND ADD constraint PK_WS_EJB_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSEJBTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSEJBTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME        	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START		date,
        MSMT_TIME_END   	date,
	INSTANTIATES_MIN	VARCHAR2(256)	 	NOT NULL,
	INSTANTIATES_MAX	VARCHAR2(256)	 	NOT NULL,
	DESTROYS_MIN	VARCHAR2(256)	 	NOT NULL,
	DESTROYS_MAX	VARCHAR2(256)	 	NOT NULL,
	TOT_METHOD_CALLS_MIN	VARCHAR2(256)	 	NOT NULL,
	TOT_METHOD_CALLS_MAX	VARCHAR2(256)	 	NOT NULL,
	AVG_METHOD_RT_MIN	VARCHAR2(256)	 	NOT NULL,
	AVG_METHOD_RT_MAX	VARCHAR2(256)	 	NOT NULL,
	AVG_CREATE_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	AVG_CREATE_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	POOL_SIZE_MIN	VARCHAR2(256)	 	NOT NULL,
	POOL_SIZE_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE WSEJBTEST_THRESH ADD constraint PK_WS_EJB_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSEJBTEST_THRESH ON WSEJBTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WSGLOBALTXTEST CASCADE CONSTRAINTS;

CREATE TABLE WSGLOBALTXTEST
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	GLOBAL_TX_BEGUN			number(20,4) 	NOT NULL,
	GLOBAL_TX_BEGUN_ST		varchar2(32) 	NOT NULL,
	ACTIVE_GLOBAL_TX		number(20,4) 	NOT NULL,
	ACTIVE_GLOBAL_TX_ST		varchar2(32) 	NOT NULL,
	GLOBAL_TX_DURATION		number(20,4) 	NOT NULL,
	GLOBAL_TX_DURATION_ST		varchar2(32) 	NOT NULL,
	GLOBAL_COMMIT_DURATION		number(20,4) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_ST	varchar2(32) 	NOT NULL,
	NUM_OPTIMIZATION		number(20,4) 	NOT NULL,
	NUM_OPTIMIZATION_ST		varchar2(32) 	NOT NULL,
	GLOBAL_TX_COMMITTED		number(20,4) 	NOT NULL,
	GLOBAL_TX_COMMITTED_ST		varchar2(32) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK		number(20,4) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_ST	varchar2(32) 	NOT NULL,
	GLOBAL_TX_TIMEOUT		number(20,4) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_ST		varchar2(32) 	NOT NULL,
	GLOBAL_TX_INVOLVED		number(20,4) 	NOT NULL,
	GLOBAL_TX_INVOLVED_ST		varchar2(32) 	NOT NULL,
	GLOBAL_PREPARE_DURATION		number(20,4) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_ST	varchar2(32) 	NOT NULL
);

ALTER TABLE WSGLOBALTXTEST ADD constraint PK_WS_GL_TX
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSGLOBALTXTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSGLOBALTXTEST_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	GLOBAL_TX_BEGUN_MIN		number(20,4) 	NOT NULL,
	GLOBAL_TX_BEGUN_MAX		number(20,4) 	NOT NULL,
	GLOBAL_TX_BEGUN_STCNT		varchar2(32) 	NOT NULL,
	ACTIVE_GLOBAL_TX_MIN		number(20,4) 	NOT NULL,
	ACTIVE_GLOBAL_TX_MAX		number(20,4) 	NOT NULL,
	ACTIVE_GLOBAL_TX_STCNT		varchar2(32) 	NOT NULL,
	GLOBAL_TX_DURATION_MIN		number(20,4) 	NOT NULL,
	GLOBAL_TX_DURATION_MAX		number(20,4) 	NOT NULL,
	GLOBAL_TX_DURATION_STCNT	varchar2(32) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MIN	number(20,4) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MAX	number(20,4) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_STCNT	varchar2(32) 	NOT NULL,
	NUM_OPTIMIZATION_MIN		number(20,4) 	NOT NULL,
	NUM_OPTIMIZATION_MAX		number(20,4) 	NOT NULL,
	NUM_OPTIMIZATION_STCNT		varchar2(32) 	NOT NULL,
	GLOBAL_TX_COMMITTED_MIN		number(20,4) 	NOT NULL,
	GLOBAL_TX_COMMITTED_MAX		number(20,4) 	NOT NULL,
	GLOBAL_TX_COMMITTED_STCNT	varchar2(32) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MIN	number(20,4) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MAX	number(20,4) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_STCNT	varchar2(32) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MIN		number(20,4) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MAX		number(20,4) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_STCNT		varchar2(32) 	NOT NULL,
	GLOBAL_TX_INVOLVED_MIN		number(20,4) 	NOT NULL,
	GLOBAL_TX_INVOLVED_MAX		number(20,4) 	NOT NULL,
	GLOBAL_TX_INVOLVED_STCNT	varchar2(32) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MIN	number(20,4) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MAX	number(20,4) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_STCNT	varchar2(32) 	NOT NULL
);
	
ALTER TABLE WSGLOBALTXTEST_TREND ADD constraint PK_WS_GL_TX_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSGLOBALTXTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSGLOBALTXTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
        MSMT_TIME_END   		date,
	GLOBAL_TX_BEGUN_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_BEGUN_MAX	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_GLOBAL_TX_MIN	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_GLOBAL_TX_MAX	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_DURATION_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_DURATION_MAX	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MAX	VARCHAR2(256)	 	NOT NULL,
	NUM_OPTIMIZATION_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_OPTIMIZATION_MAX	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_COMMITTED_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_COMMITTED_MAX	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MAX	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MAX	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_INVOLVED_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_INVOLVED_MAX	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MAX	VARCHAR2(256)	 	NOT NULL
);
	
ALTER TABLE WSGLOBALTXTEST_THRESH ADD constraint PK_WS_GL_TX_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSGLOBALTXTEST_THRESH ON WSGLOBALTXTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WSJDBCTEST CASCADE CONSTRAINTS;

CREATE TABLE WSJDBCTEST
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	CREATION_RATE		number(20,4) 	NOT NULL,
	CREATION_RATE_ST	varchar2(32) 	NOT NULL,
	DESTROY_RATE		number(20,4) 	NOT NULL,
	DESTROY_RATE_ST		varchar2(32) 	NOT NULL,
	RETURN_RATE		number(20,4) 	NOT NULL,
	RETURN_RATE_ST		varchar2(32) 	NOT NULL,
	ALLOCATE_RATE		number(20,4) 	NOT NULL,
	ALLOCATE_RATE_ST	varchar2(32) 	NOT NULL,
	POOL_SIZE		number(20,4) 	NOT NULL,
	POOL_SIZE_ST		varchar2(32) 	NOT NULL,
	CONCUR_WAITERS		number(20,4) 	NOT NULL,
	CONCUR_WAITERS_ST	varchar2(32) 	NOT NULL,
	AVG_WAIT_TIME		number(20,4) 	NOT NULL,
	AVG_WAIT_TIME_ST	varchar2(32) 	NOT NULL,
	FAULTS			number(20,4) 	NOT NULL,
	FAULTS_ST		varchar2(32) 	NOT NULL,
	PCT_USED		number(20,4) 	NOT NULL,
	PCT_USED_ST		varchar2(32) 	NOT NULL,
	PCT_MAXED		number(20,4) 	NOT NULL,
	PCT_MAXED_ST		varchar2(32) 	NOT NULL,
	PSTMT_CACHE_DISCARDS	number(20,4) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_ST	varchar2(32) 	NOT NULL
);

ALTER TABLE WSJDBCTEST ADD constraint PK_WS_JDBC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSJDBCTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSJDBCTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	CREATION_RATE_MIN	number(20,4) 	NOT NULL,
	CREATION_RATE_MAX	number(20,4) 	NOT NULL,
	CREATION_RATE_STCNT	varchar2(32) 	NOT NULL,
	DESTROY_RATE_MIN	number(20,4) 	NOT NULL,
	DESTROY_RATE_MAX	number(20,4) 	NOT NULL,
	DESTROY_RATE_STCNT	varchar2(32) 	NOT NULL,
	RETURN_RATE_MIN		number(20,4) 	NOT NULL,
	RETURN_RATE_MAX		number(20,4) 	NOT NULL,
	RETURN_RATE_STCNT	varchar2(32) 	NOT NULL,
	ALLOCATE_RATE_MIN	number(20,4) 	NOT NULL,
	ALLOCATE_RATE_MAX	number(20,4) 	NOT NULL,
	ALLOCATE_RATE_STCNT	varchar2(32) 	NOT NULL,
	POOL_SIZE_MIN		number(20,4) 	NOT NULL,
	POOL_SIZE_MAX		number(20,4) 	NOT NULL,
	POOL_SIZE_STCNT		varchar2(32) 	NOT NULL,
	CONCUR_WAITERS_MIN	number(20,4) 	NOT NULL,
	CONCUR_WAITERS_MAX	number(20,4) 	NOT NULL,
	CONCUR_WAITERS_STCNT	varchar2(32) 	NOT NULL,
	AVG_WAIT_TIME_MIN	number(20,4) 	NOT NULL,
	AVG_WAIT_TIME_MAX	number(20,4) 	NOT NULL,
	AVG_WAIT_TIME_STCNT	varchar2(32) 	NOT NULL,
	FAULTS_MIN		number(20,4) 	NOT NULL,
	FAULTS_MAX		number(20,4) 	NOT NULL,
	FAULTS_STCNT		varchar2(32) 	NOT NULL,
	PCT_USED_MIN		number(20,4) 	NOT NULL,
	PCT_USED_MAX		number(20,4) 	NOT NULL,
	PCT_USED_STCNT		varchar2(32) 	NOT NULL,
	PCT_MAXED_MIN		number(20,4) 	NOT NULL,
	PCT_MAXED_MAX		number(20,4) 	NOT NULL,
	PCT_MAXED_STCNT		varchar2(32) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MIN	number(20,4) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MAX	number(20,4) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_STCNT	varchar2(32) 	NOT NULL
);

ALTER TABLE WSJDBCTEST_TREND ADD constraint PK_WS_JDBC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSJDBCTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSJDBCTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
        MSMT_TIME_END   		date,
	CREATION_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	CREATION_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DESTROY_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DESTROY_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	RETURN_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	RETURN_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	ALLOCATE_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	ALLOCATE_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	POOL_SIZE_MIN	VARCHAR2(256)	 	NOT NULL,
	POOL_SIZE_MAX	VARCHAR2(256)	 	NOT NULL,
	CONCUR_WAITERS_MIN	VARCHAR2(256)	 	NOT NULL,
	CONCUR_WAITERS_MAX	VARCHAR2(256)	 	NOT NULL,
	AVG_WAIT_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	AVG_WAIT_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	FAULTS_MIN	VARCHAR2(256)	 	NOT NULL,
	FAULTS_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_USED_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_USED_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_MAXED_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_MAXED_MAX	VARCHAR2(256)	 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MIN	VARCHAR2(256)	 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE WSJDBCTEST_THRESH ADD constraint PK_WS_JDBC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSJDBCTEST_THRESH ON WSJDBCTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WSLOCALTXTEST CASCADE CONSTRAINTS;

CREATE TABLE WSLOCALTXTEST
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	LOCAL_TX_BEGUN			number(20,4) 	NOT NULL,
	LOCAL_TX_BEGUN_ST		varchar2(32) 	NOT NULL,
	ACTIVE_LOCAL_TX			number(20,4) 	NOT NULL,
	ACTIVE_LOCAL_TX_ST		varchar2(32) 	NOT NULL,
	LOCAL_TX_DURA		number(20,4) 	NOT NULL,
	LOCAL_TX_DURA_ST		varchar2(32) 	NOT NULL,
	LOCAL_COMMIT_DURA		number(20,4) 	NOT NULL,
	LOCAL_COMMIT_DURA_ST	varchar2(32) 	NOT NULL,
	LOCAL_TX_COMMITTED		number(20,4) 	NOT NULL,
	LOCAL_TX_COMMITTED_ST		varchar2(32) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK		number(20,4) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_ST		varchar2(32) 	NOT NULL,
	LOCAL_TX_TIMEOUT		number(20,4) 	NOT NULL,
	LOCAL_TX_TIMEOUT_ST		varchar2(32) 	NOT NULL
);

ALTER TABLE WSLOCALTXTEST ADD constraint PK_WS_LOCAL_TX
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSLOCALTXTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSLOCALTXTEST_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	LOCAL_TX_BEGUN_MIN		number(20,4) 	NOT NULL,
	LOCAL_TX_BEGUN_MAX		number(20,4) 	NOT NULL,
	LOCAL_TX_BEGUN_STCNT		varchar2(32) 	NOT NULL,
	ACTIVE_LOCAL_TX_MIN		number(20,4) 	NOT NULL,
	ACTIVE_LOCAL_TX_MAX		number(20,4) 	NOT NULL,
	ACTIVE_LOCAL_TX_STCNT		varchar2(32) 	NOT NULL,
	LOCAL_TX_DURA_MIN		number(20,4) 	NOT NULL,
	LOCAL_TX_DURA_MAX		number(20,4) 	NOT NULL,
	LOCAL_TX_DURA_STCNT		varchar2(32) 	NOT NULL,
	LOCAL_COMMIT_DURA_MIN	number(20,4) 	NOT NULL,
	LOCAL_COMMIT_DURA_MAX	number(20,4) 	NOT NULL,
	LOCAL_COMMIT_DURA_STCNT	varchar2(32) 	NOT NULL,
	LOCAL_TX_COMMITTED_MIN		number(20,4) 	NOT NULL,
	LOCAL_TX_COMMITTED_MAX		number(20,4) 	NOT NULL,
	LOCAL_TX_COMMITTED_STCNT	varchar2(32) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MIN	number(20,4) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MAX	number(20,4) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_STCNT	varchar2(32) 	NOT NULL,
	LOCAL_TX_TIMEOUT_MIN		number(20,4) 	NOT NULL,
	LOCAL_TX_TIMEOUT_MAX		number(20,4) 	NOT NULL,
	LOCAL_TX_TIMEOUT_STCNT		varchar2(32) 	NOT NULL
);
	
ALTER TABLE WSLOCALTXTEST_TREND ADD constraint PK_WS_LOCAL_TX_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSLOCALTXTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSLOCALTXTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
        MSMT_TIME_END   		date,
	LOCAL_TX_BEGUN_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_BEGUN_MAX	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_LOCAL_TX_MIN	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_LOCAL_TX_MAX	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_DURA_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_DURA_MAX	VARCHAR2(256)	 	NOT NULL,
	LOCAL_COMMIT_DURA_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCAL_COMMIT_DURA_MAX	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_COMMITTED_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_COMMITTED_MAX	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MAX	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_TIMEOUT_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_TIMEOUT_MAX	VARCHAR2(256)	 	NOT NULL
);
	
ALTER TABLE WSLOCALTXTEST_THRESH ADD constraint PK_WS_LOCAL_TX_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSLOCALTXTEST_THRESH ON WSLOCALTXTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WSSRVLTSESSIONTEST CASCADE CONSTRAINTS;

CREATE TABLE WSSRVLTSESSIONTEST
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	SESSION_CREATION_RATE	number(20,4) 	NOT NULL,
	SESSION_CREATION_RATE_ST	varchar2(32) 	NOT NULL,
	INVALIDATED_SESSIONS	number(20,4) 	NOT NULL,
	INVALIDATED_SESSIONS_ST	varchar2(32) 	NOT NULL,
	SESSION_LIFE_TIME	number(20,4) 	NOT NULL,
	SESSION_LIFE_TIME_ST	varchar2(32) 	NOT NULL,
	ACTIVE_SESSIONS		number(20,4) 	NOT NULL,
	ACTIVE_SESSIONS_ST	varchar2(32) 	NOT NULL,
	LIVE_SESSIONS		number(20,4) 	NOT NULL,
	LIVE_SESSIONS_ST	varchar2(32) 	NOT NULL
);

ALTER TABLE WSSRVLTSESSIONTEST ADD constraint PK_WS_SS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSSRVLTSESSIONTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSSRVLTSESSIONTEST_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	SESSION_CREATION_RATE_MIN		number(20,4) 	NOT NULL,
	SESSION_CREATION_RATE_MAX		number(20,4) 	NOT NULL,
	SESSION_CREATION_RATE_STCNT		varchar2(32) 	NOT NULL,
	INVALIDATED_SESSIONS_MIN	number(20,4) 	NOT NULL,
	INVALIDATED_SESSIONS_MAX	number(20,4) 	NOT NULL,
	INVALIDATED_SESSIONS_STCNT	varchar2(32) 	NOT NULL,
	SESSION_LIFE_TIME_MIN		number(20,4) 	NOT NULL,
	SESSION_LIFE_TIME_MAX		number(20,4) 	NOT NULL,
	SESSION_LIFE_TIME_STCNT		varchar2(32) 	NOT NULL,
	ACTIVE_SESSIONS_MIN		number(20,4) 	NOT NULL,
	ACTIVE_SESSIONS_MAX		number(20,4) 	NOT NULL,
	ACTIVE_SESSIONS_STCNT		varchar2(32) 	NOT NULL,
	LIVE_SESSIONS_MIN		number(20,4) 	NOT NULL,
	LIVE_SESSIONS_MAX		number(20,4) 	NOT NULL,
	LIVE_SESSIONS_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE WSSRVLTSESSIONTEST_TREND ADD constraint PK_WS_SS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSSRVLTSESSIONTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSSRVLTSESSIONTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
        MSMT_TIME_END   		date,
	SESSION_CREATION_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	SESSION_CREATION_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	INVALIDATED_SESSIONS_MIN	VARCHAR2(256)	 	NOT NULL,
	INVALIDATED_SESSIONS_MAX	VARCHAR2(256)	 	NOT NULL,
	SESSION_LIFE_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	SESSION_LIFE_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_SESSIONS_MIN	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_SESSIONS_MAX	VARCHAR2(256)	 	NOT NULL,
	LIVE_SESSIONS_MIN	VARCHAR2(256)	 	NOT NULL,
	LIVE_SESSIONS_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE WSSRVLTSESSIONTEST_THRESH ADD constraint PK_WS_SS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSSRVLTSESSIONTEST_THRESH ON WSSRVLTSESSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WSTEST CASCADE CONSTRAINTS;

CREATE TABLE WSTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	PCT_HEAP_USE 	number(20,4) 	NOT NULL,
	PCT_HEAP_USE_ST	varchar2(32) 	NOT NULL,
	AVAILABILITY 	number(20,4) 	NOT NULL,
	AVAILABILITY_ST	varchar2(32) 	NOT NULL
);

ALTER TABLE WSTEST ADD constraint PK_WS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	PCT_HEAP_USE_MIN	number(20,4) 	NOT NULL,
	PCT_HEAP_USE_MAX	number(20,4) 	NOT NULL,
	PCT_HEAP_USE_STCNT 	varchar2(32) 	NOT NULL,
	AVAILABILITY_MIN	number(20,4) 	NOT NULL,
	AVAILABILITY_MAX	number(20,4) 	NOT NULL,
	AVAILABILITY_STCNT 	varchar2(32) 	NOT NULL
);

ALTER TABLE WSTEST_TREND ADD constraint PK_WS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	PCT_HEAP_USE_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_HEAP_USE_MAX	VARCHAR2(256)	 	NOT NULL,
	AVAILABILITY_MIN	VARCHAR2(256)	 	NOT NULL,
	AVAILABILITY_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE WSTEST_THRESH ADD constraint PK_WS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSTEST_THRESH ON WSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WSTHREADPOOLTEST CASCADE CONSTRAINTS;

CREATE TABLE WSTHREADPOOLTEST
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	THREAD_CREATION_RATE 	number(20,4) 	NOT NULL,
	THREAD_CREATION_RATE_ST	varchar2(32) 	NOT NULL,
	THREAD_DESTROY_RATE 	number(20,4) 	NOT NULL,
	THREAD_DESTROY_RATE_ST	varchar2(32) 	NOT NULL,
	ACTIVE_THREADS 		number(20,4) 	NOT NULL,
	ACTIVE_THREADS_ST	varchar2(32) 	NOT NULL,
	POOL_SIZE 		number(20,4) 	NOT NULL,
	POOL_SIZE_ST		varchar2(32) 	NOT NULL,
	PCT_MAXED		number(20,4) 	NOT NULL,
	PCT_MAXED_ST		varchar2(32) 	NOT NULL
);

ALTER TABLE WSTHREADPOOLTEST ADD constraint PK_WSTHREAD_POOL
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSTHREADPOOLTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSTHREADPOOLTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	THREAD_CREATION_RATE_MIN	number(20,4) 	NOT NULL,
	THREAD_CREATION_RATE_MAX	number(20,4) 	NOT NULL,
	THREAD_CREATION_RATE_STCNT 	varchar2(32) 	NOT NULL,
	THREAD_DESTROY_RATE_MIN		number(20,4) 	NOT NULL,
	THREAD_DESTROY_RATE_MAX		number(20,4) 	NOT NULL,
	THREAD_DESTROY_RATE_STCNT	varchar2(32) 	NOT NULL,
	ACTIVE_THREADS_MIN	number(20,4) 	NOT NULL,
	ACTIVE_THREADS_MAX	number(20,4) 	NOT NULL,
	ACTIVE_THREADS_STCNT	varchar2(32) 	NOT NULL,
	POOL_SIZE_MIN		number(20,4) 	NOT NULL,
	POOL_SIZE_MAX		number(20,4) 	NOT NULL,
	POOL_SIZE_STCNT		varchar2(32) 	NOT NULL,
	PCT_MAXED_MIN		number(20,4) 	NOT NULL,
	PCT_MAXED_MAX		number(20,4) 	NOT NULL,
	PCT_MAXED_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE WSTHREADPOOLTEST_TREND ADD constraint PK_WSTHREAD_POOL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSTHREADPOOLTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSTHREADPOOLTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME      		varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START		date,
        MSMT_TIME_END   	date,
	THREAD_CREATION_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	THREAD_CREATION_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	THREAD_DESTROY_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	THREAD_DESTROY_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_THREADS_MIN	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_THREADS_MAX	VARCHAR2(256)	 	NOT NULL,
	POOL_SIZE_MIN	VARCHAR2(256)	 	NOT NULL,
	POOL_SIZE_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_MAXED_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_MAXED_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE WSTHREADPOOLTEST_THRESH ADD constraint PK_WSTHREAD_POOL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSTHREADPOOLTEST_THRESH ON WSTHREADPOOLTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WSWEBAPPSTEST CASCADE CONSTRAINTS;

CREATE TABLE WSWEBAPPSTEST
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	NUM_LOADED_SERVLETS	number(20,4) 	NOT NULL,
	NUM_LOADED_SERVLETS_ST	varchar2(32) 	NOT NULL,
	NUM_RELOADS		number(20,4) 	NOT NULL,
	NUM_RELOADS_ST		varchar2(32) 	NOT NULL,
	REQUEST_RATE		number(20,4) 	NOT NULL,
	REQUEST_RATE_ST		varchar2(32) 	NOT NULL,
	CONCURRENT_REQUESTS	number(20,4) 	NOT NULL,
	CONCURRENT_REQUESTS_ST	varchar2(32) 	NOT NULL,
	RESPONSE_TIME		number(20,4) 	NOT NULL,
	RESPONSE_TIME_ST	varchar2(32) 	NOT NULL,
	NUM_ERRORS		number(20,4) 	NOT NULL,
	NUM_ERRORS_ST		varchar2(32) 	NOT NULL
);

ALTER TABLE WSWEBAPPSTEST ADD constraint PK_WS_WEB_APPS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSWEBAPPSTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSWEBAPPSTEST_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	NUM_LOADED_SERVLETS_MIN		number(20,4) 	NOT NULL,
	NUM_LOADED_SERVLETS_MAX		number(20,4) 	NOT NULL,
	NUM_LOADED_SERVLETS_STCNT	varchar2(32) 	NOT NULL,
	NUM_RELOADS_MIN			number(20,4) 	NOT NULL,
	NUM_RELOADS_MAX			number(20,4) 	NOT NULL,
	NUM_RELOADS_STCNT		varchar2(32) 	NOT NULL,
	REQUEST_RATE_MIN		number(20,4) 	NOT NULL,
	REQUEST_RATE_MAX		number(20,4) 	NOT NULL,
	REQUEST_RATE_STCNT		varchar2(32) 	NOT NULL,
	CONCURRENT_REQUESTS_MIN		number(20,4) 	NOT NULL,
	CONCURRENT_REQUESTS_MAX		number(20,4) 	NOT NULL,
	CONCURRENT_REQUESTS_STCNT	varchar2(32) 	NOT NULL,
	RESPONSE_TIME_MIN		number(20,4) 	NOT NULL,
	RESPONSE_TIME_MAX		number(20,4) 	NOT NULL,
	RESPONSE_TIME_STCNT		varchar2(32) 	NOT NULL,
	NUM_ERRORS_MIN			number(20,4) 	NOT NULL,
	NUM_ERRORS_MAX			number(20,4) 	NOT NULL,
	NUM_ERRORS_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE WSWEBAPPSTEST_TREND ADD constraint PK_WS_WEB_APPS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSWEBAPPSTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSWEBAPPSTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
        MSMT_TIME_END   		date,
	NUM_LOADED_SERVLETS_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_LOADED_SERVLETS_MAX	VARCHAR2(256)	 	NOT NULL,
	NUM_RELOADS_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_RELOADS_MAX	VARCHAR2(256)	 	NOT NULL,
	REQUEST_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	REQUEST_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	CONCURRENT_REQUESTS_MIN	VARCHAR2(256)	 	NOT NULL,
	CONCURRENT_REQUESTS_MAX	VARCHAR2(256)	 	NOT NULL,
	RESPONSE_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	RESPONSE_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	NUM_ERRORS_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_ERRORS_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE WSWEBAPPSTEST_THRESH ADD constraint PK_WS_WEB_APPS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSWEBAPPSTEST_THRESH ON WSWEBAPPSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE XChgCacheTest CASCADE CONSTRAINTS;

CREATE TABLE XChgCacheTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	cacheHitRatio			number(20,4) not null,
	cacheHitRatio_ST		varchar2(32) not null
);

ALTER TABLE XChgCacheTest ADD constraint PK_XChgCacheTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   XChgCacheTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE XChgCacheTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	cacheHitRatio_min		number(20,4) not null,
	cacheHitRatio_max		number(20,4) not null,
	cacheHitRatio_stcnt		varchar2(32) not null
);

ALTER TABLE XChgCacheTest_TREND ADD constraint PK_XChgCacheTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgCacheTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE XChgCacheTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	CACHEHITRATIO_MIN	VARCHAR2(256)	 NOT NULL,
	CACHEHITRATIO_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE XChgCacheTest_THRESH ADD constraint PK_XChgCacheTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgCacheTest_THRESH ON XChgCacheTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE XChgDBTest CASCADE CONSTRAINTS;

CREATE TABLE XChgDBTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	dbCacheHit			number(20,4) not null,
	dbCacheHit_ST			varchar2(32) not null,
	dbTablesCacheHit		number(20,4) not null,
	dbTablesCacheHit_st		varchar2(32) not null,
	logRecrdWaitingRate		number(20,4) not null,
	logRecrdWaitingRate_st		varchar2(32) not null,
	logThreadWaiting		Number(20,4) not null,
	logThreadWaiting_st		varchar2(32) not null
);

ALTER TABLE XChgDBTest ADD constraint PK_XChgDBTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   XChgDBTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE XChgDBTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	dbCacheHit_min			number(20,4) not null,
	dbCacheHit_max			number(20,4) not null,
	dbCacheHit_stcnt		varchar2(32) not null,
	dbTablesCacheHit_min		number(20,4) not null,
	dbTablesCacheHit_max		number(20,4) not null,
	dbTablesCacheHit_stcnt		varchar2(32) not null,
	logRecrdWaitingRate_min		number(20,4) not null,
	logRecrdWaitingRate_max		number(20,4) not null,
	logRecrdWaitingRate_stcnt	varchar2(32) not null,
	logThreadWaiting_min		Number(20,4) not null,
	logThreadWaiting_max		Number(20,4) not null,
	logThreadWaiting_stcnt		varchar2(32) not null
);

ALTER TABLE XChgDBTest_TREND ADD constraint PK_XChgDBTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgDBTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE XChgDBTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	DBCACHEHIT_MIN	VARCHAR2(256)	 NOT NULL,
	DBCACHEHIT_MAX	VARCHAR2(256)	 NOT NULL,
	DBTABLESCACHEHIT_MIN	VARCHAR2(256)	 NOT NULL,
	DBTABLESCACHEHIT_MAX	VARCHAR2(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MIN	VARCHAR2(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MAX	VARCHAR2(256)	 NOT NULL,
	LOGTHREADWAITING_MIN	VARCHAR2(256)	 NOT NULL,
	LOGTHREADWAITING_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE XChgDBTest_THRESH ADD constraint PK_XChgDBTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgDBTest_THRESH ON XChgDBTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE XChgMailRetrvlTest CASCADE CONSTRAINTS;

CREATE TABLE XChgMailRetrvlTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	currPop3Conn			Number(20,4) not null,
	currPop3Conn_st			varchar2(32) not null,
	currImapConn			Number(20,4) not null,
	currImapConn_st			varchar2(32) not null,
	pop3AuthFailures		Number(20,4) not null,
	pop3AuthFailures_st		varchar2(32) not null,
	imapAuthFailures		Number(20,4) not null,
	imapAuthFailures_st		varchar2(32) not null
);

ALTER TABLE XChgMailRetrvlTest ADD constraint PK_XChgMailRetrvlTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   XChgMailRetrvlTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE XChgMailRetrvlTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	currPop3Conn_min		Number(20,4) not null,
	currPop3Conn_max		Number(20,4) not null,
	currPop3Conn_stcnt		varchar2(32) not null,
	currImapConn_min		Number(20,4) not null,
	currImapConn_max		Number(20,4) not null,
	currImapConn_stcnt		varchar2(32) not null,
	pop3AuthFailures_min		Number(20,4) not null,
	pop3AuthFailures_max		Number(20,4) not null,
	pop3AuthFailures_stcnt		varchar2(32) not null,
	imapAuthFailures_min		Number(20,4) not null,
	imapAuthFailures_max		Number(20,4) not null,
	imapAuthFailures_stcnt		varchar2(32) not null
);

ALTER TABLE XChgMailRetrvlTest_TREND ADD constraint PK_XChgMailRetrvlTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgMailRetrvlTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE XChgMailRetrvlTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	CURRPOP3CONN_MIN	VARCHAR2(256)	 NOT NULL,
	CURRPOP3CONN_MAX	VARCHAR2(256)	 NOT NULL,
	CURRIMAPCONN_MIN	VARCHAR2(256)	 NOT NULL,
	CURRIMAPCONN_MAX	VARCHAR2(256)	 NOT NULL,
	POP3AUTHFAILURES_MIN	VARCHAR2(256)	 NOT NULL,
	POP3AUTHFAILURES_MAX	VARCHAR2(256)	 NOT NULL,
	IMAPAUTHFAILURES_MIN	VARCHAR2(256)	 NOT NULL,
	IMAPAUTHFAILURES_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE XChgMailRetrvlTest_THRESH ADD constraint PK_XChgMailRetrvlTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgMailRetrvlTest_THRESH ON XChgMailRetrvlTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE XChgMailXferTest CASCADE CONSTRAINTS;

CREATE TABLE XChgMailXferTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	localQSize			Number(20,4) not null,
	localQSize_st			varchar2(32) not null,
	remoteQSize			Number(20,4) not null,
	remoteQSize_st			varchar2(32) not null,
	currSmtpConn			Number(20,4) not null,
	currSmtpConn_st			varchar2(32) not null,
	badMailMsgs			Number(20,4) not null,
	badMailMsgs_st			varchar2(32) not null,
	dataRcvdRate			number(20,4) not null,
	dataRcvdRate_st			varchar2(32) not null,
	dataSentRate			number(20,4) not null,
	dataSentRate_st			varchar2(32) not null,
	avgRetryMsgDelvry		number(20,4) not null,
	avgRetryMsgDelvry_st		varchar2(32) not null,
	avgRetryMsgSent			number(20,4) not null,
	avgRetryMsgSent_st		varchar2(32) not null
);

ALTER TABLE XChgMailXferTest ADD constraint PK_XChgMailXferTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   XChgMailXferTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE XChgMailXferTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	localQSize_min			Number(20,4) not null,
	localQSize_max			Number(20,4) not null,
	localQSize_stcnt		varchar2(32) not null,
	remoteQSize_min			Number(20,4) not null,
	remoteQSize_max			Number(20,4) not null,
	remoteQSize_stcnt		varchar2(32) not null,
	currSmtpConn_min		Number(20,4) not null,
	currSmtpConn_max		Number(20,4) not null,
	currSmtpConn_stcnt		varchar2(32) not null,
	badMailMsgs_min			Number(20,4) not null,
	badMailMsgs_max			Number(20,4) not null,
	badMailMsgs_stcnt		varchar2(32) not null,
	dataRcvdRate_min		number(20,4) not null,
	dataRcvdRate_max		number(20,4) not null,
	dataRcvdRate_stcnt		varchar2(32) not null,
	dataSentRate_min		number(20,4) not null,
	dataSentRate_max		number(20,4) not null,
	dataSentRate_stcnt		varchar2(32) not null,
	avgRetryMsgDelvry_min		number(20,4) not null,
	avgRetryMsgDelvry_max		number(20,4) not null,
	avgRetryMsgDelvry_stcnt		varchar2(32) not null,
	avgRetryMsgSent_min		number(20,4) not null,
	avgRetryMsgSent_max		number(20,4) not null,
	avgRetryMsgSent_stcnt		varchar2(32) not null
);

ALTER TABLE XChgMailXferTest_TREND ADD constraint PK_XChgMailXferTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgMailXferTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE XChgMailXferTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	LOCALQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	LOCALQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	REMOTEQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	REMOTEQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	CURRSMTPCONN_MIN	VARCHAR2(256)	 NOT NULL,
	CURRSMTPCONN_MAX	VARCHAR2(256)	 NOT NULL,
	BADMAILMSGS_MIN	VARCHAR2(256)	 NOT NULL,
	BADMAILMSGS_MAX	VARCHAR2(256)	 NOT NULL,
	DATARCVDRATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATARCVDRATE_MAX	VARCHAR2(256)	 NOT NULL,
	DATASENTRATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATASENTRATE_MAX	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MIN	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MAX	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGSENT_MIN	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGSENT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE XChgMailXferTest_THRESH ADD constraint PK_XChgMailXferTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgMailXferTest_THRESH ON XChgMailXferTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE XChgStoreTest CASCADE CONSTRAINTS;

CREATE TABLE XChgStoreTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	currUsers			Number(20,4) not null,
	currUsers_st			varchar2(32) not null,
	mailSendQSize			Number(20,4) not null,
	mailSendQSize_st		varchar2(32) not null,
	mailRcvdQSize			Number(20,4) not null,
	mailRcvdQSize_st		varchar2(32) not null,
	mailSentRate			number(20,4) not null,
	mailSentRate_st			varchar2(32) not null,
	mailOpensRate			number(20,4) not null,
	mailOpensRate_st		varchar2(32) not null,
	folderOpensRate			number(20,4) not null,
	folderOpensRate_st		varchar2(32) not null,
	avgMailDelvryTime			number(20,4) not null,
	avgMailDelvryTime_st		varchar2(32) not null,
	avgMailLocalDelvryTime		number(20,4) not null,
	avgMailLocalDelvryTime_st		varchar2(32) not null
);

ALTER TABLE XChgStoreTest ADD constraint PK_XChgStoreTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   XChgStoreTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE XChgStoreTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	currUsers_min			Number(20,4) not null,
	currUsers_max			Number(20,4) not null,
	currUsers_stcnt			varchar2(32) not null,
	mailSendQSize_min		Number(20,4) not null,
	mailSendQSize_max		Number(20,4) not null,
	mailSendQSize_stcnt		varchar2(32) not null,
	mailRcvdQSize_min		Number(20,4) not null,
	mailRcvdQSize_max		Number(20,4) not null,
	mailRcvdQSize_stcnt		varchar2(32) not null,
	mailSentRate_min		number(20,4) not null,
	mailSentRate_max		number(20,4) not null,
	mailSentRate_stcnt		varchar2(32) not null,
	mailOpensRate_min		number(20,4) not null,
	mailOpensRate_max		number(20,4) not null,
	mailOpensRate_stcnt		varchar2(32) not null,
	folderOpensRate_min		number(20,4) not null,
	folderOpensRate_max		number(20,4) not null,
	folderOpensRate_stcnt		varchar2(32) not null,
	avgMailDelvryTime_min		number(20,4) not null,
	avgMailDelvryTime_max		number(20,4) not null,
	avgMailDelvryTime_stcnt		varchar2(32) not null,
	avgMailLocalDelvryTime_min		number(20,4) not null,
	avgMailLocalDelvryTime_max		number(20,4) not null,
	avgMailLocalDelvryTime_stcnt	varchar2(32) not null
);

ALTER TABLE XChgStoreTest_TREND ADD constraint PK_XChgStoreTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgStoreTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE XChgStoreTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	CURRUSERS_MIN	VARCHAR2(256)	 NOT NULL,
	CURRUSERS_MAX	VARCHAR2(256)	 NOT NULL,
	MAILSENDQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILSENDQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	MAILRCVDQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILRCVDQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	MAILSENTRATE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILSENTRATE_MAX	VARCHAR2(256)	 NOT NULL,
	MAILOPENSRATE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILOPENSRATE_MAX	VARCHAR2(256)	 NOT NULL,
	FOLDEROPENSRATE_MIN	VARCHAR2(256)	 NOT NULL,
	FOLDEROPENSRATE_MAX	VARCHAR2(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MIN	VARCHAR2(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MAX	VARCHAR2(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MIN	VARCHAR2(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE XChgStoreTest_THRESH ADD constraint PK_XChgStoreTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgStoreTest_THRESH ON XChgStoreTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE JRUNTHREADTEST CASCADE CONSTRAINTS;
CREATE TABLE JRUNTHREADTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date ,
	Pct_threads_utilized 		number(20,4) 	NOT NULL,
	Pct_threads_utilized_st 	varchar2(32) 	NOT NULL,
	Waiting_thread_count 		Number(20,4) 	NOT NULL,
	Waiting_thread_count_st		varchar2(32) 	NOT NULL,
	Total_threads_count	 	Number(20,4) 	NOT NULL,
	Total_threads_count_st		 varchar2(32) 	NOT NULL
);

ALTER TABLE JRUNTHREADTEST ADD constraint PK_JRUNTHREADTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME); 

DROP TABLE JRUNTHREADTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE JRUNTHREADTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32) , 
	MSMT_TIME		date ,
	PERIOD 			varchar2(32) ,
	Pct_threads_utilized_MIN	        number(20,4) 	NOT NULL,
	Pct_threads_utilized_MAX	        number(20,4) 	NOT NULL,
	Pct_threads_utilized_STCNT 	varchar2(32) 	NOT NULL,
	Waiting_thread_count_MIN	number(20,4) 	NOT NULL,
	Waiting_thread_count_MAX	number(20,4) 	NOT NULL,
	Waiting_thread_count_STCNT 	varchar2(32) 	NOT NULL,
	Total_threads_count_MIN		number(20,4) 	NOT NULL,
	Total_threads_count_MAX		number(20,4) 	NOT NULL,
	Total_threads_count_STCNT 	varchar2(32) 	NOT NULL
);


ALTER TABLE JRUNTHREADTEST_TREND ADD constraint PK_JRUNTHREADTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JRUNTHREADTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE JRUNTHREADTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32) ,
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32) , 
	MSMT_TIME_START	date ,
        MSMT_TIME_END   date ,
	PCT_THREADS_UTILIZED_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_THREADS_UTILIZED_MAX	VARCHAR2(256)	 	NOT NULL,
	WAITING_THREAD_COUNT_MIN	VARCHAR2(256)	 	NOT NULL,
	WAITING_THREAD_COUNT_MAX	VARCHAR2(256)	 	NOT NULL,
	TOTAL_THREADS_COUNT_MIN	VARCHAR2(256)	 	NOT NULL,
	TOTAL_THREADS_COUNT_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE JRUNTHREADTEST_THRESH ADD constraint PK_JRUNTHREADTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_JRUNTHREADTEST_THRESH ON JRUNTHREADTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE JRUNSERVERTEST CASCADE CONSTRAINTS;

CREATE TABLE JRUNSERVERTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64) ,
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32) , 
	MSMT_TIME 	date ,
	Total_serv_memory 		number(20,4) 	NOT NULL,
	Total_serv_memory_st 	varchar2(32) 	NOT NULL,
	Free_serv_memory 		number(20,4) 	NOT NULL,
	Free_serv_memory_st		varchar2(32) 	NOT NULL,
	Num_active_sessions	 	Number(20,4) 	NOT NULL,
	Num_active_sessions_st		 varchar2(32) 	NOT NULL,
	Num_mem_sessions	 	Number(20,4) 	NOT NULL,
	Num_mem_sessions_st		 varchar2(32) 	NOT NULL
);

ALTER TABLE JRUNSERVERTEST ADD constraint PK_JRUNSERVERTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME); 

DROP TABLE JRUNSERVERTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE JRUNSERVERTEST_TREND 
(
	TRGT_HOST		varchar2(32) ,
	PORT_NO         	varchar2(32) ,
	SITE_NAME       	varchar2(64) ,
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32) , 
	MSMT_TIME		date ,
	PERIOD 			varchar2(32) ,
	Total_serv_memory_MIN	        number(20,4) 	NOT NULL,
	Total_serv_memory_MAX	        number(20,4) 	NOT NULL,
	Total_serv_memory_STCNT 	varchar2(32) 	NOT NULL,
	Free_serv_memory_MIN		number(20,4) 	NOT NULL,
	Free_serv_memory_MAX		number(20,4) 	NOT NULL,
	Free_serv_memory_STCNT 		varchar2(32) 	NOT NULL,
	Num_active_sessions_MIN		number(20,4) 	NOT NULL,
	Num_active_sessions_MAX		number(20,4) 	NOT NULL,
	Num_active_sessions_STCNT 	varchar2(32) 	NOT NULL,
	Num_mem_sessions_MIN		number(20,4) 	NOT NULL,
	Num_mem_sessions_MAX		number(20,4) 	NOT NULL,
	Num_mem_sessions_STCNT 		varchar2(32) 	NOT NULL	
);


ALTER TABLE JRUNSERVERTEST_TREND ADD constraint PK_JRUNSERVERTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JRUNSERVERTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE JRUNSERVERTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32) , 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	TOTAL_SERV_MEMORY_MIN	VARCHAR2(256)	 	NOT NULL,
	TOTAL_SERV_MEMORY_MAX	VARCHAR2(256)	 	NOT NULL,
	FREE_SERV_MEMORY_MIN	VARCHAR2(256)	 	NOT NULL,
	FREE_SERV_MEMORY_MAX	VARCHAR2(256)	 	NOT NULL,
	NUM_ACTIVE_SESSIONS_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_ACTIVE_SESSIONS_MAX	VARCHAR2(256)	 	NOT NULL,
	NUM_MEM_SESSIONS_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_MEM_SESSIONS_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE JRUNSERVERTEST_THRESH ADD constraint PK_JRUNSERVERTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_JRUNSERVERTEST_THRESH ON JRUNSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE JRUNSERVICETEST CASCADE CONSTRAINTS;

CREATE TABLE JRUNSERVICETEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32) , 
	MSMT_TIME 	date,
	Request_rate	number(20,4) NOT NULL,
	Request_rate_st	varchar2(32) NOT NULL,
	Avg_queue_time 		number(20,4) 	NOT NULL,
	Avg_queue_time_st 	varchar2(32) 	NOT NULL,
	Avg_proc_time 		number(20,4) 	NOT NULL,
	Avg_proc_time_st		varchar2(32) 	NOT NULL,
	Avg_response_time	 	number(20,4) 	NOT NULL,
	Avg_response_time_st		 varchar2(32) 	NOT NULL,
	Data_read_rate	 		number(20,4) 	NOT NULL,
	Data_read_rate_st		 varchar2(32) 	NOT NULL,
	Data_write_rate	 		number(20,4) 	NOT NULL,
	Data_write_rate_st		 varchar2(32) 	NOT NULL,
	Delayed_request_count	 	Number(20,4) 	NOT NULL,
	Delayed_request_count_st	 varchar2(32) 	NOT NULL,
	Dropped_request_count	 	Number(20,4) 	NOT NULL,
	Dropped_request_count_st	 varchar2(32) 	NOT NULL
);

ALTER TABLE JRUNSERVICETEST ADD constraint PK_JRUNSERVICETEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME); 

DROP TABLE JRUNSERVICETEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE JRUNSERVICETEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32) , 
	MSMT_TIME		date,
	PERIOD 			varchar2(32) NOT NULL,
	Request_rate_MIN	        number(20,4) 	NOT NULL,
	Request_rate_MAX	        number(20,4) 	NOT NULL,
	Request_rate_STCNT			varchar2(32)	NOT NULL,
	Avg_queue_time_MIN	        number(20,4) 	NOT NULL,
	Avg_queue_time_MAX	        number(20,4) 	NOT NULL,
	Avg_queue_time_STCNT 		varchar2(32) 	NOT NULL,
	Avg_proc_time_MIN		number(20,4) 	NOT NULL,
	Avg_proc_time_MAX		number(20,4) 	NOT NULL,
	Avg_proc_time_STCNT 		varchar2(32) 	NOT NULL,
	Avg_response_time_MIN		number(20,4) 	NOT NULL,
	Avg_response_time_MAX		number(20,4) 	NOT NULL,
	Avg_response_time_STCNT 	varchar2(32) 	NOT NULL,
	Data_read_rate_MIN		number(20,4) 	NOT NULL,
	Data_read_rate_MAX		number(20,4) 	NOT NULL,
	Data_read_rate_STCNT 		varchar2(32) 	NOT NULL,	
	Data_write_rate_MIN		number(20,4) 	NOT NULL,
	Data_write_rate_MAX		number(20,4) 	NOT NULL,
	Data_write_rate_STCNT 		varchar2(32) 	NOT NULL,	
	Delayed_request_count_MIN		number(20,4) 	NOT NULL,
	Delayed_request_count_MAX		number(20,4) 	NOT NULL,
	Delayed_request_count_STCNT 		varchar2(32) 	NOT NULL,
	Dropped_request_count_MIN		number(20,4) 	NOT NULL,
	Dropped_request_count_MAX		number(20,4) 	NOT NULL,
	Dropped_request_count_STCNT 		varchar2(32) 	NOT NULL	
);


ALTER TABLE JRUNSERVICETEST_TREND ADD constraint PK_JRUNSERVICETEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JRUNSERVICETEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE JRUNSERVICETEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32) , 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	REQUEST_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	REQUEST_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	AVG_QUEUE_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	AVG_QUEUE_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	AVG_PROC_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	AVG_PROC_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	AVG_RESPONSE_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	AVG_RESPONSE_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	DATA_READ_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DATA_READ_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DATA_WRITE_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DATA_WRITE_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DELAYED_REQUEST_COUNT_MIN	VARCHAR2(256)	 	NOT NULL,
	DELAYED_REQUEST_COUNT_MAX	VARCHAR2(256)	 	NOT NULL,
	DROPPED_REQUEST_COUNT_MIN	VARCHAR2(256)	 	NOT NULL,
	DROPPED_REQUEST_COUNT_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE JRUNSERVICETEST_THRESH ADD constraint PK_JRUNSERVICETEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_JRUNSERVICETEST_THRESH ON JRUNSERVICETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE PrinterTest CASCADE CONSTRAINTS;
CREATE TABLE PrinterTest
( 	
	TRGT_HOST			varchar2(32),       
	PORT_NO    			varchar2(32),       
	SITE_NAME      			varchar2(64),       
	INFO           			varchar2(128),	
	MSMT_HOST			varchar2(32),	
	MSMT_TIME     			date,
	PRINTER_AVAILABILITY	 	Number(20,4) 	NOT NULL,
	PRINTER_AVAILABILITY_ST 	varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterTest ADD constraint PK_PrinterTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE PrinterTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE PrinterTest_TREND 
( 	
	TRGT_HOST       			varchar2(32),       
	PORT_NO         			varchar2(32),       
	SITE_NAME       			varchar2(64),       
	INFO            			varchar2(128),	
	MSMT_HOST       			varchar2(32),	
	MSMT_TIME       			date,	
	PERIOD       				varchar2(32),
	PRINTER_AVAILABILITY_MIN 		Number(20,4) 	NOT NULL,
	PRINTER_AVAILABILITY_MAX 		Number(20,4) 	NOT NULL,
	PRINTER_AVAILABILITY_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterTest_TREND ADD constraint PK_PrinterTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE PrinterTest_THRESH 
( 	
	TRGT_HOST       			varchar2(32),       
	PORT_NO         			varchar2(32),       
	SITE_NAME       			varchar2(64),       
	INFO            			varchar2(128),	
	MSMT_HOST       			varchar2(32),	
	MSMT_TIME_START 			date,	
	MSMT_TIME_END   			date,
	PRINTER_AVAILABILITY_MIN	VARCHAR2(256)	 	NOT NULL,
	PRINTER_AVAILABILITY_MAX	VARCHAR2(256)	 	NOT NULL
);
ALTER TABLE PrinterTest_THRESH ADD constraint PK_PrinterTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterTest_THRESH ON PrinterTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterCoverTest CASCADE CONSTRAINTS;

CREATE TABLE PrinterCoverTest 
( 	
	TRGT_HOST       		varchar2(32),       
	PORT_NO         		varchar2(32),       
	SITE_NAME       		varchar2(64),       
	INFO            		varchar2(128),	
	MSMT_HOST       		varchar2(32),	
	MSMT_TIME       		date,
	COVER_CLOSED 			Number(20,4) 	NOT NULL,
	COVER_CLOSED_ST 		varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterCoverTest ADD constraint PK_PrinterCoverTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE PrinterCoverTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE PrinterCoverTest_TREND 
( 	
	TRGT_HOST       		varchar2(32),       
	PORT_NO         		varchar2(32),       
	SITE_NAME       		varchar2(64),       
	INFO            		varchar2(128),	
	MSMT_HOST       		varchar2(32),	
	MSMT_TIME       		date,	
	PERIOD       			varchar2(32),
	COVER_CLOSED_MIN 		Number(20,4) 	NOT NULL,
	COVER_CLOSED_MAX 		Number(20,4) 	NOT NULL,
	COVER_CLOSED_STCNT 		varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterCoverTest_TREND ADD constraint PK_PrinterCoverTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterCoverTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE PrinterCoverTest_THRESH 
( 		
	TRGT_HOST       	varchar2(32),       
	PORT_NO        		varchar2(32), 
	SITE_NAME       	varchar2(64), 
	INFO            	varchar2(128),	
	MSMT_HOST     		varchar2(32),	
	MSMT_TIME_START 	date,
	MSMT_TIME_END   	date,
	COVER_CLOSED_MIN	VARCHAR2(256)	 	NOT NULL,
	COVER_CLOSED_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE PrinterCoverTest_THRESH ADD constraint PK_PrinterCoverTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterCoverTest_THRESH ON PrinterCoverTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterErrorTest CASCADE CONSTRAINTS;

CREATE TABLE PrinterErrorTest
( 
	TRGT_HOST       		varchar2(32),    
	PORT_NO         		varchar2(32),     
	SITE_NAME       		varchar2(64),  
	INFO            			varchar2(128),	
	MSMT_HOST			varchar2(32),	
	MSMT_TIME       		date,
	PAPER_AVAILABILITY 	Number(20,4) 	NOT NULL,
	PAPER_AVAILABILITY_ST varchar2(32) 	NOT NULL,
	TONER_CAPACITY 		Number(20,4) 	NOT NULL,
	TONER_CAPACITY_ST 	varchar2(32) 	NOT NULL,
	TONER_AVAILABILITY 	Number(20,4) 	NOT NULL,
	TONER_AVAILABILITY_ST varchar2(32) 	NOT NULL,
	PAPER_FLOW 			Number(20,4) 	NOT NULL,
	PAPER_FLOW_ST 		varchar2(32) 	NOT NULL,
	ON_LINE 				Number(20,4) 	NOT NULL,
	ON_LINE_ST 			varchar2(32) 	NOT NULL,
	DOOR_CLOSED 		Number(20,4) 	NOT NULL,
	DOOR_CLOSED_ST 		varchar2(32) NOT NULL
);
	
ALTER TABLE PrinterErrorTest ADD constraint PK_PrinterErrorTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE PrinterErrorTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE PrinterErrorTest_TREND
( 
	TRGT_HOST       			varchar2(32),  
	PORT_NO         			varchar2(32),       
	SITE_NAME       			varchar2(64),       
	INFO            				varchar2(128),	
	MSMT_HOST       			varchar2(32),	
	MSMT_TIME       			date,	
	PERIOD       				varchar2(32),
	PAPER_AVAILABILITY_MIN 	Number(20,4) 	NOT NULL,
	PAPER_AVAILABILITY_MAX 	Number(20,4) 	NOT NULL,
	PAPER_AVAILABILITY_STCNT 	varchar2(32) 	NOT NULL,
	TONER_CAPACITY_MIN 		Number(20,4) 	NOT NULL,
	TONER_CAPACITY_MAX 		Number(20,4) 	NOT NULL,
	TONER_CAPACITY_STCNT 	varchar2(32) 	NOT NULL,
	TONER_AVAILABILITY_MIN 	Number(20,4) 	NOT NULL,
	TONER_AVAILABILITY_MAX 	Number(20,4) 	NOT NULL,
	TONER_AVAILABILITY_STCNT 	varchar2(32)	NOT NULL,
	PAPER_FLOW_MIN 			Number(20,4) 	NOT NULL,
	PAPER_FLOW_MAX 			Number(20,4) 	NOT NULL,
	PAPER_FLOW_STCNT 		varchar2(32) 	NOT NULL,
	ON_LINE_MIN 				Number(20,4) 	NOT NULL,
	ON_LINE_MAX 				Number(20,4) 	NOT NULL,
	ON_LINE_STCNT 			varchar2(32) 	NOT NULL,
	DOOR_CLOSED_MIN 		Number(20,4) 	NOT NULL,
	DOOR_CLOSED_MAX 		Number(20,4) 	NOT NULL,
	DOOR_CLOSED_STCNT 		varchar2(32) 	NOT NULL
);
	
ALTER TABLE PrinterErrorTest_TREND ADD constraint PK_PrinterErrorTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterErrorTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE PrinterErrorTest_THRESH 
( 	
	TRGT_HOST       			varchar2(32), 
	PORT_NO         			varchar2(32),       
	SITE_NAME       			varchar2(64),	
	INFO            				varchar2(128),	
	MSMT_HOST       			varchar2(32),	
	MSMT_TIME_START 		date,	
	MSMT_TIME_END   			date,
	PAPER_AVAILABILITY_MIN	VARCHAR2(256)	 	NOT NULL,
	PAPER_AVAILABILITY_MAX	VARCHAR2(256)	 	NOT NULL,
	TONER_CAPACITY_MIN	VARCHAR2(256)	 	NOT NULL,
	TONER_CAPACITY_MAX	VARCHAR2(256)		NOT NULL,
	TONER_AVAILABILITY_MIN	VARCHAR2(256)	 	NOT NULL,
	TONER_AVAILABILITY_MAX	VARCHAR2(256)	 	NOT NULL,
	PAPER_FLOW_MIN	VARCHAR2(256)	 	NOT NULL,
	PAPER_FLOW_MAX	VARCHAR2(256)	 	NOT NULL,
	ON_LINE_MIN	VARCHAR2(256)	 	NOT NULL,
	ON_LINE_MAX	VARCHAR2(256)	 	NOT NULL,
	DOOR_CLOSED_MIN	VARCHAR2(256)	 	NOT NULL,
	DOOR_CLOSED_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE PrinterErrorTest_THRESH ADD constraint PK_PrinterErrorTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterErrorTest_THRESH ON PrinterErrorTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterInputTest CASCADE CONSTRAINTS;

CREATE TABLE PrinterInputTest
( 	
	TRGT_HOST       		varchar2(32),   
	PORT_NO         		varchar2(32),      
	SITE_NAME       		varchar2(64),     
	INFO            		varchar2(128),	
	MSMT_HOST       		varchar2(32),	
	MSMT_TIME       		date,
	TRAY_AVAILABILITY 		Number(20,4) 	NOT NULL,
	TRAY_AVAILABILITY_ST		varchar2(32) 	NOT NULL,
	TRAY_IDLE 			Number(20,4) 	NOT NULL,
	TRAY_IDLE_ST 			varchar2(32) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY 	Number(20,4)	NOT NULL,
	TRAY_PAPER_AVAILABILITY_ST 	varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterInputTest ADD constraint PK_PrinterInputTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE PrinterInputTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE PrinterInputTest_TREND 
( 	
	TRGT_HOST       		varchar2(32),   
	PORT_NO         		varchar2(32),   
	SITE_NAME       		varchar2(64),      
	INFO            		varchar2(128),	
	MSMT_HOST      			varchar2(32),	
	MSMT_TIME      			date,	
	PERIOD       			varchar2(32),
	TRAY_AVAILABILITY_MIN 		Number(20,4) 	NOT NULL,
	TRAY_AVAILABILITY_MAX		Number(20,4) 	NOT NULL,
	TRAY_AVAILABILITY_STCNT 	varchar2(32)	NOT NULL,
	TRAY_IDLE_MIN 			Number(20,4) 	NOT NULL,
	TRAY_IDLE_MAX 			Number(20,4) 	NOT NULL,
	TRAY_IDLE_STCNT 		varchar2(32) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY_MIN 	Number(20,4) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY_MAX 	Number(20,4) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY_STCNT 	varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterInputTest_TREND ADD constraint PK_PrinterInputTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterInputTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE PrinterInputTest_THRESH 
( 	
	TRGT_HOST       		varchar2(32),
	PORT_NO         		varchar2(32), 
	SITE_NAME       		varchar2(64),
	INFO           			varchar2(128),
	MSMT_HOST      			varchar2(32),
	MSMT_TIME_START 		date,
	MSMT_TIME_END   		date,
	TRAY_AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
	TRAY_AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL,
	TRAY_IDLE_MIN	VARCHAR2(256)	 NOT NULL,
	TRAY_IDLE_MAX	VARCHAR2(256)	 NOT NULL,
	TRAY_PAPER_AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
	TRAY_PAPER_AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE PrinterInputTest_THRESH ADD constraint PK_PrinterInputTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterInputTest_THRESH ON PrinterInputTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterOutputTest CASCADE CONSTRAINTS;

CREATE TABLE PrinterOutputTest
( 	
	TRGT_HOST       		varchar2(32), 
	PORT_NO         		varchar2(32), 
	SITE_NAME       		varchar2(64),  
	INFO            		varchar2(128),
	MSMT_HOST      			varchar2(32),
	MSMT_TIME      			date,
	OUTPUT_BIN_AVAILABLE 		Number(20,4) 	NOT NULL,
	OUTPUT_BIN_AVAILABLE_ST 	varchar2(32) 	NOT NULL,
	OUTPUT_BIN_IDLE 		Number(20,4) 	NOT NULL,
	OUTPUT_BIN_IDLE_ST 		varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterOutputTest ADD constraint PK_PrinterOutputTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE PrinterOutputTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE PrinterOutputTest_TREND
( 	
	TRGT_HOST       		varchar2(32), 
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO           			varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME       		date,
	PERIOD       			varchar2(32),
	OUTPUT_BIN_AVAILABLE_MIN 	Number(20,4) 	NOT NULL,
	OUTPUT_BIN_AVAILABLE_MAX 	Number(20,4) 	NOT NULL,
	OUTPUT_BIN_AVAILABLE_STCNT	varchar2(32) 	NOT NULL,
	OUTPUT_BIN_IDLE_MIN 		Number(20,4) 	NOT NULL,
	OUTPUT_BIN_IDLE_MAX 		Number(20,4) 	NOT NULL,
	OUTPUT_BIN_IDLE_STCNT 		varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterOutputTest_TREND ADD constraint PK_PrinterOutputTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterOutputTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE PrinterOutputTest_THRESH
( 	
	TRGT_HOST      			varchar2(32),  
	PORT_NO         		varchar2(32),   
	SITE_NAME       		varchar2(64),     
	INFO            		varchar2(128),	
	MSMT_HOST       		varchar2(32),	
	MSMT_TIME_START 		date,	
	MSMT_TIME_END   		date,
	OUTPUT_BIN_AVAILABLE_MIN	VARCHAR2(256)	 NOT NULL,
	OUTPUT_BIN_AVAILABLE_MAX	VARCHAR2(256)	 NOT NULL,
	OUTPUT_BIN_IDLE_MIN	VARCHAR2(256)	 NOT NULL,
	OUTPUT_BIN_IDLE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE PrinterOutputTest_THRESH ADD constraint PK_PrinterOutputTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterOutputTest_THRESH ON PrinterOutputTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterPageCount CASCADE CONSTRAINTS;

CREATE TABLE PrinterPageCount
( 	
	TRGT_HOST       varchar2(32),  
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),   
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PAGES_PRINTED Number(20,4)
	NOT NULL,
	PAGES_PRINTED_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_PrinterPageCount ON PrinterPageCount(MSMT_TIME);
ALTER TABLE PrinterPageCount ADD constraint PK_PrinterPageCount PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE PrinterPageCount_TREND CASCADE CONSTRAINTS;

CREATE TABLE PrinterPageCount_TREND 
( 	
	TRGT_HOST       		varchar2(32), 
	PORT_NO         		varchar2(32), 
	SITE_NAME      	 		varchar2(64), 
	INFO            		varchar2(128),	
	MSMT_HOST       		varchar2(32),	
	MSMT_TIME       		date,
	PERIOD       			varchar2(32),
	PAGES_PRINTED_MIN 		Number(20,4) 	NOT NULL,
	PAGES_PRINTED_MAX 		Number(20,4) 	NOT NULL,
	PAGES_PRINTED_STCNT 		varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterPageCount_TREND ADD constraint PK_PrinterPageCount_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterPageCount_THRESH CASCADE CONSTRAINTS;

CREATE TABLE PrinterPageCount_THRESH 
( 	
	TRGT_HOST       		varchar2(32),  
	PORT_NO        			varchar2(32),   
	SITE_NAME       		varchar2(64),    
	INFO            		varchar2(128),	
	MSMT_HOST       		varchar2(32),	
	MSMT_TIME_START 		date,	
	MSMT_TIME_END   		date,
	PAGES_PRINTED_MIN	VARCHAR2(256)	 NOT NULL,
	PAGES_PRINTED_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE PrinterPageCount_THRESH ADD constraint PK_PrinterPageCount_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterPageCount_THRESH ON PrinterPageCount_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE BackupJobsTest CASCADE CONSTRAINTS;

CREATE TABLE BackupJobsTest
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME       	date,
	ACTIVE_JOB_COUNT 	Number(20,4)   NOT NULL,
	ACTIVE_JOB_COUNT_ST 	varchar2(32) 	NOT NULL,
	FAILED_JOBS_COUNT 	Number(20,4) 	NOT NULL,
	FAILED_JOBS_COUNT_ST 	varchar2(32) 	NOT NULL,
	SUCCESSFUL_JOBS 	Number(20,4) 	NOT NULL,
	SUCCESSFUL_JOBS_ST 	varchar2(32) 	NOT NULL,
	TOTAL_BYTES 		Number(20,4) 	NOT NULL,
	TOTAL_BYTES_ST 		varchar2(32) 	NOT NULL
);

ALTER TABLE BackupJobsTest ADD constraint PK_BackupJobsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE BackupJobsTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE BackupJobsTest_TREND
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO           		varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME       	date,
	PERIOD       		varchar2(32),
	ACTIVE_JOB_COUNT_MIN 	Number(20,4) 	NOT NULL,
	ACTIVE_JOB_COUNT_MAX 	Number(20,4) 	NOT NULL,
	ACTIVE_JOB_COUNT_STCNT 	varchar2(32) 	NOT NULL,
	FAILED_JOBS_COUNT_MIN 	Number(20,4) 	NOT NULL,
	FAILED_JOBS_COUNT_MAX 	Number(20,4) 	NOT NULL,
	FAILED_JOBS_COUNT_STCNT varchar2(32) 	NOT NULL,
	SUCCESSFUL_JOBS_MIN 	Number(20,4) 	NOT NULL,
	SUCCESSFUL_JOBS_MAX 	Number(20,4) 	NOT NULL,
	SUCCESSFUL_JOBS_STCNT 	varchar2(32) 	NOT NULL,
	TOTAL_BYTES_MIN 	Number(20,4) 	NOT NULL,
	TOTAL_BYTES_MAX 	Number(20,4) 	NOT NULL,
	TOTAL_BYTES_STCNT 	varchar2(32) 	NOT NULL
);

ALTER TABLE BackupJobsTest_TREND ADD constraint PK_BackupJobsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE BackupJobsTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE BackupJobsTest_THRESH 
( 	
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME_START 	date,
	MSMT_TIME_END   	date,
	ACTIVE_JOB_COUNT_MIN	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_JOB_COUNT_MAX	VARCHAR2(256)	 	NOT NULL,
	FAILED_JOBS_COUNT_MIN	VARCHAR2(256)	 	NOT NULL,
	FAILED_JOBS_COUNT_MAX	VARCHAR2(256)	 	NOT NULL,
	SUCCESSFUL_JOBS_MIN	VARCHAR2(256)	 	NOT NULL,
	SUCCESSFUL_JOBS_MAX	VARCHAR2(256)	 	NOT NULL,
	TOTAL_BYTES_MIN	VARCHAR2(256)	 	NOT NULL,
	TOTAL_BYTES_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE BackupJobsTest_THRESH ADD constraint PK_BackupJobsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_BackupJobsTest_THRESH ON BackupJobsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE VeritasStatsTest CASCADE CONSTRAINTS;

CREATE TABLE VeritasStatsTest
( 
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO       	  	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME       	date,
	ABORTED_JOBS 		Number(20,4) 	NOT NULL,
	ABORTED_JOBS_ST 	varchar2(32) 	NOT NULL,
	CORRUPTED_OBJECTS 	Number(20,4) 	NOT NULL,
	CORRUPTED_OBJECTS_ST 	varchar2(32) 	NOT NULL,
	ERROR_SKIPPED_OBJECTS 	Number(20,4) 	NOT NULL,
	ERROR_SKIPPED_OBJECTS_ST varchar2(32) 	NOT NULL,
	FAILED_VERIFY_OBJECTS 	Number(20,4) 	NOT NULL,
	FAILED_VERIFY_OBJECTS_ST varchar2(32) 	NOT NULL,
	SKIPPED_OBJECTS 	Number(20,4) 	NOT NULL,
	SKIPPED_OBJECTS_ST 	varchar2(32) 	NOT NULL
);

ALTER TABLE VeritasStatsTest ADD constraint PK_VeritasStatsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE VeritasStatsTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE VeritasStatsTest_TREND
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME      	 	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME       	date,
	PERIOD       		varchar2(32),
	ABORTED_JOBS_MIN 	Number(20,4) 	NOT NULL,
	ABORTED_JOBS_MAX 	Number(20,4) 	NOT NULL,
	ABORTED_JOBS_STCNT 	varchar2(32) 	NOT NULL,
	CORRUPTED_OBJECTS_MIN 	Number(20,4) 	NOT NULL,
	CORRUPTED_OBJECTS_MAX 	Number(20,4) 	NOT NULL,
	CORRUPTED_OBJECTS_STCNT varchar2(32) 	NOT NULL,
	ERROR_SKIPPED_OBJECTS_MIN Number(20,4) NOT NULL,
	ERROR_SKIPPED_OBJECTS_MAX Number(20,4) NOT NULL,
	ERROR_SKIPPED_OBJECTS_STCNT varchar2(32) NOT NULL,
	FAILED_VERIFY_OBJECTS_MIN Number(20,4) NOT NULL,
	FAILED_VERIFY_OBJECTS_MAX Number(20,4) NOT NULL,
	FAILED_VERIFY_OBJECTS_STCNT varchar2(32) NOT NULL,
	SKIPPED_OBJECTS_MIN 	Number(20,4) 	NOT NULL,
	SKIPPED_OBJECTS_MAX 	Number(20,4) 	NOT NULL,
	SKIPPED_OBJECTS_STCNT 	varchar2(32) 	NOT NULL
);

ALTER TABLE VeritasStatsTest_TREND ADD constraint PK_VeritasStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE VeritasStatsTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE VeritasStatsTest_THRESH
( 
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME_START 	date,
	MSMT_TIME_END   	date,
	ABORTED_JOBS_MIN	VARCHAR2(256)	 	NOT NULL,
	ABORTED_JOBS_MAX	VARCHAR2(256)	 	NOT NULL,
	CORRUPTED_OBJECTS_MIN	VARCHAR2(256)	 	NOT NULL,
	CORRUPTED_OBJECTS_MAX	VARCHAR2(256)	 	NOT NULL,
	ERROR_SKIPPED_OBJECTS_MIN	VARCHAR2(256)	 NOT NULL,
	ERROR_SKIPPED_OBJECTS_MAX	VARCHAR2(256)	 NOT NULL,
	FAILED_VERIFY_OBJECTS_MIN	VARCHAR2(256)	 NOT NULL,
	FAILED_VERIFY_OBJECTS_MAX	VARCHAR2(256)	 NOT NULL,
	SKIPPED_OBJECTS_MIN	VARCHAR2(256)	 	NOT NULL,
	SKIPPED_OBJECTS_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE VeritasStatsTest_THRESH ADD constraint PK_VeritasStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_VeritasStatsTest_THRESH ON VeritasStatsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE EventLogTest CASCADE CONSTRAINTS;

CREATE TABLE EventLogTest
( 
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO       	  	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME       	date,
	APP_ERROR_CNT		Number(20,4) 	NOT NULL,
	APP_ERROR_CNT_ST 	varchar2(32) 	NOT NULL,
	APP_INFRM_CNT		Number(20,4)	NOT NULL,
	APP_INFRM_CNT_ST	varchar2(32)	NOT NULL,
	APP_WARNING_CNT		Number(20,4)	NOT NULL,
	APP_WARNING_CNT_ST	varchar2(32)	NOT NULL,
	SYS_ERROR_CNT		Number(20,4)	NOT NULL,
	SYS_ERROR_CNT_ST	varchar2(32)	NOT NULL,
	SYS_INFRM_CNT		Number(20,4)	NOT NULL,
	SYS_INFRM_CNT_ST	varchar2(32)	NOT NULL,
	SYS_WARNING_CNT		Number(20,4)	NOT NULL,
	SYS_WARNING_CNT_ST	varchar2(32)	NOT NULL,
	APP_CRITICAL_CNT	Number(20,4) 	NOT NULL,
	APP_CRITICAL_CNT_ST 	varchar2(32) 	NOT NULL,
	APP_VERBOSE_CNT		Number(20,4)	NOT NULL,
	APP_VERBOSE_CNT_ST	varchar2(32)	NOT NULL,
	SYS_CRITICAL_CNT	Number(20,4)	NOT NULL,
	SYS_CRITICAL_CNT_ST	varchar2(32)	NOT NULL,
	SYS_VERBOSE_CNT		Number(20,4)	NOT NULL,
	SYS_VERBOSE_CNT_ST	varchar2(32)	NOT NULL
);

ALTER TABLE EventLogTest ADD constraint PK_EventLogTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE EventLogTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE EventLogTest_TREND
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME      	 	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME       	date,
	PERIOD       		varchar2(32),
	APP_ERROR_CNT_MIN	Number(20,4) 	NOT NULL,
	APP_ERROR_CNT_MAX	Number(20,4) 	NOT NULL,
	APP_ERROR_CNT_STCNT 	varchar2(32) 	NOT NULL,
	APP_INFRM_CNT_MIN	Number(20,4)	NOT NULL,
	APP_INFRM_CNT_MAX	Number(20,4)	NOT NULL,
	APP_INFRM_CNT_STCNT	varchar2(32)	NOT NULL,
	APP_WARNING_CNT_MIN	Number(20,4)	NOT NULL,
	APP_WARNING_CNT_MAX	Number(20,4)	NOT NULL,
	APP_WARNING_CNT_STCNT	varchar2(32)	NOT NULL,
	SYS_ERROR_CNT_MIN	Number(20,4)	NOT NULL,
	SYS_ERROR_CNT_MAX	Number(20,4)	NOT NULL,
	SYS_ERROR_CNT_STCNT	varchar2(32)	NOT NULL,
	SYS_INFRM_CNT_MIN	Number(20,4)	NOT NULL,
	SYS_INFRM_CNT_MAX	Number(20,4)	NOT NULL,
	SYS_INFRM_CNT_STCNT	varchar2(32)	NOT NULL,
	SYS_WARNING_CNT_MIN	Number(20,4)	NOT NULL,
	SYS_WARNING_CNT_MAX	Number(20,4)	NOT NULL,
	SYS_WARNING_CNT_STCNT	varchar2(32)	NOT NULL,
	APP_CRITICAL_CNT_MIN	Number(20,4) 	NOT NULL,
	APP_CRITICAL_CNT_MAX	Number(20,4) 	NOT NULL,
	APP_CRITICAL_CNT_STCNT 	varchar2(32) 	NOT NULL,
	APP_VERBOSE_CNT_MIN	Number(20,4)	NOT NULL,
	APP_VERBOSE_CNT_MAX	Number(20,4)	NOT NULL,
	APP_VERBOSE_CNT_STCNT	varchar2(32)	NOT NULL,
	SYS_CRITICAL_CNT_MIN	Number(20,4)	NOT NULL,
	SYS_CRITICAL_CNT_MAX	Number(20,4)	NOT NULL,
	SYS_CRITICAL_CNT_STCNT	varchar2(32)	NOT NULL,
	SYS_VERBOSE_CNT_MIN	Number(20,4)	NOT NULL,
	SYS_VERBOSE_CNT_MAX	Number(20,4)	NOT NULL,
	SYS_VERBOSE_CNT_STCNT	varchar2(32)	NOT NULL
);

ALTER TABLE EventLogTest_TREND ADD constraint PK_EventLogTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE EventLogTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE EventLogTest_THRESH
( 
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME_START 	date,
	MSMT_TIME_END   	date,
	APP_ERROR_CNT_MIN	VARCHAR2(256)	 	NOT NULL,
	APP_ERROR_CNT_MAX	VARCHAR2(256)	 	NOT NULL,
	APP_INFRM_CNT_MIN	VARCHAR2(256)		NOT NULL,
	APP_INFRM_CNT_MAX	VARCHAR2(256)		NOT NULL,
	APP_WARNING_CNT_MIN	VARCHAR2(256)		NOT NULL,
	APP_WARNING_CNT_MAX	VARCHAR2(256)		NOT NULL,
	SYS_ERROR_CNT_MIN	VARCHAR2(256)		NOT NULL,
	SYS_ERROR_CNT_MAX	VARCHAR2(256)		NOT NULL,
	SYS_INFRM_CNT_MIN	VARCHAR2(256)		NOT NULL,
	SYS_INFRM_CNT_MAX	VARCHAR2(256)		NOT NULL,
	SYS_WARNING_CNT_MIN	VARCHAR2(256)		NOT NULL,
	SYS_WARNING_CNT_MAX	VARCHAR2(256)		NOT NULL,
	APP_CRITICAL_CNT_MIN	VARCHAR2(256)	 	NOT NULL,
	APP_CRITICAL_CNT_MAX	VARCHAR2(256)	 	NOT NULL,
	APP_VERBOSE_CNT_MIN	VARCHAR2(256)		NOT NULL,
	APP_VERBOSE_CNT_MAX	VARCHAR2(256)		NOT NULL,
	SYS_CRITICAL_CNT_MIN	VARCHAR2(256)		NOT NULL,
	SYS_CRITICAL_CNT_MAX	VARCHAR2(256)		NOT NULL,
	SYS_VERBOSE_CNT_MIN	VARCHAR2(256)		NOT NULL,
	SYS_VERBOSE_CNT_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE EventLogTest_THRESH ADD constraint PK_EventLogTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EventLogTest_THRESH ON EventLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE JavaServerTest CASCADE CONSTRAINTS;

CREATE TABLE JavaServerTest
( 
	TRGT_HOST       varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO       	  	varchar2(128),
	MSMT_HOST      varchar2(32),
	MSMT_TIME       date,
	ACTIVE_THREAD_CNT	Number(20,4) 	NOT NULL,
	ACTIVE_THREAD_CNT_ST 	varchar2(32) 	NOT NULL,
	TOTAL_MEMORY 		Number(20,4)	NOT NULL,
	TOTAL_MEMORY_ST	        varchar2(32)	NOT NULL,
	FREE_MEMORY           	Number(20,4)	NOT NULL,
	FREE_MEMORY_ST	        varchar2(32)	NOT NULL
);

ALTER TABLE JavaServerTest ADD constraint PK_JavaServerTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE JavaServerTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE JavaServerTest_TREND
(
	TRGT_HOST       	varchar2(32),
	PORT_NO             	varchar2(32),
	SITE_NAME      	 	varchar2(64),
	INFO            	        varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME       	date,
	PERIOD       	        varchar2(32),
	ACTIVE_THREAD_CNT_MIN	        Number(20,4) 	NOT NULL,
	ACTIVE_THREAD_CNT_MAX	Number(20,4) 	NOT NULL,
	ACTIVE_THREAD_CNT_STCNT 	varchar2(32) 	NOT NULL,
	TOTAL_MEMORY_MIN	                Number(20,4)	NOT NULL,
	TOTAL_MEMORY_MAX         	Number(20,4)	NOT NULL,
	TOTAL_MEMORY_STCNT	        varchar2(32)	NOT NULL,
	FREE_MEMORY_MIN	                Number(20,4)	NOT NULL,
	FREE_MEMORY_MAX	                Number(20,4)	NOT NULL,
	FREE_MEMORY_STCNT	        varchar2(32)	NOT NULL
);

ALTER TABLE JavaServerTest_TREND ADD constraint PK_JavaServerTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JavaServerTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE JavaServerTest_THRESH
( 
	TRGT_HOST       	varchar2(32),
	PORT_NO               	varchar2(32),
	SITE_NAME       	        varchar2(64),
	INFO            	        varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME_START 	date,
	MSMT_TIME_END   	date,
	ACTIVE_THREAD_CNT_MIN	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_THREAD_CNT_MAX	VARCHAR2(256)	 	NOT NULL,
	TOTAL_MEMORY_MIN	VARCHAR2(256)		NOT NULL,
	TOTAL_MEMORY_MAX	VARCHAR2(256)		NOT NULL,
	FREE_MEMORY_MIN	VARCHAR2(256)		NOT NULL,
	FREE_MEMORY_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE JavaServerTest_THRESH ADD constraint PK_JavaServerTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_JavaServerTest_THRESH ON JavaServerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TcpConnectionTest CASCADE CONSTRAINTS;

CREATE TABLE TcpConnectionTest
( 
	TRGT_HOST      varchar2(32), 
	PORT_NO          varchar2(32),  
	SITE_NAME       varchar2(64),    
	INFO                 varchar2(128),	
	MSMT_HOST      varchar2(32),	
	MSMT_TIME       date,
	AVAILABILITY          Number(20,4) NOT NULL,
	AVAILABILITY_ST     varchar2(32) NOT NULL,
	RESPONSETIME        Number(20,4) NOT NULL,
	RESPONSETIME_ST  varchar2(32) NOT NULL
);

ALTER TABLE TcpConnectionTest ADD constraint PK_TcpConnectionTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE TcpConnectionTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TcpConnectionTest_TREND
(
	TRGT_HOST       varchar2(32),  
	PORT_NO           varchar2(32),  
	SITE_NAME        varchar2(64),
	INFO                  varchar2(128),	
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,	
	PERIOD       	varchar2(32),
	AVAILABILITY_MIN        Number(20,4) NOT NULL,
	AVAILABILITY_MAX       Number(20,4) NOT NULL,
	AVAILABILITY_STCNT    varchar2(32) NOT NULL,
	RESPONSETIME_MIN      Number(20,4) NOT NULL,
	RESPONSETIME_MAX     Number(20,4) NOT NULL,
	RESPONSETIME_STCNT varchar2(32) NOT NULL
);

ALTER TABLE TcpConnectionTest_TREND ADD constraint PK_TcpConnectionTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE TcpConnectionTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TcpConnectionTest_THRESH 
( 
	TRGT_HOST       varchar2(32),
	PORT_NO           varchar2(32),
	SITE_NAME        varchar2(64), 
	INFO                  varchar2(128),	
	MSMT_HOST       varchar2(32),	
	MSMT_TIME_START  date,
	MSMT_TIME_END     date,
	AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
	AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL,
	RESPONSETIME_MIN	VARCHAR2(256)	 NOT NULL,
	RESPONSETIME_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE TcpConnectionTest_THRESH ADD constraint PK_TcpConnectionTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TcpConnectionTest_THRESH ON TcpConnectionTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE ProcessPoolTest CASCADE CONSTRAINTS;

CREATE TABLE ProcessPoolTest
(
	TRGT_HOST       varchar2(32),
	PORT_NO           varchar2(32), 
	SITE_NAME        varchar2(64),  
	INFO                  varchar2(128),	
	MSMT_HOST       varchar2(32),
	MSMT_TIME        date,
	NUMBER_OF_PROCESSES        Number(20,4) NOT NULL,
	NUMBER_OF_PROCESSES_ST   varchar2(32) NOT NULL,
	PERCENTAGE_CPU_UTIL          Number(20,4) NOT NULL,
	PERCENTAGE_CPU_UTIL_ST     varchar2(32) NOT NULL,
	PERCENTAGE_MEM_UTIL          Number(20,4) NOT NULL,
	PERCENTAGE_MEM_UTIL_ST     varchar2(32) NOT NULL
);

ALTER TABLE ProcessPoolTest ADD constraint PK_ProcessPoolTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE ProcessPoolTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE ProcessPoolTest_TREND
( 
	TRGT_HOST       varchar2(32),
	PORT_NO           varchar2(32),
	SITE_NAME        varchar2(64),
	INFO                 varchar2(128),	
	MSMT_HOST      varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	NUMBER_OF_PROCESSES_MIN        Number(20,4) NOT NULL,
	NUMBER_OF_PROCESSES_MAX       Number(20,4) NOT NULL,
	NUMBER_OF_PROCESSES_STCNT   varchar2(32) NOT NULL,
	PERCENTAGE_CPU_UTIL_MIN         Number(20,4) NOT NULL,
	PERCENTAGE_CPU_UTIL_MAX        Number(20,4) NOT NULL,
	PERCENTAGE_CPU_UTIL_STCNT    varchar2(32) NOT NULL,
	PERCENTAGE_MEM_UTIL_MIN        Number(20,4) NOT NULL,
	PERCENTAGE_MEM_UTIL_MAX       Number(20,4) NOT NULL,
	PERCENTAGE_MEM_UTIL_STCNT   varchar2(32) NOT NULL
);

ALTER TABLE ProcessPoolTest_TREND ADD constraint PK_ProcessPoolTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ProcessPoolTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ProcessPoolTest_THRESH
(
	TRGT_HOST      varchar2(32), 
	PORT_NO          varchar2(32), 
	SITE_NAME        varchar2(64),
	INFO                  varchar2(128),
	MSMT_HOST       varchar2(32),	
	MSMT_TIME_START  date,
	MSMT_TIME_END     date,
	NUMBER_OF_PROCESSES_MIN	VARCHAR2(256)	 NOT NULL,
	NUMBER_OF_PROCESSES_MAX	VARCHAR2(256)	 NOT NULL,
	PERCENTAGE_CPU_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
	PERCENTAGE_CPU_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
	PERCENTAGE_MEM_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
	PERCENTAGE_MEM_UTIL_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE ProcessPoolTest_THRESH ADD constraint PK_ProcessPoolTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ProcessPoolTest_THRESH ON ProcessPoolTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE ErrorLogTest CASCADE CONSTRAINTS;

CREATE TABLE ErrorLogTest
(
 	TRGT_HOST       varchar2(32), 
    PORT_NO         varchar2(32),    
    SITE_NAME       varchar2(64),  
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
    NUMBER_EXCEPTION_COUNT Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_ST varchar2(32) NOT NULL
);

ALTER TABLE ErrorLogTest ADD constraint PK_ErrorLogTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE ErrorLogTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE ErrorLogTest_TREND
(
 	TRGT_HOST       varchar2(32),   
    PORT_NO         varchar2(32),  
    SITE_NAME       varchar2(64),  
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
    NUMBER_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL
);

ALTER TABLE ErrorLogTest_TREND ADD constraint PK_ErrorLogTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ErrorLogTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ErrorLogTest_THRESH
( 
	TRGT_HOST       varchar2(32), 
    PORT_NO         varchar2(32), 
    SITE_NAME       varchar2(64), 
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
    NUMBER_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE ErrorLogTest_THRESH ADD constraint PK_ErrorLogTest_THRESH
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ErrorLogTest_THRESH ON ErrorLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsgLogTest CASCADE CONSTRAINTS;

CREATE TABLE MsgLogTest
(
 	TRGT_HOST       varchar2(32),  
    PORT_NO         varchar2(32),   
    SITE_NAME       varchar2(64),  
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
    NUMBER_EXCEPTION_COUNT Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_ST varchar2(32) NOT NULL,
    HIGH_EXCEPTION_COUNT Number(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_ST varchar2(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT Number(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_ST varchar2(32) NOT NULL,
    LOW_EXCEPTION_COUNT Number(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_ST varchar2(32) NOT NULL
);

ALTER TABLE MsgLogTest ADD constraint PK_MsgLogTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE MsgLogTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MsgLogTest_TREND
(
 	TRGT_HOST       varchar2(32),   
    PORT_NO         varchar2(32),
    SITE_NAME       varchar2(64),  
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
    NUMBER_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL,
    LOW_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MsgLogTest_TREND ADD constraint PK_MsgLogTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MsgLogTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MsgLogTest_THRESH
(
 	TRGT_HOST       varchar2(32), 
    PORT_NO         varchar2(32), 
    SITE_NAME       varchar2(64), 
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
    NUMBER_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE MsgLogTest_THRESH ADD constraint PK_MsgLogTest_THRESH
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsgLogTest_THRESH ON MsgLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE XceptionLogTest CASCADE CONSTRAINTS;

CREATE TABLE XceptionLogTest
(
 	TRGT_HOST       varchar2(32), 
    PORT_NO         varchar2(32),  
    SITE_NAME       varchar2(64), 
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
    NUMBER_EXCEPTION_COUNT Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_ST varchar2(32) NOT NULL,
    HIGH_EXCEPTION_COUNT Number(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_ST varchar2(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT Number(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_ST varchar2(32) NOT NULL,
    LOW_EXCEPTION_COUNT Number(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_ST varchar2(32) NOT NULL
);

ALTER TABLE XceptionLogTest ADD constraint PK_XceptionLogTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE XceptionLogTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE XceptionLogTest_TREND 
( 
	TRGT_HOST       varchar2(32), 
    PORT_NO         varchar2(32),  
    SITE_NAME       varchar2(64),   
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
    NUMBER_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL,
    LOW_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL, 
    LOW_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL
);

ALTER TABLE XceptionLogTest_TREND ADD constraint PK_XceptionLogTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE XceptionLogTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE XceptionLogTest_THRESH
(
 	TRGT_HOST       varchar2(32), 
    PORT_NO         varchar2(32), 
    SITE_NAME       varchar2(64),  
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
    NUMBER_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE XceptionLogTest_THRESH ADD constraint PK_XceptionLogTest_THRESH
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_XceptionLogTest_THRESH ON XceptionLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE CiscoCatalystTest CASCADE CONSTRAINTS;

CREATE TABLE CiscoCatalystTest (
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
DATA_RECVD_RATE Number(20,4) NOT NULL,
DATA_RECVD_RATE_ST varchar2(32) NOT NULL,
DATA_XMIT_RATE Number(20,4) NOT NULL,
DATA_XMIT_RATE_ST varchar2(32) NOT NULL,
PCT_BANDWIDTH_USED Number(20,4) NOT NULL,
PCT_BANDWIDTH_USED_ST varchar2(32) NOT NULL);

ALTER TABLE CiscoCatalystTest ADD constraint PK_CiscoCatalystTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE CiscoCatalystTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE CiscoCatalystTest_TREND ( 	
TRGT_HOST       varchar2(32),       
PORT_NO         varchar2(32),       
SITE_NAME       varchar2(64),       
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,	
PERIOD       	varchar2(32),
DATA_RECVD_RATE_MIN Number(20,4) NOT NULL,
DATA_RECVD_RATE_MAX Number(20,4) NOT NULL,
DATA_RECVD_RATE_STCNT varchar2(32) NOT NULL,
DATA_XMIT_RATE_MIN Number(20,4) NOT NULL,
DATA_XMIT_RATE_MAX Number(20,4) NOT NULL,
DATA_XMIT_RATE_STCNT varchar2(32) NOT NULL,
PCT_BANDWIDTH_USED_MIN Number(20,4) NOT NULL,
PCT_BANDWIDTH_USED_MAX Number(20,4) NOT NULL,
PCT_BANDWIDTH_USED_STCNT varchar2(32) NOT NULL);

ALTER TABLE CiscoCatalystTest_TREND ADD constraint PK_CiscoCatalystTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE CiscoCatalystTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE CiscoCatalystTest_THRESH ( 	
TRGT_HOST       varchar2(32),       
PORT_NO         varchar2(32),       
SITE_NAME       varchar2(64),       
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME_START date,	
MSMT_TIME_END   date,
DATA_RECVD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
DATA_RECVD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
DATA_XMIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
DATA_XMIT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
PCT_BANDWIDTH_USED_MIN	VARCHAR2(256)	 NOT NULL,
PCT_BANDWIDTH_USED_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CiscoCatalystTest_THRESH ADD constraint PK_CiscoCatalystTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_CiscoCatalystTest_THRESH ON CiscoCatalystTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE TuxARTimeTest CASCADE CONSTRAINTS;

CREATE TABLE TuxARTimeTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
AVAILABILITY NUMBER(20,4) NOT NULL,
AVAILABILITY_ST varchar2(32) NOT NULL,
RESPONSE_TIME Number(20,4) NOT NULL,
RESPONSE_TIME_ST varchar2(32) NOT NULL);

ALTER TABLE TuxARTimeTest ADD constraint PK_TuxARTimeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxARTimeTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxARTimeTest_TREND ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AVAILABILITY_MIN NUMBER(20,4) NOT NULL,
AVAILABILITY_MAX NUMBER(20,4) NOT NULL,
AVAILABILITY_STCNT varchar2(32) NOT NULL,
RESPONSE_TIME_MIN Number(20,4) NOT NULL,
RESPONSE_TIME_MAX Number(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxARTimeTest_TREND ADD constraint PK_TuxARTimeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxARTimeTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxARTimeTest_THRESH ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL,
RESPONSE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
RESPONSE_TIME_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxARTimeTest_THRESH ADD constraint PK_TuxARTimeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxARTimeTest_THRESH ON TuxARTimeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE TuxBridgeTest CASCADE CONSTRAINTS;

CREATE TABLE TuxBridgeTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
BRIDGE_STATE Number(20,4) NOT NULL,
BRIDGE_STATE_ST varchar2(32) NOT NULL,
BYT_RCVD_RATE NUMBER(20,4) NOT NULL,
BYT_RCVD_RATE_ST varchar2(32) NOT NULL,
BYT_SENT_RATE NUMBER(20,4) NOT NULL,
BYT_SENT_RATE_ST varchar2(32) NOT NULL,
MSG_RCVD_RATE NUMBER(20,4) NOT NULL,
MSG_RCVD_RATE_ST varchar2(32) NOT NULL,
MSG_SENT_RATE NUMBER(20,4) NOT NULL,
MSG_SENT_RATE_ST varchar2(32) NOT NULL);

ALTER TABLE TuxBridgeTest ADD constraint PK_TuxBridgeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxBridgeTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxBridgeTest_TREND ( 	TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
BRIDGE_STATE_MIN Number(20,4) NOT NULL,
BRIDGE_STATE_MAX Number(20,4) NOT NULL,
BRIDGE_STATE_STCNT varchar2(32) NOT NULL,
BYT_RCVD_RATE_MIN NUMBER(20,4) NOT NULL,
BYT_RCVD_RATE_MAX NUMBER(20,4) NOT NULL,
BYT_RCVD_RATE_STCNT varchar2(32) NOT NULL,
BYT_SENT_RATE_MIN NUMBER(20,4) NOT NULL,
BYT_SENT_RATE_MAX NUMBER(20,4) NOT NULL,
BYT_SENT_RATE_STCNT varchar2(32) NOT NULL,
MSG_RCVD_RATE_MIN NUMBER(20,4) NOT NULL,
MSG_RCVD_RATE_MAX NUMBER(20,4) NOT NULL,
MSG_RCVD_RATE_STCNT varchar2(32) NOT NULL,
MSG_SENT_RATE_MIN NUMBER(20,4) NOT NULL,
MSG_SENT_RATE_MAX NUMBER(20,4) NOT NULL,
MSG_SENT_RATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxBridgeTest_TREND ADD constraint PK_TuxBridgeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxBridgeTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxBridgeTest_THRESH ( 	TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
BRIDGE_STATE_MIN	VARCHAR2(256)	 NOT NULL,
BRIDGE_STATE_MAX	VARCHAR2(256)	 NOT NULL,
BYT_RCVD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
BYT_RCVD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
BYT_SENT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
BYT_SENT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
MSG_RCVD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
MSG_RCVD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
MSG_SENT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
MSG_SENT_RATE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxBridgeTest_THRESH ADD constraint PK_TuxBridgeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxBridgeTest_THRESH ON TuxBridgeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE TuxDomainTest CASCADE CONSTRAINTS;

CREATE TABLE TuxDomainTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CURR_MACS Number(20,4) NOT NULL,
CURR_MACS_ST varchar2(32) NOT NULL,
CURR_SERVERS Number(20,4) NOT NULL,
CURR_SERVERS_ST varchar2(32) NOT NULL,
CURR_QS Number(20,4) NOT NULL,
CURR_QS_ST varchar2(32) NOT NULL,
CURR_SERVICES Number(20,4) NOT NULL,
CURR_SERVICES_ST varchar2(32) NOT NULL,
MAC_PCT_UTIL NUMBER(20,4) NOT NULL,
MAC_PCT_UTIL_ST varchar2(32) NOT NULL,
SERVER_PCT_UTIL NUMBER(20,4) NOT NULL,
SERVER_PCT_UTIL_ST varchar2(32) NOT NULL,
Q_PCT_UTIL NUMBER(20,4) NOT NULL,
Q_PCT_UTIL_ST varchar2(32) NOT NULL,
SERVICE_PCT_UTIL NUMBER(20,4) NOT NULL,
SERVICE_PCT_UTIL_ST varchar2(32) NOT NULL);

ALTER TABLE TuxDomainTest ADD constraint PK_TuxDomainTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxDomainTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxDomainTest_TREND ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CURR_MACS_MIN Number(20,4) NOT NULL,
CURR_MACS_MAX Number(20,4) NOT NULL,
CURR_MACS_STCNT varchar2(32) NOT NULL,
CURR_SERVERS_MIN Number(20,4) NOT NULL,
CURR_SERVERS_MAX Number(20,4) NOT NULL,
CURR_SERVERS_STCNT varchar2(32) NOT NULL,
CURR_QS_MIN Number(20,4) NOT NULL,
CURR_QS_MAX Number(20,4) NOT NULL,
CURR_QS_STCNT varchar2(32) NOT NULL,
CURR_SERVICES_MIN Number(20,4) NOT NULL,
CURR_SERVICES_MAX Number(20,4) NOT NULL,
CURR_SERVICES_STCNT varchar2(32) NOT NULL,
MAC_PCT_UTIL_MIN NUMBER(20,4) NOT NULL,
MAC_PCT_UTIL_MAX NUMBER(20,4) NOT NULL,
MAC_PCT_UTIL_STCNT varchar2(32) NOT NULL,
SERVER_PCT_UTIL_MIN NUMBER(20,4) NOT NULL,
SERVER_PCT_UTIL_MAX NUMBER(20,4) NOT NULL,
SERVER_PCT_UTIL_STCNT varchar2(32) NOT NULL,
Q_PCT_UTIL_MIN NUMBER(20,4) NOT NULL,
Q_PCT_UTIL_MAX NUMBER(20,4) NOT NULL,
Q_PCT_UTIL_STCNT varchar2(32) NOT NULL,
SERVICE_PCT_UTIL_MIN NUMBER(20,4) NOT NULL,
SERVICE_PCT_UTIL_MAX NUMBER(20,4) NOT NULL,
SERVICE_PCT_UTIL_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxDomainTest_TREND ADD constraint PK_TuxDomainTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxDomainTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxDomainTest_THRESH ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CURR_MACS_MIN	VARCHAR2(256)	 NOT NULL,
CURR_MACS_MAX	VARCHAR2(256)	 NOT NULL,
CURR_SERVERS_MIN	VARCHAR2(256)	 NOT NULL,
CURR_SERVERS_MAX	VARCHAR2(256)	 NOT NULL,
CURR_QS_MIN	VARCHAR2(256)	 NOT NULL,
CURR_QS_MAX	VARCHAR2(256)	 NOT NULL,
CURR_SERVICES_MIN	VARCHAR2(256)	 NOT NULL,
CURR_SERVICES_MAX	VARCHAR2(256)	 NOT NULL,
MAC_PCT_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
MAC_PCT_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
SERVER_PCT_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
SERVER_PCT_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
Q_PCT_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
Q_PCT_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
SERVICE_PCT_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
SERVICE_PCT_UTIL_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxDomainTest_THRESH ADD constraint PK_TuxDomainTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxDomainTest_THRESH ON TuxDomainTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxProcsTest CASCADE CONSTRAINTS;

CREATE TABLE TuxProcsTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NUM_OF_PROCS Number(20,4) NOT NULL,
NUM_OF_PROCS_ST varchar2(32) NOT NULL,
CPU_UTIL_PCT NUMBER(20,4) NOT NULL,
CPU_UTIL_PCT_ST varchar2(32) NOT NULL,
MEM_UTIL_PCT NUMBER(20,4) NOT NULL,
MEM_UTIL_PCT_ST varchar2(32) NOT NULL);

ALTER TABLE TuxProcsTest ADD constraint PK_TuxProcsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxProcsTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxProcsTest_TREND ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NUM_OF_PROCS_MIN Number(20,4) NOT NULL,
NUM_OF_PROCS_MAX Number(20,4) NOT NULL,
NUM_OF_PROCS_STCNT varchar2(32) NOT NULL,
CPU_UTIL_PCT_MIN NUMBER(20,4) NOT NULL,
CPU_UTIL_PCT_MAX NUMBER(20,4) NOT NULL,
CPU_UTIL_PCT_STCNT varchar2(32) NOT NULL,
MEM_UTIL_PCT_MIN NUMBER(20,4) NOT NULL,
MEM_UTIL_PCT_MAX NUMBER(20,4) NOT NULL,
MEM_UTIL_PCT_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxProcsTest_TREND ADD constraint PK_TuxProcsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxProcsTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxProcsTest_THRESH ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NUM_OF_PROCS_MIN	VARCHAR2(256)	 NOT NULL,
NUM_OF_PROCS_MAX	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_PCT_MIN	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_PCT_MAX	VARCHAR2(256)	 NOT NULL,
MEM_UTIL_PCT_MIN	VARCHAR2(256)	 NOT NULL,
MEM_UTIL_PCT_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxProcsTest_THRESH ADD constraint PK_TuxProcsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxProcsTest_THRESH ON TuxProcsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxServerTest CASCADE CONSTRAINTS;

CREATE TABLE TuxServerTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SERVER_STATE Number(20,4) NOT NULL,
SERVER_STATE_ST varchar2(32) NOT NULL,
TOTWRKLC_RATE NUMBER(20,4) NOT NULL,
TOTWRKLC_RATE_ST varchar2(32) NOT NULL,
TOTAL_CONV Number(20,4) NOT NULL,
TOTAL_CONV_ST varchar2(32) NOT NULL,
CURR_ACTIVE_CONV Number(20,4) NOT NULL,
CURR_ACTIVE_CONV_ST varchar2(32) NOT NULL,
TOTAL_REQ Number(20,4) NOT NULL,
TOTAL_REQ_ST varchar2(32) NOT NULL,
CURR_ACTIVE_REQ Number(20,4) NOT NULL,
CURR_ACTIVE_REQ_ST varchar2(32) NOT NULL,
TRAN_INIT_RATE NUMBER(20,4) NOT NULL,
TRAN_INIT_RATE_ST varchar2(32) NOT NULL,
TRAN_ABT_RATE NUMBER(20,4) NOT NULL,
TRAN_ABT_RATE_ST varchar2(32) NOT NULL,
TRAN_CMT_RATE NUMBER(20,4) NOT NULL,
TRAN_CMT_RATE_ST varchar2(32) NOT NULL,
TOTREQC_RATE NUMBER(20,4) NOT NULL,
TOTREQC_RATE_ST varchar2(32) NOT NULL);

ALTER TABLE TuxServerTest ADD constraint PK_TuxServerTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxServerTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxServerTest_TREND ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SERVER_STATE_MIN Number(20,4) NOT NULL,
SERVER_STATE_MAX Number(20,4) NOT NULL,
SERVER_STATE_STCNT varchar2(32) NOT NULL,
TOTWRKLC_RATE_MIN NUMBER(20,4) NOT NULL,
TOTWRKLC_RATE_MAX NUMBER(20,4) NOT NULL,
TOTWRKLC_RATE_STCNT varchar2(32) NOT NULL,
TOTAL_CONV_MIN Number(20,4) NOT NULL,
TOTAL_CONV_MAX Number(20,4) NOT NULL,
TOTAL_CONV_STCNT varchar2(32) NOT NULL,
CURR_ACTIVE_CONV_MIN Number(20,4) NOT NULL,
CURR_ACTIVE_CONV_MAX Number(20,4) NOT NULL,
CURR_ACTIVE_CONV_STCNT varchar2(32) NOT NULL,
TOTAL_REQ_MIN Number(20,4) NOT NULL,
TOTAL_REQ_MAX Number(20,4) NOT NULL,
TOTAL_REQ_STCNT varchar2(32) NOT NULL,
CURR_ACTIVE_REQ_MIN Number(20,4) NOT NULL,
CURR_ACTIVE_REQ_MAX Number(20,4) NOT NULL,
CURR_ACTIVE_REQ_STCNT varchar2(32) NOT NULL,
TRAN_INIT_RATE_MIN NUMBER(20,4) NOT NULL,
TRAN_INIT_RATE_MAX NUMBER(20,4) NOT NULL,
TRAN_INIT_RATE_STCNT varchar2(32) NOT NULL,
TRAN_ABT_RATE_MIN NUMBER(20,4) NOT NULL,
TRAN_ABT_RATE_MAX NUMBER(20,4) NOT NULL,
TRAN_ABT_RATE_STCNT varchar2(32) NOT NULL,
TRAN_CMT_RATE_MIN NUMBER(20,4) NOT NULL,
TRAN_CMT_RATE_MAX NUMBER(20,4) NOT NULL,
TRAN_CMT_RATE_STCNT varchar2(32) NOT NULL,
TOTREQC_RATE_MIN NUMBER(20,4) NOT NULL,
TOTREQC_RATE_MAX NUMBER(20,4) NOT NULL,
TOTREQC_RATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxServerTest_TREND ADD constraint PK_TuxServerTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxServerTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxServerTest_THRESH ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SERVER_STATE_MIN	VARCHAR2(256)	 NOT NULL,
SERVER_STATE_MAX	VARCHAR2(256)	 NOT NULL,
TOTWRKLC_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TOTWRKLC_RATE_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_CONV_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_CONV_MAX	VARCHAR2(256)	 NOT NULL,
CURR_ACTIVE_CONV_MIN	VARCHAR2(256)	 NOT NULL,
CURR_ACTIVE_CONV_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_REQ_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_REQ_MAX	VARCHAR2(256)	 NOT NULL,
CURR_ACTIVE_REQ_MIN	VARCHAR2(256)	 NOT NULL,
CURR_ACTIVE_REQ_MAX	VARCHAR2(256)	 NOT NULL,
TRAN_INIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TRAN_INIT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
TRAN_ABT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TRAN_ABT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
TRAN_CMT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TRAN_CMT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
TOTREQC_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TOTREQC_RATE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxServerTest_THRESH ADD constraint PK_TuxServerTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxServerTest_THRESH ON TuxServerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxServiceTest CASCADE CONSTRAINTS;

CREATE TABLE TuxServiceTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SERVICE_STATE Number(20,4) NOT NULL,
SERVICE_STATE_ST varchar2(32) NOT NULL,
LD_IMPOSED Number(20,4) NOT NULL,
LD_IMPOSED_ST varchar2(32) NOT NULL,
REQ_COMPLTD_RATE NUMBER(20,4) NOT NULL,
REQ_COMPLTD_RATE_ST varchar2(32) NOT NULL,
REQ_CURR_QUD Number(20,4) NOT NULL,
REQ_CURR_QUD_ST varchar2(32) NOT NULL);

ALTER TABLE TuxServiceTest ADD constraint PK_TuxServiceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxServiceTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxServiceTest_TREND ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SERVICE_STATE_MIN Number(20,4) NOT NULL,
SERVICE_STATE_MAX Number(20,4) NOT NULL,
SERVICE_STATE_STCNT varchar2(32) NOT NULL,
LD_IMPOSED_MIN Number(20,4) NOT NULL,
LD_IMPOSED_MAX Number(20,4) NOT NULL,
LD_IMPOSED_STCNT varchar2(32) NOT NULL,
REQ_COMPLTD_RATE_MIN NUMBER(20,4) NOT NULL,
REQ_COMPLTD_RATE_MAX NUMBER(20,4) NOT NULL,
REQ_COMPLTD_RATE_STCNT varchar2(32) NOT NULL,
REQ_CURR_QUD_MIN Number(20,4) NOT NULL,
REQ_CURR_QUD_MAX Number(20,4) NOT NULL,
REQ_CURR_QUD_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxServiceTest_TREND ADD constraint PK_TuxServiceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxServiceTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxServiceTest_THRESH ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SERVICE_STATE_MIN	VARCHAR2(256)	 NOT NULL,
SERVICE_STATE_MAX	VARCHAR2(256)	 NOT NULL,
LD_IMPOSED_MIN	VARCHAR2(256)	 NOT NULL,
LD_IMPOSED_MAX	VARCHAR2(256)	 NOT NULL,
REQ_COMPLTD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQ_COMPLTD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
REQ_CURR_QUD_MIN	VARCHAR2(256)	 NOT NULL,
REQ_CURR_QUD_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxServiceTest_THRESH ADD constraint PK_TuxServiceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxServiceTest_THRESH ON TuxServiceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxSiteTest CASCADE CONSTRAINTS;

CREATE TABLE TuxSiteTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SITE_STATE Number(20,4) NOT NULL,
SITE_STATE_ST varchar2(32) NOT NULL,
TRAN_ABT_RATE NUMBER(20,4) NOT NULL,
TRAN_ABT_RATE_ST varchar2(32) NOT NULL,
TRAN_CMT_RATE NUMBER(20,4) NOT NULL,
TRAN_CMT_RATE_ST varchar2(32) NOT NULL,
TLISTEN_STATE Number(20,4) NOT NULL,
TLISTEN_STATE_ST varchar2(32) NOT NULL,
CURR_CLTS Number(20,4) NOT NULL,
CURR_CLTS_ST varchar2(32) NOT NULL,
CUR_WS_CLTS Number(20,4) NOT NULL,
CUR_WS_CLTS_ST varchar2(32) NOT NULL,
CURR_CONV Number(20,4) NOT NULL,
CURR_CONV_ST varchar2(32) NOT NULL,
CURR_GT Number(20,4) NOT NULL,
CURR_GT_ST varchar2(32) NOT NULL,
CURR_LOAD_RATE NUMBER(20,4) NOT NULL,
CURR_LOAD_RATE_ST varchar2(32) NOT NULL,
WK_COMPLETED_RATE NUMBER(20,4) NOT NULL,
WK_COMPLETED_RATE_ST varchar2(32) NOT NULL,
WK_INIT_RATE NUMBER(20,4) NOT NULL,
WK_INIT_RATE_ST varchar2(32) NOT NULL,
TRAN_INIT_RATE NUMBER(20,4) NOT NULL,
TRAN_INIT_RATE_ST varchar2(32) NOT NULL);

ALTER TABLE TuxSiteTest ADD constraint PK_TuxSiteTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxSiteTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxSiteTest_TREND ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SITE_STATE_MIN Number(20,4) NOT NULL,
SITE_STATE_MAX Number(20,4) NOT NULL,
SITE_STATE_STCNT varchar2(32) NOT NULL,
TRAN_ABT_RATE_MIN NUMBER(20,4) NOT NULL,
TRAN_ABT_RATE_MAX NUMBER(20,4) NOT NULL,
TRAN_ABT_RATE_STCNT varchar2(32) NOT NULL,
TRAN_CMT_RATE_MIN NUMBER(20,4) NOT NULL,
TRAN_CMT_RATE_MAX NUMBER(20,4) NOT NULL,
TRAN_CMT_RATE_STCNT varchar2(32) NOT NULL,
TLISTEN_STATE_MIN Number(20,4) NOT NULL,
TLISTEN_STATE_MAX Number(20,4) NOT NULL,
TLISTEN_STATE_STCNT varchar2(32) NOT NULL,
CURR_CLTS_MIN Number(20,4) NOT NULL,
CURR_CLTS_MAX Number(20,4) NOT NULL,
CURR_CLTS_STCNT varchar2(32) NOT NULL,
CUR_WS_CLTS_MIN Number(20,4) NOT NULL,
CUR_WS_CLTS_MAX Number(20,4) NOT NULL,
CUR_WS_CLTS_STCNT varchar2(32) NOT NULL,
CURR_CONV_MIN Number(20,4) NOT NULL,
CURR_CONV_MAX Number(20,4) NOT NULL,
CURR_CONV_STCNT varchar2(32) NOT NULL,
CURR_GT_MIN Number(20,4) NOT NULL,
CURR_GT_MAX Number(20,4) NOT NULL,
CURR_GT_STCNT varchar2(32) NOT NULL,
CURR_LOAD_RATE_MIN NUMBER(20,4) NOT NULL,
CURR_LOAD_RATE_MAX NUMBER(20,4) NOT NULL,
CURR_LOAD_RATE_STCNT varchar2(32) NOT NULL,
WK_COMPLETED_RATE_MIN NUMBER(20,4) NOT NULL,
WK_COMPLETED_RATE_MAX NUMBER(20,4) NOT NULL,
WK_COMPLETED_RATE_STCNT varchar2(32) NOT NULL,
WK_INIT_RATE_MIN NUMBER(20,4) NOT NULL,
WK_INIT_RATE_MAX NUMBER(20,4) NOT NULL,
WK_INIT_RATE_STCNT varchar2(32) NOT NULL,
TRAN_INIT_RATE_MIN NUMBER(20,4) NOT NULL,
TRAN_INIT_RATE_MAX NUMBER(20,4) NOT NULL,
TRAN_INIT_RATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxSiteTest_TREND ADD constraint PK_TuxSiteTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxSiteTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxSiteTest_THRESH ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SITE_STATE_MIN	VARCHAR2(256)	 NOT NULL,
SITE_STATE_MAX	VARCHAR2(256)	 NOT NULL,
TRAN_ABT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TRAN_ABT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
TRAN_CMT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TRAN_CMT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
TLISTEN_STATE_MIN	VARCHAR2(256)	 NOT NULL,
TLISTEN_STATE_MAX	VARCHAR2(256)	 NOT NULL,
CURR_CLTS_MIN	VARCHAR2(256)	 NOT NULL,
CURR_CLTS_MAX	VARCHAR2(256)	 NOT NULL,
CUR_WS_CLTS_MIN	VARCHAR2(256)	 NOT NULL,
CUR_WS_CLTS_MAX	VARCHAR2(256)	 NOT NULL,
CURR_CONV_MIN	VARCHAR2(256)	 NOT NULL,
CURR_CONV_MAX	VARCHAR2(256)	 NOT NULL,
CURR_GT_MIN	VARCHAR2(256)	 NOT NULL,
CURR_GT_MAX	VARCHAR2(256)	 NOT NULL,
CURR_LOAD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
CURR_LOAD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
WK_COMPLETED_RATE_MIN	VARCHAR2(256)	 NOT NULL,
WK_COMPLETED_RATE_MAX	VARCHAR2(256)	 NOT NULL,
WK_INIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
WK_INIT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
TRAN_INIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TRAN_INIT_RATE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxSiteTest_THRESH ADD constraint PK_TuxSiteTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxSiteTest_THRESH ON TuxSiteTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxTQueueTest CASCADE CONSTRAINTS;

CREATE TABLE TuxTQueueTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Q_STATE Number(20,4) NOT NULL,
Q_STATE_ST varchar2(32) NOT NULL,
SERVER_CNT Number(20,4) NOT NULL,
SERVER_CNT_ST varchar2(32) NOT NULL,
REQ_CURR_QUD Number(20,4) NOT NULL,
REQ_CURR_QUD_ST varchar2(32) NOT NULL,
WKL_CURR_QUD Number(20,4) NOT NULL,
WKL_CURR_QUD_ST varchar2(32) NOT NULL);

ALTER TABLE TuxTQueueTest ADD constraint PK_TuxTQueueTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxTQueueTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxTQueueTest_TREND ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Q_STATE_MIN Number(20,4) NOT NULL,
Q_STATE_MAX Number(20,4) NOT NULL,
Q_STATE_STCNT varchar2(32) NOT NULL,
SERVER_CNT_MIN Number(20,4) NOT NULL,
SERVER_CNT_MAX Number(20,4) NOT NULL,
SERVER_CNT_STCNT varchar2(32) NOT NULL,
REQ_CURR_QUD_MIN Number(20,4) NOT NULL,
REQ_CURR_QUD_MAX Number(20,4) NOT NULL,
REQ_CURR_QUD_STCNT varchar2(32) NOT NULL,
WKL_CURR_QUD_MIN Number(20,4) NOT NULL,
WKL_CURR_QUD_MAX Number(20,4) NOT NULL,
WKL_CURR_QUD_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxTQueueTest_TREND ADD constraint PK_TuxTQueueTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxTQueueTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxTQueueTest_THRESH ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Q_STATE_MIN	VARCHAR2(256)	 NOT NULL,
Q_STATE_MAX	VARCHAR2(256)	 NOT NULL,
SERVER_CNT_MIN	VARCHAR2(256)	 NOT NULL,
SERVER_CNT_MAX	VARCHAR2(256)	 NOT NULL,
REQ_CURR_QUD_MIN	VARCHAR2(256)	 NOT NULL,
REQ_CURR_QUD_MAX	VARCHAR2(256)	 NOT NULL,
WKL_CURR_QUD_MIN	VARCHAR2(256)	 NOT NULL,
WKL_CURR_QUD_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxTQueueTest_THRESH ADD constraint PK_TuxTQueueTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxTQueueTest_THRESH ON TuxTQueueTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MQManagerTest CASCADE CONSTRAINTS;

CREATE TABLE MQManagerTest (
TRGT_HOST varchar2(32),
PORT_NO varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,
AVAILABILITY Number(20,4) NOT NULL,
AVAILABILITY_ST varchar2(32) NOT NULL);

ALTER TABLE MQManagerTest ADD constraint PK_MQManagerTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE MQManagerTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MQManagerTest_TREND (
TRGT_HOST varchar2(32),
PORT_NO  varchar2(32),
SITE_NAME varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AVAILABILITY_MIN Number(20,4) NOT NULL,
AVAILABILITY_MAX Number(20,4) NOT NULL,
AVAILABILITY_STCNT varchar2(32) NOT NULL);

ALTER TABLE MQManagerTest_TREND ADD constraint PK_MQManagerTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MQManagerTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MQManagerTest_THRESH (
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),  
SITE_NAME       varchar2(64), 
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME_START date,	
MSMT_TIME_END   date,
AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE MQManagerTest_THRESH ADD constraint PK_MQManagerTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MQManagerTest_THRESH ON MQManagerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MQLocalQueueTest CASCADE CONSTRAINTS;

CREATE TABLE MQLocalQueueTest ( 
TRGT_HOST       varchar2(32), 
PORT_NO         varchar2(32), 
SITE_NAME       varchar2(64),  
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,
CURRENT_QUEUE_DEPTH Number(20,4) NOT NULL,
CURRENT_QUEUE_DEPTH_ST varchar2(32) NOT NULL,
QUEUE_FILL_PCT Number(20,4) NOT NULL,
QUEUE_FILL_PCT_ST varchar2(32) NOT NULL);

ALTER TABLE MQLocalQueueTest ADD constraint PK_MQLocalQueueTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MQLocalQueueTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MQLocalQueueTest_TREND ( 
TRGT_HOST       varchar2(32),     
PORT_NO         varchar2(32),       
SITE_NAME       varchar2(64),  
INFO            varchar2(128),
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,
PERIOD       	varchar2(32),
CURRENT_QUEUE_DEPTH_MIN Number(20,4) NOT NULL,
CURRENT_QUEUE_DEPTH_MAX Number(20,4) NOT NULL,
CURRENT_QUEUE_DEPTH_STCNT varchar2(32) NOT NULL,
QUEUE_FILL_PCT_MIN Number(20,4) NOT NULL,
QUEUE_FILL_PCT_MAX Number(20,4) NOT NULL,
QUEUE_FILL_PCT_STCNT varchar2(32) NOT NULL);

ALTER TABLE MQLocalQueueTest_TREND ADD constraint PK_MQLocalQueueTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE MQLocalQueueTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MQLocalQueueTest_THRESH ( 
TRGT_HOST       varchar2(32),   
PORT_NO         varchar2(32), 
SITE_NAME       varchar2(64), 
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME_START date,	
MSMT_TIME_END   date,
CURRENT_QUEUE_DEPTH_MIN	VARCHAR2(256)	 NOT NULL,
CURRENT_QUEUE_DEPTH_MAX	VARCHAR2(256)	 NOT NULL,
QUEUE_FILL_PCT_MIN	VARCHAR2(256)	 NOT NULL,
QUEUE_FILL_PCT_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE MQLocalQueueTest_THRESH ADD constraint PK_MQLocalQueueTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MQLocalQueueTest_THRESH ON MQLocalQueueTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE MQChannelTest CASCADE CONSTRAINTS;

CREATE TABLE MQChannelTest ( 
TRGT_HOST       varchar2(32), 
PORT_NO         varchar2(32),     
SITE_NAME       varchar2(64),       
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,
KBYTES_RECD_RATE Number(20,4) NOT NULL,
KBYTES_RECD_RATE_ST varchar2(32) NOT NULL,
KBYTES_SENT_RATE Number(20,4) NOT NULL,
KBYTES_SENT_RATE_ST varchar2(32) NOT NULL,
BUFFERS_RECD_RATE Number(20,4) NOT NULL,
BUFFERS_RECD_RATE_ST varchar2(32) NOT NULL,
BUFFERS_SENT_RATE Number(20,4) NOT NULL,
BUFFERS_SENT_RATE_ST varchar2(32) NOT NULL,
AVAILABILITY Number(20,4) NOT NULL,
AVAILABILITY_ST varchar2(32) NOT NULL);

ALTER TABLE MQChannelTest ADD constraint PK_MQChannelTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MQChannelTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MQChannelTest_TREND ( 
TRGT_HOST       varchar2(32),    
PORT_NO         varchar2(32),   
SITE_NAME       varchar2(64), 
INFO            varchar2(128),
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,
PERIOD       	varchar2(32),
KBYTES_RECD_RATE_MIN Number(20,4) NOT NULL,
KBYTES_RECD_RATE_MAX Number(20,4) NOT NULL,
KBYTES_RECD_RATE_STCNT varchar2(32) NOT NULL,
KBYTES_SENT_RATE_MIN Number(20,4) NOT NULL,
KBYTES_SENT_RATE_MAX Number(20,4) NOT NULL,
KBYTES_SENT_RATE_STCNT varchar2(32) NOT NULL,
BUFFERS_RECD_RATE_MIN Number(20,4) NOT NULL,
BUFFERS_RECD_RATE_MAX Number(20,4) NOT NULL,
BUFFERS_RECD_RATE_STCNT varchar2(32) NOT NULL,
BUFFERS_SENT_RATE_MIN Number(20,4) NOT NULL,
BUFFERS_SENT_RATE_MAX Number(20,4) NOT NULL,
BUFFERS_SENT_RATE_STCNT varchar2(32) NOT NULL,
AVAILABILITY_MIN Number(20,4) NOT NULL,
AVAILABILITY_MAX Number(20,4) NOT NULL,
AVAILABILITY_STCNT varchar2(32) NOT NULL);

ALTER TABLE MQChannelTest_TREND ADD constraint PK_MQChannelTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE MQChannelTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MQChannelTest_THRESH ( 
TRGT_HOST       varchar2(32),    
PORT_NO         varchar2(32),     
SITE_NAME       varchar2(64),      
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME_START date,
MSMT_TIME_END   date,
KBYTES_RECD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
KBYTES_RECD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
KBYTES_SENT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
KBYTES_SENT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
BUFFERS_RECD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
BUFFERS_RECD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
BUFFERS_SENT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
BUFFERS_SENT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE MQChannelTest_THRESH ADD constraint PK_MQChannelTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MQChannelTest_THRESH ON MQChannelTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DhcpPerfTest CASCADE CONSTRAINTS;

CREATE TABLE DhcpPerfTest ( 
TRGT_HOST       		varchar2(32), 
PORT_NO         		varchar2(32),     
SITE_NAME       		varchar2(64),       
INFO            		varchar2(128),	
MSMT_HOST       		varchar2(32),	
MSMT_TIME       		date,
AVG_PKTS_RATE			Number(20,4) NOT NULL,
AVG_PKTS_RATE_ST		varchar2(32) NOT NULL,
CURR_MSG_QUEUE_LEN 		Number(20,4) NOT NULL,
CURR_MSG_QUEUE_LEN_ST 	Varchar2(32) NOT NULL,
REQ_RATE 				Number(20,4) NOT NULL,
REQ_RATE_ST				varchar2(32) NOT NULL,
REQ_ACKS_RATE			Number(20,4) NOT NULL,
REQ_ACKS_RATE_ST 		varchar2(32) NOT NULL,
REQ_NACKS_RATE 			Number(20,4) NOT NULL,
REQ_NACKS_RATE_ST 		varchar2(32) NOT NULL,
REQ_DECLINES_RATE 		Number(20,4) NOT NULL,
REQ_DECLINES_RATE_ST	varchar2(32) NOT NULL,
PKTS_EXPD_RATE 			Number(20,4) NOT NULL,
PKTS_EXPD_RATE_ST 		varchar2(32) NOT NULL,
PKTS_DROPPED_RATE 		Number(20,4) NOT NULL,
PKTS_DROPPED_RATE_ST 	varchar2(32) NOT NULL,
REQ_RELEASE_RATE 		Number(20,4) NOT NULL,
REQ_RELEASE_RATE_ST 	varchar2(32) NOT NULL,
PKTS_RECEIVE 			Number(20,4) NOT NULL,
PKTS_RECEIVE_ST 		varchar2(32) NOT NULL,
CONFLICT_CHECK 		Number(20,4) NOT NULL,
CONFLICT_CHECK_ST	varchar2(32) NOT NULL,
DISCOVER_SEC 		Number(20,4) NOT NULL,
DISCOVER_SEC_ST 	varchar2(32) NOT NULL,
OFFERS_SEC 		Number(20,4) NOT NULL,
OFFERS_SEC_ST 		varchar2(32) NOT NULL,
INFO_SEC 		Number(20,4) NOT NULL,
INFO_SEC_ST 		varchar2(32) NOT NULL);

ALTER TABLE DhcpPerfTest ADD constraint PK_DhcpPerfTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DhcpPerfTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE DhcpPerfTest_TREND ( 
TRGT_HOST       varchar2(32),    
PORT_NO         varchar2(32),   
SITE_NAME       varchar2(64), 
INFO            varchar2(128),
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,
PERIOD       	varchar2(32),
AVG_PKTS_RATE_MIN			Number(20,4) NOT NULL,
AVG_PKTS_RATE_MAX			Number(20,4) NOT NULL,
AVG_PKTS_RATE_STCNT			varchar2(32) NOT NULL,
CURR_MSG_QUEUE_LEN_MIN		Number(20,4) NOT NULL,
CURR_MSG_QUEUE_LEN_MAX		Number(20,4) NOT NULL,
CURR_MSG_QUEUE_LEN_STCNT 	Varchar2(32) NOT NULL,
REQ_RATE_MIN 				Number(20,4) NOT NULL,
REQ_RATE_MAX 				Number(20,4) NOT NULL,
REQ_RATE_STCNT				varchar2(32) NOT NULL,
REQ_ACKS_RATE_MIN			Number(20,4) NOT NULL,
REQ_ACKS_RATE_MAX			Number(20,4) NOT NULL,
REQ_ACKS_RATE_STCNT 		varchar2(32) NOT NULL,
REQ_NACKS_RATE_MIN 			Number(20,4) NOT NULL,
REQ_NACKS_RATE_MAX 			Number(20,4) NOT NULL,
REQ_NACKS_RATE_STCNT 		varchar2(32) NOT NULL,
REQ_DECLINES_RATE_MIN 		Number(20,4) NOT NULL,
REQ_DECLINES_RATE_MAX 		Number(20,4) NOT NULL,
REQ_DECLINES_RATE_STCNT		varchar2(32) NOT NULL,
PKTS_EXPD_RATE_MIN 			Number(20,4) NOT NULL,
PKTS_EXPD_RATE_MAX 			Number(20,4) NOT NULL,
PKTS_EXPD_RATE_STCNT 		varchar2(32) NOT NULL,
PKTS_DROPPED_RATE_MIN 		Number(20,4) NOT NULL,
PKTS_DROPPED_RATE_MAX 		Number(20,4) NOT NULL,
PKTS_DROPPED_RATE_STCNT 	varchar2(32) NOT NULL,
REQ_RELEASE_RATE_MIN 		Number(20,4) NOT NULL,
REQ_RELEASE_RATE_MAX 		Number(20,4) NOT NULL,
REQ_RELEASE_RATE_STCNT	 	varchar2(32) NOT NULL,
PKTS_RECEIVE_MIN 			Number(20,4) NOT NULL,
PKTS_RECEIVE_MAX 			Number(20,4) NOT NULL,
PKTS_RECEIVE_STCNT 		varchar2(32) NOT NULL,
CONFLICT_CHECK_MIN 		Number(20,4) NOT NULL,
CONFLICT_CHECK_MAX 		Number(20,4) NOT NULL,
CONFLICT_CHECK_STCNT		varchar2(32) NOT NULL,
DISCOVER_SEC_MIN 			Number(20,4) NOT NULL,
DISCOVER_SEC_MAX 			Number(20,4) NOT NULL,
DISCOVER_SEC_STCNT 		varchar2(32) NOT NULL,
OFFERS_SEC_MIN 			Number(20,4) NOT NULL,
OFFERS_SEC_MAX 			Number(20,4) NOT NULL,
OFFERS_SEC_STCNT 		varchar2(32) NOT NULL,
INFO_SEC_MIN 			Number(20,4) NOT NULL,
INFO_SEC_MAX 			Number(20,4) NOT NULL,
INFO_SEC_STCNT	 		varchar2(32) NOT NULL);

ALTER TABLE DhcpPerfTest_TREND ADD constraint PK_DhcpPerfTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE DhcpPerfTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE DhcpPerfTest_THRESH ( 
TRGT_HOST       varchar2(32),    
PORT_NO         varchar2(32),     
SITE_NAME       varchar2(64),      
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME_START date,
MSMT_TIME_END   date,
AVG_PKTS_RATE_MIN	VARCHAR2(256)	 NOT NULL,
AVG_PKTS_RATE_MAX	VARCHAR2(256)	 NOT NULL,
CURR_MSG_QUEUE_LEN_MIN	VARCHAR2(256)	 NOT NULL,
CURR_MSG_QUEUE_LEN_MAX	VARCHAR2(256)	 NOT NULL,
REQ_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQ_RATE_MAX	VARCHAR2(256)	 NOT NULL,
REQ_ACKS_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQ_ACKS_RATE_MAX	VARCHAR2(256)	 NOT NULL,
REQ_NACKS_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQ_NACKS_RATE_MAX	VARCHAR2(256)	 NOT NULL,
REQ_DECLINES_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQ_DECLINES_RATE_MAX	VARCHAR2(256)	 NOT NULL,
PKTS_EXPD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
PKTS_EXPD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
PKTS_DROPPED_RATE_MIN	VARCHAR2(256)	 NOT NULL,
PKTS_DROPPED_RATE_MAX	VARCHAR2(256)	 NOT NULL,
REQ_RELEASE_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQ_RELEASE_RATE_MAX	VARCHAR2(256)	 NOT NULL,
PKTS_RECEIVE_MIN	VARCHAR2(256)	 NOT NULL,
PKTS_RECEIVE_MAX	VARCHAR2(256)	 NOT NULL,
CONFLICT_CHECK_MIN	VARCHAR2(256)	 NOT NULL,
CONFLICT_CHECK_MAX	VARCHAR2(256)	 NOT NULL,
DISCOVER_SEC_MIN	VARCHAR2(256)	 NOT NULL,
DISCOVER_SEC_MAX	VARCHAR2(256)	 NOT NULL,
OFFERS_SEC_MIN		VARCHAR2(256)	 NOT NULL,
OFFERS_SEC_MAX		VARCHAR2(256)	 NOT NULL,
INFO_SEC_MIN		VARCHAR2(256)	 NOT NULL,
INFO_SEC_MAX		VARCHAR2(256)	 NOT NULL);

ALTER TABLE DhcpPerfTest_THRESH ADD constraint PK_DhcpPerfTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DhcpPerfTest_THRESH ON DhcpPerfTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DhcpUtilTest CASCADE CONSTRAINTS;

CREATE TABLE DhcpUtilTest ( 
TRGT_HOST       		varchar2(32), 
PORT_NO         		varchar2(32),     
SITE_NAME       		varchar2(64),       
INFO            		varchar2(128),	
MSMT_HOST       		varchar2(32),	
MSMT_TIME       		date,
CURR_ADDR_USAGE_CNT		Number(20,4) NOT NULL,
CURR_ADDR_USAGE_CNT_ST	VARCHAR2(32) NOT NULL,
FREE_ADDR_USAGE_CNT		Number(20,4) NOT NULL,
FREE_ADDR_USAGE_CNT_ST	VARCHAR2(32) NOT NULL,
TOTAL_ADDR_USAGE_CNT		Number(20,4) NOT NULL,
TOTAL_ADDR_USAGE_CNT_ST	VARCHAR2(32) NOT NULL,
USAGE				Number(20,4) NOT NULL,
USAGE_ST		VARCHAR2(32) NOT NULL,
Status				Number(20,4) NOT NULL,
Status_ST		VARCHAR2(32) NOT NULL);


ALTER TABLE DhcpUtilTest ADD constraint PK_DhcpUtilTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DhcpUtilTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE DhcpUtilTest_TREND ( 
TRGT_HOST       varchar2(32),    
PORT_NO         varchar2(32),   
SITE_NAME       varchar2(64), 
INFO            varchar2(128),
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,
PERIOD       	varchar2(32),
CURR_ADDR_USAGE_CNT_MIN		Number(20,4) NOT NULL,
CURR_ADDR_USAGE_CNT_MAX		Number(20,4) NOT NULL,
CURR_ADDR_USAGE_CNT_STCNT	VARCHAR2(32) NOT NULL,
FREE_ADDR_USAGE_CNT_MIN		Number(20,4) NOT NULL,
FREE_ADDR_USAGE_CNT_MAX		Number(20,4) NOT NULL,
FREE_ADDR_USAGE_CNT_STCNT	VARCHAR2(32) NOT NULL,
TOTAL_ADDR_USAGE_CNT_MIN	Number(20,4) NOT NULL,
TOTAL_ADDR_USAGE_CNT_MAX	Number(20,4) NOT NULL,
TOTAL_ADDR_USAGE_CNT_STCNT	VARCHAR2(32) NOT NULL,
USAGE_MIN			Number(20,4) NOT NULL,
USAGE_MAX			Number(20,4) NOT NULL,
USAGE_STCNT			VARCHAR2(32) NOT NULL,
Status_MIN			Number(20,4) NOT NULL,
Status_MAX			Number(20,4) NOT NULL,
Status_STCNT			VARCHAR2(32) NOT NULL);

ALTER TABLE DhcpUtilTest_TREND ADD constraint PK_DhcpUtilTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE DhcpUtilTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE DhcpUtilTest_THRESH ( 
TRGT_HOST       varchar2(32),    
PORT_NO         varchar2(32),     
SITE_NAME       varchar2(64),      
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME_START date,
MSMT_TIME_END   date,
CURR_ADDR_USAGE_CNT_MIN	VARCHAR2(256)	 NOT NULL,
CURR_ADDR_USAGE_CNT_MAX	VARCHAR2(256)	 NOT NULL,
FREE_ADDR_USAGE_CNT_MIN	VARCHAR2(256)	 NOT NULL,
FREE_ADDR_USAGE_CNT_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_ADDR_USAGE_CNT_MIN VARCHAR2(256)	 NOT NULL,
TOTAL_ADDR_USAGE_CNT_MAX VARCHAR2(256)	 NOT NULL,
USAGE_MIN		VARCHAR2(256)	 NOT NULL,
USAGE_MAX		VARCHAR2(256)	 NOT NULL,
Status_MIN		VARCHAR2(256)	 NOT NULL,
Status_MAX		VARCHAR2(256)	 NOT NULL);

ALTER TABLE DhcpUtilTest_THRESH ADD constraint PK_DhcpUtilTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DhcpUtilTest_THRESH ON DhcpUtilTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WLThreadTest CASCADE CONSTRAINTS;

CREATE TABLE WLThreadTest 
(
	TRGT_HOST       		varchar2(32), 
	PORT_NO         		varchar2(32), 
	SITE_NAME       		varchar2(64),  
	INFO            		varchar2(128),  
	MSMT_HOST       		varchar2(32), 
	MSMT_TIME       		date,
	IDLE_THREADS    		Number(20,4) NOT NULL,
	IDLE_THREADS_ST 		varchar2(32) NOT NULL,
	PCT_THREAD_UTILIZATION  	Number(20,4) NOT NULL,
	PCT_THREAD_UTILIZATION_ST 	varchar2(32) NOT NULL,
	PENDING_REQUESTS 		Number(20,4) NOT NULL,
	PENDING_REQUESTS_ST 		varchar2(32) NOT NULL,
	REQUEST_RATE			Number(20,4) NOT NULL,
	REQUEST_RATE_ST 		varchar2(32) NOT NULL
);

ALTER TABLE WLThreadTest ADD constraint PK_WLThreadTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WLThreadTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WLThreadTest_TREND 
(
	TRGT_HOST      					varchar2(32), 
	PORT_NO    		       			varchar2(32),
	SITE_NAME    					varchar2(64),
	INFO							varchar2(128), 
	MSMT_HOST   					varchar2(32), 
	MSMT_TIME    					date,
	PERIOD      		   			varchar2(32),
	IDLE_THREADS_MIN 				Number(20,4) NOT NULL,
	IDLE_THREADS_MAX 				Number(20,4) NOT NULL,
	IDLE_THREADS_STCNT 				varchar2(32) NOT NULL,
	PCT_THREAD_UTILIZATION_MIN 		Number(20,4) NOT NULL,
	PCT_THREAD_UTILIZATION_MAX 		Number(20,4) NOT NULL,
	PCT_THREAD_UTILIZATION_STCNT    varchar2(32) NOT NULL,
	PENDING_REQUESTS_MIN 			Number(20,4) NOT NULL,
	PENDING_REQUESTS_MAX 			Number(20,4) NOT NULL,
	PENDING_REQUESTS_STCNT 			varchar2(32) NOT NULL,
	REQUEST_RATE_MIN 				Number(20,4) NOT NULL,
	REQUEST_RATE_MAX 				Number(20,4) NOT NULL,
	REQUEST_RATE_STCNT 				varchar2(32) NOT NULL
);

ALTER TABLE WLThreadTest_TREND ADD constraint PK_WLThreadTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE WLThreadTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WLThreadTest_THRESH
(
	TRGT_HOST       				varchar2(32),
	PORT_NO			        		varchar2(32),
	SITE_NAME    					varchar2(64),
	INFO			        		varchar2(128),      
	MSMT_HOST		        		varchar2(32),   
	MSMT_TIME_START 				date,
	MSMT_TIME_END  					date,
	IDLE_THREADS_MIN	VARCHAR2(256)	 NOT NULL,
	IDLE_THREADS_MAX	VARCHAR2(256)	 NOT NULL,
	PCT_THREAD_UTILIZATION_MIN	VARCHAR2(256)	 NOT NULL,
	PCT_THREAD_UTILIZATION_MAX	VARCHAR2(256)	 NOT NULL,
	PENDING_REQUESTS_MIN	VARCHAR2(256)	 NOT NULL,
	PENDING_REQUESTS_MAX	VARCHAR2(256)	 NOT NULL,
	REQUEST_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	REQUEST_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE WLThreadTest_THRESH ADD constraint PK_WLThreadTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_WLThreadTest_THRESH ON WLThreadTest_THRESH 
(
	MSMT_HOST,
	MSMT_TIME_START,
	MSMT_TIME_END
);

DROP TABLE WLClusterTest CASCADE CONSTRAINTS;

CREATE TABLE WLClusterTest
(
	TRGT_HOST       			varchar2(32),
	PORT_NO         			varchar2(32),
	SITE_NAME       			varchar2(64),
	INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME       			date,
	ALIVE_SERVERS_COUNT 		Number(20,4)	 NOT NULL,
	ALIVE_SERVERS_COUNT_ST 		varchar2(32) NOT NULL,
	FRAGMENTS_SENT_RT 			Number(20,4) NOT NULL,
	FRAGMENTS_SENT_RT_ST 		varchar2(32) NOT NULL,
	FRAGMENTS_RECEIVED_RT 		Number(20,4) NOT NULL,
	FRAGMENTS_RECEIVED_RT_ST 	varchar2(32) NOT NULL,
	FRAGMENTS_DROPPED_RT 		Number(20,4) NOT NULL,
	FRAGMENTS_DROPPED_RT_ST 	varchar2(32) NOT NULL,
	MSGS_LOST_RT 				Number(20,4) NOT NULL,
	MSGS_LOST_RT_ST 			varchar2(32) NOT NULL,
	RESEND_REQUESTS_RT 			Number(20,4) NOT NULL,
	RESEND_REQUESTS_RT_ST 		varchar2(32) NOT NULL,
	PRIMARY_COUNT 				Number(20,4)	 NOT NULL,
	PRIMARY_COUNT_ST 			varchar2(32) NOT NULL
);

ALTER TABLE WLClusterTest ADD constraint PK_WLClusterTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);

DROP TABLE WLClusterTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WLClusterTest_TREND
(
	TRGT_HOST       			varchar2(32),
	PORT_NO         			varchar2(32),
	SITE_NAME       			varchar2(64),
	INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME       			date,
	PERIOD       				varchar2(32),
	ALIVE_SERVERS_COUNT_MIN 	Number(20,4)	 NOT NULL,
	ALIVE_SERVERS_COUNT_MAX 	Number(20,4)	 NOT NULL,
	ALIVE_SERVERS_COUNT_STCNT 	varchar2(32) NOT NULL,
	FRAGMENTS_SENT_RT_MIN 		Number(20,4) NOT NULL,
	FRAGMENTS_SENT_RT_MAX 		Number(20,4) NOT NULL,
	FRAGMENTS_SENT_RT_STCNT 	varchar2(32) NOT NULL,
	FRAGMENTS_RECEIVED_RT_MIN 	Number(20,4) NOT NULL,
	FRAGMENTS_RECEIVED_RT_MAX 	Number(20,4) NOT NULL,
	FRAGMENTS_RECEIVED_RT_STCNT varchar2(32) NOT NULL,
	FRAGMENTS_DROPPED_RT_MIN 	Number(20,4) NOT NULL,
	FRAGMENTS_DROPPED_RT_MAX 	Number(20,4) NOT NULL,
	FRAGMENTS_DROPPED_RT_STCNT 	varchar2(32) NOT NULL,
	MSGS_LOST_RT_MIN 			Number(20,4) NOT NULL,
	MSGS_LOST_RT_MAX 			Number(20,4) NOT NULL,
	MSGS_LOST_RT_STCNT 			varchar2(32) NOT NULL,
	RESEND_REQUESTS_RT_MIN 		Number(20,4) NOT NULL,
	RESEND_REQUESTS_RT_MAX 		Number(20,4) NOT NULL,
	RESEND_REQUESTS_RT_STCNT 	varchar2(32) NOT NULL,
	PRIMARY_COUNT_MIN 			Number(20,4)	 NOT NULL,
	PRIMARY_COUNT_MAX 			Number(20,4)	 NOT NULL,
	PRIMARY_COUNT_STCNT 		varchar2(32) NOT NULL
);

ALTER TABLE WLClusterTest_TREND ADD constraint PK_WLClusterTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,
			PERIOD);

DROP TABLE WLClusterTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WLClusterTest_THRESH(
	TRGT_HOST       			varchar2(32),
	PORT_NO         			varchar2(32),
	SITE_NAME       			varchar2(64),
	INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME_START 			date,
	MSMT_TIME_END   			date,
	ALIVE_SERVERS_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
	ALIVE_SERVERS_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
	FRAGMENTS_SENT_RT_MIN	VARCHAR2(256)	 NOT NULL,
	FRAGMENTS_SENT_RT_MAX	VARCHAR2(256)	 NOT NULL,
	FRAGMENTS_RECEIVED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	FRAGMENTS_RECEIVED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	FRAGMENTS_DROPPED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	FRAGMENTS_DROPPED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	MSGS_LOST_RT_MIN	VARCHAR2(256)	 NOT NULL,
	MSGS_LOST_RT_MAX	VARCHAR2(256)	 NOT NULL,
	RESEND_REQUESTS_RT_MIN	VARCHAR2(256)	 NOT NULL,
	RESEND_REQUESTS_RT_MAX	VARCHAR2(256)	 NOT NULL,
	PRIMARY_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
	PRIMARY_COUNT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE WLClusterTest_THRESH ADD constraint PK_WLClusterTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLClusterTest_THRESH ON WLClusterTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WLConnectorTest CASCADE CONSTRAINTS;

CREATE TABLE WLConnectorTest(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME       				varchar2(64),
	INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME       				date,
	TOTAL_CONNS_CREATED_RT 			Number(20,4) NOT NULL,
	TOTAL_CONNS_CREATED_RT_ST 		varchar2(32) NOT NULL,
	TOTAL_CONNS_DESTROYED_RT 		Number(20,4) NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_ST 	varchar2(32) NOT NULL,
	TOTAL_CONNS_MATCHED_RT 			Number(20,4) NOT NULL,
	TOTAL_CONNS_MATCHED_RT_ST 		varchar2(32) NOT NULL,
	TOTAL_CONNS_REJECTED_RT 		Number(20,4) NOT NULL,
	TOTAL_CONNS_REJECTED_RT_ST 		varchar2(32) NOT NULL,
	TOTAL_CONNS_RECYCLED_RT 		Number(20,4) NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_ST 		varchar2(32) NOT NULL,
	CURRENT_ACTIVE_CONNS 			Number(20,4)	 NOT NULL,
	CURRENT_ACTIVE_CONNS_ST 		varchar2(32) NOT NULL,
	ACTIVE_CONNS_HWM 				Number(20,4)	 NOT NULL,
	ACTIVE_CONNS_HWM_ST 			varchar2(32) NOT NULL,
	CURRENT_FREE_CONNS 				Number(20,4)	 NOT NULL,
	CURRENT_FREE_CONNS_ST 			varchar2(32) NOT NULL,
	FREE_CONNS_HWM 					Number(20,4)	 NOT NULL,
	FREE_CONNS_HWM_ST 				varchar2(32) NOT NULL,
	MAX_CAPACITY 					Number(20,4)	 NOT NULL,
	MAX_CAPACITY_ST 				varchar2(32) NOT NULL
);

ALTER TABLE WLConnectorTest ADD constraint PK_WLConnectorTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);

DROP TABLE WLConnectorTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WLConnectorTest_TREND
(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME       				varchar2(64),
	INFO           					varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME       				date,
	PERIOD       					varchar2(32),
	TOTAL_CONNS_CREATED_RT_MIN 		Number(20,4) NOT NULL,
	TOTAL_CONNS_CREATED_RT_MAX 		Number(20,4) NOT NULL,
	TOTAL_CONNS_CREATED_RT_STCNT 	varchar2(32) NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MIN 	Number(20,4) NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MAX 	Number(20,4) NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_STCNT 	varchar2(32) NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MIN 		Number(20,4) NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MAX 		Number(20,4) NOT NULL,
	TOTAL_CONNS_MATCHED_RT_STCNT 	varchar2(32) NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MIN 	Number(20,4) NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MAX 	Number(20,4) NOT NULL,
	TOTAL_CONNS_REJECTED_RT_STCNT 	varchar2(32) NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MIN 	Number(20,4) NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MAX 	Number(20,4) NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_STCNT 	varchar2(32) NOT NULL,
	CURRENT_ACTIVE_CONNS_MIN 		Number(20,4) NOT NULL,
	CURRENT_ACTIVE_CONNS_MAX 		Number(20,4) NOT NULL,
	CURRENT_ACTIVE_CONNS_STCNT 		varchar2(32) NOT NULL,
	ACTIVE_CONNS_HWM_MIN 			Number(20,4) NOT NULL,
	ACTIVE_CONNS_HWM_MAX 			Number(20,4) NOT NULL,
	ACTIVE_CONNS_HWM_STCNT 			varchar2(32) NOT NULL,
	CURRENT_FREE_CONNS_MIN 			Number(20,4) NOT NULL,
	CURRENT_FREE_CONNS_MAX 			Number(20,4) NOT NULL,
	CURRENT_FREE_CONNS_STCNT 		varchar2(32) NOT NULL,
	FREE_CONNS_HWM_MIN 				Number(20,4) NOT NULL,
	FREE_CONNS_HWM_MAX 				Number(20,4) NOT NULL,
	FREE_CONNS_HWM_STCNT 			varchar2(32) NOT NULL,
	MAX_CAPACITY_MIN 				Number(20,4) NOT NULL,
	MAX_CAPACITY_MAX 				Number(20,4) NOT NULL,
	MAX_CAPACITY_STCNT 				varchar2(32) NOT NULL
);

ALTER TABLE WLConnectorTest_TREND ADD constraint PK_WLConnectorTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,
			PERIOD);

DROP TABLE WLConnectorTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WLConnectorTest_THRESH
(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME      					varchar2(64),
	INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME_START 				date,
	MSMT_TIME_END   				date,
	TOTAL_CONNS_CREATED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_CREATED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	CURRENT_ACTIVE_CONNS_MIN	VARCHAR2(256)		 NOT NULL,
	CURRENT_ACTIVE_CONNS_MAX	VARCHAR2(256)		 NOT NULL,
	ACTIVE_CONNS_HWM_MIN	VARCHAR2(256)		 NOT NULL,
	ACTIVE_CONNS_HWM_MAX	VARCHAR2(256)		 NOT NULL,
	CURRENT_FREE_CONNS_MIN	VARCHAR2(256)		 NOT NULL,
	CURRENT_FREE_CONNS_MAX	VARCHAR2(256)		 NOT NULL,
	FREE_CONNS_HWM_MIN	VARCHAR2(256)		 NOT NULL,
	FREE_CONNS_HWM_MAX	VARCHAR2(256)		 NOT NULL,
	MAX_CAPACITY_MIN	VARCHAR2(256)		 NOT NULL,
	MAX_CAPACITY_MAX	VARCHAR2(256)	 	 NOT NULL
);

ALTER TABLE WLConnectorTest_THRESH ADD constraint PK_WLConnectorTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLConnectorTest_THRESH ON WLConnectorTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WLJMSTest CASCADE CONSTRAINTS;

CREATE TABLE WLJMSTest
(
	TRGT_HOST       			varchar2(32),
	PORT_NO         			varchar2(32),
	SITE_NAME       			varchar2(64),
	INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME       			date,
	BYTES_RECEIVED_RT 			Number(20,4) NOT NULL,
	BYTES_RECEIVED_RT_ST 		varchar2(32) NOT NULL,
	MSGS_RECEIVED_RT 			Number(20,4) NOT NULL,
	MSGS_RECEIVED_RT_ST 		varchar2(32) NOT NULL,
	BYTES_CURRENT_COUNT 		Number(20,4)	 NOT NULL,
	BYTES_CURRENT_COUNT_ST 		varchar2(32) NOT NULL,
	BYTES_PENDING_COUNT 		Number(20,4)	 NOT NULL,
	BYTES_PENDING_COUNT_ST 		varchar2(32) NOT NULL,
	BYTES_COUNT_HWM 			Number(20,4)	 NOT NULL,
	BYTES_COUNT_HWM_ST 			varchar2(32) NOT NULL,
	MSGS_CURRENT_COUNT 			Number(20,4)	 NOT NULL,
	MSGS_CURRENT_COUNT_ST 		varchar2(32) NOT NULL,
	MSGS_PENDING_COUNT 			Number(20,4)	 NOT NULL,
	MSGS_PENDING_COUNT_ST 		varchar2(32) NOT NULL,
	MSGS_COUNT_HWM 				Number(20,4)	 NOT NULL,
	MSGS_COUNT_HWM_ST 			varchar2(32) NOT NULL,
	DEST_CURRENT_COUNT 			Number(20,4)	 NOT NULL,
	DEST_CURRENT_COUNT_ST 		varchar2(32) NOT NULL,
	DEST_COUNT_HWM 				Number(20,4)	 NOT NULL,
	DEST_COUNT_HWM_ST 			varchar2(32) NOT NULL,
	SESS_POOL_CURRENT_COUNT 	Number(20,4)	 NOT NULL,
	SESS_POOL_CURRENT_COUNT_ST 	varchar2(32) NOT NULL,
	SESSION_POOL_HWM 			Number(20,4)	 NOT NULL,
	SESSION_POOL_HWM_ST 		varchar2(32) NOT NULL
);

ALTER TABLE WLJMSTest ADD constraint PK_WLJMSTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);

DROP TABLE WLJMSTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WLJMSTest_TREND
(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME       				varchar2(64),
	INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME      					date,
	PERIOD       					varchar2(32),
	BYTES_RECEIVED_RT_MIN 			Number(20,4) NOT NULL,
	BYTES_RECEIVED_RT_MAX 			Number(20,4) NOT NULL,
	BYTES_RECEIVED_RT_STCNT 		varchar2(32) NOT NULL,
	MSGS_RECEIVED_RT_MIN 			Number(20,4) NOT NULL,
	MSGS_RECEIVED_RT_MAX 			Number(20,4) NOT NULL,
	MSGS_RECEIVED_RT_STCNT 			varchar2(32) NOT NULL,
	BYTES_CURRENT_COUNT_MIN 		Number(20,4)	 NOT NULL,
	BYTES_CURRENT_COUNT_MAX 		Number(20,4)	 NOT NULL,
	BYTES_CURRENT_COUNT_STCNT 		varchar2(32) NOT NULL,
	BYTES_PENDING_COUNT_MIN 		Number(20,4)	 NOT NULL,
	BYTES_PENDING_COUNT_MAX 		Number(20,4)	 NOT NULL,
	BYTES_PENDING_COUNT_STCNT 		varchar2(32) NOT NULL,
	BYTES_COUNT_HWM_MIN 			Number(20,4)	 NOT NULL,
	BYTES_COUNT_HWM_MAX 			Number(20,4)	 NOT NULL,
	BYTES_COUNT_HWM_STCNT 			varchar2(32) NOT NULL,
	MSGS_CURRENT_COUNT_MIN 			Number(20,4)	 NOT NULL,
	MSGS_CURRENT_COUNT_MAX 			Number(20,4)	 NOT NULL,
	MSGS_CURRENT_COUNT_STCNT 		varchar2(32) NOT NULL,
	MSGS_PENDING_COUNT_MIN 			Number(20,4)	 NOT NULL,
	MSGS_PENDING_COUNT_MAX 			Number(20,4)	 NOT NULL,
	MSGS_PENDING_COUNT_STCNT 		varchar2(32) NOT NULL,
	MSGS_COUNT_HWM_MIN 				Number(20,4)	 NOT NULL,
	MSGS_COUNT_HWM_MAX 				Number(20,4)	 NOT NULL,
	MSGS_COUNT_HWM_STCNT 			varchar2(32) NOT NULL,
	DEST_CURRENT_COUNT_MIN 			Number(20,4)	 NOT NULL,
	DEST_CURRENT_COUNT_MAX 			Number(20,4)	 NOT NULL,
	DEST_CURRENT_COUNT_STCNT 		varchar2(32) NOT NULL,
	DEST_COUNT_HWM_MIN 				Number(20,4)	 NOT NULL,
	DEST_COUNT_HWM_MAX 				Number(20,4)	 NOT NULL,
	DEST_COUNT_HWM_STCNT 			varchar2(32) NOT NULL,
	SESS_POOL_CURRENT_COUNT_MIN 	Number(20,4)	 NOT NULL,
	SESS_POOL_CURRENT_COUNT_MAX 	Number(20,4)	 NOT NULL,
	SESS_POOL_CURRENT_COUNT_STCNT 	varchar2(32) NOT NULL,
	SESSION_POOL_HWM_MIN 			Number(20,4)	 NOT NULL,
	SESSION_POOL_HWM_MAX 			Number(20,4)	 NOT NULL,
	SESSION_POOL_HWM_STCNT 			varchar2(32) NOT NULL
);

ALTER TABLE WLJMSTest_TREND ADD constraint PK_WLJMSTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,
			PERIOD);

DROP TABLE WLJMSTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WLJMSTest_THRESH
(
	TRGT_HOST       			varchar2(32),
	PORT_NO         			varchar2(32),
	SITE_NAME      				varchar2(64),
	INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME_START 			date,
	MSMT_TIME_END   			date,
	BYTES_RECEIVED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	BYTES_RECEIVED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	MSGS_RECEIVED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	MSGS_RECEIVED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	BYTES_CURRENT_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	BYTES_CURRENT_COUNT_MAX	VARCHAR2(256)		 NOT NULL,
	BYTES_PENDING_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	BYTES_PENDING_COUNT_MAX	VARCHAR2(256)		 NOT NULL,
	BYTES_COUNT_HWM_MIN	VARCHAR2(256)		 NOT NULL,
	BYTES_COUNT_HWM_MAX	VARCHAR2(256)		 NOT NULL,
	MSGS_CURRENT_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	MSGS_CURRENT_COUNT_MAX	VARCHAR2(256)		 NOT NULL,
	MSGS_PENDING_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	MSGS_PENDING_COUNT_MAX	VARCHAR2(256)		 NOT NULL,
	MSGS_COUNT_HWM_MIN	VARCHAR2(256)		 NOT NULL,
	MSGS_COUNT_HWM_MAX	VARCHAR2(256)		 NOT NULL,
	DEST_CURRENT_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	DEST_CURRENT_COUNT_MAX	VARCHAR2(256)		 NOT NULL,
	DEST_COUNT_HWM_MIN	VARCHAR2(256)		 NOT NULL,
	DEST_COUNT_HWM_MAX	VARCHAR2(256)		 NOT NULL,
	SESS_POOL_CURRENT_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	SESS_POOL_CURRENT_COUNT_MAX	VARCHAR2(256)		 NOT NULL,
	SESSION_POOL_HWM_MIN	VARCHAR2(256)		 NOT NULL,
	SESSION_POOL_HWM_MAX	VARCHAR2(256)		 NOT NULL
);

ALTER TABLE WLJMSTest_THRESH ADD constraint PK_WLJMSTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLJMSTest_THRESH ON WLJMSTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WLJTATest CASCADE CONSTRAINTS;

CREATE TABLE WLJTATest
(
	TRGT_HOST       			varchar2(32),
	PORT_NO         			varchar2(32),
	SITE_NAME       			varchar2(64),
	INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME       			date,
	TOTAL_ACTIVE_TX 			Number(20,4)	 NOT NULL,
	TOTAL_ACTIVE_TX_ST 			varchar2(32) NOT NULL,
	ABANDONED_TX_RT 			Number(20,4) NOT NULL,
	ABANDONED_TX_RT_ST 			varchar2(32) NOT NULL,
	APP_ROLLEDBACK_TX_RT 		Number(20,4) NOT NULL,
	APP_ROLLEDBACK_TX_RT_ST 	varchar2(32) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT 	Number(20,4) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_ST varchar2(32) NOT NULL,
	SYS_ROLLEDBACK_TX_RT 		Number(20,4) NOT NULL,
	SYS_ROLLEDBACK_TX_RT_ST 	varchar2(32) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT 	Number(20,4) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_ST varchar2(32) NOT NULL,
	COMMITTED_TX_RT 			Number(20,4) NOT NULL,
	COMMITTED_TX_RT_ST 			varchar2(32) NOT NULL,
	HEURISTICS_TX_RT 			Number(20,4) NOT NULL,
	HEURISTICS_TX_RT_ST 		varchar2(32) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT 		Number(20,4) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_ST 	varchar2(32) NOT NULL,
	TOTAL_TX_RT 				Number(20,4) NOT NULL,
	TOTAL_TX_RT_ST 				varchar2(32) NOT NULL
);

ALTER TABLE WLJTATest ADD constraint PK_WLJTATest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);

DROP TABLE WLJTATest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WLJTATest_TREND
(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME       				varchar2(64),
	INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME       				date,
	PERIOD       					varchar2(32),
	TOTAL_ACTIVE_TX_MIN 			Number(20,4)	 NOT NULL,
	TOTAL_ACTIVE_TX_MAX 			Number(20,4)	 NOT NULL,
	TOTAL_ACTIVE_TX_STCNT 			varchar2(32) NOT NULL,
	ABANDONED_TX_RT_MIN 			Number(20,4) NOT NULL,
	ABANDONED_TX_RT_MAX 			Number(20,4) NOT NULL,
	ABANDONED_TX_RT_STCNT 			varchar2(32) NOT NULL,
	APP_ROLLEDBACK_TX_RT_MIN 		Number(20,4) NOT NULL,
	APP_ROLLEDBACK_TX_RT_MAX 		Number(20,4) NOT NULL,
	APP_ROLLEDBACK_TX_RT_STCNT 		varchar2(32) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MIN 	Number(20,4) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MAX 	Number(20,4) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_STCNT 	varchar2(32) NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MIN 		Number(20,4) NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MAX 		Number(20,4) NOT NULL,
	SYS_ROLLEDBACK_TX_RT_STCNT 		varchar2(32) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MIN 	Number(20,4) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MAX 	Number(20,4) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_STCNT 	varchar2(32) NOT NULL,
	COMMITTED_TX_RT_MIN 			Number(20,4) NOT NULL,
	COMMITTED_TX_RT_MAX 			Number(20,4) NOT NULL,
	COMMITTED_TX_RT_STCNT 			varchar2(32) NOT NULL,
	HEURISTICS_TX_RT_MIN 			Number(20,4) NOT NULL,
	HEURISTICS_TX_RT_MAX 			Number(20,4) NOT NULL,
	HEURISTICS_TX_RT_STCNT 			varchar2(32) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MIN 		Number(20,4) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MAX 		Number(20,4) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_STCNT 	varchar2(32) NOT NULL,
	TOTAL_TX_RT_MIN 				Number(20,4) NOT NULL,
	TOTAL_TX_RT_MAX 				Number(20,4) NOT NULL,
	TOTAL_TX_RT_STCNT 				varchar2(32) NOT NULL
);

ALTER TABLE WLJTATest_TREND ADD constraint PK_WLJTATest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,
			PERIOD);

DROP TABLE WLJTATest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WLJTATest_THRESH
(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME       				varchar2(64),
	INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME_START 				date,
	MSMT_TIME_END   				date,
	TOTAL_ACTIVE_TX_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_ACTIVE_TX_MAX	VARCHAR2(256)	 NOT NULL,
	ABANDONED_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	ABANDONED_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	APP_ROLLEDBACK_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	APP_ROLLEDBACK_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	COMMITTED_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	COMMITTED_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	HEURISTICS_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	HEURISTICS_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_TX_RT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE WLJTATest_THRESH ADD constraint PK_WLJTATest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,			
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLJTATest_THRESH ON WLJTATest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WLSecurityTest CASCADE CONSTRAINTS;

CREATE TABLE WLSecurityTest
(
	TRGT_HOST       			varchar2(32),
	PORT_NO         			varchar2(32),
	SITE_NAME       			varchar2(64),
	INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME       			date,
	INVALID_LOGIN_ATTEMPT_RT 	Number(20,4) NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_ST varchar2(32) NOT NULL,
	INVALID_USERS_COUNT_HWM 	Number(20,4)	 NOT NULL,
	INVALID_USERS_COUNT_HWM_ST 	varchar2(32) NOT NULL,
	CURR_LOCKED_USERS_COUNT 	Number(20,4)	 NOT NULL,
	CURR_LOCKED_USERS_COUNT_ST 	varchar2(32) NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD 	Number(20,4)	 NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_ST varchar2(32) NOT NULL,
	TOTAL_UNLOCKED_USERS 		Number(20,4)	 NOT NULL,
	TOTAL_UNLOCKED_USERS_ST 	varchar2(32) NOT NULL,
	USER_LOCKOUT_COUNT 			Number(20,4)	 NOT NULL,
	USER_LOCKOUT_COUNT_ST 		varchar2(32) NOT NULL
);

ALTER TABLE WLSecurityTest ADD constraint PK_WLSecurityTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);

DROP TABLE WLSecurityTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WLSecurityTest_TREND
(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME       				varchar2(64),
	INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME       				date,
	PERIOD       					varchar2(32),
	INVALID_LOGIN_ATTEMPT_RT_MIN 	Number(20,4) NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_MAX 	Number(20,4) NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_STCNT 	varchar2(32) NOT NULL,
	INVALID_USERS_COUNT_HWM_MIN 	Number(20,4)	 NOT NULL,
	INVALID_USERS_COUNT_HWM_MAX 	Number(20,4)	 NOT NULL,
	INVALID_USERS_COUNT_HWM_STCNT 	varchar2(32) NOT NULL,
	CURR_LOCKED_USERS_COUNT_MIN 	Number(20,4)	 NOT NULL,
	CURR_LOCKED_USERS_COUNT_MAX 	Number(20,4)	 NOT NULL,
	CURR_LOCKED_USERS_COUNT_STCNT 	varchar2(32) NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MIN 	Number(20,4)	 NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MAX 	Number(20,4)	 NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_STCNT 	varchar2(32) NOT NULL,
	TOTAL_UNLOCKED_USERS_MIN 		Number(20,4)	 NOT NULL,
	TOTAL_UNLOCKED_USERS_MAX 		Number(20,4)	 NOT NULL,
	TOTAL_UNLOCKED_USERS_STCNT 		varchar2(32) NOT NULL,
	USER_LOCKOUT_COUNT_MIN 			Number(20,4)	 NOT NULL,
	USER_LOCKOUT_COUNT_MAX 			Number(20,4)	 NOT NULL,
	USER_LOCKOUT_COUNT_STCNT 		varchar2(32) NOT NULL
);

ALTER TABLE WLSecurityTest_TREND ADD constraint PK_WLSecurityTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,
			PERIOD);

DROP TABLE WLSecurityTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WLSecurityTest_THRESH
(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME       				varchar2(64),
	INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME_START 				date,
	MSMT_TIME_END   				date,
	INVALID_LOGIN_ATTEMPT_RT_MIN	VARCHAR2(256)	 NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_MAX	VARCHAR2(256)	 NOT NULL,
	INVALID_USERS_COUNT_HWM_MIN	VARCHAR2(256)		 NOT NULL,
	INVALID_USERS_COUNT_HWM_MAX	VARCHAR2(256)		 NOT NULL,
	CURR_LOCKED_USERS_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	CURR_LOCKED_USERS_COUNT_MAX	VARCHAR2(256)		 NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MIN	VARCHAR2(256)		 NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MAX	VARCHAR2(256)		 NOT NULL,
	TOTAL_UNLOCKED_USERS_MIN	VARCHAR2(256)		 NOT NULL,
	TOTAL_UNLOCKED_USERS_MAX	VARCHAR2(256)		 NOT NULL,
	USER_LOCKOUT_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	USER_LOCKOUT_COUNT_MAX	VARCHAR2(256)		 NOT NULL
);

ALTER TABLE WLSecurityTest_THRESH ADD constraint PK_WLSecurityTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLSecurityTest_THRESH ON WLSecurityTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TcpPortTest CASCADE CONSTRAINTS;

CREATE TABLE TcpPortTest
( 
	TRGT_HOST      			 varchar2(32),
    PORT_NO        			 varchar2(32),
    SITE_NAME      			 varchar2(64),
    INFO           			 varchar2(128),
	MSMT_HOST      			 varchar2(32),
	MSMT_TIME      			 date,
	SYN_SENT 				 Number(20,4) NOT NULL,
	SYN_SENT_ST 			 varchar2(32) NOT NULL,
	SYN_RECEIVED 			 Number(20,4) NOT NULL,
	SYN_RECEIVED_ST 		 varchar2(32) NOT NULL,
	ESTABLISHED 			 Number(20,4) NOT NULL,
	ESTABLISHED_ST 			 varchar2(32) NOT NULL,
	CLOSE_WAIT 				 Number(20,4) NOT NULL,
	CLOSE_WAIT_ST 			 varchar2(32) NOT NULL,
	FIN_WAIT_1 				 Number(20,4) NOT NULL,
	FIN_WAIT_1_ST 			 varchar2(32) NOT NULL,
	FIN_WAIT_2 				 Number(20,4) NOT NULL,
	FIN_WAIT_2_ST		     varchar2(32) NOT NULL,
	TIME_WAIT 				 Number(20,4) NOT NULL,
	TIME_WAIT_ST 			 varchar2(32) NOT NULL,
	SEND_QUEUE 				 Number(20,4) NOT NULL,
	SEND_QUEUE_ST			 varchar2(32) NOT NULL,
	RECEIVE_QUEUE			 Number(20,4) NOT NULL,
	RECEIVE_QUEUE_ST		 varchar2(32) NOT NULL
);

ALTER TABLE TcpPortTest ADD constraint PK_TcpPortTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TcpPortTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TcpPortTest_TREND
( 
	TRGT_HOST       varchar2(32),
    PORT_NO         varchar2(32),
    SITE_NAME       varchar2(64), 
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	SYN_SENT_MIN Number(20,4) NOT NULL,
	SYN_SENT_MAX Number(20,4) NOT NULL,
	SYN_SENT_STCNT varchar2(32) NOT NULL,
	SYN_RECEIVED_MIN Number(20,4) NOT NULL,
	SYN_RECEIVED_MAX Number(20,4) NOT NULL,
	SYN_RECEIVED_STCNT varchar2(32) NOT NULL,
	ESTABLISHED_MIN Number(20,4) NOT NULL,
	ESTABLISHED_MAX Number(20,4) NOT NULL,
	ESTABLISHED_STCNT varchar2(32) NOT NULL,
	CLOSE_WAIT_MIN Number(20,4) NOT NULL,
	CLOSE_WAIT_MAX Number(20,4) NOT NULL,
	CLOSE_WAIT_STCNT varchar2(32) NOT NULL,
	FIN_WAIT_1_MIN Number(20,4) NOT NULL,
	FIN_WAIT_1_MAX Number(20,4) NOT NULL,
	FIN_WAIT_1_STCNT varchar2(32) NOT NULL,
	FIN_WAIT_2_MIN Number(20,4) NOT NULL,
	FIN_WAIT_2_MAX Number(20,4) NOT NULL,
	FIN_WAIT_2_STCNT varchar2(32) NOT NULL,
	TIME_WAIT_MIN Number(20,4) NOT NULL,
	TIME_WAIT_MAX Number(20,4) NOT NULL,
	TIME_WAIT_STCNT varchar2(32) NOT NULL,
	SEND_QUEUE_MIN Number(20,4) NOT NULL,
	SEND_QUEUE_MAX Number(20,4) NOT NULL,
	SEND_QUEUE_STCNT varchar2(32) NOT NULL,
	RECEIVE_QUEUE_MIN Number(20,4) NOT NULL,
	RECEIVE_QUEUE_MAX Number(20,4) NOT NULL,
	RECEIVE_QUEUE_STCNT varchar2(32) NOT NULL
);

ALTER TABLE TcpPortTest_TREND ADD constraint PK_TcpPortTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TcpPortTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TcpPortTest_THRESH
( 
	TRGT_HOST       varchar2(32),
    PORT_NO         varchar2(32),
    SITE_NAME       varchar2(64),
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	SYN_SENT_MIN	VARCHAR2(256)	 NOT NULL,
	SYN_SENT_MAX	VARCHAR2(256)	 NOT NULL,
	SYN_RECEIVED_MIN	VARCHAR2(256)	 NOT NULL,
	SYN_RECEIVED_MAX	VARCHAR2(256)	 NOT NULL,
	ESTABLISHED_MIN	VARCHAR2(256)	 NOT NULL,
	ESTABLISHED_MAX	VARCHAR2(256)	 NOT NULL,
	CLOSE_WAIT_MIN	VARCHAR2(256)	 NOT NULL,
	CLOSE_WAIT_MAX	VARCHAR2(256)	 NOT NULL,
	FIN_WAIT_1_MIN	VARCHAR2(256)	 NOT NULL,
	FIN_WAIT_1_MAX	VARCHAR2(256)	 NOT NULL,
	FIN_WAIT_2_MIN	VARCHAR2(256)	 NOT NULL,
	FIN_WAIT_2_MAX	VARCHAR2(256)	 NOT NULL,
	TIME_WAIT_MIN	VARCHAR2(256)	 NOT NULL,
	TIME_WAIT_MAX	VARCHAR2(256)	 NOT NULL,
	SEND_QUEUE_MIN	VARCHAR2(256)	 NOT NULL,
	SEND_QUEUE_MAX	VARCHAR2(256)	 NOT NULL,
	RECEIVE_QUEUE_MIN	VARCHAR2(256)	 NOT NULL,
	RECEIVE_QUEUE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE TcpPortTest_THRESH ADD constraint PK_TcpPortTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TcpPortTest_THRESH ON TcpPortTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE FileTest CASCADE CONSTRAINTS;

CREATE TABLE FileTest
( 	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64),
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME       		date,
	CDUMPCNT 				Number(20,4) NOT NULL,
	CDUMPCNT_ST 			varchar2(32) NOT NULL,
	RECENTCDUMPCNT 			Number(20,4) NOT NULL,
	RECENTCDUMPCNT_ST 		varchar2(32) NOT NULL
);

ALTER TABLE FileTest ADD constraint PK_FileTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE FileTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE FileTest_TREND
( 	
	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64),
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME       		date,
	PERIOD       			varchar2(32),
	CDUMPCNT_MIN 			Number(20,4) NOT NULL,
	CDUMPCNT_MAX 			Number(20,4) NOT NULL,
	CDUMPCNT_STCNT 			varchar2(32) NOT NULL,
	RECENTCDUMPCNT_MIN		Number(20,4) NOT NULL,
	RECENTCDUMPCNT_MAX 		Number(20,4) NOT NULL,
	RECENTCDUMPCNT_STCNT 	varchar2(32) NOT NULL
);


ALTER TABLE FileTest_TREND ADD constraint PK_FileTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE FileTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE FileTest_THRESH
( 
	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64),
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME_START 		date,
	MSMT_TIME_END   		date,
	CDUMPCNT_MIN	VARCHAR2(256)	 NOT NULL,
	CDUMPCNT_MAX	VARCHAR2(256)	 NOT NULL,
	RECENTCDUMPCNT_MIN	VARCHAR2(256)	 NOT NULL,
	RECENTCDUMPCNT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE FileTest_THRESH ADD constraint PK_FileTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_FileTest_THRESH ON FileTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraArchiveTest CASCADE CONSTRAINTS;

CREATE TABLE OraArchiveTest
( 	
	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64),
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME       		date,
	ARCHIVE_LOG_MODE 		Number(20,4) NOT NULL,
	ARCHIVE_LOG_MODE_ST 	varchar2(32) NOT NULL
);

ALTER TABLE OraArchiveTest ADD constraint PK_OraArchiveTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE OraArchiveTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE OraArchiveTest_TREND
( 	
	TRGT_HOST       varchar2(32),
    PORT_NO         varchar2(32),
    SITE_NAME       varchar2(64),
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),	
	MSMT_TIME       date,	
	PERIOD       	varchar2(32),
	ARCHIVE_LOG_MODE_MIN Number(20,4) NOT NULL,
	ARCHIVE_LOG_MODE_MAX Number(20,4) NOT NULL,
	ARCHIVE_LOG_MODE_STCNT varchar2(32) NOT NULL
);

ALTER TABLE OraArchiveTest_TREND ADD constraint PK_OraArchiveTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraArchiveTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE OraArchiveTest_THRESH
( 
	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64), 
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME_START 		date,
	MSMT_TIME_END   		date,
	ARCHIVE_LOG_MODE_MIN	VARCHAR2(256)	 NOT NULL,
	ARCHIVE_LOG_MODE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE OraArchiveTest_THRESH ADD constraint PK_OraArchiveTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraArchiveTest_THRESH ON OraArchiveTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraUserTsTest CASCADE CONSTRAINTS;

CREATE TABLE OraUserTsTest
( 
	TRGT_HOST       varchar2(32),
    PORT_NO         varchar2(32),
    SITE_NAME       varchar2(64),
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	SYSTEM_TS_USERS Number(20,4) NOT NULL,
	SYSTEM_TS_USERS_ST varchar2(32) NOT NULL
);

ALTER TABLE OraUserTsTest ADD constraint PK_OraUserTsTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE OraUserTsTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE OraUserTsTest_TREND
( 	
	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64),
    INFO            		varchar2(128),
	MSMT_HOST      			varchar2(32),
	MSMT_TIME       		date,
	PERIOD       			varchar2(32),
	SYSTEM_TS_USERS_MIN 	Number(20,4) NOT NULL,
	SYSTEM_TS_USERS_MAX 	Number(20,4) NOT NULL,
	SYSTEM_TS_USERS_STCNT 	varchar2(32) NOT NULL
);

ALTER TABLE OraUserTsTest_TREND ADD constraint PK_OraUserTsTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraUserTsTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE OraUserTsTest_THRESH
( 	
	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64),
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME_START 		date,
	MSMT_TIME_END   		date,
	SYSTEM_TS_USERS_MIN	VARCHAR2(256)	 NOT NULL,
	SYSTEM_TS_USERS_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE OraUserTsTest_THRESH ADD constraint PK_OraUserTsTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraUserTsTest_THRESH ON OraUserTsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraParamsTest CASCADE CONSTRAINTS;

CREATE TABLE OraParamsTest
( 	
	TRGT_HOST       varchar2(32),
    PORT_NO         varchar2(32),
    SITE_NAME       varchar2(64),
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	NON_ORACLE_PARAMS Number(20,4) NOT NULL,
	NON_ORACLE_PARAMS_ST varchar2(32) NOT NULL
);

ALTER TABLE OraParamsTest ADD constraint PK_OraParamsTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE OraParamsTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE OraParamsTest_TREND
( 	
	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64), 
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME       		date,
	PERIOD       			varchar2(32),
	NON_ORACLE_PARAMS_MIN 	Number(20,4) NOT NULL,
	NON_ORACLE_PARAMS_MAX 	Number(20,4) NOT NULL,
	NON_ORACLE_PARAMS_STCNT varchar2(32) NOT NULL
);

ALTER TABLE OraParamsTest_TREND ADD constraint PK_OraParamsTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraParamsTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE OraParamsTest_THRESH
( 
	TRGT_HOST       		varchar2(32),
    PORT_NO        			varchar2(32),
    SITE_NAME       		varchar2(64),
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME_START 		date,
	MSMT_TIME_END   		date,
	NON_ORACLE_PARAMS_MIN	VARCHAR2(256)	 NOT NULL,
	NON_ORACLE_PARAMS_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE OraParamsTest_THRESH ADD constraint PK_OraParamsTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraParamsTest_THRESH ON OraParamsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraAlertTest CASCADE CONSTRAINTS;
CREATE TABLE OraAlertTest
( 
	TRGT_HOST       		varchar2(32),
	PORT_NO        			varchar2(32),      
	SITE_NAME       		varchar2(64), 
	INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME       		date,
	BDUMPERRORCNT 			Number(20,4) NOT NULL,
	BDUMPERRORCNT_ST 		varchar2(32) NOT NULL,
	FILE_SIZE 			Number(20,4) NOT NULL,
	FILE_SIZE_ST 			varchar2(32) NOT NULL,
	GROWTH_RATE 			Number(20,4) NOT NULL,
	GROWTH_RATE_ST 			varchar2(32) NOT NULL
);
ALTER TABLE OraAlertTest ADD constraint PK_OraAlertTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraAlertTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraAlertTest_TREND 
( 	
	TRGT_HOST       		varchar2(32),
	 PORT_NO         		varchar2(32),
	 SITE_NAME       		varchar2(64),
	 INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME      	 		date,
	PERIOD       			varchar2(32),
	BDUMPERRORCNT_MIN 		Number(20,4) NOT NULL,
	BDUMPERRORCNT_MAX 		Number(20,4) NOT NULL,
	BDUMPERRORCNT_STCNT 		varchar2(32) NOT NULL,
	FILE_SIZE_MIN 			Number(20,4) NOT NULL,
	FILE_SIZE_MAX 			Number(20,4) NOT NULL,
	FILE_SIZE_STCNT 		varchar2(32) NOT NULL,
	GROWTH_RATE_MIN 		Number(20,4) NOT NULL,
	GROWTH_RATE_MAX 		Number(20,4) NOT NULL,
	GROWTH_RATE_STCNT 		varchar2(32) NOT NULL

);
ALTER TABLE OraAlertTest_TREND ADD constraint PK_OraAlertTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraAlertTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraAlertTest_THRESH
( 
	TRGT_HOST       		varchar2(32),
	PORT_NO         		varchar2(32),
	 SITE_NAME       		varchar2(64),
	 INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME_START 		date,
	MSMT_TIME_END  	 		date,
	BDUMPERRORCNT_MIN		VARCHAR2(256)	 NOT NULL,
	BDUMPERRORCNT_MAX		VARCHAR2(256)	 NOT NULL,
	FILE_SIZE_MIN			VARCHAR2(256)	 NOT NULL,
	FILE_SIZE_MAX			VARCHAR2(256)	 NOT NULL,
	GROWTH_RATE_MIN			 VARCHAR2(256)	 NOT NULL,
	GROWTH_RATE_MAX			VARCHAR2(256)	 NOT NULL
);
ALTER TABLE OraAlertTest_THRESH ADD constraint PK_OraAlertTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraAlertTest_THRESH ON OraAlertTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraTsParamsTest CASCADE CONSTRAINTS;

CREATE TABLE OraTsParamsTest
( 	
	TRGT_HOST       			varchar2(32),
   	PORT_NO         			varchar2(32),
    SITE_NAME       			varchar2(64),  
    INFO            			varchar2(128),	
	MSMT_HOST       			varchar2(32),
	MSMT_TIME       			date,
	NON_LOCALLY_MANAGED_TS 		Number(20,4) NOT NULL,
	NON_LOCALLY_MANAGED_TS_ST 	varchar2(32) NOT NULL
);

ALTER TABLE OraTsParamsTest ADD constraint PK_OraTsParamsTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE OraTsParamsTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE OraTsParamsTest_TREND
( 	
	TRGT_HOST      					varchar2(32),
    PORT_NO         				varchar2(32),
    SITE_NAME       				varchar2(64),
    INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),	
	MSMT_TIME       				date,
	PERIOD       					varchar2(32),
	NON_LOCALLY_MANAGED_TS_MIN 		Number(20,4) NOT NULL,
	NON_LOCALLY_MANAGED_TS_MAX 		Number(20,4) NOT NULL,
	NON_LOCALLY_MANAGED_TS_STCNT 	varchar2(32) NOT NULL
);

ALTER TABLE OraTsParamsTest_TREND ADD constraint PK_OraTsParamsTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraTsParamsTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE OraTsParamsTest_THRESH
( 	
	TRGT_HOST       			varchar2(32),
    PORT_NO         			varchar2(32),
    SITE_NAME       			varchar2(64),
    INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME_START 			date,
	MSMT_TIME_END   			date,
	NON_LOCALLY_MANAGED_TS_MIN	VARCHAR2(256)	 NOT NULL,
	NON_LOCALLY_MANAGED_TS_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE OraTsParamsTest_THRESH ADD constraint PK_OraTsParamsTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraTsParamsTest_THRESH ON OraTsParamsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1EjbCacheTest CASCADE CONSTRAINTS;
CREATE TABLE Sun1EjbCacheTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
RESIZE_QUANTITY Number(20,4) NOT NULL,
RESIZE_QUANTITY_ST varchar2(32) NOT NULL,
CACHE_MISSES Number(20,4) NOT NULL,
CACHE_MISSES_ST varchar2(32) NOT NULL,
IDLE_TIMEOUT Number(20,4) NOT NULL,
IDLE_TIMEOUT_ST varchar2(32) NOT NULL,
NUM_PASSIVS Number(20,4) NOT NULL,
NUM_PASSIVS_ST varchar2(32) NOT NULL,
CACHE_HITS Number(20,4) NOT NULL,
CACHE_HITS_ST varchar2(32) NOT NULL,
NUM_PASSIV_ERRORS Number(20,4) NOT NULL,
NUM_PASSIV_ERRORS_ST varchar2(32) NOT NULL,
BEANS_IN_CACHE Number(20,4) NOT NULL,
BEANS_IN_CACHE_ST varchar2(32) NOT NULL,
EXPIRED_SESS_REMOVED Number(20,4) NOT NULL,
EXPIRED_SESS_REMOVED_ST varchar2(32) NOT NULL,
MAX_BEANS_IN_CACHE Number(20,4) NOT NULL,
MAX_BEANS_IN_CACHE_ST varchar2(32) NOT NULL,
NUM_PASSIV_SUCCESS Number(20,4) NOT NULL,
NUM_PASSIV_SUCCESS_ST varchar2(32) NOT NULL);

ALTER TABLE Sun1EjbCacheTest ADD constraint PK_Sun1EjbCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE Sun1EjbCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE Sun1EjbCacheTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
RESIZE_QUANTITY_MIN Number(20,4) NOT NULL,
RESIZE_QUANTITY_MAX Number(20,4) NOT NULL,
RESIZE_QUANTITY_STCNT varchar2(32) NOT NULL,
CACHE_MISSES_MIN Number(20,4) NOT NULL,
CACHE_MISSES_MAX Number(20,4) NOT NULL,
CACHE_MISSES_STCNT varchar2(32) NOT NULL,
IDLE_TIMEOUT_MIN Number(20,4) NOT NULL,
IDLE_TIMEOUT_MAX Number(20,4) NOT NULL,
IDLE_TIMEOUT_STCNT varchar2(32) NOT NULL,
NUM_PASSIVS_MIN Number(20,4) NOT NULL,
NUM_PASSIVS_MAX Number(20,4) NOT NULL,
NUM_PASSIVS_STCNT varchar2(32) NOT NULL,
CACHE_HITS_MIN Number(20,4) NOT NULL,
CACHE_HITS_MAX Number(20,4) NOT NULL,
CACHE_HITS_STCNT varchar2(32) NOT NULL,
NUM_PASSIV_ERRORS_MIN Number(20,4) NOT NULL,
NUM_PASSIV_ERRORS_MAX Number(20,4) NOT NULL,
NUM_PASSIV_ERRORS_STCNT varchar2(32) NOT NULL,
BEANS_IN_CACHE_MIN Number(20,4) NOT NULL,
BEANS_IN_CACHE_MAX Number(20,4) NOT NULL,
BEANS_IN_CACHE_STCNT varchar2(32) NOT NULL,
EXPIRED_SESS_REMOVED_MIN Number(20,4) NOT NULL,
EXPIRED_SESS_REMOVED_MAX Number(20,4) NOT NULL,
EXPIRED_SESS_REMOVED_STCNT varchar2(32) NOT NULL,
MAX_BEANS_IN_CACHE_MIN Number(20,4) NOT NULL,
MAX_BEANS_IN_CACHE_MAX Number(20,4) NOT NULL,
MAX_BEANS_IN_CACHE_STCNT varchar2(32) NOT NULL,
NUM_PASSIV_SUCCESS_MIN Number(20,4) NOT NULL,
NUM_PASSIV_SUCCESS_MAX Number(20,4) NOT NULL,
NUM_PASSIV_SUCCESS_STCNT varchar2(32) NOT NULL);

ALTER TABLE Sun1EjbCacheTest_TREND ADD constraint PK_Sun1EjbCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1EjbCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE Sun1EjbCacheTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
RESIZE_QUANTITY_MIN	VARCHAR2(256)	 NOT NULL,
RESIZE_QUANTITY_MAX	VARCHAR2(256)	 NOT NULL,
CACHE_MISSES_MIN	VARCHAR2(256)	 NOT NULL,
CACHE_MISSES_MAX	VARCHAR2(256)	 NOT NULL,
IDLE_TIMEOUT_MIN	VARCHAR2(256)	 NOT NULL,
IDLE_TIMEOUT_MAX	VARCHAR2(256)	 NOT NULL,
NUM_PASSIVS_MIN	VARCHAR2(256)	 NOT NULL,
NUM_PASSIVS_MAX	VARCHAR2(256)	 NOT NULL,
CACHE_HITS_MIN	VARCHAR2(256)	 NOT NULL,
CACHE_HITS_MAX	VARCHAR2(256)	 NOT NULL,
NUM_PASSIV_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
NUM_PASSIV_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
BEANS_IN_CACHE_MIN	VARCHAR2(256)	 NOT NULL,
BEANS_IN_CACHE_MAX	VARCHAR2(256)	 NOT NULL,
EXPIRED_SESS_REMOVED_MIN	VARCHAR2(256)	 NOT NULL,
EXPIRED_SESS_REMOVED_MAX	VARCHAR2(256)	 NOT NULL,
MAX_BEANS_IN_CACHE_MIN	VARCHAR2(256)	 NOT NULL,
MAX_BEANS_IN_CACHE_MAX	VARCHAR2(256)	 NOT NULL,
NUM_PASSIV_SUCCESS_MIN	VARCHAR2(256)	 NOT NULL,
NUM_PASSIV_SUCCESS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE Sun1EjbCacheTest_THRESH ADD constraint PK_Sun1EjbCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1EjbCacheTest_THRESH ON Sun1EjbCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1EjbPoolTest CASCADE CONSTRAINTS;
CREATE TABLE Sun1EjbPoolTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
IDLE_TIMEOUT Number(20,4) NOT NULL,
IDLE_TIMEOUT_ST varchar2(32) NOT NULL,
STEADY_POOL_SIZE Number(20,4) NOT NULL,
STEADY_POOL_SIZE_ST varchar2(32) NOT NULL,
TOTAL_BEANS_DESTROYED Number(20,4) NOT NULL,
TOTAL_BEANS_DESTROYED_ST varchar2(32) NOT NULL,
NUM_THREADS_WAITING Number(20,4) NOT NULL,
NUM_THREADS_WAITING_ST varchar2(32) NOT NULL,
NUM_BEANS_IN_POOL Number(20,4) NOT NULL,
NUM_BEANS_IN_POOL_ST varchar2(32) NOT NULL,
MAX_POOL_SIZE Number(20,4) NOT NULL,
MAX_POOL_SIZE_ST varchar2(32) NOT NULL,
POOL_RESIZE_QUANTITY Number(20,4) NOT NULL,
POOL_RESIZE_QUANTITY_ST varchar2(32) NOT NULL,
TOTAL_BEANS_CREATED Number(20,4) NOT NULL,
TOTAL_BEANS_CREATED_ST varchar2(32) NOT NULL);

ALTER TABLE Sun1EjbPoolTest ADD constraint PK_Sun1EjbPoolTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE Sun1EjbPoolTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE Sun1EjbPoolTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
IDLE_TIMEOUT_MIN Number(20,4) NOT NULL,
IDLE_TIMEOUT_MAX Number(20,4) NOT NULL,
IDLE_TIMEOUT_STCNT varchar2(32) NOT NULL,
STEADY_POOL_SIZE_MIN Number(20,4) NOT NULL,
STEADY_POOL_SIZE_MAX Number(20,4) NOT NULL,
STEADY_POOL_SIZE_STCNT varchar2(32) NOT NULL,
TOTAL_BEANS_DESTROYED_MIN Number(20,4) NOT NULL,
TOTAL_BEANS_DESTROYED_MAX Number(20,4) NOT NULL,
TOTAL_BEANS_DESTROYED_STCNT varchar2(32) NOT NULL,
NUM_THREADS_WAITING_MIN Number(20,4) NOT NULL,
NUM_THREADS_WAITING_MAX Number(20,4) NOT NULL,
NUM_THREADS_WAITING_STCNT varchar2(32) NOT NULL,
NUM_BEANS_IN_POOL_MIN Number(20,4) NOT NULL,
NUM_BEANS_IN_POOL_MAX Number(20,4) NOT NULL,
NUM_BEANS_IN_POOL_STCNT varchar2(32) NOT NULL,
MAX_POOL_SIZE_MIN Number(20,4) NOT NULL,
MAX_POOL_SIZE_MAX Number(20,4) NOT NULL,
MAX_POOL_SIZE_STCNT varchar2(32) NOT NULL,
POOL_RESIZE_QUANTITY_MIN Number(20,4) NOT NULL,
POOL_RESIZE_QUANTITY_MAX Number(20,4) NOT NULL,
POOL_RESIZE_QUANTITY_STCNT varchar2(32) NOT NULL,
TOTAL_BEANS_CREATED_MIN Number(20,4) NOT NULL,
TOTAL_BEANS_CREATED_MAX Number(20,4) NOT NULL,
TOTAL_BEANS_CREATED_STCNT varchar2(32) NOT NULL);

ALTER TABLE Sun1EjbPoolTest_TREND ADD constraint PK_Sun1EjbPoolTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1EjbPoolTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE Sun1EjbPoolTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
IDLE_TIMEOUT_MIN	VARCHAR2(256)	 NOT NULL,
IDLE_TIMEOUT_MAX	VARCHAR2(256)	 NOT NULL,
STEADY_POOL_SIZE_MIN	VARCHAR2(256)	 NOT NULL,
STEADY_POOL_SIZE_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_BEANS_DESTROYED_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_BEANS_DESTROYED_MAX	VARCHAR2(256)	 NOT NULL,
NUM_THREADS_WAITING_MIN	VARCHAR2(256)	 NOT NULL,
NUM_THREADS_WAITING_MAX	VARCHAR2(256)	 NOT NULL,
NUM_BEANS_IN_POOL_MIN	VARCHAR2(256)	 NOT NULL,
NUM_BEANS_IN_POOL_MAX	VARCHAR2(256)	 NOT NULL,
MAX_POOL_SIZE_MIN	VARCHAR2(256)	 NOT NULL,
MAX_POOL_SIZE_MAX	VARCHAR2(256)	 NOT NULL,
POOL_RESIZE_QUANTITY_MIN	VARCHAR2(256)	 NOT NULL,
POOL_RESIZE_QUANTITY_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_BEANS_CREATED_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_BEANS_CREATED_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE Sun1EjbPoolTest_THRESH ADD constraint PK_Sun1EjbPoolTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1EjbPoolTest_THRESH ON Sun1EjbPoolTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1HttpTest CASCADE CONSTRAINTS;
CREATE TABLE Sun1HttpTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
REQUESTS_COUNT Number(20,4) NOT NULL,
REQUESTS_COUNT_ST varchar2(32) NOT NULL,
KB_RECEIVED_COUNT Number(20,4) NOT NULL,
KB_RECEIVED_COUNT_ST varchar2(32) NOT NULL,
KB_TRANSMITTED_COUNT Number(20,4) NOT NULL,
KB_TRANSMITTED_COUNT_ST varchar2(32) NOT NULL,
MAX_TRANS_RATE_HWM Number(20,4) NOT NULL,
MAX_TRANS_RATE_HWM_ST varchar2(32) NOT NULL,
OPEN_CONNECTIONS_COUNT Number(20,4) NOT NULL,
OPEN_CONNECTIONS_COUNT_ST varchar2(32) NOT NULL,
MAX_OPEN_CONNS_HWM Number(20,4) NOT NULL,
MAX_OPEN_CONNS_HWM_ST varchar2(32) NOT NULL,
COUNT_2XX Number(20,4) NOT NULL,
COUNT_2XX_ST varchar2(32) NOT NULL,
COUNT_3XX Number(20,4) NOT NULL,
COUNT_3XX_ST varchar2(32) NOT NULL,
COUNT_4XX Number(20,4) NOT NULL,
COUNT_4XX_ST varchar2(32) NOT NULL,
COUNT_5XX Number(20,4) NOT NULL,
COUNT_5XX_ST varchar2(32) NOT NULL,
OTHER_RESPONSES_COUNT Number(20,4) NOT NULL,
OTHER_RESPONSES_COUNT_ST varchar2(32) NOT NULL);

ALTER TABLE Sun1HttpTest ADD constraint PK_Sun1HttpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE Sun1HttpTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE Sun1HttpTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
REQUESTS_COUNT_MIN Number(20,4) NOT NULL,
REQUESTS_COUNT_MAX Number(20,4) NOT NULL,
REQUESTS_COUNT_STCNT varchar2(32) NOT NULL,
KB_RECEIVED_COUNT_MIN Number(20,4) NOT NULL,
KB_RECEIVED_COUNT_MAX Number(20,4) NOT NULL,
KB_RECEIVED_COUNT_STCNT varchar2(32) NOT NULL,
KB_TRANSMITTED_COUNT_MIN Number(20,4) NOT NULL,
KB_TRANSMITTED_COUNT_MAX Number(20,4) NOT NULL,
KB_TRANSMITTED_COUNT_STCNT varchar2(32) NOT NULL,
MAX_TRANS_RATE_HWM_MIN Number(20,4) NOT NULL,
MAX_TRANS_RATE_HWM_MAX Number(20,4) NOT NULL,
MAX_TRANS_RATE_HWM_STCNT varchar2(32) NOT NULL,
OPEN_CONNECTIONS_COUNT_MIN Number(20,4) NOT NULL,
OPEN_CONNECTIONS_COUNT_MAX Number(20,4) NOT NULL,
OPEN_CONNECTIONS_COUNT_STCNT varchar2(32) NOT NULL,
MAX_OPEN_CONNS_HWM_MIN Number(20,4) NOT NULL,
MAX_OPEN_CONNS_HWM_MAX Number(20,4) NOT NULL,
MAX_OPEN_CONNS_HWM_STCNT varchar2(32) NOT NULL,
COUNT_2XX_MIN Number(20,4) NOT NULL,
COUNT_2XX_MAX Number(20,4) NOT NULL,
COUNT_2XX_STCNT varchar2(32) NOT NULL,
COUNT_3XX_MIN Number(20,4) NOT NULL,
COUNT_3XX_MAX Number(20,4) NOT NULL,
COUNT_3XX_STCNT varchar2(32) NOT NULL,
COUNT_4XX_MIN Number(20,4) NOT NULL,
COUNT_4XX_MAX Number(20,4) NOT NULL,
COUNT_4XX_STCNT varchar2(32) NOT NULL,
COUNT_5XX_MIN Number(20,4) NOT NULL,
COUNT_5XX_MAX Number(20,4) NOT NULL,
COUNT_5XX_STCNT varchar2(32) NOT NULL,
OTHER_RESPONSES_COUNT_MIN Number(20,4) NOT NULL,
OTHER_RESPONSES_COUNT_MAX Number(20,4) NOT NULL,
OTHER_RESPONSES_COUNT_STCNT varchar2(32) NOT NULL);

ALTER TABLE Sun1HttpTest_TREND ADD constraint PK_Sun1HttpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1HttpTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE Sun1HttpTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
REQUESTS_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
REQUESTS_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
KB_RECEIVED_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
KB_RECEIVED_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
KB_TRANSMITTED_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
KB_TRANSMITTED_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
MAX_TRANS_RATE_HWM_MIN	VARCHAR2(256)	 NOT NULL,
MAX_TRANS_RATE_HWM_MAX	VARCHAR2(256)	 NOT NULL,
OPEN_CONNECTIONS_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
OPEN_CONNECTIONS_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
MAX_OPEN_CONNS_HWM_MIN	VARCHAR2(256)	 NOT NULL,
MAX_OPEN_CONNS_HWM_MAX	VARCHAR2(256)	 NOT NULL,
COUNT_2XX_MIN	VARCHAR2(256)	 NOT NULL,
COUNT_2XX_MAX	VARCHAR2(256)	 NOT NULL,
COUNT_3XX_MIN	VARCHAR2(256)	 NOT NULL,
COUNT_3XX_MAX	VARCHAR2(256)	 NOT NULL,
COUNT_4XX_MIN	VARCHAR2(256)	 NOT NULL,
COUNT_4XX_MAX	VARCHAR2(256)	 NOT NULL,
COUNT_5XX_MIN	VARCHAR2(256)	 NOT NULL,
COUNT_5XX_MAX	VARCHAR2(256)	 NOT NULL,
OTHER_RESPONSES_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
OTHER_RESPONSES_COUNT_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE Sun1HttpTest_THRESH ADD constraint PK_Sun1HttpTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1HttpTest_THRESH ON Sun1HttpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1JdbcTest CASCADE CONSTRAINTS;
CREATE TABLE Sun1JdbcTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_THREADS_WAITING Number(20,4) NOT NULL,
TOTAL_THREADS_WAITING_ST varchar2(32) NOT NULL,
TOTAL_CONNS_FAILED Number(20,4) NOT NULL,
TOTAL_CONNS_FAILED_ST varchar2(32) NOT NULL,
TOTAL_CONNS_TIMED_OUT Number(20,4) NOT NULL,
TOTAL_CONNS_TIMED_OUT_ST varchar2(32) NOT NULL);

ALTER TABLE Sun1JdbcTest ADD constraint PK_Sun1JdbcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE Sun1JdbcTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE Sun1JdbcTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_THREADS_WAITING_MIN Number(20,4) NOT NULL,
TOTAL_THREADS_WAITING_MAX Number(20,4) NOT NULL,
TOTAL_THREADS_WAITING_STCNT varchar2(32) NOT NULL,
TOTAL_CONNS_FAILED_MIN Number(20,4) NOT NULL,
TOTAL_CONNS_FAILED_MAX Number(20,4) NOT NULL,
TOTAL_CONNS_FAILED_STCNT varchar2(32) NOT NULL,
TOTAL_CONNS_TIMED_OUT_MIN Number(20,4) NOT NULL,
TOTAL_CONNS_TIMED_OUT_MAX Number(20,4) NOT NULL,
TOTAL_CONNS_TIMED_OUT_STCNT varchar2(32) NOT NULL);

ALTER TABLE Sun1JdbcTest_TREND ADD constraint PK_Sun1JdbcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1JdbcTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE Sun1JdbcTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_THREADS_WAITING_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_THREADS_WAITING_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_CONNS_FAILED_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_CONNS_FAILED_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_CONNS_TIMED_OUT_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_CONNS_TIMED_OUT_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE Sun1JdbcTest_THRESH ADD constraint PK_Sun1JdbcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1JdbcTest_THRESH ON Sun1JdbcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1TxTest CASCADE CONSTRAINTS;
CREATE TABLE Sun1TxTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_TX_COMPLETED Number(20,4) NOT NULL,
TOTAL_TX_COMPLETED_ST varchar2(32) NOT NULL,
TOTAL_TX_ROLLED_BACK Number(20,4) NOT NULL,
TOTAL_TX_ROLLED_BACK_ST varchar2(32) NOT NULL,
TOTAL_TX_INFLIGHT Number(20,4) NOT NULL,
TOTAL_TX_INFLIGHT_ST varchar2(32) NOT NULL);

ALTER TABLE Sun1TxTest ADD constraint PK_Sun1TxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE Sun1TxTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE Sun1TxTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_TX_COMPLETED_MIN Number(20,4) NOT NULL,
TOTAL_TX_COMPLETED_MAX Number(20,4) NOT NULL,
TOTAL_TX_COMPLETED_STCNT varchar2(32) NOT NULL,
TOTAL_TX_ROLLED_BACK_MIN Number(20,4) NOT NULL,
TOTAL_TX_ROLLED_BACK_MAX Number(20,4) NOT NULL,
TOTAL_TX_ROLLED_BACK_STCNT varchar2(32) NOT NULL,
TOTAL_TX_INFLIGHT_MIN Number(20,4) NOT NULL,
TOTAL_TX_INFLIGHT_MAX Number(20,4) NOT NULL,
TOTAL_TX_INFLIGHT_STCNT varchar2(32) NOT NULL);

ALTER TABLE Sun1TxTest_TREND ADD constraint PK_Sun1TxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1TxTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE Sun1TxTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_TX_COMPLETED_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_TX_COMPLETED_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_TX_ROLLED_BACK_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_TX_ROLLED_BACK_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_TX_INFLIGHT_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_TX_INFLIGHT_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE Sun1TxTest_THRESH ADD constraint PK_Sun1TxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1TxTest_THRESH ON Sun1TxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxAppTest CASCADE CONSTRAINTS;
CREATE TABLE CtxAppTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NUMBER_OF_PROCESSES Number(20,4) NOT NULL,
NUMBER_OF_PROCESSES_ST varchar2(32) NOT NULL,
CPU_USAGE Number(20,4) NOT NULL,
CPU_USAGE_ST varchar2(32) NOT NULL,
MEMORY_USAGE Number(20,4) NOT NULL,
MEMORY_USAGE_ST varchar2(32) NOT NULL,
HANDLE_COUNT Number(20,4) NOT NULL,
HANDLE_COUNT_ST varchar2(32) NOT NULL,
NO_OF_THREADS Number(20,4) NOT NULL,
NO_OF_THREADS_ST varchar2(32) NOT NULL,
IO_DATA_RATE Number(20,4) NOT NULL,
IO_DATA_RATE_ST varchar2(32) NOT NULL,
IO_DATA_OPER_RATE Number(20,4) NOT NULL,
IO_DATA_OPER_RATE_ST varchar2(32) NOT NULL,
IO_READ_DATA_RATE Number(20,4) NOT NULL,
IO_READ_DATA_RATE_ST varchar2(32) NOT NULL,
IO_WRITE_DATA_RATE Number(20,4) NOT NULL,
IO_WRITE_DATA_RATE_ST varchar2(32) NOT NULL,
PAGE_FAULT_RATE Number(20,4) NOT NULL,
PAGE_FAULT_RATE_ST varchar2(32) NOT NULL,
VIRTUAL_MEMORY_USED Number(20,4) NOT NULL,
VIRTUAL_MEMORY_USED_ST varchar2(32) NOT NULL,
MEMORY_USED Number(20,4) NOT NULL,
MEMORY_USED_ST varchar2(32) NOT NULL);

ALTER TABLE CtxAppTest ADD constraint PK_CtxAppTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxAppTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxAppTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NUMBER_OF_PROCESSES_MIN Number(20,4) NOT NULL,
NUMBER_OF_PROCESSES_MAX Number(20,4) NOT NULL,
NUMBER_OF_PROCESSES_STCNT varchar2(32) NOT NULL,
CPU_USAGE_MIN Number(20,4) NOT NULL,
CPU_USAGE_MAX Number(20,4) NOT NULL,
CPU_USAGE_STCNT varchar2(32) NOT NULL,
MEMORY_USAGE_MIN Number(20,4) NOT NULL,
MEMORY_USAGE_MAX Number(20,4) NOT NULL,
MEMORY_USAGE_STCNT varchar2(32) NOT NULL,
HANDLE_COUNT_MIN Number(20,4) NOT NULL,
HANDLE_COUNT_MAX Number(20,4) NOT NULL,
HANDLE_COUNT_STCNT varchar2(32) NOT NULL,
NO_OF_THREADS_MIN Number(20,4) NOT NULL,
NO_OF_THREADS_MAX Number(20,4) NOT NULL,
NO_OF_THREADS_STCNT varchar2(32) NOT NULL,
IO_DATA_RATE_MIN Number(20,4) NOT NULL,
IO_DATA_RATE_MAX Number(20,4) NOT NULL,
IO_DATA_RATE_STCNT varchar2(32) NOT NULL,
IO_DATA_OPER_RATE_MIN Number(20,4) NOT NULL,
IO_DATA_OPER_RATE_MAX Number(20,4) NOT NULL,
IO_DATA_OPER_RATE_STCNT varchar2(32) NOT NULL,
IO_READ_DATA_RATE_MIN Number(20,4) NOT NULL,
IO_READ_DATA_RATE_MAX Number(20,4) NOT NULL,
IO_READ_DATA_RATE_STCNT varchar2(32) NOT NULL,
IO_WRITE_DATA_RATE_MIN Number(20,4) NOT NULL,
IO_WRITE_DATA_RATE_MAX Number(20,4) NOT NULL,
IO_WRITE_DATA_RATE_STCNT varchar2(32) NOT NULL,
PAGE_FAULT_RATE_MIN Number(20,4) NOT NULL,
PAGE_FAULT_RATE_MAX Number(20,4) NOT NULL,
PAGE_FAULT_RATE_STCNT varchar2(32) NOT NULL,
VIRTUAL_MEMORY_USED_MIN Number(20,4) NOT NULL,
VIRTUAL_MEMORY_USED_MAX Number(20,4) NOT NULL,
VIRTUAL_MEMORY_USED_STCNT varchar2(32) NOT NULL,
MEMORY_USED_MIN Number(20,4) NOT NULL,
MEMORY_USED_MAX Number(20,4) NOT NULL,
MEMORY_USED_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxAppTest_TREND ADD constraint PK_CtxAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxAppTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxAppTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NUMBER_OF_PROCESSES_MIN	VARCHAR2(256)	 NOT NULL,
NUMBER_OF_PROCESSES_MAX	VARCHAR2(256)	 NOT NULL,
CPU_USAGE_MIN	VARCHAR2(256)	 NOT NULL,
CPU_USAGE_MAX	VARCHAR2(256)	 NOT NULL,
MEMORY_USAGE_MIN	VARCHAR2(256)	 NOT NULL,
MEMORY_USAGE_MAX	VARCHAR2(256)	 NOT NULL,
HANDLE_COUNT_MIN VARCHAR2(256) NOT NULL,
HANDLE_COUNT_MAX VARCHAR2(256) NOT NULL,
NO_OF_THREADS_MIN VARCHAR2(256) NOT NULL,
NO_OF_THREADS_MAX VARCHAR2(256) NOT NULL,
IO_DATA_RATE_MIN VARCHAR2(256) NOT NULL,
IO_DATA_RATE_MAX VARCHAR2(256) NOT NULL,
IO_DATA_OPER_RATE_MIN VARCHAR2(256) NOT NULL,
IO_DATA_OPER_RATE_MAX VARCHAR2(256) NOT NULL,
IO_READ_DATA_RATE_MIN VARCHAR2(256) NOT NULL,
IO_READ_DATA_RATE_MAX VARCHAR2(256) NOT NULL,
IO_WRITE_DATA_RATE_MIN VARCHAR2(256) NOT NULL,
IO_WRITE_DATA_RATE_MAX VARCHAR2(256) NOT NULL,
PAGE_FAULT_RATE_MIN VARCHAR2(256) NOT NULL,
PAGE_FAULT_RATE_MAX VARCHAR2(256) NOT NULL,
VIRTUAL_MEMORY_USED_MIN VARCHAR2(256) NOT NULL,
VIRTUAL_MEMORY_USED_MAX VARCHAR2(256) NOT NULL,
MEMORY_USED_MIN VARCHAR2(256) NOT NULL,
MEMORY_USED_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE CtxAppTest_THRESH ADD constraint PK_CtxAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxAppTest_THRESH ON CtxAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxMfAppTest CASCADE CONSTRAINTS;
CREATE TABLE CtxMfAppTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NUMBER_OF_PROCESSES Number(20,4) NOT NULL,
NUMBER_OF_PROCESSES_ST varchar2(32) NOT NULL,
CPU_USAGE Number(20,4) NOT NULL,
CPU_USAGE_ST varchar2(32) NOT NULL,
MEMORY_USAGE Number(20,4) NOT NULL,
MEMORY_USAGE_ST varchar2(32) NOT NULL);

ALTER TABLE CtxMfAppTest ADD constraint PK_CtxMfAppTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxMfAppTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxMfAppTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NUMBER_OF_PROCESSES_MIN Number(20,4) NOT NULL,
NUMBER_OF_PROCESSES_MAX Number(20,4) NOT NULL,
NUMBER_OF_PROCESSES_STCNT varchar2(32) NOT NULL,
CPU_USAGE_MIN Number(20,4) NOT NULL,
CPU_USAGE_MAX Number(20,4) NOT NULL,
CPU_USAGE_STCNT varchar2(32) NOT NULL,
MEMORY_USAGE_MIN Number(20,4) NOT NULL,
MEMORY_USAGE_MAX Number(20,4) NOT NULL,
MEMORY_USAGE_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxMfAppTest_TREND ADD constraint PK_CtxMfAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxMfAppTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxMfAppTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NUMBER_OF_PROCESSES_MIN	VARCHAR2(256)	 NOT NULL,
NUMBER_OF_PROCESSES_MAX	VARCHAR2(256)	 NOT NULL,
CPU_USAGE_MIN	VARCHAR2(256)	 NOT NULL,
CPU_USAGE_MAX	VARCHAR2(256)	 NOT NULL,
MEMORY_USAGE_MIN	VARCHAR2(256)	 NOT NULL,
MEMORY_USAGE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CtxMfAppTest_THRESH ADD constraint PK_CtxMfAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxMfAppTest_THRESH ON CtxMfAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxClientTest CASCADE CONSTRAINTS;
CREATE TABLE CtxClientTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CURRENT_CONNS Number(20,4) NOT NULL,
CURRENT_CONNS_ST varchar2(32) NOT NULL,
NEW_CONNS_ADDED Number(20,4) NOT NULL,
NEW_CONNS_ADDED_ST varchar2(32) NOT NULL,
OLD_CONNS_REMOVED Number(20,4) NOT NULL,
OLD_CONNS_REMOVED_ST varchar2(32) NOT NULL,
AVG_CONN_DURATION Number(20,4) NOT NULL,
AVG_CONN_DURATION_ST varchar2(32) NOT NULL);

ALTER TABLE CtxClientTest ADD constraint PK_CtxClientTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxClientTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxClientTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CURRENT_CONNS_MIN Number(20,4) NOT NULL,
CURRENT_CONNS_MAX Number(20,4) NOT NULL,
CURRENT_CONNS_STCNT varchar2(32) NOT NULL,
NEW_CONNS_ADDED_MIN Number(20,4) NOT NULL,
NEW_CONNS_ADDED_MAX Number(20,4) NOT NULL,
NEW_CONNS_ADDED_STCNT varchar2(32) NOT NULL,
OLD_CONNS_REMOVED_MIN Number(20,4) NOT NULL,
OLD_CONNS_REMOVED_MAX Number(20,4) NOT NULL,
OLD_CONNS_REMOVED_STCNT varchar2(32) NOT NULL,
AVG_CONN_DURATION_MIN Number(20,4) NOT NULL,
AVG_CONN_DURATION_MAX Number(20,4) NOT NULL,
AVG_CONN_DURATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxClientTest_TREND ADD constraint PK_CtxClientTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxClientTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxClientTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CURRENT_CONNS_MIN	VARCHAR2(256)	 NOT NULL,
CURRENT_CONNS_MAX	VARCHAR2(256)	 NOT NULL,
NEW_CONNS_ADDED_MIN	VARCHAR2(256)	 NOT NULL,
NEW_CONNS_ADDED_MAX	VARCHAR2(256)	 NOT NULL,
OLD_CONNS_REMOVED_MIN	VARCHAR2(256)	 NOT NULL,
OLD_CONNS_REMOVED_MAX	VARCHAR2(256)	 NOT NULL,
AVG_CONN_DURATION_MIN	VARCHAR2(256)	 NOT NULL,
AVG_CONN_DURATION_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CtxClientTest_THRESH ADD constraint PK_CtxClientTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxClientTest_THRESH ON CtxClientTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxImaTest CASCADE CONSTRAINTS;
CREATE TABLE CtxImaTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
BYTES_RECEIVED Number(20,4) NOT NULL,
BYTES_RECEIVED_ST varchar2(32) NOT NULL,
BYTES_SENT Number(20,4) NOT NULL,
BYTES_SENT_ST varchar2(32) NOT NULL,
NETWORK_CONNECTIONS Number(20,4) NOT NULL,
NETWORK_CONNECTIONS_ST varchar2(32) NOT NULL);

ALTER TABLE CtxImaTest ADD constraint PK_CtxImaTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxImaTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxImaTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
BYTES_RECEIVED_MIN Number(20,4) NOT NULL,
BYTES_RECEIVED_MAX Number(20,4) NOT NULL,
BYTES_RECEIVED_STCNT varchar2(32) NOT NULL,
BYTES_SENT_MIN Number(20,4) NOT NULL,
BYTES_SENT_MAX Number(20,4) NOT NULL,
BYTES_SENT_STCNT varchar2(32) NOT NULL,
NETWORK_CONNECTIONS_MIN Number(20,4) NOT NULL,
NETWORK_CONNECTIONS_MAX Number(20,4) NOT NULL,
NETWORK_CONNECTIONS_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxImaTest_TREND ADD constraint PK_CtxImaTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxImaTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxImaTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
BYTES_RECEIVED_MIN	VARCHAR2(256)	 NOT NULL,
BYTES_RECEIVED_MAX	VARCHAR2(256)	 NOT NULL,
BYTES_SENT_MIN	VARCHAR2(256)	 NOT NULL,
BYTES_SENT_MAX	VARCHAR2(256)	 NOT NULL,
NETWORK_CONNECTIONS_MIN	VARCHAR2(256)	 NOT NULL,
NETWORK_CONNECTIONS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CtxImaTest_THRESH ADD constraint PK_CtxImaTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxImaTest_THRESH ON CtxImaTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);



DROP TABLE CtxSessionTest CASCADE CONSTRAINTS;
CREATE TABLE CtxSessionTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
ACTIVE_SESSIONS Number(20,4) NOT NULL,
ACTIVE_SESSIONS_ST varchar2(32) NOT NULL,
IDLE_SESSIONS Number(20,4) NOT NULL,
IDLE_SESSIONS_ST varchar2(32) NOT NULL,
CONNECTED_SESSIONS Number(20,4) NOT NULL,
CONNECTED_SESSIONS_ST varchar2(32) NOT NULL,
CONNECTING_SESSIONS Number(20,4) NOT NULL,
CONNECTING_SESSIONS_ST varchar2(32) NOT NULL,
DISCONNECTED_SESSIONS Number(20,4) NOT NULL,
DISCONNECTED_SESSIONS_ST varchar2(32) NOT NULL,
LISTEN_SESSIONS Number(20,4) NOT NULL,
LISTEN_SESSIONS_ST varchar2(32) NOT NULL,
SHADOW_SESSIONS Number(20,4) NOT NULL,
SHADOW_SESSIONS_ST varchar2(32) NOT NULL,
DOWN_SESSIONS Number(20,4) NOT NULL,
DOWN_SESSIONS_ST varchar2(32) NOT NULL,
INIT_SESSIONS Number(20,4) NOT NULL,
INIT_SESSIONS_ST varchar2(32) NOT NULL);
 
CREATE INDEX IDX_CtxSessionTest ON CtxSessionTest(MSMT_TIME);
CREATE INDEX IDX1_CTXSESSIONTEST ON CTXSESSIONTEST (ACTIVE_SESSIONS);
ALTER TABLE CtxSessionTest ADD constraint PK_CtxSessionTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxSessionTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxSessionTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD        varchar2(32),
ACTIVE_SESSIONS_MIN Number(20,4) NOT NULL,
ACTIVE_SESSIONS_MAX Number(20,4) NOT NULL,
ACTIVE_SESSIONS_STCNT varchar2(32) NOT NULL,
IDLE_SESSIONS_MIN Number(20,4) NOT NULL,
IDLE_SESSIONS_MAX Number(20,4) NOT NULL,
IDLE_SESSIONS_STCNT varchar2(32) NOT NULL,
CONNECTED_SESSIONS_MIN Number(20,4) NOT NULL,
CONNECTED_SESSIONS_MAX Number(20,4) NOT NULL,
CONNECTED_SESSIONS_STCNT varchar2(32) NOT NULL,
CONNECTING_SESSIONS_MIN Number(20,4) NOT NULL,
CONNECTING_SESSIONS_MAX Number(20,4) NOT NULL,
CONNECTING_SESSIONS_STCNT varchar2(32) NOT NULL,
DISCONNECTED_SESSIONS_MIN Number(20,4) NOT NULL,
DISCONNECTED_SESSIONS_MAX Number(20,4) NOT NULL,
DISCONNECTED_SESSIONS_STCNT varchar2(32) NOT NULL,
LISTEN_SESSIONS_MIN Number(20,4) NOT NULL,
LISTEN_SESSIONS_MAX Number(20,4) NOT NULL,
LISTEN_SESSIONS_STCNT varchar2(32) NOT NULL,
SHADOW_SESSIONS_MIN Number(20,4) NOT NULL,
SHADOW_SESSIONS_MAX Number(20,4) NOT NULL,
SHADOW_SESSIONS_STCNT varchar2(32) NOT NULL,
DOWN_SESSIONS_MIN Number(20,4) NOT NULL,
DOWN_SESSIONS_MAX Number(20,4) NOT NULL,
DOWN_SESSIONS_STCNT varchar2(32) NOT NULL,
INIT_SESSIONS_MIN Number(20,4) NOT NULL,
INIT_SESSIONS_MAX Number(20,4) NOT NULL,
INIT_SESSIONS_STCNT varchar2(32) NOT NULL);
 
ALTER TABLE CtxSessionTest_TREND ADD constraint PK_CtxSessionTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxSessionTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxSessionTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
ACTIVE_SESSIONS_MIN VARCHAR2(256) NOT NULL,
ACTIVE_SESSIONS_MAX VARCHAR2(256) NOT NULL,
IDLE_SESSIONS_MIN VARCHAR2(256) NOT NULL,
IDLE_SESSIONS_MAX VARCHAR2(256) NOT NULL,
CONNECTED_SESSIONS_MIN VARCHAR2(256) NOT NULL,
CONNECTED_SESSIONS_MAX VARCHAR2(256) NOT NULL,
CONNECTING_SESSIONS_MIN VARCHAR2(256) NOT NULL,
CONNECTING_SESSIONS_MAX VARCHAR2(256) NOT NULL,
DISCONNECTED_SESSIONS_MIN VARCHAR2(256) NOT NULL,
DISCONNECTED_SESSIONS_MAX VARCHAR2(256) NOT NULL,
LISTEN_SESSIONS_MIN VARCHAR2(256) NOT NULL,
LISTEN_SESSIONS_MAX VARCHAR2(256) NOT NULL,
SHADOW_SESSIONS_MIN VARCHAR2(256) NOT NULL,
SHADOW_SESSIONS_MAX VARCHAR2(256) NOT NULL,
DOWN_SESSIONS_MIN VARCHAR2(256) NOT NULL,
DOWN_SESSIONS_MAX VARCHAR2(256) NOT NULL,
INIT_SESSIONS_MIN VARCHAR2(256) NOT NULL,
INIT_SESSIONS_MAX VARCHAR2(256) NOT NULL);
 
ALTER TABLE CtxSessionTest_THRESH ADD constraint PK_CtxSessionTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxSessionTest_THRESH ON CtxSessionTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_CtxSessionTest ON CtxSessionTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_CtxSessionTest ON CtxSessionTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE CtxMfXpSrvTest CASCADE CONSTRAINTS;
CREATE TABLE CtxMfXpSrvTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
APP_ENUMS_RT Number(20,4) NOT NULL,
APP_ENUMS_RT_ST varchar2(32) NOT NULL,
APP_RESOLUTIONS_RT Number(20,4) NOT NULL,
APP_RESOLUTIONS_RT_ST varchar2(32) NOT NULL,
DSTORE_CONN_FAILURE Number(20,4) NOT NULL,
DSTORE_CONN_FAILURE_ST varchar2(32) NOT NULL,
DSTORE_KB_READ_RT Number(20,4) NOT NULL,
DSTORE_KB_READ_RT_ST varchar2(32) NOT NULL,
DSTORE_KB_WRITTEN_RT Number(20,4) NOT NULL,
DSTORE_KB_WRITTEN_RT_ST varchar2(32) NOT NULL,
DYNSTORE_KB_READ_RT Number(20,4) NOT NULL,
DYNSTORE_KB_READ_RT_ST varchar2(32) NOT NULL,
DYNSTORE_KB_WRITTEN_RT Number(20,4) NOT NULL,
DYNSTORE_KB_WRITTEN_RT_ST varchar2(32) NOT NULL,
LH_CACHE_KB_READ_RT Number(20,4) NOT NULL,
LH_CACHE_KB_READ_RT_ST varchar2(32) NOT NULL,
LH_CACHE_KB_WRITTEN_RT Number(20,4) NOT NULL,
LH_CACHE_KB_WRITTEN_RT_ST varchar2(32) NOT NULL,
ZONE_ELECTIONS Number(20,4) NOT NULL,
ZONE_ELECTIONS_ST varchar2(32) NOT NULL,
ZONE_ELECTIONS_W Number(20,4) NOT NULL,
ZONE_ELECTIONS_W_ST varchar2(32) NOT NULL
);

ALTER TABLE CtxMfXpSrvTest ADD constraint PK_CtxMfXpSrvTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxMfXpSrvTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxMfXpSrvTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
APP_ENUMS_RT_MIN Number(20,4) NOT NULL,
APP_ENUMS_RT_MAX Number(20,4) NOT NULL,
APP_ENUMS_RT_STCNT varchar2(32) NOT NULL,
APP_RESOLUTIONS_RT_MIN Number(20,4) NOT NULL,
APP_RESOLUTIONS_RT_MAX Number(20,4) NOT NULL,
APP_RESOLUTIONS_RT_STCNT varchar2(32) NOT NULL,
DSTORE_CONN_FAILURE_MIN Number(20,4) NOT NULL,
DSTORE_CONN_FAILURE_MAX Number(20,4) NOT NULL,
DSTORE_CONN_FAILURE_STCNT varchar2(32) NOT NULL,
DSTORE_KB_READ_RT_MIN Number(20,4) NOT NULL,
DSTORE_KB_READ_RT_MAX Number(20,4) NOT NULL,
DSTORE_KB_READ_RT_STCNT varchar2(32) NOT NULL,
DSTORE_KB_WRITTEN_RT_MIN Number(20,4) NOT NULL,
DSTORE_KB_WRITTEN_RT_MAX Number(20,4) NOT NULL,
DSTORE_KB_WRITTEN_RT_STCNT varchar2(32) NOT NULL,
DYNSTORE_KB_READ_RT_MIN Number(20,4) NOT NULL,
DYNSTORE_KB_READ_RT_MAX Number(20,4) NOT NULL,
DYNSTORE_KB_READ_RT_STCNT varchar2(32) NOT NULL,
DYNSTORE_KB_WRITTEN_RT_MIN Number(20,4) NOT NULL,
DYNSTORE_KB_WRITTEN_RT_MAX Number(20,4) NOT NULL,
DYNSTORE_KB_WRITTEN_RT_STCNT varchar2(32) NOT NULL,
LH_CACHE_KB_READ_RT_MIN Number(20,4) NOT NULL,
LH_CACHE_KB_READ_RT_MAX Number(20,4) NOT NULL,
LH_CACHE_KB_READ_RT_STCNT varchar2(32) NOT NULL,
LH_CACHE_KB_WRITTEN_RT_MIN Number(20,4) NOT NULL,
LH_CACHE_KB_WRITTEN_RT_MAX Number(20,4) NOT NULL,
LH_CACHE_KB_WRITTEN_RT_STCNT varchar2(32) NOT NULL,
ZONE_ELECTIONS_MIN Number(20,4) NOT NULL,
ZONE_ELECTIONS_MAX Number(20,4) NOT NULL,
ZONE_ELECTIONS_STCNT varchar2(32) NOT NULL,
ZONE_ELECTIONS_W_MIN Number(20,4) NOT NULL,
ZONE_ELECTIONS_W_MAX Number(20,4) NOT NULL,
ZONE_ELECTIONS_W_STCNT varchar2(32) NOT NULL
);

ALTER TABLE CtxMfXpSrvTest_TREND ADD constraint PK_CtxMfXpSrvTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxMfXpSrvTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxMfXpSrvTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
APP_ENUMS_RT_MIN	VARCHAR2(256)	 NOT NULL,
APP_ENUMS_RT_MAX	VARCHAR2(256)	 NOT NULL,
APP_RESOLUTIONS_RT_MIN	VARCHAR2(256)	 NOT NULL,
APP_RESOLUTIONS_RT_MAX	VARCHAR2(256)	 NOT NULL,
DSTORE_CONN_FAILURE_MIN	VARCHAR2(256)	 NOT NULL,
DSTORE_CONN_FAILURE_MAX	VARCHAR2(256)	 NOT NULL,
DSTORE_KB_READ_RT_MIN	VARCHAR2(256)	 NOT NULL,
DSTORE_KB_READ_RT_MAX	VARCHAR2(256)	 NOT NULL,
DSTORE_KB_WRITTEN_RT_MIN	VARCHAR2(256)	 NOT NULL,
DSTORE_KB_WRITTEN_RT_MAX	VARCHAR2(256)	 NOT NULL,
DYNSTORE_KB_READ_RT_MIN	VARCHAR2(256)	 NOT NULL,
DYNSTORE_KB_READ_RT_MAX	VARCHAR2(256)	 NOT NULL,
DYNSTORE_KB_WRITTEN_RT_MIN	VARCHAR2(256)	 NOT NULL,
DYNSTORE_KB_WRITTEN_RT_MAX	VARCHAR2(256)	 NOT NULL,
LH_CACHE_KB_READ_RT_MIN	VARCHAR2(256)	 NOT NULL,
LH_CACHE_KB_READ_RT_MAX	VARCHAR2(256)	 NOT NULL,
LH_CACHE_KB_WRITTEN_RT_MIN	VARCHAR2(256)	 NOT NULL,
LH_CACHE_KB_WRITTEN_RT_MAX	VARCHAR2(256)	 NOT NULL,
ZONE_ELECTIONS_MIN	VARCHAR2(256)	 NOT NULL,
ZONE_ELECTIONS_MAX	VARCHAR2(256)	 NOT NULL,
ZONE_ELECTIONS_W_MIN	VARCHAR2(256)	 NOT NULL,
ZONE_ELECTIONS_W_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE CtxMfXpSrvTest_THRESH ADD constraint PK_CtxMfXpSrvTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxMfXpSrvTest_THRESH ON CtxMfXpSrvTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxXpUserTest CASCADE CONSTRAINTS;
CREATE TABLE CtxXpUserTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NO_OF_SESSIONS Number(20,4) NOT NULL,
NO_OF_SESSIONS_ST varchar2(32) NOT NULL,
LATENCY_LAST Number(20,4) NOT NULL,
LATENCY_LAST_ST varchar2(32) NOT NULL,
LATENCY_AVG Number(20,4) NOT NULL,
LATENCY_AVG_ST varchar2(32) NOT NULL,
LATENCY_DEVN Number(20,4) NOT NULL,
LATENCY_DEVN_ST varchar2(32) NOT NULL,
MEM_UTIL Number(20,4) NOT NULL,
MEM_UTIL_ST varchar2(32) NOT NULL,
CPU_UTIL Number(20,4) NOT NULL,
CPU_UTIL_ST varchar2(32) NOT NULL,
INPUT_BANDWIDTH Number(20,4) NOT NULL,
INPUT_BANDWIDTH_ST varchar2(32) NOT NULL,
OUTPUT_BANDWIDTH Number(20,4) NOT NULL,
OUTPUT_BANDWIDTH_ST varchar2(32) NOT NULL,
INPUT_LINE_SPEED Number(20,4) NOT NULL,
INPUT_LINE_SPEED_ST varchar2(32) NOT NULL,
OUTPUT_LINE_SPEED Number(20,4) NOT NULL,
OUTPUT_LINE_SPEED_ST varchar2(32) NOT NULL,
INPUT_COMPRESSION Number(20,4) NOT NULL,
INPUT_COMPRESSION_ST varchar2(32) NOT NULL,
OUTPUT_COMPRESSION Number(20,4) NOT NULL,
OUTPUT_COMPRESSION_ST varchar2(32) NOT NULL,
IO_READS Number(20,4) NOT NULL,
IO_READS_ST varchar2(32) NOT NULL,
IO_WRITES Number(20,4) NOT NULL,
IO_WRITES_ST varchar2(32) NOT NULL,
PAGE_FAULTS Number(20,4) NOT NULL,
PAGE_FAULTS_ST varchar2(32) NOT NULL,
VIRTUAL_MEM Number(20,4) NOT NULL,
VIRTUAL_MEM_ST varchar2(32) NOT NULL,
HANDLES Number(20,4) NOT NULL,
HANDLES_ST varchar2(32) NOT NULL,
INPUT_AUDIO Number(20,4) NOT NULL,
INPUT_AUDIO_ST varchar2(32) NOT NULL,
OUTPUT_AUDIO Number(20,4) NOT NULL,
OUTPUT_AUDIO_ST varchar2(32) NOT NULL,
INPUT_COM Number(20,4) NOT NULL,
INPUT_COM_ST varchar2(32) NOT NULL,
OUTPUT_COM Number(20,4) NOT NULL,
OUTPUT_COM_ST varchar2(32) NOT NULL,
INPUT_DRIVE Number(20,4) NOT NULL,
INPUT_DRIVE_ST varchar2(32) NOT NULL,
OUTPUT_DRIVE Number(20,4) NOT NULL,
OUTPUT_DRIVE_ST varchar2(32) NOT NULL,
INPUT_HDX Number(20,4) NOT NULL,
INPUT_HDX_ST varchar2(32) NOT NULL,
OUTPUT_HDX Number(20,4) NOT NULL,
OUTPUT_HDX_ST varchar2(32) NOT NULL,
INPUT_PRINTER Number(20,4) NOT NULL,
INPUT_PRINTER_ST varchar2(32) NOT NULL,
OUTPUT_PRINTER Number(20,4) NOT NULL,
OUTPUT_PRINTER_ST varchar2(32) NOT NULL,
INPUT_DATA Number(20,4) NOT NULL,
INPUT_DATA_ST varchar2(32) NOT NULL,
OUTPUT_DATA Number(20,4) NOT NULL,
OUTPUT_DATA_ST varchar2(32) NOT NULL,
INPUT_MULTI Number(20,4) NOT NULL,
INPUT_MULTI_ST varchar2(32) NOT NULL,
OUTPUT_MULTI Number(20,4) NOT NULL,
OUTPUT_MULTI_ST varchar2(32) NOT NULL,
INPUT_USB Number(20,4) NOT NULL,
INPUT_USB_ST varchar2(32) NOT NULL,
OUTPUT_USB Number(20,4) NOT NULL,
OUTPUT_USB_ST varchar2(32) NOT NULL,
CPU_UTIL_TIME Number(20,4) NOT NULL,
CPU_UTIL_TIME_ST varchar2(32) NOT NULL,
BANDWIDTH_USAGE Number(20,4) NOT NULL,
BANDWIDTH_USAGE_ST varchar2(32) NOT NULL,
INPUT_THINWIRE Number(20,4) NOT NULL,
INPUT_THINWIRE_ST varchar2(32) NOT NULL,
OUTPUT_THINWIRE Number(20,4) NOT NULL,
OUTPUT_THINWIRE_ST varchar2(32) NOT NULL,
INPUT_SEAMLESS Number(20,4) NOT NULL,
INPUT_SEAMLESS_ST varchar2(32) NOT NULL,
OUTPUT_SEAMLESS Number(20,4) NOT NULL,
OUTPUT_SEAMLESS_ST varchar2(32) NOT NULL,
RESOURCE_SHARES Number(20,4) NOT NULL,
RESOURCE_SHARES_ST varchar2(32) NOT NULL,
TOTAL_SESSION_DURATION Number(20,4) NOT NULL,
TOTAL_SESSION_DURATION_ST varchar2(32) NOT NULL,
IDLE_TIME_MEASUREPRD Number(20,4) NOT NULL,
IDLE_TIME_MEASUREPRD_ST varchar2(32) NOT NULL,
IDLE_TIME_DURATION Number(20,4) NOT NULL,
IDLE_TIME_DURATION_ST varchar2(32) NOT NULL,
TOTAL_IDLE_DURATION Number(20,4) NOT NULL,
TOTAL_IDLE_DURATION_ST varchar2(32) NOT NULL,
TOTAL_BANDWIDTH Number(20,4) NOT NULL,
TOTAL_BANDWIDTH_ST varchar2(32) NOT NULL,
MEMORY_USED Number(20,4) NOT NULL,
MEMORY_USED_ST varchar2(32) NOT NULL,
PROCESS_COUNT Number(20,4) NOT NULL,
PROCESS_COUNT_ST varchar2(32) NOT NULL);

CREATE INDEX IDX1_CTXXPUSERTEST ON CTXXPUSERTEST (PORT_NO , MSMT_TIME);
ALTER TABLE CtxXpUserTest ADD constraint PK_CtxXpUserTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxXpUserTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxXpUserTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NO_OF_SESSIONS_MIN Number(20,4) NOT NULL,
NO_OF_SESSIONS_MAX Number(20,4) NOT NULL,
NO_OF_SESSIONS_STCNT varchar2(32) NOT NULL,
LATENCY_LAST_MIN Number(20,4) NOT NULL,
LATENCY_LAST_MAX Number(20,4) NOT NULL,
LATENCY_LAST_STCNT varchar2(32) NOT NULL,
LATENCY_AVG_MIN Number(20,4) NOT NULL,
LATENCY_AVG_MAX Number(20,4) NOT NULL,
LATENCY_AVG_STCNT varchar2(32) NOT NULL,
LATENCY_DEVN_MIN Number(20,4) NOT NULL,
LATENCY_DEVN_MAX Number(20,4) NOT NULL,
LATENCY_DEVN_STCNT varchar2(32) NOT NULL,
MEM_UTIL_MIN Number(20,4) NOT NULL,
MEM_UTIL_MAX Number(20,4) NOT NULL,
MEM_UTIL_STCNT varchar2(32) NOT NULL,
CPU_UTIL_MIN Number(20,4) NOT NULL,
CPU_UTIL_MAX Number(20,4) NOT NULL,
CPU_UTIL_STCNT varchar2(32) NOT NULL,
INPUT_BANDWIDTH_MIN Number(20,4) NOT NULL,
INPUT_BANDWIDTH_MAX Number(20,4) NOT NULL,
INPUT_BANDWIDTH_STCNT varchar2(32) NOT NULL,
OUTPUT_BANDWIDTH_MIN Number(20,4) NOT NULL,
OUTPUT_BANDWIDTH_MAX Number(20,4) NOT NULL,
OUTPUT_BANDWIDTH_STCNT varchar2(32) NOT NULL,
INPUT_LINE_SPEED_MIN Number(20,4) NOT NULL,
INPUT_LINE_SPEED_MAX Number(20,4) NOT NULL,
INPUT_LINE_SPEED_STCNT varchar2(32) NOT NULL,
OUTPUT_LINE_SPEED_MIN Number(20,4) NOT NULL,
OUTPUT_LINE_SPEED_MAX Number(20,4) NOT NULL,
OUTPUT_LINE_SPEED_STCNT varchar2(32) NOT NULL,
INPUT_COMPRESSION_MIN Number(20,4) NOT NULL,
INPUT_COMPRESSION_MAX Number(20,4) NOT NULL,
INPUT_COMPRESSION_STCNT varchar2(32) NOT NULL,
OUTPUT_COMPRESSION_MIN Number(20,4) NOT NULL,
OUTPUT_COMPRESSION_MAX Number(20,4) NOT NULL,
OUTPUT_COMPRESSION_STCNT varchar2(32) NOT NULL,
IO_READS_MIN Number(20,4) NOT NULL,
IO_READS_MAX Number(20,4)  NOT NULL,
IO_READS_STCNT varchar2(32) NOT NULL,
IO_WRITES_MIN Number(20,4) NOT NULL,
IO_WRITES_MAX Number(20,4) NOT NULL,
IO_WRITES_STCNT varchar2(32) NOT NULL,
PAGE_FAULTS_MIN Number(20,4) NOT NULL,
PAGE_FAULTS_MAX Number(20,4) NOT NULL,
PAGE_FAULTS_STCNT varchar2(32) NOT NULL,
VIRTUAL_MEM_MIN Number(20,4) NOT NULL,
VIRTUAL_MEM_MAX Number(20,4) NOT NULL,
VIRTUAL_MEM_STCNT varchar2(32) NOT NULL,
HANDLES_MIN Number(20,4) NOT NULL,
HANDLES_MAX Number(20,4) NOT NULL,
HANDLES_STCNT varchar2(32) NOT NULL,
INPUT_AUDIO_MIN Number(20,4) NOT NULL,
INPUT_AUDIO_MAX Number(20,4) NOT NULL,
INPUT_AUDIO_STCNT varchar2(32) NOT NULL,
OUTPUT_AUDIO_MIN Number(20,4) NOT NULL,
OUTPUT_AUDIO_MAX Number(20,4) NOT NULL,
OUTPUT_AUDIO_STCNT varchar2(32) NOT NULL,
INPUT_COM_MIN Number(20,4) NOT NULL,
INPUT_COM_MAX Number(20,4) NOT NULL,
INPUT_COM_STCNT varchar2(32) NOT NULL,
OUTPUT_COM_MIN Number(20,4) NOT NULL,
OUTPUT_COM_MAX Number(20,4) NOT NULL,
OUTPUT_COM_STCNT varchar2(32) NOT NULL,
INPUT_DRIVE_MIN Number(20,4) NOT NULL,
INPUT_DRIVE_MAX Number(20,4) NOT NULL,
INPUT_DRIVE_STCNT varchar2(32) NOT NULL,
OUTPUT_DRIVE_MIN Number(20,4) NOT NULL,
OUTPUT_DRIVE_MAX Number(20,4) NOT NULL,
OUTPUT_DRIVE_STCNT varchar2(32) NOT NULL,
INPUT_HDX_MIN Number(20,4) NOT NULL,
INPUT_HDX_MAX Number(20,4) NOT NULL,
INPUT_HDX_STCNT varchar2(32) NOT NULL,
OUTPUT_HDX_MIN Number(20,4) NOT NULL,
OUTPUT_HDX_MAX Number(20,4) NOT NULL,
OUTPUT_HDX_STCNT varchar2(32) NOT NULL,
INPUT_PRINTER_MIN Number(20,4) NOT NULL,
INPUT_PRINTER_MAX Number(20,4) NOT NULL,
INPUT_PRINTER_STCNT varchar2(32) NOT NULL,
OUTPUT_PRINTER_MIN Number(20,4) NOT NULL,
OUTPUT_PRINTER_MAX Number(20,4) NOT NULL,
OUTPUT_PRINTER_STCNT varchar2(32) NOT NULL,
INPUT_DATA_MIN Number(20,4) NOT NULL,
INPUT_DATA_MAX Number(20,4) NOT NULL,
INPUT_DATA_STCNT varchar2(32) NOT NULL,
OUTPUT_DATA_MIN Number(20,4) NOT NULL,
OUTPUT_DATA_MAX Number(20,4) NOT NULL,
OUTPUT_DATA_STCNT varchar2(32) NOT NULL,
INPUT_MULTI_MIN Number(20,4) NOT NULL,
INPUT_MULTI_MAX Number(20,4) NOT NULL,
INPUT_MULTI_STCNT varchar2(32) NOT NULL,
OUTPUT_MULTI_MIN Number(20,4) NOT NULL,
OUTPUT_MULTI_MAX Number(20,4) NOT NULL,
OUTPUT_MULTI_STCNT varchar2(32) NOT NULL,
INPUT_USB_MIN Number(20,4) NOT NULL,
INPUT_USB_MAX Number(20,4) NOT NULL,
INPUT_USB_STCNT varchar2(32) NOT NULL,
OUTPUT_USB_MIN Number(20,4) NOT NULL,
OUTPUT_USB_MAX Number(20,4) NOT NULL,
OUTPUT_USB_STCNT varchar2(32) NOT NULL,
CPU_UTIL_TIME_MIN Number(20,4) NOT NULL,
CPU_UTIL_TIME_MAX Number(20,4) NOT NULL,
CPU_UTIL_TIME_STCNT varchar2(32) NOT NULL,
BANDWIDTH_USAGE_MIN Number(20,4) NOT NULL,
BANDWIDTH_USAGE_MAX Number(20,4) NOT NULL,
BANDWIDTH_USAGE_STCNT varchar2(32) NOT NULL,
INPUT_THINWIRE_MIN Number(20,4) NOT NULL,
INPUT_THINWIRE_MAX Number(20,4) NOT NULL,
INPUT_THINWIRE_STCNT varchar2(32) NOT NULL,
OUTPUT_THINWIRE_MIN Number(20,4) NOT NULL,
OUTPUT_THINWIRE_MAX Number(20,4) NOT NULL,
OUTPUT_THINWIRE_STCNT varchar2(32) NOT NULL,
INPUT_SEAMLESS_MIN Number(20,4) NOT NULL,
INPUT_SEAMLESS_MAX Number(20,4) NOT NULL,
INPUT_SEAMLESS_STCNT varchar2(32) NOT NULL,
OUTPUT_SEAMLESS_MIN Number(20,4) NOT NULL,
OUTPUT_SEAMLESS_MAX Number(20,4) NOT NULL,
OUTPUT_SEAMLESS_STCNT varchar2(32) NOT NULL,
RESOURCE_SHARES_MIN Number(20,4) NOT NULL,
RESOURCE_SHARES_MAX Number(20,4) NOT NULL,
RESOURCE_SHARES_STCNT varchar2(32) NOT NULL,
TOTAL_SESSION_DURATION_MIN Number(20,4) NOT NULL,
TOTAL_SESSION_DURATION_MAX Number(20,4) NOT NULL,
TOTAL_SESSION_DURATION_STCNT varchar2(32) NOT NULL,
IDLE_TIME_MEASUREPRD_MIN Number(20,4) NOT NULL,
IDLE_TIME_MEASUREPRD_MAX Number(20,4) NOT NULL,
IDLE_TIME_MEASUREPRD_STCNT varchar2(32) NOT NULL,
IDLE_TIME_DURATION_MIN Number(20,4) NOT NULL,
IDLE_TIME_DURATION_MAX Number(20,4) NOT NULL,
IDLE_TIME_DURATION_STCNT varchar2(32) NOT NULL,
TOTAL_IDLE_DURATION_MIN Number(20,4) NOT NULL,
TOTAL_IDLE_DURATION_MAX Number(20,4) NOT NULL,
TOTAL_IDLE_DURATION_STCNT varchar2(32) NOT NULL,
TOTAL_BANDWIDTH_MIN Number(20,4) NOT NULL,
TOTAL_BANDWIDTH_MAX Number(20,4) NOT NULL,
TOTAL_BANDWIDTH_STCNT varchar2(32) NOT NULL,
MEMORY_USED_MIN Number(20,4) NOT NULL,
MEMORY_USED_MAX Number(20,4) NOT NULL,
MEMORY_USED_STCNT varchar2(32) NOT NULL,
PROCESS_COUNT_MIN Number(20,4) NOT NULL,
PROCESS_COUNT_MAX Number(20,4) NOT NULL,
PROCESS_COUNT_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxXpUserTest_TREND ADD constraint PK_CtxXpUserTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxXpUserTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxXpUserTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NO_OF_SESSIONS_MIN	VARCHAR2(256)	 NOT NULL,
NO_OF_SESSIONS_MAX	VARCHAR2(256)	 NOT NULL,
LATENCY_LAST_MIN	VARCHAR2(256)	 NOT NULL,
LATENCY_LAST_MAX	VARCHAR2(256)	 NOT NULL,
LATENCY_AVG_MIN	VARCHAR2(256)	 NOT NULL,
LATENCY_AVG_MAX	VARCHAR2(256)	 NOT NULL,
LATENCY_DEVN_MIN	VARCHAR2(256)	 NOT NULL,
LATENCY_DEVN_MAX	VARCHAR2(256)	 NOT NULL,
MEM_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
MEM_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
INPUT_BANDWIDTH_MIN	VARCHAR2(256)	 NOT NULL,
INPUT_BANDWIDTH_MAX	VARCHAR2(256)	 NOT NULL,
OUTPUT_BANDWIDTH_MIN	VARCHAR2(256)	 NOT NULL,
OUTPUT_BANDWIDTH_MAX	VARCHAR2(256)	 NOT NULL,
INPUT_LINE_SPEED_MIN	VARCHAR2(256)	 NOT NULL,
INPUT_LINE_SPEED_MAX	VARCHAR2(256)	 NOT NULL,
OUTPUT_LINE_SPEED_MIN	VARCHAR2(256)	 NOT NULL,
OUTPUT_LINE_SPEED_MAX	VARCHAR2(256)	 NOT NULL,
INPUT_COMPRESSION_MIN	VARCHAR2(256)	 NOT NULL,
INPUT_COMPRESSION_MAX	VARCHAR2(256)	 NOT NULL,
OUTPUT_COMPRESSION_MIN	VARCHAR2(256)	 NOT NULL,
OUTPUT_COMPRESSION_MAX	VARCHAR2(256)	 NOT NULL,
IO_READS_MIN VARCHAR2(256) NOT NULL,
IO_READS_MAX VARCHAR2(256)  NOT NULL,
IO_WRITES_MIN VARCHAR2(256) NOT NULL,
IO_WRITES_MAX VARCHAR2(256) NOT NULL,
PAGE_FAULTS_MIN VARCHAR2(256) NOT NULL,
PAGE_FAULTS_MAX VARCHAR2(256) NOT NULL,
VIRTUAL_MEM_MIN VARCHAR2(256) NOT NULL,
VIRTUAL_MEM_MAX VARCHAR2(256) NOT NULL,
HANDLES_MIN VARCHAR2(256) NOT NULL,
HANDLES_MAX VARCHAR2(256) NOT NULL,
INPUT_AUDIO_MIN VARCHAR2(256) NOT NULL,
INPUT_AUDIO_MAX VARCHAR2(256) NOT NULL,
OUTPUT_AUDIO_MIN VARCHAR2(256) NOT NULL,
OUTPUT_AUDIO_MAX VARCHAR2(256) NOT NULL,
INPUT_COM_MIN VARCHAR2(256) NOT NULL,
INPUT_COM_MAX VARCHAR2(256) NOT NULL,
OUTPUT_COM_MIN VARCHAR2(256) NOT NULL,
OUTPUT_COM_MAX VARCHAR2(256) NOT NULL,
INPUT_DRIVE_MIN VARCHAR2(256) NOT NULL,
INPUT_DRIVE_MAX VARCHAR2(256) NOT NULL,
OUTPUT_DRIVE_MIN VARCHAR2(256) NOT NULL,
OUTPUT_DRIVE_MAX VARCHAR2(256) NOT NULL,
INPUT_HDX_MIN VARCHAR2(256) NOT NULL,
INPUT_HDX_MAX VARCHAR2(256) NOT NULL,
OUTPUT_HDX_MIN VARCHAR2(256) NOT NULL,
OUTPUT_HDX_MAX VARCHAR2(256) NOT NULL,
INPUT_PRINTER_MIN VARCHAR2(256) NOT NULL,
INPUT_PRINTER