' Corrective script - ComPlusAppTest_Memory_usage.vbs
' 
' This script uses COMAdmin library to restart a COM+ application.
'  
' By default, the script does not restart system COM+ applications. To enable system app restart,
' set the variable, allowSystemAppRestart to True.
'
' The script logs its events into ComAppRestarts.log file. The file will be created in the directory from
' where the script is executed.


On Error Resume Next

Dim args,appname,allowSystemAppRestart,restart
Dim userParams
Dim param
Dim logging

Set args = WScript.Arguments

If WScript.Arguments.Count > 0 Then
	userParams= args.Item(0)
	appname = args.Item(2)
End If	

allowSystemAppRestart = False
logging = True
restart = False

Dim filesys, logfile
Set filesys = CreateObject("Scripting.FileSystemObject")
Set logfile = filesys.OpenTextFile("ComAppRestarts.log",8,true)

Dim wrongAppName
wrongAppName = True

If appname <> "" Then

	If userParams <> "" Then
		If userParams = "none" Then
			restart = true
		Else
			userParams = split(userParams,",")
			For Each param In userParams
				If param = appname Then
					restart = True	
					Exit For
				End If
			Next
		End If	
	Else
		restart = True
	End If	

	If restart Then
		Dim objCatalog, result
		Set objCatalog = CreateObject("COMAdmin.COMAdminCatalog")

		Dim comApps
		Dim App
		Set comApps = objCatalog.GetCollection("Applications") 
		comApps.Populate 

		restart = False
		
		For Each App In comApps 
		    If App.Name = appname Then
			If allowSystemAppRestart Then
				restart=True
			Else
				If App.Value("IsSystem") Then
					restart = False
				Else
					restart = True
				End If
			End If	
			wrongAppName = False
			Exit For
		    End If	
		Next 


		If restart Then
			If logging Then
				logfile.WriteLine("[" & Date & " " & Time & "] Restarting the COM+ Application: " & appname)
			End If
			objCatalog.ShutdownApplication(appname)
			WScript.sleep 5000
			objCatalog.StartApplication(appname)

			If Err.Number <> 0 Then  
				If logging Then
					logfile.WriteLine("[" & Date & " " & Time & "] Error:" & Err.Number & " " & Err.Description & Err.Source)
				End If	
				Err.Clear
			Else
				If logging Then
					logfile.WriteLine("[" & Date & " " & Time & "] Restart Successfull")
				End If

			End If

		Else
			If wrongAppName Then
				If logging Then
					logfile.WriteLine("[" & Date & " " & Time & "] Application does not exist:" & appname)
				End If
			End If
		End If	
	End If
Else
	If logging Then
		logfile.WriteLine("[" & Date & " " & Time & "] Application name is null")
	End If
End If

logfile.Close
set logfile = nothing
set filesys = nothing
