'use strict'

var Timer = require('./timer')
var log = require('../logger')
var appendMsg = "Span :"

module.exports = Span

function Span (transaction) {
  this.transaction = transaction
  this.started = false
  this.truncated = false
  this.ended = false
  this.name = null
  this.type = null
  this._timer = null
  this._agent = transaction._agent

  log.debug(appendMsg, 'New object created', { id: this.transaction.id })
}

Span.prototype.start = function (name, type) {
  if (this.started) {
    log.debug(appendMsg, 'tried to call span.start() on already started span', { id: this.transaction.id, name: this.name, type: this.type })
    return
  }

  this.started = true
  this.name = name || this.name || 'unnamed'
  this.type = type || this.type || 'custom'

  this._timer = new Timer()

  log.debug(appendMsg, 'started id', { id: this.transaction.id, name: name, type: type })
}


Span.prototype.truncate = function () {
  if (!this.started) {
    log.debug(appendMsg, 'tried to truncate non-started span - ignoring ', { id: this.transaction.id, name: this.name, type: this.type })
    return
  } else if (this.ended) {
    log.debug(appendMsg, 'tried to truncate already ended span - ignoring', { id: this.transaction.id, name: this.name, type: this.type })
    return
  }
  this.truncated = true
  this.end()
}

Span.prototype.end = function () {
  if (!this.started) {
    log.debug(appendMsg,'tried to call span.end() on un-started span ', { id: this.transaction.id, name: this.name, type: this.type })
    return
  } else if (this.ended) {
    log.debug(appendMsg,'tried to call span.end() on already ended span ', { id: this.transaction.id, name: this.name, type: this.type })
    return
  }

  this._timer.end()
  this._agent._instrumentation._recoverTransaction(this.transaction)

  this.ended = true
  log.debug(appendMsg, 'ended', { id: this.transaction.id, name: this.name, type: this.type, truncated: this.truncated })
  this.transaction._recordEndedSpan(this)
}

Span.prototype.duration = function () {
  if (!this.ended) {
    log.debug(appendMsg, 'tried to call span.duration() on un-ended span ', { id: this.transaction.id, name: this.name, type: this.type })
    return null
  }

  return this._timer.duration()
}

Span.prototype.offsetTime = function () {
  if (!this.started) {
    log.debug(appendMsg, 'tried to call span.offsetTime() for un-started span ', { id: this.transaction.id, name: this.name, type: this.type })
    return null
  }

  return this._timer.offset(this.transaction._timer)
}


