'use strict'

var log = require('../../../logger')
var appendMsg = 'Core :'

module.exports = function patchCore(agent){
    
    var mods = [] //['fs', 'timer', 'dns', 'zlib' , 'cluster', 'error']
    
    mods.forEach(function(mod) {
        try{
            require('./wrap_'+mod)(agent)
        }catch(e){
            log.error(appendMsg, 'error while wrapping the core :'+ mod +' module', e)
        }
    });

    log.info(appendMsg, "wrapped core modules", mods)
}