/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AlreadyExists;
import com.vmware.vim25.ConcurrentAccess;
import com.vmware.vim25.DVPortConfigSpec;
import com.vmware.vim25.DVPortgroupConfigSpec;
import com.vmware.vim25.DVSCapability;
import com.vmware.vim25.DVSConfigInfo;
import com.vmware.vim25.DVSConfigSpec;
import com.vmware.vim25.DVSHealthCheckConfig;
import com.vmware.vim25.DVSNetworkResourcePool;
import com.vmware.vim25.DVSNetworkResourcePoolConfigSpec;
import com.vmware.vim25.DVSRuntimeInfo;
import com.vmware.vim25.DVSSummary;
import com.vmware.vim25.DistributedVirtualPort;
import com.vmware.vim25.DistributedVirtualSwitchPortCriteria;
import com.vmware.vim25.DistributedVirtualSwitchProductSpec;
import com.vmware.vim25.DuplicateName;
import com.vmware.vim25.DvsFault;
import com.vmware.vim25.DvsNotAuthorized;
import com.vmware.vim25.EntityBackupConfig;
import com.vmware.vim25.InvalidHostState;
import com.vmware.vim25.InvalidName;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.LimitExceeded;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.ResourceInUse;
import com.vmware.vim25.ResourceNotAvailable;
import com.vmware.vim25.RollbackFailure;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.mo.DistributedVirtualPortgroup;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.util.MorUtil;
import java.rmi.RemoteException;

public class DistributedVirtualSwitch
extends ManagedEntity {
    public DistributedVirtualSwitch(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public DVSCapability getCapability() {
        return (DVSCapability)this.getCurrentProperty("capability");
    }

    public DVSConfigInfo getConfig() {
        return (DVSConfigInfo)this.getCurrentProperty("config");
    }

    public DVSNetworkResourcePool[] getNetworkResourcePool() {
        return (DVSNetworkResourcePool[])this.getCurrentProperty("networkResourcePool");
    }

    public DistributedVirtualPortgroup[] getPortgroup() {
        ManagedObjectReference[] pgMors = (ManagedObjectReference[])this.getCurrentProperty("portgroup");
        if (pgMors == null) {
            return new DistributedVirtualPortgroup[0];
        }
        DistributedVirtualPortgroup[] dvpgs = new DistributedVirtualPortgroup[pgMors.length];
        int i = 0;
        while (i < pgMors.length) {
            dvpgs[i] = new DistributedVirtualPortgroup(this.getServerConnection(), pgMors[i]);
            ++i;
        }
        return dvpgs;
    }

    public DVSSummary getSummary() {
        return (DVSSummary)this.getCurrentProperty("summary");
    }

    public String getUuid() {
        return (String)this.getCurrentProperty("uuid");
    }

    public DVSRuntimeInfo getRuntime() {
        return (DVSRuntimeInfo)this.getCurrentProperty("runtime");
    }

    public Task addDVPortgroup_Task(DVPortgroupConfigSpec[] spec) throws DvsFault, DuplicateName, InvalidName, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().addDVPortgroup_Task(this.getMOR(), spec);
        return new Task(this.getServerConnection(), taskMor);
    }

    public Task createDVPortgroup_Task(DVPortgroupConfigSpec spec) throws DvsFault, DuplicateName, InvalidName, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().createDVPortgroup_Task(this.getMOR(), spec);
        return new Task(this.getServerConnection(), taskMor);
    }

    public Task dVSRollback_Task(EntityBackupConfig spec) throws RollbackFailure, DvsFault, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().dVSRollback_Task(this.getMOR(), spec);
        return new Task(this.getServerConnection(), taskMor);
    }

    public DistributedVirtualPortgroup lookupDvPortGroup(String portgroupKey) throws NotFound, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().lookupDvPortGroup(this.getMOR(), portgroupKey);
        return new DistributedVirtualPortgroup(this.getServerConnection(), mor);
    }

    public Task updateDVSHealthCheckConfig_Task(DVSHealthCheckConfig[] healthCheckConfig) throws DvsFault, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().updateDVSHealthCheckConfig_Task(this.getMOR(), healthCheckConfig);
        return new Task(this.getServerConnection(), taskMor);
    }

    public void addNetworkResourcePool(DVSNetworkResourcePoolConfigSpec[] configSpec) throws DvsFault, InvalidName, RuntimeFault, RemoteException {
        this.getVimService().addNetworkResourcePool(this.getMOR(), configSpec);
    }

    public void enableNetworkResourceManagement(boolean enable) throws DvsFault, RuntimeFault, RemoteException {
        this.getVimService().enableNetworkResourceManagement(this.getMOR(), enable);
    }

    public String[] fetchDVPortKeys(DistributedVirtualSwitchPortCriteria criteria) throws RuntimeFault, RemoteException {
        return this.getVimService().fetchDVPortKeys(this.getMOR(), criteria);
    }

    public DistributedVirtualPort[] fetchDVPorts(DistributedVirtualSwitchPortCriteria criteria) throws RuntimeFault, RemoteException {
        return this.getVimService().fetchDVPorts(this.getMOR(), criteria);
    }

    public Task mergeDvs_Task(DistributedVirtualSwitch dvs) throws InvalidHostState, DvsFault, NotFound, ResourceInUse, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().mergeDvs_Task(this.getMOR(), dvs.getMOR());
        return new Task(this.getServerConnection(), taskMor);
    }

    public Task moveDVPort_Task(String[] portKey, String destinationPortgroupKey) throws DvsFault, NotFound, ConcurrentAccess, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().moveDVPort_Task(this.getMOR(), portKey, destinationPortgroupKey);
        return new Task(this.getServerConnection(), taskMor);
    }

    public Task performDvsProductSpecOperation_Task(String operation, DistributedVirtualSwitchProductSpec productSpec) throws TaskInProgress, InvalidState, DvsFault, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().performDvsProductSpecOperation_Task(this.getMOR(), operation, productSpec);
        return new Task(this.getServerConnection(), taskMor);
    }

    public int[] queryUsedVlanIdInDvs() throws RuntimeFault, RemoteException {
        return this.getVimService().queryUsedVlanIdInDvs(this.getMOR());
    }

    public Task reconfigureDvs_Task(DVSConfigSpec spec) throws DvsNotAuthorized, DvsFault, ConcurrentAccess, DuplicateName, InvalidState, InvalidName, NotFound, AlreadyExists, LimitExceeded, ResourceInUse, ResourceNotAvailable, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().reconfigureDvs_Task(this.getMOR(), spec);
        return new Task(this.getServerConnection(), taskMor);
    }

    public Task rectifyDvsHost_Task(HostSystem[] hosts) throws DvsFault, NotFound, RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = MorUtil.createMORs(hosts);
        ManagedObjectReference mor = this.getVimService().rectifyDvsHost_Task(this.getMOR(), mors);
        return new Task(this.getServerConnection(), mor);
    }

    public void refreshDVPortState(String[] portKeys) throws DvsFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().refreshDVPortState(this.getMOR(), portKeys);
    }

    public void removeNetworkResourcePool(String[] key) throws DvsFault, NotFound, InvalidName, ResourceInUse, RuntimeFault, RemoteException {
        this.getVimService().removeNetworkResourcePool(this.getMOR(), key);
    }

    public void updateDvsCapability(DVSCapability capability) throws RuntimeFault, RemoteException {
        this.getVimService().updateDvsCapability(this.getMOR(), capability);
    }

    public void updateNetworkResourcePool(DVSNetworkResourcePoolConfigSpec[] configSpec) throws DvsFault, NotFound, InvalidName, RuntimeFault, RemoteException {
        this.getVimService().updateNetworkResourcePool(this.getMOR(), configSpec);
    }

    public Task reconfigureDVPort_Task(DVPortConfigSpec[] port) throws DvsFault, NotFound, ResourceInUse, ConcurrentAccess, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().reconfigureDVPort_Task(this.getMOR(), port);
        return new Task(this.getServerConnection(), mor);
    }
}

