/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.ireasoning.protocol.snmp.AgentUsmStats;
import com.ireasoning.protocol.snmp.MibUtil;
import com.ireasoning.protocol.snmp.NameValue;
import com.ireasoning.protocol.snmp.SnmpCounter32;
import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpGauge32;
import com.ireasoning.protocol.snmp.SnmpInt;
import com.ireasoning.protocol.snmp.SnmpIpAddress;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpOctetString;
import com.ireasoning.protocol.snmp.SnmpPdu;
import com.ireasoning.protocol.snmp.SnmpSession;
import com.ireasoning.protocol.snmp.SnmpTimeTicks;
import com.ireasoning.protocol.snmp.SnmpUInt;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.util.ParseArguments;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class snmp {
    protected ParseArguments _parseArgs;
    protected int _port;
    protected int _version;
    protected String _host;
    protected String _authProtocol;
    protected String _authPassword;
    protected int _privProtocol = 0;
    protected String _privPassword;
    protected String _community;
    protected String _user;
    protected String[] _oids;
    protected boolean _isSnmpV3;
    protected boolean _numericalOID = false;
    protected String[] _mibFiles;
    protected String _mibString;
    protected String _transportLayer;
    protected boolean _tcp;
    protected String _context;
    protected String _sPrivProtocol;
    protected String _engineID = null;
    protected boolean _engineIDVal;

    protected void printUsage(String string, boolean bl) {
        this.usage(string, bl);
        System.out.println("\nwhere possible options include:");
        System.out.println("-?\tprint this Usage");
        System.out.println("-h\tprint this Usage");
        System.out.println("-o\tprint oids numerically");
        System.out.println("-c <c>\tcommunity name");
        System.out.println("-v <1|2|3>\tspecifies snmp version to use, default is 1");
        System.out.println("-p <p>\tport number");
        System.out.println("-m <m>\tmib files to load. Use ',' or ';' to separate multiple files");
        this.moreOptions();
        System.out.println("\nSnmpV3 options:");
        System.out.println("-u <u>\tuser name");
        System.out.println("-a <a>\tauthentication algorithm, one of md5 or sha. md5 by default.");
        System.out.println("-A <A>\tauthentication password");
        System.out.println("-x <x>\tprivacy algorithm, either \"DES\" or \"AES\". DES by default.");
        System.out.println("-X <X>\tprivacy password");
        System.out.println("\nExample:");
        this.printExample(string);
    }

    protected void usage(String string, boolean bl) {
        if (bl) {
            System.out.println("Usage: java " + string + " [options...] <hostname> [<OID> ...]\n");
            System.out.println("<OID>\tobject identifiers, .1.3 by default. Or MIB node name if MIB loaded");
        } else {
            System.out.println("Usage: java " + string + " [options...] <hostname> [<OID>]\n");
            System.out.println("<OID>\tobject identifier, .1.3 by default.");
        }
    }

    protected void moreOptions() {
    }

    protected void printExample(String string) {
        System.out.println("java " + string + " localhost .1.3");
        System.out.println("java " + string + " localhost");
        System.out.println("java " + string + " localhost -v 3 -u newUser -A abc12345 -X abc12345 .1.3");
    }

    protected void print(SnmpPdu snmpPdu) {
        this.print(snmpPdu, System.out);
    }

    protected void print(SnmpPdu snmpPdu, PrintStream printStream) {
        if (snmpPdu.getErrorStatus() > 0) {
            System.out.println("PDU error status = " + snmpPdu.getErrorStatusString());
            return;
        }
        if (snmpPdu.isSnmpV3AuthenticationFailed()) {
            System.out.println("Authentication failure");
            this.printAuthFailReason(snmpPdu);
            return;
        }
        this.print(snmpPdu.getVarBinds(), printStream);
    }

    protected ArrayList print(SnmpPdu snmpPdu, ArrayList arrayList) {
        if (snmpPdu.getErrorStatus() > 0) {
            System.out.println("PDU error status = " + snmpPdu.getErrorStatusString());
            return arrayList;
        }
        if (snmpPdu.isSnmpV3AuthenticationFailed()) {
            System.out.println("Authentication failure");
            this.printAuthFailReason(snmpPdu);
            return arrayList;
        }
        arrayList = this.print(snmpPdu.getVarBinds(), arrayList);
        return arrayList;
    }

    private void printAuthFailReason(SnmpPdu snmpPdu) {
        SnmpVarBind snmpVarBind = snmpPdu.getFirstVarBind();
        if (snmpVarBind != null) {
            SnmpOID snmpOID = snmpVarBind.getName();
            if (snmpOID.equals((Object)AgentUsmStats.USM_STATS_UNKNOWN_USER_NAMES)) {
                System.out.println("Reason: Unknown user name");
            } else if (snmpOID.equals((Object)AgentUsmStats.USM_STATS_DECRYPTION_ERRORS)) {
                System.out.println("USM decryption error");
            } else if (snmpOID.equals((Object)AgentUsmStats.USM_STATS_WRONG_DIGESTS)) {
                System.out.println("Wrong digest");
            } else if (snmpOID.equals((Object)AgentUsmStats.USM_STATS_UNKNOWN_ENGINE_IDS)) {
                System.out.println("Unkown engine ID");
            } else if (snmpOID.equals((Object)AgentUsmStats.USM_STATS_NOT_IN_TIMEWINDOWS)) {
                System.out.println("Not in time windows");
            } else if (snmpOID.equals((Object)AgentUsmStats.USM_STATS_UNSUPPORTED_SEC_LEVELS)) {
                System.out.println("Unsupported security levels");
            }
        }
    }

    protected void print(SnmpVarBind[] snmpVarBindArray) {
        this.print(snmpVarBindArray, System.out);
    }

    protected void print(SnmpVarBind[] snmpVarBindArray, PrintStream printStream) {
        for (int i = 0; i < snmpVarBindArray.length; ++i) {
            this.print(snmpVarBindArray[i], printStream);
        }
    }

    protected ArrayList print(SnmpVarBind[] snmpVarBindArray, ArrayList arrayList) {
        for (int i = 0; i < snmpVarBindArray.length; ++i) {
            arrayList = this.print(snmpVarBindArray[i], arrayList);
        }
        return arrayList;
    }

    protected void print(SnmpVarBind snmpVarBind) {
        this.print(snmpVarBind, System.out);
    }

    protected void print(SnmpVarBind snmpVarBind, PrintStream printStream) {
        NameValue nameValue;
        if (snmpVarBind == null) {
            return;
        }
        SnmpOID snmpOID = snmpVarBind.getName();
        SnmpDataType snmpDataType = snmpVarBind.getValue();
        if (snmpOID == null) {
            printStream.println("SnmpVarBind 's name is null");
        }
        String string = snmpOID.toString();
        String string2 = snmpDataType.toString();
        if (MibUtil.isMibFileLoaded() && (nameValue = MibUtil.translate((String)string, (String)string2, (boolean)true)) != null) {
            if (!this._numericalOID) {
                string = nameValue.getName();
            }
            string2 = nameValue.getValue();
        }
        if (snmpDataType.getType() == 67) {
            string2 = ((SnmpTimeTicks)snmpDataType).getTimeString();
        } else {
            if (snmpDataType.getType() == 130) {
                printStream.println("End of MIB reached.");
                return;
            }
            if (snmpDataType.getType() == 128) {
                printStream.println("No such object.");
                return;
            }
            if (snmpDataType.getType() == 129) {
                printStream.println("No such Instance.");
                return;
            }
        }
        printStream.println(string + "\r\nValue (" + snmpDataType.getTypeString() + "): " + string2 + "\r\n");
    }

    protected ArrayList print(SnmpVarBind snmpVarBind, ArrayList arrayList) {
        NameValue nameValue;
        if (snmpVarBind == null) {
            return arrayList;
        }
        SnmpOID snmpOID = snmpVarBind.getName();
        SnmpDataType snmpDataType = snmpVarBind.getValue();
        if (snmpOID == null) {
            System.out.println("SnmpVarBind 's name is null");
            return arrayList;
        }
        String string = snmpOID.toString();
        String string2 = snmpDataType.toString();
        if (MibUtil.isMibFileLoaded() && (nameValue = MibUtil.translate((String)string, (String)string2, (boolean)true)) != null) {
            if (!this._numericalOID) {
                string = nameValue.getName();
            }
            string2 = nameValue.getValue();
        }
        if (snmpDataType.getType() == 67) {
            string2 = ((SnmpTimeTicks)snmpDataType).getTimeString();
        } else {
            if (snmpDataType.getType() == 130) {
                System.out.println("End of MIB reached.");
                return arrayList;
            }
            if (snmpDataType.getType() == 128) {
                System.out.println("No such object.");
                return arrayList;
            }
            if (snmpDataType.getType() == 129) {
                System.out.println("No such Instance.");
                return arrayList;
            }
        }
        arrayList.add(string + '=' + string2);
        return arrayList;
    }

    protected ParseArguments newParseArgumentsInstance(String[] stringArray) {
        return new ParseArguments(stringArray, "?ho", "uvaAXxcpm");
    }

    protected void parseOptions(String[] stringArray, String string) {
        this.parseOptions(stringArray, string, true, false);
    }

    protected void parseOptions(String[] stringArray, String string, boolean bl, boolean bl2) {
        this._parseArgs = this.newParseArgumentsInstance(stringArray);
        if (this._parseArgs.isSwitchPresent('?') || this._parseArgs.isSwitchPresent('h') || !bl2 && stringArray.length == 0) {
            this.printUsage(string, bl);
            System.exit(0);
        }
        this._numericalOID = this._parseArgs.isSwitchPresent('o');
        this._version = Integer.parseInt(this._parseArgs.getOptionValue('v', "1"));
        if (this._version < 3) {
            --this._version;
        }
        this._isSnmpV3 = this._version == 3;
        SnmpSession.loadMib2();
        this._mibString = this._parseArgs.getOptionValue('m');
        if (this._mibString != null && this._mibString.length() > 0) {
            this._mibFiles = snmp.parseMibFiles(this._mibString);
            for (int i = 0; i < this._mibFiles.length; ++i) {
                try {
                    SnmpSession.loadMib((String)this._mibFiles[i]);
                    continue;
                }
                catch (ParseException parseException) {
                    System.out.println("MIB file (" + this._mibFiles[i] + ") has syntax errors");
                    continue;
                }
                catch (IOException iOException) {
                    System.out.println("Can't load mib file: " + this._mibFiles[i]);
                }
            }
        }
        if (this._isSnmpV3) {
            this._user = this._parseArgs.getOptionValue('u');
            if (this._user == null || this._user.equalsIgnoreCase("none")) {
                throw new RuntimeException("User name has to be provided.");
            }
            this._authProtocol = this._parseArgs.getOptionValue('a', "md5");
            if (this._authProtocol.equalsIgnoreCase("none")) {
                this._authProtocol = "md5";
            }
            if (this._authProtocol.equalsIgnoreCase("md5")) {
                this._authProtocol = "HMAC-MD5";
            } else if (this._authProtocol.equalsIgnoreCase("sha")) {
                this._authProtocol = "HMAC-SHA-1";
            } else if (this._authProtocol.trim().indexOf(",") > -1) {
                String string2;
                StringBuffer stringBuffer = new StringBuffer();
                StringTokenizer stringTokenizer = new StringTokenizer(this._authProtocol, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (this._authProtocol.equalsIgnoreCase("none")) {
                        this._authProtocol = "md5";
                    }
                    if (string2.equalsIgnoreCase("md5")) {
                        string2 = "HMAC-MD5";
                    } else if (string2.equalsIgnoreCase("sha")) {
                        string2 = "HMAC-SHA-1";
                    }
                    stringBuffer.append(string2 + ",");
                }
                string2 = stringBuffer.toString();
                if (string2.lastIndexOf(",") > -1) {
                    this._authProtocol = string2.substring(0, string2.length() - 1);
                }
            } else {
                System.out.println("Unknown Authentication[Other than MD5|SHA] algorithm");
                throw new RuntimeException("Unknown authentication algorithm.");
            }
            String string3 = this._parseArgs.getOptionValue('x', "des");
            if (string3.equalsIgnoreCase("none")) {
                string3 = "des";
            }
            if (string3.equalsIgnoreCase("des")) {
                this._privProtocol = 0;
            } else if (string3.equalsIgnoreCase("aes")) {
                this._privProtocol = 1;
            } else if (string3.equalsIgnoreCase("aes128")) {
                this._privProtocol = 1;
            } else if (string3.equalsIgnoreCase("aes192")) {
                this._privProtocol = 2;
            } else if (string3.equalsIgnoreCase("aes256")) {
                this._privProtocol = 3;
            } else if (string3.trim().indexOf(",") > -1) {
                this._sPrivProtocol = string3;
            } else {
                System.out.println("Unknown privacy[Other than DES|AES] algorithm");
                throw new RuntimeException("Unknown privacy algorithm.");
            }
            this._authPassword = this._parseArgs.getOptionValue('A');
            this._privPassword = this._parseArgs.getOptionValue('X');
            this._context = this._parseArgs.getOptionValue('n');
            if (this._authPassword == null || this._authPassword.trim().length() == 0 || this._authPassword.equalsIgnoreCase("none")) {
                this._authPassword = " ";
            }
            if (this._privPassword == null || this._privPassword.trim().length() == 0 || this._privPassword.equalsIgnoreCase("none")) {
                this._privPassword = " ";
            }
        }
        this._community = this._parseArgs.getOptionValue('c', "public");
        if (this._isSnmpV3) {
            if (stringArray.length == 18) {
                this._engineID = "no";
                this._transportLayer = stringArray[17];
            } else if (stringArray.length == 19) {
                this._engineID = stringArray[17];
                this._transportLayer = stringArray[18];
            } else if (stringArray.length == 22) {
                this._engineID = "no";
                this._transportLayer = stringArray[21];
            } else {
                this._engineID = stringArray[21];
                this._transportLayer = stringArray[22];
            }
        } else {
            this._transportLayer = stringArray[9];
        }
        this._tcp = !this._transportLayer.equalsIgnoreCase("udp");
        this._engineIDVal = this._engineID != null && this._engineID.equalsIgnoreCase("yes");
        this._port = Integer.parseInt(this._parseArgs.getOptionValue('p', "161"));
        this.parseArgs();
    }

    protected void parseArgs() {
        String[] stringArray = this._parseArgs.getArguments();
        if (stringArray.length > 0) {
            this._host = stringArray[0];
        }
        if (stringArray.length > 1) {
            this._oids = new String[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                this._oids[i - 1] = stringArray[i];
            }
        } else {
            this._oids = new String[]{".1.3"};
        }
    }

    protected void printOptions() {
        System.out.println("Options:");
        System.out.println("_____________________________________");
        System.out.println("host =\t\t\t" + this._host);
        System.out.println("port =\t\t\t" + this._port);
        System.out.println("isSnmpV3 =\t\t" + this._isSnmpV3);
        System.out.println("authProtocol =\t\t" + this._authProtocol);
        System.out.println("authPassword =\t\t" + this._authPassword);
        System.out.println("privProtocol =\t\t" + this._privProtocol);
        System.out.println("privPassword =\t\t" + this._privPassword);
        System.out.println("community =\t\t" + this._community);
        System.out.println("user =\t\t\t" + this._user);
        System.out.println("mib files =\t\t" + this._mibString);
        this.printMoreOptions();
        System.out.println("______________________________________");
    }

    protected void printMoreOptions() {
    }

    private static String[] parseMibFiles(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";,");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static SnmpDataType translate(String string, String string2) {
        if (string.equals("i")) {
            return new SnmpInt(Integer.parseInt(string2));
        }
        if (string.equals("u")) {
            return new SnmpUInt(Long.parseLong(string2));
        }
        if (string.equals("t")) {
            return new SnmpTimeTicks(Long.parseLong(string2));
        }
        if (string.equals("a")) {
            return new SnmpIpAddress(string2);
        }
        if (string.equals("o")) {
            return new SnmpOID(string2);
        }
        if (string.equals("s")) {
            return new SnmpOctetString(string2);
        }
        if (string.equals("x")) {
            return new SnmpOctetString(SnmpOctetString.getBytes((String)string2));
        }
        if (string.equals("c")) {
            return new SnmpCounter32(string2);
        }
        if (string.equals("g")) {
            return new SnmpGauge32(string2);
        }
        throw new RuntimeException("Unknown data type");
    }

    public static byte[] getHexString(String string) {
        if (string.startsWith("0x") || string.startsWith("0X")) {
            int n = string.length() - 2;
            if (n % 2 != 0) {
                throw new IllegalArgumentException("Illegal hex string");
            }
            byte[] byArray = new byte[n / 2];
            int n2 = 0;
            for (int i = 0; i < n; i += 2) {
                String string2 = string.substring(i + 2, i + 4);
                int n3 = Integer.parseInt(string2, 16);
                byArray[n2++] = (byte)n3;
            }
            return byArray;
        }
        return string.getBytes();
    }
}

