/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigFilesSync;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.MultiThreadDD;
import com.eg.MultiThreadDDConfigTask;
import com.eg.MultiThreadDDLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MultiThreadDDInfo {
    private static final ConcurrentHashMap queryDDMap = new ConcurrentHashMap();
    private ArrayList singlethreadList = null;
    private ArrayList multithreadList = null;
    private static final ArrayList excludeTableList = new ArrayList();
    private static final String servicesIni = EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini";
    private static final String multiDDSubject = "MULTITHREAD_DD_INSERT_SETTINGS";
    private static final String multiDDKeyword = "UseMultiThreadedDDInsertion";
    private static boolean isFailure = false;
    private static long hashMapClearSecond;
    private static int failurePercentLimit;
    private static final String SWITCH_SYNC;
    private static AtomicInteger preSingleFailurePercent;

    public void updateStatistics(String string, int n, String string2, String string3, String string4, String string5, String string6, String string7, int n2) {
        block7: {
            boolean bl = MultiThreadDDConfigTask.isMultiThreadDDLogEnabled();
            try {
                boolean bl2;
                if ((string3.indexOf("PRIMARY KEY constraint") != -1 || string3.indexOf("Cannot insert duplicate key in object") != -1 || string3.indexOf("unique constraint") != -1) && excludeTableList.indexOf(string4.toUpperCase()) != -1) {
                    n = 1;
                }
                if (bl2 = this.isMultiThreadMode()) {
                    if (this.multithreadList == null) {
                        this.multithreadList = new ArrayList();
                        this.multithreadList.add(0);
                        this.multithreadList.add(0);
                        this.multithreadList.add(0);
                    }
                    this.statisticsCount(this.multithreadList, n, bl);
                } else {
                    if (this.singlethreadList == null) {
                        this.singlethreadList = new ArrayList();
                        this.singlethreadList.add(0);
                        this.singlethreadList.add(0);
                        this.singlethreadList.add(0);
                    }
                    this.statisticsCount(this.singlethreadList, n, bl);
                }
            }
            catch (Exception exception) {
                if (!bl) break block7;
                MultiThreadDDLogger.logToErrorFile("ERROR", "Dbinfo", exception.getMessage());
            }
        }
    }

    private void statisticsCount(ArrayList arrayList, int n, boolean bl) {
        block5: {
            try {
                if (n == 1) {
                    this.incrementSummaryDetails(arrayList, 1);
                } else if (n == 0) {
                    this.incrementSummaryDetails(arrayList, 2);
                }
                this.incrementSummaryDetails(arrayList, 0);
            }
            catch (Exception exception) {
                if (!bl) break block5;
                MultiThreadDDLogger.logToErrorFile("ERROR", "Dbinfo", exception.getMessage());
            }
        }
    }

    private void mergeStatisticsHashMap(boolean bl, boolean bl2) {
        block14: {
            try {
                if (bl) {
                    ArrayList arrayList = null;
                    if (this.multithreadList != null) {
                        arrayList = (ArrayList)this.multithreadList.clone();
                        this.multithreadList = null;
                    } else {
                        arrayList = new ArrayList();
                    }
                    if (arrayList.size() > 0) {
                        ArrayList arrayList2 = (ArrayList)queryDDMap.get("multithread");
                        if (arrayList2 == null || arrayList2.size() == 0) {
                            queryDDMap.put("multithread", arrayList);
                        } else {
                            arrayList2.set(0, (Integer)arrayList2.get(0) + (Integer)arrayList.get(0));
                            arrayList2.set(1, (Integer)arrayList2.get(1) + (Integer)arrayList.get(1));
                            arrayList2.set(2, (Integer)arrayList2.get(2) + (Integer)arrayList.get(2));
                            queryDDMap.put("multithread", arrayList2);
                        }
                    }
                } else {
                    ArrayList arrayList = null;
                    if (this.singlethreadList != null) {
                        arrayList = (ArrayList)this.singlethreadList.clone();
                        this.singlethreadList = null;
                    } else {
                        arrayList = new ArrayList();
                    }
                    if (arrayList.size() > 0) {
                        ArrayList arrayList3 = (ArrayList)queryDDMap.get("singlethread");
                        if (arrayList3 == null || arrayList3.size() == 0) {
                            queryDDMap.put("singlethread", arrayList);
                        } else {
                            arrayList3.set(0, (Integer)arrayList3.get(0) + (Integer)arrayList.get(0));
                            arrayList3.set(1, (Integer)arrayList3.get(1) + (Integer)arrayList.get(1));
                            arrayList3.set(2, (Integer)arrayList3.get(2) + (Integer)arrayList.get(2));
                            queryDDMap.put("singlethread", arrayList3);
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!bl2) break block14;
                MultiThreadDDLogger.logToErrorFile("ERROR", "Dbinfo", exception.getMessage());
            }
        }
    }

    private void checkForUpdateEgServiceIni(boolean bl) {
        block5: {
            try {
                long l;
                long l2 = IniFile.getLastModified(servicesIni);
                if (queryDDMap.get("iniLastmodified") == null) {
                    queryDDMap.put("iniLastmodified", l2);
                    this.readEgServiceIni(bl);
                }
                if (l2 > (l = ((Long)queryDDMap.get("iniLastmodified")).longValue())) {
                    if (bl) {
                        MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo", "eg_service.ini is changed: " + l2);
                    }
                    this.readEgServiceIni(bl);
                    queryDDMap.put("iniLastmodified", l2);
                }
            }
            catch (Exception exception) {
                if (!bl) break block5;
                MultiThreadDDLogger.logToErrorFile("ERROR", "Dbinfo", exception.getMessage());
            }
        }
    }

    private void readEgServiceIni(boolean bl) {
        block2: {
            try {
                IniFile iniFile = new IniFile(servicesIni);
                hashMapClearSecond = this.stringToLong(iniFile.getValue(multiDDSubject, "ClearSucessFailureStatistics"), 300L);
                failurePercentLimit = this.stringToInt(iniFile.getValue(multiDDSubject, "FailureQueryRatePercentage"), 30);
            }
            catch (Exception exception) {
                if (!bl) break block2;
                MultiThreadDDLogger.logToErrorFile("ERROR", "Dbinfo", exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatistics() {
        block29: {
            boolean bl = MultiThreadDDConfigTask.isMultiThreadDDLogEnabled();
            try {
                String string;
                String string2;
                if (queryDDMap.get("timestamp") == null) {
                    queryDDMap.put("timestamp", System.currentTimeMillis());
                }
                boolean bl2 = this.isMultiThreadMode();
                this.mergeStatisticsHashMap(bl2, bl);
                this.checkForUpdateEgServiceIni(bl);
                int n = 0;
                int n2 = 0;
                String string3 = bl2 ? "multithread" : "singlethread";
                ArrayList arrayList = (ArrayList)queryDDMap.get(string3);
                if (arrayList != null && arrayList.size() > 0) {
                    double d = Double.valueOf(arrayList.get(0) + "");
                    double d2 = Double.valueOf(arrayList.get(1) + "");
                    double d3 = Double.valueOf(arrayList.get(2) + "");
                    if (d > 0.0) {
                        n = (int)Math.round(d2 / d * 100.0);
                        n2 = (int)Math.round(d3 / d * 100.0);
                    }
                    if (bl) {
                        MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo - Thread:::", this.getThreadName() + "---" + bl2);
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("ThreadType:").append(string3);
                        stringBuilder.append("\tTotal:").append(d);
                        stringBuilder.append("\tSuccess:").append(d2).append(" (").append(n).append("%)");
                        stringBuilder.append("\tFailure:").append(d3).append(" (").append(n2).append("%)");
                        MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo - updateStatistics", stringBuilder.toString());
                    }
                }
                MultiThreadDD multiThreadDD = MultiThreadDD.getInstance("Dbinfo");
                if (n2 >= failurePercentLimit && bl2) {
                    if (!isFailure) {
                        string2 = SWITCH_SYNC;
                        synchronized (string2) {
                            if (!isFailure) {
                                try {
                                    multiThreadDD.getExecutor().shutDown();
                                    preSingleFailurePercent.set(failurePercentLimit);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                this.updateEgServiceIni(multiDDSubject, multiDDKeyword, "no");
                                IniFile iniFile = new IniFile(servicesIni);
                                multiThreadDD.getMultiThreadSettings(iniFile);
                                isFailure = true;
                                if (bl) {
                                    string = "Failure % is over " + failurePercentLimit + "% and above, so flag switched from multithread to single thread from the Thread - " + this.getThreadName();
                                    MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo - updateStatistics", string);
                                    MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo - updateStatistics", "Executor Object " + ((Object)multiThreadDD.getExecutor()).toString());
                                }
                            }
                        }
                    }
                } else if (n2 == 0 && !bl2 && multiThreadDD.getExecutor() == null && preSingleFailurePercent.get() == 0) {
                    string2 = SWITCH_SYNC;
                    synchronized (string2) {
                        if (multiThreadDD.getExecutor() == null) {
                            this.updateEgServiceIni(multiDDSubject, multiDDKeyword, "yes");
                            IniFile iniFile = new IniFile(servicesIni);
                            multiThreadDD.getMultiThreadSettings(iniFile);
                            isFailure = false;
                            MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo - Executor ", ((Object)multiThreadDD.getExecutor()).toString());
                            if (bl) {
                                string = "Failure % is 0%, so flag switched from single thread to multithread from " + this.getThreadName();
                                MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo - updateStatistics", string);
                            }
                        }
                    }
                }
                long l = (Long)queryDDMap.get("timestamp");
                long l2 = System.currentTimeMillis();
                long l3 = (l2 - l) / 1000L;
                if (l3 >= hashMapClearSecond) {
                    if (!bl2) {
                        preSingleFailurePercent.set(n2);
                    } else {
                        preSingleFailurePercent.set(0);
                    }
                    ArrayList arrayList2 = (ArrayList)queryDDMap.get("singlethread");
                    ArrayList arrayList3 = (ArrayList)queryDDMap.get("multithread");
                    if (arrayList2 != null && arrayList2.size() > 0) {
                        queryDDMap.put("singlethread", new ArrayList());
                        if (bl) {
                            MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo", "HashMap Cleared for " + string3 + "& preSingleFailurePercent is " + preSingleFailurePercent.get());
                        }
                    }
                    if (arrayList3 != null && arrayList3.size() > 0) {
                        queryDDMap.put("multithread", new ArrayList());
                        if (bl) {
                            MultiThreadDDLogger.logToErrorFile("INFO", "Dbinfo", "HashMap Cleared for " + string3 + "& preSingleFailurePercent is " + preSingleFailurePercent.get());
                        }
                    }
                    queryDDMap.put("timestamp", l2);
                }
            }
            catch (Exception exception) {
                if (!bl) break block29;
                MultiThreadDDLogger.logToErrorFile("ERROR", "Dbinfo", exception.getMessage());
            }
        }
    }

    private void incrementSummaryDetails(ArrayList arrayList, Integer n) {
        try {
            int n2 = (Integer)arrayList.get(n);
            arrayList.set(n, n2 + 1);
        }
        catch (Exception exception) {
            arrayList.set(n, 1);
        }
    }

    private void nullCheckeStack(ArrayList arrayList, Integer n, String string) {
        try {
            String string2 = (String)arrayList.get(n);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            stringBuffer.append("\r\n");
            stringBuffer.append(string);
            arrayList.set(n, stringBuffer.toString());
        }
        catch (Exception exception) {
            arrayList.set(n, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEgServiceIni(String string, String string2, String string3) {
        IniFile iniFile = EgConfigFilesSync.getInstance(servicesIni);
        try {
            iniFile.setValue(string, string2, string3);
            iniFile.saveFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            EgConfigFilesSync.releaseInstance(iniFile);
        }
    }

    private int stringToInt(String string, int n) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string.trim());
        }
        catch (Exception exception) {
            n2 = n;
        }
        return n2;
    }

    private long stringToLong(String string, long l) {
        long l2 = 0L;
        try {
            l2 = Long.parseLong(string.trim());
        }
        catch (Exception exception) {
            l2 = l;
        }
        return l2;
    }

    private String getThreadName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Thread.currentThread().getName()).append(" (").append(Thread.currentThread().getId()).append(")");
        return stringBuilder.toString();
    }

    private boolean isMultiThreadMode() {
        String string = this.getThreadName();
        boolean bl = false;
        if (string.indexOf("DD-DataInsertThread") != -1) {
            bl = true;
        }
        return bl;
    }

    public String eStack(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        String string = stringWriter.toString();
        return string;
    }

    public static ConcurrentHashMap getFailureSuccessResultMap() {
        return queryDDMap;
    }

    static {
        SWITCH_SYNC = new String("Switch");
        preSingleFailurePercent = new AtomicInteger(0);
        excludeTableList.add("BTM_SQL_QUERIES");
        excludeTableList.add("EXTERNAL_SERVICE_DETAILS");
        excludeTableList.add("BTM_EXN_MASTER");
        excludeTableList.add("BTM_EXN_STACKTRACE");
        excludeTableList.add("BTM_EXN_DETAILS");
        excludeTableList.add("BTM_SQL_DETAILS");
        excludeTableList.add("BTM_USER_EXPERIENCE");
        excludeTableList.add("BUSINESSTRANSTEST_DDD");
        excludeTableList.add("KBUSINESSTRANSTEST_DDD");
    }
}

