/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgDnsManager;
import com.eg.FakeSSLSocketFactory;
import com.vmware.vcloud.api.rest.schema.NetworkConfigSectionType;
import com.vmware.vcloud.api.rest.schema.NetworkConnectionType;
import com.vmware.vcloud.api.rest.schema.OrganizationReferenceType;
import com.vmware.vcloud.api.rest.schema.QueryResultAdminVMRecordType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.ResourceReferenceType;
import com.vmware.vcloud.api.rest.schema.VAppNetworkConfigurationType;
import com.vmware.vcloud.api.rest.schema.VmType;
import com.vmware.vcloud.api.rest.schema.extension.VimServerType;
import com.vmware.vcloud.sdk.Expression;
import com.vmware.vcloud.sdk.Filter;
import com.vmware.vcloud.sdk.QueryParams;
import com.vmware.vcloud.sdk.QueryService;
import com.vmware.vcloud.sdk.RecordResult;
import com.vmware.vcloud.sdk.VM;
import com.vmware.vcloud.sdk.Vapp;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.admin.AdminOrganization;
import com.vmware.vcloud.sdk.admin.AdminVdc;
import com.vmware.vcloud.sdk.admin.VcloudAdmin;
import com.vmware.vcloud.sdk.admin.extensions.VMWVimServer;
import com.vmware.vcloud.sdk.admin.extensions.VcloudAdminExtension;
import com.vmware.vcloud.sdk.constants.Version;
import com.vmware.vcloud.sdk.constants.query.ExpressionType;
import com.vmware.vcloud.sdk.constants.query.FilterType;
import com.vmware.vcloud.sdk.constants.query.QueryAdminVMField;
import com.vmware.vcloud.sdk.constants.query.QueryField;
import com.vmware.vcloud.sdk.constants.query.QueryRecordType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;

public class EgvCloudDiscovery {
    private String vCloudHost = "";
    private String vCloudUser = "";
    private String vCloudPass = "";
    private boolean isSSl = true;
    String str_URL = "";
    VcloudClient vcloudClient = null;

    public EgvCloudDiscovery(String string, String string2, String string3, String string4) {
        this.vCloudHost = string;
        this.vCloudUser = string2;
        this.vCloudPass = string3;
        String string5 = string4;
        this.isSSl = string5 != null && string5.length() != 0 && !string5.equalsIgnoreCase("none") ? string5.equalsIgnoreCase("true") || string5.equalsIgnoreCase("yes") : true;
        this.str_URL = this.isSSl ? "https://" + this.vCloudHost : "http://" + this.vCloudHost;
        if (this.vCloudUser != null && this.vCloudUser.length() != 0 && !this.vCloudUser.equalsIgnoreCase("none") && !this.vCloudUser.endsWith("@System")) {
            this.vCloudUser = this.vCloudUser + "@System";
        }
    }

    public boolean getConnection() {
        try {
            boolean bl = false;
            if (this.str_URL == null || this.vCloudUser == null || this.vCloudPass == null) {
                return false;
            }
            VcloudClient.setLogLevel((Level)Level.OFF);
            this.vcloudClient = new VcloudClient(this.str_URL, Version.V5_5);
            if (this.vcloudClient == null) {
                System.out.println("[EgvCloudDiscovery] vcloudClient object is null so return false");
                return false;
            }
            this.vcloudClient.registerScheme("https", new Integer(443), FakeSSLSocketFactory.getInstance());
            this.vcloudClient.login(this.vCloudUser, this.vCloudPass);
            bl = true;
            System.out.println("[EgvCloudDiscovery] connected sucessfully  " + this.str_URL);
            return bl;
        }
        catch (Exception exception) {
            System.out.println("[EgvCloudDiscovery] connection failed for " + this.str_URL + "\t\tuser=" + this.vCloudUser);
            exception.printStackTrace();
            return false;
        }
    }

    public void disconnect() {
        if (this.vcloudClient == null) {
            return;
        }
        try {
            this.vcloudClient.logout();
        }
        catch (Exception exception) {
            System.out.println("[EgvCloudDiscovery] Exception occured while disconnecting " + this.str_URL + "\t\tuser=" + this.vCloudUser);
            exception.printStackTrace();
        }
    }

    public Hashtable getAllVSphereHostAndVCDetails() {
        try {
            String string;
            Object object;
            Hashtable<String, Boolean> hashtable;
            Object object2;
            Object object3;
            Object object4;
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            VcloudAdminExtension vcloudAdminExtension = this.vcloudClient.getVcloudAdminExtension();
            QueryParams queryParams = new QueryParams();
            queryParams.setPageSize(new Integer(128));
            Expression expression = new Expression((QueryField)QueryAdminVMField.STATUS, "UNRESOLVED", ExpressionType.NOT_EQUALS);
            Expression expression2 = new Expression((QueryField)QueryAdminVMField.STATUS, "UNRESOLVED", ExpressionType.NOT_EQUALS);
            ArrayList<Filter> arrayList = new ArrayList<Filter>();
            arrayList.add(new Filter(expression));
            arrayList.add(new Filter(expression2));
            queryParams.setFilter(new Filter(arrayList, FilterType.AND));
            QueryService queryService = this.vcloudClient.getQueryService();
            RecordResult recordResult = queryService.queryIdRecords(QueryRecordType.ADMINVM, queryParams);
            List list = recordResult.getRecords();
            Hashtable hashtable3 = new Hashtable();
            if (list != null && list.size() > 0) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    object4 = (QueryResultAdminVMRecordType)list.get(i);
                    try {
                        object3 = object4.getVc();
                        object2 = new StringTokenizer((String)object3, ":");
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            hashtable = ((StringTokenizer)object2).nextToken();
                            if (!((String)((Object)(hashtable = ((String)((Object)hashtable)).trim()))).equalsIgnoreCase("vimserver")) continue;
                            object3 = ((StringTokenizer)object2).nextToken();
                            object3 = ((String)object3).trim();
                        }
                        if (object3 == null) continue;
                        hashtable = null;
                        if (hashtable3.containsKey(object3)) {
                            hashtable = (Hashtable)hashtable3.get(object3);
                        }
                        if (hashtable == null) {
                            hashtable = new Hashtable<String, Boolean>();
                        }
                        boolean bl = false;
                        object = object4.getGuestOs();
                        if ((object = ((String)object).toLowerCase()) != null && (((String)object).indexOf("2008") > 0 || ((String)object).indexOf("2012") > 0 || ((String)object).indexOf("2016") > 0 || ((String)object).indexOf("2019") > 0 || ((String)object).indexOf("linux") >= 0 || ((String)object).indexOf("centos") >= 0 || ((String)object).indexOf("server") > 0 || ((String)object).indexOf("other") >= 0 || ((String)object).indexOf("freebsd") >= 0)) {
                            bl = true;
                        }
                        if ((string = object4.getHostName()) != null) {
                            if (hashtable.containsKey(string)) {
                                boolean bl2 = (Boolean)hashtable.get(string);
                                if (!bl2) {
                                    hashtable.put(string, new Boolean(bl));
                                }
                            } else {
                                hashtable.put(string, new Boolean(bl));
                            }
                        }
                        hashtable3.put(object3, hashtable);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("exception occured while getting vms");
                    }
                }
            }
            System.out.println("vcentre:(Host:IsServer)" + hashtable3);
            HashMap hashMap = vcloudAdminExtension.getVMWVimServerRefsByName();
            if (hashMap != null && hashMap.size() > 0) {
                Set set = hashMap.keySet();
                object4 = set.iterator();
                object3 = new Hashtable();
                while (object4.hasNext()) {
                    int n;
                    int n2;
                    String string2;
                    Object object5;
                    object2 = (String)object4.next();
                    if (object2 == null) continue;
                    hashtable = new ArrayList();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    object = new Hashtable();
                    string = (ReferenceType)hashMap.get(object2);
                    VMWVimServer vMWVimServer = VMWVimServer.getVMWVimServerByReference((VcloudClient)this.vcloudClient, (ReferenceType)string);
                    VimServerType vimServerType = (VimServerType)vMWVimServer.getResource();
                    String string3 = vimServerType.getHref();
                    if (string3 != null) {
                        object5 = new StringTokenizer(string3, "/");
                        while (((StringTokenizer)object5).hasMoreTokens()) {
                            string2 = ((StringTokenizer)object5).nextToken();
                            if (!(string2 = string2.trim()).equalsIgnoreCase("vimserver")) continue;
                            string3 = ((StringTokenizer)object5).nextToken();
                            string3 = string3.trim();
                        }
                    }
                    System.out.println("VC host Name" + (String)object2 + " href=" + string3);
                    if (string3 == null || !hashtable3.containsKey(string3)) continue;
                    object5 = (Hashtable)hashtable3.get(string3);
                    string2 = vimServerType.getName();
                    String string4 = vimServerType.getUrl();
                    String string5 = "";
                    if (string4 != null && string4.indexOf("//") > 0 && (n2 = string4.indexOf("//")) + 2 < string4.length() && (n = (string4 = string4.substring(n2 + 2)).indexOf(":")) > 0) {
                        string5 = string4.substring(0, n);
                    }
                    if (string5 == null || string5.length() == 0) {
                        string5 = string2;
                    }
                    String string6 = string5 + "#~#" + string2;
                    System.out.println(" href=" + string3 + " vcfinalVal " + string6);
                    Enumeration enumeration = ((Hashtable)object5).keys();
                    while (enumeration.hasMoreElements()) {
                        String string7 = (String)enumeration.nextElement();
                        if (string7 == null || string7 == null) continue;
                        boolean bl = this.isIpAddress(string7);
                        String string8 = "";
                        String string9 = "";
                        if (bl) {
                            string8 = string7;
                            string9 = this.getDNSHostName(string7);
                        } else {
                            string8 = string7;
                            string9 = string7;
                        }
                        String string10 = string8 + "#~#" + string9;
                        System.out.println(" finalVal " + string10);
                        boolean bl3 = (Boolean)((Hashtable)object5).get(string7);
                        if (bl3) {
                            if (((ArrayList)((Object)hashtable)).contains(string10)) continue;
                            System.out.println("adding " + string10 + " to a_vSphereHosts_esx");
                            ((ArrayList)((Object)hashtable)).add(string10);
                            continue;
                        }
                        if (arrayList2.contains(string10)) continue;
                        System.out.println("adding " + string10 + " to a_vSphereHosts_vdi");
                        arrayList2.add(string10);
                    }
                    if (hashtable != null && ((ArrayList)((Object)hashtable)).size() > 0) {
                        ((Hashtable)object).put("VmEsx_i_server", hashtable);
                    }
                    if (arrayList2 != null && arrayList2.size() > 0) {
                        ((Hashtable)object).put("VmVdi_i_server", arrayList2);
                    }
                    hashtable2.put(string6, object);
                }
            }
            System.out.println(" [EgvCloudDiscovery] ht_vSphereDt =" + hashtable2);
            return hashtable2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Hashtable getvAppVmDetails() {
        Hashtable hashtable = new Hashtable();
        try {
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            Hashtable hashtable3 = new Hashtable();
            VcloudAdmin vcloudAdmin = this.vcloudClient.getVcloudAdmin();
            if (vcloudAdmin == null) {
                return null;
            }
            HashMap hashMap = vcloudAdmin.getAdminOrgRefsByName();
            if (hashMap == null) {
                return null;
            }
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string == null) continue;
                OrganizationReferenceType organizationReferenceType = (OrganizationReferenceType)hashMap.get(string);
                AdminOrganization adminOrganization = null;
                if (organizationReferenceType != null) {
                    adminOrganization = AdminOrganization.getAdminOrgByReference((VcloudClient)this.vcloudClient, (ReferenceType)organizationReferenceType);
                }
                HashMap hashMap2 = null;
                if (adminOrganization != null) {
                    hashMap2 = adminOrganization.getAdminVdcRefsByName();
                }
                if (hashMap2 == null || hashMap2.size() <= 0) continue;
                Set set2 = hashMap2.keySet();
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    HashMap hashMap3;
                    String string2 = (String)iterator2.next();
                    if (string2 == null) continue;
                    ReferenceType referenceType = (ReferenceType)hashMap2.get(string2);
                    AdminVdc adminVdc = null;
                    if (referenceType != null) {
                        adminVdc = AdminVdc.getAdminVdcByReference((VcloudClient)this.vcloudClient, (ReferenceType)referenceType);
                    }
                    if (adminVdc == null || (hashMap3 = adminVdc.getVappRefsByName()) == null || hashMap3.size() <= 0) continue;
                    Set set3 = hashMap3.keySet();
                    Iterator iterator3 = set3.iterator();
                    while (iterator3.hasNext()) {
                        String string3;
                        String string4;
                        VmType vmType;
                        Object object;
                        int n;
                        List list;
                        Vapp vapp;
                        ResourceReferenceType resourceReferenceType;
                        String string5 = (String)iterator3.next();
                        if (string5 == null || (resourceReferenceType = (ResourceReferenceType)hashMap3.get(string5)) == null || (vapp = Vapp.getVappByReference((VcloudClient)this.vcloudClient, (ReferenceType)resourceReferenceType)) == null) continue;
                        NetworkConfigSectionType networkConfigSectionType = null;
                        try {
                            networkConfigSectionType = vapp.getNetworkConfigSection();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (networkConfigSectionType != null) {
                            list = null;
                            try {
                                list = networkConfigSectionType.getNetworkConfig();
                            }
                            catch (Exception exception) {
                                System.out.println(" [EgvCloudDiscovery]  exception occured while calling getNetworkConfig for vapp " + string5);
                                exception.printStackTrace();
                            }
                            if (list != null && list.size() > 0) {
                                int n2 = list.size();
                                for (n = 0; n < n2; ++n) {
                                    VAppNetworkConfigurationType vAppNetworkConfigurationType = (VAppNetworkConfigurationType)list.get(n);
                                    if (vAppNetworkConfigurationType == null) continue;
                                    object = vAppNetworkConfigurationType.getNetworkName();
                                    vmType = null;
                                    try {
                                        vmType = vAppNetworkConfigurationType.getConfiguration();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (vmType == null || (string4 = vmType.getRouterInfo()) == null || (string3 = string4.getExternalIp()) == null || string3.length() <= 0) continue;
                                    hashtable2.put(string3, string5);
                                }
                            }
                        }
                        list = null;
                        try {
                            list = vapp.getChildrenVms();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Hashtable<String, Object> hashtable4 = new Hashtable<String, Object>();
                        if (list != null && list.size() > 0) {
                            n = list.size();
                            for (int i = 0; i < n; ++i) {
                                String string6;
                                Integer n3;
                                Object object2;
                                Collection<Object> collection;
                                Object object3;
                                object = (VM)list.get(i);
                                if (object == null) continue;
                                vmType = (VmType)object.getResource();
                                string4 = "";
                                string3 = "";
                                if (vmType != null) {
                                    int n4;
                                    string4 = vmType.getName();
                                    string3 = vmType.getId();
                                    if (string3 != null && (n4 = string3.indexOf(":vm:")) > 0 && string3.length() > n4 + 4) {
                                        object3 = string3.substring(n4 + 4);
                                        string4 = string4 + " (" + (String)object3 + ")";
                                    }
                                }
                                HashMap hashMap4 = object.getIpAddressesById();
                                object3 = new ArrayList();
                                if (hashMap4 != null && hashMap4.size() > 0) {
                                    collection = hashMap4.keySet();
                                    object2 = collection.iterator();
                                    while (object2.hasNext()) {
                                        n3 = (Integer)object2.next();
                                        if (n3 == null || (string6 = (String)hashMap4.get(n3)) == null || ((ArrayList)object3).contains(string6)) continue;
                                        ((ArrayList)object3).add(string6);
                                    }
                                }
                                collection = null;
                                try {
                                    collection = (List)object.getNetworkConnections();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (collection != null) {
                                    for (int j = 0; j < collection.size(); ++j) {
                                        n3 = (NetworkConnectionType)collection.get(j);
                                        string6 = n3.getIpAddress();
                                        if (string6 == null || ((ArrayList)object3).contains(string6)) continue;
                                        ((ArrayList)object3).add(string6);
                                    }
                                }
                                object2 = "";
                                if (object3 != null && ((ArrayList)object3).size() > 0) {
                                    int n5 = ((ArrayList)object3).size();
                                    for (int j = 0; j < n5; ++j) {
                                        String string7 = (String)((ArrayList)object3).get(j);
                                        if (string7 == null || string7.length() == 0) continue;
                                        object2 = j == 0 ? string7 : (String)object2 + "," + string7;
                                    }
                                }
                                hashtable4.put(string4, object2);
                            }
                        }
                        if (hashtable4 == null || hashtable4.size() <= 0) continue;
                        hashtable3.put(string5, hashtable4);
                    }
                }
            }
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable.put("vCloudvAppDetails", hashtable2);
            }
            if (hashtable3 != null && hashtable3.size() > 0) {
                hashtable.put("vCloudVMDetails", hashtable3);
            }
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public String getDNSHostName(String string) {
        String string2 = "";
        if (string != null && string.length() > 0) {
            EgDnsManager egDnsManager = EgDnsManager.getInstance();
            Vector<String> vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    String string3;
                    String string4 = stringTokenizer.nextToken();
                    if (string4 == null || string4.equals("-") || string4.equalsIgnoreCase("N/A") || (string3 = egDnsManager.getHostName(string4)) == null || string3.length() == 0 || vector.contains(string3)) continue;
                    vector.add(string3);
                    string2 = string2.length() == 0 ? string3 : string2 + "," + string3;
                }
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        EgvCloudDiscovery egvCloudDiscovery = new EgvCloudDiscovery("192.168.9.42", "administrator", "abc123ABC", "true");
        boolean bl = egvCloudDiscovery.getConnection();
        if (bl) {
            egvCloudDiscovery.getAllVSphereHostAndVCDetails();
            Hashtable hashtable = egvCloudDiscovery.getvAppVmDetails();
            egvCloudDiscovery.disconnect();
        }
    }
}

