/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgInstallInfo;
import com.eg.EgSmInit;
import com.eg.IniFile;
import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class EgSmInfo {
    public String optEgurkha;
    public String homeDir;
    public String EgIniDir;
    public String filename;
    public String egSuperManagerConfigFile;
    Vector syncVector;
    public int managerCount;
    public File f;
    public long lastModifiedTime;
    public String[] getSubject;
    public Hashtable managerURL;
    public Hashtable map_mgrid;
    public Hashtable mgrUrl_IdMap;
    IniFile iniFilePtr;
    private String dbFileName;
    private String refreshRate;
    private String alarmStatus;
    private String userLogin;
    private String configTime;

    public EgSmInfo() {
        this.homeDir = this.optEgurkha = EgInstallInfo.getInstallDir();
        this.EgIniDir = this.optEgurkha + "/manager/config/";
        this.filename = "eg_supermanager.ini";
        this.egSuperManagerConfigFile = this.EgIniDir + this.filename;
        this.syncVector = new Vector();
        this.managerCount = 0;
        this.f = new File(this.egSuperManagerConfigFile);
        this.getSubject = null;
        this.managerURL = new Hashtable();
        this.map_mgrid = new Hashtable();
        this.mgrUrl_IdMap = new Hashtable();
        this.refreshRate = "REFRESH";
        this.alarmStatus = "ALARMS";
        this.userLogin = "SM_USER_LOGIN";
        this.configTime = "CONFIG_TIME";
    }

    public boolean checkForUpdate() {
        long l = this.f.lastModified();
        if (this.getSubject == null || this.getSubject.length == 0) {
            if (this.filename.length() > 0) {
                this.lastModifiedTime = l;
                this.init();
                return true;
            }
        } else {
            if (l == this.lastModifiedTime) {
                return false;
            }
            this.lastModifiedTime = l;
            this.init();
            return true;
        }
        return false;
    }

    public void init() {
        this.managerCount = EgSmInit.getmanagerCount();
        this.iniFilePtr = new IniFile(this.egSuperManagerConfigFile, true);
        int n = 0;
        this.getSubject = this.iniFilePtr.getSubjects();
        if (n > this.managerCount) {
            n = this.managerCount;
            System.out.println("INFO:Your license supports only " + this.managerCount + " mana" + "ger" + "s to" + "repo" + "rt");
        }
        for (int i = 0; i < this.getSubject.length; ++i) {
            String string;
            String string2 = this.getSubject[i];
            String string3 = this.iniFilePtr.getValue(string2, "IP");
            if (string3 == null || string3.equals("")) continue;
            String string4 = this.iniFilePtr.getValue(string2, "PORT");
            if (string4 == null || string4.equals("")) {
                string4 = "80";
            }
            string = (string = this.iniFilePtr.getValue(string2, "SSL")).equals("true") ? "https" : "http";
            if (n >= this.managerCount) {
                System.out.println("INFO:Your license supports only " + this.managerCount + " mana" + "ger" + "s to" + " repo" + "rt");
                break;
            }
            String string5 = string + "://" + string3 + ":" + string4;
            this.managerURL.put(new String(string3), new String(string5));
            this.map_mgrid.put(new String(string2), new String(string3));
            this.mgrUrl_IdMap.put(string5, string2);
            ++n;
        }
    }

    public String getManagerID(String string) {
        this.checkForUpdate();
        return (String)this.mgrUrl_IdMap.get(string);
    }

    public Hashtable getAllManagerUrl() {
        this.checkForUpdate();
        return this.managerURL;
    }

    public String getMonitorHomeRefreshRate() {
        this.checkForUpdate();
        String string = "";
        try {
            String string2 = this.iniFilePtr.getValue(this.refreshRate, "HomePageTime");
            if (string2 == null || string2.equals(" ") || string2.trim().length() == 0) {
                return "300";
            }
            string = string2.trim();
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "300";
        }
    }

    public String getAlarmsRefreshRate() {
        this.checkForUpdate();
        String string = "";
        try {
            String string2 = this.iniFilePtr.getValue(this.refreshRate, "AlarmsTime");
            if (string2 == null || string2.equals(" ") || string2.trim().length() == 0) {
                return "60";
            }
            string = string2.trim();
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "60";
        }
    }

    public long getUserObjectRefreshTime() {
        this.checkForUpdate();
        long l = 0L;
        String string = this.iniFilePtr.getValue(this.refreshRate, "UserObjectRefreshTime");
        try {
            if (string == null || string.equals(" ") || string.trim().length() == 0) {
                return 300000L;
            }
            string = string.trim();
            l = Long.parseLong(string);
            return l *= 1000L;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 300000L;
        }
    }

    public long getUserObjectMaxIdleTime() {
        this.checkForUpdate();
        long l = 0L;
        String string = this.iniFilePtr.getValue(this.refreshRate, "UserObjectIdleTime");
        try {
            if (string == null || string.equals(" ") || string.trim().length() == 0) {
                return 1200000L;
            }
            string = string.trim();
            l = Long.parseLong(string);
            return l *= 1000L;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1200000L;
        }
    }

    public long getMeasureSleepTime() {
        this.checkForUpdate();
        long l = 0L;
        String string = this.iniFilePtr.getValue(this.configTime, "SleepTime");
        try {
            if (string == null || string.equals(" ") || string.trim().length() == 0) {
                return 20000L;
            }
            string = string.trim();
            l = Long.parseLong(string);
            return l *= 1000L;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 20000L;
        }
    }

    public long getAlarmsMaxTimePeriod() {
        this.checkForUpdate();
        long l = 0L;
        String string = this.iniFilePtr.getValue(this.configTime, "MeasureMaxPeriod");
        try {
            if (string == null || string.equals(" ") || string.trim().length() == 0) {
                return 300000L;
            }
            string = string.trim();
            l = Long.parseLong(string);
            return l *= 1000L;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 300000L;
        }
    }

    public long getAlarmsConfigTime() {
        this.checkForUpdate();
        long l = 0L;
        String string = this.iniFilePtr.getValue(this.configTime, "AlarmsTime");
        try {
            if (string == null || string.equals(" ") || string.trim().length() == 0) {
                return 180000L;
            }
            string = string.trim();
            l = Long.parseLong(string);
            return l *= 1000L;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 180000L;
        }
    }

    public long getAlarmsUserConfigTime() {
        this.checkForUpdate();
        long l = 0L;
        String string = this.iniFilePtr.getValue(this.configTime, "AlarmsUserTime");
        try {
            if (string == null || string.equals(" ") || string.trim().length() == 0) {
                return 600000L;
            }
            string = string.trim();
            l = Long.parseLong(string);
            return l *= 1000L;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 600000L;
        }
    }

    public long getUserComponentListTime() {
        this.checkForUpdate();
        long l = 0L;
        String string = this.iniFilePtr.getValue(this.configTime, "UserComponentListTime");
        try {
            if (string == null || string.equals(" ") || string.trim().length() == 0) {
                return 30000L;
            }
            string = string.trim();
            l = Long.parseLong(string);
            return l *= 1000L;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 30000L;
        }
    }

    public boolean getMouseoverAllow() {
        this.checkForUpdate();
        boolean bl = false;
        try {
            String string = this.iniFilePtr.getValue(this.alarmStatus, "MOUSE_OVER");
            if (string == null || string.equals(" ") || string.trim().length() == 0) {
                return bl;
            }
            if (string.toLowerCase().equals("true")) {
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return bl;
        }
    }

    public boolean allowDeleteAlarms() {
        this.checkForUpdate();
        String string = this.iniFilePtr.getValue(this.alarmStatus, "ALLOW_DELETE");
        return string != null && string.equalsIgnoreCase("true");
    }

    public boolean allowAcknowledgeAlarms() {
        this.checkForUpdate();
        String string = this.iniFilePtr.getValue(this.alarmStatus, "ALLOW_ACKNOWLEDGE");
        return string != null && string.equalsIgnoreCase("true");
    }

    public boolean mainDispAlarms(String string) {
        this.checkForUpdate();
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        String string2 = this.iniFilePtr.getValue(this.alarmStatus, "MAIN_DISP_ALARM");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().toLowerCase();
            vector.addElement(string3);
        }
        if (vector.contains(string.toLowerCase())) {
            bl = true;
        }
        return bl;
    }

    public String getSMPass() {
        this.checkForUpdate();
        return this.iniFilePtr.getValue(this.userLogin, "SMPASS");
    }

    public String getSMName() {
        this.checkForUpdate();
        return this.iniFilePtr.getValue(this.userLogin, "SMID");
    }

    public Hashtable getManagerId() {
        this.checkForUpdate();
        return this.map_mgrid;
    }

    public boolean setSMPass(String string) {
        boolean bl = this.iniFilePtr.setValue(this.userLogin, "SMPASS", string);
        this.iniFilePtr.saveFile();
        return bl;
    }

    public boolean getWinPerManager() {
        this.checkForUpdate();
        String string = this.iniFilePtr.getValue(this.alarmStatus, "NEW_WINDOW");
        if (string != null && string.length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return false;
    }

    public static void main(String[] stringArray) {
    }
}

