/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgCrypt;
import com.eg.EgDomainValidationFrameWork;
import com.eg.EgInstallInfo;
import com.eg.HelperThread;
import com.eg.IniFile;
import com.egurkha.util.StringUtils;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;

public class EgDomainAuthenticationFrameWork
implements EgDomainValidationFrameWork {
    String disName = "";
    String connectUser = "";
    String ConnectPwd = "";
    boolean ssl = false;
    String domainName = "";
    boolean autoDiscover = false;
    String domainIP = "";
    String port = "";
    String frmURI = "";
    String domAliasName = "";
    public ArrayList response = new ArrayList();
    public ArrayList errorList = new ArrayList();
    public ArrayList errors = new ArrayList();
    ArrayList domainNames = new ArrayList();
    ArrayList displayNames = new ArrayList();
    public IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_authenticate.ini");

    public EgDomainAuthenticationFrameWork() {
    }

    public EgDomainAuthenticationFrameWork(String string, String string2, String string3, boolean bl, String string4) {
        this.disName = string;
        this.connectUser = string2;
        this.ConnectPwd = EgCrypt.encrypt(string3);
        this.ssl = bl;
        this.frmURI = string4;
    }

    public EgDomainAuthenticationFrameWork(String string, String string2, String string3, boolean bl, String string4, String string5, String string6) {
        this.disName = string;
        this.connectUser = string2;
        this.ConnectPwd = EgCrypt.encrypt(string3);
        this.ssl = bl;
        this.domainIP = string4;
        this.port = string5;
        this.frmURI = string6;
    }

    public void validateADCredentials(boolean bl, String string, String string2) {
        this.domainName = string;
        this.domAliasName = string2;
        this.autoDiscover = bl;
        boolean bl2 = false;
        if (bl) {
            String[] stringArray = this.iniFile.getSubjects();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!StringUtils.isNull((String)stringArray[i]) && stringArray[i].equals("Domain_Alias")) continue;
                String string3 = this.iniFile.getValue(stringArray[i], "domain_name");
                this.displayNames.add(stringArray[i]);
                this.domainNames.add(string3);
            }
            if (this.displayNames.contains(this.disName) || this.domainNames.contains(string)) {
                if (this.frmURI != null && this.frmURI.equalsIgnoreCase("add")) {
                    this.errorList.add("Display or Domain name already exists");
                    this.response.add("Display Name$#$NA");
                    this.response.add("Domain Name$#$NA");
                    return;
                }
                this.response.add("Display Name$#$Yes");
            } else {
                this.response.add("Display Name$#$Yes");
            }
            bl2 = this.validateDomainName(string);
            if (!bl2) {
                this.response.add("Domain Name$#$NA");
                this.setADErrorResult(this.errors);
                return;
            }
            this.response.add("Domain Name$#$Yes");
            bl2 = false;
            bl2 = this.validateADDomain(string);
            if (bl2) {
                this.response.add("Domain User$#$Yes");
                this.response.add("Domain Password$#$Yes");
            } else {
                this.setADErrorResult(this.errors);
            }
        } else {
            boolean bl3 = false;
            String[] stringArray = this.iniFile.getSubjects();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!StringUtils.isNull((String)stringArray[i]) && stringArray[i].equals("Domain_Alias")) continue;
                String string4 = this.iniFile.getValue(stringArray[i], "domain_name");
                this.displayNames.add(stringArray[i]);
                this.domainNames.add(string4);
            }
            if (this.displayNames.contains(this.disName) || this.displayNames.contains(this.disName.toLowerCase()) || this.domainNames.contains(string)) {
                if (this.frmURI != null && this.frmURI.equalsIgnoreCase("add")) {
                    this.errorList.add("Display or Domain name already exists");
                    this.response.add("Display Name$#$NA");
                    this.response.add("Domain Name$#$NA");
                    return;
                }
                this.response.add("Display Name$#$Yes");
            } else {
                this.response.add("Display Name$#$Yes");
            }
            bl2 = this.validateDomainName(string);
            if (!bl2) {
                this.response.add("Domain Name$#$NA");
                this.setADErrorResult(this.errors);
                return;
            }
            this.response.add("Domain Name$#$Yes");
            bl3 = this.validateDomainIP(this.domainIP, string);
            if (!bl3) {
                if (string2 != null && string2.length() > 0) {
                    this.errorList.add("Domain IP does not correspond to domain alias name");
                } else {
                    this.errorList.add("Domain IP does not correspond to domain name");
                }
                this.response.add("Domain IP$#$No");
                return;
            }
            if (!this.checkPort(this.domainIP, this.port)) {
                this.response.add("Domain IP$#$No");
                this.response.add("Domain Port$#$No");
            } else {
                this.response.add("DomainIP$#$Yes");
                this.response.add("Domain Port$#$Yes");
            }
            bl2 = false;
            bl2 = this.validateADDomain(string);
            if (bl2) {
                this.response.add("Domain User$#$Yes");
                this.response.add("Domain Password$#$Yes");
            } else {
                this.setADErrorResult(this.errors);
            }
        }
    }

    public void validateADCredentials(boolean bl, String string) {
        this.domainName = string;
        this.autoDiscover = bl;
        boolean bl2 = false;
        if (bl) {
            String[] stringArray = this.iniFile.getSubjects();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!StringUtils.isNull((String)stringArray[i]) && stringArray[i].equals("Domain_Alias")) continue;
                String string2 = this.iniFile.getValue(stringArray[i], "domain_name");
                this.displayNames.add(stringArray[i]);
                this.domainNames.add(string2);
            }
            if (this.displayNames.contains(this.disName) || this.domainNames.contains(string)) {
                if (this.frmURI != null && this.frmURI.equalsIgnoreCase("add")) {
                    this.errorList.add("Display or Domain name already exists");
                    this.response.add("Display Name$#$NA");
                    this.response.add("Domain Name$#$NA");
                    return;
                }
                this.response.add("Display Name$#$Yes");
            } else {
                this.response.add("Display Name$#$Yes");
            }
            bl2 = this.validateDomainName(string);
            if (!bl2) {
                this.response.add("Domain Name$#$NA");
                this.setADErrorResult(this.errors);
                return;
            }
            this.response.add("Domain Name$#$Yes");
            bl2 = false;
            bl2 = this.validateADDomain(string);
            if (bl2) {
                this.response.add("Domain User$#$Yes");
                this.response.add("Domain Password$#$Yes");
            } else {
                this.setADErrorResult(this.errors);
            }
        } else {
            boolean bl3 = false;
            String[] stringArray = this.iniFile.getSubjects();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!StringUtils.isNull((String)stringArray[i]) && stringArray[i].equals("Domain_Alias")) continue;
                String string3 = this.iniFile.getValue(stringArray[i], "domain_name");
                this.displayNames.add(stringArray[i]);
                this.domainNames.add(string3);
            }
            if (this.displayNames.contains(this.disName) || this.displayNames.contains(this.disName.toLowerCase()) || this.domainNames.contains(string)) {
                if (this.frmURI != null && this.frmURI.equalsIgnoreCase("add")) {
                    this.errorList.add("Display or Domain name already exists");
                    this.response.add("Display Name$#$NA");
                    this.response.add("Domain Name$#$NA");
                    return;
                }
                this.response.add("Display Name$#$Yes");
            } else {
                this.response.add("Display Name$#$Yes");
            }
            bl2 = this.validateDomainName(string);
            if (!bl2) {
                this.response.add("Domain Name$#$NA");
                this.setADErrorResult(this.errors);
                return;
            }
            this.response.add("Domain Name$#$Yes");
            bl3 = this.validateDomainIP(this.domainIP, string);
            if (!bl3) {
                this.errorList.add("Domain IP does not correspond to domain name");
                this.response.add("Domain IP$#$No");
                return;
            }
            if (!this.checkPort(this.domainIP, this.port)) {
                this.response.add("Domain IP$#$No");
                this.response.add("Domain Port$#$No");
            } else {
                this.response.add("DomainIP$#$Yes");
                this.response.add("Domain Port$#$Yes");
            }
            bl2 = false;
            bl2 = this.validateADDomain(string);
            if (bl2) {
                this.response.add("Domain User$#$Yes");
                this.response.add("Domain Password$#$Yes");
            } else {
                this.setADErrorResult(this.errors);
            }
        }
    }

    public boolean validateDomainIP(String string, String string2) {
        ArrayList arrayList = null;
        arrayList = this.getIPAddressesByDomainName(string2);
        return arrayList != null && arrayList.contains(string);
    }

    public void setADErrorResult(ArrayList arrayList) {
        int n = this.getADErrorCode(arrayList);
        switch (n) {
            case -1: {
                this.errorList.add("Username or Password is incorrect.");
                this.response.add("Domain User$#$No");
                this.response.add("Domain Password$#$No");
                break;
            }
            case 525: {
                this.errorList.add("The username does not exist in domain server");
                this.response.add("Domain User$#$No");
                this.response.add("Domain Password$#$No");
                break;
            }
            case 701: {
                this.errorList.add("The user account has expired in domain server");
                this.response.add("Domain User$#$No");
                this.response.add("Domain Password$#$No");
                break;
            }
            case 531: {
                this.errorList.add("The user is not permitted to log on at this workstation. Please contact the domain administrator and verify the workstation permission for the user.");
                this.response.add("Domain User$#$Yes");
                this.response.add("Domain Password$#$Yes");
                this.response.add("Logon to Workstation#$No");
                break;
            }
            case 530: {
                this.errorList.add("The user is not permitted to log on at this time. Please contact the domain administrator and verify the logon hours for the user.");
                this.response.add("Domain User$#$Yes");
                this.response.add("Domain Password$#$Yes");
                this.response.add("Logon Hours#$No");
                break;
            }
            case 533: {
                this.errorList.add("The user account is disabled in the domain server");
                this.response.add("Domain User$#$No");
                this.response.add("Domain Password$#$No");
                break;
            }
            case 532: {
                this.errorList.add("The password has expired in domain server");
                this.response.add("Domain User$#$Yes");
                this.response.add("Domain Password$#$No");
                break;
            }
            case 773: {
                this.errorList.add("The user must reset the password in domain server");
                this.response.add("Domain User$#$Yes");
                this.response.add("Domain Password$#$No");
                break;
            }
            case 775: {
                this.errorList.add("The user account is locked in domain server");
                this.response.add("Domain User$#$No");
                this.response.add("Domain Password$#$No");
                break;
            }
            case 50: {
                this.errorList.add("The user does not have sufficient rights to perform this action");
                this.response.add("Domain User$#$No");
                this.response.add("Domain Password$#$No");
                break;
            }
            case 2: {
                this.errorList.add("Connection timed out");
                this.errorList.add("The combination of domain IP/name and port may be invalid");
                break;
            }
            case -21: {
                this.response.add("SSL Enabled$#$No");
                this.errorList.add("Connection timed out");
                this.errorList.add("SSL certificate may not have been installed");
                this.errorList.add("SSL certificate for the domain server may be invalid");
                break;
            }
            case 51: {
                this.errorList.add("Connection timed out");
                this.errorList.add("Domain server is too busy or unavailable");
                break;
            }
            case -20: {
                this.errorList.add("An unexpected error has been encountered");
                break;
            }
            default: {
                this.errorList.add("An unexpected error has been encountered. Please try again");
            }
        }
    }

    public ArrayList getADErrorResult() {
        return this.errorList;
    }

    public ArrayList getADResponse() {
        return this.response;
    }

    public int getADErrorCode(ArrayList arrayList) {
        String string = "";
        int n = -8;
        if (arrayList.contains("EXCEPTION")) {
            int n2 = arrayList.indexOf("EXCEPTION");
            Exception exception = (Exception)arrayList.get(n2 + 1);
            String string2 = exception.toString();
            if (string2.startsWith("javax.naming.AuthenticationException")) {
                String string3 = exception.getMessage();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (!string4.startsWith(" data ")) continue;
                    string = string4.substring(string4.indexOf(" ", 1) + 1);
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (Exception exception2) {
                        n = -1;
                    }
                }
            } else {
                n = string2.startsWith("javax.naming.NoPermissionException") ? 50 : (string2.startsWith("javax.naming.CommunicationException") ? (string2.indexOf("SSLHandshakeException") > -1 || string2.indexOf("ValidatorException") > -1 || string2.indexOf("SunCertPathBuilderException") > -1 ? -21 : 2) : (string2.startsWith("javax.naming.ServiceUnavailableException") ? 51 : (string2.startsWith("java.net.UnknownHostException") ? 1 : (string2.startsWith("javax.naming.NamingException") ? 6 : -20))));
            }
        } else if (arrayList.contains("SocketException")) {
            n = 2;
        }
        return n;
    }

    public boolean validateDomainName(String string) {
        ArrayList arrayList = null;
        arrayList = this.getIPAddressesByDomainName(string);
        if (arrayList == null || arrayList.size() == 0) {
            this.errors.add("SocketException");
            return false;
        }
        return true;
    }

    public boolean validateADDomain(String string) {
        boolean bl = false;
        ArrayList arrayList = null;
        String string2 = null;
        InitialLdapContext initialLdapContext = null;
        String string3 = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string4 = EgCrypt.decrypt(this.ConnectPwd);
        if (this.autoDiscover) {
            string3 = "3268";
            if (this.ssl) {
                this.ssl = true;
                string3 = "3269";
            }
            if ((string2 = this.getValidIP(arrayList = this.getIPAddressesByDomainName(string), string3)) == null) {
                string3 = this.ssl ? "636" : "389";
                string2 = this.getValidIP(arrayList, string3);
                if (string2 == null) {
                    this.errors.add("SocketException");
                    return false;
                }
                this.domainIP = string2;
                this.port = string3;
            } else {
                this.domainIP = string2;
                this.port = string3;
            }
        } else if (!this.checkPort(this.domainIP, this.port)) {
            this.errors.add("SocketException");
            return false;
        }
        String string5 = this.connectUser + "@" + string;
        string5 = this.findUserDN(string5, string4, string, this.port, this.ssl, this.connectUser);
        if (string5 == null) {
            return false;
        }
        String string6 = string5 = string5 + "," + this.getSearchBase(string);
        String string7 = "ldap://" + this.domainIP + ":" + this.port;
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        if (this.ssl) {
            string7 = "ldaps://" + this.domainIP + ":" + this.port;
            String string8 = System.getProperty("java.home");
            String string9 = string8 + "/lib/security/cacerts";
            System.setProperty("javax.net.ssl.trustStore", string9);
            hashtable.put("java.naming.security.protocol", "ssl");
        }
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.security.principal", string6);
        hashtable.put("java.naming.security.credentials", string4);
        hashtable.put("java.naming.provider.url", string7);
        try {
            initialLdapContext = new InitialLdapContext(hashtable, null);
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errors.add("EXCEPTION");
            this.errors.add(exception);
            return false;
        }
        System.out.println("connected ------>" + bl);
        return bl;
    }

    public ArrayList getIPAddressesByDomainName(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            InetAddress[] inetAddressArray = null;
            inetAddressArray = this.domAliasName != null && this.domAliasName.length() > 0 ? InetAddress.getAllByName(this.domAliasName) : InetAddress.getAllByName(string);
            for (int i = 0; i < inetAddressArray.length; ++i) {
                String string2 = inetAddressArray[i].getHostAddress();
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
        }
        return arrayList;
    }

    public String getValidIP(ArrayList arrayList, String string) {
        String string2 = null;
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = (String)arrayList.get(i);
                if (!this.checkPort(string3, string)) continue;
                string2 = string3;
                break;
            }
        }
        return string2;
    }

    public boolean checkPort(String string, String string2) {
        long l;
        int n = 1000;
        HelperThread helperThread = new HelperThread(string, string2, n);
        long l2 = 0L;
        long l3 = 5L;
        do {
            this.suspendForPeriod(l3);
            if (helperThread.done) {
                return helperThread.status;
            }
            if ((l2 += l3) >= (long)n) {
                helperThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                helperThread = null;
                return false;
            }
            l = l3;
            if ((long)n - l2 >= l) continue;
            l = (long)n - l2;
        } while ((l3 = l) > 0L);
        helperThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        helperThread = null;
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public String getSearchBase(String string) {
        String string2 = "DC=";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string3 = stringTokenizer.nextToken();
        string2 = string2 + string3;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + ",DC=" + stringTokenizer.nextToken();
        }
        return string2;
    }

    public String findUserDN(String string, String string2, String string3, String string4, boolean bl, String string5) {
        Object object;
        Object object2;
        String string6 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ArrayList arrayList = null;
        String string7 = null;
        arrayList = this.getIPAddressesByDomainName(string3);
        string7 = this.getValidIP(arrayList, string4);
        if (string7 == null) {
            return string6;
        }
        String string8 = string;
        String string9 = EgCrypt.decrypt(string2);
        String string10 = "ldap://" + string7 + ":" + string4;
        if (bl) {
            object2 = System.getProperty("java.home");
            object = (String)object2 + "/lib/security/cacerts";
            System.setProperty("javax.net.ssl.trustStore", (String)object);
            hashtable.put("java.naming.security.protocol", "ssl");
        }
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.security.principal", string8);
        hashtable.put("java.naming.security.credentials", string9);
        hashtable.put("javax.security.sasl.qop", "auth-int");
        hashtable.put("java.naming.referral", "follow");
        hashtable.put("java.naming.provider.url", string10);
        object2 = null;
        try {
            object2 = new InitialDirContext(hashtable);
            object = new SearchControls();
            String[] stringArray = new String[]{"distinguishedName"};
            ((SearchControls)object).setReturningAttributes(stringArray);
            ((SearchControls)object).setSearchScope(2);
            String string11 = "(&(objectClass=User)(objectCategory=person)(sAMAccountName=" + string5 + "))";
            String string12 = this.getSearchBase(string3);
            NamingEnumeration<SearchResult> namingEnumeration = object2.search(string12, string11, (SearchControls)object);
            if (namingEnumeration.hasMoreElements()) {
                SearchResult searchResult = namingEnumeration.next();
                string6 = searchResult.getName();
            }
            object2.close();
            hashtable = null;
        }
        catch (Exception exception) {
            this.errors.add("EXCEPTION");
            this.errors.add(exception);
            exception.printStackTrace();
            hashtable = null;
            string6 = null;
        }
        return string6;
    }

    public static void main(String[] stringArray) {
        String string = "";
        EgDomainAuthenticationFrameWork egDomainAuthenticationFrameWork = new EgDomainAuthenticationFrameWork("", "administrator", string, true, "192.168.8.79", "636", "add");
        egDomainAuthenticationFrameWork.validateADCredentials(false, "DIATEST.COM");
        ArrayList arrayList = egDomainAuthenticationFrameWork.getADResponse();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            System.out.println(" key " + string2);
        }
    }
}

