/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.utils;

import com.sybase.jdbc2.utils.CacheChunk;
import com.sybase.jdbc2.utils.CacheStream;
import com.sybase.jdbc2.utils.Cacheable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.Vector;

public class CacheManager {
    public static final boolean DEBUG = false;
    public static final boolean ASSERT = false;
    public static final int INFINITE_CACHING = -1;
    public static final int NO_CACHING = 0;
    public static final int DEFAULT_CHUNK_SIZE = 0;
    public static final String IO_CACHE_EXHAUSED = "IO_CACHE_EXHAUSED";
    public static final String IO_NOT_RESETABLE = "IO_NOT_RESETABLE";
    public static final String IO_CLOSED = "IO_CLOSED";
    public static final String IO_NOT_OPEN = "IO_NOT_OPEN";
    private static ResourceBundle _messages;
    protected Vector _colleagues;
    protected InputStream _is;
    protected int _maxCacheSize = -1;
    protected int _currentCacheSize = 0;
    protected int _chunkSize = 0;
    protected int _cacheTimeout = 0;
    protected boolean _reReadable = false;
    protected boolean _setable = true;
    protected boolean _abortOnCacheOverflow = false;
    protected Cacheable _current = null;
    protected CacheChunk _free = null;
    private boolean _resettingChunkSize = false;

    static {
        try {
            _messages = ResourceBundle.getBundle("com.sybase.jdbc2.utils.resource.Messages");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CacheManager(InputStream is) {
        this._is = is;
        this._colleagues = new Vector();
    }

    public synchronized void allDead() {
        this._current = null;
        this._colleagues.removeAllElements();
    }

    public void beginReading(Cacheable cis) throws IOException {
        while (true) {
            Cacheable currentCopy;
            Object var4_4;
            Object object = this;
            synchronized (object) {
                if (this._current == null || this._current == cis) {
                    cis.open(this._reReadable);
                    this._current = cis;
                    var4_4 = null;
                    return;
                }
                currentCopy = this._current;
            }
            object = currentCopy;
            synchronized (object) {
                if (currentCopy != this._current) {
                    var4_4 = null;
                    continue;
                }
                int state = currentCopy.getState();
                if (state == 1 && this._setable) {
                    currentCopy.resetInputStream(new CacheStream(this, this._is, this._cacheTimeout));
                }
                if (state != 0) {
                    currentCopy.cache();
                }
            }
        }
    }

    public synchronized void clear() throws IOException {
        if (this._colleagues != null) {
            int i = 0;
            while (i < this._colleagues.size()) {
                Cacheable c = (Cacheable)this._colleagues.elementAt(i);
                c.clear();
                ++i;
            }
        }
    }

    public synchronized void dead(Cacheable c) {
        if (this._current == c) {
            this._current = null;
        }
        this._colleagues.removeElement(c);
    }

    public synchronized void doneReading() {
        this._current = null;
    }

    protected synchronized CacheChunk getChunk(int size, int timeout) throws IOException {
        CacheChunk retChunk;
        int actualSize;
        int n = actualSize = size < this._chunkSize ? this._chunkSize : size;
        if (this._maxCacheSize >= 0 && this._maxCacheSize - this._currentCacheSize < actualSize) {
            if (this._abortOnCacheOverflow) {
                CacheManager.raiseIOException(IO_CACHE_EXHAUSED);
            } else {
                long startTime = System.currentTimeMillis();
                boolean waitForever = timeout == 0;
                while (true) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this._maxCacheSize - this._currentCacheSize >= actualSize) break;
                    long endTime = System.currentTimeMillis();
                    if (!waitForever) {
                        timeout -= (int)(endTime - startTime);
                        startTime = endTime;
                    }
                    if (timeout >= 0) continue;
                    CacheManager.raiseIOException(IO_CACHE_EXHAUSED);
                }
            }
        }
        if (actualSize == this._chunkSize && this._free != null) {
            retChunk = this._free;
            this._free = this._free._next;
            retChunk._length = 0;
            retChunk._next = null;
        } else {
            byte[] buf = new byte[actualSize];
            retChunk = new CacheChunk(buf);
        }
        this._currentCacheSize += actualSize;
        return retChunk;
    }

    public void open(Cacheable c) throws IOException {
        if (this._setable) {
            InputStream is = this._is;
            if (this._reReadable) {
                is = new CacheStream(this, is, this._cacheTimeout);
            }
            c.resetInputStream(is);
        }
        this.beginReading(c);
    }

    protected synchronized void putChunks(CacheChunk cc) {
        CacheChunk next = null;
        CacheChunk x = cc;
        while (x != null) {
            next = x._next;
            if (!this._resettingChunkSize) {
                this._currentCacheSize -= x._buf.length;
                this.notify();
            }
            if (x._buf.length == this._chunkSize) {
                x._next = this._free;
                this._free = x;
            } else {
                x._next = null;
            }
            x = next;
        }
    }

    protected static void raiseIOException(String key) throws IOException {
        String message;
        try {
            message = _messages.getString(key);
        }
        catch (Exception e) {
            message = "Internal error, missing message for: " + key + " exception: " + e.toString();
        }
        throw new IOException(message);
    }

    public synchronized void register(Cacheable colleague) {
        colleague.setManager(this);
        if (!this._colleagues.contains(colleague)) {
            this._colleagues.addElement(colleague);
        }
    }

    public synchronized void setAbortOnCacheOverflow(boolean value) {
        this._abortOnCacheOverflow = value;
    }

    public synchronized void setCacheSize(int size) {
        this._maxCacheSize = size;
    }

    public synchronized void setCacheTimeout(int timeout) {
        this._cacheTimeout = timeout;
    }

    public synchronized void setChunkSize(int size) {
        this._chunkSize = size;
        CacheChunk tmp = this._free;
        this._free = null;
        this._resettingChunkSize = true;
        this.putChunks(tmp);
        this._resettingChunkSize = false;
    }

    public synchronized void setReReadable(boolean value) {
        this._reReadable = value;
    }

    public synchronized void setSetable(boolean value) {
        this._setable = value;
    }
}

