/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.CharsetToUniInputStream;
import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.DynamicClassLoader;
import com.sybase.jdbc2.jdbc.DynamicObjectInputStream;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.RawInputStream;
import com.sybase.jdbc2.jdbc.RawToAsciiInputStream;
import com.sybase.jdbc2.jdbc.TextPointer;
import com.sybase.jdbc2.jdbc.UnicharToAsciiInputStream;
import com.sybase.jdbc2.tds.CachedTdsJdbcInputStream;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataObject;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.CacheStream;
import com.sybase.jdbc2.utils.Cacheable;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;

public class TdsJdbcInputStream
extends TdsDataObject
implements Cacheable {
    private static final String JAVA_LANG_BOOLEAN = "java.lang.Boolean";
    private static final String JAVA_LANG_DOUBLE = "java.lang.Double";
    private static final String JAVA_LANG_FLOAT = "java.lang.Float";
    private static final String JAVA_LANG_INTEGER = "java.lang.Integer";
    private static final String JAVA_LANG_LONG = "java.lang.Long";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_MATH_BIGDECIMAL = "java.math.BigDecimal";
    private static final String JAVA_IO_FILTERINPUTSTREAM = "java.io.FilterInputStream";
    private static final String JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
    private static final int BUFLEN = 512;
    public static final int RAW_TO_ASCII_STREAM = 1;
    public static final int RAW_TO_UNI_STREAM = 2;
    public static final int CHARSET_TO_UNI_STREAM = 3;
    public static final int RAW_STREAM = 4;
    public static final int UNICHAR_TO_UNI_STREAM = 5;
    public static final int UNICHAR_TO_ASCII_STREAM = 6;
    private CacheManager _monitor;
    private RawInputStream _columnInputStream;
    private InputStreamReader _columnInputStreamReader;
    private DynamicClassLoader _classLoader;

    public TdsJdbcInputStream(TdsProtocolContext context, Tds tds) throws IOException {
        super(context);
        this._classLoader = this._tds.getClassLoader();
    }

    public int available() throws IOException {
        Debug.println(this, "available()");
        return this._dataLength != -1 ? this._dataLength : this.in.available();
    }

    protected void beginRead() throws IOException {
        Debug.println(this, "beginRead() from " + this._state);
        if (this._monitor == null && this._state == 0 && this._prev != null && this._prev._state != 3) {
            this._prev.cache();
        }
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                this._columnInputStream.cache((CacheStream)this.in);
                this._state = 3;
            } else {
                ErrorMessage.raiseIOException("JZ0R3");
            }
        }
        this.getSize();
        if (this._isNull) {
            return;
        }
        if (this._monitor == null) {
            if (this._state == 0) {
                if (this._context._rereadable) {
                    this.openCacheStream();
                }
                this._state = 1;
            }
        } else if (this._state == 0) {
            ErrorMessage.raiseIOException("JZ0R3");
        }
        if (this._state == 3) {
            if (this._context._rereadable) {
                this.reset();
            } else {
                ErrorMessage.raiseIOException("JZ0R3");
            }
        }
        Debug.println(this, "Exit beginRead() _isNull = " + this._isNull);
    }

    public void cache() throws IOException {
        Debug.println(this, "cache()");
        if (this._state == 3) {
            return;
        }
        if (this._monitor == null) {
            this.startRead();
            if (this._context._rereadable && (this._state == 0 || this._columnInputStream == null)) {
                this.openCacheStream();
            }
        }
        this._state = 2;
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                this._columnInputStream.cache((CacheStream)this.in);
            } else {
                this._columnInputStream.close();
                this._columnInputStream = null;
            }
            this._state = 3;
            return;
        }
        this.getSize();
        Debug.println(this, "caching " + this._dataLength + " bytes.");
        if (this._dataLength == -1 && this._columnInputStream == null) {
            try {
                this._columnInputStream = this.makeNewRIS(4);
            }
            catch (SQLException sqe) {
                throw new IOException(sqe.getMessage());
            }
            this._columnInputStream.cache((CacheStream)this.in);
            this._state = 3;
            this.reset();
            this._columnInputStream = null;
            return;
        }
        byte[] tmpbuf = new byte[512];
        int toCache = this._dataLength;
        while (toCache > 0) {
            int len = toCache < 512 ? toCache : 512;
            this.in.read(tmpbuf, 0, len);
            toCache -= len;
        }
        if (this._monitor != null) {
            this._monitor.doneReading();
        }
        this._state = 3;
        if (this._monitor != null) {
            this.in.reset();
        }
    }

    public void clear() throws IOException {
        Debug.println(this, "clear()");
        if (this._columnInputStream != null) {
            this._columnInputStream.close();
            this._columnInputStream = null;
        } else {
            switch (this._state) {
                case 0: {
                    if (this._monitor != null) break;
                    this.skipParam();
                    break;
                }
                case 1: {
                    this.skipParam();
                    if (this._monitor == null) break;
                    this._monitor.doneReading();
                    break;
                }
                case 2: {
                    this.getSize();
                    Debug.assert(this, this._dataLength != -1);
                    this.in.skip(this._dataLength);
                    if (this._monitor == null) break;
                    this._monitor.doneReading();
                    break;
                }
            }
        }
        this.initialize();
    }

    protected TdsDataObject createCachedCopy() throws SQLException, IOException {
        return new CachedTdsJdbcInputStream(this);
    }

    protected void endRead() throws SQLException {
        Debug.println(this, "endRead()");
        if (this._state != 3 && this._monitor != null) {
            this._monitor.doneReading();
        }
        this._state = 3;
    }

    public InputStream getAsciiStream() throws SQLException {
        InputStream retVal = null;
        try {
            Debug.println(this, "getAsciiStream()");
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 3) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(4);
                        return this._columnInputStream;
                    }
                    case 4: 
                    case 34: 
                    case 37: 
                    case 45: {
                        this._columnInputStream = this.makeNewRIS(1);
                        return this._columnInputStream;
                    }
                    case 225: {
                        this._columnInputStream = this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34 ? this.makeNewRIS(6) : this.makeNewRIS(1);
                        return this._columnInputStream;
                    }
                }
                ErrorMessage.raiseError("JZ0TE", "char, varchar, text, image, binary, long binary, varbinary");
            }
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
        return retVal;
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        Debug.println(this, "getBigDecimal()");
        BigDecimal retVal = null;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            retVal = new BigDecimal((double)this.readUnsignedByte());
                            break;
                        }
                        case 52: {
                            retVal = new BigDecimal((double)this.readShort());
                            break;
                        }
                        case 56: {
                            retVal = new BigDecimal((double)this.readInt());
                            break;
                        }
                        case 38: {
                            retVal = new BigDecimal((double)this.readINTN());
                            break;
                        }
                        case 59: {
                            retVal = new BigDecimal(this.readFloat());
                            break;
                        }
                        case 62: {
                            retVal = new BigDecimal(this.readDouble());
                            break;
                        }
                        case 109: {
                            retVal = new BigDecimal(this.readFLTN());
                            break;
                        }
                        case 106: 
                        case 108: {
                            retVal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            retVal = new BigDecimal(Convert.numString(this.readString()));
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            retVal = this.readMONEYN();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                            break;
                        }
                    }
                }
            }
            catch (IOException ioe) {
                ErrorMessage.raiseError("JZ006", ioe.getMessage());
            }
            catch (NumberFormatException nfe) {
                ErrorMessage.raiseError("JZ009", nfe.toString());
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        retVal = Convert.setScale(retVal, scale);
        return retVal;
    }

    public InputStream getBinaryStream() throws SQLException {
        Debug.println(this, "getBinaryStream()");
        InputStream retVal = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 4) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 34: 
                    case 37: 
                    case 45: 
                    case 225: {
                        this._columnInputStream = this.makeNewRIS(4);
                        return this._columnInputStream;
                    }
                }
                ErrorMessage.raiseError("JZ0TE", "image, binary, long binary, varbinary");
            }
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
        return retVal;
    }

    public boolean getBoolean() throws SQLException {
        Debug.println(this, "getBoolean()");
        boolean retVal = false;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            retVal = this.readUnsignedByte() != 0;
                            break;
                        }
                        case 52: {
                            retVal = this.readShort() != 0;
                            break;
                        }
                        case 56: {
                            retVal = this.readInt() != 0;
                            break;
                        }
                        case 38: {
                            retVal = this.readINTN() != 0L;
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            BigDecimal bd = this.readMONEYN();
                            retVal = bd.signum() != 0;
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            retVal = this.readFLTN() != 0.0;
                            break;
                        }
                        case 106: 
                        case 108: {
                            BigDecimal bd = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            retVal = bd.signum() != 0;
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            String val = this.readString();
                            retVal = val != null && (val.trim().toLowerCase().equals("true") || val.trim().equals("1"));
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                            break;
                        }
                    }
                }
            }
            catch (IOException ioe) {
                ErrorMessage.raiseError("JZ006", ioe.getMessage());
            }
            catch (NumberFormatException nfe) {
                ErrorMessage.raiseError("JZ009", nfe.toString());
            }
            Object var3_7 = null;
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return retVal;
    }

    public byte getByte() throws SQLException {
        Debug.println(this, "getByte()");
        long retVal = 0L;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            retVal = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            retVal = this.readShort();
                            break;
                        }
                        case 56: {
                            retVal = this.readInt();
                            break;
                        }
                        case 38: {
                            retVal = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            retVal = new Double(this.readFLTN()).longValue();
                            break;
                        }
                        case 106: 
                        case 108: {
                            retVal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            retVal = new BigDecimal(Convert.numString(this.readString())).longValue();
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            retVal = this.readMONEYN().longValue();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                        }
                    }
                    Convert.checkByteOflo(retVal);
                }
            }
            catch (IOException ioe) {
                ErrorMessage.raiseError("JZ006", ioe.getMessage());
            }
            catch (NumberFormatException nfe) {
                ErrorMessage.raiseError("JZ009", nfe.toString());
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        Debug.println(this, "retVal = " + retVal);
        return (byte)retVal;
    }

    public byte[] getBytes() throws SQLException {
        Debug.println(this, "getBytes()");
        byte[] retVal = null;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 36: {
                            int i;
                            if (this._dataFmt._blobType != 4) {
                                ErrorMessage.raiseError("JZ0TE", "Object");
                            }
                            this._columnInputStream = this.makeNewRIS(4);
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            byte[] buf = new byte[512];
                            while ((i = this._columnInputStream.read(buf, 0, 512)) != -1) {
                                baos.write(buf, 0, i);
                            }
                            retVal = baos.toByteArray();
                            baos.close();
                            this._columnInputStream.close();
                            this._columnInputStream = null;
                            break;
                        }
                        case 34: 
                        case 37: 
                        case 45: 
                        case 225: {
                            retVal = this.funkyBinaryReader();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "varbinay, long binary, binary, image");
                            break;
                        }
                    }
                }
            }
            catch (IOException ioe) {
                ErrorMessage.raiseError("JZ006", ioe.getMessage());
            }
            Object var3_6 = null;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return retVal;
    }

    public Reader getCharacterStream() throws SQLException {
        Reader retVal = null;
        try {
            Debug.println(this, "getAsciiStream()");
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 3) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(4);
                        this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                        return this._columnInputStreamReader;
                    }
                    case 4: 
                    case 34: 
                    case 37: 
                    case 45: 
                    case 225: {
                        this._columnInputStream = this.makeNewRIS(1);
                        this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                        return this._columnInputStreamReader;
                    }
                }
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
        return retVal;
    }

    public DateObject getDateObject(int targetType, Calendar cal) throws SQLException {
        Debug.println(this, "getDateObject()");
        DateObject retVal = null;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            retVal = Convert.objectToDateObject(this.readString(), targetType, cal);
                            break;
                        }
                        case 58: 
                        case 61: 
                        case 111: {
                            retVal = this.readDATETIMN().dateObjectValue(cal);
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "char, varchar, datetime, short datetime");
                            break;
                        }
                    }
                }
            }
            catch (IOException ioe) {
                ErrorMessage.raiseError("JZ006", ioe.getMessage());
            }
            catch (IllegalArgumentException iae) {
                ErrorMessage.raiseError("JZ009", iae.getMessage());
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return retVal;
    }

    public double getDouble() throws SQLException {
        Debug.println(this, "getDouble()");
        double retVal = 0.0;
        try {
            block17: {
                try {
                    this.beginRead();
                    if (this._isNull) break block17;
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            retVal = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            retVal = this.readShort();
                            break;
                        }
                        case 56: {
                            retVal = this.readInt();
                            break;
                        }
                        case 38: {
                            retVal = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            retVal = this.readFLTN();
                            break;
                        }
                        case 106: 
                        case 108: {
                            BigDecimal bd = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            if (bd != null) {
                                retVal = bd.doubleValue();
                            }
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            retVal = Double.valueOf(Convert.numString(this.readString()));
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            BigDecimal bdM = this.readMONEYN();
                            if (bdM != null) {
                                retVal = bdM.doubleValue();
                            }
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                            break;
                        }
                    }
                }
                catch (IOException ioe) {
                    ErrorMessage.raiseError("JZ006", ioe.getMessage());
                }
                catch (NumberFormatException nfe) {
                    ErrorMessage.raiseError("JZ009", nfe.toString());
                }
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return retVal;
    }

    public float getFloat() throws SQLException {
        Debug.println(this, "getFloat()");
        float retVal = 0.0f;
        try {
            block19: {
                try {
                    this.beginRead();
                    if (this._isNull) break block19;
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            retVal = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            retVal = this.readShort();
                            break;
                        }
                        case 56: {
                            retVal = this.readInt();
                            break;
                        }
                        case 38: {
                            retVal = this.readINTN();
                            break;
                        }
                        case 59: {
                            retVal = this.readFloat();
                            break;
                        }
                        case 62: {
                            retVal = (float)this.readDouble();
                            break;
                        }
                        case 109: {
                            retVal = (float)this.readFLTN();
                            break;
                        }
                        case 106: 
                        case 108: {
                            BigDecimal bd = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            if (bd != null) {
                                retVal = bd.floatValue();
                            }
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            retVal = Float.valueOf(Convert.numString(this.readString())).floatValue();
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            BigDecimal bdM = this.readMONEYN();
                            if (bdM != null) {
                                retVal = bdM.floatValue();
                            }
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                            break;
                        }
                    }
                }
                catch (IOException ioe) {
                    ErrorMessage.raiseError("JZ006", ioe.getMessage());
                }
                catch (NumberFormatException nfe) {
                    ErrorMessage.raiseError("JZ009", nfe.toString());
                }
            }
            Object var3_6 = null;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return retVal;
    }

    public int getInt() throws SQLException {
        Debug.println(this, "getInt()");
        long retVal = 0L;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            retVal = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            retVal = this.readShort();
                            break;
                        }
                        case 56: {
                            retVal = this.readInt();
                            break;
                        }
                        case 38: {
                            retVal = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            retVal = new Double(this.readFLTN()).longValue();
                            break;
                        }
                        case 106: 
                        case 108: {
                            retVal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            retVal = new BigDecimal(Convert.numString(this.readString())).longValue();
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            retVal = this.readMONEYN().longValue();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                        }
                    }
                    Convert.checkIntOflo(retVal);
                }
            }
            catch (IOException ioe) {
                ErrorMessage.raiseError("JZ006", ioe.getMessage());
            }
            catch (NumberFormatException nfe) {
                ErrorMessage.raiseError("JZ009", nfe.toString());
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return (int)retVal;
    }

    public long getLong() throws SQLException {
        Debug.println(this, "getLong()");
        long retVal = 0L;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            retVal = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            retVal = this.readShort();
                            break;
                        }
                        case 56: {
                            retVal = this.readInt();
                            break;
                        }
                        case 38: {
                            retVal = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            retVal = new Double(this.readFLTN()).longValue();
                            break;
                        }
                        case 106: 
                        case 108: {
                            retVal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            retVal = new BigDecimal(Convert.numString(this.readString())).longValue();
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            retVal = this.readMONEYN().longValue();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                            break;
                        }
                    }
                }
            }
            catch (IOException ioe) {
                ErrorMessage.raiseError("JZ006", ioe.getMessage());
            }
            catch (NumberFormatException nfe) {
                ErrorMessage.raiseError("JZ009", nfe.toString());
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return retVal;
    }

    /*
     * Exception decompiling
     */
    public Object getObject() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String getObjectClassName(int dataType, int blobType, int length) throws SQLException {
        String retVal = JAVA_LANG_OBJECT;
        switch (dataType) {
            case 50: {
                return JAVA_LANG_BOOLEAN;
            }
            case 48: 
            case 52: 
            case 56: {
                return JAVA_LANG_INTEGER;
            }
            case 38: {
                if (length > 4) return JAVA_LANG_LONG;
                return JAVA_LANG_INTEGER;
            }
            case 59: {
                return JAVA_LANG_FLOAT;
            }
            case 62: 
            case 109: {
                if (length != 4) return JAVA_LANG_DOUBLE;
                return JAVA_LANG_FLOAT;
            }
            case 35: 
            case 39: 
            case 47: 
            case 175: {
                return JAVA_LANG_STRING;
            }
            case 60: 
            case 106: 
            case 108: 
            case 110: 
            case 122: {
                return JAVA_MATH_BIGDECIMAL;
            }
            case 34: 
            case 37: 
            case 45: 
            case 103: 
            case 104: 
            case 225: {
                return new byte[1].getClass().getName();
            }
            case 58: 
            case 61: 
            case 111: {
                return JAVA_SQL_TIMESTAMP;
            }
            case 36: {
                switch (blobType) {
                    case 1: 
                    case 2: {
                        return JAVA_LANG_OBJECT;
                    }
                    case 3: 
                    case 4: {
                        return JAVA_IO_FILTERINPUTSTREAM;
                    }
                    default: {
                        return retVal;
                    }
                }
            }
            default: {
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        return retVal;
    }

    protected byte[] getRawBytes() throws SQLException {
        byte[] retVal = null;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    int i;
                    this._columnInputStream = this.makeNewRIS(4);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buf = new byte[512];
                    while ((i = this._columnInputStream.read(buf, 0, 512)) != -1) {
                        baos.write(buf, 0, i);
                    }
                    retVal = baos.toByteArray();
                    baos.close();
                    this._columnInputStream.close();
                    this._columnInputStream = null;
                }
            }
            catch (IOException ioe) {
                ErrorMessage.raiseError("JZ006", ioe.getMessage());
            }
            Object var3_6 = null;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return retVal;
    }

    public short getShort() throws SQLException {
        Debug.println(this, "getShort()");
        long retVal = 0L;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            retVal = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            retVal = this.readShort();
                            break;
                        }
                        case 56: {
                            retVal = this.readInt();
                            break;
                        }
                        case 38: {
                            retVal = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            retVal = new Double(this.readFLTN()).longValue();
                            break;
                        }
                        case 106: 
                        case 108: {
                            retVal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            retVal = new BigDecimal(Convert.numString(this.readString())).longValue();
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            retVal = this.readMONEYN().longValue();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                        }
                    }
                    Convert.checkShortOflo(retVal);
                }
            }
            catch (IOException ioe) {
                ErrorMessage.raiseError("JZ006", ioe.getMessage());
            }
            catch (NumberFormatException nfe) {
                ErrorMessage.raiseError("JZ009", nfe.toString());
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return (short)retVal;
    }

    public int getState() {
        return this._state;
    }

    public String getString() throws SQLException {
        Debug.println(this, "getString()");
        String retVal = null;
        try {
            block32: {
                try {
                    this.beginRead();
                    if (this._isNull) break block32;
                    block2 : switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            retVal = String.valueOf(this.readUnsignedByte());
                            break;
                        }
                        case 52: {
                            retVal = String.valueOf(this.readShort());
                            break;
                        }
                        case 56: {
                            retVal = String.valueOf(this.readInt());
                            break;
                        }
                        case 38: {
                            retVal = String.valueOf(this.readINTN());
                            break;
                        }
                        case 59: {
                            retVal = String.valueOf(this.readFloat());
                            break;
                        }
                        case 62: {
                            retVal = String.valueOf(this.readDouble());
                            break;
                        }
                        case 109: {
                            retVal = String.valueOf(this.readFLTN());
                            break;
                        }
                        case 106: 
                        case 108: {
                            BigDecimal bd = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            if (bd != null) {
                                retVal = bd.toString();
                            }
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            retVal = this.readString();
                            break;
                        }
                        case 34: 
                        case 37: 
                        case 45: 
                        case 103: 
                        case 104: {
                            retVal = HexConverts.hexConvert(this.funkyBinaryReader());
                            break;
                        }
                        case 225: {
                            if (this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34) {
                                retVal = this.readUnicodeString();
                                break;
                            }
                            retVal = HexConverts.hexConvert(this.funkyBinaryReader());
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            BigDecimal bdM = this.readMONEYN();
                            if (bdM != null) {
                                retVal = bdM.toString();
                            }
                            break;
                        }
                        case 58: 
                        case 61: 
                        case 111: {
                            retVal = this.readDATETIMN().stringValue();
                            break;
                        }
                        case 36: {
                            switch (this._dataFmt._blobType) {
                                case 1: {
                                    Object o = this.readObject();
                                    if (o == null) {
                                        retVal = null;
                                        break block2;
                                    }
                                    retVal = o.toString();
                                    break block2;
                                }
                                case 3: {
                                    int i;
                                    this._columnInputStream = this.makeNewRIS(4);
                                    InputStreamReader isr = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                                    char[] cbuf = new char[512];
                                    StringBuffer sb = new StringBuffer();
                                    while ((i = isr.read(cbuf, 0, 512)) != -1) {
                                        sb.append(cbuf, 0, i);
                                    }
                                    retVal = sb.toString();
                                    isr.close();
                                    this._columnInputStream.close();
                                    this._columnInputStream = null;
                                    break block2;
                                }
                                case 4: {
                                    int i;
                                    this._columnInputStream = this.makeNewRIS(4);
                                    byte[] buf = new byte[512];
                                    StringBuffer sb = new StringBuffer();
                                    while ((i = this._columnInputStream.read(buf, 0, 512)) != -1) {
                                        sb.append(HexConverts.hexConvert(buf, i));
                                    }
                                    retVal = sb.toString();
                                    this._columnInputStream.close();
                                    this._columnInputStream = null;
                                    break block2;
                                }
                            }
                            Debug.assert(this, false);
                            ErrorMessage.raiseError("JZ0TC");
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TC");
                            break;
                        }
                    }
                }
                catch (IOException ioe) {
                    ErrorMessage.raiseError("JZ006", ioe.getMessage());
                }
                catch (NumberFormatException nfe) {
                    ErrorMessage.raiseError("JZ009", nfe.toString());
                }
            }
            Object var3_14 = null;
        }
        catch (Throwable throwable) {
            Object var3_15 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return retVal;
    }

    /*
     * Exception decompiling
     */
    public TextPointer getTextPtr() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InputStream getUnicodeStream() throws SQLException {
        Debug.println(this, "getUnicodeStream()");
        InputStream retVal = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 3) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(3);
                        return this._columnInputStream;
                    }
                    case 4: 
                    case 34: 
                    case 37: 
                    case 45: {
                        this._columnInputStream = this.makeNewRIS(2);
                        return this._columnInputStream;
                    }
                    case 225: {
                        this._columnInputStream = this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34 ? this.makeNewRIS(5) : this.makeNewRIS(2);
                        return this._columnInputStream;
                    }
                }
                ErrorMessage.raiseError("JZ0TE", "char, varchar, text, image, binary, long binary, varbinary");
            }
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
        return retVal;
    }

    public void initialize() {
        Debug.println(this, "TdsJdbcInputSteam.initialize()");
        super.initialize();
        this._columnInputStream = null;
        if (this.in instanceof CacheStream) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
            this.in = this._context._in;
        }
    }

    public boolean isNull() throws SQLException {
        return this._isNull;
    }

    protected RawInputStream makeNewRIS(int cisType) throws SQLException {
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                try {
                    try {
                        this._columnInputStream.close();
                        this._state = 3;
                        this.reset();
                    }
                    catch (IOException ioe) {
                        ErrorMessage.raiseError("JZ006", ioe.toString());
                    }
                    Object var3_4 = null;
                    this._columnInputStream = null;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    this._columnInputStream = null;
                    throw throwable;
                }
            }
            ErrorMessage.raiseError("JZ0R3");
        }
        RawInputStream ris = null;
        CacheManager cm = null;
        Debug.println(this, ">>> makeNewRIS");
        int lengthLimit = this._dataLength;
        if (this._dataFmt._datatype == 37 && this._dataFmt._usertype == 3) {
            lengthLimit = this._dataFmt._length;
        }
        if (this._context._maxFieldSize > 0) {
            lengthLimit = Math.min(lengthLimit, this._context._maxFieldSize);
        }
        if (this._state != 3) {
            Debug.println(this, "not CACHED, so create a CIS w/a manager");
            cm = this._monitor;
            this._state = 1;
        }
        try {
            switch (cisType) {
                case 4: {
                    ris = new RawInputStream(this, this._dataLength, lengthLimit, cm);
                    break;
                }
                case 1: {
                    ris = new RawToAsciiInputStream(this, this._dataLength, lengthLimit, cm);
                    break;
                }
                case 3: {
                    ris = new CharsetToUniInputStream(this, this._dataLength, lengthLimit, cm, this._tds._charsetName);
                    break;
                }
                case 2: {
                    int charDataLength = this._dataLength == -1 ? -1 : 2 * this._dataLength;
                    int charLengthLimit = lengthLimit == -1 ? -1 : 2 * lengthLimit;
                    ris = new CharsetToUniInputStream(new RawToAsciiInputStream(this, this._dataLength, lengthLimit, cm), charDataLength, charLengthLimit, null, "8859_1");
                    break;
                }
                case 5: {
                    ris = new RawInputStream(this, this._dataLength, lengthLimit, cm);
                    break;
                }
                case 6: {
                    ris = new UnicharToAsciiInputStream(this, this._dataLength, lengthLimit, cm);
                    break;
                }
                default: {
                    Debug.assert(this, false);
                    break;
                }
            }
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ0I5", ioe.toString());
        }
        ris.setCached(this._state == 3);
        return ris;
    }

    public void open(boolean caching) {
        Debug.println(this, "open(" + caching + ")");
        this._state = caching ? 2 : 1;
        if (this._context._lastResult == 209) {
            this._context._lastResult = -1;
        }
    }

    private void openCacheStream() {
        Debug.println(this, "creating CacheStream");
        this.in = new CacheStream(this._context._cm, this.in, this._context._timeout);
    }

    private Object readObject() throws SQLException {
        Object retVal = null;
        Debug.assert(this, this._dataFmt._datatype == 36 && this._dataFmt._blobType == 1);
        try {
            this._columnInputStream = this.makeNewRIS(4);
            if (this._columnInputStream.available() > 0) {
                ObjectInputStream ois;
                if (this._classLoader == null) {
                    ois = new ObjectInputStream(this._columnInputStream);
                } else {
                    Debug.println(this, "Using Dynamic OIS");
                    ois = new DynamicObjectInputStream((InputStream)this._columnInputStream, this._classLoader);
                }
                retVal = ois.readObject();
                ois.close();
            } else {
                this._isNull = true;
            }
            this._columnInputStream.close();
            this._columnInputStream = null;
        }
        catch (Exception e) {
            ErrorMessage.raiseError("JZ010", e.getMessage());
        }
        return retVal;
    }

    public void reset() throws IOException {
        if (this._state == 3 && !this._isNull) {
            Debug.println(this, "reset() in = " + this.in);
            this.in.reset();
            if (this._monitor != null) {
                this._dataLength = -2;
                this.getSize();
            }
        } else {
            ErrorMessage.raiseIOException("JZ0P7");
        }
    }

    public void resetInputStream(InputStream is) {
        Debug.println(this, "resetInputStream(" + is + ")");
        this.in = is;
    }

    public void setManager(CacheManager cm) {
        Debug.println(this, "setManager(" + cm + ")");
        this._monitor = cm;
    }

    private void skipParam() throws IOException {
        this.getSize();
        if (this._dataLength == -1) {
            try {
                try {
                    this._columnInputStream = this.makeNewRIS(4);
                    this._columnInputStream.close();
                }
                catch (SQLException sqe) {
                    throw new IOException(sqe.getMessage());
                }
                Object var2_2 = null;
                this._columnInputStream = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this._columnInputStream = null;
                throw throwable;
            }
        }
        this.in.skip(this._dataLength);
    }
}

